# Example for: selection.assess(), soap_protein_od.Scorer()

from modeller import *
from modeller.scripts import complete_pdb
from modeller import soap_protein_od

env = environ()
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

# Set up SOAP-Protein-OD scoring (note: if assessing multiple models, it is
# best to create 'sp' just once and keep it around, since reading in the
# potential from disk can take a long time).
sp = soap_protein_od.Scorer()

# Read a model previously generated by Modeller's automodel class
mdl = complete_pdb(env, '../atom_files/1fdx.B99990001.pdb')

# Select all atoms in the first chain
atmsel = selection(mdl.chains[0])

# Assess with the above Scorer
try:
    score = atmsel.assess(sp)
except ModellerError:
    print("The SOAP-Protein-OD library file is not included with MODELLER.")
    print("Please get it from http://salilab.org/SOAP/.")
