#
#     Copyright (C) 2015 CCP-EM
#
#     This code is distributed under the terms and conditions of the
#     CCP-EM Program Suite Licence Agreement as a CCP-EM Application.
#     A copy of the CCP-EM licence can be obtained by writing to the
#     CCP-EM Secretary, RAL Laboratory, Harwell, OX11 0FA, UK.
#

import unittest
import os
import sys
import shutil
import time
import tempfile
from PyQt4 import QtGui, QtCore
from PyQt4.QtTest import QTest
from ccpem_core import ccpem_utils
from ccpem_core import process_manager
from ccpem_core.test_data.tasks import loc_scale as loc_scale_test


app = QtGui.QApplication(sys.argv)

class Test(unittest.TestCase):
    '''
    Unit test for TEMPy SMOC score (invokes GUI).
    '''
    def setUp(self):
        '''
        Setup test data and output directories.
        '''
        self.test_data = os.path.dirname(loc_scale_test.__file__)
        self.test_output = tempfile.mkdtemp()

    def tearDown(self):
        '''
        Remove temporary data.
        '''
        if os.path.exists(path=self.test_output):
            shutil.rmtree(self.test_output)

    def test_loc_scale_inports(self):
        '''
        Test LocScale imports... to be replaced with GUI implementation.
        '''
        from ccpem_core.tasks.loc_scale import loc_scale_task
        from ccpem_gui.tasks.loc_scale import loc_scale_window
        from loc_scale import np_locscale


if __name__ == '__main__':
    unittest.main()
