#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Jan 21 13:42:47 2016 by generateDS.py version 2.17a.
#
# Command line options:
#   ('--user-methods', 'emdb_user_methods')
#   ('--external-encoding', 'utf-8')
#   ('-f', '')
#   ('-o', 'emdb_19.py')
#
# Command line arguments:
#   ../../emdbXMLTranslator/schema/emdb19.xsd
#
# Command line:
#   ../../emdbXMLTranslator/generateDS-2.17a0/build/scripts-2.7/generateDS.py --user-methods="emdb_user_methods" --external-encoding="utf-8" -f -o "emdb_19.py" ../../emdbXMLTranslator/schema/emdb19.xsd
#
# Current working directory (os.getcwd()):
#   emdbXMLTranslator
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
from lxml import etree as etree_


Validate_simpletypes_ = True


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        parser = etree_.ETCompatXMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class entryType(GeneratedsSuper):
    """Electron Microscopy Database record identified by its accession code"""
    member_data_items_ = [
        MemberSpec_('version', 'xs:string', 0),
        MemberSpec_('accessCode', 'xs:string', 0),
        MemberSpec_('admin', 'adminType', 0),
        MemberSpec_('deposition', 'depType', 0),
        MemberSpec_('map', 'mapType', 0),
        MemberSpec_('supplement', 'supplType', 0),
        MemberSpec_('sample', 'samplType', 0),
        MemberSpec_('experiment', 'expType', 0),
        MemberSpec_('processing', 'processType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, version=None, accessCode=None, admin=None, deposition=None, map=None, supplement=None, sample=None, experiment=None, processing=None):
        self.original_tagname_ = None
        self.version = _cast(None, version)
        self.accessCode = _cast(None, accessCode)
        self.admin = admin
        self.deposition = deposition
        self.map = map
        self.supplement = supplement
        self.sample = sample
        self.experiment = experiment
        self.processing = processing
    def factory(*args_, **kwargs_):
        if entryType.subclass:
            return entryType.subclass(*args_, **kwargs_)
        else:
            return entryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_admin(self): return self.admin
    def set_admin(self, admin): self.admin = admin
    def get_deposition(self): return self.deposition
    def set_deposition(self, deposition): self.deposition = deposition
    def get_map(self): return self.map
    def set_map(self, map): self.map = map
    def get_supplement(self): return self.supplement
    def set_supplement(self, supplement): self.supplement = supplement
    def get_sample(self): return self.sample
    def set_sample(self, sample): self.sample = sample
    def get_experiment(self): return self.experiment
    def set_experiment(self, experiment): self.experiment = experiment
    def get_processing(self): return self.processing
    def set_processing(self, processing): self.processing = processing
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_accessCode(self): return self.accessCode
    def set_accessCode(self, accessCode): self.accessCode = accessCode
    def hasContent_(self):
        if (
            self.admin is not None or
            self.deposition is not None or
            self.map is not None or
            self.supplement is not None or
            self.sample is not None or
            self.experiment is not None or
            self.processing is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='entryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='entryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='entryType'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.accessCode is not None and 'accessCode' not in already_processed:
            already_processed.add('accessCode')
            outfile.write(' accessCode=%s' % (self.gds_format_string(quote_attrib(self.accessCode).encode(ExternalEncoding), input_name='accessCode'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='entryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.admin is not None:
            self.admin.export(outfile, level, namespace_, name_='admin', pretty_print=pretty_print)
        if self.deposition is not None:
            self.deposition.export(outfile, level, namespace_, name_='deposition', pretty_print=pretty_print)
        if self.map is not None:
            self.map.export(outfile, level, namespace_, name_='map', pretty_print=pretty_print)
        if self.supplement is not None:
            self.supplement.export(outfile, level, namespace_, name_='supplement', pretty_print=pretty_print)
        if self.sample is not None:
            self.sample.export(outfile, level, namespace_, name_='sample', pretty_print=pretty_print)
        if self.experiment is not None:
            self.experiment.export(outfile, level, namespace_, name_='experiment', pretty_print=pretty_print)
        if self.processing is not None:
            self.processing.export(outfile, level, namespace_, name_='processing', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('accessCode', node)
        if value is not None and 'accessCode' not in already_processed:
            already_processed.add('accessCode')
            self.accessCode = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'admin':
            obj_ = adminType.factory()
            obj_.build(child_)
            self.admin = obj_
            obj_.original_tagname_ = 'admin'
        elif nodeName_ == 'deposition':
            obj_ = depType.factory()
            obj_.build(child_)
            self.deposition = obj_
            obj_.original_tagname_ = 'deposition'
        elif nodeName_ == 'map':
            obj_ = mapType.factory()
            obj_.build(child_)
            self.map = obj_
            obj_.original_tagname_ = 'map'
        elif nodeName_ == 'supplement':
            obj_ = supplType.factory()
            obj_.build(child_)
            self.supplement = obj_
            obj_.original_tagname_ = 'supplement'
        elif nodeName_ == 'sample':
            obj_ = samplType.factory()
            obj_.build(child_)
            self.sample = obj_
            obj_.original_tagname_ = 'sample'
        elif nodeName_ == 'experiment':
            obj_ = expType.factory()
            obj_.build(child_)
            self.experiment = obj_
            obj_.original_tagname_ = 'experiment'
        elif nodeName_ == 'processing':
            obj_ = processType.factory()
            obj_.build(child_)
            self.processing = obj_
            obj_.original_tagname_ = 'processing'
# end class entryType


class adminType(GeneratedsSuper):
    """Information relevant for administration purposes. Not for public
    release"""
    member_data_items_ = [
        MemberSpec_('lastUpdate', 'xs:date', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, lastUpdate=None):
        self.original_tagname_ = None
        if isinstance(lastUpdate, basestring):
            initvalue_ = datetime_.datetime.strptime(lastUpdate, '%Y-%m-%d').date()
        else:
            initvalue_ = lastUpdate
        self.lastUpdate = initvalue_
    def factory(*args_, **kwargs_):
        if adminType.subclass:
            return adminType.subclass(*args_, **kwargs_)
        else:
            return adminType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_lastUpdate(self): return self.lastUpdate
    def set_lastUpdate(self, lastUpdate): self.lastUpdate = lastUpdate
    def hasContent_(self):
        if (
            self.lastUpdate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adminType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adminType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='adminType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adminType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='adminType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.lastUpdate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastUpdate>%s</%slastUpdate>%s' % (namespace_, self.gds_format_date(self.lastUpdate, input_name='lastUpdate'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'lastUpdate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.lastUpdate = dval_
# end class adminType


class depType(GeneratedsSuper):
    """Contains context information relevant to the EMD entry record"""
    member_data_items_ = [
        MemberSpec_('status', 'statusType', 0),
        MemberSpec_('depositionDate', 'xs:date', 0),
        MemberSpec_('depositionSite', ['depositionSiteType', 'xs:token'], 0),
        MemberSpec_('processingSite', ['processingSiteType', 'xs:token'], 0),
        MemberSpec_('headerReleaseDate', 'xs:date', 0),
        MemberSpec_('mapReleaseDate', 'xs:date', 0),
        MemberSpec_('obsoletedDate', 'xs:date', 0),
        MemberSpec_('supersededByList', 'emdbListType', 0),
        MemberSpec_('replaceExistingEntry', 'xs:boolean', 0),
        MemberSpec_('obsoleteList', 'emdbListType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('inFrameEMDBId', ['emdbEntryIdType', 'xs:string'], 0),
        MemberSpec_('title', 'xs:string', 0),
        MemberSpec_('authors', 'xs:string', 0),
        MemberSpec_('keywords', 'xs:string', 0),
        MemberSpec_('fittedPDBEntryIdList', 'pdbidListType', 0),
        MemberSpec_('primaryReference', 'prRefType', 0),
        MemberSpec_('secondaryReference', 'prRefType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, status=None, depositionDate=None, depositionSite=None, processingSite=None, headerReleaseDate=None, mapReleaseDate=None, obsoletedDate=None, supersededByList=None, replaceExistingEntry=None, obsoleteList=None, details=None, inFrameEMDBId=None, title=None, authors=None, keywords=None, fittedPDBEntryIdList=None, primaryReference=None, secondaryReference=None):
        self.original_tagname_ = None
        self.status = status
        if isinstance(depositionDate, basestring):
            initvalue_ = datetime_.datetime.strptime(depositionDate, '%Y-%m-%d').date()
        else:
            initvalue_ = depositionDate
        self.depositionDate = initvalue_
        self.depositionSite = depositionSite
        self.validate_depositionSiteType(self.depositionSite)
        self.processingSite = processingSite
        self.validate_processingSiteType(self.processingSite)
        if isinstance(headerReleaseDate, basestring):
            initvalue_ = datetime_.datetime.strptime(headerReleaseDate, '%Y-%m-%d').date()
        else:
            initvalue_ = headerReleaseDate
        self.headerReleaseDate = initvalue_
        if isinstance(mapReleaseDate, basestring):
            initvalue_ = datetime_.datetime.strptime(mapReleaseDate, '%Y-%m-%d').date()
        else:
            initvalue_ = mapReleaseDate
        self.mapReleaseDate = initvalue_
        if isinstance(obsoletedDate, basestring):
            initvalue_ = datetime_.datetime.strptime(obsoletedDate, '%Y-%m-%d').date()
        else:
            initvalue_ = obsoletedDate
        self.obsoletedDate = initvalue_
        self.supersededByList = supersededByList
        self.replaceExistingEntry = replaceExistingEntry
        self.obsoleteList = obsoleteList
        self.details = details
        self.inFrameEMDBId = inFrameEMDBId
        self.validate_emdbEntryIdType(self.inFrameEMDBId)
        self.title = title
        self.authors = authors
        self.keywords = keywords
        self.fittedPDBEntryIdList = fittedPDBEntryIdList
        self.primaryReference = primaryReference
        if secondaryReference is None:
            self.secondaryReference = []
        else:
            self.secondaryReference = secondaryReference
    def factory(*args_, **kwargs_):
        if depType.subclass:
            return depType.subclass(*args_, **kwargs_)
        else:
            return depType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_depositionDate(self): return self.depositionDate
    def set_depositionDate(self, depositionDate): self.depositionDate = depositionDate
    def get_depositionSite(self): return self.depositionSite
    def set_depositionSite(self, depositionSite): self.depositionSite = depositionSite
    def get_processingSite(self): return self.processingSite
    def set_processingSite(self, processingSite): self.processingSite = processingSite
    def get_headerReleaseDate(self): return self.headerReleaseDate
    def set_headerReleaseDate(self, headerReleaseDate): self.headerReleaseDate = headerReleaseDate
    def get_mapReleaseDate(self): return self.mapReleaseDate
    def set_mapReleaseDate(self, mapReleaseDate): self.mapReleaseDate = mapReleaseDate
    def get_obsoletedDate(self): return self.obsoletedDate
    def set_obsoletedDate(self, obsoletedDate): self.obsoletedDate = obsoletedDate
    def get_supersededByList(self): return self.supersededByList
    def set_supersededByList(self, supersededByList): self.supersededByList = supersededByList
    def get_replaceExistingEntry(self): return self.replaceExistingEntry
    def set_replaceExistingEntry(self, replaceExistingEntry): self.replaceExistingEntry = replaceExistingEntry
    def get_obsoleteList(self): return self.obsoleteList
    def set_obsoleteList(self, obsoleteList): self.obsoleteList = obsoleteList
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_inFrameEMDBId(self): return self.inFrameEMDBId
    def set_inFrameEMDBId(self, inFrameEMDBId): self.inFrameEMDBId = inFrameEMDBId
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_authors(self): return self.authors
    def set_authors(self, authors): self.authors = authors
    def get_keywords(self): return self.keywords
    def set_keywords(self, keywords): self.keywords = keywords
    def get_fittedPDBEntryIdList(self): return self.fittedPDBEntryIdList
    def set_fittedPDBEntryIdList(self, fittedPDBEntryIdList): self.fittedPDBEntryIdList = fittedPDBEntryIdList
    def get_primaryReference(self): return self.primaryReference
    def set_primaryReference(self, primaryReference): self.primaryReference = primaryReference
    def get_secondaryReference(self): return self.secondaryReference
    def set_secondaryReference(self, secondaryReference): self.secondaryReference = secondaryReference
    def add_secondaryReference(self, value): self.secondaryReference.append(value)
    def insert_secondaryReference_at(self, index, value): self.secondaryReference.insert(index, value)
    def replace_secondaryReference_at(self, index, value): self.secondaryReference[index] = value
    def validate_depositionSiteType(self, value):
        # Validate type depositionSiteType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PDBe', 'RCSB']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on depositionSiteType' % {"value" : value.encode("utf-8")} )
    def validate_processingSiteType(self, value):
        # Validate type processingSiteType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PDBe', 'RCSB', 'PDBj']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on processingSiteType' % {"value" : value.encode("utf-8")} )
    def validate_emdbEntryIdType(self, value):
        # Validate type emdbEntryIdType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdbEntryIdType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdbEntryIdType_patterns_, ))
    validate_emdbEntryIdType_patterns_ = [['^EMD-\\d{4,}(, EMD-\\d{4,})*$']]
    def hasContent_(self):
        if (
            self.status is not None or
            self.depositionDate is not None or
            self.depositionSite is not None or
            self.processingSite is not None or
            self.headerReleaseDate is not None or
            self.mapReleaseDate is not None or
            self.obsoletedDate is not None or
            self.supersededByList is not None or
            self.replaceExistingEntry is not None or
            self.obsoleteList is not None or
            self.details is not None or
            self.inFrameEMDBId is not None or
            self.title is not None or
            self.authors is not None or
            self.keywords is not None or
            self.fittedPDBEntryIdList is not None or
            self.primaryReference is not None or
            self.secondaryReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='depType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='depType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='depType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='depType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='depType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.depositionDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdepositionDate>%s</%sdepositionDate>%s' % (namespace_, self.gds_format_date(self.depositionDate, input_name='depositionDate'), namespace_, eol_))
        if self.depositionSite is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdepositionSite>%s</%sdepositionSite>%s' % (namespace_, self.gds_format_string(quote_xml(self.depositionSite).encode(ExternalEncoding), input_name='depositionSite'), namespace_, eol_))
        if self.processingSite is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocessingSite>%s</%sprocessingSite>%s' % (namespace_, self.gds_format_string(quote_xml(self.processingSite).encode(ExternalEncoding), input_name='processingSite'), namespace_, eol_))
        if self.headerReleaseDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheaderReleaseDate>%s</%sheaderReleaseDate>%s' % (namespace_, self.gds_format_date(self.headerReleaseDate, input_name='headerReleaseDate'), namespace_, eol_))
        if self.mapReleaseDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smapReleaseDate>%s</%smapReleaseDate>%s' % (namespace_, self.gds_format_date(self.mapReleaseDate, input_name='mapReleaseDate'), namespace_, eol_))
        if self.obsoletedDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sobsoletedDate>%s</%sobsoletedDate>%s' % (namespace_, self.gds_format_date(self.obsoletedDate, input_name='obsoletedDate'), namespace_, eol_))
        if self.supersededByList is not None:
            self.supersededByList.export(outfile, level, namespace_, name_='supersededByList', pretty_print=pretty_print)
        if self.replaceExistingEntry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreplaceExistingEntry>%s</%sreplaceExistingEntry>%s' % (namespace_, self.gds_format_boolean(self.replaceExistingEntry, input_name='replaceExistingEntry'), namespace_, eol_))
        if self.obsoleteList is not None:
            self.obsoleteList.export(outfile, level, namespace_, name_='obsoleteList', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.inFrameEMDBId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinFrameEMDBId>%s</%sinFrameEMDBId>%s' % (namespace_, self.gds_format_string(quote_xml(self.inFrameEMDBId).encode(ExternalEncoding), input_name='inFrameEMDBId'), namespace_, eol_))
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.title).encode(ExternalEncoding), input_name='title'), namespace_, eol_))
        if self.authors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthors>%s</%sauthors>%s' % (namespace_, self.gds_format_string(quote_xml(self.authors).encode(ExternalEncoding), input_name='authors'), namespace_, eol_))
        if self.keywords is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeywords>%s</%skeywords>%s' % (namespace_, self.gds_format_string(quote_xml(self.keywords).encode(ExternalEncoding), input_name='keywords'), namespace_, eol_))
        if self.fittedPDBEntryIdList is not None:
            self.fittedPDBEntryIdList.export(outfile, level, namespace_, name_='fittedPDBEntryIdList', pretty_print=pretty_print)
        if self.primaryReference is not None:
            self.primaryReference.export(outfile, level, namespace_, name_='primaryReference', pretty_print=pretty_print)
        for secondaryReference_ in self.secondaryReference:
            secondaryReference_.export(outfile, level, namespace_, name_='secondaryReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'status':
            obj_ = statusType.factory()
            obj_.build(child_)
            self.status = obj_
            obj_.original_tagname_ = 'status'
        elif nodeName_ == 'depositionDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.depositionDate = dval_
        elif nodeName_ == 'depositionSite':
            depositionSite_ = child_.text
            depositionSite_ = re_.sub(String_cleanup_pat_, " ", depositionSite_).strip()
            depositionSite_ = self.gds_validate_string(depositionSite_, node, 'depositionSite')
            self.depositionSite = depositionSite_
            # validate type depositionSiteType
            self.validate_depositionSiteType(self.depositionSite)
        elif nodeName_ == 'processingSite':
            processingSite_ = child_.text
            processingSite_ = re_.sub(String_cleanup_pat_, " ", processingSite_).strip()
            processingSite_ = self.gds_validate_string(processingSite_, node, 'processingSite')
            self.processingSite = processingSite_
            # validate type processingSiteType
            self.validate_processingSiteType(self.processingSite)
        elif nodeName_ == 'headerReleaseDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.headerReleaseDate = dval_
        elif nodeName_ == 'mapReleaseDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.mapReleaseDate = dval_
        elif nodeName_ == 'obsoletedDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.obsoletedDate = dval_
        elif nodeName_ == 'supersededByList':
            obj_ = emdbListType.factory()
            obj_.build(child_)
            self.supersededByList = obj_
            obj_.original_tagname_ = 'supersededByList'
        elif nodeName_ == 'replaceExistingEntry':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'replaceExistingEntry')
            self.replaceExistingEntry = ival_
        elif nodeName_ == 'obsoleteList':
            obj_ = emdbListType.factory()
            obj_.build(child_)
            self.obsoleteList = obj_
            obj_.original_tagname_ = 'obsoleteList'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'inFrameEMDBId':
            inFrameEMDBId_ = child_.text
            inFrameEMDBId_ = self.gds_validate_string(inFrameEMDBId_, node, 'inFrameEMDBId')
            self.inFrameEMDBId = inFrameEMDBId_
            # validate type emdbEntryIdType
            self.validate_emdbEntryIdType(self.inFrameEMDBId)
        elif nodeName_ == 'title':
            title_ = child_.text
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'authors':
            authors_ = child_.text
            authors_ = self.gds_validate_string(authors_, node, 'authors')
            self.authors = authors_
        elif nodeName_ == 'keywords':
            keywords_ = child_.text
            keywords_ = self.gds_validate_string(keywords_, node, 'keywords')
            self.keywords = keywords_
        elif nodeName_ == 'fittedPDBEntryIdList':
            obj_ = pdbidListType.factory()
            obj_.build(child_)
            self.fittedPDBEntryIdList = obj_
            obj_.original_tagname_ = 'fittedPDBEntryIdList'
        elif nodeName_ == 'primaryReference':
            obj_ = prRefType.factory()
            obj_.build(child_)
            self.primaryReference = obj_
            obj_.original_tagname_ = 'primaryReference'
        elif nodeName_ == 'secondaryReference':
            obj_ = prRefType.factory()
            obj_.build(child_)
            self.secondaryReference.append(obj_)
            obj_.original_tagname_ = 'secondaryReference'
# end class depType


class mapType(GeneratedsSuper):
    """Information on the volume density map"""
    member_data_items_ = [
        MemberSpec_('file', 'mapFileType', 0),
        MemberSpec_('dataType', ['mapDataType', 'xs:string'], 0),
        MemberSpec_('dimensions', 'dimensionType', 0),
        MemberSpec_('origin', 'originType', 0),
        MemberSpec_('limit', 'limitType', 0),
        MemberSpec_('spacing', 'spacingType', 0),
        MemberSpec_('cell', 'cellType', 0),
        MemberSpec_('axisOrder', 'axisOrderType', 0),
        MemberSpec_('statistics', 'statisticsType', 0),
        MemberSpec_('spaceGroupNumber', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('pixelSpacing', 'pixelSpacingType', 0),
        MemberSpec_('contourLevel', 'contourLevelType', 0),
        MemberSpec_('annotationDetails', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, dataType=None, dimensions=None, origin=None, limit=None, spacing=None, cell=None, axisOrder=None, statistics=None, spaceGroupNumber=None, details=None, pixelSpacing=None, contourLevel=None, annotationDetails=None):
        self.original_tagname_ = None
        self.file = file
        self.dataType = dataType
        self.validate_mapDataType(self.dataType)
        self.dimensions = dimensions
        self.origin = origin
        self.limit = limit
        self.spacing = spacing
        self.cell = cell
        self.axisOrder = axisOrder
        self.statistics = statistics
        self.spaceGroupNumber = spaceGroupNumber
        self.details = details
        self.pixelSpacing = pixelSpacing
        self.contourLevel = contourLevel
        self.annotationDetails = annotationDetails
    def factory(*args_, **kwargs_):
        if mapType.subclass:
            return mapType.subclass(*args_, **kwargs_)
        else:
            return mapType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_dataType(self): return self.dataType
    def set_dataType(self, dataType): self.dataType = dataType
    def get_dimensions(self): return self.dimensions
    def set_dimensions(self, dimensions): self.dimensions = dimensions
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_limit(self): return self.limit
    def set_limit(self, limit): self.limit = limit
    def get_spacing(self): return self.spacing
    def set_spacing(self, spacing): self.spacing = spacing
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_axisOrder(self): return self.axisOrder
    def set_axisOrder(self, axisOrder): self.axisOrder = axisOrder
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_spaceGroupNumber(self): return self.spaceGroupNumber
    def set_spaceGroupNumber(self, spaceGroupNumber): self.spaceGroupNumber = spaceGroupNumber
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_pixelSpacing(self): return self.pixelSpacing
    def set_pixelSpacing(self, pixelSpacing): self.pixelSpacing = pixelSpacing
    def get_contourLevel(self): return self.contourLevel
    def set_contourLevel(self, contourLevel): self.contourLevel = contourLevel
    def get_annotationDetails(self): return self.annotationDetails
    def set_annotationDetails(self, annotationDetails): self.annotationDetails = annotationDetails
    def validate_mapDataType(self, value):
        # Validate type mapDataType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Envelope stored as signed bytes', 'Image stored as Integer*2', 'Image stored as Reals']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on mapDataType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.file is not None or
            self.dataType is not None or
            self.dimensions is not None or
            self.origin is not None or
            self.limit is not None or
            self.spacing is not None or
            self.cell is not None or
            self.axisOrder is not None or
            self.statistics is not None or
            self.spaceGroupNumber is not None or
            self.details is not None or
            self.pixelSpacing is not None or
            self.contourLevel is not None or
            self.annotationDetails is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='mapType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mapType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='mapType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mapType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='mapType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
        if self.dataType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataType>%s</%sdataType>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataType).encode(ExternalEncoding), input_name='dataType'), namespace_, eol_))
        if self.dimensions is not None:
            self.dimensions.export(outfile, level, namespace_, name_='dimensions', pretty_print=pretty_print)
        if self.origin is not None:
            self.origin.export(outfile, level, namespace_, name_='origin', pretty_print=pretty_print)
        if self.limit is not None:
            self.limit.export(outfile, level, namespace_, name_='limit', pretty_print=pretty_print)
        if self.spacing is not None:
            self.spacing.export(outfile, level, namespace_, name_='spacing', pretty_print=pretty_print)
        if self.cell is not None:
            self.cell.export(outfile, level, namespace_, name_='cell', pretty_print=pretty_print)
        if self.axisOrder is not None:
            self.axisOrder.export(outfile, level, namespace_, name_='axisOrder', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.spaceGroupNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspaceGroupNumber>%s</%sspaceGroupNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.spaceGroupNumber).encode(ExternalEncoding), input_name='spaceGroupNumber'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.pixelSpacing is not None:
            self.pixelSpacing.export(outfile, level, namespace_, name_='pixelSpacing', pretty_print=pretty_print)
        if self.contourLevel is not None:
            self.contourLevel.export(outfile, level, namespace_, name_='contourLevel', pretty_print=pretty_print)
        if self.annotationDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sannotationDetails>%s</%sannotationDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.annotationDetails).encode(ExternalEncoding), input_name='annotationDetails'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = mapFileType.factory()
            obj_.build(child_)
            self.file = obj_
            obj_.original_tagname_ = 'file'
        elif nodeName_ == 'dataType':
            dataType_ = child_.text
            dataType_ = self.gds_validate_string(dataType_, node, 'dataType')
            self.dataType = dataType_
            # validate type mapDataType
            self.validate_mapDataType(self.dataType)
        elif nodeName_ == 'dimensions':
            obj_ = dimensionType.factory()
            obj_.build(child_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'origin':
            obj_ = originType.factory()
            obj_.build(child_)
            self.origin = obj_
            obj_.original_tagname_ = 'origin'
        elif nodeName_ == 'limit':
            obj_ = limitType.factory()
            obj_.build(child_)
            self.limit = obj_
            obj_.original_tagname_ = 'limit'
        elif nodeName_ == 'spacing':
            obj_ = spacingType.factory()
            obj_.build(child_)
            self.spacing = obj_
            obj_.original_tagname_ = 'spacing'
        elif nodeName_ == 'cell':
            obj_ = cellType.factory()
            obj_.build(child_)
            self.cell = obj_
            obj_.original_tagname_ = 'cell'
        elif nodeName_ == 'axisOrder':
            obj_ = axisOrderType.factory()
            obj_.build(child_)
            self.axisOrder = obj_
            obj_.original_tagname_ = 'axisOrder'
        elif nodeName_ == 'statistics':
            obj_ = statisticsType.factory()
            obj_.build(child_)
            self.statistics = obj_
            obj_.original_tagname_ = 'statistics'
        elif nodeName_ == 'spaceGroupNumber':
            spaceGroupNumber_ = child_.text
            spaceGroupNumber_ = self.gds_validate_string(spaceGroupNumber_, node, 'spaceGroupNumber')
            self.spaceGroupNumber = spaceGroupNumber_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'pixelSpacing':
            obj_ = pixelSpacingType.factory()
            obj_.build(child_)
            self.pixelSpacing = obj_
            obj_.original_tagname_ = 'pixelSpacing'
        elif nodeName_ == 'contourLevel':
            obj_ = contourLevelType.factory()
            obj_.build(child_)
            self.contourLevel = obj_
            obj_.original_tagname_ = 'contourLevel'
        elif nodeName_ == 'annotationDetails':
            annotationDetails_ = child_.text
            annotationDetails_ = self.gds_validate_string(annotationDetails_, node, 'annotationDetails')
            self.annotationDetails = annotationDetails_
# end class mapType


class samplType(GeneratedsSuper):
    """Nature of the biological sample studied. [/emdEntry/sample]"""
    member_data_items_ = [
        MemberSpec_('numComponents', 'xs:positiveInteger', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('compDegree', 'xs:string', 0),
        MemberSpec_('molWtTheo', 'mwType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('molWtMethod', 'xs:string', 0),
        MemberSpec_('molWtExp', 'mwType', 0),
        MemberSpec_('sampleComponentList', 'smplCompListType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, numComponents=None, name=None, compDegree=None, molWtTheo=None, details=None, molWtMethod=None, molWtExp=None, sampleComponentList=None):
        self.original_tagname_ = None
        self.numComponents = numComponents
        self.name = name
        self.compDegree = compDegree
        self.molWtTheo = molWtTheo
        self.details = details
        self.molWtMethod = molWtMethod
        self.molWtExp = molWtExp
        self.sampleComponentList = sampleComponentList
    def factory(*args_, **kwargs_):
        if samplType.subclass:
            return samplType.subclass(*args_, **kwargs_)
        else:
            return samplType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numComponents(self): return self.numComponents
    def set_numComponents(self, numComponents): self.numComponents = numComponents
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_compDegree(self): return self.compDegree
    def set_compDegree(self, compDegree): self.compDegree = compDegree
    def get_molWtTheo(self): return self.molWtTheo
    def set_molWtTheo(self, molWtTheo): self.molWtTheo = molWtTheo
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_molWtMethod(self): return self.molWtMethod
    def set_molWtMethod(self, molWtMethod): self.molWtMethod = molWtMethod
    def get_molWtExp(self): return self.molWtExp
    def set_molWtExp(self, molWtExp): self.molWtExp = molWtExp
    def get_sampleComponentList(self): return self.sampleComponentList
    def set_sampleComponentList(self, sampleComponentList): self.sampleComponentList = sampleComponentList
    def hasContent_(self):
        if (
            self.numComponents is not None or
            self.name is not None or
            self.compDegree is not None or
            self.molWtTheo is not None or
            self.details is not None or
            self.molWtMethod is not None or
            self.molWtExp is not None or
            self.sampleComponentList is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='samplType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='samplType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='samplType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='samplType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='samplType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.numComponents is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumComponents>%s</%snumComponents>%s' % (namespace_, self.gds_format_integer(self.numComponents, input_name='numComponents'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
        if self.compDegree is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompDegree>%s</%scompDegree>%s' % (namespace_, self.gds_format_string(quote_xml(self.compDegree).encode(ExternalEncoding), input_name='compDegree'), namespace_, eol_))
        if self.molWtTheo is not None:
            self.molWtTheo.export(outfile, level, namespace_, name_='molWtTheo', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.molWtMethod is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smolWtMethod>%s</%smolWtMethod>%s' % (namespace_, self.gds_format_string(quote_xml(self.molWtMethod).encode(ExternalEncoding), input_name='molWtMethod'), namespace_, eol_))
        if self.molWtExp is not None:
            self.molWtExp.export(outfile, level, namespace_, name_='molWtExp', pretty_print=pretty_print)
        if self.sampleComponentList is not None:
            self.sampleComponentList.export(outfile, level, namespace_, name_='sampleComponentList', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'numComponents':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numComponents')
            self.numComponents = ival_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'compDegree':
            compDegree_ = child_.text
            compDegree_ = self.gds_validate_string(compDegree_, node, 'compDegree')
            self.compDegree = compDegree_
        elif nodeName_ == 'molWtTheo':
            obj_ = mwType.factory()
            obj_.build(child_)
            self.molWtTheo = obj_
            obj_.original_tagname_ = 'molWtTheo'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'molWtMethod':
            molWtMethod_ = child_.text
            molWtMethod_ = self.gds_validate_string(molWtMethod_, node, 'molWtMethod')
            self.molWtMethod = molWtMethod_
        elif nodeName_ == 'molWtExp':
            obj_ = mwType.factory()
            obj_.build(child_)
            self.molWtExp = obj_
            obj_.original_tagname_ = 'molWtExp'
        elif nodeName_ == 'sampleComponentList':
            obj_ = smplCompListType.factory()
            obj_.build(child_)
            self.sampleComponentList = obj_
            obj_.original_tagname_ = 'sampleComponentList'
# end class samplType


class expType(GeneratedsSuper):
    """Experimental techniques used to derive the density map."""
    member_data_items_ = [
        MemberSpec_('vitrification', 'vitrifType', 1),
        MemberSpec_('imaging', 'imgType', 1),
        MemberSpec_('imageAcquisition', 'imgScanType', 1),
        MemberSpec_('fitting', 'fittingType', 1),
        MemberSpec_('specimenPreparation', 'smplPrepType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, vitrification=None, imaging=None, imageAcquisition=None, fitting=None, specimenPreparation=None):
        self.original_tagname_ = None
        if vitrification is None:
            self.vitrification = []
        else:
            self.vitrification = vitrification
        if imaging is None:
            self.imaging = []
        else:
            self.imaging = imaging
        if imageAcquisition is None:
            self.imageAcquisition = []
        else:
            self.imageAcquisition = imageAcquisition
        if fitting is None:
            self.fitting = []
        else:
            self.fitting = fitting
        self.specimenPreparation = specimenPreparation
    def factory(*args_, **kwargs_):
        if expType.subclass:
            return expType.subclass(*args_, **kwargs_)
        else:
            return expType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vitrification(self): return self.vitrification
    def set_vitrification(self, vitrification): self.vitrification = vitrification
    def add_vitrification(self, value): self.vitrification.append(value)
    def insert_vitrification_at(self, index, value): self.vitrification.insert(index, value)
    def replace_vitrification_at(self, index, value): self.vitrification[index] = value
    def get_imaging(self): return self.imaging
    def set_imaging(self, imaging): self.imaging = imaging
    def add_imaging(self, value): self.imaging.append(value)
    def insert_imaging_at(self, index, value): self.imaging.insert(index, value)
    def replace_imaging_at(self, index, value): self.imaging[index] = value
    def get_imageAcquisition(self): return self.imageAcquisition
    def set_imageAcquisition(self, imageAcquisition): self.imageAcquisition = imageAcquisition
    def add_imageAcquisition(self, value): self.imageAcquisition.append(value)
    def insert_imageAcquisition_at(self, index, value): self.imageAcquisition.insert(index, value)
    def replace_imageAcquisition_at(self, index, value): self.imageAcquisition[index] = value
    def get_fitting(self): return self.fitting
    def set_fitting(self, fitting): self.fitting = fitting
    def add_fitting(self, value): self.fitting.append(value)
    def insert_fitting_at(self, index, value): self.fitting.insert(index, value)
    def replace_fitting_at(self, index, value): self.fitting[index] = value
    def get_specimenPreparation(self): return self.specimenPreparation
    def set_specimenPreparation(self, specimenPreparation): self.specimenPreparation = specimenPreparation
    def hasContent_(self):
        if (
            self.vitrification or
            self.imaging or
            self.imageAcquisition or
            self.fitting or
            self.specimenPreparation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='expType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='expType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='expType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='expType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='expType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for vitrification_ in self.vitrification:
            vitrification_.export(outfile, level, namespace_, name_='vitrification', pretty_print=pretty_print)
        for imaging_ in self.imaging:
            imaging_.export(outfile, level, namespace_, name_='imaging', pretty_print=pretty_print)
        for imageAcquisition_ in self.imageAcquisition:
            imageAcquisition_.export(outfile, level, namespace_, name_='imageAcquisition', pretty_print=pretty_print)
        for fitting_ in self.fitting:
            fitting_.export(outfile, level, namespace_, name_='fitting', pretty_print=pretty_print)
        if self.specimenPreparation is not None:
            self.specimenPreparation.export(outfile, level, namespace_, name_='specimenPreparation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vitrification':
            obj_ = vitrifType.factory()
            obj_.build(child_)
            self.vitrification.append(obj_)
            obj_.original_tagname_ = 'vitrification'
        elif nodeName_ == 'imaging':
            obj_ = imgType.factory()
            obj_.build(child_)
            self.imaging.append(obj_)
            obj_.original_tagname_ = 'imaging'
        elif nodeName_ == 'imageAcquisition':
            obj_ = imgScanType.factory()
            obj_.build(child_)
            self.imageAcquisition.append(obj_)
            obj_.original_tagname_ = 'imageAcquisition'
        elif nodeName_ == 'fitting':
            obj_ = fittingType.factory()
            obj_.build(child_)
            self.fitting.append(obj_)
            obj_.original_tagname_ = 'fitting'
        elif nodeName_ == 'specimenPreparation':
            obj_ = smplPrepType.factory()
            obj_.build(child_)
            self.specimenPreparation = obj_
            obj_.original_tagname_ = 'specimenPreparation'
# end class expType


class processType(GeneratedsSuper):
    """Digital processing of the image data."""
    member_data_items_ = [
        MemberSpec_('method', ['methodType', 'xs:string'], 0),
        MemberSpec_('reconstruction', 'reconsType', 1),
        MemberSpec_('twoDCrystal', 'xtal2DType', 0),
        MemberSpec_('helical', 'helixType', 0),
        MemberSpec_('subtomogramAveraging', 'subTomType', 0),
        MemberSpec_('tomography', 'tomogrType', 0),
        MemberSpec_('singleParticle', 'singPartType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, method=None, reconstruction=None, twoDCrystal=None, helical=None, subtomogramAveraging=None, tomography=None, singleParticle=None):
        self.original_tagname_ = None
        self.method = method
        self.validate_methodType(self.method)
        if reconstruction is None:
            self.reconstruction = []
        else:
            self.reconstruction = reconstruction
        self.twoDCrystal = twoDCrystal
        self.helical = helical
        self.subtomogramAveraging = subtomogramAveraging
        self.tomography = tomography
        self.singleParticle = singleParticle
    def factory(*args_, **kwargs_):
        if processType.subclass:
            return processType.subclass(*args_, **kwargs_)
        else:
            return processType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def get_reconstruction(self): return self.reconstruction
    def set_reconstruction(self, reconstruction): self.reconstruction = reconstruction
    def add_reconstruction(self, value): self.reconstruction.append(value)
    def insert_reconstruction_at(self, index, value): self.reconstruction.insert(index, value)
    def replace_reconstruction_at(self, index, value): self.reconstruction[index] = value
    def get_twoDCrystal(self): return self.twoDCrystal
    def set_twoDCrystal(self, twoDCrystal): self.twoDCrystal = twoDCrystal
    def get_helical(self): return self.helical
    def set_helical(self, helical): self.helical = helical
    def get_subtomogramAveraging(self): return self.subtomogramAveraging
    def set_subtomogramAveraging(self, subtomogramAveraging): self.subtomogramAveraging = subtomogramAveraging
    def get_tomography(self): return self.tomography
    def set_tomography(self, tomography): self.tomography = tomography
    def get_singleParticle(self): return self.singleParticle
    def set_singleParticle(self, singleParticle): self.singleParticle = singleParticle
    def validate_methodType(self, value):
        # Validate type methodType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['twoDCrystal', 'singleParticle', 'tomography', 'subtomogramAveraging', 'helical']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on methodType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.method is not None or
            self.reconstruction or
            self.twoDCrystal is not None or
            self.helical is not None or
            self.subtomogramAveraging is not None or
            self.tomography is not None or
            self.singleParticle is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='processType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='processType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='processType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='processType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='processType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethod>%s</%smethod>%s' % (namespace_, self.gds_format_string(quote_xml(self.method).encode(ExternalEncoding), input_name='method'), namespace_, eol_))
        for reconstruction_ in self.reconstruction:
            reconstruction_.export(outfile, level, namespace_, name_='reconstruction', pretty_print=pretty_print)
        if self.twoDCrystal is not None:
            self.twoDCrystal.export(outfile, level, namespace_, name_='twoDCrystal', pretty_print=pretty_print)
        if self.helical is not None:
            self.helical.export(outfile, level, namespace_, name_='helical', pretty_print=pretty_print)
        if self.subtomogramAveraging is not None:
            self.subtomogramAveraging.export(outfile, level, namespace_, name_='subtomogramAveraging', pretty_print=pretty_print)
        if self.tomography is not None:
            self.tomography.export(outfile, level, namespace_, name_='tomography', pretty_print=pretty_print)
        if self.singleParticle is not None:
            self.singleParticle.export(outfile, level, namespace_, name_='singleParticle', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'method':
            method_ = child_.text
            method_ = self.gds_validate_string(method_, node, 'method')
            self.method = method_
            # validate type methodType
            self.validate_methodType(self.method)
        elif nodeName_ == 'reconstruction':
            obj_ = reconsType.factory()
            obj_.build(child_)
            self.reconstruction.append(obj_)
            obj_.original_tagname_ = 'reconstruction'
        elif nodeName_ == 'twoDCrystal':
            obj_ = xtal2DType.factory()
            obj_.build(child_)
            self.twoDCrystal = obj_
            obj_.original_tagname_ = 'twoDCrystal'
        elif nodeName_ == 'helical':
            obj_ = helixType.factory()
            obj_.build(child_)
            self.helical = obj_
            obj_.original_tagname_ = 'helical'
        elif nodeName_ == 'subtomogramAveraging':
            obj_ = subTomType.factory()
            obj_.build(child_)
            self.subtomogramAveraging = obj_
            obj_.original_tagname_ = 'subtomogramAveraging'
        elif nodeName_ == 'tomography':
            obj_ = tomogrType.factory()
            obj_.build(child_)
            self.tomography = obj_
            obj_.original_tagname_ = 'tomography'
        elif nodeName_ == 'singleParticle':
            obj_ = singPartType.factory()
            obj_.build(child_)
            self.singleParticle = obj_
            obj_.original_tagname_ = 'singleParticle'
# end class processType


class fittingType(GeneratedsSuper):
    """Fitting procedure details for coordinates."""
    member_data_items_ = [
        MemberSpec_('pdbEntryIdList', 'pdbidList2Type', 0),
        MemberSpec_('software', 'xs:string', 0),
        MemberSpec_('refProtocol', ['refProtocolType', 'xs:string'], 0),
        MemberSpec_('targetCriteria', 'xs:string', 0),
        MemberSpec_('overallBValue', 'xs:float', 0),
        MemberSpec_('refSpace', ['refSpaceType', 'xs:string'], 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, pdbEntryIdList=None, software=None, refProtocol=None, targetCriteria=None, overallBValue=None, refSpace=None, details=None):
        self.original_tagname_ = None
        self.pdbEntryIdList = pdbEntryIdList
        self.software = software
        self.refProtocol = refProtocol
        self.validate_refProtocolType(self.refProtocol)
        self.targetCriteria = targetCriteria
        self.overallBValue = overallBValue
        self.refSpace = refSpace
        self.validate_refSpaceType(self.refSpace)
        self.details = details
    def factory(*args_, **kwargs_):
        if fittingType.subclass:
            return fittingType.subclass(*args_, **kwargs_)
        else:
            return fittingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pdbEntryIdList(self): return self.pdbEntryIdList
    def set_pdbEntryIdList(self, pdbEntryIdList): self.pdbEntryIdList = pdbEntryIdList
    def get_software(self): return self.software
    def set_software(self, software): self.software = software
    def get_refProtocol(self): return self.refProtocol
    def set_refProtocol(self, refProtocol): self.refProtocol = refProtocol
    def get_targetCriteria(self): return self.targetCriteria
    def set_targetCriteria(self, targetCriteria): self.targetCriteria = targetCriteria
    def get_overallBValue(self): return self.overallBValue
    def set_overallBValue(self, overallBValue): self.overallBValue = overallBValue
    def get_refSpace(self): return self.refSpace
    def set_refSpace(self, refSpace): self.refSpace = refSpace
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_refProtocolType(self, value):
        # Validate type refProtocolType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['rigid body', 'flexible']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on refProtocolType' % {"value" : value.encode("utf-8")} )
    def validate_refSpaceType(self, value):
        # Validate type refSpaceType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['REAL', 'RECIPROCAL']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on refSpaceType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.pdbEntryIdList is not None or
            self.software is not None or
            self.refProtocol is not None or
            self.targetCriteria is not None or
            self.overallBValue is not None or
            self.refSpace is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fittingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fittingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fittingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fittingType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='fittingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pdbEntryIdList is not None:
            self.pdbEntryIdList.export(outfile, level, namespace_, name_='pdbEntryIdList', pretty_print=pretty_print)
        if self.software is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssoftware>%s</%ssoftware>%s' % (namespace_, self.gds_format_string(quote_xml(self.software).encode(ExternalEncoding), input_name='software'), namespace_, eol_))
        if self.refProtocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefProtocol>%s</%srefProtocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.refProtocol).encode(ExternalEncoding), input_name='refProtocol'), namespace_, eol_))
        if self.targetCriteria is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stargetCriteria>%s</%stargetCriteria>%s' % (namespace_, self.gds_format_string(quote_xml(self.targetCriteria).encode(ExternalEncoding), input_name='targetCriteria'), namespace_, eol_))
        if self.overallBValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverallBValue>%s</%soverallBValue>%s' % (namespace_, self.gds_format_float(self.overallBValue, input_name='overallBValue'), namespace_, eol_))
        if self.refSpace is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefSpace>%s</%srefSpace>%s' % (namespace_, self.gds_format_string(quote_xml(self.refSpace).encode(ExternalEncoding), input_name='refSpace'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pdbEntryIdList':
            obj_ = pdbidList2Type.factory()
            obj_.build(child_)
            self.pdbEntryIdList = obj_
            obj_.original_tagname_ = 'pdbEntryIdList'
        elif nodeName_ == 'software':
            software_ = child_.text
            software_ = self.gds_validate_string(software_, node, 'software')
            self.software = software_
        elif nodeName_ == 'refProtocol':
            refProtocol_ = child_.text
            refProtocol_ = self.gds_validate_string(refProtocol_, node, 'refProtocol')
            self.refProtocol = refProtocol_
            # validate type refProtocolType
            self.validate_refProtocolType(self.refProtocol)
        elif nodeName_ == 'targetCriteria':
            targetCriteria_ = child_.text
            targetCriteria_ = self.gds_validate_string(targetCriteria_, node, 'targetCriteria')
            self.targetCriteria = targetCriteria_
        elif nodeName_ == 'overallBValue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'overallBValue')
            self.overallBValue = fval_
        elif nodeName_ == 'refSpace':
            refSpace_ = child_.text
            refSpace_ = self.gds_validate_string(refSpace_, node, 'refSpace')
            self.refSpace = refSpace_
            # validate type refSpaceType
            self.validate_refSpaceType(self.refSpace)
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class fittingType


class supplType(GeneratedsSuper):
    """Supplemental data sets."""
    member_data_items_ = [
        MemberSpec_('maskSet', 'mskSetType', 0),
        MemberSpec_('sliceSet', 'slcSetType', 0),
        MemberSpec_('figureSet', 'figSetType', 0),
        MemberSpec_('fscSet', 'fscSetType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, maskSet=None, sliceSet=None, figureSet=None, fscSet=None):
        self.original_tagname_ = None
        self.maskSet = maskSet
        self.sliceSet = sliceSet
        self.figureSet = figureSet
        self.fscSet = fscSet
    def factory(*args_, **kwargs_):
        if supplType.subclass:
            return supplType.subclass(*args_, **kwargs_)
        else:
            return supplType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_maskSet(self): return self.maskSet
    def set_maskSet(self, maskSet): self.maskSet = maskSet
    def get_sliceSet(self): return self.sliceSet
    def set_sliceSet(self, sliceSet): self.sliceSet = sliceSet
    def get_figureSet(self): return self.figureSet
    def set_figureSet(self, figureSet): self.figureSet = figureSet
    def get_fscSet(self): return self.fscSet
    def set_fscSet(self, fscSet): self.fscSet = fscSet
    def hasContent_(self):
        if (
            self.maskSet is not None or
            self.sliceSet is not None or
            self.figureSet is not None or
            self.fscSet is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='supplType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='supplType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='supplType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='supplType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='supplType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.maskSet is not None:
            self.maskSet.export(outfile, level, namespace_, name_='maskSet', pretty_print=pretty_print)
        if self.sliceSet is not None:
            self.sliceSet.export(outfile, level, namespace_, name_='sliceSet', pretty_print=pretty_print)
        if self.figureSet is not None:
            self.figureSet.export(outfile, level, namespace_, name_='figureSet', pretty_print=pretty_print)
        if self.fscSet is not None:
            self.fscSet.export(outfile, level, namespace_, name_='fscSet', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'maskSet':
            obj_ = mskSetType.factory()
            obj_.build(child_)
            self.maskSet = obj_
            obj_.original_tagname_ = 'maskSet'
        elif nodeName_ == 'sliceSet':
            obj_ = slcSetType.factory()
            obj_.build(child_)
            self.sliceSet = obj_
            obj_.original_tagname_ = 'sliceSet'
        elif nodeName_ == 'figureSet':
            obj_ = figSetType.factory()
            obj_.build(child_)
            self.figureSet = obj_
            obj_.original_tagname_ = 'figureSet'
        elif nodeName_ == 'fscSet':
            obj_ = fscSetType.factory()
            obj_.build(child_)
            self.fscSet = obj_
            obj_.original_tagname_ = 'fscSet'
# end class supplType


class smplCompListType(GeneratedsSuper):
    """List of individual sample components.
    [/emdEntry/sample/sampleComponentList]"""
    member_data_items_ = [
        MemberSpec_('sampleComponent', 'smplCompType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, sampleComponent=None):
        self.original_tagname_ = None
        if sampleComponent is None:
            self.sampleComponent = []
        else:
            self.sampleComponent = sampleComponent
    def factory(*args_, **kwargs_):
        if smplCompListType.subclass:
            return smplCompListType.subclass(*args_, **kwargs_)
        else:
            return smplCompListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sampleComponent(self): return self.sampleComponent
    def set_sampleComponent(self, sampleComponent): self.sampleComponent = sampleComponent
    def add_sampleComponent(self, value): self.sampleComponent.append(value)
    def insert_sampleComponent_at(self, index, value): self.sampleComponent.insert(index, value)
    def replace_sampleComponent_at(self, index, value): self.sampleComponent[index] = value
    def hasContent_(self):
        if (
            self.sampleComponent
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='smplCompListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='smplCompListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='smplCompListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='smplCompListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='smplCompListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for sampleComponent_ in self.sampleComponent:
            sampleComponent_.export(outfile, level, namespace_, name_='sampleComponent', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sampleComponent':
            obj_ = smplCompType.factory()
            obj_.build(child_)
            self.sampleComponent.append(obj_)
            obj_.original_tagname_ = 'sampleComponent'
# end class smplCompListType


class smplCompType(GeneratedsSuper):
    """A single sample component.
    [/emdEntry/sample/sampleComponentList/sampleComponent]"""
    member_data_items_ = [
        MemberSpec_('componentID', 'xs:positiveInteger', 0),
        MemberSpec_('entry', ['cmpntClassType', 'xs:string'], 0),
        MemberSpec_('sciName', 'xs:string', 0),
        MemberSpec_('synName', 'xs:string', 0),
        MemberSpec_('molWtTheo', 'mwType', 0),
        MemberSpec_('molWtExp', 'mwType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('protein', 'proteinType', 0),
        MemberSpec_('cellular_component', 'cellCompType', 0),
        MemberSpec_('virus', 'virusType', 0),
        MemberSpec_('nucleic_acid', 'nuclAcidType', 0),
        MemberSpec_('ligand', 'ligandType', 0),
        MemberSpec_('label', 'labelType', 0),
        MemberSpec_('ribosome_eukaryote', 'riboTypeEu', 0),
        MemberSpec_('ribosome_prokaryote', 'riboTypePro', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, componentID=None, entry=None, sciName=None, synName=None, molWtTheo=None, molWtExp=None, details=None, protein=None, cellular_component=None, virus=None, nucleic_acid=None, ligand=None, label=None, ribosome_eukaryote=None, ribosome_prokaryote=None):
        self.original_tagname_ = None
        self.componentID = _cast(int, componentID)
        self.entry = entry
        self.validate_cmpntClassType(self.entry)
        self.sciName = sciName
        self.synName = synName
        self.molWtTheo = molWtTheo
        self.molWtExp = molWtExp
        self.details = details
        self.protein = protein
        self.cellular_component = cellular_component
        self.virus = virus
        self.nucleic_acid = nucleic_acid
        self.ligand = ligand
        self.label = label
        self.ribosome_eukaryote = ribosome_eukaryote
        self.ribosome_prokaryote = ribosome_prokaryote
    def factory(*args_, **kwargs_):
        if smplCompType.subclass:
            return smplCompType.subclass(*args_, **kwargs_)
        else:
            return smplCompType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_entry(self): return self.entry
    def set_entry(self, entry): self.entry = entry
    def get_sciName(self): return self.sciName
    def set_sciName(self, sciName): self.sciName = sciName
    def get_synName(self): return self.synName
    def set_synName(self, synName): self.synName = synName
    def get_molWtTheo(self): return self.molWtTheo
    def set_molWtTheo(self, molWtTheo): self.molWtTheo = molWtTheo
    def get_molWtExp(self): return self.molWtExp
    def set_molWtExp(self, molWtExp): self.molWtExp = molWtExp
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_protein(self): return self.protein
    def set_protein(self, protein): self.protein = protein
    def get_cellular_component(self): return self.cellular_component
    def set_cellular_component(self, cellular_component): self.cellular_component = cellular_component
    def get_virus(self): return self.virus
    def set_virus(self, virus): self.virus = virus
    def get_nucleic_acid(self): return self.nucleic_acid
    def set_nucleic_acid(self, nucleic_acid): self.nucleic_acid = nucleic_acid
    def get_ligand(self): return self.ligand
    def set_ligand(self, ligand): self.ligand = ligand
    def get_label(self): return self.label
    def set_label(self, label): self.label = label
    def get_ribosome_eukaryote(self): return self.ribosome_eukaryote
    def set_ribosome_eukaryote(self, ribosome_eukaryote): self.ribosome_eukaryote = ribosome_eukaryote
    def get_ribosome_prokaryote(self): return self.ribosome_prokaryote
    def set_ribosome_prokaryote(self, ribosome_prokaryote): self.ribosome_prokaryote = ribosome_prokaryote
    def get_componentID(self): return self.componentID
    def set_componentID(self, componentID): self.componentID = componentID
    def validate_cmpntClassType(self, value):
        # Validate type cmpntClassType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['virus', 'cellular-component', 'protein', 'nucleic-acid', 'ligand', 'label', 'ribosome-eukaryote', 'ribosome-prokaryote']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on cmpntClassType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.entry is not None or
            self.sciName is not None or
            self.synName is not None or
            self.molWtTheo is not None or
            self.molWtExp is not None or
            self.details is not None or
            self.protein is not None or
            self.cellular_component is not None or
            self.virus is not None or
            self.nucleic_acid is not None or
            self.ligand is not None or
            self.label is not None or
            self.ribosome_eukaryote is not None or
            self.ribosome_prokaryote is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='smplCompType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='smplCompType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='smplCompType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='smplCompType'):
        if self.componentID is not None and 'componentID' not in already_processed:
            already_processed.add('componentID')
            outfile.write(' componentID="%s"' % self.gds_format_integer(self.componentID, input_name='componentID'))
    def exportChildren(self, outfile, level, namespace_='', name_='smplCompType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.entry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sentry>%s</%sentry>%s' % (namespace_, self.gds_format_string(quote_xml(self.entry).encode(ExternalEncoding), input_name='entry'), namespace_, eol_))
        if self.sciName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssciName>%s</%ssciName>%s' % (namespace_, self.gds_format_string(quote_xml(self.sciName).encode(ExternalEncoding), input_name='sciName'), namespace_, eol_))
        if self.synName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynName>%s</%ssynName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synName).encode(ExternalEncoding), input_name='synName'), namespace_, eol_))
        if self.molWtTheo is not None:
            self.molWtTheo.export(outfile, level, namespace_, name_='molWtTheo', pretty_print=pretty_print)
        if self.molWtExp is not None:
            self.molWtExp.export(outfile, level, namespace_, name_='molWtExp', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.protein is not None:
            self.protein.export(outfile, level, namespace_, name_='protein', pretty_print=pretty_print)
        if self.cellular_component is not None:
            self.cellular_component.export(outfile, level, namespace_, name_='cellular-component', pretty_print=pretty_print)
        if self.virus is not None:
            self.virus.export(outfile, level, namespace_, name_='virus', pretty_print=pretty_print)
        if self.nucleic_acid is not None:
            self.nucleic_acid.export(outfile, level, namespace_, name_='nucleic-acid', pretty_print=pretty_print)
        if self.ligand is not None:
            self.ligand.export(outfile, level, namespace_, name_='ligand', pretty_print=pretty_print)
        if self.label is not None:
            self.label.export(outfile, level, namespace_, name_='label', pretty_print=pretty_print)
        if self.ribosome_eukaryote is not None:
            self.ribosome_eukaryote.export(outfile, level, namespace_, name_='ribosome-eukaryote', pretty_print=pretty_print)
        if self.ribosome_prokaryote is not None:
            self.ribosome_prokaryote.export(outfile, level, namespace_, name_='ribosome-prokaryote', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('componentID', node)
        if value is not None and 'componentID' not in already_processed:
            already_processed.add('componentID')
            try:
                self.componentID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.componentID <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'entry':
            entry_ = child_.text
            entry_ = self.gds_validate_string(entry_, node, 'entry')
            self.entry = entry_
            # validate type cmpntClassType
            self.validate_cmpntClassType(self.entry)
        elif nodeName_ == 'sciName':
            sciName_ = child_.text
            sciName_ = self.gds_validate_string(sciName_, node, 'sciName')
            self.sciName = sciName_
        elif nodeName_ == 'synName':
            synName_ = child_.text
            synName_ = self.gds_validate_string(synName_, node, 'synName')
            self.synName = synName_
        elif nodeName_ == 'molWtTheo':
            obj_ = mwType.factory()
            obj_.build(child_)
            self.molWtTheo = obj_
            obj_.original_tagname_ = 'molWtTheo'
        elif nodeName_ == 'molWtExp':
            obj_ = mwType.factory()
            obj_.build(child_)
            self.molWtExp = obj_
            obj_.original_tagname_ = 'molWtExp'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'protein':
            obj_ = proteinType.factory()
            obj_.build(child_)
            self.protein = obj_
            obj_.original_tagname_ = 'protein'
        elif nodeName_ == 'cellular-component':
            obj_ = cellCompType.factory()
            obj_.build(child_)
            self.cellular_component = obj_
            obj_.original_tagname_ = 'cellular-component'
        elif nodeName_ == 'virus':
            obj_ = virusType.factory()
            obj_.build(child_)
            self.virus = obj_
            obj_.original_tagname_ = 'virus'
        elif nodeName_ == 'nucleic-acid':
            obj_ = nuclAcidType.factory()
            obj_.build(child_)
            self.nucleic_acid = obj_
            obj_.original_tagname_ = 'nucleic-acid'
        elif nodeName_ == 'ligand':
            obj_ = ligandType.factory()
            obj_.build(child_)
            self.ligand = obj_
            obj_.original_tagname_ = 'ligand'
        elif nodeName_ == 'label':
            obj_ = labelType.factory()
            obj_.build(child_)
            self.label = obj_
            obj_.original_tagname_ = 'label'
        elif nodeName_ == 'ribosome-eukaryote':
            obj_ = riboTypeEu.factory()
            obj_.build(child_)
            self.ribosome_eukaryote = obj_
            obj_.original_tagname_ = 'ribosome-eukaryote'
        elif nodeName_ == 'ribosome-prokaryote':
            obj_ = riboTypePro.factory()
            obj_.build(child_)
            self.ribosome_prokaryote = obj_
            obj_.original_tagname_ = 'ribosome-prokaryote'
# end class smplCompType


class pubType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('journalArticle', 'jrnlArtType', 0),
        MemberSpec_('nonJournalArticle', 'nonJrnlArtType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, journalArticle=None, nonJournalArticle=None, extensiontype_=None):
        self.original_tagname_ = None
        self.journalArticle = journalArticle
        self.nonJournalArticle = nonJournalArticle
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if pubType.subclass:
            return pubType.subclass(*args_, **kwargs_)
        else:
            return pubType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_journalArticle(self): return self.journalArticle
    def set_journalArticle(self, journalArticle): self.journalArticle = journalArticle
    def get_nonJournalArticle(self): return self.nonJournalArticle
    def set_nonJournalArticle(self, nonJournalArticle): self.nonJournalArticle = nonJournalArticle
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.journalArticle is not None or
            self.nonJournalArticle is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pubType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pubType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pubType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pubType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pubType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.journalArticle is not None:
            self.journalArticle.export(outfile, level, namespace_, name_='journalArticle', pretty_print=pretty_print)
        if self.nonJournalArticle is not None:
            self.nonJournalArticle.export(outfile, level, namespace_, name_='nonJournalArticle', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'journalArticle':
            obj_ = jrnlArtType.factory()
            obj_.build(child_)
            self.journalArticle = obj_
            obj_.original_tagname_ = 'journalArticle'
        elif nodeName_ == 'nonJournalArticle':
            obj_ = nonJrnlArtType.factory()
            obj_.build(child_)
            self.nonJournalArticle = obj_
            obj_.original_tagname_ = 'nonJournalArticle'
# end class pubType


class prRefType(pubType):
    member_data_items_ = [
        MemberSpec_('published', 'xs:boolean', 0),
    ]
    subclass = None
    superclass = pubType
    def __init__(self, journalArticle=None, nonJournalArticle=None, published=None):
        self.original_tagname_ = None
        super(prRefType, self).__init__(journalArticle, nonJournalArticle, )
        self.published = _cast(bool, published)
    def factory(*args_, **kwargs_):
        if prRefType.subclass:
            return prRefType.subclass(*args_, **kwargs_)
        else:
            return prRefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def hasContent_(self):
        if (
            super(prRefType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='prRefType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='prRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='prRefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='prRefType'):
        super(prRefType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='prRefType')
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def exportChildren(self, outfile, level, namespace_='', name_='prRefType', fromsubclass_=False, pretty_print=True):
        super(prRefType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(prRefType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(prRefType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class prRefType


class jrnlArtType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('authors', 'xs:string', 0),
        MemberSpec_('articleTitle', 'xs:string', 0),
        MemberSpec_('journal', 'xs:string', 0),
        MemberSpec_('volume', 'xs:string', 0),
        MemberSpec_('firstPage', 'xs:string', 0),
        MemberSpec_('lastPage', 'xs:string', 0),
        MemberSpec_('year', 'xs:string', 0),
        MemberSpec_('externalReference', 'externalRefType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, authors=None, articleTitle=None, journal=None, volume=None, firstPage=None, lastPage=None, year=None, externalReference=None):
        self.original_tagname_ = None
        self.authors = authors
        self.articleTitle = articleTitle
        self.journal = journal
        self.volume = volume
        self.firstPage = firstPage
        self.lastPage = lastPage
        self.year = year
        if externalReference is None:
            self.externalReference = []
        else:
            self.externalReference = externalReference
    def factory(*args_, **kwargs_):
        if jrnlArtType.subclass:
            return jrnlArtType.subclass(*args_, **kwargs_)
        else:
            return jrnlArtType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authors(self): return self.authors
    def set_authors(self, authors): self.authors = authors
    def get_articleTitle(self): return self.articleTitle
    def set_articleTitle(self, articleTitle): self.articleTitle = articleTitle
    def get_journal(self): return self.journal
    def set_journal(self, journal): self.journal = journal
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_firstPage(self): return self.firstPage
    def set_firstPage(self, firstPage): self.firstPage = firstPage
    def get_lastPage(self): return self.lastPage
    def set_lastPage(self, lastPage): self.lastPage = lastPage
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_externalReference(self): return self.externalReference
    def set_externalReference(self, externalReference): self.externalReference = externalReference
    def add_externalReference(self, value): self.externalReference.append(value)
    def insert_externalReference_at(self, index, value): self.externalReference.insert(index, value)
    def replace_externalReference_at(self, index, value): self.externalReference[index] = value
    def hasContent_(self):
        if (
            self.authors is not None or
            self.articleTitle is not None or
            self.journal is not None or
            self.volume is not None or
            self.firstPage is not None or
            self.lastPage is not None or
            self.year is not None or
            self.externalReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='jrnlArtType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='jrnlArtType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='jrnlArtType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='jrnlArtType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='jrnlArtType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.authors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthors>%s</%sauthors>%s' % (namespace_, self.gds_format_string(quote_xml(self.authors).encode(ExternalEncoding), input_name='authors'), namespace_, eol_))
        if self.articleTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarticleTitle>%s</%sarticleTitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.articleTitle).encode(ExternalEncoding), input_name='articleTitle'), namespace_, eol_))
        if self.journal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sjournal>%s</%sjournal>%s' % (namespace_, self.gds_format_string(quote_xml(self.journal).encode(ExternalEncoding), input_name='journal'), namespace_, eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume).encode(ExternalEncoding), input_name='volume'), namespace_, eol_))
        if self.firstPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirstPage>%s</%sfirstPage>%s' % (namespace_, self.gds_format_string(quote_xml(self.firstPage).encode(ExternalEncoding), input_name='firstPage'), namespace_, eol_))
        if self.lastPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastPage>%s</%slastPage>%s' % (namespace_, self.gds_format_string(quote_xml(self.lastPage).encode(ExternalEncoding), input_name='lastPage'), namespace_, eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%syear>%s</%syear>%s' % (namespace_, self.gds_format_string(quote_xml(self.year).encode(ExternalEncoding), input_name='year'), namespace_, eol_))
        for externalReference_ in self.externalReference:
            externalReference_.export(outfile, level, namespace_, name_='externalReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authors':
            authors_ = child_.text
            authors_ = self.gds_validate_string(authors_, node, 'authors')
            self.authors = authors_
        elif nodeName_ == 'articleTitle':
            articleTitle_ = child_.text
            articleTitle_ = self.gds_validate_string(articleTitle_, node, 'articleTitle')
            self.articleTitle = articleTitle_
        elif nodeName_ == 'journal':
            journal_ = child_.text
            journal_ = self.gds_validate_string(journal_, node, 'journal')
            self.journal = journal_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'firstPage':
            firstPage_ = child_.text
            firstPage_ = self.gds_validate_string(firstPage_, node, 'firstPage')
            self.firstPage = firstPage_
        elif nodeName_ == 'lastPage':
            lastPage_ = child_.text
            lastPage_ = self.gds_validate_string(lastPage_, node, 'lastPage')
            self.lastPage = lastPage_
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
        elif nodeName_ == 'externalReference':
            obj_ = externalRefType.factory()
            obj_.build(child_)
            self.externalReference.append(obj_)
            obj_.original_tagname_ = 'externalReference'
# end class jrnlArtType


class nonJrnlArtType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('authors', 'xs:string', 0),
        MemberSpec_('chapterTitle', 'xs:string', 0),
        MemberSpec_('book', 'xs:string', 0),
        MemberSpec_('thesisTitle', 'xs:string', 0),
        MemberSpec_('editor', 'xs:string', 0),
        MemberSpec_('publisher', 'xs:string', 0),
        MemberSpec_('publisherLocation', 'xs:string', 0),
        MemberSpec_('volume', 'xs:string', 0),
        MemberSpec_('firstPage', 'xs:string', 0),
        MemberSpec_('lastPage', 'xs:string', 0),
        MemberSpec_('year', 'xs:string', 0),
        MemberSpec_('externalReference', 'externalRefType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, authors=None, chapterTitle=None, book=None, thesisTitle=None, editor=None, publisher=None, publisherLocation=None, volume=None, firstPage=None, lastPage=None, year=None, externalReference=None):
        self.original_tagname_ = None
        self.authors = authors
        self.chapterTitle = chapterTitle
        self.book = book
        self.thesisTitle = thesisTitle
        self.editor = editor
        self.publisher = publisher
        self.publisherLocation = publisherLocation
        self.volume = volume
        self.firstPage = firstPage
        self.lastPage = lastPage
        self.year = year
        if externalReference is None:
            self.externalReference = []
        else:
            self.externalReference = externalReference
    def factory(*args_, **kwargs_):
        if nonJrnlArtType.subclass:
            return nonJrnlArtType.subclass(*args_, **kwargs_)
        else:
            return nonJrnlArtType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authors(self): return self.authors
    def set_authors(self, authors): self.authors = authors
    def get_chapterTitle(self): return self.chapterTitle
    def set_chapterTitle(self, chapterTitle): self.chapterTitle = chapterTitle
    def get_book(self): return self.book
    def set_book(self, book): self.book = book
    def get_thesisTitle(self): return self.thesisTitle
    def set_thesisTitle(self, thesisTitle): self.thesisTitle = thesisTitle
    def get_editor(self): return self.editor
    def set_editor(self, editor): self.editor = editor
    def get_publisher(self): return self.publisher
    def set_publisher(self, publisher): self.publisher = publisher
    def get_publisherLocation(self): return self.publisherLocation
    def set_publisherLocation(self, publisherLocation): self.publisherLocation = publisherLocation
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_firstPage(self): return self.firstPage
    def set_firstPage(self, firstPage): self.firstPage = firstPage
    def get_lastPage(self): return self.lastPage
    def set_lastPage(self, lastPage): self.lastPage = lastPage
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_externalReference(self): return self.externalReference
    def set_externalReference(self, externalReference): self.externalReference = externalReference
    def add_externalReference(self, value): self.externalReference.append(value)
    def insert_externalReference_at(self, index, value): self.externalReference.insert(index, value)
    def replace_externalReference_at(self, index, value): self.externalReference[index] = value
    def hasContent_(self):
        if (
            self.authors is not None or
            self.chapterTitle is not None or
            self.book is not None or
            self.thesisTitle is not None or
            self.editor is not None or
            self.publisher is not None or
            self.publisherLocation is not None or
            self.volume is not None or
            self.firstPage is not None or
            self.lastPage is not None or
            self.year is not None or
            self.externalReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='nonJrnlArtType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='nonJrnlArtType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='nonJrnlArtType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='nonJrnlArtType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='nonJrnlArtType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.authors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sauthors>%s</%sauthors>%s' % (namespace_, self.gds_format_string(quote_xml(self.authors).encode(ExternalEncoding), input_name='authors'), namespace_, eol_))
        if self.chapterTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schapterTitle>%s</%schapterTitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.chapterTitle).encode(ExternalEncoding), input_name='chapterTitle'), namespace_, eol_))
        if self.book is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbook>%s</%sbook>%s' % (namespace_, self.gds_format_string(quote_xml(self.book).encode(ExternalEncoding), input_name='book'), namespace_, eol_))
        if self.thesisTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sthesisTitle>%s</%sthesisTitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.thesisTitle).encode(ExternalEncoding), input_name='thesisTitle'), namespace_, eol_))
        if self.editor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%seditor>%s</%seditor>%s' % (namespace_, self.gds_format_string(quote_xml(self.editor).encode(ExternalEncoding), input_name='editor'), namespace_, eol_))
        if self.publisher is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublisher>%s</%spublisher>%s' % (namespace_, self.gds_format_string(quote_xml(self.publisher).encode(ExternalEncoding), input_name='publisher'), namespace_, eol_))
        if self.publisherLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublisherLocation>%s</%spublisherLocation>%s' % (namespace_, self.gds_format_string(quote_xml(self.publisherLocation).encode(ExternalEncoding), input_name='publisherLocation'), namespace_, eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolume>%s</%svolume>%s' % (namespace_, self.gds_format_string(quote_xml(self.volume).encode(ExternalEncoding), input_name='volume'), namespace_, eol_))
        if self.firstPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirstPage>%s</%sfirstPage>%s' % (namespace_, self.gds_format_string(quote_xml(self.firstPage).encode(ExternalEncoding), input_name='firstPage'), namespace_, eol_))
        if self.lastPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastPage>%s</%slastPage>%s' % (namespace_, self.gds_format_string(quote_xml(self.lastPage).encode(ExternalEncoding), input_name='lastPage'), namespace_, eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%syear>%s</%syear>%s' % (namespace_, self.gds_format_string(quote_xml(self.year).encode(ExternalEncoding), input_name='year'), namespace_, eol_))
        for externalReference_ in self.externalReference:
            externalReference_.export(outfile, level, namespace_, name_='externalReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authors':
            authors_ = child_.text
            authors_ = self.gds_validate_string(authors_, node, 'authors')
            self.authors = authors_
        elif nodeName_ == 'chapterTitle':
            chapterTitle_ = child_.text
            chapterTitle_ = self.gds_validate_string(chapterTitle_, node, 'chapterTitle')
            self.chapterTitle = chapterTitle_
        elif nodeName_ == 'book':
            book_ = child_.text
            book_ = self.gds_validate_string(book_, node, 'book')
            self.book = book_
        elif nodeName_ == 'thesisTitle':
            thesisTitle_ = child_.text
            thesisTitle_ = self.gds_validate_string(thesisTitle_, node, 'thesisTitle')
            self.thesisTitle = thesisTitle_
        elif nodeName_ == 'editor':
            editor_ = child_.text
            editor_ = self.gds_validate_string(editor_, node, 'editor')
            self.editor = editor_
        elif nodeName_ == 'publisher':
            publisher_ = child_.text
            publisher_ = self.gds_validate_string(publisher_, node, 'publisher')
            self.publisher = publisher_
        elif nodeName_ == 'publisherLocation':
            publisherLocation_ = child_.text
            publisherLocation_ = self.gds_validate_string(publisherLocation_, node, 'publisherLocation')
            self.publisherLocation = publisherLocation_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'firstPage':
            firstPage_ = child_.text
            firstPage_ = self.gds_validate_string(firstPage_, node, 'firstPage')
            self.firstPage = firstPage_
        elif nodeName_ == 'lastPage':
            lastPage_ = child_.text
            lastPage_ = self.gds_validate_string(lastPage_, node, 'lastPage')
            self.lastPage = lastPage_
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
        elif nodeName_ == 'externalReference':
            obj_ = externalRefType.factory()
            obj_.build(child_)
            self.externalReference.append(obj_)
            obj_.original_tagname_ = 'externalReference'
# end class nonJrnlArtType


class externalRefType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if externalRefType.subclass:
            return externalRefType.subclass(*args_, **kwargs_)
        else:
            return externalRefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalRefType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalRefType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalRefType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalRefType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='externalRefType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class externalRefType


class contactType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('firstName', 'xs:string', 0),
        MemberSpec_('middleName', 'xs:string', 0),
        MemberSpec_('familyName', 'xs:string', 0),
        MemberSpec_('email', 'xs:string', 0),
        MemberSpec_('phone', 'xs:string', 0),
        MemberSpec_('fax', 'xs:string', 0),
        MemberSpec_('address', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, firstName=None, middleName=None, familyName=None, email=None, phone=None, fax=None, address=None):
        self.original_tagname_ = None
        self.firstName = firstName
        self.middleName = middleName
        self.familyName = familyName
        self.email = email
        self.phone = phone
        self.fax = fax
        self.address = address
    def factory(*args_, **kwargs_):
        if contactType.subclass:
            return contactType.subclass(*args_, **kwargs_)
        else:
            return contactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_firstName(self): return self.firstName
    def set_firstName(self, firstName): self.firstName = firstName
    def get_middleName(self): return self.middleName
    def set_middleName(self, middleName): self.middleName = middleName
    def get_familyName(self): return self.familyName
    def set_familyName(self, familyName): self.familyName = familyName
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_phone(self): return self.phone
    def set_phone(self, phone): self.phone = phone
    def get_fax(self): return self.fax
    def set_fax(self, fax): self.fax = fax
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def hasContent_(self):
        if (
            self.firstName is not None or
            self.middleName is not None or
            self.familyName is not None or
            self.email is not None or
            self.phone is not None or
            self.fax is not None or
            self.address is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contactType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contactType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contactType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contactType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='contactType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.firstName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirstName>%s</%sfirstName>%s' % (namespace_, self.gds_format_string(quote_xml(self.firstName).encode(ExternalEncoding), input_name='firstName'), namespace_, eol_))
        if self.middleName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smiddleName>%s</%smiddleName>%s' % (namespace_, self.gds_format_string(quote_xml(self.middleName).encode(ExternalEncoding), input_name='middleName'), namespace_, eol_))
        if self.familyName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfamilyName>%s</%sfamilyName>%s' % (namespace_, self.gds_format_string(quote_xml(self.familyName).encode(ExternalEncoding), input_name='familyName'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.phone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphone>%s</%sphone>%s' % (namespace_, self.gds_format_string(quote_xml(self.phone).encode(ExternalEncoding), input_name='phone'), namespace_, eol_))
        if self.fax is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfax>%s</%sfax>%s' % (namespace_, self.gds_format_string(quote_xml(self.fax).encode(ExternalEncoding), input_name='fax'), namespace_, eol_))
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'firstName':
            firstName_ = child_.text
            firstName_ = self.gds_validate_string(firstName_, node, 'firstName')
            self.firstName = firstName_
        elif nodeName_ == 'middleName':
            middleName_ = child_.text
            middleName_ = self.gds_validate_string(middleName_, node, 'middleName')
            self.middleName = middleName_
        elif nodeName_ == 'familyName':
            familyName_ = child_.text
            familyName_ = self.gds_validate_string(familyName_, node, 'familyName')
            self.familyName = familyName_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'phone':
            phone_ = child_.text
            phone_ = self.gds_validate_string(phone_, node, 'phone')
            self.phone = phone_
        elif nodeName_ == 'fax':
            fax_ = child_.text
            fax_ = self.gds_validate_string(fax_, node, 'fax')
            self.fax = fax_
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
# end class contactType


class smplPrepType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('specimenState', ['specimenType', 'xs:string'], 0),
        MemberSpec_('specimenConc', 'samplConcType', 0),
        MemberSpec_('buffer', 'bufferType', 0),
        MemberSpec_('staining', 'xs:string', 0),
        MemberSpec_('specimenSupportDetails', 'xs:string', 0),
        MemberSpec_('twoDCrystalParameters', 'twoDxtalParamType', 0),
        MemberSpec_('threeDCrystalParameters', 'threeDxtalParamType', 0),
        MemberSpec_('helicalParameters', 'helixParamType', 0),
        MemberSpec_('crystalGrowDetails', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, specimenState=None, specimenConc=None, buffer=None, staining=None, specimenSupportDetails=None, twoDCrystalParameters=None, threeDCrystalParameters=None, helicalParameters=None, crystalGrowDetails=None):
        self.original_tagname_ = None
        self.specimenState = specimenState
        self.validate_specimenType(self.specimenState)
        self.specimenConc = specimenConc
        self.buffer = buffer
        self.staining = staining
        self.specimenSupportDetails = specimenSupportDetails
        self.twoDCrystalParameters = twoDCrystalParameters
        self.threeDCrystalParameters = threeDCrystalParameters
        self.helicalParameters = helicalParameters
        self.crystalGrowDetails = crystalGrowDetails
    def factory(*args_, **kwargs_):
        if smplPrepType.subclass:
            return smplPrepType.subclass(*args_, **kwargs_)
        else:
            return smplPrepType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_specimenState(self): return self.specimenState
    def set_specimenState(self, specimenState): self.specimenState = specimenState
    def get_specimenConc(self): return self.specimenConc
    def set_specimenConc(self, specimenConc): self.specimenConc = specimenConc
    def get_buffer(self): return self.buffer
    def set_buffer(self, buffer): self.buffer = buffer
    def get_staining(self): return self.staining
    def set_staining(self, staining): self.staining = staining
    def get_specimenSupportDetails(self): return self.specimenSupportDetails
    def set_specimenSupportDetails(self, specimenSupportDetails): self.specimenSupportDetails = specimenSupportDetails
    def get_twoDCrystalParameters(self): return self.twoDCrystalParameters
    def set_twoDCrystalParameters(self, twoDCrystalParameters): self.twoDCrystalParameters = twoDCrystalParameters
    def get_threeDCrystalParameters(self): return self.threeDCrystalParameters
    def set_threeDCrystalParameters(self, threeDCrystalParameters): self.threeDCrystalParameters = threeDCrystalParameters
    def get_helicalParameters(self): return self.helicalParameters
    def set_helicalParameters(self, helicalParameters): self.helicalParameters = helicalParameters
    def get_crystalGrowDetails(self): return self.crystalGrowDetails
    def set_crystalGrowDetails(self, crystalGrowDetails): self.crystalGrowDetails = crystalGrowDetails
    def validate_specimenType(self, value):
        # Validate type specimenType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['particle', 'filament', 'twoDArray', 'threeDArray', 'helicalArray', 'tissue', 'cell']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on specimenType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.specimenState is not None or
            self.specimenConc is not None or
            self.buffer is not None or
            self.staining is not None or
            self.specimenSupportDetails is not None or
            self.twoDCrystalParameters is not None or
            self.threeDCrystalParameters is not None or
            self.helicalParameters is not None or
            self.crystalGrowDetails is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='smplPrepType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='smplPrepType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='smplPrepType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='smplPrepType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='smplPrepType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.specimenState is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspecimenState>%s</%sspecimenState>%s' % (namespace_, self.gds_format_string(quote_xml(self.specimenState).encode(ExternalEncoding), input_name='specimenState'), namespace_, eol_))
        if self.specimenConc is not None:
            self.specimenConc.export(outfile, level, namespace_, name_='specimenConc', pretty_print=pretty_print)
        if self.buffer is not None:
            self.buffer.export(outfile, level, namespace_, name_='buffer', pretty_print=pretty_print)
        if self.staining is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstaining>%s</%sstaining>%s' % (namespace_, self.gds_format_string(quote_xml(self.staining).encode(ExternalEncoding), input_name='staining'), namespace_, eol_))
        if self.specimenSupportDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspecimenSupportDetails>%s</%sspecimenSupportDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.specimenSupportDetails).encode(ExternalEncoding), input_name='specimenSupportDetails'), namespace_, eol_))
        if self.twoDCrystalParameters is not None:
            self.twoDCrystalParameters.export(outfile, level, namespace_, name_='twoDCrystalParameters', pretty_print=pretty_print)
        if self.threeDCrystalParameters is not None:
            self.threeDCrystalParameters.export(outfile, level, namespace_, name_='threeDCrystalParameters', pretty_print=pretty_print)
        if self.helicalParameters is not None:
            self.helicalParameters.export(outfile, level, namespace_, name_='helicalParameters', pretty_print=pretty_print)
        if self.crystalGrowDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scrystalGrowDetails>%s</%scrystalGrowDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.crystalGrowDetails).encode(ExternalEncoding), input_name='crystalGrowDetails'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'specimenState':
            specimenState_ = child_.text
            specimenState_ = self.gds_validate_string(specimenState_, node, 'specimenState')
            self.specimenState = specimenState_
            # validate type specimenType
            self.validate_specimenType(self.specimenState)
        elif nodeName_ == 'specimenConc':
            obj_ = samplConcType.factory()
            obj_.build(child_)
            self.specimenConc = obj_
            obj_.original_tagname_ = 'specimenConc'
        elif nodeName_ == 'buffer':
            obj_ = bufferType.factory()
            obj_.build(child_)
            self.buffer = obj_
            obj_.original_tagname_ = 'buffer'
        elif nodeName_ == 'staining':
            staining_ = child_.text
            staining_ = self.gds_validate_string(staining_, node, 'staining')
            self.staining = staining_
        elif nodeName_ == 'specimenSupportDetails':
            specimenSupportDetails_ = child_.text
            specimenSupportDetails_ = self.gds_validate_string(specimenSupportDetails_, node, 'specimenSupportDetails')
            self.specimenSupportDetails = specimenSupportDetails_
        elif nodeName_ == 'twoDCrystalParameters':
            obj_ = twoDxtalParamType.factory()
            obj_.build(child_)
            self.twoDCrystalParameters = obj_
            obj_.original_tagname_ = 'twoDCrystalParameters'
        elif nodeName_ == 'threeDCrystalParameters':
            obj_ = threeDxtalParamType.factory()
            obj_.build(child_)
            self.threeDCrystalParameters = obj_
            obj_.original_tagname_ = 'threeDCrystalParameters'
        elif nodeName_ == 'helicalParameters':
            obj_ = helixParamType.factory()
            obj_.build(child_)
            self.helicalParameters = obj_
            obj_.original_tagname_ = 'helicalParameters'
        elif nodeName_ == 'crystalGrowDetails':
            crystalGrowDetails_ = child_.text
            crystalGrowDetails_ = self.gds_validate_string(crystalGrowDetails_, node, 'crystalGrowDetails')
            self.crystalGrowDetails = crystalGrowDetails_
# end class smplPrepType


class vitrifType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('cryogenName', ['cryogenType', 'xs:string'], 0),
        MemberSpec_('humidity', 'xs:string', 0),
        MemberSpec_('temperature', 'tempType', 0),
        MemberSpec_('instrument', ['vitrInstrType', 'xs:string'], 0),
        MemberSpec_('method', 'xs:string', 0),
        MemberSpec_('timeResolvedState', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, cryogenName=None, humidity=None, temperature=None, instrument=None, method=None, timeResolvedState=None, details=None):
        self.original_tagname_ = None
        self.cryogenName = cryogenName
        self.validate_cryogenType(self.cryogenName)
        self.humidity = humidity
        self.temperature = temperature
        self.instrument = instrument
        self.validate_vitrInstrType(self.instrument)
        self.method = method
        self.timeResolvedState = timeResolvedState
        self.details = details
    def factory(*args_, **kwargs_):
        if vitrifType.subclass:
            return vitrifType.subclass(*args_, **kwargs_)
        else:
            return vitrifType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cryogenName(self): return self.cryogenName
    def set_cryogenName(self, cryogenName): self.cryogenName = cryogenName
    def get_humidity(self): return self.humidity
    def set_humidity(self, humidity): self.humidity = humidity
    def get_temperature(self): return self.temperature
    def set_temperature(self, temperature): self.temperature = temperature
    def get_instrument(self): return self.instrument
    def set_instrument(self, instrument): self.instrument = instrument
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def get_timeResolvedState(self): return self.timeResolvedState
    def set_timeResolvedState(self, timeResolvedState): self.timeResolvedState = timeResolvedState
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_cryogenType(self, value):
        # Validate type cryogenType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ETHANE', 'ETHANE-PROPANE MIXTURE', 'METHANE', 'NITROGEN', 'HELIUM', 'PROPANE', 'FREON 12', 'FREON 22', 'NONE', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on cryogenType' % {"value" : value.encode("utf-8")} )
    def validate_vitrInstrType(self, value):
        # Validate type vitrInstrType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['BAL-TEC HPM 010', 'EMS-002 RAPID IMMERSION FREEZER', 'FEI VITROBOT', 'FEI VITROBOT MARK I', 'FEI VITROBOT MARK II', 'FEI VITROBOT MARK III', 'FEI VITROBOT MARK IV', 'GATAN CRYOPLUNGE 3', 'HOMEMADE PLUNGER', 'LEICA PLUNGER', 'LEICA EM GP', 'LEICA EM CPC', 'LEICA EM HPM100', 'LEICA EM PACT', 'LEICA EM PACT2', 'LEICA KF80', 'NONE', 'REICHERT-JUNG PLUNGER', 'ZEISS PLUNGE FREEZER CRYOBOX', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on vitrInstrType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.cryogenName is not None or
            self.humidity is not None or
            self.temperature is not None or
            self.instrument is not None or
            self.method is not None or
            self.timeResolvedState is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vitrifType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vitrifType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vitrifType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vitrifType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='vitrifType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cryogenName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scryogenName>%s</%scryogenName>%s' % (namespace_, self.gds_format_string(quote_xml(self.cryogenName).encode(ExternalEncoding), input_name='cryogenName'), namespace_, eol_))
        if self.humidity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shumidity>%s</%shumidity>%s' % (namespace_, self.gds_format_string(quote_xml(self.humidity).encode(ExternalEncoding), input_name='humidity'), namespace_, eol_))
        if self.temperature is not None:
            self.temperature.export(outfile, level, namespace_, name_='temperature', pretty_print=pretty_print)
        if self.instrument is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstrument>%s</%sinstrument>%s' % (namespace_, self.gds_format_string(quote_xml(self.instrument).encode(ExternalEncoding), input_name='instrument'), namespace_, eol_))
        if self.method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethod>%s</%smethod>%s' % (namespace_, self.gds_format_string(quote_xml(self.method).encode(ExternalEncoding), input_name='method'), namespace_, eol_))
        if self.timeResolvedState is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimeResolvedState>%s</%stimeResolvedState>%s' % (namespace_, self.gds_format_string(quote_xml(self.timeResolvedState).encode(ExternalEncoding), input_name='timeResolvedState'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cryogenName':
            cryogenName_ = child_.text
            cryogenName_ = self.gds_validate_string(cryogenName_, node, 'cryogenName')
            self.cryogenName = cryogenName_
            # validate type cryogenType
            self.validate_cryogenType(self.cryogenName)
        elif nodeName_ == 'humidity':
            humidity_ = child_.text
            humidity_ = self.gds_validate_string(humidity_, node, 'humidity')
            self.humidity = humidity_
        elif nodeName_ == 'temperature':
            obj_ = tempType.factory()
            obj_.build(child_)
            self.temperature = obj_
            obj_.original_tagname_ = 'temperature'
        elif nodeName_ == 'instrument':
            instrument_ = child_.text
            instrument_ = self.gds_validate_string(instrument_, node, 'instrument')
            self.instrument = instrument_
            # validate type vitrInstrType
            self.validate_vitrInstrType(self.instrument)
        elif nodeName_ == 'method':
            method_ = child_.text
            method_ = self.gds_validate_string(method_, node, 'method')
            self.method = method_
        elif nodeName_ == 'timeResolvedState':
            timeResolvedState_ = child_.text
            timeResolvedState_ = self.gds_validate_string(timeResolvedState_, node, 'timeResolvedState')
            self.timeResolvedState = timeResolvedState_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
    def gds_format_float(self,input_data, input_name="" ):
        return ("%g" % input_data)
# end class vitrifType


class imgType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('astigmatism', 'xs:string', 0),
        MemberSpec_('electronSource', ['eSourceType', 'xs:string'], 0),
        MemberSpec_('electronDose', 'eDoseType', 0),
        MemberSpec_('energyFilter', 'xs:string', 0),
        MemberSpec_('imagingMode', ['imgModeType', 'xs:string'], 0),
        MemberSpec_('nominalDefocusMin', 'defocusType', 0),
        MemberSpec_('nominalDefocusMax', 'defocusType', 0),
        MemberSpec_('illuminationMode', ['illumType', 'xs:string'], 0),
        MemberSpec_('specimenHolder', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('detector', ['detectorType', 'xs:string'], 0),
        MemberSpec_('nominalCs', 'csType', 0),
        MemberSpec_('tiltAngleMin', 'tiltType', 0),
        MemberSpec_('calibratedMagnification', 'xs:float', 0),
        MemberSpec_('tiltAngleMax', 'tiltType', 0),
        MemberSpec_('temperature', 'tempType', 0),
        MemberSpec_('temperatureMin', 'tempType', 0),
        MemberSpec_('temperatureMax', 'tempType', 0),
        MemberSpec_('microscope', ['microscopeType', 'xs:string'], 0),
        MemberSpec_('date', 'xs:string', 0),
        MemberSpec_('specimenHolderModel', ['specimenHolderType', 'xs:string'], 0),
        MemberSpec_('acceleratingVoltage', 'accVoltType', 0),
        MemberSpec_('nominalMagnification', 'xs:float', 0),
        MemberSpec_('energyWindow', 'eWindowType', 0),
        MemberSpec_('detectorDistance', 'xs:string', 0),
        MemberSpec_('electronBeamTiltParams', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, astigmatism=None, electronSource=None, electronDose=None, energyFilter=None, imagingMode=None, nominalDefocusMin=None, nominalDefocusMax=None, illuminationMode=None, specimenHolder=None, details=None, detector=None, nominalCs=None, tiltAngleMin=None, calibratedMagnification=None, tiltAngleMax=None, temperature=None, temperatureMin=None, temperatureMax=None, microscope=None, date=None, specimenHolderModel=None, acceleratingVoltage=None, nominalMagnification=None, energyWindow=None, detectorDistance=None, electronBeamTiltParams=None):
        self.original_tagname_ = None
        self.astigmatism = astigmatism
        self.electronSource = electronSource
        self.validate_eSourceType(self.electronSource)
        self.electronDose = electronDose
        self.energyFilter = energyFilter
        self.imagingMode = imagingMode
        self.validate_imgModeType(self.imagingMode)
        self.nominalDefocusMin = nominalDefocusMin
        self.nominalDefocusMax = nominalDefocusMax
        self.illuminationMode = illuminationMode
        self.validate_illumType(self.illuminationMode)
        self.specimenHolder = specimenHolder
        self.details = details
        self.detector = detector
        self.validate_detectorType(self.detector)
        self.nominalCs = nominalCs
        self.tiltAngleMin = tiltAngleMin
        self.calibratedMagnification = calibratedMagnification
        self.tiltAngleMax = tiltAngleMax
        self.temperature = temperature
        self.temperatureMin = temperatureMin
        self.temperatureMax = temperatureMax
        self.microscope = microscope
        self.validate_microscopeType(self.microscope)
        self.date = date
        self.specimenHolderModel = specimenHolderModel
        self.validate_specimenHolderType(self.specimenHolderModel)
        self.acceleratingVoltage = acceleratingVoltage
        self.nominalMagnification = nominalMagnification
        self.energyWindow = energyWindow
        self.detectorDistance = detectorDistance
        self.electronBeamTiltParams = electronBeamTiltParams
    def factory(*args_, **kwargs_):
        if imgType.subclass:
            return imgType.subclass(*args_, **kwargs_)
        else:
            return imgType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_astigmatism(self): return self.astigmatism
    def set_astigmatism(self, astigmatism): self.astigmatism = astigmatism
    def get_electronSource(self): return self.electronSource
    def set_electronSource(self, electronSource): self.electronSource = electronSource
    def get_electronDose(self): return self.electronDose
    def set_electronDose(self, electronDose): self.electronDose = electronDose
    def get_energyFilter(self): return self.energyFilter
    def set_energyFilter(self, energyFilter): self.energyFilter = energyFilter
    def get_imagingMode(self): return self.imagingMode
    def set_imagingMode(self, imagingMode): self.imagingMode = imagingMode
    def get_nominalDefocusMin(self): return self.nominalDefocusMin
    def set_nominalDefocusMin(self, nominalDefocusMin): self.nominalDefocusMin = nominalDefocusMin
    def get_nominalDefocusMax(self): return self.nominalDefocusMax
    def set_nominalDefocusMax(self, nominalDefocusMax): self.nominalDefocusMax = nominalDefocusMax
    def get_illuminationMode(self): return self.illuminationMode
    def set_illuminationMode(self, illuminationMode): self.illuminationMode = illuminationMode
    def get_specimenHolder(self): return self.specimenHolder
    def set_specimenHolder(self, specimenHolder): self.specimenHolder = specimenHolder
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_detector(self): return self.detector
    def set_detector(self, detector): self.detector = detector
    def get_nominalCs(self): return self.nominalCs
    def set_nominalCs(self, nominalCs): self.nominalCs = nominalCs
    def get_tiltAngleMin(self): return self.tiltAngleMin
    def set_tiltAngleMin(self, tiltAngleMin): self.tiltAngleMin = tiltAngleMin
    def get_calibratedMagnification(self): return self.calibratedMagnification
    def set_calibratedMagnification(self, calibratedMagnification): self.calibratedMagnification = calibratedMagnification
    def get_tiltAngleMax(self): return self.tiltAngleMax
    def set_tiltAngleMax(self, tiltAngleMax): self.tiltAngleMax = tiltAngleMax
    def get_temperature(self): return self.temperature
    def set_temperature(self, temperature): self.temperature = temperature
    def get_temperatureMin(self): return self.temperatureMin
    def set_temperatureMin(self, temperatureMin): self.temperatureMin = temperatureMin
    def get_temperatureMax(self): return self.temperatureMax
    def set_temperatureMax(self, temperatureMax): self.temperatureMax = temperatureMax
    def get_microscope(self): return self.microscope
    def set_microscope(self, microscope): self.microscope = microscope
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_specimenHolderModel(self): return self.specimenHolderModel
    def set_specimenHolderModel(self, specimenHolderModel): self.specimenHolderModel = specimenHolderModel
    def get_acceleratingVoltage(self): return self.acceleratingVoltage
    def set_acceleratingVoltage(self, acceleratingVoltage): self.acceleratingVoltage = acceleratingVoltage
    def get_nominalMagnification(self): return self.nominalMagnification
    def set_nominalMagnification(self, nominalMagnification): self.nominalMagnification = nominalMagnification
    def get_energyWindow(self): return self.energyWindow
    def set_energyWindow(self, energyWindow): self.energyWindow = energyWindow
    def get_detectorDistance(self): return self.detectorDistance
    def set_detectorDistance(self, detectorDistance): self.detectorDistance = detectorDistance
    def get_electronBeamTiltParams(self): return self.electronBeamTiltParams
    def set_electronBeamTiltParams(self, electronBeamTiltParams): self.electronBeamTiltParams = electronBeamTiltParams
    def validate_eSourceType(self, value):
        # Validate type eSourceType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['TUNGSTEN HAIRPIN', 'LAB6', 'FIELD EMISSION GUN', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on eSourceType' % {"value" : value.encode("utf-8")} )
    def validate_imgModeType(self, value):
        # Validate type imgModeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['BRIGHT FIELD', 'DARK FIELD', 'DIFFRACTION', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on imgModeType' % {"value" : value.encode("utf-8")} )
    def validate_illumType(self, value):
        # Validate type illumType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['FLOOD BEAM', 'SPOT SCAN', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on illumType' % {"value" : value.encode("utf-8")} )
    def validate_detectorType(self, value):
        # Validate type detectorType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['AGFA SCIENTA FILM', 'KODAK 4489 FILM', 'KODAK SO-163 FILM', 'GENERIC FILM', 'GENERIC IMAGE PLATES', 'DIRECT ELECTRON DE-10 (5k x 4k)', 'DIRECT ELECTRON DE-12 (4k x 3k)', 'FEI CETA (4k x 4k)', 'FEI EAGLE (2k x 2k)', 'FEI EAGLE (4k x 4k)', 'FEI FALCON I (4k x 4k)', 'FEI FALCON II (4k x 4k)', 'GATAN MULTISCAN', 'GATAN ORIUS SC200 (2k x 2k)', 'GATAN ORIUS SC600 (2.7k x 2.7k)', 'GATAN ORIUS SC1000 (4k x 2.7k)', 'GATAN ULTRASCAN 1000 (2k x 2k)', 'GATAN ULTRASCAN 4000 (4k x 4k)', 'GATAN ULTRASCAN 10000 (10k x 10k)', 'GATAN K2 (4k x 4k)', 'GENERIC GATAN (2k x 2k)', 'GENERIC GATAN (4k x 4k)', 'GENERIC GATAN', 'PROSCAN TEM-PIV (2k x 2k)', 'SIA 15C (3k x 3k)', 'TVIPS TEMCAM-F816 (8k x 8k)', 'TVIPS TEMCAM-F415 (4k x 4k)', 'TVIPS TEMCAM-F416 (4k x 4k)', 'TVIPS TEMCAM-F216 (2k x 2k)', 'TVIPS TEMCAM-F224 (2k x 2k)', 'GENERIC TVIPS (2k x 2k)', 'GENERIC TVIPS (4k x 4k)', 'GENERIC TVIPS', 'GENERIC CCD (2k x 2k)', 'GENERIC CCD (4k x 4k)', 'GENERIC CCD', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on detectorType' % {"value" : value.encode("utf-8")} )
    def validate_microscopeType(self, value):
        # Validate type microscopeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['FEI MORGAGNI', 'FEI POLARA 300', 'FEI TECNAI 10', 'FEI TECNAI 12', 'FEI TECNAI 20', 'FEI TECNAI F20', 'FEI TECNAI F30', 'FEI TECNAI SPHERA', 'FEI TECNAI SPIRIT', 'FEI TITAN', 'FEI TITAN KRIOS', 'FEI/PHILIPS CM12', 'FEI/PHILIPS CM120T', 'FEI/PHILIPS CM200FEG', 'FEI/PHILIPS CM200FEG/SOPHIE', 'FEI/PHILIPS CM200FEG/ST', 'FEI/PHILIPS CM200FEG/UT', 'FEI/PHILIPS CM200T', 'FEI/PHILIPS CM300FEG/HE', 'FEI/PHILIPS CM300FEG/ST', 'FEI/PHILIPS CM300FEG/T', 'FEI/PHILIPS EM400', 'FEI/PHILIPS EM420', 'HITACHI EF2000', 'HITACHI H7600', 'HITACHI HF2000', 'HITACHI HF3000', 'HITACHI H-9500SD', 'JEOL 100CX', 'JEOL 1010', 'JEOL 1200', 'JEOL 1200EX', 'JEOL 1200EXII', 'JEOL 1230', 'JEOL 1400', 'JEOL 2000EX', 'JEOL 2000EXII', 'JEOL 2010', 'JEOL 2010F', 'JEOL 2010HT', 'JEOL 2010HC', 'JEOL 2010UHR', 'JEOL 2011', 'JEOL 2100', 'JEOL 2100F', 'JEOL 2200FS', 'JEOL 2200FSC', 'JEOL 3000SFF', 'JEOL 3100FFC', 'JEOL 3200FS', 'JEOL 3200FSC', 'JEOL KYOTO-3000SFF', 'JEOL 3200FSC', 'JEOL 4000', 'JEOL 4000EX', 'ZEISS LEO912', 'ZEISS LIBRA120PLUS', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on microscopeType' % {"value" : value.encode("utf-8")} )
    def validate_specimenHolderType(self, value):
        # Validate type specimenHolderType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['FEI TITAN KRIOS AUTOGRID HOLDER', 'GATAN HELIUM', 'GATAN LIQUID NITROGEN', 'HOME BUILD', 'JEOL', 'JEOL 3200FSC CRYOHOLDER', 'PHILIPS ROTATION HOLDER', 'SIDE ENTRY, EUCENTRIC', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on specimenHolderType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.astigmatism is not None or
            self.electronSource is not None or
            self.electronDose is not None or
            self.energyFilter is not None or
            self.imagingMode is not None or
            self.nominalDefocusMin is not None or
            self.nominalDefocusMax is not None or
            self.illuminationMode is not None or
            self.specimenHolder is not None or
            self.details is not None or
            self.detector is not None or
            self.nominalCs is not None or
            self.tiltAngleMin is not None or
            self.calibratedMagnification is not None or
            self.tiltAngleMax is not None or
            self.temperature is not None or
            self.temperatureMin is not None or
            self.temperatureMax is not None or
            self.microscope is not None or
            self.date is not None or
            self.specimenHolderModel is not None or
            self.acceleratingVoltage is not None or
            self.nominalMagnification is not None or
            self.energyWindow is not None or
            self.detectorDistance is not None or
            self.electronBeamTiltParams is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='imgType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='imgType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='imgType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='imgType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='imgType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.astigmatism is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sastigmatism>%s</%sastigmatism>%s' % (namespace_, self.gds_format_string(quote_xml(self.astigmatism).encode(ExternalEncoding), input_name='astigmatism'), namespace_, eol_))
        if self.electronSource is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%selectronSource>%s</%selectronSource>%s' % (namespace_, self.gds_format_string(quote_xml(self.electronSource).encode(ExternalEncoding), input_name='electronSource'), namespace_, eol_))
        if self.electronDose is not None:
            self.electronDose.export(outfile, level, namespace_, name_='electronDose', pretty_print=pretty_print)
        if self.energyFilter is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senergyFilter>%s</%senergyFilter>%s' % (namespace_, self.gds_format_string(quote_xml(self.energyFilter).encode(ExternalEncoding), input_name='energyFilter'), namespace_, eol_))
        if self.imagingMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simagingMode>%s</%simagingMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.imagingMode).encode(ExternalEncoding), input_name='imagingMode'), namespace_, eol_))
        if self.nominalDefocusMin is not None:
            self.nominalDefocusMin.export(outfile, level, namespace_, name_='nominalDefocusMin', pretty_print=pretty_print)
        if self.nominalDefocusMax is not None:
            self.nominalDefocusMax.export(outfile, level, namespace_, name_='nominalDefocusMax', pretty_print=pretty_print)
        if self.illuminationMode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%silluminationMode>%s</%silluminationMode>%s' % (namespace_, self.gds_format_string(quote_xml(self.illuminationMode).encode(ExternalEncoding), input_name='illuminationMode'), namespace_, eol_))
        if self.specimenHolder is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspecimenHolder>%s</%sspecimenHolder>%s' % (namespace_, self.gds_format_string(quote_xml(self.specimenHolder).encode(ExternalEncoding), input_name='specimenHolder'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.detector is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetector>%s</%sdetector>%s' % (namespace_, self.gds_format_string(quote_xml(self.detector).encode(ExternalEncoding), input_name='detector'), namespace_, eol_))
        if self.nominalCs is not None:
            self.nominalCs.export(outfile, level, namespace_, name_='nominalCs', pretty_print=pretty_print)
        if self.tiltAngleMin is not None:
            self.tiltAngleMin.export(outfile, level, namespace_, name_='tiltAngleMin', pretty_print=pretty_print)
        if self.calibratedMagnification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scalibratedMagnification>%s</%scalibratedMagnification>%s' % (namespace_, self.gds_format_float(self.calibratedMagnification, input_name='calibratedMagnification'), namespace_, eol_))
        if self.tiltAngleMax is not None:
            self.tiltAngleMax.export(outfile, level, namespace_, name_='tiltAngleMax', pretty_print=pretty_print)
        if self.temperature is not None:
            self.temperature.export(outfile, level, namespace_, name_='temperature', pretty_print=pretty_print)
        if self.temperatureMin is not None:
            self.temperatureMin.export(outfile, level, namespace_, name_='temperatureMin', pretty_print=pretty_print)
        if self.temperatureMax is not None:
            self.temperatureMax.export(outfile, level, namespace_, name_='temperatureMax', pretty_print=pretty_print)
        if self.microscope is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smicroscope>%s</%smicroscope>%s' % (namespace_, self.gds_format_string(quote_xml(self.microscope).encode(ExternalEncoding), input_name='microscope'), namespace_, eol_))
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespace_, self.gds_format_string(quote_xml(self.date).encode(ExternalEncoding), input_name='date'), namespace_, eol_))
        if self.specimenHolderModel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspecimenHolderModel>%s</%sspecimenHolderModel>%s' % (namespace_, self.gds_format_string(quote_xml(self.specimenHolderModel).encode(ExternalEncoding), input_name='specimenHolderModel'), namespace_, eol_))
        if self.acceleratingVoltage is not None:
            self.acceleratingVoltage.export(outfile, level, namespace_, name_='acceleratingVoltage', pretty_print=pretty_print)
        if self.nominalMagnification is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snominalMagnification>%s</%snominalMagnification>%s' % (namespace_, self.gds_format_float(self.nominalMagnification, input_name='nominalMagnification'), namespace_, eol_))
        if self.energyWindow is not None:
            self.energyWindow.export(outfile, level, namespace_, name_='energyWindow', pretty_print=pretty_print)
        if self.detectorDistance is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetectorDistance>%s</%sdetectorDistance>%s' % (namespace_, self.gds_format_string(quote_xml(self.detectorDistance).encode(ExternalEncoding), input_name='detectorDistance'), namespace_, eol_))
        if self.electronBeamTiltParams is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%selectronBeamTiltParams>%s</%selectronBeamTiltParams>%s' % (namespace_, self.gds_format_string(quote_xml(self.electronBeamTiltParams).encode(ExternalEncoding), input_name='electronBeamTiltParams'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'astigmatism':
            astigmatism_ = child_.text
            astigmatism_ = self.gds_validate_string(astigmatism_, node, 'astigmatism')
            self.astigmatism = astigmatism_
        elif nodeName_ == 'electronSource':
            electronSource_ = child_.text
            electronSource_ = self.gds_validate_string(electronSource_, node, 'electronSource')
            self.electronSource = electronSource_
            # validate type eSourceType
            self.validate_eSourceType(self.electronSource)
        elif nodeName_ == 'electronDose':
            obj_ = eDoseType.factory()
            obj_.build(child_)
            self.electronDose = obj_
            obj_.original_tagname_ = 'electronDose'
        elif nodeName_ == 'energyFilter':
            energyFilter_ = child_.text
            energyFilter_ = self.gds_validate_string(energyFilter_, node, 'energyFilter')
            self.energyFilter = energyFilter_
        elif nodeName_ == 'imagingMode':
            imagingMode_ = child_.text
            imagingMode_ = self.gds_validate_string(imagingMode_, node, 'imagingMode')
            self.imagingMode = imagingMode_
            # validate type imgModeType
            self.validate_imgModeType(self.imagingMode)
        elif nodeName_ == 'nominalDefocusMin':
            obj_ = defocusType.factory()
            obj_.build(child_)
            self.nominalDefocusMin = obj_
            obj_.original_tagname_ = 'nominalDefocusMin'
        elif nodeName_ == 'nominalDefocusMax':
            obj_ = defocusType.factory()
            obj_.build(child_)
            self.nominalDefocusMax = obj_
            obj_.original_tagname_ = 'nominalDefocusMax'
        elif nodeName_ == 'illuminationMode':
            illuminationMode_ = child_.text
            illuminationMode_ = self.gds_validate_string(illuminationMode_, node, 'illuminationMode')
            self.illuminationMode = illuminationMode_
            # validate type illumType
            self.validate_illumType(self.illuminationMode)
        elif nodeName_ == 'specimenHolder':
            specimenHolder_ = child_.text
            specimenHolder_ = self.gds_validate_string(specimenHolder_, node, 'specimenHolder')
            self.specimenHolder = specimenHolder_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'detector':
            detector_ = child_.text
            detector_ = self.gds_validate_string(detector_, node, 'detector')
            self.detector = detector_
            # validate type detectorType
            self.validate_detectorType(self.detector)
        elif nodeName_ == 'nominalCs':
            obj_ = csType.factory()
            obj_.build(child_)
            self.nominalCs = obj_
            obj_.original_tagname_ = 'nominalCs'
        elif nodeName_ == 'tiltAngleMin':
            obj_ = tiltType.factory()
            obj_.build(child_)
            self.tiltAngleMin = obj_
            obj_.original_tagname_ = 'tiltAngleMin'
        elif nodeName_ == 'calibratedMagnification':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'calibratedMagnification')
            self.calibratedMagnification = fval_
        elif nodeName_ == 'tiltAngleMax':
            obj_ = tiltType.factory()
            obj_.build(child_)
            self.tiltAngleMax = obj_
            obj_.original_tagname_ = 'tiltAngleMax'
        elif nodeName_ == 'temperature':
            obj_ = tempType.factory()
            obj_.build(child_)
            self.temperature = obj_
            obj_.original_tagname_ = 'temperature'
        elif nodeName_ == 'temperatureMin':
            obj_ = tempType.factory()
            obj_.build(child_)
            self.temperatureMin = obj_
            obj_.original_tagname_ = 'temperatureMin'
        elif nodeName_ == 'temperatureMax':
            obj_ = tempType.factory()
            obj_.build(child_)
            self.temperatureMax = obj_
            obj_.original_tagname_ = 'temperatureMax'
        elif nodeName_ == 'microscope':
            microscope_ = child_.text
            microscope_ = self.gds_validate_string(microscope_, node, 'microscope')
            self.microscope = microscope_
            # validate type microscopeType
            self.validate_microscopeType(self.microscope)
        elif nodeName_ == 'date':
            date_ = child_.text
            date_ = self.gds_validate_string(date_, node, 'date')
            self.date = date_
        elif nodeName_ == 'specimenHolderModel':
            specimenHolderModel_ = child_.text
            specimenHolderModel_ = self.gds_validate_string(specimenHolderModel_, node, 'specimenHolderModel')
            self.specimenHolderModel = specimenHolderModel_
            # validate type specimenHolderType
            self.validate_specimenHolderType(self.specimenHolderModel)
        elif nodeName_ == 'acceleratingVoltage':
            obj_ = accVoltType.factory()
            obj_.build(child_)
            self.acceleratingVoltage = obj_
            obj_.original_tagname_ = 'acceleratingVoltage'
        elif nodeName_ == 'nominalMagnification':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'nominalMagnification')
            self.nominalMagnification = fval_
        elif nodeName_ == 'energyWindow':
            obj_ = eWindowType.factory()
            obj_.build(child_)
            self.energyWindow = obj_
            obj_.original_tagname_ = 'energyWindow'
        elif nodeName_ == 'detectorDistance':
            detectorDistance_ = child_.text
            detectorDistance_ = self.gds_validate_string(detectorDistance_, node, 'detectorDistance')
            self.detectorDistance = detectorDistance_
        elif nodeName_ == 'electronBeamTiltParams':
            electronBeamTiltParams_ = child_.text
            electronBeamTiltParams_ = self.gds_validate_string(electronBeamTiltParams_, node, 'electronBeamTiltParams')
            self.electronBeamTiltParams = electronBeamTiltParams_
    def gds_format_float(self,input_data, input_name="" ):
        return ("%g" % input_data)
# end class imgType


class imgScanType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('numDigitalImages', 'xs:positiveInteger', 0),
        MemberSpec_('scanner', ['scannerType', 'xs:string'], 0),
        MemberSpec_('samplingSize', 'samplSizeType', 0),
        MemberSpec_('odRange', 'xs:float', 0),
        MemberSpec_('URLRawData', 'xs:string', 0),
        MemberSpec_('quantBitNumber', 'xs:positiveInteger', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, numDigitalImages=None, scanner=None, samplingSize=None, odRange=None, URLRawData=None, quantBitNumber=None, details=None):
        self.original_tagname_ = None
        self.numDigitalImages = numDigitalImages
        self.scanner = scanner
        self.validate_scannerType(self.scanner)
        self.samplingSize = samplingSize
        self.odRange = odRange
        self.URLRawData = URLRawData
        self.quantBitNumber = quantBitNumber
        self.details = details
    def factory(*args_, **kwargs_):
        if imgScanType.subclass:
            return imgScanType.subclass(*args_, **kwargs_)
        else:
            return imgScanType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numDigitalImages(self): return self.numDigitalImages
    def set_numDigitalImages(self, numDigitalImages): self.numDigitalImages = numDigitalImages
    def get_scanner(self): return self.scanner
    def set_scanner(self, scanner): self.scanner = scanner
    def get_samplingSize(self): return self.samplingSize
    def set_samplingSize(self, samplingSize): self.samplingSize = samplingSize
    def get_odRange(self): return self.odRange
    def set_odRange(self, odRange): self.odRange = odRange
    def get_URLRawData(self): return self.URLRawData
    def set_URLRawData(self, URLRawData): self.URLRawData = URLRawData
    def get_quantBitNumber(self): return self.quantBitNumber
    def set_quantBitNumber(self, quantBitNumber): self.quantBitNumber = quantBitNumber
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_scannerType(self, value):
        # Validate type scannerType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['n/a', 'CREO EVERSMART SUPREME', 'EIKONIX IEEE 488', 'EMIL 10', 'IMACON', 'NIKON SUPER COOLSCAN 9000', 'NIKON SUPER COOLSCAN 8000', 'NIKON SUPER COOLSCAN 5000', 'NIKON SUPER COOLSCAN 4000', 'NIKON COOLSCAN', 'OPTRONICS', 'PATCHWORK DENSITOMETER', 'PERKIN ELMER', 'PRIMESCAN', 'TEMSCAN', 'ZEISS SCAI', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on scannerType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.numDigitalImages is not None or
            self.scanner is not None or
            self.samplingSize is not None or
            self.odRange is not None or
            self.URLRawData is not None or
            self.quantBitNumber is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='imgScanType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='imgScanType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='imgScanType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='imgScanType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='imgScanType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.numDigitalImages is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumDigitalImages>%s</%snumDigitalImages>%s' % (namespace_, self.gds_format_integer(self.numDigitalImages, input_name='numDigitalImages'), namespace_, eol_))
        if self.scanner is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscanner>%s</%sscanner>%s' % (namespace_, self.gds_format_string(quote_xml(self.scanner).encode(ExternalEncoding), input_name='scanner'), namespace_, eol_))
        if self.samplingSize is not None:
            self.samplingSize.export(outfile, level, namespace_, name_='samplingSize', pretty_print=pretty_print)
        if self.odRange is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sodRange>%s</%sodRange>%s' % (namespace_, self.gds_format_float(self.odRange, input_name='odRange'), namespace_, eol_))
        if self.URLRawData is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sURLRawData>%s</%sURLRawData>%s' % (namespace_, self.gds_format_string(quote_xml(self.URLRawData).encode(ExternalEncoding), input_name='URLRawData'), namespace_, eol_))
        if self.quantBitNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squantBitNumber>%s</%squantBitNumber>%s' % (namespace_, self.gds_format_integer(self.quantBitNumber, input_name='quantBitNumber'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'numDigitalImages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numDigitalImages')
            self.numDigitalImages = ival_
        elif nodeName_ == 'scanner':
            scanner_ = child_.text
            scanner_ = self.gds_validate_string(scanner_, node, 'scanner')
            self.scanner = scanner_
            # validate type scannerType
            self.validate_scannerType(self.scanner)
        elif nodeName_ == 'samplingSize':
            obj_ = samplSizeType.factory()
            obj_.build(child_)
            self.samplingSize = obj_
            obj_.original_tagname_ = 'samplingSize'
        elif nodeName_ == 'odRange':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'odRange')
            self.odRange = fval_
        elif nodeName_ == 'URLRawData':
            URLRawData_ = child_.text
            URLRawData_ = self.gds_validate_string(URLRawData_, node, 'URLRawData')
            self.URLRawData = URLRawData_
        elif nodeName_ == 'quantBitNumber':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'quantBitNumber')
            self.quantBitNumber = ival_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class imgScanType


class reconsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('algorithm', 'xs:string', 0),
        MemberSpec_('software', 'xs:string', 0),
        MemberSpec_('ctfCorrection', 'xs:string', 0),
        MemberSpec_('resolutionByAuthor', 'xs:string', 0),
        MemberSpec_('resolutionMethod', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('eulerAnglesDetails', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, algorithm=None, software=None, ctfCorrection=None, resolutionByAuthor=None, resolutionMethod=None, details=None, eulerAnglesDetails=None):
        self.original_tagname_ = None
        self.algorithm = algorithm
        self.software = software
        self.ctfCorrection = ctfCorrection
        self.resolutionByAuthor = resolutionByAuthor
        self.resolutionMethod = resolutionMethod
        self.details = details
        self.eulerAnglesDetails = eulerAnglesDetails
    def factory(*args_, **kwargs_):
        if reconsType.subclass:
            return reconsType.subclass(*args_, **kwargs_)
        else:
            return reconsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_algorithm(self): return self.algorithm
    def set_algorithm(self, algorithm): self.algorithm = algorithm
    def get_software(self): return self.software
    def set_software(self, software): self.software = software
    def get_ctfCorrection(self): return self.ctfCorrection
    def set_ctfCorrection(self, ctfCorrection): self.ctfCorrection = ctfCorrection
    def get_resolutionByAuthor(self): return self.resolutionByAuthor
    def set_resolutionByAuthor(self, resolutionByAuthor): self.resolutionByAuthor = resolutionByAuthor
    def get_resolutionMethod(self): return self.resolutionMethod
    def set_resolutionMethod(self, resolutionMethod): self.resolutionMethod = resolutionMethod
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_eulerAnglesDetails(self): return self.eulerAnglesDetails
    def set_eulerAnglesDetails(self, eulerAnglesDetails): self.eulerAnglesDetails = eulerAnglesDetails
    def hasContent_(self):
        if (
            self.algorithm is not None or
            self.software is not None or
            self.ctfCorrection is not None or
            self.resolutionByAuthor is not None or
            self.resolutionMethod is not None or
            self.details is not None or
            self.eulerAnglesDetails is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='reconsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='reconsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='reconsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='reconsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='reconsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.algorithm is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salgorithm>%s</%salgorithm>%s' % (namespace_, self.gds_format_string(quote_xml(self.algorithm).encode(ExternalEncoding), input_name='algorithm'), namespace_, eol_))
        if self.software is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssoftware>%s</%ssoftware>%s' % (namespace_, self.gds_format_string(quote_xml(self.software).encode(ExternalEncoding), input_name='software'), namespace_, eol_))
        if self.ctfCorrection is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sctfCorrection>%s</%sctfCorrection>%s' % (namespace_, self.gds_format_string(quote_xml(self.ctfCorrection).encode(ExternalEncoding), input_name='ctfCorrection'), namespace_, eol_))
        if self.resolutionByAuthor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresolutionByAuthor>%s</%sresolutionByAuthor>%s' % (namespace_, self.gds_format_string(quote_xml(self.resolutionByAuthor).encode(ExternalEncoding), input_name='resolutionByAuthor'), namespace_, eol_))
        if self.resolutionMethod is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresolutionMethod>%s</%sresolutionMethod>%s' % (namespace_, self.gds_format_string(quote_xml(self.resolutionMethod).encode(ExternalEncoding), input_name='resolutionMethod'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.eulerAnglesDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%seulerAnglesDetails>%s</%seulerAnglesDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.eulerAnglesDetails).encode(ExternalEncoding), input_name='eulerAnglesDetails'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'algorithm':
            algorithm_ = child_.text
            algorithm_ = self.gds_validate_string(algorithm_, node, 'algorithm')
            self.algorithm = algorithm_
        elif nodeName_ == 'software':
            software_ = child_.text
            software_ = self.gds_validate_string(software_, node, 'software')
            self.software = software_
        elif nodeName_ == 'ctfCorrection':
            ctfCorrection_ = child_.text
            ctfCorrection_ = self.gds_validate_string(ctfCorrection_, node, 'ctfCorrection')
            self.ctfCorrection = ctfCorrection_
        elif nodeName_ == 'resolutionByAuthor':
            resolutionByAuthor_ = child_.text
            resolutionByAuthor_ = self.gds_validate_string(resolutionByAuthor_, node, 'resolutionByAuthor')
            self.resolutionByAuthor = resolutionByAuthor_
        elif nodeName_ == 'resolutionMethod':
            resolutionMethod_ = child_.text
            resolutionMethod_ = self.gds_validate_string(resolutionMethod_, node, 'resolutionMethod')
            self.resolutionMethod = resolutionMethod_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'eulerAnglesDetails':
            eulerAnglesDetails_ = child_.text
            eulerAnglesDetails_ = self.gds_validate_string(eulerAnglesDetails_, node, 'eulerAnglesDetails')
            self.eulerAnglesDetails = eulerAnglesDetails_
# end class reconsType


class twoDxtalParamType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('aLength', 'lengthType', 0),
        MemberSpec_('bLength', 'lengthType', 0),
        MemberSpec_('cLength', 'lengthType', 0),
        MemberSpec_('alpha', 'anglType', 0),
        MemberSpec_('beta', 'anglType', 0),
        MemberSpec_('gamma', 'anglType', 0),
        MemberSpec_('planeGroup', ['plGrpType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, aLength=None, bLength=None, cLength=None, alpha=None, beta=None, gamma=None, planeGroup=None):
        self.original_tagname_ = None
        self.aLength = aLength
        self.bLength = bLength
        self.cLength = cLength
        self.alpha = alpha
        self.beta = beta
        self.gamma = gamma
        self.planeGroup = planeGroup
        self.validate_plGrpType(self.planeGroup)
    def factory(*args_, **kwargs_):
        if twoDxtalParamType.subclass:
            return twoDxtalParamType.subclass(*args_, **kwargs_)
        else:
            return twoDxtalParamType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_aLength(self): return self.aLength
    def set_aLength(self, aLength): self.aLength = aLength
    def get_bLength(self): return self.bLength
    def set_bLength(self, bLength): self.bLength = bLength
    def get_cLength(self): return self.cLength
    def set_cLength(self, cLength): self.cLength = cLength
    def get_alpha(self): return self.alpha
    def set_alpha(self, alpha): self.alpha = alpha
    def get_beta(self): return self.beta
    def set_beta(self, beta): self.beta = beta
    def get_gamma(self): return self.gamma
    def set_gamma(self, gamma): self.gamma = gamma
    def get_planeGroup(self): return self.planeGroup
    def set_planeGroup(self, planeGroup): self.planeGroup = planeGroup
    def validate_plGrpType(self, value):
        # Validate type plGrpType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['P 1', 'P 2', 'P 1 2', 'P 1 21', 'C 1 2', 'P 2 2 2', 'P 2 2 21', 'P 2 21 21', 'C 2 2 2', 'P 4', 'P 4 2 2', 'P 4 21 2', 'P 3', 'P 3 1 2', 'P 3 2 1', 'P 6', 'P 6 2 2']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on plGrpType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.aLength is not None or
            self.bLength is not None or
            self.cLength is not None or
            self.alpha is not None or
            self.beta is not None or
            self.gamma is not None or
            self.planeGroup is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='twoDxtalParamType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='twoDxtalParamType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='twoDxtalParamType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='twoDxtalParamType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='twoDxtalParamType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.aLength is not None:
            self.aLength.export(outfile, level, namespace_, name_='aLength', pretty_print=pretty_print)
        if self.bLength is not None:
            self.bLength.export(outfile, level, namespace_, name_='bLength', pretty_print=pretty_print)
        if self.cLength is not None:
            self.cLength.export(outfile, level, namespace_, name_='cLength', pretty_print=pretty_print)
        if self.alpha is not None:
            self.alpha.export(outfile, level, namespace_, name_='alpha', pretty_print=pretty_print)
        if self.beta is not None:
            self.beta.export(outfile, level, namespace_, name_='beta', pretty_print=pretty_print)
        if self.gamma is not None:
            self.gamma.export(outfile, level, namespace_, name_='gamma', pretty_print=pretty_print)
        if self.planeGroup is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splaneGroup>%s</%splaneGroup>%s' % (namespace_, self.gds_format_string(quote_xml(self.planeGroup).encode(ExternalEncoding), input_name='planeGroup'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'aLength':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.aLength = obj_
            obj_.original_tagname_ = 'aLength'
        elif nodeName_ == 'bLength':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.bLength = obj_
            obj_.original_tagname_ = 'bLength'
        elif nodeName_ == 'cLength':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.cLength = obj_
            obj_.original_tagname_ = 'cLength'
        elif nodeName_ == 'alpha':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.alpha = obj_
            obj_.original_tagname_ = 'alpha'
        elif nodeName_ == 'beta':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.beta = obj_
            obj_.original_tagname_ = 'beta'
        elif nodeName_ == 'gamma':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.gamma = obj_
            obj_.original_tagname_ = 'gamma'
        elif nodeName_ == 'planeGroup':
            planeGroup_ = child_.text
            planeGroup_ = self.gds_validate_string(planeGroup_, node, 'planeGroup')
            self.planeGroup = planeGroup_
            # validate type plGrpType
            self.validate_plGrpType(self.planeGroup)
# end class twoDxtalParamType


class threeDxtalParamType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('aLength', 'lengthType', 0),
        MemberSpec_('bLength', 'lengthType', 0),
        MemberSpec_('cLength', 'lengthType', 0),
        MemberSpec_('alpha', 'anglType', 0),
        MemberSpec_('beta', 'anglType', 0),
        MemberSpec_('gamma', 'anglType', 0),
        MemberSpec_('spaceGroup', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, aLength=None, bLength=None, cLength=None, alpha=None, beta=None, gamma=None, spaceGroup=None):
        self.original_tagname_ = None
        self.aLength = aLength
        self.bLength = bLength
        self.cLength = cLength
        self.alpha = alpha
        self.beta = beta
        self.gamma = gamma
        self.spaceGroup = spaceGroup
    def factory(*args_, **kwargs_):
        if threeDxtalParamType.subclass:
            return threeDxtalParamType.subclass(*args_, **kwargs_)
        else:
            return threeDxtalParamType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_aLength(self): return self.aLength
    def set_aLength(self, aLength): self.aLength = aLength
    def get_bLength(self): return self.bLength
    def set_bLength(self, bLength): self.bLength = bLength
    def get_cLength(self): return self.cLength
    def set_cLength(self, cLength): self.cLength = cLength
    def get_alpha(self): return self.alpha
    def set_alpha(self, alpha): self.alpha = alpha
    def get_beta(self): return self.beta
    def set_beta(self, beta): self.beta = beta
    def get_gamma(self): return self.gamma
    def set_gamma(self, gamma): self.gamma = gamma
    def get_spaceGroup(self): return self.spaceGroup
    def set_spaceGroup(self, spaceGroup): self.spaceGroup = spaceGroup
    def hasContent_(self):
        if (
            self.aLength is not None or
            self.bLength is not None or
            self.cLength is not None or
            self.alpha is not None or
            self.beta is not None or
            self.gamma is not None or
            self.spaceGroup is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='threeDxtalParamType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='threeDxtalParamType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='threeDxtalParamType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='threeDxtalParamType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='threeDxtalParamType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.aLength is not None:
            self.aLength.export(outfile, level, namespace_, name_='aLength', pretty_print=pretty_print)
        if self.bLength is not None:
            self.bLength.export(outfile, level, namespace_, name_='bLength', pretty_print=pretty_print)
        if self.cLength is not None:
            self.cLength.export(outfile, level, namespace_, name_='cLength', pretty_print=pretty_print)
        if self.alpha is not None:
            self.alpha.export(outfile, level, namespace_, name_='alpha', pretty_print=pretty_print)
        if self.beta is not None:
            self.beta.export(outfile, level, namespace_, name_='beta', pretty_print=pretty_print)
        if self.gamma is not None:
            self.gamma.export(outfile, level, namespace_, name_='gamma', pretty_print=pretty_print)
        if self.spaceGroup is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspaceGroup>%s</%sspaceGroup>%s' % (namespace_, self.gds_format_string(quote_xml(self.spaceGroup).encode(ExternalEncoding), input_name='spaceGroup'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'aLength':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.aLength = obj_
            obj_.original_tagname_ = 'aLength'
        elif nodeName_ == 'bLength':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.bLength = obj_
            obj_.original_tagname_ = 'bLength'
        elif nodeName_ == 'cLength':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.cLength = obj_
            obj_.original_tagname_ = 'cLength'
        elif nodeName_ == 'alpha':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.alpha = obj_
            obj_.original_tagname_ = 'alpha'
        elif nodeName_ == 'beta':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.beta = obj_
            obj_.original_tagname_ = 'beta'
        elif nodeName_ == 'gamma':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.gamma = obj_
            obj_.original_tagname_ = 'gamma'
        elif nodeName_ == 'spaceGroup':
            spaceGroup_ = child_.text
            spaceGroup_ = self.gds_validate_string(spaceGroup_, node, 'spaceGroup')
            self.spaceGroup = spaceGroup_
# end class threeDxtalParamType


class xtal2DType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, details=None):
        self.original_tagname_ = None
        self.details = details
    def factory(*args_, **kwargs_):
        if xtal2DType.subclass:
            return xtal2DType.subclass(*args_, **kwargs_)
        else:
            return xtal2DType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='xtal2DType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='xtal2DType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='xtal2DType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='xtal2DType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='xtal2DType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class xtal2DType


class helixParamType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('deltaPhi', 'anglType', 0),
        MemberSpec_('deltaZ', 'lengthType', 0),
        MemberSpec_('hand', ['handType', 'xs:string'], 0),
        MemberSpec_('axialSymmetry', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, deltaPhi=None, deltaZ=None, hand=None, axialSymmetry=None):
        self.original_tagname_ = None
        self.deltaPhi = deltaPhi
        self.deltaZ = deltaZ
        self.hand = hand
        self.validate_handType(self.hand)
        self.axialSymmetry = axialSymmetry
    def factory(*args_, **kwargs_):
        if helixParamType.subclass:
            return helixParamType.subclass(*args_, **kwargs_)
        else:
            return helixParamType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_deltaPhi(self): return self.deltaPhi
    def set_deltaPhi(self, deltaPhi): self.deltaPhi = deltaPhi
    def get_deltaZ(self): return self.deltaZ
    def set_deltaZ(self, deltaZ): self.deltaZ = deltaZ
    def get_hand(self): return self.hand
    def set_hand(self, hand): self.hand = hand
    def get_axialSymmetry(self): return self.axialSymmetry
    def set_axialSymmetry(self, axialSymmetry): self.axialSymmetry = axialSymmetry
    def validate_handType(self, value):
        # Validate type handType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['RIGHT HANDED', 'LEFT HANDED']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on handType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.deltaPhi is not None or
            self.deltaZ is not None or
            self.hand is not None or
            self.axialSymmetry is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='helixParamType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='helixParamType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='helixParamType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='helixParamType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='helixParamType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.deltaPhi is not None:
            self.deltaPhi.export(outfile, level, namespace_, name_='deltaPhi', pretty_print=pretty_print)
        if self.deltaZ is not None:
            self.deltaZ.export(outfile, level, namespace_, name_='deltaZ', pretty_print=pretty_print)
        if self.hand is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shand>%s</%shand>%s' % (namespace_, self.gds_format_string(quote_xml(self.hand).encode(ExternalEncoding), input_name='hand'), namespace_, eol_))
        if self.axialSymmetry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saxialSymmetry>%s</%saxialSymmetry>%s' % (namespace_, self.gds_format_string(quote_xml(self.axialSymmetry).encode(ExternalEncoding), input_name='axialSymmetry'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'deltaPhi':
            obj_ = anglType.factory()
            obj_.build(child_)
            self.deltaPhi = obj_
            obj_.original_tagname_ = 'deltaPhi'
        elif nodeName_ == 'deltaZ':
            obj_ = lengthType.factory()
            obj_.build(child_)
            self.deltaZ = obj_
            obj_.original_tagname_ = 'deltaZ'
        elif nodeName_ == 'hand':
            hand_ = child_.text
            hand_ = self.gds_validate_string(hand_, node, 'hand')
            self.hand = hand_
            # validate type handType
            self.validate_handType(self.hand)
        elif nodeName_ == 'axialSymmetry':
            axialSymmetry_ = child_.text
            axialSymmetry_ = self.gds_validate_string(axialSymmetry_, node, 'axialSymmetry')
            self.axialSymmetry = axialSymmetry_
# end class helixParamType


class helixType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, details=None):
        self.original_tagname_ = None
        self.details = details
    def factory(*args_, **kwargs_):
        if helixType.subclass:
            return helixType.subclass(*args_, **kwargs_)
        else:
            return helixType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='helixType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='helixType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='helixType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='helixType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='helixType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class helixType


class singPartType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('appliedSymmetry', ['pointGroupSymmetryType', 'xs:token'], 0),
        MemberSpec_('numProjections', 'xs:positiveInteger', 0),
        MemberSpec_('numClassAverages', 'xs:positiveInteger', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, appliedSymmetry=None, numProjections=None, numClassAverages=None, details=None):
        self.original_tagname_ = None
        self.appliedSymmetry = appliedSymmetry
        self.validate_pointGroupSymmetryType(self.appliedSymmetry)
        self.numProjections = numProjections
        self.numClassAverages = numClassAverages
        self.details = details
    def factory(*args_, **kwargs_):
        if singPartType.subclass:
            return singPartType.subclass(*args_, **kwargs_)
        else:
            return singPartType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_appliedSymmetry(self): return self.appliedSymmetry
    def set_appliedSymmetry(self, appliedSymmetry): self.appliedSymmetry = appliedSymmetry
    def get_numProjections(self): return self.numProjections
    def set_numProjections(self, numProjections): self.numProjections = numProjections
    def get_numClassAverages(self): return self.numClassAverages
    def set_numClassAverages(self, numClassAverages): self.numClassAverages = numClassAverages
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_pointGroupSymmetryType(self, value):
        # Validate type pointGroupSymmetryType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pointGroupSymmetryType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pointGroupSymmetryType_patterns_, ))
    validate_pointGroupSymmetryType_patterns_ = [['^C\\d+|D\\d+|O|T|I$']]
    def hasContent_(self):
        if (
            self.appliedSymmetry is not None or
            self.numProjections is not None or
            self.numClassAverages is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='singPartType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='singPartType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='singPartType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='singPartType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='singPartType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.appliedSymmetry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sappliedSymmetry>%s</%sappliedSymmetry>%s' % (namespace_, self.gds_format_string(quote_xml(self.appliedSymmetry).encode(ExternalEncoding), input_name='appliedSymmetry'), namespace_, eol_))
        if self.numProjections is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumProjections>%s</%snumProjections>%s' % (namespace_, self.gds_format_integer(self.numProjections, input_name='numProjections'), namespace_, eol_))
        if self.numClassAverages is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumClassAverages>%s</%snumClassAverages>%s' % (namespace_, self.gds_format_integer(self.numClassAverages, input_name='numClassAverages'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'appliedSymmetry':
            appliedSymmetry_ = child_.text
            appliedSymmetry_ = re_.sub(String_cleanup_pat_, " ", appliedSymmetry_).strip()
            appliedSymmetry_ = self.gds_validate_string(appliedSymmetry_, node, 'appliedSymmetry')
            self.appliedSymmetry = appliedSymmetry_
            # validate type pointGroupSymmetryType
            self.validate_pointGroupSymmetryType(self.appliedSymmetry)
        elif nodeName_ == 'numProjections':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numProjections')
            self.numProjections = ival_
        elif nodeName_ == 'numClassAverages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numClassAverages')
            self.numClassAverages = ival_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class singPartType


class subTomType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('appliedSymmetry', 'xs:string', 0),
        MemberSpec_('numSubtomograms', 'xs:positiveInteger', 0),
        MemberSpec_('numClassAverages', 'xs:positiveInteger', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, appliedSymmetry=None, numSubtomograms=None, numClassAverages=None, details=None):
        self.original_tagname_ = None
        self.appliedSymmetry = appliedSymmetry
        self.numSubtomograms = numSubtomograms
        self.numClassAverages = numClassAverages
        self.details = details
    def factory(*args_, **kwargs_):
        if subTomType.subclass:
            return subTomType.subclass(*args_, **kwargs_)
        else:
            return subTomType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_appliedSymmetry(self): return self.appliedSymmetry
    def set_appliedSymmetry(self, appliedSymmetry): self.appliedSymmetry = appliedSymmetry
    def get_numSubtomograms(self): return self.numSubtomograms
    def set_numSubtomograms(self, numSubtomograms): self.numSubtomograms = numSubtomograms
    def get_numClassAverages(self): return self.numClassAverages
    def set_numClassAverages(self, numClassAverages): self.numClassAverages = numClassAverages
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.appliedSymmetry is not None or
            self.numSubtomograms is not None or
            self.numClassAverages is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='subTomType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='subTomType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='subTomType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='subTomType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='subTomType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.appliedSymmetry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sappliedSymmetry>%s</%sappliedSymmetry>%s' % (namespace_, self.gds_format_string(quote_xml(self.appliedSymmetry).encode(ExternalEncoding), input_name='appliedSymmetry'), namespace_, eol_))
        if self.numSubtomograms is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumSubtomograms>%s</%snumSubtomograms>%s' % (namespace_, self.gds_format_integer(self.numSubtomograms, input_name='numSubtomograms'), namespace_, eol_))
        if self.numClassAverages is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumClassAverages>%s</%snumClassAverages>%s' % (namespace_, self.gds_format_integer(self.numClassAverages, input_name='numClassAverages'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'appliedSymmetry':
            appliedSymmetry_ = child_.text
            appliedSymmetry_ = self.gds_validate_string(appliedSymmetry_, node, 'appliedSymmetry')
            self.appliedSymmetry = appliedSymmetry_
        elif nodeName_ == 'numSubtomograms':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numSubtomograms')
            self.numSubtomograms = ival_
        elif nodeName_ == 'numClassAverages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numClassAverages')
            self.numClassAverages = ival_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class subTomType


class tomogrType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('appliedSymmetry', ['pointGroupSymmetryType', 'xs:token'], 0),
        MemberSpec_('tiltAngleIncrement', 'xs:string', 0),
        MemberSpec_('numSections', 'xs:positiveInteger', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, appliedSymmetry=None, tiltAngleIncrement=None, numSections=None, details=None):
        self.original_tagname_ = None
        self.appliedSymmetry = appliedSymmetry
        self.validate_pointGroupSymmetryType(self.appliedSymmetry)
        self.tiltAngleIncrement = tiltAngleIncrement
        self.numSections = numSections
        self.details = details
    def factory(*args_, **kwargs_):
        if tomogrType.subclass:
            return tomogrType.subclass(*args_, **kwargs_)
        else:
            return tomogrType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_appliedSymmetry(self): return self.appliedSymmetry
    def set_appliedSymmetry(self, appliedSymmetry): self.appliedSymmetry = appliedSymmetry
    def get_tiltAngleIncrement(self): return self.tiltAngleIncrement
    def set_tiltAngleIncrement(self, tiltAngleIncrement): self.tiltAngleIncrement = tiltAngleIncrement
    def get_numSections(self): return self.numSections
    def set_numSections(self, numSections): self.numSections = numSections
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_pointGroupSymmetryType(self, value):
        # Validate type pointGroupSymmetryType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pointGroupSymmetryType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pointGroupSymmetryType_patterns_, ))
    validate_pointGroupSymmetryType_patterns_ = [['^C\\d+|D\\d+|O|T|I$']]
    def hasContent_(self):
        if (
            self.appliedSymmetry is not None or
            self.tiltAngleIncrement is not None or
            self.numSections is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tomogrType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tomogrType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tomogrType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tomogrType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='tomogrType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.appliedSymmetry is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sappliedSymmetry>%s</%sappliedSymmetry>%s' % (namespace_, self.gds_format_string(quote_xml(self.appliedSymmetry).encode(ExternalEncoding), input_name='appliedSymmetry'), namespace_, eol_))
        if self.tiltAngleIncrement is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stiltAngleIncrement>%s</%stiltAngleIncrement>%s' % (namespace_, self.gds_format_string(quote_xml(self.tiltAngleIncrement).encode(ExternalEncoding), input_name='tiltAngleIncrement'), namespace_, eol_))
        if self.numSections is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumSections>%s</%snumSections>%s' % (namespace_, self.gds_format_integer(self.numSections, input_name='numSections'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'appliedSymmetry':
            appliedSymmetry_ = child_.text
            appliedSymmetry_ = re_.sub(String_cleanup_pat_, " ", appliedSymmetry_).strip()
            appliedSymmetry_ = self.gds_validate_string(appliedSymmetry_, node, 'appliedSymmetry')
            self.appliedSymmetry = appliedSymmetry_
            # validate type pointGroupSymmetryType
            self.validate_pointGroupSymmetryType(self.appliedSymmetry)
        elif nodeName_ == 'tiltAngleIncrement':
            tiltAngleIncrement_ = child_.text
            tiltAngleIncrement_ = self.gds_validate_string(tiltAngleIncrement_, node, 'tiltAngleIncrement')
            self.tiltAngleIncrement = tiltAngleIncrement_
        elif nodeName_ == 'numSections':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numSections')
            self.numSections = ival_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class tomogrType


class figSetType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('figure', 'figType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, figure=None):
        self.original_tagname_ = None
        if figure is None:
            self.figure = []
        else:
            self.figure = figure
    def factory(*args_, **kwargs_):
        if figSetType.subclass:
            return figSetType.subclass(*args_, **kwargs_)
        else:
            return figSetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_figure(self): return self.figure
    def set_figure(self, figure): self.figure = figure
    def add_figure(self, value): self.figure.append(value)
    def insert_figure_at(self, index, value): self.figure.insert(index, value)
    def replace_figure_at(self, index, value): self.figure[index] = value
    def hasContent_(self):
        if (
            self.figure
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='figSetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='figSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='figSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='figSetType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='figSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for figure_ in self.figure:
            figure_.export(outfile, level, namespace_, name_='figure', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'figure':
            obj_ = figType.factory()
            obj_.build(child_)
            self.figure.append(obj_)
            obj_.original_tagname_ = 'figure'
# end class figSetType


class fscSetType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fsc', 'fscType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, fsc=None):
        self.original_tagname_ = None
        if fsc is None:
            self.fsc = []
        else:
            self.fsc = fsc
    def factory(*args_, **kwargs_):
        if fscSetType.subclass:
            return fscSetType.subclass(*args_, **kwargs_)
        else:
            return fscSetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fsc(self): return self.fsc
    def set_fsc(self, fsc): self.fsc = fsc
    def add_fsc(self, value): self.fsc.append(value)
    def insert_fsc_at(self, index, value): self.fsc.insert(index, value)
    def replace_fsc_at(self, index, value): self.fsc[index] = value
    def hasContent_(self):
        if (
            self.fsc
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fscSetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fscSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fscSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fscSetType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='fscSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for fsc_ in self.fsc:
            fsc_.export(outfile, level, namespace_, name_='fsc', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fsc':
            obj_ = fscType.factory()
            obj_.build(child_)
            self.fsc.append(obj_)
            obj_.original_tagname_ = 'fsc'
# end class fscSetType


class figType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        self.file = file
        self.details = details
    def factory(*args_, **kwargs_):
        if figType.subclass:
            return figType.subclass(*args_, **kwargs_)
        else:
            return figType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.file is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='figType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='figType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='figType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='figType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='figType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespace_, self.gds_format_string(quote_xml(self.file).encode(ExternalEncoding), input_name='file'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class figType


class fscType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        self.file = file
        self.details = details
    def factory(*args_, **kwargs_):
        if fscType.subclass:
            return fscType.subclass(*args_, **kwargs_)
        else:
            return fscType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.file is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fscType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fscType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fscType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fscType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='fscType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespace_, self.gds_format_string(quote_xml(self.file).encode(ExternalEncoding), input_name='file'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class fscType


class mskSetType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('mask', 'mskType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, mask=None):
        self.original_tagname_ = None
        if mask is None:
            self.mask = []
        else:
            self.mask = mask
    def factory(*args_, **kwargs_):
        if mskSetType.subclass:
            return mskSetType.subclass(*args_, **kwargs_)
        else:
            return mskSetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mask(self): return self.mask
    def set_mask(self, mask): self.mask = mask
    def add_mask(self, value): self.mask.append(value)
    def insert_mask_at(self, index, value): self.mask.insert(index, value)
    def replace_mask_at(self, index, value): self.mask[index] = value
    def hasContent_(self):
        if (
            self.mask
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='mskSetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mskSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='mskSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mskSetType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='mskSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for mask_ in self.mask:
            mask_.export(outfile, level, namespace_, name_='mask', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'mask':
            obj_ = mskType.factory()
            obj_.build(child_)
            self.mask.append(obj_)
            obj_.original_tagname_ = 'mask'
# end class mskSetType


class mskType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'mskFileType', 0),
        MemberSpec_('dataType', ['mapDataType', 'xs:string'], 0),
        MemberSpec_('dimensions', 'dimensionType', 0),
        MemberSpec_('spacing', 'spacingType', 0),
        MemberSpec_('origin', 'originType', 0),
        MemberSpec_('limit', 'limitType', 0),
        MemberSpec_('cell', 'cellType', 0),
        MemberSpec_('axisOrder', 'axisOrderType', 0),
        MemberSpec_('statistics', 'statisticsType', 0),
        MemberSpec_('pixelSpacing', 'pixelSpacingType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('annotationDetails', 'xs:string', 0),
        MemberSpec_('spaceGroupNumber', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, dataType=None, dimensions=None, spacing=None, origin=None, limit=None, cell=None, axisOrder=None, statistics=None, pixelSpacing=None, details=None, annotationDetails=None, spaceGroupNumber=None):
        self.original_tagname_ = None
        self.file = file
        self.dataType = dataType
        self.validate_mapDataType(self.dataType)
        self.dimensions = dimensions
        self.spacing = spacing
        self.origin = origin
        self.limit = limit
        self.cell = cell
        self.axisOrder = axisOrder
        self.statistics = statistics
        self.pixelSpacing = pixelSpacing
        self.details = details
        self.annotationDetails = annotationDetails
        self.spaceGroupNumber = spaceGroupNumber
    def factory(*args_, **kwargs_):
        if mskType.subclass:
            return mskType.subclass(*args_, **kwargs_)
        else:
            return mskType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_dataType(self): return self.dataType
    def set_dataType(self, dataType): self.dataType = dataType
    def get_dimensions(self): return self.dimensions
    def set_dimensions(self, dimensions): self.dimensions = dimensions
    def get_spacing(self): return self.spacing
    def set_spacing(self, spacing): self.spacing = spacing
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_limit(self): return self.limit
    def set_limit(self, limit): self.limit = limit
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_axisOrder(self): return self.axisOrder
    def set_axisOrder(self, axisOrder): self.axisOrder = axisOrder
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_pixelSpacing(self): return self.pixelSpacing
    def set_pixelSpacing(self, pixelSpacing): self.pixelSpacing = pixelSpacing
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_annotationDetails(self): return self.annotationDetails
    def set_annotationDetails(self, annotationDetails): self.annotationDetails = annotationDetails
    def get_spaceGroupNumber(self): return self.spaceGroupNumber
    def set_spaceGroupNumber(self, spaceGroupNumber): self.spaceGroupNumber = spaceGroupNumber
    def validate_mapDataType(self, value):
        # Validate type mapDataType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Envelope stored as signed bytes', 'Image stored as Integer*2', 'Image stored as Reals']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on mapDataType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.file is not None or
            self.dataType is not None or
            self.dimensions is not None or
            self.spacing is not None or
            self.origin is not None or
            self.limit is not None or
            self.cell is not None or
            self.axisOrder is not None or
            self.statistics is not None or
            self.pixelSpacing is not None or
            self.details is not None or
            self.annotationDetails is not None or
            self.spaceGroupNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='mskType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mskType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='mskType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mskType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='mskType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
        if self.dataType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataType>%s</%sdataType>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataType).encode(ExternalEncoding), input_name='dataType'), namespace_, eol_))
        if self.dimensions is not None:
            self.dimensions.export(outfile, level, namespace_, name_='dimensions', pretty_print=pretty_print)
        if self.spacing is not None:
            self.spacing.export(outfile, level, namespace_, name_='spacing', pretty_print=pretty_print)
        if self.origin is not None:
            self.origin.export(outfile, level, namespace_, name_='origin', pretty_print=pretty_print)
        if self.limit is not None:
            self.limit.export(outfile, level, namespace_, name_='limit', pretty_print=pretty_print)
        if self.cell is not None:
            self.cell.export(outfile, level, namespace_, name_='cell', pretty_print=pretty_print)
        if self.axisOrder is not None:
            self.axisOrder.export(outfile, level, namespace_, name_='axisOrder', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.pixelSpacing is not None:
            self.pixelSpacing.export(outfile, level, namespace_, name_='pixelSpacing', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.annotationDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sannotationDetails>%s</%sannotationDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.annotationDetails).encode(ExternalEncoding), input_name='annotationDetails'), namespace_, eol_))
        if self.spaceGroupNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspaceGroupNumber>%s</%sspaceGroupNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.spaceGroupNumber).encode(ExternalEncoding), input_name='spaceGroupNumber'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = mskFileType.factory()
            obj_.build(child_)
            self.file = obj_
            obj_.original_tagname_ = 'file'
        elif nodeName_ == 'dataType':
            dataType_ = child_.text
            dataType_ = self.gds_validate_string(dataType_, node, 'dataType')
            self.dataType = dataType_
            # validate type mapDataType
            self.validate_mapDataType(self.dataType)
        elif nodeName_ == 'dimensions':
            obj_ = dimensionType.factory()
            obj_.build(child_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'spacing':
            obj_ = spacingType.factory()
            obj_.build(child_)
            self.spacing = obj_
            obj_.original_tagname_ = 'spacing'
        elif nodeName_ == 'origin':
            obj_ = originType.factory()
            obj_.build(child_)
            self.origin = obj_
            obj_.original_tagname_ = 'origin'
        elif nodeName_ == 'limit':
            obj_ = limitType.factory()
            obj_.build(child_)
            self.limit = obj_
            obj_.original_tagname_ = 'limit'
        elif nodeName_ == 'cell':
            obj_ = cellType.factory()
            obj_.build(child_)
            self.cell = obj_
            obj_.original_tagname_ = 'cell'
        elif nodeName_ == 'axisOrder':
            obj_ = axisOrderType.factory()
            obj_.build(child_)
            self.axisOrder = obj_
            obj_.original_tagname_ = 'axisOrder'
        elif nodeName_ == 'statistics':
            obj_ = statisticsType.factory()
            obj_.build(child_)
            self.statistics = obj_
            obj_.original_tagname_ = 'statistics'
        elif nodeName_ == 'pixelSpacing':
            obj_ = pixelSpacingType.factory()
            obj_.build(child_)
            self.pixelSpacing = obj_
            obj_.original_tagname_ = 'pixelSpacing'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'annotationDetails':
            annotationDetails_ = child_.text
            annotationDetails_ = self.gds_validate_string(annotationDetails_, node, 'annotationDetails')
            self.annotationDetails = annotationDetails_
        elif nodeName_ == 'spaceGroupNumber':
            spaceGroupNumber_ = child_.text
            spaceGroupNumber_ = self.gds_validate_string(spaceGroupNumber_, node, 'spaceGroupNumber')
            self.spaceGroupNumber = spaceGroupNumber_
# end class mskType


class slcSetType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('slice', 'slcType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, slice=None):
        self.original_tagname_ = None
        if slice is None:
            self.slice = []
        else:
            self.slice = slice
    def factory(*args_, **kwargs_):
        if slcSetType.subclass:
            return slcSetType.subclass(*args_, **kwargs_)
        else:
            return slcSetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_slice(self): return self.slice
    def set_slice(self, slice): self.slice = slice
    def add_slice(self, value): self.slice.append(value)
    def insert_slice_at(self, index, value): self.slice.insert(index, value)
    def replace_slice_at(self, index, value): self.slice[index] = value
    def hasContent_(self):
        if (
            self.slice
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcSetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcSetType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='slcSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for slice_ in self.slice:
            slice_.export(outfile, level, namespace_, name_='slice', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'slice':
            obj_ = slcType.factory()
            obj_.build(child_)
            self.slice.append(obj_)
            obj_.original_tagname_ = 'slice'
# end class slcSetType


class slcType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'slcFileType', 0),
        MemberSpec_('dataType', ['mapDataType', 'xs:string'], 0),
        MemberSpec_('dimensions', 'slcDimensionType', 0),
        MemberSpec_('spacing', 'slcSpacingType', 0),
        MemberSpec_('origin', 'originType', 0),
        MemberSpec_('limit', 'limitType', 0),
        MemberSpec_('cell', 'slcCellType', 0),
        MemberSpec_('axisOrder', 'axisOrderType', 0),
        MemberSpec_('statistics', 'statisticsType', 0),
        MemberSpec_('pixelSpacing', 'pixelSpacingType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('annotationDetails', 'xs:string', 0),
        MemberSpec_('spaceGroupNumber', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, dataType=None, dimensions=None, spacing=None, origin=None, limit=None, cell=None, axisOrder=None, statistics=None, pixelSpacing=None, details=None, annotationDetails=None, spaceGroupNumber=None):
        self.original_tagname_ = None
        self.file = file
        self.dataType = dataType
        self.validate_mapDataType(self.dataType)
        self.dimensions = dimensions
        self.spacing = spacing
        self.origin = origin
        self.limit = limit
        self.cell = cell
        self.axisOrder = axisOrder
        self.statistics = statistics
        self.pixelSpacing = pixelSpacing
        self.details = details
        self.annotationDetails = annotationDetails
        self.spaceGroupNumber = spaceGroupNumber
    def factory(*args_, **kwargs_):
        if slcType.subclass:
            return slcType.subclass(*args_, **kwargs_)
        else:
            return slcType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_dataType(self): return self.dataType
    def set_dataType(self, dataType): self.dataType = dataType
    def get_dimensions(self): return self.dimensions
    def set_dimensions(self, dimensions): self.dimensions = dimensions
    def get_spacing(self): return self.spacing
    def set_spacing(self, spacing): self.spacing = spacing
    def get_origin(self): return self.origin
    def set_origin(self, origin): self.origin = origin
    def get_limit(self): return self.limit
    def set_limit(self, limit): self.limit = limit
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_axisOrder(self): return self.axisOrder
    def set_axisOrder(self, axisOrder): self.axisOrder = axisOrder
    def get_statistics(self): return self.statistics
    def set_statistics(self, statistics): self.statistics = statistics
    def get_pixelSpacing(self): return self.pixelSpacing
    def set_pixelSpacing(self, pixelSpacing): self.pixelSpacing = pixelSpacing
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_annotationDetails(self): return self.annotationDetails
    def set_annotationDetails(self, annotationDetails): self.annotationDetails = annotationDetails
    def get_spaceGroupNumber(self): return self.spaceGroupNumber
    def set_spaceGroupNumber(self, spaceGroupNumber): self.spaceGroupNumber = spaceGroupNumber
    def validate_mapDataType(self, value):
        # Validate type mapDataType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Envelope stored as signed bytes', 'Image stored as Integer*2', 'Image stored as Reals']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on mapDataType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.file is not None or
            self.dataType is not None or
            self.dimensions is not None or
            self.spacing is not None or
            self.origin is not None or
            self.limit is not None or
            self.cell is not None or
            self.axisOrder is not None or
            self.statistics is not None or
            self.pixelSpacing is not None or
            self.details is not None or
            self.annotationDetails is not None or
            self.spaceGroupNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='slcType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            self.file.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
        if self.dataType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataType>%s</%sdataType>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataType).encode(ExternalEncoding), input_name='dataType'), namespace_, eol_))
        if self.dimensions is not None:
            self.dimensions.export(outfile, level, namespace_, name_='dimensions', pretty_print=pretty_print)
        if self.spacing is not None:
            self.spacing.export(outfile, level, namespace_, name_='spacing', pretty_print=pretty_print)
        if self.origin is not None:
            self.origin.export(outfile, level, namespace_, name_='origin', pretty_print=pretty_print)
        if self.limit is not None:
            self.limit.export(outfile, level, namespace_, name_='limit', pretty_print=pretty_print)
        if self.cell is not None:
            self.cell.export(outfile, level, namespace_, name_='cell', pretty_print=pretty_print)
        if self.axisOrder is not None:
            self.axisOrder.export(outfile, level, namespace_, name_='axisOrder', pretty_print=pretty_print)
        if self.statistics is not None:
            self.statistics.export(outfile, level, namespace_, name_='statistics', pretty_print=pretty_print)
        if self.pixelSpacing is not None:
            self.pixelSpacing.export(outfile, level, namespace_, name_='pixelSpacing', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.annotationDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sannotationDetails>%s</%sannotationDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.annotationDetails).encode(ExternalEncoding), input_name='annotationDetails'), namespace_, eol_))
        if self.spaceGroupNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspaceGroupNumber>%s</%sspaceGroupNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.spaceGroupNumber).encode(ExternalEncoding), input_name='spaceGroupNumber'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = slcFileType.factory()
            obj_.build(child_)
            self.file = obj_
            obj_.original_tagname_ = 'file'
        elif nodeName_ == 'dataType':
            dataType_ = child_.text
            dataType_ = self.gds_validate_string(dataType_, node, 'dataType')
            self.dataType = dataType_
            # validate type mapDataType
            self.validate_mapDataType(self.dataType)
        elif nodeName_ == 'dimensions':
            obj_ = slcDimensionType.factory()
            obj_.build(child_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'spacing':
            obj_ = slcSpacingType.factory()
            obj_.build(child_)
            self.spacing = obj_
            obj_.original_tagname_ = 'spacing'
        elif nodeName_ == 'origin':
            obj_ = originType.factory()
            obj_.build(child_)
            self.origin = obj_
            obj_.original_tagname_ = 'origin'
        elif nodeName_ == 'limit':
            obj_ = limitType.factory()
            obj_.build(child_)
            self.limit = obj_
            obj_.original_tagname_ = 'limit'
        elif nodeName_ == 'cell':
            obj_ = slcCellType.factory()
            obj_.build(child_)
            self.cell = obj_
            obj_.original_tagname_ = 'cell'
        elif nodeName_ == 'axisOrder':
            obj_ = axisOrderType.factory()
            obj_.build(child_)
            self.axisOrder = obj_
            obj_.original_tagname_ = 'axisOrder'
        elif nodeName_ == 'statistics':
            obj_ = statisticsType.factory()
            obj_.build(child_)
            self.statistics = obj_
            obj_.original_tagname_ = 'statistics'
        elif nodeName_ == 'pixelSpacing':
            obj_ = pixelSpacingType.factory()
            obj_.build(child_)
            self.pixelSpacing = obj_
            obj_.original_tagname_ = 'pixelSpacing'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'annotationDetails':
            annotationDetails_ = child_.text
            annotationDetails_ = self.gds_validate_string(annotationDetails_, node, 'annotationDetails')
            self.annotationDetails = annotationDetails_
        elif nodeName_ == 'spaceGroupNumber':
            spaceGroupNumber_ = child_.text
            spaceGroupNumber_ = self.gds_validate_string(spaceGroupNumber_, node, 'spaceGroupNumber')
            self.spaceGroupNumber = spaceGroupNumber_
# end class slcType


class layerLineType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        self.file = file
        self.details = details
    def factory(*args_, **kwargs_):
        if layerLineType.subclass:
            return layerLineType.subclass(*args_, **kwargs_)
        else:
            return layerLineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.file is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='layerLineType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='layerLineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='layerLineType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='layerLineType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='layerLineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespace_, self.gds_format_string(quote_xml(self.file).encode(ExternalEncoding), input_name='file'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class layerLineType


class structFactType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'xs:string', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None, details=None):
        self.original_tagname_ = None
        self.file = file
        self.details = details
    def factory(*args_, **kwargs_):
        if structFactType.subclass:
            return structFactType.subclass(*args_, **kwargs_)
        else:
            return structFactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.file is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='structFactType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='structFactType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='structFactType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='structFactType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='structFactType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespace_, self.gds_format_string(quote_xml(self.file).encode(ExternalEncoding), input_name='file'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class structFactType


class virusType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('sciSpeciesSerotype', 'xs:string', 0),
        MemberSpec_('sciSpeciesSerocomplex', 'xs:string', 0),
        MemberSpec_('sciSpeciesSubspecies', 'xs:string', 0),
        MemberSpec_('sciSpeciesStrain', 'xs:string', 0),
        MemberSpec_('empty', 'xs:boolean', 0),
        MemberSpec_('enveloped', 'xs:boolean', 0),
        MemberSpec_('isolate', ['virusIsolType', 'xs:string'], 0),
        MemberSpec_('class_', ['virusClassType', 'xs:string'], 0),
        MemberSpec_('externalReferences', 'externalReferencesType', 1),
        MemberSpec_('natSource', 'natSrcVirusType', 1),
        MemberSpec_('engSource', 'engSrcType', 1),
        MemberSpec_('shell', 'shellType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, sciSpeciesName=None, synSpeciesName=None, sciSpeciesSerotype=None, sciSpeciesSerocomplex=None, sciSpeciesSubspecies=None, sciSpeciesStrain=None, empty=None, enveloped=None, isolate=None, class_=None, externalReferences=None, natSource=None, engSource=None, shell=None):
        self.original_tagname_ = None
        self.sciSpeciesName = sciSpeciesName
        self.synSpeciesName = synSpeciesName
        self.sciSpeciesSerotype = sciSpeciesSerotype
        self.sciSpeciesSerocomplex = sciSpeciesSerocomplex
        self.sciSpeciesSubspecies = sciSpeciesSubspecies
        self.sciSpeciesStrain = sciSpeciesStrain
        self.empty = empty
        self.enveloped = enveloped
        self.isolate = isolate
        self.validate_virusIsolType(self.isolate)
        self.class_ = class_
        self.validate_virusClassType(self.class_)
        if externalReferences is None:
            self.externalReferences = []
        else:
            self.externalReferences = externalReferences
        if natSource is None:
            self.natSource = []
        else:
            self.natSource = natSource
        if engSource is None:
            self.engSource = []
        else:
            self.engSource = engSource
        if shell is None:
            self.shell = []
        else:
            self.shell = shell
    def factory(*args_, **kwargs_):
        if virusType.subclass:
            return virusType.subclass(*args_, **kwargs_)
        else:
            return virusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_sciSpeciesSerotype(self): return self.sciSpeciesSerotype
    def set_sciSpeciesSerotype(self, sciSpeciesSerotype): self.sciSpeciesSerotype = sciSpeciesSerotype
    def get_sciSpeciesSerocomplex(self): return self.sciSpeciesSerocomplex
    def set_sciSpeciesSerocomplex(self, sciSpeciesSerocomplex): self.sciSpeciesSerocomplex = sciSpeciesSerocomplex
    def get_sciSpeciesSubspecies(self): return self.sciSpeciesSubspecies
    def set_sciSpeciesSubspecies(self, sciSpeciesSubspecies): self.sciSpeciesSubspecies = sciSpeciesSubspecies
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_empty(self): return self.empty
    def set_empty(self, empty): self.empty = empty
    def get_enveloped(self): return self.enveloped
    def set_enveloped(self, enveloped): self.enveloped = enveloped
    def get_isolate(self): return self.isolate
    def set_isolate(self, isolate): self.isolate = isolate
    def get_class(self): return self.class_
    def set_class(self, class_): self.class_ = class_
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def add_externalReferences(self, value): self.externalReferences.append(value)
    def insert_externalReferences_at(self, index, value): self.externalReferences.insert(index, value)
    def replace_externalReferences_at(self, index, value): self.externalReferences[index] = value
    def get_natSource(self): return self.natSource
    def set_natSource(self, natSource): self.natSource = natSource
    def add_natSource(self, value): self.natSource.append(value)
    def insert_natSource_at(self, index, value): self.natSource.insert(index, value)
    def replace_natSource_at(self, index, value): self.natSource[index] = value
    def get_engSource(self): return self.engSource
    def set_engSource(self, engSource): self.engSource = engSource
    def add_engSource(self, value): self.engSource.append(value)
    def insert_engSource_at(self, index, value): self.engSource.insert(index, value)
    def replace_engSource_at(self, index, value): self.engSource[index] = value
    def get_shell(self): return self.shell
    def set_shell(self, shell): self.shell = shell
    def add_shell(self, value): self.shell.append(value)
    def insert_shell_at(self, index, value): self.shell.insert(index, value)
    def replace_shell_at(self, index, value): self.shell[index] = value
    def validate_virusIsolType(self, value):
        # Validate type virusIsolType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['STRAIN', 'SEROTYPE', 'SEROCOMPLEX', 'SUBSPECIES', 'SPECIES', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on virusIsolType' % {"value" : value.encode("utf-8")} )
    def validate_virusClassType(self, value):
        # Validate type virusClassType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['VIRION', 'SATELLITE', 'PRION', 'VIROID', 'VIRUS-LIKE PARTICLE', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on virusClassType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.sciSpeciesName is not None or
            self.synSpeciesName is not None or
            self.sciSpeciesSerotype is not None or
            self.sciSpeciesSerocomplex is not None or
            self.sciSpeciesSubspecies is not None or
            self.sciSpeciesStrain is not None or
            self.empty is not None or
            self.enveloped is not None or
            self.isolate is not None or
            self.class_ is not None or
            self.externalReferences or
            self.natSource or
            self.engSource or
            self.shell
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='virusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='virusType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='virusType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='virusType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='virusType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.sciSpeciesSerotype is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssciSpeciesSerotype>%s</%ssciSpeciesSerotype>%s' % (namespace_, self.gds_format_string(quote_xml(self.sciSpeciesSerotype).encode(ExternalEncoding), input_name='sciSpeciesSerotype'), namespace_, eol_))
        if self.sciSpeciesSerocomplex is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssciSpeciesSerocomplex>%s</%ssciSpeciesSerocomplex>%s' % (namespace_, self.gds_format_string(quote_xml(self.sciSpeciesSerocomplex).encode(ExternalEncoding), input_name='sciSpeciesSerocomplex'), namespace_, eol_))
        if self.sciSpeciesSubspecies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssciSpeciesSubspecies>%s</%ssciSpeciesSubspecies>%s' % (namespace_, self.gds_format_string(quote_xml(self.sciSpeciesSubspecies).encode(ExternalEncoding), input_name='sciSpeciesSubspecies'), namespace_, eol_))
        if self.sciSpeciesStrain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssciSpeciesStrain>%s</%ssciSpeciesStrain>%s' % (namespace_, self.gds_format_string(quote_xml(self.sciSpeciesStrain).encode(ExternalEncoding), input_name='sciSpeciesStrain'), namespace_, eol_))
        if self.empty is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sempty>%s</%sempty>%s' % (namespace_, self.gds_format_boolean(self.empty, input_name='empty'), namespace_, eol_))
        if self.enveloped is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%senveloped>%s</%senveloped>%s' % (namespace_, self.gds_format_boolean(self.enveloped, input_name='enveloped'), namespace_, eol_))
        if self.isolate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sisolate>%s</%sisolate>%s' % (namespace_, self.gds_format_string(quote_xml(self.isolate).encode(ExternalEncoding), input_name='isolate'), namespace_, eol_))
        if self.class_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclass>%s</%sclass>%s' % (namespace_, self.gds_format_string(quote_xml(self.class_).encode(ExternalEncoding), input_name='class'), namespace_, eol_))
        for externalReferences_ in self.externalReferences:
            externalReferences_.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
        for natSource_ in self.natSource:
            natSource_.export(outfile, level, namespace_, name_='natSource', pretty_print=pretty_print)
        for engSource_ in self.engSource:
            engSource_.export(outfile, level, namespace_, name_='engSource', pretty_print=pretty_print)
        for shell_ in self.shell:
            shell_.export(outfile, level, namespace_, name_='shell', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'sciSpeciesSerotype':
            sciSpeciesSerotype_ = child_.text
            sciSpeciesSerotype_ = self.gds_validate_string(sciSpeciesSerotype_, node, 'sciSpeciesSerotype')
            self.sciSpeciesSerotype = sciSpeciesSerotype_
        elif nodeName_ == 'sciSpeciesSerocomplex':
            sciSpeciesSerocomplex_ = child_.text
            sciSpeciesSerocomplex_ = self.gds_validate_string(sciSpeciesSerocomplex_, node, 'sciSpeciesSerocomplex')
            self.sciSpeciesSerocomplex = sciSpeciesSerocomplex_
        elif nodeName_ == 'sciSpeciesSubspecies':
            sciSpeciesSubspecies_ = child_.text
            sciSpeciesSubspecies_ = self.gds_validate_string(sciSpeciesSubspecies_, node, 'sciSpeciesSubspecies')
            self.sciSpeciesSubspecies = sciSpeciesSubspecies_
        elif nodeName_ == 'sciSpeciesStrain':
            sciSpeciesStrain_ = child_.text
            sciSpeciesStrain_ = self.gds_validate_string(sciSpeciesStrain_, node, 'sciSpeciesStrain')
            self.sciSpeciesStrain = sciSpeciesStrain_
        elif nodeName_ == 'empty':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'empty')
            self.empty = ival_
        elif nodeName_ == 'enveloped':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'enveloped')
            self.enveloped = ival_
        elif nodeName_ == 'isolate':
            isolate_ = child_.text
            isolate_ = self.gds_validate_string(isolate_, node, 'isolate')
            self.isolate = isolate_
            # validate type virusIsolType
            self.validate_virusIsolType(self.isolate)
        elif nodeName_ == 'class':
            class_ = child_.text
            class_ = self.gds_validate_string(class_, node, 'class')
            self.class_ = class_
            # validate type virusClassType
            self.validate_virusClassType(self.class_)
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences.append(obj_)
            obj_.original_tagname_ = 'externalReferences'
        elif nodeName_ == 'natSource':
            obj_ = natSrcVirusType.factory()
            obj_.build(child_)
            self.natSource.append(obj_)
            obj_.original_tagname_ = 'natSource'
        elif nodeName_ == 'engSource':
            obj_ = engSrcType.factory()
            obj_.build(child_)
            self.engSource.append(obj_)
            obj_.original_tagname_ = 'engSource'
        elif nodeName_ == 'shell':
            obj_ = shellType.factory()
            obj_.build(child_)
            self.shell.append(obj_)
            obj_.original_tagname_ = 'shell'
# end class virusType


class shellType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('id', 'xs:positiveInteger', 0),
        MemberSpec_('nameElement', 'xs:string', 0),
        MemberSpec_('diameter', 'diamType', 0),
        MemberSpec_('tNumber', ['floatOrNAType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, nameElement=None, diameter=None, tNumber=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.nameElement = nameElement
        self.diameter = diameter
        self.tNumber = tNumber
        self.validate_floatOrNAType(self.tNumber)
    def factory(*args_, **kwargs_):
        if shellType.subclass:
            return shellType.subclass(*args_, **kwargs_)
        else:
            return shellType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nameElement(self): return self.nameElement
    def set_nameElement(self, nameElement): self.nameElement = nameElement
    def get_diameter(self): return self.diameter
    def set_diameter(self, diameter): self.diameter = diameter
    def get_tNumber(self): return self.tNumber
    def set_tNumber(self, tNumber): self.tNumber = tNumber
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_floatOrNAType(self, value):
        # Validate type floatOrNAType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.nameElement is not None or
            self.diameter is not None or
            self.tNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='shellType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='shellType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='shellType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='shellType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='shellType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.nameElement is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snameElement>%s</%snameElement>%s' % (namespace_, self.gds_format_string(quote_xml(self.nameElement).encode(ExternalEncoding), input_name='nameElement'), namespace_, eol_))
        if self.diameter is not None:
            self.diameter.export(outfile, level, namespace_, name_='diameter', pretty_print=pretty_print)
        if self.tNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stNumber>%s</%stNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.tNumber).encode(ExternalEncoding), input_name='tNumber'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nameElement':
            nameElement_ = child_.text
            nameElement_ = self.gds_validate_string(nameElement_, node, 'nameElement')
            self.nameElement = nameElement_
        elif nodeName_ == 'diameter':
            obj_ = diamType.factory()
            obj_.build(child_)
            self.diameter = obj_
            obj_.original_tagname_ = 'diameter'
        elif nodeName_ == 'tNumber':
            tNumber_ = child_.text
            tNumber_ = self.gds_validate_string(tNumber_, node, 'tNumber')
            self.tNumber = tNumber_
            # validate type floatOrNAType
            self.validate_floatOrNAType(self.tNumber)
# end class shellType


class proteinType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('sciSpeciesStrain', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('oligomericDetails', 'xs:string', 0),
        MemberSpec_('numCopies', 'xs:string', 0),
        MemberSpec_('recombinantExpFlag', 'xs:boolean', 0),
        MemberSpec_('natSource', 'natSrcType', 0),
        MemberSpec_('engSource', 'engSrcType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('externalReferences', 'externalReferencesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sciSpeciesName=None, sciSpeciesStrain=None, synSpeciesName=None, oligomericDetails=None, numCopies=None, recombinantExpFlag=None, natSource=None, engSource=None, details=None, externalReferences=None):
        self.original_tagname_ = None
        self.sciSpeciesName = sciSpeciesName
        self.sciSpeciesStrain = sciSpeciesStrain
        self.synSpeciesName = synSpeciesName
        self.oligomericDetails = oligomericDetails
        self.numCopies = numCopies
        self.recombinantExpFlag = recombinantExpFlag
        self.natSource = natSource
        self.engSource = engSource
        self.details = details
        self.externalReferences = externalReferences
    def factory(*args_, **kwargs_):
        if proteinType.subclass:
            return proteinType.subclass(*args_, **kwargs_)
        else:
            return proteinType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_oligomericDetails(self): return self.oligomericDetails
    def set_oligomericDetails(self, oligomericDetails): self.oligomericDetails = oligomericDetails
    def get_numCopies(self): return self.numCopies
    def set_numCopies(self, numCopies): self.numCopies = numCopies
    def get_recombinantExpFlag(self): return self.recombinantExpFlag
    def set_recombinantExpFlag(self, recombinantExpFlag): self.recombinantExpFlag = recombinantExpFlag
    def get_natSource(self): return self.natSource
    def set_natSource(self, natSource): self.natSource = natSource
    def get_engSource(self): return self.engSource
    def set_engSource(self, engSource): self.engSource = engSource
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def hasContent_(self):
        if (
            self.sciSpeciesName is not None or
            self.sciSpeciesStrain is not None or
            self.synSpeciesName is not None or
            self.oligomericDetails is not None or
            self.numCopies is not None or
            self.recombinantExpFlag is not None or
            self.natSource is not None or
            self.engSource is not None or
            self.details is not None or
            self.externalReferences is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='proteinType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='proteinType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='proteinType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='proteinType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='proteinType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.sciSpeciesStrain is not None:
            self.sciSpeciesStrain.export(outfile, level, namespace_, name_='sciSpeciesStrain', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.oligomericDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomericDetails>%s</%soligomericDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.oligomericDetails).encode(ExternalEncoding), input_name='oligomericDetails'), namespace_, eol_))
        if self.numCopies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumCopies>%s</%snumCopies>%s' % (namespace_, self.gds_format_string(quote_xml(self.numCopies).encode(ExternalEncoding), input_name='numCopies'), namespace_, eol_))
        if self.recombinantExpFlag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinantExpFlag>%s</%srecombinantExpFlag>%s' % (namespace_, self.gds_format_boolean(self.recombinantExpFlag, input_name='recombinantExpFlag'), namespace_, eol_))
        if self.natSource is not None:
            self.natSource.export(outfile, level, namespace_, name_='natSource', pretty_print=pretty_print)
        if self.engSource is not None:
            self.engSource.export(outfile, level, namespace_, name_='engSource', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.externalReferences is not None:
            self.externalReferences.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'sciSpeciesStrain':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesStrain = obj_
            obj_.original_tagname_ = 'sciSpeciesStrain'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'oligomericDetails':
            oligomericDetails_ = child_.text
            oligomericDetails_ = self.gds_validate_string(oligomericDetails_, node, 'oligomericDetails')
            self.oligomericDetails = oligomericDetails_
        elif nodeName_ == 'numCopies':
            numCopies_ = child_.text
            numCopies_ = self.gds_validate_string(numCopies_, node, 'numCopies')
            self.numCopies = numCopies_
        elif nodeName_ == 'recombinantExpFlag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinantExpFlag')
            self.recombinantExpFlag = ival_
        elif nodeName_ == 'natSource':
            obj_ = natSrcType.factory()
            obj_.build(child_)
            self.natSource = obj_
            obj_.original_tagname_ = 'natSource'
        elif nodeName_ == 'engSource':
            obj_ = engSrcType.factory()
            obj_.build(child_)
            self.engSource = obj_
            obj_.original_tagname_ = 'engSource'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences = obj_
            obj_.original_tagname_ = 'externalReferences'
# end class proteinType


class cellCompType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('sciSpeciesStrain', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('oligomericDetails', 'xs:string', 0),
        MemberSpec_('numCopies', 'xs:string', 0),
        MemberSpec_('recombinantExpFlag', 'xs:boolean', 0),
        MemberSpec_('natSource', 'natSrcType', 0),
        MemberSpec_('engSource', 'engSrcType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('externalReferences', 'externalReferencesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sciSpeciesName=None, sciSpeciesStrain=None, synSpeciesName=None, oligomericDetails=None, numCopies=None, recombinantExpFlag=None, natSource=None, engSource=None, details=None, externalReferences=None):
        self.original_tagname_ = None
        self.sciSpeciesName = sciSpeciesName
        self.sciSpeciesStrain = sciSpeciesStrain
        self.synSpeciesName = synSpeciesName
        self.oligomericDetails = oligomericDetails
        self.numCopies = numCopies
        self.recombinantExpFlag = recombinantExpFlag
        self.natSource = natSource
        self.engSource = engSource
        self.details = details
        self.externalReferences = externalReferences
    def factory(*args_, **kwargs_):
        if cellCompType.subclass:
            return cellCompType.subclass(*args_, **kwargs_)
        else:
            return cellCompType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_oligomericDetails(self): return self.oligomericDetails
    def set_oligomericDetails(self, oligomericDetails): self.oligomericDetails = oligomericDetails
    def get_numCopies(self): return self.numCopies
    def set_numCopies(self, numCopies): self.numCopies = numCopies
    def get_recombinantExpFlag(self): return self.recombinantExpFlag
    def set_recombinantExpFlag(self, recombinantExpFlag): self.recombinantExpFlag = recombinantExpFlag
    def get_natSource(self): return self.natSource
    def set_natSource(self, natSource): self.natSource = natSource
    def get_engSource(self): return self.engSource
    def set_engSource(self, engSource): self.engSource = engSource
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def hasContent_(self):
        if (
            self.sciSpeciesName is not None or
            self.sciSpeciesStrain is not None or
            self.synSpeciesName is not None or
            self.oligomericDetails is not None or
            self.numCopies is not None or
            self.recombinantExpFlag is not None or
            self.natSource is not None or
            self.engSource is not None or
            self.details is not None or
            self.externalReferences is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cellCompType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cellCompType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cellCompType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cellCompType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cellCompType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.sciSpeciesStrain is not None:
            self.sciSpeciesStrain.export(outfile, level, namespace_, name_='sciSpeciesStrain', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.oligomericDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomericDetails>%s</%soligomericDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.oligomericDetails).encode(ExternalEncoding), input_name='oligomericDetails'), namespace_, eol_))
        if self.numCopies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumCopies>%s</%snumCopies>%s' % (namespace_, self.gds_format_string(quote_xml(self.numCopies).encode(ExternalEncoding), input_name='numCopies'), namespace_, eol_))
        if self.recombinantExpFlag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinantExpFlag>%s</%srecombinantExpFlag>%s' % (namespace_, self.gds_format_boolean(self.recombinantExpFlag, input_name='recombinantExpFlag'), namespace_, eol_))
        if self.natSource is not None:
            self.natSource.export(outfile, level, namespace_, name_='natSource', pretty_print=pretty_print)
        if self.engSource is not None:
            self.engSource.export(outfile, level, namespace_, name_='engSource', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.externalReferences is not None:
            self.externalReferences.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'sciSpeciesStrain':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesStrain = obj_
            obj_.original_tagname_ = 'sciSpeciesStrain'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'oligomericDetails':
            oligomericDetails_ = child_.text
            oligomericDetails_ = self.gds_validate_string(oligomericDetails_, node, 'oligomericDetails')
            self.oligomericDetails = oligomericDetails_
        elif nodeName_ == 'numCopies':
            numCopies_ = child_.text
            numCopies_ = self.gds_validate_string(numCopies_, node, 'numCopies')
            self.numCopies = numCopies_
        elif nodeName_ == 'recombinantExpFlag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinantExpFlag')
            self.recombinantExpFlag = ival_
        elif nodeName_ == 'natSource':
            obj_ = natSrcType.factory()
            obj_.build(child_)
            self.natSource = obj_
            obj_.original_tagname_ = 'natSource'
        elif nodeName_ == 'engSource':
            obj_ = engSrcType.factory()
            obj_.build(child_)
            self.engSource = obj_
            obj_.original_tagname_ = 'engSource'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences = obj_
            obj_.original_tagname_ = 'externalReferences'
# end class cellCompType


class nuclAcidType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('sciSpeciesStrain', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('syntheticFlag', 'xs:boolean', 0),
        MemberSpec_('sequence', 'xs:string', 0),
        MemberSpec_('class_', ['naClassType', 'xs:string'], 0),
        MemberSpec_('structure', ['naStructType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sciSpeciesName=None, sciSpeciesStrain=None, synSpeciesName=None, syntheticFlag=None, sequence=None, class_=None, structure=None):
        self.original_tagname_ = None
        self.sciSpeciesName = sciSpeciesName
        self.sciSpeciesStrain = sciSpeciesStrain
        self.synSpeciesName = synSpeciesName
        self.syntheticFlag = syntheticFlag
        self.sequence = sequence
        self.class_ = class_
        self.validate_naClassType(self.class_)
        self.structure = structure
        self.validate_naStructType(self.structure)
    def factory(*args_, **kwargs_):
        if nuclAcidType.subclass:
            return nuclAcidType.subclass(*args_, **kwargs_)
        else:
            return nuclAcidType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_syntheticFlag(self): return self.syntheticFlag
    def set_syntheticFlag(self, syntheticFlag): self.syntheticFlag = syntheticFlag
    def get_sequence(self): return self.sequence
    def set_sequence(self, sequence): self.sequence = sequence
    def get_class(self): return self.class_
    def set_class(self, class_): self.class_ = class_
    def get_structure(self): return self.structure
    def set_structure(self, structure): self.structure = structure
    def validate_naClassType(self, value):
        # Validate type naClassType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['DNA', 'DNA/RNA', 'PEPTIDE NUCLEIC ACID', 'PEPTIDE NUCLEIC ACID/DNA', 'RIBOZYME', 'RNA', 'T-RNA', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on naClassType' % {"value" : value.encode("utf-8")} )
    def validate_naStructType(self, value):
        # Validate type naStructType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['SINGLE STRANDED', 'DOUBLE HELIX', 'TRIPLE HELIX', 'QUADRUPLE HELIX', 'OTHER']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on naStructType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.sciSpeciesName is not None or
            self.sciSpeciesStrain is not None or
            self.synSpeciesName is not None or
            self.syntheticFlag is not None or
            self.sequence is not None or
            self.class_ is not None or
            self.structure is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='nuclAcidType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='nuclAcidType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='nuclAcidType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='nuclAcidType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='nuclAcidType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.sciSpeciesStrain is not None:
            self.sciSpeciesStrain.export(outfile, level, namespace_, name_='sciSpeciesStrain', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.syntheticFlag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssyntheticFlag>%s</%ssyntheticFlag>%s' % (namespace_, self.gds_format_boolean(self.syntheticFlag, input_name='syntheticFlag'), namespace_, eol_))
        if self.sequence is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssequence>%s</%ssequence>%s' % (namespace_, self.gds_format_string(quote_xml(self.sequence).encode(ExternalEncoding), input_name='sequence'), namespace_, eol_))
        if self.class_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclass>%s</%sclass>%s' % (namespace_, self.gds_format_string(quote_xml(self.class_).encode(ExternalEncoding), input_name='class'), namespace_, eol_))
        if self.structure is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstructure>%s</%sstructure>%s' % (namespace_, self.gds_format_string(quote_xml(self.structure).encode(ExternalEncoding), input_name='structure'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'sciSpeciesStrain':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesStrain = obj_
            obj_.original_tagname_ = 'sciSpeciesStrain'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'syntheticFlag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'syntheticFlag')
            self.syntheticFlag = ival_
        elif nodeName_ == 'sequence':
            sequence_ = child_.text
            sequence_ = self.gds_validate_string(sequence_, node, 'sequence')
            self.sequence = sequence_
        elif nodeName_ == 'class':
            class_ = child_.text
            class_ = self.gds_validate_string(class_, node, 'class')
            self.class_ = class_
            # validate type naClassType
            self.validate_naClassType(self.class_)
        elif nodeName_ == 'structure':
            structure_ = child_.text
            structure_ = self.gds_validate_string(structure_, node, 'structure')
            self.structure = structure_
            # validate type naStructType
            self.validate_naStructType(self.structure)
# end class nuclAcidType


class ligandType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('sciSpeciesStrain', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('oligomericDetails', 'xs:string', 0),
        MemberSpec_('numCopies', 'xs:string', 0),
        MemberSpec_('recombinantExpFlag', 'xs:boolean', 0),
        MemberSpec_('natSource', 'natSrcType', 0),
        MemberSpec_('engSource', 'engSrcType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('externalReferences', 'externalReferencesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sciSpeciesName=None, sciSpeciesStrain=None, synSpeciesName=None, oligomericDetails=None, numCopies=None, recombinantExpFlag=None, natSource=None, engSource=None, details=None, externalReferences=None):
        self.original_tagname_ = None
        self.sciSpeciesName = sciSpeciesName
        self.sciSpeciesStrain = sciSpeciesStrain
        self.synSpeciesName = synSpeciesName
        self.oligomericDetails = oligomericDetails
        self.numCopies = numCopies
        self.recombinantExpFlag = recombinantExpFlag
        self.natSource = natSource
        self.engSource = engSource
        self.details = details
        self.externalReferences = externalReferences
    def factory(*args_, **kwargs_):
        if ligandType.subclass:
            return ligandType.subclass(*args_, **kwargs_)
        else:
            return ligandType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_oligomericDetails(self): return self.oligomericDetails
    def set_oligomericDetails(self, oligomericDetails): self.oligomericDetails = oligomericDetails
    def get_numCopies(self): return self.numCopies
    def set_numCopies(self, numCopies): self.numCopies = numCopies
    def get_recombinantExpFlag(self): return self.recombinantExpFlag
    def set_recombinantExpFlag(self, recombinantExpFlag): self.recombinantExpFlag = recombinantExpFlag
    def get_natSource(self): return self.natSource
    def set_natSource(self, natSource): self.natSource = natSource
    def get_engSource(self): return self.engSource
    def set_engSource(self, engSource): self.engSource = engSource
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def hasContent_(self):
        if (
            self.sciSpeciesName is not None or
            self.sciSpeciesStrain is not None or
            self.synSpeciesName is not None or
            self.oligomericDetails is not None or
            self.numCopies is not None or
            self.recombinantExpFlag is not None or
            self.natSource is not None or
            self.engSource is not None or
            self.details is not None or
            self.externalReferences is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ligandType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ligandType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ligandType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ligandType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ligandType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.sciSpeciesStrain is not None:
            self.sciSpeciesStrain.export(outfile, level, namespace_, name_='sciSpeciesStrain', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.oligomericDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomericDetails>%s</%soligomericDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.oligomericDetails).encode(ExternalEncoding), input_name='oligomericDetails'), namespace_, eol_))
        if self.numCopies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumCopies>%s</%snumCopies>%s' % (namespace_, self.gds_format_string(quote_xml(self.numCopies).encode(ExternalEncoding), input_name='numCopies'), namespace_, eol_))
        if self.recombinantExpFlag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinantExpFlag>%s</%srecombinantExpFlag>%s' % (namespace_, self.gds_format_boolean(self.recombinantExpFlag, input_name='recombinantExpFlag'), namespace_, eol_))
        if self.natSource is not None:
            self.natSource.export(outfile, level, namespace_, name_='natSource', pretty_print=pretty_print)
        if self.engSource is not None:
            self.engSource.export(outfile, level, namespace_, name_='engSource', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.externalReferences is not None:
            self.externalReferences.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'sciSpeciesStrain':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesStrain = obj_
            obj_.original_tagname_ = 'sciSpeciesStrain'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'oligomericDetails':
            oligomericDetails_ = child_.text
            oligomericDetails_ = self.gds_validate_string(oligomericDetails_, node, 'oligomericDetails')
            self.oligomericDetails = oligomericDetails_
        elif nodeName_ == 'numCopies':
            numCopies_ = child_.text
            numCopies_ = self.gds_validate_string(numCopies_, node, 'numCopies')
            self.numCopies = numCopies_
        elif nodeName_ == 'recombinantExpFlag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinantExpFlag')
            self.recombinantExpFlag = ival_
        elif nodeName_ == 'natSource':
            obj_ = natSrcType.factory()
            obj_.build(child_)
            self.natSource = obj_
            obj_.original_tagname_ = 'natSource'
        elif nodeName_ == 'engSource':
            obj_ = engSrcType.factory()
            obj_.build(child_)
            self.engSource = obj_
            obj_.original_tagname_ = 'engSource'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences = obj_
            obj_.original_tagname_ = 'externalReferences'
# end class ligandType


class labelType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('formula', 'xs:string', 0),
        MemberSpec_('oligomericDetails', 'xs:string', 0),
        MemberSpec_('numCopies', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, formula=None, oligomericDetails=None, numCopies=None):
        self.original_tagname_ = None
        self.formula = formula
        self.oligomericDetails = oligomericDetails
        self.numCopies = numCopies
    def factory(*args_, **kwargs_):
        if labelType.subclass:
            return labelType.subclass(*args_, **kwargs_)
        else:
            return labelType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_formula(self): return self.formula
    def set_formula(self, formula): self.formula = formula
    def get_oligomericDetails(self): return self.oligomericDetails
    def set_oligomericDetails(self, oligomericDetails): self.oligomericDetails = oligomericDetails
    def get_numCopies(self): return self.numCopies
    def set_numCopies(self, numCopies): self.numCopies = numCopies
    def hasContent_(self):
        if (
            self.formula is not None or
            self.oligomericDetails is not None or
            self.numCopies is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='labelType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='labelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='labelType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='labelType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='labelType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.formula is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformula>%s</%sformula>%s' % (namespace_, self.gds_format_string(quote_xml(self.formula).encode(ExternalEncoding), input_name='formula'), namespace_, eol_))
        if self.oligomericDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomericDetails>%s</%soligomericDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.oligomericDetails).encode(ExternalEncoding), input_name='oligomericDetails'), namespace_, eol_))
        if self.numCopies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumCopies>%s</%snumCopies>%s' % (namespace_, self.gds_format_string(quote_xml(self.numCopies).encode(ExternalEncoding), input_name='numCopies'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'formula':
            formula_ = child_.text
            formula_ = self.gds_validate_string(formula_, node, 'formula')
            self.formula = formula_
        elif nodeName_ == 'oligomericDetails':
            oligomericDetails_ = child_.text
            oligomericDetails_ = self.gds_validate_string(oligomericDetails_, node, 'oligomericDetails')
            self.oligomericDetails = oligomericDetails_
        elif nodeName_ == 'numCopies':
            numCopies_ = child_.text
            numCopies_ = self.gds_validate_string(numCopies_, node, 'numCopies')
            self.numCopies = numCopies_
# end class labelType


class riboTypeEu(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('eukaryote', 'xs:string', 0),
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('sciSpeciesStrain', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('oligomericDetails', 'xs:string', 0),
        MemberSpec_('numCopies', 'xs:string', 0),
        MemberSpec_('recombinantExpFlag', 'xs:boolean', 0),
        MemberSpec_('natSource', 'natSrcType', 0),
        MemberSpec_('engSource', 'engSrcType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('externalReferences', 'externalReferencesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, eukaryote=None, sciSpeciesName=None, sciSpeciesStrain=None, synSpeciesName=None, oligomericDetails=None, numCopies=None, recombinantExpFlag=None, natSource=None, engSource=None, details=None, externalReferences=None):
        self.original_tagname_ = None
        self.eukaryote = eukaryote
        self.sciSpeciesName = sciSpeciesName
        self.sciSpeciesStrain = sciSpeciesStrain
        self.synSpeciesName = synSpeciesName
        self.oligomericDetails = oligomericDetails
        self.numCopies = numCopies
        self.recombinantExpFlag = recombinantExpFlag
        self.natSource = natSource
        self.engSource = engSource
        self.details = details
        self.externalReferences = externalReferences
    def factory(*args_, **kwargs_):
        if riboTypeEu.subclass:
            return riboTypeEu.subclass(*args_, **kwargs_)
        else:
            return riboTypeEu(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_eukaryote(self): return self.eukaryote
    def set_eukaryote(self, eukaryote): self.eukaryote = eukaryote
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_oligomericDetails(self): return self.oligomericDetails
    def set_oligomericDetails(self, oligomericDetails): self.oligomericDetails = oligomericDetails
    def get_numCopies(self): return self.numCopies
    def set_numCopies(self, numCopies): self.numCopies = numCopies
    def get_recombinantExpFlag(self): return self.recombinantExpFlag
    def set_recombinantExpFlag(self, recombinantExpFlag): self.recombinantExpFlag = recombinantExpFlag
    def get_natSource(self): return self.natSource
    def set_natSource(self, natSource): self.natSource = natSource
    def get_engSource(self): return self.engSource
    def set_engSource(self, engSource): self.engSource = engSource
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def hasContent_(self):
        if (
            self.eukaryote is not None or
            self.sciSpeciesName is not None or
            self.sciSpeciesStrain is not None or
            self.synSpeciesName is not None or
            self.oligomericDetails is not None or
            self.numCopies is not None or
            self.recombinantExpFlag is not None or
            self.natSource is not None or
            self.engSource is not None or
            self.details is not None or
            self.externalReferences is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='riboTypeEu', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='riboTypeEu')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='riboTypeEu', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='riboTypeEu'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='riboTypeEu', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.eukaryote is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%seukaryote>%s</%seukaryote>%s' % (namespace_, self.gds_format_string(quote_xml(self.eukaryote).encode(ExternalEncoding), input_name='eukaryote'), namespace_, eol_))
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.sciSpeciesStrain is not None:
            self.sciSpeciesStrain.export(outfile, level, namespace_, name_='sciSpeciesStrain', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.oligomericDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomericDetails>%s</%soligomericDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.oligomericDetails).encode(ExternalEncoding), input_name='oligomericDetails'), namespace_, eol_))
        if self.numCopies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumCopies>%s</%snumCopies>%s' % (namespace_, self.gds_format_string(quote_xml(self.numCopies).encode(ExternalEncoding), input_name='numCopies'), namespace_, eol_))
        if self.recombinantExpFlag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinantExpFlag>%s</%srecombinantExpFlag>%s' % (namespace_, self.gds_format_boolean(self.recombinantExpFlag, input_name='recombinantExpFlag'), namespace_, eol_))
        if self.natSource is not None:
            self.natSource.export(outfile, level, namespace_, name_='natSource', pretty_print=pretty_print)
        if self.engSource is not None:
            self.engSource.export(outfile, level, namespace_, name_='engSource', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.externalReferences is not None:
            self.externalReferences.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'eukaryote':
            eukaryote_ = child_.text
            eukaryote_ = self.gds_validate_string(eukaryote_, node, 'eukaryote')
            self.eukaryote = eukaryote_
        elif nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'sciSpeciesStrain':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesStrain = obj_
            obj_.original_tagname_ = 'sciSpeciesStrain'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'oligomericDetails':
            oligomericDetails_ = child_.text
            oligomericDetails_ = self.gds_validate_string(oligomericDetails_, node, 'oligomericDetails')
            self.oligomericDetails = oligomericDetails_
        elif nodeName_ == 'numCopies':
            numCopies_ = child_.text
            numCopies_ = self.gds_validate_string(numCopies_, node, 'numCopies')
            self.numCopies = numCopies_
        elif nodeName_ == 'recombinantExpFlag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinantExpFlag')
            self.recombinantExpFlag = ival_
        elif nodeName_ == 'natSource':
            obj_ = natSrcType.factory()
            obj_.build(child_)
            self.natSource = obj_
            obj_.original_tagname_ = 'natSource'
        elif nodeName_ == 'engSource':
            obj_ = engSrcType.factory()
            obj_.build(child_)
            self.engSource = obj_
            obj_.original_tagname_ = 'engSource'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences = obj_
            obj_.original_tagname_ = 'externalReferences'
# end class riboTypeEu


class riboTypePro(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('prokaryote', 'xs:string', 0),
        MemberSpec_('sciSpeciesName', 'sciSpeciesType', 0),
        MemberSpec_('sciSpeciesStrain', 'sciSpeciesType', 0),
        MemberSpec_('synSpeciesName', 'xs:string', 0),
        MemberSpec_('oligomericDetails', 'xs:string', 0),
        MemberSpec_('numCopies', 'xs:string', 0),
        MemberSpec_('recombinantExpFlag', 'xs:boolean', 0),
        MemberSpec_('natSource', 'natSrcType', 0),
        MemberSpec_('engSource', 'engSrcType', 0),
        MemberSpec_('details', 'xs:string', 0),
        MemberSpec_('externalReferences', 'externalReferencesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, prokaryote=None, sciSpeciesName=None, sciSpeciesStrain=None, synSpeciesName=None, oligomericDetails=None, numCopies=None, recombinantExpFlag=None, natSource=None, engSource=None, details=None, externalReferences=None):
        self.original_tagname_ = None
        self.prokaryote = prokaryote
        self.sciSpeciesName = sciSpeciesName
        self.sciSpeciesStrain = sciSpeciesStrain
        self.synSpeciesName = synSpeciesName
        self.oligomericDetails = oligomericDetails
        self.numCopies = numCopies
        self.recombinantExpFlag = recombinantExpFlag
        self.natSource = natSource
        self.engSource = engSource
        self.details = details
        self.externalReferences = externalReferences
    def factory(*args_, **kwargs_):
        if riboTypePro.subclass:
            return riboTypePro.subclass(*args_, **kwargs_)
        else:
            return riboTypePro(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_prokaryote(self): return self.prokaryote
    def set_prokaryote(self, prokaryote): self.prokaryote = prokaryote
    def get_sciSpeciesName(self): return self.sciSpeciesName
    def set_sciSpeciesName(self, sciSpeciesName): self.sciSpeciesName = sciSpeciesName
    def get_sciSpeciesStrain(self): return self.sciSpeciesStrain
    def set_sciSpeciesStrain(self, sciSpeciesStrain): self.sciSpeciesStrain = sciSpeciesStrain
    def get_synSpeciesName(self): return self.synSpeciesName
    def set_synSpeciesName(self, synSpeciesName): self.synSpeciesName = synSpeciesName
    def get_oligomericDetails(self): return self.oligomericDetails
    def set_oligomericDetails(self, oligomericDetails): self.oligomericDetails = oligomericDetails
    def get_numCopies(self): return self.numCopies
    def set_numCopies(self, numCopies): self.numCopies = numCopies
    def get_recombinantExpFlag(self): return self.recombinantExpFlag
    def set_recombinantExpFlag(self, recombinantExpFlag): self.recombinantExpFlag = recombinantExpFlag
    def get_natSource(self): return self.natSource
    def set_natSource(self, natSource): self.natSource = natSource
    def get_engSource(self): return self.engSource
    def set_engSource(self, engSource): self.engSource = engSource
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def hasContent_(self):
        if (
            self.prokaryote is not None or
            self.sciSpeciesName is not None or
            self.sciSpeciesStrain is not None or
            self.synSpeciesName is not None or
            self.oligomericDetails is not None or
            self.numCopies is not None or
            self.recombinantExpFlag is not None or
            self.natSource is not None or
            self.engSource is not None or
            self.details is not None or
            self.externalReferences is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='riboTypePro', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='riboTypePro')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='riboTypePro', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='riboTypePro'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='riboTypePro', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.prokaryote is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprokaryote>%s</%sprokaryote>%s' % (namespace_, self.gds_format_string(quote_xml(self.prokaryote).encode(ExternalEncoding), input_name='prokaryote'), namespace_, eol_))
        if self.sciSpeciesName is not None:
            self.sciSpeciesName.export(outfile, level, namespace_, name_='sciSpeciesName', pretty_print=pretty_print)
        if self.sciSpeciesStrain is not None:
            self.sciSpeciesStrain.export(outfile, level, namespace_, name_='sciSpeciesStrain', pretty_print=pretty_print)
        if self.synSpeciesName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssynSpeciesName>%s</%ssynSpeciesName>%s' % (namespace_, self.gds_format_string(quote_xml(self.synSpeciesName).encode(ExternalEncoding), input_name='synSpeciesName'), namespace_, eol_))
        if self.oligomericDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soligomericDetails>%s</%soligomericDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.oligomericDetails).encode(ExternalEncoding), input_name='oligomericDetails'), namespace_, eol_))
        if self.numCopies is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumCopies>%s</%snumCopies>%s' % (namespace_, self.gds_format_string(quote_xml(self.numCopies).encode(ExternalEncoding), input_name='numCopies'), namespace_, eol_))
        if self.recombinantExpFlag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srecombinantExpFlag>%s</%srecombinantExpFlag>%s' % (namespace_, self.gds_format_boolean(self.recombinantExpFlag, input_name='recombinantExpFlag'), namespace_, eol_))
        if self.natSource is not None:
            self.natSource.export(outfile, level, namespace_, name_='natSource', pretty_print=pretty_print)
        if self.engSource is not None:
            self.engSource.export(outfile, level, namespace_, name_='engSource', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
        if self.externalReferences is not None:
            self.externalReferences.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'prokaryote':
            prokaryote_ = child_.text
            prokaryote_ = self.gds_validate_string(prokaryote_, node, 'prokaryote')
            self.prokaryote = prokaryote_
        elif nodeName_ == 'sciSpeciesName':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesName = obj_
            obj_.original_tagname_ = 'sciSpeciesName'
        elif nodeName_ == 'sciSpeciesStrain':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.sciSpeciesStrain = obj_
            obj_.original_tagname_ = 'sciSpeciesStrain'
        elif nodeName_ == 'synSpeciesName':
            synSpeciesName_ = child_.text
            synSpeciesName_ = self.gds_validate_string(synSpeciesName_, node, 'synSpeciesName')
            self.synSpeciesName = synSpeciesName_
        elif nodeName_ == 'oligomericDetails':
            oligomericDetails_ = child_.text
            oligomericDetails_ = self.gds_validate_string(oligomericDetails_, node, 'oligomericDetails')
            self.oligomericDetails = oligomericDetails_
        elif nodeName_ == 'numCopies':
            numCopies_ = child_.text
            numCopies_ = self.gds_validate_string(numCopies_, node, 'numCopies')
            self.numCopies = numCopies_
        elif nodeName_ == 'recombinantExpFlag':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'recombinantExpFlag')
            self.recombinantExpFlag = ival_
        elif nodeName_ == 'natSource':
            obj_ = natSrcType.factory()
            obj_.build(child_)
            self.natSource = obj_
            obj_.original_tagname_ = 'natSource'
        elif nodeName_ == 'engSource':
            obj_ = engSrcType.factory()
            obj_.build(child_)
            self.engSource = obj_
            obj_.original_tagname_ = 'engSource'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences = obj_
            obj_.original_tagname_ = 'externalReferences'
# end class riboTypePro


class sciSpeciesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('ncbiTaxId', 'xs:integer', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, ncbiTaxId=None, valueOf_=None):
        self.original_tagname_ = None
        self.ncbiTaxId = _cast(int, ncbiTaxId)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if sciSpeciesType.subclass:
            return sciSpeciesType.subclass(*args_, **kwargs_)
        else:
            return sciSpeciesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ncbiTaxId(self): return self.ncbiTaxId
    def set_ncbiTaxId(self, ncbiTaxId): self.ncbiTaxId = ncbiTaxId
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sciSpeciesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sciSpeciesType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='sciSpeciesType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sciSpeciesType'):
        if self.ncbiTaxId is not None and 'ncbiTaxId' not in already_processed:
            already_processed.add('ncbiTaxId')
            outfile.write(' ncbiTaxId="%s"' % self.gds_format_integer(self.ncbiTaxId, input_name='ncbiTaxId'))
    def exportChildren(self, outfile, level, namespace_='', name_='sciSpeciesType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ncbiTaxId', node)
        if value is not None and 'ncbiTaxId' not in already_processed:
            already_processed.add('ncbiTaxId')
            try:
                self.ncbiTaxId = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class sciSpeciesType


class externalReferencesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('refUniProt', ['uniProtType', 'xs:string'], 1),
        MemberSpec_('refGo', ['goIdType', 'xs:string'], 1),
        MemberSpec_('refInterpro', ['iprIdType', 'xs:string'], 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, refUniProt=None, refGo=None, refInterpro=None):
        self.original_tagname_ = None
        if refUniProt is None:
            self.refUniProt = []
        else:
            self.refUniProt = refUniProt
        if refGo is None:
            self.refGo = []
        else:
            self.refGo = refGo
        if refInterpro is None:
            self.refInterpro = []
        else:
            self.refInterpro = refInterpro
    def factory(*args_, **kwargs_):
        if externalReferencesType.subclass:
            return externalReferencesType.subclass(*args_, **kwargs_)
        else:
            return externalReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_refUniProt(self): return self.refUniProt
    def set_refUniProt(self, refUniProt): self.refUniProt = refUniProt
    def add_refUniProt(self, value): self.refUniProt.append(value)
    def insert_refUniProt_at(self, index, value): self.refUniProt.insert(index, value)
    def replace_refUniProt_at(self, index, value): self.refUniProt[index] = value
    def get_refGo(self): return self.refGo
    def set_refGo(self, refGo): self.refGo = refGo
    def add_refGo(self, value): self.refGo.append(value)
    def insert_refGo_at(self, index, value): self.refGo.insert(index, value)
    def replace_refGo_at(self, index, value): self.refGo[index] = value
    def get_refInterpro(self): return self.refInterpro
    def set_refInterpro(self, refInterpro): self.refInterpro = refInterpro
    def add_refInterpro(self, value): self.refInterpro.append(value)
    def insert_refInterpro_at(self, index, value): self.refInterpro.insert(index, value)
    def replace_refInterpro_at(self, index, value): self.refInterpro[index] = value
    def validate_uniProtType(self, value):
        # Validate type uniProtType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_uniProtType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_uniProtType_patterns_, ))
    validate_uniProtType_patterns_ = [['^[A-Z][\\dA-Z]{5}$']]
    def validate_goIdType(self, value):
        # Validate type goIdType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_goIdType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_goIdType_patterns_, ))
    validate_goIdType_patterns_ = [['^GO:\\d{7}$']]
    def validate_iprIdType(self, value):
        # Validate type iprIdType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_iprIdType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_iprIdType_patterns_, ))
    validate_iprIdType_patterns_ = [['^IPR\\d{6}$']]
    def hasContent_(self):
        if (
            self.refUniProt or
            self.refGo or
            self.refInterpro
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalReferencesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalReferencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalReferencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalReferencesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='externalReferencesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for refUniProt_ in self.refUniProt:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefUniProt>%s</%srefUniProt>%s' % (namespace_, self.gds_format_string(quote_xml(refUniProt_).encode(ExternalEncoding), input_name='refUniProt'), namespace_, eol_))
        for refGo_ in self.refGo:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefGo>%s</%srefGo>%s' % (namespace_, self.gds_format_string(quote_xml(refGo_).encode(ExternalEncoding), input_name='refGo'), namespace_, eol_))
        for refInterpro_ in self.refInterpro:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefInterpro>%s</%srefInterpro>%s' % (namespace_, self.gds_format_string(quote_xml(refInterpro_).encode(ExternalEncoding), input_name='refInterpro'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'refUniProt':
            refUniProt_ = child_.text
            refUniProt_ = self.gds_validate_string(refUniProt_, node, 'refUniProt')
            self.refUniProt.append(refUniProt_)
            # validate type uniProtType
            self.validate_uniProtType(self.refUniProt[-1])
        elif nodeName_ == 'refGo':
            refGo_ = child_.text
            refGo_ = self.gds_validate_string(refGo_, node, 'refGo')
            self.refGo.append(refGo_)
            # validate type goIdType
            self.validate_goIdType(self.refGo[-1])
        elif nodeName_ == 'refInterpro':
            refInterpro_ = child_.text
            refInterpro_ = self.gds_validate_string(refInterpro_, node, 'refInterpro')
            self.refInterpro.append(refInterpro_)
            # validate type iprIdType
            self.validate_iprIdType(self.refInterpro[-1])
# end class externalReferencesType


class natSrcVirusType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('hostCategory', ['hostCategoryType', 'xs:string'], 0),
        MemberSpec_('hostSpecies', 'sciSpeciesType', 0),
        MemberSpec_('hostSpeciesStrain', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, hostCategory=None, hostSpecies=None, hostSpeciesStrain=None):
        self.original_tagname_ = None
        self.hostCategory = hostCategory
        self.validate_hostCategoryType(self.hostCategory)
        self.hostSpecies = hostSpecies
        self.hostSpeciesStrain = hostSpeciesStrain
    def factory(*args_, **kwargs_):
        if natSrcVirusType.subclass:
            return natSrcVirusType.subclass(*args_, **kwargs_)
        else:
            return natSrcVirusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_hostCategory(self): return self.hostCategory
    def set_hostCategory(self, hostCategory): self.hostCategory = hostCategory
    def get_hostSpecies(self): return self.hostSpecies
    def set_hostSpecies(self, hostSpecies): self.hostSpecies = hostSpecies
    def get_hostSpeciesStrain(self): return self.hostSpeciesStrain
    def set_hostSpeciesStrain(self, hostSpeciesStrain): self.hostSpeciesStrain = hostSpeciesStrain
    def validate_hostCategoryType(self, value):
        # Validate type hostCategoryType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ARCHAEA', 'ALGAE', 'BACTERIA(EUBACTERIA)', 'FUNGI', 'INVERTEBRATES', 'PLANTAE(HIGHER PLANTS)', 'VERTEBRATES', 'PROTOZOA']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on hostCategoryType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.hostCategory is not None or
            self.hostSpecies is not None or
            self.hostSpeciesStrain is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='natSrcVirusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='natSrcVirusType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='natSrcVirusType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='natSrcVirusType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='natSrcVirusType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.hostCategory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shostCategory>%s</%shostCategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.hostCategory).encode(ExternalEncoding), input_name='hostCategory'), namespace_, eol_))
        if self.hostSpecies is not None:
            self.hostSpecies.export(outfile, level, namespace_, name_='hostSpecies', pretty_print=pretty_print)
        if self.hostSpeciesStrain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shostSpeciesStrain>%s</%shostSpeciesStrain>%s' % (namespace_, self.gds_format_string(quote_xml(self.hostSpeciesStrain).encode(ExternalEncoding), input_name='hostSpeciesStrain'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'hostCategory':
            hostCategory_ = child_.text
            hostCategory_ = self.gds_validate_string(hostCategory_, node, 'hostCategory')
            self.hostCategory = hostCategory_
            # validate type hostCategoryType
            self.validate_hostCategoryType(self.hostCategory)
        elif nodeName_ == 'hostSpecies':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.hostSpecies = obj_
            obj_.original_tagname_ = 'hostSpecies'
        elif nodeName_ == 'hostSpeciesStrain':
            hostSpeciesStrain_ = child_.text
            hostSpeciesStrain_ = self.gds_validate_string(hostSpeciesStrain_, node, 'hostSpeciesStrain')
            self.hostSpeciesStrain = hostSpeciesStrain_
# end class natSrcVirusType


class natSrcType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('cell', 'xs:string', 0),
        MemberSpec_('organelle', 'xs:string', 0),
        MemberSpec_('organOrTissue', 'xs:string', 0),
        MemberSpec_('cellLocation', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, cell=None, organelle=None, organOrTissue=None, cellLocation=None):
        self.original_tagname_ = None
        self.cell = cell
        self.organelle = organelle
        self.organOrTissue = organOrTissue
        self.cellLocation = cellLocation
    def factory(*args_, **kwargs_):
        if natSrcType.subclass:
            return natSrcType.subclass(*args_, **kwargs_)
        else:
            return natSrcType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def get_organelle(self): return self.organelle
    def set_organelle(self, organelle): self.organelle = organelle
    def get_organOrTissue(self): return self.organOrTissue
    def set_organOrTissue(self, organOrTissue): self.organOrTissue = organOrTissue
    def get_cellLocation(self): return self.cellLocation
    def set_cellLocation(self, cellLocation): self.cellLocation = cellLocation
    def hasContent_(self):
        if (
            self.cell is not None or
            self.organelle is not None or
            self.organOrTissue is not None or
            self.cellLocation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='natSrcType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='natSrcType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='natSrcType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='natSrcType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='natSrcType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scell>%s</%scell>%s' % (namespace_, self.gds_format_string(quote_xml(self.cell).encode(ExternalEncoding), input_name='cell'), namespace_, eol_))
        if self.organelle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganelle>%s</%sorganelle>%s' % (namespace_, self.gds_format_string(quote_xml(self.organelle).encode(ExternalEncoding), input_name='organelle'), namespace_, eol_))
        if self.organOrTissue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganOrTissue>%s</%sorganOrTissue>%s' % (namespace_, self.gds_format_string(quote_xml(self.organOrTissue).encode(ExternalEncoding), input_name='organOrTissue'), namespace_, eol_))
        if self.cellLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scellLocation>%s</%scellLocation>%s' % (namespace_, self.gds_format_string(quote_xml(self.cellLocation).encode(ExternalEncoding), input_name='cellLocation'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cell':
            cell_ = child_.text
            cell_ = self.gds_validate_string(cell_, node, 'cell')
            self.cell = cell_
        elif nodeName_ == 'organelle':
            organelle_ = child_.text
            organelle_ = self.gds_validate_string(organelle_, node, 'organelle')
            self.organelle = organelle_
        elif nodeName_ == 'organOrTissue':
            organOrTissue_ = child_.text
            organOrTissue_ = self.gds_validate_string(organOrTissue_, node, 'organOrTissue')
            self.organOrTissue = organOrTissue_
        elif nodeName_ == 'cellLocation':
            cellLocation_ = child_.text
            cellLocation_ = self.gds_validate_string(cellLocation_, node, 'cellLocation')
            self.cellLocation = cellLocation_
# end class natSrcType


class engSrcType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('expSystem', 'sciSpeciesType', 0),
        MemberSpec_('expSystemStrain', 'xs:string', 0),
        MemberSpec_('expSystemCell', 'xs:string', 0),
        MemberSpec_('vector', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, expSystem=None, expSystemStrain=None, expSystemCell=None, vector=None):
        self.original_tagname_ = None
        self.expSystem = expSystem
        self.expSystemStrain = expSystemStrain
        self.expSystemCell = expSystemCell
        self.vector = vector
    def factory(*args_, **kwargs_):
        if engSrcType.subclass:
            return engSrcType.subclass(*args_, **kwargs_)
        else:
            return engSrcType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_expSystem(self): return self.expSystem
    def set_expSystem(self, expSystem): self.expSystem = expSystem
    def get_expSystemStrain(self): return self.expSystemStrain
    def set_expSystemStrain(self, expSystemStrain): self.expSystemStrain = expSystemStrain
    def get_expSystemCell(self): return self.expSystemCell
    def set_expSystemCell(self, expSystemCell): self.expSystemCell = expSystemCell
    def get_vector(self): return self.vector
    def set_vector(self, vector): self.vector = vector
    def hasContent_(self):
        if (
            self.expSystem is not None or
            self.expSystemStrain is not None or
            self.expSystemCell is not None or
            self.vector is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='engSrcType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='engSrcType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='engSrcType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='engSrcType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='engSrcType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.expSystem is not None:
            self.expSystem.export(outfile, level, namespace_, name_='expSystem', pretty_print=pretty_print)
        if self.expSystemStrain is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpSystemStrain>%s</%sexpSystemStrain>%s' % (namespace_, self.gds_format_string(quote_xml(self.expSystemStrain).encode(ExternalEncoding), input_name='expSystemStrain'), namespace_, eol_))
        if self.expSystemCell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpSystemCell>%s</%sexpSystemCell>%s' % (namespace_, self.gds_format_string(quote_xml(self.expSystemCell).encode(ExternalEncoding), input_name='expSystemCell'), namespace_, eol_))
        if self.vector is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svector>%s</%svector>%s' % (namespace_, self.gds_format_string(quote_xml(self.vector).encode(ExternalEncoding), input_name='vector'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'expSystem':
            obj_ = sciSpeciesType.factory()
            obj_.build(child_)
            self.expSystem = obj_
            obj_.original_tagname_ = 'expSystem'
        elif nodeName_ == 'expSystemStrain':
            expSystemStrain_ = child_.text
            expSystemStrain_ = self.gds_validate_string(expSystemStrain_, node, 'expSystemStrain')
            self.expSystemStrain = expSystemStrain_
        elif nodeName_ == 'expSystemCell':
            expSystemCell_ = child_.text
            expSystemCell_ = self.gds_validate_string(expSystemCell_, node, 'expSystemCell')
            self.expSystemCell = expSystemCell_
        elif nodeName_ == 'vector':
            vector_ = child_.text
            vector_ = self.gds_validate_string(vector_, node, 'vector')
            self.vector = vector_
# end class engSrcType


class bufferType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('ph', 'xs:float', 0),
        MemberSpec_('details', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, ph=None, details=None):
        self.original_tagname_ = None
        self.ph = ph
        self.details = details
    def factory(*args_, **kwargs_):
        if bufferType.subclass:
            return bufferType.subclass(*args_, **kwargs_)
        else:
            return bufferType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ph(self): return self.ph
    def set_ph(self, ph): self.ph = ph
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def hasContent_(self):
        if (
            self.ph is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='bufferType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='bufferType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='bufferType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='bufferType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='bufferType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ph is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sph>%s</%sph>%s' % (namespace_, self.gds_format_float(self.ph, input_name='ph'), namespace_, eol_))
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.details).encode(ExternalEncoding), input_name='details'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ph':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'ph')
            self.ph = fval_
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class bufferType


class mwType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if mwType.subclass:
            return mwType.subclass(*args_, **kwargs_)
        else:
            return mwType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='mwType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mwType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='mwType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mwType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='mwType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class mwType


class samplConcType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if samplConcType.subclass:
            return samplConcType.subclass(*args_, **kwargs_)
        else:
            return samplConcType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='samplConcType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='samplConcType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='samplConcType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='samplConcType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='samplConcType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class samplConcType


class tempType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if tempType.subclass:
            return tempType.subclass(*args_, **kwargs_)
        else:
            return tempType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tempType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tempType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tempType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tempType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='tempType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class tempType


class crystSizeType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if crystSizeType.subclass:
            return crystSizeType.subclass(*args_, **kwargs_)
        else:
            return crystSizeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crystSizeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crystSizeType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crystSizeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crystSizeType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='crystSizeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class crystSizeType


class lengthType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if lengthType.subclass:
            return lengthType.subclass(*args_, **kwargs_)
        else:
            return lengthType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='lengthType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='lengthType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='lengthType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='lengthType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='lengthType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class lengthType


class origType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if origType.subclass:
            return origType.subclass(*args_, **kwargs_)
        else:
            return origType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='origType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='origType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='origType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='origType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='origType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class origType


class diamType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', ['floatOrNAType', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if diamType.subclass:
            return diamType.subclass(*args_, **kwargs_)
        else:
            return diamType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='diamType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='diamType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='diamType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='diamType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='diamType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class diamType


class anglType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if anglType.subclass:
            return anglType.subclass(*args_, **kwargs_)
        else:
            return anglType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='anglType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='anglType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='anglType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='anglType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='anglType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class anglType


class samplSizeType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if samplSizeType.subclass:
            return samplSizeType.subclass(*args_, **kwargs_)
        else:
            return samplSizeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='samplSizeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='samplSizeType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='samplSizeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='samplSizeType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='samplSizeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class samplSizeType


class accVoltType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if accVoltType.subclass:
            return accVoltType.subclass(*args_, **kwargs_)
        else:
            return accVoltType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='accVoltType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='accVoltType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='accVoltType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='accVoltType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='accVoltType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class accVoltType


class csType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if csType.subclass:
            return csType.subclass(*args_, **kwargs_)
        else:
            return csType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='csType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='csType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='csType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='csType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='csType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class csType


class eDoseType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if eDoseType.subclass:
            return eDoseType.subclass(*args_, **kwargs_)
        else:
            return eDoseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='eDoseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='eDoseType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='eDoseType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='eDoseType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='eDoseType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class eDoseType


class eWindowType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if eWindowType.subclass:
            return eWindowType.subclass(*args_, **kwargs_)
        else:
            return eWindowType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='eWindowType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='eWindowType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='eWindowType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='eWindowType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='eWindowType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
    def gds_format_float(self,input_data, input_name="" ):
        return ("%g" % input_data)
# end class eWindowType


class defocusType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', ['defocusAllowed', 'xs:float'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if defocusType.subclass:
            return defocusType.subclass(*args_, **kwargs_)
        else:
            return defocusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='defocusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='defocusType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='defocusType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='defocusType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='defocusType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class defocusType


class tiltType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if tiltType.subclass:
            return tiltType.subclass(*args_, **kwargs_)
        else:
            return tiltType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tiltType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tiltType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='tiltType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tiltType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='tiltType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class tiltType


class mapFileType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sizeKb', 'xs:positiveInteger', 0),
        MemberSpec_('type', 'xs:string', 0),
        MemberSpec_('format', 'xs:string', 0),
        MemberSpec_('valueOf_', ['mapNamePattern', 'xs:token'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sizeKb=None, type_=None, format=None, valueOf_=None):
        self.original_tagname_ = None
        self.sizeKb = _cast(int, sizeKb)
        self.type_ = _cast(None, type_)
        self.format = _cast(None, format)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if mapFileType.subclass:
            return mapFileType.subclass(*args_, **kwargs_)
        else:
            return mapFileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sizeKb(self): return self.sizeKb
    def set_sizeKb(self, sizeKb): self.sizeKb = sizeKb
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='mapFileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mapFileType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='mapFileType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mapFileType'):
        if self.sizeKb is not None and 'sizeKb' not in already_processed:
            already_processed.add('sizeKb')
            outfile.write(' sizeKb="%s"' % self.gds_format_integer(self.sizeKb, input_name='sizeKb'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (self.gds_format_string(quote_attrib(self.format).encode(ExternalEncoding), input_name='format'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='mapFileType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sizeKb', node)
        if value is not None and 'sizeKb' not in already_processed:
            already_processed.add('sizeKb')
            try:
                self.sizeKb = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.sizeKb <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class mapFileType


class mskFileType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sizeKb', 'xs:positiveInteger', 0),
        MemberSpec_('type', 'xs:string', 0),
        MemberSpec_('format', 'xs:string', 0),
        MemberSpec_('valueOf_', ['maskNamePattern', 'xs:token'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sizeKb=None, type_=None, format=None, valueOf_=None):
        self.original_tagname_ = None
        self.sizeKb = _cast(int, sizeKb)
        self.type_ = _cast(None, type_)
        self.format = _cast(None, format)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if mskFileType.subclass:
            return mskFileType.subclass(*args_, **kwargs_)
        else:
            return mskFileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sizeKb(self): return self.sizeKb
    def set_sizeKb(self, sizeKb): self.sizeKb = sizeKb
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='mskFileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='mskFileType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='mskFileType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='mskFileType'):
        if self.sizeKb is not None and 'sizeKb' not in already_processed:
            already_processed.add('sizeKb')
            outfile.write(' sizeKb="%s"' % self.gds_format_integer(self.sizeKb, input_name='sizeKb'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (self.gds_format_string(quote_attrib(self.format).encode(ExternalEncoding), input_name='format'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='mskFileType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sizeKb', node)
        if value is not None and 'sizeKb' not in already_processed:
            already_processed.add('sizeKb')
            try:
                self.sizeKb = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.sizeKb <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class mskFileType


class slcFileType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('sizeKb', 'xs:positiveInteger', 0),
        MemberSpec_('type', 'xs:string', 0),
        MemberSpec_('format', 'xs:string', 0),
        MemberSpec_('valueOf_', ['slcNamePattern', 'xs:token'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, sizeKb=None, type_=None, format=None, valueOf_=None):
        self.original_tagname_ = None
        self.sizeKb = _cast(int, sizeKb)
        self.type_ = _cast(None, type_)
        self.format = _cast(None, format)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if slcFileType.subclass:
            return slcFileType.subclass(*args_, **kwargs_)
        else:
            return slcFileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sizeKb(self): return self.sizeKb
    def set_sizeKb(self, sizeKb): self.sizeKb = sizeKb
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcFileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcFileType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcFileType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcFileType'):
        if self.sizeKb is not None and 'sizeKb' not in already_processed:
            already_processed.add('sizeKb')
            outfile.write(' sizeKb="%s"' % self.gds_format_integer(self.sizeKb, input_name='sizeKb'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (self.gds_format_string(quote_attrib(self.format).encode(ExternalEncoding), input_name='format'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='slcFileType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sizeKb', node)
        if value is not None and 'sizeKb' not in already_processed:
            already_processed.add('sizeKb')
            try:
                self.sizeKb = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.sizeKb <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class slcFileType


class axisOrderType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('axisOrderFast', 'xs:string', 0),
        MemberSpec_('axisOrderMedium', 'xs:string', 0),
        MemberSpec_('axisOrderSlow', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, axisOrderFast=None, axisOrderMedium=None, axisOrderSlow=None):
        self.original_tagname_ = None
        self.axisOrderFast = axisOrderFast
        self.axisOrderMedium = axisOrderMedium
        self.axisOrderSlow = axisOrderSlow
    def factory(*args_, **kwargs_):
        if axisOrderType.subclass:
            return axisOrderType.subclass(*args_, **kwargs_)
        else:
            return axisOrderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_axisOrderFast(self): return self.axisOrderFast
    def set_axisOrderFast(self, axisOrderFast): self.axisOrderFast = axisOrderFast
    def get_axisOrderMedium(self): return self.axisOrderMedium
    def set_axisOrderMedium(self, axisOrderMedium): self.axisOrderMedium = axisOrderMedium
    def get_axisOrderSlow(self): return self.axisOrderSlow
    def set_axisOrderSlow(self, axisOrderSlow): self.axisOrderSlow = axisOrderSlow
    def hasContent_(self):
        if (
            self.axisOrderFast is not None or
            self.axisOrderMedium is not None or
            self.axisOrderSlow is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='axisOrderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='axisOrderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='axisOrderType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='axisOrderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='axisOrderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.axisOrderFast is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saxisOrderFast>%s</%saxisOrderFast>%s' % (namespace_, self.gds_format_string(quote_xml(self.axisOrderFast).encode(ExternalEncoding), input_name='axisOrderFast'), namespace_, eol_))
        if self.axisOrderMedium is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saxisOrderMedium>%s</%saxisOrderMedium>%s' % (namespace_, self.gds_format_string(quote_xml(self.axisOrderMedium).encode(ExternalEncoding), input_name='axisOrderMedium'), namespace_, eol_))
        if self.axisOrderSlow is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saxisOrderSlow>%s</%saxisOrderSlow>%s' % (namespace_, self.gds_format_string(quote_xml(self.axisOrderSlow).encode(ExternalEncoding), input_name='axisOrderSlow'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'axisOrderFast':
            axisOrderFast_ = child_.text
            axisOrderFast_ = self.gds_validate_string(axisOrderFast_, node, 'axisOrderFast')
            self.axisOrderFast = axisOrderFast_
        elif nodeName_ == 'axisOrderMedium':
            axisOrderMedium_ = child_.text
            axisOrderMedium_ = self.gds_validate_string(axisOrderMedium_, node, 'axisOrderMedium')
            self.axisOrderMedium = axisOrderMedium_
        elif nodeName_ == 'axisOrderSlow':
            axisOrderSlow_ = child_.text
            axisOrderSlow_ = self.gds_validate_string(axisOrderSlow_, node, 'axisOrderSlow')
            self.axisOrderSlow = axisOrderSlow_
# end class axisOrderType


class dimensionType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('numRows', 'xs:positiveInteger', 0),
        MemberSpec_('numColumns', 'xs:positiveInteger', 0),
        MemberSpec_('numSections', 'xs:positiveInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, numRows=None, numColumns=None, numSections=None):
        self.original_tagname_ = None
        self.numRows = numRows
        self.numColumns = numColumns
        self.numSections = numSections
    def factory(*args_, **kwargs_):
        if dimensionType.subclass:
            return dimensionType.subclass(*args_, **kwargs_)
        else:
            return dimensionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numRows(self): return self.numRows
    def set_numRows(self, numRows): self.numRows = numRows
    def get_numColumns(self): return self.numColumns
    def set_numColumns(self, numColumns): self.numColumns = numColumns
    def get_numSections(self): return self.numSections
    def set_numSections(self, numSections): self.numSections = numSections
    def hasContent_(self):
        if (
            self.numRows is not None or
            self.numColumns is not None or
            self.numSections is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='dimensionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='dimensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='dimensionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='dimensionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='dimensionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.numRows is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumRows>%s</%snumRows>%s' % (namespace_, self.gds_format_integer(self.numRows, input_name='numRows'), namespace_, eol_))
        if self.numColumns is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumColumns>%s</%snumColumns>%s' % (namespace_, self.gds_format_integer(self.numColumns, input_name='numColumns'), namespace_, eol_))
        if self.numSections is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumSections>%s</%snumSections>%s' % (namespace_, self.gds_format_integer(self.numSections, input_name='numSections'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'numRows':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numRows')
            self.numRows = ival_
        elif nodeName_ == 'numColumns':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numColumns')
            self.numColumns = ival_
        elif nodeName_ == 'numSections':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numSections')
            self.numSections = ival_
# end class dimensionType


class slcDimensionType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('numRows', 'xs:positiveInteger', 0),
        MemberSpec_('numColumns', 'xs:nonNegativeInteger', 0),
        MemberSpec_('numSections', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, numRows=None, numColumns=None, numSections=None):
        self.original_tagname_ = None
        self.numRows = numRows
        self.numColumns = numColumns
        self.numSections = numSections
    def factory(*args_, **kwargs_):
        if slcDimensionType.subclass:
            return slcDimensionType.subclass(*args_, **kwargs_)
        else:
            return slcDimensionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_numRows(self): return self.numRows
    def set_numRows(self, numRows): self.numRows = numRows
    def get_numColumns(self): return self.numColumns
    def set_numColumns(self, numColumns): self.numColumns = numColumns
    def get_numSections(self): return self.numSections
    def set_numSections(self, numSections): self.numSections = numSections
    def hasContent_(self):
        if (
            self.numRows is not None or
            self.numColumns is not None or
            self.numSections is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcDimensionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcDimensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcDimensionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcDimensionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='slcDimensionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.numRows is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumRows>%s</%snumRows>%s' % (namespace_, self.gds_format_integer(self.numRows, input_name='numRows'), namespace_, eol_))
        if self.numColumns is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumColumns>%s</%snumColumns>%s' % (namespace_, self.gds_format_integer(self.numColumns, input_name='numColumns'), namespace_, eol_))
        if self.numSections is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumSections>%s</%snumSections>%s' % (namespace_, self.gds_format_integer(self.numSections, input_name='numSections'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'numRows':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numRows')
            self.numRows = ival_
        elif nodeName_ == 'numColumns':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numColumns')
            self.numColumns = ival_
        elif nodeName_ == 'numSections':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numSections')
            self.numSections = ival_
# end class slcDimensionType


class spacingType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('spacingRow', 'xs:positiveInteger', 0),
        MemberSpec_('spacingCol', 'xs:positiveInteger', 0),
        MemberSpec_('spacingSec', 'xs:positiveInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, spacingRow=None, spacingCol=None, spacingSec=None):
        self.original_tagname_ = None
        self.spacingRow = spacingRow
        self.spacingCol = spacingCol
        self.spacingSec = spacingSec
    def factory(*args_, **kwargs_):
        if spacingType.subclass:
            return spacingType.subclass(*args_, **kwargs_)
        else:
            return spacingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_spacingRow(self): return self.spacingRow
    def set_spacingRow(self, spacingRow): self.spacingRow = spacingRow
    def get_spacingCol(self): return self.spacingCol
    def set_spacingCol(self, spacingCol): self.spacingCol = spacingCol
    def get_spacingSec(self): return self.spacingSec
    def set_spacingSec(self, spacingSec): self.spacingSec = spacingSec
    def hasContent_(self):
        if (
            self.spacingRow is not None or
            self.spacingCol is not None or
            self.spacingSec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='spacingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='spacingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='spacingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='spacingType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='spacingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.spacingRow is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspacingRow>%s</%sspacingRow>%s' % (namespace_, self.gds_format_integer(self.spacingRow, input_name='spacingRow'), namespace_, eol_))
        if self.spacingCol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspacingCol>%s</%sspacingCol>%s' % (namespace_, self.gds_format_integer(self.spacingCol, input_name='spacingCol'), namespace_, eol_))
        if self.spacingSec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspacingSec>%s</%sspacingSec>%s' % (namespace_, self.gds_format_integer(self.spacingSec, input_name='spacingSec'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'spacingRow':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'spacingRow')
            self.spacingRow = ival_
        elif nodeName_ == 'spacingCol':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'spacingCol')
            self.spacingCol = ival_
        elif nodeName_ == 'spacingSec':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'spacingSec')
            self.spacingSec = ival_
# end class spacingType


class slcSpacingType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('spacingRow', 'xs:positiveInteger', 0),
        MemberSpec_('spacingCol', 'xs:nonNegativeInteger', 0),
        MemberSpec_('spacingSec', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, spacingRow=None, spacingCol=None, spacingSec=None):
        self.original_tagname_ = None
        self.spacingRow = spacingRow
        self.spacingCol = spacingCol
        self.spacingSec = spacingSec
    def factory(*args_, **kwargs_):
        if slcSpacingType.subclass:
            return slcSpacingType.subclass(*args_, **kwargs_)
        else:
            return slcSpacingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_spacingRow(self): return self.spacingRow
    def set_spacingRow(self, spacingRow): self.spacingRow = spacingRow
    def get_spacingCol(self): return self.spacingCol
    def set_spacingCol(self, spacingCol): self.spacingCol = spacingCol
    def get_spacingSec(self): return self.spacingSec
    def set_spacingSec(self, spacingSec): self.spacingSec = spacingSec
    def hasContent_(self):
        if (
            self.spacingRow is not None or
            self.spacingCol is not None or
            self.spacingSec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcSpacingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcSpacingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcSpacingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcSpacingType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='slcSpacingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.spacingRow is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspacingRow>%s</%sspacingRow>%s' % (namespace_, self.gds_format_integer(self.spacingRow, input_name='spacingRow'), namespace_, eol_))
        if self.spacingCol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspacingCol>%s</%sspacingCol>%s' % (namespace_, self.gds_format_integer(self.spacingCol, input_name='spacingCol'), namespace_, eol_))
        if self.spacingSec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspacingSec>%s</%sspacingSec>%s' % (namespace_, self.gds_format_integer(self.spacingSec, input_name='spacingSec'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'spacingRow':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'spacingRow')
            self.spacingRow = ival_
        elif nodeName_ == 'spacingCol':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'spacingCol')
            self.spacingCol = ival_
        elif nodeName_ == 'spacingSec':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'spacingSec')
            self.spacingSec = ival_
# end class slcSpacingType


class pixelSpacingType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('pixelX', 'pixType', 0),
        MemberSpec_('pixelY', 'pixType', 0),
        MemberSpec_('pixelZ', 'pixType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, pixelX=None, pixelY=None, pixelZ=None):
        self.original_tagname_ = None
        self.pixelX = pixelX
        self.pixelY = pixelY
        self.pixelZ = pixelZ
    def factory(*args_, **kwargs_):
        if pixelSpacingType.subclass:
            return pixelSpacingType.subclass(*args_, **kwargs_)
        else:
            return pixelSpacingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pixelX(self): return self.pixelX
    def set_pixelX(self, pixelX): self.pixelX = pixelX
    def get_pixelY(self): return self.pixelY
    def set_pixelY(self, pixelY): self.pixelY = pixelY
    def get_pixelZ(self): return self.pixelZ
    def set_pixelZ(self, pixelZ): self.pixelZ = pixelZ
    def hasContent_(self):
        if (
            self.pixelX is not None or
            self.pixelY is not None or
            self.pixelZ is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pixelSpacingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pixelSpacingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pixelSpacingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pixelSpacingType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pixelSpacingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.pixelX is not None:
            self.pixelX.export(outfile, level, namespace_, name_='pixelX', pretty_print=pretty_print)
        if self.pixelY is not None:
            self.pixelY.export(outfile, level, namespace_, name_='pixelY', pretty_print=pretty_print)
        if self.pixelZ is not None:
            self.pixelZ.export(outfile, level, namespace_, name_='pixelZ', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pixelX':
            obj_ = pixType.factory()
            obj_.build(child_)
            self.pixelX = obj_
            obj_.original_tagname_ = 'pixelX'
        elif nodeName_ == 'pixelY':
            obj_ = pixType.factory()
            obj_.build(child_)
            self.pixelY = obj_
            obj_.original_tagname_ = 'pixelY'
        elif nodeName_ == 'pixelZ':
            obj_ = pixType.factory()
            obj_.build(child_)
            self.pixelZ = obj_
            obj_.original_tagname_ = 'pixelZ'
# end class pixelSpacingType


class originType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('originRow', 'xs:float', 0),
        MemberSpec_('originCol', 'xs:float', 0),
        MemberSpec_('originSec', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, originRow=None, originCol=None, originSec=None):
        self.original_tagname_ = None
        self.originRow = originRow
        self.originCol = originCol
        self.originSec = originSec
    def factory(*args_, **kwargs_):
        if originType.subclass:
            return originType.subclass(*args_, **kwargs_)
        else:
            return originType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_originRow(self): return self.originRow
    def set_originRow(self, originRow): self.originRow = originRow
    def get_originCol(self): return self.originCol
    def set_originCol(self, originCol): self.originCol = originCol
    def get_originSec(self): return self.originSec
    def set_originSec(self, originSec): self.originSec = originSec
    def hasContent_(self):
        if (
            self.originRow is not None or
            self.originCol is not None or
            self.originSec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='originType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='originType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='originType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='originType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='originType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.originRow is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soriginRow>%s</%soriginRow>%s' % (namespace_, self.gds_format_float(self.originRow, input_name='originRow'), namespace_, eol_))
        if self.originCol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soriginCol>%s</%soriginCol>%s' % (namespace_, self.gds_format_float(self.originCol, input_name='originCol'), namespace_, eol_))
        if self.originSec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soriginSec>%s</%soriginSec>%s' % (namespace_, self.gds_format_float(self.originSec, input_name='originSec'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'originRow':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'originRow')
            self.originRow = fval_
        elif nodeName_ == 'originCol':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'originCol')
            self.originCol = fval_
        elif nodeName_ == 'originSec':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'originSec')
            self.originSec = fval_
    def gds_format_float(self,input_data, input_name="" ):
        return ("%g" % input_data)
# end class originType


class statisticsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('minimum', 'xs:float', 0),
        MemberSpec_('maximum', 'xs:float', 0),
        MemberSpec_('average', 'xs:float', 0),
        MemberSpec_('std', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, minimum=None, maximum=None, average=None, std=None):
        self.original_tagname_ = None
        self.minimum = minimum
        self.maximum = maximum
        self.average = average
        self.std = std
    def factory(*args_, **kwargs_):
        if statisticsType.subclass:
            return statisticsType.subclass(*args_, **kwargs_)
        else:
            return statisticsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_minimum(self): return self.minimum
    def set_minimum(self, minimum): self.minimum = minimum
    def get_maximum(self): return self.maximum
    def set_maximum(self, maximum): self.maximum = maximum
    def get_average(self): return self.average
    def set_average(self, average): self.average = average
    def get_std(self): return self.std
    def set_std(self, std): self.std = std
    def hasContent_(self):
        if (
            self.minimum is not None or
            self.maximum is not None or
            self.average is not None or
            self.std is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='statisticsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='statisticsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='statisticsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='statisticsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='statisticsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.minimum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sminimum>%s</%sminimum>%s' % (namespace_, self.gds_format_float(self.minimum, input_name='minimum'), namespace_, eol_))
        if self.maximum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaximum>%s</%smaximum>%s' % (namespace_, self.gds_format_float(self.maximum, input_name='maximum'), namespace_, eol_))
        if self.average is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saverage>%s</%saverage>%s' % (namespace_, self.gds_format_float(self.average, input_name='average'), namespace_, eol_))
        if self.std is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstd>%s</%sstd>%s' % (namespace_, self.gds_format_float(self.std, input_name='std'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'minimum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'minimum')
            self.minimum = fval_
        elif nodeName_ == 'maximum':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'maximum')
            self.maximum = fval_
        elif nodeName_ == 'average':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'average')
            self.average = fval_
        elif nodeName_ == 'std':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'std')
            self.std = fval_
# end class statisticsType


class cellType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('cellA', 'cType', 0),
        MemberSpec_('cellB', 'cType', 0),
        MemberSpec_('cellC', 'cType', 0),
        MemberSpec_('cellAlpha', 'cAngleType', 0),
        MemberSpec_('cellBeta', 'cAngleType', 0),
        MemberSpec_('cellGamma', 'cAngleType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, cellA=None, cellB=None, cellC=None, cellAlpha=None, cellBeta=None, cellGamma=None):
        self.original_tagname_ = None
        self.cellA = cellA
        self.cellB = cellB
        self.cellC = cellC
        self.cellAlpha = cellAlpha
        self.cellBeta = cellBeta
        self.cellGamma = cellGamma
    def factory(*args_, **kwargs_):
        if cellType.subclass:
            return cellType.subclass(*args_, **kwargs_)
        else:
            return cellType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cellA(self): return self.cellA
    def set_cellA(self, cellA): self.cellA = cellA
    def get_cellB(self): return self.cellB
    def set_cellB(self, cellB): self.cellB = cellB
    def get_cellC(self): return self.cellC
    def set_cellC(self, cellC): self.cellC = cellC
    def get_cellAlpha(self): return self.cellAlpha
    def set_cellAlpha(self, cellAlpha): self.cellAlpha = cellAlpha
    def get_cellBeta(self): return self.cellBeta
    def set_cellBeta(self, cellBeta): self.cellBeta = cellBeta
    def get_cellGamma(self): return self.cellGamma
    def set_cellGamma(self, cellGamma): self.cellGamma = cellGamma
    def hasContent_(self):
        if (
            self.cellA is not None or
            self.cellB is not None or
            self.cellC is not None or
            self.cellAlpha is not None or
            self.cellBeta is not None or
            self.cellGamma is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cellType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cellType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cellType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cellType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cellType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cellA is not None:
            self.cellA.export(outfile, level, namespace_, name_='cellA', pretty_print=pretty_print)
        if self.cellB is not None:
            self.cellB.export(outfile, level, namespace_, name_='cellB', pretty_print=pretty_print)
        if self.cellC is not None:
            self.cellC.export(outfile, level, namespace_, name_='cellC', pretty_print=pretty_print)
        if self.cellAlpha is not None:
            self.cellAlpha.export(outfile, level, namespace_, name_='cellAlpha', pretty_print=pretty_print)
        if self.cellBeta is not None:
            self.cellBeta.export(outfile, level, namespace_, name_='cellBeta', pretty_print=pretty_print)
        if self.cellGamma is not None:
            self.cellGamma.export(outfile, level, namespace_, name_='cellGamma', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cellA':
            obj_ = cType.factory()
            obj_.build(child_)
            self.cellA = obj_
            obj_.original_tagname_ = 'cellA'
        elif nodeName_ == 'cellB':
            obj_ = cType.factory()
            obj_.build(child_)
            self.cellB = obj_
            obj_.original_tagname_ = 'cellB'
        elif nodeName_ == 'cellC':
            obj_ = cType.factory()
            obj_.build(child_)
            self.cellC = obj_
            obj_.original_tagname_ = 'cellC'
        elif nodeName_ == 'cellAlpha':
            obj_ = cAngleType.factory()
            obj_.build(child_)
            self.cellAlpha = obj_
            obj_.original_tagname_ = 'cellAlpha'
        elif nodeName_ == 'cellBeta':
            obj_ = cAngleType.factory()
            obj_.build(child_)
            self.cellBeta = obj_
            obj_.original_tagname_ = 'cellBeta'
        elif nodeName_ == 'cellGamma':
            obj_ = cAngleType.factory()
            obj_.build(child_)
            self.cellGamma = obj_
            obj_.original_tagname_ = 'cellGamma'
# end class cellType


class slcCellType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('cellA', 'cType', 0),
        MemberSpec_('cellB', 'slcCType', 0),
        MemberSpec_('cellC', 'slcCType', 0),
        MemberSpec_('cellAlpha', 'cAngleType', 0),
        MemberSpec_('cellBeta', 'cAngleType', 0),
        MemberSpec_('cellGamma', 'cAngleType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, cellA=None, cellB=None, cellC=None, cellAlpha=None, cellBeta=None, cellGamma=None):
        self.original_tagname_ = None
        self.cellA = cellA
        self.cellB = cellB
        self.cellC = cellC
        self.cellAlpha = cellAlpha
        self.cellBeta = cellBeta
        self.cellGamma = cellGamma
    def factory(*args_, **kwargs_):
        if slcCellType.subclass:
            return slcCellType.subclass(*args_, **kwargs_)
        else:
            return slcCellType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cellA(self): return self.cellA
    def set_cellA(self, cellA): self.cellA = cellA
    def get_cellB(self): return self.cellB
    def set_cellB(self, cellB): self.cellB = cellB
    def get_cellC(self): return self.cellC
    def set_cellC(self, cellC): self.cellC = cellC
    def get_cellAlpha(self): return self.cellAlpha
    def set_cellAlpha(self, cellAlpha): self.cellAlpha = cellAlpha
    def get_cellBeta(self): return self.cellBeta
    def set_cellBeta(self, cellBeta): self.cellBeta = cellBeta
    def get_cellGamma(self): return self.cellGamma
    def set_cellGamma(self, cellGamma): self.cellGamma = cellGamma
    def hasContent_(self):
        if (
            self.cellA is not None or
            self.cellB is not None or
            self.cellC is not None or
            self.cellAlpha is not None or
            self.cellBeta is not None or
            self.cellGamma is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcCellType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcCellType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcCellType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcCellType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='slcCellType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cellA is not None:
            self.cellA.export(outfile, level, namespace_, name_='cellA', pretty_print=pretty_print)
        if self.cellB is not None:
            self.cellB.export(outfile, level, namespace_, name_='cellB', pretty_print=pretty_print)
        if self.cellC is not None:
            self.cellC.export(outfile, level, namespace_, name_='cellC', pretty_print=pretty_print)
        if self.cellAlpha is not None:
            self.cellAlpha.export(outfile, level, namespace_, name_='cellAlpha', pretty_print=pretty_print)
        if self.cellBeta is not None:
            self.cellBeta.export(outfile, level, namespace_, name_='cellBeta', pretty_print=pretty_print)
        if self.cellGamma is not None:
            self.cellGamma.export(outfile, level, namespace_, name_='cellGamma', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cellA':
            obj_ = cType.factory()
            obj_.build(child_)
            self.cellA = obj_
            obj_.original_tagname_ = 'cellA'
        elif nodeName_ == 'cellB':
            obj_ = slcCType.factory()
            obj_.build(child_)
            self.cellB = obj_
            obj_.original_tagname_ = 'cellB'
        elif nodeName_ == 'cellC':
            obj_ = slcCType.factory()
            obj_.build(child_)
            self.cellC = obj_
            obj_.original_tagname_ = 'cellC'
        elif nodeName_ == 'cellAlpha':
            obj_ = cAngleType.factory()
            obj_.build(child_)
            self.cellAlpha = obj_
            obj_.original_tagname_ = 'cellAlpha'
        elif nodeName_ == 'cellBeta':
            obj_ = cAngleType.factory()
            obj_.build(child_)
            self.cellBeta = obj_
            obj_.original_tagname_ = 'cellBeta'
        elif nodeName_ == 'cellGamma':
            obj_ = cAngleType.factory()
            obj_.build(child_)
            self.cellGamma = obj_
            obj_.original_tagname_ = 'cellGamma'
# end class slcCellType


class limitType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('limitRow', 'xs:float', 0),
        MemberSpec_('limitCol', 'xs:float', 0),
        MemberSpec_('limitSec', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, limitRow=None, limitCol=None, limitSec=None):
        self.original_tagname_ = None
        self.limitRow = limitRow
        self.limitCol = limitCol
        self.limitSec = limitSec
    def factory(*args_, **kwargs_):
        if limitType.subclass:
            return limitType.subclass(*args_, **kwargs_)
        else:
            return limitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_limitRow(self): return self.limitRow
    def set_limitRow(self, limitRow): self.limitRow = limitRow
    def get_limitCol(self): return self.limitCol
    def set_limitCol(self, limitCol): self.limitCol = limitCol
    def get_limitSec(self): return self.limitSec
    def set_limitSec(self, limitSec): self.limitSec = limitSec
    def hasContent_(self):
        if (
            self.limitRow is not None or
            self.limitCol is not None or
            self.limitSec is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='limitType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='limitType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='limitType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='limitType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='limitType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.limitRow is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slimitRow>%s</%slimitRow>%s' % (namespace_, self.gds_format_float(self.limitRow, input_name='limitRow'), namespace_, eol_))
        if self.limitCol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slimitCol>%s</%slimitCol>%s' % (namespace_, self.gds_format_float(self.limitCol, input_name='limitCol'), namespace_, eol_))
        if self.limitSec is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slimitSec>%s</%slimitSec>%s' % (namespace_, self.gds_format_float(self.limitSec, input_name='limitSec'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'limitRow':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'limitRow')
            self.limitRow = fval_
        elif nodeName_ == 'limitCol':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'limitCol')
            self.limitCol = fval_
        elif nodeName_ == 'limitSec':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'limitSec')
            self.limitSec = fval_
    def gds_format_float(self,input_data, input_name="" ):
        return ("%g" % input_data)
# end class limitType


class pixType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if pixType.subclass:
            return pixType.subclass(*args_, **kwargs_)
        else:
            return pixType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pixType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pixType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pixType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pixType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='pixType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class pixType


class limType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if limType.subclass:
            return limType.subclass(*args_, **kwargs_)
        else:
            return limType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='limType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='limType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='limType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='limType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='limType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class limType


class cType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', ['allowedCellDim', 'xs:float'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if cType.subclass:
            return cType.subclass(*args_, **kwargs_)
        else:
            return cType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='cType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cType


class slcCType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', ['allowedSlcCellDim', 'xs:float'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if slcCType.subclass:
            return slcCType.subclass(*args_, **kwargs_)
        else:
            return slcCType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='slcCType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='slcCType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='slcCType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='slcCType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='slcCType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class slcCType


class cAngleType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('units', 'xs:string', 0),
        MemberSpec_('valueOf_', ['allowedAngles', 'xs:float'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, units=None, valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if cAngleType.subclass:
            return cAngleType.subclass(*args_, **kwargs_)
        else:
            return cAngleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cAngleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cAngleType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cAngleType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cAngleType'):
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units).encode(ExternalEncoding), input_name='units'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='cAngleType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cAngleType


class emdbListType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('entry', ['emdbType', 'xs:string'], 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, entry=None):
        self.original_tagname_ = None
        if entry is None:
            self.entry = []
        else:
            self.entry = entry
    def factory(*args_, **kwargs_):
        if emdbListType.subclass:
            return emdbListType.subclass(*args_, **kwargs_)
        else:
            return emdbListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_entry(self): return self.entry
    def set_entry(self, entry): self.entry = entry
    def add_entry(self, value): self.entry.append(value)
    def insert_entry_at(self, index, value): self.entry.insert(index, value)
    def replace_entry_at(self, index, value): self.entry[index] = value
    def validate_emdbType(self, value):
        # Validate type emdbType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdbType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdbType_patterns_, ))
    validate_emdbType_patterns_ = [['^EMD-\\d{4,}$']]
    def hasContent_(self):
        if (
            self.entry
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='emdbListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='emdbListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='emdbListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='emdbListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='emdbListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for entry_ in self.entry:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sentry>%s</%sentry>%s' % (namespace_, self.gds_format_string(quote_xml(entry_).encode(ExternalEncoding), input_name='entry'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'entry':
            entry_ = child_.text
            entry_ = self.gds_validate_string(entry_, node, 'entry')
            self.entry.append(entry_)
            # validate type emdbType
            self.validate_emdbType(self.entry[-1])
# end class emdbListType


class pdbidListType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fittedPDBEntryId', ['pdbidType', 'xs:string'], 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, fittedPDBEntryId=None):
        self.original_tagname_ = None
        if fittedPDBEntryId is None:
            self.fittedPDBEntryId = []
        else:
            self.fittedPDBEntryId = fittedPDBEntryId
    def factory(*args_, **kwargs_):
        if pdbidListType.subclass:
            return pdbidListType.subclass(*args_, **kwargs_)
        else:
            return pdbidListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fittedPDBEntryId(self): return self.fittedPDBEntryId
    def set_fittedPDBEntryId(self, fittedPDBEntryId): self.fittedPDBEntryId = fittedPDBEntryId
    def add_fittedPDBEntryId(self, value): self.fittedPDBEntryId.append(value)
    def insert_fittedPDBEntryId_at(self, index, value): self.fittedPDBEntryId.insert(index, value)
    def replace_fittedPDBEntryId_at(self, index, value): self.fittedPDBEntryId[index] = value
    def validate_pdbidType(self, value):
        # Validate type pdbidType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pdbidType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pdbidType_patterns_, ))
    validate_pdbidType_patterns_ = [['^\\d[0-9a-zA-Z]{3}$']]
    def hasContent_(self):
        if (
            self.fittedPDBEntryId
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pdbidListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pdbidListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pdbidListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pdbidListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pdbidListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for fittedPDBEntryId_ in self.fittedPDBEntryId:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfittedPDBEntryId>%s</%sfittedPDBEntryId>%s' % (namespace_, self.gds_format_string(quote_xml(fittedPDBEntryId_).encode(ExternalEncoding), input_name='fittedPDBEntryId'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fittedPDBEntryId':
            fittedPDBEntryId_ = child_.text
            fittedPDBEntryId_ = self.gds_validate_string(fittedPDBEntryId_, node, 'fittedPDBEntryId')
            self.fittedPDBEntryId.append(fittedPDBEntryId_)
            # validate type pdbidType
            self.validate_pdbidType(self.fittedPDBEntryId[-1])
# end class pdbidListType


class pdbidList2Type(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('pdbEntryId', ['pdbidType', 'xs:string'], 1),
        MemberSpec_('pdbChainId', 'xs:string', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, pdbEntryId=None, pdbChainId=None):
        self.original_tagname_ = None
        if pdbEntryId is None:
            self.pdbEntryId = []
        else:
            self.pdbEntryId = pdbEntryId
        if pdbChainId is None:
            self.pdbChainId = []
        else:
            self.pdbChainId = pdbChainId
    def factory(*args_, **kwargs_):
        if pdbidList2Type.subclass:
            return pdbidList2Type.subclass(*args_, **kwargs_)
        else:
            return pdbidList2Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pdbEntryId(self): return self.pdbEntryId
    def set_pdbEntryId(self, pdbEntryId): self.pdbEntryId = pdbEntryId
    def add_pdbEntryId(self, value): self.pdbEntryId.append(value)
    def insert_pdbEntryId_at(self, index, value): self.pdbEntryId.insert(index, value)
    def replace_pdbEntryId_at(self, index, value): self.pdbEntryId[index] = value
    def get_pdbChainId(self): return self.pdbChainId
    def set_pdbChainId(self, pdbChainId): self.pdbChainId = pdbChainId
    def add_pdbChainId(self, value): self.pdbChainId.append(value)
    def insert_pdbChainId_at(self, index, value): self.pdbChainId.insert(index, value)
    def replace_pdbChainId_at(self, index, value): self.pdbChainId[index] = value
    def validate_pdbidType(self, value):
        # Validate type pdbidType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pdbidType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pdbidType_patterns_, ))
    validate_pdbidType_patterns_ = [['^\\d[0-9a-zA-Z]{3}$']]
    def hasContent_(self):
        if (
            self.pdbEntryId or
            self.pdbChainId
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pdbidList2Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pdbidList2Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pdbidList2Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pdbidList2Type'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pdbidList2Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pdbEntryId_ in self.pdbEntryId:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spdbEntryId>%s</%spdbEntryId>%s' % (namespace_, self.gds_format_string(quote_xml(pdbEntryId_).encode(ExternalEncoding), input_name='pdbEntryId'), namespace_, eol_))
        for pdbChainId_ in self.pdbChainId:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spdbChainId>%s</%spdbChainId>%s' % (namespace_, self.gds_format_string(quote_xml(pdbChainId_).encode(ExternalEncoding), input_name='pdbChainId'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pdbEntryId':
            pdbEntryId_ = child_.text
            pdbEntryId_ = self.gds_validate_string(pdbEntryId_, node, 'pdbEntryId')
            self.pdbEntryId.append(pdbEntryId_)
            # validate type pdbidType
            self.validate_pdbidType(self.pdbEntryId[-1])
        elif nodeName_ == 'pdbChainId':
            pdbChainId_ = child_.text
            pdbChainId_ = self.gds_validate_string(pdbChainId_, node, 'pdbChainId')
            self.pdbChainId.append(pdbChainId_)
# end class pdbidList2Type


class statusType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('prior', 'status', 0),
        MemberSpec_('valueOf_', ['status', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, prior=None, valueOf_=None):
        self.original_tagname_ = None
        self.prior = _cast(None, prior)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if statusType.subclass:
            return statusType.subclass(*args_, **kwargs_)
        else:
            return statusType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_prior(self): return self.prior
    def set_prior(self, prior): self.prior = prior
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_status(self, value):
        # Validate type status, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['REL', 'HPUB', 'HOLD1', 'OBS']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on status' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='statusType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='statusType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='statusType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='statusType'):
        if self.prior is not None and 'prior' not in already_processed:
            already_processed.add('prior')
            outfile.write(' prior=%s' % (quote_attrib(self.prior), ))
    def exportChildren(self, outfile, level, namespace_='', name_='statusType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('prior', node)
        if value is not None and 'prior' not in already_processed:
            already_processed.add('prior')
            self.prior = value
            self.validate_status(self.prior)    # validate type status
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class statusType


class contourLevelType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('source', 'xs:string', 0),
        MemberSpec_('valueOf_', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, source=None, valueOf_=None):
        self.original_tagname_ = None
        self.source = _cast(None, source)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if contourLevelType.subclass:
            return contourLevelType.subclass(*args_, **kwargs_)
        else:
            return contourLevelType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contourLevelType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contourLevelType')
        if self.hasContent_():
            outfile.write('>')
            if type(self.valueOf_) is float:
                x_ = self.gds_format_float(self.valueOf_)
            elif type(self.valueOf_) is str:
                x_ = quote_xml(self.valueOf_)
            else:
                x_ = str(self.valueOf_)
            outfile.write(x_.encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contourLevelType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contourLevelType'):
        if self.source is not None and 'source' not in already_processed:
            already_processed.add('source')
            outfile.write(' source=%s' % (self.gds_format_string(quote_attrib(self.source).encode(ExternalEncoding), input_name='source'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='contourLevelType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.add('source')
            self.source = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
    def gds_format_float(self,input_data, input_name="" ):
        return ("%g" % input_data)
# end class contourLevelType


GDSClassesMapping = {
    'ribosome-eukaryote': riboTypeEu,
    'contourLevel': contourLevelType,
    'supplement': supplType,
    'cellAlpha': cAngleType,
    'nominalDefocusMax': defocusType,
    'nominalDefocusMin': defocusType,
    'ligand': ligandType,
    'deltaZ': lengthType,
    'threeDCrystalParameters': threeDxtalParamType,
    'aLength': lengthType,
    'bLength': lengthType,
    'emdEntry': entryType,
    'nucleic-acid': nuclAcidType,
    'cLength': lengthType,
    'externalReference': externalRefType,
    'nonJournalArticle': nonJrnlArtType,
    'hostSpecies': sciSpeciesType,
    'helicalParameters': helixParamType,
    'obsoleteList': emdbListType,
    'sciSpeciesName': sciSpeciesType,
    'temperatureMin': tempType,
    'engSource': engSrcType,
    'secondaryReference': prRefType,
    'slice': slcType,
    'dimensions': slcDimensionType,
    'temperatureMax': tempType,
    'sliceSet': slcSetType,
    'label': labelType,
    'cell': slcCellType,
    'experiment': expType,
    'reconstruction': reconsType,
    'sampleComponent': smplCompType,
    'acceleratingVoltage': accVoltType,
    'samplingSize': samplSizeType,
    'processing': processType,
    'spacing': slcSpacingType,
    'deposition': depType,
    'imaging': imgType,
    'ribosome-prokaryote': riboTypePro,
    'temperature': tempType,
    'cellular-component': cellCompType,
    'expSystem': sciSpeciesType,
    'energyWindow': eWindowType,
    'admin': adminType,
    'virus': virusType,
    'pixelZ': pixType,
    'pixelX': pixType,
    'natSource': natSrcType,
    'gamma': anglType,
    'origin': originType,
    'diameter': diamType,
    'tiltAngleMin': tiltType,
    'electronDose': eDoseType,
    'helical': helixType,
    'tiltAngleMax': tiltType,
    'statistics': statisticsType,
    'figure': figType,
    'twoDCrystal': xtal2DType,
    'molWtTheo': mwType,
    'sciSpeciesStrain': sciSpeciesType,
    'deltaPhi': anglType,
    'subtomogramAveraging': subTomType,
    'shell': shellType,
    'supersededByList': emdbListType,
    'cellA': cType,
    'cellC': slcCType,
    'cellB': slcCType,
    'twoDCrystalParameters': twoDxtalParamType,
    'cellGamma': cAngleType,
    'figureSet': figSetType,
    'pdbEntryIdList': pdbidList2Type,
    'limit': limitType,
    'primaryReference': prRefType,
    'externalReferences': externalReferencesType,
    'fscSet': fscSetType,
    'sampleComponentList': smplCompListType,
    'sample': samplType,
    'file': slcFileType,
    'tomography': tomogrType,
    'protein': proteinType,
    'vitrification': vitrifType,
    'nominalCs': csType,
    'fitting': fittingType,
    'imageAcquisition': imgScanType,
    'status': statusType,
    'map': mapType,
    'specimenConc': samplConcType,
    'buffer': bufferType,
    'pixelY': pixType,
    'fittedPDBEntryIdList': pdbidListType,
    'beta': anglType,
    'journalArticle': jrnlArtType,
    'alpha': anglType,
    'molWtExp': mwType,
    'maskSet': mskSetType,
    'specimenPreparation': smplPrepType,
    'fsc': fscType,
    'singleParticle': singPartType,
    'axisOrder': axisOrderType,
    'mask': mskType,
    'cellBeta': cAngleType,
    'pixelSpacing': pixelSpacingType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    parser = None
    doc = parsexml_(StringIO(inString), parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from emdb_19 import *\n\n')
        sys.stdout.write('import emdb_19 as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "accVoltType",
    "adminType",
    "anglType",
    "axisOrderType",
    "bufferType",
    "cAngleType",
    "cType",
    "cellCompType",
    "cellType",
    "contactType",
    "contourLevelType",
    "crystSizeType",
    "csType",
    "defocusType",
    "depType",
    "diamType",
    "dimensionType",
    "eDoseType",
    "eWindowType",
    "emdbListType",
    "engSrcType",
    "entryType",
    "expType",
    "externalRefType",
    "externalReferencesType",
    "figSetType",
    "figType",
    "fittingType",
    "fscSetType",
    "fscType",
    "helixParamType",
    "helixType",
    "imgScanType",
    "imgType",
    "jrnlArtType",
    "labelType",
    "layerLineType",
    "lengthType",
    "ligandType",
    "limType",
    "limitType",
    "mapFileType",
    "mapType",
    "mskFileType",
    "mskSetType",
    "mskType",
    "mwType",
    "natSrcType",
    "natSrcVirusType",
    "nonJrnlArtType",
    "nuclAcidType",
    "origType",
    "originType",
    "pdbidList2Type",
    "pdbidListType",
    "pixType",
    "pixelSpacingType",
    "prRefType",
    "processType",
    "proteinType",
    "pubType",
    "reconsType",
    "riboTypeEu",
    "riboTypePro",
    "samplConcType",
    "samplSizeType",
    "samplType",
    "sciSpeciesType",
    "shellType",
    "singPartType",
    "slcCType",
    "slcCellType",
    "slcDimensionType",
    "slcFileType",
    "slcSetType",
    "slcSpacingType",
    "slcType",
    "smplCompListType",
    "smplCompType",
    "smplPrepType",
    "spacingType",
    "statisticsType",
    "statusType",
    "structFactType",
    "subTomType",
    "supplType",
    "tempType",
    "threeDxtalParamType",
    "tiltType",
    "tomogrType",
    "twoDxtalParamType",
    "virusType",
    "vitrifType",
    "xtal2DType"
]
