C  CALCULATE TILT ANGLES FROM TILTED AND UNTILTED RECIPROCAL
C  CELL DEIMENSIONS.
C
C  CONVENTION FOR MEASURING TILT AXIS TO ASTAR IS THAT THE ANGLE IS
C  FROM TILTAXIS TO ASTAR IN THE DIRECTION GIVEN BY ASTAR TO BSTAR
C  BEING POSITIVE.
C
	IMPLICIT REAL*8 (A-H,O-Z)
	WRITE(6,102)
102	FORMAT(' TILT ANGLE PROGRAM - PETER SHAW 3.5.81')
	WRITE(6,100)
100	FORMAT('$UNTILTED ASTAR,BSTAR,GAMMASTAR ...')
	READ(5,*) A,B,GAMMA
103	WRITE(6,101)
101	FORMAT('$TILTED ASTAR,BSTAR,GAMMASTAR ...')
	READ(5,*) AT,BT,GAMMAT
	IF(AT.LE.0.)STOP
C
	COSG = DCOS(GAMMA*3.14159/180.0)
	COSGT= DCOS(GAMMAT*3.14159/180.0)
	SING = DSIN(GAMMA*3.14159/180.0)
C
	C1 = (A*A)/(AT*AT)
	C2 = (B*B)/(BT*BT)
	C3 = (A*B)/(AT*BT*COSGT)
	C4 = (A*B*COSG)/(AT*BT*COSGT)
C
	AX = C2*(C1/C3)*(C1/C3) - C1
	BX = C2 + 2.0*C2*(C1/C3)*((C1-C4)/C3) - C1
	CX = C2*((C1-C4)/C3)*((C1-C4)/C3)
	DISC = BX*BX - 4.0*AX*CX
	IF (DISC .LT. 0.0) GO TO 200
	PSQ1 = (-BX + DSQRT(DISC))/(2.0*AX)
	PSQ2 = (-BX - DSQRT(DISC))/(2.0*AX)
	IF (PSQ1 .LT. 0.0 .AND. PSQ2 .LT. 0.0) GO TO 210
	IF (PSQ1 .GT. 0.0) PP = DSQRT(PSQ1)
	IF (PSQ2 .GT. 0.0) PP = DSQRT(PSQ2)
	QQ = (C1/C3)*PP + ((C1-C4)/C3)*(1.0/PP)
	XK = DSQRT(C1*(PP*PP + 1.0))
	WRITE(6,110) PP,QQ,XK
110	FORMAT (' P,Q, AND SCALE FACTOR ',3F15.5)
	PHI = DATAN2(SING,QQ/PP-COSG)
	SINPHI = DSIN(PHI)
	COSPHI = DCOS(PHI)
	THETA = DATAN2(PP,SINPHI)
	TANTHE = DTAN(THETA)
	PHI = PHI*180.0/3.14159
	THETA = THETA*180.0/3.14159
	WRITE(6,111) PHI,THETA
111	FORMAT (' ANGLE FROM TILT AXIS TO ASTAR, AND TILT ANGLE',2F15.5)
C
C  CALCULATE ANGLE TO TILTED ASTAR ... THIS IS THE ANGLE ONE
C  WOULD GET DIRECTLY FROM THE FILM, FOR EXAMPLE BY FINDING
C  THE DIRECTION OF ZERO CHANGE IN THE C.T.F.
C
	COSPHI = COSPHI/(DSQRT(1.0 + SINPHI*SINPHI*TANTHE*TANTHE))
	PHITLT = DACOS(COSPHI)*180.0/3.14159
	WRITE(6,112) PHITLT
112	FORMAT(' ANGLE FROM TILT AXIS TO TILTED ASTAR ...',F15.5)
	GO TO 103
200	WRITE (6,201)
201	FORMAT (' DISCRIMINANT LESS THAN ZERO')
	STOP
210	WRITE (6,211)
211	FORMAT(' TWO NEGATIVE ROOTS - SOMETHING WRONG')
	STOP
	END

