C*RFILTIM.FOR*************************************************************
C     ROTATIONAL FILTERING
C     FILTERING OF IMAGES IN RECIPROCAL SPACE
C     DIMENSIONED FOR TRANSFORMS OF 256X256 IMAGES (MAX SIZE)
C       Modified for VAX   RAC      27MAR84
C       Redimensioned  ARRAY-->  =250000  - total input pixels   RH   18-Dec-93
C	Redimensioned  RHO  --> (251,251) - output array size    RH   18-Dec-93
C	Redimensioned  NLRP1-->  =126     - see NLR below        RH   18-Dec-93
C	Redimensioned  NLR  -->   NLRP1-1 - No. realspace radii  RH   18-Dec-93
C	Redimensioned  iBESMX-->  =4001    - Max No. Bessels      RH   18-Dec-93
C	Redimensioned  MAXNR =   =40      - Max transform radius RH   18-Dec-93
C	Output power spectrum format changed to I5,F20.8)        RH   07-Jan-00
C       V2.0 04-Apr-00 irtorg mod to include zorigin 		JMS   29-MAr-00
C	V2.1 21-Apr-09 dimensioning changed to use integers, error
C                      trap for transforms > 256		
C			 file opened properly for curvy output  JMS   21-Apr-09
C	V2.2 24-Apr-12 bug fix to integer ibesmx		RH15  24-Apr-12
C******************************************************************************
C*** JMS mod asize to iasize, rsize to irsize throughout 21-Apr-09
C*** JMS mod for gfortran - changed all occurrences of BESMX top ibesmx
      PARAMETER (iasize=250000)
      PARAMETER (irsize=251)
C*** jms 25.06.2010
      parameter (ibesmx = 4001)
C***      PARAMETER (BESMX=4001)
      PARAMETER (MAXNR=40)
      PARAMETER (NLRP1=126)
      PARAMETER (NLRMAX=NLRP1-1)
C*** JMS mod to trap transforms > 256
	parameter (maxtrans=65536)
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      COMMON /BLOCKO/ N,NR,RSTEP,M,DXMAX,DXMIN,DELDX,DYMAX,DYMIN,DELDY,
     1ALPHA,IMX,IMY,IOPT,JOPT,NBSTEP,AMPFAC,NBMIN,LGDUMP,LGOUT,NORM
      DIMENSION AMPFAC(40),M(40),NXYZ(3)
      COMMON IBD,TWODD,MEND,MSTEP,DELBR,NLR,DELSR,NMAX,ABG,BBG,ALG,BLG
      COMMON TITLE,ASCAL,BSCAL,SCALE,PHI0,RHOMAX,RHOMIN,RHOBAR
      DIMENSION BSA(ibesmx,15),ABG(40,71),BBG(40,71),ALG(NLRP1,15),
     1 BLG(NLRP1,15),RHO(irsize,irsize),TITLE(20)
C***      EQUIVALENCE (BSA(1),ARRAY(1)),(RHO(1),ARRAY(1)),(NX,NXYZ)
      EQUIVALENCE (BSA(1,1),ARRAY(1)),(RHO(1,1),ARRAY(1)),(NX,NXYZ)
      DIMENSION NXYZ1(3),MXYZ(3)
      CHARACTER DAT*24
C*** jms 25.06.2010
      character head1(12)
      character head(10)
C***      BYTE HEAD1(12),HEAD(10)
      EQUIVALENCE (HEAD(1),HEAD1(3))
CTSH++
	CHARACTER*80 TMPTITLE
	EQUIVALENCE (TMPTITLE,TITLE)
CTSH--
      DATA HEAD1/'T','=',10*' '/
C
C     IF JOPT = 1 , G0 IS OMITTED
C     IF  LGDUMP.NE.0   LITTLE GS ARE DUMPED STARTING ON FORTRAN 10
      LGOUT=10
      TWOPI=6.28318
      WRITE(6,1000)
1000  FORMAT('1'/'  Rotational filtering - Transform processed :'//)
      CALL IMOPEN(1,'IN','RO')
      CALL IRDHDR(1,NXYZ,MXYZ,MODE,DMIN,DMAX,DMEAN)
C*** JMS mod to trap transforms > 256
	if(nxyz(1) * nxyz(2) .gt. maxtrans) then
	 write(6,'(''Transform too large - 256 maximum'')')
	 stop
	end if
      CALL IRTORG(1,ORIGX,ORIGY,ORIGZ)
      CALL IRDSEC(1,ARRAY,*99)
      NXP2=2*NX
      KY=NY/2
      DELPX=-TWOPI*ORIGX/NY
      DELPY=-TWOPI*ORIGY/NY
C
      READ(5,1001) HEAD
1001  FORMAT(10A)
      WRITE(6,1002) HEAD
1002  FORMAT(///'  Header   ',10A)
      READ(5,*) N,NR,RSTEP,NLR,RSCAL
      IF(NR.GT.MAXNR) STOP ' Number transform radii, NR .GT. MAXNR'
      WRITE(6,1003) N,NR,RSTEP,NLR,RSCAL
 1003 FORMAT(///'  Rotational symmetry       N',I10,
     1         /'  No of transform annuli   NR',I10,
     2         /'  Spacing of annuli     RSTEP',F10.3,' transform steps',
     3         /'  No. of real space radii NLR',I10,
     4         /'  Real space scaling    RSCAL',F10.3)
      READ(5,*) DXMIN,DXMAX,DELDX,DYMIN,DYMAX,DELDY,NBSTEP,NBMIN
      WRITE(6,1005) DXMIN,DXMAX,DELDX,DYMIN,DYMAX,DELDY,NBSTEP,NBMIN
 1005 FORMAT(//'  Origin search :'
     1        /'  x from',F6.2,' to',F6.2,' in steps of',F6.2,
     2        /'  y from',F6.2,' to',F6.2,' in steps of',F6.2,
     3        /'  No of annuli per band',I6,
     4        /'  No of bands omitted from total residual',I6)
      READ(5,*) ASCAL,BSCAL,PHI0,SCALE,JOPT,LGDUMP,NORM
      WRITE(6,1006) ASCAL,BSCAL,PHI0,SCALE,JOPT,LGDUMP,NORM
 1006 FORMAT(//'  Frequency weighting  ASCAL,BSCAL',2F6.2,
     1        /'  Image rotation              PHI0',F6.2,' degrees',
     2        /'  Image scaling              SCALE',F6.2,
     3        /'  Include g0  (Y/N 0/1)       JOPT',I5,
     4        /'  Dump gn to disc (N/Y 0/1) LGDUMP',I5,
     5        /'  Norm power spec (N/Y 0/1)   NORM',I5)
C
      IF(SCALE.EQ.0.0) SCALE=1.0
      DELBR=RSTEP/NY
   32 TWODD=TWOPI*RSTEP*RSCAL/NY
      MAX=N*14+1
      IF(MAX.GT.71) MAX=71
      DO 30 IR=1,NR
      M(IR)=1+INT(TWOPI*NLR*RSCAL*IR*RSTEP/NY+2.)
      IF(M(IR).GT.MAX) M(IR)=MAX
   30 CONTINUE
      WRITE(6,1007) (M(IR),IR=1,NR)
1007  FORMAT(//'  No. of Bessel functions contributing at each radius
     1 in the transform',5(/5X,20I5))
      MSTEP=N
      MEND=1+(M(NR)-1)/N
      IF(MEND.GT.15) STOP
      IF(NLR.GT.NLRMAX) NLR=NLRMAX
      IBD=NR*NLR+1
      WRITE(6,1011) IBD
 1011 FORMAT('0REQUIRED NO. OF BESSEL ARGUMENTS =',I7)
      IF(IBD.GT.ibesmx)STOP
      NLR=NLR+1
      DO 40 IR=1,NR
   40 AMPFAC(IR)=1.0
      PHI0=PHI0*3.14159/180.0
C
C     Initialise CURVY file for power spectrum
	open(unit=3,file='spectrum.dat',status='unknown')
        write(*,*) 'starting CURVY section'
      WRITE(3,1100) HEAD1,N
1100  FORMAT(12A,10X,I5,'-fold refined')
      WRITE(3,1101)
1101  FORMAT('X=N')
      WRITE(3,1102)
1102  FORMAT('Y=POWER')
      WRITE(3,1103)
1103  FORMAT('L=Power in each harmonic!*')
C
      CALL ORIGIN
      ORIGX=ORIGX+DXMIN+(IMX-1)*DELDX
      ORIGY=ORIGY+DYMIN+(IMY-1)*DELDY
      WRITE(6,1008) ORIGX,ORIGY
 1008 FORMAT(//' Refined origin position',2F10.2)
C
      DELPX=-TWOPI*ORIGX/NY
      DELPY=-TWOPI*ORIGY/NY
      CALL BIGG
      CALL FILBES
      CALL LITTLG
   10 CALL FILTIM
C
C     Output filtered image
      NXIM=2*NLR+1
      NXYZ1(1)=NXIM
      NXYZ1(2)=NXIM
      NXYZ1(3)=1
      CALL fdate(DAT)
      CALL IMOPEN(2,'OUT','NEW')
      CALL ICRHDR(2,NXYZ1,NXYZ1,1,RHOMIN,RHOMAX,RHOBAR)
      CALL ITRLAB(2,1)
CTSH      ENCODE(80,1050,TITLE) N,ORIGX,ORIGY,DAT(5:24)
CTSH++
      WRITE(TMPTITLE,1050) N,ORIGX,ORIGY,DAT(5:24)
CTSH--
1050  FORMAT(' RFILTIM :',I2,'-fold filtered   origin:',2F6.1,
     1 3X,A20)
	write (6,'(''file 2 opened'')')
      ZERO=0.
      CALL IWRHDR(2,TITLE,1,ZERO,ZERO,ZERO)
C     Scale max excursion about zero to 100 and then apply scale factor
C      read in
      SCA=SCALE*100./AMAX1(ABS(RHOMAX),ABS(RHOMIN))
      DO 100 IY=1,NXIM
      DO 100 IX=1,NXIM
100   RHO(IX,IY)=SCA*RHO(IX,IY)
      IF(SCA.GT.0.) THEN
         RHOMIN=RHOMIN*SCA
         RHOMAX=RHOMAX*SCA
            ELSE
         TEMP=RHOMIN
         RHOMIN=RHOMAX*SCA
         RHOMAX=TEMP*SCA
      ENDIF
      RHOBAR=RHOBAR*SCA
      NXIM1=NXIM-1
      CALL IWRPAS(2,RHO,irsize,irsize,0,NXIM1,0,NXIM1)
      CALL IWRHDR(2,TITLE,-1,RHOMIN,RHOMAX,RHOBAR)
      CALL IMCLOSE(1)
      CALL IMCLOSE(2)
	close(3)
      STOP
C
99    WRITE(6,1020)
1020  FORMAT('  End of file on stream 1')
      STOP
      END
C
      SUBROUTINE ORIGIN
      PARAMETER (iasize=250000)
      PARAMETER (irsize=251)
C*** jms 25.06.2010
      parameter (ibesmx = 4001)
C***      PARAMETER (BESMX=4001)
      PARAMETER (NLRP1=126)
C     Find best symmetry origin by shifting phase origin
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      COMMON /BLOCKO/ N,NR,RSTEP,M,DXMAX,DXMIN,DELDX,DYMAX,DYMIN,DELDY,
     1ALPHA,IMX,IMY,IOPT,JOPT,NBSTEP,AMPFAC,NBMIN,LGDUMP,LGOUT,NORM
      DIMENSION AMPFAC(40),M(40),NXYZ(3)
      COMMON IBD,TWODD,MEND,MSTEP,DELBR,NLR,DELSR,NMAX,ABG,BBG,ALG,BLG
      COMMON TITLE,ASCAL,BSCAL,SCALE,PHI0,RHOMAX,RHOMIN,RHOBAR
      DIMENSION BSA(ibesmx,15),ABG(40,71),BBG(40,71),ALG(NLRP1,15),
     1 BLG(NLRP1,15),RHO(irsize,irsize),TITLE(20)
C***      EQUIVALENCE (BSA(1),ARRAY(1)),(RHO(1),ARRAY(1)),(NX,NXYZ)
      EQUIVALENCE (BSA(1,1),ARRAY(1)),(RHO(1,1),ARRAY(1)),(NX,NXYZ)
      DIMENSION SIGMA(10,10),SIGA(10,10),SIGB(10,10),SIGR(10,10)
      TWOPI=6.28319
      PIBYX=-TWOPI/NY
      ALPHA=TWOPI/N
      COSAL=COS(ALPHA)
      SINAL=SIN(ALPHA)
      NNX=(DXMAX-DXMIN+0.1)/DELDX+1
      NNY=(DYMAX-DYMIN+0.1)/DELDY+1
      IF(NNX.GT.10) NNX=10
      IF(NNY.GT.10) NNY=10
      NBMIN=NBMIN*NBSTEP
C
      DO 50 IX=1,NNX
      DO 50 IY=1,NNY
      SIGR(IX,IY)=0.0
   50 SIGMA(IX,IY)=0.0
C
      WRITE(6,1010)
1010  FORMAT('1'//' Origin refinement residuals - DXMIN,DYMIN at top LH
     1 corner')
      DO 500 IR=1,NR
      R=IR*RSTEP
      NPHI=2*(M(IR)-1)/N+2
      DELPHI=ALPHA/NPHI
      PHI=0.0
      DO 550 IPHI=1,NPHI
      DO 40 IX=1,NNX
      DO 40 IY=1,NNY
      SIGA(IX,IY)=0.0
   40 SIGB(IX,IY)=0.0
C
      X=R*COS(PHI)
      Y=R*SIN(PHI)
      DO 400 IN=1,N
      CALL INTERPTS(X,Y,A,B)
      XA=PIBYX*X
      YA=PIBYX*Y
      DO 30 IX=1,NNX
      DX=DXMIN+(IX-1)*DELDX
      XB=XA*DX
      DO 30 IY=1,NNY
      DY=DYMIN+(IY-1)*DELDY
      YB=YA*DY
      BETA=XB+YB
      CB=COS(BETA)
      SB=SIN(BETA)
      A1=A*CB-B*SB
      B1=A*SB+B*CB
      SIGR(IX,IY)=SIGR(IX,IY)+A1*A1+B1*B1
      SIGA(IX,IY)=SIGA(IX,IY)+A1
      SIGB(IX,IY)=SIGB(IX,IY)+B1
   30 CONTINUE
C     STEP ROUND INTO NEXT SECTOR
      XX=X
      YY=Y
      X=XX*COSAL-YY*SINAL
      Y=XX*SINAL+YY*COSAL
  400 CONTINUE
C
      DO 20 IX=1,NNX
      DO 20 IY=1,NNY
      SIGR(IX,IY)=SIGR(IX,IY)-(SIGA(IX,IY)**2+SIGB(IX,IY)**2)/N
   20 CONTINUE
  550 PHI=PHI+DELPHI
C
      IF(MOD(IR,NBSTEP).NE.0.AND.IR.NE.NR) GO TO 500
      WRITE(6,1003) IR
      DO 66 IY=1,NNY
      IF(IR.LE.NBMIN) GO TO 66
      DO 67 IX=1,NNX
   67 SIGMA(IX,IY)=SIGMA(IX,IY)+SIGR(IX,IY)
   66 WRITE(6,1000) (SIGR(IX,IY),IX=1,NNX)
      DO 45 IX=1,NNX
      DO 45 IY=1,NNY
   45 SIGR(IX,IY)=0.0
  500 CONTINUE
C
      WRITE(6,1002)
      SIGMIN=SIGMA(1,1)
      DO 65 IY=1,NNY
      DO 60 IX=1,NNX
      IF(SIGMIN.LT.SIGMA(IX,IY)) GO TO 60
      SIGMIN=SIGMA(IX,IY)
      IMX=IX
      IMY=IY
   60 CONTINUE
   65 WRITE(6,1000) (SIGMA(IX,IY),IX=1,NNX)
      WRITE(6,1001) IMX,IMY
      RETURN
 1000 FORMAT(1X,10E12.3)
 1001 FORMAT('0MINIMUM VALUE AT IMX ',I5,' IMY ',I5)
 1002 FORMAT('0ARRAY OF TOTAL RESIDUALS')
 1003 FORMAT('0RESIDUALS, OUT TO ANNULUS',I10)
      END
C
      SUBROUTINE BIGG
      PARAMETER (iasize=250000)
      PARAMETER (irsize=251)
C*** jms 25.06.2010
      parameter (ibesmx = 4001)
C***      PARAMETER (BESMX=4001)
      PARAMETER (NLRP1=126)
C     Routine to compute big G's around each annulus in transform
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      COMMON /BLOCKO/ N,NR,RSTEP,M,DXMAX,DXMIN,DELDX,DYMAX,DYMIN,DELDY,
     1ALPHA,IMX,IMY,IOPT,JOPT,NBSTEP,AMPFAC,NBMIN,LGDUMP,LGOUT,NORM
      DIMENSION AMPFAC(40),M(40),NXYZ(3)
      COMMON IBD,TWODD,MEND,MSTEP,DELBR,NLR,DELSR,NMAX,ABG,BBG,ALG,BLG
      COMMON TITLE,ASCAL,BSCAL,SCALE,PHI0,RHOMAX,RHOMIN,RHOBAR
      DIMENSION BSA(ibesmx,15),ABG(40,71),BBG(40,71),ALG(NLRP1,15),
     1 BLG(NLRP1,15),RHO(irsize,irsize),TITLE(20)
C***      EQUIVALENCE (BSA(1),ARRAY(1)),(RHO(1),ARRAY(1)),(NX,NXYZ)
      EQUIVALENCE (BSA(1,1),ARRAY(1)),(RHO(1,1),ARRAY(1)),(NX,NXYZ)
C***      DIMENSION AF(71),BF(71),POWER(71),GMOD(40)
      DIMENSION AF(71),BF(71),POWER(71)
C
      PI=3.14159
      PIBY2=PI/2.0
      TWOPI=6.28318
      DBR2=DELBR*DELBR
      CPHI0=COS(PHI0)
      SPHI0=SIN(PHI0)
      NMAX=M(NR)
      DO 15 IN=1,NMAX
      POWER(IN)=0.0
      DO 15 IR=1,NR
      ABG(IR,IN)=0.0
   15 BBG(IR,IN)=0.0
C
C     WRITE(6,1000)
      R=RSTEP
      DO 500 IR=1,NR
      NMAX=M(IR)
C     INITIALISATION OF BIG G'S
      DO 20 IN=1,NMAX
      AF(IN)=0.0
      BF(IN)=0.0
   20 CONTINUE
C
C     SOLVE FOR G'S AROUND THIS ANNULUS
      NPHI=NMAX*N
      PHIDEL=PI/NPHI
      CP0=CPHI0
      SP0=SPHI0
      CP00=1.
      SP00=0.
      CPL=COS(PHIDEL)
      SPL=SIN(PHIDEL)
C
      DO 400 IPHI=1,NPHI
      X=R*CP0
      Y=R*SP0
      CALL INTERPTS(X,Y,A,B)
C
      AF(1)=AF(1)+A
      CPN1=1.0
      SPN1=0.0
      DO 420 IN=2,NMAX,2
      CPN0=CPN1*CP00-SPN1*SP00
      SPN0=SPN1*CP00+CPN1*SP00
      AF(IN)=AF(IN)+B*SPN0
      BF(IN)=BF(IN)+B*CPN0
      IF(IN.EQ.NMAX) GO TO 420
      CPN1=CPN0*CP00-SPN0*SP00
      SPN1=SPN0*CP00+CPN0*SP00
      AF(IN+1)=AF(IN+1)+A*CPN1
      BF(IN+1)=BF(IN+1)-A*SPN1
  420 CONTINUE
      CPH=CP0*CPL-SP0*SPL
      SPH=SP0*CPL+CP0*SPL
      CP0=CPH
      SP0=SPH
      CPH=CP00*CPL-SP00*SPL
      SPH=SP00*CPL+CP00*SPL
      CP00=CPH
      SP00=SPH
  400 CONTINUE
C
C     APPLY EXP(-I*N*PI/2) FACTOR, SUM POWER SPECTRUM ETC
      RSC=(ASCAL+IR*BSCAL)*AMPFAC(IR)
      DR=IR*DBR2
      DO 350 IN=1,NMAX,2
      AB=AF(IN)/NPHI*RSC
      BB=BF(IN)/NPHI*RSC
      ABG(IR,IN)=AB
      BBG(IR,IN)=BB
      POWER(IN)=POWER(IN)+DR*(AB*AB+BB*BB)
      IF(IN.EQ.NMAX) GO TO 350
      AB=AF(IN+1)/NPHI*RSC
      BB=BF(IN+1)/NPHI*RSC
      ABG(IR,IN+1)=BB
      BBG(IR,IN+1)=-AB
      POWER(IN+1)=POWER(IN+1)+DR*(AB*AB+BB*BB)
  350 RSC=-RSC
C
  500 R=R+RSTEP
C      DO 901 IN=1,9
C      DO 902 IR=1,NR
C902   GMOD(IR)=SQRT(ABG(IR,IN)**2+BBG(IR,IN)**2)
C      WRITE(6,903) (ABG(IR,IN),IR=1,NR)
C      WRITE(6,903) (BBG(IR,IN),IR=1,NR)
C901   WRITE(6,903) (GMOD(IR),IR=1,NR)
C903   FORMAT(/10(/5X,10E12.3))
C
C
      POWER1=POWER(1)
      SUMP1=0.0
      PF=1.0
      DO 130 IN=1,NMAX
      IF(NORM.EQ.0) THEN
         POWER(IN)=POWER(IN)*PF
           ELSE
         POWER(IN)=POWER(IN)*PF/POWER1
      ENDIF
      INDISK=IN-1
      IF(IN.NE.1.AND.IN.LE.41) WRITE(3,131) INDISK,POWER(IN)
131   FORMAT(I5,F20.8)
      PF=2.0
  130 SUMP1=SUMP1+POWER(IN)
      WRITE(6,1006) (POWER(IN),IN=1,NMAX)
C
      NK=N
      NK1=NK+1
      SUMP3=0.0
      SUMP2=POWER(1)
      DO 230 IN=NK1,NMAX,NK
      SUMP3=SUMP3+POWER(IN)
  230 SUMP2=SUMP2+POWER(IN)
      SUMP2=SUMP2/SUMP1*100.0
      SUMP3=SUMP3/(SUMP1-POWER(1))*100.
   90 WRITE(6,1005) N,SUMP3,SUMP2
      RETURN
C
 1000 FORMAT('0LIST OF BIG G S, ANNULUS BY ANNULUS')
 1001 FORMAT(I10/(10E12.3))
 1005 FORMAT('0PERCENT OF AZIMUTHAL POWER WHICH IS',I3,'-FOLD IS',F10.2/
     1' THIS PLUS G0 IS',F10.2,' PERCENT OF TOTAL POWER')
 1006 FORMAT(///'0ROTATIONAL POWER SPECTRUM'/(1X,10F12.5))
      END
C
      SUBROUTINE LITTLG
      PARAMETER (iasize=250000)
      PARAMETER (irsize=251)
C*** jms 25.06.2010
      parameter (ibesmx = 4001)
C***      PARAMETER (BESMX=4001)
      PARAMETER (NLRP1=126)
C     Convert big G's to little g's
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      COMMON /BLOCKO/ N,NR,RSTEP,M,DXMAX,DXMIN,DELDX,DYMAX,DYMIN,DELDY,
     1ALPHA,IMX,IMY,IOPT,JOPT,NBSTEP,AMPFAC,NBMIN,LGDUMP,LGOUT,NORM
      DIMENSION AMPFAC(40),M(40),NXYZ(3)
      COMMON IBD,TWODD,MEND,MSTEP,DELBR,NLR,DELSR,NMAX,ABG,BBG,ALG,BLG
      COMMON TITLE,ASCAL,BSCAL,SCALE,PHI0,RHOMAX,RHOMIN,RHOBAR
      DIMENSION BSA(ibesmx,15),ABG(40,71),BBG(40,71),ALG(NLRP1,15),
     1 BLG(NLRP1,15),RHO(irsize,irsize),TITLE(20),GLMOD(NLRP1)
C***      EQUIVALENCE (BSA(1),ARRAY(1)),(RHO(1),ARRAY(1)),(NX,NXYZ)
      EQUIVALENCE (BSA(1,1),ARRAY(1)),(RHO(1,1),ARRAY(1)),(NX,NXYZ)
C
C      INITIALISATION OF LITTLE G'S ETC
      DO 15 ILR=1,NLR
      DO 15 IN=1,MEND
      ALG(ILR,IN)=0.0
      BLG(ILR,IN)=0.0
   15 CONTINUE
      IF(LGDUMP.NE.0) WRITE(LGOUT) TITLE
      IF(LGDUMP.NE.0) WRITE(LGOUT) N,NMAX,NLR
      TWOPI=6.28318
      DD=TWOPI*DELBR**2
      JN=1
      WRITE(6,1002)
      DO 500 IN=1,NMAX,N
      NN=IN-1
      WRITE(6,1020) NN
1020  FORMAT(///'  N =',I6)
C     HALVE FINAL ORDINATE FOR TRAPEZOIDAL RULE INTEGRATION
C     INITIAL ORDINATE AT BIGR=0 ALWAYS ZERO
      ABG(NR,IN)=0.5*ABG(NR,IN)
      BBG(NR,IN)=0.5*BBG(NR,IN)
      DO 300 ILR=1,NLR
      DO 350 IR=1,NR
      IARG=IR*(ILR-1)+1
      BS=BSA(IARG,JN)*IR*DD
      ALG(ILR,JN)=ALG(ILR,JN)+ABG(IR,IN)*BS
      BLG(ILR,JN)=BLG(ILR,JN)+BBG(IR,IN)*BS
  350 CONTINUE
      GLMOD(ILR)=SQRT(ALG(ILR,JN)**2+BLG(ILR,JN)**2)
  300 CONTINUE
      IF(LGDUMP.NE.0) WRITE(LGOUT) (ALG(ILR,JN),BLG(ILR,JN),ILR=1,NLR)
      WRITE(6,1004)
 1004 FORMAT(' REAL PART')
      WRITE(6,1003) (ALG(ILR,JN),ILR=1,NLR)
      WRITE(6,1005)
 1005 FORMAT(' IMAG PART')
      WRITE(6,1003) (BLG(ILR,JN),ILR=1,NLR)
      WRITE(6,1006)
 1006 FORMAT(' MODULUS')
      WRITE(6,1003) (GLMOD(ILR),ILR=1,NLR)
      JN=JN+1
  500 CONTINUE
      IF(LGDUMP.NE.0) REWIND LGOUT
      LGOUT=LGOUT+1
      RETURN
 1002 FORMAT('1LISTING OF LITTLE G S')
 1003 FORMAT(5X,10E12.3)
 1010 FORMAT(18A4)
 1011 FORMAT(I10)
 1012 FORMAT(F10.4,2E10.3)
      END
C
      SUBROUTINE FILTIM
      PARAMETER (iasize=250000)
      PARAMETER (irsize=251)
C*** jms 25.06.2010
      parameter (ibesmx = 4001)
C***      PARAMETER (BESMX=4001)
      PARAMETER (NLRP1=126)
C     Calculate filtered image
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      COMMON /BLOCKO/ N,NR,RSTEP,M,DXMAX,DXMIN,DELDX,DYMAX,DYMIN,DELDY,
     1ALPHA,IMX,IMY,IOPT,JOPT,NBSTEP,AMPFAC,NBMIN,LGDUMP,LGOUT,NORM
      DIMENSION AMPFAC(40),M(40),NXYZ(3)
      COMMON IBD,TWODD,MEND,MSTEP,DELBR,NLR,DELSR,NMAX,ABG,BBG,ALG,BLG
      COMMON TITLE,ASCAL,BSCAL,SCALE,PHI0,RHOMAX,RHOMIN,RHOBAR
      DIMENSION BSA(ibesmx,15),ABG(40,71),BBG(40,71),ALG(NLRP1,15),
     1 BLG(NLRP1,15),RHO(irsize,irsize),TITLE(20)
C***      EQUIVALENCE (BSA(1),ARRAY(1)),(RHO(1),ARRAY(1)),(NX,NXYZ)
      EQUIVALENCE (BSA(1,1),ARRAY(1)),(RHO(1,1),ARRAY(1)),(NX,NXYZ)
C
      AMIN=0.001*ABS(ALG(1,1))
      DO 20 IR=1,NLR
      DO 20 IN=1,MEND
      IF(ABS(ALG(IR,IN)).LT.AMIN) ALG(IR,IN)=0.0
   20 IF(ABS(BLG(IR,IN)).LT.AMIN) BLG(IR,IN)=0.0
      NNX=NLR*2-1
      NNY=NNX
      NLR=NLR-1
      RMAX=NLR-0.1
C
C     X,Y, R IN UNITS OF DELSR STEPS, NOT ANGSTROMS
      RHOMAX=-1.E10
      RHOMIN=1.E10
      RHOBAR=0.
      NRHO=0
      DO 500 IY=1,NNY
      Y=IY-NLR-1
      DO 400 IX=1,NNX
      RHO(IX,IY)=0.0
      X=IX-NLR-1
      R=SQRT(X*X+Y*Y)
      IF(R.GT.RMAX) GO TO 400
      PHI=0.0
      IF(R.EQ.0.0) GO TO 10
      PHI=ATAN2(Y,X)
   10 IR=R
      RBIT=R-IR
      NRHO=NRHO+1
      PHIN=N*PHI
      C1=COS(PHIN)
      S1=SIN(PHIN)
      C0=1.0
      S0=0.0
      IF(JOPT.EQ.0) RHO(IX,IY)=ALG(IR+1,1)*(1.0-RBIT)+ALG(IR+2,1)*RBIT
      DO 450 IN=2,MEND
      C=C1*C0-S1*S0
      S=S1*C0+C1*S0
      ADD1=ALG(IR+1,IN)*(1.-RBIT)+ALG(IR+2,IN)*RBIT
      ADD2=BLG(IR+1,IN)*(1.-RBIT)+BLG(IR+2,IN)*RBIT
      ADD1=ADD1*C*2.0
      IF(ABS(ADD1).LT.AMIN) ADD1=0.0
      ADD2=ADD2*S*2.0
      IF(ABS(ADD2).LT.AMIN) ADD2=0.0
      RHO(IX,IY)=RHO(IX,IY)+ADD1-ADD2
      C0=C
      S0=S
  450 CONTINUE
      IF(RHO(IX,IY).GT.RHOMAX) RHOMAX=RHO(IX,IY)
      IF(RHO(IX,IY).LT.RHOMIN) RHOMIN=RHO(IX,IY)
      RHOBAR=RHOBAR+RHO(IX,IY)
400   CONTINUE
  500 CONTINUE
      RHOBAR=RHOBAR/NRHO
C
      RETURN
      END
C
      SUBROUTINE FILBES
      PARAMETER (iasize=250000)
      PARAMETER (irsize=251)
C*** jms 25.06.2010
      parameter (ibesmx = 4001)
C***      PARAMETER (BESMX=4001)
      PARAMETER (NLRP1=126)
C     ROUTINE TO GENERATE POSITIVE BESSEL ORDERS FOR ALL REQ. ARGS
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      COMMON /BLOCKO/ N,NR,RSTEP,M,DXMAX,DXMIN,DELDX,DYMAX,DYMIN,DELDY,
     1ALPHA,IMX,IMY,IOPT,JOPT,NBSTEP,AMPFAC,NBMIN,LGDUMP,LGOUT,NORM
      DIMENSION AMPFAC(40),M(40),NXYZ(3)
      COMMON IBD,TWODD,MEND,MSTEP,DELBR,NLR,DELSR,NMAX,ABG,BBG,ALG,BLG
      COMMON TITLE,ASCAL,BSCAL,SCALE,PHI0,RHOMAX,RHOMIN,RHOBAR
      DIMENSION BSA(ibesmx,15),ABG(40,71),BBG(40,71),ALG(NLRP1,15),
     1 BLG(NLRP1,15),RHO(irsize,irsize),TITLE(20)
C***      EQUIVALENCE (BSA(1),ARRAY(1)),(RHO(1),ARRAY(1)),(NX,NXYZ)
      EQUIVALENCE (BSA(1,1),ARRAY(1)),(RHO(1,1),ARRAY(1)),(NX,NXYZ)
C
      DO 200 K=1,IBD
      ARG=TWODD*(K-1)
      BFA=BSL0(ARG)
      BSA(K,1)=BFA
      IF(ARG.GT.0.000001) GO TO 31
      MSTART=2
      GO TO 23
C
   31 BFB=BSL1(ARG)
      RECIP=2.0/ARG
C
      DO 100 MM=2,MEND
      JMAX=(MM-1)*MSTEP
      IF(ARG.GT.0.825*(JMAX-4.9)) GO TO 32
      MSTART=MM
      GO TO 23
   32 JMIN=(MM-2)*MSTEP+1
      DO 102 J=JMIN,JMAX
      X=J*BFB*RECIP-BFA
      BFA=BFB
      BFB=X
  102 CONTINUE
      BSA(K,MM)=BFA
  100 CONTINUE
      GO TO 200
   23 DO 105 MM=MSTART,MEND
  105 BSA(K,MM)=0.0
C
  200 CONTINUE
      RETURN
      END
C
C     Bessel function of order zero
      FUNCTION BSL0(X0)
      IF(X0-4.0)910,911,911
 910  X2=(X0/4.0)**2
      BSL0 = ((((((-0.00050144*X2+0.00767719)*X2-0.07092536)*X2+
     1  0.44435843)*X2-1.7777561)*X2+3.9999973)*X2-3.9999999)*X2+1.0
      GOTO912
 911  X1=4.0/X0
      X2 = X1**2
      P = ((((-0.00000370*X2+0.0001736)*X2-.48761E-04)*X2+0.00017343)* X
     12-0.00175306)*X2+0.39894228
      Q = (X1)*(((((0.00000323*X2-0.00001421)*X2+0.00003425)*X2-
     1  0.00008698)*X2+0.00045643)*X2-0.01246694)
      BSL0 = SQRT(X1)*(P*COS(X0-.7853981E+00)-Q*SIN(X0-.7853981E+00))
 912  RETURN
      END
C
C     Bessel function of order one
      FUNCTION BSL1(X0)
      IF(X0-4.0)913,914,914
 913  X1=X0/4.0
      X2 = X1**2
      BSL1 = X1*(((((((-0.0001290 *X2+0.0022069 )*X2-0.02366168)*X2+
     1  0.1777583 )*X2-0.8888840 )*X2+2.6666661)*X2-4.0)*X2+2.0)
      GO TO 915
 914  X1=4.0/X0
      X2 = X1**2
      P = ((((0.0000042 *X2-0.0000201 )*X2+0.0000581 )*X2-0.0002232 )*X2
     1  +0.0029218 )*X2+0.3989423
      Q = (X1)*(((((-0.0000037 *X2+0.0000162 )*X2-.398708E-04)*X2+ 0.000
     11065 )*X2-0.0006390 )*X2+0.0374008 )
      BSL1 = SQRT(X1)*(P*SIN(X0-.7853981E+00)+Q*COS(X0-.7853981E+00))
 915  RETURN
      END
C
C     Routine for bilinear interpolation in transform
C     at position X,Y in transform steps; A,B are real and
C     imaginary parts of transform corrected for phase origin
      SUBROUTINE INTERPTS(X,Y,A,B)
      PARAMETER (iasize=250000)
      COMMON /BLOCKT/NX,NY,NZ,ARRAY(iasize),ORIGX,ORIGY,DELPX,DELPY,
     1 NXP2,KY
      IF(X.GE.0.) THEN
          XX=X
          YY=Y
             ELSE
          XX=-X
          YY=-Y
      ENDIF
C
10    IX=XX
      XFR=XX-IX
      IY=YY+KY
      YFR=YY-IY+KY
      XBAR=1.-XFR
      YBAR=1.-YFR
C     Indices and phase shifts for 4 nearest points
      IND=IY*NXP2+2*IX+1
      PSHFT=IX*DELPX+(IY-KY)*DELPY
      CALL SHIFT(A1,B1,PSHFT,IND,ARRAY)
      IND=IND+2
      PSHFT=PSHFT+DELPX
      CALL SHIFT(A2,B2,PSHFT,IND,ARRAY)
      IND=IND+NXP2
      PSHFT=PSHFT+DELPY
      CALL SHIFT(A4,B4,PSHFT,IND,ARRAY)
      IND=IND-2
      PSHFT=PSHFT-DELPX
      CALL SHIFT(A3,B3,PSHFT,IND,ARRAY)
      A=A1*XBAR*YBAR+A2*XFR*YBAR+A3*XBAR*YFR+A4*XFR*YFR
      B=B1*XBAR*YBAR+B2*XFR*YBAR+B3*XBAR*YFR+B4*XFR*YFR
      IF(X.LT.0.) B=-B
      RETURN
      END
C
C
C     Routine to return phase origin corrected transform value
      SUBROUTINE SHIFT(APART,BPART,PSHFT,IND,ARRAY)
C*** jms mod dimension 1 fails with g77 21-Apr-09
      PARAMETER (iasize=250000)
      DIMENSION ARRAY(iasize)
c      DIMENSION ARRAY(1)
      C=COS(PSHFT)
      S=SIN(PSHFT)
      APART=ARRAY(IND)*C-ARRAY(IND+1)*S
      BPART=ARRAY(IND)*S+ARRAY(IND+1)*C
      RETURN
      END
