
# TODO:
# distribute module level variables between relevant classes
# add help
# use 'body' tag to put widgets on empty page
# table class is not complete and cannot yet be used in morda

import os, sys
import json
import pyrvapi
from pyrvapi import rvapi_flush as flush

class document(object):
  alias = 'doc'
  _instance = None
  _report_key = '_reportdir_'
  _report_default = 'report'

  @classmethod
  def newdoc(
    cls,
    wintitle='Untitled',
    docfile=None,
    reportdir=None,
    jslib=None,
    html='index.html',
    xml=None,
    ostream=None,
    layout=pyrvapi.RVAPI_LAYOUT_Full,
    abspaths=False,
  ):
    assert not cls._instance

    if not jslib:
      jslib = os.environ.get('DIRJSRVIEW')

    if not jslib:
      ccp4 = os.environ.get('CCP4')
      if ccp4:
        jslib = os.path.join(ccp4, 'share', 'jsrview')

    if not reportdir:
      reportdir = cls._report_default

    if not os.path.isdir(reportdir):
      assert not os.path.exists(reportdir)
      os.mkdir(reportdir)

    if ostream:
      print >>ostream, 'JavaScript library:', jslib
      print >>ostream, 'Report directory:  ', reportdir
      print >>ostream, 'Python executable: ', sys.executable
      pfilter = lambda p: p.startswith('/Library') or os.path.abspath(p) == os.getcwd()
      pp = [p for p in sys.path if not pfilter(p)]
      pp.insert(0, 'In python path:')
      print >>ostream, '\n  '.join(pp)

    #// Document modes
    #define RVAPI_MODE_Silent  0x00100000
    #define RVAPI_MODE_Html    0x00000001
    #define RVAPI_MODE_Xmli2   0x00000002

    mode = pyrvapi.RVAPI_MODE_Html | bool(xml)* pyrvapi.RVAPI_MODE_Xmli2

    #// Document layouts
    #define RVAPI_LAYOUT_Header   0x00000001
    #define RVAPI_LAYOUT_Toolbar  0x00000002
    #define RVAPI_LAYOUT_Tabs     0x00000004
    #define RVAPI_LAYOUT_Full     0x00000007

    xml_relpath =  os.path.relpath(xml, reportdir) if xml else None
    docid = 'TestRun'
    pyrvapi.rvapi_init_document(
      docid,             # const char * docId      // mandatory
      reportdir,         # const char * outDir     // mandatory
      wintitle,          # const char * winTitle   // mandatory
      mode,              # const int    mode       // mandatory
      layout,            # const int    layout     // mandatory
      jslib,             # const char * jsUri      // needed
      None,              # const char * helpFName  // may be NULL
      html,              # const char * htmlFName  // may be NULL
      None,              # const char * taskFName  // may be NULL
      xml_relpath        # const char * xmli2FName // may be NULL
    )

    cls._instance = cls(dict(), reportdir, docfile, abspaths)
    return cls._instance

  @classmethod
  def fromfile(cls, docfile):
    assert not cls._instance
    pyrvapi.rvapi_restore_document2(docfile)
    meta_str = pyrvapi.rvapi_get_meta()
    meta_dict = json.loads(meta_str)
    meta = dict()
    for k, v in meta_dict.items():
      meta[str(k)] = str(v)

    reportdir = meta.pop(cls._report_key, cls._report_default)
    cls._instance = cls(meta, reportdir, docfile)
    return cls._instance

  def __init__(self, meta, reportdir, docfile, abspaths=False):
    self.meta = meta
    self._docfile = docfile
    self._reportdir = reportdir
    self._abspaths = abspaths

  def add_header(self, header):
    pyrvapi.rvapi_add_header(header)

  def _relpath(self, path):
    if self._abspaths:
      return os.path.abspath(path) if path else None

    else:
      return os.path.relpath(path, self._reportdir) if path else None

  def close(self, keep_polling=True):
    if self._docfile:
      self.meta[self._report_key] = self._reportdir
      kwdargs = dict(sort_keys=True, indent=4, separators=(',', ': '))
      meta_string = json.dumps(self.meta, **kwdargs)
      pyrvapi.rvapi_put_meta(meta_string)
      pyrvapi.rvapi_keep_polling(keep_polling)
      pyrvapi.rvapi_store_document2(self._docfile)

class LeafCounter(object):

  def __init__(self, cls, *ind_list):
    items = [str(ind) for ind in ind_list]
    items.insert(0, cls.alias)
    items.append('')
    self.prefix = '.'.join(items)
    self.cou = 0

  def get_id(self):
    self.cou += 1
    return self.cou, self.prefix + str(self.cou)

class Counter(object):
  cou = 0
  shown = False

  @classmethod
  def get_id(cls):
    exists = True
    while exists:
      cls.cou += 1
      id = "%s_%02d" %(cls.__name__, cls.cou)
      exists = pyrvapi.rvapi_exists(id)

    return cls.cou, id

  def __str__(self):
    return self.id

  def remove(self):
    pyrvapi.rvapi_remove_widget(self.id)
    flush()
    self.shown = False

  def add_text(self, textString, *args):
    if args:
      pyrvapi.rvapi_add_text(textString, self.id, *args)

    else:
      pyrvapi.rvapi_append_text(textString, self.id)

class pyrvapi_tab(Counter):
  alias = 'tab'

  def __init__(self, name, before=None, open=True):
    ind, self.id = self.get_id()
    if before:
      before_id = before if isinstance(before, str) else before.id
      pyrvapi.rvapi_insert_tab(self.id, name, before_id, open)

    else:
      pyrvapi.rvapi_add_tab(self.id, name, open)

class pyrvapi_section(Counter):
  alias = 'sec'

  def __init__(self, holder, title, irow, icol, nrow, ncol, state=1):
    ind, self.id = self.get_id()
    self.title = title
    holder_id = holder if isinstance(holder, str) else holder.id
    self.args = holder_id, irow, icol, nrow, ncol, state
    self.draw()

  def set_state(self, state=True):
    pyrvapi.rvapi_set_section_state(self.id, bool(state))

  def draw(self):
    assert not self.shown
    self.shown = True
    pyrvapi.rvapi_add_section(self.id, self.title, *self.args)

class pyrvapi_table(Counter):
  alias = 'tbl'

  def __init__(self, grid, igr, igc, ngr, ngc, title, state):
    ind, self.id = self.get_id()
    pyrvapi.rvapi_add_table(self.id, title, grid.id, igr, igc, ngr, ngc, state)

  def col_title(self, itc, text='', tooltip=''):
    pyrvapi.rvapi_put_horz_theader(self.id, text, tooltip, itc)

  def row_title(self, itr, text='', tooltip=''):
    pyrvapi.rvapi_put_vert_theader(self.id, text, tooltip, itr)

  def body_cell(self, itr, itc, value='', style=''):
    pyrvapi.rvapi_put_table_string(self.id, str(value), itr, itc)
    if style:
      pyrvapi.rvapi_shape_table_cell(self.id, itr, itc, '', style, '', 1, 1)

  def cell_data(self, itr, itc, value=''):
    pyrvapi.rvapi_put_table_string(self.id, str(value), itr, itc)

  def cell_shape(self, itr, itc, rowSpan, colSpan, style='', css='', tooltip=''):
      pyrvapi.rvapi_shape_table_cell(self.id, itr, itc, tooltip, style, css, rowSpan, colSpan)

class pyrvapi_pdb_mtz(Counter):
  alias = 'dat'
  id = args = title = None
  pdbrel = mtzrel = m11rel = m21rel = None

  def __init__(self, title, grid, igr, igc, ngr, ngc, state):
    ind, self.id = self.get_id()
    self.title = title
    self.args = grid.id, igr, igc, ngr, ngc, state

  def set_paths(self, pdbpath, mtzpath, m11path=None, m21path=None):
    doc = document._instance
    self.pdbrel = doc._relpath(pdbpath)
    self.mtzrel = doc._relpath(mtzpath)
    self.m11rel = doc._relpath(m11path)
    self.m21rel = doc._relpath(m21path)

  def draw(self):
    if self.pdbrel and self.mtzrel:
      pyrvapi.rvapi_add_data(self.id, self.title, self.pdbrel, 'xyz', *self.args)
      pyrvapi.rvapi_append_to_data(self.id, self.mtzrel, 'hkl:map')
      if self.m11rel and self.m21rel:
        pyrvapi.rvapi_append_to_data(self.id, self.m21rel, 'hkl:ccp4_map')
        pyrvapi.rvapi_append_to_data(self.id, self.m11rel, 'hkl:ccp4_dmap')

class pyrvapi_content(Counter):

  def __init__(self, t, file, watch=True):
    doc = document._instance
    relpath = doc._relpath(file)
    ind, self.id = self.get_id()
    pyrvapi.rvapi_append_content(relpath, watch, t.id)


# ------ new part starts here ------


class radar(Counter):
    alias = 'tree'

    def __init__(self, holder, title, *args):
        ind, self.id = self.get_id()
        self.tree = self
        holder_id = holder if isinstance(holder, str) else holder.id
        assert len(args) in (1, 5)
        if len(args) == 5:
            pyrvapi.rvapi_add_radar(self.id, title, holder_id, *args)

        else:
            pyrvapi.rvapi_append_radar(self.id, title, holder_id, *args)

    def add_property(self, name, value):
        pyrvapi.rvapi_add_radar_property(self.id, name, value)


class tree_widget(Counter):
    alias = 'tree'

    def __init__(self, holder, title, *args):
        ind, self.id = self.get_id()
        self.tree = self
        holder_id = holder if isinstance(holder, str) else holder.id
        if args:
            pyrvapi.rvapi_add_tree_widget(self.id, title, holder_id, *args)

        else:
            pyrvapi.rvapi_append_tree_widget(self.id, title, holder_id)


class tree_node(Counter):
    alias = 'node'

    def __init__(self, parent, title, openState):
        ind, self.id = self.get_id()
        self.tree = parent.tree
        parent_id = '' if parent is parent.tree else parent.id
        pyrvapi.rvapi_add_panel(self.id, self.tree.id, 0, 0, 1, 1)
        pyrvapi.rvapi_set_tree_node(self.tree.id, self.id, title, openState, parent_id)


class panel(Counter):
    alias = 'panel'

    def __init__(self, holder, row, col, rowSpan, colSpan):
        ind, self.id = self.get_id()
        holder_id = holder if isinstance(holder, str) else holder.id
        pyrvapi.rvapi_add_panel(self.id, holder_id, row, col, rowSpan, colSpan)


class loggraph(Counter):
    alias = 'gwd'

    def __init__(self, holder, *args):
        self.ind, self.id = self.get_id()
        self.plt_cou = LeafCounter(graph_plot, self.ind)
        self.gdt_cou = LeafCounter(graph_data, self.ind)
        holder_id = holder if isinstance(holder, str) else holder.id
        self._draw(holder_id, *args)

    def _draw(self, holder_id, *args):
        if args:
            row, col, rowSpan, colSpan = args
            pyrvapi.rvapi_add_loggraph(self.id, holder_id, row, col, rowSpan, colSpan)

        else:
            pyrvapi.rvapi_append_loggraph(self.id, holder_id)

    def set_size(self, width, height):
        pyrvapi.rvapi_set_graph_size(self.id, width, height)


class graph(loggraph):
    alias = 'graph'

    def _draw(self, holder_id, row, col, rowSpan, colSpan):
        pyrvapi.rvapi_add_graph(self.id, holder_id, row, col, rowSpan, colSpan)


class graph_data(object):
    alias = 'gdt'

    def __init__(self, gwd, gdtTitle):
        ind, self.id = gwd.gdt_cou.get_id()
        self.set_cou = LeafCounter(graph_dataset, gwd.ind, ind)
        self.gwd = gwd
        pyrvapi.rvapi_add_graph_data(self.id, gwd.id, gdtTitle)
        self.datasets = set()


class graph_dataset(object):
    alias = 'set'

    def __init__(self, gdt, setName, setHeader, isint=True, fmt='%g'):
        ind, self.id = gdt.set_cou.get_id()
        self.gdt = gdt
        self.fmt = fmt
        self.isint = isint
        pyrvapi.rvapi_add_graph_dataset(self.id, gdt.id, gdt.gwd.id, setName, setHeader)
        gdt.datasets.add(self.id)

    def reset(self):
        pyrvapi.rvapi_reset_graph_dataset(self.id, self.gdt.id, self.gdt.gwd.id)


    def add_datum(self, v):
        if self.isint:
          pyrvapi.rvapi_add_graph_int(self.id, self.gdt.id, self.gdt.gwd.id, v)

        else:
          pyrvapi.rvapi_add_graph_real(self.id, self.gdt.id, self.gdt.gwd.id, v, self.fmt)


class graph_plot(object):
    alias = 'plt'

    def __init__(self, gwd, pltTitle, xName, yName):
        ind, self.id = gwd.plt_cou.get_id()
        self.gwd = gwd
        pyrvapi.rvapi_add_graph_plot(self.id, gwd.id, pltTitle, xName, yName)

    def set_default(self):
        pyrvapi.rvapi_set_default_plot(self.id, self.gwd.id)

    def set_log(self, logx, logy):
        pyrvapi.rvapi_set_plot_log(self.id, self.gwd.id, logx, logy)

    def set_plot_int(self, intx, inty):
        pyrvapi.rvapi_set_plot_int(self.id, self.gwd.id, intx, inty)

    def set_xmin(self, xmin):
        pyrvapi.rvapi_set_plot_xmin(self.id, self.gwd.id, xmin)

    def set_xmax(self, xmax):
        pyrvapi.rvapi_set_plot_xmax(self.id, self.gwd.id, xmax)

    def set_xrange(self, xmin, xmax):
        pyrvapi.rvapi_set_plot_xrange(self.id, self.gwd.id, xmin, xmax)

    def set_ymin(self, ymin):
        pyrvapi.rvapi_set_plot_ymin(self.id, self.gwd.id, ymin)

    def set_ymax(self, ymax):
        pyrvapi.rvapi_set_plot_ymax(self.id, self.gwd.id, ymax)

    def set_yrange(self, ymin, ymax):
        pyrvapi.rvapi_set_plot_yrange(self.id, self.gwd.id, ymin, ymax)

    def set_xslider(self, smin, smax):
        pyrvapi.rvapi_set_plot_xslider(self.id, self.gwd.id, smin, smax)

    def set_yslider(self, smin, smax):
        pyrvapi.rvapi_set_plot_yslider(self.id, self.gwd.id, smin, smax)

    def set_legend(self, location='', placement=''):
        pyrvapi.rvapi_set_plot_legend(self.id, self.gwd.id, location, placement)

    def reset_xticks(self):
        pyrvapi.rvapi_reset_plot_xticks(self.id, self.gwd.id)

    def reset_yticks(self):
        pyrvapi.rvapi_reset_plot_yticks(self.id, self.gwd.id)

    def add_xtick(self, value, label):
        pyrvapi.rvapi_add_plot_xtick(self.id, self.gwd.id, value, label)

    def add_ytick(self, value, label):
        pyrvapi.rvapi_add_plot_ytick(self.id, self.gwd.id, value, label)


class plot_line(object):
    RVAPI_LINE_Bars = pyrvapi.RVAPI_LINE_Bars
    RVAPI_LINE_Center = pyrvapi.RVAPI_LINE_Center
    RVAPI_LINE_Dashed = pyrvapi.RVAPI_LINE_Dashed
    RVAPI_LINE_Dotted = pyrvapi.RVAPI_LINE_Dotted
    RVAPI_LINE_Off = pyrvapi.RVAPI_LINE_Off
    RVAPI_LINE_Solid = pyrvapi.RVAPI_LINE_Solid

    def __init__(self, plt, gdt, xset, yset):
        assert xset.id in gdt.datasets
        assert yset.id in gdt.datasets
        self.plt = plt
        self.gdt = gdt
        self.xset = xset
        self.yset = yset
        pyrvapi.rvapi_add_plot_line(plt.id, gdt.id, gdt.gwd.id, xset.id, yset.id)

    def set_options(self, color='', style='', marker='', width=0.0, shown=True):
        plt = self.plt; gdt = self.gdt; gwd = gdt.gwd
        pyrvapi.rvapi_set_line_options(self.yset.id, plt.id, gdt.id, gwd.id, color, style, marker, width, shown)
        # color           Html color
        # style           RVAPI_LINE_XXX
        # marker          RVAPI_MARKER_XXX
        # width           2.5 default
        # empty color, style, marker and negative/zero width don't change the corresponding settings


    def set_line_fill(self, fill='', fillAndStroke='', fillColor='', fillAlpha=''):
        plt = self.plt; gdt = self.gdt; gwd = gdt.gwd
        pyrvapi.rvapi_set_line_fill(self.yset.id, plt.id, gdt.id, gwd.id, fill, fillAndStroke, fillColor, fillAlpha)
        # fill            fill under line
        # fillAndStroke   keep line
        # fillColor       Html color
        # fillAlpha       0..1


vars().update([(k.partition('_')[2], v) for k, v in sorted(vars(pyrvapi).items()) if k.startswith('RVAPI_')])

