#!/bin/bash

cd `dirname "$0"`
dir=`pwd`
master=`dirname $dir`
subdir=`basename $dir`

echo "";
echo "";
echo "################################ Install CCP-EM ################################";

################### confirm CCP-EM licence ###################

if [ -f $HOME/.agree2ccpemv1 ]; then
    agreed=yes
else
    more conditions.txt
    echo
    echo -n "Do you accept the terms of the CCP-EM licence? y/n [n] "
    read ans
    if [ "$ans" = y -o $ans = Y -o $ans = yes -o $ans = YES ]; then 
        agreed=yes
    fi
fi

if [ "$agreed" = "yes" ]; then
    echo `date` "$subdir" >> $HOME/.agree2ccpemv1
else
    echo " You have indicated that you do not agree to the conditions";
    echo " of use for the CCP-EM package. Please delete all CCP-EM software";
    echo " from your system. If you have any further queries please refer ";
    echo " to the CCP-EM web pages on http://www.ccpem.ac.uk/ or contact" ;
    echo " ccpem@stfc.ac.uk";
    exit 1
fi

################### final setup ###################

echo 'Setting up paths...'

sed "s|\(CCPEM=\).*|\1$dir|" include/setup_ccpem.sh.in > setup_ccpem.sh

sed "s|\(setenv CCPEM \).*|\1$dir|" include/setup_ccpem.csh.in > setup_ccpem.csh


# the --minimal option is for quick testing only
[ "$1" = "--minimal" ] && exit

echo 'Compiling py-files'
(CCPEM=$dir $dir/bin/ccpem-python -Wignore -m compileall \
 $dir/lib/py2 $dir/lib/python2.7 >/dev/null)


################### checks for common problems ###################

if ! $dir/bin/ccpem-python -c "import numpy" >/dev/null; then
    echo
    echo "ERROR: starting an example CCP-EM program failed !!!"
    echo "Please check you downloaded the version for your operating system,"
    echo "or contact ccpem@stfc.ac.uk for assistance."
    echo
fi

if [ -z "$CCP4" ]; then
    echo
    echo "  Warning: CCP4 not found!"
    echo
    echo "  Several CCP-EM tasks use CCP4 programs. To use those tasks, please install"
    echo "  and set up CCP4 before running CCP-EM. CCP4 is available from www.ccp4.ac.uk."
    echo
else
    output="$($CCP4/bin/refmac5 -i | head -1)"
    if [ -z "$output" ]; then
        echo
        echo "  Warning: problem running an example CCP4 program!"
        echo
        echo "  Several CCP-EM tasks use CCP4 programs. Please check your CCP4 installation,"
        echo "  or contact ccpem@stfc.ac.uk for assistance."
        echo
    else
        version=${output##* }  # bash substring removal: keep only from the last space onwards
        if [[ "${version%.*}" != "7.0" || (( ${version##*.} < 062 )) ]]; then
            echo
            echo "  Your CCP4 installation (version ${version}) appears to be out of date."
            echo "  We recommend using version 7.0.062 or later for best results."
            echo
        fi
    fi
fi


echo
echo "         Before running CCPEM programs from command line,"
echo "         source setup_ccpem.sh"
echo "         (or setup_ccpem.csh if you use csh)."
echo

################### Install Modeller ###################
# Only required for linux; modeller found automatically on mac
if [ "$(uname)" = "Linux" ]; then
    if [ -d "$dir/lib/modeller" ]; then
        echo
        echo "To install modeller (for Flex-EM and other programs) please run ";
        echo "     install_modeller.sh";
        echo
#       Don't run now as halts build system
#        $dir/install_modeller.sh
    fi
fi
