#   residue    atoms        mean    stdev
bonds = [
    ( 'ALA', ('CB', 'CA'), 1.5259, 0.0163 ),
    ( 'ALA', ('N', 'CA'), 1.4601, 0.0108 ),
    ( 'ALA', ('O', 'C'), 1.2329, 0.0104 ),
    ( 'ALA', ('C', 'CA'), 1.5255, 0.0112 ),
    ( 'ALA', ('C', '+N'), 1.3299, 0.0094 ),
    ( 'CYS', ('CB', 'CA'), 1.5310, 0.0126 ),
    ( 'CYS', ('SG', 'CB'), 1.8105, 0.0209 ),
    ( 'CYS', ('N', 'CA'), 1.4591, 0.0113 ),
    ( 'CYS', ('O', 'C'), 1.2324, 0.0104 ),
    ( 'CYS', ('C', 'CA'), 1.5240, 0.0122 ),
    ( 'CYS', ('C', '+N'), 1.3296, 0.0109 ),
    ( 'ASP', ('CB', 'CA'), 1.5321, 0.0115 ),
    ( 'ASP', ('CG', 'CB'), 1.5172, 0.0155 ),
    ( 'ASP', ('OD1', 'CG'), 1.2505, 0.0130 ),
    ( 'ASP', ('OD2', 'CG'), 1.2512, 0.0146 ),
    ( 'ASP', ('N', 'CA'), 1.4601, 0.0110 ),
    ( 'ASP', ('O', 'C'), 1.2325, 0.0099 ),
    ( 'ASP', ('C', 'CA'), 1.5258, 0.0115 ),
    ( 'ASP', ('C', '+N'), 1.3298, 0.0089 ),
    ( 'GLU', ('CB', 'CA'), 1.5318, 0.0109 ),
    ( 'GLU', ('CG', 'CB'), 1.5221, 0.0164 ),
    ( 'GLU', ('CD', 'CG'), 1.5200, 0.0142 ),
    ( 'GLU', ('OE1', 'CD'), 1.2514, 0.0125 ),
    ( 'GLU', ('OE2', 'CD'), 1.2524, 0.0143 ),
    ( 'GLU', ('N', 'CA'), 1.4593, 0.0105 ),
    ( 'GLU', ('O', 'C'), 1.2324, 0.0097 ),
    ( 'GLU', ('C', 'CA'), 1.5252, 0.0111 ),
    ( 'GLU', ('C', '+N'), 1.3297, 0.0083 ),
    ( 'PHE', ('CB', 'CA'), 1.5339, 0.0113 ),
    ( 'PHE', ('CG', 'CB'), 1.5055, 0.0127 ),
    ( 'PHE', ('CD1', 'CG'), 1.3904, 0.0097 ),
    ( 'PHE', ('CD2', 'CG'), 1.3903, 0.0096 ),
    ( 'PHE', ('CE1', 'CD1'), 1.3938, 0.0141 ),
    ( 'PHE', ('CE2', 'CD2'), 1.3937, 0.0141 ),
    ( 'PHE', ('CZ', 'CE1'), 1.3883, 0.0144 ),
    ( 'PHE', ('CZ', 'CE2'), 1.3884, 0.0143 ),
    ( 'PHE', ('N', 'CA'), 1.4593, 0.0109 ),
    ( 'PHE', ('O', 'C'), 1.2324, 0.0099 ),
    ( 'PHE', ('C', 'CA'), 1.5245, 0.0118 ),
    ( 'PHE', ('C', '+N'), 1.3295, 0.0094 ),
    ( 'GLY', ('N', 'CA'), 1.4538, 0.0108 ),
    ( 'GLY', ('O', 'C'), 1.2331, 0.0101 ),
    ( 'GLY', ('C', 'CA'), 1.5177, 0.0102 ),
    ( 'GLY', ('C', '+N'), 1.3298, 0.0091 ),
    ( 'HIS', ('CB', 'CA'), 1.5329, 0.0123 ),
    ( 'HIS', ('CG', 'CB'), 1.4973, 0.0096 ),
    ( 'HIS', ('ND1', 'CG'), 1.3781, 0.0097 ),
    ( 'HIS', ('CD2', 'CG'), 1.3552, 0.0076 ),
    ( 'HIS', ('CE1', 'ND1'), 1.3233, 0.0086 ),
    ( 'HIS', ('NE2', 'CD2'), 1.3736, 0.0113 ),
    ( 'HIS', ('N', 'CA'), 1.4595, 0.0110 ),
    ( 'HIS', ('O', 'C'), 1.2325, 0.0105 ),
    ( 'HIS', ('C', 'CA'), 1.5247, 0.0121 ),
    ( 'HIS', ('C', '+N'), 1.3298, 0.0093 ),
    ( 'HIS', ('NE2', 'CE1'), 1.3220, 0.0084 ),
    ( 'ILE', ('CB', 'CA'), 1.5468, 0.0155 ),
    ( 'ILE', ('CG1', 'CB'), 1.5327, 0.0106 ),
    ( 'ILE', ('CG2', 'CB'), 1.5292, 0.0172 ),
    ( 'ILE', ('CD1', 'CG1'), 1.5197, 0.0245 ),
    ( 'ILE', ('N', 'CA'), 1.4594, 0.0108 ),
    ( 'ILE', ('O', 'C'), 1.2329, 0.0100 ),
    ( 'ILE', ('C', 'CA'), 1.5259, 0.0113 ),
    ( 'ILE', ('C', '+N'), 1.3297, 0.0089 ),
    ( 'LYS', ('CB', 'CA'), 1.5314, 0.0104 ),
    ( 'LYS', ('CG', 'CB'), 1.5221, 0.0176 ),
    ( 'LYS', ('CD', 'CG'), 1.5240, 0.0182 ),
    ( 'LYS', ('CE', 'CD'), 1.5237, 0.0174 ),
    ( 'LYS', ('NZ', 'CE'), 1.4936, 0.0173 ),
    ( 'LYS', ('N', 'CA'), 1.4597, 0.0106 ),
    ( 'LYS', ('O', 'C'), 1.2325, 0.0097 ),
    ( 'LYS', ('C', 'CA'), 1.5254, 0.0110 ),
    ( 'LYS', ('C', '+N'), 1.3295, 0.0088 ),
    ( 'LEU', ('CB', 'CA'), 1.5321, 0.0105 ),
    ( 'LEU', ('CG', 'CB'), 1.5312, 0.0113 ),
    ( 'LEU', ('CD2', 'CG'), 1.5236, 0.0167 ),
    ( 'LEU', ('CD1', 'CG'), 1.5232, 0.0165 ),
    ( 'LEU', ('N', 'CA'), 1.4594, 0.0108 ),
    ( 'LEU', ('O', 'C'), 1.2325, 0.0103 ),
    ( 'LEU', ('C', 'CA'), 1.5249, 0.0114 ),
    ( 'LEU', ('C', '+N'), 1.3297, 0.0089 ),
    ( 'MET', ('CB', 'CA'), 1.5316, 0.0114 ),
    ( 'MET', ('CG', 'CB'), 1.5213, 0.0209 ),
    ( 'MET', ('SD', 'CG'), 1.8206, 0.0464 ),
    ( 'MET', ('CE', 'SD'), 1.7964, 0.0643 ),
    ( 'MET', ('N', 'CA'), 1.4602, 0.0125 ),
    ( 'MET', ('O', 'C'), 1.2323, 0.0099 ),
    ( 'MET', ('C', 'CA'), 1.5248, 0.0116 ),
    ( 'MET', ('C', '+N'), 1.3298, 0.0089 ),
    ( 'ASN', ('CB', 'CA'), 1.5325, 0.0115 ),
    ( 'ASN', ('CG', 'CB'), 1.5169, 0.0151 ),
    ( 'ASN', ('OD1', 'CG'), 1.2338, 0.0118 ),
    ( 'ASN', ('ND2', 'CG'), 1.3282, 0.0128 ),
    ( 'ASN', ('N', 'CA'), 1.4597, 0.0110 ),
    ( 'ASN', ('O', 'C'), 1.2325, 0.0103 ),
    ( 'ASN', ('C', 'CA'), 1.5252, 0.0117 ),
    ( 'ASN', ('C', '+N'), 1.3297, 0.0093 ),
    ( 'PRO', ('O', 'C'), 1.2333, 0.0102 ),
    ( 'PRO', ('C', 'CA'), 1.5257, 0.0116 ),
    ( 'PRO', ('C', '+N'), 1.3292, 0.0093 ),
    ( 'PRO', ('N', 'CA'), 1.4654, 0.0095 ),
    ( 'PRO', ('CA', 'CB'), 1.5300, 0.0104 ),
    ( 'PRO', ('CB', 'CG'), 1.4980, 0.0242 ),
    ( 'PRO', ('CG', 'CD'), 1.5106, 0.0183 ),
    ( 'PRO', ('N', 'CD'), 1.4753, 0.0089 ),
    ( 'GLN', ('CB', 'CA'), 1.5316, 0.0112 ),
    ( 'GLN', ('CG', 'CB'), 1.5228, 0.0188 ),
    ( 'GLN', ('CD', 'CG'), 1.5183, 0.0155 ),
    ( 'GLN', ('OE1', 'CD'), 1.2347, 0.0133 ),
    ( 'GLN', ('NE2', 'CD'), 1.3289, 0.0131 ),
    ( 'GLN', ('N', 'CA'), 1.4595, 0.0109 ),
    ( 'GLN', ('O', 'C'), 1.2326, 0.0104 ),
    ( 'GLN', ('C', 'CA'), 1.5251, 0.0114 ),
    ( 'GLN', ('C', '+N'), 1.3297, 0.0091 ),
    ( 'ARG', ('CB', 'CA'), 1.5314, 0.0111 ),
    ( 'ARG', ('CG', 'CB'), 1.5212, 0.0195 ),
    ( 'ARG', ('CD', 'CG'), 1.5227, 0.0195 ),
    ( 'ARG', ('NE', 'CD'), 1.4605, 0.0124 ),
    ( 'ARG', ('CZ', 'NE'), 1.3301, 0.0099 ),
    ( 'ARG', ('NH1', 'CZ'), 1.3291, 0.0094 ),
    ( 'ARG', ('NH2', 'CZ'), 1.3280, 0.0096 ),
    ( 'ARG', ('N', 'CA'), 1.4594, 0.0107 ),
    ( 'ARG', ('O', 'C'), 1.2326, 0.0099 ),
    ( 'ARG', ('C', 'CA'), 1.5252, 0.0113 ),
    ( 'ARG', ('C', '+N'), 1.3296, 0.0087 ),
    ( 'SER', ('CB', 'CA'), 1.5313, 0.0115 ),
    ( 'SER', ('OG', 'CB'), 1.4176, 0.0125 ),
    ( 'SER', ('N', 'CA'), 1.4594, 0.0111 ),
    ( 'SER', ('O', 'C'), 1.2327, 0.0101 ),
    ( 'SER', ('C', 'CA'), 1.5248, 0.0115 ),
    ( 'SER', ('C', '+N'), 1.3297, 0.0101 ),
    ( 'THR', ('CB', 'CA'), 1.5429, 0.0162 ),
    ( 'THR', ('OG1', 'CB'), 1.4336, 0.0105 ),
    ( 'THR', ('CG2', 'CB'), 1.5241, 0.0172 ),
    ( 'THR', ('N', 'CA'), 1.4591, 0.0110 ),
    ( 'THR', ('O', 'C'), 1.2329, 0.0104 ),
    ( 'THR', ('C', 'CA'), 1.5249, 0.0115 ),
    ( 'THR', ('C', '+N'), 1.3296, 0.0093 ),
    ( 'VAL', ('CB', 'CA'), 1.5468, 0.0152 ),
    ( 'VAL', ('CG1', 'CB'), 1.5253, 0.0169 ),
    ( 'VAL', ('CG2', 'CB'), 1.5250, 0.0172 ),
    ( 'VAL', ('N', 'CA'), 1.4592, 0.0108 ),
    ( 'VAL', ('O', 'C'), 1.2330, 0.0102 ),
    ( 'VAL', ('C', 'CA'), 1.5260, 0.0113 ),
    ( 'VAL', ('C', '+N'), 1.3296, 0.0089 ),
    ( 'TRP', ('CB', 'CA'), 1.5334, 0.0121 ),
    ( 'TRP', ('CG', 'CB'), 1.5003, 0.0174 ),
    ( 'TRP', ('CD1', 'CG'), 1.3673, 0.0102 ),
    ( 'TRP', ('CD2', 'CG'), 1.4318, 0.0109 ),
    ( 'TRP', ('NE1', 'CD1'), 1.3750, 0.0113 ),
    ( 'TRP', ('CE2', 'CD2'), 1.4122, 0.0080 ),
    ( 'TRP', ('CZ2', 'CE2'), 1.3984, 0.0092 ),
    ( 'TRP', ('CZ3', 'CE3'), 1.3913, 0.0131 ),
    ( 'TRP', ('CH2', 'CZ2'), 1.3722, 0.0091 ),
    ( 'TRP', ('N', 'CA'), 1.4593, 0.0107 ),
    ( 'TRP', ('O', 'C'), 1.2328, 0.0100 ),
    ( 'TRP', ('C', 'CA'), 1.5249, 0.0114 ),
    ( 'TRP', ('C', '+N'), 1.3297, 0.0087 ),
    ( 'TRP', ('CZ3', 'CH2'), 1.4047, 0.0107 ),
    ( 'TRP', ('CD2', 'CE3'), 1.4013, 0.0073 ),
    ( 'TRP', ('NE1', 'CE2'), 1.3701, 0.0085 ),
    ( 'TYR', ('CB', 'CA'), 1.5336, 0.0122 ),
    ( 'TYR', ('CG', 'CB'), 1.5118, 0.0116 ),
    ( 'TYR', ('CD1', 'CG'), 1.3935, 0.0095 ),
    ( 'TYR', ('CD2', 'CG'), 1.3929, 0.0098 ),
    ( 'TYR', ('CE1', 'CD1'), 1.3925, 0.0139 ),
    ( 'TYR', ('CE2', 'CD2'), 1.3919, 0.0137 ),
    ( 'TYR', ('CZ', 'CE1'), 1.3843, 0.0116 ),
    ( 'TYR', ('CZ', 'CE2'), 1.3839, 0.0114 ),
    ( 'TYR', ('OH', 'CZ'), 1.3776, 0.0104 ),
    ( 'TYR', ('N', 'CA'), 1.4591, 0.0110 ),
    ( 'TYR', ('O', 'C'), 1.2326, 0.0102 ),
    ( 'TYR', ('C', 'CA'), 1.5242, 0.0118 ),
    ( 'TYR', ('C', '+N'), 1.3296, 0.0090 ),
  ]

def make_restraints(atmsel, restraints, num_selected):
    from modeller import forms, physical, features
    for (res, atoms, mean, stdev) in bonds:
        for a in atmsel.find_atoms(res, atoms, num_selected):
            r = forms.gaussian(physical.bond, features.distance(*a), mean,
                               stdev)
            restraints.add(r)
