#
#     Copyright (C) 2018 CCP-EM
#
#     This code is distributed under the terms and conditions of the
#     CCP-EM Program Suite Licence Agreement as a CCP-EM Application.
#     A copy of the CCP-EM licence can be obtained by writing to the
#     CCP-EM Secretary, RAL Laboratory, Harwell, OX11 0FA, UK.
#

import os
from ccpem_core.ccpem_utils import ccpem_argparser
from ccpem_core import settings
from ccpem_core import process_manager
from ccpem_core.tasks import task_utils
from ccpem_core.settings import which


class ProShade(task_utils.CCPEMTask):
    '''
    CCPEM ProSHADE task.
    '''
    task_info = task_utils.CCPEMTaskInfo(
        name='ProSHADE',
        author='Tykac M',
        version='1.0',
        description=(
            '<p> Use ProSHADE to find symmetry</p>'
            '<p>Full documentation:</p>'
            '<p>http://www.ccpem.ac.uk</p>'),
        short_description=(
            'Sym'),
        documentation_link='http://www.ccpem.ac.uk',
        references=None)

    commands = {'proshade': settings.which(program='mapdump')}

    def __init__(self,
                 database_path=None,
                 args=None,
                 args_json=None,
                 pipeline=None,
                 job_location=None,
                 parent=None):
        super(ProShade, self).__init__(
            database_path=database_path,
            args=args,
            args_json=args_json,
            pipeline=pipeline,
            job_location=job_location,
            parent=parent)

    def parser(self):
        parser = ccpem_argparser.ccpemArgParser()
        #
        parser.add_argument(
            '-job_title',
            '--job_title',
            help='Short description of job',
            metavar='Job title',
            type=str,
            default=None)
        #
        parser.add_argument(
            '-input_map',
            '--input_map',
            help='''Input map file (mrc format)''',
            metavar='Input map',
            type=str,
            default=None)
        #
        parser.add_argument(
            '-resolution',
            '--resolution',
            help='''Map resolution (Angstrom)''',
            metavar='Map resolution',
            type=float,
            default=None)
        #
        parser.add_argument(
            '-keywords',
            '--keywords',
            help='Keywords for advanced options.  Select file or define text',
            type=str,
            metavar='Keywords',
            default='')
        return parser

    def run_pipeline(self, job_id=None, db_inject=None):
        self.process_proshade = ProShadeWrapper(
            name='Proxy for ProSHADE',
            job_location=self.job_location,
            map_path=self.args.input_map())
        pl = [[self.process_proshade.process]]
        self.pipeline = process_manager.CCPEMPipeline(
            pipeline=pl,
            job_id=job_id,
            args_path=self.args.jsonfile,
            location=self.job_location,
            database_path=self.database_path,
            db_inject=db_inject,
            taskname=self.task_info.name,
            title=self.args.job_title.value)
        self.pipeline.start()

class ProShadeWrapper(object):
    '''
    ProSHADE wrapper
    '''
    def __init__(self,
                 job_location,
                 map_path,
                 name=None):
        command = ProShade.commands['proshade']
        assert command is not None
        self.job_location = job_location
        self.map_path = map_path
        self.name = name
        if self.name is None:
            self.name = self.__class__.__name__
        self.stdin = None
        #
        self.set_args()
        self.set_stdin()
        #
        self.process = process_manager.CCPEMProcess(
            name=self.name,
            command=command,
            args=self.args,
            location=self.job_location,
            stdin=self.stdin)

    def set_args(self):
        self.args = ['mapin', self.map_path]

    def set_stdin(self):
        self.stdin = '\nend'

