import sys
import os
import subprocess
from ccpem_core import ccpem_utils
from ccpem_core import settings


def get_ccpem_bin_location(attribute):
    args = settings.get_ccpem_settings()
    if getattr(args, attribute, None) is not None:
        return getattr(args, attribute, None).value
    else:
        return None
    return None


def get_linux_terminal_command():
    command = settings.which('gnome-terminal')
    if command is None:
        command = settings.which('konsole')
    if command is None:
        command = settings.which('xterm')
    return command


def run_terminal(working_directory=None):
    if sys.platform == 'linux2':
        command = get_linux_terminal_command()
        find_wd = False
        if working_directory is not None:
            if os.path.exists(working_directory):
                find_wd = True
        if command is not None:
            args = []
            if find_wd:
                if 'gnome-terminal' in command:
                    arg = '--working-directory={0}'.format(working_directory)
                    args = [arg]
                elif 'konsole' in command:
                    args = '--workdir {0}'.format(working_directory)
                elif 'xterm' in command:
                    print 'Xterm not terminal launch surported'
                    # Can't reliably pass working directory to xterm
                    pass
            run_detatched_process(command=command,
                                  args=args)
    elif sys.platform == 'darwin':
        if working_directory is None:
                working_directory = ''
        osascript = '''osascript -e 'tell application "Terminal" \
                       to do script "cd {0}"' '''.format(
            working_directory)
        os.system(osascript)
    else:
        print 'Window terminal launch not supported yet...'

def run_coot(args=[]):
    '''
    Run coot with optional command line args e.g. :
    coot --pdb=foo.pdb --map=foo.mrc
    '''
    coot_command = settings.which('coot')
    if coot_command is None:
        text = 'Warning: Coot not found'
        ccpem_utils.print_error(message=text)
    else:
        run_detatched_process(command=coot_command,
                              args=args)


def run_ccp4mg(args=[]):
    '''
    Run ccp4mg with optional command line args e.g. :
    ccp4mg -pdb foo.pdb -map foo.map
    N.B. ccp4mg doesn't currently automatically recognise .mrc extension.
    '''
    ccp4mg_command = settings.which('ccp4mg')
    if ccp4mg_command is None:
        text = 'Warning: CCP4MG not found'
        ccpem_utils.print_error(message=text)
    else:
        run_detatched_process(command=ccp4mg_command,
                              args=args)


def run_chimera(args=[]):
    '''
    Run chimera with optional command line args e.g. :
    chimera foo.pdb foo.map
    '''
    chimera_command = settings.which('chimera')
    if chimera_command is None:
        text = 'Warning: Chimera not found'
        ccpem_utils.print_error(message=text)
    else:
        run_detatched_process(command=chimera_command,
                              args=args)


def run_pymol(args=[]):
    '''
    Run PyMOL with optional command line args e.g. :
    pymol foo.pdb foo.ccp4
    N.B. ccp4mg doesn't currently automatically recognise .mrc or .map
    extensions.
    '''
    pymol_command = settings.which('pymol')
    if pymol_command is None:
        text = 'Warning: PyMOL not found'
        ccpem_utils.print_error(message=text)
    else:
        run_detatched_process(command=pymol_command,
                              args=[])


def run_relion():
    '''
    Run relion GUI.
    '''
    relion_command = get_ccpem_bin_location(attribute='relion_bin')
    # Else try and find command
    if relion_command is None:
        relion_command = settings.which('relion')
    if relion_command is None:
        text = 'Warning: RELION not found'
        ccpem_utils.print_error(message=text)
    else:
        run_detatched_process(command=relion_command,
                              args=[])


def run_detatched_process(command, args=[], verbose=True):
    assert command is not None
    assert type(args) is type([])
    if verbose:
        command_str = ccpem_utils.print_header(message='CCP-EM toolbar launch',
                                               return_str=True)
        command_str += ccpem_utils.print_sub_sub_header(message='Command',
                                                        return_str=True)
        command_str += command
        for arg in args:
            command_str += ' '
            command_str += arg
        command_str += '\n'
        command_str += ccpem_utils.return_footer()

    # Run with python subprocess to allow environment to be set.  This is
    # required to reset PYTHONPATH to remove ccpem python libraries which 
    # can cause conflicts.
    env = os.environ.copy()
    env.pop('PYTHONPATH', None)
    command = [command] + args
    subprocess.Popen(command,
                     env=env)

def main():
    '''
    For testing.
    '''
    pass

if __name__ == '__main__':
    main()
