infile = "RMSD.txt"

data <- read.table(infile,header=TRUE)
rms    <- data$RMS
ccf    <- data$CCFobs
dope   <- data$Normalized_DOPE

pdf("RMSD_CCF.pdf")
xlab <- expression(paste("CAlpha-RMSD ", (ring(A))))
plot(rms,ccf,main="RMSD-CCF plot",xlab=xlab,ylab="CCF score")

# add regression line
#reg <- lm(ccf~rms)
#abline(reg,col="red")

# mark best point from DOPE score (blue point)
x <- data[min(dope)==data$Normalized_DOPE,]$RMS
y <- data[min(dope)==data$Normalized_DOPE,]$CCFobs
points(x,y,col="blue")

# mark best point from CCFobs score (green point)
x <- data[max(ccf)==data$CCFobs,]$RMS
y <- data[max(ccf)==data$CCFobs,]$CCFobs
points(x,y,col="green")

# R^2 
#r.2    <- round(cor(rms,ccf)^2,digits=2)
#cor(rms,ccf)
#cor(rms,ccf)^2

require(gplots)
#smartlegend(x="right",y="top", inset = 0.01,c("best CCFobs","best DOPE",paste("R^2=",r.2,sep=""),paste("# models=",length(rms),sep="")),fill=c("green","blue","white","white"))
smartlegend(x="right",y="top", inset = 0.01,c("best CCFobs","best DOPE",paste("# models=",length(rms),sep="")),col=c("green","blue","white"),pch=c(1,1,1))
dev.off()





#pdf("RMSD_DOPE.pdf")
#plot(rms,dope,main="RMSD-DOPE plot",xlab="RMSD",ylab="DOPE score")

#reg <- lm(dope~rms)
#abline(reg,col="red")

#dev.off()
