C  QUADSERCHK
C
C   Remember to change version number in first write statement.
C	VX1.0	JMB	1988	 MODIFIED FROM QUADSERCH2
C	VX1.1	RH	19.9.88	 DIMENSIONS OF MDC, MDR EXPANDED
C       VX1.2   RH      3.11.88  PLOT CHARACTERS CHANGED FOR SPEED.
C       VX1.3   RH     11.12.88  Changed plot characters, & profile printout.
C       VX1.4   RH     22.12.88  Performs profile fit over elliptical area.
C       VX1.5   RH       1.4.90  INCREASE KDC,KDR max dimensions.
C       VX1.6   RH       1.7.90  some useful control card instructions.
C       VX2.0   RH       1.1.92  convert to UNIX for Alliant
C       VX2.1   RH       9.7.94  test BIGFACTR to avoid edge of profile
C       VX2.2   RH      29.8.94  read in entire image to avoid diskio overhead
C       VX2.3   RH       3.9.94  test negative values BIGFACTR as above
C       VX2.4   RH      14.4.95  normalise PROFILE(avoid overflow)+9030 format
C       VX2.5   RH      29.4.95  add date and time to plots
C       VX2.6   RH       1.6.95  double precision CCFCALC summations
C       VX2.7   RH      25.7.95  ENCODE debug for Alpha
C	VX2.8   JMS     03.5.96  ARRAY put in common to be compatible with sgi
C	VX2.9   JMS    13.06.96  Variable NCALLPROF initialized to 0
C	VX3.0   RH     15.08.97  increase dimensions of search to 240
C	VX3.1   RH      4.12.97  optional real or reciprocal space latt params
C                                 input card 4 changed, therefore QUADSERCHC
C	VX3.2   RH      11.3.98  add QUADSERCHC to plot title
C	VX3.3   RH      21.9.99  cosmetic change QUADSERCHE->C
C	VX4.0   RH      23.8.00  convert to plot2000 direct postscript output
C       "       JMS     21.2.06  renamed output file CCPLOT.PS to CCPLOT for
C                                MAC/OSX compliance
C       VX4.1   JMS     22.06.10 GFORTRAN mods
C
C  MODIFIED JUN 1987 TO HANDLE RECTANGULAR IMAGES.   JMB.
C  MODIFIED FROM PROFSERCH DEC 1986.   JMB.
C
C  NOW PREDICTS DIFFERENCE BETWEEN LATTICE POSITION AND SEARCH POSITION
C  FROM LOCAL AREA NEAR POINT, OF DIMENSIONS +/- NRANGE IN A AND B.
C  ON FIRST PASS ONLY THE AREA ALREADY PASSED IN THE SEARCH PROCEDURE
C  CONTAINS USEABLE INFORMATION;
C  IN OPTIONAL SECOND PASS THE AREA AHEAD
C  OF THE CURRENT POINT CONTAINS USEABLE INFORMATION STORED FROM PASS 1.
C
C  CROSS-CORRELATION SEARCHING PROGRAM 15.8.84
C  SEARCHES A CROSS-CORRELATION MAP CALCULATED
C  SEPARATELY BY THE FFT METHOD BUT GIVES OUTPUT IN SIMILAR FORMAT
C  TO THE CORNELL REAL-SPACE PROGRAM CCOR.
C
C  THIS PROGRAM PRODUCES :-
C        1. The file 'PROFDATA'; it contains the data for use in CCUNBENDA.
C           First the information previously transferrd in file 'PIXPARMS';
C           Then the list of best correlation peak positions and the
C           heights of their correlation peaks.
C        2. A plot of the lattice positions searched in which; 1) error
C           vectors are shown X10; 2) peak heights are shown as grey levels.
C	 3. The file 'ERRORS'; this contains a list of the differences
C	    between actual positions of peaks and lattice positions. It
C	    can be used in a second pass through this program if some
C	    patches gave bad correlation peaks first time through and look
C	    as if they could be improved with hindsight
C
C-------CORRELATION PEAKS ARE SEARCHED FOR AROUND THEIR
C-------EXPECTED POSITION BASED ON INPUT LATTICE PARAMETERS
C
C UNIX compile and link as below
C f77 -o quadserchb.exe quadserchb.for ${IMAGELIB}/imlib.a \
C                                          ${IMAGELIB}/genlib.a \
C                                          ${IMAGELIB}/plot82lib.a
C
C   FILE STRUCTURE IS
C     INPUT:
C
C     CARDS ON UNIT 5 :
C	1	IPASS,NRANGE		! controls search learning algorithm.
C	2	FILENAME 		! name of cross-correlation file
C	3	ISIZEX,ISIZEY		! SIZE OF TRANSFORM
C	4	ASTR1,ASTR2,BSTR1,BSTR2,LREAL
C					! Lattice vectors, real(T) or recip(F)
C	5	MINA,MAXA,MINB,MAXB	! NUMBER UNIT CELLS TO SEARCH
C	6	KDC,KDR			! RADIUS OF CORR SEARCH
C	7	IC,IR			! POSN OF SEARCH START (0,0 IS ORIGIN)
C	8	IPRNT			! YES/NO FOR DETAILED PRINTOUT
C	9	RADLIMP,RADLIMQ,RADANGP	! ELLIPTICAL CUTOFF.
C
C	  IPASS	-0 no error input or output, simple search only.
C		-1 writes error file with peak positions for use in later pass.
C		-2 reads error file for use in better initial peak predict.
C	  NRANGE- range of previous peaks used in prediction of next peak posn.
C	  ISIZEX- size of transform in x-pixels (eg. 3000,3000)
C	  ISIZEY-                  and y-pixels
C	  ASTR1 - reciprocal space lattice vectors.
C	  ASTR2 -	""
C	  BSTR1 -	""
C	  BSTR2 -	""
C	  LREAL - use real space params if T, recip space if F
C	  MINA  - number of unit cells to search for in each direction from
C	  MAXA  - search origin IC,IR  e.g.(-120,120,-120,120)
C	  MINB  -   ""
C	  MAXB  -   ""
C	  KDC   - search over +/- this number of pixels on each side of the
C	  KDR   - predicted centre of each correlation peak.
C	  IC    - position of search origin for the first correlation peak
C	  IR    - relative to corner of image at 0,0 -  e.g.(1500,1500)
C	  IPRNT - more (Y) or less (N) printout
C	  RADLIMP- radius for profile fit in profile units in one direction
C	  RADLIMQ- same in orthogonal direction -- (20x smaller than pixels)
C	  RADANGP- angle relative to x-axis of RADLIMP (elliptical)
C
C     INPUT FILES :
C	  ERRORS      - (Created if IPASS=1); Read if IPASS=2; Contains
C                     - list of XERROR,YERROR,PEAK found when IPASS=1
C                     - not written or read if IPASS=0
C         PROFILE     - Profile used for matching against correlation peaks.
C                     - This has been previously obtained from procedure
C                     - AUTOCORRL
C     OUTPUT FILES:
C         PROFDATA    - File contains;
C                     - Parameters to be transferred between programs,
C                     - including data read in here, maximum value of
C                     - peak height, raw list of correlation peak positions
C                     - and heights produced by this program and to be used
C                     - by CCUNBENDA
C	  ERRORS      - Produced when IPASS=1; File contains list of
C			 XERROR(IA,IB),YERROR(IA,IB),PEAK(IA,IB)
C
	COMMON/PROFITC/PROFILE,XC
C*** jms 22.06.2010
	parameter (iarrmxsiz = 37000000)
C***      	PARAMETER (ARRMXSIZ=37000000)
	PARAMETER (MDR=30)
	PARAMETER (MDC=30)
	PARAMETER (MNY=-240)
	PARAMETER (MXY=240)
	PARAMETER (NDATA = 40)
	PARAMETER (NSMOTH=5)
C
      	DIMENSION ARRAY(iarrmxsiz)
      	DIMENSION NASTOP(2)
	DIMENSION NSTART(10),NFIN(10),NSTEP(10)
	DIMENSION PROFILE(101,101),NCOUNT(11),RADSTORE(-180:180)
	DIMENSION NXYZ2(3),MXYZ2(3)
        DIMENSION TITLE(20),NXYZ(3),MXYZ(3)
	DIMENSION COOR(3,MNY:MXY,MNY:MXY)
C
      DIMENSION XERROR(MNY:MXY,MNY:MXY),YERROR(MNY:MXY,MNY:MXY)
      DIMENSION PEAK(MNY:MXY,MNY:MXY)
	DIMENSION XC(MDC,MDR)  ! this should be (x,y)
      	LOGICAL LREAL
      	CHARACTER*80 NAME
      	EQUIVALENCE (TITLE,NAME)
CTSH++
	CHARACTER*1 IUSE
CTSH--
c	INTEGER*4 LIST(NDATA)
C*** next statement necessary for compatibility with sgi machines
	COMMON/BIG/ARRAY
C
C	DATA FOR PROFIT
	DATA NSTEP/5,1,1,1,1,1,1,1,1,1/
	DATA NSTART/-10,-7,-5,-3,-3,-3,-3,-3,-3,-3/
	DATA NFIN/10,7,5,3,3,3,3,3,3,3/
	DATA NCOUNT/11*0/
	DATA NPASSLIM/9/
C
	DATA CORFAC/10.0/
      	EQUIVALENCE (NCOL,NXYZ(1)),(NLINE,NXYZ(2))
C
	XCOORD(I,J)=A1*I+B1*J+IC
	YCOORD(I,J)=A2*I+B2*J+IR
C*** initialization added by JMS 06.03.96
	do k=mny,mxy
	 do j=mny,mxy
	  do i=1,3
	   coor(i,j,k) = 0.
	  end do
	 end do
	end do
C*** initialization added by JMS 13.06.96
        ncallprof = 0
C
      WRITE(6,1)
1     FORMAT(/' QUADSERCHK VX4.0(23.8.00), searches cross-correlation',
     .' map one quadrant at a time, and fits profile to peaks'//)
      READ(5,*)IPASS,NRANGE
      WRITE(6,39003)IPASS,NRANGE
39003	FORMAT(' IPASS=',I2,' NRANGE=',I3/)
      IF(IPASS.NE.1.AND.IPASS.NE.2.AND.IPASS.NE.0)IPASS=0
      	  WRITE(6,9003)
9003	  FORMAT('$NAME OF CROSS-CORRELATION FILE TO BE SEARCHED? ')
      	  READ(5,19006) TITLE
19006     FORMAT(20A4)
          WRITE(6,9006) TITLE
9006	  FORMAT(1X,20A4)
      CALL IMOPEN(1,NAME,'RO')
      CALL IRDHDR(1,NXYZ,MXYZ,MODE,DMIN,DMAX,DMEAN)
      	IF(NCOL*NLINE.GT.iarrmxsiz) STOP ' iarrmxsiz too small'
      CALL IMPOSN(1,0,0)
      CALL IRDPAS(1,ARRAY,NCOL,NLINE,0,NCOL-1,0,NLINE-1,*9400)
      CALL IMCLOSE(1)
C
          WRITE(6,8007)
8007      FORMAT('$ISIZEX,ISIZEY? ')
          READ(5,*)ISIZEX,ISIZEY
          WRITE(6,*)ISIZEX,ISIZEY
      	  WRITE(6,9008)
9008	  FORMAT('$REAL/RECIPROCAL SPACE LATTICE PARAMETERS',
     .           ' ASTR1,ASTR2,BSTR1,BSTR2,LREAL? ')
      	  READ(5,*) ASTR1,ASTR2,BSTR1,BSTR2,LREAL
      	  WRITE(6,*) ASTR1,ASTR2,BSTR1,BSTR2,LREAL

C   LREAL canbe used to bypass the next few lines of code.
      IF(LREAL) THEN ! real space lattice parameters
      	A1=ASTR1
      	A2=ASTR2
      	B1=BSTR1
      	B2=BSTR2
      ELSE  ! reciprocal space lattice parameters
C		CALCULATE REAL SPACE LATTICE PARAMETERS FROM RECIPROCAL;
C		IE X AND Y CORRDINATES OF (1,0) AND (0,1)
C		ADJUST COMPONENTS 2 FOR DIFFERENCE IN X AND Y SAMPLING IF
C		RECTANGULAR IMAGE
      	SIZEX=ISIZEX
      	ADJUST=SIZEX/ISIZEY
      	ASTR2=ASTR2*ADJUST
      	BSTR2=BSTR2*ADJUST
      	PI2=1.570796327
      	ASTR=SQRT(ASTR1**2+ASTR2**2)
      	BSTR=SQRT(BSTR1**2+BSTR2**2)
C
     	SINASTR=ASTR2/ASTR
      	COSASTR=ASTR1/ASTR
      	SINBSTR=BSTR2/BSTR
      	COSBSTR=BSTR1/BSTR
C
      	SINGMSTR=SINASTR*COSBSTR-COSASTR*SINBSTR
      	COSGMSTR=SINASTR*SINBSTR+COSASTR*COSBSTR
      	GAMMASTR=ATAN2(SINGMSTR,COSGMSTR)
C		GAMMASTR IS GT -PI AND LE PI
C		IF GAMMASTR IS +VE C IS ALONG -Z; IF -VE C IS ALONG +Z
      	IF(GAMMASTR.GE.0.0)THEN
      	 AA1=-BSTR2
      	 AA2=+BSTR1
      	 BB1=+ASTR2
      	 BB2=-ASTR1
      	ELSE
      	 AA1=+BSTR2
      	 AA2=-BSTR1
      	 BB1=-ASTR2
      	 BB2=+ASTR1
      	END IF
      	SINA=AA2/BSTR
      	COSA=AA1/BSTR
      	SINB=BB2/ASTR
      	COSB=BB1/ASTR
C
      	IF(GAMMASTR.LT.0.0)GAMMASTR=-GAMMASTR
      	A=ISIZEX/(ASTR*SIN(GAMMASTR))
      	B=ISIZEX/(BSTR*SIN(GAMMASTR))
C
      	A1=A*COSA
      	A2=A*SINA
      	B1=B*COSB
      	B2=B*SINB
      ENDIF

      WRITE(6,8005)
8005  FORMAT('$REAL SPACE LATTICE PARAMETERS CALCULATED or READ IN',
     .' A1,A2,B1,B2')
      WRITE(6,*)A1,A2,B1,B2
C      WRITE(6,*)ASTR,BSTR,ANGASTR,ANGBSTR,GAMMASTR,A,B
C
310	WRITE(6,9014)
9014	FORMAT('$NUMBER OF UNIT CELLS ALONG EACH AXIS TO'/
     .	        ' BE USED IN SEARCH, MINA,MAXA,MINB,MAXB? ')
      	READ(5,*) MINA,MAXA,MINB,MAXB
      	WRITE(6,*) MINA,MAXA,MINB,MAXB
	IF(MINB.LT.MNY.OR.MINB.GT.MXY)GO TO 9310
	IF(MAXB.LT.MNY.OR.MAXB.GT.MXY)GO TO 9310
	IF(MINA.LT.MNY.OR.MINA.GT.MXY)GO TO 9310
	IF(MAXA.LT.MNY.OR.MAXA.GT.MXY)GO TO 9310
      GO TO 9311
9310	WRITE(6,9312)
9312	FORMAT(' NUMBER OF UNIT CELLS REQUIRED EXCEEDS DIMENSIONS')
      STOP
9311	CONTINUE
	MINX=0
      	MINY=0
	MAXX=NCOL-1
	MAXY=NLINE-1
C      	NC=0
C      	NR=0
C
        NC=NXYZ(1)
        NR=NXYZ(2)
320	WRITE(6,9015)
9015	FORMAT('$HALF-WIDTH OF CCOR SEARCH KDC,KDR: ')
      	READ(5,*) KDC,KDR  !HALF-WIDTH OF XCOR SEARCH
        WRITE(6,*) KDC,KDR
	KDC1=KDC+1
	KDR1=KDR+1
	KDC21=2*KDC1+1
	KDR21=2*KDR1+1
	IF(KDC21.GT.MDC.OR.KDR21.GT.MDR)THEN
      WRITE(6,19016)
19016	FORMAT(' KDC,KDR TOO LARGE FOR CURRENT DIMENSIONS')
      STOP
      END IF
      	  WRITE(6,9016)
9016	  FORMAT('$POSITION OF STARTING ORIGIN FOR SEARCH'/
     .	' NORMALLY CENTRE OF CCOR MAP  IC,IR? ')
      	  READ(5,*) IC,IR
      	  WRITE(6,*) IC,IR
      	WRITE(6,9035)
9035	FORMAT('$PRINTOUT OF ALL CCOR VALUES IN SEARCH? ')
      	READ(5,9004)IPRNT
9004	FORMAT(A1)
C
C
C
C	READ PROFILE DATA SET
C
	CALL IMOPEN(2,'PROFILE','RO')
	CALL IRDHDR(2,NXYZ2,MXYZ2,MODE,DMIN,DMAX,DMEAN)
	NXP=NXYZ2(1)
	NYP=NXYZ2(2)
	CALL IMPOSN(2,0,0)
	CALL IRDPAS(2,PROFILE,NXP,NYP,0,NXP-1,0,NYP-1,*9501)
      	CALL IMCLOSE(2)
C
C  Normalise profile to reasonable numbers (max=100.0) - avoids overflow later.
      	IF(PROFILE(51,51).GT.1.0) THEN
      	 FACTOR = 100.0/PROFILE(51,51)
      	 DO 95 I=1,101
      	 DO 95 J=1,101
95		PROFILE(I,J)=PROFILE(I,J)*FACTOR
		WRITE(6,90) FACTOR
      	ELSE
      	 FACTOR = 1.0
		WRITE(6,90) FACTOR
      	ENDIF
90	FORMAT(' PROFILE in steps of 10 mini-steps (0.5 pixels?), ',
     .	 '      NORMALISED by? --',E15.5)
	WRITE(6,91)((PROFILE(I,J),I=1,101,10),J=1,101,10)
91	FORMAT(11(2X,E10.4))
	GO TO 92
9501	STOP 'ERROR READING PROFILE'
C
92	READ(5,*)RADLIMP,RADLIMQ,RADANGP
      	RADLIMPSQ=RADLIMP**2
      	RADLIMQSQ=RADLIMQ**2
      	DO 93 J=-180,180
      	 ANGDIFFP=RADANGP-J
      	 RADSTORE(J)=(RADLIMP*COS(ANGDIFFP/57.295776))**2 +
     .                      (RADLIMQ*SIN(ANGDIFFP/57.295776))**2
93	CONTINUE
	WRITE(6,61)RADLIMP,RADLIMQ,RADANGP
61	FORMAT(//' ELLIPSE RADIUS LIMITS AND ANGLE FOR PROFILE MATCH,'/
     .  ' IN PROFILE GRID UNITS, RADP,RADQ,ANGP',3F8.2)
C
	WRITE(6,9052)
9052	FORMAT(//' PARAMETERS USED IN SEARCHING FOR PROFILE MATCH'/)
	WRITE(6,9051)(I,NSTART(I),NFIN(I),NSTEP(I),I=1,10)
9051	FORMAT(' NPASS=',I3,' NSTART=',I3,' NFIN=',I3,' NSTEP=',I3/)
C
C OPEN FILE FOR ERRORS; WRITE IF IPASS=1; READ IF IPASS=2
      	IF(IPASS.NE.0) CALL CCPDPN(4,'ERRORS','UNKNOWN','F',0,0)
C
      IF (IPASS.EQ.1.OR.IPASS.EQ.0)THEN
      IF(IPASS.EQ.1)WRITE(4,45000)(TITLE(J),J=1,10),MINA,MAXA,MINB,MAXB
C SET CONTENTS OF XERROR,YERROR ARRAYS TO 9999.; PEAK ARRAY TO 0.0
      DO 45004 IA=MINA,MAXA
      DO 45004 IB=MINB,MAXB
      XERROR(IA,IB)=9999.
      YERROR(IA,IB)=9999.
      PEAK(IA,IB)=0.0
45004	CONTINUE
      END IF
C
      IF(IPASS.EQ.2)THEN
        READ(4,45000)(TITLE(J),J=1,10),MINA1,MAXA1,MINB1,MAXB1
45000	FORMAT(10A4,4I5)
      WRITE(6,45002)(TITLE(J),J=1,10),MINA,MAXA,MINB,MAXB
45002	FORMAT(//' SECOND PASS; ERROR FILE READ FROM UNIT 4;',
     .' TITLE AND RANGES'/20X,10A4,4I5/)
      DO 45001 IA=MINA1,MAXA1
      DO 45001 IB=MINB1,MAXB1
      READ(4,39031)XERROR(IA,IB),YERROR(IA,IB),PEAK(IA,IB)
45001	CONTINUE
      END IF
C
C
C WRITE OUT CCORDATA FOR USE IN CCUNBENDA
      	CALL CCPDPN(3,'PROFDATA','UNKNOWN','F',0,0)
C
        WRITE(3,15000)(TITLE(J),J=1,10),KDC,KDR,RADLIMP,RADLIMQ,RADANGP
        WRITE(6,15001)
15001   FORMAT(' TITLE RECORDS WRITTEN TO CCORDATA OUTPUT FILE'/)
        WRITE(6,15000)(TITLE(J),J=1,10),KDC,KDR,RADLIMP,RADLIMQ,RADANGP
15000   FORMAT(' CROSS-CORRELATION FILE SEARCHED ',10A4/
     .  ' HALF-WIDTH OF CCOR SEARCH KDC,KDR: ',2I5/' RADII & ANGLE FOR',
     .  ' PROFILE FIT IN PROFILE GRID UNITS ',3F7.2//)
        WRITE(3,*)NC,NR,IC,IR,A1,A2,B1,B2,MINA,MAXA,MINB,MAXB
C
C  SEARCH FOR CORRELATION PEAKS IN QUADRANTS. START
C   AT CENTER OF SEARCH RANGE.  MODIFY LATTICE PARAMETERS
C   AS SEARCH PROCEEDS TO ADJUST FOR SLOWLY CHANGING LATTICE.
C
C
	CORMAX=-1E30
	CORMIN=-CORMAX
	CORAVG=0
      	NCOOR=0
	NFOUNDT=0
	NOTUSED=0
	NDRIFT=0
      NOUT=0
      NJUMP=0
      XMXDSCRP=0.0
      YMXDSCRP=0.0
C
C  WRITE DATA ON  X,Y CORRELATION PEAK HEIGHTS
C    FOR USE BY CCUNBEND TO UNDISTORT THE LATTICE.
C
C
      MXMNA=MAXA
      IF(MINA.LT.-MAXA)MXMNA=-MINA
      MXMNB=MAXB
      IF(MINB.LT.-MAXB)MXMNB=-MINB
      DO 10021 LA=1,2
      IF(LA.EQ.1)IASGN=1
      IF(LA.EQ.2)IASGN=-1
C
      NASTOP(1)=0
      NASTOP(2)=0
C NASTOP(IBSGN) IS SET TO 1 ONCE A HALF-LINE IS REACHED ON WHICH ALL
C PREDICTED PEAKS ARE OUTSIDE IMAGE AREA
C
	DO 21 IIA=0,MXMNA
 	IF(NASTOP(1).EQ.1.AND.NASTOP(2).EQ.1)THEN
      NJUMP=NJUMP+2
      GO TO 21
      END IF
      IF(LA.EQ.2.AND.IIA.EQ.0)GO TO 21
      IF(LA.EQ.1)IA=IIA
      IF(LA.EQ.2)IA=-IIA
      IF(IA.LT.MINA.OR.IA.GT.MAXA)GO TO 21
C
C
      DO 10022 LB=1,2
      IF(NASTOP(LB).EQ.1)THEN
      NJUMP=NJUMP+1
      GO TO 10022
      END IF
      IF(LB.EQ.1)IBSGN=1
      IF(LB.EQ.2)IBSGN=-1
      	  NFOUND=0
          NALINE=0
      XPRDI=0.0
      YPRDI=0.0
      XPRDL=0.0
      YPRDL=0.0
      XPRDM=0.0
      YPRDM=0.0
      NPREDCT=0
      TOTXPREDCT=0.0
      TOTYPREDCT=0.0
C
C IBSTART GETS SET TO THE FIRST IB VALUE IN EACH HALF LINE WHERE
C PREDICTION IS POSSIBLE, JUST FOR DIAGNOSTIC PRINTOUT
      IBSTART1=0
      IF(MINB.GT.0)IBSTART1=MINB
      IBSTART2=-1
      IF(MAXB.LT.0)IBSTART2=MAXB
      NBSTART=0
C
	 DO 22 IIB=0,MXMNB
C
      IF(LB.EQ.2.AND.IIB.EQ.0)GO TO 22
      IF(LB.EQ.1)IB=IIB
      IF(LB.EQ.2)IB=-IIB
      IF(IB.LT.MINB.OR.IB.GT.MAXB)GO TO 22
C
C
C  CALC EXPECTED CORREL LOCATION WITH ERROR ADJUSTMENT
C
      CALL PREDICT(NRANGE,IASGN,IBSGN,IA,IB,XPREDICT,
     .YPREDICT,MINA,MAXA,MINB,MAXB,XERROR,YERROR,PEAK,NAVG,IPASS)
C
C
      IF(NAVG.NE.0)THEN
C PREDICTION MADE
      NBSTART=1
      NPREDCT=NPREDCT+1
      TOTXPREDCT=TOTXPREDCT+XPREDICT
      TOTYPREDCT=TOTYPREDCT+YPREDICT
C STORE PREDICTION; LAST ONE MADE FOR EACH HALF-LINE WILL APPEAR ON PRINTOUT
      XPRDL=XPREDICT
      YPRDL=YPREDICT
      ELSE
C NO PREDICTION MADE
      IF(NBSTART.EQ.0.AND.LB.EQ.1)IBSTART1=IB+1
      IF(NBSTART.EQ.0.AND.LB.EQ.2)IBSTART2=IB-1
      END IF
C
      IF(LB.EQ.1.AND.IB.EQ.IBSTART1)THEN
C STORE INITIAL PREDICTION FOR HALF-LINE FOR DIAGNOSTIC PRINTOUT
      XPRDI=XPREDICT
      YPRDI=YPREDICT
      END IF
      IF(LB.EQ.2.AND.IB.EQ.IBSTART2)THEN
      XPRDI=XPREDICT
      YPRDI=YPREDICT
      END IF
C
      XXX=XCOORD(IA,IB)+XPREDICT
      YYY=YCOORD(IA,IB)+YPREDICT
C      WRITE(6,*)IA,IB,XXX,YYY		! diagnostic
      IX=XXX
      IY=YYY
C
C      WRITE(6,*)KDC1,KDR1,MINX,MINY,MAXX,MAXY
C      WRITE(6,*)IX,IY
	  IF(IX-KDC1.LT.MINX.OR.IX+KDC1.GT.MAXX.OR.
     .IY-KDR1.LT.MINY.OR.IY+KDR1.GT.MAXY)GO TO 23
C
C COUNT NUMBER OF BOXES READ ON EACH HALF LINE;
      NALINE=NALINE+1
C
C  HERE, FIND CENTRE OF GRAVITY OF CORRELATION PEAK IN A SMALL SEARCH AREA.
C  PREVIOUS CORNELL PROGRAM USED SUBROUTINE BLCK, WHICH DID HIGHEST PEAK ONLY.
C
      CALL GETXC(ARRAY,NCOL,NLINE,XC,IX,IY,KDC1,KDR1)
C		CALL IMPOSN(1,0,0)	! replaced by reading in entire array.
C		CALL IRDPAS(1,XC,MDR,MDC,IX-KDC1,IX+KDC1,IY-KDR1,IY+KDR1,*9500)
      	 BIG5=-1.0E30
CTSH      	IF(IPRNT.EQ.'Y') THEN
CTSH++
      	IF(IPRNT.EQ.ICHAR('Y')) THEN
CTSH--
      	 WRITE(6,*)J,I
      	 DO 9037 IIY=1,KDR21
9037     WRITE(6,9036) (XC(IIX,IIY),IIX=1,KDC21)
9036		FORMAT(16F5.1)
      	ENDIF
C
C  FIRST FIND HIGHEST PEAK,
C	EACH POINT IS REPLACED BY THE SUM OF THE DENSITY AT THE POINT
C	AND THE DENSITIES OF THE 4 NEAR NEIGHBOURS
      	 DO 9031 IIX=-KDC,KDC
      	 DO 9031 IIY=-KDR,KDR
      	 IXST =IIX+KDC+2
      	 IYST =IIY+KDR+2
	XC5=XC(IXST,IYST)+XC(IXST+1,IYST)+XC(IXST-1,IYST)+
     .	        XC(IXST,IYST+1)+XC(IXST,IYST-1)
	IF(XC5.LE.BIG5) GO TO 9031
      	 BIG5=XC5
	BIG=XC(IXST,IYST)
      	 IGC=IX+IIX
      	 IGR=IY+IIY
9031		CONTINUE
C	WRITE(6,20001)IGC,IGR,BIG	! diagnostic
20001	FORMAT(' HIGHEST PEAK',2I10,E12.4)
C******************
C
C*********************************************
C
	IIX=IGC-IX
	IIY=IGR-IY
	JFLAG=0
	IDRIFT=0
C	WRITE(6,20000)IX,IY,IIX,IIY
20000	FORMAT(' CALL PROFIT',4I10)
      NCALLPROF=NCALLPROF+1
	CALL PROFIT(RADSTORE,RADLIMPSQ,RADLIMQSQ,
     .	IIX,IIY,KDC,KDR,KDC21,KDR21,
     .	CGXADJST,CGYADJST,CCFBEST,BIGFACTR,NCOUNT,JFLAG,IDRIFT)
C
	IF(IDRIFT.EQ.1)NDRIFT=NDRIFT+1
	IF(IDRIFT.EQ.1)WRITE(6,20011) BIGFACTR,IX,IY,IIX,IIY
20011	FORMAT(' DRIFTED PEAK - BIGFACTR,X,Y,dX,dY',F6.1,4I8)
	IF(JFLAG.EQ.1)WRITE(6,20010)IX,IY,IIX,IIY
20010	FORMAT(' ? PROFILE FIT, IX,IY,IIX,IIY',4I8)
C
C
	GC=IX+IIX+CGXADJST
	GR=IY+IIY+CGYADJST
	BIG=BIG*BIGFACTR
C	WRITE(6,20002)GC,GR,BIG
20002	FORMAT(' PEAK AT',2F10.5,10X,F12.5)
      XERROR(IA,IB)=GC-(XXX-XPREDICT)
      YERROR(IA,IB)=GR-(YYY-YPREDICT)
      PEAK(IA,IB)=BIG
C
      	IF(BIG.LT.CORMIN) CORMIN=BIG
      	IF(BIG.GT.CORMAX) CORMAX=BIG
C      WRITE(6,*)GR,IY,KDR,GC,IX,KDC,BIG
      	CORAVG=CORAVG+BIG
      	NCOOR=NCOOR+1
	  COOR(1,IB,IA)=GC
	  COOR(2,IB,IA)=GR
	  COOR(3,IB,IA)=CORFAC*BIG
	  IUSE='*'
C  DO NOT USE POINT IF IT IS AT EDGE OF SEARCH AREA(* MEANS IT IS TO BE USED).
	  IF(INT(ABS(GC-IX)).GE.KDC.OR.INT(ABS(GR-IY)).GE.KDR) IUSE=' '
C  DO NOT USE IF BIGFACTR=0.0
	IF(BIGFACTR.EQ.0.0)IUSE=' '
	  IF(IUSE.EQ.' ') THEN
 	NOTUSED=NOTUSED+1
      	    COOR(1,IB,IA)=0
      	    COOR(2,IB,IA)=0
      	    COOR(3,IB,IA)=0
      XERROR(IA,IB)=9999.
      YERROR(IA,IB)=9999.
      PEAK(IA,IB)=0.
C      IF(BIG.EQ.0.0)WRITE(6,30003)IA,IB
30003	FORMAT(' NOT FOUND; C=0.0; PROBABLY DRIFTED',2X,2I5)
C      IF(BIG.NE.0.0)WRITE(6,30013)IA,IB
30013	FORMAT(' NOT FOUND; AT EDGE OF SEARCH BOX',2X,2I5)
      	  ENDIF
C
      	 IF(IUSE.EQ.'*')THEN
C COUNT NUMBER OF PEAKS FOUND ON EACH HALF-LINE
      NFOUND=NFOUND+1
      XDISCREP=XERROR(IA,IB)-XPREDICT
      YDISCREP=YERROR(IA,IB)-YPREDICT
C STORE MAXIMUM DISCREPANCY FOUND FOR DIAGNOSTIC OUTPUT
      XDSC=ABS(XDISCREP)
      YDSC=ABS(YDISCREP)
      IF(XDSC.GT.XMXDSCRP)XMXDSCRP=XDSC
      IF(YDSC.GT.YMXDSCRP)YMXDSCRP=YDSC
      END IF
	  GO TO 22
C
C COUNT NUMBER OF EXPECTED PEAKS THAT FALL OUTSIDE IMAGE AREA AFTER
C PREDICTED CORRECTION IS APPLIED
23      NOUT=NOUT+1
	  COOR(1,IB,IA)=0
	  COOR(2,IB,IA)=0
	  COOR(3,IB,IA)=0
      XERROR(IA,IB)=9999.
      YERROR(IA,IB)=9999.
      PEAK(IA,IB)=0.
C
C
22       CONTINUE
C
      IF (NALINE.EQ.0)THEN
      NASTOP(LB)=1
C      WRITE(6,*)NALINE,LB,NASTOP(LB)
      GO TO 9922
      END IF
C ONE HALF-LINE COMPLETED
      IF(NPREDCT.EQ.0)THEN
      XPRDM=0.0
      YPRDM=0.0
      ELSE
      XPRDM=TOTXPREDCT/NPREDCT
      YPRDM=TOTYPREDCT/NPREDCT
      END IF
      	WRITE(6,9021)IA,IBSGN,NFOUND,NALINE,XPRDI,XPRDL,XPRDM,
     .YPRDI,YPRDL,YPRDM,NPREDCT
9021	FORMAT(' *LINE IA,IBSGN',I5,I3,'; # PEAKS FOUND=',2I5,
     .'; PREDICTIONS(I,L,M:X,Y:N)',6F8.2,I4)
C SUM FOR TOTAL NUMBER OF PEAKS FOUND
	NFOUNDT=NFOUNDT+NFOUND
C IF NO CALLS TO READ BOX ON THE HALF-LINE JUST DONE THEN THERE
C IS NO NEED TO CONSIDER FURTHER VALUES IF IA FOR THIS IBSGN
C
9922	CONTINUE
C

10022	CONTINUE
C
21	CONTINUE
C
10021	CONTINUE
C
C
      DENMAX=CORMAX*CORFAC
      WRITE(3,*)DENMAX
      DO 40 K=MINA,MAXA
      DO 40 J=MINB,MAXB
C      WRITE(6,9030) (COOR(I,J,K),I=1,3)
      WRITE(3,9030) (COOR(I,J,K),I=1,3)
      IF(IPASS.EQ.1)WRITE(4,39031)XERROR(K,J),YERROR(K,J),PEAK(K,J)
40    CONTINUE
39031	FORMAT(3F15.5)
9030  FORMAT(2F10.3,F16.2) ! increase PEAK size possibility
      WRITE(6,39020)NJUMP
39020	FORMAT(' NUMBER OF HALF-LINES COMPLETELY OUTSIDE IMAGE',I10)
      WRITE(6,39019)NOUT
39019	FORMAT(' NUMBER OR PEAKS OUTSIDE EDGE OF IMAGE',I10)
      WRITE(6,39030)NCALLPROF
39030	FORMAT(' NUMBER OF CALLS TO PROFIT SUBROUTINE',I10)
	WRITE(6,29019)NFOUNDT
29019	FORMAT(' TOTAL NUMBER OF CORRELATION PEAKS FOUND',I10/)
	WRITE(6,29020)NOTUSED
29020	FORMAT(' TOTAL NUMBER OF CORRELATION PEAKS NOT USED',I10/)
	WRITE(6,29021)NDRIFT
29021	FORMAT(' NUMBER OF PEAKS THAT DRIFTED FROM ORIGINAL BEST',
     .' POSITION',I10/)
      	WRITE(6,9019) CORMIN,CORMAX,CORAVG/NCOOR,NCOOR
9019	FORMAT('$CORMIN,CORMAX,CORAVG ',3G18.4,' NCOOR',I10)
      	WRITE(6,9020) CORMIN*CORFAC,CORMAX*CORFAC,CORAVG/NCOOR*CORFAC
9020	FORMAT('$THE SAME SCALED = ',3F10.3)
      WRITE(6,39021)XMXDSCRP,YMXDSCRP
39021	FORMAT(' MAXIMUM DIFFERENCE FOUND BETWEEN ACTUAL AND PREDICTED',
     .' POSITION; IN X AND Y',2F10.3)
C
	WRITE(6,9050)(NCOUNT(I),I=1,11)
9050	FORMAT(' NUMBER OF PEAKS NEEDING N PASSES TO REACH FIT'/
     .' NPASS=1',I5,', NPASS=2',I6,', NPASS=3',I6,', NPASS=4',I6,
     .', NPASS=5',I5,', NPASS=6',I5/' NPASS=7',I5,', NPASS=8',I5,
     .', NPASS=9',I5,', NPASS=10',I5,', NPASS=11',I5)
C
      	CALL PLOTLATT(COOR,TITLE,NXYZ,MINA,MAXA,
     .	 MINB,MAXB,A1,A2,B1,B2,IC,IR,NC,NR)
      	STOP
9400	WRITE(6,9013)
9013	FORMAT(' Error reading in the entire map at beginning')
      	STOP
C9500	WRITE(6,9012)IX,KDC,IY,KDR,MINX,MAXX,MINY,MAXY
C9012	FORMAT(' Error reading CCOR file with IRDPAS'/
C     .	' IX,KDC,IY,KDR,MINX,MAXX,MINY,MAXY =',8I6)
C      	STOP
	END
C******************************************************************************
C  SUBROUTINE TO PLOT THE LATTICE OF SEARCH STARTING AND FOUND POSITIONS.
C             ALSO THE ROUGH SIZES OF THE CORRELATION PEAKS (SYMBOLICALLY).
      	SUBROUTINE PLOTLATT(COOR,TITLE,NXYZ,MINA,MAXA,
     .	        MINB,MAXB,A1,A2,B1,B2,IC,IR,NC,NR)
	PARAMETER (MNY=-240)
	PARAMETER (MXY=240)
      	DIMENSION COOR(3,MNY:MXY,MNY:MXY),NXYZ(3)
CTSH      	DIMENSION TEXT(20),TITLE(20),TITLEPLOT(20),PROGTIT(4)
CTSH++
	CHARACTER*80 FONTNAME
      	DIMENSION TITLE(20),PROGTIT(4)
	CHARACTER*80 TEXT
	CHARACTER*80 TITLEPLOT
CTSH--
      	CHARACTER DAT*24
CTSH      	DATA PROGTIT/'[QUA','DSER','CHK]','    '/
CTSH++
C*** jms 22.06.2010
	character*4 tmpprogtit(4)
C***	INTEGER*4 TMPPROGTIT(4)
	EQUIVALENCE (TMPPROGTIT,PROGTIT)
      	DATA TMPPROGTIT/'[QUA','DSER','CHK]','    '/
CTSH--
	XCOORD(J,I)=A1*J+B1*I+IC
	YCOORD(J,I)=A2*J+B2*I+IR
      	ZERO=0.0
      	PEAKMAX=-1.0E30
      XPEAKMAX=-100.
      YPEAKMAX=-100.
         CALL FDATE(DAT)
      	 WRITE(6,1502) DAT(5:24)
1502		FORMAT('  Date from fdate ----  ',A20)
CTSH        	ENCODE(80,1501,TITLEPLOT)
CTSH++
         WRITE(TITLEPLOT,1501)
CTSH--
     .               (TITLE(J),J=1,11),(PROGTIT(J),J=1,4),DAT(5:24)
1501            FORMAT(15A4,A20)
200	FORMAT('  ENTERING PLOTLATT')
CTSH103	FORMAT(' TITLE FOR PLOT  ',20A4)
CTSH++
103	FORMAT(' TITLE FOR PLOT  ',A)
CTSH--
       WRITE(6,200)
       WRITE(6,103) TITLEPLOT
      PLTSIZ=260.0
      FONTSIZE=3.6
C  Strings passed from Fortran to C need terminating with a zero char
      FONTNAME='Courier'//CHAR(0)
      CALL P2K_OUTFILE('CCPLOT'//CHAR(0),6)
      CALL P2K_HOME
      CALL P2K_FONT(FONTNAME,FONTSIZE)
      CALL P2K_GRID(0.5*PLTSIZ,0.5*PLTSIZ,1.0)
      CALL P2K_ORIGIN(-0.5*PLTSIZ,-0.7*PLTSIZ,0.)
      CALL P2K_COLOUR(0)
      	SPLOT=PLTSIZ/NXYZ(1)
      SIZEX=SPLOT*NXYZ(1)
      SIZEY=SPLOT*NXYZ(2)
C  BOX ROUND THE WHOLE IMAGE AREA
      CALL P2K_MOVE(0.,0.,0.)
      CALL P2K_DRAW(SIZEX,0.,0.)
      CALL P2K_DRAW(SIZEX,SIZEY,0.)
      CALL P2K_DRAW(0.,SIZEY,0.)
      CALL P2K_DRAW(0.,0.,0.)
C NOW PLOT THE POINTS
      CALL P2K_FONT(FONTNAME,FONTSIZE*0.5)
      	DO 100 K=MINA,MAXA
      	DO 100 J=MINB,MAXB
	XPLOT=SPLOT*XCOORD(K,J)
      	YPLOT=SPLOT*YCOORD(K,J)
      	IF(XPLOT.GT.SIZEX.OR.XPLOT.LT.0.) GO TO 100
      	IF(YPLOT.GT.SIZEY.OR.YPLOT.LT.0.) GO TO 100
C      	CALL P2K_MOVE(XPLOT,YPLOT,0.)
C      	ENCODE(1,102,TEXT)
C       CALL P2K_CSTRING(TEXT,1,0.)
C102	FORMAT('X')
      	X=COOR(1,J,K)
      	Y=COOR(2,J,K)
C	WRITE(6,20000)XCOORD(K,J),YCOORD(K,J),X,Y
20000	FORMAT(' EXPCTD, ACTUAL',2E12.4,10X,2E12.4)
      IF(COOR(3,J,K).GT.PEAKMAX)THEN
      PEAKMAX=COOR(3,J,K)
      XPEAKMAX=X
      YPEAKMAX=Y
      END IF
C      	PEAKMAX=MAX(PEAKMAX,COOR(3,J,K))
      	IF(X.EQ.0.) GO TO 100
      	XPLOTC=SPLOT*X
      	YPLOTC=SPLOT*Y
      	XERR=10*XPLOTC-9*XPLOT
      	YERR=10*YPLOTC-9*YPLOT
C deviations from perfect lattice plotted at 10x actual deviation
C      	CALL LOCCHR(XPLOTC,YPLOTC,0)
C      	ENCODE(1,101,TEXT)
C      	CALL CSTRING(TEXT,1)
C101	FORMAT('O')
      CALL P2K_MOVE(XPLOT,YPLOT,0.)
      	IF(XERR.GT.SIZEX.OR.XERR.LT.0.) GO TO 100
      	IF(YERR.GT.SIZEY.OR.YERR.LT.0.) GO TO 100
      CALL P2K_DRAW(XERR,YERR,0.)
100	CONTINUE
      CALL P2K_FONT(FONTNAME,FONTSIZE)
      YPOS=SIZEY+4.0
      CALL P2K_MOVE(10.,YPOS,0.)
      CALL P2K_STRING(TITLEPLOT,80,0.)
                CALL P2K_PAGE
C
      WRITE(6,9000)XPEAKMAX,YPEAKMAX
9000	FORMAT(//' POSITION OF MAXIMUM PEAK HEIGHT',2F10.2/)
C END OF FIRST PLOT OF DEVIATION VECTORS.
C NOW PLOT CORRELATION PEAK HEIGHTS SYMBOLICALLY.
C
C  BOX ROUND THE WHOLE IMAGE AREA
      CALL P2K_MOVE(0.,0.,0.)
      CALL P2K_DRAW(SIZEX,0.,0.)
      CALL P2K_DRAW(SIZEX,SIZEY,0.)
      CALL P2K_DRAW(0.,SIZEY,0.)
      CALL P2K_DRAW(0.,0.,0.)
C NOW PLOT THE POINTS
      CALL P2K_FONT(FONTNAME,FONTSIZE*0.5)
      	DO 300 K=MINA,MAXA
      	DO 300 J=MINB,MAXB
      	X=COOR(1,J,K)
      	Y=COOR(2,J,K)
      	IF(X.EQ.0.) GO TO 300
      	XPLOTC=SPLOT*X
      	YPLOTC=SPLOT*Y
      	IF(XPLOTC.GT.SIZEX.OR.XPLOTC.LT.0.) GO TO 300
      	IF(YPLOTC.GT.SIZEY.OR.YPLOTC.LT.0.) GO TO 300
      	PEAKNORM=COOR(3,J,K)/PEAKMAX
      	CALL P2K_MOVE(XPLOTC,YPLOTC,0.)
      	IF(PEAKNORM.LE.0.0)GO TO 300
CTSH      	IF(PEAKNORM.GT.0.0) ENCODE(1,402,TEXT)
CTSH      	IF(PEAKNORM.GT.0.1) ENCODE(1,403,TEXT)
CTSH      	IF(PEAKNORM.GT.0.2) ENCODE(1,404,TEXT)
CTSH      	IF(PEAKNORM.GT.0.3) ENCODE(1,405,TEXT)
CTSH      	IF(PEAKNORM.GT.0.5) ENCODE(1,406,TEXT)
CTSH      	IF(PEAKNORM.GT.0.7) ENCODE(1,408,TEXT)
CTSH++
      	IF(PEAKNORM.GT.0.0) TEXT='.'
      	IF(PEAKNORM.GT.0.1) TEXT=':'
      	IF(PEAKNORM.GT.0.2) TEXT='-'
      	IF(PEAKNORM.GT.0.3) TEXT='+'
      	IF(PEAKNORM.GT.0.5) TEXT='<'
      	IF(PEAKNORM.GT.0.7) TEXT='H'
CTSH--
      	CALL P2K_CSTRING(TEXT,1,0.)
      	IF(PEAKNORM.GT.0.5.AND.PEAKNORM.LT.0.7) THEN
C			overprint < and > for speed.
CTSH      		ENCODE(1,407,TEXT)
CTSH++
      	 TEXT='>'
CTSH--
      	 CALL P2K_MOVE(XPLOTC,YPLOTC,0.)
         CALL P2K_CSTRING(TEXT,1,0.)
      	ENDIF
	IF(PEAKNORM.GT.0.7) THEN
C			overprint H and I (0.7).
CTSH		ENCODE(1,409,TEXT)
CTSH++
	TEXT='I'
CTSH--
      	 XPLOTXTRA=XPLOTC+0.475
                CALL P2K_MOVE(XPLOTXTRA,YPLOTC,0.)
                CALL P2K_CSTRING(TEXT,1,0.)
      	ENDIF
C
CTSH402	FORMAT('.')
CTSH403	FORMAT(':')
CTSH404	FORMAT('-')
CTSH405	FORMAT('+')
CTSH406	FORMAT('<')
CTSH407     FORMAT('>')
CTSH408	FORMAT('H')
CTSH409     FORMAT('I')
300	CONTINUE
      	CALL P2K_FONT(FONTNAME,FONTSIZE)
      	YPOS=SIZEY+4.0
      	CALL P2K_MOVE(10.,YPOS,0.)
      	CALL P2K_STRING(TITLEPLOT,80,0.)
      	CALL P2K_PAGE
      	RETURN
      	END
C********** FROM CORNELL PROG *************************************************
	SUBROUTINE RCAVG(X,N,AV)
	DIMENSION X(1)
	AVV=0.0
	DO 10 I=1,N
10	AVV=AVV+X(I)
	AV=AV+AVV/N
	RETURN
	END
C***************
C********* ADDED MARCH 1985. JMB *********
	SUBROUTINE PROFIT(RADSTORE,RADLIMPSQ,RADLIMQSQ,
     .	IIX,IIY,KDC,KDR,KDC21,KDR21,
     .	CGXADJST,CGYADJST,CCFBEST,BIGFACTR,NCOUNT,JFLAG,IDRIFT)
C
	COMMON/PROFITC/PROFILE,XC
C
C	PROGRAM TO MATCH PROFILE TO CORRELATION MAP PEAKS
C
	PARAMETER (MDR=30)
        PARAMETER (MDC=30)
	DIMENSION PROFILE(101,101),XC(MDC,MDR),RADSTORE(-180:180)
	DIMENSION NSTEP(10),NSTART(10),NFIN(10),NCOUNT(11)

	DATA NSTEP/5,1,1,1,1,1,1,1,1,1/
	DATA NSTART/-10,-7,-5,-3,-3,-3,-3,-3,-3,-3/
	DATA NFIN/10,7,5,3,3,3,3,3,3,3/
	DATA NPASSLIM/9/
C
C	IX+IIX AND IY+IIY ARE COORDS IN CORRELATION-MAP ARRAY ON COARSE
C	GRID AT WHICH MAXIMUM HAS BEEN FOUND IN PRELIMINARY SEARCH.
C	TRUE POSITION OF CORRELATION PEAK IS TO BE FOUND BY MATCHING
C	THE VALUES OF DENSITIES AT SURROUNDING GRID POINTS AGAINST
C	A MORE FINELY SAMPLED PROFILE
C
C
C	
	IFLAG=0
5	LXSV=0
	LYSV=0
	NPASS=1
	ISTEP=NSTEP(NPASS)
	ISTART=NSTART(NPASS)
	IFIN=NFIN(NPASS)
	LY=0
C
30	CCFBSTX=0.0
	CCFBSTY=0.0
	DO 40 ITRX=ISTART,IFIN,ISTEP
C
	LX=ITRX+LXSV
C	LX,LY ARE COORDS ON FINE GRID
C	CENTRE OF PROFILE TRIED AT POSITION LX,LY
C
	CALL CCFCALC(LX,LY,RADSTORE,RADLIMPSQ,RADLIMQSQ,
     .          IIX,IIY,KDC,KDR,KDC21,KDR21,CCF,
     .          IFLAG,JFLAG)
C
	IF (CCF.GT.CCFBSTX)THEN
	CCFBSTX=CCF
	LXBEST=LX
	END IF
C
40	CONTINUE
C
	IF(IFLAG.EQ.1)WRITE(6,900)LXBEST,LY,LXSV,LYSV,CCFBSTX
900	FORMAT(' AFTER X ROW',2I5,5X,2I5,F8.3)
	IF(LXBEST.EQ.LXSV.AND.NPASS.GT.2)GO TO 50
	LX=LXBEST
C
	DO 41 ITRY=ISTART,IFIN,ISTEP
	LY=ITRY+LYSV
	CALL CCFCALC(LX,LY,RADSTORE,RADLIMPSQ,RADLIMQSQ,
     .          IIX,IIY,KDC,KDR,KDC21,KDR21,CCF,
     .          IFLAG,JFLAG)
	IF(CCF.GT.CCFBSTY)THEN
	CCFBSTY=CCF
	LYBEST=LY
	END IF
41	CONTINUE
C
	IF(IFLAG.EQ.1)WRITE(6,901)LXBEST,LYBEST,LXSV,LYSV,CCFBSTY
901	FORMAT(' AFTER Y ROW',2I5,5X,2I5,F8.3)
	IF(LYBEST.EQ.LYSV.AND.NPASS.GT.1)GO TO 51
C
	NPASS=NPASS+1
	IF (NPASS.EQ.NPASSLIM)GO TO 55
	ISTEP=NSTEP(NPASS)
	ISTART=NSTART(NPASS)
	IFIN=NFIN(NPASS)
	LXSV=LXBEST
	LYSV=LYBEST
	LY=LYBEST
	GO TO 30
C
50	CCFBEST=CCFBSTX
	GO TO 52
51	CCFBEST=CCFBSTY
	GO TO 52
55	WRITE(6,56)NPASS,LXBEST,LYBEST,LXSV,LYSV
56	FORMAT(' NOT CONVERGED',5I5)
C REPEAT WITH PRINT
C
	IF(IFLAG.EQ.0)THEN
	IFLAG=1
	GO TO 5
	END IF
	IFLAG=0
C	
C
52	CONTINUE
	NCOUNT(NPASS)=NCOUNT(NPASS)+1
C	WRITE(6,66)LXBEST,LYBEST,CCFBEST,NPASS
66	FORMAT(' POSITION OF BEST CORRELATION',2I5,F8.3,I5)
C
	CGXADJST=LXBEST/20.0
	CGYADJST=LYBEST/20.0
	IXP=52-LXBEST
	IYP=52-LYBEST
	BIGFACTR=PROFILE(52,52)/PROFILE(IXP,IYP)
	IF(BIGFACTR.GT.10.0 .OR. BIGFACTR.LT.0.0 .OR.
     .          LXBEST.GT.20 .OR. LXBEST.LT.-20 .OR.
     .          LYBEST.GT.20 .OR. LYBEST.LT.-20)  THEN
	CGXADJST=0.0
	CGYADJST=0.0
	BIGFACTR=0.0
	IDRIFT=1
	END IF
	RETURN
C
	END
C******************************************************************************
	SUBROUTINE CCFCALC(LX,LY,RADSTORE,RADLIMPSQ,RADLIMQSQ,
     .          IIX,IIY,KDC,KDR,KDC21,KDR21,
     .          CCF,IFLAG,JFLAG)
	COMMON/PROFITC/PROFILE,XC
	PARAMETER (MDC=30)
        PARAMETER (MDR=30)
	DIMENSION PROFILE(101,101),XC(MDR,MDC),RADSTORE(-180:180)
      	REAL*8 SUMCC,SUMPP,SUMPC,SUMP,SUMC
      	DATA RDEG/57.295776/
C	CALCULATE CORRELATION COEFF FOR EACH POSITION LX,LY
	SUMC=0.
	SUMP=0.
	SUMPC=0.
	SUMPP=0.
	SUMCC=0.
	NCOMP=0
C
	DO 50 ISTPX=-3,3
	XP=ISTPX*20-LX
	IXP=XP+52
	XG=IIX+ISTPX
	IXG=XG+1+KDC+1
	IF(IXG.LT.1.OR.IXG.GT.KDC21)GO TO 50
C
	DO 51 ISTPY=-3,3
	YP=ISTPY*20-LY
	IYP=YP+52
	YG=IIY+ISTPY
	IYG=YG+1+KDR+1
	IF(IYG.LT.1.OR.IYG.GT.KDR21)GO TO 51
		RADSQ=(XP**2+YP**2)
      	 IF(RADSQ.LT.RADLIMPSQ) GO TO 71
      	 IF(RADSQ.GT.RADLIMQSQ) GO TO 51
      	 IANGLE=RDEG*ATAN2(YP,XP) ! Only for radius betw P & Q.
		IF(RADSQ.GT.RADSTORE(IANGLE))GO TO 51
C	WRITE(6,70)IXP,IYP,IXG,IYG
70	FORMAT(' ??',2I5,5X,2I5)
C	DENSITY FROM PROFILE
71	RHOP=PROFILE(IXP,IYP)
C	WRITE(6,75)IXP,IYP,RHOP
75	FORMAT(' ???',2I5,E12.4)
C	DENSITY FROM CORRELATION MAP
	RHOC=XC(IXG,IYG)
C
	NCOMP=NCOMP+1
	SUMC=SUMC+RHOC
	SUMP=SUMP+RHOP
	SUMPP=SUMPP+RHOP*RHOP
	SUMCC=SUMCC+RHOC*RHOC
	SUMPC=SUMPC+RHOC*RHOP
C
51	CONTINUE
50	CONTINUE
C
C	CALCULATE CORRELATION COEFF
	IF (NCOMP.EQ.0)THEN
	JFLAG=1
	CCF=0.
	WRITE(6,65)NCOMP,LX,LY
65	FORMAT(1X,I5,' COMPARISONS FOR POSITION',2I5)
	GO TO 55
C	STOP
	END IF
	IF(NCOMP.EQ.1)THEN
	JFLAG=1
	CCF=0.0
	WRITE(6,65)NCOMP,LX,LY
	GO TO 55
	END IF

C
	TOP=SUMPC-(SUMP*SUMC)/NCOMP
	TEMPP=SUMPP-(SUMP**2)/NCOMP
	TEMPC=SUMCC-(SUMC**2)/NCOMP
	IF(TEMPP.LE.0.0)WRITE(6,67)TEMPP,TEMPC
	IF(TEMPC.LE.0.0)WRITE(6,67)TEMPP,TEMPC
67	FORMAT('?',2E12.4)
C      write(6,4) TEMPP, TEMPC		! diagnostic for overflow
4	format(' TEMPP, TEMPC =',2E15.5)
      BOTTOMSQ=TEMPP*TEMPC
      IF(BOTTOMSQ.LE.0.0)THEN
	CCF=0.0
	WRITE(6,63)LX,LY,CCF,NCOMP,SUMP,SUMC
63 	FORMAT(' ?',2I5,F8.3,I5,1X,2E10.4)
	JFLAG=1
      ELSE
	BOTTOM=SQRT(TEMPP*TEMPC)
	CCF=TOP/BOTTOM
      END IF
55	CONTINUE
	IF(IFLAG.EQ.1)WRITE(6,64)LX,LY,CCF
64	FORMAT(' POSITION AND COEFF',2I5,F8.3)
	RETURN
	END
C******************************************************************************
	SUBROUTINE PREDICT(NRANGE,IASGN,IBSGN,IA,IB,XPREDICT,YPREDICT,
     .MINA,MAXA,MINB,MAXB,XERROR,YERROR,PEAK,NAVG,IPASS)
C
C	FOR IPASS = 1 or 0; VECTORS ARE ONLY AVAILABLE FOR PREDICTION BEHIND
C	THE MOVING POINT
C	FOR IPASS = 2; ESTIMATE OF ERROR VECTORS AVAILABLE ALL ROUND EACH POINT
C
C	 XERROR(IA,IB) IS  9999.0 IF NO DATA AVAILABLE FOR ERROR AT THIS POINT;
C	IF NOT 9999.0 XERROR(IA,IB), YERROR(IA,IB) ARE
C	THE VECTORS AVAILABLE FROM THE CURRENT PASS OR THE PREVIOUS PASS
C
C
      PARAMETER (MNY=-240)
      PARAMETER (MXY=240)
      DIMENSION XERROR(MNY:MXY,MNY:MXY),YERROR(MNY:MXY,MNY:MXY)
      DIMENSION PEAK(MNY:MXY,MNY:MXY)
C
C	FORM LOCAL AVERAGE OF X AND Y DRIFTS FROM TRUE LATTICE POSITIONS
C
C
      TOTDX=0.
      TOTDY=0.
      TOTWDX=0.
      TOTWDY=0.
      SUMWT=0.0
      NAVG=0
C
      DO 110 NA=-NRANGE,NRANGE
      IAN=IA+NA
      IF(IAN.LT.MINA.OR.IAN.GT.MAXA)GO TO 110
      NASQ=(NA)*(NA)
C
      DO 10 NB=-NRANGE,NRANGE
      IBN=IB+NB
      IF(IBN.LT.MINB.OR.IBN.GT.MAXB)GO TO 10
      DISTSQ=NASQ+(NB)*(NB)
      IF(DISTSQ.EQ.0.0)THEN
      RECDIST=1.0/5.0
      ELSE
      DIST=SQRT(DISTSQ)+5.0
      RECDIST=1.0/DIST
      END IF
      IF(XERROR(IAN,IBN).EQ.9999.)GO TO 10
      TOTDX=TOTDX+XERROR(IAN,IBN)
      TOTDY=TOTDY+YERROR(IAN,IBN)
      WT=PEAK(IAN,IBN)*PEAK(IAN,IBN)*RECDIST
      TOTWDX=TOTWDX+XERROR(IAN,IBN)*WT
      TOTWDY=TOTWDY+YERROR(IAN,IBN)*WT
      SUMWT=SUMWT+WT
      NAVG=NAVG+1
10	CONTINUE
C
110	CONTINUE
C
      IF(NAVG.EQ.0.OR.SUMWT.EQ.0.0)THEN
      XPREDICT=0.
      YPREDICT=0.
C      WRITE(6,99)
99	FORMAT(' NO PREDICTION DATA AVAILABLE ')
      ELSE
C
      XPREDICT=TOTWDX/SUMWT
      YPREDICT=TOTWDY/SUMWT
C
      END IF
100	CONTINUE
C	    WRITE(6,20)IA,IB,XPREDICT,YPREDICT,SUMWT		! for diagnostic use
20	FORMAT(' IA,IB ;PREDICTED DX,DY AND NAVG,SUM OF WEIGHTS',
     .2I5,2F10.5,F10.5)
      RETURN
	    END
C*******************************************************************************
      SUBROUTINE GETXC(ARRAY,NCOL,NLINE,XC,IX,IY,KDC1,KDR1)
C
C replacement subroutine to return region of correlation map of interest, after
C reading in the entire array in one initial IRDPAS statement.
C    defunct----CALL-IRDPAS(1,XC,MDR,MDC,IX-KDC1,IX+KDC1,IY-KDR1,IY+KDR1,*9500)
      PARAMETER (MDR=30)
      PARAMETER (MDC=30)
      DIMENSION ARRAY(1),XC(MDC,MDR)
      IR = 0
      DO 75 JR = IY-KDR1,IY+KDR1
      	INDY = NCOL*JR + 1
      	IR = IR+1
      	IC = 0
      	DO 70 JC = IX-KDC1,IX+KDC1
      	 IC = IC+1
      	 INDEX = INDY + JC
      	  XC(IC,IR)=ARRAY(INDEX)
70    	CONTINUE
75    CONTINUE
      RETURN
      END
