
import re, time
import sys, traceback

class LogDataLine(object):

  def __init__(self, pattern=''):
    self.regex = re.compile(pattern)
    self.action_list = list()
    self.next_list = list()

  def add_next(self, *next_list):
    self.next_list.extend(next_list)

  def add_action(self, *action_list):
    self.action_list.extend(action_list)

class LogDataParser(object):

  def __init__(self):
    self.recovery_list = list()
    self.action_list = list()
    self.next_list = list()

  def add_next(self, *next_list):
    self.next_list.extend(next_list)

  def add_recovery_next(self, *next_list):
    self.recovery_list.extend(next_list)

  def add_recovery_action(self, *action_list):
    self.action_list.extend(action_list)

  def parse_stream(
    self,
    istream,
    ostream = None,
    verbose = False,
    pause = 0,
    patches = None,
    stop_on_error = False,
  ):
    line = istream.readline()
    line_cou = 1
    while line:
      if ostream:
        ostream.write(line)
        ostream.flush()

      if patches:
        for patch_fun in patches:
          line = patch_fun(line)

      try:
        it = iter(self.next_list)
        line_end = line
        while line_end:
          next = it.next()
          data = next.regex.match(line_end)
          if data:
            items = data.groups()
            for action in next.action_list:
              action(items)
              if pause:
                time.sleep(pause)

            self.next_list = next.next_list
            it = iter(self.next_list)
            line_end = line_end[data.end():]

      except StopIteration:
        if self.recovery_list:
          if verbose:
            print >>ostream, '|++++++++++++++++++'
            print >>ostream, '|WARNING, giving up on line %d' %line_cou
            print >>ostream, '|' + line.rstrip()
            print >>ostream, '|' + (len(line) - len(line_end))*' ' + '^'
            print >>ostream, '|with the following regular expressions'
            for next in self.next_list:
              print >>ostream, '|\'' + next.regex.pattern + '\''

            print >>ostream, '|++++++++++++++++++'

          self.next_list = self.recovery_list
          for action in self.action_list:
            action()

      except:
        if stop_on_error:
          raise

        elif verbose:
          print >>ostream, '|++++++++++++++++++'
          print >>ostream, '|WARNING, giving up on line %d' %line_cou
          print >>ostream, '|' + line.rstrip()
          print >>ostream, '|' + (len(line) - len(line_end))*' ' + '^'
          print >>ostream, '|after matching the regular expression'
          print >>ostream, '|\'' + next.regex.pattern + '\''
          print >>ostream, '|and failure of one of associated actions.'
          tb_lines = ''.join(traceback.format_exception(*sys.exc_info())).split('\n')
          for tb_line in tb_lines[:-1]:
            print >>ostream, '|' + tb_line

          print >>ostream, '|++++++++++++++++++'

      line = istream.readline()
      line_cou += 1

