C  CTFAPPLY : derived from CTFPLOT giving automatic application of C.T.F. to
C             phases input from MMBOX and output ready for ORIGTILT.
C  PROGRAM PLOTS SPOTS FROM MMBOX IN RECIPROCAL SPACE AND C.T.F. PLOT OF IMAGE.
C
C	V1.01	20.4.87		RH	changed to allow IQMAX = 9 to be passed.
C	V1.02	24.1.89		RH	plots box sizes proportional to 8.1-IQ.
C	V1.03	13.6.90		RH	Minor change to FORMAT statement 105.
C	V1.04	6.10.92		RH	extended o/p format h,k,A,P,IQ,BCK,CTF
C	V1.05	21.5.93		RH	compatible with Alliant - CCPDPN.
C	V1.06	14.4.95		RH	minor change to I/P FORMAT statement 99
C	V2.00	13.8.00		TSH	major change from plot82 to plot2k
C	V2.01	13.6.01		TSH	P2K_FONT needed string terminator
C	V2.02	21.2.06         JMS	rename CTFPLOT.PS to CTFPLOT for Mac/OSX
C	V2.03	11.4.06         RH	include line width change from RH-2001
C		remember to change version number and date in title record.
C
C  INPUT PARAMETERS
C      CARD 1    AX AY BX BY ISIZE DSTEP XMAG
C      CARD 2    DFMID1 DFMID2 ANGAST CS KV
C      CARD 3    ISER TITLE
C
C         AX,AY   - LATTICE PARAMETERS (FROM NNBOX) OF (1,0) AND (0,1)
C         BX,BY   -                                     IN GRID UNITS.
C         ISIZE   - SIZE OF DENSITOMETERED ARRAY (E.G. 2048)
C         DSTEP   - DENSITOMETER STEPSIZE IN MICRONS
C         XMAG    - PRECISE MAGNIFICATION NORMALLY WORKED OUT FROM LATTICE
C                    PARAMETERS AND KNOWN CELL DIMENSIONS.
C         DFMID1  - DEFOCUS LEVEL (UNDERFOCUS +VE). IF DFMID2=DFMID1, IMAGE
C         DFMID2  -  IS NON-ASTIGMATIC. OTHERWISE AMOUNT OF DEFOCUS IN TWO
C                    ORTHOGONAL DIRECTIONS, DFMID1 BEING DEFOCUS IN DIRECTION
C                    ANGAST (DEGS) RELATIVE TO X AND Y OF THE FOURIER TRANSFORM
C         CS      - SPHERICAL ABERRATION IN MM.
C         KV      - E.M. ACCELERATING VOLTAGE
C         ISER    - SERIAL NUMBER AT HEAD OF OUTPUT FILE.
C         TITLE   - TITLE FOR OUTPUT FILE.
C
C   INPUT  DATASTREAM  'IN'
C   OUTPUT DATASTREAM  'OUT'
C
      PARAMETER (ID=150)
      PARAMETER (RESMAX=0.3)
      PARAMETER (PLTSIZ=300.0)
      PARAMETER (CHRSIZ=0.6)
      PARAMETER (IPTMAX=1000)
      LOGICAL BITS
      REAL KV
      DIMENSION ARRAY(-ID:ID,-ID:ID),BITS(8*ID**2+8*ID+2)
      DIMENSION TITLE(15),TITLEIN(15),TEXT(20)
      DIMENSION B(2*ID+1,2*ID+1)
      DIMENSION XV(IPTMAX),YV(IPTMAX),CONT(2)
      EQUIVALENCE(ARRAY,B)
CTSH++
      CHARACTER*80 TMPTEXT
      EQUIVALENCE (TMPTEXT,TEXT)
CTSH--

      TWOPI=6.28318
      FONTSIZE=4.0 ! SELECT 4MM CHAR HEIGHT FOR TEXT
      WRITE(6,1)
1     FORMAT(/'  CTFAPPLY V2.03 : 11.4.06'//)
      READ(5,*) AX,AY,BX,BY,ISIZE,DSTEP,XMAG
      READ(5,*)DFMID1,DFMID2,ANGAST,CS,KV
      READ(5,99)ISER,TITLE
      WRITE(6,98)TITLE, ISER
99    FORMAT(I10,15A4)
98    FORMAT(' TITLE FOR PLOT AND OUTPUT FILE :',15A4/
     .	' SERIAL NUMBER ON OUTPUT',I10)
      WRITE(6,101)AX,AY,BX,BY,ISIZE,DSTEP,XMAG
      WRITE(6,102)DFMID1,DFMID2,ANGAST,CS,KV
101   FORMAT(' LATTICE PARAMETERS AX,AY............',2F10.2/
     .       '                    BX,BY............',2F10.2/
     .       ' SIZE OF DENSITOMETERED ARRAY........',I7/
     .       ' DENSITOMETERED STEPSIZE(MICRONS)....',F10.2/
     .       ' MAGNIFICATION OF MICROGRAPH.........',F8.0)
102   FORMAT(' UNDERFOCUS 1 .......................',F8.0/
     .       ' UNDERFOCUS 2 .......................',F8.0/
     .       ' DIRECTION FOR UNDERFOCUS 1 .........',F9.1/
     .       ' SPHERICAL ABERRATION (MM) ..........',F10.2/
     .       ' ACCELERATING VOLTAGE (KV) ..........',F8.0)
      CALL CCPDPN(1,'IN','READONLY','F',0,0)
      CALL CCPDPN(2,'OUT','UNKNOWN','F',0,0)
C      CALL DOPEN(1,'IN','RO','F')	! old vax open
C      CALL DOPEN(2,'OUT','NEW','F')	!  "   "   "
      READ(1,99)  NSER,TITLEIN
      WRITE(6,97) NSER,TITLEIN
97	FORMAT(' Serial no and tilted on input file of uncorrected data'/
     .	40X,I10,15A4)
      WRITE(2,99) ISER,TITLE
      ANGAST=ANGAST*TWOPI/360.0
      CALL P2K_OUTFILE('CTFPLOT',7)
      CALL P2K_HOME
      CALL P2K_LWIDTH(0.3)
      CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE)
      CALL P2K_GRID(0.5*PLTSIZ,0.5*PLTSIZ,1.0)
      CALL P2K_ORIGIN(-0.5*PLTSIZ,-0.7*PLTSIZ,0.)
      CALL P2K_COLOUR(0)
      YPOSN=PLTSIZ+5.
      CALL P2K_MOVE(10.0,YPOSN,0.)
      CALL P2K_STRING(TITLE,60,0.)
      SCALE=PLTSIZ/(2.0*RESMAX)  !MAXIMUM RESOLUTION, 0.3=3.33 ANGSTROMS
      CALL P2K_MOVE(0.,0.,0.)
      CALL P2K_DRAW(PLTSIZ,0.,0.)
      CALL P2K_DRAW(PLTSIZ,PLTSIZ,0.)
      CALL P2K_DRAW(0.,PLTSIZ,0.)
      CALL P2K_DRAW(0.,0.,0.)
      CENTRE=PLTSIZ/2.0
      CALL P2K_ORIGIN(CENTRE,CENTRE,0.)
      CS=CS*(10.0**7.0)
      KV=KV*1000.0
      WL=12.3/SQRT(KV+KV**2/(10.0**6.0))
      WRITE(6,103)WL
103   FORMAT(' WAVELENGTH (ANGSTROMS)',F10.4)
      STEPR=DSTEP*(10.0**4.0)/XMAG
      THETATR=WL/(STEPR*ISIZE)
      THETAPL=WL*RESMAX/ID
C
C  THETATR IS DIFFRACTION ANGLE OF POINT (0,1) IN TRANSFORM (IN GRID UNITS)
C  THETAPL IS DIFFRACTION ANGLE OF POINT IN PLOT ARRAY IN ARRAY INDEX UNITS.
C
      CALL P2K_MOVE(-CHRSIZ,-CHRSIZ,0.)
      CALL P2K_DRAW(CHRSIZ,CHRSIZ,0.)
      CALL P2K_MOVE(CHRSIZ,-CHRSIZ,0.)
      CALL P2K_DRAW(-CHRSIZ,CHRSIZ,0.) ! CENTRAL CROSS AT ORIGIN.
      	ALENGTH=SQRT(AX**2+AY**2)
      	X=(AX/ALENGTH)*(PLTSIZ/2.0)
      	Y=(AY/ALENGTH)*(PLTSIZ/2.0)
 	CALL P2K_MOVE(0.,0.,0.)
      	CALL P2K_DRAW(X,Y,0.)  ! PLOT ASTAR VECTOR
      	  X=X+10.
          CALL P2K_MOVE(X,Y,0.)
CTSH         ENCODE(1,151,TEXT)	
CTSH++
      	  WRITE(TMPTEXT(1:1),151)
CTSH--
151		FORMAT('H')
152		FORMAT('K')
      	  CALL P2K_CSTRING(TEXT,1,0.)
      	BLENGTH=SQRT(BX**2+BY**2)
      	X=(BX/BLENGTH)*(PLTSIZ/2.0)
      	Y=(BY/BLENGTH)*(PLTSIZ/2.0)
 	CALL P2K_MOVE(0.,0.,0.)
      	CALL P2K_DRAW(X,Y,0.)  ! PLOT BSTAR VECTOR
      	  X=X+10.
          CALL P2K_MOVE(X,Y,0.)
CTSH      	  ENCODE(1,152,TEXT)
CTSH++
      	  WRITE(TMPTEXT(1:1),152)
CTSH--
      	  CALL P2K_CSTRING(TEXT,1,0.)
      NSPOTS=0
      WRITE(6,1002)
1002	FORMAT(/' LIST OFSPOTS TO WHICH CTF IS APPLIED'/
     .	'   IH  IK     A       P  IQIN            PCORR IQOUT CNTRST')
      	NTOTSPOTS = 0
        CALL P2K_FONT('Courier'//CHAR(0),0.6*FONTSIZE) !REDUCE FONT SIZE
109	READ(1,*,END=110) IHIN,IKIN,AIN,PIN,IQIN,BIN
      IF(IQIN.GT.8) GO TO 107  ! PLOTS SPOTS WITH IQIN 8 OR LESS.
      DO 100 J=-1,1,2
      IH=J*IHIN
      IK=J*IKIN
      X=IH*AX+IK*BX
      Y=IH*AY+IK*BY
      X=X/(STEPR*ISIZE)
      Y=Y/(STEPR*ISIZE)
      IF(ABS(X).GE.RESMAX)GO TO 100
      IF(ABS(Y).GE.RESMAX)GO TO 100
      X=X*SCALE
      Y=Y*SCALE
C      WRITE(6,104)X,Y
104   FORMAT(2F10.1)
      XN=X-CHRSIZ*(8.1-IQIN)/2 ! work this one out if you can.
      XP=X+CHRSIZ*(8.1-IQIN)/2
      YN=Y-CHRSIZ*(8.1-IQIN)/2
      YP=Y+CHRSIZ*(8.1-IQIN)/2
      NSPOTS=NSPOTS+1
      CALL P2K_MOVE(XN,YN,0.)
      CALL P2K_DRAW(XP,YN,0.)
      CALL P2K_DRAW(XP,YP,0.)
      CALL P2K_DRAW(XN,YP,0.)
      CALL P2K_DRAW(XN,YN,0.)  ! SQUARE ROUND EACH SPOT.
cc      X=X-0.3				! ADJUST CHARACTER TO BE CENTRAL IN X.
cc      Y=Y+0.5				! ADJUST CHARACTER TO BE CENTRAL IN Y.
      Y=Y-1    ! ADJUST CHARACTER TO BE CENTRAL IN Y.
CTSH      	ENCODE(1,160,TEXT)
CTSH      	IF(IQIN.EQ.1) ENCODE(1,161,TEXT)	! IQIN=1 include number
CTSH      	IF(IQIN.EQ.2) ENCODE(1,162,TEXT)	! IQIN=2 include number
CTSH      	IF(IQIN.EQ.3) ENCODE(1,163,TEXT)	! IQIN=3 include number
CTSH      	IF(IQIN.EQ.4) ENCODE(1,164,TEXT)	! IQIN=4 include number
CTSH++
      	WRITE(TMPTEXT(1:1),160)
      	IF(IQIN.EQ.1) WRITE(TMPTEXT(1:1),161) ! IQIN=1 include number
      	IF(IQIN.EQ.2) WRITE(TMPTEXT(1:1),162) ! IQIN=2 include number
      	IF(IQIN.EQ.3) WRITE(TMPTEXT(1:1),163) ! IQIN=3 include number
      	IF(IQIN.EQ.4) WRITE(TMPTEXT(1:1),164) ! IQIN=4 include number
CTSH--
160	FORMAT(' ')
161	FORMAT('1')
162	FORMAT('2')
163	FORMAT('3')
164	FORMAT('4')
        CALL P2K_MOVE(X,Y,0.)
        CALL P2K_CSTRING(TEXT,1,0.)
100   CONTINUE
107 	X = IHIN*AX + IKIN*BX
 	Y = IHIN*AY + IKIN*BY
 	RAD = SQRT(X**2+Y**2)
 	ANGLE=RAD*THETATR
 	ANGSPT=ATAN2(Y,X)
      	C1=TWOPI*ANGLE*ANGLE/(2.0*WL)
      	C2=-C1*CS*ANGLE*ANGLE/2.0
      	ANGDIF=ANGSPT-ANGAST
      	CCOS=COS(2.0*ANGDIF)
      	DF=0.5*(DFMID1+DFMID2+CCOS*(DFMID1-DFMID2))
      	CHI=C1*DF+C2
      	CNTRST=-SIN(CHI)
 	IQ=IQIN
 	IF(ABS(CNTRST).LT.0.15.AND.ANGLE.GT.WL/5.5) IQ=MAX(IQ,5)
C  above sets IQ to 5 for high resolution spots with ctf < 0.15.
 	P=PIN
 	IF(CNTRST.LT.0.0) P=PIN+180.0
 	IF(P.GE.360.0) P=P-360.0
 	WRITE(2,1000) IHIN,IKIN,AIN,P,IQ,BIN,CNTRST ! O/P of SPOTS.
C		NOTE A FEW SPOTS NEAR CTF ZEROES HAVE THEIR IQ CHANGED TO 5.
1000	FORMAT(2I4,2F8.1,I3,F8.1,F8.3)
      	NTOTSPOTS = NTOTSPOTS +1
      IF(IQ.LE.7) THEN
 	WRITE(6,1001)IHIN,IKIN,AIN,PIN,IQIN,P,IQ,CNTRST
1001	FORMAT(1X,2I4,2F8.1,I3,F18.1,I3,F8.3)
1003	FORMAT(1X,2I4,2F8.1,I3,F18.1,I3,F8.3,' WRITTEN OUT, BUT IQ=8,9')
      ELSE
 	WRITE(6,1003)IHIN,IKIN,AIN,PIN,IQIN,P,IQ,CNTRST
      ENDIF
      GO TO 109
110   CLOSE(1)
      CLOSE(2)
      CALL P2K_ROR
C
      WRITE(6,108)NTOTSPOTS
108   FORMAT(' THERE WERE',I10,'  TOTAL SPOTS PASSED TO OUTPUT FILE')
      NUNIQUE=NSPOTS/2
      WRITE(6,105)NSPOTS,NUNIQUE
105   FORMAT(I10,'  SPOTS WITH IQ 8 OR LESS PLOTTED,',I10,
     $	' OF THEM UNIQUE')
      NCALC=0
      CTFAVG=0.0
      DO 200 IX=-ID,ID
      DO 200 IY=-ID,ID
      IF(IX.EQ.0.AND.IY.EQ.0) THEN
      	CNTRST=0.0
      	GO TO 200
      ENDIF
      T1=IX
      T2=IY
      RAD2=T1*T1+T2*T2
      RAD=SQRT(RAD2)
      ANGLE=RAD*THETAPL
      C1=TWOPI*ANGLE*ANGLE/(2.0*WL)
      C2=-C1*CS*ANGLE*ANGLE/2.0
      ANGSPT=ATAN2(T2,T1)
      ANGDIF=ANGSPT-ANGAST
      CCOS=COS(2.0*ANGDIF)
      DF=0.5*(DFMID1+DFMID2+CCOS*(DFMID1-DFMID2))
      CHI=C1*DF+C2
      CNTRST=-SIN(CHI)
      CTFAVG=CTFAVG+ABS(CNTRST)
      NCALC=NCALC+1
200   ARRAY(IX,IY)=CNTRST
      IF(NCALC.NE.0) CTFAVG=CTFAVG/NCALC
      WRITE(6,106)NCALC,CTFAVG
106   FORMAT(' C.T.F. NOW GENERATED',I10,' CALCULATED POINTS',
     . ' AVERAGE CTF VALUE',F5.2,' - PROCEED TO CONTOURING')
      CONT(1)=0.0
      CONT(2)=5.0  ! OFF TOP OF CTFPLOT
      NCONT=2
      M=2*ID+1
      SCALE=PLTSIZ/(2.0*ID)
      CALL HPCNTR(B,M,M,SCALE,BITS,CONT,NCONT,XV,YV,IPTMAX)
C HPCNTR IS SAME AS PLUTO SUBROUTINE BUT WITHH OTHER CALLS REMOVED AND SCALE
C ADDED TO ARGUMENT LIST.
      CALL P2K_PAGE
      END
C**APLOT***********************************************************************
      SUBROUTINE APLOT(XV,YV,NPT,SCALE)
      DIMENSION XV(NPT),YV(NPT)
C      WRITE(6,10)NPT,SCALE
10    FORMAT(' ENTERING APLOT, NPT,SCALE',I10,F10.3)
      X=XV(1)*SCALE
      Y=YV(1)*SCALE
      CALL P2K_MOVE(X,Y,0.)
      DO 1 I=2,NPT
      X=XV(I)*SCALE
      Y=YV(I)*SCALE
1     CALL P2K_DRAW(X,Y,0.)
      RETURN
      END
C**HPCNTR**********************************************************************
      SUBROUTINE HPCNTR (A,M,N,SCALE,BITS,CONT,NCONT,X,Y,IPTMAX)
C
C***************************************
C
C                  CONTUR ROUTINE
C
C***************************************
C
C  A IS FUNCTION TO BE CONTOURED, DIMENSIONED A(M,N) OR A(M*N)
C  M = NUMBER OF ROWS OF A
C  N = NUMBER OF COLUMN
C  BITS IS LOGICAL*1 ARRAY DIMENSIONED AT LEAST 2*M*N IN CALLING ROUTINE.
C  CONT  ARRAY OF NCONT CONTOUR LEVELS
C  X,Y  ARRAYS OF DIMENSION IPTMAX USED IN SUBROUTINE TO STORE CONTOUR LINES
C
C  IDIV = NUMBER OF LINE SEGMENTS BETWEEN CONTOUR LEVEL CROSSINGS IN UNIT GRID
C     CELL.  IF >= 1, THEN ROUTINE FINDS IDIV-1 COORDINATES BETWEEN CROSSINGS,
C     BY LINEAR INTERPOLATION ON THE UNIT CELL.
C  CONTUR OUTPUT VIA CALLS TO SUBROUTINE APLOT (X,Y,IPT,SCALE)
C     X,Y ARE COORDINATES WITH 0<=X<M AND 0<=Y<N.
C  SUBROUTINE CONSTL(CL) IS CALLED TO SET UP PLOTTING STYLE FOR CONTOUR LEVEL CL
C
      DIMENSION IDIR(4), ISIDE(5), IVCT(4), JVCT(4), KVCT(4), LVCT(4),
     *   SIDE(4), NVCT(4)
      LOGICAL*1 BITS
      DIMENSION A(1),BITS(1),C(4),CONT(NCONT)
      DIMENSION X(1),Y(1)
      DATA  IDIR/3,4,1,2/, ISIDE/1,2,3,4,1/, IVCT/0,-1,0,1/,
     * JVCT/-1,0,1,0/, SIDE/0.,0.,1.0,1.0/, KVCT/4,1,2,3/, LVCT/2,3,4,1/
C
        CLOLD=1.E28
        IDIV=1
      MN=M*N
      MN2=2*MN
      DIV=IDIV
      ICONT=1
C
C LOOP CONTOUR LEVELS CL
1     CL=CONT(ICONT)
      ICONT=ICONT+1
C SET UP PLOTTING STYLE FOR THIS CONTOUR LEVEL
C      CALL CONSTL(CL) 	! USED TO SET CONTOUR LINE TYPE
C
C
C
        DO 10 I=1,MN2
10    BITS(I)=.FALSE.
      NVCT(1)=0
      NVCT(2)=MN
      NVCT(3)=M
      NVCT(4)=MN+1
      IPT=1
      MM=M-1
      NN=N-1
C     SEARCH FOR CONTOUR CROSSING BETWEEN ADJACENT COLUMN OF ARRAY A(I,J)
      I=0
      J=1
      ISUB=0
      JSUB=0
      IRTN=1
  100 IF (J .GT. N) GO TO 140
  110 IF (I .GE. MM) GO TO 130
      I=I+1
      ISUB=ISUB+1
      JSUB=JSUB+1
      IF (A(ISUB)-CL) 115,600,120
115   IF (A(ISUB+1)-CL) 110,110,125
120   IF (A(ISUB+1)-CL) 125,110,110
125   IF (BITS(JSUB+NVCT(1)))  GO TO 110
      XSTART=(CL-A(ISUB))/(A(ISUB+1)-A(ISUB))
      YSTART=0
      GO TO 200
  130 I=0
      ISUB=ISUB+1
      JSUB=JSUB+1
      J=J+1
      GO TO 100
C     SEARCH FOR CONTOUR CROSSING BETWEEN ADJACENT ROWS OF ARRAY A(I,J)
  140 I=0
      J=1
      JSUB=0
      ISUB=0
      IRTN=2
  150 IF (J .GT. NN) GO TO 190
  160 IF (I .GE. M) GO TO 180
      I=I+1
      ISUB=ISUB+1
      JSUB=JSUB+1
      IF (A(ISUB)-CL) 165,160,170
165   IF (A(ISUB+M)-CL) 160,160,175
170   IF (A(ISUB+M)-CL) 175,160,160
175   IF (BITS(JSUB+NVCT(2)))  GO TO 160
      YSTART=(CL-A(ISUB))/(A(ISUB+M)-A(ISUB))
      XSTART=0
      GO TO 200
  180 I=0
      J=J+1
      GO TO 150
190   IF(ICONT.GT.NCONT)RETURN
      GO TO 1
C
C
C     BEGIN FOLLOWING CONTOUR LINE... SAVE INDICIES FOR RETURN TO SEARCH
  200 ISAVE=I
      JSAVE=J
      ISUBSV=ISUB
      JSUBSV=JSUB
      XSAVE=XSTART
      YSAVE=YSTART
      X(1)=XSTART+FLOAT(I-1)
      Y(1)=YSTART+FLOAT(J-1)
      IENT=IRTN
      IRS=0
      GO TO 250
C     DUMP LINE AND FOLLOW CONTOUR LINE ON OPPOSITE SIDE OF STARTING PIONT
C     WHEN USED A SECOND TIME THIS ENTRY RETURNS TO SEARCH
  205 IRS=1
  210 IF (IPT .GT. 1) CALL  APLOT(X,Y,IPT,SCALE)
      IPT=1
      I=ISAVE
      J=JSAVE
      ISUB=ISUBSV
      JSUB=JSUBSV
      XSTART=XSAVE
      YSTART=YSAVE
      X(1)=XSTART+FLOAT(I-1)
      Y(1)=YSTART+FLOAT(J-1)
      IF (IRS.NE.0) GO TO (110,160), IRTN
      IEXIT=IRTN
      IRS=1
      GO TO 240
C     RETURN FROM FOLLOWING CONTOUR LINE THROUGH A CELL
230   IF (BITS(JSUB+NVCT(IEXIT)))  GO TO 205
  240 I=I+IVCT(IEXIT)
      J=J+JVCT(IEXIT)
      JSUB=I+(J-1)*M
      ISUB=JSUB
      IENT=IDIR(IEXIT)
250   BITS(JSUB+NVCT(IENT))=.TRUE.
      IF (I.LT.1 .OR. I.GT.MM .OR. J.LT.1 .OR. J.GT.NN)  GO TO 210
C     FIND CONTOUR CROSSING IN NEW CELL
260   IF (ISUB+1.GT.MN .OR. ISUB+M.GT.MN
     1     .OR. ISUB+1+M.GT.MN)  GO TO 210
      C(1)=A(ISUB+1)
      C(2)=A(ISUB)
      C(3)=A(ISUB+M)
      C(4)=A(ISUB+1+M)
      JRTN=1
      ICNT=1
      JCNT=1
      DO 290 IROUND=1,4
      IF (IROUND .EQ. IENT) GO TO 290
      I1=ISIDE(IROUND)
      I2=ISIDE(IROUND+1)
      IF (C(I1)-CL) 270,285,275
  270 IF (C(I2)-CL) 290,290,280
  275 IF (C(I2)-CL) 280,290,290
  280 IEXIT=IROUND
      ICNT=ICNT+1
      GO TO 290
  285 JEXIT=IROUND
      JCNT=JCNT+1
  290 CONTINUE
      GO TO (300,310,700,210), JCNT
  300 GO TO (210,320,210,800), ICNT
  310 GO TO (710,320,210,210), ICNT
  320 GO TO (330,340,350,360), IENT
  330 GO TO (210,410,500,410), IEXIT
  340 GO TO (510,210,510,400), IEXIT
  350 GO TO (500,410,210,410), IEXIT
  360 GO TO (510,400,510,210), IEXIT
C     FOLLOW CONTOUR LINE ACROSS A CELL TO A SIDE
  400 XSTART=SIDE(IENT)
  410 XFIN=SIDE(IEXIT)
      XINC=(XFIN-XSTART)/DIV
      XBASE=FLOAT(I-1)
      YBASE=FLOAT(J-1)
      A1=CL-C(2)
      A2=C(1)-C(2)
      A3=C(3)-C(2)
      A4=C(2)-C(1)+C(4)-C(3)
      DO 440 INTERP=1,IDIV
      XSTART=XSTART+XINC
      YSTART=(A1-A2*XSTART)/(A3+A4*XSTART)
      IF (IPT.LT.IPTMAX)  GO TO 430
      CALL APLOT(X, Y, IPT,SCALE)
      X(1)=X(IPT)
      Y(1)=Y(IPT)
      IPT=1
  430 IPT=IPT+1
      X(IPT)=XBASE+XSTART
      Y(IPT)=YBASE+YSTART
  440 CONTINUE
      GO TO (230,210,615,635), JRTN
  500 YSTART=SIDE(IENT)
C     FOLLOW CONTOUR LINE ACROSS A CELL TO A TOP OR BOTTOM
  510 YFIN=SIDE(IEXIT)
      XBASE=FLOAT(I-1)
      YINC=(YFIN-YSTART)/DIV
      YBASE=FLOAT(J-1)
      A1=CL-C(2)
      A2=C(3)-C(2)
      A3=C(1)-C(2)
      A4=C(2)-C(1)+C(4)-C(3)
      DO 540 INTERP=1,IDIV
      YSTART=YSTART+YINC
      XSTART=(A1-A2*YSTART)/(A3+A4*YSTART)
      IF (IPT.LT.IPTMAX) GO TO 530
      CALL APLOT(X, Y, IPT,SCALE)
      X(1)=X(IPT)
      Y(1)=Y(IPT)
      IPT=1
  530 IPT=IPT+1
      X(IPT)=XBASE+XSTART
      Y(IPT)=YBASE+YSTART
  540 CONTINUE
      GO TO (230,210,615,635), JRTN
C     FOLLOW CONTOUR LINE FROM CORNER TO CORNER
600   K1=ISUB-M
      K2=ISUB+1-M
      K3=ISUB+1
      K4=ISUB+1+M
      K5=ISUB+M
      K6=ISUB-1+M
      K7=ISUB-1
      C1=A(K1)
      C2=A(K2)
      C3=A(K3)
      C4=A(K4)
      C5=A(K5)
      C6=A(K6)
      C7=A(K7)
      C8=A(ISUB)
      IF (ISUB.LT.1 .OR. ISUB.GT.MN) GO TO 640
      X(1)=FLOAT(I-1)
      Y(1)=FLOAT(J-1)
      IF (J .EQ. 1 .OR. J .EQ. M)  GO TO 610
      IF (K1.LT.1 .OR. K1.GT.MN)  GO TO 610
      IF (K2.LT.1 .OR. K2.GT.MN)  GO TO 610
      IF (K3.LT.1 .OR. K3.GT.MN)  GO TO 610
      IF (K4.LT.1 .OR. K4.GT.MN)  GO TO 610
      IF (K5.LT.1 .OR. K5.GT.MN)  GO TO 610
      IF (C3.NE.CL)  GO TO 610
      IF (C1 .EQ. CL .AND. C2 .EQ. CL .AND.
     *    C4 .EQ. CL .AND. C5 .EQ. CL)  GO TO 610
      X(2)=X(1)+1.
      Y(2)=Y(1)
      CALL APLOT (X, Y, 2,SCALE)
      GO TO 620
  610 IF (J .EQ. 1)  GO TO 620
      IF (K1.LT.1 .OR. K1.GT.MN)  GO TO 620
      IF (K2.LT.1 .OR. K2.GT.MN)  GO TO 620
      IF (K3.LT.1 .OR. K3.GT.MN)  GO TO 620
      IF (C2 .NE. CL)  GO TO 620
      IF (C1 .EQ. CL .OR. C3 .EQ. CL)  GO TO 620
      IF (C1 .GT. CL .AND. C3 .GT. CL .OR.
     *    C1 .LT. CL .AND. C3 .LT. CL)  GO TO 620
      C(1)=C2
      C(2)=C1
      C(3)=C8
      C(4)=C3
      J=J-1
      JRTN=3
      IENT=3
      IEXIT=1
      GO TO 500
  615 IF (IPT .GT. 1)  CALL APLOT (X, Y, IPT,SCALE)
      IPT=1
      J=J+1
      X(1)=FLOAT(I-1)
      Y(1)=FLOAT(J-1)
  620  IF (J .EQ. M .OR. I .EQ. 1)  GO TO 630
      IF (K3.LT.1 .OR. K3.GT.MN)  GO TO 630
      IF (K4.LT.1 .OR. K4.GT.MN)  GO TO 630
      IF (K5.LT.1 .OR. K5.GT.MN)  GO TO 630
      IF (K6.LT.1 .OR. K6.GT.MN)  GO TO 630
      IF (K7.LT.1 .OR. K7.GT.MN)  GO TO 630
      IF (C5 .NE. CL)  GO TO 630
      IF (C3 .EQ. CL .AND. C4 .EQ. CL .AND.
     *    C6 .EQ. CL .AND. C7 .EQ. CL)   GO TO 630
      X(2)=X(1)
      Y(2)=Y(1)+1.
      CALL APLOT (X, Y, 2,SCALE)
      GO TO 640
  630 IF (J .EQ. M)  GO TO 640
      IF (K3.LT.1 .OR. K3.GT.MN)  GO TO 640
      IF (K4.LT.1 .OR. K4.GT.MN)  GO TO 640
      IF (K5.LT.1 .OR. K5.GT.MN)  GO TO 640
      IF (C4 .NE. CL)  GO TO 640
      IF (C3 .EQ. CL .OR. C5 .EQ. CL)  GO TO 640
      IF (C3 .GT. CL .AND. C5 .GT. CL .OR.
     *    C3 .LT. CL .AND. C5 .LT. CL)  GO TO 640
      C(1)=C3
      C(2)=C8
      C(3)=C5
      C(4)=C4
      JRTN=4
      IENT=1
      IEXIT=3
      GO TO 500
  635 IF (IPT .GT. 1) CALL APLOT (X, Y, IPT,SCALE)
      IPT=1
      X(1)=FLOAT(I-1)
      Y(1)=FLOAT(J-1)
  640 GO TO (110,160), IRTN
C    FOLLOW CONTOUR LINE FROM SIDE TO CORNER OR CORNERS
  700 JRTN=2
      IOPP=IDIR(IENT)
      I1=ISIDE(IOPP)
      I2=ISIDE(IOPP+1)
      IEXIT=IOPP
      C(I1)=C(KVCT(I1))
      C(I2)=C(LVCT(I2))
      GO TO 320
  710 JRTN=2
      IEXIT=JEXIT
      GO TO 320
C     FOLLOW CONTOUR LINE THROUGH SADDLE POINT
  800 IOPP=IDIR(IENT)
      I1=ISIDE(IENT)
      C1=C(I1)
      I2=ISIDE(IENT+1)
      C2=C(I2)
      I3=ISIDE(IOPP)
      C3=C(I3)
      I4=ISIDE(IOPP+1)
      C4=C(I4)
      IF ((C1-CL)/(C1-C2) .EQ. (C4-CL)/(C4-C3))  GO TO 820
      IF ((C1-CL)/(C1-C4) .GT. (C2-CL)/(C2-C3))  GO TO 810
      IEXIT=I4
      GO TO 320
  810 IEXIT=I2
      GO TO 320
  820 C(I3)=C(I2)
      C(I4)=C(I1)
      IEXIT=I3
      GO TO 320
      END
