C      PROGRAM TO PLOT FITTED CURVES AND DATA POINTS FROM DATA SET
C      GENERATED BY SYNCFITP3; VERSION ADAPTED FOR P3
C      ALSO PLOTS GUIDE POINTS TAKEN FROM PREVIOUS CURVES
C
C	VX1.1	RH	5.11.98	increase dimensions plus PARAMETER
C	VX1.2	RH	25.8.00	convert to plot2000 direct to postscript
C	VX1.3	RH	28.8.00	debug - TEXT(20) dimension statement added
C         "     TSH     13.6.01 P2K_FONT needed string terminator
C
      PARAMETER (NMAX=2000)
      PARAMETER (NCMX=500)
      DIMENSION SIG(NMAX),XX(NMAX),YY(NMAX),CX(NCMX),CY(NCMX),EY(NCMX)
CTSH      DIMENSION TITLE(10),TEXT(20)
CTSH++
      DIMENSION TITLE(10)
      CHARACTER*80 TEXT
CTSH--
C
      WRITE(6,99)
99    FORMAT(/' PLTSYNCP3 VX1.2 (25.8.00)'/)
C
C      CALL DOPEN(10,'PLOTDATA','RO','U')	! old vax input
      CALL CCPDPN(10,'PLOTDATA','READONLY','U',0,0)
      READ(5,*) XSFACTOR,INTMAX
      WRITE(6,102) XSFACTOR,INTMAX
102   FORMAT(' X-axis scale factor(600), in mm per ZSTAR unit=',F10.1/
     $' Minimum intensity/1000 for graph Y value (ie. 5=5000)=',I7)
10    READ(5,*)IPLOT1,IPLOT2
      WRITE(6,101)IPLOT1,IPLOT2
101   FORMAT(/' REQUESTED PLOT NUMBERS',I5,' TO',I5)
      IF(IPLOT1.LT.0)GO TO 200
      IPLOTC=IPLOT1
150   READ(10)IPLOT,JH,JK,N,NGUIDE,NG1,NG2,AMPMAX
      write(6,151)IPLOT,JH,JK,N,NGUIDE,NG1,NG2,AMPMAX
151   format(' IPLOT,JH,JK,N,NGUIDE,NG1,NG2,AMPMAX',7I6,F10.1)
      READ(10)NSER,TITLE
      NPLOT=N+NGUIDE+NG1+NG2
C      WRITE(6,5000)N,NGUIDE,NG1,NG2
C5000  FORMAT(4I5)
      IF(NGUIDE.EQ.-1)NPLOT=N+NG1+NG2
      IF(NPLOT.GT.NMAX) THEN
      	WRITE(6,999) NPLOT
999   	FORMAT(' Too many points',I5,' on line for program dimensions')
      	STOP
      ENDIF
C
      DO 5 J=1,NPLOT
      READ(10)XX(J),YY(J),SIG(J)
C      WRITE(6,11)XX(J),YY(J),SIG(J)
11    FORMAT(3F10.5)
5     CONTINUE
      IF(NGUIDE.EQ.-1)GO TO 7
      READ(10)JLAST
      IF(JLAST.GT.NCMX) THEN
      	WRITE(6,998) JLAST
998   	FORMAT(' Too many points',I5,' on curve for program dimensions')
      	STOP
      ENDIF
      DO 6 J=1,JLAST
      READ(10)CX(J),CY(J),EY(J)
6     CONTINUE
C
7     IF(IPLOT.NE.IPLOTC)GO TO 150
      WRITE(6,2)IPLOT,JH,JK,N,NGUIDE,NG1,NG2,AMPMAX,NSER,TITLE
2     FORMAT(/' PLOT NUMBER',I5,' LINE',2I5,' NUMBER OF POINTS',
     14I5/' AMPMAX',F10.0,' RUN',I5,10A4)
C
      PLTSIZ=233.0
      FONTSIZE=3.8
      CALL P2K_OUTFILE('PLOTOUT.PS',10)
      CALL P2K_HOME
      CALL P2K_LWIDTH(0.3)
      CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE)
      CALL P2K_TWIST(90.0,180.0,120.0)
      CALL P2K_GRID(0.5*PLTSIZ,0.5*PLTSIZ,1.0)
      CALL P2K_ORIGIN(0.0,-0.40*PLTSIZ,0.)
      CALL P2K_COLOUR(0)
      CALL P2K_MOVE(100.,170.,0.)
CTSH      ENCODE(16,512,TEXT)NSER
CTSH++
      WRITE(TEXT,512)NSER
CTSH--
512   FORMAT(' RUN NUMBER',I5)
C
      CALL P2K_STRING(TEXT,16,0.)
      CALL P2K_MOVE(100.,155.,0.)
CTSH      ENCODE(23,508,TEXT)JH,JK
CTSH++
      WRITE(TEXT,508)JH,JK
CTSH--
508   FORMAT(' LATTICE LINE (',I3,',',I3,')')
      CALL P2K_STRING(TEXT,23,0.)
C NOW DRAW AXES
      CALL P2K_MOVE(-160.,0.,0.)
      CALL P2K_DRAW(160.,0.,0.)
      CALL P2K_MOVE(0.,0.,0.)
      CALL P2K_DRAW(0.,150.,0.)
C
      DO 1130 I=1,15
      C=I
      C=(-1.)+C
      E=0.
      F=-3.0
      G=10.+(10.*C)
      CALL P2K_MOVE(G,E,0.)
      CALL P2K_DRAW(G,F,0.)
      CALL P2K_MOVE(-G,E,0.)
      CALL P2K_DRAW(-G,F,0.)
1130  CONTINUE
C
C LABEL X AXIS
C
      YPOS=-10.0
      ZSTINCR=0.1
      DO 507 IZ=-3,3
      XPOS=FLOAT(IZ)*XSFACTOR/10.0
      ZST=ZSTINCR*IZ
      CALL P2K_MOVE(XPOS,YPOS,0.)
      IF(ZST.LT.0.0) THEN
      	NUMCHARS=4
CTSH      	ENCODE(NUMCHARS,506,TEXT)ZST
CTSH++
      	WRITE(TEXT,506)ZST
CTSH--
506   	FORMAT(F4.1)
      ELSE
      	NUMCHARS=3
CTSH      	ENCODE(NUMCHARS,509,TEXT)ZST
CTSH++
      	WRITE(TEXT,509)ZST
CTSH--
509   	FORMAT(F3.1)
      ENDIF
      CALL P2K_CSTRING(TEXT,NUMCHARS,0.)
507   CONTINUE
C
      XPOS=130.0
      CALL P2K_MOVE(XPOS,YPOS,0.)
CTSH      ENCODE(5,510,TEXT)
CTSH++
      WRITE(TEXT,510)
CTSH--
510   FORMAT('ZSTAR')
      CALL P2K_CSTRING(TEXT,5,0.)
C
      IMAX=AMPMAX/1000.+1
      IF(IMAX.LT.INTMAX)IMAX=INTMAX
      ISCALE=IMAX*1000
      YSCALE=150./ISCALE
      STEP=150./IMAX
      XPOS=0.
      XPOS1=1.5
      YPOS=0.
      DO 500 IY=1,IMAX
      YPOS=YPOS+STEP
      CALL P2K_MOVE(XPOS,YPOS,0.)
      CALL P2K_DRAW(XPOS1,YPOS,0.)
500   CONTINUE
      YPOS=IMAX*STEP
      CALL P2K_MOVE(XPOS1,YPOS-1.0,0.)
CTSH      ENCODE(5,501,TEXT)ISCALE
CTSH++
      WRITE(TEXT,501)ISCALE
CTSH--
501   FORMAT(I5)
      CALL P2K_STRING(TEXT,5,0.)
C
C
      I1=NG1+1
      I2=NG1+N
      IF(I2.GT.NMAX) THEN
      	WRITE(*,*)'I2,NG1,N=',I2,NG1,N
      	STOP '***** ERROR ****** I2 > NMAX'
      ENDIF
      DO 1110 I=I1,I2
      X=XSFACTOR*XX(I)
      Y=YSCALE*YY(I)
      YMAX=Y+YSCALE*SIG(I)
      YMIN=Y-YSCALE*SIG(I)
      IF(X.GT.159.5)GO TO 5001
      IF(X.LT.-159.5)GO TO 5001
      CALL P2K_MOVE(X,YMAX,0.)
      CALL P2K_DRAW(X,YMIN,0.)
      X1=X-0.5
      X2=X+0.5
      Y1=Y-0.5
      Y2=Y+0.5
      CALL P2K_MOVE(X1,Y1,0.)
      CALL P2K_DRAW(X2,Y2,0.)
      CALL P2K_MOVE(X1,Y2,0.)
      CALL P2K_DRAW(X2,Y1,0.)
5001  CONTINUE
1110  CONTINUE
C
C     PLOT GUIDE POINTS WITH +VE Z VALUE FOR CENTROSYMMETRIC CURVES
C     PLOT ALL GUIDE POINTS FOR NON CENTROSYMMETRIC CURVES
C     GUIDE POINTS PLOTTED WITHOUT ERROR ESTIMATE
      IF(NGUIDE.EQ.-1)GO TO 401
C
C   PLOT INTERPOLATED GUIDE POINTS
      IG1=N+NG1+NG2
      IZERO=0
      IGP=0
      DO 400 I=1,NGUIDE
      IG=IG1+I
C      IF(XX(IG).LT.0.0)GO TO 400
C      IF(XX(IG).EQ.0.0.AND.YY(IG).EQ.0.0)IZERO=1
C      IF(XX(IG).EQ.0.0.AND.YY(IG).NE.0.0)GO TO 400
      X=XSFACTOR*XX(IG)
      Y=YSCALE*YY(IG)
      YMAX=Y+0.5
      YMIN=Y-0.5
      IF(X.GT.159.5)GO TO 5002
      IF(X.LT.-159.5)GO TO 5002
      IGP=IGP+1
      CALL P2K_MOVE(X,YMAX,0.)
      CALL P2K_DRAW(X,YMIN,0.)
      X1=X-0.5
      X2=X+0.5
      CALL P2K_MOVE(X1,Y,0.)
      CALL P2K_DRAW(X2,Y,0.)
5002  CONTINUE
400   CONTINUE
C   PLOT GUIDE POINTS FROM PREVIOUS CURVES FOR -Z; IF PRESENT
      IF (NG1.EQ.0)GO TO 4003
      DO 4001 I=1,NG1
      IG=I
C      IF(XX(IG).LT.0.0)GO TO 400
C      IF(XX(IG).EQ.0.0.AND.YY(IG).EQ.0.0)IZERO=1
C      IF(XX(IG).EQ.0.0.AND.YY(IG).NE.0.0)GO TO 400
      X=XSFACTOR*XX(IG)
      Y=YSCALE*YY(IG)
      YMAX=Y+0.5
      YMIN=Y-0.5
      IF(X.GT.159.5)GO TO 5003
      IF(X.LT.-159.5)GO TO 5003
      IGP=IGP+1
      CALL P2K_MOVE(X,YMAX,0.)
      CALL P2K_DRAW(X,YMIN,0.)
      X1=X-0.5
      X2=X+0.5
      CALL P2K_MOVE(X1,Y,0.)
      CALL P2K_DRAW(X2,Y,0.)
5003   CONTINUE
4001   CONTINUE
4003   CONTINUE
C   PLOT GUIDE POINTS FROM PREVIOUS CURVES +Z; IF PRESENT
      IF (NG2.EQ.0)GO TO 4004
      I3=N+NG1+1
      I4=N+NG1+NG2
      DO 4002 I=I3,I4
      IG=I
C      IF(XX(IG).LT.0.0)GO TO 400
C      IF(XX(IG).EQ.0.0.AND.YY(IG).EQ.0.0)IZERO=1
C      IF(XX(IG).EQ.0.0.AND.YY(IG).NE.0.0)GO TO 400
      X=XSFACTOR*XX(IG)
      Y=YSCALE*YY(IG)
      YMAX=Y+0.5
      YMIN=Y-0.5
      IF(X.GT.159.5)GO TO 5004
      IF(X.LT.-159.5)GO TO 5004
      IGP=IGP+1
      CALL P2K_MOVE(X,YMAX,0.)
      CALL P2K_DRAW(X,YMIN,0.)
      X1=X-0.5
      X2=X+0.5
      CALL P2K_MOVE(X1,Y,0.)
      CALL P2K_DRAW(X2,Y,0.)
5004   CONTINUE
4002   CONTINUE
4004   CONTINUE
C
      ICP=0
C     PLOT FITTED CURVE
      DO 5006 I=1,JLAST
      XP=CX(I)*XSFACTOR
      IF(XP.LT.-159.5)GO TO 5006
      ICP=ICP+1
      YP=CY(I)*YSCALE
      IF(YP.GT.180.)YP=180.
      IF(YP.LT.-20.)YP=-20.
      I1=I+1
      CALL P2K_MOVE(XP,YP,0.)
      GO TO 5007
5006  CONTINUE
C
5007  DO 410 I=I1,JLAST
      IF(CX(I).EQ.100.)GO TO 411
      XP=CX(I)*XSFACTOR
      YP=YSCALE*CY(I)
      IF(YP.GT.180.)YP=180.
      IF(YP.LT.-20.)YP=-20.
      IF(XP.LT.-159.5)GO TO 5005
      IF(XP.GT.159.5)GO TO 5005
      ICP=ICP+1
      CALL P2K_DRAW(XP,YP,0.)
5005  CONTINUE
410   CONTINUE
411   CONTINUE
C
C     DRAW ERROR CURVE IN DASHED LINE
      DO 5008 I=1,JLAST
      EYP=EY(1)*YSCALE
      IF(EYP.GT.180.)EYP=180.
      IF(EYP.LT.-20.)EYP=-20.
      XP=XSFACTOR*CX(1)
      IF(XP.LT.-159.5)GO TO 5008
      CALL P2K_MOVE(XP,EYP,0.)
      I1=I+1
      GO TO 5009
5008  CONTINUE
5009  DO 415 I=I1,JLAST
      IF(CX(I).EQ.100.)GO TO 416
      XP=CX(I)*XSFACTOR
      IF(XP.LT.-159.5)GO TO 5010
      IF(XP.GT.159.5)GO TO 5010
      EYP=YSCALE*EY(I)
      IF(EYP.GT.180.)EYP=180.
      IF(EYP.LT.-20.)EYP=-20.
      I2=I/2
      ITEST=I-2*I2
      IF(ITEST.EQ.0)CALL P2K_DRAW(XP,EYP,0.)
      IF(ITEST.NE.0)CALL P2K_MOVE(XP,EYP,0.)
5010  CONTINUE
415   CONTINUE
416   CONTINUE
C
      WRITE(6,402)IGP,IZERO,ICP
402   FORMAT('   NUMBER OF GUIDE POINTS PLOTTED =',I4,' INCLUDING ',
     1I2,' AT Z=0'/' NUMBER OF POINTS PLOTTED FOR FITTED CURVE =',I4)
401   CALL P2K_PAGE
C
      IPLOTC=IPLOTC+1
      IF(IPLOTC.LE.IPLOT2)GO TO 150
      GO TO 10
C
200   WRITE(6,201)
201   FORMAT(' PLOTS FINISHED')
C
      END
