
import pyrvapi_ext as API
import regex_tree as RT
import time
import sys


class molrep_parser(object):

    def flush(self):
        if self.pause > 0:
            time.sleep(self.pause)

        API.flush()

    def __init__(
        self,
        rvapi_grid,
        show_progs = False,
        pause = 0,
        **kwargs
    ):
        self.pause = pause

        i = ' +(-?[0-9]+)'
        r = '( *[- ][0-9]+\.[0-9]*(?:E[+-]?[0-9]+)?)'
        x = ' +\((-?[0-9]+\.[0-9]*)\)'
        b = '^'
        v = ' *\|'
        e = ' *\n'
        mask_msg = '^ --- Remove fixed model from Fobs by mask  ---\n'
        saptf_title = '^  --- SAPTF and (Phased |)Rotation function ---\n'
        crf_title = '^     --- Peaks of Rotation Function ---\n'
        tf_title = '^  --- Translation function ---\n'
        ptf_title = '^  --- phased translation function ---\n'
        tf_title = '^  --- (phased t|T)ranslation function ---\n'
        crf_head = '^ +\| +theta +phi +chi +Rf/sigma \|\n'
        tf_head = '^ +RF +TF +TF/sig +TFcntrst +PFind +PF'
        tf_head += ' +PF(?:min|mod) +wRfac +Score +Cntrst +\(for\)\n'
        saptf_head = '^ +\| +Xfrac +Yfrac +Zfrac +Dens +Dens/sigma +\| *\n'
        prf_head = '^ +theta +phi +chi +shx +shy +shz +Score +SAPTF *\n'
        prf_s_head = '^ +\| +theta +phi +chi +shx +shy +shz +Score +SAPTF *\| *\n'
        coord_conv = '^ --- convert "molrep.crd" to "molrep.pdb" ---\n'

        ed_maskline = RT.LogDataLine(mask_msg)

        saptf_titleline = RT.LogDataLine(saptf_title)
        saptf_startline = RT.LogDataLine(saptf_head)
        saptf_dataline = RT.LogDataLine(b + v + i + 5* r + v + e)
        saptf_finishline = RT.LogDataLine('^ \+-+\+\n')

        prf_startline = RT.LogDataLine(prf_head)
        prf_dataline = RT.LogDataLine(b + i + 7* r + i + e)
        prf_finishline = RT.LogDataLine('^ \+-+\+\n')

        prf_s_startline = RT.LogDataLine(prf_s_head)
        prf_s_dataline = RT.LogDataLine(b + v + i + 7* r + i + v + e)
        prf_s_finishline = RT.LogDataLine('^ \+-+\+\n')

        crf_startline = RT.LogDataLine(crf_head)
        crf_dataline = RT.LogDataLine(b + v + i + 4* r + v + e)
        crf_finishline = RT.LogDataLine('^ \+-+\+\n')

        tf_titleline = RT.LogDataLine(tf_title)
        tf_startline = RT.LogDataLine(tf_head)
        tf_dataline = RT.LogDataLine(b + 2* i + 8* r + x + e)
        tf_finishline = RT.LogDataLine('^ \+-+\+\n')

        success = RT.LogDataLine(coord_conv)


        self.parser = RT.LogDataParser()
        self.parser.add_next(ed_maskline, crf_startline, saptf_titleline)
        ed_maskline.add_next(crf_startline, saptf_titleline)

        saptf_titleline.add_next(saptf_startline)
        saptf_startline.add_next(saptf_dataline)
        saptf_dataline.add_next(saptf_dataline, saptf_finishline)
        saptf_finishline.add_next(prf_startline)

        prf_startline.add_next(prf_dataline)
        prf_dataline.add_next(prf_dataline, prf_finishline)
        prf_finishline.add_next(prf_s_startline)

        prf_s_startline.add_next(prf_s_dataline)
        prf_s_dataline.add_next(prf_s_dataline, prf_s_finishline)
        prf_s_finishline.add_next(tf_titleline)

        crf_startline.add_next(crf_dataline)
        crf_dataline.add_next(crf_dataline, crf_finishline)
        crf_finishline.add_next(tf_titleline)

        tf_titleline.add_next(tf_startline)
        tf_startline.add_next(tf_dataline)
        tf_dataline.add_next(tf_dataline, tf_finishline)
        tf_finishline.add_next(tf_startline, success)


        ed_maskline.add_action(self.ed_masked)

        saptf_titleline.add_action(self.saptf_init)
        saptf_startline.add_action(self.draw_graph, self.saptf_started)
        saptf_dataline.add_action(self.saptf_data)
        saptf_finishline.add_action(self.saptf_finished)

        prf_startline.add_action(self.prf_started)
        prf_dataline.add_action(self.prf_data)
        prf_finishline.add_action(self.prf_finished)

        prf_s_startline.add_action(self.prf_s_started)
        prf_s_dataline.add_action(self.prf_s_data)
        prf_s_finishline.add_action(self.prf_s_finished)

        crf_startline.add_action(self.draw_graph, self.crf_started)
        crf_dataline.add_action(self.crf_data)
        crf_finishline.add_action(self.crf_finished)

        tf_titleline.add_action(self.tf_init)
        tf_startline.add_action(self.tf_started)
        tf_dataline.add_action(self.tf_data)
        tf_finishline.add_action(self.tf_finished)

        success.add_action(self.job_succeeded)


        self.w = None
        self.show_progs = show_progs
        self.sect = rvapi_grid
        if show_progs:
            self.sect = API.pyrvapi_section(rvapi_grid, 'Molrep', 0, 0, 1, 1)

        self.np_max = 5
        self.show_tfz = True
        self.flag_masked = False

    def draw_graph(self, items):
        self.w = API.loggraph(self.sect, 0, 0, 1, 1)

    def parse_stream(self, istream, ostream=None, verbose=False, pause=0, patches=None):
        self.parser.parse_stream(istream, ostream, verbose, pause, patches)
        if self.show_progs:
            self.sect.set_state(False)

        self.flush()

    def ed_masked(self, items):
        self.ed_masked = True


    def saptf_init(self, items):
        self.flag_phased = items[0].startswith('Phased')
        self.show_tfz = False

    def saptf_started(self, items):
        f = API.graph_data(self.w, 'Spherically Averaged Phased TF')
        self.plot_saptf = MLP_plot_saptf(f, self.w, self.np_max)
        self.np_cou = 0

    def saptf_data(self, items):
        self.plot_saptf.add_data(items)
        self.flush()
        self.np_cou += 1

    def saptf_finished(self, items):
        self.np_max = max(self.np_max, self.np_cou)
        self.plot_saptf.finish(items, self.np_max)


    def prf_started(self, items):
        prefix = 'Phased' if self.flag_phased else 'Local'
        f = API.graph_data(self.w, prefix + ' Rotation Function')
        self.plot_prf = MLP_plot_prf(f, self.w, self.np_max)

    def prf_data(self, items):
        self.plot_prf.add_data(items)
        self.flush()

    def prf_finished(self, items):
        self.np_max = max(self.np_max, self.np_cou)


    def prf_s_started(self, items):
        prefix = 'Phased' if self.flag_phased else 'Local'
        f = API.graph_data(self.w, prefix + ' Rotation Function (Sorted)')
        self.plot_prf_s = MLP_plot_prf(f, self.w, self.np_max)

    def prf_s_data(self, items):
        self.plot_prf_s.add_data(items)
        self.flush()

    def prf_s_finished(self, items):
        self.plot_prf_s.finish(items, self.np_max)


    def crf_started(self, items):
        prefix = 'Modified ' if self.flag_masked else ''
        f = API.graph_data(self.w, prefix + 'Rotation Function')
        self.plot_rf = MLP_plot_rf(f, self.w, self.np_max)
        self.np_cou = 0

    def crf_data(self, items):
        self.plot_rf.add_data(items)
        self.flush()
        self.np_cou += 1

    def crf_finished(self, items):
        self.np_max = max(self.np_max, self.np_cou)
        self.plot_rf.finish(items, self.np_max)


    def tf_init(self, items):
        phased = items[0].startswith('phased')
        prefix = 'Phased ' if phased else ''
        f = API.graph_data(self.w, prefix + 'Translation Function')
        self.plot_tfc = MLP_plot_tfc(f, self.w, self.np_max)
        if self.show_tfz:
          self.plot_tfz = MLP_plot_tfz(f, self.w, self.np_max)

    def tf_started(self, items):
        self.plot_tfc.start(items)
        if self.show_tfz:
          self.plot_tfz.start(items)

    def tf_data(self, items):
        self.plot_tfc.add_data(items)
        if self.show_tfz:
          self.plot_tfz.add_data(items)

        self.flush()

    def tf_finished(self, items):
        API.reset_task()


    def job_succeeded(self, items):
        pass


class MLP_plot_rf(object):

    y_index = 4

    def __init__(self, f, w, np_max):
        self.x_index = 0

        self.p = API.graph_plot(w, **self.p_kwargs)
        self.p.set_xrange(0, np_max + 1)
        self.x = API.graph_dataset(f, **self.x_kwargs)
        self.y = API.graph_dataset(f, **self.y_kwargs)
        API.plot_line(self.p, f, self.x, self.y)

    def add_data(self, items):
        self.x.add_datum(int(items[self.x_index]))
        self.y.add_datum(float(items[self.y_index]))

    def finish(self, items, np_max):
        self.p.set_xrange(0, np_max + 1)

    p_kwargs = dict(
        pltTitle='RF based Z-score',
        xName='RF peak No',
        yName='RF/sigRF',
    )

    x_kwargs = dict(
        setName='RF peak No',
        setHeader='Rotation Function Peak Rank',
    )

    y_kwargs = dict(
        setName = 'RF/sigRF',
        setHeader = 'RF based Z-score',
        isint=False,
    )


class MLP_plot_prf(MLP_plot_rf):

    y_index = 7


class MLP_plot_saptf(MLP_plot_rf):

    y_index = 5

    p_kwargs = dict(
        pltTitle='SAPTF Z-score',
        xName='RF peak No',
        yName='SAPTF/sigSAPTF',
    )

    y_kwargs = dict(
        setName = 'Z(SAPTF)',
        setHeader = 'SAPTF based Z-score',
        isint=False,
    )


class MLP_plot_tf(object):

    def __init__(self, f, w, np_max):
        self.x_index = 0
        self.cou = 0
        self.f = f

        self.p = API.graph_plot(w, **self.p_kwargs)
        self.p.set_legend(API.pyrvapi.RVAPI_LEGEND_LOC_SE, API.pyrvapi.RVAPI_LEGEND_PLACE_Inside)
        self.p.set_xrange(0, np_max + 1)

    def start(self, items):
        self.cou += 1

        y_kwargs = dict(
            setName = self.y_fmt['name'] %self.cou,
            setHeader = self.y_fmt['header'] %self.cou,
            isint=False
        )

        self.x = API.graph_dataset(self.f, **self.x_kwargs)
        self.y = API.graph_dataset(self.f, **y_kwargs)
        API.plot_line(self.p, self.f, self.x, self.y)

    def add_data(self, items):
        self.x.add_datum(int(items[self.x_index]))
        self.y.add_datum(float(items[self.y_index]))

    x_kwargs = dict(
        setName='RF peak No',
        setHeader='Rotation Function Peak Rank',
    )


class MLP_plot_tfc(MLP_plot_tf):

    y_index = 8

    p_kwargs = dict(
        pltTitle='Correlation Coefficient',
        xName='RF peak No',
        yName='CC',
    )

    y_fmt = dict(
        name = 'TF CC for copy %d',
        header = 'TF Correlation Coefficient for copy %d',
    )


class MLP_plot_tfz(MLP_plot_tf):

    y_index = 2

    p_kwargs = dict(
        pltTitle='TF based Z-score',
        xName='RF peak No',
        yName='TF/sigTF',
    )

    y_fmt = dict(
        name = 'TF/sigTF for copy %d',
        header = 'TF based Z-score for copy %d',
    )

