//
//  =================================================================
//
//    16.12.17   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  rvapi_iframe  <interface>
//       ~~~~~~~~~
//  **** Project :  HTML5-based presentation system
//       ~~~~~~~~~
//  **** Classes :  rvapi::IFrame - API IFrame class
//       ~~~~~~~~~
//
//  (C) E. Krissinel 2013-2017
//
//  =================================================================
//

#ifndef RVAPI_IFRAME_H
#define RVAPI_IFRAME_H

#include "rvapi_node.h"

namespace rvapi  {

  class IFrame : public Node  {

    public:
      IFrame ( const char * nodeId,
               const char * sourceUri,
               const int    keepDWidth,  //!< if >0 then width else window offset
               const int    keepDHeight, //!< if >0 then height else window offset
               const int    hrow     = -1,
               const int    hcol     = 0,
               const int    hrowSpan = 1,
               const int    hcolSpan = 1
             );
      IFrame ();
      ~IFrame();

      virtual NODE_TYPE type() { return NTYPE_Text; }

      void setUri ( const char * newUri );

      virtual void write ( std::ofstream & s );
      virtual void read  ( std::ifstream & s );

      virtual void flush_html ( std::string & outDir,
                                std::string & task );

  protected:
    std::string uri;          //!< to load in iframe
    int         keep_dwidth;  //!< if >0 then width else window offset
    int         keep_dheight; //!< if >0 then height else window offset

    void initIFrame();
    void freeIFrame();

  };

}

#endif // RVAPI_IFRAME_H
