import numpy as np

def make_soft_edged_window(wn_shape,edge=5):
    z,y,x = wn_shape
#     z,y,x = (8,8,8)
#     edge = 2
    radius = int(round(max(z,y,x) / 2.0))
    rad_z = np.arange(np.floor(z/2.0)*-1, 
                      np.ceil(z/2.0))
    rad_y = np.arange(np.floor(y/2.0)*-1, 
                      np.ceil(y/2.0))
    rad_x = np.arange(np.floor(x/2.0)*-1, 
                      np.ceil(x/2.0))
    rad_x = rad_x**2
    rad_y = rad_y**2
    rad_z = rad_z**2
    dist = np.sqrt(rad_z[:,None,None]+rad_y[:,None] + rad_x)
    #for tanh smoothing get values from center as >=2 to -1 at fixed_radius
    fixed_radius = radius - edge
    fixed_radius = max(3,fixed_radius)
    dist = fixed_radius-dist
    dist[:] = (np.tanh(dist)+1)/2.
    dist[dist<0.] = 0.
    dist[dist>1.] = 1.
    return dist

def compare_tuple(tuple1,tuple2):
    for val1, val2 in zip(tuple1, tuple2):
        if type(val2) is float:
            if round(val1,2) != round(val2,2):
                return False
        else:
            if val1 != val2:
                return False
    return True
    
