#
#     Copyright (C) 2019 CCP-EM
#
#     This code is distributed under the terms and conditions of the
#     CCP-EM Program Suite Licence Agreement as a CCP-EM Application.
#     A copy of the CCP-EM licence can be obtained by writing to the
#     CCP-EM Secretary, RAL Laboratory, Harwell, OX11 0FA, UK.

import unittest
import os
import shutil
import tempfile
import json
import gemmi
from ccpem_core import test_data
import gemmi_utils


class Test(unittest.TestCase):
    '''
    Unit test for gemmi utils
    '''
    def setUp(self):
        self.test_data = test_data.get_test_data_path()
        self.test_output = tempfile.mkdtemp()

    def tearDown(self):
        shutil.rmtree(self.test_output)

    def test_convert_pdb_to_mmcif(self):
        # Test to convert pdb to mmcif
        print 'Test pdb to mmcif conversion'
        pdb_path = os.path.join(
            self.test_data,
            'pdb/5me2.pdb')
        print pdb_path
        mmcif_path = gemmi_utils.convert_pdb_to_mmcif(
            pdb_path=pdb_path,
            mmcif_path=None)
        print mmcif_path
        assert os.path.exists(mmcif_path)
        cif_block = gemmi.cif.read(mmcif_path)[0]
        os.remove(mmcif_path)
        assert not os.path.exists(mmcif_path)

if __name__ == '__main__':
    unittest.main()

