#
#     Copyright (C) 2015 CCP-EM
#
#     This code is distributed under the terms and conditions of the
#     CCP-EM Program Suite Licence Agreement as a CCP-EM Application.
#     A copy of the CCP-EM licence can be obtained by writing to the
#     CCP-EM Secretary, RAL Laboratory, Harwell, OX11 0FA, UK.
#

import unittest
import time
from ccpem_gui.tasks import ccpem_tasks
from ccpem_core.tasks.molrep import molrep_task
try:
    import modeller
    modeller_available = True
except ImportError:
    modeller_available = False


class Test(unittest.TestCase):
    '''
    Unit test for ccpem tasks.
    '''
    
    def test_tasks(self):
        # Get task and assert returns correct class
        time_s = time.time()
        tasks = ccpem_tasks.CCPEMTasks()

        # Test task initialisation
        time_t = time.time() - time_s
        self.assertLess(time_t,
            5.0,
            'CCP-EM tasks initialisation too slow, check imports')
        task = tasks.get_task_class(program='Molrep')()
        assert isinstance(task, molrep_task.MolRep)

    @unittest.skipIf(not modeller_available,
                     'Modeller not found: skipping test tasks for errors')
    def test_task_errors(self):
        # Check no errors in task loading
        tasks = ccpem_tasks.CCPEMTasks()
        if tasks.errors:
            raise AssertionError(tasks.errors)


if __name__ == '__main__':
    unittest.main()
