#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Dec 12 16:18:00 2017 by generateDS.py version 2.29.3.
# Python 2.7.12 (default, Oct 14 2016, 10:32:21)  [GCC 4.2.1 Compatible Apple LLVM 5.1 (clang-503.0.40)]
#
# Command line options:
#   ('-o', 'empiar.py')
#   ('-s', 'empiarsub_f.py')
#   ('--external-encoding', 'utf-8')
#
# Command line arguments:
#   empiar.xsd
#
# Command line:
#   /usr/local/bin/generateDS.py -o "empiar.py" -s "empiarsub_f.py" --external-encoding="utf-8" empiar.xsd
#
# Current working directory (os.getcwd()):
#   XML schema
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__
        def __ne__(self, other):
            return not self.__eq__(other)
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class entryType(GeneratedsSuper):
    """Accesion code in the format: EMPIAR-####XML schema version that
    validates the entryVersions: 0.4; 20140729; Ardan Patwardhan;
    Added dataset size 0.5; 20140729; Ardan Patwardhan; Added DM4 as
    a map/header format 0.6; 20140908; Ardan Patwardhan; Added TIFF
    as a map/header format 0.7; 20140909; Ardan Patwardhan; Added
    IMAGIC as map/header format 0.8; 20140916; Ardan Patwardhan;
    Changed images to imageSet. Allow "variable" image size if the
    dataset does not have a fixed image size. 0.9; 20141030; Andrii
    Iudin/Ardan Patwardhan; General clean up. Added directory to
    imageSet. 0.10; 20141204; Andrii Iudin; Added ORCID for authors
    and DOI for EMPIAR entries 0.11; 20151026; Paul Korir; Modified
    principleInvestigator to allow multiple entries 0.12; 20151026;
    Paul Korir; Added publications element; replicated verbatim from
    emdb.xsd 0.13; 20151026; Paul Korir; Added 'type' element to
    'imageSet' currently restricted to strings '3VIEW', 'INSILICO',
    and 'EMDB' 0.14; 20151028; Paul Korir; Added to 'type' 'SXT' and
    'FIB-SEM' 0.15; 20151113; Paul Korir; Copied 'citation_list'
    from 'DA_schema/emdb_da.xsd'; modified names and types to
    camelCase Added 'citationList' to 'crossReferences'. Renamed
    'primary_citation' in 'citationList' to 'citation' with
    cardinality 0..Inf. Deleted 'secondary_citation' from under
    'citationList'. Moved 'type' from 'imageSet' to 'admin' and
    renamed as 'experimentType'. 0.16; 20151201; Andrii Iudin; Added
    OBSOLETE status code type, key dates of an entry being made
    obsolete and of the last update of an entry 0.17; 20160415;
    Andrii Iudin; Added ORCID to contact details type, documented
    the citations list. 0.18; 20160704; Andrii Iudin; Renamed
    citation to universalCitation due to the clash with the
    citationType. 0.19; 20160922; Andrii Iudin; Made the journal
    citation's country non-mandatory. 0.20; 20161011; Andrii Iudin;
    Simplified the phone/fax field to be just a single token and
    removed the restrictions from the middle name since we already
    have accepted cases when the full middle name has been provided.
    0.21; 20161107; Andrii Iudin; Made all citation fields (except
    the title) non-mandatory. This is done to allow releasing
    entries with no citation available at the moment of the release
    0.22; 20170208; Andrii Iudin; Issue number of citations is now a
    string to correspond with the format of possible results. 0.23;
    20170302; Andrii Iudin; Replaced "MRC (FEI)" header and data
    formats with "MRCS" 0.24; 20170508; Andrii Iudin; Added IHM
    experiment type and raw images class averages image set type
    0.25; 20170601; Andrii Iudin; Journal abbreviation regex updated
    to correspond to Europe PMC ISO abbreviation 0.26; 20170601;
    Andrii Iudin; Added SBF-SEM to the enumeration of the experiment
    type. 0.27; 20171205; Andrii Iudin; Made the page regex more
    inclusive, as we have a deposition with page set to '1630.e3'"""
    subclass = None
    superclass = None
    def __init__(self, accessionCode=None, schemaVersion=None, admin=None, crossReferences=None, imageSet=None):
        self.original_tagname_ = None
        self.accessionCode = _cast(None, accessionCode)
        self.schemaVersion = _cast(None, schemaVersion)
        self.admin = admin
        self.crossReferences = crossReferences
        if imageSet is None:
            self.imageSet = []
        else:
            self.imageSet = imageSet
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, entryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if entryType.subclass:
            return entryType.subclass(*args_, **kwargs_)
        else:
            return entryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_admin(self): return self.admin
    def set_admin(self, admin): self.admin = admin
    def get_crossReferences(self): return self.crossReferences
    def set_crossReferences(self, crossReferences): self.crossReferences = crossReferences
    def get_imageSet(self): return self.imageSet
    def set_imageSet(self, imageSet): self.imageSet = imageSet
    def add_imageSet(self, value): self.imageSet.append(value)
    def insert_imageSet_at(self, index, value): self.imageSet.insert(index, value)
    def replace_imageSet_at(self, index, value): self.imageSet[index] = value
    def get_accessionCode(self): return self.accessionCode
    def set_accessionCode(self, accessionCode): self.accessionCode = accessionCode
    def get_schemaVersion(self): return self.schemaVersion
    def set_schemaVersion(self, schemaVersion): self.schemaVersion = schemaVersion
    def hasContent_(self):
        if (
            self.admin is not None or
            self.crossReferences is not None or
            self.imageSet
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='entryType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('entryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='entryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='entryType'):
        if self.accessionCode is not None and 'accessionCode' not in already_processed:
            already_processed.add('accessionCode')
            outfile.write(' accessionCode=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.accessionCode), input_name='accessionCode')), ))
        if self.schemaVersion is not None and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            outfile.write(' schemaVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.schemaVersion), input_name='schemaVersion')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='entryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.admin is not None:
            self.admin.export(outfile, level, namespace_, name_='admin', pretty_print=pretty_print)
        if self.crossReferences is not None:
            self.crossReferences.export(outfile, level, namespace_, name_='crossReferences', pretty_print=pretty_print)
        for imageSet_ in self.imageSet:
            imageSet_.export(outfile, level, namespace_, name_='imageSet', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('accessionCode', node)
        if value is not None and 'accessionCode' not in already_processed:
            already_processed.add('accessionCode')
            self.accessionCode = value
        value = find_attr_value_('schemaVersion', node)
        if value is not None and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            self.schemaVersion = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'admin':
            obj_ = adminType.factory()
            obj_.build(child_)
            self.admin = obj_
            obj_.original_tagname_ = 'admin'
        elif nodeName_ == 'crossReferences':
            obj_ = crossReferencesType.factory()
            obj_.build(child_)
            self.crossReferences = obj_
            obj_.original_tagname_ = 'crossReferences'
        elif nodeName_ == 'imageSet':
            obj_ = imageSetType.factory()
            obj_.build(child_)
            self.imageSet.append(obj_)
            obj_.original_tagname_ = 'imageSet'
# end class entryType


class adminType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, currentStatus=None, keyDates=None, title=None, correspondingAuthor=None, principalInvestigator=None, authorsList=None, versionHistory=None, grantSupport=None, datasetSize=None, entryDOI=None, experimentType=None):
        self.original_tagname_ = None
        self.currentStatus = currentStatus
        self.validate_statusCodeType(self.currentStatus)
        self.keyDates = keyDates
        self.title = title
        self.correspondingAuthor = correspondingAuthor
        if principalInvestigator is None:
            self.principalInvestigator = []
        else:
            self.principalInvestigator = principalInvestigator
        self.authorsList = authorsList
        self.versionHistory = versionHistory
        self.grantSupport = grantSupport
        self.datasetSize = datasetSize
        self.entryDOI = entryDOI
        self.validate_entryDOIType(self.entryDOI)
        self.experimentType = experimentType
        self.validate_experimentTypeType(self.experimentType)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, adminType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if adminType.subclass:
            return adminType.subclass(*args_, **kwargs_)
        else:
            return adminType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_currentStatus(self): return self.currentStatus
    def set_currentStatus(self, currentStatus): self.currentStatus = currentStatus
    def get_keyDates(self): return self.keyDates
    def set_keyDates(self, keyDates): self.keyDates = keyDates
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_correspondingAuthor(self): return self.correspondingAuthor
    def set_correspondingAuthor(self, correspondingAuthor): self.correspondingAuthor = correspondingAuthor
    def get_principalInvestigator(self): return self.principalInvestigator
    def set_principalInvestigator(self, principalInvestigator): self.principalInvestigator = principalInvestigator
    def add_principalInvestigator(self, value): self.principalInvestigator.append(value)
    def insert_principalInvestigator_at(self, index, value): self.principalInvestigator.insert(index, value)
    def replace_principalInvestigator_at(self, index, value): self.principalInvestigator[index] = value
    def get_authorsList(self): return self.authorsList
    def set_authorsList(self, authorsList): self.authorsList = authorsList
    def get_versionHistory(self): return self.versionHistory
    def set_versionHistory(self, versionHistory): self.versionHistory = versionHistory
    def get_grantSupport(self): return self.grantSupport
    def set_grantSupport(self, grantSupport): self.grantSupport = grantSupport
    def get_datasetSize(self): return self.datasetSize
    def set_datasetSize(self, datasetSize): self.datasetSize = datasetSize
    def get_entryDOI(self): return self.entryDOI
    def set_entryDOI(self, entryDOI): self.entryDOI = entryDOI
    def get_experimentType(self): return self.experimentType
    def set_experimentType(self, experimentType): self.experimentType = experimentType
    def validate_statusCodeType(self, value):
        # Validate type statusCodeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PROC', 'REL', 'OBSOLETE']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on statusCodeType' % {"value" : value.encode("utf-8")} )
    def validate_entryDOIType(self, value):
        # Validate type entryDOIType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_entryDOIType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_entryDOIType_patterns_, ))
    validate_entryDOIType_patterns_ = [['^10.6019/EMPIAR-\\d{5}$']]
    def validate_experimentTypeType(self, value):
        # Validate type experimentTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['3VIEW', 'INSILICO', 'EMDB', 'SXT', 'FIB-SEM', 'IHM', 'SBF-SEM']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on experimentTypeType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.currentStatus is not None or
            self.keyDates is not None or
            self.title is not None or
            self.correspondingAuthor is not None or
            self.principalInvestigator or
            self.authorsList is not None or
            self.versionHistory is not None or
            self.grantSupport is not None or
            self.datasetSize is not None or
            self.entryDOI is not None or
            self.experimentType is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='adminType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('adminType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='adminType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='adminType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='adminType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='adminType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.currentStatus is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<currentStatus>%s</currentStatus>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.currentStatus), input_name='currentStatus')), eol_))
        if self.keyDates is not None:
            self.keyDates.export(outfile, level, namespace_, name_='keyDates', pretty_print=pretty_print)
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.correspondingAuthor is not None:
            self.correspondingAuthor.export(outfile, level, namespace_, name_='correspondingAuthor', pretty_print=pretty_print)
        for principalInvestigator_ in self.principalInvestigator:
            principalInvestigator_.export(outfile, level, namespace_, name_='principalInvestigator', pretty_print=pretty_print)
        if self.authorsList is not None:
            self.authorsList.export(outfile, level, namespace_, name_='authorsList', pretty_print=pretty_print)
        if self.versionHistory is not None:
            self.versionHistory.export(outfile, level, namespace_, name_='versionHistory', pretty_print=pretty_print)
        if self.grantSupport is not None:
            self.grantSupport.export(outfile, level, namespace_, name_='grantSupport', pretty_print=pretty_print)
        if self.datasetSize is not None:
            self.datasetSize.export(outfile, level, namespace_, name_='datasetSize', pretty_print=pretty_print)
        if self.entryDOI is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<entryDOI>%s</entryDOI>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.entryDOI), input_name='entryDOI')), eol_))
        if self.experimentType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<experimentType>%s</experimentType>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.experimentType), input_name='experimentType')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'currentStatus':
            currentStatus_ = child_.text
            currentStatus_ = self.gds_validate_string(currentStatus_, node, 'currentStatus')
            self.currentStatus = currentStatus_
            # validate type statusCodeType
            self.validate_statusCodeType(self.currentStatus)
        elif nodeName_ == 'keyDates':
            obj_ = keyDatesType.factory()
            obj_.build(child_)
            self.keyDates = obj_
            obj_.original_tagname_ = 'keyDates'
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'correspondingAuthor':
            obj_ = correspondingAuthorType.factory()
            obj_.build(child_)
            self.correspondingAuthor = obj_
            obj_.original_tagname_ = 'correspondingAuthor'
        elif nodeName_ == 'principalInvestigator':
            obj_ = principalInvestigatorType.factory()
            obj_.build(child_)
            self.principalInvestigator.append(obj_)
            obj_.original_tagname_ = 'principalInvestigator'
        elif nodeName_ == 'authorsList':
            obj_ = authorsListType.factory()
            obj_.build(child_)
            self.authorsList = obj_
            obj_.original_tagname_ = 'authorsList'
        elif nodeName_ == 'versionHistory':
            obj_ = versionHistoryType.factory()
            obj_.build(child_)
            self.versionHistory = obj_
            obj_.original_tagname_ = 'versionHistory'
        elif nodeName_ == 'grantSupport':
            obj_ = grantSupportType.factory()
            obj_.build(child_)
            self.grantSupport = obj_
            obj_.original_tagname_ = 'grantSupport'
        elif nodeName_ == 'datasetSize':
            obj_ = datasetSizeType.factory()
            obj_.build(child_)
            self.datasetSize = obj_
            obj_.original_tagname_ = 'datasetSize'
        elif nodeName_ == 'entryDOI':
            entryDOI_ = child_.text
            if entryDOI_:
                entryDOI_ = re_.sub(String_cleanup_pat_, " ", entryDOI_).strip()
            else:
                entryDOI_ = ""
            entryDOI_ = self.gds_validate_string(entryDOI_, node, 'entryDOI')
            self.entryDOI = entryDOI_
            # validate type entryDOIType
            self.validate_entryDOIType(self.entryDOI)
        elif nodeName_ == 'experimentType':
            experimentType_ = child_.text
            experimentType_ = self.gds_validate_string(experimentType_, node, 'experimentType')
            self.experimentType = experimentType_
            # validate type experimentTypeType
            self.validate_experimentTypeType(self.experimentType)
# end class adminType


class crossReferencesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, relatedEMDBEntries=None, citationList=None):
        self.original_tagname_ = None
        self.relatedEMDBEntries = relatedEMDBEntries
        self.citationList = citationList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, crossReferencesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if crossReferencesType.subclass:
            return crossReferencesType.subclass(*args_, **kwargs_)
        else:
            return crossReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_relatedEMDBEntries(self): return self.relatedEMDBEntries
    def set_relatedEMDBEntries(self, relatedEMDBEntries): self.relatedEMDBEntries = relatedEMDBEntries
    def get_citationList(self): return self.citationList
    def set_citationList(self, citationList): self.citationList = citationList
    def hasContent_(self):
        if (
            self.relatedEMDBEntries is not None or
            self.citationList is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='crossReferencesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('crossReferencesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='crossReferencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='crossReferencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='crossReferencesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='crossReferencesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.relatedEMDBEntries is not None:
            self.relatedEMDBEntries.export(outfile, level, namespace_, name_='relatedEMDBEntries', pretty_print=pretty_print)
        if self.citationList is not None:
            self.citationList.export(outfile, level, namespace_, name_='citationList', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'relatedEMDBEntries':
            obj_ = relatedEMDBEntriesType.factory()
            obj_.build(child_)
            self.relatedEMDBEntries = obj_
            obj_.original_tagname_ = 'relatedEMDBEntries'
        elif nodeName_ == 'citationList':
            obj_ = citationListType.factory()
            obj_.build(child_)
            self.citationList = obj_
            obj_.original_tagname_ = 'citationList'
# end class crossReferencesType


class relatedEMDBEntriesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, emdbEntry=None):
        self.original_tagname_ = None
        if emdbEntry is None:
            self.emdbEntry = []
        else:
            self.emdbEntry = emdbEntry
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, relatedEMDBEntriesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if relatedEMDBEntriesType.subclass:
            return relatedEMDBEntriesType.subclass(*args_, **kwargs_)
        else:
            return relatedEMDBEntriesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_emdbEntry(self): return self.emdbEntry
    def set_emdbEntry(self, emdbEntry): self.emdbEntry = emdbEntry
    def add_emdbEntry(self, value): self.emdbEntry.append(value)
    def insert_emdbEntry_at(self, index, value): self.emdbEntry.insert(index, value)
    def replace_emdbEntry_at(self, index, value): self.emdbEntry[index] = value
    def validate_emdbCodeType(self, value):
        # Validate type emdbCodeType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emdbCodeType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emdbCodeType_patterns_, ))
    validate_emdbCodeType_patterns_ = [['^EMD-\\d{4,}$']]
    def hasContent_(self):
        if (
            self.emdbEntry
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='relatedEMDBEntriesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('relatedEMDBEntriesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relatedEMDBEntriesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='relatedEMDBEntriesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='relatedEMDBEntriesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='relatedEMDBEntriesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for emdbEntry_ in self.emdbEntry:
            showIndent(outfile, level, pretty_print)
            outfile.write('<emdbEntry>%s</emdbEntry>%s' % (self.gds_encode(self.gds_format_string(quote_xml(emdbEntry_), input_name='emdbEntry')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'emdbEntry':
            emdbEntry_ = child_.text
            if emdbEntry_:
                emdbEntry_ = re_.sub(String_cleanup_pat_, " ", emdbEntry_).strip()
            else:
                emdbEntry_ = ""
            emdbEntry_ = self.gds_validate_string(emdbEntry_, node, 'emdbEntry')
            self.emdbEntry.append(emdbEntry_)
            # validate type emdbCodeType
            self.validate_emdbCodeType(self.emdbEntry[-1])
# end class relatedEMDBEntriesType


class grantReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, fundingBody=None, code=None, country=None):
        self.original_tagname_ = None
        self.fundingBody = fundingBody
        self.code = code
        self.country = country
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grantReferenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grantReferenceType.subclass:
            return grantReferenceType.subclass(*args_, **kwargs_)
        else:
            return grantReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fundingBody(self): return self.fundingBody
    def set_fundingBody(self, fundingBody): self.fundingBody = fundingBody
    def get_code(self): return self.code
    def set_code(self, code): self.code = code
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def hasContent_(self):
        if (
            self.fundingBody is not None or
            self.code is not None or
            self.country is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='grantReferenceType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grantReferenceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='grantReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='grantReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='grantReferenceType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='grantReferenceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fundingBody is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<fundingBody>%s</fundingBody>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.fundingBody), input_name='fundingBody')), eol_))
        if self.code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<code>%s</code>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.code), input_name='code')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fundingBody':
            fundingBody_ = child_.text
            if fundingBody_:
                fundingBody_ = re_.sub(String_cleanup_pat_, " ", fundingBody_).strip()
            else:
                fundingBody_ = ""
            fundingBody_ = self.gds_validate_string(fundingBody_, node, 'fundingBody')
            self.fundingBody = fundingBody_
        elif nodeName_ == 'code':
            code_ = child_.text
            if code_:
                code_ = re_.sub(String_cleanup_pat_, " ", code_).strip()
            else:
                code_ = ""
            code_ = self.gds_validate_string(code_, node, 'code')
            self.code = code_
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
# end class grantReferenceType


class versionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, versionNumber=None, date=None, statusCode=None, annotator=None, details=None):
        self.original_tagname_ = None
        self.versionNumber = versionNumber
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.statusCode = statusCode
        self.validate_statusCodeType(self.statusCode)
        self.annotator = annotator
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, versionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if versionType.subclass:
            return versionType.subclass(*args_, **kwargs_)
        else:
            return versionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_versionNumber(self): return self.versionNumber
    def set_versionNumber(self, versionNumber): self.versionNumber = versionNumber
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_statusCode(self): return self.statusCode
    def set_statusCode(self, statusCode): self.statusCode = statusCode
    def get_annotator(self): return self.annotator
    def set_annotator(self, annotator): self.annotator = annotator
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_dateType(self, value):
        # Validate type dateType, a restriction on xs:date.
        if value is not None and Validate_simpletypes_:
            if value < self.gds_parse_date('2002-01-01'):
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on dateType' % {"value" : value} )
    def validate_statusCodeType(self, value):
        # Validate type statusCodeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['PROC', 'REL', 'OBSOLETE']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on statusCodeType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.versionNumber is not None or
            self.date is not None or
            self.statusCode is not None or
            self.annotator is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='versionType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('versionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='versionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='versionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='versionType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='versionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.versionNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<versionNumber>%s</versionNumber>%s' % (self.gds_format_integer(self.versionNumber, input_name='versionNumber'), eol_))
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<date>%s</date>%s' % (self.gds_format_date(self.date, input_name='date'), eol_))
        if self.statusCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<statusCode>%s</statusCode>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.statusCode), input_name='statusCode')), eol_))
        if self.annotator is not None:
            self.annotator.export(outfile, level, namespace_, name_='annotator', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'versionNumber':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'versionNumber')
            self.versionNumber = ival_
        elif nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.date = dval_
            # validate type dateType
            self.validate_dateType(self.date)
        elif nodeName_ == 'statusCode':
            statusCode_ = child_.text
            statusCode_ = self.gds_validate_string(statusCode_, node, 'statusCode')
            self.statusCode = statusCode_
            # validate type statusCodeType
            self.validate_statusCodeType(self.statusCode)
        elif nodeName_ == 'annotator':
            obj_ = annotatorType.factory()
            obj_.build(child_)
            self.annotator = obj_
            obj_.original_tagname_ = 'annotator'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class versionType


class contactDetailsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, authorORCID=None, title=None, firstName=None, middleName=None, lastName=None, organization=None, street=None, townOrCity=None, stateOrProvince=None, country=None, postOrZipCode=None, email=None, telephone=None, fax=None, extensiontype_=None):
        self.original_tagname_ = None
        self.authorORCID = authorORCID
        self.validate_authorORCIDType(self.authorORCID)
        self.title = title
        self.validate_titleType(self.title)
        self.firstName = firstName
        self.middleName = middleName
        self.lastName = lastName
        self.organization = organization
        self.street = street
        self.townOrCity = townOrCity
        self.stateOrProvince = stateOrProvince
        self.country = country
        self.postOrZipCode = postOrZipCode
        self.email = email
        self.validate_emailType(self.email)
        self.telephone = telephone
        self.fax = fax
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contactDetailsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contactDetailsType.subclass:
            return contactDetailsType.subclass(*args_, **kwargs_)
        else:
            return contactDetailsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authorORCID(self): return self.authorORCID
    def set_authorORCID(self, authorORCID): self.authorORCID = authorORCID
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_firstName(self): return self.firstName
    def set_firstName(self, firstName): self.firstName = firstName
    def get_middleName(self): return self.middleName
    def set_middleName(self, middleName): self.middleName = middleName
    def get_lastName(self): return self.lastName
    def set_lastName(self, lastName): self.lastName = lastName
    def get_organization(self): return self.organization
    def set_organization(self, organization): self.organization = organization
    def get_street(self): return self.street
    def set_street(self, street): self.street = street
    def get_townOrCity(self): return self.townOrCity
    def set_townOrCity(self, townOrCity): self.townOrCity = townOrCity
    def get_stateOrProvince(self): return self.stateOrProvince
    def set_stateOrProvince(self, stateOrProvince): self.stateOrProvince = stateOrProvince
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_postOrZipCode(self): return self.postOrZipCode
    def set_postOrZipCode(self, postOrZipCode): self.postOrZipCode = postOrZipCode
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_telephone(self): return self.telephone
    def set_telephone(self, telephone): self.telephone = telephone
    def get_fax(self): return self.fax
    def set_fax(self, fax): self.fax = fax
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_authorORCIDType(self, value):
        # Validate type authorORCIDType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_authorORCIDType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_authorORCIDType_patterns_, ))
    validate_authorORCIDType_patterns_ = [['^(\\d{4}-){3}\\d{3}(\\d$|^X)$']]
    def validate_titleType(self, value):
        # Validate type titleType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Prof.', 'Dr.']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on titleType' % {"value" : value.encode("utf-8")} )
    def validate_emailType(self, value):
        # Validate type emailType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_emailType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_emailType_patterns_, ))
    validate_emailType_patterns_ = [['^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}$']]
    def hasContent_(self):
        if (
            self.authorORCID is not None or
            self.title is not None or
            self.firstName is not None or
            self.middleName is not None or
            self.lastName is not None or
            self.organization is not None or
            self.street is not None or
            self.townOrCity is not None or
            self.stateOrProvince is not None or
            self.country is not None or
            self.postOrZipCode is not None or
            self.email is not None or
            self.telephone is not None or
            self.fax is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contactDetailsType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('contactDetailsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contactDetailsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contactDetailsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contactDetailsType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='contactDetailsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.authorORCID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<authorORCID>%s</authorORCID>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.authorORCID), input_name='authorORCID')), eol_))
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.firstName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstName>%s</firstName>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstName), input_name='firstName')), eol_))
        if self.middleName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<middleName>%s</middleName>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.middleName), input_name='middleName')), eol_))
        if self.lastName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastName>%s</lastName>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastName), input_name='lastName')), eol_))
        if self.organization is not None:
            self.organization.export(outfile, level, namespace_, name_='organization', pretty_print=pretty_print)
        if self.street is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<street>%s</street>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.street), input_name='street')), eol_))
        if self.townOrCity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<townOrCity>%s</townOrCity>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.townOrCity), input_name='townOrCity')), eol_))
        if self.stateOrProvince is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<stateOrProvince>%s</stateOrProvince>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.stateOrProvince), input_name='stateOrProvince')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
        if self.postOrZipCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<postOrZipCode>%s</postOrZipCode>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.postOrZipCode), input_name='postOrZipCode')), eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<email>%s</email>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), eol_))
        if self.telephone is not None:
            self.telephone.export(outfile, level, namespace_, name_='telephone', pretty_print=pretty_print)
        if self.fax is not None:
            self.fax.export(outfile, level, namespace_, name_='fax', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authorORCID':
            authorORCID_ = child_.text
            if authorORCID_:
                authorORCID_ = re_.sub(String_cleanup_pat_, " ", authorORCID_).strip()
            else:
                authorORCID_ = ""
            authorORCID_ = self.gds_validate_string(authorORCID_, node, 'authorORCID')
            self.authorORCID = authorORCID_
            # validate type authorORCIDType
            self.validate_authorORCIDType(self.authorORCID)
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
            # validate type titleType
            self.validate_titleType(self.title)
        elif nodeName_ == 'firstName':
            firstName_ = child_.text
            if firstName_:
                firstName_ = re_.sub(String_cleanup_pat_, " ", firstName_).strip()
            else:
                firstName_ = ""
            firstName_ = self.gds_validate_string(firstName_, node, 'firstName')
            self.firstName = firstName_
        elif nodeName_ == 'middleName':
            middleName_ = child_.text
            if middleName_:
                middleName_ = re_.sub(String_cleanup_pat_, " ", middleName_).strip()
            else:
                middleName_ = ""
            middleName_ = self.gds_validate_string(middleName_, node, 'middleName')
            self.middleName = middleName_
        elif nodeName_ == 'lastName':
            lastName_ = child_.text
            if lastName_:
                lastName_ = re_.sub(String_cleanup_pat_, " ", lastName_).strip()
            else:
                lastName_ = ""
            lastName_ = self.gds_validate_string(lastName_, node, 'lastName')
            self.lastName = lastName_
        elif nodeName_ == 'organization':
            obj_ = organizationType.factory()
            obj_.build(child_)
            self.organization = obj_
            obj_.original_tagname_ = 'organization'
        elif nodeName_ == 'street':
            street_ = child_.text
            street_ = self.gds_validate_string(street_, node, 'street')
            self.street = street_
        elif nodeName_ == 'townOrCity':
            townOrCity_ = child_.text
            if townOrCity_:
                townOrCity_ = re_.sub(String_cleanup_pat_, " ", townOrCity_).strip()
            else:
                townOrCity_ = ""
            townOrCity_ = self.gds_validate_string(townOrCity_, node, 'townOrCity')
            self.townOrCity = townOrCity_
        elif nodeName_ == 'stateOrProvince':
            stateOrProvince_ = child_.text
            if stateOrProvince_:
                stateOrProvince_ = re_.sub(String_cleanup_pat_, " ", stateOrProvince_).strip()
            else:
                stateOrProvince_ = ""
            stateOrProvince_ = self.gds_validate_string(stateOrProvince_, node, 'stateOrProvince')
            self.stateOrProvince = stateOrProvince_
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'postOrZipCode':
            postOrZipCode_ = child_.text
            if postOrZipCode_:
                postOrZipCode_ = re_.sub(String_cleanup_pat_, " ", postOrZipCode_).strip()
            else:
                postOrZipCode_ = ""
            postOrZipCode_ = self.gds_validate_string(postOrZipCode_, node, 'postOrZipCode')
            self.postOrZipCode = postOrZipCode_
        elif nodeName_ == 'email':
            email_ = child_.text
            if email_:
                email_ = re_.sub(String_cleanup_pat_, " ", email_).strip()
            else:
                email_ = ""
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
            # validate type emailType
            self.validate_emailType(self.email)
        elif nodeName_ == 'telephone':
            obj_ = telephoneNumberType.factory()
            obj_.build(child_)
            self.telephone = obj_
            obj_.original_tagname_ = 'telephone'
        elif nodeName_ == 'fax':
            obj_ = telephoneNumberType.factory()
            obj_.build(child_)
            self.fax = obj_
            obj_.original_tagname_ = 'fax'
# end class contactDetailsType


class telephoneNumberType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, local=None):
        self.original_tagname_ = None
        self.local = local
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, telephoneNumberType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if telephoneNumberType.subclass:
            return telephoneNumberType.subclass(*args_, **kwargs_)
        else:
            return telephoneNumberType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_local(self): return self.local
    def set_local(self, local): self.local = local
    def hasContent_(self):
        if (
            self.local is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='telephoneNumberType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('telephoneNumberType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='telephoneNumberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='telephoneNumberType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='telephoneNumberType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='telephoneNumberType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.local is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<local>%s</local>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.local), input_name='local')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'local':
            local_ = child_.text
            if local_:
                local_ = re_.sub(String_cleanup_pat_, " ", local_).strip()
            else:
                local_ = ""
            local_ = self.gds_validate_string(local_, node, 'local')
            self.local = local_
# end class telephoneNumberType


class dimensionsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, imageWidth=None, pixelWidth=None, imageHeight=None, pixelHeight=None):
        self.original_tagname_ = None
        self.imageWidth = imageWidth
        self.validate_imageWidthType(self.imageWidth)
        self.pixelWidth = pixelWidth
        self.imageHeight = imageHeight
        self.validate_imageHeightType(self.imageHeight)
        self.pixelHeight = pixelHeight
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, dimensionsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dimensionsType.subclass:
            return dimensionsType.subclass(*args_, **kwargs_)
        else:
            return dimensionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_imageWidth(self): return self.imageWidth
    def set_imageWidth(self, imageWidth): self.imageWidth = imageWidth
    def get_pixelWidth(self): return self.pixelWidth
    def set_pixelWidth(self, pixelWidth): self.pixelWidth = pixelWidth
    def get_imageHeight(self): return self.imageHeight
    def set_imageHeight(self, imageHeight): self.imageHeight = imageHeight
    def get_pixelHeight(self): return self.pixelHeight
    def set_pixelHeight(self, pixelHeight): self.pixelHeight = pixelHeight
    def validate_imageWidthType(self, value):
        # Validate type imageWidthType, a restriction on xs:string.
        pass
    def validate_imageHeightType(self, value):
        # Validate type imageHeightType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.imageWidth is not None or
            self.pixelWidth is not None or
            self.imageHeight is not None or
            self.pixelHeight is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='dimensionsType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('dimensionsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='dimensionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='dimensionsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='dimensionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='dimensionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.imageWidth is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<imageWidth>%s</imageWidth>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.imageWidth), input_name='imageWidth')), eol_))
        if self.pixelWidth is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<pixelWidth>%s</pixelWidth>%s' % (self.gds_format_float(self.pixelWidth, input_name='pixelWidth'), eol_))
        if self.imageHeight is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<imageHeight>%s</imageHeight>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.imageHeight), input_name='imageHeight')), eol_))
        if self.pixelHeight is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<pixelHeight>%s</pixelHeight>%s' % (self.gds_format_float(self.pixelHeight, input_name='pixelHeight'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'imageWidth':
            imageWidth_ = child_.text
            imageWidth_ = self.gds_validate_string(imageWidth_, node, 'imageWidth')
            self.imageWidth = imageWidth_
            # validate type imageWidthType
            self.validate_imageWidthType(self.imageWidth)
        elif nodeName_ == 'pixelWidth':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'pixelWidth')
            self.pixelWidth = fval_
        elif nodeName_ == 'imageHeight':
            imageHeight_ = child_.text
            imageHeight_ = self.gds_validate_string(imageHeight_, node, 'imageHeight')
            self.imageHeight = imageHeight_
            # validate type imageHeightType
            self.validate_imageHeightType(self.imageHeight)
        elif nodeName_ == 'pixelHeight':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'pixelHeight')
            self.pixelHeight = fval_
# end class dimensionsType


class datasetSizeType(GeneratedsSuper):
    """Size of entire dataset in MB, GB, or TB"""
    subclass = None
    superclass = None
    def __init__(self, units='GB', valueOf_=None):
        self.original_tagname_ = None
        self.units = _cast(None, units)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, datasetSizeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if datasetSizeType.subclass:
            return datasetSizeType.subclass(*args_, **kwargs_)
        else:
            return datasetSizeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='datasetSizeType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('datasetSizeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='datasetSizeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='datasetSizeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='datasetSizeType'):
        if self.units != "GB" and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.units), input_name='units')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='datasetSizeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class datasetSizeType


class authorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, authorORCID=None, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.authorORCID = _cast(None, authorORCID)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, authorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if authorType.subclass:
            return authorType.subclass(*args_, **kwargs_)
        else:
            return authorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authorORCID(self): return self.authorORCID
    def set_authorORCID(self, authorORCID): self.authorORCID = authorORCID
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_authorORCIDType(self, value):
        # Validate type authorORCIDType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_authorORCIDType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_authorORCIDType_patterns_, ))
    validate_authorORCIDType_patterns_ = [['^(\\d{4}-){3}\\d{3}(\\d$|^X)$']]
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='authorType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('authorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='authorType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='authorType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='authorType'):
        if self.authorORCID is not None and 'authorORCID' not in already_processed:
            already_processed.add('authorORCID')
            outfile.write(' authorORCID=%s' % (quote_attrib(self.authorORCID), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='authorType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('authorORCID', node)
        if value is not None and 'authorORCID' not in already_processed:
            already_processed.add('authorORCID')
            self.authorORCID = value
            self.authorORCID = ' '.join(self.authorORCID.split())
            self.validate_authorORCIDType(self.authorORCID)    # validate type authorORCIDType
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class authorType


class pubType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, journalArticle=None, nonJournalArticle=None):
        self.original_tagname_ = None
        self.journalArticle = journalArticle
        self.nonJournalArticle = nonJournalArticle
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, pubType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if pubType.subclass:
            return pubType.subclass(*args_, **kwargs_)
        else:
            return pubType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_journalArticle(self): return self.journalArticle
    def set_journalArticle(self, journalArticle): self.journalArticle = journalArticle
    def get_nonJournalArticle(self): return self.nonJournalArticle
    def set_nonJournalArticle(self, nonJournalArticle): self.nonJournalArticle = nonJournalArticle
    def hasContent_(self):
        if (
            self.journalArticle is not None or
            self.nonJournalArticle is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pubType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('pubType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pubType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='pubType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pubType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='pubType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.journalArticle is not None:
            self.journalArticle.export(outfile, level, namespace_, name_='journalArticle', pretty_print=pretty_print)
        if self.nonJournalArticle is not None:
            self.nonJournalArticle.export(outfile, level, namespace_, name_='nonJournalArticle', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'journalArticle':
            obj_ = jrnlArtType.factory()
            obj_.build(child_)
            self.journalArticle = obj_
            obj_.original_tagname_ = 'journalArticle'
        elif nodeName_ == 'nonJournalArticle':
            obj_ = nonJrnlArtType.factory()
            obj_.build(child_)
            self.nonJournalArticle = obj_
            obj_.original_tagname_ = 'nonJournalArticle'
# end class pubType


class jrnlArtType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, authors=None, articleTitle=None, journal=None, volume=None, firstPage=None, lastPage=None, year=None, externalReference=None):
        self.original_tagname_ = None
        self.authors = authors
        self.articleTitle = articleTitle
        self.journal = journal
        self.volume = volume
        self.firstPage = firstPage
        self.lastPage = lastPage
        self.year = year
        if externalReference is None:
            self.externalReference = []
        else:
            self.externalReference = externalReference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, jrnlArtType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if jrnlArtType.subclass:
            return jrnlArtType.subclass(*args_, **kwargs_)
        else:
            return jrnlArtType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authors(self): return self.authors
    def set_authors(self, authors): self.authors = authors
    def get_articleTitle(self): return self.articleTitle
    def set_articleTitle(self, articleTitle): self.articleTitle = articleTitle
    def get_journal(self): return self.journal
    def set_journal(self, journal): self.journal = journal
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_firstPage(self): return self.firstPage
    def set_firstPage(self, firstPage): self.firstPage = firstPage
    def get_lastPage(self): return self.lastPage
    def set_lastPage(self, lastPage): self.lastPage = lastPage
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_externalReference(self): return self.externalReference
    def set_externalReference(self, externalReference): self.externalReference = externalReference
    def add_externalReference(self, value): self.externalReference.append(value)
    def insert_externalReference_at(self, index, value): self.externalReference.insert(index, value)
    def replace_externalReference_at(self, index, value): self.externalReference[index] = value
    def hasContent_(self):
        if (
            self.authors is not None or
            self.articleTitle is not None or
            self.journal is not None or
            self.volume is not None or
            self.firstPage is not None or
            self.lastPage is not None or
            self.year is not None or
            self.externalReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='jrnlArtType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('jrnlArtType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='jrnlArtType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='jrnlArtType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='jrnlArtType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='jrnlArtType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.authors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<authors>%s</authors>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.authors), input_name='authors')), eol_))
        if self.articleTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<articleTitle>%s</articleTitle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.articleTitle), input_name='articleTitle')), eol_))
        if self.journal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<journal>%s</journal>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.journal), input_name='journal')), eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<volume>%s</volume>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), eol_))
        if self.firstPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstPage>%s</firstPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstPage), input_name='firstPage')), eol_))
        if self.lastPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastPage>%s</lastPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastPage), input_name='lastPage')), eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<year>%s</year>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), eol_))
        for externalReference_ in self.externalReference:
            externalReference_.export(outfile, level, namespace_, name_='externalReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authors':
            authors_ = child_.text
            authors_ = self.gds_validate_string(authors_, node, 'authors')
            self.authors = authors_
        elif nodeName_ == 'articleTitle':
            articleTitle_ = child_.text
            articleTitle_ = self.gds_validate_string(articleTitle_, node, 'articleTitle')
            self.articleTitle = articleTitle_
        elif nodeName_ == 'journal':
            journal_ = child_.text
            journal_ = self.gds_validate_string(journal_, node, 'journal')
            self.journal = journal_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'firstPage':
            firstPage_ = child_.text
            firstPage_ = self.gds_validate_string(firstPage_, node, 'firstPage')
            self.firstPage = firstPage_
        elif nodeName_ == 'lastPage':
            lastPage_ = child_.text
            lastPage_ = self.gds_validate_string(lastPage_, node, 'lastPage')
            self.lastPage = lastPage_
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
        elif nodeName_ == 'externalReference':
            obj_ = externalRefType.factory()
            obj_.build(child_)
            self.externalReference.append(obj_)
            obj_.original_tagname_ = 'externalReference'
# end class jrnlArtType


class nonJrnlArtType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, authors=None, chapterTitle=None, book=None, thesisTitle=None, editor=None, publisher=None, publisherLocation=None, volume=None, firstPage=None, lastPage=None, year=None, externalReference=None):
        self.original_tagname_ = None
        self.authors = authors
        self.chapterTitle = chapterTitle
        self.book = book
        self.thesisTitle = thesisTitle
        self.editor = editor
        self.publisher = publisher
        self.publisherLocation = publisherLocation
        self.volume = volume
        self.firstPage = firstPage
        self.lastPage = lastPage
        self.year = year
        if externalReference is None:
            self.externalReference = []
        else:
            self.externalReference = externalReference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, nonJrnlArtType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if nonJrnlArtType.subclass:
            return nonJrnlArtType.subclass(*args_, **kwargs_)
        else:
            return nonJrnlArtType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_authors(self): return self.authors
    def set_authors(self, authors): self.authors = authors
    def get_chapterTitle(self): return self.chapterTitle
    def set_chapterTitle(self, chapterTitle): self.chapterTitle = chapterTitle
    def get_book(self): return self.book
    def set_book(self, book): self.book = book
    def get_thesisTitle(self): return self.thesisTitle
    def set_thesisTitle(self, thesisTitle): self.thesisTitle = thesisTitle
    def get_editor(self): return self.editor
    def set_editor(self, editor): self.editor = editor
    def get_publisher(self): return self.publisher
    def set_publisher(self, publisher): self.publisher = publisher
    def get_publisherLocation(self): return self.publisherLocation
    def set_publisherLocation(self, publisherLocation): self.publisherLocation = publisherLocation
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_firstPage(self): return self.firstPage
    def set_firstPage(self, firstPage): self.firstPage = firstPage
    def get_lastPage(self): return self.lastPage
    def set_lastPage(self, lastPage): self.lastPage = lastPage
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_externalReference(self): return self.externalReference
    def set_externalReference(self, externalReference): self.externalReference = externalReference
    def add_externalReference(self, value): self.externalReference.append(value)
    def insert_externalReference_at(self, index, value): self.externalReference.insert(index, value)
    def replace_externalReference_at(self, index, value): self.externalReference[index] = value
    def hasContent_(self):
        if (
            self.authors is not None or
            self.chapterTitle is not None or
            self.book is not None or
            self.thesisTitle is not None or
            self.editor is not None or
            self.publisher is not None or
            self.publisherLocation is not None or
            self.volume is not None or
            self.firstPage is not None or
            self.lastPage is not None or
            self.year is not None or
            self.externalReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='nonJrnlArtType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('nonJrnlArtType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='nonJrnlArtType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='nonJrnlArtType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='nonJrnlArtType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='nonJrnlArtType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.authors is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<authors>%s</authors>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.authors), input_name='authors')), eol_))
        if self.chapterTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<chapterTitle>%s</chapterTitle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.chapterTitle), input_name='chapterTitle')), eol_))
        if self.book is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<book>%s</book>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.book), input_name='book')), eol_))
        if self.thesisTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<thesisTitle>%s</thesisTitle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.thesisTitle), input_name='thesisTitle')), eol_))
        if self.editor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<editor>%s</editor>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.editor), input_name='editor')), eol_))
        if self.publisher is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<publisher>%s</publisher>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.publisher), input_name='publisher')), eol_))
        if self.publisherLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<publisherLocation>%s</publisherLocation>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.publisherLocation), input_name='publisherLocation')), eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<volume>%s</volume>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), eol_))
        if self.firstPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstPage>%s</firstPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstPage), input_name='firstPage')), eol_))
        if self.lastPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastPage>%s</lastPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastPage), input_name='lastPage')), eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<year>%s</year>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), eol_))
        for externalReference_ in self.externalReference:
            externalReference_.export(outfile, level, namespace_, name_='externalReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'authors':
            authors_ = child_.text
            authors_ = self.gds_validate_string(authors_, node, 'authors')
            self.authors = authors_
        elif nodeName_ == 'chapterTitle':
            chapterTitle_ = child_.text
            chapterTitle_ = self.gds_validate_string(chapterTitle_, node, 'chapterTitle')
            self.chapterTitle = chapterTitle_
        elif nodeName_ == 'book':
            book_ = child_.text
            book_ = self.gds_validate_string(book_, node, 'book')
            self.book = book_
        elif nodeName_ == 'thesisTitle':
            thesisTitle_ = child_.text
            thesisTitle_ = self.gds_validate_string(thesisTitle_, node, 'thesisTitle')
            self.thesisTitle = thesisTitle_
        elif nodeName_ == 'editor':
            editor_ = child_.text
            editor_ = self.gds_validate_string(editor_, node, 'editor')
            self.editor = editor_
        elif nodeName_ == 'publisher':
            publisher_ = child_.text
            publisher_ = self.gds_validate_string(publisher_, node, 'publisher')
            self.publisher = publisher_
        elif nodeName_ == 'publisherLocation':
            publisherLocation_ = child_.text
            publisherLocation_ = self.gds_validate_string(publisherLocation_, node, 'publisherLocation')
            self.publisherLocation = publisherLocation_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'firstPage':
            firstPage_ = child_.text
            firstPage_ = self.gds_validate_string(firstPage_, node, 'firstPage')
            self.firstPage = firstPage_
        elif nodeName_ == 'lastPage':
            lastPage_ = child_.text
            lastPage_ = self.gds_validate_string(lastPage_, node, 'lastPage')
            self.lastPage = lastPage_
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
        elif nodeName_ == 'externalReference':
            obj_ = externalRefType.factory()
            obj_.build(child_)
            self.externalReference.append(obj_)
            obj_.original_tagname_ = 'externalReference'
# end class nonJrnlArtType


class externalRefType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, externalRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if externalRefType.subclass:
            return externalRefType.subclass(*args_, **kwargs_)
        else:
            return externalRefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalRefType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('externalRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalRefType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalRefType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalRefType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='externalRefType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class externalRefType


class citationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, citationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if citationType.subclass:
            return citationType.subclass(*args_, **kwargs_)
        else:
            return citationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='citationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('citationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='citationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='citationType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='citationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='citationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class citationType


class nonJournalCitation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, published=None, author=None, editor=None, bookTitle=None, thesisTitle=None, bookChapterTitle=None, volume=None, publisher=None, publicationLocation=None, country=None, firstPage=None, lastPage=None, year=None, language=None, externalReferences=None, details=None):
        self.original_tagname_ = None
        self.published = _cast(bool, published)
        if author is None:
            self.author = []
        else:
            self.author = author
        if editor is None:
            self.editor = []
        else:
            self.editor = editor
        self.bookTitle = bookTitle
        self.thesisTitle = thesisTitle
        self.bookChapterTitle = bookChapterTitle
        self.volume = volume
        self.publisher = publisher
        self.publicationLocation = publicationLocation
        self.validate_publicationLocationType(self.publicationLocation)
        self.country = country
        self.firstPage = firstPage
        self.validate_pageType(self.firstPage)
        self.lastPage = lastPage
        self.validate_pageType(self.lastPage)
        self.year = year
        self.validate_yearType(self.year)
        self.language = language
        if externalReferences is None:
            self.externalReferences = []
        else:
            self.externalReferences = externalReferences
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, nonJournalCitation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if nonJournalCitation.subclass:
            return nonJournalCitation.subclass(*args_, **kwargs_)
        else:
            return nonJournalCitation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_editor(self): return self.editor
    def set_editor(self, editor): self.editor = editor
    def add_editor(self, value): self.editor.append(value)
    def insert_editor_at(self, index, value): self.editor.insert(index, value)
    def replace_editor_at(self, index, value): self.editor[index] = value
    def get_bookTitle(self): return self.bookTitle
    def set_bookTitle(self, bookTitle): self.bookTitle = bookTitle
    def get_thesisTitle(self): return self.thesisTitle
    def set_thesisTitle(self, thesisTitle): self.thesisTitle = thesisTitle
    def get_bookChapterTitle(self): return self.bookChapterTitle
    def set_bookChapterTitle(self, bookChapterTitle): self.bookChapterTitle = bookChapterTitle
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_publisher(self): return self.publisher
    def set_publisher(self, publisher): self.publisher = publisher
    def get_publicationLocation(self): return self.publicationLocation
    def set_publicationLocation(self, publicationLocation): self.publicationLocation = publicationLocation
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_firstPage(self): return self.firstPage
    def set_firstPage(self, firstPage): self.firstPage = firstPage
    def get_lastPage(self): return self.lastPage
    def set_lastPage(self, lastPage): self.lastPage = lastPage
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def add_externalReferences(self, value): self.externalReferences.append(value)
    def insert_externalReferences_at(self, index, value): self.externalReferences.insert(index, value)
    def replace_externalReferences_at(self, index, value): self.externalReferences[index] = value
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def validate_publicationLocationType(self, value):
        # Validate type publicationLocationType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_publicationLocationType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_publicationLocationType_patterns_, ))
    validate_publicationLocationType_patterns_ = [['^[\\w -]+(, [\\w -]+)*$']]
    def validate_pageType(self, value):
        # Validate type pageType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pageType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pageType_patterns_, ))
    validate_pageType_patterns_ = [['^[.\\w]+$']]
    def validate_yearType(self, value):
        # Validate type yearType, a restriction on xs:gYear.
        if value is not None and Validate_simpletypes_:
            if value < 1900:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on yearType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.author or
            self.editor or
            self.bookTitle is not None or
            self.thesisTitle is not None or
            self.bookChapterTitle is not None or
            self.volume is not None or
            self.publisher is not None or
            self.publicationLocation is not None or
            self.country is not None or
            self.firstPage is not None or
            self.lastPage is not None or
            self.year is not None or
            self.language is not None or
            self.externalReferences or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='nonJournalCitation', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('nonJournalCitation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='nonJournalCitation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='nonJournalCitation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='nonJournalCitation'):
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def exportChildren(self, outfile, level, namespace_='', name_='nonJournalCitation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        for editor_ in self.editor:
            editor_.export(outfile, level, namespace_, name_='editor', pretty_print=pretty_print)
        if self.bookTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<bookTitle>%s</bookTitle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.bookTitle), input_name='bookTitle')), eol_))
        if self.thesisTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<thesisTitle>%s</thesisTitle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.thesisTitle), input_name='thesisTitle')), eol_))
        if self.bookChapterTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<bookChapterTitle>%s</bookChapterTitle>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.bookChapterTitle), input_name='bookChapterTitle')), eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<volume>%s</volume>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), eol_))
        if self.publisher is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<publisher>%s</publisher>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.publisher), input_name='publisher')), eol_))
        if self.publicationLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<publicationLocation>%s</publicationLocation>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.publicationLocation), input_name='publicationLocation')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
        if self.firstPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstPage>%s</firstPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstPage), input_name='firstPage')), eol_))
        if self.lastPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastPage>%s</lastPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastPage), input_name='lastPage')), eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<year>%s</year>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), eol_))
        if self.language is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<language>%s</language>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.language), input_name='language')), eol_))
        for externalReferences_ in self.externalReferences:
            externalReferences_.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'author':
            obj_ = authorOrderType.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'editor':
            obj_ = authorOrderType.factory()
            obj_.build(child_)
            self.editor.append(obj_)
            obj_.original_tagname_ = 'editor'
        elif nodeName_ == 'bookTitle':
            bookTitle_ = child_.text
            if bookTitle_:
                bookTitle_ = re_.sub(String_cleanup_pat_, " ", bookTitle_).strip()
            else:
                bookTitle_ = ""
            bookTitle_ = self.gds_validate_string(bookTitle_, node, 'bookTitle')
            self.bookTitle = bookTitle_
        elif nodeName_ == 'thesisTitle':
            thesisTitle_ = child_.text
            if thesisTitle_:
                thesisTitle_ = re_.sub(String_cleanup_pat_, " ", thesisTitle_).strip()
            else:
                thesisTitle_ = ""
            thesisTitle_ = self.gds_validate_string(thesisTitle_, node, 'thesisTitle')
            self.thesisTitle = thesisTitle_
        elif nodeName_ == 'bookChapterTitle':
            bookChapterTitle_ = child_.text
            if bookChapterTitle_:
                bookChapterTitle_ = re_.sub(String_cleanup_pat_, " ", bookChapterTitle_).strip()
            else:
                bookChapterTitle_ = ""
            bookChapterTitle_ = self.gds_validate_string(bookChapterTitle_, node, 'bookChapterTitle')
            self.bookChapterTitle = bookChapterTitle_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'publisher':
            publisher_ = child_.text
            if publisher_:
                publisher_ = re_.sub(String_cleanup_pat_, " ", publisher_).strip()
            else:
                publisher_ = ""
            publisher_ = self.gds_validate_string(publisher_, node, 'publisher')
            self.publisher = publisher_
        elif nodeName_ == 'publicationLocation':
            publicationLocation_ = child_.text
            if publicationLocation_:
                publicationLocation_ = re_.sub(String_cleanup_pat_, " ", publicationLocation_).strip()
            else:
                publicationLocation_ = ""
            publicationLocation_ = self.gds_validate_string(publicationLocation_, node, 'publicationLocation')
            self.publicationLocation = publicationLocation_
            # validate type publicationLocationType
            self.validate_publicationLocationType(self.publicationLocation)
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'firstPage':
            firstPage_ = child_.text
            if firstPage_:
                firstPage_ = re_.sub(String_cleanup_pat_, " ", firstPage_).strip()
            else:
                firstPage_ = ""
            firstPage_ = self.gds_validate_string(firstPage_, node, 'firstPage')
            self.firstPage = firstPage_
            # validate type pageType
            self.validate_pageType(self.firstPage)
        elif nodeName_ == 'lastPage':
            lastPage_ = child_.text
            if lastPage_:
                lastPage_ = re_.sub(String_cleanup_pat_, " ", lastPage_).strip()
            else:
                lastPage_ = ""
            lastPage_ = self.gds_validate_string(lastPage_, node, 'lastPage')
            self.lastPage = lastPage_
            # validate type pageType
            self.validate_pageType(self.lastPage)
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
            # validate type yearType
            self.validate_yearType(self.year)
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences.append(obj_)
            obj_.original_tagname_ = 'externalReferences'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class nonJournalCitation


class journalCitation(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, published=None, author=None, editor=None, title=None, journal=None, journalAbbreviation=None, country=None, issue=None, volume=None, firstPage=None, lastPage=None, year=None, language=None, externalReferences=None, details=None):
        self.original_tagname_ = None
        self.published = _cast(bool, published)
        if author is None:
            self.author = []
        else:
            self.author = author
        if editor is None:
            self.editor = []
        else:
            self.editor = editor
        self.title = title
        self.journal = journal
        self.journalAbbreviation = journalAbbreviation
        self.validate_journalAbbreviationType(self.journalAbbreviation)
        self.country = country
        self.issue = issue
        self.volume = volume
        self.firstPage = firstPage
        self.validate_pageType(self.firstPage)
        self.lastPage = lastPage
        self.validate_pageType(self.lastPage)
        self.year = year
        self.validate_yearType1(self.year)
        self.language = language
        if externalReferences is None:
            self.externalReferences = []
        else:
            self.externalReferences = externalReferences
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, journalCitation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if journalCitation.subclass:
            return journalCitation.subclass(*args_, **kwargs_)
        else:
            return journalCitation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def get_editor(self): return self.editor
    def set_editor(self, editor): self.editor = editor
    def add_editor(self, value): self.editor.append(value)
    def insert_editor_at(self, index, value): self.editor.insert(index, value)
    def replace_editor_at(self, index, value): self.editor[index] = value
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_journal(self): return self.journal
    def set_journal(self, journal): self.journal = journal
    def get_journalAbbreviation(self): return self.journalAbbreviation
    def set_journalAbbreviation(self, journalAbbreviation): self.journalAbbreviation = journalAbbreviation
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_issue(self): return self.issue
    def set_issue(self, issue): self.issue = issue
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def get_firstPage(self): return self.firstPage
    def set_firstPage(self, firstPage): self.firstPage = firstPage
    def get_lastPage(self): return self.lastPage
    def set_lastPage(self, lastPage): self.lastPage = lastPage
    def get_year(self): return self.year
    def set_year(self, year): self.year = year
    def get_language(self): return self.language
    def set_language(self, language): self.language = language
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def add_externalReferences(self, value): self.externalReferences.append(value)
    def insert_externalReferences_at(self, index, value): self.externalReferences.insert(index, value)
    def replace_externalReferences_at(self, index, value): self.externalReferences[index] = value
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def validate_journalAbbreviationType(self, value):
        # Validate type journalAbbreviationType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_journalAbbreviationType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_journalAbbreviationType_patterns_, ))
    validate_journalAbbreviationType_patterns_ = [['^[A-Z][a-z]*\\.?( [A-Z\\.?]*[a-z]*\\.?)*$']]
    def validate_pageType(self, value):
        # Validate type pageType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_pageType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_pageType_patterns_, ))
    validate_pageType_patterns_ = [['^[.\\w]+$']]
    def validate_yearType1(self, value):
        # Validate type yearType1, a restriction on xs:gYear.
        if value is not None and Validate_simpletypes_:
            if value < 1900:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on yearType1' % {"value" : value} )
    def hasContent_(self):
        if (
            self.author or
            self.editor or
            self.title is not None or
            self.journal is not None or
            self.journalAbbreviation is not None or
            self.country is not None or
            self.issue is not None or
            self.volume is not None or
            self.firstPage is not None or
            self.lastPage is not None or
            self.year is not None or
            self.language is not None or
            self.externalReferences or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='journalCitation', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('journalCitation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='journalCitation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='journalCitation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='journalCitation'):
        if self.published is not None and 'published' not in already_processed:
            already_processed.add('published')
            outfile.write(' published="%s"' % self.gds_format_boolean(self.published, input_name='published'))
    def exportChildren(self, outfile, level, namespace_='', name_='journalCitation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
        for editor_ in self.editor:
            editor_.export(outfile, level, namespace_, name_='editor', pretty_print=pretty_print)
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<title>%s</title>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), eol_))
        if self.journal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<journal>%s</journal>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.journal), input_name='journal')), eol_))
        if self.journalAbbreviation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<journalAbbreviation>%s</journalAbbreviation>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.journalAbbreviation), input_name='journalAbbreviation')), eol_))
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<country>%s</country>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.country), input_name='country')), eol_))
        if self.issue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<issue>%s</issue>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.issue), input_name='issue')), eol_))
        if self.volume is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<volume>%s</volume>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.volume), input_name='volume')), eol_))
        if self.firstPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<firstPage>%s</firstPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.firstPage), input_name='firstPage')), eol_))
        if self.lastPage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<lastPage>%s</lastPage>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.lastPage), input_name='lastPage')), eol_))
        if self.year is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<year>%s</year>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.year), input_name='year')), eol_))
        if self.language is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<language>%s</language>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.language), input_name='language')), eol_))
        for externalReferences_ in self.externalReferences:
            externalReferences_.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('published', node)
        if value is not None and 'published' not in already_processed:
            already_processed.add('published')
            if value in ('true', '1'):
                self.published = True
            elif value in ('false', '0'):
                self.published = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'author':
            obj_ = authorOrderType.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
        elif nodeName_ == 'editor':
            obj_ = authorOrderType.factory()
            obj_.build(child_)
            self.editor.append(obj_)
            obj_.original_tagname_ = 'editor'
        elif nodeName_ == 'title':
            title_ = child_.text
            if title_:
                title_ = re_.sub(String_cleanup_pat_, " ", title_).strip()
            else:
                title_ = ""
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'journal':
            journal_ = child_.text
            if journal_:
                journal_ = re_.sub(String_cleanup_pat_, " ", journal_).strip()
            else:
                journal_ = ""
            journal_ = self.gds_validate_string(journal_, node, 'journal')
            self.journal = journal_
        elif nodeName_ == 'journalAbbreviation':
            journalAbbreviation_ = child_.text
            if journalAbbreviation_:
                journalAbbreviation_ = re_.sub(String_cleanup_pat_, " ", journalAbbreviation_).strip()
            else:
                journalAbbreviation_ = ""
            journalAbbreviation_ = self.gds_validate_string(journalAbbreviation_, node, 'journalAbbreviation')
            self.journalAbbreviation = journalAbbreviation_
            # validate type journalAbbreviationType
            self.validate_journalAbbreviationType(self.journalAbbreviation)
        elif nodeName_ == 'country':
            country_ = child_.text
            if country_:
                country_ = re_.sub(String_cleanup_pat_, " ", country_).strip()
            else:
                country_ = ""
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'issue':
            issue_ = child_.text
            if issue_:
                issue_ = re_.sub(String_cleanup_pat_, " ", issue_).strip()
            else:
                issue_ = ""
            issue_ = self.gds_validate_string(issue_, node, 'issue')
            self.issue = issue_
        elif nodeName_ == 'volume':
            volume_ = child_.text
            if volume_:
                volume_ = re_.sub(String_cleanup_pat_, " ", volume_).strip()
            else:
                volume_ = ""
            volume_ = self.gds_validate_string(volume_, node, 'volume')
            self.volume = volume_
        elif nodeName_ == 'firstPage':
            firstPage_ = child_.text
            if firstPage_:
                firstPage_ = re_.sub(String_cleanup_pat_, " ", firstPage_).strip()
            else:
                firstPage_ = ""
            firstPage_ = self.gds_validate_string(firstPage_, node, 'firstPage')
            self.firstPage = firstPage_
            # validate type pageType
            self.validate_pageType(self.firstPage)
        elif nodeName_ == 'lastPage':
            lastPage_ = child_.text
            if lastPage_:
                lastPage_ = re_.sub(String_cleanup_pat_, " ", lastPage_).strip()
            else:
                lastPage_ = ""
            lastPage_ = self.gds_validate_string(lastPage_, node, 'lastPage')
            self.lastPage = lastPage_
            # validate type pageType
            self.validate_pageType(self.lastPage)
        elif nodeName_ == 'year':
            year_ = child_.text
            year_ = self.gds_validate_string(year_, node, 'year')
            self.year = year_
            # validate type yearType1
            self.validate_yearType1(self.year)
        elif nodeName_ == 'language':
            language_ = child_.text
            language_ = self.gds_validate_string(language_, node, 'language')
            self.language = language_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType2.factory()
            obj_.build(child_)
            self.externalReferences.append(obj_)
            obj_.original_tagname_ = 'externalReferences'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class journalCitation


class authorOrderType(authorType):
    subclass = None
    superclass = authorType
    def __init__(self, authorORCID=None, order=None, valueOf_=None):
        self.original_tagname_ = None
        super(authorOrderType, self).__init__(authorORCID, valueOf_, )
        self.order = _cast(int, order)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, authorOrderType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if authorOrderType.subclass:
            return authorOrderType.subclass(*args_, **kwargs_)
        else:
            return authorOrderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_order(self): return self.order
    def set_order(self, order): self.order = order
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            super(authorOrderType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='authorOrderType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('authorOrderType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='authorOrderType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='authorOrderType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='authorOrderType'):
        super(authorOrderType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='authorOrderType')
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
    def exportChildren(self, outfile, level, namespace_='', name_='authorOrderType', fromsubclass_=False, pretty_print=True):
        super(authorOrderType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            try:
                self.order = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.order <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        super(authorOrderType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class authorOrderType


class imageSetType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, directory=None, category=None, headerFormat=None, dataFormat=None, numImagesOrTiltSeries=None, framesPerImage=1, frameRange=None, voxelType=None, dimensions=None, details=None):
        self.original_tagname_ = None
        self.name = name
        self.directory = directory
        self.category = category
        self.validate_imageDataCategory(self.category)
        self.headerFormat = headerFormat
        self.validate_headerFormatType(self.headerFormat)
        self.dataFormat = dataFormat
        self.validate_dataFormatType(self.dataFormat)
        self.numImagesOrTiltSeries = numImagesOrTiltSeries
        self.framesPerImage = framesPerImage
        self.frameRange = frameRange
        self.voxelType = voxelType
        self.validate_voxelTypeType(self.voxelType)
        self.dimensions = dimensions
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, imageSetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if imageSetType.subclass:
            return imageSetType.subclass(*args_, **kwargs_)
        else:
            return imageSetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_directory(self): return self.directory
    def set_directory(self, directory): self.directory = directory
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_headerFormat(self): return self.headerFormat
    def set_headerFormat(self, headerFormat): self.headerFormat = headerFormat
    def get_dataFormat(self): return self.dataFormat
    def set_dataFormat(self, dataFormat): self.dataFormat = dataFormat
    def get_numImagesOrTiltSeries(self): return self.numImagesOrTiltSeries
    def set_numImagesOrTiltSeries(self, numImagesOrTiltSeries): self.numImagesOrTiltSeries = numImagesOrTiltSeries
    def get_framesPerImage(self): return self.framesPerImage
    def set_framesPerImage(self, framesPerImage): self.framesPerImage = framesPerImage
    def get_frameRange(self): return self.frameRange
    def set_frameRange(self, frameRange): self.frameRange = frameRange
    def get_voxelType(self): return self.voxelType
    def set_voxelType(self, voxelType): self.voxelType = voxelType
    def get_dimensions(self): return self.dimensions
    def set_dimensions(self, dimensions): self.dimensions = dimensions
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def validate_imageDataCategory(self, value):
        # Validate type imageDataCategory, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['micrographs - single frame', 'micrographs - multiframe', 'micrographs - tilt series', 'micrographs - focal pairs - unprocessed', 'micrographs - focal pairs - contrast inverted', 'picked particles - single frame - unprocessed', 'picked particles - multiframe - unprocessed', 'picked particles - single frame - processed', 'picked particles - multiframe - processed', 'tilt series', 'class averages']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on imageDataCategory' % {"value" : value.encode("utf-8")} )
    def validate_headerFormatType(self, value):
        # Validate type headerFormatType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['EMX', 'FEI EPU', 'MRC', 'SPIDER', 'MRCS', 'DM4', 'TIFF', 'IMAGIC']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on headerFormatType' % {"value" : value.encode("utf-8")} )
    def validate_dataFormatType(self, value):
        # Validate type dataFormatType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['MRC', 'SPIDER', 'MRCS', 'DM4', 'TIFF', 'IMAGIC']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on dataFormatType' % {"value" : value.encode("utf-8")} )
    def validate_voxelTypeType(self, value):
        # Validate type voxelTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['UNSIGNED BYTE', 'SIGNED BYTE', 'UNSIGNED 16 BIT INTEGER', 'SIGNED 16 BIT INTEGER', 'UNSIGNED 32 BIT INTEGER', 'SIGNED 32 BIT INTEGER', '32 BIT FLOAT']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on voxelTypeType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.name is not None or
            self.directory is not None or
            self.category is not None or
            self.headerFormat is not None or
            self.dataFormat is not None or
            self.numImagesOrTiltSeries is not None or
            self.framesPerImage != 1 or
            self.frameRange is not None or
            self.voxelType is not None or
            self.dimensions is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='imageSetType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('imageSetType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='imageSetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='imageSetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='imageSetType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='imageSetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<name>%s</name>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), eol_))
        if self.directory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<directory>%s</directory>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.directory), input_name='directory')), eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<category>%s</category>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.category), input_name='category')), eol_))
        if self.headerFormat is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<headerFormat>%s</headerFormat>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.headerFormat), input_name='headerFormat')), eol_))
        if self.dataFormat is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<dataFormat>%s</dataFormat>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.dataFormat), input_name='dataFormat')), eol_))
        if self.numImagesOrTiltSeries is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<numImagesOrTiltSeries>%s</numImagesOrTiltSeries>%s' % (self.gds_format_integer(self.numImagesOrTiltSeries, input_name='numImagesOrTiltSeries'), eol_))
        if self.framesPerImage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<framesPerImage>%s</framesPerImage>%s' % (self.gds_format_integer(self.framesPerImage, input_name='framesPerImage'), eol_))
        if self.frameRange is not None:
            self.frameRange.export(outfile, level, namespace_, name_='frameRange', pretty_print=pretty_print)
        if self.voxelType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<voxelType>%s</voxelType>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.voxelType), input_name='voxelType')), eol_))
        if self.dimensions is not None:
            self.dimensions.export(outfile, level, namespace_, name_='dimensions', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<details>%s</details>%s' % (self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'directory':
            directory_ = child_.text
            directory_ = self.gds_validate_string(directory_, node, 'directory')
            self.directory = directory_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
            # validate type imageDataCategory
            self.validate_imageDataCategory(self.category)
        elif nodeName_ == 'headerFormat':
            headerFormat_ = child_.text
            headerFormat_ = self.gds_validate_string(headerFormat_, node, 'headerFormat')
            self.headerFormat = headerFormat_
            # validate type headerFormatType
            self.validate_headerFormatType(self.headerFormat)
        elif nodeName_ == 'dataFormat':
            dataFormat_ = child_.text
            dataFormat_ = self.gds_validate_string(dataFormat_, node, 'dataFormat')
            self.dataFormat = dataFormat_
            # validate type dataFormatType
            self.validate_dataFormatType(self.dataFormat)
        elif nodeName_ == 'numImagesOrTiltSeries':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'numImagesOrTiltSeries')
            self.numImagesOrTiltSeries = ival_
        elif nodeName_ == 'framesPerImage':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'framesPerImage')
            self.framesPerImage = ival_
        elif nodeName_ == 'frameRange':
            obj_ = frameRangeType.factory()
            obj_.build(child_)
            self.frameRange = obj_
            obj_.original_tagname_ = 'frameRange'
        elif nodeName_ == 'voxelType':
            voxelType_ = child_.text
            voxelType_ = self.gds_validate_string(voxelType_, node, 'voxelType')
            self.voxelType = voxelType_
            # validate type voxelTypeType
            self.validate_voxelTypeType(self.voxelType)
        elif nodeName_ == 'dimensions':
            obj_ = dimensionsType.factory()
            obj_.build(child_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class imageSetType


class frameRangeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, frameRangeMin=None, frameRangeMax=None):
        self.original_tagname_ = None
        self.frameRangeMin = frameRangeMin
        self.frameRangeMax = frameRangeMax
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, frameRangeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if frameRangeType.subclass:
            return frameRangeType.subclass(*args_, **kwargs_)
        else:
            return frameRangeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_frameRangeMin(self): return self.frameRangeMin
    def set_frameRangeMin(self, frameRangeMin): self.frameRangeMin = frameRangeMin
    def get_frameRangeMax(self): return self.frameRangeMax
    def set_frameRangeMax(self, frameRangeMax): self.frameRangeMax = frameRangeMax
    def hasContent_(self):
        if (
            self.frameRangeMin is not None or
            self.frameRangeMax is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='frameRangeType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('frameRangeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='frameRangeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='frameRangeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='frameRangeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='frameRangeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.frameRangeMin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<frameRangeMin>%s</frameRangeMin>%s' % (self.gds_format_integer(self.frameRangeMin, input_name='frameRangeMin'), eol_))
        if self.frameRangeMax is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<frameRangeMax>%s</frameRangeMax>%s' % (self.gds_format_integer(self.frameRangeMax, input_name='frameRangeMax'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'frameRangeMin':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'frameRangeMin')
            self.frameRangeMin = ival_
        elif nodeName_ == 'frameRangeMax':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'frameRangeMax')
            self.frameRangeMax = ival_
# end class frameRangeType


class keyDatesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, depositionDate=None, releaseDate=None, obsoleteDate=None, updateDate=None):
        self.original_tagname_ = None
        if isinstance(depositionDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(depositionDate, '%Y-%m-%d').date()
        else:
            initvalue_ = depositionDate
        self.depositionDate = initvalue_
        if isinstance(releaseDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(releaseDate, '%Y-%m-%d').date()
        else:
            initvalue_ = releaseDate
        self.releaseDate = initvalue_
        if isinstance(obsoleteDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(obsoleteDate, '%Y-%m-%d').date()
        else:
            initvalue_ = obsoleteDate
        self.obsoleteDate = initvalue_
        if isinstance(updateDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(updateDate, '%Y-%m-%d').date()
        else:
            initvalue_ = updateDate
        self.updateDate = initvalue_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, keyDatesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if keyDatesType.subclass:
            return keyDatesType.subclass(*args_, **kwargs_)
        else:
            return keyDatesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_depositionDate(self): return self.depositionDate
    def set_depositionDate(self, depositionDate): self.depositionDate = depositionDate
    def get_releaseDate(self): return self.releaseDate
    def set_releaseDate(self, releaseDate): self.releaseDate = releaseDate
    def get_obsoleteDate(self): return self.obsoleteDate
    def set_obsoleteDate(self, obsoleteDate): self.obsoleteDate = obsoleteDate
    def get_updateDate(self): return self.updateDate
    def set_updateDate(self, updateDate): self.updateDate = updateDate
    def hasContent_(self):
        if (
            self.depositionDate is not None or
            self.releaseDate is not None or
            self.obsoleteDate is not None or
            self.updateDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='keyDatesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('keyDatesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='keyDatesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='keyDatesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='keyDatesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='keyDatesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.depositionDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<depositionDate>%s</depositionDate>%s' % (self.gds_format_date(self.depositionDate, input_name='depositionDate'), eol_))
        if self.releaseDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<releaseDate>%s</releaseDate>%s' % (self.gds_format_date(self.releaseDate, input_name='releaseDate'), eol_))
        if self.obsoleteDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<obsoleteDate>%s</obsoleteDate>%s' % (self.gds_format_date(self.obsoleteDate, input_name='obsoleteDate'), eol_))
        if self.updateDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<updateDate>%s</updateDate>%s' % (self.gds_format_date(self.updateDate, input_name='updateDate'), eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'depositionDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.depositionDate = dval_
        elif nodeName_ == 'releaseDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.releaseDate = dval_
        elif nodeName_ == 'obsoleteDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.obsoleteDate = dval_
        elif nodeName_ == 'updateDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.updateDate = dval_
# end class keyDatesType


class correspondingAuthorType(contactDetailsType):
    subclass = None
    superclass = contactDetailsType
    def __init__(self, authorORCID=None, title=None, firstName=None, middleName=None, lastName=None, organization=None, street=None, townOrCity=None, stateOrProvince=None, country=None, postOrZipCode=None, email=None, telephone=None, fax=None, private=None):
        self.original_tagname_ = None
        super(correspondingAuthorType, self).__init__(authorORCID, title, firstName, middleName, lastName, organization, street, townOrCity, stateOrProvince, country, postOrZipCode, email, telephone, fax, )
        self.private = _cast(None, private)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, correspondingAuthorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if correspondingAuthorType.subclass:
            return correspondingAuthorType.subclass(*args_, **kwargs_)
        else:
            return correspondingAuthorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_private(self): return self.private
    def set_private(self, private): self.private = private
    def hasContent_(self):
        if (
            super(correspondingAuthorType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='correspondingAuthorType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('correspondingAuthorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='correspondingAuthorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='correspondingAuthorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='correspondingAuthorType'):
        super(correspondingAuthorType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='correspondingAuthorType')
        if self.private is not None and 'private' not in already_processed:
            already_processed.add('private')
            outfile.write(' private=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.private), input_name='private')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='correspondingAuthorType', fromsubclass_=False, pretty_print=True):
        super(correspondingAuthorType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('private', node)
        if value is not None and 'private' not in already_processed:
            already_processed.add('private')
            self.private = value
        super(correspondingAuthorType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(correspondingAuthorType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class correspondingAuthorType


class principalInvestigatorType(contactDetailsType):
    subclass = None
    superclass = contactDetailsType
    def __init__(self, authorORCID=None, title=None, firstName=None, middleName=None, lastName=None, organization=None, street=None, townOrCity=None, stateOrProvince=None, country=None, postOrZipCode=None, email=None, telephone=None, fax=None, private=None):
        self.original_tagname_ = None
        super(principalInvestigatorType, self).__init__(authorORCID, title, firstName, middleName, lastName, organization, street, townOrCity, stateOrProvince, country, postOrZipCode, email, telephone, fax, )
        self.private = _cast(None, private)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, principalInvestigatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if principalInvestigatorType.subclass:
            return principalInvestigatorType.subclass(*args_, **kwargs_)
        else:
            return principalInvestigatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_private(self): return self.private
    def set_private(self, private): self.private = private
    def hasContent_(self):
        if (
            super(principalInvestigatorType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='principalInvestigatorType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('principalInvestigatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='principalInvestigatorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='principalInvestigatorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='principalInvestigatorType'):
        super(principalInvestigatorType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='principalInvestigatorType')
        if self.private is not None and 'private' not in already_processed:
            already_processed.add('private')
            outfile.write(' private=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.private), input_name='private')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='principalInvestigatorType', fromsubclass_=False, pretty_print=True):
        super(principalInvestigatorType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('private', node)
        if value is not None and 'private' not in already_processed:
            already_processed.add('private')
            self.private = value
        super(principalInvestigatorType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(principalInvestigatorType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class principalInvestigatorType


class authorsListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, author=None):
        self.original_tagname_ = None
        if author is None:
            self.author = []
        else:
            self.author = author
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, authorsListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if authorsListType.subclass:
            return authorsListType.subclass(*args_, **kwargs_)
        else:
            return authorsListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_author(self): return self.author
    def set_author(self, author): self.author = author
    def add_author(self, value): self.author.append(value)
    def insert_author_at(self, index, value): self.author.insert(index, value)
    def replace_author_at(self, index, value): self.author[index] = value
    def hasContent_(self):
        if (
            self.author
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='authorsListType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('authorsListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='authorsListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='authorsListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='authorsListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='authorsListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for author_ in self.author:
            author_.export(outfile, level, namespace_, name_='author', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'author':
            class_obj_ = self.get_class_obj_(child_, authorType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = 'author'
# end class authorsListType


class versionHistoryType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, version=None):
        self.original_tagname_ = None
        if version is None:
            self.version = []
        else:
            self.version = version
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, versionHistoryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if versionHistoryType.subclass:
            return versionHistoryType.subclass(*args_, **kwargs_)
        else:
            return versionHistoryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def add_version(self, value): self.version.append(value)
    def insert_version_at(self, index, value): self.version.insert(index, value)
    def replace_version_at(self, index, value): self.version[index] = value
    def hasContent_(self):
        if (
            self.version
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='versionHistoryType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('versionHistoryType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='versionHistoryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='versionHistoryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='versionHistoryType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='versionHistoryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for version_ in self.version:
            version_.export(outfile, level, namespace_, name_='version', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            obj_ = versionType.factory()
            obj_.build(child_)
            self.version.append(obj_)
            obj_.original_tagname_ = 'version'
# end class versionHistoryType


class grantSupportType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, grantReference=None):
        self.original_tagname_ = None
        if grantReference is None:
            self.grantReference = []
        else:
            self.grantReference = grantReference
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, grantSupportType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if grantSupportType.subclass:
            return grantSupportType.subclass(*args_, **kwargs_)
        else:
            return grantSupportType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_grantReference(self): return self.grantReference
    def set_grantReference(self, grantReference): self.grantReference = grantReference
    def add_grantReference(self, value): self.grantReference.append(value)
    def insert_grantReference_at(self, index, value): self.grantReference.insert(index, value)
    def replace_grantReference_at(self, index, value): self.grantReference[index] = value
    def hasContent_(self):
        if (
            self.grantReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='grantSupportType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('grantSupportType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='grantSupportType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='grantSupportType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='grantSupportType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='grantSupportType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for grantReference_ in self.grantReference:
            grantReference_.export(outfile, level, namespace_, name_='grantReference', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'grantReference':
            obj_ = grantReferenceType.factory()
            obj_.build(child_)
            self.grantReference.append(obj_)
            obj_.original_tagname_ = 'grantReference'
# end class grantSupportType


class citationListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, universalCitation=None):
        self.original_tagname_ = None
        if universalCitation is None:
            self.universalCitation = []
        else:
            self.universalCitation = universalCitation
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, citationListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if citationListType.subclass:
            return citationListType.subclass(*args_, **kwargs_)
        else:
            return citationListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_universalCitation(self): return self.universalCitation
    def set_universalCitation(self, universalCitation): self.universalCitation = universalCitation
    def add_universalCitation(self, value): self.universalCitation.append(value)
    def insert_universalCitation_at(self, index, value): self.universalCitation.insert(index, value)
    def replace_universalCitation_at(self, index, value): self.universalCitation[index] = value
    def hasContent_(self):
        if (
            self.universalCitation
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='citationListType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('citationListType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='citationListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='citationListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='citationListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='citationListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for universalCitation_ in self.universalCitation:
            universalCitation_.export(outfile, level, namespace_, name_='universalCitation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'universalCitation':
            obj_ = universalCitationType.factory()
            obj_.build(child_)
            self.universalCitation.append(obj_)
            obj_.original_tagname_ = 'universalCitation'
# end class citationListType


class universalCitationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, citationType=None):
        self.original_tagname_ = None
        self.citationType = citationType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, universalCitationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if universalCitationType.subclass:
            return universalCitationType.subclass(*args_, **kwargs_)
        else:
            return universalCitationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_citationType(self): return self.citationType
    def set_citationType(self, citationType): self.citationType = citationType
    def hasContent_(self):
        if (
            self.citationType is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='universalCitationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('universalCitationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='universalCitationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='universalCitationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='universalCitationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='universalCitationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.citationType is not None:
            self.citationType.export(outfile, level, namespace_, name_='citationType', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'citationType':
            obj_ = citationType.factory()
            obj_.build(child_)
            self.citationType = obj_
            obj_.original_tagname_ = 'citationType'
        elif nodeName_ == 'nonJournalCitation':
            obj_ = nonJournalCitation.factory()
            obj_.build(child_)
            self.citationType = obj_
            obj_.original_tagname_ = 'nonJournalCitation'
        elif nodeName_ == 'journalCitation':
            obj_ = journalCitation.factory()
            obj_.build(child_)
            self.citationType = obj_
            obj_.original_tagname_ = 'journalCitation'
# end class universalCitationType


class annotatorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, private=None, valueOf_=None):
        self.original_tagname_ = None
        self.private = _cast(None, private)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, annotatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if annotatorType.subclass:
            return annotatorType.subclass(*args_, **kwargs_)
        else:
            return annotatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_private(self): return self.private
    def set_private(self, private): self.private = private
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='annotatorType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('annotatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='annotatorType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='annotatorType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='annotatorType'):
        if self.private is not None and 'private' not in already_processed:
            already_processed.add('private')
            outfile.write(' private=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.private), input_name='private')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='annotatorType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('private', node)
        if value is not None and 'private' not in already_processed:
            already_processed.add('private')
            self.private = value
            self.private = ' '.join(self.private.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class annotatorType


class organizationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, organizationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if organizationType.subclass:
            return organizationType.subclass(*args_, **kwargs_)
        else:
            return organizationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='organizationType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('organizationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='organizationType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='organizationType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='organizationType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='organizationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class organizationType


class externalReferencesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, externalReferencesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if externalReferencesType.subclass:
            return externalReferencesType.subclass(*args_, **kwargs_)
        else:
            return externalReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalReferencesType', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('externalReferencesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalReferencesType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalReferencesType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalReferencesType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='externalReferencesType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class externalReferencesType


class externalReferencesType2(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, externalReferencesType2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if externalReferencesType2.subclass:
            return externalReferencesType2.subclass(*args_, **kwargs_)
        else:
            return externalReferencesType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalReferencesType2', namespacedef_='', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('externalReferencesType2')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalReferencesType2')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalReferencesType2', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalReferencesType2'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='externalReferencesType2', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class externalReferencesType2


GDSClassesMapping = {
    'entry': entryType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    if sys.version_info.major == 2:
        from StringIO import StringIO as IOBuffer
    else:
        from io import BytesIO as IOBuffer
    parser = None
    doc = parsexml_(IOBuffer(inString), parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'entryType'
        rootClass = entryType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from empiar import *\n\n')
        sys.stdout.write('import empiar as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "adminType",
    "annotatorType",
    "authorOrderType",
    "authorType",
    "authorsListType",
    "citationListType",
    "citationType",
    "contactDetailsType",
    "correspondingAuthorType",
    "crossReferencesType",
    "datasetSizeType",
    "dimensionsType",
    "entryType",
    "externalRefType",
    "externalReferencesType",
    "externalReferencesType2",
    "frameRangeType",
    "grantReferenceType",
    "grantSupportType",
    "imageSetType",
    "journalCitation",
    "jrnlArtType",
    "keyDatesType",
    "nonJournalCitation",
    "nonJrnlArtType",
    "organizationType",
    "principalInvestigatorType",
    "pubType",
    "relatedEMDBEntriesType",
    "telephoneNumberType",
    "universalCitationType",
    "versionHistoryType",
    "versionType"
]
