      SUBROUTINE F01LZF(N,A,NRA,C,NRC,WANTB,B,WANTQ,WANTY,Y,NRY,LY,
     *                  WANTZ,Z,NRZ,NCZ,D,E,WORK1,WORK2,IFAIL)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (BIDIAG)
C
C     F01LZF RETURNS ALL OR PART OF THE FACTORIZATION OF THE
C     N*N UPPER TRIANGULAR MATRIX A GIVEN BY
C
C     A = Q*C*(P**T) ,
C
C     WHERE Q AND P ARE N*N ORTHOGONAL MATRICES AND C IS AN
C     N*N UPPER BIDIAGONAL MATRIX.
C
C     IF WANTB IS .TRUE. THEN B RETURNS (Q**T)*B.
C     IF WANTY IS .TRUE. THEN Y RETURNS Y*Q.
C     IF WANTZ IS .TRUE. THEN Z RETURNS (P**T)*Z.
C
C     INPUT PARAMETERS.
C
C     N     - ORDER OF THE MATRIX A.
C
C     A     - THE N*N UPPER TRIANGULAR MATRIX TO BE FACTORIZED. THE
C             STRICTLY LOWER TRIANGULAR PART OF A IS NOT REFERENCED.
C
C     NRA   - ROW DIMENSION OF A AS DECLARED IN THE CALLING PROGRAM.
C             NRA MUST BE AT LEAST N.
C
C     NRC   - ROW DIMENSION OF C AS DECLARED IN THE CALLING PROGRAM.
C             NRC MUST BE AT LEAST N.
C
C     WANTB - MUST BE .TRUE. IF (Q**T)*B IS REQUIRED.
C             IF WANTB IS .FALSE. THEN B IS NOT REFERENCED.
C
C     B     - AN N ELEMENT REAL VECTOR.
C
C     WANTQ - MUST BE .TRUE. IF DETAILS OF Q ARE TO BE
C             STORED BELOW THE BIDIAGONAL PART OF C.
C             IF WANTQ IS .FALSE. THEN THE LOWER TRIANGULAR
C             PART OF C IS NOT REFERENCED.
C
C     WANTY - MUST BE .TRUE. IF Y*Q IS REQUIRED.
C             IF WANTY IS .FALSE. THEN Y IS NOT REFERENCED.
C
C     Y     - AN LY*N REAL MATRIX.
C
C     NRY   - IF WANTY IS .TRUE. THEN NRY MUST BE THE ROW
C             DIMENSION OF Y AS DECLARED IN THE CALLING
C             PROGRAM AND MUST BE AT LEAST LY.
C
C     LY    - IF WANTY IS .TRUE. THEN LY MUST BE THE NUMBER
C             OF ROWS OF Y AND MUST BE AT LEAST 1.
C
C     WANTZ - MUST BE .TRUE. IF (P**T)*Z IS REQUIRED.
C             IF WANTZ IS .FALSE. THEN Z IS NOT REFERENCED.
C
C     Z     - AN N*NCZ REAL MATRIX.
C
C     NRZ   - IF WANTZ IS .TRUE. THEN NRZ MUST BE THE ROW
C             DIMENSION OF Z AS DECLARED IN THE CALLING
C             PROGRAM AND MUST BE AT LEAST N.
C
C     NCZ   - IF WANTZ IS .TRUE. THEN NCZ MUST BE THE
C             NUMBER OF COLUMNS OF Z AND MUST BE AT LEAST
C             1.
C
C     IFAIL - THE USUAL FAILURE PARAMETER. IF IN DOUBT SET
C             IFAIL TO ZERO BEFORE CALLING THIS ROUTINE.
C
C     OUTPUT PARAMETERS.
C
C     C     - N*N MATRIX CONTAINING THE UPPER BIDIAGONAL MATRIX B.
C             DETAILS OF P ARE STORED ABOVE THE BIDIAGONAL
C             PART OF C. UNLESS WANTQ IS .TRUE. THE
C             STRICTLY LOWER TRIANGULAR PART OF C IS NOT
C             REFERENCED.
C             THE ROUTINE MAY BE CALLED WITH C=A.
C
C     B     - IF WANTB IS .TRUE. THEN B WILL RETURN THE N ELEMENT
C             VECTOR (Q**T)*B.
C
C     Y     - IF WANTY IS .TRUE. THEN Y WILL RETURN THE
C             LY*N MATRIX Y*Q.
C
C     Z     - IF WANTZ IS .TRUE. THEN Z WILL RETURN THE N*NCZ MATRIX
C             (P**T)*Z.
C
C     D     - N ELEMENT VECTOR CONTAINING THE DIAGONAL ELEMENTS OF C
C             SUCH THAT D(I)=C(I,I), I=1,2,...,N.
C
C     E     - N ELEMENT VECTOR CONTAINING THE
C             SUPER-DIAGONAL ELEMENTS OF C SUCH THAT
C             E(I)=C(I-1,I), I=2,3,...,N. E(1) IS NOT
C             REFERENCED.
C
C     IFAIL - ON NORMAL RETURN IFAIL WILL BE ZERO.
C             IF AN INPUT PARAMETER IS INCORRECTLY SUPPLIED
C             THEN IFAIL IS SET TO UNITY. NO OTHER FAILURE
C             IS POSSIBLE.
C
C     WORKSPACE PARAMETERS.
C
C     WORK1
C     WORK2 - N ELEMENT REAL VECTORS.
C             IF WANTZ IS .FALSE. THEN WORK1 AND WORK2 ARE NOT
C             REFERENCED.
C
C     .. Parameters ..
      CHARACTER*6       SRNAME
      PARAMETER         (SRNAME='F01LZF')
C     .. Scalar Arguments ..
      INTEGER           IFAIL, LY, N, NCZ, NRA, NRC, NRY, NRZ
      LOGICAL           WANTB, WANTQ, WANTY, WANTZ
C     .. Array Arguments ..
      DOUBLE PRECISION  A(NRA,N), B(N), C(NRC,N), D(N), E(N), WORK1(N),
     *                  WORK2(N), Y(NRY,N), Z(NRZ,NCZ)
C     .. Local Scalars ..
      DOUBLE PRECISION  BIG, CS, EPS, RSQTPS, SMALL, SN, SQTEPS, T, W, X
      INTEGER           I, IERR, J, JJ, JP1, K, KP1, KP2, NM2
C     .. Local Arrays ..
      CHARACTER*1       P01REC(1)
C     .. External Functions ..
      DOUBLE PRECISION  F01LZZ, X02AJF, X02AMF
      INTEGER           P01ABF
      EXTERNAL          F01LZZ, X02AJF, X02AMF, P01ABF
C     .. External Subroutines ..
      EXTERNAL          F01LZW, F01LZX, F01LZY
C     .. Intrinsic Functions ..
      INTRINSIC         SQRT
C     .. Executable Statements ..
      IERR = IFAIL
      IF (IERR.EQ.0) IFAIL = 1
C
      IF (NRA.LT.N .OR. NRC.LT.N .OR. N.LT.1) GO TO 220
      IF (WANTY .AND. (NRY.LT.LY .OR. LY.LT.1)) GO TO 220
      IF (WANTZ .AND. (NRZ.LT.N .OR. NCZ.LT.1)) GO TO 220
C
      SMALL = X02AMF()
      BIG = 1.0D0/SMALL
      EPS = X02AJF()
      SQTEPS = SQRT(EPS)
      RSQTPS = 1.0D0/SQTEPS
C
      D(1) = A(1,1)
C
      DO 40 J = 1, N
         DO 20 I = 1, J
            C(I,J) = A(I,J)
   20    CONTINUE
   40 CONTINUE
C
      IFAIL = 0
      IF (N.EQ.1) RETURN
      IF (N.EQ.2) GO TO 200
C
C     START MAIN LOOP. K(TH) STEP PUTS ZEROS INTO K(TH) ROW OF C.
C
      NM2 = N - 2
      DO 180 K = 1, NM2
         KP1 = K + 1
C
C        SET UP PLANE ROTATION P(J,J+1) TO ANNIHILATE C(K,J+1).
C        THIS ROTATION INTRODUCES AN UNWANTED ELEMENT IN C(J+1,J)
C        WHICH IS STORED IN X.
C        J GOES N-1,N-2,...,K+1.
C
         J = N
         DO 100 JJ = K, NM2
            JP1 = J
            J = J - 1
            W = C(K,JP1)
C
            T = F01LZZ(C(K,J),W,SMALL,BIG)
C
            C(K,JP1) = T
            X = 0.0D0
C
            CALL F01LZW(T,CS,SN,SQTEPS,RSQTPS,BIG)
C
            IF ( .NOT. WANTZ) GO TO 60
            WORK1(J) = CS
            WORK2(J) = SN
C
   60       IF (T.EQ.0.0D0) GO TO 80
            C(K,J) = CS*C(K,J) + SN*W
C
C           NOW APPLY THE TRANSFORMATION P(J,J+1).
C
            CALL F01LZY(J-K,CS,SN,C(KP1,J),C(KP1,JP1))
C
            X = SN*C(JP1,JP1)
            C(JP1,JP1) = CS*C(JP1,JP1)
C
C           NOW SET UP PLANE ROTATION Q(J,J+1)**T TO ANNIHILATE
C           X=C(J+1,J).
C
   80       T = F01LZZ(C(J,J),X,SMALL,BIG)
C
            IF (WANTQ) C(JP1,K) = T
C
            CALL F01LZW(T,D(J),E(J),SQTEPS,RSQTPS,BIG)
C
            C(J,J) = D(J)*C(J,J) + E(J)*X
C
            IF (WANTY) CALL F01LZY(LY,D(J),E(J),Y(1,J),Y(1,JP1))
C
  100    CONTINUE
C
C        NOW APPLY THE TRANSFORMATIONS Q(J,J+1)**T AND FORM
C        (P(J,J+1)**T)*Z, J=N-1,N-2,...,K+1 COLUMN BY COLUMN
C
         KP2 = KP1 + 1
         DO 120 J = KP2, N
C
            CALL F01LZX(J-K,D(K),E(K),C(KP1,J))
C
  120    CONTINUE
C
         IF (WANTB) CALL F01LZX(N-K,D(K),E(K),B(KP1))
C
         IF ( .NOT. WANTZ) GO TO 160
         DO 140 J = 1, NCZ
C
            CALL F01LZX(N-K,WORK1(K),WORK2(K),Z(KP1,J))
C
  140    CONTINUE
C
  160    D(KP1) = C(KP1,KP1)
         E(KP1) = C(K,KP1)
C
  180 CONTINUE
C
  200 D(N) = C(N,N)
      E(N) = C(N-1,N)
      RETURN
C
  220 IFAIL = P01ABF(IERR,IFAIL,SRNAME,0,P01REC)
      RETURN
      END

      SUBROUTINE F01LZW(T,C,S,SQTEPS,RSQTPS,BIG)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (COSSIN)
C
C     F01LZW RETURNS THE VALUES
C
C     C = COS(THETA)   AND   S = SIN(THETA)
C
C     FOR A GIVEN VALUE OF
C
C     T = TAN(THETA) .
C
C     C IS ALWAYS NON-NEGATIVE AND S HAS THE SAME SIGN AS T.
C
C     SQTEPS, RSQTPS AND BIG MUST BE SUCH THAT
C
C     SQTEPS = SQRT(X02AJF) , RSQTPS = 1.0/SQTEPS AND BIG =
C     1.0/X02AMF ,
C
C     WHERE X02AJF AND X02AMF ARE THE NUMBERS RETURNED FROM
C     ROUTINES X02AJF AND X02AMF RESPECTIVELY.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  BIG, C, RSQTPS, S, SQTEPS, T
C     .. Local Scalars ..
      DOUBLE PRECISION  ABST, TT
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, SIGN, SQRT
C     .. Executable Statements ..
      IF (T.NE.0.0D0) GO TO 20
      C = 1.0D0
      S = 0.0D0
      RETURN
C
   20 ABST = ABS(T)
      IF (ABST.LT.SQTEPS) GO TO 60
      IF (ABST.GT.RSQTPS) GO TO 80
C
      TT = ABST*ABST
      IF (ABST.GT.1.0D0) GO TO 40
C
      TT = 0.25D0*TT
      C = 0.5D0/SQRT(0.25D0+TT)
      S = C*T
      RETURN
C
   40 TT = 0.25D0/TT
      S = 0.5D0/SQRT(0.25D0+TT)
      C = S/ABST
      S = SIGN(S,T)
      RETURN
C
   60 C = 1.0D0
      S = T
      RETURN
C
   80 C = 0.0D0
      IF (ABST.LT.BIG) C = 1.0D0/ABST
      S = SIGN(1.0D0,T)
      RETURN
      END

      SUBROUTINE F01LZX(N,C,S,X)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (PLROT6)
C
C     F01LZX RETURNS THE N ELEMENT VECTOR
C
C     Y = R(1,2)*R(2,3)*...*R(N-1,N)*X ,
C
C     WHERE X IS AN N ELEMENT VECTOR AND R(J-1,J) IS A PLANE
C     ROTATION FOR THE (J-1,J)-PLANE.
C
C     Y IS OVERWRITTEN ON X.
C
C     THE N ELEMENT VECTORS C AND S MUST BE SUCH THAT THE
C     NON-IDENTITY PART OF R(J-1,J) IS GIVEN BY
C
C     R(J-1,J) = (  C(J)  S(J) ) .
C                ( -S(J)  C(J) )
C
C     C(1) AND S(1) ARE NOT REFERENCED.
C
C
C     N MUST BE AT LEAST 1. IF N=1 THEN AN IMMEDIATE RETURN TO
C     THE CALLING PROGRAM IS MADE.
C
C     .. Scalar Arguments ..
      INTEGER           N
C     .. Array Arguments ..
      DOUBLE PRECISION  C(N), S(N), X(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  W
      INTEGER           I, II, IM1
C     .. Executable Statements ..
      IF (N.EQ.1) RETURN
C
      I = N
      DO 20 II = 2, N
         IM1 = I - 1
         W = X(IM1)
         X(IM1) = C(I)*W + S(I)*X(I)
         X(I) = C(I)*X(I) - S(I)*W
         I = IM1
   20 CONTINUE
C
      RETURN
      END

      SUBROUTINE F01LZY(N,C,S,X,Y)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (PLROT8)
C
C     F01LZY FORMS THE N*2 MATRIX
C
C     Z = ( X  Y )*( C  -S ) ,
C                  ( S   C )
C
C     WHERE X AND Y ARE N ELEMENT VECTORS, C=COS(THETA) AND
C     S=SIN(THETA).
C
C     THE FIRST COLUMN OF Z IS OVERWRITTEN ON X AND THE SECOND
C     COLUMN OF Z IS OVERWRITTEN ON Y.
C
C
C     N MUST BE AT LEAST 1.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  C, S
      INTEGER           N
C     .. Array Arguments ..
      DOUBLE PRECISION  X(N), Y(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  W
      INTEGER           I
C     .. Executable Statements ..
      DO 20 I = 1, N
         W = X(I)
         X(I) = C*W + S*Y(I)
         Y(I) = C*Y(I) - S*W
   20 CONTINUE
C
      RETURN
      END

      DOUBLE PRECISION FUNCTION F01LZZ(A,B,SMALL,BIG)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (TANGNT)
C
C     F01LZZ RETURNS THE VALUE
C
C     F01LZZ = B/A .
C
C     SMALL AND BIG MUST BE SUCH THAT
C
C     SMALL = X02AMF     AND     BIG = 1.0/SMALL ,
C
C     WHERE X02AMF IS THE SMALL NUMBER RETURNED FROM ROUTINE
C     X02AMF.
C
C     IF B/A IS LESS THAN SMALL THEN F01LZZ IS RETURNED AS
C     ZERO AND IF B/A IS GREATER THAN BIG THEN F01LZZ IS
C     RETURNED AS SIGN(BIG,B).
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION                 A, B, BIG, SMALL
C     .. Local Scalars ..
      DOUBLE PRECISION                 ABSA, ABSB, X
C     .. Intrinsic Functions ..
      INTRINSIC                        ABS, SIGN
C     .. Executable Statements ..
      F01LZZ = 0.0D0
      IF (B.EQ.0.0D0) RETURN
C
      ABSA = ABS(A)
      ABSB = ABS(B)
      X = 0.0D0
      IF (ABSA.GE.1.0D0) X = ABSA*SMALL
C
      IF (ABSB.LT.X) RETURN
C
      X = 0.0D0
      IF (ABSB.GE.1.0D0) X = ABSB*SMALL
C
      IF (ABSA.LE.X) GO TO 20
C
      F01LZZ = B/A
      RETURN
C
   20 F01LZZ = SIGN(BIG,B)
      RETURN
      END

      SUBROUTINE F01QAF(M,N,A,NRA,C,NRC,Z,IFAIL)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     MARK 14 REVISED. IER-730 (DEC 1989).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (HOUSQU)
C
C     F01QAF RETURNS, IN C AND Z, THE HOUSEHOLDER QU
C     FACTORIZATION OF THE M*N (M.GE.N) MATRIX A. THAT IS A
C     FACTORIZED AS
C
C     A = Q(U) , M.GT.N,   A = QU , M.EQ.N,
C          (0)
C
C     WHERE Q IS AN M*M ORTHOGONAL MATRIX AND U IS A SQUARE UPPER
C     TRIANGULAR MATRIX.
C
C     INPUT PARAMETERS.
C
C     M     - THE NUMBER OF ROWS OF A. M MUST BE AT LEAST N.
C
C     N     - THE NUMBER OF COLUMNS OF A. N MUST BE AT LEAST UNITY.
C
C     A     - THE M*N MATRIX TO BE FACTORIZED.
C
C     NRA   - ROW DIMENSION OF A AS DECLARED IN THE CALLING PROGRAM.
C             NRA MUST BE AT LEAST M.
C
C     NRC   - ROW DIMENSION OF C AS DECLARED IN THE CALLING PROGRAM.
C             NRC MUST BE AT LEAST M.
C
C     IFAIL - THE USUAL FAILURE PARAMETER. IF IN DOUBT SET
C             IFAIL TO ZERO BEFORE CALLING THIS ROUTINE.
C
C     OUTPUT PARAMETERS.
C
C     C     - AN M*N MATRIX CONTAINING DETAILS OF THE QU
C             FACTORIZATION. U IS RETURNED IN THE UPPER
C             TRIANGULAR PART OF C. THE SUB-DIAGONAL
C             ELEMENTS OF THE J(TH) COLUMN OF C CONTAIN
C             ELEMENTS Y(J+1),Y(J+2),...,Y(M) OF THE VECTOR
C             Y SUCH THAT (I-(1/Y(J))*Y*(Y**T)) IS THE
C             J(TH)  HOUSEHOLDER TRANSFORMATION MATRIX.
C             THE ROUTINE MAY BE CALLED WITH C=A.
C
C     Z     - N ELEMENT VECTOR.
C             Z(J) CONTAINS THE ELEMENT Y(J) OF THE J(TH)
C             HOUSEHOLDER TRANSFORMATION MATRIX.
C
C     IFAIL - ON NORMAL RETURN IFAIL WILL BE ZERO.
C             IF AN INPUT PARAMETER IS INCORRECTLY SUPPLIED
C             THEN IFAIL IS SET TO UNITY. NO OTHER FAILURE
C             IS POSSIBLE.
C
C     .. Parameters ..
      CHARACTER*6       SRNAME
      PARAMETER         (SRNAME='F01QAF')
C     .. Scalar Arguments ..
      INTEGER           IFAIL, M, N, NRA, NRC
C     .. Array Arguments ..
      DOUBLE PRECISION  A(NRA,*), C(NRC,*), Z(*)
C     .. Local Scalars ..
      DOUBLE PRECISION  BIG, SMALL, TINY
      INTEGER           I, IERR, J, K, KLAST, KP1, NR
C     .. Local Arrays ..
      CHARACTER*1       P01REC(1)
C     .. External Functions ..
      DOUBLE PRECISION  X02AMF
      INTEGER           P01ABF
      EXTERNAL          X02AMF, P01ABF
C     .. External Subroutines ..
      EXTERNAL          F01QAY, F01QAZ
C     .. Intrinsic Functions ..
      INTRINSIC         MIN, SQRT
C     .. Executable Statements ..
      IERR = IFAIL
      IF (IERR.EQ.0) IFAIL = 1
C
      IF (NRA.LT.M .OR. NRC.LT.M .OR. M.LT.N .OR. N.LT.1) GO TO 100
C
      SMALL = X02AMF()
      TINY = SQRT(SMALL)
      BIG = 1.0D0/SMALL
C
      DO 40 J = 1, N
         DO 20 I = 1, M
            C(I,J) = A(I,J)
   20    CONTINUE
   40 CONTINUE
C
      IFAIL = 0
      IF (M.EQ.1) RETURN
C
      KLAST = MIN(M-1,N)
      NR = M + 1
      DO 80 K = 1, KLAST
         NR = NR - 1
C
         CALL F01QAY(NR,C(K,K),.FALSE.,Z(K),SMALL,TINY,BIG)
C
         IF (K.EQ.N) RETURN
C
         KP1 = K + 1
         DO 60 J = KP1, N
C
            CALL F01QAZ(NR,C(K,K),Z(K),C(K,J))
C
   60    CONTINUE
   80 CONTINUE
C
      RETURN
C
  100 IFAIL = P01ABF(IERR,IFAIL,SRNAME,0,P01REC)
      RETURN
      END

      SUBROUTINE F01QAW(N,X,XMUL,Y,UNDFLW)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (ROWOP2)
C
C     F01QAW RETURNS THE N ELEMENT VECTOR Z GIVEN BY
C
C     Z = X - XMUL*Y ,
C
C     WHERE XMUL IS A REAL VALUE AND X AND Y ARE N ELEMENT
C     VECTORS.
C
C     Z IS OVERWRITTEN ON X.
C
C     N MUST BE AT LEAST 1.
C
C     UNDFLW MUST BE THE VALUE RETURNED BY X02DAF
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  XMUL
      INTEGER           N
      LOGICAL           UNDFLW
C     .. Array Arguments ..
      DOUBLE PRECISION  X(N), Y(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  AMUL, W
      INTEGER           I
C     .. External Functions ..
      DOUBLE PRECISION  X02AMF
      EXTERNAL          X02AMF
C     .. Intrinsic Functions ..
      INTRINSIC         ABS
C     .. Executable Statements ..
      IF (XMUL.EQ.0.0D0) RETURN
C
      IF (UNDFLW) GO TO 60
C
   20 DO 40 I = 1, N
         X(I) = X(I) - XMUL*Y(I)
   40 CONTINUE
C
      RETURN
C
   60 AMUL = ABS(XMUL)
      IF (AMUL.GE.1.0D0) GO TO 20
      W = X02AMF()/AMUL
C
      DO 80 I = 1, N
         IF (ABS(Y(I)).LT.W) GO TO 80
         X(I) = X(I) - XMUL*Y(I)
   80 CONTINUE
C
      RETURN
      END

      DOUBLE PRECISION FUNCTION F01QAX(NR,N,V,PLUS,X,Y,UNDFLW)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (DOTPRD)
C
C     F01QAX RETURNS THE VALUE
C
C     F01QAX = ( V + (X**T)*Y , WHEN PLUS = .TRUE.
C              (
C              ( V - (X**T)*Y , WHEN PLUS = .FALSE. ,
C
C     WHERE V IS A REAL VALUE AND X AND Y ARE N ELEMENT VECTORS.
C
C     IF N IS LESS THAN UNITY THEN F01QAX IS RETURNED AS V.
C
C     NR MUST BE AT LEAST MAX(1,N).
C
C     UNDFLW MUST BE THE VALUE RETURNED BY X02DAF
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION                 V
      INTEGER                          N, NR
      LOGICAL                          PLUS, UNDFLW
C     .. Array Arguments ..
      DOUBLE PRECISION                 X(NR), Y(NR)
C     .. Local Scalars ..
      DOUBLE PRECISION                 ABSXI, SMALL, SUM
      INTEGER                          I
C     .. External Functions ..
      DOUBLE PRECISION                 X02AMF
      EXTERNAL                         X02AMF
C     .. Intrinsic Functions ..
      INTRINSIC                        ABS
C     .. Executable Statements ..
      SUM = V
C
      IF (N.LT.1) GO TO 80
C
      IF (UNDFLW) GO TO 100
C
      IF (PLUS) GO TO 40
C
      DO 20 I = 1, N
         SUM = SUM - X(I)*Y(I)
   20 CONTINUE
C
      F01QAX = SUM
C
      RETURN
C
   40 DO 60 I = 1, N
         SUM = SUM + X(I)*Y(I)
   60 CONTINUE
C
   80 F01QAX = SUM
C
      RETURN
C
  100 SMALL = X02AMF()
C
      IF (PLUS) GO TO 160
C
      DO 140 I = 1, N
         ABSXI = ABS(X(I))
         IF (ABSXI.GE.1.0D0 .OR. ABSXI.EQ.0.0D0) GO TO 120
         IF (ABS(Y(I)).LT.SMALL/ABSXI) GO TO 140
  120    SUM = SUM - X(I)*Y(I)
  140 CONTINUE
C
      F01QAX = SUM
C
      RETURN
C
  160 DO 200 I = 1, N
         ABSXI = ABS(X(I))
         IF (ABSXI.GE.1.0D0 .OR. ABSXI.EQ.0.0D0) GO TO 180
         IF (ABS(Y(I)).LT.SMALL/ABSXI) GO TO 200
  180    SUM = SUM + X(I)*Y(I)
  200 CONTINUE
C
      F01QAX = SUM
C
      RETURN
      END

      SUBROUTINE F01QAY(N,X,NORM,Z1,SMALL,TINY,BIG)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (HOUSH0)
C
C     F01QAY FORMS DETAILS OF THE HOUSEHOLDER TRANSFORMATION
C
C     Y = (I-2*U*(U**T))*X ,  (U**T)*U = 1 ,
C
C     WHERE X IS AN N ELEMENT VECTOR AND THE N ELEMENT VECTOR
C     U IS CHOSEN SO THAT
C
C     Y(I) = 0 , I=2,3,...,N .
C
C     IN PLACE OF U THE ROUTINE ACTUALLY COMPUTES THE VECTOR Z
C     GIVEN BY
C
C     Z = (2*U(1))*U , SO THAT  2*U*(U**T) = (1/Z(1))*Z*(Z**T) .
C
C     THE ELEMENTS Z(2),Z(3),...,Z(N) ARE OVERWRITTEN ON THE
C     ELEMENTS X(2),X(3),...,X(N) RESPECTIVELY AND THE ELEMENT
C     Z(1) IS RETURNED IN Z1.
C
C     Y(1) IS OVERWRITTEN ON X(1).
C
C     N MUST BE AT LEAST 1. IF N=1 THEN AN IMMEDIATE RETURN TO
C     THE CALLING PROGRAM IS MADE.
C
C     NORM MUST BE .TRUE. IF THE EUCLIDEAN NORM OF X IS
C     SUPPLIED IN Z1 AND MUST BE .FALSE. OTHERWISE.
C
C     SMALL, TINY AND BIG MUST BE
C
C     SMALL = X02AMF ,  TINY = SQRT(X02AMF)   AND   BIG = 1.0/X02AMF
C
C     WHERE X02AMF IS THE SMALL VALUE RETURNED FROM ROUTINE X02AMF.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  BIG, SMALL, TINY, Z1
      INTEGER           N
      LOGICAL           NORM
C     .. Array Arguments ..
      DOUBLE PRECISION  X(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  D, P, Q
      INTEGER           I
C     .. External Functions ..
      DOUBLE PRECISION  F04JGV
      EXTERNAL          F04JGV
C     .. Intrinsic Functions ..
      INTRINSIC         ABS
C     .. Executable Statements ..
      IF (N.EQ.1) RETURN
C
      IF (NORM) D = Z1
C
      IF ( .NOT. NORM) D = F04JGV(N,X,TINY,BIG)
C
      Z1 = 2.0D0
      IF (D.EQ.0.0D0) RETURN
C
      Q = 0.0D0
      IF (D.GT.1.0D0) Q = D*SMALL
      IF (X(1).LT.0.0D0) D = -D
C
      DO 20 I = 1, N
         P = 0.0D0
         IF (ABS(X(I)).GE.Q) P = X(I)/D
         X(I) = P
   20 CONTINUE
C
      Z1 = 1.0D0 + X(1)
      X(1) = -D
C
      RETURN
      END

      SUBROUTINE F01QAZ(N,Z,Z1,X)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (HOUSH1)
C
C     F01QAZ RETURNS THE N ELEMENT VECTOR
C
C     Y = (I-(1/Z(1))*Z*(Z**T))*X ,
C
C     WHERE X AND Z ARE N ELEMENT VECTORS.
C
C     Y IS OVERWRITTEN ON X.
C
C     THE VALUE OF Z(1) MUST ACTUALLY BE SUPPLIED IN Z1.
C     THE ELEMENT Z(1) IS NOT REFERENCED.
C
C
C     N MUST BE AT LEAST 1. IF N=1 THEN AN IMMEDIATE RETURN TO
C     THE CALLING PROGRAM IS MADE.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  Z1
      INTEGER           N
C     .. Array Arguments ..
      DOUBLE PRECISION  X(N), Z(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  D
      LOGICAL           UNDFLW
C     .. External Functions ..
      DOUBLE PRECISION  F01QAX
      LOGICAL           X02DAF
      EXTERNAL          F01QAX, X02DAF
C     .. External Subroutines ..
      EXTERNAL          F01QAW
C     .. Executable Statements ..
      IF (N.EQ.1) RETURN
C
      UNDFLW = X02DAF(0.0D0)
C
C     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C     THE CALL TO F01QAX CAN BE REPLACED BY THE FOLLOWING IN-LINE
C     CODE, PROVIDED THAT NO PRECAUTIONS AGAINST UNDERFLOW
C     ARE REQUIRED
C
C     D = X(1)*Z1
C     DO 20 I=2,N
C        D = D + Z(I)*X(I)
C     20 CONTINUE
C
C     IN THIS CASE THE DECLARATION
C
C     REAL F01QAX
C
C     MUST ALSO BE REMOVED.
C
      D = F01QAX(N-1,N-1,X(1)*Z1,.TRUE.,Z(2),X(2),UNDFLW)
C
C     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      X(1) = X(1) - D
C
C     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C     THE CALL TO F01QAW CAN BE REPLACED BY THE FOLLOWING IN-LINE
C     CODE, PROVIDED THAT NO PRECAUTIONS AGAINST UNDERFLOW
C     ARE REQUIRED
C
C     D = D/Z1
C     DO 40 I=2,N
C        X(I) = X(I) - D*Z(I)
C     40 CONTINUE
C
      CALL F01QAW(N-1,X(2),D/Z1,Z(2),UNDFLW)
C
C     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      RETURN
      END

      SUBROUTINE F02SZF(N,D,E,SV,WANTB,B,WANTY,Y,NRY,LY,WANTZ,Z,NRZ,NCZ,
     *                  WORK1,WORK2,WORK3,IFAIL)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 9 REVISED. IER-328 (SEP 1981).
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 12 REVISED. IER-518 (AUG 1986).
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (SVDBID)
C
C     F02SZF RETURNS PART OR ALL OF THE SINGULAR VALUE
C     DECOMPOSITION OF THE N*N UPPER BIDIAGONAL MATRIX A. THAT
C     IS, A IS FACTORIZED AS
C
C     A = Q*DIAG(SV)*(P**T) ,
C
C     WHERE Q AND P ARE N*N ORTHOGONAL MATRICES AND DIAG(SV)
C     IS AN N*N DIAGONAL MATRIX WITH NON-NEGATIVE DIAGONAL
C     ELEMENTS SV(1),SV(2),..., SV(N), THESE BEING THE
C     SINGULAR VALUES OF A.
C
C     IF WANTB IS .TRUE. THEN B RETURNS (Q**T)*B.
C     IF WANTY IS .TRUE. THEN Y RETURNS Y*Q.
C     IF WANTZ IS .TRUE. THEN Z RETURNS (P**T)*Z.
C
C     INPUT PARAMETERS.
C
C     N     - THE ORDER OF THE MATRIX. MUST BE AT LEAST 1.
C
C     D     - N ELEMENT VECTOR SUCH THAT D(I)=A(I,I), I=1,2,...,N.
C             D IS UNALTERED UNLESS ROUTINE IS CALLED WITH SV=D.
C
C     E     - N ELEMENT VECTOR SUCH THAT E(I)=A(I-1,I), I=2,3,...,N.
C             E(1) IS NOT REFERENCED.
C             E IS UNALTERED UNLESS ROUTINE IS CALLED WITH WORK1=E.
C
C     WANTB - MUST BE .TRUE. IF (Q**T)*B IS REQUIRED.
C             IF WANTB IS .FALSE. THEN B IS NOT REFERENCED.
C
C     B     - AN N ELEMENT REAL VECTOR.
C
C     WANTY - MUST BE .TRUE. IF Y*Q IS REQUIRED.
C             IF WANTY IS .FALSE. THEN Y IS NOT REFERENCED.
C
C     Y     - AN LY*N REAL MATRIX.
C
C     NRY   - IF WANTY IS .TRUE. THEN NRY MUST BE THE ROW
C             DIMENSION OF Y AS DECLARED IN THE CALLING
C             PROGRAM AND MUST BE AT LEAST LY.
C
C     LY    - IF WANTY IS .TRUE. THEN LY MUST BE THE NUMBER
C             OF ROWS OF Y AND MUST BE AT LEAST 1.
C
C     WANTZ - MUST BE .TRUE. IF (P**T)*Z IS REQUIRED.
C             IF WANTZ IS .FALSE. THEN Z IS NOT REFERENCED.
C
C     Z     - AN N*NCZ REAL MATRIX.
C
C     NRZ   - IF WANTZ IS .TRUE. THEN NRZ MUST BE THE ROW
C             DIMENSION OF Z AS DECLARED IN THE CALLING
C             PROGRAM AND MUST BE AT LEAST N.
C
C     NCZ   - IF WANTZ IS .TRUE. THEN NCZ MUST BE THE
C             NUMBER OF COLUMNS OF Z AND MUST BE AT LEAST
C             1.
C
C     IFAIL - THE USUAL FAILURE PARAMETER. IF IN DOUBT SET
C             IFAIL TO ZERO BEFORE CALLING F02SZF.
C
C     OUTPUT PARAMETERS.
C
C     SV    - N ELEMENT VECTOR CONTAINING THE SINGULAR
C             VALUES OF A. THEY ARE ORDERED SO THAT
C             SV(1).GE.SV(2).GE. ... .GE.SV(N). THE ROUTINE
C             MAY BE CALLED WITH SV=D.
C
C     B     - IF WANTB IS .TRUE. THEN B WILL RETURN THE N
C             ELEMENT VECTOR (Q**T)*B.
C
C     Y     - IF WANTY IS .TRUE. THEN Y WILL RETURN THE
C             LY*N MATRIX Y*Q.
C
C     Z     - IF WANTZ IS .TRUE. THEN Z WILL RETURN THE N*NCZ MATRIX
C             (P**T)*Z.
C
C     IFAIL - ON NORMAL RETURN IFAIL WILL BE ZERO.
C             IN THE UNLIKELY EVENT THAT THE QR-ALGORITHM
C             FAILS TO FIND THE SINGULAR VALUES IN 50*N
C             ITERATIONS THEN IFAIL WILL BE 2 OR MORE AND
C             SUCH THAT SV(1),SV(2),..,SV(IFAIL-1) MAY NOT
C             HAVE BEEN FOUND. SEE WORK1 BELOW. THIS
C             FAILURE IS NOT LIKELY TO OCCUR.
C             IF AN INPUT PARAMETER IS INCORRECTLY SUPPLIED
C             THEN IFAIL IS SET TO UNITY.
C
C     WORKSPACE PARAMETERS.
C
C     WORK1 - AN N ELEMENT VECTOR. IF E IS NOT REQUIRED ON
C             RETURN THEN THE ROUTINE MAY BE CALLED WITH
C             WORK1=E. WORK1(1) RETURNS THE TOTAL NUMBER OF
C             ITERATIONS TAKEN BY THE  QR-ALGORITHM. IF
C             IFAIL IS POSITIVE ON RETURN THEN THE MATRIX A
C             IS GIVEN  BY A=Q*C*(P**T) , WHERE C IS THE
C             UPPER BIDIAGONAL MATRIX WITH SV AS ITS
C             DIAGONAL AND WORK1 AS ITS SUPER-DIAGONAL.
C
C     WORK2
C     WORK3 - N ELEMENT VECTORS. IF WANTZ IS .FALSE. THEN WORK2 AND
C             WORK3 ARE NOT REFERENCED.
C
C     .. Parameters ..
      CHARACTER*6       SRNAME
      PARAMETER         (SRNAME='F02SZF')
C     .. Scalar Arguments ..
      INTEGER           IFAIL, LY, N, NCZ, NRY, NRZ
      LOGICAL           WANTB, WANTY, WANTZ
C     .. Array Arguments ..
      DOUBLE PRECISION  B(N), D(N), E(N), SV(N), WORK1(N), WORK2(N),
     *                  WORK3(N), Y(NRY,N), Z(NRZ,NCZ)
C     .. Local Scalars ..
      DOUBLE PRECISION  ANORM, BIG, C, DK, DKM1, DL, EK, EKM1, EPS, F,
     *                  G, RSQTPS, S, SHUFT, SMALL, SQTEPS, SVI, T, X
      INTEGER           I, IERR, ITER, J, JJ, K, KK, L, LL, LM1, LP1,
     *                  MAXIT
C     .. Local Arrays ..
      CHARACTER*1       P01REC(1)
C     .. External Functions ..
      DOUBLE PRECISION  F01LZZ, X02AJF, X02AMF
      INTEGER           P01ABF
      EXTERNAL          F01LZZ, X02AJF, X02AMF, P01ABF
C     .. External Subroutines ..
      EXTERNAL          F01LZW, F01LZY, F02SZZ
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, MAX, SQRT
C     .. Executable Statements ..
      IERR = IFAIL
      IF (IERR.EQ.0) IFAIL = 1
C
      IF (N.LT.1) GO TO 500
      IF (WANTY .AND. (NRY.LT.LY .OR. LY.LT.1)) GO TO 500
      IF (WANTZ .AND. (NRZ.LT.N .OR. NCZ.LT.1)) GO TO 500
C
      SMALL = X02AMF()
      BIG = 1.0D0/SMALL
      EPS = X02AJF()
      SQTEPS = SQRT(EPS)
      RSQTPS = 1.0D0/SQTEPS
C
      ITER = 0
      K = N
      SV(1) = D(1)
      ANORM = ABS(D(1))
      IF (N.EQ.1) GO TO 280
C
      DO 20 I = 2, N
         SV(I) = D(I)
         WORK1(I) = E(I)
         ANORM = MAX(ANORM,ABS(D(I)),ABS(E(I)))
   20 CONTINUE
C
      MAXIT = 50*N
      EPS = EPS*ANORM
C
C     MAXIT IS THE MAXIMUM NUMBER OF ITERATIONS ALLOWED.
C     EPS WILL BE USED TO TEST FOR NEGLIGIBLE ELEMENTS.
C     START MAIN LOOP. ONE SINGULAR VALUE IS FOUND FOR EACH
C     VALUE OF K. K GOES IN OPPOSITE DIRECTION TO KK.
C
      DO 260 KK = 2, N
C
C        NOW TEST FOR SPLITTING. L GOES IN OPPOSITE DIRECTION TO LL.
C
   40    L = K
         DO 60 LL = 2, K
            IF (ABS(WORK1(L)).LE.EPS) GO TO 240
            L = L - 1
            IF (ABS(SV(L)).LT.EPS) GO TO 180
   60    CONTINUE
C
   80    IF (ITER.EQ.MAXIT) GO TO 280
C
C        MAXIT QR-STEPS WITHOUT CONVERGENCE. FAILURE.
C
         ITER = ITER + 1
C
C        NOW DETERMINE SHIFT.
C
         LP1 = L + 1
         DL = SV(L)
         DKM1 = SV(K-1)
         DK = SV(K)
         EKM1 = 0.0D0
         IF (K.NE.2) EKM1 = WORK1(K-1)
         EK = WORK1(K)
         F = (DKM1-DK)*(DKM1+DK) + (EKM1-EK)*(EKM1+EK)
         F = F/(2.0D0*EK*DKM1)
         G = ABS(F)
         IF (G.LE.RSQTPS) G = SQRT(1.0D0+F**2)
         IF (F.LT.0.0D0) G = -G
C
         SHUFT = EK*(EK-DKM1/(F+G))
         F = (DL-DK)*(DL+DK) - SHUFT
         X = DL*WORK1(LP1)
C
C        NOW PERFORM THE QR-STEP AND CHASE ZEROS.
C
         DO 140 I = LP1, K
C
            T = F01LZZ(F,X,SMALL,BIG)
C
            CALL F01LZW(T,C,S,SQTEPS,RSQTPS,BIG)
C
            IF (I.GT.LP1) WORK1(I-1) = C*F + S*X
            F = C*SV(I-1) + S*WORK1(I)
            WORK1(I) = C*WORK1(I) - S*SV(I-1)
            X = S*SV(I)
            SVI = C*SV(I)
C
            IF ( .NOT. WANTZ) GO TO 100
            WORK2(I) = C
            WORK3(I) = S
C
  100       T = F01LZZ(F,X,SMALL,BIG)
C
            CALL F01LZW(T,C,S,SQTEPS,RSQTPS,BIG)
C
            IF (WANTY) CALL F01LZY(LY,C,S,Y(1,I-1),Y(1,I))
C
            IF ( .NOT. WANTB) GO TO 120
            T = B(I)
            B(I) = C*T - S*B(I-1)
            B(I-1) = C*B(I-1) + S*T
C
  120       SV(I-1) = C*F + S*X
            F = C*WORK1(I) + S*SVI
            SV(I) = C*SVI - S*WORK1(I)
C
            IF (I.EQ.K) GO TO 140
            X = S*WORK1(I+1)
            WORK1(I+1) = C*WORK1(I+1)
C
  140    CONTINUE
C
         WORK1(K) = F
         IF ( .NOT. WANTZ) GO TO 40
         DO 160 J = 1, NCZ
C
            CALL F02SZZ(K-L+1,WORK2(L),WORK3(L),Z(L,J))
C
  160    CONTINUE
         GO TO 40
C
C        COME TO NEXT PIECE IF SV(L-1) IS NEGLIGIBLE. FORCE A SPLIT.
C
  180    LM1 = L
         L = L + 1
         X = WORK1(L)
         WORK1(L) = 0.0D0
         DO 220 I = L, K
C
            T = F01LZZ(SV(I),X,SMALL,BIG)
C
            CALL F01LZW(T,C,S,SQTEPS,RSQTPS,BIG)
C
            IF (WANTY) CALL F01LZY(LY,C,-S,Y(1,LM1),Y(1,I))
C
            IF ( .NOT. WANTB) GO TO 200
            T = B(I)
            B(I) = C*T + S*B(LM1)
            B(LM1) = C*B(LM1) - S*T
C
  200       SV(I) = C*SV(I) + S*X
            IF (I.EQ.K) GO TO 220
            X = -S*WORK1(I+1)
            WORK1(I+1) = C*WORK1(I+1)
C
  220    CONTINUE
C
C        IF WE COME HERE WITH L=K THEN A SINGULAR VALUE HAS BEEN
C        FOUND.
C
  240    IF (L.LT.K) GO TO 80
C
         K = K - 1
  260 CONTINUE
C
  280 IFAIL = K - 1
      WORK1(1) = ITER
C
C     NOW MAKE SINGULAR VALUES NON-NEGATIVE.
C     K WILL BE 1 UNLESS FAILURE HAS OCCURED.
C
      DO 320 J = K, N
         IF (SV(J).GE.0.0D0) GO TO 320
C
         SV(J) = -SV(J)
C
         IF (WANTB) B(J) = -B(J)
         IF ( .NOT. WANTY) GO TO 320
         DO 300 I = 1, LY
            Y(I,J) = -Y(I,J)
  300    CONTINUE
C
  320 CONTINUE
C
C     NOW SORT THE SINGULAR VALUES INTO DESCENDING ORDER.
C
      IF (WANTZ) JJ = 0
      DO 400 J = K, N
         S = 0.0D0
         L = J
C
         DO 340 I = J, N
            IF (SV(I).LE.S) GO TO 340
            S = SV(I)
            L = I
  340    CONTINUE
C
         IF (S.EQ.0.0D0) GO TO 420
         IF (WANTZ) WORK2(J) = L
         IF (L.EQ.J) GO TO 400
         IF (WANTZ) JJ = J
C
         SV(L) = SV(J)
         SV(J) = S
         IF ( .NOT. WANTY) GO TO 380
C
         DO 360 I = 1, LY
            T = Y(I,J)
            Y(I,J) = Y(I,L)
            Y(I,L) = T
  360    CONTINUE
C
  380    IF ( .NOT. WANTB) GO TO 400
         T = B(J)
         B(J) = B(L)
         B(L) = T
C
  400 CONTINUE
C
  420 IF ( .NOT. WANTZ) GO TO 480
      IF (JJ.EQ.0) GO TO 480
      DO 460 I = 1, NCZ
         DO 440 J = K, JJ
            L = WORK2(J)
            IF (J.EQ.L) GO TO 440
            T = Z(J,I)
            Z(J,I) = Z(L,I)
            Z(L,I) = T
  440    CONTINUE
  460 CONTINUE
C
  480 IF (IFAIL.EQ.0) RETURN
C
      IFAIL = IFAIL + 1
  500 IFAIL = P01ABF(IERR,IFAIL,SRNAME,0,P01REC)
      RETURN
      END

      SUBROUTINE F02SZZ(N,C,S,X)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (PLRT10)
C
C     F02SZZ RETURNS THE N ELEMENT VECTOR
C
C     Y = R(N-1,N)*R(N-2,N-1)*...*R(1,2)*X ,
C
C     WHERE X IS AN N ELEMENT VECTOR AND R(J-1,J) IS A PLANE
C     ROTATION FOR THE (J-1,J)-PLANE.
C
C     Y IS OVERWRITTEN ON X.
C
C     THE N ELEMENT VECTORS C AND S MUST BE SUCH THAT THE
C     NON-IDENTITY PART OF R(J-1,J) IS GIVEN BY
C
C     R(J-1,J) = (  C(J)  S(J) ) .
C                ( -S(J)  C(J) )
C
C     C(1) AND S(1) ARE NOT REFERENCED.
C
C
C     N MUST BE AT LEAST 1. IF N=1 THEN AN IMMEDIATE RETURN TO
C     THE CALLING PROGRAM IS MADE.
C
C     .. Scalar Arguments ..
      INTEGER           N
C     .. Array Arguments ..
      DOUBLE PRECISION  C(N), S(N), X(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  W
      INTEGER           I
C     .. Executable Statements ..
      IF (N.EQ.1) RETURN
C
      DO 20 I = 2, N
         W = X(I-1)
         X(I-1) = C(I)*W + S(I)*X(I)
         X(I) = C(I)*X(I) - S(I)*W
   20 CONTINUE
C
      RETURN
      END

      SUBROUTINE F02WAF(M,N,A,NRA,WANTB,B,SV,WORK,LWORK,IFAIL)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (SVDGN1)
C
C     F02WAF RETURNS PART OF THE SINGULAR VALUE DECOMPOSITION
C     OF THE M*N (M.GE.N) MATRIX A GIVEN BY
C
C     A = Q*(D)*(P**T) ,
C           (0)
C
C     WHERE Q AND P ARE ORTHOGONAL MATRICES AND D IS AN N*N
C     DIAGONAL MATRIX WITH NON-NEGATIVE DIAGONAL ELEMENTS,
C     THESE BEING THE SINGULAR VALUES OF A.
C
C     P**T AND THE DIAGONAL ELEMENTS OF D ARE RETURNED.
C     IF WANTB IS .TRUE. THEN (Q**T)*B IS ALSO RETURNED.
C
C     INPUT PARAMETERS.
C
C     M     - NUMBER OF ROWS OF A. M MUST BE AT LEAST N.
C
C     N     - NUMBER OF COLUMNS OF A. N MUST BE AT LEAST
C             UNITY AND MUST NOT BE LARGER THAN THAN M.
C
C     A     - THE M*N MATRIX TO BE FACTORIZED.
C
C     NRA   - ROW DIMENSION OF A AS DECLARED IN THE CALLING PROGRAM.
C             NRA MUST BE AT LEAST M.
C
C     WANTB - MUST BE .TRUE. IF (Q**T)*B IS REQUIRED.
C             IF WANTB IS .FALSE. THEN B IS NOT REFERENCED.
C
C     B     - AN M ELEMENT VECTOR.
C
C     IFAIL - THE USUAL FAILURE PARAMETER. IF IN DOUBT SET
C             IFAIL TO ZERO BEFORE CALLING F02WAF.
C
C     OUTPUT PARAMETERS.
C
C     A     - THE TOP N*N PART OF A WILL CONTAIN THE N*N ORTHOGONAL
C             MATRIX P**T.
C             THE REMAINING (M-N)*N PART OF A IS USED FOR INTERNAL
C             WORKSPACE.
C
C     B     - IF WANTB IS .TRUE. THEN B IS OVERWRITTEN BY
C             THE M ELEMENT VECTOR (Q**T)*B.
C
C     SV    - N ELEMENT VECTOR CONTAINING THE SINGULAR
C             VALUES OF A. THEY ARE ORDERED SO THAT
C             SV(1).GE.SV(2).GE. ... .GE.SV(N).GE.0.
C
C     IFAIL - ON NORMAL RETURN IFAIL WILL BE ZERO.
C             IN THE UNLIKELY EVENT THAT THE QR-ALGORITHM
C             FAILS TO FIND THE SINGULAR VALUES IN 50*N
C             ITERATIONS THEN IFAIL IS SET TO 2.
C             IF AN INPUT PARAMETER IS INCORRECTLY SUPPLIED
C             THEN IFAIL IS SET TO UNITY.
C
C     WORKSPACE PARAMETERS.
C
C     WORK  - A 3*N ELEMENT VECTOR.
C             WORK(1) RETURNS THE TOTAL NUMBER OF ITERATIONS TAKEN
C             BY THE QR-ALGORITHM.
C
C     LWORK - THE LENGTH OF THE VECTOR WORK. LWORK MUST BE
C             AT LEAST 3*N.
C
C     .. Parameters ..
      CHARACTER*6       SRNAME
      PARAMETER         (SRNAME='F02WAF')
C     .. Scalar Arguments ..
      INTEGER           IFAIL, LWORK, M, N, NRA
      LOGICAL           WANTB
C     .. Array Arguments ..
      DOUBLE PRECISION  A(NRA,N), B(M), SV(N), WORK(LWORK)
C     .. Local Scalars ..
      INTEGER           IERR, NP1, NPNP1
C     .. Local Arrays ..
      CHARACTER*1       P01REC(1)
C     .. External Functions ..
      INTEGER           P01ABF
      EXTERNAL          P01ABF
C     .. External Subroutines ..
      EXTERNAL          F01LZF, F01QAF, F02SZF, F02WAY, F02WAZ
C     .. Executable Statements ..
      IERR = IFAIL
      IF (IERR.EQ.0) IFAIL = 1
C
      IF (NRA.LT.M .OR. M.LT.N .OR. LWORK.LT.3*N .OR. N.LT.1)
     *    GO TO 20
C
      NP1 = N + 1
      NPNP1 = N + NP1
C
      CALL F01QAF(M,N,A,NRA,A,NRA,WORK,IFAIL)
C
      IF (WANTB) CALL F02WAZ(M,N,A,NRA,WORK,B,B)
C
      CALL F01LZF(N,A,NRA,A,NRA,WANTB,B,.FALSE.,.FALSE.,WORK,1,1,
     *            .FALSE.,WORK,1,1,SV,WORK,WORK,WORK,IFAIL)
C
      CALL F02WAY(N,A,NRA,A,NRA)
C
      IFAIL = 1
      CALL F02SZF(N,SV,WORK,SV,WANTB,B,.FALSE.,WORK,1,1,.TRUE.,A,NRA,N,
     *            WORK,WORK(NP1),WORK(NPNP1),IFAIL)
C
      IF (IFAIL.EQ.0) RETURN
C
      IFAIL = 2
   20 IFAIL = P01ABF(IERR,IFAIL,SRNAME,0,P01REC)
      RETURN
      END

      SUBROUTINE F02WAY(N,C,NRC,PT,NRPT)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 12 REVISED. IER-519 (AUG 1986).
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (BIGVPT)
C
C     F02WAY RETURNS THE N*N ORTHOGONAL MATRIX P**T FOR THE
C     FACTORIZATION OF ROUTINE F01LZF.
C
C     DETAILS OF P MUST BE SUPPLIED IN THE N*N MATRIX C AS
C     RETURNED FROM ROUTINE F01LZF.
C
C     NRC AND NRPT MUST BE THE ROW DIMENSIONS OF C AND PT
C     RESPECTIVELY AS DECLARED IN THE CALLING PROGRAM AND MUST
C     EACH BE AT LEAST N.
C
C     THE ROUTINE MAY BE CALLED WITH PT=C.
C
C     .. Scalar Arguments ..
      INTEGER           N, NRC, NRPT
C     .. Array Arguments ..
      DOUBLE PRECISION  C(NRC,N), PT(NRPT,N)
C     .. Local Scalars ..
      DOUBLE PRECISION  BIG, CS, RSQTPS, SN, SQTEPS, T
      INTEGER           I, J, K, KK, KM1, KP1
C     .. External Functions ..
      DOUBLE PRECISION  X02AJF, X02AMF
      EXTERNAL          X02AJF, X02AMF
C     .. External Subroutines ..
      EXTERNAL          F01LZW, F01LZY
C     .. Intrinsic Functions ..
      INTRINSIC         SQRT
C     .. Executable Statements ..
      BIG = 1.0D0/X02AMF()
      SQTEPS = SQRT(X02AJF())
      RSQTPS = 1.0D0/SQTEPS
      DO 15 J = 3, N
         DO 5 I = 1, J - 2
            PT(I,J) = C(I,J)
    5    CONTINUE
   15 CONTINUE
C
      PT(N,N) = 1.0D0
      IF (N.EQ.1) RETURN
C
      PT(N-1,N) = 0.0D0
      PT(N,N-1) = 0.0D0
      PT(N-1,N-1) = 1.0D0
      IF (N.EQ.2) RETURN
C
      K = N
      DO 60 KK = 3, N
         KP1 = K
         K = K - 1
         KM1 = K - 1
         PT(KM1,K) = 0.0D0
C
         DO 20 J = KP1, N
            T = PT(KM1,J)
            PT(KM1,J) = 0.0D0
            IF (T.EQ.0.0D0) GO TO 20
C
            CALL F01LZW(-T,CS,SN,SQTEPS,RSQTPS,BIG)
C
            CALL F01LZY(N-KM1,CS,SN,PT(K,J-1),PT(K,J))
C
   20    CONTINUE
C
         PT(KM1,KM1) = 1.0D0
         DO 40 I = K, N
            PT(I,KM1) = 0.0D0
   40    CONTINUE
C
   60 CONTINUE
C
      RETURN
      END

      SUBROUTINE F02WAZ(M,N,A,NRA,Z,B,C)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (HOURHS)
C
C     F02WAZ RETURNS THE M ELEMENT VECTOR C GIVEN BY
C
C     C = (Q**T)*B ,
C
C     WHERE Q IS AN M*M ORTHOGONAL MATRIX, DETAILS OF WHICH
C     ARE IN THE STRICTLY LOWER TRIANGULAR PART OF A THE M*N
C     (M.GE.N) MATRIX A AND IN THE N ELEMENT VECTOR Z AS
C     RETURNED FROM ROUTINE F01QAF, AND B IS AN M ELEMENT
C     VECTOR.
C
C     THE ROUTINE MAY BE CALLED WITH C=B.
C
C     NRA MUST BE THE ROW DIMENSION OF A AS DECLARED IN THE
C     CALLING PROGRAM AND MUST BE AT LEAST M.
C
C     .. Scalar Arguments ..
      INTEGER           M, N, NRA
C     .. Array Arguments ..
      DOUBLE PRECISION  A(NRA,N), B(M), C(M), Z(N)
C     .. Local Scalars ..
      INTEGER           K, KLAST, NR
C     .. External Subroutines ..
      EXTERNAL          F01QAZ
C     .. Intrinsic Functions ..
      INTRINSIC         MIN
C     .. Executable Statements ..
      DO 20 K = 1, M
         C(K) = B(K)
   20 CONTINUE
C
      IF (M.EQ.1) RETURN
C
      KLAST = MIN(M-1,N)
      NR = M + 1
      DO 40 K = 1, KLAST
         NR = NR - 1
C
         CALL F01QAZ(NR,A(K,K),Z(K),C(K))
C
   40 CONTINUE
C
      RETURN
      END

      INTEGER FUNCTION F02WDY(N,SV,TOL)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (IRKSVD)
C
C     F02WDY RETURNS THE RANK OF AN M*K MATRIX A FOLLOWING A
C     SINGULAR VALUE DECOMPOSITION OF A.
C
C     THE N=MIN(M,K) SINGULAR VALUES OF A MUST BE IN
C     DESCENDING ORDER IN THE N ELEMENT VECTOR SV. THEN F02WDY
C     RETURNS THE LARGEST INTEGER SUCH THAT
C
C     SV(F02WDY) .GT. TOL*SV(1) .
C
C     IF SV(1)=0 THEN F02WDY IS RETURNED AS ZERO.
C
C     IF TOL.LT.EPS OR TOL.GE.1 THEN THE VALUE EPS IS USED IN
C     PLACE OF TOL, WHERE EPS IS THE SMALLEST REAL FOR WHICH
C     1.0+EPS.GT.1.0 ON THE MACHINE. FOR MOST PROBLEMS THIS IS
C     UNREASONABLY SMALL AND TOL SHOULD BE CHOSEN TO
C     APPROXIMATE THE RELATIVE ERRORS IN THE ELEMENTS OF A.
C
C     IF INSTEAD SINGULAR VALUES BELOW SOME VALUE DELTA ARE TO
C     BE REGARDED AS ZERO THEN SUPPLY TOL AS DELTA/SV(1).
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION        TOL
      INTEGER                 N
C     .. Array Arguments ..
      DOUBLE PRECISION        SV(N)
C     .. Local Scalars ..
      DOUBLE PRECISION        DELTA, TL
      INTEGER                 I, IR
C     .. External Functions ..
      DOUBLE PRECISION        X02AJF
      EXTERNAL                X02AJF
C     .. Executable Statements ..
      TL = TOL
      DELTA = X02AJF()
      IF (TL.LT.DELTA .OR. TL.GE.1.0D0) TL = DELTA
C
      IR = 0
      DELTA = TL*SV(1)
C
      DO 20 I = 1, N
         IF (SV(I).LE.DELTA) GO TO 40
         IR = I
   20 CONTINUE
C
   40 F02WDY = IR
      RETURN
      END

      SUBROUTINE F04JAF(M,N,A,NRA,B,TOL,SIGMA,IRANK,WORK,LWORK,IFAIL)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (SVDLS1)
C
C     F04JAF RETURNS THE N ELEMENT VECTOR X, OF MINIMAL
C     LENGTH, THAT MINIMIZES THE EUCLIDEAN LENGTH OF THE M
C     ELEMENT VECTOR R GIVEN BY
C
C     R = B-A*X ,
C
C     WHERE A IS AN M*N (M.GE.N) MATRIX AND B IS AN M ELEMENT
C     VECTOR. X IS OVERWRITTEN ON B.
C
C     THE SOLUTION IS OBTAINED VIA A SINGULAR VALUE
C     DECOMPOSITION (SVD) OF THE MATRIX A GIVEN BY
C
C     A = Q*(D)*(P**T) ,
C           (0)
C
C     WHERE Q AND P ARE ORTHOGONAL AND D IS A DIAGONAL MATRIX WITH
C     NON-NEGATIVE DIAGONAL ELEMENTS, THESE BEING THE SINGULAR
C     VALUES OF A.
C
C     INPUT PARAMETERS.
C
C     M     - NUMBER OF ROWS OF A. M MUST BE AT LEAST N.
C
C     N     - NUMBER OF COLUMNS OF A. N MUST BE AT LEAST UNITY.
C
C     A     - AN M*N REAL MATRIX.
C
C     NRA   - ROW DIMENSION OF A AS DECLARED IN THE CALLING PROGRAM.
C             NRA MUST BE AT LEAST M.
C
C     B     - AN M ELEMENT REAL VECTOR.
C
C     TOL   - A RELATIVE TOLERANCE USED TO DETERMINE THE RANK OF A.
C             TOL SHOULD BE CHOSEN AS APPROXIMATELY THE
C             LARGEST RELATIVE ERROR IN THE ELEMENTS OF A.
C             FOR EXAMPLE IF THE ELEMENTS OF A ARE CORRECT
C             TO ABOUT 4 SIGNIFICANT FIGURES THEN TOL
C             SHOULD BE CHOSEN AS ABOUT 5.0*10.0**(-4).
C
C     IFAIL - THE USUAL FAILURE PARAMETER. IF IN DOUBT SET
C             IFAIL TO ZERO BEFORE CALLING THIS ROUTINE.
C
C     OUTPUT PARAMETERS.
C
C     A     - THE TOP N*N PART OF A WILL CONTAIN THE
C             ORTHOGONAL MATRIX P**T OF THE SVD.
C             THE REMAINDER OF A IS USED FOR INTERNAL WORKSPACE.
C
C     B     - THE FIRST N ELEMENTS OF B WILL CONTAIN THE
C             MINIMAL LEAST SQUARES SOLUTION VECTOR X.
C
C     SIGMA - IF M IS GREATER THAN IRANK THEN SIGMA WILL CONTAIN THE
C             STANDARD ERROR GIVEN BY
C             SIGMA=L(R)/SQRT(M-IRANK), WHERE L(R) DENOTES
C             THE EUCLIDEAN LENGTH OF THE RESIDUAL VECTOR
C             R. IF M=IRANK THEN SIGMA IS RETURNED AS ZERO.
C
C     IRANK - THE RANK OF THE MATRIX A.
C
C     IFAIL - ON NORMAL RETURN IFAIL WILL BE ZERO.
C             IN THE UNLIKELY EVENT THAT THE QR-ALGORITHM
C             FAILS TO FIND THE SINGULAR VALUES IN 50*N
C             ITERATIONS THEN IFAIL IS SET TO 2.
C             IF AN INPUT PARAMETER IS INCORRECTLY SUPPLIED
C             THEN IFAIL IS SET TO UNITY.
C
C     WORKSPACE PARAMETERS.
C
C     WORK  - A 4*N ELEMENT VECTOR.
C             ON RETURN THE FIRST N ELEMENTS OF WORK WILL
C             CONTAIN THE SINGULAR VALUES OF A ARRANGED IN
C             DESCENDING ORDER.
C             WORK(N+1) WILL CONTAIN THE TOTAL NUMBER OF ITERATIONS
C             TAKEN BY THE QR-ALGORITHM.
C
C     LWORK - THE LENGTH OF THE VECTOR WORK. LWORK MUST BE
C             AT LEAST 4*N.
C
C     .. Parameters ..
      CHARACTER*6       SRNAME
      PARAMETER         (SRNAME='F04JAF')
C     .. Scalar Arguments ..
      DOUBLE PRECISION  SIGMA, TOL
      INTEGER           IFAIL, IRANK, LWORK, M, N, NRA
C     .. Array Arguments ..
      DOUBLE PRECISION  A(NRA,N), B(M), WORK(LWORK)
C     .. Local Scalars ..
      INTEGER           IERR, NNN, NP1, NP2
C     .. Local Arrays ..
      CHARACTER*1       P01REC(1)
C     .. External Functions ..
      INTEGER           F02WDY, P01ABF
      EXTERNAL          F02WDY, P01ABF
C     .. External Subroutines ..
      EXTERNAL          F02WAF, F04JAZ
C     .. Executable Statements ..
      IERR = IFAIL
      IF (IERR.EQ.0) IFAIL = 1
C
      IF (NRA.LT.M .OR. M.LT.N .OR. N.LT.1 .OR. LWORK.LT.4*N)
     *    GO TO 20
C
      NP1 = N + 1
      NP2 = NP1 + 1
      NNN = 3*N
C
      CALL F02WAF(M,N,A,NRA,.TRUE.,B,WORK,WORK(NP1),NNN,IFAIL)
C
      IF (IFAIL.NE.0) GO TO 20
C
      IRANK = F02WDY(N,WORK,TOL)
C
      CALL F04JAZ(M,N,IRANK,WORK,N,B,A,NRA,B,SIGMA,WORK(NP2))
C
      RETURN
C
   20 IFAIL = P01ABF(IERR,IFAIL,SRNAME,0,P01REC)
      RETURN
      END

      SUBROUTINE F04JAY(N,IRANK,SV,LSV,B,PT,NRPT,X,WORK)
C     MARK 13 RE-ISSUE. NAG COPYRIGHT 1988.
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (SVDLSQ)
C
C     F04JAY RETURNS THE N ELEMENT VECTOR X GIVEN BY
C
C     X = P*(D**(-1))*B ,
C
C     WHERE D IS AN IRANK*IRANK NON-SINGULAR DIAGONAL MATRIX,
C     P CONTAINS THE FIRST IRANK COLUMNS OF AN N*N ORTHOGONAL
C     MATRIX AND B IS AN IRANK ELEMENT VECTOR.
C
C     THE ROUTINE MAY BE CALLED WITH IRANK=0 IN WHICH CASE X
C     IS RETURNED AS THE ZERO VECTOR.
C
C     INPUT PARAMETERS.
C
C     N     - NUMBER OF ROWS OF P. N MUST BE AT LEAST UNITY.
C
C     IRANK - ORDER OF THE MATRIX D.
C             IF IRANK=0 THEN SV, B, PT AND WORK ARE NOT REFERENCED.
C
C     SV    - AN IRANK ELEMENT VECTOR CONTAINING THE
C             DIAGONAL ELEMENTS OF D. SV MUST BE SUCH THAT
C             NO ELEMENT OF (D**(-1)*B WILL OVERFLOW.
C
C     LSV   - LSV MUST BE AT LEAST MAX(1,IRANK).
C
C     B     - AN IRANK ELEMENT VECTOR.
C
C     PT    - AN IRANK*N ELEMENT MATRIX CONTAINING THE MATRIX P**T.
C
C     NRPT  - ROW DIMENSION OF PT AS DECLARED IN THE
C             CALLING PROGRAM. NRPT MUST BE AT LEAST LSV.
C
C     OUTPUT PARAMETER.
C
C     X     - N ELEMENT VECTOR CONTAINING P*(D**(-1))*B.
C             IF IRANK=0 THEN X RETURNS THE ZERO VECTOR.
C             THE ROUTINE MAY BE CALLED WITH X=B OR WITH X=SV.
C
C     WORKSPACE PARAMETER.
C
C     WORK  - AN LSV ELEMENT VECTOR.
C             IF THE ROUTINE IS NOT CALLED WITH X=B THEN IT MAY BE
C             CALLED WITH WORK=B. SIMILARLY IF THE ROUTINE
C             IS NOT CALLED WITH X=SV THEN IT MAY BE CALLED
C             WITH WORK=SV.
C
C     Modified to call BLAS.
C     Jeremy Du Croz, NAG Central Office, October 1987.
C
C     .. Scalar Arguments ..
      INTEGER           IRANK, LSV, N, NRPT
C     .. Array Arguments ..
      DOUBLE PRECISION  B(LSV), PT(NRPT,N), SV(LSV), WORK(LSV), X(N)
C     .. Local Scalars ..
      INTEGER           I
C     .. External Subroutines ..
      EXTERNAL          DGEMV
C     .. Executable Statements ..
      IF (IRANK.EQ.0) GO TO 40
C
      DO 20 I = 1, IRANK
         WORK(I) = B(I)/SV(I)
   20 CONTINUE
C
      CALL DGEMV('Transpose',IRANK,N,1.0D0,PT,NRPT,WORK,1,0.0D0,X,1)
C
      RETURN
C
   40 DO 60 I = 1, N
         X(I) = 0.0D0
   60 CONTINUE
C
      RETURN
      END

      SUBROUTINE F04JAZ(M,N,IRANK,SV,LSV,B,PT,NRPT,X,SIGMA,WORK)
C     MARK 13 RE-ISSUE. NAG COPYRIGHT 1988.
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (SVDLS0)
C
C     F04JAZ RETURNS THE N ELEMENT VECTOR X, OF MINIMAL
C     LENGTH, THAT MINIMIZES THE EUCLIDEAN LENGTH OF THE M
C     ELEMENT VECTOR R GIVEN BY
C
C     R = B-A*X ,
C
C     WHERE B IS AN M ELEMENT VECTOR AND A IS AN M*N MATRIX,
C     FOLLOWING A SINGULAR VALUE DECOMPOSITION (SVD) OF A
C     GIVEN BY
C
C     A = Q*D*(P**T) ,
C
C     WHERE D IS A RECTANGULAR DIAGONAL MATRIX WHOSE DIAGONAL
C     ELEMENTS CONTAIN THE SINGULAR VALUES OF A IN DESCENDING
C     ORDER.
C
C     INPUT PARAMETERS.
C
C     M     - NUMBER OF ROWS OF A. M MUST BE AT LEAST UNITY.
C
C     N     - NUMBER OF COLUMNS OF A. N MUST BE AT LEAST UNITY.
C
C     IRANK - THE RANK OF THE MATRIX A. IRANK MUST BE SUCH THAT THE
C             ELEMENTS SV(I), I=1,2,...,IRANK ARE NON-NEGLIGIBLE.
C             IRANK MUST BE AT LEAST ZERO AND MUST NOT BE
C             LARGER THAN MIN(M,N).
C             ROUTINE F02WDY CAN BE USED TO DETERMINE RANK FOLLOWING
C             AN SVD.
C
C     SV    - AN LSV ELEMENT VECTOR CONTAINING THE POSITIVE
C             NON-NEGLIGIBLE SINGULAR VALUES OF A.
C
C     LSV   - LENGTH OF THE VECTOR SV.
C             LSV MUST BE AT LEAST MAX(1,IRANK).
C
C     B     - MUST CONTAIN THE M ELEMENT VECTOR (Q**T)*B, WHERE Q IS
C             THE LEFT-HAND ORTHOGONAL MATRIX OF THE SVD.
C
C     PT    - THE IRANK*N PART OF PT MUST CONTAIN THE FIRST
C             IRANK ROWS OF THE RIGHT-HAND ORTHOGONAL
C             MATRIX P**T OF THE SVD.
C
C     NRPT  - ROW DIMENSION OF PT AS DECLARED IN THE CALLING PROGRAM
C             NRPT MUST BE AT LEAST LSV.
C
C     OUTPUT PARAMETERS.
C
C     X     - THE N ELEMENT SOLUTION VECTOR.
C             THE ROUTINE MAY BE CALLED WITH X=B OR WITH X=SV.
C
C     SIGMA - IF M IS GREATER THAN IRANK THEN SIGMA WILL CONTAIN THE
C             STANDARD ERROR GIVEN BY
C             SIGMA=L(R)/SQRT(M-IRANK), WHERE L(R) DENOTES
C             THE EUCLIDEAN LENGTH OF THE RESIDUAL VECTOR
C             R. IF M=IRANK THEN SIGMA IS RETURNED AS ZERO.
C
C     WORKSPACE PARAMETER.
C
C     WORK  - AN LSV ELEMENT VECTOR.
C             IF THE ROUTINE IS NOT CALLED WITH X=B THEN IT MAY BE
C             CALLED WITH WORK=B. SIMILARLY IF THE ROUTINE
C             IS NOT CALLED WITH X=SV THEN IT MAY BE CALLED
C             WITH WORK=SV.
C
C     Modified to call BLAS.
C     Jeremy Du Croz, NAG Central Office, October 1987.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  SIGMA
      INTEGER           IRANK, LSV, M, N, NRPT
C     .. Array Arguments ..
      DOUBLE PRECISION  B(M), PT(NRPT,N), SV(LSV), WORK(LSV), X(N)
C     .. Local Scalars ..
      INTEGER           IRP1, MMIR
C     .. External Functions ..
      DOUBLE PRECISION  F06EJF
      EXTERNAL          F06EJF
C     .. External Subroutines ..
      EXTERNAL          F04JAY
C     .. Intrinsic Functions ..
      INTRINSIC         DBLE, SQRT
C     .. Executable Statements ..
      SIGMA = 0.0D0
      IF (IRANK.EQ.M) GO TO 20
      IRP1 = IRANK + 1
      MMIR = M - IRANK
C
      SIGMA = F06EJF(MMIR,B(IRP1),1)/SQRT(DBLE(MMIR))
C
   20 CALL F04JAY(N,IRANK,SV,LSV,B,PT,NRPT,X,WORK)
C
      RETURN
      END

      SUBROUTINE F04JGT(N,X,SCALE,SUMSQ,TINY,UNDFLW)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (SCLSQS)
C
C     F04JGT RETURNS THE VALUES SCL AND SUM SUCH THAT
C
C     (SCL**2)*SUM = X(1)**2+X(2)**2+...+X(N)**2+(SCALE**2)*SUMSQ .
C
C     SCL IS OVERWRITTEN ON SCALE AND SUM IS OVERWRITTEN ON SUMSQ.
C
C     THE SUPPLIED VALUE OF SUMSQ IS ASSUMED TO BE AT LEAST
C     UNITY IN WHICH CASE SUM WILL SATISFY THE BOUNDS
C
C     1.0 .LE. SUM .LE. SUMSQ+N .
C
C     ONLY ONE PASS THROUGH THE VECTOR X IS MADE.
C
C     TINY MUST BE SUCH THAT
C
C     TINY = SQRT(X02AMF) ,
C
C     WHERE X02AMF IS THE SMALL VALUE RETURNED FROM ROUTINE X02AMF.
C
C     UNDFLW MUST BE THE VALUE RETURNED BY X02DAF
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  SCALE, SUMSQ, TINY
      INTEGER           N
      LOGICAL           UNDFLW
C     .. Array Arguments ..
      DOUBLE PRECISION  X(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  ABSXI, Q
      INTEGER           I
C     .. Intrinsic Functions ..
      INTRINSIC         ABS
C     .. Executable Statements ..
      IF (UNDFLW) GO TO 60
C
      DO 40 I = 1, N
         IF (X(I).EQ.0.0D0) GO TO 40
C
         ABSXI = ABS(X(I))
         IF (SCALE.GE.ABSXI) GO TO 20
C
         SUMSQ = 1.0D0 + SUMSQ*(SCALE/ABSXI)**2
         SCALE = ABSXI
         GO TO 40
C
   20    SUMSQ = SUMSQ + (ABSXI/SCALE)**2
C
   40 CONTINUE
C
      RETURN
C
   60 DO 100 I = 1, N
         IF (X(I).EQ.0.0D0) GO TO 100
C
         ABSXI = ABS(X(I))
         Q = 0.0D0
         IF (SCALE.LT.ABSXI) GO TO 80
C
         IF (SCALE.GT.TINY) Q = SCALE*TINY
         IF (ABSXI.GE.Q) SUMSQ = SUMSQ + (ABSXI/SCALE)**2
         GO TO 100
C
   80    IF (ABSXI.GT.TINY) Q = ABSXI*TINY
         IF (SCALE.GE.Q) SUMSQ = 1.0D0 + SUMSQ*(SCALE/ABSXI)**2
         SCALE = ABSXI
C
  100 CONTINUE
C
      RETURN
      END

      DOUBLE PRECISION FUNCTION F04JGU(SCALE,SUMSQ,BIG)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (TWONRM)
C
C     F04JGU RETURNS THE VALUE
C
C     F04JGU = SCALE*SQRT(SUMSQ) .
C
C     SCALE IS ASSUMED TO BE NON-NEGATIVE AND SUMSQ IS ASSUMED
C     TO BE AT LEAST UNITY.
C
C     BIG MUST BE GIVEN BY
C
C     BIG = 1.0/X02AMF ,
C
C     WHERE X02AMF IS THE SMALL REAL VALUE RETURNED FROM
C     ROUTINE X02AMF.
C
C     F04JGU IS USED IN CONJUNCTION WITH F04JGT BY VARIOUS
C     EUCLIDEAN NORM ROUTINES.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION                 BIG, SCALE, SUMSQ
C     .. Intrinsic Functions ..
      INTRINSIC                        SQRT
C     .. Executable Statements ..
      IF (SCALE.GE.BIG/SUMSQ) GO TO 20
      F04JGU = SCALE*SQRT(SUMSQ)
      RETURN
C
   20 F04JGU = BIG
      RETURN
      END

      DOUBLE PRECISION FUNCTION F04JGV(N,X,TINY,BIG)
C     MARK 8 RELEASE. NAG COPYRIGHT 1979.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 13 REVISED. USE OF MARK 12 X02 FUNCTIONS (APR 1988).
C     WRITTEN BY S. HAMMARLING, MIDDLESEX POLYTECHNIC (VENORM)
C
C     REAL FUNCTION F04JGV RETURNS THE VALUE OF THE EUCLIDEAN
C     LENGTH OF THE N ELEMENT VECTOR X. F04JGV IS DEFINED AS
C
C     F04JGV = SQRT(X(1)**2+X(2)**2+...+X(N)**2).
C
C     TINY AND BIG MUST BE GIVEN BY
C
C     TINY = SQRT(X02AMF)   AND   BIG = 1.0/X02AMF
C
C     WHERE X02AMF IS THE SMALL REAL VALUE RETURNED FROM
C     ROUTINE X02AMF.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION                 BIG, TINY
      INTEGER                          N
C     .. Array Arguments ..
      DOUBLE PRECISION                 X(N)
C     .. Local Scalars ..
      DOUBLE PRECISION                 SCALE, SUMSQ
C     .. External Functions ..
      DOUBLE PRECISION                 F04JGU
      LOGICAL                          X02DAF
      EXTERNAL                         F04JGU, X02DAF
C     .. External Subroutines ..
      EXTERNAL                         F04JGT
C     .. Executable Statements ..
      SCALE = 0.0D0
      SUMSQ = 1.0D0
C
      CALL F04JGT(N,X,SCALE,SUMSQ,TINY,X02DAF(0.0D0))
C
      F04JGV = F04JGU(SCALE,SUMSQ,BIG)
C
      RETURN
      END

      SUBROUTINE F06AAZ ( SRNAME, INFO )
C     MARK 12 RELEASE. NAG COPYRIGHT 1986.
C     .. Scalar Arguments ..
      INTEGER            INFO
      CHARACTER*13       SRNAME
C     ..
C
C  Purpose
C  =======
C
C  F06AAZ  is an error handler for the Level 2 BLAS routines.
C
C  It is called by the Level 2 BLAS routines if an input parameter is
C  invalid.
C
C  Parameters
C  ==========
C
C  SRNAME - CHARACTER*13.
C           On entry, SRNAME specifies the name of the routine which
C           called F06AAZ.
C
C  INFO   - INTEGER.
C           On entry, INFO specifies the position of the invalid
C           parameter in the parameter-list of the calling routine.
C
C
C  Auxiliary routine for Level 2 Blas.
C
C  Written on 20-July-1986.
C
C     .. Local Scalars ..
      INTEGER            IFAIL
      CHARACTER*80       REC (1)
C     .. External Functions ..
      INTEGER            P01ABF
      EXTERNAL           P01ABF
C     ..
C     .. Executable Statements ..
      WRITE (REC (1),99999) SRNAME, INFO
      IFAIL = 0
      IFAIL = P01ABF (IFAIL, -1, SRNAME(1:6), 1, REC)
C
      RETURN
C
99999 FORMAT ( ' ** On entry to ', A13, ' parameter number ', I2,
     $         ' had an illegal value' )
C
C     End of F06AAZ.
C
      END

      DOUBLE PRECISION FUNCTION F06BMF( SCALE, SSQ )
C     MARK 12 RELEASE. NAG COPYRIGHT 1986.
C     .. Scalar Arguments ..
      DOUBLE PRECISION                  SCALE, SSQ
C     ..
C
C  F06BMF returns the value norm given by
C
C     norm = ( scale*sqrt( ssq ), scale*sqrt( ssq ) .lt. flmax
C            (
C            ( flmax,             scale*sqrt( ssq ) .ge. flmax
C
C  via the function name.
C
C
C  Nag Fortran 77 O( 1 ) basic linear algebra routine.
C
C  -- Written on 22-October-1982.
C     Sven Hammarling, Nag Central Office.
C
C
C     .. Local Scalars ..
      DOUBLE PRECISION      FLMAX, FLMIN, NORM, SQT
      LOGICAL               FIRST
C     .. External Functions ..
      DOUBLE PRECISION      X02AMF
      EXTERNAL              X02AMF
C     .. Intrinsic Functions ..
      INTRINSIC             SQRT
C     .. Save statement ..
      SAVE                  FIRST, FLMAX
C     .. Data statements ..
      DATA                  FIRST/ .TRUE. /
C     ..
C     .. Executable Statements ..
      IF( FIRST )THEN
         FIRST = .FALSE.
         FLMIN =  X02AMF( )
         FLMAX =  1/FLMIN
      END IF
C
      SQT = SQRT( SSQ )
      IF( SCALE.LT.FLMAX/SQT )THEN
         NORM = SCALE*SQT
      ELSE
         NORM = FLMAX
      END IF
C
      F06BMF = NORM
      RETURN
C
C     End of F06BMF. ( SNORM )
C
      END

      DOUBLE PRECISION FUNCTION F06EJF( N, X, INCX )
C     MARK 12 RELEASE. NAG COPYRIGHT 1986.
C     .. Entry Points ..
      DOUBLE PRECISION          DNRM2
      ENTRY                     DNRM2 ( N, X, INCX )
C     .. Scalar Arguments ..
      INTEGER                           INCX, N
C     .. Array Arguments ..
      DOUBLE PRECISION                  X( * )
C     ..
C
C  F06EJF returns the euclidean norm of a vector via the function
C  name, so that
C
C     F06EJF := sqrt( x'*x )
C
C
C  Nag Fortran 77 version of the Blas routine DNRM2.
C  Nag Fortran 77 O( n ) basic linear algebra routine.
C
C  -- Written on 25-October-1982.
C     Sven Hammarling, Nag Central Office.
C
C
C     .. Parameters ..
      DOUBLE PRECISION      ONE         , ZERO
      PARAMETER           ( ONE = 1.0D+0, ZERO = 0.0D+0 )
C     .. Local Scalars ..
      DOUBLE PRECISION      NORM, SCALE, SSQ
C     .. External Functions ..
      DOUBLE PRECISION      F06BMF
      EXTERNAL              F06BMF
C     .. External Subroutines ..
      EXTERNAL              F06FJF
C     .. Intrinsic Functions ..
      INTRINSIC             ABS
C     ..
C     .. Executable Statements ..
      IF( N.LT.1 )THEN
         NORM  = ZERO
      ELSE IF( N.EQ.1 )THEN
         NORM  = ABS( X( 1 ) )
      ELSE
         SCALE = ZERO
         SSQ   = ONE
         CALL F06FJF( N, X, INCX, SCALE, SSQ )
         NORM  = F06BMF( SCALE, SSQ )
      END IF
C
      F06EJF = NORM
      RETURN
C
C     End of F06EJF. ( DNRM2 )
C
      END

      SUBROUTINE F06FJF( N, X, INCX, SCALE, SUMSQ )
C     MARK 12 RELEASE. NAG COPYRIGHT 1986.
C     .. Scalar Arguments ..
      DOUBLE PRECISION   SCALE, SUMSQ
      INTEGER            INCX, N
C     .. Array Arguments ..
      DOUBLE PRECISION   X( * )
C     ..
C
C  F06FJF returns the values scl and smsq such that
C
C     ( scl**2 )*smsq = x( 1 )**2 +...+ x( n )**2 + ( scale**2 )*sumsq,
C
C  where x( i ) = X( 1 + ( i - 1 )*INCX ). The value of sumsq is assumed
C  to be at least unity and the value of smsq will then satisfy
C
C     1.0 .le. smsq .le. ( sumsq + n ) .
C
C  scale is assumed to be non-negative and scl returns the value
C
C     scl = max( scale, abs( x( i ) ) ) .
C
C  scale and sumsq must be supplied in SCALE and SUMSQ respectively.
C  scl and smsq are overwritten on SCALE and SUMSQ respectively.
C
C  The routine makes only one pass through the vector X.
C
C
C  Nag Fortran 77 O( n ) basic linear algebra routine.
C
C  -- Written on 22-October-1982.
C     Sven Hammarling, Nag Central Office.
C
C
C     .. Parameters ..
      DOUBLE PRECISION   ZERO
      PARAMETER        ( ZERO = 0.0D+0 )
C     .. Local Scalars ..
      DOUBLE PRECISION   ABSXI
      INTEGER            IX
C     .. Intrinsic Functions ..
      INTRINSIC          ABS
C     ..
C     .. Executable Statements ..
      IF( N.GT.0 )THEN
         DO 10, IX = 1, 1 + ( N - 1 )*INCX, INCX
            IF( X( IX ).NE.ZERO )THEN
               ABSXI = ABS( X( IX ) )
               IF( SCALE.LT.ABSXI )THEN
                  SUMSQ = 1     + SUMSQ*( SCALE/ABSXI )**2
                  SCALE = ABSXI
               ELSE
                  SUMSQ = SUMSQ +       ( ABSXI/SCALE )**2
               END IF
            END IF
   10    CONTINUE
      END IF
      RETURN
C
C     End of F06FJF. ( SSSQ )
C
      END

      SUBROUTINE F06PAF( TRANS, M, N, ALPHA, A, LDA, X, INCX,
     $                   BETA, Y, INCY )
C     MARK 13 RE-ISSUE. NAG COPYRIGHT 1988.
C     .. Entry Points ..
      ENTRY      DGEMV ( TRANS, M, N, ALPHA, A, LDA, X, INCX,
     $                   BETA, Y, INCY )
C     .. Scalar Arguments ..
      DOUBLE PRECISION   ALPHA, BETA
      INTEGER            INCX, INCY, LDA, M, N
      CHARACTER*1        TRANS
C     .. Array Arguments ..
      DOUBLE PRECISION   A( LDA, * ), X( * ), Y( * )
C     ..
C
C  Purpose
C  =======
C
C  DGEMV  performs one of the matrix-vector operations
C
C     y := alpha*A*x + beta*y,   or   y := alpha*A'*x + beta*y,
C
C  where alpha and beta are scalars, x and y are vectors and A is an
C  m by n matrix.
C
C  Parameters
C  ==========
C
C  TRANS  - CHARACTER*1.
C           On entry, TRANS specifies the operation to be performed as
C           follows:
C
C              TRANS = 'N' or 'n'   y := alpha*A*x + beta*y.
C
C              TRANS = 'T' or 't'   y := alpha*A'*x + beta*y.
C
C              TRANS = 'C' or 'c'   y := alpha*A'*x + beta*y.
C
C           Unchanged on exit.
C
C  M      - INTEGER.
C           On entry, M specifies the number of rows of the matrix A.
C           M must be at least zero.
C           Unchanged on exit.
C
C  N      - INTEGER.
C           On entry, N specifies the number of columns of the matrix A.
C           N must be at least zero.
C           Unchanged on exit.
C
C  ALPHA  - DOUBLE PRECISION.
C           On entry, ALPHA specifies the scalar alpha.
C           Unchanged on exit.
C
C  A      - DOUBLE PRECISION array of DIMENSION ( LDA, n ).
C           Before entry, the leading m by n part of the array A must
C           contain the matrix of coefficients.
C           Unchanged on exit.
C
C  LDA    - INTEGER.
C           On entry, LDA specifies the first dimension of A as declared
C           in the calling (sub) program. LDA must be at least
C           max( 1, m ).
C           Unchanged on exit.
C
C  X      - DOUBLE PRECISION array of DIMENSION at least
C           ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n'
C           and at least
C           ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.
C           Before entry, the incremented array X must contain the
C           vector x.
C           Unchanged on exit.
C
C  INCX   - INTEGER.
C           On entry, INCX specifies the increment for the elements of
C           X. INCX must not be zero.
C           Unchanged on exit.
C
C  BETA   - DOUBLE PRECISION.
C           On entry, BETA specifies the scalar beta. When BETA is
C           supplied as zero then Y need not be set on input.
C           Unchanged on exit.
C
C  Y      - DOUBLE PRECISION array of DIMENSION at least
C           ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n'
C           and at least
C           ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.
C           Before entry with BETA non-zero, the incremented array Y
C           must contain the vector y. On exit, Y is overwritten by the
C           updated vector y.
C
C  INCY   - INTEGER.
C           On entry, INCY specifies the increment for the elements of
C           Y. INCY must not be zero.
C           Unchanged on exit.
C
C
C  Level 2 Blas routine.
C
C  -- Written on 22-October-1986.
C     Jack Dongarra, Argonne National Lab.
C     Jeremy Du Croz, Nag Central Office.
C     Sven Hammarling, Nag Central Office.
C     Richard Hanson, Sandia National Labs.
C
C
C     .. Parameters ..
      DOUBLE PRECISION   ONE         , ZERO
      PARAMETER        ( ONE = 1.0D+0, ZERO = 0.0D+0 )
C     .. Local Scalars ..
      DOUBLE PRECISION   TEMP
      INTEGER            I, INFO, IX, IY, J, JX, JY, KX, KY, LENX, LENY
C     .. External Subroutines ..
      EXTERNAL           F06AAZ
C     .. Intrinsic Functions ..
      INTRINSIC          MAX
C     ..
C     .. Executable Statements ..
C
C     Test the input parameters.
C
      INFO = 0
      IF     ( .NOT.(TRANS.EQ.'N' .OR. TRANS.EQ.'n').AND.
     $         .NOT.(TRANS.EQ.'T' .OR. TRANS.EQ.'t').AND.
     $         .NOT.(TRANS.EQ.'C' .OR. TRANS.EQ.'c')      )THEN
         INFO = 1
      ELSE IF( M.LT.0 )THEN
         INFO = 2
      ELSE IF( N.LT.0 )THEN
         INFO = 3
      ELSE IF( LDA.LT.MAX( 1, M ) )THEN
         INFO = 6
      ELSE IF( INCX.EQ.0 )THEN
         INFO = 8
      ELSE IF( INCY.EQ.0 )THEN
         INFO = 11
      END IF
      IF( INFO.NE.0 )THEN
         CALL F06AAZ( 'F06PAF/DGEMV ', INFO )
         RETURN
      END IF
C
C     Quick return if possible.
C
      IF( ( M.EQ.0 ).OR.( N.EQ.0 ).OR.
     $    ( ( ALPHA.EQ.ZERO ).AND.( BETA.EQ.ONE ) ) )
     $   RETURN
C
C     Set  LENX  and  LENY, the lengths of the vectors x and y, and set
C     up the start points in  X  and  Y.
C
      IF( (TRANS.EQ.'N' .OR. TRANS.EQ.'n') )THEN
         LENX = N
         LENY = M
      ELSE
         LENX = M
         LENY = N
      END IF
      IF( INCX.GT.0 )THEN
         KX = 1
      ELSE
         KX = 1 - ( LENX - 1 )*INCX
      END IF
      IF( INCY.GT.0 )THEN
         KY = 1
      ELSE
         KY = 1 - ( LENY - 1 )*INCY
      END IF
C
C     Start the operations. In this version the elements of A are
C     accessed sequentially with one pass through A.
C
C     First form  y := beta*y.
C
      IF( BETA.NE.ONE )THEN
         IF( INCY.EQ.1 )THEN
            IF( BETA.EQ.ZERO )THEN
               DO 10, I = 1, LENY
                  Y( I ) = ZERO
   10          CONTINUE
            ELSE
               DO 20, I = 1, LENY
                  Y( I ) = BETA*Y( I )
   20          CONTINUE
            END IF
         ELSE
            IY = KY
            IF( BETA.EQ.ZERO )THEN
               DO 30, I = 1, LENY
                  Y( IY ) = ZERO
                  IY      = IY   + INCY
   30          CONTINUE
            ELSE
               DO 40, I = 1, LENY
                  Y( IY ) = BETA*Y( IY )
                  IY      = IY           + INCY
   40          CONTINUE
            END IF
         END IF
      END IF
      IF( ALPHA.EQ.ZERO )
     $   RETURN
      IF( (TRANS.EQ.'N' .OR. TRANS.EQ.'n') )THEN
C
C        Form  y := alpha*A*x + y.
C
         JX = KX
         IF( INCY.EQ.1 )THEN
            DO 60, J = 1, N
               IF( X( JX ).NE.ZERO )THEN
                  TEMP = ALPHA*X( JX )
                  DO 50, I = 1, M
                     Y( I ) = Y( I ) + TEMP*A( I, J )
   50             CONTINUE
               END IF
               JX = JX + INCX
   60       CONTINUE
         ELSE
            DO 80, J = 1, N
               IF( X( JX ).NE.ZERO )THEN
                  TEMP = ALPHA*X( JX )
                  IY   = KY
                  DO 70, I = 1, M
                     Y( IY ) = Y( IY ) + TEMP*A( I, J )
                     IY      = IY      + INCY
   70             CONTINUE
               END IF
               JX = JX + INCX
   80       CONTINUE
         END IF
      ELSE
C
C        Form  y := alpha*A'*x + y.
C
         JY = KY
         IF( INCX.EQ.1 )THEN
            DO 100, J = 1, N
               TEMP = ZERO
               DO 90, I = 1, M
                  TEMP = TEMP + A( I, J )*X( I )
   90          CONTINUE
               Y( JY ) = Y( JY ) + ALPHA*TEMP
               JY      = JY      + INCY
  100       CONTINUE
         ELSE
            DO 120, J = 1, N
               TEMP = ZERO
               IX   = KX
               DO 110, I = 1, M
                  TEMP = TEMP + A( I, J )*X( IX )
                  IX   = IX   + INCX
  110          CONTINUE
               Y( JY ) = Y( JY ) + ALPHA*TEMP
               JY      = JY      + INCY
  120       CONTINUE
         END IF
      END IF
C
      RETURN
C
C     End of F06PAF (DGEMV ).
C
      END

      INTEGER FUNCTION P01ABF(IFAIL,IERROR,SRNAME,NREC,REC)
C     MARK 11.5(F77) RELEASE. NAG COPYRIGHT 1986.
C     MARK 13 REVISED. IER-621 (APR 1988).
C     MARK 13B REVISED. IER-668 (AUG 1988).
C
C     P01ABF is the error-handling routine for the NAG Library.
C
C     P01ABF either returns the value of IERROR through the routine
C     name (soft failure), or terminates execution of the program
C     (hard failure). Diagnostic messages may be output.
C
C     If IERROR = 0 (successful exit from the calling routine),
C     the value 0 is returned through the routine name, and no
C     message is output
C
C     If IERROR is non-zero (abnormal exit from the calling routine),
C     the action taken depends on the value of IFAIL.
C
C     IFAIL =  1: soft failure, silent exit (i.e. no messages are
C                 output)
C     IFAIL = -1: soft failure, noisy exit (i.e. messages are output)
C     IFAIL =-13: soft failure, noisy exit but standard messages from
C                 P01ABF are suppressed
C     IFAIL =  0: hard failure, noisy exit
C
C     For compatibility with certain routines included before Mark 12
C     P01ABF also allows an alternative specification of IFAIL in which
C     it is regarded as a decimal integer with least significant digits
C     cba. Then
C
C     a = 0: hard failure  a = 1: soft failure
C     b = 0: silent exit   b = 1: noisy exit
C
C     except that hard failure now always implies a noisy exit.
C
C     S.Hammarling, M.P.Hooper and J.J.du Croz, NAG Central Office.
C
C     .. Scalar Arguments ..
      INTEGER                 IERROR, IFAIL, NREC
      CHARACTER*(*)           SRNAME
C     .. Array Arguments ..
      CHARACTER*(*)           REC(*)
C     .. Local Scalars ..
      INTEGER                 I, NERR
      CHARACTER*72            MESS
C     .. External Subroutines ..
      EXTERNAL                P01ABZ, X04AAF, X04BAF
C     .. Intrinsic Functions ..
      INTRINSIC               ABS, MOD
C     .. Executable Statements ..
      IF (IERROR.NE.0) THEN
C        Abnormal exit from calling routine
         IF (IFAIL.EQ.-1 .OR. IFAIL.EQ.0 .OR. IFAIL.EQ.-13 .OR.
     *       (IFAIL.GT.0 .AND. MOD(IFAIL/10,10).NE.0)) THEN
C           Noisy exit
            CALL X04AAF(0,NERR)
            DO 20 I = 1, NREC
               CALL X04BAF(NERR,REC(I))
   20       CONTINUE
            IF (IFAIL.NE.-13) THEN
               WRITE (MESS,FMT=99999) SRNAME, IERROR
               CALL X04BAF(NERR,MESS)
               IF (ABS(MOD(IFAIL,10)).NE.1) THEN
C                 Hard failure
                  CALL X04BAF(NERR,
     *                     ' ** NAG hard failure - execution terminated'
     *                        )
                  CALL P01ABZ
               ELSE
C                 Soft failure
                  CALL X04BAF(NERR,
     *                        ' ** NAG soft failure - control returned')
               END IF
            END IF
         END IF
      END IF
      P01ABF = IERROR
      RETURN
C
99999 FORMAT (' ** ABNORMAL EXIT from NAG Library routine ',A,': IFAIL',
     *  ' =',I6)
      END

      SUBROUTINE P01ABZ
C     MARK 11.5(F77) RELEASE. NAG COPYRIGHT 1986.
C
C     Terminates execution when a hard failure occurs.
C
C     ******************** IMPLEMENTATION NOTE ********************
C     The following STOP statement may be replaced by a call to an
C     implementation-dependent routine to display a message and/or
C     to abort the program.
C     *************************************************************
C     .. Executable Statements ..
      STOP
      END

      DOUBLE PRECISION FUNCTION X02AJF()
C     MARK 12 RELEASE. NAG COPYRIGHT 1986.
C
C     RETURNS  (1/2)*B**(1-P)  IF ROUNDS IS .TRUE.
C     RETURNS  B**(1-P)  OTHERWISE
C
C     .. Executable Statements ..
C     IN THEORY THIS SHOULD BE 2.0**(-56) BUT 2.0**(-55) HAS BEEN FOUND
C     TO BE MORE PRACTICAL IN THE PAST.
C     HOWEVER, FROM MARK 14 THE THEORETICAL VALUE WILL BE USED.
      X02AJF = 2.0D0**(-56)
      RETURN
      END

      DOUBLE PRECISION FUNCTION X02AMF()
C     MARK 12 RELEASE. NAG COPYRIGHT 1986.
C
C     RETURNS THE 'SAFE RANGE' PARAMETER
C     I.E. THE SMALLEST POSITIVE MODEL NUMBER Z SUCH THAT
C     FOR ANY X WHICH SATISFIES X.GE.Z AND X.LE.1/Z
C     THE FOLLOWING CAN BE COMPUTED WITHOUT OVERFLOW, UNDERFLOW OR OTHER
C     ERROR
C
C        -X
C        1.0/X
C        SQRT(X)
C        LOG(X)
C        EXP(LOG(X))
C        Y**(LOG(X)/LOG(Y)) FOR ANY Y
C
C     .. Executable Statements ..
      X02AMF = (0.5D0 + 2.0D0**(-52)) * 2.0D0**(-126)
      RETURN
      END

      LOGICAL FUNCTION X02DAF(X)
C     MARK 8 RELEASE. NAG COPYRIGHT 1980.
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C
C     RETURNS .FALSE. IF THE SYSTEM SETS UNDERFLOWING QUANTITIES
C     TO ZERO, WITHOUT ANY ERROR INDICATION OR UNDESIRABLE WARNING
C     OR SYSTEM OVERHEAD.
C     RETURNS .TRUE. OTHERWISE, IN WHICH CASE CERTAIN LIBRARY
C     ROUTINES WILL TAKE SPECIAL PRECAUTIONS TO AVOID UNDERFLOW
C     (USUALLY AT SOME COST IN EFFICIENCY).
C
C     X IS A DUMMY ARGUMENT
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION        X
C     .. Executable Statements ..
      X02DAF = .FALSE.
      RETURN
      END

      SUBROUTINE X04AAF(I,NERR)
C     MARK 7 RELEASE. NAG COPYRIGHT 1978
C     MARK 7C REVISED IER-190 (MAY 1979)
C     MARK 11.5(F77) REVISED. (SEPT 1985.)
C     MARK 14 REVISED. IER-829 (DEC 1989).
C     IF I = 0, SETS NERR TO CURRENT ERROR MESSAGE UNIT NUMBER
C     (STORED IN NERR1).
C     IF I = 1, CHANGES CURRENT ERROR MESSAGE UNIT NUMBER TO
C     VALUE SPECIFIED BY NERR.
C
C     .. Scalar Arguments ..
      INTEGER           I, NERR
C     .. Local Scalars ..
      INTEGER           NERR1
C     .. Save statement ..
      SAVE              NERR1
C     .. Data statements ..
      DATA              NERR1/6/
C     .. Executable Statements ..
      IF (I.EQ.0) NERR = NERR1
      IF (I.EQ.1) NERR1 = NERR
      RETURN
      END

      SUBROUTINE X04BAF(NOUT,REC)
C     MARK 11.5(F77) RELEASE. NAG COPYRIGHT 1986.
C
C     X04BAF writes the contents of REC to the unit defined by NOUT.
C
C     Trailing blanks are not output, except that if REC is entirely
C     blank, a single blank character is output.
C     If NOUT.lt.0, i.e. if NOUT is not a valid Fortran unit identifier,
C     then no output occurs.
C
C     .. Scalar Arguments ..
      INTEGER           NOUT
      CHARACTER*(*)     REC
C     .. Local Scalars ..
      INTEGER           I
C     .. Intrinsic Functions ..
      INTRINSIC         LEN
C     .. Executable Statements ..
      IF (NOUT.GE.0) THEN
C        Remove trailing blanks
         DO 20 I = LEN(REC), 2, -1
            IF (REC(I:I).NE.' ') GO TO 40
   20    CONTINUE
C        Write record to external file
   40    WRITE (NOUT,FMT=99999) REC(1:I)
      END IF
      RETURN
C
99999 FORMAT (A)
      END
