
import re, time
import sys, traceback

class LogDataLine(object):

  def __init__(self, pattern=''):
    self.regex = re.compile(pattern)
    self.action_list = list()
    self.next_list = list()

  def add_next(self, *next_list):
    self.next_list.extend(next_list)

  def add_action(self, *action_list):
    self.action_list.extend(action_list)

class LogDataParser(object):

  def __init__(self):
    self.recovery_list = list()
    self.action_list = list()
    self.next_list = list()

  def add_next(self, *next_list):
    self.next_list.extend(next_list)

  def add_recovery_next(self, *next_list):
    self.recovery_list.extend(next_list)

  def add_recovery_action(self, *action_list):
    self.action_list.extend(action_list)

  def parse_stream(
    self,
    istream,
    ostream = None,
    verbose = False,
    pause = 0,
    patches = None,
    stop_on_error = True,
  ):
    line = istream.readline()
    line_cou = 1
    while line:
      if ostream:
        ostream.write(line)
        ostream.flush()

      if patches:
        for patch_fun in patches:
          line = patch_fun(line)

      try:
        it = iter(self.next_list)
        line_end = line
        while line_end:
          next_node = next(it)
          data = next_node.regex.match(line_end)
          if data:
            items = data.groups()
            for action in next_node.action_list:
              action(items)
              if pause:
                time.sleep(pause)

            self.next_list = next_node.next_list
            it = iter(self.next_list)
            line_end = line_end[data.end():]

      except StopIteration:
        if self.recovery_list:
          if verbose:
            ostream.write('|++++++++++++++++++\n')
            ostream.write('|WARNING, giving up on line %d' %line_cou + '\n')
            ostream.write('|' + line.rstrip() + '\n')
            ostream.write('|' + (len(line) - len(line_end))*' ' + '^\n')
            ostream.write('|with the following regular expressions\n')
            for next_node in self.next_list:
              ostream.write('|\'' + next_node.regex.pattern + '\'\n')

            ostream.write('|++++++++++++++++++\n')

          self.next_list = self.recovery_list
          for action in self.action_list:
            action()

      except:
        if stop_on_error:
          raise

        elif verbose:
          ostream.write('|++++++++++++++++++\n')
          ostream.write('|WARNING, giving up on line %d' %line_cou + '\n')
          ostream.write('|' + line.rstrip() + '\n')
          ostream.write('|' + (len(line) - len(line_end))*' ' + '^\n')
          ostream.write('|after matching the regular expression\n')
          ostream.write('|\'' + next_node.regex.pattern + '\'\n')
          ostream.write('|and failure of one of associated actions.\n')
          tb_lines = ''.join(traceback.format_exception(*sys.exc_info())).split('\n')
          for tb_line in tb_lines[:-1]:
            ostream.write('|' + tb_line + '\n')

          ostream.write('|++++++++++++++++++\n')

      line = istream.readline()
      line_cou += 1

