#   residue    atoms                  mean      stdev
impropers = [
    ( 'ALA', ('C', 'CA', '+N', 'O'), -0.00019, 0.03160 ),
    ( 'ALA', ('CA', 'N', 'C', 'CB'), 0.59838, 0.01964 ),
    ( 'CYS', ('C', 'CA', '+N', 'O'), 0.00084, 0.03215 ),
    ( 'CYS', ('CA', 'N', 'C', 'CB'), 0.60237, 0.02852 ),
    ( 'ASP', ('C', 'CA', '+N', 'O'), 0.00034, 0.03326 ),
    ( 'ASP', ('OD1', 'CB', 'OD2', 'CG'), 0.00096, 0.02081 ),
    ( 'ASP', ('CA', 'N', 'C', 'CB'), 0.59868, 0.02841 ),
    ( 'GLU', ('C', 'CA', '+N', 'O'), -0.00040, 0.03190 ),
    ( 'GLU', ('OE1', 'CG', 'OE2', 'CD'), 0.00019, 0.02119 ),
    ( 'GLU', ('CA', 'N', 'C', 'CB'), 0.59869, 0.02560 ),
    ( 'PHE', ('C', 'CA', '+N', 'O'), -0.00032, 0.03621 ),
    ( 'PHE', ('CA', 'N', 'C', 'CB'), 0.59995, 0.02774 ),
    ( 'PHE', ('CB', 'CG', 'CD1', 'CE1'), 3.14359, 0.04338 ),
    ( 'PHE', ('CG', 'CD1', 'CE1', 'CZ'), 0.00001, 0.02109 ),
    ( 'PHE', ('CD1', 'CE1', 'CZ', 'CE2'), -0.00014, 0.02644 ),
    ( 'PHE', ('CE1', 'CZ', 'CE2', 'CD2'), 0.00007, 0.02604 ),
    ( 'PHE', ('CZ', 'CE2', 'CD2', 'CG'), 0.00014, 0.02147 ),
    ( 'PHE', ('CE2', 'CD2', 'CG', 'CB'), 3.13958, 0.04319 ),
    ( 'GLY', ('C', 'CA', '+N', 'O'), -0.00105, 0.03582 ),
    ( 'HIS', ('C', 'CA', '+N', 'O'), -0.00020, 0.03180 ),
    ( 'HIS', ('CA', 'N', 'C', 'CB'), 0.59988, 0.02901 ),
    ( 'HIS', ('CG', 'ND1', 'CD2', 'CB'), -0.00090, 0.02621 ),
    ( 'HIS', ('CG', 'ND1', 'CE1', 'NE2'), 0.00012, 0.02114 ),
    ( 'HIS', ('ND1', 'CE1', 'NE2', 'CD2'), 0.00010, 0.01915 ),
    ( 'HIS', ('CE1', 'NE2', 'CD2', 'CG'), -0.00015, 0.01937 ),
    ( 'HIS', ('NE2', 'CD2', 'CG', 'ND1'), 0.00035, 0.02678 ),
    ( 'HIS', ('CD2', 'CG', 'ND1', 'CE1'), -0.00018, 0.03133 ),
    ( 'ILE', ('C', 'CA', '+N', 'O'), 0.00134, 0.03543 ),
    ( 'ILE', ('CA', 'N', 'C', 'CB'), 0.59534, 0.02634 ),
    ( 'ILE', ('CB', 'CG1', 'CG2', 'CA'), 0.59142, 0.02473 ),
    ( 'LYS', ('C', 'CA', '+N', 'O'), -0.00002, 0.03162 ),
    ( 'LYS', ('CA', 'N', 'C', 'CB'), 0.59949, 0.02544 ),
    ( 'LEU', ('C', 'CA', '+N', 'O'), -0.00005, 0.02952 ),
    ( 'LEU', ('CA', 'N', 'C', 'CB'), 0.60233, 0.02413 ),
    ( 'LEU', ('CG', 'CD1', 'CD2', 'CB'), -0.59488, 0.04057 ),
    ( 'MET', ('C', 'CA', '+N', 'O'), 0.00001, 0.03798 ),
    ( 'MET', ('CA', 'N', 'C', 'CB'), 0.59979, 0.02722 ),
    ( 'ASN', ('C', 'CA', '+N', 'O'), -0.00040, 0.02894 ),
    ( 'ASN', ('CG', 'ND2', 'CB', 'OD1'), -0.00068, 0.01924 ),
    ( 'ASN', ('CG', 'CB', 'ND2', 'OD1'), 0.00068, 0.01924 ),
    ( 'ASN', ('CA', 'N', 'C', 'CB'), 0.59535, 0.02878 ),
    ( 'PRO', ('N', '-C', 'CA', 'CD'), -0.02761, 0.07391 ),
    ( 'PRO', ('C', 'CA', '+N', 'O'), -0.00007, 0.03817 ),
    ( 'PRO', ('CA', 'N', 'C', 'CB'), 0.66127, 0.02403 ),
    ( 'GLN', ('C', 'CA', '+N', 'O'), -0.00038, 0.03587 ),
    ( 'GLN', ('CD', 'NE2', 'CG', 'OE1'), 0.00023, 0.02394 ),
    ( 'GLN', ('CD', 'CG', 'NE2', 'OE1'), -0.00023, 0.02394 ),
    ( 'GLN', ('CA', 'N', 'C', 'CB'), 0.59924, 0.02700 ),
    ( 'ARG', ('C', 'CA', '+N', 'O'), -0.00015, 0.03805 ),
    ( 'ARG', ('CZ', 'NH1', 'NH2', 'NE'), 0.00002, 0.02213 ),
    ( 'ARG', ('CA', 'N', 'C', 'CB'), 0.59966, 0.02646 ),
    ( 'SER', ('C', 'CA', '+N', 'O'), -0.00060, 0.04031 ),
    ( 'SER', ('CA', 'N', 'C', 'CB'), 0.60155, 0.02678 ),
    ( 'THR', ('C', 'CA', '+N', 'O'), 0.00014, 0.03651 ),
    ( 'THR', ('CA', 'N', 'C', 'CB'), 0.60066, 0.02728 ),
    ( 'THR', ('CB', 'OG1', 'CG2', 'CA'), 0.61301, 0.02739 ),
    ( 'VAL', ('C', 'CA', '+N', 'O'), 0.00201, 0.02878 ),
    ( 'VAL', ('CA', 'N', 'C', 'CB'), 0.59463, 0.02683 ),
    ( 'VAL', ('CB', 'CG2', 'CG1', 'CA'), 0.59175, 0.03297 ),
    ( 'TRP', ('C', 'CA', '+N', 'O'), -0.00078, 0.03245 ),
    ( 'TRP', ('CA', 'N', 'C', 'CB'), 0.60006, 0.02798 ),
    ( 'TRP', ('CG', 'CD1', 'CD2', 'CB'), 0.00199, 0.02415 ),
    ( 'TRP', ('CE3', 'CD2', 'CE2', 'CZ2'), -0.00001, 0.02068 ),
    ( 'TRP', ('CZ2', 'CH2', 'CZ3', 'CE3'), -0.00021, 0.02021 ),
    ( 'TRP', ('CG', 'CD1', 'NE1', 'CE2'), 0.00009, 0.01797 ),
    ( 'TRP', ('NE1', 'CE2', 'CD2', 'CG'), -0.00035, 0.01629 ),
    ( 'TRP', ('NE1', 'CE2', 'CZ2', 'CH2'), 3.14166, 0.01619 ),
    ( 'TRP', ('CG', 'CD2', 'CE3', 'CZ3'), 3.14193, 0.01784 ),
    ( 'TYR', ('C', 'CA', '+N', 'O'), -0.00043, 0.02649 ),
    ( 'TYR', ('CA', 'N', 'C', 'CB'), 0.60147, 0.02740 ),
    ( 'TYR', ('CB', 'CG', 'CD1', 'CE1'), 3.14465, 0.04289 ),
    ( 'TYR', ('CG', 'CD1', 'CE1', 'CZ'), 0.00011, 0.02115 ),
    ( 'TYR', ('CD1', 'CE1', 'CZ', 'CE2'), -0.00014, 0.02113 ),
    ( 'TYR', ('CE1', 'CZ', 'CE2', 'CD2'), 0.00002, 0.02056 ),
    ( 'TYR', ('CZ', 'CE2', 'CD2', 'CG'), 0.00022, 0.02031 ),
    ( 'TYR', ('CE2', 'CD2', 'CG', 'CB'), 3.13848, 0.04319 ),
    ( 'TYR', ('CD1', 'CE1', 'CZ', 'OH'), 3.14117, 0.02652 ),
    ( 'TYR', ('CD2', 'CE2', 'CZ', 'OH'), 3.14195, 0.02584 ),
  ]

def make_restraints(atmsel, restraints, num_selected):
    from modeller import forms, physical, features
    for (res, atoms, mean, stdev) in impropers:
        for a in atmsel.find_atoms(res, atoms, num_selected):
            r = forms.gaussian(physical.improper, features.dihedral(*a), mean,
                               stdev)
            restraints.add(r)
