# -*- coding: utf-8 -*-

#
#     Copyright (C) 2015 CCP-EM
#
#     This code is distributed under the terms and conditions of the
#     CCP-EM Program Suite Licence Agreement as a CCP-EM Application.
#     A copy of the CCP-EM licence can be obtained by writing to the
#     CCP-EM Secretary, RAL Laboratory, Harwell, OX11 0FA, UK.
#

'''
Remote server settings GUI layout code; based on original code
generated by QtDesigner
'''
from ccpem_core.gui.job_manager import longbow  #to use the test connection module


from PyQt4 import QtCore, QtGui
from ccpem_core.gui.utils import ccpem_widgets

class Ui_remote_settings(object):
    '''
    Class just to contain setup code
    '''
    def setupUi(self, remote_settings):
        '''
        Initialise the layout
        '''
        remote_settings.setObjectName(ccpem_widgets._fromUtf8("remote_settings"))
        remote_settings.resize(400, 286)
        remote_settings.setMaximumSize(400, 286)
        remote_settings.setMinimumSize(400, 286)

        # Generate labels for grid layout. Added new labels
        self.labels = {
            'host_name':["Server name"],
            'port':["Port"],
            'user': ["Username"],
            'accountflag': ["Account flag"],
            'handler': ["Handler"],
           # 'commandline': ["Command line"],
            'account': ["Account"], 
            'queue': ["Queue"],
            'cluster': ["Specific nodes"],
            'accountflag': ["Account flag"],
            'frequency': ["Frequency"],
            'corespernode': ["Cores per node"],
            'memory': ["Memory"],
            'cores': ["Cores"],
            'maxtime': ["Maxtime"],
            'remoteworkdir': ["Remote work directory"]}

        for i in self.labels:
            self.labels[i].append(ccpem_widgets.CCPEMParameterLabel(
                                                    remote_settings,
                                                    self.labels[i][0],
                                                    i))
            self.labels[i][1].setAlignment(QtCore.Qt.AlignLeft)

        self.buttonBox = QtGui.QDialogButtonBox(remote_settings)
        self.buttonBox.setGeometry(QtCore.QRect(10, 253, 381, 23))
        self.buttonBox.setOrientation(QtCore.Qt.Horizontal)
        self.buttonBox.setStandardButtons(QtGui.QDialogButtonBox.Cancel|
                                          QtGui.QDialogButtonBox.Ok)
        self.buttonBox.setCenterButtons(False)
        self.buttonBox.setObjectName(ccpem_widgets._fromUtf8("buttonBox"))
        self.tabWidget = QtGui.QTabWidget(remote_settings)
        self.tabWidget.setGeometry(QtCore.QRect(10, 10, 381, 237))
        self.tabWidget.setObjectName(ccpem_widgets._fromUtf8("tabWidget"))
     
        self.basicTab = QtGui.QWidget()
        self.basicTab.setObjectName(ccpem_widgets._fromUtf8("basicTab"))
        self.layoutWidget = QtGui.QWidget(self.basicTab)
        self.layoutWidget.setGeometry(QtCore.QRect(10, 10, 361, 191))
        self.layoutWidget.setObjectName(ccpem_widgets._fromUtf8("layoutWidget"))
        self.gridLayout = QtGui.QGridLayout(self.layoutWidget)
        self.gridLayout.setMargin(0)
        self.gridLayout.setObjectName(ccpem_widgets._fromUtf8("gridLayout"))
        self.gridLayout.addWidget(self.labels["host_name"][1], 0, 0, 1, 1)
        self.hostNameEdit = QtGui.QLineEdit(self.layoutWidget)
        self.hostNameEdit.setObjectName(ccpem_widgets._fromUtf8("hostNameEdit"))
        self.gridLayout.addWidget(self.hostNameEdit, 0, 1, 1, 1)
        self.gridLayout.addWidget(self.labels["port"][1], 1, 0, 1, 1)
        self.portSpinBox = QtGui.QSpinBox(self.layoutWidget)
        self.portSpinBox.setFrame(True)
        self.portSpinBox.setButtonSymbols(QtGui.QAbstractSpinBox.NoButtons)
        self.portSpinBox.setMaximum(99999)
        self.portSpinBox.setProperty("value", 22)
        self.portSpinBox.setObjectName(ccpem_widgets._fromUtf8("portSpinBox"))
        self.gridLayout.addWidget(self.portSpinBox, 1, 1, 1, 1)
        self.gridLayout.addWidget(self.labels["user"][1], 2, 0, 1, 1)
        self.userEdit = QtGui.QLineEdit(self.layoutWidget)
        self.userEdit.setObjectName(ccpem_widgets._fromUtf8("userEdit"))
        self.gridLayout.addWidget(self.userEdit, 2, 1, 1, 1)
        self.gridLayout.addWidget(self.labels["remoteworkdir"][1], 3, 0, 1, 1)
        self.remoteworkdirEdit = QtGui.QLineEdit(self.layoutWidget)
        self.remoteworkdirEdit.setObjectName(ccpem_widgets._fromUtf8("remoteworkdirEdit"))
        self.gridLayout.addWidget(self.remoteworkdirEdit, 3, 1, 1, 1)
        self.testConnectionButton = QtGui.QPushButton(self.layoutWidget)
        self.testConnectionButton.setObjectName(ccpem_widgets._fromUtf8("testConnectionButton"))
        self.testConnectionButton.clicked.connect(self.testconn)
        self.gridLayout.addWidget(self.testConnectionButton, 4, 0, 1, 1)
        self.tabWidget.addTab(self.basicTab, ccpem_widgets._fromUtf8(""))
 
#  Added tab with job parameters 
        self.jobTab = QtGui.QWidget()
        self.jobTab.setObjectName(ccpem_widgets._fromUtf8("jobTab"))
        self.layoutWidget = QtGui.QWidget(self.jobTab)
        self.layoutWidget.setGeometry(QtCore.QRect(10, 10, 361, 191))
        self.layoutWidget.setObjectName(ccpem_widgets._fromUtf8("layoutWidget"))
        self.gridLayout = QtGui.QGridLayout(self.layoutWidget)
        self.gridLayout.setMargin(0)
        self.gridLayout.setObjectName(ccpem_widgets._fromUtf8("gridLayout"))
     


        self.gridLayout.addWidget(self.labels["queue"][1], 0, 0, 1, 1)
        self.queueEdit = QtGui.QLineEdit(self.layoutWidget)
        self.queueEdit.setObjectName(ccpem_widgets._fromUtf8("queueEdit"))
        self.gridLayout.addWidget(self.queueEdit, 0, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["cores"][1], 1, 0, 1, 1)
        self.coresEdit = QtGui.QLineEdit(self.layoutWidget)
        self.coresEdit.setObjectName(ccpem_widgets._fromUtf8("coresEdit"))
        self.gridLayout.addWidget(self.coresEdit, 1, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["maxtime"][1], 2, 0, 1, 1)
        self.maxtimeEdit = QtGui.QLineEdit(self.layoutWidget)
        self.maxtimeEdit.setObjectName(ccpem_widgets._fromUtf8("maxtimeEdit"))
        self.gridLayout.addWidget(self.maxtimeEdit, 2, 1, 1, 1)


 
        self.tabWidget.addTab(self.jobTab, ccpem_widgets._fromUtf8(""))

        self.extraTab = QtGui.QWidget()
        self.extraTab.setObjectName(ccpem_widgets._fromUtf8("extraTab"))
        self.layoutWidget = QtGui.QWidget(self.extraTab)
        self.layoutWidget.setGeometry(QtCore.QRect(10, 10, 361, 191))
        self.layoutWidget.setObjectName(ccpem_widgets._fromUtf8("layoutWidget"))
        self.gridLayout = QtGui.QGridLayout(self.layoutWidget)
        self.gridLayout.setMargin(0)
        self.gridLayout.setObjectName(ccpem_widgets._fromUtf8("gridLayout"))
      
        self.gridLayout.addWidget(self.labels["accountflag"][1], 0, 0, 1, 1)
        self.accountflagEdit = QtGui.QLineEdit(self.layoutWidget)
        self.accountflagEdit.setObjectName(ccpem_widgets._fromUtf8("accountflagEdit"))
        self.gridLayout.addWidget(self.accountflagEdit, 0, 1, 1, 1)
     
        self.gridLayout.addWidget(self.labels["account"][1], 1, 0, 1, 1)
        self.accountEdit = QtGui.QLineEdit(self.layoutWidget)
        self.accountEdit.setObjectName(ccpem_widgets._fromUtf8("accountEdit"))
        self.gridLayout.addWidget(self.accountEdit, 1, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["cluster"][1], 2, 0, 1, 1)
        self.clusterEdit = QtGui.QLineEdit(self.layoutWidget)
        self.clusterEdit.setObjectName(ccpem_widgets._fromUtf8("clusterEdit"))
        self.gridLayout.addWidget(self.clusterEdit, 2, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["frequency"][1], 3, 0, 1, 1)
        self.frequencyEdit = QtGui.QLineEdit(self.layoutWidget)
        self.frequencyEdit.setObjectName(ccpem_widgets._fromUtf8("frequencyEdit"))
        self.gridLayout.addWidget(self.frequencyEdit, 3, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["corespernode"][1], 4, 0, 1, 1)
        self.corespernodeEdit = QtGui.QLineEdit(self.layoutWidget)
        self.corespernodeEdit.setObjectName(ccpem_widgets._fromUtf8("corespernodeEdit"))
        self.gridLayout.addWidget(self.corespernodeEdit, 4, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["memory"][1], 5, 0, 1, 1)
        self.memoryEdit = QtGui.QLineEdit(self.layoutWidget)
        self.memoryEdit.setObjectName(ccpem_widgets._fromUtf8("memoryEdit"))
        self.gridLayout.addWidget(self.memoryEdit, 5, 1, 1, 1)

        self.gridLayout.addWidget(self.labels["handler"][1], 6, 0, 1, 1)
        self.handlerEdit = QtGui.QLineEdit(self.layoutWidget)
        self.handlerEdit.setObjectName(ccpem_widgets._fromUtf8("handlerEdit"))
        self.gridLayout.addWidget(self.handlerEdit, 6, 1, 1, 1)



 
        self.tabWidget.addTab(self.extraTab, ccpem_widgets._fromUtf8(""))


# Added tab with advanced parameters

        self.advancedTab = QtGui.QWidget()
        self.advancedTab.setObjectName(ccpem_widgets._fromUtf8("advancedTab"))
        
        self.layoutWidget = QtGui.QWidget(self.advancedTab)
        self.layoutWidget.setGeometry(QtCore.QRect(10, 10, 361, 191))
        self.layoutWidget.setObjectName(ccpem_widgets._fromUtf8("layoutWidget"))
        self.gridLayout = QtGui.QGridLayout(self.layoutWidget)
        self.gridLayout.setMargin(0)
        self.gridLayout.setObjectName(ccpem_widgets._fromUtf8("gridLayout"))
 

        self.schedulerComboBox = QtGui.QComboBox(self.advancedTab)
        self.schedulerComboBox.setGeometry(QtCore.QRect(110, 40, 69, 22))
        self.schedulerComboBox.setObjectName(ccpem_widgets._fromUtf8("schedulerComboBox"))
  #      self.schedulerComboBox.addItem(ccpem_widgets._fromUtf8(""))
 
       # self.gridLayout.addWidget(self.schedulerComboBox)

        self.schedulerLabel = QtGui.QLabel(self.advancedTab)
        self.schedulerLabel.setGeometry(QtCore.QRect(10, 40, 101, 16))
        self.schedulerLabel.setObjectName(ccpem_widgets._fromUtf8("schedulerLabel"))
        self.labels['proxy'] = ["Ability to set a proxy?"]
        self.labels['scheduler'] = ["Scheduler"]
        self.labels["proxy"].append(QtGui.QLabel(self.advancedTab))
        self.labels["proxy"][1].setText(ccpem_widgets._translate("remote_settings", "Ability to set proxy?", None))
        self.labels["proxy"][1].setGeometry(QtCore.QRect(10, 10, 1000, 16))
        self.labels["proxy"][1].setObjectName(ccpem_widgets._fromUtf8("proxy"))
        self.labels["scheduler"].append(QtGui.QLabel(self.advancedTab))
        self.labels["scheduler"][1].setGeometry(QtCore.QRect(10, 40, 101, 16))
        self.labels["scheduler"][1].setText(ccpem_widgets._translate("remoteServerSettingsWidget", "Scheduler", None))
        self.labels["scheduler"][1].setObjectName(ccpem_widgets._fromUtf8("scheduler"))
        self.schedulerComboBox = QtGui.QComboBox(self.advancedTab)
        self.schedulerComboBox.setGeometry(QtCore.QRect(110, 40, 69, 22))
        self.schedulerComboBox.setObjectName(ccpem_widgets._fromUtf8("schedulerComboBox"))
        self.schedulerComboBox.addItem(ccpem_widgets._fromUtf8(""))
        self.schedulerComboBox.addItem(ccpem_widgets._fromUtf8(""))
        self.tabWidget.addTab(self.advancedTab, ccpem_widgets._fromUtf8(""))
        self.saveDetailsCheckBox = QtGui.QCheckBox(remote_settings)
        self.saveDetailsCheckBox.setGeometry(QtCore.QRect(20, 260, 211, 17))
        self.saveDetailsCheckBox.setObjectName(ccpem_widgets._fromUtf8("saveDetailsCheckBox"))
   #     self.testConnectionButton.clicked.connect(self.save_details)        
        self.retranslateUi(remote_settings)
        self.tabWidget.setCurrentIndex(0)
        QtCore.QMetaObject.connectSlotsByName(remote_settings)

    def testconn(self):
        longbow.testconnection(remoteres = "")

  #  def save_details(self):
        
#Added here the other two tabs
    def retranslateUi(self, remote_settings):
        remote_settings.setWindowTitle(ccpem_widgets._translate("remote_settings", "Server settings", None))
        self.testConnectionButton.setText(ccpem_widgets._translate("remote_settings", "Test connection", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.basicTab), ccpem_widgets._translate("remote_settings", "Host parameters", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.jobTab), ccpem_widgets._translate("remote_settings", "Job parameters", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.extraTab), ccpem_widgets._translate("remote_settings", "Advanced", None)) 
        self.schedulerComboBox.setItemText(0, ccpem_widgets._translate("remote_settings", "PBS", None))
        self.schedulerComboBox.setItemText(1, ccpem_widgets._translate("remote_settings", "LSF", None))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.advancedTab), ccpem_widgets._translate("remote_settings", "Scheduler", None))
        self.saveDetailsCheckBox.setText(ccpem_widgets._translate("remote_settings", "Save details", None))
