C HALFSTAT.FOR
C
C  Remember to change version number in foirst write statement.
C
C		JMB	1984		Original programme
C	V 1.0	NG	21-Dec-1995	UNIX version by Nikolaus Grigorieff
C	V 1.1	RH	27-May-1996	general cell dimensions
C       V 1.2   RH      19-Sep-1996     debug  ISLOT= 1 + IRES/RESTEP
C
C	INPUT DATA
C
C	Card 1 :	RESTEP	resolution steps inunits of 10000/d**2
C	Card 2 :	ACELL,BCELL,GAMMA  unit cell
C
      PARAMETER (NSLOTS=32)
      DIMENSION TITLE(10)
      DIMENSION NRESO(NSLOTS),ERRES(NSLOTS),SERRES(NSLOTS)
      DIMENSION ERRTHEOR(NSLOTS),SERRTHEOR(NSLOTS),SIGBOTH(NSLOTS)
      DRAD=3.14159/180.0
C
      WRITE(6,2)
2     FORMAT(/'  ***** HALFSTAT V1.2(19-Sept-1996) *****',
     .	' Phase diffs bet two halves of data'/)
      READ(5,*)RESTEP
      READ(5,*)ACELL,BCELL,GAMMA
      IF(GAMMA.LT.90.0) GAMMA=180.0-GAMMA
      ASTAR=1.0/(ACELL*SIN(GAMMA*DRAD))
      BSTAR=1.0/(BCELL*SIN(GAMMA*DRAD))
C
C      CALL CCPDPN(1,'FOR001','READONLY','F',0,0)
C      CALL CCPDPN(2,'FOR002','READONLY','F',0,0)
C      CALL CCPDPN(3,'FOR003','READONLY','F',0,0)
C
11      FORMAT(10A4)
        READ(1,11)TITLE
        WRITE(6,14)TITLE
14      FORMAT(' TITLE OF FIRST HALF MERGED LIST',10A4/)
        READ(2,11)TITLE
        WRITE(6,15)TITLE
15      FORMAT(' TITLE OF SECOND HALF MERGED LIST',10A4/)
        READ(3,11)TITLE
        WRITE(6,16)TITLE
16      FORMAT(' TITLE OF WHOLE MERGED LIST',10A4/)
C
      NREFL=0
100     CONTINUE
        READ(1,*,END=1340)IH,IK,IL,AMP1,PHS1,PHSERR1
        READ(2,*,END=1340)JH,JK,JL,AMP2,PHS2,PHSERR2
        READ(3,*,END=1340)KH,KK,KL,AMP3,PHS3,PHSERR3
110	CONTINUE
      	IME=100*IH+IK
      	JME=100*JH+JK
      	KME=100*KH+KK
        IMISS=0
      	IF (IME.GT.KME) THEN
      	  WRITE(6,1000)KH,KK
1000	  FORMAT(' MISSING REFLECTION ON LIST 1, HK=',2I3)
      	  IMISS=IMISS+1
      	ELSEIF (IME.LT.KME) THEN
      	  IMISS=IMISS+4
      	ENDIF
      	IF (JME.GT.KME) THEN
      	  WRITE(6,1001)KH,KK
1001	  FORMAT(' MISSING REFLECTION ON LIST 2, HK=',2I3)
      	  IMISS=IMISS+2
      	ELSEIF (JME.LT.KME) THEN
      	  IMISS=IMISS+8
      	ENDIF
      	IF (IMISS.EQ.1) THEN
          READ(2,*,END=1340)JH,JK,JL,AMP2,PHS2,PHSERR2
          READ(3,*,END=1340)KH,KK,KL,AMP3,PHS3,PHSERR3
      	  GOTO 110
      	ELSEIF (IMISS.EQ.2) THEN
          READ(1,*,END=1340)IH,IK,IL,AMP1,PHS1,PHSERR1
          READ(3,*,END=1340)KH,KK,KL,AMP3,PHS3,PHSERR3
      	  GOTO 110
      	ELSEIF (IMISS.EQ.3) THEN
          READ(3,*,END=1340)KH,KK,KL,AMP3,PHS3,PHSERR3
      	  GOTO 110
      	ELSEIF (IMISS.EQ.4) THEN
          READ(1,*,END=1340)IH,IK,IL,AMP1,PHS1,PHSERR1
      	  GOTO 110
      	ELSEIF (IMISS.EQ.6) THEN
          READ(1,*,END=1340)IH,IK,IL,AMP1,PHS1,PHSERR1
      	  GOTO 110
      	ELSEIF (IMISS.EQ.8) THEN
          READ(2,*,END=1340)JH,JK,JL,AMP2,PHS2,PHSERR2
      	  GOTO 110
      	ELSEIF (IMISS.EQ.9) THEN
          READ(2,*,END=1340)JH,JK,JL,AMP2,PHS2,PHSERR2
      	  GOTO 110
      	ELSEIF (IMISS.EQ.12) THEN
          READ(1,*,END=1340)IH,IK,IL,AMP1,PHS1,PHSERR1
          READ(2,*,END=1340)JH,JK,JL,AMP2,PHS2,PHSERR2
      	  GOTO 110
      	ENDIF
      	SIGMA1=ACOS(PHSERR1/100.0)
      	SIGMA2=ACOS(PHSERR2/100.0)
      	SIGMA3=ACOS(PHSERR3/100.0)
        NREFL=NREFL+1
C       CALCULATE RESOLUTION OF SPOT
        DSTARSQ = (IH*ASTAR)**2 + (IK*BSTAR)**2 -
     .	 2.0*IH*IK*ASTAR*BSTAR*COS(DRAD*GAMMA)
        IRES=DSTARSQ*10000.
C****
        ISLOT= 1 + IRES/RESTEP
                IF(ISLOT.LT.1.OR.ISLOT.GE.NSLOTS) THEN
                WRITE(6,20000)ISLOT
20000           FORMAT(' ERROR, ISLOT=',I10)
                STOP
        END IF
      DELTA=PHS1-PHS2
      SIGTHEOR=SQRT(SIGMA1**2+SIGMA2**2)
      IF(DELTA.LT.0.0) DELTA=-DELTA
1310   IF(DELTA.LE.180.0) GO TO 1320
      DELTA=DELTA-360.0
      GO TO 1310
1320   IF(DELTA.LT.0.0) DELTA=-DELTA
      SERR=DELTA+SERR
C
        SERRES(ISLOT)=SERRES(ISLOT)+DELTA
        SERRTHEOR(ISLOT)=SERRTHEOR(ISLOT)+SIGTHEOR
        SIGBOTH(ISLOT)=SIGBOTH(ISLOT)+SIGMA3
        NRESO(ISLOT)=NRESO(ISLOT)+1
      GO TO 100
1340    CONTINUE
        WRITE(6,1341) NREFL
1341    FORMAT(' TOTAL SPOTS INPUT ON BOTH LISTS',I5)
C       WRITE TABLE OF RESIDUAL AS FUNCTION OF RESOLUTION
C
        WRITE(6,10173)
10173   FORMAT(/1X,'BEST PHASE RESIDUAL IN RESOLUTION RANGES'/)
        WRITE(6,10171)
c 10171   FORMAT(1X,' RANGE','     DMIN ','     DMAX ','   RESIDUAL',
c      .'  NUMBER  RESTHEOR   SIGBOTH'/)
10171   FORMAT(1X,' RANGE','     DMIN ','     DMAX ','   RESIDUAL',
     .'  NUMBER'/)
        NRESALL=0
        SERRESALL=0.0
        SERRTHEORALL=0.0
        DO 10175 I=1,NSLOTS
        IF(NRESO(I).EQ.0)GO TO 10175
        NRESALL=NRESALL+NRESO(I)
        SERRESALL=SERRES(I)+SERRESALL
        SERRTHEORALL=SERRTHEOR(I)+SERRTHEORALL
        SIGOVERALL=SIGOVERALL+SIGBOTH(I)
        ERRES(I)=SERRES(I)/NRESO(I)
        ERRTHEOR(I)=SERRTHEOR(I)/NRESO(I)
        SIGBOTH(I)=SIGBOTH(I)/NRESO(I)
        DMIN=SQRT(10000.0/((I-1)*RESTEP + 0.04))
        DMAX=SQRT(10000.0/(I*RESTEP))
        WRITE(6,10172)I,DMIN,DMAX,ERRES(I),NRESO(I)
c        WRITE(6,10172)I,DMIN,DMAX,ERRES(I),NRESO(I),ERRTHEOR(I),
c     .          SIGBOTH(I)
10175   CONTINUE
c 10172   FORMAT(1X,I6,3F10.3,I7,2F10.3)
10172   FORMAT(1X,I6,3F10.3,I7)
        ERRESALL=SERRESALL/NRESALL
        ERRTHEORALL=SERRTHEORALL/NRESALL
        SIGOVERALL=SIGOVERALL/NRESALL
c        WRITE(6,10174)ERRESALL,NRESALL,ERRTHEORALL,SIGOVERALL
        WRITE(6,10174)ERRESALL,NRESALL
c 10174   FORMAT(//1X,'OVERALL',19X,F10.3,I7,2F10.3//)
10174   FORMAT(//1X,'OVERALL',19X,F10.3,I7//)
      	CLOSE(UNIT=1)
      	CLOSE(UNIT=2)
      	CLOSE(UNIT=3)
        END
