C
C***********************************************************************
C
C     HLXFOUR
C     Version 1.0 updated by JMS1 JUNE 25 1982 for o/p compatibility
C     with PLOTFOUR( calcomp program)
C     Version 1.1 Error corrected by LAA1 SEPT 82
C     Version 1.2 updated MAR 1983 for output compatible VAX IMAGE files
C     but not exhaustively tested.
C     Control for EMHFH2, EMHFC2, EMHFV2
C     Output file of little g's for plotting with HLXGOUT  3Apr85 RAC
C     Version 1.3 Converted to image2000     13NOV00  RAC
C     Version 1.4 GFORTRAN conversion	 16.06.2010 jms
C     Version 1.5 Dimension increase / rectangular section converted to square 01.02.2012
C     Version 1.6 Dimension increase 03.05.2012
C
C***************************************************************************
C
C*** jms 01.02.2012      
C*** DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),IN(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50)
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,ISIDE,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C
C     set IABS(KOUT)  to 1 for isometric line-printer O/P,5*DELX=6*
C                     to 2 for TONE output
C                     to 3 for TONE and line printer output
C     if KOUT -VE layer line data printed out
C
    5 READ(5,1000,END=10) (TITLE(I),I=6,15)
      WRITE(6,1002) (TITLE(I),I=6,15)
      READ(5,*) C,DELBR,RMAX,DELSR
      WRITE(6,1007) C,DELBR,RMAX,DELSR
      READ(5,*) LLMAX,ISIDE,KOUT
      WRITE(6,1005) LLMAX,ISIDE,KOUT
      READ(5,*) (WT(L),L=1,LLMAX)
      WRITE(6,1004) (WT(L),L=1,LLMAX)
      READ(5,*) IHFH,IHFC,IHFV,IHFP,IHFZ,IQATOR,MAP,ITRFN
      WRITE(6,1005) IHFH,IHFC,IHFV,IHFP,IHFZ,IQATOR,MAP,ITRFN
C
      ISMAX=RMAX/DELSR+1.1
c      IF(ISMAX.LE.51) GO TO 119
c      ISMAX=51
c      DELSR=RMAX/50.0
      IF(ISMAX.LE.404) GO TO 119
      ISMAX=404
      DELSR=RMAX/200.0
      WRITE(6,1013) DELSR
C
  119 CALL EMLTLG(MAP,ITRFN)
      IF(IQATOR.EQ.0)  GO TO 110
      WRITE(6,1010)
      LLMAX=LLMAX+1
      NN(LLMAX)=0
      NL(LLMAX)=0
      DO 120 I=1,ISMAX
      READ(5,*) R,GLITA(I,LLMAX),GLITB(I,LLMAX)
  120 WRITE(6,1009) R,GLITA(I,LLMAX),GLITB(I,LLMAX)
C
110   CALL EMSCAL
C
      RMM=RMAX
    6 IF(IHFH.EQ.0) GO TO 1
      READ(5,*) PHIMIN,PHIMAX
      WRITE(6,1004) PHIMIN,PHIMAX
      READ(5,*) ZMIN,ZMAX,DELZED
      WRITE(6,1004) ZMIN,ZMAX,DELZED
      CALL EMHFH2
    1 IF(IHFC.EQ.0) GO TO 2
      READ(5,*) RMIN,RMAX
      WRITE(6,1004) RMIN,RMAX
      READ(5,*) PHIMIN,PHIMAX,DELPHI
      WRITE(6,1004) PHIMIN,PHIMAX,DELPHI
      READ(5,*) ZMIN,ZMAX,DELZED
      WRITE(6,1004) ZMIN,ZMAX,DELZED
      CALL EMHFC2
    2 IF(IHFV.EQ.0) GO TO 3
      READ(5,*) RMIN,RMAX
      WRITE(6,1004) RMIN,RMAX
      READ(5,*) PHIMIN,PHIMAX,DELPHI
      WRITE(6,1004) PHIMIN,PHIMAX,DELPHI
      READ(5,*) ZMIN,ZMAX,DELZED
      WRITE(6,1004) ZMIN,ZMAX,DELZED
      CALL EMHFV2
    3 IF(IHFP.EQ.0) GO TO 4
      RMAX=RMM
      READ(5,*) XMIN,XMAX,DELX
      WRITE(6,1004) XMIN,XMAX,DELX
      READ(5,*) PHIMIN,PHIMAX
      WRITE(6,1004) PHIMIN,PHIMAX
      READ(5,*) ZMIN,ZMAX,DELZED
      WRITE(6,1004) ZMIN,ZMAX,DELZED
      CALL EMHFP2
    4 IF(IHFZ.EQ.0) GO TO 5
      RMAX=RMM
      READ(5,*) PHIMIN,MIND,DMIN
      WRITE(6,1012) PHIMIN,MIND,DMIN
      READ(5,*) ZMIN,ZMAX,DELZED
      WRITE(6,1004) ZMIN,ZMAX,DELZED
      CALL EMHFZP
      IHFZ=IHFZ-1
      GO TO 4
   10 STOP
 1000 FORMAT(20A4)
 1001 FORMAT('1',20A4,'  LISTING OF CARD INPUT')
 1002 FORMAT(1X,20A4)
 1003 FORMAT(8F10.2)
 1004 FORMAT(1X,8F10.3)
 1005 FORMAT(8I10)
 1007 FORMAT(1X,F10.2,F10.6,2F10.2)
 1008 FORMAT(3E10.3)
 1009 FORMAT(1X,3E10.3)
 1010 FORMAT(//'0AVERAGE RADIAL DENSITY DISTRIBUTION ADDED IN DIRECTLY')
 1011 FORMAT(F10.0,I10,F10.0)
 1012 FORMAT(1X,F10.2,I10,F10.1)
 1013 FORMAT('0DELSR RESET TO ',F10.3)
      END
C
C***********************************************************************
C
C     EMSCAL
C
C************************************************************************
C
      SUBROUTINE EMSCAL
C     SCALE LITTLE G'S READY FOR OUTPUT ROUTINES
C
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),IN(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50)
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     .DELPHI,LLMAX,ISIDE,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     .TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C
C     COMPUTE SCALE FACTOR
  110 LIMR=RMAX/DELSR+1.1
      DENMAX=0.0
      DOMAX=0.0
      DO 101 IR=1,LIMR
      SUMIR=0.0
      CAVSCL=0.0
      DO 102 LL=1,LLMAX
      APLUSB=SQRT(GLITA(IR,LL)**2+GLITB(IR,LL)**2)
      IF(APLUSB.GE.0.001*SUMIR) GO TO 100
      GLITA(IR,LL)=0.0
      GLITB(IR,LL)=0.0
      APLUSB=0.0
  100 IF(NN(LL).EQ.0) CAVSCL=CAVSCL+APLUSB
  102 SUMIR=SUMIR+APLUSB
      DOMAX=AMAX1(DOMAX,CAVSCL)
  101 DENMAX=AMAX1(DENMAX,SUMIR)
      SCAL2=99.0/DENMAX
      SCAL1=SCAL2/2.0
      IF(DOMAX.NE.0.0) CAVSCL=DENMAX/(DOMAX*2.0)
C     APPLY SCALE FACTOR AND MULTIPLICITY CORR.
      DO 103 LL=1,LLMAX
      IF(NL(LL).EQ.0) GO TO 104
      DO 105 IR=1,LIMR
      GLITA(IR,LL)=GLITA(IR,LL)*SCAL2
      GLITB(IR,LL)=GLITB(IR,LL)*SCAL2
      APLUSB=SQRT(GLITA(IR,LL)**2+GLITB(IR,LL)**2)
      IF(APLUSB.GE.0.1) GO TO 105
      GLITA(IR,LL)=0.0
      GLITB(IR,LL)=0.0
  105 CONTINUE
      GO TO 103
  104 DO 106 IR=1,LIMR
      GLITA(IR,LL)=GLITA(IR,LL)*SCAL1
      GLITB(IR,LL)=GLITB(IR,LL)*SCAL1
      APLUSB=SQRT(GLITA(IR,LL)**2+GLITB(IR,LL)**2)
      IF(APLUSB.GE.0.01) GO TO 106
      GLITA(IR,LL)=0.0
      GLITB(IR,LL)=0.0
  106 CONTINUE
  103 CONTINUE
      SCAL1=SCAL1*C
      WRITE(6,1006) SCAL1
      RETURN
C
 1006 FORMAT('0DENSITIES HAVE BEEN SCALED BY FACTOR',E15.4)
      END
C
C***************************************************************************
C
C     EMLTLG
C
C***************************************************************************
C
      SUBROUTINE EMLTLG(MAP,ITRFN)
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),JN(50),GLITA(51,50),GLITB(51,50),
C***     1NL(50),NN(50),WT(100),A(50,200),B(50,200),IBMAX(50),HEAD(10),
C***     2TITLE(15),RAD(51),TRFN(400)
      DIMENSION BSA(4072,200),IN(200),JN(200),GLITA(408,200),GLITB(408,200),
     1NL(50),NN(50),WT(400),A(200,800),B(200,800),IBMAX(200),HEAD(10),
     2TITLE(15),RAD(408),TRFN(1600)
      REAL*8 HEAD
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C
      NARG=1000
C*** jms 10.04.2012      LLDIM=50
      LLDIM=200
C*** jms 10.04.2012      NBESL=50
      NBESL=200
C*** jms 08.04.2012      NRMAX=200
      NRMAX=800
C
      PI=3.14159
      PIBY2=PI/2.0
      CRAD = 3.14159 / 180.0
      DD = 6.28318 * DELBR**2
      TWODD = DELBR * DELSR * 6.28318
      ISMAX=RMAX/DELSR+1.1
	write(6,'(''rmax,delsr,ismax :'',2f10.3,i10)')
     *  rmax,delsr,ismax
      DO 12 L=1,LLDIM
      IBMAX(L)=0
      DO 12 II=1,ISMAX
      GLITA(II,L)=0.0
   12 GLITB(II,L)=0.0
      IRMAX = 0
      NB = 1
      ISIDE = 1
      IF(IJUMP.EQ.1) ISIDE=2
      CALL EMTRFN(ITRFN,TRFN,NRMAX)
C
C     READ IN LAYER-LINE DATA - F'S ARE FROM Y,Z PLANE OF TRANSFORM SPAC
C     SO PSI = PI/2.  CONVERT TO REAL & IMAG. PARTS OF G, WHERE
C                   G = F * EXP(-I*N*(PSI+PI/2))
C
      CALL CCPDPN(1,'LLIN','OLD','F',0,0)
 9    L = 1
      LLNULL=0
      WRITE(6,1000)
      GO TO 2
    1 IF(IR.GT.IBMAX(L)) IBMAX(L)=IR
      IF(IR.GT.IRMAX) IRMAX = IR
      LLL=L+LLNULL
      IF(WT(LLL).EQ.0.0) LLNULL=LLNULL+1
      IF(WT(LLL).NE.0.0) L=L+1
      IF(L+LLNULL.GT.LLMAX.OR.L.GT.LLDIM) GO TO 499
 2    READ(1,1004,END = 500) HEAD,SCALE,NN(L),NL(L)
      WRITE(6,1006) HEAD,SCALE,NN(L),NL(L),WT(L+LLNULL)
      IF(WT(L+LLNULL).EQ.0.0) GO TO 51
      MODN = IABS(NN(L))
      PHIDEL=MOD(MODN,2) * PI
      IF(ISIDE.EQ.2.AND.IJUMP.EQ.2) GO TO 51
      IF(L.EQ.1) GO TO 20
      DO 30 J = 1,NB
      IF(MODN.EQ.JN(J)) GO TO 21
 30   CONTINUE
      NB = NB + 1
      IF(NB.GT.NBESL) GO TO 1233
   20 JN(NB) = MODN
C
C     INITIALISATION
   21 DO 50 IR = 1,NRMAX
      A(L,IR) = 0.0
 50   B(L,IR) = 0.0
 51   IR = -1
      ZZ=(NL(L)/C)**2
C
 3    READ(1,1005,END=500) RR,GG,PHI
      IF(IR.GE.0.AND.RR.LE.0.0) GO TO 1
 6    IR = RR / DELBR + 0.1
      IF(RR.LE.0.0) GO TO 3
      IF(WT(L+LLNULL).EQ.0.0) GO TO 3
      IF(IR.GT.NRMAX) GO TO 1232
      KR=SQRT(RR*RR+ZZ)/DELBR+0.5
      IF(KR.GT.NRMAX*2) GO TO 1232
   58 PHI1 = PHI * CRAD
      IF(ISIDE.EQ.1.AND.NN(L).LT.0) PHI1=PHI1-PHIDEL
      IF(ISIDE.EQ.2.AND.NN(L).GT.0) PHI1=PHI1-PHIDEL
      A(L,IR) = A(L,IR) + GG * COS(PHI1) * SCALE * WT(L+LLNULL)*TRFN(KR)
      B(L,IR)=B(L,IR)+GG*SIN(PHI1)*SCALE*WT(L+LLNULL)*TRFN(KR)
      IF(KOUT.LT.0) WRITE(6,1012) RR,GG,PHI,A(L,IR),B(L,IR)
      GO TO 3
C
  499 READ(1,1001,END=500) WXYZ
      GO TO 499
  500 IF(IJUMP.LT.2) GO TO 501
      IF(ISIDE.EQ.2) GO TO 501
      ISIDE = 2
      GO TO 9
C
C     SORT BESSEL ORDERS AND SET POINTER FOR EACH LAYER LINE
  501 LLMAX=L-1
      DO 40 J=1,NB
      MIN = 1000
      DO 45 M = 1,NB
      IF(JN(M).GE.MIN) GO TO 45
      MIN = JN(M)
      MM = M
 45   CONTINUE
      IN(J) = JN(MM)
      JN(MM) = 1000
 40   CONTINUE
      WRITE(6,1010) (IN(J),J=1,NB)
C
      DO 60 L = 1,LLMAX
      MODN=IABS(NN(L))
      DO 65 M = 1,NB
      IF(IN(M).NE.MODN) GO TO 65
      JN(L) = M
      GO TO 60
 65   CONTINUE
 60   CONTINUE
      WRITE(6,1011) (JN(L),L=1,LLMAX)
C
C     SUMMATION TO GIVE LITTLE G'S
      KMIN = 1
      KOMIN = 1
      ISMIN=1
      IBD = IRMAX * (ISMAX - 1) + 1
 4    KMAX = KMIN + NARG-1
      IF(KMAX.GT.IBD) KMAX = IBD
C
      CALL EMBES2
C
      DO 600 L = 1,LLMAX
      MODN = IABS(NN(L))
      N1 = 0
      N2 = MODN / 2
      IF(NN(L).LT.0.AND.N2*2.NE.MODN) N1 = 1
      IRMAX = IBMAX(L)
      KOMAX=IRMAX
      M = JN(L)
C
      DO 204 II = ISMIN,ISMAX
      SUMA = 0.0
      SUMB = 0.0
      RAD(II) = (II - 1) * DELSR
      IF(II.GT.1) KOMAX = (KMAX - 1) / (II - 1)
      IF(KOMAX.GT.IRMAX) KOMAX = IRMAX
      IF(KMIN.GT.1) KOMIN = (KMIN-2)/(II-1)+1
      IF(KOMIN.GT.IRMAX) GO TO 204
C
      DO 203 I = KOMIN,KOMAX
      FF = I * DD
      K = I * (II - 1) - KMIN + 2
      IF(K.LT.1.OR.K.GT.NARG) GO TO 1231
      BS = BSA(K,M) * FF
      IF(N1.EQ.1) BS = -BS
      IF(ABS(A(L,I)).LE.0.000001) GO TO 110
      SUMA = SUMA + BS * A(L,I)
 110  IF(ABS(B(L,I)).LE.0.000001) GO TO 203
      SUMB = SUMB + BS * B(L,I)
 203  CONTINUE
C
      GLITA(II,L) = GLITA(II,L)+SUMA
      GLITB(II,L) = GLITB(II,L)+SUMB
 204  CONTINUE
 600  CONTINUE
C
      KMIN = KMAX + 1
      ISMIN=2
      IF(KMIN.LE.IBD) GO TO 4
C
      WRITE(6,1002)
      DO 650 L = 1,LLMAX
 650  WRITE(6,1003) NN(L),NL(L),(RAD(II),GLITA(II,L),GLITB(II,L),
     1II = 1,ISMAX)
C
C     Output of little g's to file if required
      IF(MAP.EQ.0) RETURN
      CALL CCPDPN(4,'GOUT','UNKNOWN','F',0,0)
ccc	open(unit=4,file='GOUT',status='unknown')
      ZERO=0.
      DO 660 L=1,LLMAX
      WRITE(4,1030) NN(L),NL(L)
      WRITE(4,1035) (RAD(II),GLITA(II,L),GLITB(II,L),II=1,ISMAX)
      WRITE(4,1035) ZERO,ZERO,ZERO
660   CONTINUE
      RETURN
 1233 WRITE(6,1020)
      STOP
 1232 IR = NRMAX
      WRITE(6,1021) NRMAX
      GO TO 3
 1231 WRITE(6,1022) K
      STOP
 1001 FORMAT(5A4)
 1004 FORMAT(10A5,F10.3,2I5)
 1006 FORMAT('0',10A5,F10.3,2I5,5X,F10.3)
 1000 FORMAT('1LIST OF LAYER-LINES INCLUDED IN RECONSTRUCTION')
 1002 FORMAT('1LIST OF LITTLE GS')
 1003 FORMAT('0',2I10 / (9E12.3))
 1005 FORMAT(3E10.3)
 1020 FORMAT('0TOO MANY BESSEL ORDERS REQUIRED')
 1021 FORMAT('0POINT MORE THAN ',I3,' STEPS ALONG LL OMITTED')
 1022 FORMAT('0TROUBLE,K = ',I10)
 1010 FORMAT('0BESSEL ORDERS REQUIRED'/(1X,12I10))
 1011 FORMAT('0INDEX TO BESSELS FOR EACH LAYER LINE'/(1X,12I10))
 1012 FORMAT(1X,F12.6,4F12.2)
 1030 FORMAT(2I5)
 1035 FORMAT(3E10.3)
      END
C
C****************************************************************************
C
C     EMTRFN
C
C****************************************************************************
C
      SUBROUTINE EMTRFN(ITRFN,TRFN,NR2)
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),IN(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50)
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     .DELPHI,LLMAX,ISIDE,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     .TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C*** jms 08.04.2012      DIMENSION TRFN(400),ATRFN(400,2),RLINE(13)
      DIMENSION TRFN(1600),ATRFN(1600,2),RLINE(13)
C*** jms 16.06.2010
      character cmap(132,41)
      character blank/' '/, star(2)/'.','*'/,plus/'+'/,dash/'-'/
C
      NRMAX=NR2*2
	write(6,'(''emtrfn nr2 = '',i10)')nr2
C
      DO 13 IR=1,NRMAX
   13 TRFN(IR)=1.0
      P1=0.0
      Q1=0.0
      S1=1.0
      P2=0.0
      Q2=0.0
      S2=1.0
      A1=1.0
      B1=0.0
      A2=0.0
      B2=0.0
      A3=0.0
      B3=0.0
C
      IF(ITRFN.EQ.0) RETURN
C
   10 READ(5,*) ASCAL,WL,CS,RESMAX
      WRITE(6,1001) ASCAL,WL,CS,RESMAX
      IF(ITRFN.EQ.2) GO TO 11
      READ(5,*) P1,Q1,DF1,S1,P2,Q2,DF2,S2
      WRITE(6,1003) P1,Q1,DF1,S1,P2,Q2,DF2,S2
   11 IF(ITRFN.EQ.1) GO TO 12
      READ(5,*) A1,B1,A2,B2,A3,B3
      WRITE(6,1005) A1,B1,A2,B2,A3,B3
   12 CONTINUE
C
C
      TWOPI=2.0*3.14159
      FAC1=TWOPI*WL*CS*WL*WL/2.0
      FAC2=TWOPI*WL*DF1/2.0
      FAC3=TWOPI*WL*DF2/2.0
      IRMAX1=RESMAX/DELBR+0.5
      IF(IRMAX1.EQ.0) IRMAX1=NRMAX
      IF(IRMAX1.GT.NRMAX) IRMAX1=NRMAX
      IRMAX2=IRMAX1+1
      IF(ASCAL.LE.0.0) ASCAL=1.0
      DO 90 IR=1,13
   90 RLINE(IR)=IR*10*DELBR
C
C
      DO 100 IR=1,IRMAX1
      R=IR*DELBR*ASCAL
      RR=R*R
      XI0=-FAC1*RR*RR
      XI1=XI0+FAC2*RR
      XI2=XI0+FAC3*RR
      ATRFN(IR,1)=-P1*SIN(XI1)-Q1*COS(XI1)+S1
      W=A1*EXP(B1*RR)+A2*EXP(B2*RR)+A3*EXP(B3*RR)
      ATRFN(IR,1)=ATRFN(IR,1)*W
      ATRFN(IR,2)=-P2*SIN(XI2)-Q2*COS(XI2) +S2
      IF(ABS(ATRFN(IR,1)).GT.0.15) TRFN(IR)=ATRFN(IR,2)/ATRFN(IR,1)
  100 CONTINUE
      IF(IRMAX1.EQ.NRMAX) GO TO 102
      DO 101 IR=IRMAX2,NRMAX
  101 TRFN(IR)=0.0
C
C     OUTPUT MAPS OF TRANSFER FUNCTIONS
C
      WRITE(6,2003)
      DO 60 IR=1,NRMAX
      R=IR*DELBR
   60 WRITE(6,2004) R,TRFN(IR)
C
      IF(NRMAX.GT.132) NRMAX=132
C
  102 DO 200 I=1,2
C
      DO 30 IR=1,NRMAX
      IF(I.EQ.2) GO TO 51
      DO 50 K=1,41
C*** jms 16.06.2010
   50 cmap(ir,k)=blank
      cmap(ir,21)=dash
      if(mod(ir,10) .eq. 0) cmap(ir,21)=plus
   51 K=21.5+ATRFN(IR,I)*20.0
      IF(K.GT.41) K=41
      IF(K.LE.0) K=1
C*** jms 16.06.2010
      cmap(ir,k) = star(i)
   30 CONTINUE
  200 CONTINUE
C
      WRITE(6,2000)
      WRITE(6,2001)
C
      DO 40 J=1,22
      K=42-J
C*** jms 16.06.2010
   40 write(6,2002) (cmap(ir,k),ir=1,nrmax)
      WRITE(6,2005) RLINE
      DO 45 J=23,41
      K=42-J
C*** jms 16.06.2010
   45 write(6,2002) (cmap(ir,k),ir=1,nrmax)
C
      RETURN
C
 1000 FORMAT(2F10.4,E10.3,F10.4)
 1001 FORMAT(1X,2F10.4,E10.3,F10.4)
 1002 FORMAT(4F10.0)
 1003 FORMAT(1X,2F10.3,F10.0,F10.3)
 1004 FORMAT(6F10.4)
 1005 FORMAT(1X,6F10.4)
 2000 FORMAT('1ORIGINAL MODULATION TRANSFER FUNCTION ...')
 2001 FORMAT('0SUBSTITUTED CONTRAST TRANSFER FUNCTION ***'//)
 2002 FORMAT(1X,132A1)
 2003 FORMAT('1SCALING FACTORS FOR CORRECTION OF CONTRAST, AS A FUNCTION
     . OF R'//)
 2004 FORMAT(1X,2E12.3)
 2005 FORMAT('+',2X,13F10.4)
      END
C
C**************************************************************************
C
C     EMBES2
C
C***************************************************************************
C
      SUBROUTINE EMBES2
C     ROUTINE TO GENERATE POSITIVE ORDEF BESSELS FOR BATCHES OF
C     2000 ARGUMENTS
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),IN(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50)
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
      KK = KMIN-1
      IBD = KMAX - KMIN + 1
C
      DO 200 K = 1,IBD
      MIN = 1
      ARG = TWODD * KK
      BFA = BSL0(ARG)
      IF(IN(1).NE.0) GO TO 44
      BSA(K,1) = BFA
      MIN  = 2
 44   IF(ARG.GT.0.000001) GO TO 31
      MSTART = MIN
      GO TO 23
 31   BFB = BSL1(ARG)
      RECIP = 2.0 / ARG
      JMAX=0
C
      DO 100 M = MIN,NB
      JMIN = JMAX + 1
      JMAX = IN(M)
      IF(JMAX.EQ.0) GO TO 200
      IF(ARG.GT.0.825 * (JMAX - 4.9)) GO TO 32
      MSTART = M
      GO TO 23
 32     DO 102 J = JMIN,JMAX
      X = J * BFB * RECIP - BFA
      BFA = BFB
      BFB = X
 102  CONTINUE
      BSA(K,M) = BFA
 100  CONTINUE
      GO TO 200
C
 23   DO 105 M = MSTART,NB
 105  BSA(K,M) = 0.0
C
C     IF(KK.LE.100) WRITE(6,1000) ARG,(BSA(K,M),M=1,NB)
 1000 FORMAT(1X,E12.4,5X,7E10.3)
 200    KK = KK + 1
      RETURN
      END
C
C************************************************************************
C
C     EMHFH2
C
C************************************************************************
C
      SUBROUTINE EMHFH2
C     NEW HELICAL FOURIER SYNTHESIS PROGRAMMME, CALCULATES -ONTAL SECTIONS
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),IN(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50)
C*** jms 01.02.2012  DIMENSION RHO(51,181),FRRAD(81,75),FRANG(81,75),IRAD(81,75),IANG(8
C***     11,75),IDEN(81,75),IPROJN(81,200),WRT(81)
      DIMENSION RHO(512,2048),FRRAD(512,512),FRANG(512,512),IRAD(512,512),
     * IANG(512,512),IDEN(512,512),IPROJN(512,512),WRT(512)
      INTEGER*2 IRAD,IANG,IDEN,IPROJN
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C!!!      EQUIVALENCE (BSA(1),RHO(1)),(BSA(9232),FRRAD(1)),
C!!!     1 (BSA(15307),FRANG(1)),(BSA(21382),IRAD(1)),
C!!!     2 (BSA(27457),IANG(1)),(BSA(33532),IDEN(1))
C***      EQUIVALENCE (BSA(1,1),RHO(1,1)),(BSA(9232),FRRAD(1,1)),
C***     1 (BSA(15307),FRANG(1,1)),(BSA(21382),IRAD(1,1)),
C***     2 (BSA(27457),IANG(1,1)),(BSA(33532),IDEN(1,1))
CTSH      REAL*4 TLE1(5)/'Z-SE','CTIO','N   ','    ','    '/,
CTSH     .       TLE2(5)/'SIDE','-PRO','JECT','ION ','    '/
CTSH++
	REAL*4 TLE1(5),TLE2(5)
	CHARACTER*20 TMPTLE1/'Z-SECTION'/
	CHARACTER*20 TMPTLE2/'SIDE-PROJECTION'/
	EQUIVALENCE (TMPTLE1,TLE1),(TMPTLE2,TLE2)
CTSH--
C
C
      TWOPI=6.28318
      DEGREE=360./TWOPI
      NQUAD=(PHIMAX-PHIMIN)/90.0+0.51
      IF(NQUAD.GE.3) NQUAD=4
      IF(NQUAD.LE.0) NQUAD=4
      NPHI=181
      DPHI=NQUAD*0.5
   3  PHI0=PHIMIN
C
      DELX=DELSR
      IOUT = IABS(KOUT)
      IF(IOUT.EQ.1) THEN
C      DELY=10.0*DELSR/12.0
      DELY=0.8*DELSR
      ELSE
      DELY = DELSR
      END IF
C
      LIMR=RMAX/DELSR+1.1
      LIMX=RMAX/DELX+1.1
      LIMY=RMAX/DELY+1.1
      LIMX21=2*LIMX-1
      LIMY21=2*LIMY-1
c	write(6,'(''emhfh2 limr,limx,limy'',3i10)') limr,limx,limy
      IF(NQUAD.GT.2) GO TO 2
      LIMX21=LIMX
      LIMX=1
      IF(NQUAD.EQ.2) GO TO 2
      LIMY21=LIMY
    2 NZ=(ZMAX-ZMIN)/DELZED+1.1
C*** jms 01.02.2012      IF(LIMX21.GT.81) LIMX21=81
C***      IF(LIMY21.GT.75) LIMY21=75
      IF(LIMX21.GT.512) LIMX21=512
      IF(LIMY21.GT.512) LIMY21=512
C
C     ARRAYS CONT. POLAR COORDS OF (X,Y) POINTS
C!!!! need to look at these
      DO 110 I=1,LIMX21
      X=(I-LIMX)*DELX
      DO 110 J=1,LIMY21
      Y=(LIMY21-LIMY+1-J)*DELY
      R=SQRT(X*X+Y*Y)/DELSR
      IF(X.EQ.0.) THEN
      IF(Y.LE.0.) ANG = 0.
      IF(Y.GT.0.) ANG = 180.
      ELSE IF (Y.EQ.0.) THEN
      IF(X.LT.0.) ANG = 270.
      IF(X.GT.0.) ANG = 90.
      ELSE
      ANG=ATAN2(X,-Y)*DEGREE
      IF(ANG.LT.0.0) ANG=ANG+360.
      END IF
      ANG=ANG/DPHI
      IRAD4=R
      IRAD(I,J)=IRAD4+1
      FRRAD(I,J)=R-FLOAT(IRAD4)
      IANG4=ANG
      IANG(I,J)=IANG4+1
  110 FRANG(I,J)=ANG-FLOAT(IANG4)
C
C     FOURIER SUMMATION FOR POLAR COORDS.
C     RHO(R)=SUM(GLIT(R).EXP(I(N*PHI-2*PI*L*Z/C)))
C     COMBINING GLIT(L,N) & GLIT(-L,-N)   RHO = A*COS(   ) - B*SIN(   )
      DPHI=DPHI/57.2958
      PHI0=PHI0/57.2958
      PIBYC=TWOPI/C
      IRMAX=LIMR-1
      RECY=1.0/FLOAT(LIMY21)
      DO 113 I=1,5
  113 TITLE(I)=TLE1(I)
C
      IF(IOUT.GT.1) THEN
      ISTREAM = 2
c	write(6,'(''emhfh2 open:'',3i10)')LIMX21,LIMY21,NZ
      CALL  IOPEN(ISTREAM,LIMX21,LIMY21,NZ,TITLE)
      DCMIN = 1.E10
      DCMAX = 0.
      END IF
C
c	write(6,'(''emhfh2 :'',5i10)')nz,nphi,limr,llmax,limr
      DO 200 IZ=1,NZ
       Z=(IZ-1)*DELZED+ZMIN
       RECZ=PIBYC*Z
       PHI=PHI0
       DO 202 IPHI=1,NPHI
        DO 201 IR=1,LIMR
  201   RHO(IR,IPHI)=0.0
        DO 203 LL=1,LLMAX
         PHIZ=NN(LL)*PHI-NL(LL)*RECZ
         APART=COS(PHIZ)
         BPART=SIN(PHIZ)
         DO 204 IR=1,LIMR
  204    RHO(IR,IPHI)=RHO(IR,IPHI)+GLITA(IR,LL)*APART-GLITB(IR,LL)*BPART
  203   CONTINUE
        PHI=PHI+DPHI
  202 CONTINUE
C
C     INTERPOLATION ON TO (X,Y) GRID
c	write(6,'(''emhfh2 limx21,limy21'',2i10)')limx21,limy21
      DO 300 IX=1,LIMX21
      DO 350 IY=1,LIMY21
      IDEN(IX,IY)=0
      IF(IRAD(IX,IY).GT.IRMAX) then
c	write(6,'(''*** irad(ix,iy),ix,iy,irmax :'',4i10)')
c     *  irad(ix,iy),ix,iy,irmax
c	pause
	GO TO 350
	end if
      FRR=FRRAD(IX,IY)
      FRRBAR=1.-FRR
      FRA=FRANG(IX,IY)
      FRABAR=1.-FRA
      IR=IRAD(IX,IY)
      IPHI=IANG(IX,IY)
      IDEN(IX,IY)=FRRBAR*FRABAR*RHO(IR,IPHI)
     1           +FRRBAR*FRA   *RHO(IR,IPHI+1)
     2           +FRR   *FRABAR*RHO(IR+1,IPHI)
     3           +FRR   *FRA   *RHO(IR+1,IPHI+1)
  350 CONTINUE
      IF(IZ.GT.200) GO TO 300
      PROJ=0.0
      DO 351 IY=1,LIMY21
  351 PROJ=PROJ+IDEN(IX,IY)
      IPROJN(IX,IZ)=PROJ*RECY*4.0
  300 CONTINUE
C
C     TONE output
C
      IF(IOUT.GT.1) THEN
      DO 261 IY=1,LIMY21
      KY = LIMY21 + 1 - IY
      DO 262 IX=1,LIMX21
      DEN = IDEN(IX,KY)
      IF(DEN.LT.DCMIN) DCMIN = DEN
      IF(DEN.GT.DCMAX) DCMAX = DEN
      WRT(IX) = DEN
  262 CONTINUE
      CALL  IWRLIN(ISTREAM,WRT)
  261 CONTINUE
      END IF
C
C     line printer output
C
      IF(IOUT.NE.2) THEN
      WRITE(6,21) Z,(TITLE(I),I=6,15),IZ
      IF(LIMX21.GT.41) GO TO 220
      DO 210 IY=1,LIMY21
  210 WRITE(6,12) (IDEN(IX,IY),IX=1,LIMX21)
      GO TO 200
C
  220 DO 230 IY=1,LIMY21
  230 WRITE(6,12) (IDEN(IX,IY),IX=1,41)
      WRITE(6,21) Z,(TITLE(I),I=6,15),IZ
      DO 240 IY=1,LIMY21
  240 WRITE(6,12) (IDEN(IX,IY),IX=42,LIMX21)
      END IF
C
  200 CONTINUE
      IF (IOUT.GT.1) CALL  ICLOSE(ISTREAM,DCMIN,DCMAX)
C
C     OUTPUT OF PROJECTION
      IF(NQUAD.EQ.1) RETURN
      DO 340 I=1,5
      TITLE(I) = TLE2(I)
  340 CONTINUE
C
      IF(IOUT.GT.1) THEN
      ISTREAM = 3
CTSH      NNZ = JMIN0(NZ,200)
CTSH++
      NNZ = MIN0(NZ,200)
CTSH--
      CALL  IOPEN(ISTREAM,LIMX21,NNZ,1,TITLE)
      DCMIN = 1.E10
      DCMAX = 0.
      DO 330 IZ=1,NNZ
      DO 320 IX=1,LIMX21
      DEN = IPROJN(IX,IZ)
      IF(DEN.LT.DCMIN) DCMIN = DEN
      IF(DEN.GT.DCMAX) DCMAX = DEN
      WRT(IX) = DEN
  320 CONTINUE
      CALL  IWRLIN(ISTREAM,WRT)
  330 CONTINUE
      CALL  ICLOSE(ISTREAM,DCMIN,DCMAX)
      END IF
C
C     line printer output
C
      IF(IOUT.NE.2) THEN
      NOSEC = LIMX21 / 40 + 1
      I1 = 1
      DO 360 KZ=1,NOSEC
      WRITE(6,17) (TITLE(I),I=6,15)
      I2 = MIN(I1+40,LIMX21)
      DO 310 JZ=1,NNZ
      IZ = NNZ - JZ + 1
      WRITE(6,12) (IPROJN(IX,IZ),IX=I1,I2)
  310 CONTINUE
      I1 = I2 + 1
  360 CONTINUE
      END IF
      RETURN
C
C
C
   10 FORMAT(I10,6F10.0)
   11 FORMAT(11H1SECTION Y=,F5.0,5X,20A4)
   12 FORMAT(/T2,41I3)
   13 FORMAT(I10,6F10.0)
   14 FORMAT(1X,20A4/I10,' STEPS OF',F7.2,' A. C =',F8.1,' RESOLUTION ='
     1,F7.1,' A')
   15 FORMAT(40I3)
   21 FORMAT(11H1SECTION Z=,F5.0,5X,10A4,I40)
   17 FORMAT('1PROJECTION ',20A4)
      END
C
C**************************************************************************
C
C     EMHFC2
C
C****************************************************************************
C
      SUBROUTINE EMHFC2
C     NEW FOURIER SYNTHESIS IN CYLINDRICAL SECTIONS
C
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),in(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50)
C***      DIMENSION IRHO(181,100),ICAV(51,100),RHO(181),WRT(181)
      DIMENSION IRHO(512,512),ICAV(408,400),RHO(512),WRT(512)
C!!!      EQUIVALENCE (BSA(1),ICAV(1)),(BSA(5101),IRHO(1))
C***      EQUIVALENCE (BSA(1,1),ICAV(1,1)),(BSA(5101),IRHO(1,1))
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
CTSH      REAL*4 TLE1(5)/'CYLI','ND. ','SECT','ION ','    '/,TLE2(5)/'CYLI',
CTSH     .'ND. ','AVER','AGE ','    '/
CTSH++
	REAL*4 TLE1(5),TLE2(5)
	CHARACTER*20 TMPTLE1/'CYLIND.SECTION'/
	CHARACTER*20 TMPTLE2/'CYLIND.AVERAGE'/
	EQUIVALENCE (TMPTLE1,TLE1),(TMPTLE2,TLE2)
CTSH--
C
      TWOPI=6.28318
      PIBYC=TWOPI/C
      DPHI=DELPHI/57.2958
      NPHI=(PHIMAX-PHIMIN)/DELPHI+1.1
      IF(NPHI.LE.181) GO TO 3
      DPHI=(PHIMAX-PHIMIN)/(180.0*57.2958)
      NPHI=181
   3  LIMR0=RMIN/DELSR+1.1
      LIMR1=RMAX/DELSR+1.1
      NRSEC = (RMAX - RMIN)/DELSR + 1.1
      IF(LIMR0.EQ.1) LIMR0=2
      NZ=(ZMAX-ZMIN)/DELZED+1.1
C
C
      DO 4 I = 1,5
4     TITLE(I) = TLE1(I)
C
      IOUT = IABS(KOUT)
      IF(IOUT.GT.1) THEN
      ISTREAM = 2
      CALL  IOPEN(ISTREAM,NPHI,NZ,NRSEC,TITLE)
      DCMIN = 1.E10
      DCMAX = 0.
      END IF
C
      DO 200 IR=1,LIMR1
      DO 205 IZ=1,NZ
      Z=(IZ-1)*DELZED+ZMIN
      RECZ=PIBYC*Z
      DO 201 IPHI=1,NPHI
  201 RHO(IPHI)=0.0
      CAV=0.0
C
      DO 202 LL=1,LLMAX
      ZLBYC=RECZ*NL(LL)
      IF(NN(LL).NE.0) GO TO 210
      CAV=CAV+GLITA(IR,LL)*COS(-ZLBYC)-GLITB(IR,LL)*SIN(-ZLBYC)
  210 IF(IR.LT.LIMR0) GO TO 202
      PHI=PHIMIN/57.2958
      DO 203 IPHI=1,NPHI
      PHIZ=NN(LL)*PHI-ZLBYC
      APART=COS(PHIZ)
      BPART=SIN(PHIZ)
      RHO(IPHI)=RHO(IPHI)+GLITA(IR,LL)*APART-GLITB(IR,LL)*BPART
  203 PHI=PHI+DPHI
  202 CONTINUE
      DO 99 IPHI=1,NPHI
   99 IRHO(IPHI,IZ)=RHO(IPHI)
  205 ICAV(IR,IZ)=CAV*CAVSCL
C
      IF(IR.LT.LIMR0) GO TO 200
C
C     TONE output
C
      IF(IOUT.GT.1) THEN
      DO 270 JZ=1,NZ
      DO 272 IPHI = 1,NPHI
      DEN = IRHO(IPHI,JZ)
      IF(DEN.LT.DCMIN) DCMIN = DEN
      IF(DEN.GT.DCMAX) DCMAX = DEN
      WRT(IPHI) = DEN
  272 CONTINUE
      CALL  IWRLIN(ISTREAM,WRT)
270   CONTINUE
      END IF
C
C     line printer output
C
      IF(IOUT.NE.2) THEN
      R=(IR-1)*DELSR
      I1=1
  250 I2=NPHI
      IF(I2-I1.GT.39) I2=I1+39
      WRITE(6,1000)R,(TITLE(I),I = 6,15),IR
      DO 260 JZ=1,NZ
      IZ=NZ+1-JZ
  260 WRITE(6,1002) (IRHO(IPHI,IZ),IPHI=I1,I2)
      IF(I2.GE.NPHI) GO TO 200
      I1=I2+1
      GO TO 250
      END IF
C
  200 CONTINUE
      IF(IOUT.GT.1) CALL ICLOSE(ISTREAM,DCMIN,DCMAX)
C
C     OUTPUT OF CYLINDRICAL AVERAGE
C
      DO 300 I=1,5
      TITLE(I) = TLE2(I)
  300 CONTINUE
C
C     TONE output
C
      IF(IOUT.GT.1) THEN
      ISTREAM = 3
      CALL  IOPEN(ISTREAM,LIMR1,NZ,1,TITLE)
      DCMIN = 1.E10
      DCMAX = 0.
      DO 330 IZ=1,NZ
      DO 320 IR=1,LIMR1
      DEN = ICAV(IR,IZ)
      IF(DEN.LT.DCMIN) DCMIN = DEN
      IF(DEN.GT.DCMAX) DCMAX = DEN
      WRT(IR) = DEN
  320 CONTINUE
      CALL  IWRLIN(ISTREAM,WRT)
  330 CONTINUE
      CALL  ICLOSE(ISTREAM,DCMIN,DCMAX)
      END IF
C
C     line printer output
C
      IF(IOUT.NE.2) THEN
      NOSEC = LIMR1 / 40 + 1
      I1 = 1
      DO 360 KZ=1,NOSEC
      WRITE(6,1001) (TITLE(I),I=6,15)
      I2 = MIN(I1+40,LIMR1)
      DO 310 JZ=1,NZ
      IZ=NZ-JZ+1
      WRITE(6,1002) (ICAV(IR,IZ),IR=I1,I2)
  310 CONTINUE
      I1 = I2 + 1
  360 CONTINUE
      END IF
C
      RETURN
C
1000  FORMAT('1CYLINDRICAL SECTION, RADIUS ',F8.1,2X,10A4,I40)
1001  FORMAT('1CYLINDRICAL AVERAGE , ',10A4)
 1002 FORMAT(/T2,41I3)
      END
C
C**************************************************************************
C
C     EMHFV2
C
C****************************************************************************
C
      SUBROUTINE EMHFV2
C     NEW FOURIER SYNTHESIS IN VERTICAL SECTIONS
C
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C*** jms 01.02.2012 DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
      DIMENSION BSA(4072,200),in(200),GLITA(408,200),GLITB(408,200),WT(200)
C*** jms 01.02.2012 DIMENSION TITLE(15),NN(50),NL(50),IRHO(51,100),RHO(51),WRT(51)
      DIMENSION TITLE(15),NN(50),NL(50),IRHO(408,400),RHO(408),WRT(408)
C!!!      EQUIVALENCE (BSA(1),IRHO(1))
C***      EQUIVALENCE (BSA(1,1),IRHO(1,1))
CTSH      REAL*4 TLE(5)/'VERT','ICAL',' SEC','TION','    '/
CTSH++
	REAL*4 TLE(5)
	CHARACTER*20 TMPTLE/'VERTICAL SECTION'/
	EQUIVALENCE (TMPTLE,TLE)
CTSH--
C
      TWOPI=6.28318
      PIBYC=TWOPI/C
      NPHI=(PHIMAX-PHIMIN)/DELPHI+1.1
      LIMR0=RMIN/DELSR
      NR=(RMAX-RMIN)/DELSR+1.1
      IOUT = IABS(KOUT)
      IF(IOUT.GT.1) DELZED=DELSR
      NZ=(ZMAX-ZMIN)/DELZED+1.1
      PHI=PHIMIN
      IF(NZ.GT.100) RETURN
C
      DO 100 I = 1,5
100   TITLE(I) = TLE(I)
C
      IF(IOUT.GT.1) THEN
      ISTREAM = 2
      CALL  IOPEN(ISTREAM,NR,NZ,NPHI,TITLE)
      DCMIN = 1.E10
      DCMAX = 0.
      END IF
C
      DO 200 IPHI=1,NPHI
      PHIR=PHI/57.2958
      DO 205 IZ=1,NZ
      Z=(IZ-1)*DELZED+ZMIN
      RECZ=PIBYC*Z
      DO 201 IR=1,NR
  201 RHO(IR)=0.0
C
      DO 202 LL=1,LLMAX
      ZLBYC=RECZ*NL(LL)
      PHIZ=NN(LL)*PHIR-ZLBYC
      APART=COS(PHIZ)
      BPART=SIN(PHIZ)
      DO 202 IR=1,NR
      JR=LIMR0+IR
      RHO(IR)=RHO(IR)+GLITA(JR,LL)*APART-GLITB(JR,LL)*BPART
  202 CONTINUE
      DO 205 IR=1,NR
  205 IRHO(IR,IZ)=RHO(IR)
C
C     TONE output
C
      IF(IOUT.GT.1) THEN
      DO 265 JZ=1,NZ
      DO 300 IR = 1,NR
      DEN = IRHO(IR,IZ)
      IF(DEN.LT.DCMIN) DCMIN = DEN
      IF(DEN.GT.DCMAX) DCMAX = DEN
      WRT(IR) = DEN
  300 CONTINUE
      CALL  IWRLIN(ISTREAM,WRT)
265   CONTINUE
      END IF
C
C     lineprinter output
C
      IF(IOUT.NE.2) THEN
      I1=1
  250 I2=NR
      IF(I2-I1.GT.39) I2=I1+39
      WRITE(6,1000) PHI,(TITLE(I),I = 6,15),IPHI
      DO 260 JZ=1,NZ
      IZ=NZ+1-JZ
  260 WRITE(6,1002) (IRHO(IR,IZ),IR=I1,I2)
      IF(I2.GE.NR) GO TO 200
      I1=I2+1
      GO TO 250
      END IF
C
  200 PHI=PHI+DELPHI
C
      IF(IOUT.GT.1) CALL  ICLOSE(ISTREAM,DCMIN,DCMAX)
      RETURN
C
 1000 FORMAT('1VERTICAL SECTION, PHI= ',F8.1,2X,10A4,I40)
 1002 FORMAT(/T2,40I3)
      END
C
C**************************************************************************
C
C     EMHFP2
C
C****************************************************************************
C
      SUBROUTINE EMHFP2
C     FOURIER SYNTHESIS IN PARALLEL VERTICAL SECTIONS
C
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C*** jms 01.02.2012      DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
C***      DIMENSION TITLE(15),NN(50),NL(50),RHO(101,100),IRHO(101,100)
      DIMENSION BSA(4072,200),in(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50),RHO(404,400),IRHO(404,400)
C***      DIMENSION WRT(101)
      DIMENSION WRT(404)
C***      EQUIVALENCE (IRHO(1),RHO(1))
CTSH      REAL*4 TLE(5)/'X-SE','CTIO','N   ','    ','    '/
CTSH++
	REAL*4 TLE(5)
	CHARACTER*20 TMPTLE/'X-SECTION'/
	EQUIVALENCE (TMPTLE,TLE)
CTSH--
C
      NHALF=(PHIMAX-PHIMIN)/180.0+0.51
      IF(NHALF.GE.2) NHALF=2
      IF(NHALF.LE.0) NHALF=2
C
      PHIMIN=PHIMIN*3.14159/180.0
      IOUT = IABS(KOUT)
C
      IF(IOUT.EQ.1) THEN
      DELY=12.0*DELZED/10.0
      ELSE
      DELY=DELZED
      END IF
C
      RMIN=XMIN
      IF(XMIN.LT.0.0.AND.XMAX.GT.0.0) RMIN=0.0
      IF(XMIN.LT.0.0.AND.XMAX.LE.0.0) RMIN=-XMAX
      LIMY=SQRT(RMAX*RMAX-RMIN*RMIN)/DELY+1.1
      LIMX0=XMIN/DELX+SIGN(0.1,XMIN/DELX+0.1)
      LIMX1=XMAX/DELX+1.1
      LIMX21=LIMX1-LIMX0
      LIMY21=LIMY*2-1
      IF(NHALF.EQ.2) GO TO 20
      LIMY21=LIMY
      LIMY=1
   20 NZ=(ZMAX-ZMIN)/DELZED+1.1
      IF(LIMY21.GT.101) RETURN
      IF(NZ.GT.100) RETURN
      CELLA=(LIMX21-1)*DELX
      CELLB=(LIMY21-1)*DELY
    5 RECC=6.28318/C
      NY=LIMY21
      IF(NY.GT.41) NY=41
C
      DO 200 I = 1,5
200   TITLE(I) = TLE(I)
C
      IF(IOUT.GT.1) THEN
      ISTREAM = 2
      CALL  IOPEN(ISTREAM,LIMY21,NZ,LIMX21,TITLE)
      DCMIN = 1.E10
      DCMAX = 0.
      END IF
C
      DO 110 IX=1,LIMX21
      X=(IX-1+LIMX0)*DELX
      IY2=NY
      IF(IOUT.NE.2) WRITE(6,1001) X,(TITLE(I),I = 6,15),IX
      DO 120 IY=1,LIMY21
      Y=(IY-LIMY)*DELY
      R=SQRT(X*X+Y*Y)/DELSR
      ANG=0.0
      IF((X.EQ.0).AND.(Y.EQ.0)) GO TO 111
      ANG=ATAN2(Y,X)+PHIMIN
  111 IRAD=R
      RBIT=R-IRAD
      RBAR=1.0-RBIT
      DO 99 IZ=1,NZ
      RHO(IY,IZ)=0.0
   99 CONTINUE
C
      DO 120 LL=1,LLMAX
      AP=RBAR*GLITA(IRAD+1,LL)+RBIT*GLITA(IRAD+2,LL)
      BP=RBAR*GLITB(IRAD+1,LL)+RBIT*GLITB(IRAD+2,LL)
      PHIN=NN(LL)*ANG
      RECCL=RECC*NL(LL)
      PHIZ=PHIN-RECCL*ZMIN
      CPH=COS(PHIZ)
      SPH=SIN(PHIZ)
      PHIZ=-RECCL*DELZED
      CDPH=COS(PHIZ)
      SDPH=SIN(PHIZ)
C
      DO 120 IZ=1,NZ
      RHO(IY,IZ)=RHO(IY,IZ)+AP*CPH-BP*SPH
      CTEMP=CPH*CDPH-SPH*SDPH
      STEMP=CPH*SDPH+SPH*CDPH
      CPH=CTEMP
      SPH=STEMP
  120 CONTINUE
C
C     TONE output
C
      IF(IOUT.GT.1) THEN
      DO 145 JZ=1,NZ
      DO 240 IY = 1,LIMY21
      DEN = RHO(IY,JZ)
      IF(DEN.LT.DCMIN) DCMIN = DEN
      IF(DEN.GT.DCMAX) DCMAX = DEN
      WRT(IY) = DEN
  240 CONTINUE
      CALL  IWRLIN(ISTREAM,WRT)
  145 CONTINUE
      END IF
C
C     line printer output
C
      IF(IOUT.NE.2) THEN
      DO 130 JZ=1,NZ
      IZ=NZ+1-JZ
      DO 140 IY=1,LIMY21
  140 IRHO(IY,IZ)=RHO(IY,IZ)
      WRITE(6,1002) (IRHO(IY,IZ),IY=1,IY2)
  130 CONTINUE
C
  135 IF(IY2.EQ.LIMY21) GO TO 110
      IY1=IY2+1
      IY2=IY1+40
      IF(IY2.GT.LIMY21) IY2=LIMY21
      WRITE(6,1001) X,(TITLE(I),I = 6,15),IX
      DO 150 JZ=1,NZ
      IZ=NZ+1-JZ
      WRITE(6,1002) (IRHO(IY,IZ),IY=IY1,IY2)
  150 CONTINUE
      GO TO 135
      END IF
C
  110 CONTINUE
      IF(IOUT.GT.1) CALL  ICLOSE(ISTREAM,DCMIN,DCMAX)
      RETURN
1001  FORMAT('SECTION, X= ',F7.1,5X,10A4,I40)
 1002 FORMAT(/1X,41I3)
 1004 FORMAT('0SECTIONS ON ARGUS TAPE ARE ROTATED BY 90 DEGREES')
      END
C
C**************************************************************************
C
C     EMHFZP
C
C****************************************************************************
C
      SUBROUTINE EMHFZP
C     PROJECTION DOWN Z-AXIS OF HFH RECONSTRUCTION
C
      COMMON C,DELBR,ZMIN,ZMAX,DELZED,RMIN,RMAX,DELSR,PHIMIN,PHIMAX,
     1DELPHI,LLMAX,IJUMP,NB,TWODD,KMIN,KMAX,IN,WT,BSA,GLITA,GLITB,
     2TITLE,NN,NL,CAVSCL,XMIN,XMAX,DELX,MIND,DMIN,KOUT
C*** jms 01.02.2012  DIMENSION BSA(1018,50),IN(50),GLITA(51,50),GLITB(51,50),WT(100)
C***      DIMENSION TITLE(15),NN(50),NL(50),RHO(101,100),IRHO(101,100)
      DIMENSION BSA(4072,200),in(200),GLITA(408,200),GLITB(408,200),WT(400)
      DIMENSION TITLE(15),NN(50),NL(50),RHO(404,400),IRHO(404,400)
C***      EQUIVALENCE (IRHO(1),RHO(1))
CTSH      REAL*4 TLE(5)/'Z-PR','OJEC','TION','    ','    '/
CTSH++
	REAL*4 TLE(5)
	CHARACTER*20 TMPTLE/'Z-PROJECTION'/
	EQUIVALENCE (TMPTLE,TLE)
CTSH--
C
C
      PHIMIN=PHIMIN*3.14159/180.0
      DELY=DELSR
      DELX=DELSR/0.9
      LIMY=RMAX/DELY+1.1
      LIMX=RMAX/DELX+1.1
      NZ=(ZMAX-ZMIN)/DELZED+1.1
      LIMY21=2*LIMY-1
      LIMX21=2*LIMX-1
    5 RECC=6.28318/C
      IY2=LIMY21
      IF(IY2.GT.41) IY2=41
C
      DO 50 I = 1,5
50    TITLE(I) = TLE(I)
C
      WRITE(6,1001)(TITLE(I),I = 6,15)
      DO 110 IX=1,LIMX21
      X=DELX*(LIMX-IX)
      DO 130 IY=1,LIMY21
      Y=(IY-LIMY)*DELY
      R=SQRT(X*X+Y*Y)/DELSR
      ANG=0.0
      IF((X.EQ.0).AND.(Y.EQ.0)) GO TO 111
      ANG=ATAN2(Y,X)+PHIMIN
  111 IRAD=R
      RBIT=R-IRAD
      RBAR=1.0-RBIT
      RHO(IY,IX)=0.0
C
      DO 130 IZ=1,NZ
      Z=ZMIN+(IZ-1)*DELZED
      RHOZ=0.0
C
      DO 120 LL=1,LLMAX
      AP=RBAR*GLITA(IRAD+1,LL)+RBIT*GLITA(IRAD+2,LL)
      BP=RBAR*GLITB(IRAD+1,LL)+RBIT*GLITB(IRAD+2,LL)
      PHIN=NN(LL)*ANG
      RECCL=RECC*NL(LL)
      PHIZ=PHIN-RECCL*Z
  120 RHOZ=RHOZ+AP*COS(PHIZ)-BP*SIN(PHIZ)
C
      IF(MIND.EQ.0) GO TO 130
      RHOZ=RHOZ*MIND
      IF(RHOZ.LT.DMIN) RHOZ=DMIN
  130 RHO(IY,IX)=RHO(IY,IX)+RHOZ
C
      DO 140 IY=1,LIMY21
      IF(MIND.LT.0) RHO(IY,IX)=-RHO(IY,IX)
  140 IRHO(IY,IX)=RHO(IY,IX)/NZ+0.5
      WRITE(6,1002) (IRHO(IY,IX),IY=1,IY2)
  110 CONTINUE
C
  135 IF(IY2.EQ.LIMY21) RETURN
      IY1=IY2+1
      IY2=IY1+40
      IF(IY2.GT.LIMY21) IY2=LIMY21
      WRITE(6,1001)(TITLE(I),I = 6,15)
      DO 150 IX=1,LIMX21
      WRITE(6,1002) (IRHO(IY,IX),IY=IY1,IY2)
  150 CONTINUE
      GO TO 135
C
1001  FORMAT('1PROJECTION DOWN Z-AXIS',5X,10A4)
 1002 FORMAT(/1X,41I3)
      END
      FUNCTION BSL0(X0)
      IF(X0-4.0)910,911,911
 910  X2=(X0/4.0)**2
      BSL0 = ((((((-0.00050144*X2+0.00767719)*X2-0.07092536)*X2+
     1  0.44435843)*X2-1.7777561)*X2+3.9999973)*X2-3.9999999)*X2+1.0
      GOTO912
 911  X1=4.0/X0
      X2 = X1**2
      P = ((((-0.00000370*X2+0.0001736)*X2-.48761E-04)*X2+0.00017343)* X
     12-0.00175306)*X2+0.39894228
      Q = (X1)*(((((0.00000323*X2-0.00001421)*X2+0.00003425)*X2-
     1  0.00008698)*X2+0.00045643)*X2-0.01246694)
      BSL0 = SQRT(X1)*(P*COS(X0-.7853981E+00)-Q*SIN(X0-.7853981E+00))
 912  RETURN
      END
      FUNCTIONBSL1(X0)
      IF(X0-4.0)913,914,914
 913  X1=X0/4.0
      X2 = X1**2
      BSL1 = X1*(((((((-0.0001290 *X2+0.0022069 )*X2-0.02366168)*X2+
     1  0.1777583 )*X2-0.8888840 )*X2+2.6666661)*X2-4.0)*X2+2.0)
      GO TO 915
 914  X1=4.0/X0
      X2 = X1**2
      P = ((((0.0000042 *X2-0.0000201 )*X2+0.0000581 )*X2-0.0002232 )*X2
     1  +0.0029218 )*X2+0.3989423
      Q = (X1)*(((((-0.0000037 *X2+0.0000162 )*X2-.398708E-04)*X2+ 0.000
     11065 )*X2-0.0006390 )*X2+0.0374008 )
      BSL1 = SQRT(X1)*(P*SIN(X0-.7853981E+00)+Q*COS(X0-.7853981E+00))
 915  RETURN
      END
C
C***********************************************************************
C
C     subroutine iopen
C
C************************************************************************
C     subroutine to open image file for output
C
      SUBROUTINE  IOPEN(ISTREAM,NX,NY,NZ,TITLE)
      DIMENSION NXYZ(3),TITLE(15),TITLEO(20)
CTSH      DATA BLANK/'    '/
CTSH++
	CHARACTER*4 TMPBLANK/'    '/
	EQUIVALENCE (TMPBLANK,BLANK)
CTSH--
C
      NXYZ(1) = NX
      NXYZ(2) = NY
      NXYZ(3) = NZ
      K = 6
      DO 10 I=1,10
      TITLEO(I) = TITLE(K)
      K = K + 1
   10 CONTINUE
      DO 20 I=11,20
      TITLEO(I) = BLANK
  20  CONTINUE
      IF(ISTREAM.EQ.2) THEN
c*** jms 08.04.2012      CALL  IMOPEN(ISTREAM,'OUT1','NEW')
      CALL  IMOPEN(ISTREAM,'OUT1','UNKNOWN')
      ELSE
C*** jms 08.04.2012      CALL  IMOPEN(ISTREAM,'OUT2','NEW')
      CALL  IMOPEN(ISTREAM,'OUT2','UNKNOWN')
      END IF
      DMIN = 0.
      DMAX = 0.
      DMEAN = 0.
      CALL  ICRHDR(ISTREAM,NXYZ,NXYZ,2,TITLEO,1)
      CALL  IWRHDR(ISTREAM,TITLEO,-1,DMIN,DMAX,DMEAN)
      RETURN
      END
C
C************************************************************************
C
C     subroutine iclose
C
C************************************************************************
C     subroutine to close image output file
C
      SUBROUTINE ICLOSE(ISTREAM,DMIN,DMAX)
      DIMENSION TITLE(20)
      DMEAN = DMIN + (DMAX - DMIN) / 2.
      CALL  IWRHDR(ISTREAM,TITLE,-1,DMIN,DMAX,DMEAN)
      CALL  IMCLOSE(ISTREAM)
      RETURN
      END
