C****MERGE.INC
C	INCLUDE PARAMETER BLOCK FOR MERGING PROGRAM
C
      PARAMETER (DRAD=0.0174532)
      PARAMETER (MAXOBS=200000)
      PARAMETER (MAXPTS=150000,MAXIDX=30,MAXREFL=3000)
      PARAMETER (IARSIZ=76)
C
C DEFINITION OF VARIABLES:
C
C	MAXPTS=MAXIMUM NUMBER OF POINTS IN CURVE LIST
C
      COMMON /HKZ/ JHC(MAXPTS),JKC(MAXPTS),ZCURVE(MAXPTS),
     $CURVIN(MAXPTS),CRVERR(MAXPTS),				!300,000
     $IPNTR(-MAXIDX:MAXIDX,-MAXIDX:MAXIDX,2),			!7442
     $JREFC,KCURV,TITLE(10),CELL(4),DZ,				!17
     $SPACER(3837),	!TOT ARRAY SIZE= 76 * 4096 * 4 BYTES
C
C   CURVE ARRAYS CONTAINING -
C	JHC	- H INDICES FROM CURVES
C	JKC	- K INDICES FROM CURVES
C	ZCURVE	- ZSTAR POSITION ALONG CURVE
C		   NOTE THAT CURVES ARE SAMPLED AT INTERVALS OF DZ
C	CURVIN	- INTENSITY VALUE
C	JREFC	- NUMBER OF POINTS ON CURVES
C	KCURV	- CURVE IDENTIFICATION NUMBER
C	TITLE	- CURVE TITLE
C	SPACER	- JUST THAT, TOTAL WORDS IN THIS SPACE:
C		   IARSIZ BLOCKS OF 4096 WORDS
C
C
C	IPNTR	- POINTER ARRAY INTO CURVE ARRAYS
C  USE POINTER ARRAY TO FIND APPROPRIATE ZSTAR VALUE FROM CURVE.
C  POINTER ARRAY SET UP SUCH THAT H,K MATRIX CONTAINS INDEX OFFSETS
C  INTO CURVE VECTOR.  SINCE NOT ALL H,K'S EXIST, MATRIX MAY NOT BE
C  FULLY POPULATED.  THE INTERVAL BETWEEN SUCCESSIVE DATA POINTS ALONG
C  THE ZSTAR DATA CURVE IS ASSUMED TO BE THE PARAMETER DZ
C
     $ITITLE(20),
C	JUST A TITLE ARRAY FOR CONVENIENCE - USED IN IOPRELCF
C
     $IIH(MAXREFL),IIK(MAXREFL),DINA(MAXREFL),
C
C	THESE TWO ARE LOCAL H,K'S
C	IIH	- H INDICES MODIFIED BY ASYM
C	IIK	- K INDICES MODIFIED BY ASYM TO PRODUCE H,K'S IN
C			ONE QUADRANT
C	DINA	- DIN MODIFIED TO REFLECT IP1 IN ASYM (FOR ANOMALOUS)
C
     $IHIN(MAXREFL),IKIN(MAXREFL),ZIN(MAXREFL),
     $RIIN(MAXREFL),DIN(MAXREFL),
C
C	IHIN	- H INDEX INPUT FROM .LST FILE (IE. ORIGINAL H)
C	IKIN	- K INDEX INPUT FROM .LST FILE
C	ZIN	- ZSTAR VALUE ORIGINALLY CALCULATED FROM INPUT
C			TILTAXIS AND TILTANGLE AND UPDATED AS TILT
C			AXIS REFINEMENTS PROCEED, IN SUBR TILT
C	RIIN	- INTENSITIES INPUT FROM .LST FILE
C	DIN	- DIFFERENCES INPUT FROM .LST FILE
C*** THESE LAST 7 ARRAYS ARE LOCAL ARRAYS FOR THE CURRENT INPUT FILM
C
     $JH(MAXOBS),JK(MAXOBS),ZSTAR(MAXOBS),
     $RINT(MAXOBS),DIFF(MAXOBS),
C
C	THESE ARE GLOBAL ARRAYS FOR REFLECTIONS
C
C	JH	- H INDEX FOR GLOBAL REFLECTION
C	JK	- K INDEX FOR GLOBAL REFLECTION
C	ZSTAR	- ZSTAR VALUE OF GLOBAL REFLECTION
C			THESE H,K'S AND ZSTAR'S ARE THE ASYM MODIFIED ONES
C			ZSTAR CAN ALSO BE MODIFIED BY SUBROUTINE TILT
C
C	RINT	- INTENSITIES OF GLOBAL REFLECTIONS
C	DIFF	- DIFFERENCES ASSOCIATED WITH EACH REFLECTION
C
C			THESE ARE COMPUTED BY APPLYING
C			SCALE AND TEMPERATURE FACTORS TO THE INPUT
C			INTENSITIES (DONE IN APPLY_SCALE_B)
C
     $JOUT(MAXOBS),JFILM(MAXOBS),
C
C	JOUT	- POINTER ARRAY USED FOR SORTING
C	JFILM	- ARRAY FOR FILM NUMBERS
C
     $ASTAR,BSTAR,ABANG
C
C	ASTAR	-
C	BSTAR	- CELL AXES LENGTHS IN ANGSTROMS
C	ABANG	- INTERAXIS RECIPROCAL SPACE ANGLE IN DEGREES
