C  SYNFITP3
C
C	VX1.1	RH	24.2.95	converted to unix
C	VX1.2	RH	5.11.98	add PARAMETER increase dimensions
C
C  VAX VERSION  JULY 84
C  VERSION FOR P3; USES GUIDE POINTS FROM PREVIOUS CURVES
C  IF REQUIRED; THESE POINTS INCLUDED WITH DATA FOR LINE WITH
C  FILM NUMBER SET TO 0
C  FIT SYNC FUNCTIONS TO LATTICE LINES PRODUCED BY MERGHIGH
C  WITH OR WITHOUT PREPARATION OF INPUT DATA SET FOR PLOTTING
C  VERSION INCLUDES ESTIMATES OF ERRORS IN SYNC FUNCTION COEFFS
C  AND ERRORS IN FITTED CURVE.  ALSO CALCULATES MERGING R-FACTORS
C  UNIT 2 USED FOR FITTED CURVES
C  THIS VERSION DOES NOT ELIMINATE NEGATIVE SYNC FUNCTION COEFFS
C    MISSING REGIONS OF THE LATTICE LINE ARE FILLED IN AS INTERNAL
C    GUIDE POINTS
C
C     THERE WILL BE AN OPTION WHICH WILL ALLOW PRINT OUT OF A COMPLETE
C     SET OF RECIPROCAL LATTICE AMPLITUDES IN A 500 ANGSTROM UNIT CELL FOR
C     SUBSEQUENT USE IN COMPUTING THE THREE-DIMENSIONAL STRUCTURE.
C
C    DATA SETS USED ARE:-
C     (1)  LATTICE LINE DATA POINTS FOR CURVE FITTING
C         FORMAT OF DATASET:- TITLE RECORD,I10,10A4;
C                        H,K,ZSTAR,AMP,DIFF,IFILM (2I3,F7.4,2F8.1,I6)
C                        TERMINATED 100,100 ETC
C     (2)  DATASET FOR NEW FITTED CURVES
C         H K 'L' INT SIG
C         FORMAT (2I4,3(2X,F8.1)); TERMINATED 100,100
C     (3)  OUTPUT FORMATTED LIST OF SYNC FUNCTION COEFFICIENTS
C         H K; 'L' COEFF
C         FORMAT F8.1, F12.3
C     (10) PLOT DATA SET READY FOR PROGRAM PLOTCRVS
C          BINARY DATA SET- SEE SUBROUTINE POINTS FOR CONTENT OF THIS
C
C    DATA CARDS ARE
C    (1) IPLOT     (*)
C    IF IPLOT=0, FITS SYNC FUNCTIONS AND COMPUTES R-FACTORS ONLY;
C    IF IPLOT=1, FITS SYNC FUNCTIONS, COMPUTES R-FACTORS, AND
C                PLOTS DATA POINTS AND FITTED CURVES
C    (2) ACELL,BCELL,GAMMA       (*)
C        2D UNIT CELL DIMENSIONS
C    (3) CCELL   C-axis cell dimension for syn-function fit.
C    (4) RESMAX,BSINC,SIGMIN,SIGMAX,SIGUID     (*)
C        RESMAX; DATA DISCARDED IF (1/D**2) > RESMAX (IN ANGS**-2)
C        BSINC;  APPLIES TEMP FACTOR EQUIVALENT TO 2*BSINC TO
C                SINCS IN CURVE FITTING
C        SIGMIN; MINIMUM SIGMA FOR CURVE FITTING
C        SIGMAX; MAXIMUM SIGMA FOR CURVE FITTING
C        SIGUID; SIGMA FOR INTERNAL GUIDE POINTS IS SIGUID*(AVERAGE
C                SIGMA OF NEAREST DATA POINTS). SIGMA IS DOUBLED
C                AS GUIDE POINTS GET FURTHER FROM DATA POINTS.
C     (5) SSQFIX,SSQDAT      (*)
C         IF SSQFIX=0.0, CALCULATE REQUIRED ERRORS SCALE FACTOR
C         FOR EACH LINE AND COMPUTE OVERALL SCALE FACTOR THAT
C         WILL BE NEEDED EVENTUALLY
C         IF SSQFIX=1.0, USE PREVIOUSLY CALCULATED SCALE FACTOR
C         FOR ALL LINES, SET BY SSQDAT
C       ALL THESE HAVE DEFAULT VALUES IF SET AS 0.
C
C
C
C     DATA SET IN PROGRAM BASED ON VALUE OF C THAT IS INPUT AS DATA:-
C          WSTAR
C          DZ
C          WLHALF
C          XMARGN
C          SNCSTP
C     IRFLMN;  MINIMUM NUMBER OF POINTS IN LATTICE LINE TO CURVE FIT
C
C	NMAX IS MAXIMUM NUMBER OF POINTS ON EACH LATTICE LINE
C	NCMX IS MAXIMUM NUMBER OF POINTS ON EACH FITTED CURVE
C
C
      PARAMETER (NMAX=2000)
      PARAMETER (NCMX=500)
      DIMENSION TITLE(10)
      INTEGER IFILM(NMAX)
      DIMENSION SIG(NMAX),PZ(NMAX),PAMP(NMAX),PDIF(NMAX)
      DIMENSION ERRY(NCMX),CURVX(NCMX),CURVY(NCMX)
      DIMENSION SUMDY(10,11),SUMY(10,11),SUMEC(10,11),SUMC(10,11)
      DIMENSION NBINRY(10,11),NBINRC(10,11)
      DIMENSION RFMERG(10,11),RFCURV(10,11)
      DIMENSION SUMDYZ(10),SUMYZ(10),NRYZ(10),NRCZ(10)
      DIMENSION SUMECZ(10),SUMCZ(10)
      DIMENSION SYNC(1200)
      DIMENSION SUMDYD(11),SUMYD(11),NRYD(11)
      DIMENSION SUMECD(11),SUMCD(11),NRCD(11)
      DIMENSION RALLZ(11)
      DIMENSION DSTSQ(11)
C
CTSH not used anywhere      DATA BLANK/'    '/
    1 FORMAT(/' SYNCFITP3 vx1.2(5-Nov-1998) fits sync ',
     .	 'functions to merged data'/)
    2 FORMAT(//)
   11 FORMAT(I10,10A4)
    3 FORMAT(2I5,2F10.4,F10.5,I5)
    6 FORMAT(5F8.2,15X,F10.4,F10.2,I8,F8.3,I5,F8.3,I5)
    9 FORMAT(' REFLECTION    ZSTAR INTENSITY   STNDEV  PLATENO '/
     1'    IH   IK'//)
   10 FORMAT(1X,2I4,F12.7,F9.0,F8.0,I7,I4)
13    FORMAT(//' *******************************************************
     1******************************************************************
     2*****'//)
14    FORMAT(' RUN NUMBER OF MERGED DATA SET ',I5,10A4)
17    FORMAT(I10)
20    FORMAT(2I3,2I6)
22    FORMAT(2I3,F6.3,F6.0)
C
      PI=3.14159
C
C
      MTOT=0.0
      NTOT=0.0
      TSQRS=0.0
C
      WRITE(6,1)
C
      READ(5,*)IPLOT
      CALL CCPDPN(10,'PLOTDATA','UNKNOWN','U',0,0)
      CALL CCPDPN(3,'COEFFS','UNKNOWN','F',0,0)
      CALL CCPDPN(2,'CURVES','UNKNOWN','F',0,0)
      CALL CCPDPN(1,'INLIST','READONLY','F',0,0)
      READ(1,11)NSER,TITLE
      WRITE(6,14)NSER,TITLE
C
      IF(IPLOT.EQ.1) WRITE(6,9011)
9011   FORMAT(' PLOT DATA WRITTEN TO UNIT 10')
      IPLOTC=0
C
C
      IF(IPLOT.EQ.0)WRITE(6,403)
      IF(IPLOT.EQ.1)WRITE(6,404)
403   FORMAT(' SYNC FUNCTIONS FITTED TO LATTICE LINES')
404   FORMAT(' SYNC FUNCTIONS FITTED; LATTICE LINE DATA POINTS',
     1' AND FITTED CURVES PREPARED FOR PLOTTING')
C
      READ(5,*)ACELL,BCELL,GAMMA
      WRITE(6,26)ACELL,BCELL,GAMMA
26    FORMAT(' 2D UNIT CELL DIMENSIONS AND ANGLE',3F7.2)
      GAMMA=(PI*GAMMA)/180.
      ASTAR=1.0/(ACELL*SIN(GAMMA))
      BSTAR=1.0/(BCELL*SIN(GAMMA))
      ASTRSQ=ASTAR**2
      BSTRSQ=BSTAR**2
      READ(5,*)CCELL
      WRITE(6,926)CCELL
926   FORMAT(' C UNIT CELL DIMENSION ',F8.3/)
      CSTAR=1.0/CCELL
      DCELL=CCELL*5.0
      WRITE(6,927)DCELL
927   FORMAT(' OUTPUT OF CURVE DATA BASED ON L INDEX FROM CCELL =',
     .F7.2)
      DCSTAR=1.0/DCELL
      WLHALF=CSTAR
      DZ=CSTAR/5.0
      XMARGN=CSTAR/2.0
      SNCSTP=CSTAR/20.0
      WSTAR=3*DZ
C
      READ(5,*)RESMAX,BSINC,SIGMIN,SIGMAX,SIGUID
      IF(SIGMIN.EQ.0.)SIGMIN=200.
      IF(SIGMAX.EQ.0.)SIGMAX=1000.
      IF(SIGUID.EQ.0.)SIGUID=2.0
      IF(RESMAX.EQ.0.)RESMAX=1/9.0
      IF(BSINC.EQ.0.)BSINC=-50.0
C
      WRITE(6,25)SIGMIN,SIGMAX,SIGUID,RESMAX,BSINC
25    FORMAT(' SIGMIN=',F7.1,' SIGMAX=',F7.1,' SIGUID=',F5.1,
     1' RESMAX=',F7.4,' BSINC=',F7.1)
C
      READ(5,*)SSQFIX,SSQDAT
      IF (SSQFIX.EQ.0.0)WRITE(6,9925)
      IF(SSQFIX.NE.0.0)WRITE(6,925)SSQDAT
925   FORMAT(' ERRORS SCALE FACTOR SET TO ',E20.4,' FOR ALL CURVES')
9925  FORMAT(' ERRORS SCALE FACTOR CALCULATED FOR EACH CURVE')
C
C  CLEAR ARRAYS FOR ACCUMULATION OF R-FACTOR DATA
      DO 9012 I=1,10
      DO 9012 J=1,11
      SUMDY(I,J)=0.
      SUMY(I,J)=0.
      SUMC(I,J)=0.
      SUMEC(I,J)=0.
      NBINRY(I,J)=0
      NBINRC(I,J)=0
9012  CONTINUE
C
9015   CONTINUE
C
      WRITE(2,9018)NSER,TITLE
9018  FORMAT(I10,10A4,'  CURVES')
      WRITE(2,9019)ACELL,BCELL,CCELL,DCELL
9019  FORMAT(4F8.2,' UNIT CELL DIMENSIONS; CCELL FOR L INDEX')
81    FORMAT(2I4,3(2X,F8.1))
      NCURVE=0
C
C    SET UP TABLE OF SYNC FUNCTIONS/
9016  CONTINUE
      PIW=PI/WLHALF
      BSYNC=BSINC
      SYNC(1)=1.0
      DO 9013 I=2,1200
      XKN=(I-1)*SNCSTP
      XF=XKN*PIW
      SYNC(I)=(SIN(XF))/(XF)
      XSQ=XKN**2
      ARG=BSYNC*XSQ
      SYNC(I)=SYNC(I)*EXP(ARG)
9013   CONTINUE
C
C
C
C
      IREFL=0
      NG1=0
      NG2=0
      NDATA=0
      N=0
      IRJ=0
      LH=0
      LK=0
      IRFLMN=4
      AMPMAX=0.
C     READ DATA SET OF LATTICE LINES
2010  N=N+1
      IF (N.GT.NMAX)THEN
      WRITE(6,16001)NMAX
16001 FORMAT(' MORE DATA THAN ALLOWED FOR IN CURRENT DIMENSIONS',I8)
      STOP
      ELSE
      CONTINUE
      END IF
      READ(1,2001)IH,IK,PZ(N),PAMP(N),PDIF(N),IFILM(N)
2001  FORMAT(2I5,F10.4,2F10.1,I6)
C
      IF(IFILM(N).EQ.0.AND.NDATA.EQ.0)NG1=NG1+1
      IF(IFILM(N).NE.0.AND.NDATA.EQ.0)IREFL=IREFL+1
      IF(IFILM(N).NE.0.AND.NDATA.NE.0)IREFL=IREFL+1
      IF(IFILM(N).EQ.0.AND.NDATA.NE.0)NG2=NG2+1
      IF(IFILM(N).NE.0.AND.NDATA.EQ.0)NDATA=1
      IF(PDIF(N).LT.0.)SIG(N)=-PDIF(N)/2.0
      IF(PDIF(N).GE.0)SIG(N)=PDIF(N)/2.0
      IF(SIG(N).LE.SIGMIN)SIG(N)=SIGMIN
      IF(SIG(N).GT.SIGMAX)SIG(N)=SIGMAX
C
      IF(IH.NE.LH.OR.IK.NE.LK)GO TO 2020
C      WRITE(6,2001)IH,IK,PZ(N),PAMP(N),PDIF(N),IFILM(N)
C
      LH=IH
      LK=IK
      DSTRSQ=QHK+PZ(N)**2
      IF(DSTRSQ.GT.RESMAX)GO TO 2009
      IF(PAMP(N).GT.AMPMAX)AMPMAX=PAMP(N)
C
      GO TO 2010
2009  N=N-1
      IREFL=IREFL-1
      IRJ=IRJ+1
      GO TO 2010
C
2020  CONTINUE
      PZSAVE=PZ(N)
      PAMPSV=PAMP(N)
      PDIFSV=PDIF(N)
      SIGSV=SIG(N)
      IFILSV=IFILM(N)
      IF(LH.EQ.0.AND.LK.EQ.0)GO TO 2021
C
      IF(IFILM(N).EQ.0)NG2=NG2-1
      IF(IFILM(N).NE.0)IREFL=IREFL-1
      IF(IFILM(N).NE.0)NDATA=0
      N=N-1
      WRITE(6,12022)N,NG1,NG2
12022 FORMAT(/' TOTAL NUMBER OF POINTS FOR LINE',I5/
     1' NUMBER OF GUIDE POINTS AT EACH END OF LINE',2I5)
C
      WRITE(6,2022)LH,LK,IREFL
2022  FORMAT(' NUMBER OF DATA POINTS IN LINE',2I3,I10)
C      WRITE(6,2026)(PZ(I),PAMP(I),SIG(I),I=1,IREFL)
2026  FORMAT((F10.4,2F10.0))
      WRITE(6,2008)IRJ
2008  FORMAT(' NUMBER OF POINTS REJECTED',I5)
      IF(IREFL.GE.IRFLMN)GO TO 2023
      WRITE(6,2024)
2024  FORMAT(' NOT ENOUGH POINTS FOR CURVE FITTING')
      NGUIDE=-1
      GO TO 2025
C
2023  CALL GUIDE(LH,LK,N,NGUIDE,PZ,PAMP,SIG,SIGMIN,SIGMAX,
     1SIGUID,WSTAR,DCSTAR)
C
      IF(IPLOT.EQ.0.OR.IPLOT.EQ.1)CALL LINE(LH,LK,IREFL,NG1,NG2,
     1NGUIDE,PZ,PAMP,IFILM,
     2SIG,CURVX,CURVY,ERRY,QHK,SUMDY,SUMY,NBINRY,SUMEC,SUMC,
     3NBINRC,SYNC,BSYNC,DZ,XMARGN,WLHALF,SNCSTP,SIGMIN,NCURVE,
     4MTOT,NTOT,TSQRS,SSQFIX,SSQDAT,DCELL,DCSTAR,NCMX)
C
      IF(NGUIDE.EQ.-1)WRITE(6,2024)
C
C
2025  IF(IPLOT.EQ.1)CALL POINTS(IPLOTC,NSER,AMPMAX,LH,LK,IREFL,
     1NGUIDE,NG1,NG2,PZ,PAMP,SIG,TITLE,CURVX,CURVY,ERRY,DCSTAR)
C
2021  PZ(1)=PZSAVE
      PAMP(1)=PAMPSV
      PDIF(1)=PDIFSV
      SIG(1)=SIGSV
      IFILM(1)=IFILSV
      LH=IH
      LK=IK
      IF(LH.EQ.100)GO TO 2000
C
      AMPMAX=PAMP(1)
      IREFL=0
      NG1=0
      NG2=0
      NDATA=0
      N=1
      IRJ=0
      QHK=ASTRSQ*LH*LH + BSTRSQ*LK*LK
      IF(IFILM(1).EQ.0)NG1=NG1+1
      IF(IFILM(1).NE.0)IREFL=IREFL+1
      IF(IFILM(1).NE.0)NDATA=1
C
      GO TO 2010
2000  CONTINUE
C
C
C
500   JH=100
      DUMMY=0.
      IF(IPLOT.EQ.0.OR.IPLOT.EQ.1) WRITE(2,81) JH,JH,DUMMY,DUMMY,DUMMY
      WRITE(6,501)NCURVE
501   FORMAT(/' NUMBER OF POINTS IN CURVES DATA SET =',I12)
C  OUTPUT OF R-FACTORS
      SUMTY=0.
      SUMTC=0.
      SUMTDY=0.
      SUMTEC=0.
      NALLY=0.
      NALLC=0.
      DO 909 I=1,10
      SUMDYZ(I)=0.
      SUMYZ(I)=0.
      NRYZ(I)=0
      SUMECZ(I)=0.
      SUMCZ(I)=0.
      NRCZ(I)=0
909   CONTINUE
C
      DO 908 J=1,11
      SUMDYD(J)=0.
      SUMYD(J)=0.
      NRYD(J)=0
      SUMECD(J)=0.
      SUMCD(J)=0.
      NRCD(J)=0
908   CONTINUE
      DO 907 I=1,10
      DO 907 J=1,11
      IF(SUMY(I,J).NE.0.0)GO TO 1001
      RFMERG(I,J)=0.0
      GO TO 1002
1001  RFMERG(I,J)=SUMDY(I,J)/SUMY(I,J)
1002  IF(SUMC(I,J).NE.0.0)GO TO 1003
      RFCURV(I,J)=0.0
      GO TO 1004
1003  RFCURV(I,J)=SUMEC(I,J)/SUMC(I,J)
1004  SUMTY=SUMTY+SUMY(I,J)
      SUMTDY=SUMTDY+SUMDY(I,J)
      NALLY=NALLY+NBINRY(I,J)
      SUMDYZ(I)=SUMDYZ(I)+SUMDY(I,J)
      SUMYZ(I)=SUMYZ(I)+SUMY(I,J)
      NRYZ(I)=NRYZ(I)+NBINRY(I,J)
C
      SUMTC=SUMTC+SUMC(I,J)
      SUMTEC=SUMTEC+SUMEC(I,J)
      NALLC=NALLC+NBINRC(I,J)
      SUMECZ(I)=SUMECZ(I)+SUMEC(I,J)
      SUMCZ(I)=SUMCZ(I)+SUMC(I,J)
      NRCZ(I)=NRCZ(I)+NBINRC(I,J)
C
      SUMDYD(J)=SUMDYD(J)+SUMDY(I,J)
      SUMYD(J)=SUMYD(J)+SUMY(I,J)
      NRYD(J)=NRYD(J)+NBINRY(I,J)
      SUMECD(J)=SUMECD(J)+SUMEC(I,J)
      SUMCD(J)=SUMCD(J)+SUMC(I,J)
      NRCD(J)=NRCD(J)+NBINRC(I,J)
C
907   CONTINUE
C   WRITE TABLES OF R-FACTORS
C  FIRST R-FACTOR BETWEEN DATA AND CURVE
C
      WRITE(6,911)
911   FORMAT('1 TABLE 1: R-FACTORS BETWEEN DATA POINTS AND CURVE'///)
      DO 921 J=1,11
      DSTSQ(J)=0.005+(J-1)*0.01
921   CONTINUE
      WRITE(6,923)
923   FORMAT('     ZSTAR ',36X,'DSTARSQ RANGES',37X,5X,'ALL DSTARSQ'/)
      WRITE(6,922)(DSTSQ(J),J=1,11)
922   FORMAT(10X,11F8.3/)
      WRITE(6,924)
C
      DO 914 I=1,10
      IF(SUMYZ(I).NE.0.0)GO TO 1005
      RALLD=0.0
      GO TO 1006
1005  RALLD=SUMDYZ(I)/SUMYZ(I)
1006  ZEDST=0.015+(I-1)*0.030
      WRITE(6,912) ZEDST,(RFMERG(I,J),J=1,11),RALLD
912   FORMAT(F10.3,' * ',F5.3,10F8.3,5X,F8.3)
      WRITE(6,913) (NBINRY(I,J),J=1,11),NRYZ(I)
913   FORMAT(10X,' * ',I5,10I8,5X,I8/)
914   CONTINUE
C
      DO 920 J=1,11
      IF(SUMYD(J).NE.0.0)GO TO 1007
      RALLZ(J)=0.0
      GO TO 920
1007  RALLZ(J)=SUMDYD(J)/SUMYD(J)
920   CONTINUE
      IF(SUMTY.NE.0.0)GO TO 1011
      RALL=0.0
      GO TO 1012
1011  RALL=SUMTDY/SUMTY
1012  WRITE(6,916) (RALLZ(J),J=1,11),RALL
916   FORMAT(' ALL ZSTAR',' * ',F5.3,10F8.3,5X,F8.3)
      WRITE(6,913) (NRYD(J),J=1,11),NALLY
C
C  NEXT R-FACTOR BASED ON SIGMA VALUES OF CURVES
C
      WRITE(6,919)
919   FORMAT('1 TABLE 2: R-FACTORS FROM SIGMA VALUES OF CURVES'///)
      WRITE(6,923)
      WRITE(6,922)(DSTSQ(J),J=1,11)
      WRITE(6,924)
924   FORMAT(11X,'*************************************************',
     1'*******************************************************'/)
C
      DO 917 I=1,10
      IF(SUMCZ(I).NE.0.0)GO TO 1008
      RALLD=0.0
      GO TO 1009
1008  RALLD=SUMECZ(I)/SUMCZ(I)
1009  ZEDST=0.015+(I-1)*0.030
      WRITE(6,912) ZEDST,(RFCURV(I,J),J=1,11),RALLD
      WRITE(6,913) (NBINRC(I,J),J=1,11),NRCZ(I)
917   CONTINUE
      DO 918 J=1,11
      IF(SUMCD(J).NE.0.0)GO TO 1010
      RALLZ(J)=0.0
      GO TO 918
1010  RALLZ(J)=SUMECD(J)/SUMCD(J)
918   CONTINUE
      IF(SUMTC.NE.0.0)GO TO 1013
      RALL=0.0
      GO TO 1014
1013  RALL=SUMTEC/SUMTC
1014  WRITE(6,916) (RALLZ(J),J=1,11),RALL
      WRITE(6,913) (NRCD(J),J=1,11),NALLC
C
C
      IF(MTOT-NTOT.NE.0) THEN
      	SSQNEW=TSQRS/(MTOT-NTOT)
      	WRITE(6,9575)SSQNEW,MTOT,NTOT
9575	FORMAT(////' OVERALL VALUE OF (SUM W*DELSQ)/(MDATA-NCOEFFS)',
     1E20.4,' MDATA',I10,' NCOEFFS',I10)
      ELSE
      	WRITE(6,9576)
9576	FORMAT(' NOT ENOUGH DATA POINTS FOR MEANINGFULL SUMMARY')
      ENDIF
9902  STOP
      END
C
C
C
C
C
C  SUBROUTINE TO WRITE SCALED 3D LATTICE LINES TO UNIT 10
      SUBROUTINE POINTS(IPLOTC,NSER,AMPMAX,JH,JK,N,NGUIDE,NG1,NG2,X,Y,
     1SIG,TITLE,CX,CY,EY,DCSTAR)
C
C  WRITE DATA FOR EACH PLOT, WITH PLOT NUMBER,INDICES,NUMBER OF
C  POINTS, NUMBER OF GUIDE POINTS (NGUIDE),AND MAXIMUM AMP IN
C  INITIAL RECORD PER PLOT
C  NGUIDE =-1 INDICATES POINTS ONLY, NO FITTED CURVE FOR THIS LINE
C  INFORMATION ON PLOT DATA PRINTED ON 6
      DIMENSION SIG(1),X(1),Y(1),TITLE(1),CX(1),CY(1),EY(1)
      IPLOTC=IPLOTC+1
      WRITE(10)IPLOTC,JH,JK,N,NGUIDE,NG1,NG2,AMPMAX
      WRITE(10)NSER,(TITLE(J),J=1,10)
      WRITE(6,1)IPLOTC,JH,JK,N,NGUIDE,NG1,NG2,AMPMAX
1     FORMAT(' PLOT NUMBER',I5,' LINE',2I5,' NUMBER OF POINTS',4I5,
     1' MAXIMUM AMP',F10.0)
      NPLOT=N+NGUIDE+NG1+NG2
      IF(NGUIDE.EQ.-1)NPLOT=N+NG1+NG2
      DO 5 J=1,NPLOT
C
      WRITE(10)X(J),Y(J),SIG(J)
5     CONTINUE
      IF(NGUIDE.NE.-1)GO TO 8
      WRITE(6,10)
10    FORMAT(20X,' NO FITTED CURVE')
      GO TO 9
8     DO 6 J=1,500
      IF(CX(J).NE.100.)GO TO 6
      JLAST=J-1
      WRITE(6,11)JLAST
11    FORMAT(' NUMBER OF POINTS DESCRIBING FITTED CURVE =',I3)
      GO TO 13
6     CONTINUE
13    WRITE(10)JLAST
      DO 12 J=1,JLAST
      WRITE(10)CX(J),CY(J),EY(J)
12    CONTINUE
9     RETURN
      END
C
C
C
C
C
C     FIT SUM OF SYNC FUNCTIONS BY LEAST SQUARES TO EXPERIMENTAL DATA.
      SUBROUTINE LINE(JH,JK,MREFL,NG1,NG2,MGUIDE,X,Y,IFILM,
     1SIG,CX,CY,EY,QHK,
     2SUMDY,SUMY,NBINRY,SUMEC,SUMC,NBINRC,SYNC,BSYNC,DZ,XMARGN,WLHALF,
     3SNCSTP,SIGMIN,NCURVE,MTOT,NTOT,TSQRS,SSQFIX,SSQDAT,DCELL,DCSTAR,
     4NCMX)
C
C     SYNC FUNCTION COEFFS WRITTEN TO UNIT 3
c      REAL*8 AASTOR(91,91),AA(91,91),BB(91),CC(91),ECC(91),WKSPCE(455)
      REAL*8 AASTOR(91,91),AA(91,91),BB(91),CC(91),WKSPCE(455)
      REAL*8 E
      DIMENSION IFILM(1)
      DIMENSION SIG(1),X(1),Y(1),CX(1),CY(1),EY(1),S(91),XN(91)
      DIMENSION XNRPT(91)
      DIMENSION SUMDY(10,11),SUMY(10,11),SUMEC(10,11),SUMC(10,11)
      DIMENSION NBINRY(10,11),NBINRC(10,11)
c      DIMENSION XSAVE(20)
c      DIMENSION TXN(91),SYNC(1200)
      DIMENSION SYNC(1200)
      MTOTL=MREFL+NG1+NG2
      M=MTOTL+MGUIDE
      IF(M.LE.20) GO TO 90
      PI=3.1415926
      XST=X(1)-XMARGN
      XFI=X(MTOTL)+XMARGN
      IF(MGUIDE.EQ.0) GO TO 23
      IF(X(M).GT.X(MTOTL)) XFI=X(M)+XMARGN
      DO 21 J=1,MGUIDE
      K=J+MTOTL
      IF((X(K)-XMARGN).LT.XST)XST=X(K)-XMARGN
21    CONTINUE
23    CONTINUE
C*****FOLLOWING 2 LINES CORRECT FOR CENTROSYMMETRIC LINES ONLY
C*****INCLUDE COEFFS FROM Z=-0.1 TO MAX Z OD DATA TO ENSURE
C*****SYMMETRY THROUGH Z=0
C      IF(XST.LT.-0.1)XST=-0.1
C      IF(XFI.LT.0.1)XST=-XFI
C*****FOLLOWING LINE CORRECT FOR NON CENTROSYMMETRIC LINES
      IF(XST.LT.-0.30) XST=-0.30
      N1=XST/WLHALF - 1
      IF(XFI.GT.0.30) XFI=0.30
C
      N2=XFI/WLHALF + 1
      N=N2-N1+1
      IF(MTOTL.LE.1.75*N2) GO TO 90
      IF(MTOTL.LE.N)GO TO 90
      WRITE(6,7) DZ,XMARGN
      WRITE(3,7) DZ,XMARGN
7     FORMAT(' CURVE FITTING AT INTERVALS OF',F10.6,
     1'   WITH ADDED MARGIN',F10.6)
      DO 9 I=1,N
      XN(I)=(N1+I-1)*WLHALF
9     XNRPT(I)=XN(I)
      WRITE(6,1) MREFL,NG1,NG2,MGUIDE,N,XST,XFI,WLHALF,SNCSTP,BSYNC
      WRITE(3,1) MREFL,NG1,NG2,MGUIDE,N,XST,XFI,WLHALF,SNCSTP,BSYNC
1     FORMAT(' SYNC FUNCTION LEAST SQUARES USING',I5,
     1' DATA +',2I5,' EXTERNAL GUIDE POINTS FROM PREVIOUS CURVES +',
     2I5,' INTERNAL GUIDE POINTS FOR'/I5,' UNKNOWNS BETWEEN LIMITS',
     3F10.4,' AND',F10.4/F10.6,' WAS THE SYNC FUNC SEPARATION;',
     4' SNCSTP WAS',F10.6,';',F6.1,' WAS B IN EXP(B.X**2) APPLIED TO'
     5' SINC FUNCTION')
C
      IJUNKD=0
C     SET UP COEFFICIENTS OF LINEAR EQUATIONS
C
C     INITIALIZE COEFFICIENTS TO ZERO
8     DO 5 I=1,N
      BB(I)=0.0
      CC(I)=0.0
      DO 4 J=1,N
4     AA(I,J)=0.0
5     CONTINUE
      N5=5*N
      DO 105 I=1,N5
      WKSPCE(I)=0.0
105   CONTINUE
C     SUM DATA TO CALCULATE COEFFICIENTS
      DO 50 K=1,M
      IF(SIG(K).EQ.0.)WRITE(6,1001)K
1001  FORMAT(' SIG SOMEHOW IS ZERO FOR K=',I10)
      IF(SIG(K).EQ.0.)SIG(K)=SIGMIN
C
      WT=1/(SIG(K)**2)
      DO 10 I=1,N
      XKN=X(K)-XN(I)
      IF(XKN.LT.0.0)XKN=-XKN
      XKN=XKN/SNCSTP
      IKN=XKN
      DKN=XKN-IKN
      IKN=IKN+1
      IKN1=IKN+1
      IF(IKN1.LE.1200)GO TO 11
      S(I)=0.0
      GO TO 10
11    S(I)=SYNC(IKN)*(1.0-DKN)+SYNC(IKN1)*DKN
10    CONTINUE
      DO 20 I=1,N
      BB(I)=BB(I)+Y(K)*S(I)*WT
      DO 20 J=1,N
      AA(I,J)=AA(I,J)+S(I)*S(J)*WT
      IF (IJUNKD.EQ.0)AASTOR(I,J)=AA(I,J)
20    CONTINUE
50    CONTINUE
      IFAIL=0
      IA=91
      E=-1.0
      CALL MA21AD(AA,IA,N,BB,WKSPCE,E)
      IF(E.EQ.0.0)GO TO 60
      WRITE(6,101)E
      WRITE(3,101)E
101   FORMAT(' ERROR IN MA21AD, E=',E20.4)
      GO TO 90
60    WRITE(6,927)DCELL
      WRITE(3,927)DCELL
927   FORMAT(' OUTPUT OF SYNC FUNCTIONS BASED ON L INDEX FROM CCELL =',
     .F7.2)
      WRITE(3,3)JH,JK
3     FORMAT(' SOLUTIONS FROM MA21AD FOR LATTICE LINE',2I5/
     1'    "L"    SYNC FN INTENSITY')
      IF(IJUNKD.NE.0)GO TO 560
C  KEEP THIS INVERSE FOR ERROR CALCS EVEN IF SYNC TERMS ARE LATER REMOVED
      CALL MA21BD(AASTOR,IA,N,WKSPCE,E)
      IF(E.EQ.0.0)GO TO 560
      WRITE(6,102)E
      WRITE(3,102)E
102   FORMAT(' ERROR IN MA21BD, E=',E20.4)
      GO TO 90
560   CONTINUE
      IREMOV=0
C
      DO 70 K=1,N
C**   COEFFICIENTS WRITTEN OUT WITH 'L' RATHER THAN ZSTAR
      DXN=XN(K)/DCSTAR
      WRITE(3,6)DXN,BB(K)
6     FORMAT(F8.1,F12.3)
      CC(K)=BB(K)
70    CONTINUE
C
C
75    CONTINUE
C
C
475   CONTINUE
C  COMPUTE CURVE AT X VALUES OF DATA POINTS
      SMSQRS=0.
      SMDEL=0.
      SMY=0.
      NRF=0
      K1=NG1+1
      K2=NG1+MREFL
      DO 550 K=K1,K2
      IF(SIG(K).EQ.0)WRITE(6,1001)K
      IF(SIG(K).EQ.0)SIG(K)=SIGMIN
      WT=1/(SIG(K)**2)
      CURVE=0.
      DO 510 I=1,N
      IF(CC(I).EQ.0.0)GO TO 510
      XKN=X(K)-XN(I)
      IF(XKN.LT.0.0)XKN=-XKN
      XKN=XKN/SNCSTP
      IKN=XKN
      DKN=XKN-IKN
      IKN=IKN+1
      IKN1=IKN+1
      IF(IKN1.LE.1200)GO TO 509
      S(I)=0.0
      GO TO 510
509   S(I)=SYNC(IKN)*(1.0-DKN)+SYNC(IKN1)*DKN
      CURVE=CURVE+CC(I)*S(I)
510   CONTINUE
C
      DEL=CURVE-Y(K)
      IF(DEL.LT.0.0)DEL=-DEL
      IF(DEL.GT.(2*SIG(K)))WRITE(6,5109)X(K),Y(K),IFILM(K)
5109  FORMAT(' BAD REFLECTION; ZSTAR=',F6.3,' INTENSITY=',F7.0,
     1' FILM NUMBER=',I5)
      SMDEL=SMDEL+DEL
      NRF=NRF+1
      SMSQRS=SMSQRS+(DEL**2)*WT
      QHKL=QHK+X(K)**2
      NBIND=QHKL/0.01+1.0
      IF(NBIND.GT.11)NBIND=11
      XBIN=X(K)/0.03
      IF(XBIN.LT.0.0)XBIN=-XBIN
      NBINZ=XBIN+1.0
      IF(NBINZ.GT.10)NBINZ=10
      ADDYK=CURVE
      IF(ADDYK.LT.0.0)ADDYK=1.0
      SMY=SMY+ADDYK
      SUMDY(NBINZ,NBIND)=SUMDY(NBINZ,NBIND)+DEL
      SUMY(NBINZ,NBIND)=SUMY(NBINZ,NBIND)+ADDYK
      NBINRY(NBINZ,NBIND)=NBINRY(NBINZ,NBIND)+1
C
550   CONTINUE
C
      RFAC=SMDEL/SMY
      WRITE(6,570)RFAC,NRF
570   FORMAT(' RFACTOR BETWEEN DATA AND CURVE',F8.2,' ON',I5,' POINTS')
      WRITE(3,570)RFAC,NRF
      NFIX=0
      IF(MREFL.LE.N)GO TO 593
      SSQ=SMSQRS/(MREFL-N)
      WRITE(6,575)SSQ,MREFL,N
575   FORMAT(' VALUE OF (SUM W*DELSQ)/(MDATA-NCOEFFS) ',E20.4,
     1' MDATA',I5,' NCOEFFS',I5)
C
      IF(SSQFIX.NE.0.0)SSQ=SSQDAT
      WRITE(6,8575)SSQ
8575  FORMAT(' VALUE OF ERRORS SCALE FACTOR USED ',E20.4)
      TSQRS=TSQRS+SMSQRS
      MTOT=MTOT+MREFL
      NTOT=NTOT+N
C
      DO 580 I=1,N
      DO 580 J=1,N
      AA(I,J)=AASTOR(I,J)*SSQ
580   CONTINUE
C
      GO TO 595
593   NFIX=1
C  GIVE FIXED ESTIMATE OF ERROR
      WRITE(6,594)
594   FORMAT(' M<N, FIXED ERROR ESTIMATE GIVEN')
595   CONTINUE
C
C  COMPUTE LEAST SQUARES CURVE AND ERRORS OF POINTS ON CURVE
C******FOLLOWING LINES CORRECT FOR CENTROSYMMETRIC LINES
C******CALCULATE PART OF CURVE FOR -VE ZSTAR TO -0.02, BUT
C******DON'T INCLUDE IN STATISTICS
C      NST=(-0.02/DZ)
C      IF(X(MDATA).LT.0.02)NST=-X(MDATA)/DZ
C******FOLLOWING LINE CORRECT FOR NON CENTROSYMMETRIC LINES
C
C
C
C     WHERE GUIDE POINTS FROM PREVIOUS CURVES ARE USED AT EITHER END
C     OF THE DATA, COMPUTE CURVES OVER THESE REGIONS BUT DON'T INCLUDE
C     IN STATISTICS
C
      NST=(X(1)/DZ)-1.0
      NFI=(X(MTOTL)/DZ)+1.0
      NPTS=NFI-NST+1
      IF (NPTS.GT.NCMX)THEN
      WRITE(6,16001)NCMX
16001 FORMAT(' CURRENT DIMENSIONS FOR CURVE DATA SET INSUFFICIENT',I8)
      STOP
      ELSE
      CONTINUE
      END IF
C
      DO 80 J=1,NPTS
      CX(J)=DZ*(NST+J-1)
      CY(J)=0.0
C
C     DATA FOR OUTPUT TO CURVES DATA (2) SET WILL NOT EXTEND BEYOND THE
C     ACTUAL DATA POINTS
C     DATA FOR PLOTTING CURVES (10) WILL EXTEND THROUGH EXTERNAL GUIDE
C     POINTS IF THERE ARE ANY
      IF(CX(J).LT.X(K1))GO TO 975
      IF(CX(J).GT.X(K2))GO TO 975
C      IF(CX(J).LT.0)GO TO 975
      XBIN=CX(J)/0.03
      IF(XBIN.LT.0.0)XBIN=-XBIN
      NBINZ=XBIN+1.0
      IF(NBINZ.GT.10)NBINZ=10
      QHKL=QHK+CX(J)**2
      NBIND=QHKL/0.01+1.0
      IF (NBIND.GT.11)NBIND=11
975   DO 79 K=1,N
C
      XKN=CX(J)-XN(K)
      IF(XKN.LT.0.0)XKN=-XKN
      IKN=XKN/SNCSTP+1.1
      IF(IKN.LE.1200)GO TO 78
      S(K)=0.0
      GO TO 79
78    S(K)=SYNC(IKN)
      CY(J)=CY(J)+CC(K)*S(K)
79     CONTINUE
      IF(NFIX.NE.0)GO TO 981
      I=J
      PART1=0.
      DO 979 K=1,N
      PART2=0.
      DO 978 L=1,N
978   PART2=PART2+AA(K,L)*S(L)
979   PART1=PART1+S(K)*PART2
      EY(J)=SQRT(PART1)
      GO TO 983
981   EY(J)=100.0
983   CONTINUE
C
      IF(CX(J).LT.X(K1))GO TO 80
      IF(CX(J).GT.X(K2))GO TO 80
C      IF(CX(J).LT.0)GO TO 80
      ADDCY=CY(J)
      IF(ADDCY.LT.0.0)ADDCY=1.0
      SUMEC(NBINZ,NBIND)=SUMEC(NBINZ,NBIND)+EY(J)
      SUMC(NBINZ,NBIND)=SUMC(NBINZ,NBIND)+ADDCY
      NBINRC(NBINZ,NBIND)=NBINRC(NBINZ,NBIND)+1
      DXOUT=CX(J)/DCSTAR
      WRITE(2,81) JH,JK,DXOUT,CY(J),EY(J)
      NCURVE=NCURVE+1
80    CONTINUE
81    FORMAT(2I4,2X,F8.1,2X,F8.1,2X,F8.1)
      J=NPTS+1
      CX(J)=100.
      CY(J)=-100.0
C      WRITE(6,9000)
C9000  FORMAT(' TERMINATOR SET IN ARRAY')
      EY(J)=-100.0
900   RETURN
90    CONTINUE
C     DATA NOT SUITABLE TO CURVE FITTING; MGUIDE=-1 USED AS MARKER
      MGUIDE=-1
      RETURN
      END
C
C
C
C
C
C
C
C
      SUBROUTINE GUIDE(LH,LK,IREFL,NGUIDE,PZ,PAMP,SIG,SIGMIN,
     1SIGMAX,SIGUID,WSTAR,DCSTAR)
C
      DIMENSION SIG(1),PZ(1),PAMP(1)
      NDATA1=IREFL-1
C     IF THERE IS A GAP IN THE DATA WIDER THAN WSTAR/2 IN ZSTAR,
C     THEN INTERPOLATE LINEARLY BETWEEN THE NEAREST TWO DATA.
      NGUIDE=0
      DO 8510 J=1,NDATA1
      SPACE=PZ(J+1)-PZ(J)
      IF(SPACE.LT.(WSTAR/2.0)) GO TO 8510
      NADD=(SPACE/(WSTAR/2.0))
      SPACE=SPACE/(NADD+1)
      DO 8505 N=1,NADD
      NGUIDE=NGUIDE+1
      IADD=IREFL+NGUIDE
      PZ(IADD)=PZ(J) +SPACE*N
C  SET SIG TO SIGUID * AVERAGE SIG FOR DATA EITHER SIDE
C  DOUBLED AS GUIDE POINTS MOVE AWAY FROM DATA AT EITHER END
      N1=N
      N2=NADD+1-N
      IF(N1.GE.5) THEN
        NF=3
      ELSE
      	NF=N1*(1.5**(N1-1))
      ENDIF
      IF(N2.LT.N1) THEN
        IF(N2.GE.5) THEN
      	  NF=3
      	ELSE
      	  NF=N2*(1.5**(N2-1))
      	ENDIF
      ENDIF
      IF(NF.GT.3)NF=3
      SIG(IADD)=((SIG(J)+SIG(J+1))/2.)*SIGUID*NF
C      WRITE(6,101)J,SIG(J),SIG(J+1),SIGUID
C101   FORMAT(I5,2F8.1,F5.1)
C      WRITE(6,102)SIG(IADD)
C102   FORMAT(F8.1)
8505   PAMP(IADD)=(PAMP(J)*(NADD+1-N)+PAMP(J+1)*N)/(NADD+1)
8510   CONTINUE
      WRITE(6,8506)IREFL,NGUIDE
8506   FORMAT(/' NUMBER OF POINTS AND GENERAL GUIDE POINTS',2I5)

C
C ADD GUIDE POINTS WITH Z<0
C*****THIS SECTION MUST BE INACTIVATED IF SPACE GROUP DOES NOT
C*****HAVE LATTICE LINES THAT ARE SYMMETRIC ABOUT Z=0.
C      IADD=IREFL+NGUIDE
C      M=IADD
C      DO 8515 I=1,IADD
C      IF (PZ(I).GT.(0.10)) GOTO 8515
C      NGUIDE=NGUIDE+1
C      M=M+1
C      PZ(M)=PZ(I)*(-1.)
C      PAMP(M)=PAMP(I)
C      SIG(M)=SIG(I)
C8515  CONTINUE
C      WRITE(6,8507)
C8507  FORMAT(' GUIDE POINTS ADDED AT -VE Z FOR CENTROSYMMETRIC LINE')
C
C*****ADD GUIDE POINT AT Z=0 IF H OR K EQ 0 AND OTHER INDEX IS ODD
C      IF(LH.EQ.0)GO TO 8520
C      IF(LK.EQ.0)GO TO 8521
C      GO TO 8522
C8520  LK2=LK/2
C      IF((LK-2*LK2).EQ.0)GO TO 8522
C      GO TO 8523
C8521  LH2=LH/2
C      IF((LH-2*LH2).EQ.0)GO TO 8522
C8523  M=M+1
C      NGUIDE=NGUIDE+1
C      PZ(M)=0.
C      PAMP(M)=0.
C      SIG(M)=SIGMIN/10.0
C      WRITE(6,8508)
C8508  FORMAT(' GUIDE POINT ADDED AT Z=0')
C8522  CONTINUE
C
      RETURN
      END
C
C
C
C  Changes to make it work on Alliant
C
C  CHANGES PUT IN TO MAKE IT WORK ON VAX (THIS VERSION HAS SCALING)
C  1.  12 STATEMENTS FOR CALCULATION OF OVER/UNDERFLOW OF DETERMINANT IN MA21
C      REPLACED BY A SIMPLE ONE WHICH WILL OVERFLOW MORE EASILY(ENTRY MA21CD)
C  2.  CHANGES TO MC10AD TO REPLACE 370-SPECIFIC PARTS....
C      A. U=FLOATI  (6 TIMES)
C      B. NEW ALOG16 PROCEDURE (TWICE)
C      C. SIMPLER 16**DIAG STATEMENT (ONCE)
C  3.  ALL DOUBLE PRECISION REPLACED BY REAL*8 (NOT REALLY NECESSARY).
C  4.  REPLACE A(N),B(N) BY A(1),B(1) IN FM02AD TO AVOID VAX ARRAY CHECKING.
C
      FUNCTION FA01AS(I)
      COMMON/FA01ES/G
      REAL*8 G
      G=DMOD(G* 9228907.D0,4294967296.D0)
      IF(I.GE.0)FA01AS=G/4294967296.D0
      IF(I.LT.0)FA01AS=2.D0*G/4294967296.D0-1.D0
      RETURN
      END
      SUBROUTINE FA01BS(MAX,NRAND)
      NRAND=INT(FA01AS(1)*FLOAT(MAX))+1
      RETURN
      END
      SUBROUTINE FA01CS(IL,IR)
      COMMON/FA01ES/G
      REAL*8 G
      IL=G/65536.D0
      IR=G-65536.D0*FLOAT(IL)
      RETURN
      END
      SUBROUTINE FA01DS(IL,IR)
      COMMON/FA01ES/G
      REAL*8 G
      G=65536.D0*FLOAT(IL)+FLOAT(IR)
      RETURN
      END
C combined these two BLOCK DATA statements so that this file has only one.
      BLOCK DATA
      COMMON/FA01ES/G
      COMMON /MA21ED/LP,JSCALE,EA,EB
C JSCALE NORMALLY =1, TEMPORARILY SET TO 0
      INTEGER * 4 LP/6/,JSCALE/1/
      REAL * 8 EA/1.0D-16/,EB/1.0D-16/
      REAL*8 G
      DATA G/1431655765.D0/
      END
C    FM02AD - A ROUTINE TO COMPUTE THE INNER PRODUCT OF TWO
C      DOUBLE PRECISION REAL VECTORS ACCUMULATING THE RESULT
C      DOUBLE PRECISION.  IT CAN BE USED AS AN ALTERNATIVE
C      TO THE ASSEMBLER VERSION, BUT NOTE THAT IT IS LIKELY
C      TO BE SIGNIFICANTLY SLOWER IN EXECUTION.
C
      REAL*8 FUNCTION FM02AD(N,A,IA,B,IB)
      REAL*8 R1,A,B
C  THE FOLLOWING STATEMENT CHANGED FROM A(N),B(N) TO AVOID VAX DYNAMIC
C  ARRAY CHECK FAILURE.
      DIMENSION A(1),B(1)
C
C    N   THE LENGTH OF THE VECTORS (IF N<= 0  FM02AD = 0)
C    A   THE FIRST VECTOR
C    IA  SUBSCRIPT DISPLACEMENT BETWEEN ELEMENTS OF A
C    B   THE SECOND VECTOR
C    IB  SUBSCRIPT DISPLACEMENT BETWEEN ELEMENTS OF B
C    FM02AD  THE RESULT
C
      R1=0D0
      IF(N.LE.0) GO TO 2
      JA=1
      IF(IA.LT.0) JA=1-(N-1)*IA
      JB=1
      IF(IB.LT.0) JB=1-(N-1)*IB
      I=0
    1 I=I+1
      R1=R1+A(JA)*B(JB)
      JA=JA+IA
      JB=JB+IB
      IF(I.LT.N) GO TO 1
    2 FM02AD=R1
      RETURN
      END
C      BLOCK DATA
C      COMMON /MA21ED/LP,JSCALE,EA,EB
C JSCALE NORMALLY =1, TEMPORARILY SET TO 0
C      INTEGER * 4 LP/6/,JSCALE/1/
C      REAL * 8 EA/1.0D-16/,EB/1.0D-16/
C      END
      SUBROUTINE MA21AD (A,IA,N,B,W,E)
      COMMON /MA21ED/ LP,JSCALE,EA,EB
         REAL *  8 A(IA,N),B(N),W(N,N),AA,AC,DET,WW,Q(2),PCK
      REAL *8 EPS4/4.0D-16/,ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/,P5/0.5D0/
     1,E,EA,EB,EPSN,XNORM,AXNORM,ENORM,ENORMA,ANORMA,ANORM,ERR,AB,AM
     2,EPS /1.0D-16/,R(4),RA,FM02AD
CTSH      REAL*8DICT(8 )/' MA21AD ',' MA21BD ',' MA21CD ',' MA21DD ',
CTSH     1               ' N IS   ',' PIVOT  ','IS SMALL','IS ZERO '/
CTSH++
	REAL*8 DICT(8)
	CHARACTER*8 TMPDICT(8)/
     *   ' MA21AD ',' MA21BD ',' MA21CD ',' MA21DD ',
     *   ' N IS   ',' PIVOT  ','IS SMALL','IS ZERO '/
	EQUIVALENCE (TMPDICT,DICT)
CTSH--
C     EPS=MACHINE PRECISION,EPS4=EPS*4
C  I3, I4 previously initialised to 0 but changed because of EQUIVALENCE stmt.
C  MRO'D 23/10/81
c      INTEGER*4 I3,I4,I1(4)
      INTEGER*4 I3,I4
      REAL*4 UPCK(4)
c      LOGICAL*1 L1,L2,L3(4),L4(4),LQ,LA
      LOGICAL*1 L1,L2,L3(4),L4(4),LA
C      DATA LQ/Z40/	! not needed in this implementation
      EQUIVALENCE (Q(1),R(1),L1),(RA,LA),(WW,II),(UPCK(1),PCK),
     1            (Q(2),L2),(L3(1),I3),(L4(1),I4)
C  Next two lines inserted to initialise I3,I4 by assignment - see above - MRO'D
      I3 = 0
      I4 = 0
      IENT = 1
      GO TO 100
      ENTRY MA21BD(A,IA,N,W,E)
      IENT = 2
      GO TO 100
      ENTRY MA21CD(A,IA,N,DET,IDET,W)
      IENT = 3
      DET = ONE
      IDET = 0
  100 IF(N.LT.1)GO TO 810
      IP = 0
      IF(JSCALE .LE. 0)GO TO 120
C     FIND SCALING FACTORS.
      CALL MC10AD(A,N,IA,W(1,5),W(1,1),IT)
      DO 110 I=1,N
      PCK = W(I,1)
      W(2*I-1,3) = UPCK(1)
  110 W(2*I,3) = UPCK(2)
C     STORE IN W(J,1),J=1,N THE MAXIMAL ELEMENTS  OF COLUMNS AFTER
C     APPLICATION OF SCALING.
  120 EPSN = ZERO
      DO 140 J=1,N
      AB = ZERO
      DO 130 I=1,N
      AM =  DABS(A(I,J))
      IF(JSCALE.GT.0)AM=AM*W(I,3)
  130 AB = DMAX1(AB,AM)
      W(J,1) = AB
      IF(JSCALE.GT.0)AB=AB*W(J,4)
  140 EPSN = DMAX1(EPSN,AB)
      EPSN = EPSN*EPS4
      IF((E.LE.ZERO).OR.(IENT.EQ.3))GO TO 160
C     MAKE COPY OF MATRIX
      DO 150 I=1,N
      DO 150 J=1,N
  150 W(I,J+5) = A(I,J)
C
C     FACTORISATION OF MATRIX INTO L*U, WHERE L IS A LOWER UNIT
C     TRIANGLE AND U IS UPPER TRIANGLE
  160 DO 230 L=1,N
      AM = ZERO
      II = L
C     EVALUATE  ELEMENTS IN PIVOTAL COLUMN.
      DO 170 I=L,N
      A(I,L)=A(I,L)-FM02AD(L-1,A(I,1),IA,A(1,L),1)
C     LOOK FOR MAXIMUM ELEMENT IN PIVOTAL COLUMN.
      AB =  DABS(A(I,L))
      IF(JSCALE .GT. 0)AB = AB*W(I,3)
      IF(AM .GE. AB)GO TO 170
      AM = AB
      II = I
  170 CONTINUE
C
C     TEST FOR SMALL OR ZERO PIVOT.
      AB = W(L,1)
      IF(AM .LE. EPS4*AB)IP=-L
      IF(AM.NE.ZERO)GO TO 180
      IF(IENT.EQ.2)GO TO 820
      IP=L
  180 IF(IENT.NE.3)GO TO 190
C
C     THE NEXT 12 STATEMENTS CALCULATE THE DETERMINANT OF MATRIX A.
C     TO PREVENT OVERFLOWS/UNDERFLOWS THE EXPONENTS OF THE NUMBERS
C     BEING MULTIPLIED ARE EXAMINED AND THE EXCESS EXPONENT IS STORED
C     IN IDET.
C FOR VAX NEXT TWELVE STATEMENTS REPLACED- MAY NEED ATTENTION IF MA21CD
C IS EVER NEEDED FOR BIG MATRICES.
C      Q(1)= DABS(DET)
C      Q(2)= DABS(A(II,L))
C      L3(4) = L1
C      L4(4) = L2
C      K = IDET+I3+I4-128
C      I3 = K
C      L2 = LQ
C      IF(IABS(K) .GT. 62)K=ISIGN(62,I3)
C      IDET = I3-K
C      I3 = K+64
C      L1 = L3(4)
C      DET =DSIGN(Q(1),DET)*DSIGN(Q(2),A(II,L))
      DET=DET*A(II,L)
C
  190 IF(II .EQ. L)GO TO 220
C
C     INTERCHANGE ROWS N AND II
C     INTERCHANGE EQUILIBRATION FACTORS
C     W(L,1)=II MEANS INTERCHANGE BETWEEN ROWS L AND II
      IF(IENT.EQ.3)DET=-DET
      IF(JSCALE .LE. 0)GO TO 200
      AA = W(L,3)
      W(L,3) = W(II,3)
      W(II,3) = AA
  200 DO 210 I=1,N
      AA = A(L,I)
      A(L,I) = A(II,I)
  210 A(II,I) = AA
  220 W(L,1) = WW
      IF( L .EQ. N)GO TO 240
      AA = ONE
      AC = A(L,L)
      IF( DABS(AC) .NE. ZERO)AA = AA/AC
      K= L+1
C     UPPER TRIANGLE
      DO 230 I=K,N
      A(I,L) = A(I,L)*AA
  230 A(L,I)=A(L,I)-FM02AD(L-1,A(L,1),IA,A(1,I),1)
C
  240 IF(IENT -2)250,500,720
C
  250 IF(E .LE. ZERO)GO TO 270
      DO 260 I=1,N
      W(I,5) = B(I)
  260 W(I,2) = ZERO
      IT = 0
C
C     FORWARD SUBSTITUTION
  270 DO 280 I=1,N
      WW = W(I,1)
      AA = B(II)
      B(II) = B(I)
  280 B(I)=AA-FM02AD(I-1,A(I,1),IA,B(1),1)
      ENORMA = ENORM
      ENORM = ZERO
C
C     CALCULATE NORMS OF X,CHANGE IN SOLUTION
C     BACKWARD SUBSTITUTION
      DO 310 K=1,N
      I=N+1-K
      AA = A(I,I)
      IF(   DABS(AA) .EQ. ZERO)GO TO 290
      AC=B(I)-FM02AD(N-I,A(I,I+1),IA,B(I+1),1)
      B(I) = AC/AA
      GO TO 300
  290 IP=I
      B(I) = ZERO
  300 AM=ONE
      IF(JSCALE.GT.0)AM=W(I,4)
  310 ENORM=DMAX1(ENORM, DABS(B(I))/AM)
      IF((E .LE. ZERO) .OR. (IP .NE. 0 ))GO TO 720
      IF(IT .EQ. 0)GO TO 320
      IF(ENORM .GT. P5*ENORMA) GO TO 460
      IF(ENORM   -  EPS*XNORM)470,470,330
  320 XNORM=ENORM
      CALL FA01CS(IRANDL,IRANDR)
      CALL FA01DS(21845,21845)
C
C     UPDATE SOLUTION VECTOR X
  330 DO 340 I=1,N
  340 W(I,2) = W(I,2)+B(I)
      IT = IT+1
C
C     COMPUTE RESIDUAL
  350 DO 450 J=1,N
      IF(IENT .NE. 2)GO TO 360
      AA = ZERO
      IF(L .EQ. J)AA = ONE
      GO TO 370
  360 AA = W(J,5)
  370 AC=AA-FM02AD(N,W(J,6),N,W(1,2),1)
      AA = ZERO
      IF(EA)400,430,380
C
C     MAKE PSEUDO RANDOM CHANGES TO ELEMENTS OF A AND B
  380 DO 390 K=1,N
  390 AA = AA+FA01AS(-K)*W(J,K+5)*W(K,2)
      GO TO 420
  400 DO 410 K=1,N
  410 AA = AA+FA01AS(-K)*W(K,2)
  420 AC =AC-DABS(EA)*AA
  430 IF(IENT .EQ. 2)GO TO 440
      AA  = DABS(EB)*FA01AS(-J)
      IF(EB .GE. ZERO)AA=AA*W(J,5)
      AC = AA+AC
      B(J) = AC
      GO TO 450
  440 W(J,5) = AC
  450 CONTINUE
      IF(IENT-2)270,630,270
  460 ENORM = ENORMA
  470 DO 480 I=1,N
  480 B(I) = W(I,2)
      E=ENORM
      IF(JSCALE .LE. 0)GO TO 710
C
C     SET UP ACCURACY ESTIMATES FOR SOLUTION VECTOR.
      ERR = ZERO
      DO 490 I=1,N
      W(I,2) = ENORM*W(I,4)
      AB = W(I,2)
  490 ERR = DMAX1(ERR,AB)
      E=ERR
      GO TO 710
C
C     OVERWRITE LU FACTORISATION OF A BY INVERSE OF PERMUTED A.
  500 IF(N .LT. 2)GO TO 520
      DO 510 I=2,N
      K=I-1
      DO 510 J=1,K
  510 A(I,J)=-A(I,J)-FM02AD(I-1-J,A(I,J+1),IA,A(J+1,J),1)
  520 DO 540 K=1,N
      I = N+1-K
      ERR = ONE/EPSN
      IF(JSCALE .GT. 0)ERR = ERR*W(I,4)
      DO 530 J=I,N
      W(J,2) = A(I,J)
  530 A(I,J) = ZERO
      A(I,I) = ONE
      AA = ONE/W(I,2)
      DO 540 J=1,N
      AB = ONE
      IF (JSCALE .GT. 0)AB = W(J,3)
      AC=A(I,J)-FM02AD(N-I,W(I+1,2),1,A(I+1,J),1)
      A(I,J) = AC*AA
      IF( DABS(A(I,J)) .GE. ERR*AB)IP=N*I+J
  540 CONTINUE
      ANORM = ZERO
      DO 590 K=1,N
      I = N+1-K
      WW = W(I,1)
      IF(II .EQ. I)GO TO 570
      IF(JSCALE .LE. 0)GO TO 550
      AA = W(I,3)
      W(I,3) = W(II,3)
      W(II,3) = AA
  550 DO 560 J=1,N
      AA = A(J,II)
      A(J,II) = A(J,I)
  560 A(J,I) = AA
      W(I,1) = W(II,1)
  570 ENORM = ZERO
      DO 580 J=1,N
      AB =  DABS(A(J,II))
      IF(JSCALE.GT.0)AB=AB/W(J,4)
  580 ENORM = DMAX1(ENORM,AB)
      W(II,1) = ENORM
      AB = ONE
      IF(JSCALE.GT.0)AB=W(II,3)
  590 ANORM = DMAX1(ANORM,ENORM/AB)
      IF((E .LE. ZERO) .OR. (IP .NE. 0 ))GO TO 720
       CALL FA01CS(IRANDL,IRANDR)
      CALL FA01DS(21845,21845)
      AXNORM=ANORM
  600 ANORMA = ANORM
      ANORM = ZERO
      L=0
  610 L=L+1
C
C     INVERSE OF A IS ITERATIVELY REFINED BY COLUMNS
C     MAKE COPY OF APPROPIATE COLUMN.
      DO 620 I=1,N
  620 W(I,2) = A(I,L)
      GO TO 350
C
C     CALCULATE THE CHANGE IN APPROPIATE COLUMN OF INVERSE OF A.
  630 ENORM = ZERO
      DO 640 I=1,N
      W(I,2) = ZERO
      W(I,2)=W(I,2)+FM02AD(N,A(I,1),IA,W(1,5),1)
      AM=ONE
      IF(JSCALE.GT.0)AM=W(I,4)
  640 ENORM=DMAX1(ENORM, DABS(W(I,2))/AM)
      AB = W(L,1)
      IF(ENORM .GT. P5*AB)GO TO 660
C
C     UPDATE APPROPIATE COLUMN OF INVERSE OF A.
      DO 650 J=1,N
  650 A(J,L) = A(J,L)+W(J,2)
      W(L,1) = ENORM
      AB = ENORM
  660 ERR = ONE
      IF(JSCALE .GT. 0)ERR = W(L,3)
      ANORM = DMAX1(ANORM,AB/ERR)
      IF(L.LT.N)GO TO 610
      IF(ANORM .GT. P5*ANORMA)GO TO 670
      IF(ANORM   -  EPS*AXNORM)680,680,600
  670 ANORM = ANORMA
  680 IF(JSCALE .LE. 0)GO TO 700
C
C     SET UP ACCURACY ESTIMATES FOR MATRIX INVERSE.
      ENORM = ZERO
      ERR = ZERO
      DO 690 I=1,N
      AB = ANORM*W(I,3)
      ENORM = DMAX1(ENORM,AB)
      W(I,1) = AB
      AB = W(I,4)
      ERR = DMAX1(ERR,AB)
  690 W(I,2) = AB
      E=ENORM*ERR
      GO TO 710
  700 E=ANORM
  710 CALL FA01DS(IRANDL,IRANDR)
      GO TO 850
C
      ENTRY MA21DD (A,IA,N,B,W,E)
      IENT = 4
      IF ( N .LE. 0)GO TO 810
C
C     CHECK WHETHER ON A PREVIOUS ENTRY A SMALL PIVOT WAS FOUND,IF
C     SO PUT ON ERROR FLAG.
      IP = 0
      WW = W(N,1)
      IF(II .GT. 0)GO TO 250
      IP = II
      I = -II
      II = N
      W(N,1) = WW
      GO TO 250
C
C     THE REMAINING INSTRUCTIONS HANDLE ERROR DIAGNOSTICS,ETC.
  720 IF(IP)730,800,740
  730 II=IP
      W(N,1) = WW
      J=7
      GO TO 770
  740 IF(IP.LE.N)GO TO 760
      I=(IP-1)/N
      J=IP-N*I
      WRITE(LP,750)DICT(IENT),I,J
  750 FORMAT(A8,'HAS FOUND THAT INVERSE ELEMENT (',I4,',',I4,') IS LARGE
     1,RESULTS MAY BE UNRELIABLE')
      GO TO 790
  760 J=8
  770 I=IABS(IP)
      WRITE(LP,780)DICT(IENT),DICT(6),I,DICT(J)
  780 FORMAT(A8,'HAS FOUND THAT',A8,I4,1X,A8,',RESULTS MAY',
     1  ' BE UNRELIABLE')
  790 E=-ONE
      GO TO 850
  800 E=ZERO
      GO TO 850
  810 WRITE(LP,830)DICT(IENT),DICT(5),N
      GO TO 840
  820 WRITE(LP,830)DICT(IENT),DICT(6),L,DICT(8 )
  830 FORMAT(' ERROR RETURN FROM',2A8,I5,1X,A8)
  840 E=-TWO
  850 RETURN
      END
      SUBROUTINE MC10AD(A,N,NN,DIAG,RES,IS)
      REAL*8 A(NN,NN)
      REAL*4 RES(N,4)
c      INTEGER*2DIAG(N,2),JU(2),KU
      INTEGER*2DIAG(N,2)
C     RES IS USED TO RETURN SCALING FACTORS AS INTEGRAL
C          POWERS OF BASE, AND AS WORKSPACE
C     IS IS SET TO 0 ON SUCCESSFUL COMPLETION, TO I IF ROW I HAS ONLY
C        ZERO ELEMENTS, TO -I IF COLUMN I HAS ONLY ZERO ELEMENTS
C     DIAG IS USED TO HOLD COUNTS OF NON-ZEROS IN ROWS AND COLUMNS
C      AND TO RETURN SCALING POWERS
C
      DATA SMIN/.01/
C     SMIN IS USED IN A CONVERGENCE TEST ON (RESIDUAL NORM)**2
c      LOGICAL*1 IU,IW(3)
C      EQUIVALENCE (UU,IW(1),KU),(U,IU,JU(1)) ......370 SPECIFIC
C     SET UP CONSTANTS
C      UU = 100.  ......370 SPECIFIC
      UU=ALOG(16.0)
      IS=0
C     INITIALISE FOR ACCUMULATION OF SUMS AND PRODUCTS
      DO 2 L=1,2
      DO 2 I=1,N
      RES(I,L)=0.
      RES(I,L+2)=0.
    2 DIAG(I,L)=0
      DO 3 I=1,N
      DO 3 J=1,N
      U=DABS(A(I,J))
      IF(U.EQ.0.)GO TO 3
C     ON THE IBM 360 THE FOLLOWING TWO INSTRUCTIONS FIND THE SMALLEST
C     INTEGER GREATER THAN ALOG16(U).
C      IW(2) = IU
C      U=UU-64.
      U=ALOG(U)/UU
      U=AINT(U+1.0)
C     COUNT NON-ZEROS IN ROW AND COLUMN
      DIAG(I,1)=DIAG(I,1)+1
      DIAG(J,2)=DIAG(J,2)+1
      RES(I,1)=RES(I,1)+U
      RES(J,3)=RES(J,3)+U
    3 CONTINUE
C     COMPUTE RHS VECTORS TESTING FOR ZERO ROW OR COLUMN
      SSUM=0.
      J=0
C      JU(1)=17920  .......370 SPECIFIC
      DO 8 I=1,N
      J=J+DIAG(I,1)
      DO 9 L=1,2
      IF(DIAG(I,L).GT.0 )GO TO 153
      DIAG(I,L)=1
      IS=I*(3-2*L)
  153 CONTINUE
C      ON IBM 360 NEXT INSTRUCTION SETS U TO VALUE OF POSITIVE INTEGER
C      JU(2)=DIAG(I,L)
CTSH      U=FLOATI(DIAG(I,L))
CTSH++
      U=DIAG(I,L)
CTSH--
    9 RES(I,2*L-1)=RES(I,2*L-1)/U
    8 SSUM=SSUM+RES(I,3)
      SM=SMIN*J
C     SWEEP TO COMPUTE INITIAL RESIDUAL VECTOR
      RSUM=0.
      DO 110 I=1,N
      SUM = SSUM
      IF(DIAG(I,1).GE. N)GO TO 109
      SUM=0.
      DO 10 J=1,N
      IF(A(I,J).EQ.0D0)GO TO 10
      SUM=SUM+RES(J,3)
   10 CONTINUE
C      ON IBM 360 NEXT INSTRUCTION SETS U TO VALUE OF POSITIVE INTEGER
C  109 JU(2)=DIAG(I,1)
CTSH  109 U=FLOATI(DIAG(I,1))
CTSH++
  109 U=DIAG(I,1)
CTSH--
      RES(I,1)=RES(I,1)-SUM/U
  110 RSUM=RSUM+RES(I,1)
C     INITIALISE ITERATION
      E=0.
      E1=0.
      Q=1.
      S=0.
      DO 11 I=1,N
C      ON IBM 360 NEXT INSTRUCTION SETS U TO VALUE OF POSITIVE INTEGER
C      JU(2)=DIAG(I,1)
CTSH      U=FLOATI(DIAG(I,1))
CTSH++
      U=DIAG(I,1)
CTSH--
   11 S=S+U*RES(I,1)**2
      L=2
      IF(S.LE.SM)GO TO 100
C     ITERATION STEP
   20 EM=E*E1
C    SWEEP THROUGH MATRIX TO UPDATE RESIDUAL VECTOR
      DO 220 I=1,N
      SUM=RSUM
      IF(DIAG(I,L).GE. N)GO TO 220
      SUM=0.
      DO 22 J=1,N
      IF(L.EQ.2)GO TO 21
      IF(A(I,J))19,22,19
   21 IF(A(J,I))19,22,19
   19 SUM=SUM+RES(J,3-L)
   22 CONTINUE
  220 RES(I,L)=RES(I,L)+SUM
      S1=S
      S=0.
      RSUM=0.
      DO 23 I=1,N
      V=-RES(I,L)/Q
C      ON IBM 360 NEXT INSTRUCTION SETS U TO VALUE OF POSITIVE INTEGER
C      JU(2)=DIAG(I,L)
CTSH      U=FLOATI(DIAG(I,L))
CTSH++
      U=DIAG(I,L)
CTSH--
      RES(I,L)=V/U
      RSUM=RSUM+RES(I,L)
   23 S=S+V*RES(I,L)
      E1=E
      E=Q*S/S1
      Q1=Q
      Q=1.-E
      M=3-L
      IF(S.GT.SM)GO TO 27
      E=M-1
      M=1
      Q=1.
   27 IF(L.EQ.2)GO TO 25
      QM=Q*Q1
      DO 24 I=1,N
      RES (I,4)=(EM*RES(I,4)+RES(I,2))/QM
   24 RES(I,3)=RES(I,3)+RES(I,4)
   25 L=M
      DO 26 I=1,N
C      ON IBM 360 NEXT INSTRUCTION SETS U TO VALUE OF POSITIVE INTEGER
C      JU(2)=DIAG(I,L)
CTSH      U=FLOATI(DIAG(I,L))
CTSH++
      U=DIAG(I,L)
CTSH--
   26 RES(I,L)=RES(I,L)*U*E
      IF(S.GT.SM  )GO TO 20
C      SWEEP THROUGH MATRIX TO GET ROW SCALING POWERS
  100 DO 103 I=1,N
      DO 103 J=1,N
      U=DABS(A(I,J))
      IF(U.EQ.0.)GO TO 103
C      ON IBM 360 NEXT TWO INSTRUCTIONS FIND THE SMALLEST INTEGER
C     LESS THAN ALOG16(U)
C      IW(2)=IU
C      U=UU-64.
      U=ALOG(U)/UU
      U=AINT(U+1.0)
      RES(I,1)=RES(I,1)+RES(J,3)-U
  103 CONTINUE
C      CONVERT POWERS TO INTEGERS
C      JU(1)=17920  .......370 SPECIFIC
      DO 104 I=1,N
C      ON IBM 360 NEXT INSTRUCTION SETS U TO VALUE OF POSITIVE INTEGER
C      JU(2)=DIAG(I,1)
CTSH      U=FLOATI(DIAG(I,1))
CTSH++
      U=DIAG(I,1)
CTSH--
      V=RES(I,1)/U
      DIAG(I,1)=V+SIGN(0.5,V)
  104 DIAG(I,2)=-(RES(I,3)+SIGN(0.5,RES(I,3)))
C      SET SCALING FACTORS IN RES
C      U=1.   .......370 SPECIFIC
      DO 105 L=1,2
      DO 105 I=1,N
  105 RES(I,L)=16.0**DIAG(I,L)
C     THE FOLLOWING THREE STATEMENTS WERE EQUIVALENT TO THE ONE REPLACING IT
C      KU=DIAG(I,L)+65
C      IU=IW(2)
C  105 RES(I,L)=U
      RETURN
      END
