#
#     Copyright (C) 2015 CCP-EM
#
#     This code is distributed under the terms and conditions of the
#     CCP-EM Program Suite Licence Agreement as a CCP-EM Application.
#     A copy of the CCP-EM licence can be obtained by writing to the
#     CCP-EM Secretary, RAL Laboratory, Harwell, OX11 0FA, UK.
#

def default_labels():
    '''
    Store all default metadata labels here
    '''
    ccpem_labels = {
'undefined' : 'Undefined metadata label definition',
'Comment' : 'A metadata comment (This is treated in a special way)',
'AreaId' : 'ID (i.e. a unique number) of an area (i.e. field-of-view)',
'AreaName' : 'Name of an area (i.e. field-of-view)',
'Bfactor' : 'B-factor (in A^2) that describes power spectrum fall-off',
'CtfScalefactor' : 'Linear scale-factor on the CTF (values between 0 and 1)',
'Voltage' : 'Voltage of the microscope (in kV)',
'DefocusU' : 'Defocus in U-direction (in Angstroms, positive values for underfocus)',
'DefocusV' : 'Defocus in V-direction (in Angstroms, positive values for underfocus)',
'DefocusAngle' : 'Angle between X and defocus U direction (in degrees)',
'SphericalAberration' : 'Spherical aberration (in millimeters)',
'ChromaticAberration' : 'Chromatic aberration (in millimeters)',
'DetectorPixelSize' : 'Pixel size of the detector (in micrometers)',
'EnergyLoss' : 'Energy loss (in eV)',
'CtfFigureOfMerit' : 'Figure of merit for the fit of the CTF (not used inside relion_refine)',
'CtfImage' : 'Name of an image with all CTF values',
'LensStability' : 'Lens stability (in ppm)',
'Magnification' : 'Magnification at the detector (in times)',
'ConvergenceCone' : 'Convergence cone (in mrad)',
'LongitudinalDisplacement' : 'Longitudinal displacement (in Angstroms)',
'TransversalDisplacement' : 'Transversal displacement (in Angstroms)',
'AmplitudeContrast' : 'Amplitude contrast (as a fraction, i.e. 10% = 0.1)',
'CtfValue' : 'Value of the Contrast Transfer Function',
'ImageName' : 'Name of an image',
'ReconstructImageName' : 'Name of an image to be used for reconstruction only',
'ImageId' : 'ID (i.e. a unique number) of an image',
'Enabled' : 'Not used in RELION, only included for backward compatibility with XMIPP selfiles',
'DataType' : 'Type of data stored in an image (e.g. int, double etc)',
'DataDimensionality' : 'Dimensionality of data stored in an image (i.e. 2 or 3)',
'BeamTiltX' : 'Beam tilt in the X-direction (in mrad)',
'BeamTiltY' : 'Beam tilt in the Y-direction (in mrad)',
'BeamTiltGroupName' : 'Name of a group (of images) with assumedly identical beam-tilts',
'CoordinateX' : 'X-Position of an image in a micrograph (in pixels)',
'CoordinateY' : 'Y-Position of an image in a micrograph (in pixels)',
'CoordinateZ' : 'Z-Position of an image in a 3D micrograph, i.e. tomogram (in pixels)',
'MovieFrameNumber' : 'Number of a movie frame',
'NormCorrection' : 'Normalisation correction value for an image',
'MagnificationCorrection' : 'Magnification correction value for an image',
'SamplingRate' : 'Sampling rate of an image (in Angstrom/pixel)',
'SamplingRateX' : 'Sampling rate in X-direction of an image (in Angstrom/pixel)',
'SamplingRateY' : 'Sampling rate in Y-direction of an image (in Angstrom/pixel)',
'SamplingRateZ' : 'Sampling rate in Z-direction of an image (in Angstrom/pixel)',
'ImageSize' : 'Size of an image (in pixels)',
'ImageSizeX' : 'Size of an image in the X-direction (in pixels)',
'ImageSizeY' : 'Size of an image in the Y-direction (in pixels)',
'ImageSizeZ' : 'Size of an image in the Z-direction (in pixels)',
'MinimumValue' : 'Minimum value for the pixels in an image',
'MaximumValue' : 'Maximum value for the pixels in an image',
'AverageValue' : 'Average value for the pixels in an image',
'StandardDeviationValue' : 'Standard deviation for the pixel values in an image',
'SkewnessValue' : 'Skewness (3rd moment) for the pixel values in an image',
'KurtosisExcessValue' : 'Kurtosis excess (4th moment - 3) for the pixel values in an image',
'ImageWeight' : 'Relative weight of an image',
'Matrix_1_1' : 'Matrix element (1,1) of a 3x3 matrix',
'Matrix_1_2' : 'Matrix element (1,2) of a 3x3 matrix',
'Matrix_1_3' : 'Matrix element (1,3) of a 3x3 matrix',
'Matrix_2_1' : 'Matrix element (2,1) of a 3x3 matrix',
'Matrix_2_2' : 'Matrix element (2,1) of a 3x3 matrix',
'Matrix_2_3' : 'Matrix element (2,1) of a 3x3 matrix',
'Matrix_3_1' : 'Matrix element (3,1) of a 3x3 matrix',
'Matrix_3_2' : 'Matrix element (3,1) of a 3x3 matrix',
'Matrix_3_3' : 'Matrix element (3,1) of a 3x3 matrix',
'MicrographId' : 'ID (i.e. a unique number) of a micrograph',
'MicrographName' : 'Name of a micrograph',
'MicrographTiltAngle' : 'Tilt angle (in degrees) used to collect a micrograph',
'MicrographTiltAxisDirection' : 'Direction of the tilt-axis (in degrees) used to collect a micrograph',
'MicrographTiltAxisOutOfPlane' : 'Out-of-plane angle (in degrees) of the tilt-axis used to collect a micrograph (90=in-plane)',
'AccuracyRotations' : 'Estimated accuracy (in degrees) with which rotations can be assigned',
'AccuracyTranslations' : 'Estimated accuracy (in pixels) with which translations can be assigned',
'AveragePmax' : 'Average value (over all images) of the maxima of the probability distributions',
'CurrentResolution' : 'Current resolution where SSNR^MAP drops below 1 (in 1/Angstroms)',
'CurrentImageSize' : 'Current size of the images used in the refinement',
'SsnrMap' : 'Spectral signal-to-noise ratio as defined for MAP estimation (SSNR^MAP)',
'ReferenceDimensionality' : 'Dimensionality of the references (2D/3D)',
'DataDimensionality' : 'Dimensionality of the data (2D/3D)',
'Diff2RandomHalves' : 'Power of the differences between two independent reconstructions from random halves of the data',
'GoldStandardFsc' : 'Fourier shell correlation between two independent reconstructions from random halves of the data',
'GroupName' : 'The name of a group of images (e.g. all images from a micrograph)',
'GroupNumber' : 'The number of a group of images',
'GroupNrParticles' : 'Number particles in a group of images',
'GroupScaleCorrection' : 'Intensity-scale correction for a group of images',
'FourierSpaceInterpolator' : 'The kernel used for Fourier-space interpolation (NN=0, linear=1)',
'LogLikelihood' : 'Value of the log-likelihood target function',
'MinRadiusNnInterpolation' : 'Minimum radius for NN-interpolation (in Fourier pixels), for smaller radii linear int. is used',
'NormCorrectionAverage' : 'Average value (over all images) of the normalisation correction values',
'NrClasses' : 'The number of references (i.e. classes) to be used in refinement',
'NrGroups' : 'The number of different groups of images (each group has its own noise spectrum, and intensity-scale correction)',
'SpectralOrientabilityContribution' : 'Spectral SNR contribution to the orientability of individual particles',
'OriginalImageSize' : 'Original size of the images (in pixels)',
'PaddingFactor' : 'Oversampling factor for Fourier transforms of the references',
'ClassDistribution' : 'Probability Density Function of the different classes (i.e. fraction of images assigned to each class)',
'ClassPriorOffsetX' : 'Prior in the X-offset for a class (in pixels)',
'ClassPriorOffsetY' : 'Prior in the Y-offset for a class (in pixels)',
'OrientationDistribution' : 'Probability Density Function of the orientations  (i.e. fraction of images assigned to each orient)',
'PixelSize' : 'Size of the pixels in the references and images (in Angstroms)',
'ReferenceSpectralPower' : 'Spherical average of the power of the reference',
'OrientationalPriorMode' : 'Mode for prior distributions on the orientations (0=no prior; 1=(rot,tilt,psi); 2=(rot,tilt); 3=rot; 4=tilt; 5=psi) ',
'ReferenceImage' : 'Name of a reference image',
'SigmaOffsets' : 'Standard deviation in the origin offsets (in Angstroms)',
'Sigma2Noise' : 'Spherical average of the standard deviation in the noise (sigma)',
'ReferenceSigma2' : 'Spherical average of the estimated power in the noise of a reference',
'SigmaPriorRotAngle' : 'Standard deviation of the prior on the rot (i.e. first Euler) angle',
'SigmaPriorTiltAngle' : 'Standard deviation of the prior on the tilt (i.e. second Euler) angle',
'SigmaPriorPsiAngle' : 'Standard deviation of the prior on the psi (i.e. third Euler) angle',
'SignalToNoiseRatio' : 'Spectral signal-to-noise ratio for a reference',
'Tau2FudgeFactor' : 'Regularisation parameter with which estimates for the power in the references will be multiplied (T in original paper)',
'ReferenceTau2' : 'Spherical average of the estimated power in the signal of a reference',
'OverallAccuracyRotations' : 'Overall accuracy of the rotational assignments (in degrees)',
'OverallAccuracyTranslations' : 'Overall accuracy of the translational assignments (in pixels)',
'AdaptiveOversampleFraction' : 'Fraction of the weights that will be oversampled in a second pass of the adaptive oversampling strategy',
'AdaptiveOversampleOrder' : 'Order of the adaptive oversampling (0=no oversampling, 1= 2x oversampling; 2= 4x oversampling, etc)',
'AutoLocalSearchesHealpixOrder' : 'Healpix order (before oversampling) from which autosampling procedure will use local angular searches',
'AvailableMemory' : 'Available memory per computing node (i.e. per MPI-process)',
'BestResolutionThusFar' : 'The highest resolution that has been obtained in this optimization thus far',
'CoarseImageSize' : 'Current size of the images to be used in the first pass of the adaptive oversampling strategy (may be smaller than the original image size)',
'ChangesOptimalOffsets' : 'The average change in optimal translation in the last iteration (in pixels) ',
'ChangesOptimalOrientations' : 'The average change in optimal orientation in the last iteration (in degrees) ',
'ChangesOptimalClasses' : 'The number of particles that changed their optimal clsas assignment in the last iteration',
'CtfDataArePhaseFlipped' : 'Flag to indicate that the input images have been phase-flipped',
'ExperimentalDataStarFile' : 'STAR file with metadata for the experimental images',
'DoCorrectCtf' : 'Flag to indicate that CTF-correction should be performed',
'DoCorrectMagnification' : 'Flag to indicate that (per-group) magnification correction should be performed',
'DoCorrectNorm' : 'Flag to indicate that (per-image) normalisation-error correction should be performed',
'DoCorrectScale' : 'Flag to indicate that internal (per-group) intensity-scale correction should be performed',
'DoRealignMovies' : 'Flag to indicate that individual frames of movies are being re-aligned',
'DoMapEstimation' : 'Flag to indicate that MAP estimation should be performed (otherwise ML estimation)',
'DoAutoRefine' : 'Flag to indicate that 3D auto-refine procedure is being used',
'DoOnlyFlipCtfPhases' : 'Flag to indicate that CTF-correction should only comprise phase-flipping',
'DoSolventFlattening' : 'Flag to indicate that the references should be masked to set their solvent areas to a constant density',
'DoSkipAlign' : 'Flag to indicate that orientational (i.e. rotational and translational) searches will be omitted from the refinement, only marginalisation over classes will take place',
'DoSkipRotate' : 'Flag to indicate that rotational searches will be omitted from the refinement, only marginalisation over classes and translations will take place',
'DoSplitRandomHalves' : 'Flag to indicate that the data should be split into two completely separate, random halves',
'DoZeroMask' : 'Flag to indicate that the surrounding solvent area in the experimental particles will be masked to zeros (by default random noise will be used',
'FixSigmaNoiseEstimates' : 'Flag to indicate that the estimates for the power spectra of the noise should be kept constant',
'FixSigmaOffsetEstimates' : 'Flag to indicate that the estimates for the stddev in the origin offsets should be kept constant',
'FixTauEstimates' : 'Flag to indicate that the estimates for the power spectra of the signal (i.e. the references) should be kept constant',
'HasConverged' : 'Flag to indicate that the optimization has converged',
'HasHighFscAtResolLimit' : 'Flag to indicate that the FSC at the resolution limit is significant',
'HasLargeSizeIncreaseIterationsAgo' : 'How many iterations have passed since the last large increase in image size',
'HighresLimitExpectation' : 'High-resolution-limit (in Angstrom) for the expectation step',
'DoIgnoreCtfUntilFirstPeak' : 'Flag to indicate that the CTFs should be ignored until their first peak',
'IncrementImageSize' : 'Number of Fourier shells to be included beyond the resolution where SSNR^MAP drops below 1',
'CurrentIteration' : 'The number of the current iteration',
'JoinHalvesUntilThisResolution' : 'Resolution (in Angstrom) to join the two random half-reconstructions to prevent their diverging orientations (for C-symmetries)',
'MagnificationSearchRange' : 'Search range for magnification correction',
'MagnificationSearchStep' : 'Step size  for magnification correction',
'MaximumCoarseImageSize' : 'Maximum size of the images to be used in the first pass of the adaptive oversampling strategy (may be smaller than the original image size)',
'MaxNumberOfPooledParticles' : 'Maximum number particles that are processed together to speed up calculations',
'ModelStarFile' : 'STAR file with metadata for the model that is being refined',
'ModelStarFile2' : 'STAR file with metadata for the second model that is being refined (from random halves of the data)',
'NumberOfIterations' : 'Maximum number of iterations to be performed',
'NumberOfIterWithoutResolutionGain' : 'Number of iterations that have passed without a gain in resolution',
'NumberOfIterWithoutChangingAssignments' : 'Number of iterations that have passed without large changes in orientation and class assignments',
'OutputRootName' : 'Rootname for all output files (this may include a directory structure, which should then exist)',
'ParticleDiameter' : 'Diameter of the circular mask to be applied to all experimental images (in Angstroms)',
'RadiusMaskMap' : 'Radius of the spherical mask to be applied to all references (in Angstroms)',
'RadiusMaskExpImages' : 'Radius of the circular mask to be applied to all experimental images (in Angstroms)',
'RandomSeed' : 'Seed (i.e. a number) for the random number generator',
'RefsAreCtfCorrected' : 'Flag to indicate that the input references have been CTF-amplitude corrected',
'SmallestChangesClasses' : 'Smallest changes thus far in the optimal class assignments (in numer of particles).',
'SmallestChangesOffsets' : 'Smallest changes thus far in the optimal offset assignments (in pixels).',
'SmallestChangesOrientations' : 'Smallest changes thus far in the optimal orientation assignments (in degrees).',
'OrientSamplingStarFile' : 'STAR file with metadata for the orientational sampling',
'SolventMaskName' : 'Name of an image that contains a (possibly soft) mask for the solvent area (values=0 for solvent, values =1 for protein)',
'SolventMask2Name' : 'Name of a secondary solvent mask (e.g. to flatten density inside an icosahedral virus)',
'TauSpectrumName' : 'Name of a STAR file that holds a tau2-spectrum',
'UseTooCoarseSampling' : 'Flag to indicate that the angular sampling on the sphere will be one step coarser than needed to speed up calculations',
'WidthMaskEdge' : 'Width (in pixels) of the soft edge for spherical/circular masks to be used for solvent flattening',
'IsFlip' : 'Flag to indicate that an image should be mirrored',
'OrientationsID' : 'ID (i.e. a unique number) for an orientation',
'OriginX' : 'X-coordinate (in pixels) for the origin of rotation',
'OriginXPrior' : 'Center of the prior on the X-coordinate (in pixels) for the origin of rotation',
'OriginY' : 'Y-coordinate (in pixels) for the origin of rotation',
'OriginYPrior' : 'Center of the prior on the X-coordinate (in pixels) for the origin of rotation',
'OriginZ' : 'Z-coordinate (in pixels) for the origin of rotation',
'OriginZPrior' : 'Center of the prior on the X-coordinate (in pixels) for the origin of rotation',
'AngleRot' : 'First Euler angle (rot, in degrees)',
'AngleRotPrior' : 'Center of the prior (in degrees) on the first Euler angle (rot)',
'AngleTilt' : 'Second Euler angle (tilt, in degrees)',
'AngleTiltPrior' : 'Center of the prior (in degrees) on the second Euler angle (tilt)',
'AnglePsi' : 'Third Euler, or in-plane angle (psi, in degrees)',
'AnglePsiPrior' : 'Center of the prior (in degrees) on the third Euler angle (psi)',
'AutopickFigureOfMerit' : 'Autopicking FOM for a particle',
'ClassNumber' : 'Class number for which a particle has its highest probability',
'LogLikeliContribution' : 'Contribution of a particle to the log-likelihood target function',
'ParticleId' : 'ID (i.e. a unique number) for a particle',
'ParticleFigureOfMerit' : 'Developmental FOM for a particle',
'KullbackLeibnerDivergence' : 'Kullback-Leibner divergence for a particle',
'RandomSubset' : 'Random subset to which this particle belongs',
'ParticleName' : 'Name for a particles',
'OriginalParticleName' : 'Original name for a particles',
'NrOfSignificantSamples' : 'Number of orientational/class assignments (for a particle) with sign.probabilities in the 1st pass of adaptive oversampling',
'NrOfFrames' : 'Number of movie frames that were collected for this particle',
'MaxValueProbDistribution' : 'Maximum value of the (normalised) probability function for a particle',
'FinalResolution' : 'Final estimated resolution after postprocessing (in Angstroms)',
'BfactorUsedForSharpening' : 'Applied B-factor in the sharpening of the map',
'FourierShellCorrelationCorrected' : 'Final FSC value: i.e. after correction based on masking of randomized-phases maps',
'FourierShellCorrelationMaskedMaps' : 'FSC value after masking of the original maps',
'FourierShellCorrelationUnmaskedMaps' : 'FSC value before masking of the original maps',
'CorrectedFourierShellCorrelationPhaseRandomizedMaskedMaps' : 'FSC value after masking of the randomized-phases maps',
'FittedInterceptGuinierPlot' : 'The fitted intercept of the Guinier-plot',
'FittedSlopeGuinierPlot' : 'The fitted slope of the Guinier-plot',
'CorrelationFitGuinierPlot' : 'The correlation coefficient of the fitted line through the Guinier-plot',
'LogAmplitudesOriginal' : 'Y-value for Guinier plot: the logarithm of the radially averaged amplitudes of the input map',
'LogAmplitudesMTFCorrected' : 'Y-value for Guinier plot: the logarithm of the radially averaged amplitudes after MTF correction',
'LogAmplitudesWeighted' : 'Y-value for Guinier plot: the logarithm of the radially averaged amplitudes after FSC-weighting',
'LogAmplitudesSharpened' : 'Y-value for Guinier plot: the logarithm of the radially averaged amplitudes after sharpening',
'LogAmplitudesIntercept' : 'Y-value for Guinier plot: the fitted plateau of the logarithm of the radially averaged amplitudes',
'ResolutionSquared' : 'X-value for Guinier plot: squared resolution in 1/Angstrom^2',
'MtfValue' : 'Value of the detectors modulation transfer function (between 0 and 1)',
'Is3DSampling' : 'Flag to indicate this concerns a 3D sampling ',
'Is3DTranslationalSampling' : 'Flag to indicate this concerns a x,y,z-translational sampling ',
'HealpixOrder' : 'Healpix order for the sampling of the first two Euler angles (rot, tilt) on the 3D sphere',
'TiltAngleLimit' : 'Values to which to limit the tilt angles (positive for keeping side views, negative for keeping top views)',
'OffsetRange' : 'Search range for the origin offsets (in Angstroms)',
'OffsetStep' : 'Step size for the searches in the origin offsets (in Angstroms)',
'SamplingPerturbInstance' : 'Random instance of the random perturbation on the orientational sampling',
'SamplingPerturbFactor' : 'Factor for random perturbation on the orientational sampling (between 0 no perturbation and 1 very strong perturbation)',
'PsiStep' : 'Step size (in degrees) for the sampling of the in-plane rotation angle (psi)',
'SymmetryGroup' : 'Symmetry group (e.g., C1, D7, I2, I5, etc.)',
'Selected' : 'Flag whether an entry in a metadatatable is selected in the viewer or not',
'ParticleSelectZScore' : 'Sum of Z-scores from particle_select. High Z-scores are likely to be outliers.',
'SortedIndex' : 'Index of a metadata entry after sorting (first sorted index is 0).',
'PerFrameCumulativeWeight' : 'Sum of the resolution-dependent relative weights from the first frame until the given frame',
'PerFrameRelativeWeight' : 'The resolution-dependent relative weights for a given frame',
'Resolution' : 'Resolution (in 1/Angstroms)',
'AngstromResolution' : 'Resolution (in Angstroms)',
'ResolutionInversePixel' : 'Resolution (in 1/pixel, Nyquist = 0.5)',
'SpectralIndex' : 'Spectral index (i.e. distance in pixels to the origin in Fourier space) '}
    return ccpem_labels