C*LLGRAPH**********************************************************************
C
C  PLOT AMPLITUDES AND PHASES ALONG EACH LAYER LINE ON PLOTTER.
C  ADAPTED FROM DAA LATLINE LATTICE-LINE FITTING PACKAGE
C
C    RAC  2NOV82   AUTO-SCALING FOR AMPLITUDES
C    RAC  11NOV00  CONVERT TO IMSUBS2000/PLOT_2K
C    TSH  13JUN02  P2K_FONT needed string terminator
C    RAC  30AUG06  corrections to internal write statements
C
C  NOBS    - NO. OF OBSERVATIONS OF AMP AND PHASE.
C  FOBS    - ARRAY OF OBSERVED AMPS.
C  PHIOBS  - ARRAY OF OBSERVED PHASES.
C  ZSTAR   - ARRAY OF OBSERVED ZSTARS.
C  ZMIN    - MINIMUM Z IN PLOT.
C  ZMAX    - MAXIMUM Z IN PLOT.
C  FMAX    - MAXIMUM AMP IN PLOT.
C  LLNO    - LAYER LINE NO. This and following just annotate plot.
C  SPLL    - LAYER LINE SPACING IN RECIPROCAL ANGSTROMS
C  NBES    - BESSEL ORDER
C  TITLE   - TITLE FOR PLOT
C  LAST    - .TRUE. IF THIS IS LAST PLOT (ELSE= .FALSE.)
C
C    FSCALE HEIGHT=70MM,PSCALE HEIGHT=50MM.
C    ZSCALE IS NOW 170MM
C
C
	SUBROUTINE LLGRAPH(FOBS,PHIOBS,ZSTAR,ZMIN,ZMAX,FMAX,LLNO,SPLL,
     1   NBES,NOBS,TITLE,LAST)
	DIMENSION FOBS(1),PHIOBS(1),ZSTAR(1),TITLE(1)
CTSH	DIMENSION LINE(20)
	character*80 line
	DATA INIT/0/
	LOGICAL LAST
C
C	ZMAG is width of boxes, FMAG is height of amp box,
C	PMAG is height of phase box, GAP is gap between boxes, all in mm
C	DELZ is interval for resolution scale in reciprocal Angstroms
	ZMAG=170.
	FMAG=70.
	PMAG=50.
	GAP=5.
	DELZ=0.01
C
	IF(INIT.EQ.1) GO TO 5
	CALL P2K_OUTFILE('llplot.ps',9)
	INIT=1
5	ZRANG=ZMAX-ZMIN
	ZERO=ZMAG/2.
C
C	Draw title and amplitude box, setting plotting area to +/-90mm
        CALL P2K_HOME
        CALL P2K_GRID(90.,90.,1.0)
	CALL P2K_ORIGIN(-90.0,-90.0,0)
        CALL P2K_MOVE(10.,-10.,0.)
	CALL P2K_FONT('Courier'//CHAR(0),3.0)
	CALL P2K_STRING(TITLE,40,0.0)
	CALL P2K_MOVE(0.0,0.0,0.)
	CALL P2K_DRAW(0.0,FMAG,0.0)
	CALL P2K_DRAW(ZMAG,FMAG,0.0)
	CALL P2K_DRAW(ZMAG,0.0,0.0)
	CALL P2K_DRAW(0.0,0.0,0.0)
	CALL P2K_MOVE(ZERO,0.0,0.0)
	CALL P2K_DRAW(ZERO,FMAG,0.0)
C	Write layer line details
	POSNX=ZMAG-40.
	POSNY=FMAG-5.
	CALL P2K_MOVE(POSNX,POSNY,0.0)
CTSH	ENCODE(20,103,LINE) LLNO
CTSH103	FORMAT('LAYER LINE    ',I4)
	write(line,'(''LAYER LINE    '',i4)') llno
	CALL P2K_STRING(LINE,20,0.0)
        POSNY=POSNY-5.
        CALL P2K_MOVE(POSNX,POSNY,0.0)
CTSH        ENCODE(20,104,LINE) NBES
CTSH104	FORMAT('BESSEL ORDER  ',I4)
	write(line,'(''BESSEL ORDER  '',i4)') nbes
        CALL P2K_STRING(LINE,20,0.0)
	POSNY=POSNY-5.
        CALL P2K_MOVE(POSNX,POSNY,0.0)
	write(line,'(''ZSTAR       '',f6.5)') spll
CTSH        ENCODE(20,105,LINE) SPLL
CTSH105     FORMAT('ZSTAR       ',F6.5)
        CALL P2K_STRING(LINE,20,0.0)
C	Put scale on radial axis
C	Number of tick marks
	IZ=ZRANG/DELZ
	IZ2=IZ/2
	ZA=-IZ2*DELZ
C	mm spacing of tick marks
	DELX=ZMAG*DELZ/ZRANG
	XPOS=ZERO-IZ2*DELX
C
	DO 25 J=1,IZ
	  CALL P2K_MOVE(XPOS,0.0,0.0)
	  CALL P2K_DRAW(XPOS,2.0,0.0)
	  XCH=XPOS-4.0
	  CALL P2K_MOVE(XCH,-5.0,0.0)
CTSH	  ENCODE(6,26,LINE) ZA
	  write(line,'(f6.2)') za
	  CALL P2K_STRING(LINE,6,0.0)
	  ZA=ZA+DELZ
	  XPOS=XPOS+DELX
25	CONTINUE
CTSH26	FORMAT(F6.2)
	POSNX=ZMAG-2.
	POSNY=-3.
	CALL P2K_FONT('Courier'//CHAR(0),2.0)
	CALL P2K_MOVE(POSNX,POSNY,0.0)
	CALL P2K_STRING('RECIPROCAL',10,0.0)
	CALL P2K_MOVE(POSNX,POSNY-3.0,0.0)
	CALL P2K_STRING('ANGSTROMS',9,0.0)
C
C	Put scale for amplitudes
	CALL P2K_FONT('Courier'//CHAR(0),3.0)
	SCALE=FMAG/(1.05*FMAX)
	IA=ALOG10(1.05*FMAX)
	B=10.0**IA
	IC=FMAX*1.05/B
	DO 200 J=1,IC
	  F=J*B
	  YPOS=F*SCALE
	  ZA=0.
	  ZB=ZMAG
	  CALL P2K_MOVE(ZA,YPOS,0.0)
	  ZD=ZA+2.0
	  CALL P2K_DRAW(ZD,YPOS,0.0)
	  ZD=ZB-2.0
	  CALL P2K_MOVE(ZB,YPOS,0.0)
	  CALL P2K_DRAW(ZD,YPOS,0.0)
	  XPOS=ZB
	  CALL P2K_MOVE(XPOS,YPOS,0.0)
CTSH	  ENCODE(7,201,LINE) F
	  write(LINE,'(f7.1)') f
	  CALL P2K_STRING(LINE,7,0.0)
200	CONTINUE
CTSH201	FORMAT(F7.1)
C
C	Plot observed amplitudes
C
	CALL P2K_FONT('Courier'//CHAR(0),1.0)
	DO 50 J=1,NOBS
	  IF(FOBS(J).EQ.-999.) GO TO 50
	  XP=ZERO+ZSTAR(J)*ZMAG/ZRANG
	  YP=FOBS(J)*SCALE
	  CALL P2K_MOVE(XP,YP,0.0)
	  CALL P2K_CSTRING('X',1,0.0)
50	CONTINUE
	CALL P2K_FONT('Courier'//CHAR(0),3.0)
C
C	Draw phase box
C
	PMAG2 = PMAG/360.
	YPOS=FMAG+GAP+PMAG/2.0
	CALL P2K_MOVE(0.0,0.0,0.0)
	CALL P2K_ORIGIN(0.0,YPOS,0.0)
	YPOS=PMAG/2.0
	CALL P2K_MOVE(0.0,-YPOS,0.0)
	CALL P2K_DRAW(ZMAG,-YPOS,0.0)
	CALL P2K_DRAW(ZMAG,YPOS,0.0)
	CALL P2K_DRAW(0.0,YPOS,0.0)
	CALL P2K_DRAW(0.0,-YPOS,0.0)
	CALL P2K_MOVE(ZERO,-YPOS,0.0)
	CALL P2K_DRAW(ZERO,YPOS,0.0)
C	Put scale for phases
	DO 620 J=1,7
	  YPOS=(PMAG/8.)*J-PMAG/2.
	  CALL P2K_MOVE(ZA,YPOS,0.0)
	  ZD=ZA+2.0
	  CALL P2K_DRAW(ZD,YPOS,0.0)
	  ZD=ZB-2.0
	  CALL P2K_MOVE(ZB,YPOS,0.0)
	  CALL P2K_DRAW(ZD,YPOS,0.0)
620	CONTINUE
	DO 630 J=1,5
	  IANG=-180+(J-1)*90
	  XPOS=ZB+1.0
	  YPOS=IANG*PMAG2
	  CALL P2K_MOVE(XPOS,YPOS,0.0)
CTSH	  ENCODE(4,631,LINE) IANG
	  write(line,'(i4)') iang
	  CALL P2K_STRING(LINE,4,0.0)
630	CONTINUE
CTSH631	FORMAT(I4)
C
C	Plot observed phases
C
	CALL P2K_FONT('Courier'//CHAR(0),1.0)
	DO 500 J=1,NOBS
	  IF(PHIOBS(J).EQ.-999.) GO TO 500
	  XP=ZERO+ZSTAR(J)*ZMAG/ZRANG
	  YP=PHIOBS(J)*PMAG2
	  CALL P2K_MOVE(XP,YP,0.0)
	  CALL P2K_CSTRING('X',1,0.0)
500	CONTINUE
C
	CALL P2K_PAGE
	RETURN
C
	END
