C   ORIGTILTK - THREE-DIMENSIONAL ORIGIN, BEAMTILT AND CRYSTAL TILT REFINEMENT.
C
C   --- remember to change version number in format statement  ---
C         VERSION VX5.05  RH  17.05.2012 debugging failed LKYASN
C         VERSION VX5.04  JMS 22.06.2010 GFORTRAN mods
C         VERSION VX5.03  JMS 21.2.06 PLOT.PS renamed as PLOT for MAC/OSX
C         VERSION VX5.02  RH  29.10.01 change FILIN to CHARACTER*80
C         VERSION VX5.01  RH  18.12.00 test to avoid IZLESS.LE.0 out-of-bounds
C         VERSION VX5.00  RH  29.8.00 convert to plot2000 direct postscript plot
C         VERSION VX4.12  RH  24.10.99 debug IF(IH.GE.900) GO TO 210
C         VERSION VX4.11  RH  17.9.99 increase MAXPLT=1500
C         VERSION VX4.10  RH   3.8.99 increase MAXPLT=500, OVERALL format I6
C         VERSION VX4.09  RH  28.5.99 INTEGER*4 JOUT, MAXINDEX=40, MAXRFL=2000
C         VERSION VX4.08  RH  10.2.99 itotrfl -> 80000
C         VERSION VX4.07  RH  2.1.98 cosmetic correction to printout for ILIST=1
C         VERSION VX4.06  RH  30.5.96 calculate S for mtz input data
C         VERSION VX4.05  RH  4.12.95 cosmetic description of TAXA
C         VERSION VX4.04  RH  17.4.95 option NPROG=3 for MTZ data, ORIGTILTD
C         VERSION VX4.03  RH  7.4.95 removes final fortran STOP to allow csh -e
C         VERSION VX4.02  RH  21.3.95 summary file output with OX,OY,TAXA,TANGL
C     VAX VERSION VX4.01  RH  5.10.93 bug in plotting IREF2 fixed
C     VAX VERSION VX4.00  RH  6.10.92 carries through background and ctf to O/P.
C     VAX VERSION VX3.02  RH  4.3.91 Prints out total no. of refls for sorting.
C     VAX VERSION VX3.01  RH  22.1.90 Minor change to ASYM.
C     VAX VERSION VX3.00  RH  19.6.89 READS AND WRITES EXTRA FLMWGT COLUMN.
C     VAX VERSION VX2.04  RH  18.6.89 annotated output lines for summary editing
C     VAX VERSION VX2.03  JMB 15.6.89 ALLOWS UP TO 40000 SPOTS
C     VAX VERSION VX2.02  JMB 15.6.89 Read filenames instead of unit numbers
C     VAX VERSION VX2.01  RH  4.4.89 option to write out shifted image data.
C     VAX VERSION VX2.00  RH  3.4.89 option to write out reference amps & phases
C     VAX VERSION VX1.19  RH  30.3.89 limits max tilt refine cycles to 4.
C     VAX VERSION VX1.18  JMB 10.3.89 ALLOWS UP TO 20000 SPOTS
C     VAX VERSION VX1.17  RH  2.3.89 IMPROVED BEAMTILT REFINEMENT, USING VA04A
C     VAX VERSION VX1.16  JMB 24.10.88 ALLOWS UP TO 16000 SPOTS
C     VAX VERSION VX1.15  RH  21.10.88 checks LCF input curves for SIGAMP.
C     VAX VERSION VX1.14  RH  8.8.88 CAN NOW USE ISPG LCFDATA WITH ZSTAR +VE.
C     VAX VERSION VX1.13  RH  30.5.88  weight for IQ=8 made slightly non-zero.
C     VAX VERSION VX1.12  JMB 23.2.88  maxindex =25
C     VAX VERSION VX1.11  JMB 25.8.87 ALLOWS MORE SPOTS PER IMAGE.
C     VAX VERSION VX1.10  RH  1.5.87 ALLOWS POINTS SLIGHTLY OFF ENDS OF CURVES.
C     VAX VERSION VX1.09  RH  20.4.87 ALLOWS ZERO AMPL INPUT, IQ UP TO 9.
C     VAX VERSION VX1.08  RH  24.1.87 NTILT(T/F), LCF ORIGREF W/O XTL TILTREF.
C     VAX VERSION VX1.07  JMB 14.5.86 COMPATIBILITY TO RECENT LCF CHANGES.
C     VAX VERSION VX1.06  RH  7.10.85  GRAPH PLOT TO +/- 0.25 ANG**-1.
C     VAX VERSION VX1.05  RH  1.7.85 NON-LEAST SQ BEAM TILT ALGORITHM.
C     VAX VERSION VX1.04  JMB 27.2.85 STATISTICS VS RESOLUTION.
C     VAX VERSION VX1.03  RH  30.12.84 WITH BEAM TILT REFINEMENT.
C     VAX VERSION VX1.02  RH  26.8.84 WITH CRYSTAL TILT REFINEMENT.
C     VAX VERSION VX1.01  RH
C     VAX VERSION VX1.00  RH
C
C     NOW DOES REFINEMENT OF BEAM AND CRYSTAL TILTANGLES AND TILTAXES.
C                            derived from ORIGMERG  13.4.84, (RH)
C     NOTE: TILT REFINEMENT (CRYSTAL AND BEAM) HAS BEEN TESTED ONLY IN
C					P3		30.12.84
C					P22121		  8.8.88
C					P4212		  4.4.94
C
C   THREE-DIMENSIONAL IMAGE COMBINING PROGRAM FOR ALL SEVENTEEN
C                   TWO-SIDED PLANE GROUPS
C
C      ORIGINAL PROGRAM WRITTEN BY S.D.FULLER, 10-MAY-1980.
C      MODIFIED L.A.AMOS & R.HENDERSON, JULY 1980 (AT LEAST 30 BUGS REMOVED).
C      MODIFIED 23-7-81 BY DANA LEIFER -- CYCLICAL REFINEMENT OPTION.
C      AMPLITUDE SCALING DEBUG, 1982(RAC)
C      TILTAXIS AND TILTANGLE REFINEMENT 26.8.84.
C      BEAMTILT REFINEMENT 30.12.84
C         LAST MODIFIED 30-DEC-1984 BY R.H.
C      PAY NO ATTENTION TO THE ABOVE HISTORICAL NONSENSE - IT IS ONLY
C      MEANT TO JOG THE MEMORY IN CASE FURTHER FESTERING BUGS EMERGE.
C
C      THIS VERSION --
C                     PRODUCES PLOTTER O/P ON FILE PLOT.PLT(SUBROUTINE_GRAPH)
C                     PRODUCES A MERGED LIST OF H,K,ZSTAR,AMPL,PHASE,FILMNO,
C                        DESCRIPTIVE CODE(+/-IQ) ON UNIT 3.
C                     THE MERGED LIST CAN THEN BE READ IN AND USED FOR
C                        CYCLICAL ORIGIN REFINEMENT.
C                     REFINES CRYSTAL TILTAXIS AN TILTANGLE.
C                     REFINES BEAMTILT (MANIFESTED AS A RESOLUTION-DEPENDENT
C                        SHIFT OF THE PHASE ORIGIN).
C
C###############################################################################
C
C               CARD INPUT ON UNIT 5
C
C   1  ISPGRP,NPROG,NTILT,NBEAM,ILIST,ALNG,BLNG,WIDTH,ANG,IPLOT,MINRFL   (*)
C
C   2  IRUN,LHMIN,LHMAX,IQMAX,IBOXPHS,NREFOUT,NSHFTIN                    (*)
C
C   3  card 3 input depends on the value of NPROG chosen
C
C  IF  NPROG.EQ.0
C       THE FIRST SET OF REFLECTIONS MUST BE FOR AN UNTILTED
C       IMAGE AND ONLY THE UNIQUE REFLECTIONS SHOULD BE PROVIDED
C       THIS OPTION IS MEANT FOR MERGING RAW DATA -- AS IN ORIGINAL
C       ORIGMERG - This set of data can have zero observations
C	provided that SCALE = 1.0 (or any non-zero value) on card 9
C  IF  NPROG.EQ.1
C       THE FIRST SET OF DATA READ IN WILL BE FROM O/P OF A PREVIOUS
C       RUN OF ORIGMERG (UNIT 3 O/P). SUBSEQUENT FILMS WILL BE COMPARED
C       ONLY WITH THIS FIRST SET AND NO MERGED OUTPUT WILL BE POSSIBLE.
C       THIS OPTION IS MEANT FOR CYCLICAL ORIGIN REFINEMENT OF AN ALREADY
C       MERGED SET OF DATA.
C
C                3  IFILM,TITLE                               (I10,10A4)
C
C                3A Filename -- e.g. SS1:[RH15]P4151.APH             (A)
C
C                Then the file contains data of following kind.
C                   ISER                                             (*)
C                   IH,IK,A,P                                        (*)
C                   IH=900 (or EOF) --- THIS ENDS THE SET OF REFLECTIONS
C
C  IF  NPROG.EQ.2 (.LCF) -- (NO INPUT OF ABOVE CARDS 3,4,5, or 6)
C   or NPROG.EQ.3 (.MTZ) data
C       THE REFERENCE DATA IS A THREE-DIMENSIONAL LCF or MTZ DATA FILE.
C       THIS OPTION IS MEANT FOR STRUCTURES THAT HAVE BEEN WELL
C       WORKED OVER ALREADY -- E.G. PURPLE MEMBRANE.
C          Input is on file with name HKLIN for LCF or MTZ file.
C
C  BUT           3  FC=.... SIGFC=.... PHCAL=.... FOM=....   ##(LCF CONTROL)
C   or           3  LABIN AMP=... SIG=... PHASE=... FOM=...  ##(MTZ CONTROL)
C
C       PROCEEDS ACCORDING TO NPROG.EQ.1, BUT REFINEMENT IS DONE AGAINST
C       AMPLITUDE AND PHASE CURVE-FITTED DATA. THE PHASE ORIGIN IS REFINED
C       AS WELL AS (if NTILT=T) THE TILTANGLE AND TILTAXIS. THIS REFINEMENT
C       OF ORIGIN AND TILT IS CARRIED OUT SEPARATELY UNTIL THERE IS
C       NO FURTHER CHANGE IN THE PARAMETERS.
C
C   4  IFILM,TITLE                                            (I10,10A4)
C
C   5  Filename -- e.g. SS1:[RH15]P4151.APH                          (A)
C
C   6  NWGT                                                          (*)
C
C   7  TAXA,TANGL,IORIGT                                             (*)
C
C   8  ORIGH,ORIGK,STEP,WIN,SGNXCH,SCALE,ROT180,REVHK,CTFREV         (*)
C
C   9  CS,KV,TILTH,TILTK                                             (*)
C
C  10  DRESMAX, DRESMIN (BLANK CARD GIVES 100.0,3.5)                 (*)
C
C     Then the file of data contains data of the following kind
C    	ISER                                                         (*)
C    	IH,IK,A,P,IQ                                                 (*)
C    	IH=900  (or EOF) --- THIS ENDS THE SET OF REFLECTIONS.
C
C            ANY NUMBER OF FURTHER IMAGES SPECIFIED BY THE ABOVE CARDS CAN
C            BE INCLUDED AT THIS STAGE.
C
C  11  IFILM<0  --- THIS ENDS DATA INPUT
C
C  12 TITLE --- TITLE FOR PLOT OUTPUT IF REQUESTED.		  (20A4)
C   	
C###############################################################################
C
C
C                ISPGRP - NUMBER OF SPACE GROUP AS BELOW
C		 NPROG  - DETERMINES TYPE OF RUN
C		          IF =0, NORMAL SEQUENTIAL MERGING (OLD ORIGMERG).
C		          IF =1, READS IN PREVIOUSLY MERGED DATA O/P ON UNIT 3.
C                         IF =2, READS IN REFERENCE DATA FROM LCF FILE.
C                         IF =3, READS IN REFERENCE DATA FROM MTZ FILE.
C		 NTILT  -  IF (F) NO CRYSTAL TILTANGLE OR TILTAXIS REFINEMENT.
C		           IF (T) CRYSTAL TILTANGLE AND TILTAXIS ARE REFINED.
C                NBEAM  -  IF (F) NO BEAMTILT REFINEMENT.
C                          IF (T) BEAMTILT IS REFINED -- IN MILLIRADIANS.
C                ILIST  - IF =1 PROGRAM LISTS EACH REFLECTION OTHERWISE
C                           ONLY THE PLOT OF RESIDUALS AND THE FINAL
C                           COMBINED LIST OF REFLECTIONS IS GENERATED
C                ALNG   -  A AXIS IN ANGSTROMS for untilted crystal.
C                BLNG   -  B AXIS IN ANGSTROMS        "        "   .
C                WIDTH  -  THICKNESS OF UNIT CELL IN ANGSTROMS
C                ANG    -  ANGLE BETWEEN A AND B - ONLY FOR P1 OR P2
C                IPLOT  -  IF NOT 0, PLOT FINAL AMPLITUDE & PHASE CURVES
C                            ON CALCOMP PLOTTER
C                MINRFL -  MINIMUM NUMBER OF POINTS REQUIRED FOR A CURVE
C                            TO BE PLOTTED
C                IRUN   - RUN NUMBER, USED AS AN IDENTIFIER ON UNIT 3 O/P
C                LHMIN  - MINIMUM H INDEX TO BE PLOTTED
C                LHMAX  - MAXIMUM H INDEX TO BE PLOTTED
C                              (PROGRAM STOPS AFTER LAST PLOT)
C                IQMAX  - REFLECTION NOT USED FOR ORIGIN OR TILTANGLE
C                           REFINEMENT IF IQ>IQMAX
C                IBOXPHS- SIZE OF PHASE ORIGIN SEARCH, (DEFAULT = 121)
C                NREFOUT-  IF (F) NO OUTPUT OF REFERENCE PROJECTION DATA.
C                          IF (T) FILE IS CREATED WITH REFERENCE PROJECTION
C                                 DATA AT SAME ANGLE AS INPUT DATA.
C                NSHFTIN-  IF (F) NO OUTPUT OF ORIGIN SHIFTED INPUT DATA
C                          IF (T) FILE IS CREATED FROM SHIFTED INPUT DATA
C                IFILM  - INTEGER FILM IDENTIFIER
C                TITLE  - DESCRIPTION OF FILM
C                NIN    - UNIT NUMBER OF INPUT DATA STREAM * NOT USED NOW
C                FILIN  - NAME OF FILE CONTAINING H,K,A,P,IQ DATA
C                NWGT   - IF (T) THEN READ EXTRA FLMWGT DATA FOR EACH REFLECTION
C                         IF (F) THEN NO EXTRA WEIGHT DATA.
C                ISER   - SERIAL NUMBER OF FILM ON UNIT NIN, MUST=IFILM.
C                IH     - H INDEX OF REFLECTION
C                IK     - K INDEX OF REFLECTION
C                P      - PHASE OF REFLECION
C                A      - AMPLITUDE OF REFLECTION
C                IQ     - QUALITY OF REFLECTION
C                TAXA   - ANGLE MEASURED FROM THE TILT AXIS TO THE ASTAR-AXIS,
C                         MEASURED IN DIRECTION OF A TO B BEING POSITIVE.
C                TANGL  - TILT ANGLE IN DEGREES
C                IORIGT - IF IORIGT=1, ORIGIN REFINEMENT IS DONE WITH
C                             WGT = 1.0 FOR EACH NEW SPOT.
C                ORIGH  - INITIAL PHASE SHIFT FOR 1,0 -- IN DEGREES
C                ORIGK  - INITIAL PHASE SHIFT FRO 0,1 --  "    "
C                STEP   - STEP SIZE IN DEGREES FOR ORIGIN REFINEMENT
C                         STEP = 0 ==> NO REFINEMENT
C                WIN    - ZSTAR RANGE WITHIN WHICH SPOTS ARE COMPARED
C                         FOR SCALING AND ORIGIN REFINEMENT
C                SCALE  - MULTIPLIED BY AMPLITUDES BEFORE COMBINATION
C                         IF EQUAL TO 0 SCALING IS AUTOMATIC
C                SGNXCH - IF NOT EQUAL TO 0, FLIP AROUND A AXIS, USEFUL IN P121
C                ROT180 - IF NOT=0, ROTATE 180 DEG ABOUT Z-AXIS, USEFUL IN P1,P3
C                REVHK  - IF NOT = 0, H AND K ARE INTERCHANGED ON INPUT.
C                         THIS IS A COSMETIC FEATURE TO FACILITATE INDEXING
C                         DIFFICULT HIGHLY TILTED FILMS. NOTE THAT ALL OTHER
C                         PARAMETERS, SUCH AS TAXA,TANGL MUST REMAIN CORRECT
C                         W.R.T. THE ORIGINAL DIRECTIONS FOR H AND K.
C		 CTFREV - IF NOT = 0,
C			  REVERSES SIGN OF STRUCTURE FACTOR BY ADDING 180 DEGS
C			  TO THE PHASE. USEFUL FOR LOW DOSE IMAGES WHERE THERE
C			  IS UNCERTAINTY ABOUT WHETHER IMAGE IS OVER-FOCUSSED
C			  OR UNDER-FOCUSSED.
C                CS     - SPHERICAL ABERRATION COEFFICIENT - USED TO GET
C                         BEAMTILT ON RIGHT ABSOLUTE SCALE OF MILIRADIANS.
C                KV     - MICROSCOPE VOLTAGE - USED TO CALCULATE WAVELENGTH.
C                TILTH  - BEAMTILT IN DIRECTION OF ASTAR.
C                TILTK  - BEAMTILT IN DIRECTION OF BSTAR.
C
C###############################################################################
C
C    OUTPUT IS MADE VIA
C         UNIT   6 - LINEPRINTER
C         UNIT   3 - MERGED DATA POINTS(H,K,ZSTAR,AMPL,PHASE,FILMNO,IQ CODE --
C                     CAN BE USED BY ORIGREFN FOR FURTHER CYLES OF REFINEMENT.
C         PLOT.PLT - PLOT FILE FOR PLOT OUTPUT.
C         UNIT   2 - If requested, origin shifted H,K,0,AMP,PHASE of projection.
C         UNIT   4 - If requested, H,K,0,REFAMP,REFPHASE for refdata projection.
C         UNIT   9 - summary file with refined values of tilt,origin & beamtilt.
C
C    INPUT IS MADE VIA
C         UNIT   5 - CONTROL DATA
C         UNIT  10 - NEW IMAGES TO BE MERGED, OR PREVIOUSLY MERGED DATASET
C         HKLIN    - LCF FILE OF AMPLITUDES AND PHASES. (for NPROG.EQ.2)
C         HKLIN    - MTZ FILE OF AMPLITUDES AND PHASES. (for NPROG.EQ.3)
C
C##############################################################################
C  18.8.84 ############  IMPORTANT CHANGE #####################################
C            THE MATRICES IMAT, MAT, IGO HAVE BEEN CHANGED, TOGETHER WITH THE
C            LREV TEST IN ASYM SO THAT THE CONVENTION IN P4, P3, AND P6 IS
C            FOR THE AXIAL INDICES TO BE H,0 RATHER THAN 0,K.
C	     ( THEY ARE THE SAME AS IN EDLCF ).
C
C  PROGRAM MUST NOW BE LINKED USING COMMAND
C   :-   on VAX, PIMLINK ORIGTILT
C	         (INCLUDES LCFLIB,IMLIB,MODLIB,PLOT82, (LIBRARIES) ETC)
C   :-   for UNIX fortran -o origtilt.exe origtilt.for ma21.for -lplot82 -lccp4
C
C##############################################################################
C
C
C SPACE GROUP MATRICES --- convention for p3, p4 and p6 is H,0 (not 0,K).
      INTEGER*2 ISPEC(5,17)
      DATA ISPEC/7*0,1,3*0,1,4*0,1,4*0,1,3*0,3*1,2*0,3*1,0,-1,3*1,0,1,
     A 3*1,4*0,1,0,0,4*1,0,5*1,8*0,1,0,1,1,5*0,1,4*0,1,1,0/
      INTEGER*2 IGO(8,17)
      DATA IGO/8*5,2*4,2*5,2*4,2*5,
     A 4,5,4,5,4,5,4,5,  4,5,4,5,4,5,4,5,  4,5,4,5,4,5,4,5,
     B 2,4,2,5,2,4,2,5,  2,4,2,5,2,4,2,5,  2,4,2,5,2,4,2,5,
     C 2,4,2,5,2,4,2,5,  3,4,3,5,3,4,3,5,  1,2,1,4,1,2,1,5,
     D 1,2,1,4,1,2,1,5,  4,5,4,5,3,5,3,5,  2,4,2,4,1,5,1,5,
     E 2,4,2,4,1,5,1,5,  3,4,3,5,1,4,1,5,  2,3,2,4,1,3,1,5/
      INTEGER*2 IMAT(5,17)
      DATA IMAT/ 1,1,1,1,1,    1,2,1,1,1,    1,3,1,1,1,
     A           1,4,1,1,1,    1,3,1,1,1,    1,2,1,3,1,
     B           1,2,1,4,1,    1,2,1,6,1,    1,2,1,3,1,
     C           1,2,7,5,1,    1,8,1,2,3,    1,8,1,9,6,
     D           1,10,11,12,1, 1,8,1,10,11,  1,9,1,10,11,
     E           1,2,10,5,11,  1,8,9,10,11/
      INTEGER*2 MAT(8,12)
      DATA MAT/   -1,0,0,-1,-1,0,0,-1,      1,0,0,1,-1,0,0,-1,
     A            1,0,0,-1,1,0,0,-1,        1,0,0,-1,1,0,180,-1,
     B            0,1,-1,0,1,0,0,1,        1,0,0,-1,1,180,180,-1,
     C            0,-1,1,0,1,0,0,1,         0,1,1,0,1,0,0,-1,
     D            0,1,1,0,-1,0,0,1,         0,-1,1,1,-1,0,0,-1,
     E            -1,-1,1,0,1,0,0,1,         1,1,-1,0,-1,0,0,-1/
      LOGICAL LREV(17)
      DATA LREV/9*.FALSE.,.TRUE.,2*.FALSE.,.TRUE.,2*.FALSE.,.TRUE.,
     1          .FALSE./
      REAL STANG(17)  ! STANDARD SPACE GROUP ANGLES.
      DATA STANG/2*0.0,10*90.0,5*120.0/
C        ANGLE BETWEEN A AND B FOR ALL SPACEGROUPS EXCEPT P1, P2 IS FIXED.
C
C        THE ABOVE MATRICES ARE USED BY ASYM TO TRANSFORM ALL REFLECTIONS
C           TO THE STANDARD ASYMMETRIC UNIT AND TO PICK OUT THE SPECIAL
C           REFLECTIONS.
C
C
C     NUMBER   SPACEGROUP    ASYMMETRIC UNIT        REAL   IMAGINARY
C
C          1          P1         H>=0
C
C          2         P21         H,Z>=0              Z=0
C
C          3         P12         H,K>=0              K=0
C
C          4        P121         H,K>=0              K=0
C
C          5         C12         H,K>=0              K=0
C
C          6        P222         H,K,Z>=0            H=0
C                                                    K=0
C                                                    Z=0
C
C          7       P2221         H,K,Z>=0          (0,2N,Z)  (0,2N+1,Z)
C                                                    (H,K,0)
C                                                    (H,0,Z)
C
C          8      P22121         H,K,Z>=0            (H,K,0)
C                                                   (2N,0,Z)  (2N+1,0,Z)
C                                                   (0,2N,Z)  (0,2N+1,Z)
C
C          9        C222         H,K,Z>=0            (H,K,0)
C                                                    (H,0,Z)
C                                                    (0,K,Z)
C
C         10          P4         H,K,Z>=0            (H,K,0)
C
C         11        P422         H,K,Z>=0            (H,K,0)
C                                K>=H                (H,0,Z)
C                                                    (0,K,Z)
C                                                    (H,H,Z)
C
C         12       P4212         H,K,Z>=0            (H,K,0)
C                                K>=H                (H,H,Z)
C                                                   (2N,0,Z)   (2N+1,0,Z)
C                                                   (0,2N,Z)   (0,2N+1,Z)
C
C         13          P3         H,K>=0
C
C         14        P312         H,K>=0              (H,H,Z)
C                                K>=H
C
C         15        P321         H,K>=0              (H,0,Z)
C                                 K>H                (0,K,Z)
C
C         16          P6       H,K,Z>=0             (H,K,0)
C
C         17        P622         H,K,Z>=0            (H,K,0)
C                                K>=H                (H,H,Z)
C
C******************************************************************************
C
      PARAMETER (NMAXC=4500)
C*** jms 22.06.2010
      parameter (itotrfl = 80000)
C***      PARAMETER (TOTRFL=80000)
      PARAMETER (MAXRFL=2000)
      PARAMETER (MAXPLT=1500)
      PARAMETER (MAXINDEX=40)
      PARAMETER (NSLOTS=32)
C
C  DIMENSION STATEMENTS FOR NPROG.EQ.2 REFINEMENT - i.e. using LCF files.
C      DIMENSION CELL(6)			! also used in MTZ section
      INTEGER*4 IDATAIN(40)
C     .		,LOOKUP(40)			! also used in MTZ section
      INTEGER*2 IHC(NMAXC),IKC(NMAXC),ILC(NMAXC),
     .	ISC(NMAXC),IFCC(NMAXC),IPHC(NMAXC),IFOM(NMAXC),
     .	IBEGIN(-MAXINDEX:MAXINDEX,-MAXINDEX:MAXINDEX),
     .	IFINISH(-MAXINDEX:MAXINDEX,-MAXINDEX:MAXINDEX)
      DATA IBEGIN/6561*-999/,IFINISH/6561*-999/
C
C----------------------------------------------------------------from here
C  DIMENSION STATEMENTS FOR NPROG.EQ.3 MTZ DATA INPUT
C     .. parameters for mtz aspects
      PARAMETER (NLOC=40)
      PARAMETER (MCOLS=200)
      PARAMETER (NPAR=200)
C
      DIMENSION CELL(6),RSYMX(4,4,96)
      LOGICAL EOF
C
C     .. Local Arrays ..
      REAL ADATAIN(MCOLS),ADATAOUT(MCOLS),DUM(2,MCOLS)
      INTEGER JPOINT(NLOC),LOOKUP(NLOC)
      CHARACTER OUTTYP(NLOC)*1,LSPRGI(NLOC)*30,LSPRGO(NLOC)*30,
     +  TITNEW*70,HISNEW(20)*80,CTPRGI(NLOC)*1,DUMMY*10
C
C     .. Scalars for Parser ..
      INTEGER NTOK
      LOGICAL LEND
      CHARACTER KEY*4,LINE*400
C     ..
C     .. Arrays for Parser ..
      REAL FVALUE(NPAR)
      INTEGER IBEG(NPAR),IDEC(NPAR),IEND(NPAR),ITYP(NPAR)
      CHARACTER CVALUE(NPAR)*4
C
C
C---- NLPRGI  =  number of input labels
      DATA NLPRGI,LSPRGI/7,'H','K','L','AMP','SIG','PHASE',
     +     'FOM',33*' '/
C---- .. This code signs which input columns are essential (LOOKUP)
      DATA CTPRGI/'H','H','H','F','Q','P','W',33*' '/
      DATA LOOKUP/-1,-1,-1,-1,-1,-1,-1,33*0/
      DATA JPOINT/40*0/
C----------------------------------------------------------------to here
C
C  DIMENSION STATEMENTS FOR MAIN ORIGMERG PROGRAM.
      CHARACTER*80 FILIN
      CHARACTER DAT*24
      INTEGER*2 JH(itotrfl),JK(itotrfl),IRP(121,121)
      INTEGER*4 JOUT(itotrfl)
      INTEGER*4 JFILM(itotrfl),JSIGN(itotrfl)
      REAL PHS(itotrfl),AMP(itotrfl),ZSTAR(itotrfl),FLMWGT(itotrfl)
      REAL CPHS(itotrfl),SPHS(itotrfl),BACK(itotrfl),CTFS(itotrfl)
C
C  DIMENSION STATEMENTS FOR INPUT AND ORIGIN/TILTAXIS REFINEMENT.
      DIMENSION RESPOT(MAXRFL)
      INTEGER IHIN(MAXRFL),IKIN(MAXRFL)
C      INTEGER IIH(MAXRFL),IIK(MAXRFL),IQIN(MAXRFL)	! see common block
      INTEGER IPTEST(MAXRFL)
      INTEGER*2 IP1(MAXRFL),IP2(MAXRFL)
      LOGICAL LSPEC(MAXRFL) ! TRUE IF PHASE IS RESTRICTED BY SYMMETRY.
C      REAL PHSI(MAXRFL),PHSC(MAXRFL),WGT(MAXRFL)	! see common block
      REAL PTEMP(MAXRFL)
      REAL PHASIN(MAXRFL),AIN(MAXRFL),WGTIN(MAXRFL)
      REAL BIN(MAXRFL),CTFIN(MAXRFL)
C      REAL BSH(MAXRFL)	! see common block
C
C	DIMENSION STATEMENTS FOR ORIGIN PHASE RESIDUAL HISTOGRAM
	DIMENSION NRESO(NSLOTS),SERRES(NSLOTS),ERRES(NSLOTS)
      DATA IRESTEP/50/
C
C  DIMENSION STATEMENTS FOR BEAMTILT REFINEMENT -- includes COMMON block
C            needed for VA04A minimisation subroutine.
      REAL*4 CS,KV,TILTH,TILTK
      LOGICAL NBEAM,NTILT,NREFOUT,NSHFTIN,NWGT
      COMMON WORK(28),IN1,IIH(MAXRFL),IIK(MAXRFL),IQIN(MAXRFL),
     .	PHSI(MAXRFL),PHSC(MAXRFL),WGT(MAXRFL),SHMIN,SKMIN,TILTH,TILTK,
     .	BEAMSHFT(4),BSH(MAXRFL),IQMAX,NCALCFX,
     .  FUNCMIN,RESTOT,NTOT
      EQUIVALENCE (BEAMSHFT(2),ASTAR),(BEAMSHFT(3),BSTAR),
     .	   (BEAMSHFT(4),ABANG)
C
C  DIMENSION STATEMENTS FOR NREFOUT=.T. REFERENCE PROJECTION AMP & PHASE OUTPUT.
C                           NSHFTIN=.T. SHIFTED INPUT DATA.
      CHARACTER*16 FNAME
      INTEGER IFNAME(4)
      EQUIVALENCE (FNAME,IFNAME)
C
C  DIMENSION STATEMENTS FOR OUTPUT SORTING.
      REAL PZ(MAXPLT),PAMP(MAXPLT),PPHS(MAXPLT)
      INTEGER IPSGN(MAXPLT)
C
      LOGICAL LIST  ! TRUE IF DETAILED PRINTOUT REQUIRED.
      LOGICAL IOK
      REAL TITLE(10)
      DATA LIST/.FALSE./ ! IF TRUE DATA IS LISTED AT INPUT AND REFINE.
      DATA JREFL/0/  ! JREFL IS COUNT ON TOTAL NO. OF REFLECTIONS.
      DATA DRAD,RDEG/0.0174532,57.295779/
      DATA IZERO/0/
C
C
      MAX1=MAXRFL+1
      ZMIN=0.0
      ZMAX=0.0
      AMAX=0.0
      SMIN=40000.
      SMAX=0.
C
C
C
103   FORMAT(' WAVELENGTH (ANGSTROMS)',F10.4)
110   FORMAT(/' THREE-DIMENSIONAL ORIGIN,',
     .' BEAMTILT AND CRYSTAL TILT',
     .' REFINEMENT PROGRAM'/' VX5.05 (17.05.12)'///)
C*** tab removed from line above jms 12.08.2010
115   FORMAT('  TWO SIDED PLANE GROUP ',I3,//)
116   FORMAT(' RUN NUMBER USED AS SERIAL NUMBER FOR UNIT 3 O/P =',I5)
117   FORMAT('  CELLAXES: A ',F7.2,'  B ',F7.2,'  THICKNESS ',F7.2,
     1  '  AB ANGLE ',F7.2,' DEGREES'/)
120   FORMAT(I10,10A4)
125   FORMAT(' *********************************************************
     1**************************************************************'//)
130   FORMAT(//'    UNTILTED FIRST IMAGE   '///)
132   FORMAT('    THESE REFLECTIONS SHOULD BE BROUGHT TO THE PROPER ORIG
     1IN AND'/'  AVERAGED TO YIELD ONE ASYMMETRIC UNIT   '//)
135   FORMAT(' IMAGE ',I10,5X,10A4)
136   FORMAT(' FOUND ',10A4)
137   FORMAT(4X,'H',4X,'K',5X,'ZSTAR',5X,'PHASE',7X,'AMP    IQ',
     .  '   REFPHASE   NREF')
C*** tab removed from line above jms 12.08.2010
138   FORMAT(10A4)
139   FORMAT(4X,'H',3X,'K',3X,'ZSTAR',7X,'AMP',2X,'PHASE  JFILM',
     .  ' IQ  FLMWGT   BACKGRND   CTF')
C*** tab removed from line above jms 12.08.2010
145   FORMAT(2I5,F10.4,2F10.1,I6,F10.1,I6)
146   FORMAT(I10)
147   FORMAT(/,5X,I5,' REFLECTIONS INPUT ')
148   FORMAT(///'0MORE THAN',I5,' REFLECTIONS FOR THIS IMAGE')
149   FORMAT(///'0TOTAL NUMBER OF REFLECTIONS IS MORE THAN',I5)
151   FORMAT(' REQUIRED FILM IDENTIFIER DOES NOT MATCH FILM SERIAL NUMBER
     1 AT'/'  HEAD OF DATALIST,  IFILM=',I10,'    ISER=',I10)
152   FORMAT('  NPROG =',I5/'  NTILT =   ',L1,/'  NBEAM =   ',L1,
     1      /'  ILIST =',I5/'  IPLOT =',I5/'  MINRFL=',I5,
     2      /'  LHMIN =',I5/'  LHMAX =',I5/'  IQMAX =',I5,
     3	    /' IBOXPHS=',I5/' NREFOUT=   ',L1,/' NSHFTIN=   ',L1)
155   FORMAT('  A-STAR WAS',F8.3,' DEGS FROM TILTAXIS;  B-STAR WAS',
     1F8.3,' DEGS FROM TILTAXIS '/'  THE TILT ANGLE WAS ',F8.3,
     1' DEGREES ')
156   FORMAT(' TOTAL REFLECTIONS TO BE SORTED =',I7)
162   FORMAT(' INITIAL PHASE SHIFTS TO (1,0) AND (0,1) WERE ',2F10.2,
     1' DEGS',/,' STEP SIZE FOR ORIGIN',
     .' REFINEMENT, IF ANY, WAS',F10.3,' DEGREES'/
     2' SCALING AND ORIGIN REFINEMENT',
     3' USED REFLECTIONS CLOSER THAN ',F8.5,' IN ZSTAR'//)
163   FORMAT(' SCALE =',F10.5/' SGNXCH=',F10.5/' ROT180=',
     1F10.5/' REVHK =',F10.5/' CTFREV=',F10.5)
164   FORMAT('  AFTER APPLYING PHASE SHIFT, DATA WILL BE FLIPPED ABOUT THE
     1HE A AXIS  ')
165   FORMAT(/'  BEAMTILT INPUT PARAMETERS'/
     .  '              CS ==========',F9.3/
     .  '              KV ==========',F6.0/
     .  '              TILTH =======',F10.4/
     .  '              TILTK =======',F10.4/)
C*** tab removed from 4 lines above jms 12.08.2010
166   FORMAT(/,3X,I10,' REFLECTIONS READ INTO CORE. ')
168   FORMAT(3X,'ORIGIN REFINEMENT DONE BETWEEN ',I5,' OF THE NEW REFLECTI
     1TIONS'/'  AND ,',I5,' OF THE REFLECTIONS FROM PREVIOUS FILMS. ',/,
     2 3X,I5,' REFLECTIONS HAVE PHASES CONSTRAINED BY SYMMETRY.')
169   FORMAT(' THIS IS A TOTAL OF ',I5,' COMPARISONS.')
170   FORMAT(/' SCALE FAC ',F10.5,' BETWEEN',I5,' NEW REFLECTIONS',
     .' AND',I5,' FROM PREVIOUS FILMS')
171   FORMAT(' BEST PHASE RESIDUAL WAS ',F10.3,' DEGREES AT POSITION',
     1 I3,',',I3,' BELOW.')
173   FORMAT(' PHASE SHIFT IS ',F7.2,',',F7.2,' DEGS; NEW ORIGIN IS',
     .F9.2,',',F9.2,' DEGS')
175   FORMAT((1X,121I1))
180   FORMAT(' OUTPUT OF SCALED AND SHIFTED REFLECTIONS. ')
181   FORMAT(' NPROG.NE.0, NO MERGING, TO MERGE RERUN WITH NPROG=0')
182   FORMAT(' SORTING FAILED!!!!!!!!!!!!!!!!!!!! NCHNG= ',I5)
185   FORMAT(' REFLECTION ZSTAR   AMPLITUDE PHASE  FILM',
     1  ' IQ  FLMWGT  BACKGRND  CTF',/,'   IH  IK'/)
C*** tab removed from line above jms 12.08.2010
187   FORMAT(////)
188   FORMAT('0TOO FEW POINTS TO BE WORTH PLOTTING FOR N=',I5,' L=',I5)
190   FORMAT(1X,2I4,F8.4,F10.1,F7.1,I7,I3,F8.5,F10.1,F7.3)
191   FORMAT(1X,2I4,F8.4,F10.1, 7X ,I7,I3,F8.5,F10.1,F7.3)
193   FORMAT(' FOR "EQUAL WEIGHT PER INPUT SPOT ON NEW FILM" TYPE'/
     1'   OF ORIGIN REFINEMENT, TOTAL COMPARISONS =',I5)
195   FORMAT(' IORIGT =',I5)
196   FORMAT(' LATTICE LINE POINTER ARRAY TOO SMALL, MAXINDEX=',I5)
197   FORMAT(' ****  REFERENCE LCF CURVE INPUT BEGINNING  ****')
C
C
C
C        READ SPACE GROUP NUMBER, LIST PARAMETER, UNIT CELL AXES AND IF
C              SPACE GROUP IS P1 OR P2, THE INTER AXIS ANGLE
C
C
      READ(5,*) ISPGRP,NPROG,NTILT,NBEAM,ILIST,ALNG,BLNG,WIDTH,ANG,
     1	 IPLOT,MINRFL
      READ(5,*) IRUN,LHMIN,LHMAX,IQMAX,IBOXPHS,NREFOUT,NSHFTIN
      IF(IBOXPHS.EQ.0.OR.IBOXPHS.GT.121) IBOXPHS=121
      IF(ILIST.EQ.1) LIST=.TRUE.
C
C     IMAT SHOWS WHICH MATRICES WILL BE USED FROM MAT FOR EACH SPACE GROUP
C       THE FIRST ELEMENT OF EACH IS PASSED TO SET,ASYM FOR LATER USE.
C       THE SAME IS DONE FOR IGO WHICH CONTROLS PROGRAM FLOW IN SET,ASYM
C       AND FOR ISPEC WHICH INDICATES SPECIAL REFLECTIONS.
C
      ABANG=STANG(ISPGRP)
      IF(ISPGRP.LE.2) ABANG=ANG
      WRITE(6,110)  ! ORIGTILT header output, with version number.
      WRITE(6,115)ISPGRP
      IF(ISPGRP.GT.9) BLNG=ALNG
      WRITE(6,116)IRUN
      WRITE(6,117)ALNG,BLNG,WIDTH,ABANG
      WRITE(6,125)
      WRITE(6,152) NPROG,NTILT,NBEAM,ILIST,IPLOT,MINRFL,
     .	    LHMIN,LHMAX,IQMAX,IBOXPHS,NREFOUT,NSHFTIN
      ASTAR=1.0/(ALNG*SIN(DRAD*ABANG))
      BSTAR=1.0/(BLNG*SIN(DRAD*ABANG))
      WSTAR=1.0/WIDTH
      ABANG=180.-ABANG  ! NOW ABANG IS RECIPROCAL SPACE ANGLE.
      CALL CCPDPN(9,'SUMMARY','UNKNOWN','F',0,0)
C
C     READ FIRST IMAGE DATA
C      (FOR NPROG.EQ.0)
C     THE FIRST IMAGE SHOULD BE UNTILTED AND ONLY THE ASYMMETRIC UNIT
C     SHOULD BE INPUT WITH ALL REFLECTIONS ON THE PROPER PHASE ORIGIN.
C      (FOR NPROG.EQ.1)
C     THE FIRST DATASET IS A PREVIOUSLY MERGED LIST.
C      (FOR NPROG.EQ.2)
C     THE FIRST DATASET IS A FULLY-FLEDGED LCF FILE.
C      (FOR NPROG.EQ.3)
C     THE FIRST DATASET IS A FULLY-FLEDGED MTZ FILE.
C
      IF(NPROG.GE.2) GO TO 207
C
C
      READ(5,120) IFILM,TITLE ! for NPROG.eq.0 or NPROG.eq.1
      WRITE(6,135)IFILM,TITLE
      READ(5,1005) FILIN
 1005 FORMAT(A)
c      OPEN(UNIT=10,NAME=FILIN,READONLY,STATUS='OLD')
C*** jms 22.06.2010
      open(unit=10,file=filin,status='old')
C***      OPEN(UNIT=10,NAME=FILIN,STATUS='OLD')
      WRITE(6,9201)FILIN
9201  FORMAT(' INPUT FILE NAME ',A)
C*** tab removed from line above jms 12.08.2010
      NIN=10
      READ(NIN,*)ISER
      IF(ISER.NE.IFILM) GO TO 602
      	BACKSPACE NIN
      	READ(NIN,138)TITLE
      	WRITE(6,136)TITLE
C
      IF(NPROG.EQ.0) GO TO 201
      IF(NPROG.EQ.1) GO TO 202
C
201   WRITE(6,130)  ! THIS IF NPROG.EQ.0
      WRITE(6,132)  ! THIS IS ONE ASYMMETRIC UNIT OF REFERENCE DATA.
      IF(LIST) WRITE(6,137)
      DO 200 I=1,MAX1
      READ(NIN,*,END=210)IH,IK,A,P
      IF(IH.GE.900) GO TO 210
      JREFL=JREFL+1
      IF (IH.GE.0) JSIGN(JREFL)=1
      IF (IH.LT.0) JSIGN(JREFL)=-1
      JH(JREFL)=IH
      JK(JREFL)=IK
      ZSTAR(JREFL)=0.0
      FLMWGT(JREFL)=1.0
      JOUT(JREFL)=JREFL
      JFILM(JREFL)=IFILM
      AMP(JREFL)=A
      BACK(JREFL)=0.0
      CTFS(JREFL)=1.0
C      IF(A.LT.0.001) GO TO 215
C
C      ALL PHASES ARE STORED AS VALUES BETWEEN -180.0 AND 180.0 DEGREES
C       THE SIN AND COS OF EACH PHASE IS ALSO STORED FOR USE IN AVERAGES
C
      P=AMOD(P,360.)
      IF(P.LT.-180.0) P=P+360.0
      IF(P.GT.180.0) P=P-360.0
      PHS(JREFL)=P
      P=DRAD*P
      CPHS(JREFL)=COS(P)
      SPHS(JREFL)=SIN(P)
215   IF(LIST)WRITE(6,145)IH,IK,ZSTAR(JREFL),PHS(JREFL),A,JSIGN(JREFL)
200   CONTINUE
      WRITE(6,148) MAXRFL
      STOP
C
202   IF(LIST) WRITE(6,139)
      DO 205 I=1,itotrfl  ! THIS FOR NPROG.EQ.1
      LREFL=JREFL+1
      READ(NIN,*,END=210)JH(LREFL),JK(LREFL),ZSTAR(LREFL),AMP(LREFL),
     .	PHS(LREFL),JFILM(LREFL),JSIGN(LREFL),
     .	FLMWGT(LREFL),BACK(LREFL),CTFS(LREFL)
      IF(JH(LREFL).GE.900) GO TO 210
      JREFL=JREFL+1
      P=DRAD*PHS(JREFL)
      CPHS(JREFL)=COS(P)
      SPHS(JREFL)=SIN(P)
      IF(LIST)WRITE(6,190)JH(LREFL),JK(LREFL),ZSTAR(LREFL),AMP(LREFL),
     .	PHS(LREFL),JFILM(LREFL),JSIGN(LREFL),
     .	FLMWGT(LREFL),BACK(LREFL),CTFS(LREFL)
205   CONTINUE
      WRITE(6,148) itotrfl
      STOP
C
210   WRITE(6,147)JREFL
      JFIRST=JREFL
C
C   Close first file.
C
	CLOSE (UNIT=NIN)
      	GO TO 220
C
207	CONTINUE ! NPROG.EQ.2 or NPROG.eq.3
      IF(NPROG.EQ.2) THEN
C                         REFERENCE CURVE INPUT TO STORAGE.
C	INPUT OF AMPL & PHASES FROM LCF FILE FOR TILTAXIS, TILTANGLE REFINEMENT.
C  	USE POINTERS TO INDICATE THE BEGINNING OR END OF EACH LATTICE LINE.
C
C  	NOTES:- THE FORMULA FOR CALCULATION OF PHASE AT AN ARBITRARY ZSTAR
C            	POSITION DOES NOT TREAT THE SYMMETRY OF SPACE GROUPS WITH
C            	LATTICE LINES FOR WHICH ZSTAR IS ONLY POSITIVE PROPERLY.
C
C       IMAT SHOWS WHICH MATRICES WILL BE USED FROM MAT FOR EACH SPACE GROUP
C       THE FIRST ELEMENT OF EACH IS PASSED TO ASYM FOR LATER USE.
C       THE SAME IS DONE FOR IGO WHICH CONTROLS PROGRAM FLOW IN SET,ASYM
C       AND FOR ISPEC WHICH INDICATES SPECIAL REFLECTIONS.
C
C       ALL PHASES ARE STORED AS VALUES BETWEEN -180.0 AND 180.0 DEGREES
C
C  	INPUT OF PHASES OF NATIVE DATA
C          (TITLE WITH THE PHASES IS CARRIED INVISIBLY IN /LCF/ COMMON BLOCK)
C
	CALL SRLCF1(1,'HKLIN',26,'H K L S FC SIGFC PHCAL FOM',LOOKUP,
     .	  .TRUE.,NCOL,CELL)
      	IF(STANG(ISPGRP).EQ.CELL(6))  GO TO 1105
     		WRITE(6,1109) STANG(ISPGRP),CELL(6)
1109            FORMAT(' CONFLICT BETWEEN CELL ANGLES FROM SPACE GROUP'/
     .          ' AND LCF INPUT FILE')
C*** tab removed from 2 lines above jms 12.08.2010
      	 STOP
1105  	ABANG = 180.0 - CELL(6)
      	 WRITE(6,1113)ALNG,CELL(1),BLNG,CELL(2),WIDTH,CELL(3)
1113	FORMAT(' COMPARISON OF CELL DIMENSIONS READ IN WITH CELL',
     .  ' DIMENSIONS'/'  FROM LCF FILE OF AMPS AND PHASES'/
     .  ' THEY SHOULD BE THE SAME ***********************************'/
     .  '            READ IN       LCF FILE'/
     .  '  A=',2F15.2/'  B=',2F15.2/'  C=',2F15.2)
C*** tabs removed from 5 lines above jms 12.08.2010
C     		ASTAR=1.0/(CELL(1)*SIN(DRAD*ABANG))
C      		BSTAR=1.0/(CELL(2)*SIN(DRAD*ABANG))
C      		CSTAR=1.0/ CELL(3)
C      		WSTAR=CSTAR/3.0
		MH=LOOKUP(1)
		MK=LOOKUP(2)
		ML=LOOKUP(3)
		MS=LOOKUP(4)
		MFC=LOOKUP(5)
      	 MSIGFC=LOOKUP(6)
		MPHCAL=LOOKUP(7)
      	 MFOM=LOOKUP(8)
      	 IFOMLIMIT=1 ! corresponds to classical FOM of 0.01
		NLCFOK=0
      	 NLCFPH=0
      	 NLCFAM=0
		NREC=0
      	 WRITE(6,197)
1101	CALL RLCF1(IDATAIN,*1110,*1110)
		NLCFOK=NLCFOK+1
		NREC=NREC+1
		IF(NLCFOK.GT.NMAXC) GO TO 1150
      	 ITH=IDATAIN(MH)
      	 ITK=IDATAIN(MK)
      	 IF(IABS(ITH).GT.MAXINDEX.OR.IABS(ITK).GT.MAXINDEX) THEN
      	  WRITE(6,196) MAXINDEX
      	  STOP
      	 ENDIF
		IHC(NLCFOK)=ITH
		IKC(NLCFOK)=ITK
		ILC(NLCFOK)=IDATAIN(ML)
		ISC(NLCFOK)=IDATAIN(MS)
		IF(ISC(NLCFOK).LT.SMIN) SMIN=ISC(NLCFOK)  ! SMIN,SMAX NOT USED YET.
		IF(ISC(NLCFOK).GT.SMAX) SMAX=ISC(NLCFOK)
C	  HERE TEST FOM TO BE  > IFOMLIMIT  BEFORE ACCEPTING CURVE DATA.
C	  AND TEST FOR PRESENCE OF THE STRUCTURE FACTOR (USING SIGFC)
	    	IF(IDATAIN(MFOM).GE.IFOMLIMIT) NLCFPH=NLCFPH+1 ! CRITERIA FOM.
      	     IF(IDATAIN(MSIGFC).GT.0.0)     NLCFAM=NLCFAM+1 ! CRITERIA SIGF.
	    	IF(IDATAIN(MFOM).GE.IFOMLIMIT.AND.
     .	  IDATAIN(MSIGFC).GT.0.0) GO TO 1102
		NLCFOK=NLCFOK-1  ! this was not a valid point after all.
	GO TO 1101
1102     IFCC(NLCFOK)=IDATAIN(MFC)
		IPHC(NLCFOK)=IDATAIN(MPHCAL)
      	IF(NLCFOK.NE.1) GO TO 1103
      	 IHOLD=IHC(NLCFOK)
      	 IKOLD=IKC(NLCFOK)
      	 IBEGIN(IHOLD,IKOLD)=1
1103  	IF((IHC(NLCFOK).EQ.IHOLD).AND.(IKC(NLCFOK).EQ.IKOLD)) GO TO 1101
      	IFINISH(IHOLD,IKOLD)=NLCFOK-1
      	WRITE(6,*) IHOLD,IKOLD,ILC(IBEGIN(IHOLD,IKOLD)),
     .	 ILC(IFINISH(IHOLD,IKOLD)),
     .	 IBEGIN(IHOLD,IKOLD),IFINISH(IHOLD,IKOLD)
      	IHOLD=IHC(NLCFOK)
      	IKOLD=IKC(NLCFOK)
      	IBEGIN(IHOLD,IKOLD)=NLCFOK
	GO TO 1101
1110  	IFINISH(IHOLD,IKOLD)=NLCFOK
      	 FOMLIMIT=IFOMLIMIT/100.0
	WRITE(6,1100)NLCFOK,NREC,NLCFAM,NLCFPH,FOMLIMIT
1100    FORMAT(I10,' GOOD S.F.s (i.e.Amp+Phs) read in from LCF FILE'/
     .  I10,' TOTAL RECORDS ON THE FILE'/
     .  I10,' RECORDS HAD AMPLITUDES WITH NON-ZERO SIGFC'/
     .  I10,' RECORDS HAD PHASES WITH FOM >',F5.2)
C*** tabs removed from 5 lines above jms 12.08.2010
	CALL CRLCF1
      	GO TO 220
      ELSE
C	   here only if NPROG.eq.3 -- i.e. for mtz file input
      	 CALL CCPFYP
      	 CALL MTZINI
      	 CALL LROPEN(1,'HKLIN',3,IERR)
      	 CALL LRCELL(1,CELL)
      	 CALL LRSYMM(1,NSYMX,RSYMX)
      	 IF(IERR.NE.0) THEN
      	  WRITE (6,11006)IERR
11006                   FORMAT(' ERROR ON INPUT OF MTZ FILE, IERR=',I5)
C*** tab removed from line above jms 12.08.2010
      	  STOP
      	 ENDIF
C--------- Find out how many columns and reflections in input file
      	 CALL LRINFO(1,DUMMY,NCOL,NREF,DUM)
      	 CALL LKYASN(1,NLPRGI,LSPRGI,CTPRGI,LOOKUP)
C
      	 IF(ISPGRP.GE.3.AND.STANG(ISPGRP).NE.CELL(6)) THEN
      	  WRITE(6,11008) STANG(ISPGRP),CELL(6)
11008     FORMAT(' Conflict between cell angles from space group',
     $    ' and mtz input file, STANG, CELL=',2F8.3)
C*** tabs removed from 2 lines above jms 12.08.2010
      	  STOP
      	 ENDIF
C
      	 IF(ABANG.NE.180.0 - CELL(6))
     .	  STOP' Conflict between GAMMA and MTZ cell angle'
      	 N=0
      	 NAMPS=0
      	 NPHASES=0
      	 NREC=0
C
11007		CALL LRREFF(1,RESOL,ADATAIN,EOF)
      	 IF(EOF) GO TO 11003
      	 NREC=NREC+1
		IF(ADATAIN(5).EQ.0) GO TO 11007 ! CRITERIA ON SIGF
      	 N=N+1
      	 NAMPS=N
	 	IF(N.GT.NMAXC) GO TO 1150
C
      	 IHC(N)=ADATAIN(1)
      	 IKC(N)=ADATAIN(2)
CTSH      		  IF(IABS(IHC(N)).GT.MAXINDEX.OR.IABS(IKC(N)).GT.MAXINDEX) THEN
CTSH++
      	   IF(ABS(IHC(N)).GT.MAXINDEX.OR.ABS(IKC(N)).GT.MAXINDEX) THEN
CTSH--
      	    WRITE(6,196) MAXINDEX
      	    STOP
      	   ENDIF
      	 ILC(N)=ADATAIN(3)
      	 ISC(N)= 10000.0 * ((IHC(N)*ASTAR)**2 +
     .	  2*IHC(N)*IKC(N)*ASTAR*BSTAR*COS(DRAD*ABANG) +
     .	  (IKC(N)*BSTAR)**2+(ILC(N)*WSTAR)**2)
      	 IFCC(N)=ADATAIN(4)
      	 IPHC(N)=ADATAIN(6)
      	 IFOM(N)=ADATAIN(7)*100.0  ! compatibility LCF vs MTZ
      	  IF(IFOM(N).GE.IFOMLIMIT) NPHASES=NPHASES+1
      	 IF(N.EQ.1) THEN
      	  IHOLD=IHC(N)
      	  IKOLD=IKC(N)
      	  IBEGIN(IHOLD,IKOLD)=1
      	 ENDIF
      	 IF(.NOT.((IHC(N).EQ.IHOLD).AND.(IKC(N).EQ.IKOLD))) THEN
      	  IFINISH(IHOLD,IKOLD)=N-1
      	  IHOLD=IHC(N)
      	  IKOLD=IKC(N)
      	  IBEGIN(IHOLD,IKOLD)=N
      	 ENDIF
      	 GO TO 11007
C
11003      WRITE(6,11004)
11004     FORMAT(' end of mtz input')
      	 IFINISH(IHOLD,IKOLD)=N
C
      	 WRITE(6,11005) NPHASES,NREC
11005    FORMAT(I10,' Phases input on stream 1'/
     $          I10,' total records on stream 1.')
C*** tab removed from line above jms 12.08.2010
      	 CALL LRCLOS(1)
      ENDIF
C
C     READ TILTED DATA
C
220    WRITE(6,125)
C  WHEN (NPROG.GE.2), NEW FILMS ARE COMPARED ONLY TO REFERENCE DATASET.
C  WHEN (NPROG.EQ.1), NEW FILMS ARE COMPARED ONLY TO FIRST DATASET(PREV MERGED)
      IF (NPROG.EQ.1) JREFL=JFIRST
      READ(5,120)IFILM,TITLE
      IF(IFILM.LT.0) GO TO 500
      WRITE(6,135) IFILM,TITLE
      READ(5,1005) FILIN
c      OPEN(UNIT=10,NAME=FILIN,READONLY,STATUS='OLD')
C*** jms 22.06.2010
      open(unit=10,file=filin,status='old')
C***      OPEN(UNIT=10,NAME=FILIN,STATUS='OLD')
      WRITE(6,9201)FILIN
      READ(5,*) NWGT
      READ(5,*) TAXA,TANGL,IORIGT
      	TAXB=TAXA+ABANG
      WRITE(6,155)TAXA,TAXB,TANGL
      WRITE(6,195)IORIGT
      READ(5,*)ORIGH,ORIGK,STEP,WIN,SGNXCH,SCALE,ROT180,REVHK,CTFREV
      READ(5,*)CS,KV,TLTH,TLTK
      	 TILTH=0.0
      	 TILTK=0.0
      IF(WIN.GT.0.0) WSTAR=WIN
      WRITE(6,162)ORIGH,ORIGK,STEP,WSTAR
      WRITE(6,163)SCALE,SGNXCH,ROT180,REVHK,CTFREV
      WRITE(6,165)CS,KV,TLTH,TLTK
      	KV=KV*1000.0
      	WL=12.3/SQRT(KV+KV**2/(10.0**6.0))
      	WRITE(6,103)WL
      	BEAMSHFT(1)=0.360*CS*10.0**7*WL**2
C
C     READ RESOLUTION LIMITS FOR THIS FILM; DEFAULT 100.0  3.5
      READ(5,*)DRESMAX,DRESMIN
      IF(DRESMAX.EQ.0.0)DRESMAX=100.
      IF(DRESMIN.EQ.0.0)DRESMIN=3.5
      WRITE(6,9165) DRESMAX,DRESMIN
9165  FORMAT(/' CALCULATIONS WILL USE REFLECTIONS IN ',
     .'RESOLUTION RANGE ',F6.2,' TO ',F6.2,'A'/)
C
      IF(SGNXCH.NE.0.0) WRITE(6,164)
      NIN=10
C	OPEN(UNIT=NIN,READONLY,STATUS='OLD')
      READ(NIN,*)ISER
      IF(ISER.NE.IFILM) GO TO 602
      	BACKSPACE NIN
      	READ(NIN,138)TITLE
      	WRITE(6,136)TITLE
      DO 250 IN=1,MAX1
9250  	IF (NWGT) THEN
      	   READ(NIN,*,END=260)IH,IK,A,P,IQ,BCK,CTF,W
      	ELSE
      	   READ(NIN,*,END=260)IH,IK,A,P,IQ,BCK,CTF
      	   W=1.000
      	ENDIF
      IF(IQ.LT.1)IQ=1
      IF(IQ.GT.9)IQ=9  ! DANGEROUS STATEMENT FOR FUTURE -- BEWARE!
      IF(IH.GE.900) GO TO 260
C     RESOLUTION CHECK  (ON H,K ONLY)
      DSTARSQ=(IH*ASTAR)**2+2*IH*IK*ASTAR*BSTAR*COS(DRAD*ABANG)
     .+(IK*BSTAR)**2
      DRES=1.0/SQRT(DSTARSQ)
      IF(DRES.LT.DRESMIN.OR.DRES.GT.DRESMAX)GO TO 9250
C
      IF(CTFREV.EQ.0.0) GO TO 224
      P=P+180.0    ! CTFREV HERE - FOR LOW DOSE IMAGES.
224   CONTINUE
      AIN(IN)=A    ! HERE A IS STORED
      BIN(IN)=BCK   ! HERE background IS STORED
      CTFIN(IN)=CTF   ! HERE ctf IS STORED
      PHASIN(IN)=P   ! HERE P IS STORED
      WGTIN(IN)=W   ! HERE FILM WEIGHT IS STORED
      IHIN(IN)=IH   ! HERE IH IS STORED AS INPUT
      IKIN(IN)=IK   ! HERE IK IS STORED AS INPUT
      IQIN(IN)=IQ
      JIN=JREFL+IN
      IF (JIN.GT.itotrfl) GO TO 601
      IF (IH.GE.0) JSIGN(JIN)=IQ ! HERE IQ IS STORED
      IF (IH.LT.0) JSIGN(JIN)=-1*IQ
C  JSIGN>0: H>=0 FOR THIS REFLECTION IN SPOTDATA (I.E.BEFORE APPLYING SYMMETRY)
C  JSIGN<0: H<0 FOR THIS REFLECTION IN SPOTDATA
C  ABSOLUTE VALUE OF JSIGN PROVIDES INFORMATION ON QUALITY
C  OF PHASE.  PHASE IS PLOTTED WITH THE SYMBOL NOTED IN
C  IN PARENTHESES.  1=GOOD(*), 2=OKAY(#), 3= UNCERTAINTY IN
C  CONTRAST TRANSFER FUNCTION(+), 4=SPLIT SPOT BUT PROBABLY
C  OKAY, OR PEAK OFF LATTICE WITH PHASE PLATEAU ON LATTICE(X),
C  5=QUESTIONABLE(TRIANGLE), 6=PHASE GRADIENT(SQUARE),
C  7=AMPLITUDE BELOW NOISE LEVEL(CIRCLE)
C
250   CONTINUE
      WRITE(6,148) MAXRFL
      STOP
260   CONTINUE
      IN1=IN-1
      WRITE(6,166) IN1
C
C                      REPEAT FROM HERE IF NPROG.GE.2
      ICALL=0
      IFINSH=0
270   TAXB = TAXA + ABANG
      STAXA=ASTAR*SIN(DRAD*TAXA)
      STAXB=BSTAR*SIN(DRAD*TAXB)
      TTANGL=TAN(TANGL*DRAD)
      ASUM=0.0
      ASUMI=0.0
      NCOMP=0
      NCOMPI=0
      NINEC=0
      SHMIN=0.0
      SKMIN=0.0
      IF(LIST)WRITE(6,137)
      IF(NREFOUT) THEN
CTSH      	ENCODE(16,30,IFNAME)IFILM
CTSH++
      	WRITE(FNAME,30)IFILM
CTSH--
30	FORMAT('HKLAPH',I6,'.REF')
C*** jms 22.06.2010
      open(unit=4,file=fname,form='formatted',status='new')
C***      		OPEN(UNIT=4,NAME=FNAME,FORM='FORMATTED',STATUS='NEW')
      	 WRITE(4,31)IFILM,TITLE
31		FORMAT(I10,10A4,'  Reference amps + phases')
      ENDIF
      	DO 290 IN=1,IN1
      	IH = IHIN(IN)
      	IK = IKIN(IN)
      	IQ = IQIN(IN)
      	A  = AIN(IN)
      	P  = PHASIN(IN)
      	W  = WGTIN(IN)
      IP1(IN)=1
      IP2(IN)=0
      WGT(IN)=0.0
      PHSC(IN)=0.0
      DPERP=IH*STAXA+IK*STAXB
      Z=DPERP*TTANGL
      CALL FIDDLE(IH,IK,Z,REVHK,SGNXCH,ROT180)
      RADSQ=IH**2*ASTAR**2 + IK**2*BSTAR**2 +
     .	     2.0*IH*IK*COS(0.0174532*ABANG)*ASTAR*BSTAR+Z**2
      BSH(IN)=BEAMSHFT(1)*RADSQ  ! HERE BSH IS STORED
      P=P+PHSHFT(IH,IK,ORIGH,ORIGK,TLTH,TLTK,BEAMSHFT,BSH(IN))
      PHSI(IN)=AMOD(P,360.)  ! HERE P IS STORED
      IIH(IN)=IH   ! HERE IH IS STORED
      IIK(IN)=IK   ! HERE IK IS STORED
      JIN=JREFL+IN
C
      CALL ASYM(IH,IK,Z,IP1(IN),IP2(IN),LSPEC(IN),IPTEST(IN),
     1  WSTAR,MAT(1,IMAT(1,ISPGRP)),MAT(1,IMAT(2,ISPGRP)),
     2  MAT(1,IMAT(3,ISPGRP)),MAT(1,IMAT(4,ISPGRP)),
     3	MAT(1,IMAT(5,ISPGRP)),
     4  IGO(1,ISPGRP),ISPEC(1,ISPGRP),LREV(ISPGRP))
C
C       IP1 AND IP2 GENERATE THE RELATIONSHIP BETWEEN PHASES OF REFLECTIONS
C         IN THE UNIQUE ASYMMETRIC UNIT AND THE INPUT REFLECTIONS. THE
C         REFLECTIONS FROM PREVIOUS FILMS WILL BE TRANSFORMED TO LIE IN THE
C         SAME POSITIONS AS THE INPUT REFLECTIONS AND ORIGIN REFINEMENT
C         WILL BE PERFORMED IN P1.
C       LSPEC IS TRUE A REFLECTION IS SPECIAL, HAS ITS PHASE RESTRICTED BY
C         SYMMETRY. IPTEST IS 0 IF THE REFLECTION SHOULD BE REAL AND 90
C         IF IT SHOULD BE IMAGINARY
C
C
      JH(JIN)=IH
      JK(JIN)=IK
      ZSTAR(JIN)=Z
      FLMWGT(JIN)=W
      DSTARSQ=(JH(JIN)*ASTAR)**2+
     .  2*JH(JIN)*JK(JIN)*ASTAR*BSTAR*COS(DRAD*ABANG)+
     .	(JK(JIN)*BSTAR)**2+ZSTAR(JIN)**2
      DRES=1.0/SQRT(DSTARSQ)
      RESPOT(IN)=DRES
      IF(Z.LT.ZMIN) ZMIN=Z
      IF(Z.GT.ZMAX) ZMAX=Z
      IF(SCALE.GT.0.00001 .AND. STEP.LT.0.001) GO TO 290  ! S.F. & ORIGIN INPUT
C
      NSUM=0
      IF(DRES.LT.DRESMIN.OR.DRES.GT.DRESMAX)GO TO 245
      IF (IQ.GT.IQMAX) GO TO 245
C      IF(A.LT.0.001) GO TO 245
      IF(LSPEC(IN)) NINEC=NINEC+1
      IF(NPROG.EQ.0.OR.NPROG.EQ.1)   THEN
C		THIS SECTION FOR COMPARISON WITH PREVIOUS FILMS.
            CSUM=0.0
            SSUM=0.0
            DO 240 IREF=1,JREFL
C            IF(AMP(IREF).LT. 0.001) GO TO 240
            IF(JK(JIN).NE.JK(IREF)) GO TO 240
            IF(JH(JIN).NE.JH(IREF)) GO TO 240
            IF(IFILM.EQ.JFILM(IREF)) GO TO 240
            IF(IABS(JSIGN(IREF)).GT.IQMAX) GO TO 240
            IF(ABS(ZSTAR(JIN)-ZSTAR(IREF)).GT.WSTAR) GO TO 240
            NCOMP=NCOMP+1
            NSUM=NSUM+1
            ASUM=ASUM+AMP(IREF)
C	    WRITE(6,900)IIH(IN),IIK(IN),JH(IREF),JK(IREF),ZSTAR(IREF)
C	    WRITE(6,900) NCOMP,NSUM,IN,IREF,NCOMPI
C900	    FORMAT(8G12.5)
            IF(STEP.EQ.0.0) GO TO 240
      	IARG=IABS(JSIGN(IREF))
CTSH      	WEIGHT=1.0/AJMAX0(2,IARG)
CTSH++
      	WEIGHT=1.0/MAX0(2,IARG)
CTSH--
      	IF(IARG.EQ.8) WEIGHT = 0.005
      	IF(IARG.GT.8) WEIGHT = 0.0
      	IF(AMP(IREF).LT.0.001) WEIGHT = 0.0
            CSUM=CSUM+CPHS(IREF)*WEIGHT ! weighted vector average, with
            SSUM=SSUM+SPHS(IREF)*WEIGHT ! an IQ of 1 or 2 getting equal weight.
240	    CONTINUE
            IF(NSUM.EQ.0) GO TO 290
            NCOMPI=NCOMPI+1
            ASUMI=ASUMI+A*NSUM
            IF(STEP.EQ.0.0) GO TO 290
C
C              SPOTS FROM PREVIOUS FILMS ARE COMPARED WITH THE INPUT FILM SPOTS
C              BY TRANSFORMING THE PREVIOUS FILMS' PHASES WITH IP1 AND IP2
C              TO CORRESPOND TO REFLECTIONS WITH THE SAME INDICES AS THE
C              INPUT REFLECTIONS. THE COMPARISON IS THEN DONE IN P1.
C
            PHSC(IN)=RDEG*ATAN2(SSUM,CSUM)*IP1(IN)-IP2(IN)
      ENDIF
      IF(NPROG.GE.2)    THEN
            CALL GETCRVAL(IN,IHIN,IKIN,IH,IK,Z,ILC,IFCC,IPHC,
     .	 IBEGIN,IFINISH,ISPEC(1,ISPGRP),
     .	 IOK,CELL(3),FREF,PREF,DPDZCU)
      	 IF(.NOT.IOK) GO TO 245
      	 NCOMP=NCOMP+1
      	 NCOMPI=NCOMPI+1
      	 ASUM=ASUM + FREF
      	 ASUMI=ASUMI + A
      	 NSUM=1
      	 IF(STEP.EQ.0.0) GO TO 290
C                  SAME PHASE TRANSFORMATION AS ABOVE.
      	 PHSC(IN)=PREF*IP1(IN)-IP2(IN)
      ENDIF
245   WGT(IN)=NSUM
      IF(NSUM.EQ.0) GO TO 290
      IF(IORIGT.EQ.1) WGT(IN)=1.0
292	     IF(NREFOUT) THEN
      	 IF(IIK(IN).GE.0) THEN
      	   WRITE(4,293) IIH(IN),IIK(IN),IZERO,FREF,PHSC(IN)
      	 ELSE        ! make K positive in p1, and change phase.
      	   WRITE(4,293) -IIH(IN),-IIK(IN),IZERO,FREF,-PHSC(IN)
      	 ENDIF
293		FORMAT(3I5,2F10.2)
      	     ENDIF
C       WRITE(6,900)IN,JIN,NCOMP,WGT(IN),NCOMPI,NSUM,IP1(IN),IP2(IN)
290   IF(LIST)WRITE(6,145)IIH(IN),IIK(IN),ZSTAR(JREFL+IN),
     .	 PHSI(IN),AIN(IN),IQ,PHSC(IN),NSUM
             IF(NREFOUT) CLOSE(4)
C
295   IF(STEP.EQ.0.0) GO TO 400      ! NO REFINEMENT OF TILT OR PHASE ORIGIN.
      SH  = -0.5*(IBOXPHS+1)*STEP
      SK0 = -0.5*(IBOXPHS+1)*STEP
      WRITE(6,168)NCOMPI,NCOMP,NINEC
      NCOMPT=NINEC+NCOMP
      NCOMP9=NINEC+NCOMPI
      IF(IORIGT.EQ.1) WRITE(6,193) NCOMP9
      WRITE(6,169) NCOMPT
      ERRMIN=999.9
      DO 350 ISH=1,IBOXPHS
      SH=STEP+SH
      SK=SK0
      DO 350 ISK=1,IBOXPHS
      SK=STEP+SK
      SERR=0.0
      DO 340 IREFC=1,IN1
      JIN=IREFC+JREFL
      P=PHSI(IREFC)+PHSHFT(IIH(IREFC),IIK(IREFC),SH,SK,
     .	  TILTH,TILTK,BEAMSHFT,BSH(IREFC))
      P=AMOD(P,360.)
      IF(WGT(IREFC).LT.1.0) GO TO 325
      DELTA=P-PHSC(IREFC)
      IF(DELTA.LT.0.0) DELTA=-DELTA
310   IF(DELTA.LE.180.0) GO TO 320
      DELTA=DELTA-360.0
      GO TO 310
320   IF(DELTA.LT.0.0) DELTA=-DELTA
      SERR=WGT(IREFC)*DELTA+SERR
325   CONTINUE
      IF(.NOT.LSPEC(IREFC)) GO TO 340
      IF(IQIN(IREFC).GT.IQMAX)GO TO 340
      IF(RESPOT(IREFC).LT.DRESMIN.OR.RESPOT(IREFC).GT.DRESMAX)GO TO 340
C
      IF(P.GT.180.0) P=P-360.0
      IF(P.LT.-180.0) P=P+360.0
      IF(P.LT.0.0) P=-P
      DELTA=P-IPTEST(IREFC)
      IF(DELTA.LT.0.0) DELTA=-DELTA
      IF(DELTA.GT.90.0) DELTA=180.0-DELTA
      SERR=SERR+DELTA
340   CONTINUE
      IF(NCOMP9.NE.0)SERR9=SERR/NCOMP9
      IF(NCOMPT.NE.0)SERR=SERR/NCOMPT
C       NCOMPT IS NUMBER OF SPECIAL SPOTS + NUMBER OF COMPARISONS WITH
C	ALL PREVIOUS COMPARABLE SPOTS
C	NCOMP9 IS NUMBER OF SPECIAL SPOTS + NUMBER OF NEW SPOTS WHICH
C	HAVE AT LEAST ONE OLD COMPARABLE SPOT
      IF(IORIGT.EQ.1) SERR=SERR9
      IF(SERR.GE.ERRMIN) GO TO 345
      SKMIN=SK
      SHMIN=SH
      ISKMIN=ISK
      ISHMIN=ISH
      ERRMIN=SERR
345   CONTINUE
      ISERR=(90.0-SERR)/10
      IF(ISERR.LT.0) ISERR=0
      IRP(ISH,ISK)=ISERR
350   CONTINUE
      WRITE(6,171) ERRMIN,ISHMIN,ISKMIN
      ORIGHNEW=ORIGH+SHMIN
      ORIGKNEW=ORIGK+SKMIN
      WRITE(6,173) SHMIN,SKMIN,ORIGHNEW,ORIGKNEW
C**
C	REPEAT CALCULATION FOR COORDS OF BEST RESIDUAL TO GET RESIDUAL
C	AS FUNCTION OF RESOLUTION WITH ORIGIN IN THIS POSITION
C
C	CLEAR ARRAYS FOR HISTOGRAM
      DO 18010 J=1,NSLOTS
      NRESO(J)=0 ! ZERO HIST0GRAM
	ERRES(J)=0.0
18010  SERRES(J)=0.0
C
	ISH=ISHMIN
	SH=ISH*STEP - 0.5*(IBOXPHS+1)*STEP
	ISK=ISKMIN
	SK=ISK*STEP - 0.5*(IBOXPHS+1)*STEP
      DO 1340 IREFC=1,IN1
      JIN=IREFC+JREFL
C	CALCULATE RESOLUTION OF SPOT
      DSTARSQ=(1.0/RESPOT(IREFC))**2
C	DSTARSQ = (IIH(IREFC)*ASTAR)**2 + (IIK(IREFC)*BSTAR)**2 +
C     .	2.0*IIH(IREFC)*IIK(IREFC)*ASTAR*BSTAR*COS(DRAD*ABANG)
C     .+ZSTAR(JIN)**2
	IRES=DSTARSQ*10000.
C****
	ISLOT= 1 + (IRES-1)/IRESTEP
      	 IF(ISLOT.LT.1.OR.ISLOT.GE.NSLOTS) THEN
		WRITE(6,20000)ISLOT
20000		FORMAT(' ERROR, ISLOT=',I10)
		STOP
		END IF
      P=PHSI(IREFC)+PHSHFT(IIH(IREFC),IIK(IREFC),SH,SK,
     .	  TILTH,TILTK,BEAMSHFT,BSH(IREFC))
      P=AMOD(P,360.)
      IF(WGT(IREFC).LT.1.0) GO TO 1325
      DELTA=P-PHSC(IREFC)
      IF(DELTA.LT.0.0) DELTA=-DELTA
1310   IF(DELTA.LE.180.0) GO TO 1320
      DELTA=DELTA-360.0
      GO TO 1310
1320   IF(DELTA.LT.0.0) DELTA=-DELTA
      SERR=WGT(IREFC)*DELTA+SERR
C
	SERRES(ISLOT)=SERRES(ISLOT)+WGT(IREFC)*DELTA
	NRESO(ISLOT)=NRESO(ISLOT)+WGT(IREFC)
C	WRITE(6,20001)IIH(IREFC),IIK(IREFC),JH(JIN),JK(JIN),
C     .	 IRES,IQIN(IREFC),PHSC(IREFC),ZSTAR(JIN)
C20001	FORMAT(5I8,I8,F10.2,F10.5)	
1325   CONTINUE
1340	CONTINUE
C	WRITE TABLE OF RESIDUAL AS FUNCTION OF RESOLUTION
C
	WRITE(6,10173)
10173   FORMAT(/5X,'BEST PHASE RESIDUAL IN RESOLUTION RANGES'/
     .5X,'BETWEEN NEW FILM AND OTHER FILMS (NO TREATMENT OF SPECIAL',
     .' REFLECTIONS)'/)
	WRITE(6,10171)
10171	FORMAT(5X,' RANGE','     DMIN ','     DMAX ','   RESIDUAL',
     .'  NUMBER'/)
	NRESALL=0
	SERRESALL=0.0
	DO 10175 I=1,NSLOTS
	IF(NRESO(I).EQ.0)GO TO 10175
	NRESALL=NRESALL+NRESO(I)
	SERRESALL=SERRES(I)+SERRESALL
	ERRES(I)=SERRES(I)/NRESO(I)
	DMIN=SQRT(10000.0/((I-1)*IRESTEP + 1))
	DMAX=SQRT(10000.0/(I*IRESTEP))
	WRITE(6,10172)I,DMIN,DMAX,ERRES(I),NRESO(I)
10175	CONTINUE
10172	FORMAT(5X,I6,3F10.3,I7)
	IF(NRESALL.NE.0) ERRESALL=SERRESALL/NRESALL
	WRITE(6,10174)IFILM,ERRESALL,NRESALL
10174	FORMAT(//5X,'OVERALL (',I6,')',10X,F10.3,I7//)
C**
C
      DO 351 J=1,IBOXPHS
351   WRITE(6,175) (IRP(I,J),I=1,IBOXPHS)
C
C  INSERT HERE FOR BEAMTILT REFINEMENT.
      	IF (NBEAM) THEN
      	 CALL BEAMTILTA
      	WRITE(6,355)ORIGH+SHMIN,ORIGK+SKMIN,TLTH+TILTH,TLTK+TILTK
355	FORMAT(' AGGREGATE TOTAL OF PARAMETERS --- INPUT PLUS REFINED'/
     .	'  ORIGH ...........',F9.2/
     .	'  ORIGK ...........',F9.2/
     .	'  TILTH ...........',F9.2/
     .	'  TILTK ...........',F9.2/)
      WRITE(6,9355)IFILM,ORIGH+SHMIN,ORIGK+SKMIN,TLTH+TILTH,TLTK+TILTK
9355	FORMAT(' LATEST PARAMS',I8,2X,4F9.2)
      	ENDIF
C
C  INSERT HERE FOR TILTANGLE/AXIS REFINEMENT.
      	IF(NPROG.GE.2)THEN
      	DO 360 IN=1,IN1
      	P=PHSI(IN)+PHSHFT(IIH(IN),IIK(IN),SHMIN,SKMIN,
     .	    TILTH,TILTK,BEAMSHFT,BSH(IN))
360	PTEMP(IN) = AMOD(P,360.)
C
      IF (NTILT) CALL TILTP(IN1,IHIN,IKIN,IQIN,AIN,
     .	PTEMP,AMP,JREFL,JH,JK,ZSTAR,
     .	IHC,IKC,ILC,ISC,IFCC,IPHC,IBEGIN,IFINISH,
     .	TAXA,ABANG,TANGL,ASTAR,BSTAR,IFINSH,
     .	MAT(1,IMAT(1,ISPGRP)),MAT(1,IMAT(2,ISPGRP)),
     .	MAT(1,IMAT(3,ISPGRP)),MAT(1,IMAT(4,ISPGRP)),
     .	MAT(1,IMAT(5,ISPGRP)),
     .	IGO(1,ISPGRP),ISPEC(1,ISPGRP),CELL(3),
     .	REVHK,SGNXCH,ROT180,IQMAX,LREV(ISPGRP))
      ICALL=ICALL+1
C
      	ELSE
      	 IF(NTILT) WRITE(6,401)
401		FORMAT(//'  WARNING !!! - crystal tilt cannot be refined',
     .	  ' unless 3D-data with NPROG = 2 or 3 is available'//)
      	ENDIF
      IF (IFINSH.EQ.1.OR.ICALL.GT.4.OR.NPROG.LT.2.) GO TO 400
      IF (.NOT.NTILT) GO TO 400
      GO TO 270  ! BACK TO START TO REDO SCALING, ORIGIN AND TILT.
C
400   IF(SCALE.LT.0.0001)SCALE=ASUM/ASUMI ! JUMP HERE IF STEP = 0.
      WRITE(6,170) SCALE,NCOMPI,NCOMP
      IF(LIST) WRITE(6,137)
C
C  Here to create new file if output of origin shifted data is needed.
      	  IF(NSHFTIN) THEN
CTSH      	    ENCODE(16,32,IFNAME)IFILM
CTSH++
      	    WRITE(FNAME,32)IFILM
CTSH--
32	    FORMAT('HKLAPH',I6,'.PRJ')
C*** jms 22.06.2010
      open(unit=2,file=fname,form='formatted',status='new')
C***      		OPEN(UNIT=2,NAME=FNAME,FORM='FORMATTED',STATUS='NEW')
      	 WRITE(2,33)IFILM,TITLE
33		FORMAT(I10,10A4,'  Origin shifted APH data')
          ENDIF
C
C  APPLY SCALE FACTOR AND ORIGIN PHASE SHIFT.
      DO 410  IN=1,IN1
      JREFL=JREFL+1  ! HERE IS WHERE JREFL IS INCREMENTED.
C                       JH,JK,ZSTAR done previously.
      JOUT(JREFL)=JREFL
      PHS(JREFL)=0.0
      AMP(JREFL)=AIN(IN)*SCALE
      BACK(JREFL)=BIN(IN)*SCALE
      CTFS(JREFL)=CTFIN(IN)
      IF(AMP(JREFL).GT.AMAX) AMAX=AMP(JREFL)
      JFILM(JREFL)=IFILM
C      IF(AIN(IN).LT.0.001) GO TO 405
      P=PHSI(IN)+PHSHFT(IIH(IN),IIK(IN),SHMIN,SKMIN,
     .	  TILTH,TILTK,BEAMSHFT,BSH(IN))
294	     IF(NSHFTIN) THEN  ! output of origin shifted data
      	 IF(AIN(IN).GT.0.0) THEN
      	  POUT=AMOD(P,360.)
      	  IF(POUT.LT.-180.0)POUT=POUT+360.0
      	  IF(POUT.GT.180.0) POUT=POUT-360.0
      	  IF(IIK(IN).GE.0) THEN
      	    WRITE(2,293) IIH(IN),IIK(IN),IZERO,AIN(IN),POUT
      	   ELSE        ! make K positive in p1, and change phase.
      	    WRITE(2,293) -IIH(IN),-IIK(IN),IZERO,AIN(IN),-POUT
      	  ENDIF
      	 ENDIF
      	     ENDIF
C
      P=P*IP1(IN)+IP2(IN)
C
C       NEW REFLECTIONS ARE TRANSFORMED TO THE UNIQUE ASYMMETRIC UNIT AFTER
C        THE BEST PHASE SHIFT HAS BEEN APPLIED
C
C
      P=AMOD(P,360.)
      IF(P.LT.-180.0)P=P+360.0
      IF(P.GT.180.0) P=P-360.0
      PHS(JREFL)=P
      P=DRAD*P
      CPHS(JREFL)=COS(P)
      SPHS(JREFL)=SIN(P)
405   IF(LIST)WRITE(6,145)JH(JREFL),JK(JREFL),ZSTAR(JREFL),
     .    PHS(JREFL),AMP(JREFL),JSIGN(JREFL)
410   CONTINUE
C
C   Before returning for another read, close file.
C
	CLOSE (UNIT=NIN)
      	IF(NSHFTIN) CLOSE(2) ! close unit 2 for
C
C  Output of summary file for use in updating .inf file, if used.
C
      IF(NTILT.OR.NBEAM.OR.STEP.NE.0.0) THEN
      	CALL FDATE(DAT)
      	WRITE(9,502)IFILM,TITLE,FILIN
      	IF(NTILT) WRITE(9,503) TAXA,TANGL,DAT(5:24)
      	IF(NBEAM) THEN
      	 WRITE(9,505) TLTH+TILTH, TLTK+TILTK, DAT(5:24)
      	 WRITE(9,504) ORIGH+SHMIN, ORIGK+SKMIN, DAT(5:24)
      	ELSE
      	 IF(STEP.NE.0.0) WRITE(9,504) ORIGHNEW,ORIGKNEW,DAT(5:24)
      	ENDIF
      	WRITE(9,506)
      ENDIF
502   FORMAT(' ORIGTILT: film ',I6,10A4/'  taken from input file ',A)
503   FORMAT(' TAXATANGL: ',2F8.3,' DATE ',A20)
504   FORMAT(' ORIGHORIGK:',2F9.2,' DATE ',A20)
505   FORMAT(' TILTHTILTK:',2F9.2,' DATE ',A20)
506   FORMAT(/)
C
      GO TO 220  ! BACK TO DO INPUT FOR ANOTHER FILM.
500   WRITE(6,125)
      CLOSE(UNIT=9)
      IF(NPROG.EQ.0) GO TO 501    ! STOP HERE FOR NPROG 1, 2 OR 3.(REFINE ONLY)
      WRITE(6,181)
      GO TO 1107
501   WRITE(6,180)
C      SORT REFLECTIONS FOR OUTPUT -- BETTER TO USE SHLSRT IF IT GETS SLOW.
C
C        REFLECTIONS ARE SORTED INTO ASCENDING ORDER IN H,K AND ZSTAR
C
      WRITE(6,156) JREFL
      IF(NPROG.EQ.0) WRITE(3,146)IRUN  ! To ensure disk is there before sorting.
C
      DO 530 I=1,10
      NCHNG=0
      JREFL1=JREFL-1
      DO 510 IA=1,JREFL1
      JA=IA+1
      DO 510 IB=JA,JREFL
      KA=JOUT(IA)
      KB=JOUT(IB)
      IF(KA.LT.1.OR.KA.GT.itotrfl.OR.KB.LT.1.OR.KB.GT.itotrfl) THEN
      	WRITE(*,*) 'KA or KB out of bounds',KA,KB
      	STOP
      ENDIF
      IF(JH(KA)-JH(KB)) 510,520,525
525   J1=JOUT(IA)
      JOUT(IA)=JOUT(IB)
      JOUT(IB)=J1
      NCHNG=NCHNG+1
      GO TO 510
520   IF(JK(KA)-JK(KB)) 510,515,525
515   IF(ZSTAR(KA)-ZSTAR(KB)) 510,510,525
510   CONTINUE
      IF(NCHNG.EQ.0) GO TO 550
530   CONTINUE
C
      WRITE(6,182) NCHNG
C
C        THIS STATEMENT SHOULD NEVER BE REACHED
550   WRITE(6,185)
C
C
C      THE SORTED REFLECTIONS ARE OUTPUT IN ASCENDING ORDER
C
C
      LH=-1000
      LK=-1000
      IREFL=1
      DO 600 KK=1,JREFL
      KJ=JOUT(KK)
      IF(IPLOT.EQ.0) GO TO 562
      IF(AMP(KJ).LT.0.001) GO TO 560 ! NO OUTPUT OF REFNS WITH ZERO AMPL.
      PZ(IREFL)=ZSTAR(KJ)
      PAMP(IREFL)=AMP(KJ)
      PPHS(IREFL)=PHS(KJ)
      IPSGN(IREFL)=JSIGN(KJ)
      IREFL=IREFL+1
      IF(IREFL.GT.MAXPLT) THEN
      	WRITE(*,*) ' H,K,IREFL,MAXPLT',JH(KJ),JK(KJ),IREFL,MAXPLT
      	STOP 'MAXPLT on above lattice line too small'
      ENDIF
560   CONTINUE
C
      IF(KK.EQ.1) GO TO 562
      IF(LH.EQ.JH(KJ).AND.LK.EQ.JK(KJ).AND.KK.NE.JREFL) GO TO 564
      IREF1=IREFL
      IF(KK.NE.JREFL) IREF1=IREFL-1
      IREF2=IREF1-1
      IF(IREF2.GE.MINRFL) GO TO 563
      WRITE(6,188) LH,LK
      GO TO 565
563   IF (LH.LT.LHMIN) GO TO 565
      IF (LH.GT.LHMAX) THEN
      	WRITE(6,*)' Sorted reflections with H > LHMAX not printed'
      	GOTO 1107
      ENDIF
C      IF (LH.GT.LHMAX) GO TO 600
      CALL GRAPH(ZMIN,ZMAX,AMAX,LH,LK,IREF2,PZ,PAMP,PPHS,IPSGN)
  565 PZ(1)=PZ(IREF1)
      PAMP(1)=PAMP(IREF1)
      PPHS(1)=PPHS(IREF1)
      IPSGN(1)=IPSGN(IREF1)
      IREFL=2
562   IF(LH.NE.JH(KJ).OR.LK.NE.JK(KJ)) WRITE(6,187)
      LH=JH(KJ)
      LK=JK(KJ)
564   IF(AMP(KJ).LT.0.001) GO TO 555
      WRITE(6,190) LH,LK,ZSTAR(KJ),AMP(KJ),PHS(KJ),
     .	JFILM(KJ),JSIGN(KJ),FLMWGT(KJ),BACK(KJ),CTFS(KJ)
      WRITE(3,190) LH,LK,ZSTAR(KJ),AMP(KJ),PHS(KJ),
     .	JFILM(KJ),JSIGN(KJ),FLMWGT(KJ),BACK(KJ),CTFS(KJ)
      GO TO 600
  555 WRITE(6,191) LH,LK,ZSTAR(KJ),AMP(KJ),JFILM(KJ),JSIGN(KJ),
     .	 FLMWGT(KJ),BACK(KJ),CTFS(KJ)
600   CONTINUE
      GO TO 1107
601   WRITE(6,149) itotrfl
      STOP
602   WRITE(6,151)IFILM,ISER
      STOP
1150  WRITE(6,1106)NMAXC
1106  FORMAT(' REFERENCE PHASE DATA TOO BIG FOR PROGRAM DIMENSION',I6)
1107  CONTINUE
      END
C
C******************************************************************************
      SUBROUTINE ASYM(IH,IK,Z,IP1,IP2,SPEC,IPTEST,WSTAR,
     1	A1,A2,A3,A4,A5,IGO,ISPEC,LREV)
      INTEGER*2 A1(8),A2(8),A3(8),A4(8),A5(8),IGO(8),ISPEC(5)
      INTEGER*2 IP1,IP2
      LOGICAL SPEC,LREV
C
C      WRITE(6,904)A1,A2,A3,A4,A5,IH,IK,Z,IP1,IP2,SPEC,IPTEST,WSTAR
      IF(IH.LT.0) CALL MULT(A1,IH,IK,Z,IP1,IP2)
      PASS=0 ! second pass (22.1.90) to check all changes made correctly.
50    INDEX=1
      IF(IK.GE.0) INDEX=INDEX+1
      IF(Z.GE.0.0) INDEX=INDEX+2
      IF(IH.LT.IABS(IK)) INDEX=INDEX+4
      INDEX=IGO(INDEX)
C      WRITE(6,902) INDEX
902   FORMAT (I10)
C      WRITE(6,901) IH,IK,Z,IP1,IP2
901   FORMAT(2I5,F10.5,2I5)
      GO TO (100,150,200,250,500), INDEX
C
C     INDEX CLASSIFIES THE REFLECTION BY ITS INDICES
C     IGO INDICATES WHICH MATRIX WILL BRING THE REFLECTION
C        INTO THE UNIQUE ASYMMETRIC UNIT FOR A GIVEN INDEX
C
C    INDEX    K>=0     Z>=0   /K/>=/H/
C      1       NO       NO      NO
C      2       YES      NO      NO
C      3       NO       YES     NO
C      4       YES      YES     NO
C      5       NO       NO      YES
C      6       YES      NO      YES
C      7       NO       YES     YES
C      8       YES      YES     YES
C
C      P622 IS THE HIGHEST SYMMETRY AND ITS ASYMMETRIC UNIT IS ONLY
C         INDEX = 8
C
100    CALL MULT(A5,IH,IK,Z,IP1,IP2)
C       WRITE(6,900) A5,IH,IK,Z,IP1,IP2
900    FORMAT(8I5,5X,2I5,F10.5,2I10)
       GO TO 50
150    CALL MULT(A4,IH,IK,Z,IP1,IP2)
C       WRITE(6,900)A4,IH,IK,Z,IP1,IP2
       GO TO 50
200    CALL MULT(A3,IH,IK,Z,IP1,IP2)
C       WRITE(6,900)A3,IH,IK,Z,IP1,IP2
       GO TO 50
250    CALL MULT(A2,IH,IK,Z,IP1,IP2)
C       WRITE(6,900)A2,IH,IK,Z,IP1,IP2
C
C      AFTER REFLECTIONS HAVE BEEN PLACED INTO THE ASYMMETRIC UNIT
C       THEY ARE EXAMINED TO SEE IF THEY ARE SPECIAL REFLECTIONS,
C       ONES WHOSE PHASE MUST BE EITHER REAL (0 OR PI) OR IMAGINARY
C       (PI/2 OR 3*PI/2)
C
500    CONTINUE
       IF(IH.EQ.0 .AND. IK.LT.0) CALL MULT(A1,IH,IK,Z,IP1,IP2)
       IF(LREV .AND. IH.EQ.0) CALL MULT(A4,IH,IK,Z,IP1,IP2)

      PASS=PASS+1   !
      IF(PASS.EQ.1) GO TO 50  ! Check through again once only.
C					! Done 22.1.90 to fix the -ve zstar
C					! obtained for h=0,k=-ve refls in p2.

       SPEC=.FALSE.
       IPTEST=0
C      SPEC WILL BE TRUE IF THE REFLECTION IS SPECIAL .
C      IPTEST WILL BE 0 IF REAL AND 90 IF IMAGINARY
C      ISPEC INDICATES THE CONDITIONS FOR THE REFLECTIONS
C          ISPEC(1)=1  H=0 SPECIAL
C          ISPEC(2)=1  K=0 SPECIAL
C          ISPEC(3)=1  Z=0 SPECIAL
C          ISPEC(4)=1  H=K SPECIAL
C          ISPEC(5)=1  IF FOR H=0 OR K=0 K+H ODD INDICATES AN
C                       IMAGINARY VALUE FOR THE REFLECTION
C                      ALL OTHER SPECIAL REFLECTIONS ARE REAL
C
      IF(ISPEC(1).LT.1) GO TO 510
      IF(IH.EQ.0) GO TO 560
510   CONTINUE
      IF(ISPEC(2).LT.1) GO TO 520
      IF(IK.EQ.0) GO TO 560
520   CONTINUE
      IF(ISPEC(3).LT.1) GO TO 530
      IF(ABS(Z).LT.WSTAR) GO TO 570
530   CONTINUE
      IF(ISPEC(4).LT.1) GO TO 600
      IF(IH.EQ.IK) GO TO 570
      GO TO 600
560   CONTINUE
      IF(ISPEC(5).EQ.0) GO TO 570
      IF(ISPEC(5).EQ.-1) GO TO 563
      I=IH+IK
      GO TO 565
563   I=IK
565   I2=2*(I/2)
      IF(I.GT.I2) IPTEST=90
570   SPEC=.TRUE.
600    CONTINUE
C      WRITE(6,903)IH,IK,Z,IP1,IP2,SPEC,IPTEST,WSTAR
903   FORMAT(2I5,F10.5,2I10,L4,I5,F10.5)
      RETURN
      END
C*******************************************************************************
      SUBROUTINE MULT(IA,IH,IK,Z,IP1,IP2)
C
C     DOES MATRIX MULTIPLICATION TO BRING REFLECTIONS INTO THE
C       ASYMMETRIC UNIT.
C
C     (H' K' Z' AMP' PHS')=(H K Z AMP PHI) <A>
C
C
C        <A> HAS FORM     IA(1)  IA(3)     0      0  IA(6)
C                         IA(2)  IA(4)     0      0  IA(7)
C                             0      0 IA(5)      0      0
C                             0      0     0      1      0
C                             0      0     0      0  IA(8)
C           FOR ALL CASES.
C
C
      INTEGER*2 IA(8),IP1,IP2
C      WRITE(6,900)IA,IH,IK,Z,IP1,IP2
      IH1=IA(1)*IH+IA(2)*IK
      IK=IA(3)*IH+IA(4)*IK
      IH=IH1
      Z=IA(5)*Z
      IP1=IA(8)*IP1
      IP2=IP2+IA(6)*IH+IA(7)*IK
C      WRITE(6,900)IA,IH,IK,Z,IP1,IP2
C900   FORMAT(' IA,IH,IK,Z,IP1,IP2 ',8G5.1,10X,5G10.5)
      RETURN
      END
C******************************************************************************
      SUBROUTINE GRAPH(ZMIN,ZMAX,FMAX,IHIN,IKIN,NOBS,ZSTAR,
     .FOBS,PHIOBS,IPSGN)
	DATA INIT/0/
CTSH	DIMENSION ZSTAR(1),FOBS(1),PHIOBS(1),IPSGN(1),LINE(20),TITLE(20)
CTSH++
	DIMENSION ZSTAR(1),FOBS(1),PHIOBS(1),IPSGN(1),TITLE(20)
	CHARACTER*80 LINE
CTSH--
C
C     PLOT AMPLITUDES AND PHASES ALONG EACH (H,K) LINE USING TRILOG.
C
C          NOBS   - NUMBER OF REFLECTIONS TO BE PLOTTED
C          ZSTAR  - ZSTAR VALUES OF DATA
C          FOBS   - AMPLITUDES OF DATA
C          PHIOBS - PHASE OF DATA
C          ZMIN   - MIN ZSTAR OVERALL
C          ZMAX   - MAX ZSTAR OVERALL
C          FMAX   - MAX AMPLITUDE OVERALL
C          IHIN   - H INDEX OF LATTICE LINE
C          IKIN   - K INDEX OF LINE
C          INIT   - 0 TO OPEN PLOT QUEUE, THEN 1
C          IPSGN  - VALUE OF +/- IQ FROM MAIN PROGRAM,
C                   DETERMINES TYPE OF CHARACTER IN PHASE PLOT
C
	ZMAG=1000.
	FMAG=70.
	PMAG=90.  ! NOW PLOT OVER 540 DEGREES
	GAP=8.
	DELZ = .02
      	PLTSIZ=142.5
      	FONTSIZE=4.75
	IF(INIT.EQ.1) THEN
      	 CALL P2K_PAGE
      	 GO TO 5
      	ENDIF
C
C PLOT TITLE
	READ(5,1)TITLE
1	FORMAT(20A4)
	WRITE(6,1)TITLE
      	CALL P2K_OUTFILE('PLOT',4)
5       CALL P2K_HOME
      	CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE)
      	CALL P2K_GRID(0.5*PLTSIZ,0.5*PLTSIZ,1.0)
      	CALL P2K_ORIGIN(-0.5*PLTSIZ,-0.8*PLTSIZ,0.)
      	CALL P2K_COLOUR(0)
      	CALL P2K_LWIDTH(0.3)
	INIT=1
C
C5	ZRANG=ZMAX-ZMIN
	ZRANG=ZMAX-ZMIN
6	ZMM=ZRANG*ZMAG
	IF (ZMM .GT. 100.0) GOTO 7
	ZMAG = ZMAG*2.0
	GOTO 6
7	ZERO=-ZMIN*ZMAG
C
C  DRAW AXES FOR AMPLITUDE BOX
C
	IF(NOBS.LE.8) GO TO 100
        CALL P2K_MOVE(0.,0.,0.)
      	CALL P2K_ORIGIN(5.0,30.0,0.)
C      	CALL P2K_MOVE(10.,-15.,0.)
      	CALL P2K_MOVE(-5.,-12.,0.)
      	CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE*0.8)
      	CALL P2K_STRING(TITLE,80,0.)
      	CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE)
      CALL P2K_MOVE(0.,0.,0.)
      CALL P2K_DRAW(0.,FMAG,0.)
      CALL P2K_DRAW(ZMM,FMAG,0.)
      CALL P2K_DRAW(ZMM,0.,0.)
      CALL P2K_DRAW(0.,0.,0.)
      CALL P2K_MOVE(0.,0.,0.)
      CALL P2K_DRAW(ZERO,0.,0.)
C	POSN=ZRANG*ZMAG-22.
	POSN=ZRANG*ZMAG-18.
      CALL P2K_MOVE(POSN,FMAG-10.0,0.)
CTSH	ENCODE(7,103,LINE) IHIN,IKIN
CTSH++
	WRITE(LINE,103) IHIN,IKIN
CTSH--
103	FORMAT('(',I2,',',I2,')')
      	CALL P2K_STRING(LINE,7,0.)
	IZ=ZRANG/DELZ
C
	DO 25 J=1,200
	  ZPOS=-0.5+J*DELZ
	  IF((ZPOS.LT.ZMIN).OR.(ZPOS.GE.ZMAX))GO TO 25
	  XPOS=ZERO+ZPOS*ZMAG
      	  CALL P2K_MOVE(XPOS,0.,0.)
      	  CALL P2K_DRAW(XPOS,-2.0,0.)
	  XPOS=XPOS-7.0
      	  CALL P2K_MOVE(XPOS,-5.5,0.)
CTSH	  ENCODE(6,26,LINE) ZPOS
CTSH++
	  WRITE(LINE,26) ZPOS
CTSH--
          CALL P2K_STRING(LINE,6,0.)
25	CONTINUE
26	FORMAT(F6.3)
        CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE*0.6)
C	POSN=ZRANG*ZMAG-45.
	POSN=ZRANG*ZMAG-35.
      	CALL P2K_MOVE(POSN,FMAG-10.0,0.)
CTSH      	ENCODE(12,27,LINE)
CTSH++
      	WRITE(LINE,27)
CTSH--
27	FORMAT('LATTICE LINE')
c	CALL STRING(%REF('LATTICE LINE'),12)
        CALL P2K_STRING(LINE,12,0.)
C	POSN=ZRANG*ZMAG-2.
	POSN=ZRANG*ZMAG+2.5
      	CALL P2K_MOVE(POSN,-4.5,0.)
c	CALL STRING(%REF('RECIPROCAL'),10)
        CALL P2K_STRING('RECIPROCAL',10,0.)
        CALL P2K_MOVE(POSN,-7.5,0.)
c	CALL STRING(%REF('ANGSTROMS'),9)
        CALL P2K_STRING('ANGSTROMS',9,0.)
        CALL P2K_MOVE(0.,0.,0.)
      	CALL P2K_ORIGIN(ZERO,0.0,0.)
	SCALE=FMAG/(1.05*FMAX)
	IA=ALOG10(1.05*FMAX)
	B=10.0**IA
	IC=FMAX*1.05/B
	DO 200 J=1,IC
	  F=J*B
	  YPOS=F*SCALE
	  ZA=ZMIN*ZMAG
	  ZB=ZMAX*ZMAG
          CALL P2K_MOVE(ZA,YPOS,0.)
	  ZD=ZA+2.0
          CALL P2K_DRAW(ZD,YPOS,0.)
	  ZD=ZB-2.0
          CALL P2K_MOVE(ZB,YPOS,0.)
          CALL P2K_DRAW(ZD,YPOS,0.)
	  XPOS=ZB
          CALL P2K_MOVE(XPOS,YPOS,0.)
CTSH	  ENCODE(7,201,LINE) F
CTSH++
	  WRITE(LINE,201) F
CTSH--
      	  CALL P2K_STRING(LINE,7,0.)
200	CONTINUE
        CALL P2K_MOVE(XPOS,0.,0.)
c	CALL STRING(%REF('    0.0'),7)
        CALL P2K_STRING('    0.0',7,0.)
201	FORMAT(F7.1)
C
C  PLOT OBSERVED AMPLITUDES FIRST
C
        CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE*0.48)
	DO 50 J=1,NOBS
	  IF(FOBS(J).EQ.-999.) GO TO 50
	  XP=ZSTAR(J)*ZMAG - 0.05
	  YP=FOBS(J)*SCALE - 0.28*FONTSIZE*0.48
          CALL P2K_MOVE(XP,YP,0.)
c	  CALL CSTRING(%REF('X'),1)
          CALL P2K_CSTRING('X',1,0.)
50	CONTINUE
        CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE*0.6)
C
C
C  DRAW AXES FOR PHASE BOX.
C
	PMAG2 = PMAG/540.  ! NOW PLOT OVER 540 DEGREES
	YPOS=FMAG+GAP+PMAG/3.0  ! NOW PLOT OVER 540 DEGREES
        CALL P2K_MOVE(0.,0.,0.)
      	CALL P2K_ORIGIN(0.0,YPOS,0.)
	ZA=ZMIN*ZMAG
	ZB=ZMAX*ZMAG
	YAXIS=180.0*PMAG2
        CALL P2K_MOVE(ZA,-YAXIS,0.)
        CALL P2K_DRAW(ZA,+YAXIS*2.0,0.) ! NOW PLOT OVER 540 DEGREES
        CALL P2K_DRAW(ZB,+YAXIS*2.0,0.) ! NOW PLOT OVER 540 DEGREES
        CALL P2K_DRAW(ZB,-YAXIS,0.)
        CALL P2K_DRAW(ZA,-YAXIS,0.)
        CALL P2K_MOVE(0.0,-YAXIS,0.)
        CALL P2K_DRAW(0.0,+YAXIS*2.0,0.) ! NOW PLOT OVER 540 DEGREES
	DO 620 J=1,11
	  YPOS=(PMAG/12)*J -YAXIS ! NOW PLOT OVER 540 DEGREES
          CALL P2K_MOVE(ZA,YPOS,0.)
	  ZD=ZA+2.0
          CALL P2K_DRAW(ZD,YPOS,0.)
	  ZD=ZB-2.0
          CALL P2K_MOVE(ZB,YPOS,0.)
          CALL P2K_DRAW(ZD,YPOS,0.)
620	CONTINUE
	DO 630 J=1,7   ! NOW PLOT OVER 540 DEGREES
	  IANG=-180+(J-1)*90
	  XPOS=ZB+1.0
	  YPOS=IANG*PMAG2
          CALL P2K_MOVE(XPOS,YPOS,0.)
CTSH	  ENCODE(4,631,LINE) IANG
CTSH++
	  WRITE(LINE,631) IANG
CTSH--
          CALL P2K_STRING(LINE,4,0.)
630	CONTINUE
631	FORMAT(I4)
C
C  PLOT OBS PHASE POINTS
C
        CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE*0.48)
	DO 500 J=1,NOBS
	  IF(PHIOBS(J).EQ.-999.) GO TO 500
	  XP=ZSTAR(J)*ZMAG - 0.05
	  YP=PHIOBS(J)*PMAG2 - 0.28*FONTSIZE*0.48
          CALL P2K_MOVE(XP,YP,0.)
	IF (IPSGN(J).GT.0)THEN
c	  CALL CSTRING(%REF('X'),1)
          CALL P2K_CSTRING('X',1,0.)
	ELSE
c	  CALL CSTRING(%REF('O'),1)
          CALL P2K_CSTRING('O',1,0.)
	ENDIF
      IF(PHIOBS(J).LT.0.0) THEN  ! REPEAT PLOT+360 IF PHASE IS .LT.0
	  	XP=ZSTAR(J)*ZMAG - 0.05
	  	YP=(PHIOBS(J)+360.0)*PMAG2 - 0.28*FONTSIZE*0.48
           CALL P2K_MOVE(XP,YP,0.)
		IF (IPSGN(J).GT.0)THEN
c		  CALL CSTRING(%REF('X'),1)
             CALL P2K_CSTRING('X',1,0.)
		ELSE
c		  CALL CSTRING(%REF('O'),1)
             CALL P2K_CSTRING('O',1,0.)
		ENDIF
      ENDIF
500	CONTINUE
        CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE*0.6)
C
C  GET READY FOR NEXT PLOTTED LINE.
C
99	CALL P2K_FONT('Courier'//CHAR(0),FONTSIZE)
	RETURN
C
100	CALL P2K_MOVE(10.0,20.0,0.)
CTSH	ENCODE(29,104,LINE) IHIN,IKIN
CTSH++
	WRITE(LINE,104) IHIN,IKIN
CTSH--
104	FORMAT('TOO FEW SPOTS ON LINE (',I2,',',I2,')')
      	CALL P2K_STRING(LINE,29,0.)
C
	RETURN
	END
C******************************************************************************
      SUBROUTINE TILTP(IN,IHIN,IKIN,IQIN,AIN,PTEMP,AMP,JREFL,JH,JK,
     1 ZSTAR,JHC,JKC,JLC,JSC,IFCC,IPHC,IBEGIN,IFINISH,TAXA,ABANG,TANGL,
     2 ASTAR,BSTAR,IFINSH,A1,A2,A3,A4,A5,IGO,ISPEC,C,
     3 REVHK,SGNXCH,ROT180,IQMAX,LREV)
C
      PARAMETER (MAXINDEX=40)
      PARAMETER (NSLOTS=32)
      INTEGER IH,IK,IHIN(1),IKIN(1),IQIN(1)
      INTEGER*2 JH(1),JK(1),JHC(1),JKC(1),JLC(1),JSC(1),IFCC(1),IPHC(1)
      INTEGER*2 IBEGIN(-MAXINDEX:MAXINDEX,-MAXINDEX:MAXINDEX),
     .	IFINISH(-MAXINDEX:MAXINDEX,-MAXINDEX:MAXINDEX)
      REAL AIN(1),PTEMP(1),AMP(1),ZSTAR(1)
      REAL*8 A(2,2),B(2),W(20),E
C              THESE BELOW ARE JUST DUMMY VARIABLES FOR ASYM.
      INTEGER*2 A1(8),A2(8),A3(8),A4(8),A5(8),IGO(8),ISPEC(5)
      INTEGER*2 IP1,IP2
      LOGICAL SPEC,LREV,IOK
      DIMENSION ASIZ(NSLOTS),FREFSIZ(NSLOTS),PHSRES(NSLOTS),
     .	NPHSRES(NSLOTS),AVIQ(NSLOTS)
      DATA ISLOTSIZ/50/
      DATA DRAD,RDEG/0.0174532,57.295779/
      WSTAR=0.01
      IPTEST=0
      TAXB=TAXA+ABANG
      WRITE(6,8051)TAXA,TAXB,ABANG
8051  FORMAT(' ENTERING TILTAXIS REFINEMENT, TAXA,TAXB,ABANG=',3F9.2)
      IF(TANGL.EQ.0.0) TANGL=0.05    ! derivative wrt TAXA infinite if TANGL=0.0
C
      FSHIFT=0.5
      IEND=0
      NCYCL=12
      DO 8300 ICYCL=1,NCYCL
      DO 8050 I=1,2
      B(I)=0.
      DO 8050 J=1,2
8050  A(I,J)=0.
      TAXB=TAXA+ABANG
C      WRITE(6,8051)TAXA,TAXB,ABANG
C
      ZH=ASTAR*TAN(TANGL*DRAD)*SIN(TAXA*DRAD)
      ZK=BSTAR*TAN(TANGL*DRAD)*SIN(TAXB*DRAD)
      DZTHEH=ASTAR*SIN(TAXA*DRAD)/(COS(TANGL*DRAD))**2
      DZTHEK=BSTAR*SIN(TAXB*DRAD)/(COS(TANGL*DRAD))**2
      DZPHIH=ASTAR*TAN(TANGL*DRAD)*COS(TAXA*DRAD)
      DZPHIK=BSTAR*TAN(TANGL*DRAD)*COS(TAXB*DRAD)
C
      RMSRESID=0.
      PNUMER=0.
      NP=0
      NOTUSED=0
      NOTNEAR=0
      NOTFOUND=0
      DO 8010 J=1,NSLOTS
      NPHSRES(J)=0 ! ZERO HIST0GRAM
      ASIZ(J)=0.0
      AVIQ(J)=0.0
      FREFSIZ(J)=0.0
8010  PHSRES(J)=0.0
C      WRITE(6,1112)
      DO 8100 I=1,IN
C  FIRST CALCULATE H,K,Z AND DZTHE,DZPHI IN CORRECT ASYMMETRIC UNIT.
        IF(IQIN(I).GT.IQMAX) THEN
      	  NOTUSED=NOTUSED+1
      	  GO TO 8100
        ENDIF
      IH=IHIN(I)
      IK=IKIN(I)
      Z=ZH*IH+ZK*IK
      IF(Z.EQ.0.0) Z=0.0000001   ! ALLOWS Z-CHANGE TEST AS FLAG BELOW.
      ZCOMP=Z
      DZTHE=DZTHEH*IH+DZTHEK*IK
      DZPHI=DZPHIH*IH+DZPHIK*IK
C  NOW REINDEX AND CHECK Z
      CALL FIDDLE(IH,IK,Z,REVHK,SGNXCH,ROT180)
      	    IF(Z.NE.ZCOMP) THEN
      	 DZTHE=-DZTHE
      	 DZPHI=-DZPHI
      	    ENDIF
      ZASYM=Z
C      WRITE(6,8700)IH,IK,Z,IP1,IP2,A1,A2,A3,A4,A5,IGO,ISPEC
8700  FORMAT(2I5,F10.5,2I5/7(8I5/))
      IP1=1
      IP2=0
C	WRITE(6,18100)IHIN(I),IKIN(I),IH,IK,ZASYM
      CALL ASYM(IH,IK,ZASYM,IP1,IP2,SPEC,IPTEST,WSTAR,
     1 A1,A2,A3,A4,A5,IGO,ISPEC,LREV)
C	WRITE(6,18100)IHIN(I),IKIN(I),IH,IK,ZASYM
C
C  HERE FOR GETCRVAL SUBROUTINE_CALL !----------------------
      CALL GETCRVAL(I,IHIN,IKIN,IH,IK,ZASYM,
     .	  JLC,IFCC,IPHC,IBEGIN,IFINISH,ISPEC,
     .	  IOK,C,FREF,PREF,DPDZCU)
      	 IF(.NOT.IOK) THEN
      	   NOTFOUND=NOTFOUND+1
C	WRITE(6,18100)IHIN(I),IKIN(I),IH,IK,ZASYM
C18100	FORMAT(4I5,F10.5)
      	   GO TO 8100
      	 ENDIF
      	PREF=PREF*IP1-IP2 ! P=P*IP1-IP2 TRANSFORMS FROM CURVE TO INPUT.
        DPDZ = DPDZCU*IP1
      	IF(Z.NE.ZASYM) DPDZ=-DPDZ
C  ABOVE TWO LINES CORRECT THE PHASE GRADIENT IF Z OR PHASE IS CHANGED IN ASYM.
C  TRANSFORMATION LATER FROM INPUT TO CURVE ASYMMETRIC UNIT IS P=P*IP1+IP2.
      	 NBEGIN=IBEGIN(IH,IK)
      	 IZLESS=INT(ZASYM*C+100)-100
      	 IZLESS=NBEGIN+(IZLESS-JLC(NBEGIN))
      	 IF(IZLESS.EQ.0) THEN
c      			write(*,*)'Warning !!!!! IZLESS=0 for IH,IK',IH,IK
      	  IZLESS=1
      	 ENDIF
     		IZMORE=IZLESS+1
         ZLESS = JLC(IZLESS)/C
C      	WRITE(6,1111)IHIN(I),IKIN(I),Z,AIN(I),PTEMP(I),IH,IK,ZASYM,
C     .		FREF,PREF,IPHC(IZLESS),IPHC(IZMORE),
C     .		JHC(IZLESS),JKC(IZLESS),JLC(IZLESS),ZLESS
1111	FORMAT(2I5,F8.4,2F8.1,2I5,F8.4,F8.1,F8.1,5I6,F8.4)
1112	FORMAT(' NKIN NKIN ZSTARIN     AIN   PTEMP   IH',
     .'   IK   ZASYM    AREF    PREF    IPH-  IPH+   IH-   IK-   IL-',
     .'   ZLESS')
8230  CONTINUE
C
      WEIGHT=1.0
C  COULD BE CHANGED TO 1/SIGMA**2 OR AMPLITUDE WEIGHTS LATER.
      JIN=JREFL+I
      AA0=PREF-PTEMP(I)
C
C  CHECK THAT PHASE IS IN RANGE -180 TO 180 SO THAT MINIMISATION IS USEFUL.
8261	IF(AA0.LT.180.0) GO TO 8260
      	AA0=AA0-360.0
      	GO TO 8261
8260	IF(AA0.GT.-180.0) GO TO 8262
      	AA0=AA0+360.0
      	GO TO 8260
8262	CONTINUE
C		FOR RESOLUTION-DEPENDENT HISTOGRAM OF PHASE RESIDUALS.
C  see above test for IZLESS as part of above diagnostic section
      	 ISLOT=1+(JSC(IZLESS)-1)/ISLOTSIZ
      	 IF(ISLOT.LT.1.OR.ISLOT.GE.NSLOTS) STOP 'ISLOT problem'
      	 ASIZ(ISLOT)=ASIZ(ISLOT)+AIN(I)
      	 AVIQ(ISLOT)=AVIQ(ISLOT)+IQIN(I)
      	 FREFSIZ(ISLOT)=FREFSIZ(ISLOT)+FREF
      	 PHSRES(ISLOT)=PHSRES(ISLOT)+ABS(AA0)
      	 NPHSRES(ISLOT)=NPHSRES(ISLOT)+1
      	IF(ABS(AA0).GT.90.0) THEN ! USE ONLY IF NEAR ENOUGH (90 DEG).
      	 NOTNEAR=NOTNEAR+1
      	 GO TO 8100
      	ENDIF
C
      AA1=DPDZ*DZTHE
      AA2=DPDZ*DZPHI
      A(1,1)=A(1,1)+WEIGHT*AA1*AA1
      A(1,2)=A(1,2)+WEIGHT*AA1*AA2
      A(2,1)=A(2,1)+WEIGHT*AA2*AA1
      A(2,2)=A(2,2)+WEIGHT*AA2*AA2
      B(1)  =B(1)  -WEIGHT*AA0*AA1
      B(2)  =B(2)  -WEIGHT*AA0*AA2
8270  IF(AA0.LT.0.0) AA0=-AA0
      PNUMER  = PNUMER  +AA0
      RMSRESID=RMSRESID +AA0**2
      NP = NP+1
C      WRITE(6,8800)IH,IK,Z,PREF,PTEMP(I),AA0,AA1,AA2,DPDZ
8800  FORMAT(' H,K,Z,PC,PO,A0,A1,A2,DPDZ',
     .	2I5,F8.5,2F8.1,F10.1,2F12.5,F12.1)
8100  CONTINUE
      IF(IEND.EQ.1)RETURN
      IA=2
      N=2
      E=-1.0
      CALL MA21AD(A,IA,N,B,W,E)
      IF(E.EQ.0.0) GO TO 8150
      WRITE(6,8101)E
8101  FORMAT(' MA21AD FAILED',F10.5)
      STOP
8150  THETA=FSHIFT*B(1)/DRAD
      PHI=FSHIFT*B(2)/DRAD
      IF(ABS(PHI).GT.10.0) WRITE(6,8151)PHI,THETA
      IF(ABS(THETA).GT.10.0) WRITE(6,8151)PHI,THETA
8151  FORMAT(' SHIFTS CALCULATED TO BE TOO LARGE',2F12.2)
      IF(ABS(THETA).GT.10.0) THETA=SIGN(10.0,THETA)
      IF(ABS(PHI).GT.10.0) PHI=SIGN(10.0,PHI)
      PHRESID=PNUMER/NP
      RMSRESID=SQRT(RMSRESID/NP)
      TAXA=TAXA+PHI
      TANGL=TANGL+THETA
      WRITE(6,8152)ICYCL,TAXA,TANGL,PHI,THETA,NP,NOTFOUND,
     .	 NOTUSED,NOTNEAR,PHRESID,RMSRESID
8152  FORMAT(' CYC=',I2,' NEW TAXA,TANGL=',2F8.3,
     1 ' SHFTS=',2F8.3,
     2 ' FOR',I4,'(EXCL',3I4,')SPOTS, RESID=',F7.3,' RMSRESID =',F7.3)
	WRITE(6,18152)NOTFOUND,NOTUSED,NOTNEAR
18152	FORMAT(' SPOTS EXCLUDED FOR; NOTFOUND=',I4,'; NOTUSED(IQ)=',I4/
     .'  NOTNEAR(>90.0)=',I4/)
      IF((ABS(THETA).LT.0.1).AND.(ABS(PHI).LT.0.1)) IEND=1
      IF((ICYCL.EQ.1).AND.(IEND.EQ.1)) THEN
      	IFINSH=1
C	PRINT OUT RESOLUTION-DEPENDENT RESIDUALS AT END OF REFINEMENT.
      	WRITE(6,8292)IQMAX
8292	FORMAT(//2X,10('*'),' PHASE RESID AS FUNCT OF RESOL',
     .	' ********** FOR ALL SPOTS WITH IQ .LE.'I2/5X,
     .	'  RANGE    DMIN      DMAX   MEANFCURV    MEANA',
     .	'   RESIDUAL  NSPOTS  AVIQ'/)
      	NALL=0
      	FALL=0.0
      	AALL=0.0
      	PHSALL=0.
      	DO 8290 J=1,NSLOTS
      	IF(NPHSRES(J).EQ.0) GO TO 8290
      	FALL=FALL+FREFSIZ(J)
      	AALL=AALL+ASIZ(J)
      	AVIQALL=AVIQALL+AVIQ(J)
      	PHSALL=PHSALL+PHSRES(J)
      	NALL=NALL+NPHSRES(J)
      	PHSRES(J)=PHSRES(J)/NPHSRES(J)
      	ASIZ(J)=ASIZ(J)/NPHSRES(J)
      	AVIQ(J)=AVIQ(J)/NPHSRES(J)
      	FREFSIZ(J)=FREFSIZ(J)/NPHSRES(J)
      	DMIN=SQRT(10000.0/((J-1)*ISLOTSIZ + 1))
      	DMAX=SQRT(10000.0/(J*ISLOTSIZ))
       WRITE(6,8291)J,DMIN,DMAX,FREFSIZ(J),ASIZ(J),PHSRES(J),
     .	 NPHSRES(J),AVIQ(J)
8291	FORMAT(5X,I6,4F10.3,F10.2,I7,F8.2)
8290	CONTINUE
8293	FORMAT(/4X,'OVERALL',20X,2F10.3,F10.2,I7,F8.2)
      	PHSALL=PHSALL/NALL
      	FALL=FALL/NALL
      	AALL=AALL/NALL
      	AVIQALL=AVIQALL/NALL
      	WRITE(6,8293)FALL,AALL,PHSALL,NALL,AVIQALL
      ENDIF
8300  CONTINUE
      RETURN
      END
C******************************************************************************
      SUBROUTINE GETCRVAL(ISPOT,IHIN,IKIN,IH,IK,ZASYM,
     .	JLC,IFCC,IPHC,IBEGIN,IFINISH,ISPEC,IOK,C,FREF,PREF,DPDZCU)
      	LOGICAL IOK
      PARAMETER (MAXINDEX=40)
      INTEGER IH,IK,IHIN(1),IKIN(1)
      INTEGER*2 JLC(1),IFCC(1),IPHC(1)
      INTEGER*2 IBEGIN(-MAXINDEX:MAXINDEX,-MAXINDEX:MAXINDEX),
     .	IFINISH(-MAXINDEX:MAXINDEX,-MAXINDEX:MAXINDEX)
      REAL*8 A(2,2),B(2),W(20),E
C              THESE BELOW ARE JUST DUMMY VARIABLES FOR ASYM.
      INTEGER*2 A1(8),A2(8),A3(8),A4(8),A5(8),IGO(8),ISPEC(5)
      INTEGER*2 IP1,IP2
      DATA DRAD,RDEG,PI/0.0174532,57.295779,3.14159/
      DATA BTEMP/80.0/
      	IOK=.TRUE.
      	NBEGIN=IBEGIN(IH,IK)
      	NFINISH=IFINISH(IH,IK)
      	IF((NBEGIN.NE.-999).AND.(NFINISH.NE.-999)) GO TO 70
      	 IOK=.FALSE.
C      		WRITE(6,1107)IH,IK,IHIN(ISPOT),IKIN(ISPOT)
1107		FORMAT(' LATTICE LINE NOT FOUND',2I5,'   SPOT',2I5)
      	 RETURN
70	ZBEGIN=JLC(NBEGIN)/C
      	ZFINISH=JLC(NFINISH)/C
      	ZALLOW = 1.0/(C*2.0) ! Allow calculation of point from curve provided
C				! that point and available curve data are close.
      IF((ZASYM.GE.ZBEGIN-ZALLOW).AND.(ZASYM.LE.ZFINISH+ZALLOW))GO TO 80
      	 IOK=.FALSE.
C      		WRITE(6,1108)IH,IK,IHIN(ISPOT),IKIN(ISPOT),ZASYM,
C     .		JLC(NBEGIN),JLC(NFINISH)
1108	FORMAT(' ZSTAR OUTSIDE RANGE ON LINE',2I5,'   SPOT',2I5,
     .	'        ZSTAR=',F8.4,' RANGE=',2I5)
      	 RETURN
80	CONTINUE
C********************BELOW IS CALCULATION OF PHASE AT EXACT VALUE OF ZSTAR.
C                    IT IS BASED ON THE SUM OF DAMPED SINC FUNCTIONS, WITH
C                    DAMPING SET TO BTEMP=80, AND A SINC FUNCTION WHICH FALLS
C                    TO ZERO AT TWO REFLECTIONS AWAY FROM THE POINT BEING
C                    CALCULATED. THUS THE CALCULATION GIVES DOUBLE THE VALUE
C                    OF F WHICH WOULD BE OBTAINED BY SIMPLE INTERPOLATION.
C                    AFTER DIVIDING THE RESULT BY TWO,THE OUTPUT COLUMN
C                    FREF IS THEREFORE DIRECTLY COMPARABLE WITH THE INPUT
C                    AMPLITUDES.  (see below).
      	CPART=0.0
      	SPART=0.0
      	  DZ=0.0004 !  SET DZ FOR GRADIENT CALC HERE.
      	  CPARTDZ=0.0
      	  SPARTDZ=0.0
      	DO 85 I=NBEGIN,NFINISH    ! Summation over given lattice line data.
      	 ZI=JLC(I)/C
      	 ZDIFF=ZASYM-ZI
      	 ZDIFFDZ=ZASYM+DZ-ZI
C  Next section is summation over lattice line for all space groups.
      	 IF(ZDIFF.NE.0) GO TO 81
      	  SINCDAMP=1.0
      	 GO TO 82
81         ARGEXP=-0.25*BTEMP*ZDIFF**2
      	   ARGSINC=0.5*PI*ZDIFF*C
      	   SINCF=SIN(ARGSINC)/ARGSINC
      	   SINCDAMP=SINCF*EXP(ARGEXP)
82		CONTINUE
      	 IF(ZDIFFDZ.NE.0) GO TO 83
      	  SINCDMPDZ=1.0
      	 GO TO 84
83         ARGEXP=-0.25*BTEMP*ZDIFFDZ**2
      	   ARGSINC=0.5*PI*ZDIFFDZ*C
      	   SINCF=SIN(ARGSINC)/ARGSINC
      	   SINCDMPDZ=SINCF*EXP(ARGEXP)
84		CONTINUE
      	 PHS=IPHC(I)*DRAD
      	 CPART=CPART+SINCDAMP*COS(PHS)*IFCC(I)
      	 SPART=SPART+SINCDAMP*SIN(PHS)*IFCC(I)
      	 CPARTDZ=CPARTDZ+SINCDMPDZ*COS(PHS)*IFCC(I)
      	 SPARTDZ=SPARTDZ+SINCDMPDZ*SIN(PHS)*IFCC(I)
C  The following section is included for lattice lines in space groups
C    where only the positive half of the lattice line is stored.
        IF(ISPEC(3).EQ.1.AND.JLC(I).NE.0) THEN
      	 ZDIFFMINUS=ZASYM+ZI
      	 ZDIFFMINUSDZ=ZASYM+ZI+DZ
     		 ARGEXP=-0.25*BTEMP*ZDIFFMINUS**2
      	  ARGSINC=0.5*PI*ZDIFFMINUS*C
      	  SINCF=SIN(ARGSINC)/ARGSINC
      	  SINCDAMP=SINCF*EXP(ARGEXP)
     		 ARGEXP=-0.25*BTEMP*ZDIFFMINUSDZ**2
      	  ARGSINC=0.5*PI*ZDIFFMINUSDZ*C
      	  SINCF=SIN(ARGSINC)/ARGSINC
      	  SINCDMPDZ=SINCF*EXP(ARGEXP)
      	 PHS= -IPHC(I)*DRAD ! Phase(hkl) = -Phase(hk-l)
      	 CPART=CPART+SINCDAMP*COS(PHS)*IFCC(I)
      	 SPART=SPART+SINCDAMP*SIN(PHS)*IFCC(I)
      	 CPARTDZ=CPARTDZ+SINCDMPDZ*COS(PHS)*IFCC(I)
      	 SPARTDZ=SPARTDZ+SINCDMPDZ*SIN(PHS)*IFCC(I)
      	ENDIF
85	CONTINUE
      FREF=0.5*SQRT(SPART**2+CPART**2)  ! Here for divide by two
C						! referred to above.
      PREF=RDEG*ATAN2(SPART,CPART)
      FREFDZ=0.5*SQRT(SPARTDZ**2+CPARTDZ**2)
      PREFDZ=RDEG*ATAN2(SPARTDZ,CPARTDZ)
      	PDIFF=PREFDZ-PREF ! MAX 8 DEG IN 0.0004 DZ == 180 DEG IN 0.01 DZ.
      	IF(ABS(PDIFF).GT.180.0) PDIFF=PDIFF-SIGN(360.0,PDIFF)
      	IF(ABS(PDIFF).GT.8.0) PDIFF=SIGN(8.0,PDIFF)
      DPDZCU = PDIFF/DZ
C      WRITE(6,86)IH,IK,ZASYM,FREF,FREFDZ,PREF,PREFDZ,DPDZCU
86    FORMAT(' H,K,Z,F,F+DZ,P,P+DZ,DPDZ',2I5,F8.4,2F10.2,2F10.3,F15.0)
      RETURN
      END
C******************************************************************************
C  FIDDLING WITH THE INDEXING TO GET CORRECT MATCH TO INDEXING CONVENTION
C  USEFUL IN A NUMBER OF SPACE GROUPS -- SEE WRITE-UP AT TOP OF PROGRAM.
      SUBROUTINE FIDDLE(IH,IK,Z,REVHK,SGNXCH,ROT180)
      IF(REVHK.EQ.0.0) GO TO 225
      I=IH
      IH=IK
      IK=I
      Z=-Z
225   CONTINUE
      IF(SGNXCH.EQ.0.0) GO TO 230
      IK=-IK
      Z=-Z
  230 IF(ROT180.EQ.0) GO TO 231
      IH=-IH
      IK=-IK
231   CONTINUE
      RETURN
      END
C******************************************************************************
C              TO APPLY ORIGIN AND BEAMTILT PHASE-SHIFT.
      FUNCTION PHSHFT(IH,IK,OX,OY,TX,TY,BEAMSHFT,B)
      DIMENSION BEAMSHFT(4)
      ASTAR=BEAMSHFT(2) ! attempt to not make it p3 specific.
      BSTAR=BEAMSHFT(3) !    "      "
      PHSHFT=IH*OX + IK*OY + B*(IH*TX*ASTAR+IK*TY*BSTAR)
      RETURN
      END
C******************************************************************************
C   PHASE ORIGIN AND BEAM TILT REFINEMENT TOGETHER BY R-FACTOR MINIMISATION.
C   THE RECIPROCAL SPACE DISTANCE ACTUALLY MINIMISED IS
C       L = SUM OF 2 * SIN(ABS(PHASEDIFF/2))
C	New version BEAMTILTA -- 3.3.89 used Harwell subroutine_VA04A by
C				by M.J.D.Powell to minimise above value of L
C
      SUBROUTINE BEAMTILTA
      PARAMETER  (MAXRFL=2000)
      REAL*4 PARAMS(4),E(4)
      COMMON WORK(28),NREF,IH(MAXRFL),IK(MAXRFL),IQ(MAXRFL),
     .	PHSI(MAXRFL),PHSC(MAXRFL),WGT(MAXRFL),OXNEW,OYNEW,TX,TY,
     .	BEAMSHFT(4),BSH(MAXRFL),IQMAX,NC,
     .  FUNCMIN,RESTOT,NTOT
      DATA DRAD/0.0174533/
      DATA E/0.02,0.02,0.001,0.001/,ESCALE/200.0/
      DATA IPRINT/0/,ICONV/1/,MAXIT/100/
      	 PARAMS(1)=OXNEW
      	 PARAMS(2)=OYNEW
      	 PARAMS(3)=TX
      	 PARAMS(4)=TY
      	 ASTAR=BEAMSHFT(2)
      ITER=0
      	WRITE(6,1010)
1010	FORMAT(//' ******* BEAM TILTA REFINEMENT BEGINNING *********'/
     .	' NITER      OX        OY        TX        TY   ',
     .	'      FUNCMIN   RESTOT  NTOT ')
      	WRITE(6,1011)ITER,(PARAMS(J),J=1,4)
C
      NPARAMS=4
      CALL VA04A(WORK,PARAMS,E,NPARAMS,F,
     .	 ESCALE,IPRINT,ICONV,MAXIT,ITER)
C
      	   WRITE(6,1011)ITER,(PARAMS(I),I=1,4),FUNCMIN,RESTOT,NTOT
1011	FORMAT(I6,2F10.2,2F10.3,F12.2,F11.2,I6)
332     BEDGE=225.0*ASTAR**2*BEAMSHFT(1) !  SPECIFIC FOR P3, BUT USED ONLY FOR
C		!  COSMETIC OUTPUT --  I.E.NOT USED IN REAL CALCULATIONS.
      	PS1=ABS(PHSHFT(15,0,0.,0.,PARAMS(3),PARAMS(4),BEAMSHFT,BEDGE))
      	PS2=ABS(PHSHFT(0,15,0.,0.,PARAMS(3),PARAMS(4),BEAMSHFT,BEDGE))
      	PS3=ABS(PHSHFT(-15,15,0.,0.,PARAMS(3),PARAMS(4),
     .	    BEAMSHFT,BEDGE))
      	PMAX15=AMAX1(PS1,PS2,PS3)
      	WRITE(6,1012)PMAX15
1012	FORMAT(' THIS AMOUNT OF BEAMTILT CAUSES THE MAX CORRECTION OF',
     .	' PHASE TO A REFLECTION'/
     .  ' AT RADIUS OF (15,0) OF',F10.3,' DEGREES'/
     .	' (THIS CALCULATION IS NOT PRECISE EXCEPT IN SPACE GROUP P3)'//)
      OXNEW=PARAMS(1)
      OYNEW=PARAMS(2)
      TX=PARAMS(3)
      TY=PARAMS(4)
      RETURN
      END
C******************************************************************************
      SUBROUTINE CALCFX(N,PARAMS,F)
      PARAMETER  (MAXRFL=2000)
      REAL*4 E(4),B(4)
      REAL*4 PARAMS(4)
      COMMON WORK(28),NREF,IH(MAXRFL),IK(MAXRFL),IQ(MAXRFL),
     .	PHSI(MAXRFL),PHSC(MAXRFL),WGT(MAXRFL),OXNEW,OYNEW,TX,TY,
     .	BEAMSHFT(4),BSH(MAXRFL),IQMAX,NC,
     .  FUNCMIN,RESTOT,NTOT
      DATA DRAD,RDEG/0.0174532,57.295779/
        NTOT=0
      	RESTOT=0.
C      	NCOMP=0
C      	NFAR=0
C      	RESID=0.0
      	FUNCMIN=0.0
      	WTOTAL=0.0
      	DO 340 M=1,NREF
      	IF (WGT(M).EQ.0.0) GO TO 340
      	IF (IQ(M).GT.IQMAX) GO TO 340
      	PM=PHSI(M)+PHSHFT(IH(M),IK(M),PARAMS(1),PARAMS(2),
     .	 PARAMS(3),PARAMS(4),BEAMSHFT,BSH(M))
      	PN=PHSC(M)
      	PDIFF=AMOD((PM-PN),360.0)
      	IF(ABS(PDIFF).GT.180.0) PDIFF=PDIFF-SIGN(360.0,PDIFF)
      	SINPD2=ABS(PDIFF*DRAD/2.0)
      	SINPD2=SIN(SINPD2)
	NTOT=NTOT+1
        RESTOT=RESTOT+ABS(PDIFF)
      	WTOTAL=WTOTAL+WGT(M)
      	FUNCMIN=FUNCMIN+2.0*SINPD2*WGT(M)
340	CONTINUE
      	RESTOT=RESTOT/NTOT
      	FUNCMIN=FUNCMIN*57.295779/WTOTAL
        F=FUNCMIN
C      	   WRITE(6,1011)NC,(PARAMS(I),I=1,4),(B(I),I=1,4),RESID,
C     .			FUNCMIN,NCOMP,NFAR
1011	FORMAT(I5,2F10.2,2F10.3,F10.2,F7.2,2F7.3,2F10.2,I10,I6)
      RETURN
      END
***************************************************************************
      SUBROUTINE VA04A(W,X,E,N,F,ESCALE,IPRINT,ICON,MAXIT,ITERC)
C  STANDARD FORTRAN 66 (A VERIFIED PFORT SUBROUTINE)
C      COMMON W
      DIMENSION W(1)
      DIMENSION X(1),E(1)
      DDMAG=0.1*ESCALE
      SCER=0.05/ESCALE
      JJ=N*N+N
      JJJ=JJ+N
      K=N+1
      NFCC=1
      IND=1
      INN=1
      DO 1 I=1,N
      DO 2 J=1,N
      W(K)=0.
      IF(I-J)4,3,4
    3 W(K)=ABS(E(I))
      W(I)=ESCALE
    4 K=K+1
    2 CONTINUE
    1 CONTINUE
      ITERC=1
      ISGRAD=2
      CALL CALCFX(N,X,F)
      FKEEP=ABS(F)+ABS(F)
    5 ITONE=1
      FP=F
      SUM=0.
      IXP=JJ
      DO 6 I=1,N
      IXP=IXP+1
      W(IXP)=X(I)
    6 CONTINUE
      IDIRN=N+1
      ILINE=1
    7 DMAX=W(ILINE)
      DACC=DMAX*SCER
      DMAG=AMIN1(DDMAG,0.1*DMAX)
      DMAG=AMAX1(DMAG,20.*DACC)
      DDMAX=10.*DMAG
      GO TO (70,70,71),ITONE
   70 DL=0.
      D=DMAG
      FPREV=F
      IS=5
      FA=F
      DA=DL
    8 DD=D-DL
      DL=D
   58 K=IDIRN
      DO 9 I=1,N
      X(I)=X(I)+DD*W(K)
      K=K+1
    9 CONTINUE
      CALL CALCFX(N,X,F)
C
      NFCC=NFCC+1
      GO TO (10,11,12,13,14,96),IS
   14 IF(F-FA)15,16,24
   16 IF (ABS(D)-DMAX) 17,17,18
   17 D=D+D
      GO TO 8
   18 WRITE(6,19)
   19 FORMAT(5X,44HVA04A MAXIMUM CHANGE DOES NOT ALTER FUNCTION)
      GO TO 20
   15 FB=F
      DB=D
      GO TO 21
   24 FB=FA
      DB=DA
      FA=F
      DA=D
   21 GO TO (83,23),ISGRAD
   23 D=DB+DB-DA
      IS=1
      GO TO 8
   83 D=0.5*(DA+DB-(FA-FB)/(DA-DB))
      IS=4
      IF((DA-D)*(D-DB))25,8,8
   25 IS=1
      IF(ABS(D-DB)-DDMAX)8,8,26
   26 D=DB+SIGN(DDMAX,DB-DA)
      IS=1
      DDMAX=DDMAX+DDMAX
      DDMAG=DDMAG+DDMAG
      IF(DDMAX-DMAX)8,8,27
   27 DDMAX=DMAX
      GO TO 8
   13 IF(F-FA)28,23,23
   28 FC=FB
      DC=DB
   29 FB=F
      DB=D
      GO TO 30
   12 IF(F-FB)28,28,31
   31 FA=F
      DA=D
      GO TO 30
   11 IF(F-FB)32,10,10
   32 FA=FB
      DA=DB
      GO TO 29
   71 DL=1.
      DDMAX=5.
      FA=FP
      DA=-1.
      FB=FHOLD
      DB=0.
      D=1.
   10 FC=F
      DC=D
   30 A=(DB-DC)*(FA-FC)
      B=(DC-DA)*(FB-FC)
      IF((A+B)*(DA-DC))33,33,34
   33 FA=FB
      DA=DB
      FB=FC
      DB=DC
      GO TO 26
   34 D=0.5*(A*(DB+DC)+B*(DA+DC))/(A+B)
      DI=DB
      FI=FB
      IF(FB-FC)44,44,43
   43 DI=DC
      FI=FC
   44 GO TO (86,86,85),ITONE
   85 ITONE=2
      GO TO 45
   86 IF (ABS(D-DI)-DACC) 41,41,93
   93 IF (ABS(D-DI)-0.03*ABS(D)) 41,41,45
   45 IF ((DA-DC)*(DC-D)) 47,46,46
   46 FA=FB
      DA=DB
      FB=FC
      DB=DC
      GO TO 25
   47 IS=2
      IF ((DB-D)*(D-DC)) 48,8,8
   48 IS=3
      GO TO 8
   41 F=FI
      D=DI-DL
      DD=SQRT((DC-DB)*(DC-DA)*(DA-DB)/(A+B))
      DO 49 I=1,N
      X(I)=X(I)+D*W(IDIRN)
      W(IDIRN)=DD*W(IDIRN)
      IDIRN=IDIRN+1
   49 CONTINUE
      W(ILINE)=W(ILINE)/DD
      ILINE=ILINE+1
      IF(IPRINT-1)51,50,51
   50 WRITE(6,52) ITERC,NFCC,F,(X(I),I=1,N)
   52 FORMAT (/1X,9HITERATION,I5,I15,16H FUNCTION VALUES,
     110X,3HF =,E21.14/(5E24.14))
      GO TO(51,53),IPRINT
   51 GO TO (55,38),ITONE
   55 IF (FPREV-F-SUM) 94,95,95
   95 SUM=FPREV-F
      JIL=ILINE
   94 IF (IDIRN-JJ) 7,7,84
   84 GO TO (92,72),IND
   92 FHOLD=F
      IS=6
      IXP=JJ
      DO 59 I=1,N
      IXP=IXP+1
      W(IXP)=X(I)-W(IXP)
   59 CONTINUE
      DD=1.
      GO TO 58
   96 GO TO (112,87),IND
  112 IF (FP-F) 37,37,91
   91 D=2.*(FP+F-2.*FHOLD)/(FP-F)**2
      IF (D*(FP-FHOLD-SUM)**2-SUM) 87,37,37
   87 J=JIL*N+1
      IF (J-JJ) 60,60,61
   60 DO 62 I=J,JJ
      K=I-N
      W(K)=W(I)
   62 CONTINUE
      DO 97 I=JIL,N
      W(I-1)=W(I)
   97 CONTINUE
   61 IDIRN=IDIRN-N
      ITONE=3
      K=IDIRN
      IXP=JJ
      AAA=0.
      DO 65 I=1,N
      IXP=IXP+1
      W(K)=W(IXP)
      IF (AAA-ABS(W(K)/E(I))) 66,67,67
   66 AAA=ABS(W(K)/E(I))
   67 K=K+1
   65 CONTINUE
      DDMAG=1.
      W(N)=ESCALE/AAA
      ILINE=N
      GO TO 7
   37 IXP=JJ
      AAA=0.
      F=FHOLD
      DO 99 I=1,N
      IXP=IXP+1
      X(I)=X(I)-W(IXP)
      IF (AAA*ABS(E(I))-ABS(W(IXP))) 98,99,99
   98 AAA=ABS(W(IXP)/E(I))
   99 CONTINUE
      GO TO 72
   38 AAA=AAA*(1.+DI)
      GO TO (72,106),IND
   72 IF (IPRINT-2) 53,50,50
   53 GO TO (109,88),IND
  109 IF (AAA-0.1) 89,89,76
   89 GO TO (20,116),ICON
  116 IND=2
      GO TO (100,101),INN
  100 INN=2
      K=JJJ
      DO 102 I=1,N
      K=K+1
      W(K)=X(I)
      X(I)=X(I)+10.*E(I)
  102 CONTINUE
      FKEEP=F
      CALL CALCFX (N,X,F)
      NFCC=NFCC+1
      DDMAG=0.
      GO TO 108
   76 IF (F-FP) 35,78,78
   78 WRITE(6,80)
   80 FORMAT (5X,37HVA04A ACCURACY LIMITED BY ERRORS IN F)
      GO TO 20
   88 IND=1
   35 DDMAG=0.4*SQRT(FP-F)
      ISGRAD=1
  108 ITERC=ITERC+1
      IF (ITERC-MAXIT) 5,5,81
   81 WRITE(6,82) MAXIT
   82 FORMAT(I5,30H ITERATIONS COMPLETED BY VA04A)
      IF (F-FKEEP) 20,20,110
  110 F=FKEEP
      DO 111 I=1,N
      JJJ=JJJ+1
      X(I)=W(JJJ)
  111 CONTINUE
      GO TO 20
  101 JIL=1
      FP=FKEEP
      IF (F-FKEEP) 105,78,104
  104 JIL=2
      FP=F
      F=FKEEP
  105 IXP=JJ
      DO 113 I=1,N
      IXP=IXP+1
      K=IXP+N
      GO TO (114,115),JIL
  114 W(IXP)=W(K)
      GO TO 113
  115 W(IXP)=X(I)
      X(I)=W(K)
  113 CONTINUE
      JIL=2
      GO TO 92
  106 IF (AAA-0.1) 20,20,107
20      RETURN
  107 INN=1
      GO TO 35
      END
