#!/bin/sh -xe
cd $(dirname ${0})

pv=3
pv=2

PYTHONPATH=../../..:../../../aux/${pv}.7
export PYTHONPATH
demo="python${pv} demo.py"

CCP4=/Applications/Xtal71/ccp4-7.1
export CCP4

rep=report
rm -fr ${rep}

doc=storred_doc
rm -f ${doc}

html=$(pwd)/${rep}/index.html

open_after() {
  sleep ${1}
  ${CCP4}/libexec/jsrview ${html} 2>/dev/null &
  open -g -a /Applications/SeaMonkey.app ${html}
}

open_after 0.5 &

p0=0.0 p1=0.0 ti=0.0 ti=1.0

${demo} -d ${doc} -p ${p0} -v -e Examples/molrep_mr2.log -c molrep
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/7_aimless.log -s
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/10_refmac5.log -t
sleep ${ti}
${demo} -d ${doc} -p ${p0} -v -e Examples/warpNtrace.log -k Examples/warpNtrace.inp -c arpwarp
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/buccaneerpipeline_stdout.txt -s
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/10_phaser_MR.log
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/refmac.log
sleep ${ti}
${demo} -d ${doc} -p ${p0} -v -e Examples/molrep_cofe.log -c molrep
#sleep ${ti}
#${demo} -d ${doc} -p ${p1} -v Examples/ccpem.log
sleep ${ti}
${demo} -d ${doc} -p ${p0} -v -e Examples/64_mr_mrf.log -c molrep
sleep ${ti}
${demo} -d ${doc} -p ${p0} -v -e Examples/65_mr_saptf_prf.log -c molrep
sleep ${ti}
${demo} -d ${doc} -p ${p0} -v -e Examples/66_mr_saptf_lrf.log -c molrep
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/10_refmac5.log -t -n
sleep ${ti}
${demo} -d ${doc} -p ${p1} -v -e Examples/7_aimless.log -s -n
sleep ${ti}
if test -f Examples/cofe_acorn.log; then
  ${demo} -d ${doc} -p ${p0} -v -e Examples/cofe_acorn.log -s
  sleep ${ti}
fi
skip() {
  ${demo} -d ${doc} -p ${p0} -v -e Examples/18.11.27_stdout.log
  sleep ${ti}
}
${demo} -d ${doc} -p ${p1} -v Examples/19.11.29_phaser_stdout.log
sleep ${ti}
${demo} /dev/null

sed -i~ 's/^TASK_STAMP.*/TASK_STAMP:::1536675447:::39238:::PASS;;;/' ${rep}/task.tsk
rm -f ${rep}/task.tsk~

rm -f ${doc}

