// File:js/build/three.custom.min.js

// https://github.com/arose/ngl/ LICENSE
/*
 MIT License <http://www.opensource.org/licenses/mit-license.php>

 Complexity: http://bigocheatsheet.com/ see Quicksort

 Example:
 points: [x, y, z, x, y, z, x, y, z, ...]
 eleSize: 3 //because of (x, y, z)
 orderElement: 0 //order according to x
 MIT License <http://www.opensource.org/licenses/mit-license.php>

 Requires typed array quicksort

 Example:
 points: [x, y, z, x, y, z, x, y, z, ...]
 metric: function(a, b){	return Math.pow(a[0] - b[0], 2) +  Math.pow(a[1] - b[1], 2) +  Math.pow(a[2] - b[2], 2); }  //Manhatten distance
 eleSize: 3 //because of (x, y, z)

 Further information (including mathematical properties)
 http://en.wikipedia.org/wiki/Binary_tree
 http://en.wikipedia.org/wiki/K-d_tree

 If you want to further minimize memory usage, remove Node.depth and replace in search algorithm with a traversal to root node (see comments at THREE.TypedArrayUtils.Kdtree.prototype.Node)
*/
var THREE={REVISION:"76"};"function"===typeof define&&define.amd?define("three",THREE):"undefined"!==typeof exports&&"undefined"!==typeof module&&(module.exports=THREE);void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52));void 0===Math.sign&&(Math.sign=function(a){return 0>a?-1:0<a?1:+a});void 0===Function.prototype.name&&void 0!==Object.defineProperty&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}});
void 0===Object.assign&&Object.defineProperty(Object,"assign",{writable:!0,configurable:!0,value:function(a){if(void 0===a||null===a)throw new TypeError("Cannot convert first argument to object");for(var b=Object(a),c=1,d=arguments.length;c!==d;++c){var e=arguments[c];if(void 0!==e&&null!==e)for(var e=Object(e),f=Object.keys(e),g=0,h=f.length;g!==h;++g){var k=f[g],l=Object.getOwnPropertyDescriptor(e,k);void 0!==l&&l.enumerable&&(b[k]=e[k])}}return b}});THREE.MOUSE={LEFT:0,MIDDLE:1,RIGHT:2};
THREE.CullFaceNone=0;THREE.CullFaceBack=1;THREE.CullFaceFront=2;THREE.CullFaceFrontBack=3;THREE.FrontFaceDirectionCW=0;THREE.FrontFaceDirectionCCW=1;THREE.BasicShadowMap=0;THREE.PCFShadowMap=1;THREE.PCFSoftShadowMap=2;THREE.FrontSide=0;THREE.BackSide=1;THREE.DoubleSide=2;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;
THREE.CustomBlending=5;THREE.AddEquation=100;THREE.SubtractEquation=101;THREE.ReverseSubtractEquation=102;THREE.MinEquation=103;THREE.MaxEquation=104;THREE.ZeroFactor=200;THREE.OneFactor=201;THREE.SrcColorFactor=202;THREE.OneMinusSrcColorFactor=203;THREE.SrcAlphaFactor=204;THREE.OneMinusSrcAlphaFactor=205;THREE.DstAlphaFactor=206;THREE.OneMinusDstAlphaFactor=207;THREE.DstColorFactor=208;THREE.OneMinusDstColorFactor=209;THREE.SrcAlphaSaturateFactor=210;THREE.NeverDepth=0;THREE.AlwaysDepth=1;
THREE.LessDepth=2;THREE.LessEqualDepth=3;THREE.EqualDepth=4;THREE.GreaterEqualDepth=5;THREE.GreaterDepth=6;THREE.NotEqualDepth=7;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.AddOperation=2;THREE.NoToneMapping=0;THREE.LinearToneMapping=1;THREE.ReinhardToneMapping=2;THREE.Uncharted2ToneMapping=3;THREE.CineonToneMapping=4;THREE.UVMapping=300;THREE.CubeReflectionMapping=301;THREE.CubeRefractionMapping=302;THREE.EquirectangularReflectionMapping=303;THREE.EquirectangularRefractionMapping=304;
THREE.SphericalReflectionMapping=305;THREE.CubeUVReflectionMapping=306;THREE.CubeUVRefractionMapping=307;THREE.RepeatWrapping=1E3;THREE.ClampToEdgeWrapping=1001;THREE.MirroredRepeatWrapping=1002;THREE.NearestFilter=1003;THREE.NearestMipMapNearestFilter=1004;THREE.NearestMipMapLinearFilter=1005;THREE.LinearFilter=1006;THREE.LinearMipMapNearestFilter=1007;THREE.LinearMipMapLinearFilter=1008;THREE.UnsignedByteType=1009;THREE.ByteType=1010;THREE.ShortType=1011;THREE.UnsignedShortType=1012;
THREE.IntType=1013;THREE.UnsignedIntType=1014;THREE.FloatType=1015;THREE.HalfFloatType=1025;THREE.UnsignedShort4444Type=1016;THREE.UnsignedShort5551Type=1017;THREE.UnsignedShort565Type=1018;THREE.AlphaFormat=1019;THREE.RGBFormat=1020;THREE.RGBAFormat=1021;THREE.LuminanceFormat=1022;THREE.LuminanceAlphaFormat=1023;THREE.RGBEFormat=THREE.RGBAFormat;THREE.DepthFormat=1026;THREE.RGB_S3TC_DXT1_Format=2001;THREE.RGBA_S3TC_DXT1_Format=2002;THREE.RGBA_S3TC_DXT3_Format=2003;THREE.RGBA_S3TC_DXT5_Format=2004;
THREE.RGB_PVRTC_4BPPV1_Format=2100;THREE.RGB_PVRTC_2BPPV1_Format=2101;THREE.RGBA_PVRTC_4BPPV1_Format=2102;THREE.RGBA_PVRTC_2BPPV1_Format=2103;THREE.RGB_ETC1_Format=2151;THREE.LoopOnce=2200;THREE.LoopRepeat=2201;THREE.LoopPingPong=2202;THREE.InterpolateDiscrete=2300;THREE.InterpolateLinear=2301;THREE.InterpolateSmooth=2302;THREE.ZeroCurvatureEnding=2400;THREE.ZeroSlopeEnding=2401;THREE.WrapAroundEnding=2402;THREE.TrianglesDrawMode=0;THREE.TriangleStripDrawMode=1;THREE.TriangleFanDrawMode=2;
THREE.LinearEncoding=3E3;THREE.sRGBEncoding=3001;THREE.GammaEncoding=3007;THREE.RGBEEncoding=3002;THREE.LogLuvEncoding=3003;THREE.RGBM7Encoding=3004;THREE.RGBM16Encoding=3005;THREE.RGBDEncoding=3006;THREE.BasicDepthPacking=3200;THREE.RGBADepthPacking=3201;THREE.Color=function(a){return 3===arguments.length?this.fromArray(arguments):this.set(a)};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,set:function(a){a instanceof THREE.Color?this.copy(a):"number"===typeof a?this.setHex(a):"string"===typeof a&&this.setStyle(a);return this},setScalar:function(a){this.b=this.g=this.r=a},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSL:function(){function a(a,c,d){0>d&&(d+=1);1<d&&--d;return d<1/6?a+6*(c-a)*d:
.5>d?c:d<2/3?a+6*(c-a)*(2/3-d):a}return function(b,c,d){b=THREE.Math.euclideanModulo(b,1);c=THREE.Math.clamp(c,0,1);d=THREE.Math.clamp(d,0,1);0===c?this.r=this.g=this.b=d:(c=.5>=d?d*(1+c):d+c-d*c,d=2*d-c,this.r=a(d,c,b+1/3),this.g=a(d,c,b),this.b=a(d,c,b-1/3));return this}}(),setStyle:function(a){function b(b){void 0!==b&&1>parseFloat(b)&&console.warn("THREE.Color: Alpha component of "+a+" will be ignored.")}var c;if(c=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(a)){var d=c[2];switch(c[1]){case "rgb":case "rgba":if(c=
/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(d))return this.r=Math.min(255,parseInt(c[1],10))/255,this.g=Math.min(255,parseInt(c[2],10))/255,this.b=Math.min(255,parseInt(c[3],10))/255,b(c[5]),this;if(c=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(d))return this.r=Math.min(100,parseInt(c[1],10))/100,this.g=Math.min(100,parseInt(c[2],10))/100,this.b=Math.min(100,parseInt(c[3],10))/100,b(c[5]),this;break;case "hsl":case "hsla":if(c=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(d)){var d=
parseFloat(c[1])/360,e=parseInt(c[2],10)/100,f=parseInt(c[3],10)/100;b(c[5]);return this.setHSL(d,e,f)}}}else if(c=/^\#([A-Fa-f0-9]+)$/.exec(a)){c=c[1];d=c.length;if(3===d)return this.r=parseInt(c.charAt(0)+c.charAt(0),16)/255,this.g=parseInt(c.charAt(1)+c.charAt(1),16)/255,this.b=parseInt(c.charAt(2)+c.charAt(2),16)/255,this;if(6===d)return this.r=parseInt(c.charAt(0)+c.charAt(1),16)/255,this.g=parseInt(c.charAt(2)+c.charAt(3),16)/255,this.b=parseInt(c.charAt(4)+c.charAt(5),16)/255,this}a&&0<a.length&&
(c=THREE.ColorKeywords[a],void 0!==c?this.setHex(c):console.warn("THREE.Color: Unknown color "+a));return this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a,b){void 0===b&&(b=2);this.r=Math.pow(a.r,b);this.g=Math.pow(a.g,b);this.b=Math.pow(a.b,b);return this},copyLinearToGamma:function(a,b){void 0===b&&(b=2);var c=0<b?1/b:1;this.r=Math.pow(a.r,c);this.g=Math.pow(a.g,c);this.b=Math.pow(a.b,
c);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);this.b=Math.sqrt(this.b);return this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(a){a=a||{h:0,s:0,l:0};var b=this.r,c=this.g,d=this.b,e=Math.max(b,c,d),f=Math.min(b,c,d),g,h=
(f+e)/2;if(f===e)f=g=0;else{var k=e-f,f=.5>=h?k/(e+f):k/(2-e-f);switch(e){case b:g=(c-d)/k+(c<d?6:0);break;case c:g=(d-b)/k+2;break;case d:g=(b-c)/k+4}g/=6}a.h=g;a.s=f;a.l=h;return a},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(a,b,c){var d=this.getHSL();d.h+=a;d.s+=b;d.l+=c;this.setHSL(d.h,d.s,d.l);return this},add:function(a){this.r+=a.r;this.g+=a.g;this.b+=a.b;return this},addColors:function(a,b){this.r=a.r+b.r;this.g=a.g+b.g;this.b=
a.b+b.b;return this},addScalar:function(a){this.r+=a;this.g+=a;this.b+=a;return this},multiply:function(a){this.r*=a.r;this.g*=a.g;this.b*=a.b;return this},multiplyScalar:function(a){this.r*=a;this.g*=a;this.b*=a;return this},lerp:function(a,b){this.r+=(a.r-this.r)*b;this.g+=(a.g-this.g)*b;this.b+=(a.b-this.b)*b;return this},equals:function(a){return a.r===this.r&&a.g===this.g&&a.b===this.b},fromArray:function(a,b){void 0===b&&(b=0);this.r=a[b];this.g=a[b+1];this.b=a[b+2];return this},toArray:function(a,
b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b]=this.r;a[b+1]=this.g;a[b+2]=this.b;return a}};
THREE.ColorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,
darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,
grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,
lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,
palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,
tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};THREE.Quaternion=function(a,b,c,d){this._x=a||0;this._y=b||0;this._z=c||0;this._w=void 0!==d?d:1};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,get x(){return this._x},set x(a){this._x=a;this.onChangeCallback()},get y(){return this._y},set y(a){this._y=a;this.onChangeCallback()},get z(){return this._z},set z(a){this._z=a;this.onChangeCallback()},get w(){return this._w},set w(a){this._w=a;this.onChangeCallback()},set:function(a,b,c,d){this._x=a;this._y=b;this._z=c;this._w=d;this.onChangeCallback();return this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},
copy:function(a){this._x=a.x;this._y=a.y;this._z=a.z;this._w=a.w;this.onChangeCallback();return this},setFromEuler:function(a,b){if(!1===a instanceof THREE.Euler)throw Error("THREE.Quaternion: .setFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var c=Math.cos(a._x/2),d=Math.cos(a._y/2),e=Math.cos(a._z/2),f=Math.sin(a._x/2),g=Math.sin(a._y/2),h=Math.sin(a._z/2),k=a.order;"XYZ"===k?(this._x=f*d*e+c*g*h,this._y=c*g*e-f*d*h,this._z=c*d*h+f*g*e,this._w=c*d*e-f*g*h):"YXZ"===
k?(this._x=f*d*e+c*g*h,this._y=c*g*e-f*d*h,this._z=c*d*h-f*g*e,this._w=c*d*e+f*g*h):"ZXY"===k?(this._x=f*d*e-c*g*h,this._y=c*g*e+f*d*h,this._z=c*d*h+f*g*e,this._w=c*d*e-f*g*h):"ZYX"===k?(this._x=f*d*e-c*g*h,this._y=c*g*e+f*d*h,this._z=c*d*h-f*g*e,this._w=c*d*e+f*g*h):"YZX"===k?(this._x=f*d*e+c*g*h,this._y=c*g*e+f*d*h,this._z=c*d*h-f*g*e,this._w=c*d*e-f*g*h):"XZY"===k&&(this._x=f*d*e-c*g*h,this._y=c*g*e-f*d*h,this._z=c*d*h+f*g*e,this._w=c*d*e+f*g*h);if(!1!==b)this.onChangeCallback();return this},setFromAxisAngle:function(a,
b){var c=b/2,d=Math.sin(c);this._x=a.x*d;this._y=a.y*d;this._z=a.z*d;this._w=Math.cos(c);this.onChangeCallback();return this},setFromRotationMatrix:function(a){var b=a.elements,c=b[0];a=b[4];var d=b[8],e=b[1],f=b[5],g=b[9],h=b[2],k=b[6],b=b[10],l=c+f+b;0<l?(c=.5/Math.sqrt(l+1),this._w=.25/c,this._x=(k-g)*c,this._y=(d-h)*c,this._z=(e-a)*c):c>f&&c>b?(c=2*Math.sqrt(1+c-f-b),this._w=(k-g)/c,this._x=.25*c,this._y=(a+e)/c,this._z=(d+h)/c):f>b?(c=2*Math.sqrt(1+f-c-b),this._w=(d-h)/c,this._x=(a+e)/c,this._y=
.25*c,this._z=(g+k)/c):(c=2*Math.sqrt(1+b-c-f),this._w=(e-a)/c,this._x=(d+h)/c,this._y=(g+k)/c,this._z=.25*c);this.onChangeCallback();return this},setFromUnitVectors:function(){var a,b;return function(c,d){void 0===a&&(a=new THREE.Vector3);b=c.dot(d)+1;1E-6>b?(b=0,Math.abs(c.x)>Math.abs(c.z)?a.set(-c.y,c.x,0):a.set(0,-c.z,c.y)):a.crossVectors(c,d);this._x=a.x;this._y=a.y;this._z=a.z;this._w=b;this.normalize();return this}}(),inverse:function(){this.conjugate().normalize();return this},conjugate:function(){this._x*=
-1;this._y*=-1;this._z*=-1;this.onChangeCallback();return this},dot:function(a){return this._x*a._x+this._y*a._y+this._z*a._z+this._w*a._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var a=this.length();0===a?(this._z=this._y=this._x=0,this._w=1):(a=1/a,this._x*=a,this._y*=a,this._z*=a,this._w*=a);this.onChangeCallback();return this},
multiply:function(a,b){return void 0!==b?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(a,b)):this.multiplyQuaternions(this,a)},multiplyQuaternions:function(a,b){var c=a._x,d=a._y,e=a._z,f=a._w,g=b._x,h=b._y,k=b._z,l=b._w;this._x=c*l+f*g+d*k-e*h;this._y=d*l+f*h+e*g-c*k;this._z=e*l+f*k+c*h-d*g;this._w=f*l-c*g-d*h-e*k;this.onChangeCallback();return this},slerp:function(a,b){if(0===b)return this;if(1===
b)return this.copy(a);var c=this._x,d=this._y,e=this._z,f=this._w,g=f*a._w+c*a._x+d*a._y+e*a._z;0>g?(this._w=-a._w,this._x=-a._x,this._y=-a._y,this._z=-a._z,g=-g):this.copy(a);if(1<=g)return this._w=f,this._x=c,this._y=d,this._z=e,this;var h=Math.sqrt(1-g*g);if(.001>Math.abs(h))return this._w=.5*(f+this._w),this._x=.5*(c+this._x),this._y=.5*(d+this._y),this._z=.5*(e+this._z),this;var k=Math.atan2(h,g),g=Math.sin((1-b)*k)/h,h=Math.sin(b*k)/h;this._w=f*g+this._w*h;this._x=c*g+this._x*h;this._y=d*g+
this._y*h;this._z=e*g+this._z*h;this.onChangeCallback();return this},equals:function(a){return a._x===this._x&&a._y===this._y&&a._z===this._z&&a._w===this._w},fromArray:function(a,b){void 0===b&&(b=0);this._x=a[b];this._y=a[b+1];this._z=a[b+2];this._w=a[b+3];this.onChangeCallback();return this},toArray:function(a,b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b]=this._x;a[b+1]=this._y;a[b+2]=this._z;a[b+3]=this._w;return a},onChange:function(a){this.onChangeCallback=a;return this},onChangeCallback:function(){}};
Object.assign(THREE.Quaternion,{slerp:function(a,b,c,d){return c.copy(a).slerp(b,d)},slerpFlat:function(a,b,c,d,e,f,g){var h=c[d+0],k=c[d+1],l=c[d+2];c=c[d+3];d=e[f+0];var n=e[f+1],p=e[f+2];e=e[f+3];if(c!==e||h!==d||k!==n||l!==p){f=1-g;var m=h*d+k*n+l*p+c*e,q=0<=m?1:-1,r=1-m*m;r>Number.EPSILON&&(r=Math.sqrt(r),m=Math.atan2(r,m*q),f=Math.sin(f*m)/r,g=Math.sin(g*m)/r);q*=g;h=h*f+d*q;k=k*f+n*q;l=l*f+p*q;c=c*f+e*q;f===1-g&&(g=1/Math.sqrt(h*h+k*k+l*l+c*c),h*=g,k*=g,l*=g,c*=g)}a[b]=h;a[b+1]=k;a[b+2]=l;
a[b+3]=c}});THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,get width(){return this.x},set width(a){this.x=a},get height(){return this.y},set height(a){this.y=a},set:function(a,b){this.x=a;this.y=b;return this},setScalar:function(a){this.y=this.x=a;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setComponent:function(a,b){switch(a){case 0:this.x=b;break;case 1:this.y=b;break;default:throw Error("index is out of range: "+a);}},getComponent:function(a){switch(a){case 0:return this.x;
case 1:return this.y;default:throw Error("index is out of range: "+a);}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(a){this.x=a.x;this.y=a.y;return this},add:function(a,b){if(void 0!==b)return console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(a,b);this.x+=a.x;this.y+=a.y;return this},addScalar:function(a){this.x+=a;this.y+=a;return this},addVectors:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},
addScaledVector:function(a,b){this.x+=a.x*b;this.y+=a.y*b;return this},sub:function(a,b){if(void 0!==b)return console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(a,b);this.x-=a.x;this.y-=a.y;return this},subScalar:function(a){this.x-=a;this.y-=a;return this},subVectors:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},multiply:function(a){this.x*=a.x;this.y*=a.y;return this},multiplyScalar:function(a){isFinite(a)?(this.x*=a,
this.y*=a):this.y=this.x=0;return this},divide:function(a){this.x/=a.x;this.y/=a.y;return this},divideScalar:function(a){return this.multiplyScalar(1/a)},min:function(a){this.x=Math.min(this.x,a.x);this.y=Math.min(this.y,a.y);return this},max:function(a){this.x=Math.max(this.x,a.x);this.y=Math.max(this.y,a.y);return this},clamp:function(a,b){this.x=Math.max(a.x,Math.min(b.x,this.x));this.y=Math.max(a.y,Math.min(b.y,this.y));return this},clampScalar:function(){var a,b;return function(c,d){void 0===
a&&(a=new THREE.Vector2,b=new THREE.Vector2);a.set(c,c);b.set(d,d);return this.clamp(a,b)}}(),clampLength:function(a,b){var c=this.length();this.multiplyScalar(Math.max(a,Math.min(b,c))/c);return this},floor:function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);return this},ceil:function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);return this},round:function(){this.x=Math.round(this.x);this.y=Math.round(this.y);return this},roundToZero:function(){this.x=0>this.x?Math.ceil(this.x):
Math.floor(this.x);this.y=0>this.y?Math.ceil(this.y):Math.floor(this.y);return this},negate:function(){this.x=-this.x;this.y=-this.y;return this},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length())},angle:function(){var a=Math.atan2(this.y,this.x);0>a&&(a+=
2*Math.PI);return a},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x;a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.multiplyScalar(a/this.length())},lerp:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;return this},lerpVectors:function(a,b,c){this.subVectors(b,a).multiplyScalar(c).add(a);return this},equals:function(a){return a.x===this.x&&a.y===this.y},fromArray:function(a,b){void 0===b&&(b=0);this.x=a[b];
this.y=a[b+1];return this},toArray:function(a,b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b]=this.x;a[b+1]=this.y;return a},fromAttribute:function(a,b,c){void 0===c&&(c=0);b=b*a.itemSize+c;this.x=a.array[b];this.y=a.array[b+1];return this},rotateAround:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=this.x-a.x,f=this.y-a.y;this.x=e*c-f*d+a.x;this.y=e*d+f*c+a.y;return this}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setScalar:function(a){this.z=this.y=this.x=a;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},setComponent:function(a,b){switch(a){case 0:this.x=b;break;case 1:this.y=b;break;case 2:this.z=b;break;default:throw Error("index is out of range: "+a);}},getComponent:function(a){switch(a){case 0:return this.x;case 1:return this.y;
case 2:return this.z;default:throw Error("index is out of range: "+a);}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},add:function(a,b){if(void 0!==b)return console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(a,b);this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},addVectors:function(a,
b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addScaledVector:function(a,b){this.x+=a.x*b;this.y+=a.y*b;this.z+=a.z*b;return this},sub:function(a,b){if(void 0!==b)return console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(a,b);this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},subScalar:function(a){this.x-=a;this.y-=a;this.z-=a;return this},subVectors:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},
multiply:function(a,b){if(void 0!==b)return console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(a,b);this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){isFinite(a)?(this.x*=a,this.y*=a,this.z*=a):this.z=this.y=this.x=0;return this},multiplyVectors:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},applyEuler:function(){var a;return function(b){!1===b instanceof THREE.Euler&&
console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order.");void 0===a&&(a=new THREE.Quaternion);this.applyQuaternion(a.setFromEuler(b));return this}}(),applyAxisAngle:function(){var a;return function(b,c){void 0===a&&(a=new THREE.Quaternion);this.applyQuaternion(a.setFromAxisAngle(b,c));return this}}(),applyMatrix3:function(a){var b=this.x,c=this.y,d=this.z;a=a.elements;this.x=a[0]*b+a[3]*c+a[6]*d;this.y=a[1]*b+a[4]*c+a[7]*d;this.z=a[2]*b+a[5]*c+a[8]*
d;return this},applyMatrix4:function(a){var b=this.x,c=this.y,d=this.z;a=a.elements;this.x=a[0]*b+a[4]*c+a[8]*d+a[12];this.y=a[1]*b+a[5]*c+a[9]*d+a[13];this.z=a[2]*b+a[6]*c+a[10]*d+a[14];return this},applyProjection:function(a){var b=this.x,c=this.y,d=this.z;a=a.elements;var e=1/(a[3]*b+a[7]*c+a[11]*d+a[15]);this.x=(a[0]*b+a[4]*c+a[8]*d+a[12])*e;this.y=(a[1]*b+a[5]*c+a[9]*d+a[13])*e;this.z=(a[2]*b+a[6]*c+a[10]*d+a[14])*e;return this},applyQuaternion:function(a){var b=this.x,c=this.y,d=this.z,e=a.x,
f=a.y,g=a.z;a=a.w;var h=a*b+f*d-g*c,k=a*c+g*b-e*d,l=a*d+e*c-f*b,b=-e*b-f*c-g*d;this.x=h*a+b*-e+k*-g-l*-f;this.y=k*a+b*-f+l*-e-h*-g;this.z=l*a+b*-g+h*-f-k*-e;return this},project:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.multiplyMatrices(b.projectionMatrix,a.getInverse(b.matrixWorld));return this.applyProjection(a)}}(),unproject:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.multiplyMatrices(b.matrixWorld,a.getInverse(b.projectionMatrix));return this.applyProjection(a)}}(),
transformDirection:function(a){var b=this.x,c=this.y,d=this.z;a=a.elements;this.x=a[0]*b+a[4]*c+a[8]*d;this.y=a[1]*b+a[5]*c+a[9]*d;this.z=a[2]*b+a[6]*c+a[10]*d;this.normalize();return this},divide:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},divideScalar:function(a){return this.multiplyScalar(1/a)},min:function(a){this.x=Math.min(this.x,a.x);this.y=Math.min(this.y,a.y);this.z=Math.min(this.z,a.z);return this},max:function(a){this.x=Math.max(this.x,a.x);this.y=Math.max(this.y,a.y);
this.z=Math.max(this.z,a.z);return this},clamp:function(a,b){this.x=Math.max(a.x,Math.min(b.x,this.x));this.y=Math.max(a.y,Math.min(b.y,this.y));this.z=Math.max(a.z,Math.min(b.z,this.z));return this},clampScalar:function(){var a,b;return function(c,d){void 0===a&&(a=new THREE.Vector3,b=new THREE.Vector3);a.set(c,c,c);b.set(d,d,d);return this.clamp(a,b)}}(),clampLength:function(a,b){var c=this.length();this.multiplyScalar(Math.max(a,Math.min(b,c))/c);return this},floor:function(){this.x=Math.floor(this.x);
this.y=Math.floor(this.y);this.z=Math.floor(this.z);return this},ceil:function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);this.z=Math.ceil(this.z);return this},round:function(){this.x=Math.round(this.x);this.y=Math.round(this.y);this.z=Math.round(this.z);return this},roundToZero:function(){this.x=0>this.x?Math.ceil(this.x):Math.floor(this.x);this.y=0>this.y?Math.ceil(this.y):Math.floor(this.y);this.z=0>this.z?Math.ceil(this.z):Math.floor(this.z);return this},negate:function(){this.x=-this.x;
this.y=-this.y;this.z=-this.z;return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.multiplyScalar(a/this.length())},lerp:function(a,b){this.x+=(a.x-this.x)*
b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;return this},lerpVectors:function(a,b,c){this.subVectors(b,a).multiplyScalar(c).add(a);return this},cross:function(a,b){if(void 0!==b)return console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(a,b);var c=this.x,d=this.y,e=this.z;this.x=d*a.z-e*a.y;this.y=e*a.x-c*a.z;this.z=c*a.y-d*a.x;return this},crossVectors:function(a,b){var c=a.x,d=a.y,e=a.z,f=b.x,g=b.y,h=b.z;this.x=d*h-e*g;
this.y=e*f-c*h;this.z=c*g-d*f;return this},projectOnVector:function(){var a,b;return function(c){void 0===a&&(a=new THREE.Vector3);a.copy(c).normalize();b=this.dot(a);return this.copy(a).multiplyScalar(b)}}(),projectOnPlane:function(){var a;return function(b){void 0===a&&(a=new THREE.Vector3);a.copy(this).projectOnVector(b);return this.sub(a)}}(),reflect:function(){var a;return function(b){void 0===a&&(a=new THREE.Vector3);return this.sub(a.copy(b).multiplyScalar(2*this.dot(b)))}}(),angleTo:function(a){a=
this.dot(a)/Math.sqrt(this.lengthSq()*a.lengthSq());return Math.acos(THREE.Math.clamp(a,-1,1))},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,c=this.y-a.y;a=this.z-a.z;return b*b+c*c+a*a},setFromSpherical:function(a){var b=Math.sin(a.phi)*a.radius;this.x=b*Math.sin(a.theta);this.y=Math.cos(a.phi)*a.radius;this.z=b*Math.cos(a.theta);return this},setFromMatrixPosition:function(a){return this.setFromMatrixColumn(a,3)},setFromMatrixScale:function(a){var b=
this.setFromMatrixColumn(a,0).length(),c=this.setFromMatrixColumn(a,1).length();a=this.setFromMatrixColumn(a,2).length();this.x=b;this.y=c;this.z=a;return this},setFromMatrixColumn:function(a,b){"number"===typeof a&&(console.warn("THREE.Vector3: setFromMatrixColumn now expects ( matrix, index )."),b=a=b);return this.fromArray(a.elements,4*b)},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z},fromArray:function(a,b){void 0===b&&(b=0);this.x=a[b];this.y=a[b+1];this.z=a[b+2];return this},
toArray:function(a,b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b]=this.x;a[b+1]=this.y;a[b+2]=this.z;return a},fromAttribute:function(a,b,c){void 0===c&&(c=0);b=b*a.itemSize+c;this.x=a.array[b];this.y=a.array[b+1];this.z=a.array[b+2];return this}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},setScalar:function(a){this.w=this.z=this.y=this.x=a;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},setW:function(a){this.w=a;return this},setComponent:function(a,b){switch(a){case 0:this.x=b;break;case 1:this.y=b;break;case 2:this.z=b;break;case 3:this.w=b;break;default:throw Error("index is out of range: "+
a);}},getComponent:function(a){switch(a){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw Error("index is out of range: "+a);}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1;return this},add:function(a,b){if(void 0!==b)return console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(a,b);
this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;this.w+=a;return this},addVectors:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addScaledVector:function(a,b){this.x+=a.x*b;this.y+=a.y*b;this.z+=a.z*b;this.w+=a.w*b;return this},sub:function(a,b){if(void 0!==b)return console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(a,b);this.x-=
a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},subScalar:function(a){this.x-=a;this.y-=a;this.z-=a;this.w-=a;return this},subVectors:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},multiplyScalar:function(a){isFinite(a)?(this.x*=a,this.y*=a,this.z*=a,this.w*=a):this.w=this.z=this.y=this.x=0;return this},applyMatrix4:function(a){var b=this.x,c=this.y,d=this.z,e=this.w;a=a.elements;this.x=a[0]*b+a[4]*c+a[8]*d+a[12]*e;this.y=a[1]*b+a[5]*c+a[9]*d+a[13]*e;this.z=
a[2]*b+a[6]*c+a[10]*d+a[14]*e;this.w=a[3]*b+a[7]*c+a[11]*d+a[15]*e;return this},divideScalar:function(a){return this.multiplyScalar(1/a)},setAxisAngleFromQuaternion:function(a){this.w=2*Math.acos(a.w);var b=Math.sqrt(1-a.w*a.w);1E-4>b?(this.x=1,this.z=this.y=0):(this.x=a.x/b,this.y=a.y/b,this.z=a.z/b);return this},setAxisAngleFromRotationMatrix:function(a){var b,c,d;a=a.elements;var e=a[0];d=a[4];var f=a[8],g=a[1],h=a[5],k=a[9];c=a[2];b=a[6];var l=a[10];if(.01>Math.abs(d-g)&&.01>Math.abs(f-c)&&.01>
Math.abs(k-b)){if(.1>Math.abs(d+g)&&.1>Math.abs(f+c)&&.1>Math.abs(k+b)&&.1>Math.abs(e+h+l-3))return this.set(1,0,0,0),this;a=Math.PI;e=(e+1)/2;h=(h+1)/2;l=(l+1)/2;d=(d+g)/4;f=(f+c)/4;k=(k+b)/4;e>h&&e>l?.01>e?(b=0,d=c=.707106781):(b=Math.sqrt(e),c=d/b,d=f/b):h>l?.01>h?(b=.707106781,c=0,d=.707106781):(c=Math.sqrt(h),b=d/c,d=k/c):.01>l?(c=b=.707106781,d=0):(d=Math.sqrt(l),b=f/d,c=k/d);this.set(b,c,d,a);return this}a=Math.sqrt((b-k)*(b-k)+(f-c)*(f-c)+(g-d)*(g-d));.001>Math.abs(a)&&(a=1);this.x=(b-k)/
a;this.y=(f-c)/a;this.z=(g-d)/a;this.w=Math.acos((e+h+l-1)/2);return this},min:function(a){this.x=Math.min(this.x,a.x);this.y=Math.min(this.y,a.y);this.z=Math.min(this.z,a.z);this.w=Math.min(this.w,a.w);return this},max:function(a){this.x=Math.max(this.x,a.x);this.y=Math.max(this.y,a.y);this.z=Math.max(this.z,a.z);this.w=Math.max(this.w,a.w);return this},clamp:function(a,b){this.x=Math.max(a.x,Math.min(b.x,this.x));this.y=Math.max(a.y,Math.min(b.y,this.y));this.z=Math.max(a.z,Math.min(b.z,this.z));
this.w=Math.max(a.w,Math.min(b.w,this.w));return this},clampScalar:function(){var a,b;return function(c,d){void 0===a&&(a=new THREE.Vector4,b=new THREE.Vector4);a.set(c,c,c,c);b.set(d,d,d,d);return this.clamp(a,b)}}(),floor:function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);this.z=Math.floor(this.z);this.w=Math.floor(this.w);return this},ceil:function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);this.z=Math.ceil(this.z);this.w=Math.ceil(this.w);return this},round:function(){this.x=
Math.round(this.x);this.y=Math.round(this.y);this.z=Math.round(this.z);this.w=Math.round(this.w);return this},roundToZero:function(){this.x=0>this.x?Math.ceil(this.x):Math.floor(this.x);this.y=0>this.y?Math.ceil(this.y):Math.floor(this.y);this.z=0>this.z?Math.ceil(this.z):Math.floor(this.z);this.w=0>this.w?Math.ceil(this.w):Math.floor(this.w);return this},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;this.w=-this.w;return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*
a.z+this.w*a.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.multiplyScalar(a/this.length())},lerp:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-
this.z)*b;this.w+=(a.w-this.w)*b;return this},lerpVectors:function(a,b,c){this.subVectors(b,a).multiplyScalar(c).add(a);return this},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z&&a.w===this.w},fromArray:function(a,b){void 0===b&&(b=0);this.x=a[b];this.y=a[b+1];this.z=a[b+2];this.w=a[b+3];return this},toArray:function(a,b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b]=this.x;a[b+1]=this.y;a[b+2]=this.z;a[b+3]=this.w;return a},fromAttribute:function(a,b,c){void 0===c&&(c=0);b=b*a.itemSize+
c;this.x=a.array[b];this.y=a.array[b+1];this.z=a.array[b+2];this.w=a.array[b+3];return this}};THREE.Euler=function(a,b,c,d){this._x=a||0;this._y=b||0;this._z=c||0;this._order=d||THREE.Euler.DefaultOrder};THREE.Euler.RotationOrders="XYZ YZX ZXY XZY YXZ ZYX".split(" ");THREE.Euler.DefaultOrder="XYZ";
THREE.Euler.prototype={constructor:THREE.Euler,get x(){return this._x},set x(a){this._x=a;this.onChangeCallback()},get y(){return this._y},set y(a){this._y=a;this.onChangeCallback()},get z(){return this._z},set z(a){this._z=a;this.onChangeCallback()},get order(){return this._order},set order(a){this._order=a;this.onChangeCallback()},set:function(a,b,c,d){this._x=a;this._y=b;this._z=c;this._order=d||this._order;this.onChangeCallback();return this},clone:function(){return new this.constructor(this._x,
this._y,this._z,this._order)},copy:function(a){this._x=a._x;this._y=a._y;this._z=a._z;this._order=a._order;this.onChangeCallback();return this},setFromRotationMatrix:function(a,b,c){var d=THREE.Math.clamp,e=a.elements;a=e[0];var f=e[4],g=e[8],h=e[1],k=e[5],l=e[9],n=e[2],p=e[6],e=e[10];b=b||this._order;"XYZ"===b?(this._y=Math.asin(d(g,-1,1)),.99999>Math.abs(g)?(this._x=Math.atan2(-l,e),this._z=Math.atan2(-f,a)):(this._x=Math.atan2(p,k),this._z=0)):"YXZ"===b?(this._x=Math.asin(-d(l,-1,1)),.99999>Math.abs(l)?
(this._y=Math.atan2(g,e),this._z=Math.atan2(h,k)):(this._y=Math.atan2(-n,a),this._z=0)):"ZXY"===b?(this._x=Math.asin(d(p,-1,1)),.99999>Math.abs(p)?(this._y=Math.atan2(-n,e),this._z=Math.atan2(-f,k)):(this._y=0,this._z=Math.atan2(h,a))):"ZYX"===b?(this._y=Math.asin(-d(n,-1,1)),.99999>Math.abs(n)?(this._x=Math.atan2(p,e),this._z=Math.atan2(h,a)):(this._x=0,this._z=Math.atan2(-f,k))):"YZX"===b?(this._z=Math.asin(d(h,-1,1)),.99999>Math.abs(h)?(this._x=Math.atan2(-l,k),this._y=Math.atan2(-n,a)):(this._x=
0,this._y=Math.atan2(g,e))):"XZY"===b?(this._z=Math.asin(-d(f,-1,1)),.99999>Math.abs(f)?(this._x=Math.atan2(p,k),this._y=Math.atan2(g,a)):(this._x=Math.atan2(-l,e),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+b);this._order=b;if(!1!==c)this.onChangeCallback();return this},setFromQuaternion:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Matrix4);a.makeRotationFromQuaternion(b);this.setFromRotationMatrix(a,c,d);return this}}(),setFromVector3:function(a,
b){return this.set(a.x,a.y,a.z,b||this._order)},reorder:function(){var a=new THREE.Quaternion;return function(b){a.setFromEuler(this);this.setFromQuaternion(a,b)}}(),equals:function(a){return a._x===this._x&&a._y===this._y&&a._z===this._z&&a._order===this._order},fromArray:function(a){this._x=a[0];this._y=a[1];this._z=a[2];void 0!==a[3]&&(this._order=a[3]);this.onChangeCallback();return this},toArray:function(a,b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b]=this._x;a[b+1]=this._y;a[b+2]=this._z;a[b+
3]=this._order;return a},toVector3:function(a){return a?a.set(this._x,this._y,this._z):new THREE.Vector3(this._x,this._y,this._z)},onChange:function(a){this.onChangeCallback=a;return this},onChangeCallback:function(){}};THREE.Line3=function(a,b){this.start=void 0!==a?a:new THREE.Vector3;this.end=void 0!==b?b:new THREE.Vector3};
THREE.Line3.prototype={constructor:THREE.Line3,set:function(a,b){this.start.copy(a);this.end.copy(b);return this},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.start.copy(a.start);this.end.copy(a.end);return this},center:function(a){return(a||new THREE.Vector3).addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(a){return(a||new THREE.Vector3).subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},
at:function(a,b){var c=b||new THREE.Vector3;return this.delta(c).multiplyScalar(a).add(this.start)},closestPointToPointParameter:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c,d){a.subVectors(c,this.start);b.subVectors(this.end,this.start);var e=b.dot(b),e=b.dot(a)/e;d&&(e=THREE.Math.clamp(e,0,1));return e}}(),closestPointToPoint:function(a,b,c){a=this.closestPointToPointParameter(a,b);c=c||new THREE.Vector3;return this.delta(c).multiplyScalar(a).add(this.start)},applyMatrix4:function(a){this.start.applyMatrix4(a);
this.end.applyMatrix4(a);return this},equals:function(a){return a.start.equals(this.start)&&a.end.equals(this.end)}};THREE.Box2=function(a,b){this.min=void 0!==a?a:new THREE.Vector2(Infinity,Infinity);this.max=void 0!==b?b:new THREE.Vector2(-Infinity,-Infinity)};
THREE.Box2.prototype={constructor:THREE.Box2,set:function(a,b){this.min.copy(a);this.max.copy(b);return this},setFromPoints:function(a){this.makeEmpty();for(var b=0,c=a.length;b<c;b++)this.expandByPoint(a[b]);return this},setFromCenterAndSize:function(){var a=new THREE.Vector2;return function(b,c){var d=a.copy(c).multiplyScalar(.5);this.min.copy(b).sub(d);this.max.copy(b).add(d);return this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.min.copy(a.min);this.max.copy(a.max);
return this},makeEmpty:function(){this.min.x=this.min.y=Infinity;this.max.x=this.max.y=-Infinity;return this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},center:function(a){return(a||new THREE.Vector2).addVectors(this.min,this.max).multiplyScalar(.5)},size:function(a){return(a||new THREE.Vector2).subVectors(this.max,this.min)},expandByPoint:function(a){this.min.min(a);this.max.max(a);return this},expandByVector:function(a){this.min.sub(a);this.max.add(a);return this},expandByScalar:function(a){this.min.addScalar(-a);
this.max.addScalar(a);return this},containsPoint:function(a){return a.x<this.min.x||a.x>this.max.x||a.y<this.min.y||a.y>this.max.y?!1:!0},containsBox:function(a){return this.min.x<=a.min.x&&a.max.x<=this.max.x&&this.min.y<=a.min.y&&a.max.y<=this.max.y?!0:!1},getParameter:function(a,b){return(b||new THREE.Vector2).set((a.x-this.min.x)/(this.max.x-this.min.x),(a.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(a){return a.max.x<this.min.x||a.min.x>this.max.x||a.max.y<this.min.y||a.min.y>
this.max.y?!1:!0},clampPoint:function(a,b){return(b||new THREE.Vector2).copy(a).clamp(this.min,this.max)},distanceToPoint:function(){var a=new THREE.Vector2;return function(b){return a.copy(b).clamp(this.min,this.max).sub(b).length()}}(),intersect:function(a){this.min.max(a.min);this.max.min(a.max);return this},union:function(a){this.min.min(a.min);this.max.max(a.max);return this},translate:function(a){this.min.add(a);this.max.add(a);return this},equals:function(a){return a.min.equals(this.min)&&
a.max.equals(this.max)}};THREE.Box3=function(a,b){this.min=void 0!==a?a:new THREE.Vector3(Infinity,Infinity,Infinity);this.max=void 0!==b?b:new THREE.Vector3(-Infinity,-Infinity,-Infinity)};
THREE.Box3.prototype={constructor:THREE.Box3,set:function(a,b){this.min.copy(a);this.max.copy(b);return this},setFromArray:function(a){for(var b=Infinity,c=Infinity,d=Infinity,e=-Infinity,f=-Infinity,g=-Infinity,h=0,k=a.length;h<k;h+=3){var l=a[h],n=a[h+1],p=a[h+2];l<b&&(b=l);n<c&&(c=n);p<d&&(d=p);l>e&&(e=l);n>f&&(f=n);p>g&&(g=p)}this.min.set(b,c,d);this.max.set(e,f,g)},setFromPoints:function(a){this.makeEmpty();for(var b=0,c=a.length;b<c;b++)this.expandByPoint(a[b]);return this},setFromCenterAndSize:function(){var a=
new THREE.Vector3;return function(b,c){var d=a.copy(c).multiplyScalar(.5);this.min.copy(b).sub(d);this.max.copy(b).add(d);return this}}(),setFromObject:function(){var a=new THREE.Vector3;return function(b){var c=this;b.updateMatrixWorld(!0);this.makeEmpty();b.traverse(function(b){var e=b.geometry;if(void 0!==e)if(e instanceof THREE.Geometry)for(var f=e.vertices,e=0,g=f.length;e<g;e++)a.copy(f[e]),a.applyMatrix4(b.matrixWorld),c.expandByPoint(a);else if(e instanceof THREE.BufferGeometry&&void 0!==
e.attributes.position)for(f=e.attributes.position.array,e=0,g=f.length;e<g;e+=3)a.fromArray(f,e),a.applyMatrix4(b.matrixWorld),c.expandByPoint(a)});return this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.min.copy(a.min);this.max.copy(a.max);return this},makeEmpty:function(){this.min.x=this.min.y=this.min.z=Infinity;this.max.x=this.max.y=this.max.z=-Infinity;return this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},
center:function(a){return(a||new THREE.Vector3).addVectors(this.min,this.max).multiplyScalar(.5)},size:function(a){return(a||new THREE.Vector3).subVectors(this.max,this.min)},expandByPoint:function(a){this.min.min(a);this.max.max(a);return this},expandByVector:function(a){this.min.sub(a);this.max.add(a);return this},expandByScalar:function(a){this.min.addScalar(-a);this.max.addScalar(a);return this},containsPoint:function(a){return a.x<this.min.x||a.x>this.max.x||a.y<this.min.y||a.y>this.max.y||a.z<
this.min.z||a.z>this.max.z?!1:!0},containsBox:function(a){return this.min.x<=a.min.x&&a.max.x<=this.max.x&&this.min.y<=a.min.y&&a.max.y<=this.max.y&&this.min.z<=a.min.z&&a.max.z<=this.max.z?!0:!1},getParameter:function(a,b){return(b||new THREE.Vector3).set((a.x-this.min.x)/(this.max.x-this.min.x),(a.y-this.min.y)/(this.max.y-this.min.y),(a.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(a){return a.max.x<this.min.x||a.min.x>this.max.x||a.max.y<this.min.y||a.min.y>this.max.y||a.max.z<
this.min.z||a.min.z>this.max.z?!1:!0},intersectsSphere:function(){var a;return function(b){void 0===a&&(a=new THREE.Vector3);this.clampPoint(b.center,a);return a.distanceToSquared(b.center)<=b.radius*b.radius}}(),intersectsPlane:function(a){var b,c;0<a.normal.x?(b=a.normal.x*this.min.x,c=a.normal.x*this.max.x):(b=a.normal.x*this.max.x,c=a.normal.x*this.min.x);0<a.normal.y?(b+=a.normal.y*this.min.y,c+=a.normal.y*this.max.y):(b+=a.normal.y*this.max.y,c+=a.normal.y*this.min.y);0<a.normal.z?(b+=a.normal.z*
this.min.z,c+=a.normal.z*this.max.z):(b+=a.normal.z*this.max.z,c+=a.normal.z*this.min.z);return b<=a.constant&&c>=a.constant},clampPoint:function(a,b){return(b||new THREE.Vector3).copy(a).clamp(this.min,this.max)},distanceToPoint:function(){var a=new THREE.Vector3;return function(b){return a.copy(b).clamp(this.min,this.max).sub(b).length()}}(),getBoundingSphere:function(){var a=new THREE.Vector3;return function(b){b=b||new THREE.Sphere;b.center=this.center();b.radius=.5*this.size(a).length();return b}}(),
intersect:function(a){this.min.max(a.min);this.max.min(a.max);this.isEmpty()&&this.makeEmpty();return this},union:function(a){this.min.min(a.min);this.max.max(a.max);return this},applyMatrix4:function(){var a=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];return function(b){if(this.isEmpty())return this;a[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(b);a[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(b);
a[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(b);a[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(b);a[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(b);a[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(b);a[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(b);a[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(b);this.setFromPoints(a);return this}}(),translate:function(a){this.min.add(a);this.max.add(a);return this},equals:function(a){return a.min.equals(this.min)&&
a.max.equals(this.max)}};THREE.Matrix3=function(){this.elements=new Float32Array([1,0,0,0,1,0,0,0,1]);0<arguments.length&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,set:function(a,b,c,d,e,f,g,h,k){var l=this.elements;l[0]=a;l[1]=d;l[2]=g;l[3]=b;l[4]=e;l[5]=h;l[6]=c;l[7]=f;l[8]=k;return this},identity:function(){this.set(1,0,0,0,1,0,0,0,1);return this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(a){a=a.elements;this.set(a[0],a[3],a[6],a[1],a[4],a[7],a[2],a[5],a[8]);return this},setFromMatrix4:function(a){a=a.elements;this.set(a[0],a[4],a[8],a[1],a[5],a[9],a[2],a[6],a[10]);
return this},applyToVector3Array:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Vector3);void 0===c&&(c=0);void 0===d&&(d=b.length);for(var e=0;e<d;e+=3,c+=3)a.fromArray(b,c),a.applyMatrix3(this),a.toArray(b,c);return b}}(),applyToBuffer:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Vector3);void 0===c&&(c=0);void 0===d&&(d=b.length/b.itemSize);for(var e=0;e<d;e++,c++)a.x=b.getX(c),a.y=b.getY(c),a.z=b.getZ(c),a.applyMatrix3(this),b.setXYZ(a.x,a.y,a.z);return b}}(),
multiplyScalar:function(a){var b=this.elements;b[0]*=a;b[3]*=a;b[6]*=a;b[1]*=a;b[4]*=a;b[7]*=a;b[2]*=a;b[5]*=a;b[8]*=a;return this},determinant:function(){var a=this.elements,b=a[0],c=a[1],d=a[2],e=a[3],f=a[4],g=a[5],h=a[6],k=a[7],a=a[8];return b*f*a-b*g*k-c*e*a+c*g*h+d*e*k-d*f*h},getInverse:function(a,b){a instanceof THREE.Matrix4&&console.error("THREE.Matrix3.getInverse no longer takes a Matrix4 argument.");var c=a.elements,d=this.elements,e=c[0],f=c[1],g=c[2],h=c[3],k=c[4],l=c[5],n=c[6],p=c[7],
c=c[8],m=c*k-l*p,q=l*n-c*h,r=p*h-k*n,s=e*m+f*q+g*r;if(0===s){if(b)throw Error("THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0");console.warn("THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0");return this.identity()}d[0]=m;d[1]=g*p-c*f;d[2]=l*f-g*k;d[3]=q;d[4]=c*e-g*n;d[5]=g*h-l*e;d[6]=r;d[7]=f*n-p*e;d[8]=k*e-f*h;return this.multiplyScalar(1/s)},transpose:function(){var a,b=this.elements;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},
flattenToArrayOffset:function(a,b){console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead.");return this.toArray(a,b)},getNormalMatrix:function(a){return this.setFromMatrix4(a).getInverse(this).transpose()},transposeIntoArray:function(a){var b=this.elements;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this},fromArray:function(a){this.elements.set(a);return this},toArray:function(a,b){void 0===a&&(a=[]);void 0===
b&&(b=0);var c=this.elements;a[b]=c[0];a[b+1]=c[1];a[b+2]=c[2];a[b+3]=c[3];a[b+4]=c[4];a[b+5]=c[5];a[b+6]=c[6];a[b+7]=c[7];a[b+8]=c[8];return a}};THREE.Matrix4=function(){this.elements=new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);0<arguments.length&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,g,h,k,l,n,p,m,q,r,s){var u=this.elements;u[0]=a;u[4]=b;u[8]=c;u[12]=d;u[1]=e;u[5]=f;u[9]=g;u[13]=h;u[2]=k;u[6]=l;u[10]=n;u[14]=p;u[3]=m;u[7]=q;u[11]=r;u[15]=s;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},clone:function(){return(new THREE.Matrix4).fromArray(this.elements)},copy:function(a){this.elements.set(a.elements);return this},copyPosition:function(a){var b=this.elements;a=a.elements;
b[12]=a[12];b[13]=a[13];b[14]=a[14];return this},extractBasis:function(a,b,c){a.setFromMatrixColumn(this,0);b.setFromMatrixColumn(this,1);c.setFromMatrixColumn(this,2);return this},makeBasis:function(a,b,c){this.set(a.x,b.x,c.x,0,a.y,b.y,c.y,0,a.z,b.z,c.z,0,0,0,0,1);return this},extractRotation:function(){var a;return function(b){void 0===a&&(a=new THREE.Vector3);var c=this.elements,d=b.elements,e=1/a.setFromMatrixColumn(b,0).length(),f=1/a.setFromMatrixColumn(b,1).length();b=1/a.setFromMatrixColumn(b,
2).length();c[0]=d[0]*e;c[1]=d[1]*e;c[2]=d[2]*e;c[4]=d[4]*f;c[5]=d[5]*f;c[6]=d[6]*f;c[8]=d[8]*b;c[9]=d[9]*b;c[10]=d[10]*b;return this}}(),makeRotationFromEuler:function(a){!1===a instanceof THREE.Euler&&console.error("THREE.Matrix: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var b=this.elements,c=a.x,d=a.y,e=a.z,f=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);if("XYZ"===a.order){a=f*h;var k=f*e,l=c*h,n=c*e;b[0]=g*h;b[4]=
-g*e;b[8]=d;b[1]=k+l*d;b[5]=a-n*d;b[9]=-c*g;b[2]=n-a*d;b[6]=l+k*d;b[10]=f*g}else"YXZ"===a.order?(a=g*h,k=g*e,l=d*h,n=d*e,b[0]=a+n*c,b[4]=l*c-k,b[8]=f*d,b[1]=f*e,b[5]=f*h,b[9]=-c,b[2]=k*c-l,b[6]=n+a*c,b[10]=f*g):"ZXY"===a.order?(a=g*h,k=g*e,l=d*h,n=d*e,b[0]=a-n*c,b[4]=-f*e,b[8]=l+k*c,b[1]=k+l*c,b[5]=f*h,b[9]=n-a*c,b[2]=-f*d,b[6]=c,b[10]=f*g):"ZYX"===a.order?(a=f*h,k=f*e,l=c*h,n=c*e,b[0]=g*h,b[4]=l*d-k,b[8]=a*d+n,b[1]=g*e,b[5]=n*d+a,b[9]=k*d-l,b[2]=-d,b[6]=c*g,b[10]=f*g):"YZX"===a.order?(a=f*g,k=f*
d,l=c*g,n=c*d,b[0]=g*h,b[4]=n-a*e,b[8]=l*e+k,b[1]=e,b[5]=f*h,b[9]=-c*h,b[2]=-d*h,b[6]=k*e+l,b[10]=a-n*e):"XZY"===a.order&&(a=f*g,k=f*d,l=c*g,n=c*d,b[0]=g*h,b[4]=-e,b[8]=d*h,b[1]=a*e+n,b[5]=f*h,b[9]=k*e-l,b[2]=l*e-k,b[6]=c*h,b[10]=n*e+a);b[3]=0;b[7]=0;b[11]=0;b[12]=0;b[13]=0;b[14]=0;b[15]=1;return this},makeRotationFromQuaternion:function(a){var b=this.elements,c=a.x,d=a.y,e=a.z,f=a.w,g=c+c,h=d+d,k=e+e;a=c*g;var l=c*h,c=c*k,n=d*h,d=d*k,e=e*k,g=f*g,h=f*h,f=f*k;b[0]=1-(n+e);b[4]=l-f;b[8]=c+h;b[1]=l+
f;b[5]=1-(a+e);b[9]=d-g;b[2]=c-h;b[6]=d+g;b[10]=1-(a+n);b[3]=0;b[7]=0;b[11]=0;b[12]=0;b[13]=0;b[14]=0;b[15]=1;return this},lookAt:function(){var a,b,c;return function(d,e,f){void 0===a&&(a=new THREE.Vector3);void 0===b&&(b=new THREE.Vector3);void 0===c&&(c=new THREE.Vector3);var g=this.elements;c.subVectors(d,e).normalize();0===c.lengthSq()&&(c.z=1);a.crossVectors(f,c).normalize();0===a.lengthSq()&&(c.x+=1E-4,a.crossVectors(f,c).normalize());b.crossVectors(c,a);g[0]=a.x;g[4]=b.x;g[8]=c.x;g[1]=a.y;
g[5]=b.y;g[9]=c.y;g[2]=a.z;g[6]=b.z;g[10]=c.z;return this}}(),multiply:function(a,b){return void 0!==b?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(a,b)):this.multiplyMatrices(this,a)},premultiply:function(a){return this.multiplyMatrices(a,this)},multiplyMatrices:function(a,b){var c=a.elements,d=b.elements,e=this.elements,f=c[0],g=c[4],h=c[8],k=c[12],l=c[1],n=c[5],p=c[9],m=c[13],q=c[2],r=c[6],s=c[10],u=c[14],
v=c[3],x=c[7],A=c[11],c=c[15],w=d[0],B=d[4],z=d[8],y=d[12],C=d[1],J=d[5],D=d[9],H=d[13],G=d[2],K=d[6],P=d[10],I=d[14],L=d[3],E=d[7],M=d[11],d=d[15];e[0]=f*w+g*C+h*G+k*L;e[4]=f*B+g*J+h*K+k*E;e[8]=f*z+g*D+h*P+k*M;e[12]=f*y+g*H+h*I+k*d;e[1]=l*w+n*C+p*G+m*L;e[5]=l*B+n*J+p*K+m*E;e[9]=l*z+n*D+p*P+m*M;e[13]=l*y+n*H+p*I+m*d;e[2]=q*w+r*C+s*G+u*L;e[6]=q*B+r*J+s*K+u*E;e[10]=q*z+r*D+s*P+u*M;e[14]=q*y+r*H+s*I+u*d;e[3]=v*w+x*C+A*G+c*L;e[7]=v*B+x*J+A*K+c*E;e[11]=v*z+x*D+A*P+c*M;e[15]=v*y+x*H+A*I+c*d;return this},
multiplyToArray:function(a,b,c){var d=this.elements;this.multiplyMatrices(a,b);c[0]=d[0];c[1]=d[1];c[2]=d[2];c[3]=d[3];c[4]=d[4];c[5]=d[5];c[6]=d[6];c[7]=d[7];c[8]=d[8];c[9]=d[9];c[10]=d[10];c[11]=d[11];c[12]=d[12];c[13]=d[13];c[14]=d[14];c[15]=d[15];return this},multiplyScalar:function(a){var b=this.elements;b[0]*=a;b[4]*=a;b[8]*=a;b[12]*=a;b[1]*=a;b[5]*=a;b[9]*=a;b[13]*=a;b[2]*=a;b[6]*=a;b[10]*=a;b[14]*=a;b[3]*=a;b[7]*=a;b[11]*=a;b[15]*=a;return this},applyToVector3Array:function(){var a;return function(b,
c,d){void 0===a&&(a=new THREE.Vector3);void 0===c&&(c=0);void 0===d&&(d=b.length);for(var e=0;e<d;e+=3,c+=3)a.fromArray(b,c),a.applyMatrix4(this),a.toArray(b,c);return b}}(),applyToBuffer:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Vector3);void 0===c&&(c=0);void 0===d&&(d=b.length/b.itemSize);for(var e=0;e<d;e++,c++)a.x=b.getX(c),a.y=b.getY(c),a.z=b.getZ(c),a.applyMatrix4(this),b.setXYZ(a.x,a.y,a.z);return b}}(),determinant:function(){var a=this.elements,b=a[0],c=a[4],d=a[8],
e=a[12],f=a[1],g=a[5],h=a[9],k=a[13],l=a[2],n=a[6],p=a[10],m=a[14];return a[3]*(+e*h*n-d*k*n-e*g*p+c*k*p+d*g*m-c*h*m)+a[7]*(+b*h*m-b*k*p+e*f*p-d*f*m+d*k*l-e*h*l)+a[11]*(+b*k*n-b*g*m-e*f*n+c*f*m+e*g*l-c*k*l)+a[15]*(-d*g*l-b*h*n+b*g*p+d*f*n-c*f*p+c*h*l)},transpose:function(){var a=this.elements,b;b=a[1];a[1]=a[4];a[4]=b;b=a[2];a[2]=a[8];a[8]=b;b=a[6];a[6]=a[9];a[9]=b;b=a[3];a[3]=a[12];a[12]=b;b=a[7];a[7]=a[13];a[13]=b;b=a[11];a[11]=a[14];a[14]=b;return this},flattenToArrayOffset:function(a,b){console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead.");
return this.toArray(a,b)},getPosition:function(){var a;return function(){void 0===a&&(a=new THREE.Vector3);console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead.");return a.setFromMatrixColumn(this,3)}}(),setPosition:function(a){var b=this.elements;b[12]=a.x;b[13]=a.y;b[14]=a.z;return this},getInverse:function(a,b){var c=this.elements,d=a.elements,e=d[0],f=d[1],g=d[2],h=d[3],k=d[4],l=d[5],n=d[6],p=d[7],m=d[8],q=d[9],r=d[10],s=d[11],u=d[12],
v=d[13],x=d[14],d=d[15],A=q*x*p-v*r*p+v*n*s-l*x*s-q*n*d+l*r*d,w=u*r*p-m*x*p-u*n*s+k*x*s+m*n*d-k*r*d,B=m*v*p-u*q*p+u*l*s-k*v*s-m*l*d+k*q*d,z=u*q*n-m*v*n-u*l*r+k*v*r+m*l*x-k*q*x,y=e*A+f*w+g*B+h*z;if(0===y){if(b)throw Error("THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0");console.warn("THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0");return this.identity()}c[0]=A;c[1]=v*r*h-q*x*h-v*g*s+f*x*s+q*g*d-f*r*d;c[2]=l*x*h-v*n*h+v*g*p-f*x*p-l*g*d+f*n*d;c[3]=q*n*h-l*r*h-
q*g*p+f*r*p+l*g*s-f*n*s;c[4]=w;c[5]=m*x*h-u*r*h+u*g*s-e*x*s-m*g*d+e*r*d;c[6]=u*n*h-k*x*h-u*g*p+e*x*p+k*g*d-e*n*d;c[7]=k*r*h-m*n*h+m*g*p-e*r*p-k*g*s+e*n*s;c[8]=B;c[9]=u*q*h-m*v*h-u*f*s+e*v*s+m*f*d-e*q*d;c[10]=k*v*h-u*l*h+u*f*p-e*v*p-k*f*d+e*l*d;c[11]=m*l*h-k*q*h-m*f*p+e*q*p+k*f*s-e*l*s;c[12]=z;c[13]=m*v*g-u*q*g+u*f*r-e*v*r-m*f*x+e*q*x;c[14]=u*l*g-k*v*g-u*f*n+e*v*n+k*f*x-e*l*x;c[15]=k*q*g-m*l*g+m*f*n-e*q*n-k*f*r+e*l*r;return this.multiplyScalar(1/y)},scale:function(a){var b=this.elements,c=a.x,d=a.y;
a=a.z;b[0]*=c;b[4]*=d;b[8]*=a;b[1]*=c;b[5]*=d;b[9]*=a;b[2]*=c;b[6]*=d;b[10]*=a;b[3]*=c;b[7]*=d;b[11]*=a;return this},getMaxScaleOnAxis:function(){var a=this.elements;return Math.sqrt(Math.max(a[0]*a[0]+a[1]*a[1]+a[2]*a[2],a[4]*a[4]+a[5]*a[5]+a[6]*a[6],a[8]*a[8]+a[9]*a[9]+a[10]*a[10]))},makeTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},makeRotationX:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},makeRotationY:function(a){var b=
Math.cos(a);a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},makeRotationZ:function(a){var b=Math.cos(a);a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},makeRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,h=a.z,k=e*f,l=e*g;this.set(k*f+c,k*g-d*h,k*h+d*g,0,k*g+d*h,l*g+c,l*h-d*f,0,k*h-d*g,l*h+d*f,e*h*h+c,0,0,0,0,1);return this},makeScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},compose:function(a,b,
c){this.makeRotationFromQuaternion(b);this.scale(c);this.setPosition(a);return this},decompose:function(){var a,b;return function(c,d,e){void 0===a&&(a=new THREE.Vector3);void 0===b&&(b=new THREE.Matrix4);var f=this.elements,g=a.set(f[0],f[1],f[2]).length(),h=a.set(f[4],f[5],f[6]).length(),k=a.set(f[8],f[9],f[10]).length();0>this.determinant()&&(g=-g);c.x=f[12];c.y=f[13];c.z=f[14];b.elements.set(this.elements);c=1/g;var f=1/h,l=1/k;b.elements[0]*=c;b.elements[1]*=c;b.elements[2]*=c;b.elements[4]*=
f;b.elements[5]*=f;b.elements[6]*=f;b.elements[8]*=l;b.elements[9]*=l;b.elements[10]*=l;d.setFromRotationMatrix(b);e.x=g;e.y=h;e.z=k;return this}}(),makeFrustum:function(a,b,c,d,e,f){var g=this.elements;g[0]=2*e/(b-a);g[4]=0;g[8]=(b+a)/(b-a);g[12]=0;g[1]=0;g[5]=2*e/(d-c);g[9]=(d+c)/(d-c);g[13]=0;g[2]=0;g[6]=0;g[10]=-(f+e)/(f-e);g[14]=-2*f*e/(f-e);g[3]=0;g[7]=0;g[11]=-1;g[15]=0;return this},makePerspective:function(a,b,c,d){a=c*Math.tan(THREE.Math.DEG2RAD*a*.5);var e=-a;return this.makeFrustum(e*b,
a*b,e,a,c,d)},makeOrthographic:function(a,b,c,d,e,f){var g=this.elements,h=1/(b-a),k=1/(c-d),l=1/(f-e);g[0]=2*h;g[4]=0;g[8]=0;g[12]=-((b+a)*h);g[1]=0;g[5]=2*k;g[9]=0;g[13]=-((c+d)*k);g[2]=0;g[6]=0;g[10]=-2*l;g[14]=-((f+e)*l);g[3]=0;g[7]=0;g[11]=0;g[15]=1;return this},equals:function(a){var b=this.elements;a=a.elements;for(var c=0;16>c;c++)if(b[c]!==a[c])return!1;return!0},fromArray:function(a){this.elements.set(a);return this},toArray:function(a,b){void 0===a&&(a=[]);void 0===b&&(b=0);var c=this.elements;
a[b]=c[0];a[b+1]=c[1];a[b+2]=c[2];a[b+3]=c[3];a[b+4]=c[4];a[b+5]=c[5];a[b+6]=c[6];a[b+7]=c[7];a[b+8]=c[8];a[b+9]=c[9];a[b+10]=c[10];a[b+11]=c[11];a[b+12]=c[12];a[b+13]=c[13];a[b+14]=c[14];a[b+15]=c[15];return a}};THREE.Ray=function(a,b){this.origin=void 0!==a?a:new THREE.Vector3;this.direction=void 0!==b?b:new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,set:function(a,b){this.origin.copy(a);this.direction.copy(b);return this},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.origin.copy(a.origin);this.direction.copy(a.direction);return this},at:function(a,b){return(b||new THREE.Vector3).copy(this.direction).multiplyScalar(a).add(this.origin)},lookAt:function(a){this.direction.copy(a).sub(this.origin).normalize()},recast:function(){var a=new THREE.Vector3;return function(b){this.origin.copy(this.at(b,
a));return this}}(),closestPointToPoint:function(a,b){var c=b||new THREE.Vector3;c.subVectors(a,this.origin);var d=c.dot(this.direction);return 0>d?c.copy(this.origin):c.copy(this.direction).multiplyScalar(d).add(this.origin)},distanceToPoint:function(a){return Math.sqrt(this.distanceSqToPoint(a))},distanceSqToPoint:function(){var a=new THREE.Vector3;return function(b){var c=a.subVectors(b,this.origin).dot(this.direction);if(0>c)return this.origin.distanceToSquared(b);a.copy(this.direction).multiplyScalar(c).add(this.origin);
return a.distanceToSquared(b)}}(),distanceSqToSegment:function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Vector3;return function(d,e,f,g){a.copy(d).add(e).multiplyScalar(.5);b.copy(e).sub(d).normalize();c.copy(this.origin).sub(a);var h=.5*d.distanceTo(e),k=-this.direction.dot(b),l=c.dot(this.direction),n=-c.dot(b),p=c.lengthSq(),m=Math.abs(1-k*k),q;0<m?(d=k*n-l,e=k*l-n,q=h*m,0<=d?e>=-q?e<=q?(h=1/m,d*=h,e*=h,k=d*(d+k*e+2*l)+e*(k*d+e+2*n)+p):(e=h,d=Math.max(0,-(k*e+l)),k=-d*d+e*(e+2*
n)+p):(e=-h,d=Math.max(0,-(k*e+l)),k=-d*d+e*(e+2*n)+p):e<=-q?(d=Math.max(0,-(-k*h+l)),e=0<d?-h:Math.min(Math.max(-h,-n),h),k=-d*d+e*(e+2*n)+p):e<=q?(d=0,e=Math.min(Math.max(-h,-n),h),k=e*(e+2*n)+p):(d=Math.max(0,-(k*h+l)),e=0<d?h:Math.min(Math.max(-h,-n),h),k=-d*d+e*(e+2*n)+p)):(e=0<k?-h:h,d=Math.max(0,-(k*e+l)),k=-d*d+e*(e+2*n)+p);f&&f.copy(this.direction).multiplyScalar(d).add(this.origin);g&&g.copy(b).multiplyScalar(e).add(a);return k}}(),intersectSphere:function(){var a=new THREE.Vector3;return function(b,
c){a.subVectors(b.center,this.origin);var d=a.dot(this.direction),e=a.dot(a)-d*d,f=b.radius*b.radius;if(e>f)return null;f=Math.sqrt(f-e);e=d-f;d+=f;return 0>e&&0>d?null:0>e?this.at(d,c):this.at(e,c)}}(),intersectsSphere:function(a){return this.distanceToPoint(a.center)<=a.radius},distanceToPlane:function(a){var b=a.normal.dot(this.direction);if(0===b)return 0===a.distanceToPoint(this.origin)?0:null;a=-(this.origin.dot(a.normal)+a.constant)/b;return 0<=a?a:null},intersectPlane:function(a,b){var c=
this.distanceToPlane(a);return null===c?null:this.at(c,b)},intersectsPlane:function(a){var b=a.distanceToPoint(this.origin);return 0===b||0>a.normal.dot(this.direction)*b?!0:!1},intersectBox:function(a,b){var c,d,e,f,g;d=1/this.direction.x;f=1/this.direction.y;g=1/this.direction.z;var h=this.origin;0<=d?(c=(a.min.x-h.x)*d,d*=a.max.x-h.x):(c=(a.max.x-h.x)*d,d*=a.min.x-h.x);0<=f?(e=(a.min.y-h.y)*f,f*=a.max.y-h.y):(e=(a.max.y-h.y)*f,f*=a.min.y-h.y);if(c>f||e>d)return null;if(e>c||c!==c)c=e;if(f<d||d!==
d)d=f;0<=g?(e=(a.min.z-h.z)*g,g*=a.max.z-h.z):(e=(a.max.z-h.z)*g,g*=a.min.z-h.z);if(c>g||e>d)return null;if(e>c||c!==c)c=e;if(g<d||d!==d)d=g;return 0>d?null:this.at(0<=c?c:d,b)},intersectsBox:function(){var a=new THREE.Vector3;return function(b){return null!==this.intersectBox(b,a)}}(),intersectTriangle:function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Vector3,d=new THREE.Vector3;return function(e,f,g,h,k){b.subVectors(f,e);c.subVectors(g,e);d.crossVectors(b,c);f=this.direction.dot(d);
if(0<f){if(h)return null;h=1}else if(0>f)h=-1,f=-f;else return null;a.subVectors(this.origin,e);e=h*this.direction.dot(c.crossVectors(a,c));if(0>e)return null;g=h*this.direction.dot(b.cross(a));if(0>g||e+g>f)return null;e=-h*a.dot(d);return 0>e?null:this.at(e/f,k)}}(),applyMatrix4:function(a){this.direction.add(this.origin).applyMatrix4(a);this.origin.applyMatrix4(a);this.direction.sub(this.origin);this.direction.normalize();return this},equals:function(a){return a.origin.equals(this.origin)&&a.direction.equals(this.direction)}};
THREE.Sphere=function(a,b){this.center=void 0!==a?a:new THREE.Vector3;this.radius=void 0!==b?b:0};
THREE.Sphere.prototype={constructor:THREE.Sphere,set:function(a,b){this.center.copy(a);this.radius=b;return this},setFromPoints:function(){var a=new THREE.Box3;return function(b,c){var d=this.center;void 0!==c?d.copy(c):a.setFromPoints(b).center(d);for(var e=0,f=0,g=b.length;f<g;f++)e=Math.max(e,d.distanceToSquared(b[f]));this.radius=Math.sqrt(e);return this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.center.copy(a.center);this.radius=a.radius;return this},
empty:function(){return 0>=this.radius},containsPoint:function(a){return a.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(a){return a.distanceTo(this.center)-this.radius},intersectsSphere:function(a){var b=this.radius+a.radius;return a.center.distanceToSquared(this.center)<=b*b},intersectsBox:function(a){return a.intersectsSphere(this)},intersectsPlane:function(a){return Math.abs(this.center.dot(a.normal)-a.constant)<=this.radius},clampPoint:function(a,b){var c=
this.center.distanceToSquared(a),d=b||new THREE.Vector3;d.copy(a);c>this.radius*this.radius&&(d.sub(this.center).normalize(),d.multiplyScalar(this.radius).add(this.center));return d},getBoundingBox:function(a){a=a||new THREE.Box3;a.set(this.center,this.center);a.expandByScalar(this.radius);return a},applyMatrix4:function(a){this.center.applyMatrix4(a);this.radius*=a.getMaxScaleOnAxis();return this},translate:function(a){this.center.add(a);return this},equals:function(a){return a.center.equals(this.center)&&
a.radius===this.radius}};THREE.Frustum=function(a,b,c,d,e,f){this.planes=[void 0!==a?a:new THREE.Plane,void 0!==b?b:new THREE.Plane,void 0!==c?c:new THREE.Plane,void 0!==d?d:new THREE.Plane,void 0!==e?e:new THREE.Plane,void 0!==f?f:new THREE.Plane]};
THREE.Frustum.prototype={constructor:THREE.Frustum,set:function(a,b,c,d,e,f){var g=this.planes;g[0].copy(a);g[1].copy(b);g[2].copy(c);g[3].copy(d);g[4].copy(e);g[5].copy(f);return this},clone:function(){return(new this.constructor).copy(this)},copy:function(a){for(var b=this.planes,c=0;6>c;c++)b[c].copy(a.planes[c]);return this},setFromMatrix:function(a){var b=this.planes,c=a.elements;a=c[0];var d=c[1],e=c[2],f=c[3],g=c[4],h=c[5],k=c[6],l=c[7],n=c[8],p=c[9],m=c[10],q=c[11],r=c[12],s=c[13],u=c[14],
c=c[15];b[0].setComponents(f-a,l-g,q-n,c-r).normalize();b[1].setComponents(f+a,l+g,q+n,c+r).normalize();b[2].setComponents(f+d,l+h,q+p,c+s).normalize();b[3].setComponents(f-d,l-h,q-p,c-s).normalize();b[4].setComponents(f-e,l-k,q-m,c-u).normalize();b[5].setComponents(f+e,l+k,q+m,c+u).normalize();return this},intersectsObject:function(){var a=new THREE.Sphere;return function(b){var c=b.geometry;null===c.boundingSphere&&c.computeBoundingSphere();a.copy(c.boundingSphere);a.applyMatrix4(b.matrixWorld);
return this.intersectsSphere(a)}}(),intersectsSphere:function(a){var b=this.planes,c=a.center;a=-a.radius;for(var d=0;6>d;d++)if(b[d].distanceToPoint(c)<a)return!1;return!0},intersectsBox:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c){for(var d=this.planes,e=0;6>e;e++){var f=d[e];a.x=0<f.normal.x?c.min.x:c.max.x;b.x=0<f.normal.x?c.max.x:c.min.x;a.y=0<f.normal.y?c.min.y:c.max.y;b.y=0<f.normal.y?c.max.y:c.min.y;a.z=0<f.normal.z?c.min.z:c.max.z;b.z=0<f.normal.z?c.max.z:c.min.z;
var g=f.distanceToPoint(a),f=f.distanceToPoint(b);if(0>g&&0>f)return!1}return!0}}(),containsPoint:function(a){for(var b=this.planes,c=0;6>c;c++)if(0>b[c].distanceToPoint(a))return!1;return!0}};THREE.Plane=function(a,b){this.normal=void 0!==a?a:new THREE.Vector3(1,0,0);this.constant=void 0!==b?b:0};
THREE.Plane.prototype={constructor:THREE.Plane,set:function(a,b){this.normal.copy(a);this.constant=b;return this},setComponents:function(a,b,c,d){this.normal.set(a,b,c);this.constant=d;return this},setFromNormalAndCoplanarPoint:function(a,b){this.normal.copy(a);this.constant=-b.dot(this.normal);return this},setFromCoplanarPoints:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c,d,e){d=a.subVectors(e,d).cross(b.subVectors(c,d)).normalize();this.setFromNormalAndCoplanarPoint(d,
c);return this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.normal.copy(a.normal);this.constant=a.constant;return this},normalize:function(){var a=1/this.normal.length();this.normal.multiplyScalar(a);this.constant*=a;return this},negate:function(){this.constant*=-1;this.normal.negate();return this},distanceToPoint:function(a){return this.normal.dot(a)+this.constant},distanceToSphere:function(a){return this.distanceToPoint(a.center)-a.radius},projectPoint:function(a,
b){return this.orthoPoint(a,b).sub(a).negate()},orthoPoint:function(a,b){var c=this.distanceToPoint(a);return(b||new THREE.Vector3).copy(this.normal).multiplyScalar(c)},intersectLine:function(){var a=new THREE.Vector3;return function(b,c){var d=c||new THREE.Vector3,e=b.delta(a),f=this.normal.dot(e);if(0===f){if(0===this.distanceToPoint(b.start))return d.copy(b.start)}else return f=-(b.start.dot(this.normal)+this.constant)/f,0>f||1<f?void 0:d.copy(e).multiplyScalar(f).add(b.start)}}(),intersectsLine:function(a){var b=
this.distanceToPoint(a.start);a=this.distanceToPoint(a.end);return 0>b&&0<a||0>a&&0<b},intersectsBox:function(a){return a.intersectsPlane(this)},intersectsSphere:function(a){return a.intersectsPlane(this)},coplanarPoint:function(a){return(a||new THREE.Vector3).copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(){var a=new THREE.Vector3,b=new THREE.Matrix3;return function(c,d){var e=this.coplanarPoint(a).applyMatrix4(c),f=d||b.getNormalMatrix(c),f=this.normal.applyMatrix3(f).normalize();
this.constant=-e.dot(f);return this}}(),translate:function(a){this.constant-=a.dot(this.normal);return this},equals:function(a){return a.normal.equals(this.normal)&&a.constant===this.constant}};THREE.Spherical=function(a,b,c){this.radius=void 0!==a?a:1;this.phi=void 0!==b?b:0;this.theta=void 0!==c?c:0;return this};
THREE.Spherical.prototype={constructor:THREE.Spherical,set:function(a,b,c){this.radius=a;this.phi=b;this.theta=c},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.radius.copy(a.radius);this.phi.copy(a.phi);this.theta.copy(a.theta);return this},makeSafe:function(){this.phi=Math.max(1E-6,Math.min(Math.PI-1E-6,this.phi))},setFromVector3:function(a){this.radius=a.length();0===this.radius?this.phi=this.theta=0:(this.theta=Math.atan2(a.x,a.z),this.phi=Math.acos(THREE.Math.clamp(a.y/
this.radius,-1,1)));return this}};
THREE.Math={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){var a="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),b=Array(36),c=0,d;return function(){for(var e=0;36>e;e++)8===e||13===e||18===e||23===e?b[e]="-":14===e?b[e]="4":(2>=c&&(c=33554432+16777216*Math.random()|0),d=c&15,c>>=4,b[e]=a[19===e?d&3|8:d]);return b.join("")}}(),clamp:function(a,b,c){return Math.max(b,Math.min(c,a))},euclideanModulo:function(a,b){return(a%b+b)%b},mapLinear:function(a,b,c,
d,e){return d+(a-b)*(e-d)/(c-b)},smoothstep:function(a,b,c){if(a<=b)return 0;if(a>=c)return 1;a=(a-b)/(c-b);return a*a*(3-2*a)},smootherstep:function(a,b,c){if(a<=b)return 0;if(a>=c)return 1;a=(a-b)/(c-b);return a*a*a*(a*(6*a-15)+10)},random16:function(){console.warn("THREE.Math.random16() has been deprecated. Use Math.random() instead.");return Math.random()},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*
(.5-Math.random())},degToRad:function(a){return a*THREE.Math.DEG2RAD},radToDeg:function(a){return a*THREE.Math.RAD2DEG},isPowerOfTwo:function(a){return 0===(a&a-1)&&0!==a},nearestPowerOfTwo:function(a){return Math.pow(2,Math.round(Math.log(a)/Math.LN2))},nextPowerOfTwo:function(a){a--;a|=a>>1;a|=a>>2;a|=a>>4;a|=a>>8;a|=a>>16;a++;return a}};
THREE.Spline=function(a){function b(a,b,c,d,e,f,g){a=.5*(c-a);d=.5*(d-b);return(2*(b-c)+a+d)*g+(-3*(b-c)-2*a-d)*f+a*e+b}this.points=a;var c=[],d={x:0,y:0,z:0},e,f,g,h,k,l,n,p,m;this.initFromArray=function(a){this.points=[];for(var b=0;b<a.length;b++)this.points[b]={x:a[b][0],y:a[b][1],z:a[b][2]}};this.getPoint=function(a){e=(this.points.length-1)*a;f=Math.floor(e);g=e-f;c[0]=0===f?f:f-1;c[1]=f;c[2]=f>this.points.length-2?this.points.length-1:f+1;c[3]=f>this.points.length-3?this.points.length-1:f+
2;l=this.points[c[0]];n=this.points[c[1]];p=this.points[c[2]];m=this.points[c[3]];h=g*g;k=g*h;d.x=b(l.x,n.x,p.x,m.x,g,h,k);d.y=b(l.y,n.y,p.y,m.y,g,h,k);d.z=b(l.z,n.z,p.z,m.z,g,h,k);return d};this.getControlPointsArray=function(){var a,b,c=this.points.length,d=[];for(a=0;a<c;a++)b=this.points[a],d[a]=[b.x,b.y,b.z];return d};this.getLength=function(a){var b,c,d,e=b=b=0,f=new THREE.Vector3,g=new THREE.Vector3,h=[],k=0;h[0]=0;a||(a=100);c=this.points.length*a;f.copy(this.points[0]);for(a=1;a<c;a++)b=
a/c,d=this.getPoint(b),g.copy(d),k+=g.distanceTo(f),f.copy(d),b*=this.points.length-1,b=Math.floor(b),b!==e&&(h[b]=k,e=b);h[h.length]=k;return{chunks:h,total:k}};this.reparametrizeByArcLength=function(a){var b,c,d,e,f,g,h=[],k=new THREE.Vector3,m=this.getLength();h.push(k.copy(this.points[0]).clone());for(b=1;b<this.points.length;b++){c=m.chunks[b]-m.chunks[b-1];g=Math.ceil(a*c/m.total);e=(b-1)/(this.points.length-1);f=b/(this.points.length-1);for(c=1;c<g-1;c++)d=e+1/g*c*(f-e),d=this.getPoint(d),
h.push(k.copy(d).clone());h.push(k.copy(this.points[b]).clone())}this.points=h}};THREE.Triangle=function(a,b,c){this.a=void 0!==a?a:new THREE.Vector3;this.b=void 0!==b?b:new THREE.Vector3;this.c=void 0!==c?c:new THREE.Vector3};THREE.Triangle.normal=function(){var a=new THREE.Vector3;return function(b,c,d,e){e=e||new THREE.Vector3;e.subVectors(d,c);a.subVectors(b,c);e.cross(a);b=e.lengthSq();return 0<b?e.multiplyScalar(1/Math.sqrt(b)):e.set(0,0,0)}}();
THREE.Triangle.barycoordFromPoint=function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Vector3;return function(d,e,f,g,h){a.subVectors(g,e);b.subVectors(f,e);c.subVectors(d,e);d=a.dot(a);e=a.dot(b);f=a.dot(c);var k=b.dot(b);g=b.dot(c);var l=d*k-e*e;h=h||new THREE.Vector3;if(0===l)return h.set(-2,-1,-1);l=1/l;k=(k*f-e*g)*l;d=(d*g-e*f)*l;return h.set(1-k-d,d,k)}}();
THREE.Triangle.containsPoint=function(){var a=new THREE.Vector3;return function(b,c,d,e){b=THREE.Triangle.barycoordFromPoint(b,c,d,e,a);return 0<=b.x&&0<=b.y&&1>=b.x+b.y}}();
THREE.Triangle.prototype={constructor:THREE.Triangle,set:function(a,b,c){this.a.copy(a);this.b.copy(b);this.c.copy(c);return this},setFromPointsAndIndices:function(a,b,c,d){this.a.copy(a[b]);this.b.copy(a[c]);this.c.copy(a[d]);return this},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.a.copy(a.a);this.b.copy(a.b);this.c.copy(a.c);return this},area:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(){a.subVectors(this.c,this.b);b.subVectors(this.a,
this.b);return.5*a.cross(b).length()}}(),midpoint:function(a){return(a||new THREE.Vector3).addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(a){return THREE.Triangle.normal(this.a,this.b,this.c,a)},plane:function(a){return(a||new THREE.Plane).setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(a,b){return THREE.Triangle.barycoordFromPoint(a,this.a,this.b,this.c,b)},containsPoint:function(a){return THREE.Triangle.containsPoint(a,this.a,this.b,this.c)},
closestPointToPoint:function(){var a,b,c,d;return function(e,f){void 0===a&&(a=new THREE.Plane,b=[new THREE.Line3,new THREE.Line3,new THREE.Line3],c=new THREE.Vector3,d=new THREE.Vector3);var g=f||new THREE.Vector3,h=Infinity;a.setFromCoplanarPoints(this.a,this.b,this.c);a.projectPoint(e,c);if(!0===this.containsPoint(c))g.copy(c);else{b[0].set(this.a,this.b);b[1].set(this.b,this.c);b[2].set(this.c,this.a);for(var k=0;k<b.length;k++){b[k].closestPointToPoint(c,!0,d);var l=c.distanceToSquared(d);l<
h&&(h=l,g.copy(d))}}return g}}(),equals:function(a){return a.a.equals(this.a)&&a.b.equals(this.b)&&a.c.equals(this.c)}};THREE.Interpolant=function(a,b,c,d){this.parameterPositions=a;this._cachedIndex=0;this.resultBuffer=void 0!==d?d:new b.constructor(c);this.sampleValues=b;this.valueSize=c};
THREE.Interpolant.prototype={constructor:THREE.Interpolant,evaluate:function(a){var b=this.parameterPositions,c=this._cachedIndex,d=b[c],e=b[c-1];a:{b:{c:{d:if(!(a<d)){for(var f=c+2;;){if(void 0===d){if(a<e)break d;this._cachedIndex=c=b.length;return this.afterEnd_(c-1,a,e)}if(c===f)break;e=d;d=b[++c];if(a<d)break b}d=b.length;break c}if(a>=e)break a;else{f=b[1];a<f&&(c=2,e=f);for(f=c-2;;){if(void 0===e)return this._cachedIndex=0,this.beforeStart_(0,a,d);if(c===f)break;d=e;e=b[--c-1];if(a>=e)break b}d=
c;c=0}}for(;c<d;)e=c+d>>>1,a<b[e]?d=e:c=e+1;d=b[c];e=b[c-1];if(void 0===e)return this._cachedIndex=0,this.beforeStart_(0,a,d);if(void 0===d)return this._cachedIndex=c=b.length,this.afterEnd_(c-1,e,a)}this._cachedIndex=c;this.intervalChanged_(c,e,d)}return this.interpolate_(c,e,a,d)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(a){var b=this.resultBuffer,c=this.sampleValues,d=this.valueSize;a*=d;for(var e=0;e!==d;++e)b[e]=
c[a+e];return b},interpolate_:function(a,b,c,d){throw Error("call to abstract method");},intervalChanged_:function(a,b,c){}};Object.assign(THREE.Interpolant.prototype,{beforeStart_:THREE.Interpolant.prototype.copySampleValue_,afterEnd_:THREE.Interpolant.prototype.copySampleValue_});THREE.CubicInterpolant=function(a,b,c,d){THREE.Interpolant.call(this,a,b,c,d);this._offsetNext=this._weightNext=this._offsetPrev=this._weightPrev=-0};
THREE.CubicInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.CubicInterpolant,DefaultSettings_:{endingStart:THREE.ZeroCurvatureEnding,endingEnd:THREE.ZeroCurvatureEnding},intervalChanged_:function(a,b,c){var d=this.parameterPositions,e=a-2,f=a+1,g=d[e],h=d[f];if(void 0===g)switch(this.getSettings_().endingStart){case THREE.ZeroSlopeEnding:e=a;g=2*b-c;break;case THREE.WrapAroundEnding:e=d.length-2;g=b+d[e]-d[e+1];break;default:e=a,g=c}if(void 0===h)switch(this.getSettings_().endingEnd){case THREE.ZeroSlopeEnding:f=
a;h=2*c-b;break;case THREE.WrapAroundEnding:f=1;h=c+d[1]-d[0];break;default:f=a-1,h=b}a=.5*(c-b);d=this.valueSize;this._weightPrev=a/(b-g);this._weightNext=a/(h-c);this._offsetPrev=e*d;this._offsetNext=f*d},interpolate_:function(a,b,c,d){var e=this.resultBuffer,f=this.sampleValues,g=this.valueSize;a*=g;var h=a-g,k=this._offsetPrev,l=this._offsetNext,n=this._weightPrev,p=this._weightNext,m=(c-b)/(d-b);c=m*m;d=c*m;b=-n*d+2*n*c-n*m;n=(1+n)*d+(-1.5-2*n)*c+(-.5+n)*m+1;m=(-1-p)*d+(1.5+p)*c+.5*m;p=p*d-p*
c;for(c=0;c!==g;++c)e[c]=b*f[k+c]+n*f[h+c]+m*f[a+c]+p*f[l+c];return e}});THREE.DiscreteInterpolant=function(a,b,c,d){THREE.Interpolant.call(this,a,b,c,d)};THREE.DiscreteInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.DiscreteInterpolant,interpolate_:function(a,b,c,d){return this.copySampleValue_(a-1)}});THREE.LinearInterpolant=function(a,b,c,d){THREE.Interpolant.call(this,a,b,c,d)};
THREE.LinearInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.LinearInterpolant,interpolate_:function(a,b,c,d){var e=this.resultBuffer,f=this.sampleValues,g=this.valueSize;a*=g;var h=a-g;b=(c-b)/(d-b);c=1-b;for(d=0;d!==g;++d)e[d]=f[h+d]*c+f[a+d]*b;return e}});THREE.QuaternionLinearInterpolant=function(a,b,c,d){THREE.Interpolant.call(this,a,b,c,d)};
THREE.QuaternionLinearInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.QuaternionLinearInterpolant,interpolate_:function(a,b,c,d){var e=this.resultBuffer,f=this.sampleValues,g=this.valueSize;a*=g;b=(c-b)/(d-b);for(c=a+g;a!==c;a+=4)THREE.Quaternion.slerpFlat(e,0,f,a-g,f,a,b);return e}});THREE.Clock=function(a){this.autoStart=void 0!==a?a:!0;this.elapsedTime=this.oldTime=this.startTime=0;this.running=!1};
THREE.Clock.prototype={constructor:THREE.Clock,start:function(){this.oldTime=this.startTime=(performance||Date).now();this.running=!0},stop:function(){this.getElapsedTime();this.running=!1},getElapsedTime:function(){this.getDelta();return this.elapsedTime},getDelta:function(){var a=0;this.autoStart&&!this.running&&this.start();if(this.running){var b=(performance||Date).now(),a=(b-this.oldTime)/1E3;this.oldTime=b;this.elapsedTime+=a}return a}};THREE.EventDispatcher=function(){};
THREE.EventDispatcher.prototype={constructor:THREE.EventDispatcher,apply:function(a){a.addEventListener=THREE.EventDispatcher.prototype.addEventListener;a.hasEventListener=THREE.EventDispatcher.prototype.hasEventListener;a.removeEventListener=THREE.EventDispatcher.prototype.removeEventListener;a.dispatchEvent=THREE.EventDispatcher.prototype.dispatchEvent},addEventListener:function(a,b){void 0===this._listeners&&(this._listeners={});var c=this._listeners;void 0===c[a]&&(c[a]=[]);-1===c[a].indexOf(b)&&
c[a].push(b)},hasEventListener:function(a,b){if(void 0===this._listeners)return!1;var c=this._listeners;return void 0!==c[a]&&-1!==c[a].indexOf(b)?!0:!1},removeEventListener:function(a,b){if(void 0!==this._listeners){var c=this._listeners[a];if(void 0!==c){var d=c.indexOf(b);-1!==d&&c.splice(d,1)}}},dispatchEvent:function(a){if(void 0!==this._listeners){var b=this._listeners[a.type];if(void 0!==b){a.target=this;for(var c=[],d=b.length,e=0;e<d;e++)c[e]=b[e];for(e=0;e<d;e++)c[e].call(this,a)}}}};
THREE.Layers=function(){this.mask=1};THREE.Layers.prototype={constructor:THREE.Layers,set:function(a){this.mask=1<<a},enable:function(a){this.mask|=1<<a},toggle:function(a){this.mask^=1<<a},disable:function(a){this.mask&=~(1<<a)},test:function(a){return 0!==(this.mask&a.mask)}};
(function(a){function b(a,b){return a.distance-b.distance}function c(a,b,f,g){if(!1!==a.visible&&(a.raycast(b,f),!0===g)){a=a.children;g=0;for(var h=a.length;g<h;g++)c(a[g],b,f,!0)}}a.Raycaster=function(b,c,f,g){this.ray=new a.Ray(b,c);this.near=f||0;this.far=g||Infinity;this.params={Mesh:{},Line:{},LOD:{},Points:{threshold:1},Sprite:{}};Object.defineProperties(this.params,{PointCloud:{get:function(){console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points.");return this.Points}}})};
a.Raycaster.prototype={constructor:a.Raycaster,linePrecision:1,set:function(a,b){this.ray.set(a,b)},setFromCamera:function(b,c){c instanceof a.PerspectiveCamera?(this.ray.origin.setFromMatrixPosition(c.matrixWorld),this.ray.direction.set(b.x,b.y,.5).unproject(c).sub(this.ray.origin).normalize()):c instanceof a.OrthographicCamera?(this.ray.origin.set(b.x,b.y,-1).unproject(c),this.ray.direction.set(0,0,-1).transformDirection(c.matrixWorld)):console.error("THREE.Raycaster: Unsupported camera type.")},
intersectObject:function(a,e){var f=[];c(a,this,f,e);f.sort(b);return f},intersectObjects:function(a,e){var f=[];if(!1===Array.isArray(a))return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),f;for(var g=0,h=a.length;g<h;g++)c(a[g],this,f,e);f.sort(b);return f}}})(THREE);
THREE.Object3D=function(){Object.defineProperty(this,"id",{value:THREE.Object3DIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="Object3D";this.parent=null;this.children=[];this.up=THREE.Object3D.DefaultUp.clone();var a=new THREE.Vector3,b=new THREE.Euler,c=new THREE.Quaternion,d=new THREE.Vector3(1,1,1);b.onChange(function(){c.setFromEuler(b,!1)});c.onChange(function(){b.setFromQuaternion(c,void 0,!1)});Object.defineProperties(this,{position:{enumerable:!0,value:a},rotation:{enumerable:!0,
value:b},quaternion:{enumerable:!0,value:c},scale:{enumerable:!0,value:d},modelViewMatrix:{value:new THREE.Matrix4},normalMatrix:{value:new THREE.Matrix3}});this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixAutoUpdate=THREE.Object3D.DefaultMatrixAutoUpdate;this.matrixWorldNeedsUpdate=!1;this.layers=new THREE.Layers;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this.renderOrder=0;this.userData={}};
THREE.Object3D.DefaultUp=new THREE.Vector3(0,1,0);THREE.Object3D.DefaultMatrixAutoUpdate=!0;
THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(a){this.matrix.multiplyMatrices(a,this.matrix);this.matrix.decompose(this.position,this.quaternion,this.scale)},setRotationFromAxisAngle:function(a,b){this.quaternion.setFromAxisAngle(a,b)},setRotationFromEuler:function(a){this.quaternion.setFromEuler(a,!0)},setRotationFromMatrix:function(a){this.quaternion.setFromRotationMatrix(a)},setRotationFromQuaternion:function(a){this.quaternion.copy(a)},rotateOnAxis:function(){var a=
new THREE.Quaternion;return function(b,c){a.setFromAxisAngle(b,c);this.quaternion.multiply(a);return this}}(),rotateX:function(){var a=new THREE.Vector3(1,0,0);return function(b){return this.rotateOnAxis(a,b)}}(),rotateY:function(){var a=new THREE.Vector3(0,1,0);return function(b){return this.rotateOnAxis(a,b)}}(),rotateZ:function(){var a=new THREE.Vector3(0,0,1);return function(b){return this.rotateOnAxis(a,b)}}(),translateOnAxis:function(){var a=new THREE.Vector3;return function(b,c){a.copy(b).applyQuaternion(this.quaternion);
this.position.add(a.multiplyScalar(c));return this}}(),translateX:function(){var a=new THREE.Vector3(1,0,0);return function(b){return this.translateOnAxis(a,b)}}(),translateY:function(){var a=new THREE.Vector3(0,1,0);return function(b){return this.translateOnAxis(a,b)}}(),translateZ:function(){var a=new THREE.Vector3(0,0,1);return function(b){return this.translateOnAxis(a,b)}}(),localToWorld:function(a){return a.applyMatrix4(this.matrixWorld)},worldToLocal:function(){var a=new THREE.Matrix4;return function(b){return b.applyMatrix4(a.getInverse(this.matrixWorld))}}(),
lookAt:function(){var a=new THREE.Matrix4;return function(b){a.lookAt(b,this.position,this.up);this.quaternion.setFromRotationMatrix(a)}}(),add:function(a){if(1<arguments.length){for(var b=0;b<arguments.length;b++)this.add(arguments[b]);return this}if(a===this)return console.error("THREE.Object3D.add: object can't be added as a child of itself.",a),this;a instanceof THREE.Object3D?(null!==a.parent&&a.parent.remove(a),a.parent=this,a.dispatchEvent({type:"added"}),this.children.push(a)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",
a);return this},remove:function(a){if(1<arguments.length)for(var b=0;b<arguments.length;b++)this.remove(arguments[b]);b=this.children.indexOf(a);-1!==b&&(a.parent=null,a.dispatchEvent({type:"removed"}),this.children.splice(b,1))},getObjectById:function(a){return this.getObjectByProperty("id",a)},getObjectByName:function(a){return this.getObjectByProperty("name",a)},getObjectByProperty:function(a,b){if(this[a]===b)return this;for(var c=0,d=this.children.length;c<d;c++){var e=this.children[c].getObjectByProperty(a,
b);if(void 0!==e)return e}},getWorldPosition:function(a){a=a||new THREE.Vector3;this.updateMatrixWorld(!0);return a.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c){c=c||new THREE.Quaternion;this.updateMatrixWorld(!0);this.matrixWorld.decompose(a,c,b);return c}}(),getWorldRotation:function(){var a=new THREE.Quaternion;return function(b){b=b||new THREE.Euler;this.getWorldQuaternion(a);return b.setFromQuaternion(a,
this.rotation.order,!1)}}(),getWorldScale:function(){var a=new THREE.Vector3,b=new THREE.Quaternion;return function(c){c=c||new THREE.Vector3;this.updateMatrixWorld(!0);this.matrixWorld.decompose(a,b,c);return c}}(),getWorldDirection:function(){var a=new THREE.Quaternion;return function(b){b=b||new THREE.Vector3;this.getWorldQuaternion(a);return b.set(0,0,1).applyQuaternion(a)}}(),raycast:function(){},traverse:function(a){a(this);for(var b=this.children,c=0,d=b.length;c<d;c++)b[c].traverse(a)},traverseVisible:function(a){if(!1!==
this.visible){a(this);for(var b=this.children,c=0,d=b.length;c<d;c++)b[c].traverseVisible(a)}},traverseAncestors:function(a){var b=this.parent;null!==b&&(a(b),b.traverseAncestors(a))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale);this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){!0===this.matrixAutoUpdate&&this.updateMatrix();if(!0===this.matrixWorldNeedsUpdate||!0===a)null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,
this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)},toJSON:function(a){function b(a){var b=[],c;for(c in a){var d=a[c];delete d.metadata;b.push(d)}return b}var c=void 0===a||""===a,d={};c&&(a={geometries:{},materials:{},textures:{},images:{}},d.metadata={version:4.4,type:"Object",generator:"Object3D.toJSON"});var e={};e.uuid=this.uuid;e.type=this.type;""!==this.name&&(e.name=this.name);"{}"!==JSON.stringify(this.userData)&&
(e.userData=this.userData);!0===this.castShadow&&(e.castShadow=!0);!0===this.receiveShadow&&(e.receiveShadow=!0);!1===this.visible&&(e.visible=!1);e.matrix=this.matrix.toArray();void 0!==this.geometry&&(void 0===a.geometries[this.geometry.uuid]&&(a.geometries[this.geometry.uuid]=this.geometry.toJSON(a)),e.geometry=this.geometry.uuid);void 0!==this.material&&(void 0===a.materials[this.material.uuid]&&(a.materials[this.material.uuid]=this.material.toJSON(a)),e.material=this.material.uuid);if(0<this.children.length){e.children=
[];for(var f=0;f<this.children.length;f++)e.children.push(this.children[f].toJSON(a).object)}if(c){var c=b(a.geometries),f=b(a.materials),g=b(a.textures);a=b(a.images);0<c.length&&(d.geometries=c);0<f.length&&(d.materials=f);0<g.length&&(d.textures=g);0<a.length&&(d.images=a)}d.object=e;return d},clone:function(a){return(new this.constructor).copy(this,a)},copy:function(a,b){void 0===b&&(b=!0);this.name=a.name;this.up.copy(a.up);this.position.copy(a.position);this.quaternion.copy(a.quaternion);this.scale.copy(a.scale);
this.rotationAutoUpdate=a.rotationAutoUpdate;this.matrix.copy(a.matrix);this.matrixWorld.copy(a.matrixWorld);this.matrixAutoUpdate=a.matrixAutoUpdate;this.matrixWorldNeedsUpdate=a.matrixWorldNeedsUpdate;this.visible=a.visible;this.castShadow=a.castShadow;this.receiveShadow=a.receiveShadow;this.frustumCulled=a.frustumCulled;this.renderOrder=a.renderOrder;this.userData=JSON.parse(JSON.stringify(a.userData));if(!0===b)for(var c=0;c<a.children.length;c++)this.add(a.children[c].clone());return this}};
THREE.EventDispatcher.prototype.apply(THREE.Object3D.prototype);THREE.Object3DIdCount=0;THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=Array.isArray(d)?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=Array.isArray(e)?e:[];this.materialIndex=void 0!==f?f:0};
THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.a=a.a;this.b=a.b;this.c=a.c;this.normal.copy(a.normal);this.color.copy(a.color);this.materialIndex=a.materialIndex;for(var b=0,c=a.vertexNormals.length;b<c;b++)this.vertexNormals[b]=a.vertexNormals[b].clone();b=0;for(c=a.vertexColors.length;b<c;b++)this.vertexColors[b]=a.vertexColors[b].clone();return this}};
THREE.BufferAttribute=function(a,b,c){this.uuid=THREE.Math.generateUUID();this.array=a;this.itemSize=b;this.dynamic=!1;this.updateRange={offset:0,count:-1};this.version=0;this.normalized=!0===c};
THREE.BufferAttribute.prototype={constructor:THREE.BufferAttribute,get count(){return this.array.length/this.itemSize},set needsUpdate(a){!0===a&&this.version++},setDynamic:function(a){this.dynamic=a;return this},copy:function(a){this.array=new a.array.constructor(a.array);this.itemSize=a.itemSize;this.dynamic=a.dynamic;return this},copyAt:function(a,b,c){a*=this.itemSize;c*=b.itemSize;for(var d=0,e=this.itemSize;d<e;d++)this.array[a+d]=b.array[c+d];return this},copyArray:function(a){this.array.set(a);
return this},copyColorsArray:function(a){for(var b=this.array,c=0,d=0,e=a.length;d<e;d++){var f=a[d];void 0===f&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",d),f=new THREE.Color);b[c++]=f.r;b[c++]=f.g;b[c++]=f.b}return this},copyIndicesArray:function(a){for(var b=this.array,c=0,d=0,e=a.length;d<e;d++){var f=a[d];b[c++]=f.a;b[c++]=f.b;b[c++]=f.c}return this},copyVector2sArray:function(a){for(var b=this.array,c=0,d=0,e=a.length;d<e;d++){var f=a[d];void 0===f&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",
d),f=new THREE.Vector2);b[c++]=f.x;b[c++]=f.y}return this},copyVector3sArray:function(a){for(var b=this.array,c=0,d=0,e=a.length;d<e;d++){var f=a[d];void 0===f&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",d),f=new THREE.Vector3);b[c++]=f.x;b[c++]=f.y;b[c++]=f.z}return this},copyVector4sArray:function(a){for(var b=this.array,c=0,d=0,e=a.length;d<e;d++){var f=a[d];void 0===f&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",d),f=new THREE.Vector4);
b[c++]=f.x;b[c++]=f.y;b[c++]=f.z;b[c++]=f.w}return this},set:function(a,b){void 0===b&&(b=0);this.array.set(a,b);return this},getX:function(a){return this.array[a*this.itemSize]},setX:function(a,b){this.array[a*this.itemSize]=b;return this},getY:function(a){return this.array[a*this.itemSize+1]},setY:function(a,b){this.array[a*this.itemSize+1]=b;return this},getZ:function(a){return this.array[a*this.itemSize+2]},setZ:function(a,b){this.array[a*this.itemSize+2]=b;return this},getW:function(a){return this.array[a*
this.itemSize+3]},setW:function(a,b){this.array[a*this.itemSize+3]=b;return this},setXY:function(a,b,c){a*=this.itemSize;this.array[a+0]=b;this.array[a+1]=c;return this},setXYZ:function(a,b,c,d){a*=this.itemSize;this.array[a+0]=b;this.array[a+1]=c;this.array[a+2]=d;return this},setXYZW:function(a,b,c,d,e){a*=this.itemSize;this.array[a+0]=b;this.array[a+1]=c;this.array[a+2]=d;this.array[a+3]=e;return this},clone:function(){return(new this.constructor).copy(this)}};
THREE.Int8Attribute=function(a,b){return new THREE.BufferAttribute(new Int8Array(a),b)};THREE.Uint8Attribute=function(a,b){return new THREE.BufferAttribute(new Uint8Array(a),b)};THREE.Uint8ClampedAttribute=function(a,b){return new THREE.BufferAttribute(new Uint8ClampedArray(a),b)};THREE.Int16Attribute=function(a,b){return new THREE.BufferAttribute(new Int16Array(a),b)};THREE.Uint16Attribute=function(a,b){return new THREE.BufferAttribute(new Uint16Array(a),b)};
THREE.Int32Attribute=function(a,b){return new THREE.BufferAttribute(new Int32Array(a),b)};THREE.Uint32Attribute=function(a,b){return new THREE.BufferAttribute(new Uint32Array(a),b)};THREE.Float32Attribute=function(a,b){return new THREE.BufferAttribute(new Float32Array(a),b)};THREE.Float64Attribute=function(a,b){return new THREE.BufferAttribute(new Float64Array(a),b)};
THREE.DynamicBufferAttribute=function(a,b){console.warn("THREE.DynamicBufferAttribute has been removed. Use new THREE.BufferAttribute().setDynamic( true ) instead.");return(new THREE.BufferAttribute(a,b)).setDynamic(!0)};THREE.InstancedBufferAttribute=function(a,b,c){THREE.BufferAttribute.call(this,a,b);this.meshPerAttribute=c||1};THREE.InstancedBufferAttribute.prototype=Object.create(THREE.BufferAttribute.prototype);THREE.InstancedBufferAttribute.prototype.constructor=THREE.InstancedBufferAttribute;
THREE.InstancedBufferAttribute.prototype.copy=function(a){THREE.BufferAttribute.prototype.copy.call(this,a);this.meshPerAttribute=a.meshPerAttribute;return this};THREE.InterleavedBuffer=function(a,b){this.uuid=THREE.Math.generateUUID();this.array=a;this.stride=b;this.dynamic=!1;this.updateRange={offset:0,count:-1};this.version=0};
THREE.InterleavedBuffer.prototype={constructor:THREE.InterleavedBuffer,get length(){return this.array.length},get count(){return this.array.length/this.stride},set needsUpdate(a){!0===a&&this.version++},setDynamic:function(a){this.dynamic=a;return this},copy:function(a){this.array=new a.array.constructor(a.array);this.stride=a.stride;this.dynamic=a.dynamic;return this},copyAt:function(a,b,c){a*=this.stride;c*=b.stride;for(var d=0,e=this.stride;d<e;d++)this.array[a+d]=b.array[c+d];return this},set:function(a,
b){void 0===b&&(b=0);this.array.set(a,b);return this},clone:function(){return(new this.constructor).copy(this)}};THREE.InstancedInterleavedBuffer=function(a,b,c){THREE.InterleavedBuffer.call(this,a,b);this.meshPerAttribute=c||1};THREE.InstancedInterleavedBuffer.prototype=Object.create(THREE.InterleavedBuffer.prototype);THREE.InstancedInterleavedBuffer.prototype.constructor=THREE.InstancedInterleavedBuffer;
THREE.InstancedInterleavedBuffer.prototype.copy=function(a){THREE.InterleavedBuffer.prototype.copy.call(this,a);this.meshPerAttribute=a.meshPerAttribute;return this};THREE.InterleavedBufferAttribute=function(a,b,c){this.uuid=THREE.Math.generateUUID();this.data=a;this.itemSize=b;this.offset=c};
THREE.InterleavedBufferAttribute.prototype={constructor:THREE.InterleavedBufferAttribute,get length(){console.warn("THREE.BufferAttribute: .length has been deprecated. Please use .count.");return this.array.length},get count(){return this.data.count},setX:function(a,b){this.data.array[a*this.data.stride+this.offset]=b;return this},setY:function(a,b){this.data.array[a*this.data.stride+this.offset+1]=b;return this},setZ:function(a,b){this.data.array[a*this.data.stride+this.offset+2]=b;return this},
setW:function(a,b){this.data.array[a*this.data.stride+this.offset+3]=b;return this},getX:function(a){return this.data.array[a*this.data.stride+this.offset]},getY:function(a){return this.data.array[a*this.data.stride+this.offset+1]},getZ:function(a){return this.data.array[a*this.data.stride+this.offset+2]},getW:function(a){return this.data.array[a*this.data.stride+this.offset+3]},setXY:function(a,b,c){a=a*this.data.stride+this.offset;this.data.array[a+0]=b;this.data.array[a+1]=c;return this},setXYZ:function(a,
b,c,d){a=a*this.data.stride+this.offset;this.data.array[a+0]=b;this.data.array[a+1]=c;this.data.array[a+2]=d;return this},setXYZW:function(a,b,c,d,e){a=a*this.data.stride+this.offset;this.data.array[a+0]=b;this.data.array[a+1]=c;this.data.array[a+2]=d;this.data.array[a+3]=e;return this}};
THREE.Geometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="Geometry";this.vertices=[];this.colors=[];this.faces=[];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphNormals=[];this.skinWeights=[];this.skinIndices=[];this.lineDistances=[];this.boundingSphere=this.boundingBox=null;this.groupsNeedUpdate=this.lineDistancesNeedUpdate=this.colorsNeedUpdate=this.normalsNeedUpdate=this.uvsNeedUpdate=this.elementsNeedUpdate=
this.verticesNeedUpdate=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){for(var b=(new THREE.Matrix3).getNormalMatrix(a),c=0,d=this.vertices.length;c<d;c++)this.vertices[c].applyMatrix4(a);c=0;for(d=this.faces.length;c<d;c++){a=this.faces[c];a.normal.applyMatrix3(b).normalize();for(var e=0,f=a.vertexNormals.length;e<f;e++)a.vertexNormals[e].applyMatrix3(b).normalize()}null!==this.boundingBox&&this.computeBoundingBox();null!==this.boundingSphere&&this.computeBoundingSphere();this.normalsNeedUpdate=
this.verticesNeedUpdate=!0;return this},rotateX:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.makeRotationX(b);this.applyMatrix(a);return this}}(),rotateY:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.makeRotationY(b);this.applyMatrix(a);return this}}(),rotateZ:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.makeRotationZ(b);this.applyMatrix(a);return this}}(),translate:function(){var a;return function(b,c,d){void 0===a&&
(a=new THREE.Matrix4);a.makeTranslation(b,c,d);this.applyMatrix(a);return this}}(),scale:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Matrix4);a.makeScale(b,c,d);this.applyMatrix(a);return this}}(),lookAt:function(){var a;return function(b){void 0===a&&(a=new THREE.Object3D);a.lookAt(b);a.updateMatrix();this.applyMatrix(a.matrix)}}(),fromBufferGeometry:function(a){function b(a,b,d,e){var f=void 0!==g?[n[a].clone(),n[b].clone(),n[d].clone()]:[],q=void 0!==h?[c.colors[a].clone(),
c.colors[b].clone(),c.colors[d].clone()]:[];e=new THREE.Face3(a,b,d,f,q,e);c.faces.push(e);void 0!==k&&c.faceVertexUvs[0].push([p[a].clone(),p[b].clone(),p[d].clone()]);void 0!==l&&c.faceVertexUvs[1].push([m[a].clone(),m[b].clone(),m[d].clone()])}var c=this,d=null!==a.index?a.index.array:void 0,e=a.attributes,f=e.position.array,g=void 0!==e.normal?e.normal.array:void 0,h=void 0!==e.color?e.color.array:void 0,k=void 0!==e.uv?e.uv.array:void 0,l=void 0!==e.uv2?e.uv2.array:void 0;void 0!==l&&(this.faceVertexUvs[1]=
[]);for(var n=[],p=[],m=[],q=e=0;e<f.length;e+=3,q+=2)c.vertices.push(new THREE.Vector3(f[e],f[e+1],f[e+2])),void 0!==g&&n.push(new THREE.Vector3(g[e],g[e+1],g[e+2])),void 0!==h&&c.colors.push(new THREE.Color(h[e],h[e+1],h[e+2])),void 0!==k&&p.push(new THREE.Vector2(k[q],k[q+1])),void 0!==l&&m.push(new THREE.Vector2(l[q],l[q+1]));if(void 0!==d)if(f=a.groups,0<f.length)for(e=0;e<f.length;e++)for(var r=f[e],s=r.start,u=r.count,q=s,s=s+u;q<s;q+=3)b(d[q],d[q+1],d[q+2],r.materialIndex);else for(e=0;e<
d.length;e+=3)b(d[e],d[e+1],d[e+2]);else for(e=0;e<f.length/3;e+=3)b(e,e+1,e+2);this.computeFaceNormals();null!==a.boundingBox&&(this.boundingBox=a.boundingBox.clone());null!==a.boundingSphere&&(this.boundingSphere=a.boundingSphere.clone());return this},center:function(){this.computeBoundingBox();var a=this.boundingBox.center().negate();this.translate(a.x,a.y,a.z);return a},normalize:function(){this.computeBoundingSphere();var a=this.boundingSphere.center,b=this.boundingSphere.radius,b=0===b?1:1/
b,c=new THREE.Matrix4;c.set(b,0,0,-b*a.x,0,b,0,-b*a.y,0,0,b,-b*a.z,0,0,0,1);this.applyMatrix(c);return this},computeFaceNormals:function(){for(var a=new THREE.Vector3,b=new THREE.Vector3,c=0,d=this.faces.length;c<d;c++){var e=this.faces[c],f=this.vertices[e.a],g=this.vertices[e.b];a.subVectors(this.vertices[e.c],g);b.subVectors(f,g);a.cross(b);a.normalize();e.normal.copy(a)}},computeVertexNormals:function(a){void 0===a&&(a=!0);var b,c,d;d=Array(this.vertices.length);b=0;for(c=this.vertices.length;b<
c;b++)d[b]=new THREE.Vector3;if(a){var e,f,g,h=new THREE.Vector3,k=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],e=this.vertices[c.a],f=this.vertices[c.b],g=this.vertices[c.c],h.subVectors(g,f),k.subVectors(e,f),h.cross(k),d[c.a].add(h),d[c.b].add(h),d[c.c].add(h)}else for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],d[c.a].add(c.normal),d[c.b].add(c.normal),d[c.c].add(c.normal);b=0;for(c=this.vertices.length;b<c;b++)d[b].normalize();a=0;for(b=this.faces.length;a<b;a++)c=
this.faces[a],e=c.vertexNormals,3===e.length?(e[0].copy(d[c.a]),e[1].copy(d[c.b]),e[2].copy(d[c.c])):(e[0]=d[c.a].clone(),e[1]=d[c.b].clone(),e[2]=d[c.c].clone());0<this.faces.length&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var a,b,c,d,e;c=0;for(d=this.faces.length;c<d;c++)for(e=this.faces[c],e.__originalFaceNormal?e.__originalFaceNormal.copy(e.normal):e.__originalFaceNormal=e.normal.clone(),e.__originalVertexNormals||(e.__originalVertexNormals=[]),a=0,b=e.vertexNormals.length;a<
b;a++)e.__originalVertexNormals[a]?e.__originalVertexNormals[a].copy(e.vertexNormals[a]):e.__originalVertexNormals[a]=e.vertexNormals[a].clone();var f=new THREE.Geometry;f.faces=this.faces;a=0;for(b=this.morphTargets.length;a<b;a++){if(!this.morphNormals[a]){this.morphNormals[a]={};this.morphNormals[a].faceNormals=[];this.morphNormals[a].vertexNormals=[];e=this.morphNormals[a].faceNormals;var g=this.morphNormals[a].vertexNormals,h,k;c=0;for(d=this.faces.length;c<d;c++)h=new THREE.Vector3,k={a:new THREE.Vector3,
b:new THREE.Vector3,c:new THREE.Vector3},e.push(h),g.push(k)}g=this.morphNormals[a];f.vertices=this.morphTargets[a].vertices;f.computeFaceNormals();f.computeVertexNormals();c=0;for(d=this.faces.length;c<d;c++)e=this.faces[c],h=g.faceNormals[c],k=g.vertexNormals[c],h.copy(e.normal),k.a.copy(e.vertexNormals[0]),k.b.copy(e.vertexNormals[1]),k.c.copy(e.vertexNormals[2])}c=0;for(d=this.faces.length;c<d;c++)e=this.faces[c],e.normal=e.__originalFaceNormal,e.vertexNormals=e.__originalVertexNormals},computeTangents:function(){console.warn("THREE.Geometry: .computeTangents() has been removed.")},
computeLineDistances:function(){for(var a=0,b=this.vertices,c=0,d=b.length;c<d;c++)0<c&&(a+=b[c].distanceTo(b[c-1])),this.lineDistances[c]=a},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new THREE.Box3);this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new THREE.Sphere);this.boundingSphere.setFromPoints(this.vertices)},merge:function(a,b,c){if(!1===a instanceof THREE.Geometry)console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",
a);else{var d,e=this.vertices.length,f=this.vertices,g=a.vertices,h=this.faces,k=a.faces,l=this.faceVertexUvs[0];a=a.faceVertexUvs[0];void 0===c&&(c=0);void 0!==b&&(d=(new THREE.Matrix3).getNormalMatrix(b));for(var n=0,p=g.length;n<p;n++){var m=g[n].clone();void 0!==b&&m.applyMatrix4(b);f.push(m)}n=0;for(p=k.length;n<p;n++){var g=k[n],q,r=g.vertexNormals,s=g.vertexColors,m=new THREE.Face3(g.a+e,g.b+e,g.c+e);m.normal.copy(g.normal);void 0!==d&&m.normal.applyMatrix3(d).normalize();b=0;for(f=r.length;b<
f;b++)q=r[b].clone(),void 0!==d&&q.applyMatrix3(d).normalize(),m.vertexNormals.push(q);m.color.copy(g.color);b=0;for(f=s.length;b<f;b++)q=s[b],m.vertexColors.push(q.clone());m.materialIndex=g.materialIndex+c;h.push(m)}n=0;for(p=a.length;n<p;n++)if(c=a[n],d=[],void 0!==c){b=0;for(f=c.length;b<f;b++)d.push(c[b].clone());l.push(d)}}},mergeMesh:function(a){!1===a instanceof THREE.Mesh?console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",a):(a.matrixAutoUpdate&&a.updateMatrix(),
this.merge(a.geometry,a.matrix))},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,4),f,g;f=0;for(g=this.vertices.length;f<g;f++)d=this.vertices[f],d=Math.round(d.x*e)+"_"+Math.round(d.y*e)+"_"+Math.round(d.z*e),void 0===a[d]?(a[d]=f,b.push(this.vertices[f]),c[f]=b.length-1):c[f]=c[a[d]];a=[];f=0;for(g=this.faces.length;f<g;f++)for(e=this.faces[f],e.a=c[e.a],e.b=c[e.b],e.c=c[e.c],e=[e.a,e.b,e.c],d=0;3>d;d++)if(e[d]===e[(d+1)%3]){a.push(f);break}for(f=a.length-1;0<=f;f--)for(e=a[f],this.faces.splice(e,
1),c=0,g=this.faceVertexUvs.length;c<g;c++)this.faceVertexUvs[c].splice(e,1);f=this.vertices.length-b.length;this.vertices=b;return f},sortFacesByMaterialIndex:function(){for(var a=this.faces,b=a.length,c=0;c<b;c++)a[c]._id=c;a.sort(function(a,b){return a.materialIndex-b.materialIndex});var d=this.faceVertexUvs[0],e=this.faceVertexUvs[1],f,g;d&&d.length===b&&(f=[]);e&&e.length===b&&(g=[]);for(c=0;c<b;c++){var h=a[c]._id;f&&f.push(d[h]);g&&g.push(e[h])}f&&(this.faceVertexUvs[0]=f);g&&(this.faceVertexUvs[1]=
g)},toJSON:function(){function a(a,b,c){return c?a|1<<b:a&~(1<<b)}function b(a){var b=a.x.toString()+a.y.toString()+a.z.toString();if(void 0!==l[b])return l[b];l[b]=k.length/3;k.push(a.x,a.y,a.z);return l[b]}function c(a){var b=a.r.toString()+a.g.toString()+a.b.toString();if(void 0!==p[b])return p[b];p[b]=n.length;n.push(a.getHex());return p[b]}function d(a){var b=a.x.toString()+a.y.toString();if(void 0!==q[b])return q[b];q[b]=m.length/2;m.push(a.x,a.y);return q[b]}var e={metadata:{version:4.4,type:"Geometry",
generator:"Geometry.toJSON"}};e.uuid=this.uuid;e.type=this.type;""!==this.name&&(e.name=this.name);if(void 0!==this.parameters){var f=this.parameters,g;for(g in f)void 0!==f[g]&&(e[g]=f[g]);return e}f=[];for(g=0;g<this.vertices.length;g++){var h=this.vertices[g];f.push(h.x,h.y,h.z)}var h=[],k=[],l={},n=[],p={},m=[],q={};for(g=0;g<this.faces.length;g++){var r=this.faces[g],s=void 0!==this.faceVertexUvs[0][g],u=0<r.normal.length(),v=0<r.vertexNormals.length,x=1!==r.color.r||1!==r.color.g||1!==r.color.b,
A=0<r.vertexColors.length,w=0,w=a(w,0,0),w=a(w,1,!0),w=a(w,2,!1),w=a(w,3,s),w=a(w,4,u),w=a(w,5,v),w=a(w,6,x),w=a(w,7,A);h.push(w);h.push(r.a,r.b,r.c);h.push(r.materialIndex);s&&(s=this.faceVertexUvs[0][g],h.push(d(s[0]),d(s[1]),d(s[2])));u&&h.push(b(r.normal));v&&(u=r.vertexNormals,h.push(b(u[0]),b(u[1]),b(u[2])));x&&h.push(c(r.color));A&&(r=r.vertexColors,h.push(c(r[0]),c(r[1]),c(r[2])))}e.data={};e.data.vertices=f;e.data.normals=k;0<n.length&&(e.data.colors=n);0<m.length&&(e.data.uvs=[m]);e.data.faces=
h;return e},clone:function(){return(new THREE.Geometry).copy(this)},copy:function(a){this.vertices=[];this.faces=[];this.faceVertexUvs=[[]];for(var b=a.vertices,c=0,d=b.length;c<d;c++)this.vertices.push(b[c].clone());b=a.faces;c=0;for(d=b.length;c<d;c++)this.faces.push(b[c].clone());c=0;for(d=a.faceVertexUvs.length;c<d;c++){b=a.faceVertexUvs[c];void 0===this.faceVertexUvs[c]&&(this.faceVertexUvs[c]=[]);for(var e=0,f=b.length;e<f;e++){for(var g=b[e],h=[],k=0,l=g.length;k<l;k++)h.push(g[k].clone());
this.faceVertexUvs[c].push(h)}}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.Geometry.prototype);THREE.GeometryIdCount=0;
THREE.DirectGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="DirectGeometry";this.indices=[];this.vertices=[];this.normals=[];this.colors=[];this.uvs=[];this.uvs2=[];this.groups=[];this.morphTargets={};this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.groupsNeedUpdate=this.uvsNeedUpdate=this.colorsNeedUpdate=this.normalsNeedUpdate=this.verticesNeedUpdate=!1};
THREE.DirectGeometry.prototype={constructor:THREE.DirectGeometry,computeBoundingBox:THREE.Geometry.prototype.computeBoundingBox,computeBoundingSphere:THREE.Geometry.prototype.computeBoundingSphere,computeFaceNormals:function(){console.warn("THREE.DirectGeometry: computeFaceNormals() is not a method of this type of geometry.")},computeVertexNormals:function(){console.warn("THREE.DirectGeometry: computeVertexNormals() is not a method of this type of geometry.")},computeGroups:function(a){var b,c=[],
d;a=a.faces;for(var e=0;e<a.length;e++){var f=a[e];f.materialIndex!==d&&(d=f.materialIndex,void 0!==b&&(b.count=3*e-b.start,c.push(b)),b={start:3*e,materialIndex:d})}void 0!==b&&(b.count=3*e-b.start,c.push(b));this.groups=c},fromGeometry:function(a){var b=a.faces,c=a.vertices,d=a.faceVertexUvs,e=d[0]&&0<d[0].length,f=d[1]&&0<d[1].length,g=a.morphTargets,h=g.length,k;if(0<h){k=[];for(var l=0;l<h;l++)k[l]=[];this.morphTargets.position=k}var n=a.morphNormals,p=n.length,m;if(0<p){m=[];for(l=0;l<p;l++)m[l]=
[];this.morphTargets.normal=m}for(var q=a.skinIndices,r=a.skinWeights,s=q.length===c.length,u=r.length===c.length,l=0;l<b.length;l++){var v=b[l];this.vertices.push(c[v.a],c[v.b],c[v.c]);var x=v.vertexNormals;3===x.length?this.normals.push(x[0],x[1],x[2]):(x=v.normal,this.normals.push(x,x,x));x=v.vertexColors;3===x.length?this.colors.push(x[0],x[1],x[2]):(x=v.color,this.colors.push(x,x,x));!0===e&&(x=d[0][l],void 0!==x?this.uvs.push(x[0],x[1],x[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",
l),this.uvs.push(new THREE.Vector2,new THREE.Vector2,new THREE.Vector2)));!0===f&&(x=d[1][l],void 0!==x?this.uvs2.push(x[0],x[1],x[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",l),this.uvs2.push(new THREE.Vector2,new THREE.Vector2,new THREE.Vector2)));for(x=0;x<h;x++){var A=g[x].vertices;k[x].push(A[v.a],A[v.b],A[v.c])}for(x=0;x<p;x++)A=n[x].vertexNormals[l],m[x].push(A.a,A.b,A.c);s&&this.skinIndices.push(q[v.a],q[v.b],q[v.c]);u&&this.skinWeights.push(r[v.a],r[v.b],
r[v.c])}this.computeGroups(a);this.verticesNeedUpdate=a.verticesNeedUpdate;this.normalsNeedUpdate=a.normalsNeedUpdate;this.colorsNeedUpdate=a.colorsNeedUpdate;this.uvsNeedUpdate=a.uvsNeedUpdate;this.groupsNeedUpdate=a.groupsNeedUpdate;return this},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.DirectGeometry.prototype);
THREE.BufferGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="BufferGeometry";this.index=null;this.attributes={};this.morphAttributes={};this.groups=[];this.boundingSphere=this.boundingBox=null;this.drawRange={start:0,count:Infinity}};
THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,getIndex:function(){return this.index},setIndex:function(a){this.index=a},addAttribute:function(a,b,c){if(!1===b instanceof THREE.BufferAttribute&&!1===b instanceof THREE.InterleavedBufferAttribute)console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),this.addAttribute(a,new THREE.BufferAttribute(b,c));else if("index"===a)console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),
this.setIndex(b);else return this.attributes[a]=b,this},getAttribute:function(a){return this.attributes[a]},removeAttribute:function(a){delete this.attributes[a];return this},addGroup:function(a,b,c){this.groups.push({start:a,count:b,materialIndex:void 0!==c?c:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(a,b){this.drawRange.start=a;this.drawRange.count=b},applyMatrix:function(a){var b=this.attributes.position;void 0!==b&&(a.applyToVector3Array(b.array),b.needsUpdate=!0);b=this.attributes.normal;
void 0!==b&&((new THREE.Matrix3).getNormalMatrix(a).applyToVector3Array(b.array),b.needsUpdate=!0);null!==this.boundingBox&&this.computeBoundingBox();null!==this.boundingSphere&&this.computeBoundingSphere();return this},rotateX:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.makeRotationX(b);this.applyMatrix(a);return this}}(),rotateY:function(){var a;return function(b){void 0===a&&(a=new THREE.Matrix4);a.makeRotationY(b);this.applyMatrix(a);return this}}(),rotateZ:function(){var a;
return function(b){void 0===a&&(a=new THREE.Matrix4);a.makeRotationZ(b);this.applyMatrix(a);return this}}(),translate:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Matrix4);a.makeTranslation(b,c,d);this.applyMatrix(a);return this}}(),scale:function(){var a;return function(b,c,d){void 0===a&&(a=new THREE.Matrix4);a.makeScale(b,c,d);this.applyMatrix(a);return this}}(),lookAt:function(){var a;return function(b){void 0===a&&(a=new THREE.Object3D);a.lookAt(b);a.updateMatrix();this.applyMatrix(a.matrix)}}(),
center:function(){this.computeBoundingBox();var a=this.boundingBox.center().negate();this.translate(a.x,a.y,a.z);return a},setFromObject:function(a){var b=a.geometry;if(a instanceof THREE.Points||a instanceof THREE.Line){a=new THREE.Float32Attribute(3*b.vertices.length,3);var c=new THREE.Float32Attribute(3*b.colors.length,3);this.addAttribute("position",a.copyVector3sArray(b.vertices));this.addAttribute("color",c.copyColorsArray(b.colors));b.lineDistances&&b.lineDistances.length===b.vertices.length&&
(a=new THREE.Float32Attribute(b.lineDistances.length,1),this.addAttribute("lineDistance",a.copyArray(b.lineDistances)));null!==b.boundingSphere&&(this.boundingSphere=b.boundingSphere.clone());null!==b.boundingBox&&(this.boundingBox=b.boundingBox.clone())}else a instanceof THREE.Mesh&&b instanceof THREE.Geometry&&this.fromGeometry(b);return this},updateFromObject:function(a){var b=a.geometry;if(a instanceof THREE.Mesh){var c=b.__directGeometry;if(void 0===c)return this.fromGeometry(b);c.verticesNeedUpdate=
b.verticesNeedUpdate;c.normalsNeedUpdate=b.normalsNeedUpdate;c.colorsNeedUpdate=b.colorsNeedUpdate;c.uvsNeedUpdate=b.uvsNeedUpdate;c.groupsNeedUpdate=b.groupsNeedUpdate;b.verticesNeedUpdate=!1;b.normalsNeedUpdate=!1;b.colorsNeedUpdate=!1;b.uvsNeedUpdate=!1;b.groupsNeedUpdate=!1;b=c}!0===b.verticesNeedUpdate&&(c=this.attributes.position,void 0!==c&&(c.copyVector3sArray(b.vertices),c.needsUpdate=!0),b.verticesNeedUpdate=!1);!0===b.normalsNeedUpdate&&(c=this.attributes.normal,void 0!==c&&(c.copyVector3sArray(b.normals),
c.needsUpdate=!0),b.normalsNeedUpdate=!1);!0===b.colorsNeedUpdate&&(c=this.attributes.color,void 0!==c&&(c.copyColorsArray(b.colors),c.needsUpdate=!0),b.colorsNeedUpdate=!1);b.uvsNeedUpdate&&(c=this.attributes.uv,void 0!==c&&(c.copyVector2sArray(b.uvs),c.needsUpdate=!0),b.uvsNeedUpdate=!1);b.lineDistancesNeedUpdate&&(c=this.attributes.lineDistance,void 0!==c&&(c.copyArray(b.lineDistances),c.needsUpdate=!0),b.lineDistancesNeedUpdate=!1);b.groupsNeedUpdate&&(b.computeGroups(a.geometry),this.groups=
b.groups,b.groupsNeedUpdate=!1);return this},fromGeometry:function(a){a.__directGeometry=(new THREE.DirectGeometry).fromGeometry(a);return this.fromDirectGeometry(a.__directGeometry)},fromDirectGeometry:function(a){var b=new Float32Array(3*a.vertices.length);this.addAttribute("position",(new THREE.BufferAttribute(b,3)).copyVector3sArray(a.vertices));0<a.normals.length&&(b=new Float32Array(3*a.normals.length),this.addAttribute("normal",(new THREE.BufferAttribute(b,3)).copyVector3sArray(a.normals)));
0<a.colors.length&&(b=new Float32Array(3*a.colors.length),this.addAttribute("color",(new THREE.BufferAttribute(b,3)).copyColorsArray(a.colors)));0<a.uvs.length&&(b=new Float32Array(2*a.uvs.length),this.addAttribute("uv",(new THREE.BufferAttribute(b,2)).copyVector2sArray(a.uvs)));0<a.uvs2.length&&(b=new Float32Array(2*a.uvs2.length),this.addAttribute("uv2",(new THREE.BufferAttribute(b,2)).copyVector2sArray(a.uvs2)));0<a.indices.length&&(b=new (65535<a.vertices.length?Uint32Array:Uint16Array)(3*a.indices.length),
this.setIndex((new THREE.BufferAttribute(b,1)).copyIndicesArray(a.indices)));this.groups=a.groups;for(var c in a.morphTargets){for(var b=[],d=a.morphTargets[c],e=0,f=d.length;e<f;e++){var g=d[e],h=new THREE.Float32Attribute(3*g.length,3);b.push(h.copyVector3sArray(g))}this.morphAttributes[c]=b}0<a.skinIndices.length&&(c=new THREE.Float32Attribute(4*a.skinIndices.length,4),this.addAttribute("skinIndex",c.copyVector4sArray(a.skinIndices)));0<a.skinWeights.length&&(c=new THREE.Float32Attribute(4*a.skinWeights.length,
4),this.addAttribute("skinWeight",c.copyVector4sArray(a.skinWeights)));null!==a.boundingSphere&&(this.boundingSphere=a.boundingSphere.clone());null!==a.boundingBox&&(this.boundingBox=a.boundingBox.clone());return this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new THREE.Box3);var a=this.attributes.position.array;void 0!==a?this.boundingBox.setFromArray(a):this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&
console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){var a=new THREE.Box3,b=new THREE.Vector3;return function(){null===this.boundingSphere&&(this.boundingSphere=new THREE.Sphere);var c=this.attributes.position.array;if(c){var d=this.boundingSphere.center;a.setFromArray(c);a.center(d);for(var e=0,f=0,g=c.length;f<g;f+=3)b.fromArray(c,f),e=Math.max(e,d.distanceToSquared(b));
this.boundingSphere.radius=Math.sqrt(e);isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}}(),computeFaceNormals:function(){},computeVertexNormals:function(){var a=this.index,b=this.attributes,c=this.groups;if(b.position){var d=b.position.array;if(void 0===b.normal)this.addAttribute("normal",new THREE.BufferAttribute(new Float32Array(d.length),3));else for(var e=b.normal.array,
f=0,g=e.length;f<g;f++)e[f]=0;var e=b.normal.array,h,k,l,n=new THREE.Vector3,p=new THREE.Vector3,m=new THREE.Vector3,q=new THREE.Vector3,r=new THREE.Vector3;if(a){a=a.array;0===c.length&&this.addGroup(0,a.length);for(var s=0,u=c.length;s<u;++s)for(f=c[s],g=f.start,h=f.count,f=g,g+=h;f<g;f+=3)h=3*a[f+0],k=3*a[f+1],l=3*a[f+2],n.fromArray(d,h),p.fromArray(d,k),m.fromArray(d,l),q.subVectors(m,p),r.subVectors(n,p),q.cross(r),e[h]+=q.x,e[h+1]+=q.y,e[h+2]+=q.z,e[k]+=q.x,e[k+1]+=q.y,e[k+2]+=q.z,e[l]+=q.x,
e[l+1]+=q.y,e[l+2]+=q.z}else for(f=0,g=d.length;f<g;f+=9)n.fromArray(d,f),p.fromArray(d,f+3),m.fromArray(d,f+6),q.subVectors(m,p),r.subVectors(n,p),q.cross(r),e[f]=q.x,e[f+1]=q.y,e[f+2]=q.z,e[f+3]=q.x,e[f+4]=q.y,e[f+5]=q.z,e[f+6]=q.x,e[f+7]=q.y,e[f+8]=q.z;this.normalizeNormals();b.normal.needsUpdate=!0}},merge:function(a,b){if(!1===a instanceof THREE.BufferGeometry)console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",a);else{void 0===b&&(b=0);var c=this.attributes,
d;for(d in c)if(void 0!==a.attributes[d])for(var e=c[d].array,f=a.attributes[d],g=f.array,h=0,f=f.itemSize*b;h<g.length;h++,f++)e[f]=g[h];return this}},normalizeNormals:function(){for(var a=this.attributes.normal.array,b,c,d,e=0,f=a.length;e<f;e+=3)b=a[e],c=a[e+1],d=a[e+2],b=1/Math.sqrt(b*b+c*c+d*d),a[e]*=b,a[e+1]*=b,a[e+2]*=b},toNonIndexed:function(){if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var a=new THREE.BufferGeometry,
b=this.index.array,c=this.attributes,d;for(d in c){for(var e=c[d],f=e.array,e=e.itemSize,g=new f.constructor(b.length*e),h=0,k=0,l=0,n=b.length;l<n;l++)for(var h=b[l]*e,p=0;p<e;p++)g[k++]=f[h++];a.addAttribute(d,new THREE.BufferAttribute(g,e))}return a},toJSON:function(){var a={metadata:{version:4.4,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};a.uuid=this.uuid;a.type=this.type;""!==this.name&&(a.name=this.name);if(void 0!==this.parameters){var b=this.parameters,c;for(c in b)void 0!==
b[c]&&(a[c]=b[c]);return a}a.data={attributes:{}};var d=this.index;null!==d&&(b=Array.prototype.slice.call(d.array),a.data.index={type:d.array.constructor.name,array:b});d=this.attributes;for(c in d){var e=d[c],b=Array.prototype.slice.call(e.array);a.data.attributes[c]={itemSize:e.itemSize,type:e.array.constructor.name,array:b,normalized:e.normalized}}c=this.groups;0<c.length&&(a.data.groups=JSON.parse(JSON.stringify(c)));c=this.boundingSphere;null!==c&&(a.data.boundingSphere={center:c.center.toArray(),
radius:c.radius});return a},clone:function(){return(new THREE.BufferGeometry).copy(this)},copy:function(a){var b=a.index;null!==b&&this.setIndex(b.clone());var b=a.attributes,c;for(c in b)this.addAttribute(c,b[c].clone());a=a.groups;c=0;for(b=a.length;c<b;c++){var d=a[c];this.addGroup(d.start,d.count,d.materialIndex)}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.BufferGeometry.prototype);THREE.BufferGeometry.MaxIndex=65535;
THREE.InstancedBufferGeometry=function(){THREE.BufferGeometry.call(this);this.type="InstancedBufferGeometry";this.maxInstancedCount=void 0};THREE.InstancedBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.InstancedBufferGeometry.prototype.constructor=THREE.InstancedBufferGeometry;THREE.InstancedBufferGeometry.prototype.addGroup=function(a,b,c){this.groups.push({start:a,count:b,instances:c})};
THREE.InstancedBufferGeometry.prototype.copy=function(a){var b=a.index;null!==b&&this.setIndex(b.clone());var b=a.attributes,c;for(c in b)this.addAttribute(c,b[c].clone());a=a.groups;c=0;for(b=a.length;c<b;c++){var d=a[c];this.addGroup(d.start,d.count,d.instances)}return this};THREE.EventDispatcher.prototype.apply(THREE.InstancedBufferGeometry.prototype);
THREE.Uniform=function(a,b){"string"===typeof a&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),a=b);this.value=a;this.dynamic=!1};THREE.Uniform.prototype={constructor:THREE.Uniform,onUpdate:function(a){this.dynamic=!0;this.onUpdateCallback=a;return this}};THREE.AnimationClip=function(a,b,c){this.name=a||THREE.Math.generateUUID();this.tracks=c;this.duration=void 0!==b?b:-1;0>this.duration&&this.resetDuration();this.trim();this.optimize()};
THREE.AnimationClip.prototype={constructor:THREE.AnimationClip,resetDuration:function(){for(var a=0,b=0,c=this.tracks.length;b!==c;++b)var d=this.tracks[b],a=Math.max(a,d.times[d.times.length-1]);this.duration=a},trim:function(){for(var a=0;a<this.tracks.length;a++)this.tracks[a].trim(0,this.duration);return this},optimize:function(){for(var a=0;a<this.tracks.length;a++)this.tracks[a].optimize();return this}};
Object.assign(THREE.AnimationClip,{parse:function(a){for(var b=[],c=a.tracks,d=1/(a.fps||1),e=0,f=c.length;e!==f;++e)b.push(THREE.KeyframeTrack.parse(c[e]).scale(d));return new THREE.AnimationClip(a.name,a.duration,b)},toJSON:function(a){var b=[],c=a.tracks;a={name:a.name,duration:a.duration,tracks:b};for(var d=0,e=c.length;d!==e;++d)b.push(THREE.KeyframeTrack.toJSON(c[d]));return a},CreateFromMorphTargetSequence:function(a,b,c,d){for(var e=b.length,f=[],g=0;g<e;g++){var h=[],k=[];h.push((g+e-1)%
e,g,(g+1)%e);k.push(0,1,0);var l=THREE.AnimationUtils.getKeyframeOrder(h),h=THREE.AnimationUtils.sortedArray(h,1,l),k=THREE.AnimationUtils.sortedArray(k,1,l);d||0!==h[0]||(h.push(e),k.push(k[0]));f.push((new THREE.NumberKeyframeTrack(".morphTargetInfluences["+b[g].name+"]",h,k)).scale(1/c))}return new THREE.AnimationClip(a,-1,f)},findByName:function(a,b){for(var c=0;c<a.length;c++)if(a[c].name===b)return a[c];return null},CreateClipsFromMorphTargetSequences:function(a,b,c){for(var d={},e=/^([\w-]*?)([\d]+)$/,
f=0,g=a.length;f<g;f++){var h=a[f],k=h.name.match(e);if(k&&1<k.length){var l=k[1];(k=d[l])||(d[l]=k=[]);k.push(h)}}a=[];for(l in d)a.push(THREE.AnimationClip.CreateFromMorphTargetSequence(l,d[l],b,c));return a},parseAnimation:function(a,b,c){if(!a)return console.error("  no animation in JSONLoader data"),null;c=function(a,b,c,d,e){if(0!==c.length){var f=[],g=[];THREE.AnimationUtils.flattenJSON(c,f,g,d);0!==f.length&&e.push(new a(b,f,g))}};var d=[],e=a.name||"default",f=a.length||-1,g=a.fps||30;a=
a.hierarchy||[];for(var h=0;h<a.length;h++){var k=a[h].keys;if(k&&0!=k.length)if(k[0].morphTargets){for(var f={},l=0;l<k.length;l++)if(k[l].morphTargets)for(var n=0;n<k[l].morphTargets.length;n++)f[k[l].morphTargets[n]]=-1;for(var p in f){for(var m=[],q=[],n=0;n!==k[l].morphTargets.length;++n){var r=k[l];m.push(r.time);q.push(r.morphTarget===p?1:0)}d.push(new THREE.NumberKeyframeTrack(".morphTargetInfluence["+p+"]",m,q))}f=f.length*(g||1)}else l=".bones["+b[h].name+"]",c(THREE.VectorKeyframeTrack,
l+".position",k,"pos",d),c(THREE.QuaternionKeyframeTrack,l+".quaternion",k,"rot",d),c(THREE.VectorKeyframeTrack,l+".scale",k,"scl",d)}return 0===d.length?null:new THREE.AnimationClip(e,f,d)}});THREE.AnimationMixer=function(a){this._root=a;this._initMemoryManager();this.time=this._accuIndex=0;this.timeScale=1};
THREE.AnimationMixer.prototype={constructor:THREE.AnimationMixer,clipAction:function(a,b){var c=(b||this._root).uuid,d="string"===typeof a?a:a.name,e=a!==d?a:null,f=this._actionsByClip[d],g;if(void 0!==f){g=f.actionByRoot[c];if(void 0!==g)return g;g=f.knownActions[0];e=g._clip;if(a!==d&&a!==e)throw Error("Different clips with the same name detected!");}if(null===e)return null;f=new THREE.AnimationMixer._Action(this,e,b);this._bindAction(f,g);this._addInactiveAction(f,d,c);return f},existingAction:function(a,
b){var c=(b||this._root).uuid,d=this._actionsByClip["string"===typeof a?a:a.name];return void 0!==d?d.actionByRoot[c]||null:null},stopAllAction:function(){for(var a=this._actions,b=this._nActiveActions,c=this._bindings,d=this._nActiveBindings,e=this._nActiveBindings=this._nActiveActions=0;e!==b;++e)a[e].reset();for(e=0;e!==d;++e)c[e].useCount=0;return this},update:function(a){a*=this.timeScale;for(var b=this._actions,c=this._nActiveActions,d=this.time+=a,e=Math.sign(a),f=this._accuIndex^=1,g=0;g!==
c;++g){var h=b[g];h.enabled&&h._update(d,a,e,f)}a=this._bindings;b=this._nActiveBindings;for(g=0;g!==b;++g)a[g].apply(f);return this},getRoot:function(){return this._root},uncacheClip:function(a){var b=this._actions;a=a.name;var c=this._actionsByClip,d=c[a];if(void 0!==d){for(var d=d.knownActions,e=0,f=d.length;e!==f;++e){var g=d[e];this._deactivateAction(g);var h=g._cacheIndex,k=b[b.length-1];g._cacheIndex=null;g._byClipCacheIndex=null;k._cacheIndex=h;b[h]=k;b.pop();this._removeInactiveBindingsForAction(g)}delete c[a]}},
uncacheRoot:function(a){a=a.uuid;var b=this._actionsByClip,c;for(c in b){var d=b[c].actionByRoot[a];void 0!==d&&(this._deactivateAction(d),this._removeInactiveAction(d))}c=this._bindingsByRootAndName[a];if(void 0!==c)for(var e in c)a=c[e],a.restoreOriginalState(),this._removeInactiveBinding(a)},uncacheAction:function(a,b){var c=this.existingAction(a,b);null!==c&&(this._deactivateAction(c),this._removeInactiveAction(c))}};THREE.EventDispatcher.prototype.apply(THREE.AnimationMixer.prototype);
THREE.AnimationMixer._Action=function(a,b,c){this._mixer=a;this._clip=b;this._localRoot=c||null;a=b.tracks;b=a.length;c=Array(b);for(var d={endingStart:THREE.ZeroCurvatureEnding,endingEnd:THREE.ZeroCurvatureEnding},e=0;e!==b;++e){var f=a[e].createInterpolant(null);c[e]=f;f.settings=d}this._interpolantSettings=d;this._interpolants=c;this._propertyBindings=Array(b);this._weightInterpolant=this._timeScaleInterpolant=this._byClipCacheIndex=this._cacheIndex=null;this.loop=THREE.LoopRepeat;this._loopCount=
-1;this._startTime=null;this.time=0;this._effectiveWeight=this.weight=this._effectiveTimeScale=this.timeScale=1;this.repetitions=Infinity;this.paused=!1;this.enabled=!0;this.clampWhenFinished=!1;this.zeroSlopeAtEnd=this.zeroSlopeAtStart=!0};
THREE.AnimationMixer._Action.prototype={constructor:THREE.AnimationMixer._Action,play:function(){this._mixer._activateAction(this);return this},stop:function(){this._mixer._deactivateAction(this);return this.reset()},reset:function(){this.paused=!1;this.enabled=!0;this.time=0;this._loopCount=-1;this._startTime=null;return this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},
startAt:function(a){this._startTime=a;return this},setLoop:function(a,b){this.loop=a;this.repetitions=b;return this},setEffectiveWeight:function(a){this.weight=a;this._effectiveWeight=this.enabled?a:0;return this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(a){return this._scheduleFading(a,0,1)},fadeOut:function(a){return this._scheduleFading(a,1,0)},crossFadeFrom:function(a,b,c){a.fadeOut(b);this.fadeIn(b);if(c){c=this._clip.duration;var d=a._clip.duration,
e=c/d;a.warp(1,d/c,b);this.warp(e,1,b)}return this},crossFadeTo:function(a,b,c){return a.crossFadeFrom(this,b,c)},stopFading:function(){var a=this._weightInterpolant;null!==a&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(a));return this},setEffectiveTimeScale:function(a){this.timeScale=a;this._effectiveTimeScale=this.paused?0:a;return this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(a){this.timeScale=this._clip.duration/
a;return this.stopWarping()},syncWith:function(a){this.time=a.time;this.timeScale=a.timeScale;return this.stopWarping()},halt:function(a){return this.warp(this._currentTimeScale,0,a)},warp:function(a,b,c){var d=this._mixer,e=d.time,f=this._timeScaleInterpolant,g=this.timeScale;null===f&&(this._timeScaleInterpolant=f=d._lendControlInterpolant());d=f.parameterPositions;f=f.sampleValues;d[0]=e;d[1]=e+c;f[0]=a/g;f[1]=b/g;return this},stopWarping:function(){var a=this._timeScaleInterpolant;null!==a&&(this._timeScaleInterpolant=
null,this._mixer._takeBackControlInterpolant(a));return this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(a,b,c,d){var e=this._startTime;if(null!==e){b=(a-e)*c;if(0>b||0===c)return;this._startTime=null;b*=c}b*=this._updateTimeScale(a);c=this._updateTime(b);a=this._updateWeight(a);if(0<a){b=this._interpolants;for(var e=this._propertyBindings,f=0,g=b.length;f!==g;++f)b[f].evaluate(c),e[f].accumulate(d,
a)}},_updateWeight:function(a){var b=0;if(this.enabled){var b=this.weight,c=this._weightInterpolant;if(null!==c){var d=c.evaluate(a)[0],b=b*d;a>c.parameterPositions[1]&&(this.stopFading(),0===d&&(this.enabled=!1))}}return this._effectiveWeight=b},_updateTimeScale:function(a){var b=0;if(!this.paused){var b=this.timeScale,c=this._timeScaleInterpolant;if(null!==c){var d=c.evaluate(a)[0],b=b*d;a>c.parameterPositions[1]&&(this.stopWarping(),0===b?this.pause=!0:this.timeScale=b)}}return this._effectiveTimeScale=
b},_updateTime:function(a){var b=this.time+a;if(0===a)return b;var c=this._clip.duration,d=this.loop,e=this._loopCount,f=!1;switch(d){case THREE.LoopOnce:-1===e&&(this.loopCount=0,this._setEndings(!0,!0,!1));if(b>=c)b=c;else if(0>b)b=0;else break;this.clampWhenFinished?this.pause=!0:this.enabled=!1;this._mixer.dispatchEvent({type:"finished",action:this,direction:0>a?-1:1});break;case THREE.LoopPingPong:f=!0;case THREE.LoopRepeat:-1===e&&(0<a?(e=0,this._setEndings(!0,0===this.repetitions,f)):this._setEndings(0===
this.repetitions,!0,f));if(b>=c||0>b){var g=Math.floor(b/c),b=b-c*g,e=e+Math.abs(g),h=this.repetitions-e;if(0>h){this.clampWhenFinished?this.paused=!0:this.enabled=!1;b=0<a?c:0;this._mixer.dispatchEvent({type:"finished",action:this,direction:0<a?1:-1});break}else 0===h?(a=0>a,this._setEndings(a,!a,f)):this._setEndings(!1,!1,f);this._loopCount=e;this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:g})}if(d===THREE.LoopPingPong&&1===(e&1))return this.time=b,c-b}return this.time=b},_setEndings:function(a,
b,c){var d=this._interpolantSettings;c?(d.endingStart=THREE.ZeroSlopeEnding,d.endingEnd=THREE.ZeroSlopeEnding):(d.endingStart=a?this.zeroSlopeAtStart?THREE.ZeroSlopeEnding:THREE.ZeroCurvatureEnding:THREE.WrapAroundEnding,d.endingEnd=b?this.zeroSlopeAtEnd?THREE.ZeroSlopeEnding:THREE.ZeroCurvatureEnding:THREE.WrapAroundEnding)},_scheduleFading:function(a,b,c){var d=this._mixer,e=d.time,f=this._weightInterpolant;null===f&&(this._weightInterpolant=f=d._lendControlInterpolant());d=f.parameterPositions;
f=f.sampleValues;d[0]=e;f[0]=b;d[1]=e+a;f[1]=c;return this}};
Object.assign(THREE.AnimationMixer.prototype,{_bindAction:function(a,b){var c=a._localRoot||this._root,d=a._clip.tracks,e=d.length,f=a._propertyBindings,g=a._interpolants,h=c.uuid,k=this._bindingsByRootAndName,l=k[h];void 0===l&&(l={},k[h]=l);for(k=0;k!==e;++k){var n=d[k],p=n.name,m=l[p];if(void 0===m){m=f[k];if(void 0!==m){null===m._cacheIndex&&(++m.referenceCount,this._addInactiveBinding(m,h,p));continue}m=new THREE.PropertyMixer(THREE.PropertyBinding.create(c,p,b&&b._propertyBindings[k].binding.parsedPath),
n.ValueTypeName,n.getValueSize());++m.referenceCount;this._addInactiveBinding(m,h,p)}f[k]=m;g[k].resultBuffer=m.buffer}},_activateAction:function(a){if(!this._isActiveAction(a)){if(null===a._cacheIndex){var b=(a._localRoot||this._root).uuid,c=a._clip.name,d=this._actionsByClip[c];this._bindAction(a,d&&d.knownActions[0]);this._addInactiveAction(a,c,b)}b=a._propertyBindings;c=0;for(d=b.length;c!==d;++c){var e=b[c];0===e.useCount++&&(this._lendBinding(e),e.saveOriginalState())}this._lendAction(a)}},
_deactivateAction:function(a){if(this._isActiveAction(a)){for(var b=a._propertyBindings,c=0,d=b.length;c!==d;++c){var e=b[c];0===--e.useCount&&(e.restoreOriginalState(),this._takeBackBinding(e))}this._takeBackAction(a)}},_initMemoryManager:function(){this._actions=[];this._nActiveActions=0;this._actionsByClip={};this._bindings=[];this._nActiveBindings=0;this._bindingsByRootAndName={};this._controlInterpolants=[];this._nActiveControlInterpolants=0;var a=this;this.stats={actions:{get total(){return a._actions.length},
get inUse(){return a._nActiveActions}},bindings:{get total(){return a._bindings.length},get inUse(){return a._nActiveBindings}},controlInterpolants:{get total(){return a._controlInterpolants.length},get inUse(){return a._nActiveControlInterpolants}}}},_isActiveAction:function(a){a=a._cacheIndex;return null!==a&&a<this._nActiveActions},_addInactiveAction:function(a,b,c){var d=this._actions,e=this._actionsByClip,f=e[b];void 0===f?(f={knownActions:[a],actionByRoot:{}},a._byClipCacheIndex=0,e[b]=f):(b=
f.knownActions,a._byClipCacheIndex=b.length,b.push(a));a._cacheIndex=d.length;d.push(a);f.actionByRoot[c]=a},_removeInactiveAction:function(a){var b=this._actions,c=b[b.length-1],d=a._cacheIndex;c._cacheIndex=d;b[d]=c;b.pop();a._cacheIndex=null;var c=a._clip.name,d=this._actionsByClip,e=d[c],f=e.knownActions,g=f[f.length-1],h=a._byClipCacheIndex;g._byClipCacheIndex=h;f[h]=g;f.pop();a._byClipCacheIndex=null;delete e.actionByRoot[(b._localRoot||this._root).uuid];0===f.length&&delete d[c];this._removeInactiveBindingsForAction(a)},
_removeInactiveBindingsForAction:function(a){a=a._propertyBindings;for(var b=0,c=a.length;b!==c;++b){var d=a[b];0===--d.referenceCount&&this._removeInactiveBinding(d)}},_lendAction:function(a){var b=this._actions,c=a._cacheIndex,d=this._nActiveActions++,e=b[d];a._cacheIndex=d;b[d]=a;e._cacheIndex=c;b[c]=e},_takeBackAction:function(a){var b=this._actions,c=a._cacheIndex,d=--this._nActiveActions,e=b[d];a._cacheIndex=d;b[d]=a;e._cacheIndex=c;b[c]=e},_addInactiveBinding:function(a,b,c){var d=this._bindingsByRootAndName,
e=d[b],f=this._bindings;void 0===e&&(e={},d[b]=e);e[c]=a;a._cacheIndex=f.length;f.push(a)},_removeInactiveBinding:function(a){var b=this._bindings,c=a.binding,d=c.rootNode.uuid,c=c.path,e=this._bindingsByRootAndName,f=e[d],g=b[b.length-1];a=a._cacheIndex;g._cacheIndex=a;b[a]=g;b.pop();delete f[c];a:{for(var h in f)break a;delete e[d]}},_lendBinding:function(a){var b=this._bindings,c=a._cacheIndex,d=this._nActiveBindings++,e=b[d];a._cacheIndex=d;b[d]=a;e._cacheIndex=c;b[c]=e},_takeBackBinding:function(a){var b=
this._bindings,c=a._cacheIndex,d=--this._nActiveBindings,e=b[d];a._cacheIndex=d;b[d]=a;e._cacheIndex=c;b[c]=e},_lendControlInterpolant:function(){var a=this._controlInterpolants,b=this._nActiveControlInterpolants++,c=a[b];void 0===c&&(c=new THREE.LinearInterpolant(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer),c.__cacheIndex=b,a[b]=c);return c},_takeBackControlInterpolant:function(a){var b=this._controlInterpolants,c=a.__cacheIndex,d=--this._nActiveControlInterpolants,
e=b[d];a.__cacheIndex=d;b[d]=a;e.__cacheIndex=c;b[c]=e},_controlInterpolantsResultBuffer:new Float32Array(1)});
THREE.AnimationObjectGroup=function(a){this.uuid=THREE.Math.generateUUID();this._objects=Array.prototype.slice.call(arguments);this.nCachedObjects_=0;var b={};this._indicesByUUID=b;for(var c=0,d=arguments.length;c!==d;++c)b[arguments[c].uuid]=c;this._paths=[];this._parsedPaths=[];this._bindings=[];this._bindingsIndicesByPath={};var e=this;this.stats={objects:{get total(){return e._objects.length},get inUse(){return this.total-e.nCachedObjects_}},get bindingsPerObject(){return e._bindings.length}}};
THREE.AnimationObjectGroup.prototype={constructor:THREE.AnimationObjectGroup,add:function(a){for(var b=this._objects,c=b.length,d=this.nCachedObjects_,e=this._indicesByUUID,f=this._paths,g=this._parsedPaths,h=this._bindings,k=h.length,l=0,n=arguments.length;l!==n;++l){var p=arguments[l],m=p.uuid,q=e[m];if(void 0===q){q=c++;e[m]=q;b.push(p);for(var m=0,r=k;m!==r;++m)h[m].push(new THREE.PropertyBinding(p,f[m],g[m]))}else if(q<d){var s=b[q],u=--d,r=b[u];e[r.uuid]=q;b[q]=r;e[m]=u;b[u]=p;m=0;for(r=k;m!==
r;++m){var v=h[m],x=v[q];v[q]=v[u];void 0===x&&(x=new THREE.PropertyBinding(p,f[m],g[m]));v[u]=x}}else b[q]!==s&&console.error("Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes...")}this.nCachedObjects_=d},remove:function(a){for(var b=this._objects,c=this.nCachedObjects_,d=this._indicesByUUID,e=this._bindings,f=e.length,g=0,h=arguments.length;g!==h;++g){var k=arguments[g],l=k.uuid,n=d[l];if(void 0!==n&&n>=c){var p=c++,m=b[p];d[m.uuid]=
n;b[n]=m;d[l]=p;b[p]=k;k=0;for(l=f;k!==l;++k){var m=e[k],q=m[n];m[n]=m[p];m[p]=q}}}this.nCachedObjects_=c},uncache:function(a){for(var b=this._objects,c=b.length,d=this.nCachedObjects_,e=this._indicesByUUID,f=this._bindings,g=f.length,h=0,k=arguments.length;h!==k;++h){var l=arguments[h].uuid,n=e[l];if(void 0!==n)if(delete e[l],n<d){var l=--d,p=b[l],m=--c,q=b[m];e[p.uuid]=n;b[n]=p;e[q.uuid]=l;b[l]=q;b.pop();p=0;for(q=g;p!==q;++p){var r=f[p],s=r[m];r[n]=r[l];r[l]=s;r.pop()}}else for(m=--c,q=b[m],e[q.uuid]=
n,b[n]=q,b.pop(),p=0,q=g;p!==q;++p)r=f[p],r[n]=r[m],r.pop()}this.nCachedObjects_=d},subscribe_:function(a,b){var c=this._bindingsIndicesByPath,d=c[a],e=this._bindings;if(void 0!==d)return e[d];var f=this._paths,g=this._parsedPaths,h=this._objects,k=this.nCachedObjects_,l=Array(h.length),d=e.length;c[a]=d;f.push(a);g.push(b);e.push(l);c=k;for(d=h.length;c!==d;++c)l[c]=new THREE.PropertyBinding(h[c],a,b);return l},unsubscribe_:function(a){var b=this._bindingsIndicesByPath,c=b[a];if(void 0!==c){var d=
this._paths,e=this._parsedPaths,f=this._bindings,g=f.length-1,h=f[g];b[a[g]]=c;f[c]=h;f.pop();e[c]=e[g];e.pop();d[c]=d[g];d.pop()}}};
THREE.AnimationUtils={arraySlice:function(a,b,c){return THREE.AnimationUtils.isTypedArray(a)?new a.constructor(a.subarray(b,c)):a.slice(b,c)},convertArray:function(a,b,c){return!a||!c&&a.constructor===b?a:"number"===typeof b.BYTES_PER_ELEMENT?new b(a):Array.prototype.slice.call(a)},isTypedArray:function(a){return ArrayBuffer.isView(a)&&!(a instanceof DataView)},getKeyframeOrder:function(a){for(var b=a.length,c=Array(b),d=0;d!==b;++d)c[d]=d;c.sort(function(b,c){return a[b]-a[c]});return c},sortedArray:function(a,
b,c){for(var d=a.length,e=new a.constructor(d),f=0,g=0;g!==d;++f)for(var h=c[f]*b,k=0;k!==b;++k)e[g++]=a[h+k];return e},flattenJSON:function(a,b,c,d){for(var e=1,f=a[0];void 0!==f&&void 0===f[d];)f=a[e++];if(void 0!==f){var g=f[d];if(void 0!==g)if(Array.isArray(g)){do g=f[d],void 0!==g&&(b.push(f.time),c.push.apply(c,g)),f=a[e++];while(void 0!==f)}else if(void 0!==g.toArray){do g=f[d],void 0!==g&&(b.push(f.time),g.toArray(c,c.length)),f=a[e++];while(void 0!==f)}else{do g=f[d],void 0!==g&&(b.push(f.time),
c.push(g)),f=a[e++];while(void 0!==f)}}}};THREE.KeyframeTrack=function(a,b,c,d){if(void 0===a)throw Error("track name is undefined");if(void 0===b||0===b.length)throw Error("no keyframes in track named "+a);this.name=a;this.times=THREE.AnimationUtils.convertArray(b,this.TimeBufferType);this.values=THREE.AnimationUtils.convertArray(c,this.ValueBufferType);this.setInterpolation(d||this.DefaultInterpolation);this.validate();this.optimize()};
THREE.KeyframeTrack.prototype={constructor:THREE.KeyframeTrack,TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:THREE.InterpolateLinear,InterpolantFactoryMethodDiscrete:function(a){return new THREE.DiscreteInterpolant(this.times,this.values,this.getValueSize(),a)},InterpolantFactoryMethodLinear:function(a){return new THREE.LinearInterpolant(this.times,this.values,this.getValueSize(),a)},InterpolantFactoryMethodSmooth:function(a){return new THREE.CubicInterpolant(this.times,
this.values,this.getValueSize(),a)},setInterpolation:function(a){var b=void 0;switch(a){case THREE.InterpolateDiscrete:b=this.InterpolantFactoryMethodDiscrete;break;case THREE.InterpolateLinear:b=this.InterpolantFactoryMethodLinear;break;case THREE.InterpolateSmooth:b=this.InterpolantFactoryMethodSmooth}if(void 0===b){b="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant)if(a!==this.DefaultInterpolation)this.setInterpolation(this.DefaultInterpolation);
else throw Error(b);console.warn(b)}else this.createInterpolant=b},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return THREE.InterpolateDiscrete;case this.InterpolantFactoryMethodLinear:return THREE.InterpolateLinear;case this.InterpolantFactoryMethodSmooth:return THREE.InterpolateSmooth}},getValueSize:function(){return this.values.length/this.times.length},shift:function(a){if(0!==a)for(var b=this.times,c=0,d=b.length;c!==d;++c)b[c]+=a;return this},
scale:function(a){if(1!==a)for(var b=this.times,c=0,d=b.length;c!==d;++c)b[c]*=a;return this},trim:function(a,b){for(var c=this.times,d=c.length,e=0,f=d-1;e!==d&&c[e]<a;)++e;for(;-1!==f&&c[f]>b;)--f;++f;if(0!==e||f!==d)e>=f&&(f=Math.max(f,1),e=f-1),d=this.getValueSize(),this.times=THREE.AnimationUtils.arraySlice(c,e,f),this.values=THREE.AnimationUtils.arraySlice(this.values,e*d,f*d);return this},validate:function(){var a=!0,b=this.getValueSize();0!==b-Math.floor(b)&&(console.error("invalid value size in track",
this),a=!1);var c=this.times,b=this.values,d=c.length;0===d&&(console.error("track is empty",this),a=!1);for(var e=null,f=0;f!==d;f++){var g=c[f];if("number"===typeof g&&isNaN(g)){console.error("time is not a valid number",this,f,g);a=!1;break}if(null!==e&&e>g){console.error("out of order keys",this,f,g,e);a=!1;break}e=g}if(void 0!==b&&THREE.AnimationUtils.isTypedArray(b))for(f=0,c=b.length;f!==c;++f)if(d=b[f],isNaN(d)){console.error("value is not a valid number",this,f,d);a=!1;break}return a},optimize:function(){for(var a=
this.times,b=this.values,c=this.getValueSize(),d=1,e=1,f=a.length-1;e<=f;++e){var g=!1,h=a[e];if(h!==a[e+1]&&(1!==e||h!==h[0]))for(var k=e*c,l=k-c,n=k+c,h=0;h!==c;++h){var p=b[k+h];if(p!==b[l+h]||p!==b[n+h]){g=!0;break}}if(g){if(e!==d)for(a[d]=a[e],g=e*c,k=d*c,h=0;h!==c;++h)b[k+h]=b[g+h];++d}}d!==a.length&&(this.times=THREE.AnimationUtils.arraySlice(a,0,d),this.values=THREE.AnimationUtils.arraySlice(b,0,d*c));return this}};
Object.assign(THREE.KeyframeTrack,{parse:function(a){if(void 0===a.type)throw Error("track type undefined, can not parse");var b=THREE.KeyframeTrack._getTrackTypeForValueTypeName(a.type);if(void 0===a.times){console.warn("legacy JSON format detected, converting");var c=[],d=[];THREE.AnimationUtils.flattenJSON(a.keys,c,d,"value");a.times=c;a.values=d}return void 0!==b.parse?b.parse(a):new b(a.name,a.times,a.values,a.interpolation)},toJSON:function(a){var b=a.constructor;if(void 0!==b.toJSON)b=b.toJSON(a);
else{var b={name:a.name,times:THREE.AnimationUtils.convertArray(a.times,Array),values:THREE.AnimationUtils.convertArray(a.values,Array)},c=a.getInterpolation();c!==a.DefaultInterpolation&&(b.interpolation=c)}b.type=a.ValueTypeName;return b},_getTrackTypeForValueTypeName:function(a){switch(a.toLowerCase()){case "scalar":case "double":case "float":case "number":case "integer":return THREE.NumberKeyframeTrack;case "vector":case "vector2":case "vector3":case "vector4":return THREE.VectorKeyframeTrack;
case "color":return THREE.ColorKeyframeTrack;case "quaternion":return THREE.QuaternionKeyframeTrack;case "bool":case "boolean":return THREE.BooleanKeyframeTrack;case "string":return THREE.StringKeyframeTrack}throw Error("Unsupported typeName: "+a);}});THREE.PropertyBinding=function(a,b,c){this.path=b;this.parsedPath=c||THREE.PropertyBinding.parseTrackName(b);this.node=THREE.PropertyBinding.findNode(a,this.parsedPath.nodeName)||a;this.rootNode=a};
THREE.PropertyBinding.prototype={constructor:THREE.PropertyBinding,getValue:function(a,b){this.bind();this.getValue(a,b)},setValue:function(a,b){this.bind();this.setValue(a,b)},bind:function(){var a=this.node,b=this.parsedPath,c=b.objectName,d=b.propertyName,e=b.propertyIndex;a||(this.node=a=THREE.PropertyBinding.findNode(this.rootNode,b.nodeName)||this.rootNode);this.getValue=this._getValue_unavailable;this.setValue=this._setValue_unavailable;if(a){if(c){var f=b.objectIndex;switch(c){case "materials":if(!a.material){console.error("  can not bind to material as node does not have a material",
this);return}if(!a.material.materials){console.error("  can not bind to material.materials as node.material does not have a materials array",this);return}a=a.material.materials;break;case "bones":if(!a.skeleton){console.error("  can not bind to bones as node does not have a skeleton",this);return}a=a.skeleton.bones;for(c=0;c<a.length;c++)if(a[c].name===f){f=c;break}break;default:if(void 0===a[c]){console.error("  can not bind to objectName of node, undefined",this);return}a=a[c]}if(void 0!==f){if(void 0===
a[f]){console.error("  trying to bind to objectIndex of objectName, but is undefined:",this,a);return}a=a[f]}}if(f=a[d]){b=this.Versioning.None;void 0!==a.needsUpdate?(b=this.Versioning.NeedsUpdate,this.targetObject=a):void 0!==a.matrixWorldNeedsUpdate&&(b=this.Versioning.MatrixWorldNeedsUpdate,this.targetObject=a);c=this.BindingType.Direct;if(void 0!==e){if("morphTargetInfluences"===d){if(!a.geometry){console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry",
this);return}if(!a.geometry.morphTargets){console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry.morphTargets",this);return}for(c=0;c<this.node.geometry.morphTargets.length;c++)if(a.geometry.morphTargets[c].name===e){e=c;break}}c=this.BindingType.ArrayElement;this.resolvedProperty=f;this.propertyIndex=e}else void 0!==f.fromArray&&void 0!==f.toArray?(c=this.BindingType.HasFromToArray,this.resolvedProperty=f):void 0!==f.length?(c=this.BindingType.EntireArray,this.resolvedProperty=
f):this.propertyName=d;this.getValue=this.GetterByBindingType[c];this.setValue=this.SetterByBindingTypeAndVersioning[c][b]}else console.error("  trying to update property for track: "+b.nodeName+"."+d+" but it wasn't found.",a)}else console.error("  trying to update node for track: "+this.path+" but it wasn't found.")},unbind:function(){this.node=null;this.getValue=this._getValue_unbound;this.setValue=this._setValue_unbound}};
Object.assign(THREE.PropertyBinding.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},_getValue_unbound:THREE.PropertyBinding.prototype.getValue,_setValue_unbound:THREE.PropertyBinding.prototype.setValue,BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(a,b){a[b]=this.node[this.propertyName]},function(a,b){for(var c=this.resolvedProperty,d=0,e=c.length;d!==e;++d)a[b++]=
c[d]},function(a,b){a[b]=this.resolvedProperty[this.propertyIndex]},function(a,b){this.resolvedProperty.toArray(a,b)}],SetterByBindingTypeAndVersioning:[[function(a,b){this.node[this.propertyName]=a[b]},function(a,b){this.node[this.propertyName]=a[b];this.targetObject.needsUpdate=!0},function(a,b){this.node[this.propertyName]=a[b];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(a,b){for(var c=this.resolvedProperty,d=0,e=c.length;d!==e;++d)c[d]=a[b++]},function(a,b){for(var c=this.resolvedProperty,
d=0,e=c.length;d!==e;++d)c[d]=a[b++];this.targetObject.needsUpdate=!0},function(a,b){for(var c=this.resolvedProperty,d=0,e=c.length;d!==e;++d)c[d]=a[b++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(a,b){this.resolvedProperty[this.propertyIndex]=a[b]},function(a,b){this.resolvedProperty[this.propertyIndex]=a[b];this.targetObject.needsUpdate=!0},function(a,b){this.resolvedProperty[this.propertyIndex]=a[b];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(a,b){this.resolvedProperty.fromArray(a,
b)},function(a,b){this.resolvedProperty.fromArray(a,b);this.targetObject.needsUpdate=!0},function(a,b){this.resolvedProperty.fromArray(a,b);this.targetObject.matrixWorldNeedsUpdate=!0}]]});THREE.PropertyBinding.Composite=function(a,b,c){c=c||THREE.PropertyBinding.parseTrackName(b);this._targetGroup=a;this._bindings=a.subscribe_(b,c)};
THREE.PropertyBinding.Composite.prototype={constructor:THREE.PropertyBinding.Composite,getValue:function(a,b){this.bind();var c=this._bindings[this._targetGroup.nCachedObjects_];void 0!==c&&c.getValue(a,b)},setValue:function(a,b){for(var c=this._bindings,d=this._targetGroup.nCachedObjects_,e=c.length;d!==e;++d)c[d].setValue(a,b)},bind:function(){for(var a=this._bindings,b=this._targetGroup.nCachedObjects_,c=a.length;b!==c;++b)a[b].bind()},unbind:function(){for(var a=this._bindings,b=this._targetGroup.nCachedObjects_,
c=a.length;b!==c;++b)a[b].unbind()}};THREE.PropertyBinding.create=function(a,b,c){return a instanceof THREE.AnimationObjectGroup?new THREE.PropertyBinding.Composite(a,b,c):new THREE.PropertyBinding(a,b,c)};
THREE.PropertyBinding.parseTrackName=function(a){var b=/^(([\w]+\/)*)([\w-\d]+)?(\.([\w]+)(\[([\w\d\[\]\_.:\- ]+)\])?)?(\.([\w.]+)(\[([\w\d\[\]\_. ]+)\])?)$/,c=b.exec(a);if(!c)throw Error("cannot parse trackName at all: "+a);c.index===b.lastIndex&&b.lastIndex++;b={nodeName:c[3],objectName:c[5],objectIndex:c[7],propertyName:c[9],propertyIndex:c[11]};if(null===b.propertyName||0===b.propertyName.length)throw Error("can not parse propertyName from trackName: "+a);return b};
THREE.PropertyBinding.findNode=function(a,b){if(!b||""===b||"root"===b||"."===b||-1===b||b===a.name||b===a.uuid)return a;if(a.skeleton){var c=function(a){for(var c=0;c<a.bones.length;c++){var d=a.bones[c];if(d.name===b)return d}return null}(a.skeleton);if(c)return c}if(a.children){var d=function(a){for(var c=0;c<a.length;c++){var g=a[c];if(g.name===b||g.uuid===b||(g=d(g.children)))return g}return null};if(c=d(a.children))return c}return null};
THREE.PropertyMixer=function(a,b,c){this.binding=a;this.valueSize=c;a=Float64Array;switch(b){case "quaternion":b=this._slerp;break;case "string":case "bool":a=Array;b=this._select;break;default:b=this._lerp}this.buffer=new a(4*c);this._mixBufferRegion=b;this.referenceCount=this.useCount=this.cumulativeWeight=0};
THREE.PropertyMixer.prototype={constructor:THREE.PropertyMixer,accumulate:function(a,b){var c=this.buffer,d=this.valueSize,e=a*d+d,f=this.cumulativeWeight;if(0===f){for(f=0;f!==d;++f)c[e+f]=c[f];f=b}else f+=b,this._mixBufferRegion(c,e,0,b/f,d);this.cumulativeWeight=f},apply:function(a){var b=this.valueSize,c=this.buffer;a=a*b+b;var d=this.cumulativeWeight,e=this.binding;this.cumulativeWeight=0;1>d&&this._mixBufferRegion(c,a,3*b,1-d,b);for(var d=b,f=b+b;d!==f;++d)if(c[d]!==c[d+b]){e.setValue(c,a);
break}},saveOriginalState:function(){var a=this.buffer,b=this.valueSize,c=3*b;this.binding.getValue(a,c);for(var d=b;d!==c;++d)a[d]=a[c+d%b];this.cumulativeWeight=0},restoreOriginalState:function(){this.binding.setValue(this.buffer,3*this.valueSize)},_select:function(a,b,c,d,e){if(.5<=d)for(d=0;d!==e;++d)a[b+d]=a[c+d]},_slerp:function(a,b,c,d,e){THREE.Quaternion.slerpFlat(a,b,a,b,a,c,d)},_lerp:function(a,b,c,d,e){for(var f=1-d,g=0;g!==e;++g){var h=b+g;a[h]=a[h]*f+a[c+g]*d}}};
THREE.BooleanKeyframeTrack=function(a,b,c){THREE.KeyframeTrack.call(this,a,b,c)};THREE.BooleanKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.BooleanKeyframeTrack,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:THREE.InterpolateDiscrete,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0});THREE.ColorKeyframeTrack=function(a,b,c,d){THREE.KeyframeTrack.call(this,a,b,c,d)};
THREE.ColorKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.ColorKeyframeTrack,ValueTypeName:"color"});THREE.NumberKeyframeTrack=function(a,b,c,d){THREE.KeyframeTrack.call(this,a,b,c,d)};THREE.NumberKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.NumberKeyframeTrack,ValueTypeName:"number"});THREE.QuaternionKeyframeTrack=function(a,b,c,d){THREE.KeyframeTrack.call(this,a,b,c,d)};
THREE.QuaternionKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.QuaternionKeyframeTrack,ValueTypeName:"quaternion",DefaultInterpolation:THREE.InterpolateLinear,InterpolantFactoryMethodLinear:function(a){return new THREE.QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),a)},InterpolantFactoryMethodSmooth:void 0});THREE.StringKeyframeTrack=function(a,b,c,d){THREE.KeyframeTrack.call(this,a,b,c,d)};
THREE.StringKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.StringKeyframeTrack,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:THREE.InterpolateDiscrete,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0});THREE.VectorKeyframeTrack=function(a,b,c,d){THREE.KeyframeTrack.call(this,a,b,c,d)};
THREE.VectorKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.VectorKeyframeTrack,ValueTypeName:"vector"});
THREE.Audio=function(a){THREE.Object3D.call(this);this.type="Audio";this.context=a.context;this.source=this.context.createBufferSource();this.source.onended=this.onEnded.bind(this);this.gain=this.context.createGain();this.gain.connect(a.getInput());this.autoplay=!1;this.startTime=0;this.playbackRate=1;this.isPlaying=!1;this.hasPlaybackControl=!0;this.sourceType="empty";this.filter=null};THREE.Audio.prototype=Object.create(THREE.Object3D.prototype);THREE.Audio.prototype.constructor=THREE.Audio;
THREE.Audio.prototype.getOutput=function(){return this.gain};THREE.Audio.prototype.setNodeSource=function(a){this.hasPlaybackControl=!1;this.sourceType="audioNode";this.source=a;this.connect();return this};THREE.Audio.prototype.setBuffer=function(a){this.source.buffer=a;this.sourceType="buffer";this.autoplay&&this.play();return this};
THREE.Audio.prototype.play=function(){if(!0===this.isPlaying)console.warn("THREE.Audio: Audio is already playing.");else if(!1===this.hasPlaybackControl)console.warn("THREE.Audio: this Audio has no playback control.");else{var a=this.context.createBufferSource();a.buffer=this.source.buffer;a.loop=this.source.loop;a.onended=this.source.onended;a.start(0,this.startTime);a.playbackRate.value=this.playbackRate;this.isPlaying=!0;this.source=a;this.connect()}};
THREE.Audio.prototype.pause=function(){!1===this.hasPlaybackControl?console.warn("THREE.Audio: this Audio has no playback control."):(this.source.stop(),this.startTime=this.context.currentTime)};THREE.Audio.prototype.stop=function(){!1===this.hasPlaybackControl?console.warn("THREE.Audio: this Audio has no playback control."):(this.source.stop(),this.startTime=0)};THREE.Audio.prototype.connect=function(){null!==this.filter?(this.source.connect(this.filter),this.filter.connect(this.getOutput())):this.source.connect(this.getOutput())};
THREE.Audio.prototype.disconnect=function(){null!==this.filter?(this.source.disconnect(this.filter),this.filter.disconnect(this.getOutput())):this.source.disconnect(this.getOutput())};THREE.Audio.prototype.getFilter=function(){return this.filter};THREE.Audio.prototype.setFilter=function(a){void 0===a&&(a=null);!0===this.isPlaying?(this.disconnect(),this.filter=a,this.connect()):this.filter=a};
THREE.Audio.prototype.setPlaybackRate=function(a){!1===this.hasPlaybackControl?console.warn("THREE.Audio: this Audio has no playback control."):(this.playbackRate=a,!0===this.isPlaying&&(this.source.playbackRate.value=this.playbackRate))};THREE.Audio.prototype.getPlaybackRate=function(){return this.playbackRate};THREE.Audio.prototype.onEnded=function(){this.isPlaying=!1};
THREE.Audio.prototype.setLoop=function(a){!1===this.hasPlaybackControl?console.warn("THREE.Audio: this Audio has no playback control."):this.source.loop=a};THREE.Audio.prototype.getLoop=function(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.source.loop};THREE.Audio.prototype.setVolume=function(a){this.gain.gain.value=a};THREE.Audio.prototype.getVolume=function(){return this.gain.gain.value};
THREE.AudioAnalyser=function(a,b){this.analyser=a.context.createAnalyser();this.analyser.fftSize=void 0!==b?b:2048;this.data=new Uint8Array(this.analyser.frequencyBinCount);a.getOutput().connect(this.analyser)};THREE.AudioAnalyser.prototype={constructor:THREE.AudioAnalyser,getData:function(){this.analyser.getByteFrequencyData(this.data);return this.data}};
Object.defineProperty(THREE,"AudioContext",{get:function(){var a;return function(){void 0===a&&(a=new (window.AudioContext||window.webkitAudioContext));return a}}()});THREE.PositionalAudio=function(a){THREE.Audio.call(this,a);this.panner=this.context.createPanner();this.panner.connect(this.gain)};THREE.PositionalAudio.prototype=Object.create(THREE.Audio.prototype);THREE.PositionalAudio.prototype.constructor=THREE.PositionalAudio;THREE.PositionalAudio.prototype.getOutput=function(){return this.panner};
THREE.PositionalAudio.prototype.setRefDistance=function(a){this.panner.refDistance=a};THREE.PositionalAudio.prototype.getRefDistance=function(){return this.panner.refDistance};THREE.PositionalAudio.prototype.setRolloffFactor=function(a){this.panner.rolloffFactor=a};THREE.PositionalAudio.prototype.getRolloffFactor=function(){return this.panner.rolloffFactor};THREE.PositionalAudio.prototype.setDistanceModel=function(a){this.panner.distanceModel=a};THREE.PositionalAudio.prototype.getDistanceModel=function(){return this.panner.distanceModel};
THREE.PositionalAudio.prototype.setMaxDistance=function(a){this.panner.maxDistance=a};THREE.PositionalAudio.prototype.getMaxDistance=function(){return this.panner.maxDistance};THREE.PositionalAudio.prototype.updateMatrixWorld=function(){var a=new THREE.Vector3;return function(b){THREE.Object3D.prototype.updateMatrixWorld.call(this,b);a.setFromMatrixPosition(this.matrixWorld);this.panner.setPosition(a.x,a.y,a.z)}}();
THREE.AudioListener=function(){THREE.Object3D.call(this);this.type="AudioListener";this.context=THREE.AudioContext;this.gain=this.context.createGain();this.gain.connect(this.context.destination);this.filter=null};THREE.AudioListener.prototype=Object.create(THREE.Object3D.prototype);THREE.AudioListener.prototype.constructor=THREE.AudioListener;THREE.AudioListener.prototype.getInput=function(){return this.gain};
THREE.AudioListener.prototype.removeFilter=function(){null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null)};THREE.AudioListener.prototype.setFilter=function(a){null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination);this.filter=a;this.gain.connect(this.filter);this.filter.connect(this.context.destination)};
THREE.AudioListener.prototype.getFilter=function(){return this.filter};THREE.AudioListener.prototype.setMasterVolume=function(a){this.gain.gain.value=a};THREE.AudioListener.prototype.getMasterVolume=function(){return this.gain.gain.value};
THREE.AudioListener.prototype.updateMatrixWorld=function(){var a=new THREE.Vector3,b=new THREE.Quaternion,c=new THREE.Vector3,d=new THREE.Vector3;return function(e){THREE.Object3D.prototype.updateMatrixWorld.call(this,e);e=this.context.listener;var f=this.up;this.matrixWorld.decompose(a,b,c);d.set(0,0,-1).applyQuaternion(b);e.setPosition(a.x,a.y,a.z);e.setOrientation(d.x,d.y,d.z,f.x,f.y,f.z)}}();
THREE.Camera=function(){THREE.Object3D.call(this);this.type="Camera";this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4};THREE.Camera.prototype=Object.create(THREE.Object3D.prototype);THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.getWorldDirection=function(){var a=new THREE.Quaternion;return function(b){b=b||new THREE.Vector3;this.getWorldQuaternion(a);return b.set(0,0,-1).applyQuaternion(a)}}();
THREE.Camera.prototype.lookAt=function(){var a=new THREE.Matrix4;return function(b){a.lookAt(this.position,b,this.up);this.quaternion.setFromRotationMatrix(a)}}();THREE.Camera.prototype.clone=function(){return(new this.constructor).copy(this)};THREE.Camera.prototype.copy=function(a){THREE.Object3D.prototype.copy.call(this,a);this.matrixWorldInverse.copy(a.matrixWorldInverse);this.projectionMatrix.copy(a.projectionMatrix);return this};
THREE.CubeCamera=function(a,b,c){THREE.Object3D.call(this);this.type="CubeCamera";var d=new THREE.PerspectiveCamera(90,1,a,b);d.up.set(0,-1,0);d.lookAt(new THREE.Vector3(1,0,0));this.add(d);var e=new THREE.PerspectiveCamera(90,1,a,b);e.up.set(0,-1,0);e.lookAt(new THREE.Vector3(-1,0,0));this.add(e);var f=new THREE.PerspectiveCamera(90,1,a,b);f.up.set(0,0,1);f.lookAt(new THREE.Vector3(0,1,0));this.add(f);var g=new THREE.PerspectiveCamera(90,1,a,b);g.up.set(0,0,-1);g.lookAt(new THREE.Vector3(0,-1,0));
this.add(g);var h=new THREE.PerspectiveCamera(90,1,a,b);h.up.set(0,-1,0);h.lookAt(new THREE.Vector3(0,0,1));this.add(h);var k=new THREE.PerspectiveCamera(90,1,a,b);k.up.set(0,-1,0);k.lookAt(new THREE.Vector3(0,0,-1));this.add(k);this.renderTarget=new THREE.WebGLRenderTargetCube(c,c,{format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter});this.updateCubeMap=function(a,b){null===this.parent&&this.updateMatrixWorld();var c=this.renderTarget,m=c.texture.generateMipmaps;c.texture.generateMipmaps=
!1;c.activeCubeFace=0;a.render(b,d,c);c.activeCubeFace=1;a.render(b,e,c);c.activeCubeFace=2;a.render(b,f,c);c.activeCubeFace=3;a.render(b,g,c);c.activeCubeFace=4;a.render(b,h,c);c.texture.generateMipmaps=m;c.activeCubeFace=5;a.render(b,k,c);a.setRenderTarget(null)}};THREE.CubeCamera.prototype=Object.create(THREE.Object3D.prototype);THREE.CubeCamera.prototype.constructor=THREE.CubeCamera;
THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.type="OrthographicCamera";this.zoom=1;this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:.1;this.far=void 0!==f?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=Object.create(THREE.Camera.prototype);THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;
THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){var a=(this.right-this.left)/(2*this.zoom),b=(this.top-this.bottom)/(2*this.zoom),c=(this.right+this.left)/2,d=(this.top+this.bottom)/2;this.projectionMatrix.makeOrthographic(c-a,c+a,d+b,d-b,this.near,this.far)};THREE.OrthographicCamera.prototype.copy=function(a){THREE.Camera.prototype.copy.call(this,a);this.left=a.left;this.right=a.right;this.top=a.top;this.bottom=a.bottom;this.near=a.near;this.far=a.far;this.zoom=a.zoom;return this};
THREE.OrthographicCamera.prototype.toJSON=function(a){a=THREE.Object3D.prototype.toJSON.call(this,a);a.object.zoom=this.zoom;a.object.left=this.left;a.object.right=this.right;a.object.top=this.top;a.object.bottom=this.bottom;a.object.near=this.near;a.object.far=this.far;return a};
THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.type="PerspectiveCamera";this.fov=void 0!==a?a:50;this.zoom=1;this.near=void 0!==c?c:.1;this.far=void 0!==d?d:2E3;this.focus=10;this.aspect=void 0!==b?b:1;this.view=null;this.filmGauge=35;this.filmOffset=0;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=Object.create(THREE.Camera.prototype);THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;
THREE.PerspectiveCamera.prototype.setLens=function(a,b){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup.");void 0!==b&&(this.filmGauge=b);this.setFocalLength(a)};THREE.PerspectiveCamera.prototype.setFocalLength=function(a){a=.5*this.getFilmHeight()/a;this.fov=2*THREE.Math.RAD2DEG*Math.atan(a);this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.getFocalLength=function(){var a=Math.tan(.5*THREE.Math.DEG2RAD*this.fov);return.5*this.getFilmHeight()/a};THREE.PerspectiveCamera.prototype.getEffectiveFOV=function(){return 2*THREE.Math.RAD2DEG*Math.atan(Math.tan(.5*THREE.Math.DEG2RAD*this.fov)/this.zoom)};THREE.PerspectiveCamera.prototype.getFilmWidth=function(){return this.filmGauge*Math.min(this.aspect,1)};THREE.PerspectiveCamera.prototype.getFilmHeight=function(){return this.filmGauge/Math.max(this.aspect,1)};
THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.aspect=a/b;this.view={fullWidth:a,fullHeight:b,offsetX:c,offsetY:d,width:e,height:f};this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){var a=this.near,b=a*Math.tan(.5*THREE.Math.DEG2RAD*this.fov)/this.zoom,c=2*b,d=this.aspect*c,e=-.5*d,f=this.view;if(null!==f)var g=f.fullWidth,h=f.fullHeight,e=e+f.offsetX*d/g,b=b-f.offsetY*c/h,d=f.width/g*d,c=f.height/h*c;f=this.filmOffset;0!==f&&(e+=a*f/this.getFilmWidth());this.projectionMatrix.makeFrustum(e,e+d,b-c,b,a,this.far)};
THREE.PerspectiveCamera.prototype.copy=function(a){THREE.Camera.prototype.copy.call(this,a);this.fov=a.fov;this.zoom=a.zoom;this.near=a.near;this.far=a.far;this.focus=a.focus;this.aspect=a.aspect;this.view=null===a.view?null:Object.assign({},a.view);this.filmGauge=a.filmGauge;this.filmOffset=a.filmOffset;return this};
THREE.PerspectiveCamera.prototype.toJSON=function(a){a=THREE.Object3D.prototype.toJSON.call(this,a);a.object.fov=this.fov;a.object.zoom=this.zoom;a.object.near=this.near;a.object.far=this.far;a.object.focus=this.focus;a.object.aspect=this.aspect;null!==this.view&&(a.object.view=Object.assign({},this.view));a.object.filmGauge=this.filmGauge;a.object.filmOffset=this.filmOffset;return a};
THREE.StereoCamera=function(){this.type="StereoCamera";this.aspect=1;this.cameraL=new THREE.PerspectiveCamera;this.cameraL.layers.enable(1);this.cameraL.matrixAutoUpdate=!1;this.cameraR=new THREE.PerspectiveCamera;this.cameraR.layers.enable(2);this.cameraR.matrixAutoUpdate=!1};
THREE.StereoCamera.prototype={constructor:THREE.StereoCamera,update:function(){var a,b,c,d,e,f=new THREE.Matrix4,g=new THREE.Matrix4;return function(h){if(a!==h.focus||b!==h.fov||c!==h.aspect*this.aspect||d!==h.near||e!==h.far){a=h.focus;b=h.fov;c=h.aspect*this.aspect;d=h.near;e=h.far;var k=h.projectionMatrix.clone(),l=.032*d/a,n=d*Math.tan(THREE.Math.DEG2RAD*b*.5),p,m;g.elements[12]=-.032;f.elements[12]=.032;p=-n*c+l;m=n*c+l;k.elements[0]=2*d/(m-p);k.elements[8]=(m+p)/(m-p);this.cameraL.projectionMatrix.copy(k);
p=-n*c-l;m=n*c-l;k.elements[0]=2*d/(m-p);k.elements[8]=(m+p)/(m-p);this.cameraR.projectionMatrix.copy(k)}this.cameraL.matrixWorld.copy(h.matrixWorld).multiply(g);this.cameraR.matrixWorld.copy(h.matrixWorld).multiply(f)}}()};THREE.Light=function(a,b){THREE.Object3D.call(this);this.type="Light";this.color=new THREE.Color(a);this.intensity=void 0!==b?b:1;this.receiveShadow=void 0};THREE.Light.prototype=Object.create(THREE.Object3D.prototype);THREE.Light.prototype.constructor=THREE.Light;
THREE.Light.prototype.copy=function(a){THREE.Object3D.prototype.copy.call(this,a);this.color.copy(a.color);this.intensity=a.intensity;return this};
THREE.Light.prototype.toJSON=function(a){a=THREE.Object3D.prototype.toJSON.call(this,a);a.object.color=this.color.getHex();a.object.intensity=this.intensity;void 0!==this.groundColor&&(a.object.groundColor=this.groundColor.getHex());void 0!==this.distance&&(a.object.distance=this.distance);void 0!==this.angle&&(a.object.angle=this.angle);void 0!==this.decay&&(a.object.decay=this.decay);void 0!==this.penumbra&&(a.object.penumbra=this.penumbra);return a};
THREE.LightShadow=function(a){this.camera=a;this.bias=0;this.radius=1;this.mapSize=new THREE.Vector2(512,512);this.map=null;this.matrix=new THREE.Matrix4};THREE.LightShadow.prototype={constructor:THREE.LightShadow,copy:function(a){this.camera=a.camera.clone();this.bias=a.bias;this.radius=a.radius;this.mapSize.copy(a.mapSize);return this},clone:function(){return(new this.constructor).copy(this)}};THREE.AmbientLight=function(a,b){THREE.Light.call(this,a,b);this.type="AmbientLight";this.castShadow=void 0};
THREE.AmbientLight.prototype=Object.create(THREE.Light.prototype);THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b){THREE.Light.call(this,a,b);this.type="DirectionalLight";this.position.set(0,1,0);this.updateMatrix();this.target=new THREE.Object3D;this.shadow=new THREE.DirectionalLightShadow};THREE.DirectionalLight.prototype=Object.create(THREE.Light.prototype);THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.DirectionalLight.prototype.copy=function(a){THREE.Light.prototype.copy.call(this,a);this.target=a.target.clone();this.shadow=a.shadow.clone();return this};THREE.DirectionalLightShadow=function(a){THREE.LightShadow.call(this,new THREE.OrthographicCamera(-5,5,5,-5,.5,500))};THREE.DirectionalLightShadow.prototype=Object.create(THREE.LightShadow.prototype);THREE.DirectionalLightShadow.prototype.constructor=THREE.DirectionalLightShadow;
THREE.HemisphereLight=function(a,b,c){THREE.Light.call(this,a,c);this.type="HemisphereLight";this.castShadow=void 0;this.position.set(0,1,0);this.updateMatrix();this.groundColor=new THREE.Color(b)};THREE.HemisphereLight.prototype=Object.create(THREE.Light.prototype);THREE.HemisphereLight.prototype.constructor=THREE.HemisphereLight;THREE.HemisphereLight.prototype.copy=function(a){THREE.Light.prototype.copy.call(this,a);this.groundColor.copy(a.groundColor);return this};
THREE.PointLight=function(a,b,c,d){THREE.Light.call(this,a,b);this.type="PointLight";this.distance=void 0!==c?c:0;this.decay=void 0!==d?d:1;this.shadow=new THREE.LightShadow(new THREE.PerspectiveCamera(90,1,.5,500))};THREE.PointLight.prototype=Object.create(THREE.Light.prototype);THREE.PointLight.prototype.constructor=THREE.PointLight;Object.defineProperty(THREE.PointLight.prototype,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(a){this.intensity=a/(4*Math.PI)}});
THREE.PointLight.prototype.copy=function(a){THREE.Light.prototype.copy.call(this,a);this.distance=a.distance;this.decay=a.decay;this.shadow=a.shadow.clone();return this};THREE.SpotLight=function(a,b,c,d,e,f){THREE.Light.call(this,a,b);this.type="SpotLight";this.position.set(0,1,0);this.updateMatrix();this.target=new THREE.Object3D;this.distance=void 0!==c?c:0;this.angle=void 0!==d?d:Math.PI/3;this.penumbra=void 0!==e?e:0;this.decay=void 0!==f?f:1;this.shadow=new THREE.SpotLightShadow};
THREE.SpotLight.prototype=Object.create(THREE.Light.prototype);THREE.SpotLight.prototype.constructor=THREE.SpotLight;Object.defineProperty(THREE.SpotLight.prototype,"power",{get:function(){return this.intensity*Math.PI},set:function(a){this.intensity=a/Math.PI}});THREE.SpotLight.prototype.copy=function(a){THREE.Light.prototype.copy.call(this,a);this.distance=a.distance;this.angle=a.angle;this.penumbra=a.penumbra;this.decay=a.decay;this.target=a.target.clone();this.shadow=a.shadow.clone();return this};
THREE.SpotLightShadow=function(){THREE.LightShadow.call(this,new THREE.PerspectiveCamera(50,1,.5,500))};THREE.SpotLightShadow.prototype=Object.create(THREE.LightShadow.prototype);THREE.SpotLightShadow.prototype.constructor=THREE.SpotLightShadow;THREE.SpotLightShadow.prototype.update=function(a){var b=2*THREE.Math.RAD2DEG*a.angle,c=this.mapSize.width/this.mapSize.height;a=a.distance||500;var d=this.camera;if(b!==d.fov||c!==d.aspect||a!==d.far)d.fov=b,d.aspect=c,d.far=a,d.updateProjectionMatrix()};
THREE.AudioLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};THREE.AudioLoader.prototype={constructor:THREE.AudioLoader,load:function(a,b,c,d){var e=new THREE.XHRLoader(this.manager);e.setResponseType("arraybuffer");e.load(a,function(a){THREE.AudioContext.decodeAudioData(a,function(a){b(a)})},c,d)}};
THREE.Cache={enabled:!1,files:{},add:function(a,b){!1!==this.enabled&&(this.files[a]=b)},get:function(a){if(!1!==this.enabled)return this.files[a]},remove:function(a){delete this.files[a]},clear:function(){this.files={}}};THREE.Loader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:void 0,extractUrlBase:function(a){a=a.split("/");if(1===a.length)return"./";a.pop();return a.join("/")+"/"},initMaterials:function(a,b,c){for(var d=[],e=0;e<a.length;++e)d[e]=this.createMaterial(a[e],b,c);return d},createMaterial:function(){var a,b,c;return function(d,e,f){function g(a,c,d,g,k){a=e+a;var l=THREE.Loader.Handlers.get(a);null!==l?a=l.load(a):(b.setCrossOrigin(f),a=b.load(a));void 0!==c&&(a.repeat.fromArray(c),1!==c[0]&&(a.wrapS=
THREE.RepeatWrapping),1!==c[1]&&(a.wrapT=THREE.RepeatWrapping));void 0!==d&&a.offset.fromArray(d);void 0!==g&&("repeat"===g[0]&&(a.wrapS=THREE.RepeatWrapping),"mirror"===g[0]&&(a.wrapS=THREE.MirroredRepeatWrapping),"repeat"===g[1]&&(a.wrapT=THREE.RepeatWrapping),"mirror"===g[1]&&(a.wrapT=THREE.MirroredRepeatWrapping));void 0!==k&&(a.anisotropy=k);c=THREE.Math.generateUUID();h[c]=a;return c}void 0===a&&(a=new THREE.Color);void 0===b&&(b=new THREE.TextureLoader);void 0===c&&(c=new THREE.MaterialLoader);
var h={},k={uuid:THREE.Math.generateUUID(),type:"MeshLambertMaterial"},l;for(l in d){var n=d[l];switch(l){case "DbgColor":case "DbgIndex":case "opticalDensity":case "illumination":break;case "DbgName":k.name=n;break;case "blending":k.blending=THREE[n];break;case "colorAmbient":case "mapAmbient":console.warn("THREE.Loader.createMaterial:",l,"is no longer supported.");break;case "colorDiffuse":k.color=a.fromArray(n).getHex();break;case "colorSpecular":k.specular=a.fromArray(n).getHex();break;case "colorEmissive":k.emissive=
a.fromArray(n).getHex();break;case "specularCoef":k.shininess=n;break;case "shading":"basic"===n.toLowerCase()&&(k.type="MeshBasicMaterial");"phong"===n.toLowerCase()&&(k.type="MeshPhongMaterial");break;case "mapDiffuse":k.map=g(n,d.mapDiffuseRepeat,d.mapDiffuseOffset,d.mapDiffuseWrap,d.mapDiffuseAnisotropy);break;case "mapDiffuseRepeat":case "mapDiffuseOffset":case "mapDiffuseWrap":case "mapDiffuseAnisotropy":break;case "mapLight":k.lightMap=g(n,d.mapLightRepeat,d.mapLightOffset,d.mapLightWrap,d.mapLightAnisotropy);
break;case "mapLightRepeat":case "mapLightOffset":case "mapLightWrap":case "mapLightAnisotropy":break;case "mapAO":k.aoMap=g(n,d.mapAORepeat,d.mapAOOffset,d.mapAOWrap,d.mapAOAnisotropy);break;case "mapAORepeat":case "mapAOOffset":case "mapAOWrap":case "mapAOAnisotropy":break;case "mapBump":k.bumpMap=g(n,d.mapBumpRepeat,d.mapBumpOffset,d.mapBumpWrap,d.mapBumpAnisotropy);break;case "mapBumpScale":k.bumpScale=n;break;case "mapBumpRepeat":case "mapBumpOffset":case "mapBumpWrap":case "mapBumpAnisotropy":break;
case "mapNormal":k.normalMap=g(n,d.mapNormalRepeat,d.mapNormalOffset,d.mapNormalWrap,d.mapNormalAnisotropy);break;case "mapNormalFactor":k.normalScale=[n,n];break;case "mapNormalRepeat":case "mapNormalOffset":case "mapNormalWrap":case "mapNormalAnisotropy":break;case "mapSpecular":k.specularMap=g(n,d.mapSpecularRepeat,d.mapSpecularOffset,d.mapSpecularWrap,d.mapSpecularAnisotropy);break;case "mapSpecularRepeat":case "mapSpecularOffset":case "mapSpecularWrap":case "mapSpecularAnisotropy":break;case "mapAlpha":k.alphaMap=
g(n,d.mapAlphaRepeat,d.mapAlphaOffset,d.mapAlphaWrap,d.mapAlphaAnisotropy);break;case "mapAlphaRepeat":case "mapAlphaOffset":case "mapAlphaWrap":case "mapAlphaAnisotropy":break;case "flipSided":k.side=THREE.BackSide;break;case "doubleSided":k.side=THREE.DoubleSide;break;case "transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity");k.opacity=n;break;case "depthTest":case "depthWrite":case "colorWrite":case "opacity":case "reflectivity":case "transparent":case "visible":case "wireframe":k[l]=
n;break;case "vertexColors":!0===n&&(k.vertexColors=THREE.VertexColors);"face"===n&&(k.vertexColors=THREE.FaceColors);break;default:console.error("THREE.Loader.createMaterial: Unsupported",l,n)}}"MeshBasicMaterial"===k.type&&delete k.emissive;"MeshPhongMaterial"!==k.type&&delete k.specular;1>k.opacity&&(k.transparent=!0);c.setTextures(h);return c.parse(k)}}()};
THREE.Loader.Handlers={handlers:[],add:function(a,b){this.handlers.push(a,b)},get:function(a){for(var b=this.handlers,c=0,d=b.length;c<d;c+=2){var e=b[c+1];if(b[c].test(a))return e}return null}};THREE.XHRLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};
THREE.XHRLoader.prototype={constructor:THREE.XHRLoader,load:function(a,b,c,d){void 0!==this.path&&(a=this.path+a);var e=this,f=THREE.Cache.get(a);if(void 0!==f)return b&&setTimeout(function(){b(f)},0),f;var g=new XMLHttpRequest;g.overrideMimeType("text/plain");g.open("GET",a,!0);g.addEventListener("load",function(c){var f=c.target.response;THREE.Cache.add(a,f);200===this.status?(b&&b(f),e.manager.itemEnd(a)):0===this.status?(console.warn("THREE.XHRLoader: HTTP Status 0 received."),b&&b(f),e.manager.itemEnd(a)):
(d&&d(c),e.manager.itemError(a))},!1);void 0!==c&&g.addEventListener("progress",function(a){c(a)},!1);g.addEventListener("error",function(b){d&&d(b);e.manager.itemError(a)},!1);void 0!==this.responseType&&(g.responseType=this.responseType);void 0!==this.withCredentials&&(g.withCredentials=this.withCredentials);g.send(null);e.manager.itemStart(a);return g},setPath:function(a){this.path=a},setResponseType:function(a){this.responseType=a},setWithCredentials:function(a){this.withCredentials=a}};
THREE.FontLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};THREE.FontLoader.prototype={constructor:THREE.FontLoader,load:function(a,b,c,d){(new THREE.XHRLoader(this.manager)).load(a,function(a){b(new THREE.Font(JSON.parse(a.substring(65,a.length-2))))},c,d)}};THREE.ImageLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};
THREE.ImageLoader.prototype={constructor:THREE.ImageLoader,load:function(a,b,c,d){void 0!==this.path&&(a=this.path+a);var e=this,f=THREE.Cache.get(a);if(void 0!==f)return e.manager.itemStart(a),b?setTimeout(function(){b(f);e.manager.itemEnd(a)},0):e.manager.itemEnd(a),f;var g=document.createElement("img");g.addEventListener("load",function(c){THREE.Cache.add(a,this);b&&b(this);e.manager.itemEnd(a)},!1);void 0!==c&&g.addEventListener("progress",function(a){c(a)},!1);g.addEventListener("error",function(b){d&&
d(b);e.manager.itemError(a)},!1);void 0!==this.crossOrigin&&(g.crossOrigin=this.crossOrigin);e.manager.itemStart(a);g.src=a;return g},setCrossOrigin:function(a){this.crossOrigin=a},setPath:function(a){this.path=a}};THREE.JSONLoader=function(a){"boolean"===typeof a&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),a=void 0);this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this.withCredentials=!1};
THREE.JSONLoader.prototype={constructor:THREE.JSONLoader,get statusDomElement(){void 0===this._statusDomElement&&(this._statusDomElement=document.createElement("div"));console.warn("THREE.JSONLoader: .statusDomElement has been removed.");return this._statusDomElement},load:function(a,b,c,d){var e=this,f=this.texturePath&&"string"===typeof this.texturePath?this.texturePath:THREE.Loader.prototype.extractUrlBase(a),g=new THREE.XHRLoader(this.manager);g.setWithCredentials(this.withCredentials);g.load(a,
function(c){c=JSON.parse(c);var d=c.metadata;if(void 0!==d&&(d=d.type,void 0!==d)){if("object"===d.toLowerCase()){console.error("THREE.JSONLoader: "+a+" should be loaded with THREE.ObjectLoader instead.");return}if("scene"===d.toLowerCase()){console.error("THREE.JSONLoader: "+a+" should be loaded with THREE.SceneLoader instead.");return}}c=e.parse(c,f);b(c.geometry,c.materials)},c,d)},setTexturePath:function(a){this.texturePath=a},parse:function(a,b){var c=new THREE.Geometry,d=void 0!==a.scale?1/
a.scale:1;(function(b){var d,g,h,k,l,n,p,m,q,r,s,u,v,x=a.faces;n=a.vertices;var A=a.normals,w=a.colors,B=0;if(void 0!==a.uvs){for(d=0;d<a.uvs.length;d++)a.uvs[d].length&&B++;for(d=0;d<B;d++)c.faceVertexUvs[d]=[]}k=0;for(l=n.length;k<l;)d=new THREE.Vector3,d.x=n[k++]*b,d.y=n[k++]*b,d.z=n[k++]*b,c.vertices.push(d);k=0;for(l=x.length;k<l;)if(b=x[k++],q=b&1,h=b&2,d=b&8,p=b&16,r=b&32,n=b&64,b&=128,q){q=new THREE.Face3;q.a=x[k];q.b=x[k+1];q.c=x[k+3];s=new THREE.Face3;s.a=x[k+1];s.b=x[k+2];s.c=x[k+3];k+=
4;h&&(h=x[k++],q.materialIndex=h,s.materialIndex=h);h=c.faces.length;if(d)for(d=0;d<B;d++)for(u=a.uvs[d],c.faceVertexUvs[d][h]=[],c.faceVertexUvs[d][h+1]=[],g=0;4>g;g++)m=x[k++],v=u[2*m],m=u[2*m+1],v=new THREE.Vector2(v,m),2!==g&&c.faceVertexUvs[d][h].push(v),0!==g&&c.faceVertexUvs[d][h+1].push(v);p&&(p=3*x[k++],q.normal.set(A[p++],A[p++],A[p]),s.normal.copy(q.normal));if(r)for(d=0;4>d;d++)p=3*x[k++],r=new THREE.Vector3(A[p++],A[p++],A[p]),2!==d&&q.vertexNormals.push(r),0!==d&&s.vertexNormals.push(r);
n&&(n=x[k++],n=w[n],q.color.setHex(n),s.color.setHex(n));if(b)for(d=0;4>d;d++)n=x[k++],n=w[n],2!==d&&q.vertexColors.push(new THREE.Color(n)),0!==d&&s.vertexColors.push(new THREE.Color(n));c.faces.push(q);c.faces.push(s)}else{q=new THREE.Face3;q.a=x[k++];q.b=x[k++];q.c=x[k++];h&&(h=x[k++],q.materialIndex=h);h=c.faces.length;if(d)for(d=0;d<B;d++)for(u=a.uvs[d],c.faceVertexUvs[d][h]=[],g=0;3>g;g++)m=x[k++],v=u[2*m],m=u[2*m+1],v=new THREE.Vector2(v,m),c.faceVertexUvs[d][h].push(v);p&&(p=3*x[k++],q.normal.set(A[p++],
A[p++],A[p]));if(r)for(d=0;3>d;d++)p=3*x[k++],r=new THREE.Vector3(A[p++],A[p++],A[p]),q.vertexNormals.push(r);n&&(n=x[k++],q.color.setHex(w[n]));if(b)for(d=0;3>d;d++)n=x[k++],q.vertexColors.push(new THREE.Color(w[n]));c.faces.push(q)}})(d);(function(){var b=void 0!==a.influencesPerVertex?a.influencesPerVertex:2;if(a.skinWeights)for(var d=0,g=a.skinWeights.length;d<g;d+=b)c.skinWeights.push(new THREE.Vector4(a.skinWeights[d],1<b?a.skinWeights[d+1]:0,2<b?a.skinWeights[d+2]:0,3<b?a.skinWeights[d+3]:
0));if(a.skinIndices)for(d=0,g=a.skinIndices.length;d<g;d+=b)c.skinIndices.push(new THREE.Vector4(a.skinIndices[d],1<b?a.skinIndices[d+1]:0,2<b?a.skinIndices[d+2]:0,3<b?a.skinIndices[d+3]:0));c.bones=a.bones;c.bones&&0<c.bones.length&&(c.skinWeights.length!==c.skinIndices.length||c.skinIndices.length!==c.vertices.length)&&console.warn("When skinning, number of vertices ("+c.vertices.length+"), skinIndices ("+c.skinIndices.length+"), and skinWeights ("+c.skinWeights.length+") should match.")})();(function(b){if(void 0!==
a.morphTargets)for(var d=0,g=a.morphTargets.length;d<g;d++){c.morphTargets[d]={};c.morphTargets[d].name=a.morphTargets[d].name;c.morphTargets[d].vertices=[];for(var h=c.morphTargets[d].vertices,k=a.morphTargets[d].vertices,l=0,n=k.length;l<n;l+=3){var p=new THREE.Vector3;p.x=k[l]*b;p.y=k[l+1]*b;p.z=k[l+2]*b;h.push(p)}}if(void 0!==a.morphColors&&0<a.morphColors.length)for(console.warn('THREE.JSONLoader: "morphColors" no longer supported. Using them as face colors.'),b=c.faces,h=a.morphColors[0].colors,
d=0,g=b.length;d<g;d++)b[d].color.fromArray(h,3*d)})(d);(function(){var b=[],d=[];void 0!==a.animation&&d.push(a.animation);void 0!==a.animations&&(a.animations.length?d=d.concat(a.animations):d.push(a.animations));for(var g=0;g<d.length;g++){var h=THREE.AnimationClip.parseAnimation(d[g],c.bones);h&&b.push(h)}c.morphTargets&&(d=THREE.AnimationClip.CreateClipsFromMorphTargetSequences(c.morphTargets,10),b=b.concat(d));0<b.length&&(c.animations=b)})();c.computeFaceNormals();c.computeBoundingSphere();
if(void 0===a.materials||0===a.materials.length)return{geometry:c};d=THREE.Loader.prototype.initMaterials(a.materials,b,this.crossOrigin);return{geometry:c,materials:d}}};
THREE.LoadingManager=function(a,b,c){var d=this,e=!1,f=0,g=0;this.onStart=void 0;this.onLoad=a;this.onProgress=b;this.onError=c;this.itemStart=function(a){g++;if(!1===e&&void 0!==d.onStart)d.onStart(a,f,g);e=!0};this.itemEnd=function(a){f++;if(void 0!==d.onProgress)d.onProgress(a,f,g);if(f===g&&(e=!1,void 0!==d.onLoad))d.onLoad()};this.itemError=function(a){if(void 0!==d.onError)d.onError(a)}};THREE.DefaultLoadingManager=new THREE.LoadingManager;
THREE.BufferGeometryLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};
THREE.BufferGeometryLoader.prototype={constructor:THREE.BufferGeometryLoader,load:function(a,b,c,d){var e=this;(new THREE.XHRLoader(e.manager)).load(a,function(a){b(e.parse(JSON.parse(a)))},c,d)},parse:function(a){var b=new THREE.BufferGeometry,c=a.data.index,d={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:Uint8ClampedArray,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};void 0!==c&&(c=
new d[c.type](c.array),b.setIndex(new THREE.BufferAttribute(c,1)));var e=a.data.attributes,f;for(f in e){var g=e[f],c=new d[g.type](g.array);b.addAttribute(f,new THREE.BufferAttribute(c,g.itemSize,g.normalized))}d=a.data.groups||a.data.drawcalls||a.data.offsets;if(void 0!==d)for(f=0,c=d.length;f!==c;++f)e=d[f],b.addGroup(e.start,e.count,e.materialIndex);a=a.data.boundingSphere;void 0!==a&&(d=new THREE.Vector3,void 0!==a.center&&d.fromArray(a.center),b.boundingSphere=new THREE.Sphere(d,a.radius));
return b}};THREE.MaterialLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this.textures={}};
THREE.MaterialLoader.prototype={constructor:THREE.MaterialLoader,load:function(a,b,c,d){var e=this;(new THREE.XHRLoader(e.manager)).load(a,function(a){b(e.parse(JSON.parse(a)))},c,d)},setTextures:function(a){this.textures=a},getTexture:function(a){var b=this.textures;void 0===b[a]&&console.warn("THREE.MaterialLoader: Undefined texture",a);return b[a]},parse:function(a){var b=new THREE[a.type];void 0!==a.uuid&&(b.uuid=a.uuid);void 0!==a.name&&(b.name=a.name);void 0!==a.color&&b.color.setHex(a.color);
void 0!==a.roughness&&(b.roughness=a.roughness);void 0!==a.metalness&&(b.metalness=a.metalness);void 0!==a.emissive&&b.emissive.setHex(a.emissive);void 0!==a.specular&&b.specular.setHex(a.specular);void 0!==a.shininess&&(b.shininess=a.shininess);void 0!==a.uniforms&&(b.uniforms=a.uniforms);void 0!==a.vertexShader&&(b.vertexShader=a.vertexShader);void 0!==a.fragmentShader&&(b.fragmentShader=a.fragmentShader);void 0!==a.vertexColors&&(b.vertexColors=a.vertexColors);void 0!==a.shading&&(b.shading=a.shading);
void 0!==a.blending&&(b.blending=a.blending);void 0!==a.side&&(b.side=a.side);void 0!==a.opacity&&(b.opacity=a.opacity);void 0!==a.transparent&&(b.transparent=a.transparent);void 0!==a.alphaTest&&(b.alphaTest=a.alphaTest);void 0!==a.depthTest&&(b.depthTest=a.depthTest);void 0!==a.depthWrite&&(b.depthWrite=a.depthWrite);void 0!==a.colorWrite&&(b.colorWrite=a.colorWrite);void 0!==a.wireframe&&(b.wireframe=a.wireframe);void 0!==a.wireframeLinewidth&&(b.wireframeLinewidth=a.wireframeLinewidth);void 0!==
a.size&&(b.size=a.size);void 0!==a.sizeAttenuation&&(b.sizeAttenuation=a.sizeAttenuation);void 0!==a.map&&(b.map=this.getTexture(a.map));void 0!==a.alphaMap&&(b.alphaMap=this.getTexture(a.alphaMap),b.transparent=!0);void 0!==a.bumpMap&&(b.bumpMap=this.getTexture(a.bumpMap));void 0!==a.bumpScale&&(b.bumpScale=a.bumpScale);void 0!==a.normalMap&&(b.normalMap=this.getTexture(a.normalMap));if(void 0!==a.normalScale){var c=a.normalScale;!1===Array.isArray(c)&&(c=[c,c]);b.normalScale=(new THREE.Vector2).fromArray(c)}void 0!==
a.displacementMap&&(b.displacementMap=this.getTexture(a.displacementMap));void 0!==a.displacementScale&&(b.displacementScale=a.displacementScale);void 0!==a.displacementBias&&(b.displacementBias=a.displacementBias);void 0!==a.roughnessMap&&(b.roughnessMap=this.getTexture(a.roughnessMap));void 0!==a.metalnessMap&&(b.metalnessMap=this.getTexture(a.metalnessMap));void 0!==a.emissiveMap&&(b.emissiveMap=this.getTexture(a.emissiveMap));void 0!==a.emissiveIntensity&&(b.emissiveIntensity=a.emissiveIntensity);
void 0!==a.specularMap&&(b.specularMap=this.getTexture(a.specularMap));void 0!==a.envMap&&(b.envMap=this.getTexture(a.envMap),b.combine=THREE.MultiplyOperation);a.reflectivity&&(b.reflectivity=a.reflectivity);void 0!==a.lightMap&&(b.lightMap=this.getTexture(a.lightMap));void 0!==a.lightMapIntensity&&(b.lightMapIntensity=a.lightMapIntensity);void 0!==a.aoMap&&(b.aoMap=this.getTexture(a.aoMap));void 0!==a.aoMapIntensity&&(b.aoMapIntensity=a.aoMapIntensity);if(void 0!==a.materials)for(var c=0,d=a.materials.length;c<
d;c++)b.materials.push(this.parse(a.materials[c]));return b}};THREE.ObjectLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this.texturePath=""};
THREE.ObjectLoader.prototype={constructor:THREE.ObjectLoader,load:function(a,b,c,d){""===this.texturePath&&(this.texturePath=a.substring(0,a.lastIndexOf("/")+1));var e=this;(new THREE.XHRLoader(e.manager)).load(a,function(a){e.parse(JSON.parse(a),b)},c,d)},setTexturePath:function(a){this.texturePath=a},setCrossOrigin:function(a){this.crossOrigin=a},parse:function(a,b){var c=this.parseGeometries(a.geometries),d=this.parseImages(a.images,function(){void 0!==b&&b(e)}),d=this.parseTextures(a.textures,
d),d=this.parseMaterials(a.materials,d),e=this.parseObject(a.object,c,d);a.animations&&(e.animations=this.parseAnimations(a.animations));void 0!==a.images&&0!==a.images.length||void 0===b||b(e);return e},parseGeometries:function(a){var b={};if(void 0!==a)for(var c=new THREE.JSONLoader,d=new THREE.BufferGeometryLoader,e=0,f=a.length;e<f;e++){var g,h=a[e];switch(h.type){case "PlaneGeometry":case "PlaneBufferGeometry":g=new THREE[h.type](h.width,h.height,h.widthSegments,h.heightSegments);break;case "BoxGeometry":case "BoxBufferGeometry":case "CubeGeometry":g=
new THREE[h.type](h.width,h.height,h.depth,h.widthSegments,h.heightSegments,h.depthSegments);break;case "CircleGeometry":case "CircleBufferGeometry":g=new THREE[h.type](h.radius,h.segments,h.thetaStart,h.thetaLength);break;case "CylinderGeometry":case "CylinderBufferGeometry":g=new THREE[h.type](h.radiusTop,h.radiusBottom,h.height,h.radialSegments,h.heightSegments,h.openEnded,h.thetaStart,h.thetaLength);break;case "SphereGeometry":case "SphereBufferGeometry":g=new THREE[h.type](h.radius,h.widthSegments,
h.heightSegments,h.phiStart,h.phiLength,h.thetaStart,h.thetaLength);break;case "DodecahedronGeometry":g=new THREE.DodecahedronGeometry(h.radius,h.detail);break;case "IcosahedronGeometry":g=new THREE.IcosahedronGeometry(h.radius,h.detail);break;case "OctahedronGeometry":g=new THREE.OctahedronGeometry(h.radius,h.detail);break;case "TetrahedronGeometry":g=new THREE.TetrahedronGeometry(h.radius,h.detail);break;case "RingGeometry":case "RingBufferGeometry":g=new THREE[h.type](h.innerRadius,h.outerRadius,
h.thetaSegments,h.phiSegments,h.thetaStart,h.thetaLength);break;case "TorusGeometry":case "TorusBufferGeometry":g=new THREE[h.type](h.radius,h.tube,h.radialSegments,h.tubularSegments,h.arc);break;case "TorusKnotGeometry":case "TorusKnotBufferGeometry":g=new THREE[h.type](h.radius,h.tube,h.tubularSegments,h.radialSegments,h.p,h.q);break;case "LatheGeometry":case "LatheBufferGeometry":g=new THREE[h.type](h.points,h.segments,h.phiStart,h.phiLength);break;case "BufferGeometry":g=d.parse(h);break;case "Geometry":g=
c.parse(h.data,this.texturePath).geometry;break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+h.type+'"');continue}g.uuid=h.uuid;void 0!==h.name&&(g.name=h.name);b[h.uuid]=g}return b},parseMaterials:function(a,b){var c={};if(void 0!==a){var d=new THREE.MaterialLoader;d.setTextures(b);for(var e=0,f=a.length;e<f;e++){var g=d.parse(a[e]);c[g.uuid]=g}}return c},parseAnimations:function(a){for(var b=[],c=0;c<a.length;c++){var d=THREE.AnimationClip.parse(a[c]);b.push(d)}return b},
parseImages:function(a,b){function c(a){d.manager.itemStart(a);return g.load(a,function(){d.manager.itemEnd(a)})}var d=this,e={};if(void 0!==a&&0<a.length){var f=new THREE.LoadingManager(b),g=new THREE.ImageLoader(f);g.setCrossOrigin(this.crossOrigin);for(var f=0,h=a.length;f<h;f++){var k=a[f],l=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(k.url)?k.url:d.texturePath+k.url;e[k.uuid]=c(l)}}return e},parseTextures:function(a,b){function c(a){if("number"===typeof a)return a;console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",
a);return THREE[a]}var d={};if(void 0!==a)for(var e=0,f=a.length;e<f;e++){var g=a[e];void 0===g.image&&console.warn('THREE.ObjectLoader: No "image" specified for',g.uuid);void 0===b[g.image]&&console.warn("THREE.ObjectLoader: Undefined image",g.image);var h=new THREE.Texture(b[g.image]);h.needsUpdate=!0;h.uuid=g.uuid;void 0!==g.name&&(h.name=g.name);void 0!==g.mapping&&(h.mapping=c(g.mapping));void 0!==g.offset&&(h.offset=new THREE.Vector2(g.offset[0],g.offset[1]));void 0!==g.repeat&&(h.repeat=new THREE.Vector2(g.repeat[0],
g.repeat[1]));void 0!==g.minFilter&&(h.minFilter=c(g.minFilter));void 0!==g.magFilter&&(h.magFilter=c(g.magFilter));void 0!==g.anisotropy&&(h.anisotropy=g.anisotropy);Array.isArray(g.wrap)&&(h.wrapS=c(g.wrap[0]),h.wrapT=c(g.wrap[1]));d[g.uuid]=h}return d},parseObject:function(){var a=new THREE.Matrix4;return function(b,c,d){function e(a){void 0===c[a]&&console.warn("THREE.ObjectLoader: Undefined geometry",a);return c[a]}function f(a){if(void 0!==a)return void 0===d[a]&&console.warn("THREE.ObjectLoader: Undefined material",
a),d[a]}var g;switch(b.type){case "Scene":g=new THREE.Scene;break;case "PerspectiveCamera":g=new THREE.PerspectiveCamera(b.fov,b.aspect,b.near,b.far);void 0!==b.focus&&(g.focus=b.focus);void 0!==b.zoom&&(g.zoom=b.zoom);void 0!==b.filmGauge&&(g.filmGauge=b.filmGauge);void 0!==b.filmOffset&&(g.filmOffset=b.filmOffset);void 0!==b.view&&(g.view=Object.assign({},b.view));break;case "OrthographicCamera":g=new THREE.OrthographicCamera(b.left,b.right,b.top,b.bottom,b.near,b.far);break;case "AmbientLight":g=
new THREE.AmbientLight(b.color,b.intensity);break;case "DirectionalLight":g=new THREE.DirectionalLight(b.color,b.intensity);break;case "PointLight":g=new THREE.PointLight(b.color,b.intensity,b.distance,b.decay);break;case "SpotLight":g=new THREE.SpotLight(b.color,b.intensity,b.distance,b.angle,b.penumbra,b.decay);break;case "HemisphereLight":g=new THREE.HemisphereLight(b.color,b.groundColor,b.intensity);break;case "Mesh":g=e(b.geometry);var h=f(b.material);g=g.bones&&0<g.bones.length?new THREE.SkinnedMesh(g,
h):new THREE.Mesh(g,h);break;case "LOD":g=new THREE.LOD;break;case "Line":g=new THREE.Line(e(b.geometry),f(b.material),b.mode);break;case "PointCloud":case "Points":g=new THREE.Points(e(b.geometry),f(b.material));break;case "Sprite":g=new THREE.Sprite(f(b.material));break;case "Group":g=new THREE.Group;break;default:g=new THREE.Object3D}g.uuid=b.uuid;void 0!==b.name&&(g.name=b.name);void 0!==b.matrix?(a.fromArray(b.matrix),a.decompose(g.position,g.quaternion,g.scale)):(void 0!==b.position&&g.position.fromArray(b.position),
void 0!==b.rotation&&g.rotation.fromArray(b.rotation),void 0!==b.scale&&g.scale.fromArray(b.scale));void 0!==b.castShadow&&(g.castShadow=b.castShadow);void 0!==b.receiveShadow&&(g.receiveShadow=b.receiveShadow);void 0!==b.visible&&(g.visible=b.visible);void 0!==b.userData&&(g.userData=b.userData);if(void 0!==b.children)for(var k in b.children)g.add(this.parseObject(b.children[k],c,d));if("LOD"===b.type)for(b=b.levels,h=0;h<b.length;h++){var l=b[h];k=g.getObjectByProperty("uuid",l.object);void 0!==
k&&g.addLevel(k,l.distance)}return g}}()};THREE.TextureLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};THREE.TextureLoader.prototype={constructor:THREE.TextureLoader,load:function(a,b,c,d){var e=new THREE.Texture,f=new THREE.ImageLoader(this.manager);f.setCrossOrigin(this.crossOrigin);f.setPath(this.path);f.load(a,function(a){e.image=a;e.needsUpdate=!0;void 0!==b&&b(e)},c,d);return e},setCrossOrigin:function(a){this.crossOrigin=a},setPath:function(a){this.path=a}};
THREE.CubeTextureLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager};
THREE.CubeTextureLoader.prototype={constructor:THREE.CubeTextureLoader,load:function(a,b,c,d){function e(c){g.load(a[c],function(a){f.images[c]=a;h++;6===h&&(f.needsUpdate=!0,b&&b(f))},void 0,d)}var f=new THREE.CubeTexture,g=new THREE.ImageLoader(this.manager);g.setCrossOrigin(this.crossOrigin);g.setPath(this.path);var h=0;for(c=0;c<a.length;++c)e(c);return f},setCrossOrigin:function(a){this.crossOrigin=a},setPath:function(a){this.path=a}};
THREE.DataTextureLoader=THREE.BinaryTextureLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this._parser=null};
THREE.BinaryTextureLoader.prototype={constructor:THREE.BinaryTextureLoader,load:function(a,b,c,d){var e=this,f=new THREE.DataTexture,g=new THREE.XHRLoader(this.manager);g.setResponseType("arraybuffer");g.load(a,function(a){if(a=e._parser(a))void 0!==a.image?f.image=a.image:void 0!==a.data&&(f.image.width=a.width,f.image.height=a.height,f.image.data=a.data),f.wrapS=void 0!==a.wrapS?a.wrapS:THREE.ClampToEdgeWrapping,f.wrapT=void 0!==a.wrapT?a.wrapT:THREE.ClampToEdgeWrapping,f.magFilter=void 0!==a.magFilter?
a.magFilter:THREE.LinearFilter,f.minFilter=void 0!==a.minFilter?a.minFilter:THREE.LinearMipMapLinearFilter,f.anisotropy=void 0!==a.anisotropy?a.anisotropy:1,void 0!==a.format&&(f.format=a.format),void 0!==a.type&&(f.type=a.type),void 0!==a.mipmaps&&(f.mipmaps=a.mipmaps),1===a.mipmapCount&&(f.minFilter=THREE.LinearFilter),f.needsUpdate=!0,b&&b(f,a)},c,d);return f}};THREE.CompressedTextureLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this._parser=null};
THREE.CompressedTextureLoader.prototype={constructor:THREE.CompressedTextureLoader,load:function(a,b,c,d){function e(e){k.load(a[e],function(a){a=f._parser(a,!0);g[e]={width:a.width,height:a.height,format:a.format,mipmaps:a.mipmaps};l+=1;6===l&&(1===a.mipmapCount&&(h.minFilter=THREE.LinearFilter),h.format=a.format,h.needsUpdate=!0,b&&b(h))},c,d)}var f=this,g=[],h=new THREE.CompressedTexture;h.image=g;var k=new THREE.XHRLoader(this.manager);k.setPath(this.path);k.setResponseType("arraybuffer");if(Array.isArray(a))for(var l=
0,n=0,p=a.length;n<p;++n)e(n);else k.load(a,function(a){a=f._parser(a,!0);if(a.isCubemap)for(var c=a.mipmaps.length/a.mipmapCount,d=0;d<c;d++){g[d]={mipmaps:[]};for(var e=0;e<a.mipmapCount;e++)g[d].mipmaps.push(a.mipmaps[d*a.mipmapCount+e]),g[d].format=a.format,g[d].width=a.width,g[d].height=a.height}else h.image.width=a.width,h.image.height=a.height,h.mipmaps=a.mipmaps;1===a.mipmapCount&&(h.minFilter=THREE.LinearFilter);h.format=a.format;h.needsUpdate=!0;b&&b(h)},c,d);return h},setPath:function(a){this.path=
a}};
THREE.Material=function(){Object.defineProperty(this,"id",{value:THREE.MaterialIdCount++});this.uuid=THREE.Math.generateUUID();this.name="";this.type="Material";this.side=THREE.FrontSide;this.opacity=1;this.transparent=!1;this.blending=THREE.NormalBlending;this.blendSrc=THREE.SrcAlphaFactor;this.blendDst=THREE.OneMinusSrcAlphaFactor;this.blendEquation=THREE.AddEquation;this.blendEquationAlpha=this.blendDstAlpha=this.blendSrcAlpha=null;this.depthFunc=THREE.LessEqualDepth;this.depthWrite=this.depthTest=!0;
this.clippingPlanes=null;this.clipShadows=!1;this.colorWrite=!0;this.precision=null;this.polygonOffset=!1;this.alphaTest=this.polygonOffsetUnits=this.polygonOffsetFactor=0;this.premultipliedAlpha=!1;this.overdraw=0;this._needsUpdate=this.visible=!0};
THREE.Material.prototype={constructor:THREE.Material,get needsUpdate(){return this._needsUpdate},set needsUpdate(a){!0===a&&this.update();this._needsUpdate=a},setValues:function(a){if(void 0!==a)for(var b in a){var c=a[b];if(void 0===c)console.warn("THREE.Material: '"+b+"' parameter is undefined.");else{var d=this[b];void 0===d?console.warn("THREE."+this.type+": '"+b+"' is not a property of this material."):d instanceof THREE.Color?d.set(c):d instanceof THREE.Vector3&&c instanceof THREE.Vector3?d.copy(c):
this[b]="overdraw"===b?Number(c):c}}},toJSON:function(a){function b(a){var b=[],c;for(c in a){var d=a[c];delete d.metadata;b.push(d)}return b}var c=void 0===a;c&&(a={textures:{},images:{}});var d={metadata:{version:4.4,type:"Material",generator:"Material.toJSON"}};d.uuid=this.uuid;d.type=this.type;""!==this.name&&(d.name=this.name);this.color instanceof THREE.Color&&(d.color=this.color.getHex());.5!==this.roughness&&(d.roughness=this.roughness);.5!==this.metalness&&(d.metalness=this.metalness);this.emissive instanceof
THREE.Color&&(d.emissive=this.emissive.getHex());this.specular instanceof THREE.Color&&(d.specular=this.specular.getHex());void 0!==this.shininess&&(d.shininess=this.shininess);this.map instanceof THREE.Texture&&(d.map=this.map.toJSON(a).uuid);this.alphaMap instanceof THREE.Texture&&(d.alphaMap=this.alphaMap.toJSON(a).uuid);this.lightMap instanceof THREE.Texture&&(d.lightMap=this.lightMap.toJSON(a).uuid);this.bumpMap instanceof THREE.Texture&&(d.bumpMap=this.bumpMap.toJSON(a).uuid,d.bumpScale=this.bumpScale);
this.normalMap instanceof THREE.Texture&&(d.normalMap=this.normalMap.toJSON(a).uuid,d.normalScale=this.normalScale.toArray());this.displacementMap instanceof THREE.Texture&&(d.displacementMap=this.displacementMap.toJSON(a).uuid,d.displacementScale=this.displacementScale,d.displacementBias=this.displacementBias);this.roughnessMap instanceof THREE.Texture&&(d.roughnessMap=this.roughnessMap.toJSON(a).uuid);this.metalnessMap instanceof THREE.Texture&&(d.metalnessMap=this.metalnessMap.toJSON(a).uuid);
this.emissiveMap instanceof THREE.Texture&&(d.emissiveMap=this.emissiveMap.toJSON(a).uuid);this.specularMap instanceof THREE.Texture&&(d.specularMap=this.specularMap.toJSON(a).uuid);this.envMap instanceof THREE.Texture&&(d.envMap=this.envMap.toJSON(a).uuid,d.reflectivity=this.reflectivity);void 0!==this.size&&(d.size=this.size);void 0!==this.sizeAttenuation&&(d.sizeAttenuation=this.sizeAttenuation);void 0!==this.vertexColors&&this.vertexColors!==THREE.NoColors&&(d.vertexColors=this.vertexColors);
void 0!==this.shading&&this.shading!==THREE.SmoothShading&&(d.shading=this.shading);void 0!==this.blending&&this.blending!==THREE.NormalBlending&&(d.blending=this.blending);void 0!==this.side&&this.side!==THREE.FrontSide&&(d.side=this.side);1>this.opacity&&(d.opacity=this.opacity);!0===this.transparent&&(d.transparent=this.transparent);0<this.alphaTest&&(d.alphaTest=this.alphaTest);!0===this.premultipliedAlpha&&(d.premultipliedAlpha=this.premultipliedAlpha);!0===this.wireframe&&(d.wireframe=this.wireframe);
1<this.wireframeLinewidth&&(d.wireframeLinewidth=this.wireframeLinewidth);c&&(c=b(a.textures),a=b(a.images),0<c.length&&(d.textures=c),0<a.length&&(d.images=a));return d},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.name=a.name;this.side=a.side;this.opacity=a.opacity;this.transparent=a.transparent;this.blending=a.blending;this.blendSrc=a.blendSrc;this.blendDst=a.blendDst;this.blendEquation=a.blendEquation;this.blendSrcAlpha=a.blendSrcAlpha;this.blendDstAlpha=a.blendDstAlpha;
this.blendEquationAlpha=a.blendEquationAlpha;this.depthFunc=a.depthFunc;this.depthTest=a.depthTest;this.depthWrite=a.depthWrite;this.colorWrite=a.colorWrite;this.precision=a.precision;this.polygonOffset=a.polygonOffset;this.polygonOffsetFactor=a.polygonOffsetFactor;this.polygonOffsetUnits=a.polygonOffsetUnits;this.alphaTest=a.alphaTest;this.premultipliedAlpha=a.premultipliedAlpha;this.overdraw=a.overdraw;this.visible=a.visible;this.clipShadows=a.clipShadows;a=a.clippingPlanes;var b=null;if(null!==
a)for(var c=a.length,b=Array(c),d=0;d!==c;++d)b[d]=a[d].clone();this.clippingPlanes=b;return this},update:function(){this.dispatchEvent({type:"update"})},dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.Material.prototype);THREE.MaterialIdCount=0;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this);this.type="LineBasicMaterial";this.color=new THREE.Color(16777215);this.linewidth=1;this.linejoin=this.linecap="round";this.blending=THREE.NormalBlending;this.vertexColors=THREE.NoColors;this.fog=!0;this.setValues(a)};THREE.LineBasicMaterial.prototype=Object.create(THREE.Material.prototype);THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.LineBasicMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.linewidth=a.linewidth;this.linecap=a.linecap;this.linejoin=a.linejoin;this.vertexColors=a.vertexColors;this.fog=a.fog;return this};
THREE.LineDashedMaterial=function(a){THREE.Material.call(this);this.type="LineDashedMaterial";this.color=new THREE.Color(16777215);this.scale=this.linewidth=1;this.dashSize=3;this.gapSize=1;this.blending=THREE.NormalBlending;this.vertexColors=THREE.NoColors;this.fog=!0;this.setValues(a)};THREE.LineDashedMaterial.prototype=Object.create(THREE.Material.prototype);THREE.LineDashedMaterial.prototype.constructor=THREE.LineDashedMaterial;
THREE.LineDashedMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.linewidth=a.linewidth;this.scale=a.scale;this.dashSize=a.dashSize;this.gapSize=a.gapSize;this.vertexColors=a.vertexColors;this.fog=a.fog;return this};
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this);this.type="MeshBasicMaterial";this.color=new THREE.Color(16777215);this.aoMap=this.map=null;this.aoMapIntensity=1;this.envMap=this.alphaMap=this.specularMap=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=
THREE.NoColors;this.morphTargets=this.skinning=!1;this.setValues(a)};THREE.MeshBasicMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshBasicMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.map=a.map;this.aoMap=a.aoMap;this.aoMapIntensity=a.aoMapIntensity;this.specularMap=a.specularMap;this.alphaMap=a.alphaMap;this.envMap=a.envMap;this.combine=a.combine;this.reflectivity=a.reflectivity;this.refractionRatio=a.refractionRatio;this.fog=a.fog;this.shading=a.shading;this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;this.wireframeLinecap=a.wireframeLinecap;
this.wireframeLinejoin=a.wireframeLinejoin;this.vertexColors=a.vertexColors;this.skinning=a.skinning;this.morphTargets=a.morphTargets;return this};THREE.MeshDepthMaterial=function(a){THREE.Material.call(this);this.type="MeshDepthMaterial";this.depthPacking=THREE.BasicDepthPacking;this.morphTargets=this.skinning=!1;this.displacementMap=this.alphaMap=this.map=null;this.displacementScale=1;this.displacementBias=0;this.wireframe=!1;this.wireframeLinewidth=1;this.setValues(a)};
THREE.MeshDepthMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshDepthMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.depthPacking=a.depthPacking;this.skinning=a.skinning;this.morphTargets=a.morphTargets;this.map=a.map;this.alphaMap=a.alphaMap;this.displacementMap=a.displacementMap;this.displacementScale=a.displacementScale;this.displacementBias=a.displacementBias;this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;return this};
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this);this.type="MeshLambertMaterial";this.color=new THREE.Color(16777215);this.lightMap=this.map=null;this.lightMapIntensity=1;this.aoMap=null;this.aoMapIntensity=1;this.emissive=new THREE.Color(0);this.emissiveIntensity=1;this.envMap=this.alphaMap=this.specularMap=this.emissiveMap=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=.98;this.fog=!0;this.blending=THREE.NormalBlending;this.wireframe=!1;this.wireframeLinewidth=
1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=THREE.NoColors;this.morphNormals=this.morphTargets=this.skinning=!1;this.setValues(a)};THREE.MeshLambertMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshLambertMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.map=a.map;this.lightMap=a.lightMap;this.lightMapIntensity=a.lightMapIntensity;this.aoMap=a.aoMap;this.aoMapIntensity=a.aoMapIntensity;this.emissive.copy(a.emissive);this.emissiveMap=a.emissiveMap;this.emissiveIntensity=a.emissiveIntensity;this.specularMap=a.specularMap;this.alphaMap=a.alphaMap;this.envMap=a.envMap;this.combine=a.combine;this.reflectivity=a.reflectivity;this.refractionRatio=
a.refractionRatio;this.fog=a.fog;this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;this.wireframeLinecap=a.wireframeLinecap;this.wireframeLinejoin=a.wireframeLinejoin;this.vertexColors=a.vertexColors;this.skinning=a.skinning;this.morphTargets=a.morphTargets;this.morphNormals=a.morphNormals;return this};THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);this.type="MeshNormalMaterial";this.wireframe=!1;this.wireframeLinewidth=1;this.morphTargets=!1;this.setValues(a)};
THREE.MeshNormalMaterial.prototype=Object.create(THREE.Material.prototype);THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshNormalMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;return this};
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this);this.type="MeshPhongMaterial";this.color=new THREE.Color(16777215);this.specular=new THREE.Color(1118481);this.shininess=30;this.lightMap=this.map=null;this.lightMapIntensity=1;this.aoMap=null;this.aoMapIntensity=1;this.emissive=new THREE.Color(0);this.emissiveIntensity=1;this.bumpMap=this.emissiveMap=null;this.bumpScale=1;this.normalMap=null;this.normalScale=new THREE.Vector2(1,1);this.displacementMap=null;this.displacementScale=1;this.displacementBias=
0;this.envMap=this.alphaMap=this.specularMap=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=THREE.NoColors;this.morphNormals=this.morphTargets=this.skinning=!1;this.setValues(a)};THREE.MeshPhongMaterial.prototype=Object.create(THREE.Material.prototype);
THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshPhongMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.specular.copy(a.specular);this.shininess=a.shininess;this.map=a.map;this.lightMap=a.lightMap;this.lightMapIntensity=a.lightMapIntensity;this.aoMap=a.aoMap;this.aoMapIntensity=a.aoMapIntensity;this.emissive.copy(a.emissive);this.emissiveMap=a.emissiveMap;this.emissiveIntensity=a.emissiveIntensity;this.bumpMap=a.bumpMap;this.bumpScale=a.bumpScale;this.normalMap=a.normalMap;this.normalScale.copy(a.normalScale);
this.displacementMap=a.displacementMap;this.displacementScale=a.displacementScale;this.displacementBias=a.displacementBias;this.specularMap=a.specularMap;this.alphaMap=a.alphaMap;this.envMap=a.envMap;this.combine=a.combine;this.reflectivity=a.reflectivity;this.refractionRatio=a.refractionRatio;this.fog=a.fog;this.shading=a.shading;this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;this.wireframeLinecap=a.wireframeLinecap;this.wireframeLinejoin=a.wireframeLinejoin;this.vertexColors=
a.vertexColors;this.skinning=a.skinning;this.morphTargets=a.morphTargets;this.morphNormals=a.morphNormals;return this};
THREE.MeshStandardMaterial=function(a){THREE.Material.call(this);this.defines={STANDARD:""};this.type="MeshStandardMaterial";this.color=new THREE.Color(16777215);this.metalness=this.roughness=.5;this.lightMap=this.map=null;this.lightMapIntensity=1;this.aoMap=null;this.aoMapIntensity=1;this.emissive=new THREE.Color(0);this.emissiveIntensity=1;this.bumpMap=this.emissiveMap=null;this.bumpScale=1;this.normalMap=null;this.normalScale=new THREE.Vector2(1,1);this.displacementMap=null;this.displacementScale=
1;this.displacementBias=0;this.envMap=this.alphaMap=this.metalnessMap=this.roughnessMap=null;this.envMapIntensity=1;this.refractionRatio=.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=THREE.NoColors;this.morphNormals=this.morphTargets=this.skinning=!1;this.setValues(a)};THREE.MeshStandardMaterial.prototype=Object.create(THREE.Material.prototype);
THREE.MeshStandardMaterial.prototype.constructor=THREE.MeshStandardMaterial;
THREE.MeshStandardMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.defines={STANDARD:""};this.color.copy(a.color);this.roughness=a.roughness;this.metalness=a.metalness;this.map=a.map;this.lightMap=a.lightMap;this.lightMapIntensity=a.lightMapIntensity;this.aoMap=a.aoMap;this.aoMapIntensity=a.aoMapIntensity;this.emissive.copy(a.emissive);this.emissiveMap=a.emissiveMap;this.emissiveIntensity=a.emissiveIntensity;this.bumpMap=a.bumpMap;this.bumpScale=a.bumpScale;this.normalMap=
a.normalMap;this.normalScale.copy(a.normalScale);this.displacementMap=a.displacementMap;this.displacementScale=a.displacementScale;this.displacementBias=a.displacementBias;this.roughnessMap=a.roughnessMap;this.metalnessMap=a.metalnessMap;this.alphaMap=a.alphaMap;this.envMap=a.envMap;this.envMapIntensity=a.envMapIntensity;this.refractionRatio=a.refractionRatio;this.fog=a.fog;this.shading=a.shading;this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;this.wireframeLinecap=a.wireframeLinecap;
this.wireframeLinejoin=a.wireframeLinejoin;this.vertexColors=a.vertexColors;this.skinning=a.skinning;this.morphTargets=a.morphTargets;this.morphNormals=a.morphNormals;return this};THREE.MeshPhysicalMaterial=function(a){THREE.MeshStandardMaterial.call(this);this.defines={PHYSICAL:""};this.type="MeshPhysicalMaterial";this.reflectivity=.5;this.setValues(a)};THREE.MeshPhysicalMaterial.prototype=Object.create(THREE.MeshStandardMaterial.prototype);THREE.MeshPhysicalMaterial.prototype.constructor=THREE.MeshPhysicalMaterial;
THREE.MeshPhysicalMaterial.prototype.copy=function(a){THREE.MeshStandardMaterial.prototype.copy.call(this,a);this.defines={PHYSICAL:""};this.reflectivity=a.reflectivity;return this};THREE.MultiMaterial=function(a){this.uuid=THREE.Math.generateUUID();this.type="MultiMaterial";this.materials=a instanceof Array?a:[];this.visible=!0};
THREE.MultiMaterial.prototype={constructor:THREE.MultiMaterial,toJSON:function(a){for(var b={metadata:{version:4.2,type:"material",generator:"MaterialExporter"},uuid:this.uuid,type:this.type,materials:[]},c=this.materials,d=0,e=c.length;d<e;d++){var f=c[d].toJSON(a);delete f.metadata;b.materials.push(f)}b.visible=this.visible;return b},clone:function(){for(var a=new this.constructor,b=0;b<this.materials.length;b++)a.materials.push(this.materials[b].clone());a.visible=this.visible;return a}};
THREE.PointsMaterial=function(a){THREE.Material.call(this);this.type="PointsMaterial";this.color=new THREE.Color(16777215);this.map=null;this.size=1;this.sizeAttenuation=!0;this.blending=THREE.NormalBlending;this.vertexColors=THREE.NoColors;this.fog=!0;this.setValues(a)};THREE.PointsMaterial.prototype=Object.create(THREE.Material.prototype);THREE.PointsMaterial.prototype.constructor=THREE.PointsMaterial;
THREE.PointsMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.map=a.map;this.size=a.size;this.sizeAttenuation=a.sizeAttenuation;this.vertexColors=a.vertexColors;this.fog=a.fog;return this};
THREE.ShaderMaterial=function(a){THREE.Material.call(this);this.type="ShaderMaterial";this.defines={};this.uniforms={};this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}";this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}";this.shading=THREE.SmoothShading;this.linewidth=1;this.wireframe=!1;this.wireframeLinewidth=1;this.clipping=this.lights=this.fog=!1;this.vertexColors=THREE.NoColors;this.morphNormals=
this.morphTargets=this.skinning=!1;this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1};this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]};this.index0AttributeName=void 0;void 0!==a&&(void 0!==a.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(a))};THREE.ShaderMaterial.prototype=Object.create(THREE.Material.prototype);THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;
THREE.ShaderMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.fragmentShader=a.fragmentShader;this.vertexShader=a.vertexShader;this.uniforms=THREE.UniformsUtils.clone(a.uniforms);this.defines=a.defines;this.shading=a.shading;this.wireframe=a.wireframe;this.wireframeLinewidth=a.wireframeLinewidth;this.fog=a.fog;this.lights=a.lights;this.clipping=a.clipping;this.vertexColors=a.vertexColors;this.skinning=a.skinning;this.morphTargets=a.morphTargets;this.morphNormals=
a.morphNormals;this.extensions=a.extensions;return this};THREE.ShaderMaterial.prototype.toJSON=function(a){a=THREE.Material.prototype.toJSON.call(this,a);a.uniforms=this.uniforms;a.vertexShader=this.vertexShader;a.fragmentShader=this.fragmentShader;return a};THREE.RawShaderMaterial=function(a){THREE.ShaderMaterial.call(this,a);this.type="RawShaderMaterial"};THREE.RawShaderMaterial.prototype=Object.create(THREE.ShaderMaterial.prototype);THREE.RawShaderMaterial.prototype.constructor=THREE.RawShaderMaterial;
THREE.SpriteMaterial=function(a){THREE.Material.call(this);this.type="SpriteMaterial";this.color=new THREE.Color(16777215);this.map=null;this.rotation=0;this.fog=!1;this.setValues(a)};THREE.SpriteMaterial.prototype=Object.create(THREE.Material.prototype);THREE.SpriteMaterial.prototype.constructor=THREE.SpriteMaterial;THREE.SpriteMaterial.prototype.copy=function(a){THREE.Material.prototype.copy.call(this,a);this.color.copy(a.color);this.map=a.map;this.rotation=a.rotation;this.fog=a.fog;return this};
THREE.Texture=function(a,b,c,d,e,f,g,h,k,l){Object.defineProperty(this,"id",{value:THREE.TextureIdCount++});this.uuid=THREE.Math.generateUUID();this.sourceFile=this.name="";this.image=void 0!==a?a:THREE.Texture.DEFAULT_IMAGE;this.mipmaps=[];this.mapping=void 0!==b?b:THREE.Texture.DEFAULT_MAPPING;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==f?f:THREE.LinearMipMapLinearFilter;
this.anisotropy=void 0!==k?k:1;this.format=void 0!==g?g:THREE.RGBAFormat;this.type=void 0!==h?h:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=!0;this.premultiplyAlpha=!1;this.flipY=!0;this.unpackAlignment=4;this.encoding=void 0!==l?l:THREE.LinearEncoding;this.version=0;this.onUpdate=null};THREE.Texture.DEFAULT_IMAGE=void 0;THREE.Texture.DEFAULT_MAPPING=THREE.UVMapping;
THREE.Texture.prototype={constructor:THREE.Texture,set needsUpdate(a){!0===a&&this.version++},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.image=a.image;this.mipmaps=a.mipmaps.slice(0);this.mapping=a.mapping;this.wrapS=a.wrapS;this.wrapT=a.wrapT;this.magFilter=a.magFilter;this.minFilter=a.minFilter;this.anisotropy=a.anisotropy;this.format=a.format;this.type=a.type;this.offset.copy(a.offset);this.repeat.copy(a.repeat);this.generateMipmaps=a.generateMipmaps;this.premultiplyAlpha=
a.premultiplyAlpha;this.flipY=a.flipY;this.unpackAlignment=a.unpackAlignment;this.encoding=a.encoding;return this},toJSON:function(a){if(void 0!==a.textures[this.uuid])return a.textures[this.uuid];var b={metadata:{version:4.4,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],wrap:[this.wrapS,this.wrapT],minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy};
if(void 0!==this.image){var c=this.image;void 0===c.uuid&&(c.uuid=THREE.Math.generateUUID());if(void 0===a.images[c.uuid]){var d=a.images,e=c.uuid,f=c.uuid,g;void 0!==c.toDataURL?g=c:(g=document.createElement("canvas"),g.width=c.width,g.height=c.height,g.getContext("2d").drawImage(c,0,0,c.width,c.height));g=2048<g.width||2048<g.height?g.toDataURL("image/jpeg",.6):g.toDataURL("image/png");d[e]={uuid:f,url:g}}b.image=c.uuid}return a.textures[this.uuid]=b},dispose:function(){this.dispatchEvent({type:"dispose"})},
transformUv:function(a){if(this.mapping===THREE.UVMapping){a.multiply(this.repeat);a.add(this.offset);if(0>a.x||1<a.x)switch(this.wrapS){case THREE.RepeatWrapping:a.x-=Math.floor(a.x);break;case THREE.ClampToEdgeWrapping:a.x=0>a.x?0:1;break;case THREE.MirroredRepeatWrapping:1===Math.abs(Math.floor(a.x)%2)?a.x=Math.ceil(a.x)-a.x:a.x-=Math.floor(a.x)}if(0>a.y||1<a.y)switch(this.wrapT){case THREE.RepeatWrapping:a.y-=Math.floor(a.y);break;case THREE.ClampToEdgeWrapping:a.y=0>a.y?0:1;break;case THREE.MirroredRepeatWrapping:1===
Math.abs(Math.floor(a.y)%2)?a.y=Math.ceil(a.y)-a.y:a.y-=Math.floor(a.y)}this.flipY&&(a.y=1-a.y)}}};THREE.EventDispatcher.prototype.apply(THREE.Texture.prototype);THREE.TextureIdCount=0;THREE.DepthTexture=function(a,b,c,d,e,f,g,h,k){THREE.Texture.call(this,null,d,e,f,g,h,THREE.DepthFormat,c,k);this.image={width:a,height:b};this.type=void 0!==c?c:THREE.UnsignedShortType;this.magFilter=void 0!==g?g:THREE.NearestFilter;this.minFilter=void 0!==h?h:THREE.NearestFilter;this.generateMipmaps=this.flipY=!1};
THREE.DepthTexture.prototype=Object.create(THREE.Texture.prototype);THREE.DepthTexture.prototype.constructor=THREE.DepthTexture;THREE.CanvasTexture=function(a,b,c,d,e,f,g,h,k){THREE.Texture.call(this,a,b,c,d,e,f,g,h,k);this.needsUpdate=!0};THREE.CanvasTexture.prototype=Object.create(THREE.Texture.prototype);THREE.CanvasTexture.prototype.constructor=THREE.CanvasTexture;
THREE.CubeTexture=function(a,b,c,d,e,f,g,h,k,l){a=void 0!==a?a:[];b=void 0!==b?b:THREE.CubeReflectionMapping;THREE.Texture.call(this,a,b,c,d,e,f,g,h,k,l);this.flipY=!1};THREE.CubeTexture.prototype=Object.create(THREE.Texture.prototype);THREE.CubeTexture.prototype.constructor=THREE.CubeTexture;Object.defineProperty(THREE.CubeTexture.prototype,"images",{get:function(){return this.image},set:function(a){this.image=a}});
THREE.CompressedTexture=function(a,b,c,d,e,f,g,h,k,l,n,p){THREE.Texture.call(this,null,f,g,h,k,l,d,e,n,p);this.image={width:b,height:c};this.mipmaps=a;this.generateMipmaps=this.flipY=!1};THREE.CompressedTexture.prototype=Object.create(THREE.Texture.prototype);THREE.CompressedTexture.prototype.constructor=THREE.CompressedTexture;
THREE.DataTexture=function(a,b,c,d,e,f,g,h,k,l,n,p){THREE.Texture.call(this,null,f,g,h,k,l,d,e,n,p);this.image={data:a,width:b,height:c};this.magFilter=void 0!==k?k:THREE.NearestFilter;this.minFilter=void 0!==l?l:THREE.NearestFilter;this.generateMipmaps=this.flipY=!1};THREE.DataTexture.prototype=Object.create(THREE.Texture.prototype);THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.VideoTexture=function(a,b,c,d,e,f,g,h,k){function l(){requestAnimationFrame(l);a.readyState>=a.HAVE_CURRENT_DATA&&(n.needsUpdate=!0)}THREE.Texture.call(this,a,b,c,d,e,f,g,h,k);this.generateMipmaps=!1;var n=this;l()};THREE.VideoTexture.prototype=Object.create(THREE.Texture.prototype);THREE.VideoTexture.prototype.constructor=THREE.VideoTexture;THREE.Group=function(){THREE.Object3D.call(this);this.type="Group"};THREE.Group.prototype=Object.create(THREE.Object3D.prototype);
THREE.Group.prototype.constructor=THREE.Group;THREE.Points=function(a,b){THREE.Object3D.call(this);this.type="Points";this.geometry=void 0!==a?a:new THREE.Geometry;this.material=void 0!==b?b:new THREE.PointsMaterial({color:16777215*Math.random()})};THREE.Points.prototype=Object.create(THREE.Object3D.prototype);THREE.Points.prototype.constructor=THREE.Points;
THREE.Points.prototype.raycast=function(){var a=new THREE.Matrix4,b=new THREE.Ray,c=new THREE.Sphere;return function(d,e){function f(a,c){var f=b.distanceSqToPoint(a);if(f<n){var h=b.closestPointToPoint(a);h.applyMatrix4(k);var m=d.ray.origin.distanceTo(h);m<d.near||m>d.far||e.push({distance:m,distanceToRay:Math.sqrt(f),point:h.clone(),index:c,face:null,object:g})}}var g=this,h=this.geometry,k=this.matrixWorld,l=d.params.Points.threshold;null===h.boundingSphere&&h.computeBoundingSphere();c.copy(h.boundingSphere);
c.applyMatrix4(k);if(!1!==d.ray.intersectsSphere(c)){a.getInverse(k);b.copy(d.ray).applyMatrix4(a);var l=l/((this.scale.x+this.scale.y+this.scale.z)/3),n=l*l,l=new THREE.Vector3;if(h instanceof THREE.BufferGeometry){var p=h.index,h=h.attributes.position.array;if(null!==p)for(var m=p.array,p=0,q=m.length;p<q;p++){var r=m[p];l.fromArray(h,3*r);f(l,r)}else for(p=0,m=h.length/3;p<m;p++)l.fromArray(h,3*p),f(l,p)}else for(l=h.vertices,p=0,m=l.length;p<m;p++)f(l[p],p)}}}();
THREE.Points.prototype.clone=function(){return(new this.constructor(this.geometry,this.material)).copy(this)};THREE.Line=function(a,b,c){if(1===c)return console.warn("THREE.Line: parameter THREE.LinePieces no longer supported. Created THREE.LineSegments instead."),new THREE.LineSegments(a,b);THREE.Object3D.call(this);this.type="Line";this.geometry=void 0!==a?a:new THREE.Geometry;this.material=void 0!==b?b:new THREE.LineBasicMaterial({color:16777215*Math.random()})};THREE.Line.prototype=Object.create(THREE.Object3D.prototype);
THREE.Line.prototype.constructor=THREE.Line;
THREE.Line.prototype.raycast=function(){var a=new THREE.Matrix4,b=new THREE.Ray,c=new THREE.Sphere;return function(d,e){var f=d.linePrecision,f=f*f,g=this.geometry,h=this.matrixWorld;null===g.boundingSphere&&g.computeBoundingSphere();c.copy(g.boundingSphere);c.applyMatrix4(h);if(!1!==d.ray.intersectsSphere(c)){a.getInverse(h);b.copy(d.ray).applyMatrix4(a);var k=new THREE.Vector3,l=new THREE.Vector3,h=new THREE.Vector3,n=new THREE.Vector3,p=this instanceof THREE.LineSegments?2:1;if(g instanceof THREE.BufferGeometry){var m=
g.index,q=g.attributes.position.array;if(null!==m)for(var m=m.array,g=0,r=m.length-1;g<r;g+=p){var s=m[g+1];k.fromArray(q,3*m[g]);l.fromArray(q,3*s);s=b.distanceSqToSegment(k,l,n,h);s>f||(n.applyMatrix4(this.matrixWorld),s=d.ray.origin.distanceTo(n),s<d.near||s>d.far||e.push({distance:s,point:h.clone().applyMatrix4(this.matrixWorld),index:g,face:null,faceIndex:null,object:this}))}else for(g=0,r=q.length/3-1;g<r;g+=p)k.fromArray(q,3*g),l.fromArray(q,3*g+3),s=b.distanceSqToSegment(k,l,n,h),s>f||(n.applyMatrix4(this.matrixWorld),
s=d.ray.origin.distanceTo(n),s<d.near||s>d.far||e.push({distance:s,point:h.clone().applyMatrix4(this.matrixWorld),index:g,face:null,faceIndex:null,object:this}))}else if(g instanceof THREE.Geometry)for(k=g.vertices,l=k.length,g=0;g<l-1;g+=p)s=b.distanceSqToSegment(k[g],k[g+1],n,h),s>f||(n.applyMatrix4(this.matrixWorld),s=d.ray.origin.distanceTo(n),s<d.near||s>d.far||e.push({distance:s,point:h.clone().applyMatrix4(this.matrixWorld),index:g,face:null,faceIndex:null,object:this}))}}}();
THREE.Line.prototype.clone=function(){return(new this.constructor(this.geometry,this.material)).copy(this)};THREE.LineStrip=0;THREE.LinePieces=1;THREE.LineSegments=function(a,b){THREE.Line.call(this,a,b);this.type="LineSegments"};THREE.LineSegments.prototype=Object.create(THREE.Line.prototype);THREE.LineSegments.prototype.constructor=THREE.LineSegments;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.type="Mesh";this.geometry=void 0!==a?a:new THREE.Geometry;this.material=void 0!==b?b:new THREE.MeshBasicMaterial({color:16777215*Math.random()});this.drawMode=THREE.TrianglesDrawMode;this.updateMorphTargets()};THREE.Mesh.prototype=Object.create(THREE.Object3D.prototype);THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.setDrawMode=function(a){this.drawMode=a};
THREE.Mesh.prototype.updateMorphTargets=function(){if(void 0!==this.geometry.morphTargets&&0<this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var a=0,b=this.geometry.morphTargets.length;a<b;a++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[a].name]=a}};
THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.warn("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Mesh.prototype.raycast=function(){function a(a,b,c,d,e,f,g){THREE.Triangle.barycoordFromPoint(a,b,c,d,s);e.multiplyScalar(s.x);f.multiplyScalar(s.y);g.multiplyScalar(s.z);e.add(f).add(g);return e.clone()}function b(a,b,c,d,e,f,g){var h=a.material;if(null===(h.side===THREE.BackSide?c.intersectTriangle(f,e,d,!0,g):c.intersectTriangle(d,e,f,h.side!==THREE.DoubleSide,g)))return null;v.copy(g);v.applyMatrix4(a.matrixWorld);c=b.ray.origin.distanceTo(v);return c<b.near||c>b.far?null:{distance:c,point:v.clone(),
object:a}}function c(c,d,e,f,l,n,p,s){g.fromArray(f,3*n);h.fromArray(f,3*p);k.fromArray(f,3*s);if(c=b(c,d,e,g,h,k,u))l&&(m.fromArray(l,2*n),q.fromArray(l,2*p),r.fromArray(l,2*s),c.uv=a(u,g,h,k,m,q,r)),c.face=new THREE.Face3(n,p,s,THREE.Triangle.normal(g,h,k)),c.faceIndex=n;return c}var d=new THREE.Matrix4,e=new THREE.Ray,f=new THREE.Sphere,g=new THREE.Vector3,h=new THREE.Vector3,k=new THREE.Vector3,l=new THREE.Vector3,n=new THREE.Vector3,p=new THREE.Vector3,m=new THREE.Vector2,q=new THREE.Vector2,
r=new THREE.Vector2,s=new THREE.Vector3,u=new THREE.Vector3,v=new THREE.Vector3;return function(s,v){var w=this.geometry,B=this.material,z=this.matrixWorld;if(void 0!==B&&(null===w.boundingSphere&&w.computeBoundingSphere(),f.copy(w.boundingSphere),f.applyMatrix4(z),!1!==s.ray.intersectsSphere(f)&&(d.getInverse(z),e.copy(s.ray).applyMatrix4(d),null===w.boundingBox||!1!==e.intersectsBox(w.boundingBox)))){var y,C;if(w instanceof THREE.BufferGeometry){var J,D,B=w.index,z=w.attributes,w=z.position.array;
void 0!==z.uv&&(y=z.uv.array);if(null!==B)for(var z=B.array,H=0,G=z.length;H<G;H+=3){if(B=z[H],J=z[H+1],D=z[H+2],C=c(this,s,e,w,y,B,J,D))C.faceIndex=Math.floor(H/3),v.push(C)}else for(H=0,G=w.length;H<G;H+=9)if(B=H/3,J=B+1,D=B+2,C=c(this,s,e,w,y,B,J,D))C.index=B,v.push(C)}else if(w instanceof THREE.Geometry){var K,P,z=B instanceof THREE.MultiMaterial,H=!0===z?B.materials:null,G=w.vertices;J=w.faces;D=w.faceVertexUvs[0];0<D.length&&(y=D);for(var I=0,L=J.length;I<L;I++){var E=J[I];C=!0===z?H[E.materialIndex]:
B;if(void 0!==C){D=G[E.a];K=G[E.b];P=G[E.c];if(!0===C.morphTargets){C=w.morphTargets;var M=this.morphTargetInfluences;g.set(0,0,0);h.set(0,0,0);k.set(0,0,0);for(var O=0,Q=C.length;O<Q;O++){var R=M[O];if(0!==R){var F=C[O].vertices;g.addScaledVector(l.subVectors(F[E.a],D),R);h.addScaledVector(n.subVectors(F[E.b],K),R);k.addScaledVector(p.subVectors(F[E.c],P),R)}}g.add(D);h.add(K);k.add(P);D=g;K=h;P=k}if(C=b(this,s,e,D,K,P,u))y&&(M=y[I],m.copy(M[0]),q.copy(M[1]),r.copy(M[2]),C.uv=a(u,D,K,P,m,q,r)),C.face=
E,C.faceIndex=I,v.push(C)}}}}}}();THREE.Mesh.prototype.clone=function(){return(new this.constructor(this.geometry,this.material)).copy(this)};THREE.Bone=function(a){THREE.Object3D.call(this);this.type="Bone";this.skin=a};THREE.Bone.prototype=Object.create(THREE.Object3D.prototype);THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.copy=function(a){THREE.Object3D.prototype.copy.call(this,a);this.skin=a.skin;return this};
THREE.Skeleton=function(a,b,c){this.useVertexTexture=void 0!==c?c:!0;this.identityMatrix=new THREE.Matrix4;a=a||[];this.bones=a.slice(0);this.useVertexTexture?(a=Math.sqrt(4*this.bones.length),a=THREE.Math.nextPowerOfTwo(Math.ceil(a)),this.boneTextureHeight=this.boneTextureWidth=a=Math.max(a,4),this.boneMatrices=new Float32Array(this.boneTextureWidth*this.boneTextureHeight*4),this.boneTexture=new THREE.DataTexture(this.boneMatrices,this.boneTextureWidth,this.boneTextureHeight,THREE.RGBAFormat,THREE.FloatType)):
this.boneMatrices=new Float32Array(16*this.bones.length);if(void 0===b)this.calculateInverses();else if(this.bones.length===b.length)this.boneInverses=b.slice(0);else for(console.warn("THREE.Skeleton bonInverses is the wrong length."),this.boneInverses=[],b=0,a=this.bones.length;b<a;b++)this.boneInverses.push(new THREE.Matrix4)};
THREE.Skeleton.prototype.calculateInverses=function(){this.boneInverses=[];for(var a=0,b=this.bones.length;a<b;a++){var c=new THREE.Matrix4;this.bones[a]&&c.getInverse(this.bones[a].matrixWorld);this.boneInverses.push(c)}};
THREE.Skeleton.prototype.pose=function(){for(var a,b=0,c=this.bones.length;b<c;b++)(a=this.bones[b])&&a.matrixWorld.getInverse(this.boneInverses[b]);b=0;for(c=this.bones.length;b<c;b++)if(a=this.bones[b])a.parent?(a.matrix.getInverse(a.parent.matrixWorld),a.matrix.multiply(a.matrixWorld)):a.matrix.copy(a.matrixWorld),a.matrix.decompose(a.position,a.quaternion,a.scale)};
THREE.Skeleton.prototype.update=function(){var a=new THREE.Matrix4;return function(){for(var b=0,c=this.bones.length;b<c;b++)a.multiplyMatrices(this.bones[b]?this.bones[b].matrixWorld:this.identityMatrix,this.boneInverses[b]),a.toArray(this.boneMatrices,16*b);this.useVertexTexture&&(this.boneTexture.needsUpdate=!0)}}();THREE.Skeleton.prototype.clone=function(){return new THREE.Skeleton(this.bones,this.boneInverses,this.useVertexTexture)};
THREE.SkinnedMesh=function(a,b,c){THREE.Mesh.call(this,a,b);this.type="SkinnedMesh";this.bindMode="attached";this.bindMatrix=new THREE.Matrix4;this.bindMatrixInverse=new THREE.Matrix4;a=[];if(this.geometry&&void 0!==this.geometry.bones){for(var d,e=0,f=this.geometry.bones.length;e<f;++e)d=this.geometry.bones[e],b=new THREE.Bone(this),a.push(b),b.name=d.name,b.position.fromArray(d.pos),b.quaternion.fromArray(d.rotq),void 0!==d.scl&&b.scale.fromArray(d.scl);e=0;for(f=this.geometry.bones.length;e<f;++e)d=
this.geometry.bones[e],-1!==d.parent&&null!==d.parent&&void 0!==a[d.parent]?a[d.parent].add(a[e]):this.add(a[e])}this.normalizeSkinWeights();this.updateMatrixWorld(!0);this.bind(new THREE.Skeleton(a,void 0,c),this.matrixWorld)};THREE.SkinnedMesh.prototype=Object.create(THREE.Mesh.prototype);THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.bind=function(a,b){this.skeleton=a;void 0===b&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),b=this.matrixWorld);this.bindMatrix.copy(b);this.bindMatrixInverse.getInverse(b)};THREE.SkinnedMesh.prototype.pose=function(){this.skeleton.pose()};
THREE.SkinnedMesh.prototype.normalizeSkinWeights=function(){if(this.geometry instanceof THREE.Geometry)for(var a=0;a<this.geometry.skinWeights.length;a++){var b=this.geometry.skinWeights[a],c=1/b.lengthManhattan();Infinity!==c?b.multiplyScalar(c):b.set(1,0,0,0)}else if(this.geometry instanceof THREE.BufferGeometry)for(var b=new THREE.Vector4,d=this.geometry.attributes.skinWeight,a=0;a<d.count;a++)b.x=d.getX(a),b.y=d.getY(a),b.z=d.getZ(a),b.w=d.getW(a),c=1/b.lengthManhattan(),Infinity!==c?b.multiplyScalar(c):
b.set(1,0,0,0),d.setXYZW(a,b.x,b.y,b.z,b.w)};THREE.SkinnedMesh.prototype.updateMatrixWorld=function(a){THREE.Mesh.prototype.updateMatrixWorld.call(this,!0);"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh unrecognized bindMode: "+this.bindMode)};THREE.SkinnedMesh.prototype.clone=function(){return(new this.constructor(this.geometry,this.material,this.useVertexTexture)).copy(this)};
THREE.LOD=function(){THREE.Object3D.call(this);this.type="LOD";Object.defineProperties(this,{levels:{enumerable:!0,value:[]}})};THREE.LOD.prototype=Object.create(THREE.Object3D.prototype);THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.addLevel=function(a,b){void 0===b&&(b=0);b=Math.abs(b);for(var c=this.levels,d=0;d<c.length&&!(b<c[d].distance);d++);c.splice(d,0,{distance:b,object:a});this.add(a)};
THREE.LOD.prototype.getObjectForDistance=function(a){for(var b=this.levels,c=1,d=b.length;c<d&&!(a<b[c].distance);c++);return b[c-1].object};THREE.LOD.prototype.raycast=function(){var a=new THREE.Vector3;return function(b,c){a.setFromMatrixPosition(this.matrixWorld);var d=b.ray.origin.distanceTo(a);this.getObjectForDistance(d).raycast(b,c)}}();
THREE.LOD.prototype.update=function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c){var d=this.levels;if(1<d.length){a.setFromMatrixPosition(c.matrixWorld);b.setFromMatrixPosition(this.matrixWorld);c=a.distanceTo(b);d[0].object.visible=!0;for(var e=1,f=d.length;e<f;e++)if(c>=d[e].distance)d[e-1].object.visible=!1,d[e].object.visible=!0;else break;for(;e<f;e++)d[e].object.visible=!1}}}();
THREE.LOD.prototype.copy=function(a){THREE.Object3D.prototype.copy.call(this,a,!1);a=a.levels;for(var b=0,c=a.length;b<c;b++){var d=a[b];this.addLevel(d.object.clone(),d.distance)}return this};THREE.LOD.prototype.toJSON=function(a){a=THREE.Object3D.prototype.toJSON.call(this,a);a.object.levels=[];for(var b=this.levels,c=0,d=b.length;c<d;c++){var e=b[c];a.object.levels.push({object:e.object.uuid,distance:e.distance})}return a};
THREE.Sprite=function(){var a=new Uint16Array([0,1,2,0,2,3]),b=new Float32Array([-.5,-.5,0,.5,-.5,0,.5,.5,0,-.5,.5,0]),c=new Float32Array([0,0,1,0,1,1,0,1]),d=new THREE.BufferGeometry;d.setIndex(new THREE.BufferAttribute(a,1));d.addAttribute("position",new THREE.BufferAttribute(b,3));d.addAttribute("uv",new THREE.BufferAttribute(c,2));return function(a){THREE.Object3D.call(this);this.type="Sprite";this.geometry=d;this.material=void 0!==a?a:new THREE.SpriteMaterial}}();THREE.Sprite.prototype=Object.create(THREE.Object3D.prototype);
THREE.Sprite.prototype.constructor=THREE.Sprite;THREE.Sprite.prototype.raycast=function(){var a=new THREE.Vector3;return function(b,c){a.setFromMatrixPosition(this.matrixWorld);var d=b.ray.distanceSqToPoint(a);d>this.scale.x*this.scale.y/4||c.push({distance:Math.sqrt(d),point:this.position,face:null,object:this})}}();THREE.Sprite.prototype.clone=function(){return(new this.constructor(this.material)).copy(this)};THREE.Particle=THREE.Sprite;
THREE.LensFlare=function(a,b,c,d,e){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=void 0;void 0!==a&&this.add(a,b,c,d,e)};THREE.LensFlare.prototype=Object.create(THREE.Object3D.prototype);THREE.LensFlare.prototype.constructor=THREE.LensFlare;
THREE.LensFlare.prototype.add=function(a,b,c,d,e,f){void 0===b&&(b=-1);void 0===c&&(c=0);void 0===f&&(f=1);void 0===e&&(e=new THREE.Color(16777215));void 0===d&&(d=THREE.NormalBlending);c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:a,size:b,distance:c,x:0,y:0,z:0,scale:1,rotation:0,opacity:f,color:e,blending:d})};
THREE.LensFlare.prototype.updateLensFlares=function(){var a,b=this.lensFlares.length,c,d=2*-this.positionScreen.x,e=2*-this.positionScreen.y;for(a=0;a<b;a++)c=this.lensFlares[a],c.x=this.positionScreen.x+d*c.distance,c.y=this.positionScreen.y+e*c.distance,c.wantedRotation=c.x*Math.PI*.25,c.rotation+=.25*(c.wantedRotation-c.rotation)};
THREE.LensFlare.prototype.copy=function(a){THREE.Object3D.prototype.copy.call(this,a);this.positionScreen.copy(a.positionScreen);this.customUpdateCallback=a.customUpdateCallback;for(var b=0,c=a.lensFlares.length;b<c;b++)this.lensFlares.push(a.lensFlares[b]);return this};THREE.Scene=function(){THREE.Object3D.call(this);this.type="Scene";this.overrideMaterial=this.fog=null;this.autoUpdate=!0};THREE.Scene.prototype=Object.create(THREE.Object3D.prototype);THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.copy=function(a,b){THREE.Object3D.prototype.copy.call(this,a,b);null!==a.fog&&(this.fog=a.fog.clone());null!==a.overrideMaterial&&(this.overrideMaterial=a.overrideMaterial.clone());this.autoUpdate=a.autoUpdate;this.matrixAutoUpdate=a.matrixAutoUpdate;return this};THREE.Fog=function(a,b,c){this.name="";this.color=new THREE.Color(a);this.near=void 0!==b?b:1;this.far=void 0!==c?c:1E3};THREE.Fog.prototype.clone=function(){return new THREE.Fog(this.color.getHex(),this.near,this.far)};
THREE.FogExp2=function(a,b){this.name="";this.color=new THREE.Color(a);this.density=void 0!==b?b:2.5E-4};THREE.FogExp2.prototype.clone=function(){return new THREE.FogExp2(this.color.getHex(),this.density)};THREE.ShaderChunk={};THREE.ShaderChunk.alphamap_fragment="#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n";THREE.ShaderChunk.alphamap_pars_fragment="#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif\n";THREE.ShaderChunk.alphatest_fragment="#ifdef ALPHATEST\n\tif ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n";
THREE.ShaderChunk.aomap_fragment="#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n\t#endif\n#endif\n";THREE.ShaderChunk.aomap_pars_fragment="#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif";
THREE.ShaderChunk.begin_vertex="\nvec3 transformed = vec3( position );\n";THREE.ShaderChunk.beginnormal_vertex="\nvec3 objectNormal = vec3( normal );\n";THREE.ShaderChunk.bsdfs="bool testLightInRange( const in float lightDistance, const in float cutoffDistance ) {\n\treturn any( bvec2( cutoffDistance == 0.0, lightDistance < cutoffDistance ) );\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\t\tif( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\t\t\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\t\t\tfloat maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t\t\treturn distanceFalloff * maxDistanceCutoffFactor;\n#else\n\t\t\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n\t\t}\n\t\treturn 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\treturn 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( G * D );\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n\treturn specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\n\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, dotLH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n";
THREE.ShaderChunk.bumpmap_pars_fragment="#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n\t\tvec3 vSigmaX = dFdx( surf_pos );\n\t\tvec3 vSigmaY = dFdy( surf_pos );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 );\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif\n";
THREE.ShaderChunk.clipping_planes_fragment="#if NUM_CLIPPING_PLANES > 0\n\tfor ( int i = 0; i < NUM_CLIPPING_PLANES; ++ i ) {\n\t\tvec4 plane = clippingPlanes[ i ];\n\t\tif ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n\t}\n#endif\n";THREE.ShaderChunk.clipping_planes_pars_fragment="#if NUM_CLIPPING_PLANES > 0\n\t#if ! defined( PHYSICAL ) && ! defined( PHONG )\n\t\tvarying vec3 vViewPosition;\n\t#endif\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n";
THREE.ShaderChunk.clipping_planes_pars_vertex="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvarying vec3 vViewPosition;\n#endif\n";THREE.ShaderChunk.clipping_planes_vertex="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n";THREE.ShaderChunk.color_fragment="#ifdef USE_COLOR\n\tdiffuseColor.rgb *= vColor;\n#endif";THREE.ShaderChunk.color_pars_fragment="#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif\n";
THREE.ShaderChunk.color_pars_vertex="#ifdef USE_COLOR\n\tvarying vec3 vColor;\n#endif";THREE.ShaderChunk.color_vertex="#ifdef USE_COLOR\n\tvColor.xyz = color.xyz;\n#endif";THREE.ShaderChunk.common="#define PI 3.14159265359\n#define PI2 6.28318530718\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract(sin(sn) * c);\n}\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\tfloat distance = dot( planeNormal, point - pointOnPlane );\n\treturn - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\n";
THREE.ShaderChunk.cube_uv_reflection_fragment="#ifdef ENVMAP_TYPE_CUBE_UV\nconst float cubeUV_textureSize = 1024.0;\nint getFaceFromDirection(vec3 direction) {\n\tvec3 absDirection = abs(direction);\n\tint face = -1;\n\tif( absDirection.x > absDirection.z ) {\n\t\tif(absDirection.x > absDirection.y )\n\t\t\tface = direction.x > 0.0 ? 0 : 3;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\telse {\n\t\tif(absDirection.z > absDirection.y )\n\t\t\tface = direction.z > 0.0 ? 2 : 5;\n\t\telse\n\t\t\tface = direction.y > 0.0 ? 1 : 4;\n\t}\n\treturn face;\n}\nfloat cubeUV_maxLods1 = log2(cubeUV_textureSize*0.25) - 1.0;\nfloat cubeUV_rangeClamp = exp2((6.0 - 1.0) * 2.0);\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n\tfloat scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n\tfloat dxRoughness = dFdx(roughness);\n\tfloat dyRoughness = dFdy(roughness);\n\tvec3 dx = dFdx( vec * scale * dxRoughness );\n\tvec3 dy = dFdy( vec * scale * dyRoughness );\n\tfloat d = max( dot( dx, dx ), dot( dy, dy ) );\n\td = clamp(d, 1.0, cubeUV_rangeClamp);\n\tfloat mipLevel = 0.5 * log2(d);\n\treturn vec2(floor(mipLevel), fract(mipLevel));\n}\nfloat cubeUV_maxLods2 = log2(cubeUV_textureSize*0.25) - 2.0;\nconst float cubeUV_rcpTextureSize = 1.0 / cubeUV_textureSize;\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n\tmipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n\tfloat a = 16.0 * cubeUV_rcpTextureSize;\n\tvec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n\tvec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n\tfloat powScale = exp2_packed.x * exp2_packed.y;\n\tfloat scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n\tfloat mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n\tbool bRes = mipLevel == 0.0;\n\tscale =  bRes && (scale < a) ? a : scale;\n\tvec3 r;\n\tvec2 offset;\n\tint face = getFaceFromDirection(direction);\n\tfloat rcpPowScale = 1.0 / powScale;\n\tif( face == 0) {\n\t\tr = vec3(direction.x, -direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n\t}\n\telse if( face == 1) {\n\t\tr = vec3(direction.y, direction.x, direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n\t}\n\telse if( face == 2) {\n\t\tr = vec3(direction.z, direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n\t}\n\telse if( face == 3) {\n\t\tr = vec3(direction.x, direction.z, direction.y);\n\t\toffset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n\t}\n\telse if( face == 4) {\n\t\tr = vec3(direction.y, direction.x, -direction.z);\n\t\toffset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n\t}\n\telse {\n\t\tr = vec3(direction.z, -direction.x, direction.y);\n\t\toffset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n\t\toffset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n\t}\n\tr = normalize(r);\n\tfloat texelOffset = 0.5 * cubeUV_rcpTextureSize;\n\tvec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n\tvec2 base = offset + vec2( texelOffset );\n\treturn base + s * ( scale - 2.0 * texelOffset );\n}\nfloat cubeUV_maxLods3 = log2(cubeUV_textureSize*0.25) - 3.0;\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n\tfloat roughnessVal = roughness* cubeUV_maxLods3;\n\tfloat r1 = floor(roughnessVal);\n\tfloat r2 = r1 + 1.0;\n\tfloat t = fract(roughnessVal);\n\tvec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n\tfloat s = mipInfo.y;\n\tfloat level0 = mipInfo.x;\n\tfloat level1 = level0 + 1.0;\n\tlevel1 = level1 > 5.0 ? 5.0 : level1;\n\tlevel0 += min( floor( s + 0.5 ), 5.0 );\n\tvec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n\tvec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n\tvec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n\tvec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n\tvec4 result = mix(color10, color20, t);\n\treturn vec4(result.rgb, 1.0);\n}\n#endif\n";
THREE.ShaderChunk.defaultnormal_vertex="#ifdef FLIP_SIDED\n\tobjectNormal = -objectNormal;\n#endif\nvec3 transformedNormal = normalMatrix * objectNormal;\n";THREE.ShaderChunk.displacementmap_vertex="#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normal * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n";THREE.ShaderChunk.displacementmap_pars_vertex="#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif\n";
THREE.ShaderChunk.emissivemap_fragment="#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n";THREE.ShaderChunk.emissivemap_pars_fragment="#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif\n";THREE.ShaderChunk.encodings_pars_fragment="\nvec4 LinearToLinear( in vec4 value ) {\n  return value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n  return vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n  return vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n  return vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n  float maxComponent = max( max( value.r, value.g ), value.b );\n  float fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n  return vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n  return vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n  float maxRGB = max( value.x, max( value.g, value.b ) );\n  float M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n  M            = ceil( M * 255.0 ) / 255.0;\n  return vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n    return vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n    float maxRGB = max( value.x, max( value.g, value.b ) );\n    float D      = max( maxRange / maxRGB, 1.0 );\n    D            = min( floor( D ) / 255.0, 1.0 );\n    return vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n  vec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n  Xp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n  vec4 vResult;\n  vResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n  float Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n  vResult.w = fract(Le);\n  vResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n  return vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n  float Le = value.z * 255.0 + value.w;\n  vec3 Xp_Y_XYZp;\n  Xp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n  Xp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n  Xp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n  vec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n  return vec4( max(vRGB, 0.0), 1.0 );\n}\n";
THREE.ShaderChunk.encodings_fragment="  gl_FragColor = linearToOutputTexel( gl_FragColor );\n";THREE.ShaderChunk.envmap_fragment="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tfloat flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t#else\n\t\tfloat flipNormal = 1.0;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\tvec2 sampleUV;\n\t\tsampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n\t\tsampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\tvec4 envColor = texture2D( envMap, sampleUV );\n\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\tvec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n\t\tvec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n\t#endif\n\tenvColor = envMapTexelToLinear( envColor );\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif\n";
THREE.ShaderChunk.envmap_pars_fragment="#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n\tuniform float reflectivity;\n\tuniform float envMapIntenstiy;\n#endif\n#ifdef USE_ENVMAP\n\t#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n\t\tvarying vec3 vWorldPosition;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\tuniform float flipEnvMap;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif\n";
THREE.ShaderChunk.envmap_pars_vertex="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif\n";THREE.ShaderChunk.envmap_vertex="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif\n";
THREE.ShaderChunk.fog_fragment="#ifdef USE_FOG\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tfloat depth = gl_FragDepthEXT / gl_FragCoord.w;\n\t#else\n\t\tfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n\t#endif\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n";
THREE.ShaderChunk.fog_pars_fragment="#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif";THREE.ShaderChunk.lightmap_fragment="#ifdef USE_LIGHTMAP\n\treflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n";THREE.ShaderChunk.lightmap_pars_fragment="#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif";
THREE.ShaderChunk.lights_lambert_vertex="vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = PI * directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n\t\t#endif\n\t}\n#endif\n";
THREE.ShaderChunk.lights_pars="uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treturn irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tdirectLight.color = directionalLight.color;\n\t\tdirectLight.direction = directionalLight.direction;\n\t\tdirectLight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tif ( testLightInRange( lightDistance, pointLight.distance ) ) {\n\t\t\tdirectLight.color = pointLight.color;\n\t\t\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t\tint shadow;\n\t\tfloat shadowBias;\n\t\tfloat shadowRadius;\n\t\tvec2 shadowMapSize;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tdirectLight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tfloat angleCos = dot( directLight.direction, spotLight.direction );\n\t\tif ( all( bvec2( angleCos > spotLight.coneCos, testLightInRange( lightDistance, spotLight.distance ) ) ) ) {\n\t\t\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\t\tdirectLight.color = spotLight.color;\n\t\t\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tdirectLight.visible = true;\n\t\t} else {\n\t\t\tdirectLight.color = vec3( 0.0 );\n\t\t\tdirectLight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n\t\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tirradiance *= PI;\n\t\t#endif\n\t\treturn irradiance;\n\t}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tfloat flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t#else\n\t\t\tfloat flipNormal = 1.0;\n\t\t#endif\n\t\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n\t\t\tvec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n\t\t#else\n\t\t\tvec4 envMapColor = vec4( 0.0 );\n\t\t#endif\n\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t}\n\tfloat getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\tfloat maxMIPLevelScalar = float( maxMIPLevel );\n\t\tfloat desiredMIPLevel = maxMIPLevelScalar - 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n\t\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n\t}\n\tvec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n\t\t#endif\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tfloat flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n\t\t#else\n\t\t\tfloat flipNormal = 1.0;\n\t\t#endif\n\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\tfloat specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n\t\t#ifdef ENVMAP_TYPE_CUBE\n\t\t\tvec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n\t\t\tvec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n\t\t#elif defined( ENVMAP_TYPE_EQUIREC )\n\t\t\tvec2 sampleUV;\n\t\t\tsampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n\t\t\tsampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#elif defined( ENVMAP_TYPE_SPHERE )\n\t\t\tvec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n\t\t\t#ifdef TEXTURE_LOD_EXT\n\t\t\t\tvec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#else\n\t\t\t\tvec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n\t\t\t#endif\n\t\t\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n\t\t#endif\n\t\treturn envMapColor.rgb * envMapIntensity;\n\t}\n#endif\n";
THREE.ShaderChunk.lights_phong_fragment="BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n";THREE.ShaderChunk.lights_phong_pars_fragment="varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n\tvec3\tdiffuseColor;\n\tvec3\tspecularColor;\n\tfloat\tspecularShininess;\n\tfloat\tspecularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)\n";
THREE.ShaderChunk.lights_physical_fragment="PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n\tmaterial.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( 0.16 * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n#endif\n";THREE.ShaderChunk.lights_physical_pars_fragment="struct PhysicalMaterial {\n\tvec3\tdiffuseColor;\n\tfloat\tspecularRoughness;\n\tvec3\tspecularColor;\n\t#ifndef STANDARD\n\t#endif\n};\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\tirradiance *= PI;\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectSpecular += radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n";
THREE.ShaderChunk.lights_template="\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n\t\t#ifdef USE_SHADOWMAP\n\t\tdirectLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#ifdef USE_LIGHTMAP\n\t\tvec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n\t\t#ifndef PHYSICALLY_CORRECT_LIGHTS\n\t\t\tlightMapIrradiance *= PI;\n\t\t#endif\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n\t\t}\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t \tirradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n\t#endif\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tvec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n\tRE_IndirectSpecular( radiance, geometry, material, reflectedLight );\n#endif\n";
THREE.ShaderChunk.logdepthbuf_fragment="#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n\tgl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n#endif";THREE.ShaderChunk.logdepthbuf_pars_fragment="#ifdef USE_LOGDEPTHBUF\n\tuniform float logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n#endif\n";THREE.ShaderChunk.logdepthbuf_pars_vertex="#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t#endif\n\tuniform float logDepthBufFC;\n#endif";
THREE.ShaderChunk.logdepthbuf_vertex="#ifdef USE_LOGDEPTHBUF\n\tgl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t#else\n\t\tgl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n\t#endif\n#endif\n";THREE.ShaderChunk.map_fragment="#ifdef USE_MAP\n\tvec4 texelColor = texture2D( map, vUv );\n\ttexelColor = mapTexelToLinear( texelColor );\n\tdiffuseColor *= texelColor;\n#endif\n";
THREE.ShaderChunk.map_pars_fragment="#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n";THREE.ShaderChunk.map_particle_fragment="#ifdef USE_MAP\n\tvec4 mapTexel = texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n\tdiffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n";THREE.ShaderChunk.map_particle_pars_fragment="#ifdef USE_MAP\n\tuniform vec4 offsetRepeat;\n\tuniform sampler2D map;\n#endif\n";THREE.ShaderChunk.metalnessmap_fragment="float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.r;\n#endif\n";
THREE.ShaderChunk.metalnessmap_pars_fragment="#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif";THREE.ShaderChunk.morphnormal_vertex="#ifdef USE_MORPHNORMALS\n\tobjectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n\tobjectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n\tobjectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n\tobjectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n";
THREE.ShaderChunk.morphtarget_pars_vertex="#ifdef USE_MORPHTARGETS\n\t#ifndef USE_MORPHNORMALS\n\tuniform float morphTargetInfluences[ 8 ];\n\t#else\n\tuniform float morphTargetInfluences[ 4 ];\n\t#endif\n#endif";THREE.ShaderChunk.morphtarget_vertex="#ifdef USE_MORPHTARGETS\n\ttransformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n\ttransformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n\ttransformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n\ttransformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n\t#ifndef USE_MORPHNORMALS\n\ttransformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n\ttransformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n\ttransformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n\ttransformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n\t#endif\n#endif\n";
THREE.ShaderChunk.normal_fragment="#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n\t#endif\n#endif\n#ifdef USE_NORMALMAP\n\tnormal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n";
THREE.ShaderChunk.normalmap_pars_fragment="#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tvec3 S = normalize( q0 * st1.t - q1 * st0.t );\n\t\tvec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n\t\tvec3 N = normalize( surf_norm );\n\t\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t\tmapN.xy = normalScale * mapN.xy;\n\t\tmat3 tsn = mat3( S, T, N );\n\t\treturn normalize( tsn * mapN );\n\t}\n#endif\n";
THREE.ShaderChunk.packing="vec3 packNormalToRGB( const in vec3 normal ) {\n  return normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n  return 1.0 - 2.0 * rgb.xyz;\n}\nvec4 packDepthToRGBA( const in float value ) {\n\tconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\n\tconst vec4 bit_mask = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\n\tvec4 res = mod( value * bit_shift * vec4( 255 ), vec4( 256 ) ) / vec4( 255 );\n\tres -= res.xxyz * bit_mask;\n\treturn res;\n}\nfloat unpackRGBAToDepth( const in vec4 rgba ) {\n\tconst vec4 bitSh = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\n\treturn dot( rgba, bitSh );\n}\nfloat viewZToOrthoDepth( const in float viewZ, const in float near, const in float far ) {\n  return ( viewZ + near ) / ( near - far );\n}\nfloat OrthoDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n  return linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n  return (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n  return ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n";
THREE.ShaderChunk.premultiplied_alpha_fragment="#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif\n";THREE.ShaderChunk.project_vertex="#ifdef USE_SKINNING\n\tvec4 mvPosition = modelViewMatrix * skinned;\n#else\n\tvec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\n#endif\ngl_Position = projectionMatrix * mvPosition;\n";THREE.ShaderChunk.roughnessmap_fragment="float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.r;\n#endif\n";
THREE.ShaderChunk.roughnessmap_pars_fragment="#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif";THREE.ShaderChunk.shadowmap_pars_fragment="#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tfloat texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n\t\tconst vec2 offset = vec2( 0.0, 1.0 );\n\t\tvec2 texelSize = vec2( 1.0 ) / size;\n\t\tvec2 centroidUV = floor( uv * size + 0.5 ) / size;\n\t\tfloat lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n\t\tfloat lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n\t\tfloat rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n\t\tfloat rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n\t\tvec2 f = fract( uv * size + 0.5 );\n\t\tfloat a = mix( lb, lt, f.y );\n\t\tfloat b = mix( rb, rt, f.y );\n\t\tfloat c = mix( a, b, f.x );\n\t\treturn c;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\treturn (\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn 1.0;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\tfloat dp = ( length( lightToPosition ) - shadowBias ) / 1000.0;\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif\n";
THREE.ShaderChunk.shadowmap_pars_vertex="#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n\t#endif\n#endif\n";
THREE.ShaderChunk.shadowmap_vertex="#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n\t}\n\t#endif\n#endif\n";
THREE.ShaderChunk.shadowmask_pars_fragment="float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHTS > 0\n\tDirectionalLight directionalLight;\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tshadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_SPOT_LIGHTS > 0\n\tSpotLight spotLight;\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tshadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#if NUM_POINT_LIGHTS > 0\n\tPointLight pointLight;\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tshadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n\t}\n\t#endif\n\t#endif\n\treturn shadow;\n}\n";
THREE.ShaderChunk.skinbase_vertex="#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif";THREE.ShaderChunk.skinning_pars_vertex="#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\t#ifdef BONE_TEXTURE\n\t\tuniform sampler2D boneTexture;\n\t\tuniform int boneTextureWidth;\n\t\tuniform int boneTextureHeight;\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tfloat j = i * 4.0;\n\t\t\tfloat x = mod( j, float( boneTextureWidth ) );\n\t\t\tfloat y = floor( j / float( boneTextureWidth ) );\n\t\t\tfloat dx = 1.0 / float( boneTextureWidth );\n\t\t\tfloat dy = 1.0 / float( boneTextureHeight );\n\t\t\ty = dy * ( y + 0.5 );\n\t\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\t\treturn bone;\n\t\t}\n\t#else\n\t\tuniform mat4 boneMatrices[ MAX_BONES ];\n\t\tmat4 getBoneMatrix( const in float i ) {\n\t\t\tmat4 bone = boneMatrices[ int(i) ];\n\t\t\treturn bone;\n\t\t}\n\t#endif\n#endif\n";
THREE.ShaderChunk.skinning_vertex="#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\tskinned  = bindMatrixInverse * skinned;\n#endif\n";THREE.ShaderChunk.skinnormal_vertex="#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n";
THREE.ShaderChunk.specularmap_fragment="float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif";THREE.ShaderChunk.specularmap_pars_fragment="#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif";THREE.ShaderChunk.tonemapping_fragment="#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n";
THREE.ShaderChunk.tonemapping_pars_fragment="#define saturate(a) clamp( a, 0.0, 1.0 )\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n  return toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  color = max( vec3( 0.0 ), color - 0.004 );\n  return pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n";
THREE.ShaderChunk.uv2_pars_fragment="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif";THREE.ShaderChunk.uv2_pars_vertex="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n#endif";THREE.ShaderChunk.uv2_vertex="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = uv2;\n#endif";THREE.ShaderChunk.uv_pars_fragment="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n#endif";
THREE.ShaderChunk.uv_pars_vertex="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvarying vec2 vUv;\n\tuniform vec4 offsetRepeat;\n#endif\n";THREE.ShaderChunk.uv_vertex="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n\tvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif";
THREE.ShaderChunk.worldpos_vertex="#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( PHYSICAL ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n\t#ifdef USE_SKINNING\n\t\tvec4 worldPosition = modelMatrix * skinned;\n\t#else\n\t\tvec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n\t#endif\n#endif\n";
THREE.UniformsUtils={merge:function(a){for(var b={},c=0;c<a.length;c++){var d=this.clone(a[c]),e;for(e in d)b[e]=d[e]}return b},clone:function(a){var b={},c;for(c in a){b[c]={};for(var d in a[c]){var e=a[c][d];e instanceof THREE.Color||e instanceof THREE.Vector2||e instanceof THREE.Vector3||e instanceof THREE.Vector4||e instanceof THREE.Matrix3||e instanceof THREE.Matrix4||e instanceof THREE.Texture?b[c][d]=e.clone():Array.isArray(e)?b[c][d]=e.slice():b[c][d]=e}}return b}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"1f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},specularMap:{type:"t",value:null},alphaMap:{type:"t",value:null},envMap:{type:"t",value:null},flipEnvMap:{type:"1f",value:-1},reflectivity:{type:"1f",value:1},refractionRatio:{type:"1f",value:.98}},aomap:{aoMap:{type:"t",value:null},aoMapIntensity:{type:"1f",value:1}},lightmap:{lightMap:{type:"t",value:null},lightMapIntensity:{type:"1f",
value:1}},emissivemap:{emissiveMap:{type:"t",value:null}},bumpmap:{bumpMap:{type:"t",value:null},bumpScale:{type:"1f",value:1}},normalmap:{normalMap:{type:"t",value:null},normalScale:{type:"v2",value:new THREE.Vector2(1,1)}},displacementmap:{displacementMap:{type:"t",value:null},displacementScale:{type:"1f",value:1},displacementBias:{type:"1f",value:0}},roughnessmap:{roughnessMap:{type:"t",value:null}},metalnessmap:{metalnessMap:{type:"t",value:null}},fog:{fogDensity:{type:"1f",value:2.5E-4},fogNear:{type:"1f",
value:1},fogFar:{type:"1f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"3fv",value:[]},directionalLights:{type:"sa",value:[],properties:{direction:{type:"v3"},color:{type:"c"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},directionalShadowMap:{type:"tv",value:[]},directionalShadowMatrix:{type:"m4v",value:[]},spotLights:{type:"sa",value:[],properties:{color:{type:"c"},position:{type:"v3"},direction:{type:"v3"},
distance:{type:"1f"},coneCos:{type:"1f"},penumbraCos:{type:"1f"},decay:{type:"1f"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},spotShadowMap:{type:"tv",value:[]},spotShadowMatrix:{type:"m4v",value:[]},pointLights:{type:"sa",value:[],properties:{color:{type:"c"},position:{type:"v3"},decay:{type:"1f"},distance:{type:"1f"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},pointShadowMap:{type:"tv",value:[]},
pointShadowMatrix:{type:"m4v",value:[]},hemisphereLights:{type:"sa",value:[],properties:{direction:{type:"v3"},skyColor:{type:"c"},groundColor:{type:"c"}}}},points:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"1f",value:1},size:{type:"1f",value:1},scale:{type:"1f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)}}};THREE.ShaderChunk.cube_frag="uniform samplerCube tCube;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tgl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n\t#include <logdepthbuf_fragment>\n}\n";
THREE.ShaderChunk.cube_vert="varying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n";THREE.ShaderChunk.depth_frag="#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n\t#endif\n}\n";
THREE.ShaderChunk.depth_vert="#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#include <begin_vertex>\n\t#include <displacementmap_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n";
THREE.ShaderChunk.distanceRGBA_frag="uniform vec3 lightPos;\nvarying vec4 vWorldPosition;\n#include <common>\n#include <packing>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tgl_FragColor = packDepthToRGBA( length( vWorldPosition.xyz - lightPos.xyz ) / 1000.0 );\n}\n";THREE.ShaderChunk.distanceRGBA_vert="varying vec4 vWorldPosition;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <skinbase_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition;\n}\n";
THREE.ShaderChunk.equirect_frag="uniform sampler2D tEquirect;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 direction = normalize( vWorldPosition );\n\tvec2 sampleUV;\n\tsampleUV.y = saturate( tFlip * direction.y * -0.5 + 0.5 );\n\tsampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\t#include <logdepthbuf_fragment>\n}\n";
THREE.ShaderChunk.equirect_vert="varying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvWorldPosition = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n";THREE.ShaderChunk.linedashed_frag="uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
THREE.ShaderChunk.linedashed_vert="uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\tvLineDistance = scale * lineDistance;\n\tvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n";
THREE.ShaderChunk.meshbasic_frag="uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight;\n\treflectedLight.directDiffuse = vec3( 0.0 );\n\treflectedLight.directSpecular = vec3( 0.0 );\n\treflectedLight.indirectDiffuse = diffuseColor.rgb;\n\treflectedLight.indirectSpecular = vec3( 0.0 );\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
THREE.ShaderChunk.meshbasic_vert="#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_ENVMAP\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <envmap_vertex>\n}\n";
THREE.ShaderChunk.meshlambert_frag="uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\treflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
THREE.ShaderChunk.meshlambert_vert="#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n}\n";
THREE.ShaderChunk.meshphong_frag="#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
THREE.ShaderChunk.meshphong_vert="#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <displacementmap_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n}\n";
THREE.ShaderChunk.meshphysical_frag="#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float envMapIntensity;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_template>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
THREE.ShaderChunk.meshphysical_vert="#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n#endif\n\t#include <begin_vertex>\n\t#include <displacementmap_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n";
THREE.ShaderChunk.normal_frag="uniform float opacity;\nvarying vec3 vNormal;\n#include <common>\n#include <packing>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tgl_FragColor = vec4( packNormalToRGB( vNormal ), opacity );\n\t#include <logdepthbuf_fragment>\n}\n";THREE.ShaderChunk.normal_vert="varying vec3 vNormal;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvNormal = normalize( normalMatrix * normal );\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n}\n";
THREE.ShaderChunk.points_frag="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\n\t#include <premultiplied_alpha_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}\n";
THREE.ShaderChunk.points_vert="uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\t#ifdef USE_SIZEATTENUATION\n\t\tgl_PointSize = size * ( scale / - mvPosition.z );\n\t#else\n\t\tgl_PointSize = size;\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n}\n";
THREE.ShaderLib={basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.fog]),vertexShader:THREE.ShaderChunk.meshbasic_vert,fragmentShader:THREE.ShaderChunk.meshbasic_frag},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)}}]),vertexShader:THREE.ShaderChunk.meshlambert_vert,
fragmentShader:THREE.ShaderChunk.meshlambert_frag},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.bumpmap,THREE.UniformsLib.normalmap,THREE.UniformsLib.displacementmap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"1f",value:30}}]),vertexShader:THREE.ShaderChunk.meshphong_vert,
fragmentShader:THREE.ShaderChunk.meshphong_frag},standard:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.bumpmap,THREE.UniformsLib.normalmap,THREE.UniformsLib.displacementmap,THREE.UniformsLib.roughnessmap,THREE.UniformsLib.metalnessmap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)},roughness:{type:"1f",value:.5},metalness:{type:"1f",value:0},
envMapIntensity:{type:"1f",value:1}}]),vertexShader:THREE.ShaderChunk.meshphysical_vert,fragmentShader:THREE.ShaderChunk.meshphysical_frag},points:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.points,THREE.UniformsLib.fog]),vertexShader:THREE.ShaderChunk.points_vert,fragmentShader:THREE.ShaderChunk.points_frag},dashed:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,{scale:{type:"1f",value:1},dashSize:{type:"1f",value:1},totalSize:{type:"1f",value:2}}]),
vertexShader:THREE.ShaderChunk.linedashed_vert,fragmentShader:THREE.ShaderChunk.linedashed_frag},depth:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.displacementmap]),vertexShader:THREE.ShaderChunk.depth_vert,fragmentShader:THREE.ShaderChunk.depth_frag},normal:{uniforms:{opacity:{type:"1f",value:1}},vertexShader:THREE.ShaderChunk.normal_vert,fragmentShader:THREE.ShaderChunk.normal_frag},cube:{uniforms:{tCube:{type:"t",value:null},tFlip:{type:"1f",value:-1}},vertexShader:THREE.ShaderChunk.cube_vert,
fragmentShader:THREE.ShaderChunk.cube_frag},equirect:{uniforms:{tEquirect:{type:"t",value:null},tFlip:{type:"1f",value:-1}},vertexShader:THREE.ShaderChunk.equirect_vert,fragmentShader:THREE.ShaderChunk.equirect_frag},distanceRGBA:{uniforms:{lightPos:{type:"v3",value:new THREE.Vector3}},vertexShader:THREE.ShaderChunk.distanceRGBA_vert,fragmentShader:THREE.ShaderChunk.distanceRGBA_frag}};
THREE.ShaderLib.physical={uniforms:THREE.UniformsUtils.merge([THREE.ShaderLib.standard.uniforms,{}]),vertexShader:THREE.ShaderChunk.meshphysical_vert,fragmentShader:THREE.ShaderChunk.meshphysical_frag};
THREE.WebGLRenderer=function(a){function b(a,b,c,d){!0===O&&(a*=d,b*=d,c*=d);N.clearColor(a,b,c,d)}function c(){N.init();N.scissor(ua.copy(Fa).multiplyScalar($));N.viewport(la.copy(ma).multiplyScalar($));b(aa.r,aa.g,aa.b,ja)}function d(){ga=ca=null;na="";oa=-1;N.reset()}function e(a){a.preventDefault();d();c();U.clear()}function f(a){a=a.target;a.removeEventListener("dispose",f);a:{var b=U.get(a);if(a.image&&b.__image__webglTextureCube)t.deleteTexture(b.__image__webglTextureCube);else{if(void 0===
b.__webglInit)break a;t.deleteTexture(b.__webglTexture)}U.delete(a)}ka.textures--}function g(a){a=a.target;a.removeEventListener("dispose",g);var b=U.get(a),c=U.get(a.texture);if(a){void 0!==c.__webglTexture&&t.deleteTexture(c.__webglTexture);a.depthTexture&&a.depthTexture.dispose();if(a instanceof THREE.WebGLRenderTargetCube)for(c=0;6>c;c++)t.deleteFramebuffer(b.__webglFramebuffer[c]),b.__webglDepthbuffer&&t.deleteRenderbuffer(b.__webglDepthbuffer[c]);else t.deleteFramebuffer(b.__webglFramebuffer),
b.__webglDepthbuffer&&t.deleteRenderbuffer(b.__webglDepthbuffer);U.delete(a.texture);U.delete(a)}ka.textures--}function h(a){a=a.target;a.removeEventListener("dispose",h);k(a);U.delete(a)}function k(a){var b=U.get(a).program;a.program=void 0;void 0!==b&&pa.releaseProgram(b)}function l(a,b){return Math.abs(b[0])-Math.abs(a[0])}function n(a,b){return a.object.renderOrder!==b.object.renderOrder?a.object.renderOrder-b.object.renderOrder:a.material.id!==b.material.id?a.material.id-b.material.id:a.z!==
b.z?a.z-b.z:a.id-b.id}function p(a,b){return a.object.renderOrder!==b.object.renderOrder?a.object.renderOrder-b.object.renderOrder:a.z!==b.z?b.z-a.z:a.id-b.id}function m(a,b,c,d,e){var f;c.transparent?(d=T,f=++X):(d=F,f=++Z);f=d[f];void 0!==f?(f.id=a.id,f.object=a,f.geometry=b,f.material=c,f.z=Y.z,f.group=e):(f={id:a.id,object:a,geometry:b,material:c,z:Y.z,group:e},d.push(f))}function q(a){var b=a.geometry;null===b.boundingSphere&&b.computeBoundingSphere();var c=Ma.copy(b.boundingSphere).applyMatrix4(a.matrixWorld);
if(!Ha.intersectsSphere(c))return!1;if(0===da)return!0;a=W.clippingPlanes;var b=c.center,c=-c.radius,d=0;do if(a[d].distanceToPoint(b)<c)return!1;while(++d!==da);return!0}function r(a,b){if(!1!==a.visible){if(a.layers.test(b.layers))if(a instanceof THREE.Light)R.push(a);else if(a instanceof THREE.Sprite)!1!==a.frustumCulled&&!0!==q(a)||ha.push(a);else if(a instanceof THREE.LensFlare)qa.push(a);else if(a instanceof THREE.ImmediateRenderObject)!0===W.sortObjects&&(Y.setFromMatrixPosition(a.matrixWorld),
Y.applyProjection(va)),m(a,null,a.material,Y.z,null);else if(a instanceof THREE.Mesh||a instanceof THREE.Line||a instanceof THREE.Points)if(a instanceof THREE.SkinnedMesh&&a.skeleton.update(),!1===a.frustumCulled||!0===q(a)){var c=a.material;if(!0===c.visible){!0===W.sortObjects&&(Y.setFromMatrixPosition(a.matrixWorld),Y.applyProjection(va));var d=ra.update(a);if(c instanceof THREE.MultiMaterial)for(var e=d.groups,f=c.materials,c=0,g=e.length;c<g;c++){var h=e[c],k=f[h.materialIndex];!0===k.visible&&
m(a,d,k,Y.z,h)}else m(a,d,c,Y.z,null)}}d=a.children;c=0;for(g=d.length;c<g;c++)r(d[c],b)}}function s(a,b,c,d){for(var e=0,f=a.length;e<f;e++){var g=a[e],h=g.object,k=g.geometry,m=void 0===d?g.material:d,g=g.group;h.modelViewMatrix.multiplyMatrices(b.matrixWorldInverse,h.matrixWorld);h.normalMatrix.getNormalMatrix(h.modelViewMatrix);if(h instanceof THREE.ImmediateRenderObject){u(m);var l=v(b,c,m,h);na="";h.render(function(a){W.renderBufferImmediate(a,l,m)})}else W.renderBufferDirect(b,c,k,m,h,g)}}
function u(a){a.side!==THREE.DoubleSide?N.enable(t.CULL_FACE):N.disable(t.CULL_FACE);N.setFlipSided(a.side===THREE.BackSide);!0===a.transparent?N.setBlending(a.blending,a.blendEquation,a.blendSrc,a.blendDst,a.blendEquationAlpha,a.blendSrcAlpha,a.blendDstAlpha,a.premultipliedAlpha):N.setBlending(THREE.NoBlending);N.setDepthFunc(a.depthFunc);N.setDepthTest(a.depthTest);N.setDepthWrite(a.depthWrite);N.setColorWrite(a.colorWrite);N.setPolygonOffset(a.polygonOffset,a.polygonOffsetFactor,a.polygonOffsetUnits)}
function v(a,b,c,d){wa=0;var e=U.get(c);if(xa){if(ya||a!==ga){var f=c.clippingPlanes,g=a===ga&&c.id===oa;if(!ya||null===f||0===f.length||sa&&!c.clipShadows)sa?A(null):w();else{var m=sa?0:ta,l=4*m,n=e.clippingState||null;fa.value=n;n=A(f,a,l,g);for(f=0;f!==l;++f)n[f]=za[f];e.clippingState=n;da+=m}}void 0!==e.numClippingPlanes&&e.numClippingPlanes!==da&&(c.needsUpdate=!0)}void 0===e.program&&(c.needsUpdate=!0);void 0!==e.lightsHash&&e.lightsHash!==S.hash&&(c.needsUpdate=!0);if(c.needsUpdate){a:{m=U.get(c);
l=pa.getParameters(c,S,b,da,d);n=pa.getProgramCode(c,l);f=m.program;g=!0;if(void 0===f)c.addEventListener("dispose",h);else if(f.code!==n)k(c);else if(void 0!==l.shaderID)break a;else g=!1;g&&(l.shaderID?(f=THREE.ShaderLib[l.shaderID],m.__webglShader={name:c.type,uniforms:THREE.UniformsUtils.clone(f.uniforms),vertexShader:f.vertexShader,fragmentShader:f.fragmentShader}):m.__webglShader={name:c.type,uniforms:c.uniforms,vertexShader:c.vertexShader,fragmentShader:c.fragmentShader},c.__webglShader=m.__webglShader,
f=pa.acquireProgram(c,l,n),m.program=f,c.program=f);l=f.getAttributes();if(c.morphTargets)for(n=c.numSupportedMorphTargets=0;n<W.maxMorphTargets;n++)0<=l["morphTarget"+n]&&c.numSupportedMorphTargets++;if(c.morphNormals)for(n=c.numSupportedMorphNormals=0;n<W.maxMorphNormals;n++)0<=l["morphNormal"+n]&&c.numSupportedMorphNormals++;l=m.__webglShader.uniforms;(c instanceof THREE.ShaderMaterial||c instanceof THREE.RawShaderMaterial)&&!0!==c.clipping||(m.numClippingPlanes=da,l.clippingPlanes=fa);if(c instanceof
THREE.MeshPhongMaterial||c instanceof THREE.MeshLambertMaterial||c instanceof THREE.MeshStandardMaterial||c.lights)m.lightsHash=S.hash,l.ambientLightColor.value=S.ambient,l.directionalLights.value=S.directional,l.spotLights.value=S.spot,l.pointLights.value=S.point,l.hemisphereLights.value=S.hemi,l.directionalShadowMap.value=S.directionalShadowMap,l.directionalShadowMatrix.value=S.directionalShadowMatrix,l.spotShadowMap.value=S.spotShadowMap,l.spotShadowMatrix.value=S.spotShadowMatrix,l.pointShadowMap.value=
S.pointShadowMap,l.pointShadowMatrix.value=S.pointShadowMatrix;n=m.program.getUniforms();n=THREE.WebGLUniforms.seqWithValue(n.seq,l);m.uniformsList=n;m.dynamicUniforms=THREE.WebGLUniforms.splitDynamic(n,l)}c.needsUpdate=!1}var q=!1,g=f=!1,m=e.program,n=m.getUniforms(),l=e.__webglShader.uniforms;m.id!==ca&&(t.useProgram(m.program),ca=m.id,g=f=q=!0);c.id!==oa&&(oa=c.id,f=!0);if(q||a!==ga){n.set(t,a,"projectionMatrix");ea.logarithmicDepthBuffer&&n.setValue(t,"logDepthBufFC",2/(Math.log(a.far+1)/Math.LN2));
a!==ga&&(ga=a,g=f=!0);if(c instanceof THREE.ShaderMaterial||c instanceof THREE.MeshPhongMaterial||c instanceof THREE.MeshStandardMaterial||c.envMap)q=n.map.cameraPosition,void 0!==q&&q.setValue(t,Y.setFromMatrixPosition(a.matrixWorld));(c instanceof THREE.MeshPhongMaterial||c instanceof THREE.MeshLambertMaterial||c instanceof THREE.MeshBasicMaterial||c instanceof THREE.MeshStandardMaterial||c instanceof THREE.ShaderMaterial||c.skinning)&&n.setValue(t,"viewMatrix",a.matrixWorldInverse);n.set(t,W,"toneMappingExposure");
n.set(t,W,"toneMappingWhitePoint")}c.skinning&&(n.setOptional(t,d,"bindMatrix"),n.setOptional(t,d,"bindMatrixInverse"),q=d.skeleton)&&(ea.floatVertexTextures&&q.useVertexTexture?(n.set(t,q,"boneTexture"),n.set(t,q,"boneTextureWidth"),n.set(t,q,"boneTextureHeight")):n.setOptional(t,q,"boneMatrices"));if(f){if(c instanceof THREE.MeshPhongMaterial||c instanceof THREE.MeshLambertMaterial||c instanceof THREE.MeshStandardMaterial||c.lights)f=g,l.ambientLightColor.needsUpdate=f,l.directionalLights.needsUpdate=
f,l.pointLights.needsUpdate=f,l.spotLights.needsUpdate=f,l.hemisphereLights.needsUpdate=f;b&&c.fog&&(l.fogColor.value=b.color,b instanceof THREE.Fog?(l.fogNear.value=b.near,l.fogFar.value=b.far):b instanceof THREE.FogExp2&&(l.fogDensity.value=b.density));if(c instanceof THREE.MeshBasicMaterial||c instanceof THREE.MeshLambertMaterial||c instanceof THREE.MeshPhongMaterial||c instanceof THREE.MeshStandardMaterial||c instanceof THREE.MeshDepthMaterial){l.opacity.value=c.opacity;l.diffuse.value=c.color;
c.emissive&&l.emissive.value.copy(c.emissive).multiplyScalar(c.emissiveIntensity);l.map.value=c.map;l.specularMap.value=c.specularMap;l.alphaMap.value=c.alphaMap;c.aoMap&&(l.aoMap.value=c.aoMap,l.aoMapIntensity.value=c.aoMapIntensity);var p;c.map?p=c.map:c.specularMap?p=c.specularMap:c.displacementMap?p=c.displacementMap:c.normalMap?p=c.normalMap:c.bumpMap?p=c.bumpMap:c.roughnessMap?p=c.roughnessMap:c.metalnessMap?p=c.metalnessMap:c.alphaMap?p=c.alphaMap:c.emissiveMap&&(p=c.emissiveMap);void 0!==
p&&(p instanceof THREE.WebGLRenderTarget&&(p=p.texture),b=p.offset,p=p.repeat,l.offsetRepeat.value.set(b.x,b.y,p.x,p.y));l.envMap.value=c.envMap;l.flipEnvMap.value=c.envMap instanceof THREE.WebGLRenderTargetCube?1:-1;l.reflectivity.value=c.reflectivity;l.refractionRatio.value=c.refractionRatio}c instanceof THREE.LineBasicMaterial?(l.diffuse.value=c.color,l.opacity.value=c.opacity):c instanceof THREE.LineDashedMaterial?(l.diffuse.value=c.color,l.opacity.value=c.opacity,l.dashSize.value=c.dashSize,
l.totalSize.value=c.dashSize+c.gapSize,l.scale.value=c.scale):c instanceof THREE.PointsMaterial?(l.diffuse.value=c.color,l.opacity.value=c.opacity,l.size.value=c.size*$,l.scale.value=.5*K.clientHeight,l.map.value=c.map,null!==c.map&&(p=c.map.offset,c=c.map.repeat,l.offsetRepeat.value.set(p.x,p.y,c.x,c.y))):c instanceof THREE.MeshLambertMaterial?(c.lightMap&&(l.lightMap.value=c.lightMap,l.lightMapIntensity.value=c.lightMapIntensity),c.emissiveMap&&(l.emissiveMap.value=c.emissiveMap)):c instanceof THREE.MeshPhongMaterial?
(l.specular.value=c.specular,l.shininess.value=Math.max(c.shininess,1E-4),c.lightMap&&(l.lightMap.value=c.lightMap,l.lightMapIntensity.value=c.lightMapIntensity),c.emissiveMap&&(l.emissiveMap.value=c.emissiveMap),c.bumpMap&&(l.bumpMap.value=c.bumpMap,l.bumpScale.value=c.bumpScale),c.normalMap&&(l.normalMap.value=c.normalMap,l.normalScale.value.copy(c.normalScale)),c.displacementMap&&(l.displacementMap.value=c.displacementMap,l.displacementScale.value=c.displacementScale,l.displacementBias.value=c.displacementBias)):
c instanceof THREE.MeshPhysicalMaterial?x(l,c):c instanceof THREE.MeshStandardMaterial?x(l,c):c instanceof THREE.MeshDepthMaterial?c.displacementMap&&(l.displacementMap.value=c.displacementMap,l.displacementScale.value=c.displacementScale,l.displacementBias.value=c.displacementBias):c instanceof THREE.MeshNormalMaterial&&(l.opacity.value=c.opacity);THREE.WebGLUniforms.upload(t,e.uniformsList,l,W)}n.set(t,d,"modelViewMatrix");n.set(t,d,"normalMatrix");n.setValue(t,"modelMatrix",d.matrixWorld);e=e.dynamicUniforms;
null!==e&&(THREE.WebGLUniforms.evalDynamic(e,l,d,a),THREE.WebGLUniforms.upload(t,e,l,W));return m}function x(a,b){a.roughness.value=b.roughness;a.metalness.value=b.metalness;b.roughnessMap&&(a.roughnessMap.value=b.roughnessMap);b.metalnessMap&&(a.metalnessMap.value=b.metalnessMap);b.lightMap&&(a.lightMap.value=b.lightMap,a.lightMapIntensity.value=b.lightMapIntensity);b.emissiveMap&&(a.emissiveMap.value=b.emissiveMap);b.bumpMap&&(a.bumpMap.value=b.bumpMap,a.bumpScale.value=b.bumpScale);b.normalMap&&
(a.normalMap.value=b.normalMap,a.normalScale.value.copy(b.normalScale));b.displacementMap&&(a.displacementMap.value=b.displacementMap,a.displacementScale.value=b.displacementScale,a.displacementBias.value=b.displacementBias);b.envMap&&(a.envMapIntensity.value=b.envMapIntensity)}function A(a,b,c,d){var e=null!==a?a.length:0,f=null;if(0!==e){f=fa.value;if(!0!==d||null===f){var g=c+4*e;b=b.matrixWorldInverse;d=Na.getNormalMatrix(b);if(null===f||f.length<g)f=new Float32Array(g);for(g=0;g!==e;++g,c+=4){var h=
Oa.copy(a[g]).applyMatrix4(b,d);h.normal.toArray(f,c);f[c+3]=h.constant}}fa.value=f;fa.needsUpdate=!0}da=e;return f}function w(){fa.value!==za&&(fa.value=za,fa.needsUpdate=0<ta);da=ta}function B(a,b,c){c?(t.texParameteri(a,t.TEXTURE_WRAP_S,G(b.wrapS)),t.texParameteri(a,t.TEXTURE_WRAP_T,G(b.wrapT)),t.texParameteri(a,t.TEXTURE_MAG_FILTER,G(b.magFilter)),t.texParameteri(a,t.TEXTURE_MIN_FILTER,G(b.minFilter))):(t.texParameteri(a,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(a,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),
b.wrapS===THREE.ClampToEdgeWrapping&&b.wrapT===THREE.ClampToEdgeWrapping||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping.",b),t.texParameteri(a,t.TEXTURE_MAG_FILTER,H(b.magFilter)),t.texParameteri(a,t.TEXTURE_MIN_FILTER,H(b.minFilter)),b.minFilter!==THREE.NearestFilter&&b.minFilter!==THREE.LinearFilter&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.",
b));!(c=V.get("EXT_texture_filter_anisotropic"))||b.type===THREE.FloatType&&null===V.get("OES_texture_float_linear")||b.type===THREE.HalfFloatType&&null===V.get("OES_texture_half_float_linear")||!(1<b.anisotropy||U.get(b).__currentAnisotropy)||(t.texParameterf(a,c.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(b.anisotropy,W.getMaxAnisotropy())),U.get(b).__currentAnisotropy=b.anisotropy)}function z(a,b){a instanceof THREE.WebGLRenderTarget&&(a=a.texture);var c=U.get(a);if(0<a.version&&c.__version!==a.version){var d=
a.image;if(void 0===d)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined",a);else if(!1===d.complete)console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete",a);else{d=a;void 0===c.__webglInit&&(c.__webglInit=!0,d.addEventListener("dispose",f),c.__webglTexture=t.createTexture(),ka.textures++);N.activeTexture(t.TEXTURE0+b);N.bindTexture(t.TEXTURE_2D,c.__webglTexture);t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,d.flipY);t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,
d.premultiplyAlpha);t.pixelStorei(t.UNPACK_ALIGNMENT,d.unpackAlignment);var e=y(d.image,ea.maxTextureSize);if((d.wrapS!==THREE.ClampToEdgeWrapping||d.wrapT!==THREE.ClampToEdgeWrapping||d.minFilter!==THREE.NearestFilter&&d.minFilter!==THREE.LinearFilter)&&!1===C(e)){var g=e;if(g instanceof HTMLImageElement||g instanceof HTMLCanvasElement){var h=document.createElement("canvas");h.width=THREE.Math.nearestPowerOfTwo(g.width);h.height=THREE.Math.nearestPowerOfTwo(g.height);h.getContext("2d").drawImage(g,
0,0,h.width,h.height);console.warn("THREE.WebGLRenderer: image is not power of two ("+g.width+"x"+g.height+"). Resized to "+h.width+"x"+h.height,g);e=h}else e=g}var g=C(e),h=G(d.format),k=G(d.type);B(t.TEXTURE_2D,d,g);var m=d.mipmaps;if(d instanceof THREE.DepthTexture){m=t.DEPTH_COMPONENT;if(d.type===THREE.FloatType){if(!Ia)throw Error("Float Depth Texture only supported in WebGL2.0");m=t.DEPTH_COMPONENT32F}else Ia&&(m=t.DEPTH_COMPONENT16);N.texImage2D(t.TEXTURE_2D,0,m,e.width,e.height,0,h,k,null)}else if(d instanceof
THREE.DataTexture)if(0<m.length&&g){for(var l=0,n=m.length;l<n;l++)e=m[l],N.texImage2D(t.TEXTURE_2D,l,h,e.width,e.height,0,h,k,e.data);d.generateMipmaps=!1}else N.texImage2D(t.TEXTURE_2D,0,h,e.width,e.height,0,h,k,e.data);else if(d instanceof THREE.CompressedTexture)for(l=0,n=m.length;l<n;l++)e=m[l],d.format!==THREE.RGBAFormat&&d.format!==THREE.RGBFormat?-1<N.getCompressedTextureFormats().indexOf(h)?N.compressedTexImage2D(t.TEXTURE_2D,l,h,e.width,e.height,0,e.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):
N.texImage2D(t.TEXTURE_2D,l,h,e.width,e.height,0,h,k,e.data);else if(0<m.length&&g){l=0;for(n=m.length;l<n;l++)e=m[l],N.texImage2D(t.TEXTURE_2D,l,h,h,k,e);d.generateMipmaps=!1}else N.texImage2D(t.TEXTURE_2D,0,h,h,k,e);d.generateMipmaps&&g&&t.generateMipmap(t.TEXTURE_2D);c.__version=d.version;if(d.onUpdate)d.onUpdate(d)}}else N.activeTexture(t.TEXTURE0+b),N.bindTexture(t.TEXTURE_2D,c.__webglTexture)}function y(a,b){if(a.width>b||a.height>b){var c=b/Math.max(a.width,a.height),d=document.createElement("canvas");
d.width=Math.floor(a.width*c);d.height=Math.floor(a.height*c);d.getContext("2d").drawImage(a,0,0,a.width,a.height,0,0,d.width,d.height);console.warn("THREE.WebGLRenderer: image is too big ("+a.width+"x"+a.height+"). Resized to "+d.width+"x"+d.height,a);return d}return a}function C(a){return THREE.Math.isPowerOfTwo(a.width)&&THREE.Math.isPowerOfTwo(a.height)}function J(a,b,c,d){var e=G(b.texture.format),f=G(b.texture.type);N.texImage2D(d,0,e,b.width,b.height,0,e,f,null);t.bindFramebuffer(t.FRAMEBUFFER,
a);t.framebufferTexture2D(t.FRAMEBUFFER,c,d,U.get(b.texture).__webglTexture,0);t.bindFramebuffer(t.FRAMEBUFFER,null)}function D(a,b){t.bindRenderbuffer(t.RENDERBUFFER,a);b.depthBuffer&&!b.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_COMPONENT16,b.width,b.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,a)):b.depthBuffer&&b.stencilBuffer?(t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_STENCIL,b.width,b.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,
t.RENDERBUFFER,a)):t.renderbufferStorage(t.RENDERBUFFER,t.RGBA4,b.width,b.height);t.bindRenderbuffer(t.RENDERBUFFER,null)}function H(a){return a===THREE.NearestFilter||a===THREE.NearestMipMapNearestFilter||a===THREE.NearestMipMapLinearFilter?t.NEAREST:t.LINEAR}function G(a){var b;if(a===THREE.RepeatWrapping)return t.REPEAT;if(a===THREE.ClampToEdgeWrapping)return t.CLAMP_TO_EDGE;if(a===THREE.MirroredRepeatWrapping)return t.MIRRORED_REPEAT;if(a===THREE.NearestFilter)return t.NEAREST;if(a===THREE.NearestMipMapNearestFilter)return t.NEAREST_MIPMAP_NEAREST;
if(a===THREE.NearestMipMapLinearFilter)return t.NEAREST_MIPMAP_LINEAR;if(a===THREE.LinearFilter)return t.LINEAR;if(a===THREE.LinearMipMapNearestFilter)return t.LINEAR_MIPMAP_NEAREST;if(a===THREE.LinearMipMapLinearFilter)return t.LINEAR_MIPMAP_LINEAR;if(a===THREE.UnsignedByteType)return t.UNSIGNED_BYTE;if(a===THREE.UnsignedShort4444Type)return t.UNSIGNED_SHORT_4_4_4_4;if(a===THREE.UnsignedShort5551Type)return t.UNSIGNED_SHORT_5_5_5_1;if(a===THREE.UnsignedShort565Type)return t.UNSIGNED_SHORT_5_6_5;
if(a===THREE.ByteType)return t.BYTE;if(a===THREE.ShortType)return t.SHORT;if(a===THREE.UnsignedShortType)return t.UNSIGNED_SHORT;if(a===THREE.IntType)return t.INT;if(a===THREE.UnsignedIntType)return t.UNSIGNED_INT;if(a===THREE.FloatType)return t.FLOAT;b=V.get("OES_texture_half_float");if(null!==b&&a===THREE.HalfFloatType)return b.HALF_FLOAT_OES;if(a===THREE.AlphaFormat)return t.ALPHA;if(a===THREE.RGBFormat)return t.RGB;if(a===THREE.RGBAFormat)return t.RGBA;if(a===THREE.LuminanceFormat)return t.LUMINANCE;
if(a===THREE.LuminanceAlphaFormat)return t.LUMINANCE_ALPHA;if(a===THREE.DepthFormat)return t.DEPTH_COMPONENT;if(a===THREE.AddEquation)return t.FUNC_ADD;if(a===THREE.SubtractEquation)return t.FUNC_SUBTRACT;if(a===THREE.ReverseSubtractEquation)return t.FUNC_REVERSE_SUBTRACT;if(a===THREE.ZeroFactor)return t.ZERO;if(a===THREE.OneFactor)return t.ONE;if(a===THREE.SrcColorFactor)return t.SRC_COLOR;if(a===THREE.OneMinusSrcColorFactor)return t.ONE_MINUS_SRC_COLOR;if(a===THREE.SrcAlphaFactor)return t.SRC_ALPHA;
if(a===THREE.OneMinusSrcAlphaFactor)return t.ONE_MINUS_SRC_ALPHA;if(a===THREE.DstAlphaFactor)return t.DST_ALPHA;if(a===THREE.OneMinusDstAlphaFactor)return t.ONE_MINUS_DST_ALPHA;if(a===THREE.DstColorFactor)return t.DST_COLOR;if(a===THREE.OneMinusDstColorFactor)return t.ONE_MINUS_DST_COLOR;if(a===THREE.SrcAlphaSaturateFactor)return t.SRC_ALPHA_SATURATE;b=V.get("WEBGL_compressed_texture_s3tc");if(null!==b){if(a===THREE.RGB_S3TC_DXT1_Format)return b.COMPRESSED_RGB_S3TC_DXT1_EXT;if(a===THREE.RGBA_S3TC_DXT1_Format)return b.COMPRESSED_RGBA_S3TC_DXT1_EXT;
if(a===THREE.RGBA_S3TC_DXT3_Format)return b.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(a===THREE.RGBA_S3TC_DXT5_Format)return b.COMPRESSED_RGBA_S3TC_DXT5_EXT}b=V.get("WEBGL_compressed_texture_pvrtc");if(null!==b){if(a===THREE.RGB_PVRTC_4BPPV1_Format)return b.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(a===THREE.RGB_PVRTC_2BPPV1_Format)return b.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(a===THREE.RGBA_PVRTC_4BPPV1_Format)return b.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(a===THREE.RGBA_PVRTC_2BPPV1_Format)return b.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}b=
V.get("WEBGL_compressed_texture_etc1");if(null!==b&&a===THREE.RGB_ETC1_Format)return b.COMPRESSED_RGB_ETC1_WEBGL;b=V.get("EXT_blend_minmax");if(null!==b){if(a===THREE.MinEquation)return b.MIN_EXT;if(a===THREE.MaxEquation)return b.MAX_EXT}return 0}console.log("THREE.WebGLRenderer",THREE.REVISION);a=a||{};var K=void 0!==a.canvas?a.canvas:document.createElement("canvas"),P=void 0!==a.context?a.context:null,I=void 0!==a.alpha?a.alpha:!1,L=void 0!==a.depth?a.depth:!0,E=void 0!==a.stencil?a.stencil:!0,
M=void 0!==a.antialias?a.antialias:!1,O=void 0!==a.premultipliedAlpha?a.premultipliedAlpha:!0,Q=void 0!==a.preserveDrawingBuffer?a.preserveDrawingBuffer:!1,R=[],F=[],Z=-1,T=[],X=-1,ba=new Float32Array(8),ha=[],qa=[];this.domElement=K;this.context=null;this.sortObjects=this.autoClearStencil=this.autoClearDepth=this.autoClearColor=this.autoClear=!0;this.clippingPlanes=[];this.localClippingEnabled=!1;this.gammaFactor=2;this.physicallyCorrectLights=this.gammaOutput=this.gammaInput=!1;this.toneMapping=
THREE.LinearToneMapping;this.toneMappingWhitePoint=this.toneMappingExposure=1;this.maxMorphTargets=8;this.maxMorphNormals=4;this.autoScaleCubemaps=!0;var W=this,ca=null,Aa=null,Ba=null,oa=-1,na="",ga=null,ua=new THREE.Vector4,Ga=null,la=new THREE.Vector4,wa=0,aa=new THREE.Color(0),ja=0,Ca=K.width,Da=K.height,$=1,Fa=new THREE.Vector4(0,0,Ca,Da),Ja=!1,ma=new THREE.Vector4(0,0,Ca,Da),Ha=new THREE.Frustum,xa=!1,ya=!1,sa=!1,da=0,fa={type:"4fv",value:null,needsUpdate:!1},za=null,ta=0,Na=new THREE.Matrix3,
Ma=new THREE.Sphere,Oa=new THREE.Plane,va=new THREE.Matrix4,Y=new THREE.Vector3,S={hash:"",ambient:[0,0,0],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],shadows:[]},ka={geometries:0,textures:0},ia={calls:0,vertices:0,faces:0,points:0};this.info={render:ia,memory:ka,programs:null};var t;try{I={alpha:I,depth:L,stencil:E,antialias:M,premultipliedAlpha:O,preserveDrawingBuffer:Q};t=
P||K.getContext("webgl",I)||K.getContext("experimental-webgl",I);if(null===t){if(null!==K.getContext("webgl"))throw"Error creating WebGL context with your selected attributes.";throw"Error creating WebGL context.";}void 0===t.getShaderPrecisionFormat&&(t.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}});K.addEventListener("webglcontextlost",e,!1)}catch(Pa){console.error("THREE.WebGLRenderer: "+Pa)}var Ia="undefined"!==typeof WebGL2RenderingContext&&t instanceof WebGL2RenderingContext,
V=new THREE.WebGLExtensions(t);V.get("WEBGL_depth_texture");V.get("OES_texture_float");V.get("OES_texture_float_linear");V.get("OES_texture_half_float");V.get("OES_texture_half_float_linear");V.get("OES_standard_derivatives");V.get("ANGLE_instanced_arrays");V.get("OES_element_index_uint")&&(THREE.BufferGeometry.MaxIndex=4294967296);var ea=new THREE.WebGLCapabilities(t,V,a),N=new THREE.WebGLState(t,V,G),U=new THREE.WebGLProperties,ra=new THREE.WebGLObjects(t,U,this.info),pa=new THREE.WebGLPrograms(this,
ea),Ea=new THREE.WebGLLights;this.info.programs=pa.programs;var Qa=new THREE.WebGLBufferRenderer(t,V,ia),Ra=new THREE.WebGLIndexedBufferRenderer(t,V,ia);c();this.context=t;this.capabilities=ea;this.extensions=V;this.properties=U;this.state=N;var Ka=new THREE.WebGLShadowMap(this,S,ra);this.shadowMap=Ka;var Sa=new THREE.SpritePlugin(this,ha),Ta=new THREE.LensFlarePlugin(this,qa);this.getContext=function(){return t};this.getContextAttributes=function(){return t.getContextAttributes()};this.forceContextLoss=
function(){V.get("WEBGL_lose_context").loseContext()};this.getMaxAnisotropy=function(){var a;return function(){if(void 0!==a)return a;var b=V.get("EXT_texture_filter_anisotropic");return a=null!==b?t.getParameter(b.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0}}();this.getPrecision=function(){return ea.precision};this.getPixelRatio=function(){return $};this.setPixelRatio=function(a){void 0!==a&&($=a,this.setSize(ma.z,ma.w,!1))};this.getSize=function(){return{width:Ca,height:Da}};this.setSize=function(a,b,c){Ca=
a;Da=b;K.width=a*$;K.height=b*$;!1!==c&&(K.style.width=a+"px",K.style.height=b+"px");this.setViewport(0,0,a,b)};this.setViewport=function(a,b,c,d){N.viewport(ma.set(a,b,c,d))};this.setScissor=function(a,b,c,d){N.scissor(Fa.set(a,b,c,d))};this.setScissorTest=function(a){N.setScissorTest(Ja=a)};this.getClearColor=function(){return aa};this.setClearColor=function(a,c){aa.set(a);ja=void 0!==c?c:1;b(aa.r,aa.g,aa.b,ja)};this.getClearAlpha=function(){return ja};this.setClearAlpha=function(a){ja=a;b(aa.r,
aa.g,aa.b,ja)};this.clear=function(a,b,c){var d=0;if(void 0===a||a)d|=t.COLOR_BUFFER_BIT;if(void 0===b||b)d|=t.DEPTH_BUFFER_BIT;if(void 0===c||c)d|=t.STENCIL_BUFFER_BIT;t.clear(d)};this.clearColor=function(){this.clear(!0,!1,!1)};this.clearDepth=function(){this.clear(!1,!0,!1)};this.clearStencil=function(){this.clear(!1,!1,!0)};this.clearTarget=function(a,b,c,d){this.setRenderTarget(a);this.clear(b,c,d)};this.resetGLState=d;this.dispose=function(){K.removeEventListener("webglcontextlost",e,!1)};this.renderBufferImmediate=
function(a,b,c){N.initAttributes();var d=U.get(a);a.hasPositions&&!d.position&&(d.position=t.createBuffer());a.hasNormals&&!d.normal&&(d.normal=t.createBuffer());a.hasUvs&&!d.uv&&(d.uv=t.createBuffer());a.hasColors&&!d.color&&(d.color=t.createBuffer());b=b.getAttributes();a.hasPositions&&(t.bindBuffer(t.ARRAY_BUFFER,d.position),t.bufferData(t.ARRAY_BUFFER,a.positionArray,t.DYNAMIC_DRAW),N.enableAttribute(b.position),t.vertexAttribPointer(b.position,3,t.FLOAT,!1,0,0));if(a.hasNormals){t.bindBuffer(t.ARRAY_BUFFER,
d.normal);if("MeshPhongMaterial"!==c.type&&"MeshStandardMaterial"!==c.type&&"MeshPhysicalMaterial"!==c.type&&c.shading===THREE.FlatShading)for(var e=0,f=3*a.count;e<f;e+=9){var g=a.normalArray,h=(g[e+0]+g[e+3]+g[e+6])/3,k=(g[e+1]+g[e+4]+g[e+7])/3,m=(g[e+2]+g[e+5]+g[e+8])/3;g[e+0]=h;g[e+1]=k;g[e+2]=m;g[e+3]=h;g[e+4]=k;g[e+5]=m;g[e+6]=h;g[e+7]=k;g[e+8]=m}t.bufferData(t.ARRAY_BUFFER,a.normalArray,t.DYNAMIC_DRAW);N.enableAttribute(b.normal);t.vertexAttribPointer(b.normal,3,t.FLOAT,!1,0,0)}a.hasUvs&&c.map&&
(t.bindBuffer(t.ARRAY_BUFFER,d.uv),t.bufferData(t.ARRAY_BUFFER,a.uvArray,t.DYNAMIC_DRAW),N.enableAttribute(b.uv),t.vertexAttribPointer(b.uv,2,t.FLOAT,!1,0,0));a.hasColors&&c.vertexColors!==THREE.NoColors&&(t.bindBuffer(t.ARRAY_BUFFER,d.color),t.bufferData(t.ARRAY_BUFFER,a.colorArray,t.DYNAMIC_DRAW),N.enableAttribute(b.color),t.vertexAttribPointer(b.color,3,t.FLOAT,!1,0,0));N.disableUnusedAttributes();t.drawArrays(t.TRIANGLES,0,a.count);a.count=0};this.renderBufferDirect=function(a,b,c,d,e,f){u(d);
var g=v(a,b,d,e),h=!1;a=c.id+"_"+g.id+"_"+d.wireframe;a!==na&&(na=a,h=!0);b=e.morphTargetInfluences;if(void 0!==b){a=[];for(var k=0,h=b.length;k<h;k++){var m=b[k];a.push([m,k])}a.sort(l);8<a.length&&(a.length=8);for(var n=c.morphAttributes,k=0,h=a.length;k<h;k++)m=a[k],ba[k]=m[0],0!==m[0]?(b=m[1],!0===d.morphTargets&&n.position&&c.addAttribute("morphTarget"+k,n.position[b]),!0===d.morphNormals&&n.normal&&c.addAttribute("morphNormal"+k,n.normal[b])):(!0===d.morphTargets&&c.removeAttribute("morphTarget"+
k),!0===d.morphNormals&&c.removeAttribute("morphNormal"+k));g.getUniforms().setValue(t,"morphTargetInfluences",ba);h=!0}b=c.index;k=c.attributes.position;!0===d.wireframe&&(b=ra.getWireframeAttribute(c));null!==b?(a=Ra,a.setIndex(b)):a=Qa;if(h){a:{var h=void 0,q;if(c instanceof THREE.InstancedBufferGeometry&&(q=V.get("ANGLE_instanced_arrays"),null===q)){console.error("THREE.WebGLRenderer.setupVertexAttributes: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");
break a}void 0===h&&(h=0);N.initAttributes();var m=c.attributes,g=g.getAttributes(),n=d.defaultAttributeValues,p;for(p in g){var r=g[p];if(0<=r){var s=m[p];if(void 0!==s){var w=t.FLOAT,x=s.array,M=s.normalized;x instanceof Float32Array?w=t.FLOAT:x instanceof Float64Array?console.warn("Unsupported data buffer format: Float64Array"):x instanceof Uint16Array?w=t.UNSIGNED_SHORT:x instanceof Int16Array?w=t.SHORT:x instanceof Uint32Array?w=t.UNSIGNED_INT:x instanceof Int32Array?w=t.INT:x instanceof Int8Array?
w=t.BYTE:x instanceof Uint8Array&&(w=t.UNSIGNED_BYTE);var x=s.itemSize,A=ra.getAttributeBuffer(s);if(s instanceof THREE.InterleavedBufferAttribute){var E=s.data,O=E.stride,s=s.offset;E instanceof THREE.InstancedInterleavedBuffer?(N.enableAttributeAndDivisor(r,E.meshPerAttribute,q),void 0===c.maxInstancedCount&&(c.maxInstancedCount=E.meshPerAttribute*E.count)):N.enableAttribute(r);t.bindBuffer(t.ARRAY_BUFFER,A);t.vertexAttribPointer(r,x,w,M,O*E.array.BYTES_PER_ELEMENT,(h*O+s)*E.array.BYTES_PER_ELEMENT)}else s instanceof
THREE.InstancedBufferAttribute?(N.enableAttributeAndDivisor(r,s.meshPerAttribute,q),void 0===c.maxInstancedCount&&(c.maxInstancedCount=s.meshPerAttribute*s.count)):N.enableAttribute(r),t.bindBuffer(t.ARRAY_BUFFER,A),t.vertexAttribPointer(r,x,w,M,0,h*x*s.array.BYTES_PER_ELEMENT)}else if(void 0!==n&&(w=n[p],void 0!==w))switch(w.length){case 2:t.vertexAttrib2fv(r,w);break;case 3:t.vertexAttrib3fv(r,w);break;case 4:t.vertexAttrib4fv(r,w);break;default:t.vertexAttrib1fv(r,w)}}}N.disableUnusedAttributes()}null!==
b&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,ra.getAttributeBuffer(b))}q=Infinity;null!==b?q=b.count:void 0!==k&&(q=k.count);p=c.drawRange.start;b=c.drawRange.count;k=null!==f?f.start:0;h=null!==f?f.count:Infinity;f=Math.max(0,p,k);q=Math.min(0+q,p+b,k+h)-1;q=Math.max(0,q-f+1);if(e instanceof THREE.Mesh)if(!0===d.wireframe)N.setLineWidth(d.wireframeLinewidth*(null===Aa?$:1)),a.setMode(t.LINES);else switch(e.drawMode){case THREE.TrianglesDrawMode:a.setMode(t.TRIANGLES);break;case THREE.TriangleStripDrawMode:a.setMode(t.TRIANGLE_STRIP);
break;case THREE.TriangleFanDrawMode:a.setMode(t.TRIANGLE_FAN)}else e instanceof THREE.Line?(d=d.linewidth,void 0===d&&(d=1),N.setLineWidth(d*(null===Aa?$:1)),e instanceof THREE.LineSegments?a.setMode(t.LINES):a.setMode(t.LINE_STRIP)):e instanceof THREE.Points&&a.setMode(t.POINTS);c instanceof THREE.InstancedBufferGeometry?0<c.maxInstancedCount&&a.renderInstances(c,f,q):a.render(f,q)};this.render=function(a,b,c,d){if(!1===b instanceof THREE.Camera)console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");
else{var e=a.fog;na="";oa=-1;ga=null;!0===a.autoUpdate&&a.updateMatrixWorld();null===b.parent&&b.updateMatrixWorld();b.matrixWorldInverse.getInverse(b.matrixWorld);va.multiplyMatrices(b.projectionMatrix,b.matrixWorldInverse);Ha.setFromMatrix(va);R.length=0;X=Z=-1;ha.length=0;qa.length=0;var f=this.clippingPlanes;xa=0!==W.clippingPlanes.length||W.localClippingEnabled||0!==ta||ya;ya=W.localClippingEnabled;za=A(f,b,0);ta=null!==f?f.length:0;r(a,b);F.length=Z+1;T.length=X+1;!0===W.sortObjects&&(F.sort(n),
T.sort(p));xa&&(sa=!0,A(null));for(var f=R,g=0,h=0,k=f.length;h<k;h++){var m=f[h];m.castShadow&&(S.shadows[g++]=m)}S.shadows.length=g;Ka.render(a,b);for(var f=R,l=m=0,q=0,u,v,x,M=b.matrixWorldInverse,E=0,O=0,ba=0,z=0,g=0,h=f.length;g<h;g++)if(k=f[g],u=k.color,v=k.intensity,x=k.distance,k instanceof THREE.AmbientLight)m+=u.r*v,l+=u.g*v,q+=u.b*v;else if(k instanceof THREE.DirectionalLight){var y=Ea.get(k);y.color.copy(k.color).multiplyScalar(k.intensity);y.direction.setFromMatrixPosition(k.matrixWorld);
Y.setFromMatrixPosition(k.target.matrixWorld);y.direction.sub(Y);y.direction.transformDirection(M);if(y.shadow=k.castShadow)y.shadowBias=k.shadow.bias,y.shadowRadius=k.shadow.radius,y.shadowMapSize=k.shadow.mapSize;S.directionalShadowMap[E]=k.shadow.map;S.directionalShadowMatrix[E]=k.shadow.matrix;S.directional[E++]=y}else if(k instanceof THREE.SpotLight){y=Ea.get(k);y.position.setFromMatrixPosition(k.matrixWorld);y.position.applyMatrix4(M);y.color.copy(u).multiplyScalar(v);y.distance=x;y.direction.setFromMatrixPosition(k.matrixWorld);
Y.setFromMatrixPosition(k.target.matrixWorld);y.direction.sub(Y);y.direction.transformDirection(M);y.coneCos=Math.cos(k.angle);y.penumbraCos=Math.cos(k.angle*(1-k.penumbra));y.decay=0===k.distance?0:k.decay;if(y.shadow=k.castShadow)y.shadowBias=k.shadow.bias,y.shadowRadius=k.shadow.radius,y.shadowMapSize=k.shadow.mapSize;S.spotShadowMap[ba]=k.shadow.map;S.spotShadowMatrix[ba]=k.shadow.matrix;S.spot[ba++]=y}else if(k instanceof THREE.PointLight){y=Ea.get(k);y.position.setFromMatrixPosition(k.matrixWorld);
y.position.applyMatrix4(M);y.color.copy(k.color).multiplyScalar(k.intensity);y.distance=k.distance;y.decay=0===k.distance?0:k.decay;if(y.shadow=k.castShadow)y.shadowBias=k.shadow.bias,y.shadowRadius=k.shadow.radius,y.shadowMapSize=k.shadow.mapSize;S.pointShadowMap[O]=k.shadow.map;void 0===S.pointShadowMatrix[O]&&(S.pointShadowMatrix[O]=new THREE.Matrix4);Y.setFromMatrixPosition(k.matrixWorld).negate();S.pointShadowMatrix[O].identity().setPosition(Y);S.point[O++]=y}else k instanceof THREE.HemisphereLight&&
(y=Ea.get(k),y.direction.setFromMatrixPosition(k.matrixWorld),y.direction.transformDirection(M),y.direction.normalize(),y.skyColor.copy(k.color).multiplyScalar(v),y.groundColor.copy(k.groundColor).multiplyScalar(v),S.hemi[z++]=y);S.ambient[0]=m;S.ambient[1]=l;S.ambient[2]=q;S.directional.length=E;S.spot.length=ba;S.point.length=O;S.hemi.length=z;S.hash=E+","+O+","+ba+","+z+","+S.shadows.length;xa&&(sa=!1,w());ia.calls=0;ia.vertices=0;ia.faces=0;ia.points=0;void 0===c&&(c=null);this.setRenderTarget(c);
(this.autoClear||d)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil);a.overrideMaterial?(d=a.overrideMaterial,s(F,b,e,d),s(T,b,e,d)):(N.setBlending(THREE.NoBlending),s(F,b,e),s(T,b,e));Sa.render(a,b);Ta.render(a,b,la);c&&(a=c.texture,a.generateMipmaps&&C(c)&&a.minFilter!==THREE.NearestFilter&&a.minFilter!==THREE.LinearFilter&&(a=c instanceof THREE.WebGLRenderTargetCube?t.TEXTURE_CUBE_MAP:t.TEXTURE_2D,c=U.get(c.texture).__webglTexture,N.bindTexture(a,c),t.generateMipmap(a),
N.bindTexture(a,null)));N.setDepthTest(!0);N.setDepthWrite(!0);N.setColorWrite(!0)}};this.setFaceCulling=function(a,b){a===THREE.CullFaceNone?N.disable(t.CULL_FACE):(b===THREE.FrontFaceDirectionCW?t.frontFace(t.CW):t.frontFace(t.CCW),a===THREE.CullFaceBack?t.cullFace(t.BACK):a===THREE.CullFaceFront?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK),N.enable(t.CULL_FACE))};var La=!1;this.setTexture=function(a,b){La||(console.warn("THREE.WebGLRenderer: .setTexture is deprecated, use setTexture2D instead."),
La=!0);z(a,b)};this.allocTextureUnit=function(){var a=wa;a>=ea.maxTextures&&console.warn("WebGLRenderer: trying to use "+a+" texture units while this GPU supports only "+ea.maxTextures);wa+=1;return a};this.setTexture2D=z;this.setTextureCube=function(a,b){if(a instanceof THREE.CubeTexture||Array.isArray(a.image)&&6===a.image.length){var c=U.get(a);if(6===a.image.length)if(0<a.version&&c.__version!==a.version){c.__image__webglTextureCube||(a.addEventListener("dispose",f),c.__image__webglTextureCube=
t.createTexture(),ka.textures++);N.activeTexture(t.TEXTURE0+b);N.bindTexture(t.TEXTURE_CUBE_MAP,c.__image__webglTextureCube);t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,a.flipY);for(var d=a instanceof THREE.CompressedTexture,e=a.image[0]instanceof THREE.DataTexture,g=[],h=0;6>h;h++)g[h]=!W.autoScaleCubemaps||d||e?e?a.image[h].image:a.image[h]:y(a.image[h],ea.maxCubemapSize);var k=C(g[0]),m=G(a.format),l=G(a.type);B(t.TEXTURE_CUBE_MAP,a,k);for(h=0;6>h;h++)if(d)for(var n,q=g[h].mipmaps,p=0,r=q.length;p<r;p++)n=
q[p],a.format!==THREE.RGBAFormat&&a.format!==THREE.RGBFormat?-1<N.getCompressedTextureFormats().indexOf(m)?N.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+h,p,m,n.width,n.height,0,n.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setCubeTexture()"):N.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+h,p,m,n.width,n.height,0,m,l,n.data);else e?N.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+h,0,m,g[h].width,g[h].height,0,m,l,g[h].data):N.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+
h,0,m,m,l,g[h]);a.generateMipmaps&&k&&t.generateMipmap(t.TEXTURE_CUBE_MAP);c.__version=a.version;if(a.onUpdate)a.onUpdate(a)}else N.activeTexture(t.TEXTURE0+b),N.bindTexture(t.TEXTURE_CUBE_MAP,c.__image__webglTextureCube)}else c=a.texture,N.activeTexture(t.TEXTURE0+b),N.bindTexture(t.TEXTURE_CUBE_MAP,U.get(c).__webglTexture)};this.getCurrentRenderTarget=function(){return Aa};this.setRenderTarget=function(a){if((Aa=a)&&void 0===U.get(a).__webglFramebuffer){var b=U.get(a),c=U.get(a.texture);a.addEventListener("dispose",
g);c.__webglTexture=t.createTexture();ka.textures++;var d=a instanceof THREE.WebGLRenderTargetCube,e=THREE.Math.isPowerOfTwo(a.width)&&THREE.Math.isPowerOfTwo(a.height);if(d){b.__webglFramebuffer=[];for(var f=0;6>f;f++)b.__webglFramebuffer[f]=t.createFramebuffer()}else b.__webglFramebuffer=t.createFramebuffer();if(d){N.bindTexture(t.TEXTURE_CUBE_MAP,c.__webglTexture);B(t.TEXTURE_CUBE_MAP,a.texture,e);for(f=0;6>f;f++)J(b.__webglFramebuffer[f],a,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+f);
a.texture.generateMipmaps&&e&&t.generateMipmap(t.TEXTURE_CUBE_MAP);N.bindTexture(t.TEXTURE_CUBE_MAP,null)}else N.bindTexture(t.TEXTURE_2D,c.__webglTexture),B(t.TEXTURE_2D,a.texture,e),J(b.__webglFramebuffer,a,t.COLOR_ATTACHMENT0,t.TEXTURE_2D),a.texture.generateMipmaps&&e&&t.generateMipmap(t.TEXTURE_2D),N.bindTexture(t.TEXTURE_2D,null);if(a.depthBuffer){b=U.get(a);c=a instanceof THREE.WebGLRenderTargetCube;if(a.depthTexture){if(c)throw Error("target.depthTexture not supported in Cube render targets");
if(a instanceof THREE.WebGLRenderTargetCube)throw Error("Depth Texture with cube render targets is not supported!");t.bindFramebuffer(t.FRAMEBUFFER,b.__webglFramebuffer);if(!(a.depthTexture instanceof THREE.DepthTexture))throw Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");U.get(a.depthTexture).__webglTexture&&a.depthTexture.image.width===a.width&&a.depthTexture.image.height===a.height||(a.depthTexture.image.width=a.width,a.depthTexture.image.height=a.height,a.depthTexture.needsUpdate=
!0);W.setTexture(a.depthTexture,0);b=U.get(a.depthTexture).__webglTexture;t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,b,0)}else if(c)for(b.__webglDepthbuffer=[],c=0;6>c;c++)t.bindFramebuffer(t.FRAMEBUFFER,b.__webglFramebuffer[c]),b.__webglDepthbuffer[c]=t.createRenderbuffer(),D(b.__webglDepthbuffer[c],a);else t.bindFramebuffer(t.FRAMEBUFFER,b.__webglFramebuffer),b.__webglDepthbuffer=t.createRenderbuffer(),D(b.__webglDepthbuffer,a);t.bindFramebuffer(t.FRAMEBUFFER,null)}}b=
a instanceof THREE.WebGLRenderTargetCube;a?(c=U.get(a),c=b?c.__webglFramebuffer[a.activeCubeFace]:c.__webglFramebuffer,ua.copy(a.scissor),Ga=a.scissorTest,la.copy(a.viewport)):(c=null,ua.copy(Fa).multiplyScalar($),Ga=Ja,la.copy(ma).multiplyScalar($));Ba!==c&&(t.bindFramebuffer(t.FRAMEBUFFER,c),Ba=c);N.scissor(ua);N.setScissorTest(Ga);N.viewport(la);b&&(b=U.get(a.texture),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+a.activeCubeFace,b.__webglTexture,a.activeMipMapLevel))};
this.readRenderTargetPixels=function(a,b,c,d,e,f){if(!1===a instanceof THREE.WebGLRenderTarget)console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");else{var g=U.get(a).__webglFramebuffer;if(g){var h=!1;g!==Ba&&(t.bindFramebuffer(t.FRAMEBUFFER,g),h=!0);try{var k=a.texture;k.format!==THREE.RGBAFormat&&G(k.format)!==t.getParameter(t.IMPLEMENTATION_COLOR_READ_FORMAT)?console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format."):
k.type===THREE.UnsignedByteType||G(k.type)===t.getParameter(t.IMPLEMENTATION_COLOR_READ_TYPE)||k.type===THREE.FloatType&&V.get("WEBGL_color_buffer_float")||k.type===THREE.HalfFloatType&&V.get("EXT_color_buffer_half_float")?t.checkFramebufferStatus(t.FRAMEBUFFER)===t.FRAMEBUFFER_COMPLETE?0<b&&b<=a.width-d&&0<c&&c<=a.height-e&&t.readPixels(b,c,d,e,G(k.format),G(k.type),f):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete."):console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.")}finally{h&&
t.bindFramebuffer(t.FRAMEBUFFER,Ba)}}}}};
THREE.WebGLRenderTarget=function(a,b,c){this.uuid=THREE.Math.generateUUID();this.width=a;this.height=b;this.scissor=new THREE.Vector4(0,0,a,b);this.scissorTest=!1;this.viewport=new THREE.Vector4(0,0,a,b);c=c||{};void 0===c.minFilter&&(c.minFilter=THREE.LinearFilter);this.texture=new THREE.Texture(void 0,void 0,c.wrapS,c.wrapT,c.magFilter,c.minFilter,c.format,c.type,c.anisotropy,c.encoding);this.depthBuffer=void 0!==c.depthBuffer?c.depthBuffer:!0;this.stencilBuffer=void 0!==c.stencilBuffer?c.stencilBuffer:
!0;this.depthTexture=null};
THREE.WebGLRenderTarget.prototype={constructor:THREE.WebGLRenderTarget,setSize:function(a,b){if(this.width!==a||this.height!==b)this.width=a,this.height=b,this.dispose();this.viewport.set(0,0,a,b);this.scissor.set(0,0,a,b)},clone:function(){return(new this.constructor).copy(this)},copy:function(a){this.width=a.width;this.height=a.height;this.viewport.copy(a.viewport);this.texture=a.texture.clone();this.depthBuffer=a.depthBuffer;this.stencilBuffer=a.stencilBuffer;this.depthTexture=a.depthTexture;return this},
dispose:function(){this.dispatchEvent({type:"dispose"})}};THREE.EventDispatcher.prototype.apply(THREE.WebGLRenderTarget.prototype);THREE.WebGLRenderTargetCube=function(a,b,c){THREE.WebGLRenderTarget.call(this,a,b,c);this.activeMipMapLevel=this.activeCubeFace=0};THREE.WebGLRenderTargetCube.prototype=Object.create(THREE.WebGLRenderTarget.prototype);THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;
THREE.WebGLBufferRenderer=function(a,b,c){var d;this.setMode=function(a){d=a};this.render=function(b,f){a.drawArrays(d,b,f);c.calls++;c.vertices+=f;d===a.TRIANGLES&&(c.faces+=f/3)};this.renderInstances=function(e){var f=b.get("ANGLE_instanced_arrays");if(null===f)console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");else{var g=e.attributes.position,h=0,h=g instanceof THREE.InterleavedBufferAttribute?g.data.count:
g.count;f.drawArraysInstancedANGLE(d,0,h,e.maxInstancedCount);c.calls++;c.vertices+=h*e.maxInstancedCount;d===a.TRIANGLES&&(c.faces+=e.maxInstancedCount*h/3)}}};
THREE.WebGLIndexedBufferRenderer=function(a,b,c){var d,e,f;this.setMode=function(a){d=a};this.setIndex=function(c){c.array instanceof Uint32Array&&b.get("OES_element_index_uint")?(e=a.UNSIGNED_INT,f=4):(e=a.UNSIGNED_SHORT,f=2)};this.render=function(b,h){a.drawElements(d,h,e,b*f);c.calls++;c.vertices+=h;d===a.TRIANGLES&&(c.faces+=h/3)};this.renderInstances=function(g,h,k){var l=b.get("ANGLE_instanced_arrays");null===l?console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays."):
(l.drawElementsInstancedANGLE(d,k,e,h*f,g.maxInstancedCount),c.calls++,c.vertices+=k*g.maxInstancedCount,d===a.TRIANGLES&&(c.faces+=g.maxInstancedCount*k/3))}};
THREE.WebGLExtensions=function(a){var b={};this.get=function(c){if(void 0!==b[c])return b[c];var d;switch(c){case "WEBGL_depth_texture":a.getExtension("WEBGL_depth_texture")||a.getExtension("MOZ_WEBGL_depth_texture")||a.getExtension("WEBKIT_WEBGL_depth_texture");case "EXT_texture_filter_anisotropic":d=a.getExtension("EXT_texture_filter_anisotropic")||a.getExtension("MOZ_EXT_texture_filter_anisotropic")||a.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case "WEBGL_compressed_texture_s3tc":d=
a.getExtension("WEBGL_compressed_texture_s3tc")||a.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||a.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case "WEBGL_compressed_texture_pvrtc":d=a.getExtension("WEBGL_compressed_texture_pvrtc")||a.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;case "WEBGL_compressed_texture_etc1":d=a.getExtension("WEBGL_compressed_texture_etc1");break;default:d=a.getExtension(c)}null===d&&console.warn("THREE.WebGLRenderer: "+c+" extension not supported.");
return b[c]=d}};
THREE.WebGLCapabilities=function(a,b,c){function d(b){if("highp"===b){if(0<a.getShaderPrecisionFormat(a.VERTEX_SHADER,a.HIGH_FLOAT).precision&&0<a.getShaderPrecisionFormat(a.FRAGMENT_SHADER,a.HIGH_FLOAT).precision)return"highp";b="mediump"}return"mediump"===b&&0<a.getShaderPrecisionFormat(a.VERTEX_SHADER,a.MEDIUM_FLOAT).precision&&0<a.getShaderPrecisionFormat(a.FRAGMENT_SHADER,a.MEDIUM_FLOAT).precision?"mediump":"lowp"}this.getMaxPrecision=d;this.precision=void 0!==c.precision?c.precision:"highp";
this.logarithmicDepthBuffer=void 0!==c.logarithmicDepthBuffer?c.logarithmicDepthBuffer:!1;this.maxTextures=a.getParameter(a.MAX_TEXTURE_IMAGE_UNITS);this.maxVertexTextures=a.getParameter(a.MAX_VERTEX_TEXTURE_IMAGE_UNITS);this.maxTextureSize=a.getParameter(a.MAX_TEXTURE_SIZE);this.maxCubemapSize=a.getParameter(a.MAX_CUBE_MAP_TEXTURE_SIZE);this.maxAttributes=a.getParameter(a.MAX_VERTEX_ATTRIBS);this.maxVertexUniforms=a.getParameter(a.MAX_VERTEX_UNIFORM_VECTORS);this.maxVaryings=a.getParameter(a.MAX_VARYING_VECTORS);
this.maxFragmentUniforms=a.getParameter(a.MAX_FRAGMENT_UNIFORM_VECTORS);this.vertexTextures=0<this.maxVertexTextures;this.floatFragmentTextures=!!b.get("OES_texture_float");this.floatVertexTextures=this.vertexTextures&&this.floatFragmentTextures;c=d(this.precision);c!==this.precision&&(console.warn("THREE.WebGLRenderer:",this.precision,"not supported, using",c,"instead."),this.precision=c);this.logarithmicDepthBuffer&&(this.logarithmicDepthBuffer=!!b.get("EXT_frag_depth"))};
THREE.WebGLGeometries=function(a,b,c){function d(a){var h=a.target;a=f[h.id];null!==a.index&&e(a.index);var k=a.attributes,l;for(l in k)e(k[l]);h.removeEventListener("dispose",d);delete f[h.id];l=b.get(h);l.wireframe&&e(l.wireframe);b.delete(h);h=b.get(a);h.wireframe&&e(h.wireframe);b.delete(a);c.memory.geometries--}function e(c){var d;d=c instanceof THREE.InterleavedBufferAttribute?b.get(c.data).__webglBuffer:b.get(c).__webglBuffer;void 0!==d&&(a.deleteBuffer(d),c instanceof THREE.InterleavedBufferAttribute?
b.delete(c.data):b.delete(c))}var f={};this.get=function(a){var b=a.geometry;if(void 0!==f[b.id])return f[b.id];b.addEventListener("dispose",d);var e;b instanceof THREE.BufferGeometry?e=b:b instanceof THREE.Geometry&&(void 0===b._bufferGeometry&&(b._bufferGeometry=(new THREE.BufferGeometry).setFromObject(a)),e=b._bufferGeometry);f[b.id]=e;c.memory.geometries++;return e}};
THREE.WebGLLights=function(){var a={};this.get=function(b){if(void 0!==a[b.id])return a[b.id];var c;switch(b.type){case "DirectionalLight":c={direction:new THREE.Vector3,color:new THREE.Color,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case "SpotLight":c={position:new THREE.Vector3,direction:new THREE.Vector3,color:new THREE.Color,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case "PointLight":c=
{position:new THREE.Vector3,color:new THREE.Color,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case "HemisphereLight":c={direction:new THREE.Vector3,skyColor:new THREE.Color,groundColor:new THREE.Color}}return a[b.id]=c}};
THREE.WebGLObjects=function(a,b,c){function d(c,d){var e=c instanceof THREE.InterleavedBufferAttribute?c.data:c,f=b.get(e);void 0===f.__webglBuffer?(f.__webglBuffer=a.createBuffer(),a.bindBuffer(d,f.__webglBuffer),a.bufferData(d,e.array,e.dynamic?a.DYNAMIC_DRAW:a.STATIC_DRAW),f.version=e.version):f.version!==e.version&&(a.bindBuffer(d,f.__webglBuffer),!1===e.dynamic||-1===e.updateRange.count?a.bufferSubData(d,0,e.array):0===e.updateRange.count?console.error("THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually."):
(a.bufferSubData(d,e.updateRange.offset*e.array.BYTES_PER_ELEMENT,e.array.subarray(e.updateRange.offset,e.updateRange.offset+e.updateRange.count)),e.updateRange.count=0),f.version=e.version)}function e(a,b,c){if(b>c){var d=b;b=c;c=d}d=a[b];return void 0===d?(a[b]=[c],!0):-1===d.indexOf(c)?(d.push(c),!0):!1}var f=new THREE.WebGLGeometries(a,b,c);this.getAttributeBuffer=function(a){return a instanceof THREE.InterleavedBufferAttribute?b.get(a.data).__webglBuffer:b.get(a).__webglBuffer};this.getWireframeAttribute=
function(c){var f=b.get(c);if(void 0!==f.wireframe)return f.wireframe;var k=[],l=c.index,n=c.attributes;c=n.position;if(null!==l)for(var n={},l=l.array,p=0,m=l.length;p<m;p+=3){var q=l[p+0],r=l[p+1],s=l[p+2];e(n,q,r)&&k.push(q,r);e(n,r,s)&&k.push(r,s);e(n,s,q)&&k.push(s,q)}else for(l=n.position.array,p=0,m=l.length/3-1;p<m;p+=3)q=p+0,r=p+1,s=p+2,k.push(q,r,r,s,s,q);k=new THREE.BufferAttribute(new (65535<c.count?Uint32Array:Uint16Array)(k),1);d(k,a.ELEMENT_ARRAY_BUFFER);return f.wireframe=k};this.update=
function(b){var c=f.get(b);b.geometry instanceof THREE.Geometry&&c.updateFromObject(b);b=c.index;var e=c.attributes;null!==b&&d(b,a.ELEMENT_ARRAY_BUFFER);for(var l in e)d(e[l],a.ARRAY_BUFFER);b=c.morphAttributes;for(l in b)for(var e=b[l],n=0,p=e.length;n<p;n++)d(e[n],a.ARRAY_BUFFER);return c}};
THREE.WebGLProgram=function(){function a(a){switch(a){case THREE.LinearEncoding:return["Linear","( value )"];case THREE.sRGBEncoding:return["sRGB","( value )"];case THREE.RGBEEncoding:return["RGBE","( value )"];case THREE.RGBM7Encoding:return["RGBM","( value, 7.0 )"];case THREE.RGBM16Encoding:return["RGBM","( value, 16.0 )"];case THREE.RGBDEncoding:return["RGBD","( value, 256.0 )"];case THREE.GammaEncoding:return["Gamma","( value, float( GAMMA_FACTOR ) )"];default:throw Error("unsupported encoding: "+
a);}}function b(b,c){var d=a(c);return"vec4 "+b+"( vec4 value ) { return "+d[0]+"ToLinear"+d[1]+"; }"}function c(b,c){var d=a(c);return"vec4 "+b+"( vec4 value ) { return LinearTo"+d[0]+d[1]+"; }"}function d(a,b){var c;switch(b){case THREE.LinearToneMapping:c="Linear";break;case THREE.ReinhardToneMapping:c="Reinhard";break;case THREE.Uncharted2ToneMapping:c="Uncharted2";break;case THREE.CineonToneMapping:c="OptimizedCineon";break;default:throw Error("unsupported toneMapping: "+b);}return"vec3 "+a+
"( vec3 color ) { return "+c+"ToneMapping( color ); }"}function e(a,b,c){a=a||{};return[a.derivatives||b.envMapCubeUV||b.bumpMap||b.normalMap||b.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(a.fragDepth||b.logarithmicDepthBuffer)&&c.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",a.drawBuffers&&c.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(a.shaderTextureLOD||b.envMap)&&c.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":
""].filter(g).join("\n")}function f(a){var b=[],c;for(c in a){var d=a[c];!1!==d&&b.push("#define "+c+" "+d)}return b.join("\n")}function g(a){return""!==a}function h(a,b){return a.replace(/NUM_DIR_LIGHTS/g,b.numDirLights).replace(/NUM_SPOT_LIGHTS/g,b.numSpotLights).replace(/NUM_POINT_LIGHTS/g,b.numPointLights).replace(/NUM_HEMI_LIGHTS/g,b.numHemiLights)}function k(a){return a.replace(/#include +<([\w\d.]+)>/g,function(a,b){var c=THREE.ShaderChunk[b];if(void 0===c)throw Error("Can not resolve #include <"+
b+">");return k(c)})}function l(a){return a.replace(/for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g,function(a,b,c,d){a="";for(b=parseInt(b);b<parseInt(c);b++)a+=d.replace(/\[ i \]/g,"[ "+b+" ]");return a})}var n=0;return function(a,m,q,r){var s=a.context,u=q.extensions,v=q.defines,x=q.__webglShader.vertexShader,A=q.__webglShader.fragmentShader,w="SHADOWMAP_TYPE_BASIC";r.shadowMapType===THREE.PCFShadowMap?w="SHADOWMAP_TYPE_PCF":r.shadowMapType===THREE.PCFSoftShadowMap&&(w="SHADOWMAP_TYPE_PCF_SOFT");
var B="ENVMAP_TYPE_CUBE",z="ENVMAP_MODE_REFLECTION",y="ENVMAP_BLENDING_MULTIPLY";if(r.envMap){switch(q.envMap.mapping){case THREE.CubeReflectionMapping:case THREE.CubeRefractionMapping:B="ENVMAP_TYPE_CUBE";break;case THREE.CubeUVReflectionMapping:case THREE.CubeUVRefractionMapping:B="ENVMAP_TYPE_CUBE_UV";break;case THREE.EquirectangularReflectionMapping:case THREE.EquirectangularRefractionMapping:B="ENVMAP_TYPE_EQUIREC";break;case THREE.SphericalReflectionMapping:B="ENVMAP_TYPE_SPHERE"}switch(q.envMap.mapping){case THREE.CubeRefractionMapping:case THREE.EquirectangularRefractionMapping:z=
"ENVMAP_MODE_REFRACTION"}switch(q.combine){case THREE.MultiplyOperation:y="ENVMAP_BLENDING_MULTIPLY";break;case THREE.MixOperation:y="ENVMAP_BLENDING_MIX";break;case THREE.AddOperation:y="ENVMAP_BLENDING_ADD"}}var C=0<a.gammaFactor?a.gammaFactor:1,u=e(u,r,a.extensions),J=f(v),D=s.createProgram();q instanceof THREE.RawShaderMaterial?w=v="":(v=["precision "+r.precision+" float;","precision "+r.precision+" int;","#define SHADER_NAME "+q.__webglShader.name,J,r.supportsVertexTextures?"#define VERTEX_TEXTURES":
"","#define GAMMA_FACTOR "+C,"#define MAX_BONES "+r.maxBones,r.map?"#define USE_MAP":"",r.envMap?"#define USE_ENVMAP":"",r.envMap?"#define "+z:"",r.lightMap?"#define USE_LIGHTMAP":"",r.aoMap?"#define USE_AOMAP":"",r.emissiveMap?"#define USE_EMISSIVEMAP":"",r.bumpMap?"#define USE_BUMPMAP":"",r.normalMap?"#define USE_NORMALMAP":"",r.displacementMap&&r.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",r.specularMap?"#define USE_SPECULARMAP":"",r.roughnessMap?"#define USE_ROUGHNESSMAP":"",r.metalnessMap?
"#define USE_METALNESSMAP":"",r.alphaMap?"#define USE_ALPHAMAP":"",r.vertexColors?"#define USE_COLOR":"",r.flatShading?"#define FLAT_SHADED":"",r.skinning?"#define USE_SKINNING":"",r.useVertexTexture?"#define BONE_TEXTURE":"",r.morphTargets?"#define USE_MORPHTARGETS":"",r.morphNormals&&!1===r.flatShading?"#define USE_MORPHNORMALS":"",r.doubleSided?"#define DOUBLE_SIDED":"",r.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+r.numClippingPlanes,r.shadowMapEnabled?"#define USE_SHADOWMAP":
"",r.shadowMapEnabled?"#define "+w:"",r.sizeAttenuation?"#define USE_SIZEATTENUATION":"",r.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",r.logarithmicDepthBuffer&&a.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_COLOR",
"\tattribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;",
"\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(g).join("\n"),w=[u,"precision "+r.precision+" float;","precision "+r.precision+" int;","#define SHADER_NAME "+q.__webglShader.name,J,r.alphaTest?"#define ALPHATEST "+r.alphaTest:"","#define GAMMA_FACTOR "+C,r.useFog&&r.fog?"#define USE_FOG":"",r.useFog&&r.fogExp?"#define FOG_EXP2":"",r.map?"#define USE_MAP":"",r.envMap?"#define USE_ENVMAP":"",r.envMap?"#define "+B:"",r.envMap?
"#define "+z:"",r.envMap?"#define "+y:"",r.lightMap?"#define USE_LIGHTMAP":"",r.aoMap?"#define USE_AOMAP":"",r.emissiveMap?"#define USE_EMISSIVEMAP":"",r.bumpMap?"#define USE_BUMPMAP":"",r.normalMap?"#define USE_NORMALMAP":"",r.specularMap?"#define USE_SPECULARMAP":"",r.roughnessMap?"#define USE_ROUGHNESSMAP":"",r.metalnessMap?"#define USE_METALNESSMAP":"",r.alphaMap?"#define USE_ALPHAMAP":"",r.vertexColors?"#define USE_COLOR":"",r.flatShading?"#define FLAT_SHADED":"",r.doubleSided?"#define DOUBLE_SIDED":
"",r.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+r.numClippingPlanes,r.shadowMapEnabled?"#define USE_SHADOWMAP":"",r.shadowMapEnabled?"#define "+w:"",r.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",r.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",r.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",r.logarithmicDepthBuffer&&a.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"",r.envMap&&a.extensions.get("EXT_shader_texture_lod")?"#define TEXTURE_LOD_EXT":
"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",r.toneMapping!==THREE.NoToneMapping?"#define TONE_MAPPING":"",r.toneMapping!==THREE.NoToneMapping?THREE.ShaderChunk.tonemapping_pars_fragment:"",r.toneMapping!==THREE.NoToneMapping?d("toneMapping",r.toneMapping):"",r.outputEncoding||r.mapEncoding||r.envMapEncoding||r.emissiveMapEncoding?THREE.ShaderChunk.encodings_pars_fragment:"",r.mapEncoding?b("mapTexelToLinear",r.mapEncoding):"",r.envMapEncoding?b("envMapTexelToLinear",r.envMapEncoding):
"",r.emissiveMapEncoding?b("emissiveMapTexelToLinear",r.emissiveMapEncoding):"",r.outputEncoding?c("linearToOutputTexel",r.outputEncoding):"",r.depthPacking?"#define DEPTH_PACKING "+q.depthPacking:"","\n"].filter(g).join("\n"));x=k(x,r);x=h(x,r);A=k(A,r);A=h(A,r);!1===q instanceof THREE.ShaderMaterial&&(x=l(x),A=l(A));A=w+A;x=THREE.WebGLShader(s,s.VERTEX_SHADER,v+x);A=THREE.WebGLShader(s,s.FRAGMENT_SHADER,A);s.attachShader(D,x);s.attachShader(D,A);void 0!==q.index0AttributeName?s.bindAttribLocation(D,
0,q.index0AttributeName):!0===r.morphTargets&&s.bindAttribLocation(D,0,"position");s.linkProgram(D);r=s.getProgramInfoLog(D);B=s.getShaderInfoLog(x);z=s.getShaderInfoLog(A);C=y=!0;if(!1===s.getProgramParameter(D,s.LINK_STATUS))y=!1,console.error("THREE.WebGLProgram: shader error: ",s.getError(),"gl.VALIDATE_STATUS",s.getProgramParameter(D,s.VALIDATE_STATUS),"gl.getProgramInfoLog",r,B,z);else if(""!==r)console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",r);else if(""===B||""===z)C=!1;C&&(this.diagnostics=
{runnable:y,material:q,programLog:r,vertexShader:{log:B,prefix:v},fragmentShader:{log:z,prefix:w}});s.deleteShader(x);s.deleteShader(A);var H;this.getUniforms=function(){void 0===H&&(H=new THREE.WebGLUniforms(s,D,a));return H};var G;this.getAttributes=function(){if(void 0===G){for(var a={},b=s.getProgramParameter(D,s.ACTIVE_ATTRIBUTES),c=0;c<b;c++){var d=s.getActiveAttrib(D,c).name;a[d]=s.getAttribLocation(D,d)}G=a}return G};this.destroy=function(){s.deleteProgram(D);this.program=void 0};Object.defineProperties(this,
{uniforms:{get:function(){console.warn("THREE.WebGLProgram: .uniforms is now .getUniforms().");return this.getUniforms()}},attributes:{get:function(){console.warn("THREE.WebGLProgram: .attributes is now .getAttributes().");return this.getAttributes()}}});this.id=n++;this.code=m;this.usedTimes=1;this.program=D;this.vertexShader=x;this.fragmentShader=A;return this}}();
THREE.WebGLPrograms=function(a,b){function c(a,b){var c;a?a instanceof THREE.Texture?c=a.encoding:a instanceof THREE.WebGLRenderTarget&&(c=a.texture.encoding):c=THREE.LinearEncoding;c===THREE.LinearEncoding&&b&&(c=THREE.GammaEncoding);return c}var d=[],e={MeshDepthMaterial:"depth",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",
PointsMaterial:"points"},f="precision supportsVertexTextures map mapEncoding envMap envMapMode envMapEncoding lightMap aoMap emissiveMap emissiveMapEncoding bumpMap normalMap displacementMap specularMap roughnessMap metalnessMap alphaMap combine vertexColors fog useFog fogExp flatShading sizeAttenuation logarithmicDepthBuffer skinning maxBones useVertexTexture morphTargets morphNormals maxMorphTargets maxMorphNormals premultipliedAlpha numDirLights numPointLights numSpotLights numHemiLights shadowMapEnabled shadowMapType toneMapping physicallyCorrectLights alphaTest doubleSided flipSided numClippingPlanes depthPacking".split(" ");
this.getParameters=function(d,f,k,l,n){var p=e[d.type],m;b.floatVertexTextures&&n&&n.skeleton&&n.skeleton.useVertexTexture?m=1024:(m=Math.floor((b.maxVertexUniforms-20)/4),void 0!==n&&n instanceof THREE.SkinnedMesh&&(m=Math.min(n.skeleton.bones.length,m),m<n.skeleton.bones.length&&console.warn("WebGLRenderer: too many bones - "+n.skeleton.bones.length+", this GPU supports just "+m+" (try OpenGL instead of ANGLE)")));var q=a.getPrecision();null!==d.precision&&(q=b.getMaxPrecision(d.precision),q!==
d.precision&&console.warn("THREE.WebGLProgram.getParameters:",d.precision,"not supported, using",q,"instead."));return{shaderID:p,precision:q,supportsVertexTextures:b.vertexTextures,outputEncoding:c(a.getCurrentRenderTarget(),a.gammaOutput),map:!!d.map,mapEncoding:c(d.map,a.gammaInput),envMap:!!d.envMap,envMapMode:d.envMap&&d.envMap.mapping,envMapEncoding:c(d.envMap,a.gammaInput),envMapCubeUV:!!d.envMap&&(d.envMap.mapping===THREE.CubeUVReflectionMapping||d.envMap.mapping===THREE.CubeUVRefractionMapping),
lightMap:!!d.lightMap,aoMap:!!d.aoMap,emissiveMap:!!d.emissiveMap,emissiveMapEncoding:c(d.emissiveMap,a.gammaInput),bumpMap:!!d.bumpMap,normalMap:!!d.normalMap,displacementMap:!!d.displacementMap,roughnessMap:!!d.roughnessMap,metalnessMap:!!d.metalnessMap,specularMap:!!d.specularMap,alphaMap:!!d.alphaMap,combine:d.combine,vertexColors:d.vertexColors,fog:k,useFog:d.fog,fogExp:k instanceof THREE.FogExp2,flatShading:d.shading===THREE.FlatShading,sizeAttenuation:d.sizeAttenuation,logarithmicDepthBuffer:b.logarithmicDepthBuffer,
skinning:d.skinning,maxBones:m,useVertexTexture:b.floatVertexTextures&&n&&n.skeleton&&n.skeleton.useVertexTexture,morphTargets:d.morphTargets,morphNormals:d.morphNormals,maxMorphTargets:a.maxMorphTargets,maxMorphNormals:a.maxMorphNormals,numDirLights:f.directional.length,numPointLights:f.point.length,numSpotLights:f.spot.length,numHemiLights:f.hemi.length,numClippingPlanes:l,shadowMapEnabled:a.shadowMap.enabled&&n.receiveShadow&&0<f.shadows.length,shadowMapType:a.shadowMap.type,toneMapping:a.toneMapping,
physicallyCorrectLights:a.physicallyCorrectLights,premultipliedAlpha:d.premultipliedAlpha,alphaTest:d.alphaTest,doubleSided:d.side===THREE.DoubleSide,flipSided:d.side===THREE.BackSide,depthPacking:void 0!==d.depthPacking?d.depthPacking:!1}};this.getProgramCode=function(a,b){var c=[];b.shaderID?c.push(b.shaderID):(c.push(a.fragmentShader),c.push(a.vertexShader));if(void 0!==a.defines)for(var d in a.defines)c.push(d),c.push(a.defines[d]);for(d=0;d<f.length;d++)c.push(b[f[d]]);return c.join()};this.acquireProgram=
function(b,c,e){for(var f,n=0,p=d.length;n<p;n++){var m=d[n];if(m.code===e){f=m;++f.usedTimes;break}}void 0===f&&(f=new THREE.WebGLProgram(a,e,b,c),d.push(f));return f};this.releaseProgram=function(a){if(0===--a.usedTimes){var b=d.indexOf(a);d[b]=d[d.length-1];d.pop();a.destroy()}};this.programs=d};THREE.WebGLProperties=function(){var a={};this.get=function(b){b=b.uuid;var c=a[b];void 0===c&&(c={},a[b]=c);return c};this.delete=function(b){delete a[b.uuid]};this.clear=function(){a={}}};
THREE.WebGLShader=function(){function a(a){a=a.split("\n");for(var c=0;c<a.length;c++)a[c]=c+1+": "+a[c];return a.join("\n")}return function(b,c,d){var e=b.createShader(c);b.shaderSource(e,d);b.compileShader(e);!1===b.getShaderParameter(e,b.COMPILE_STATUS)&&console.error("THREE.WebGLShader: Shader couldn't compile.");""!==b.getShaderInfoLog(e)&&console.warn("THREE.WebGLShader: gl.getShaderInfoLog()",c===b.VERTEX_SHADER?"vertex":"fragment",b.getShaderInfoLog(e),a(d));return e}}();
THREE.WebGLShadowMap=function(a,b,c){function d(b,c,d,e){var f=b.geometry,g=null,g=r,h=b.customDepthMaterial;d&&(g=s,h=b.customDistanceMaterial);h?g=h:(b=b instanceof THREE.SkinnedMesh&&c.skinning,h=0,void 0!==f.morphTargets&&0<f.morphTargets.length&&c.morphTargets&&(h|=1),b&&(h|=2),g=g[h]);a.localClippingEnabled&&!0===c.clipShadows&&0!==c.clippingPlanes.length&&(h=g.uuid,f=c.uuid,b=u[h],void 0===b&&(b={},u[h]=b),h=b[f],void 0===h&&(h=g.clone(),b[f]=h),g=h);g.visible=c.visible;g.wireframe=c.wireframe;
g.side=c.side;g.clipShadows=c.clipShadows;g.clippingPlanes=c.clippingPlanes;g.wireframeLinewidth=c.wireframeLinewidth;g.linewidth=c.linewidth;d&&void 0!==g.uniforms.lightPos&&g.uniforms.lightPos.value.copy(e);return g}function e(a,b,c){if(!1!==a.visible){a.layers.test(b.layers)&&(a instanceof THREE.Mesh||a instanceof THREE.Line||a instanceof THREE.Points)&&a.castShadow&&(!1===a.frustumCulled||!0===h.intersectsObject(a))&&!0===a.material.visible&&(a.modelViewMatrix.multiplyMatrices(c.matrixWorldInverse,
a.matrixWorld),q.push(a));a=a.children;for(var d=0,f=a.length;d<f;d++)e(a[d],b,c)}}var f=a.context,g=a.state,h=new THREE.Frustum,k=new THREE.Matrix4,l=b.shadows,n=new THREE.Vector2,p=new THREE.Vector3,m=new THREE.Vector3,q=[],r=Array(4),s=Array(4),u={},v=[new THREE.Vector3(1,0,0),new THREE.Vector3(-1,0,0),new THREE.Vector3(0,0,1),new THREE.Vector3(0,0,-1),new THREE.Vector3(0,1,0),new THREE.Vector3(0,-1,0)],x=[new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,
1,0),new THREE.Vector3(0,0,1),new THREE.Vector3(0,0,-1)],A=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4];b=new THREE.MeshDepthMaterial;b.depthPacking=THREE.RGBADepthPacking;b.clipping=!0;for(var w=THREE.ShaderLib.distanceRGBA,B=THREE.UniformsUtils.clone(w.uniforms),z=0;4!==z;++z){var y=0!==(z&1),C=0!==(z&2),J=b.clone();J.morphTargets=y;J.skinning=C;r[z]=J;y=new THREE.ShaderMaterial({defines:{USE_SHADOWMAP:""},uniforms:B,vertexShader:w.vertexShader,
fragmentShader:w.fragmentShader,morphTargets:y,skinning:C,clipping:!0});s[z]=y}var D=this;this.enabled=!1;this.autoUpdate=!0;this.needsUpdate=!1;this.type=THREE.PCFShadowMap;this.cullFace=THREE.CullFaceFront;this.render=function(b,r){if(!1!==D.enabled&&(!1!==D.autoUpdate||!1!==D.needsUpdate)&&0!==l.length){g.clearColor(1,1,1,1);g.disable(f.BLEND);g.enable(f.CULL_FACE);f.frontFace(f.CCW);f.cullFace(D.cullFace===THREE.CullFaceFront?f.FRONT:f.BACK);g.setDepthTest(!0);g.setScissorTest(!1);for(var s,u,
w=0,y=l.length;w<y;w++){var E=l[w],M=E.shadow,O=M.camera;n.copy(M.mapSize);if(E instanceof THREE.PointLight){s=6;u=!0;var z=n.x,B=n.y;A[0].set(2*z,B,z,B);A[1].set(0,B,z,B);A[2].set(3*z,B,z,B);A[3].set(z,B,z,B);A[4].set(3*z,0,z,B);A[5].set(z,0,z,B);n.x*=4;n.y*=2}else s=1,u=!1;null===M.map&&(M.map=new THREE.WebGLRenderTarget(n.x,n.y,{minFilter:THREE.NearestFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat}),O.updateProjectionMatrix());M instanceof THREE.SpotLightShadow&&M.update(E);z=M.map;
M=M.matrix;m.setFromMatrixPosition(E.matrixWorld);O.position.copy(m);a.setRenderTarget(z);a.clear();for(z=0;z<s;z++){u?(p.copy(O.position),p.add(v[z]),O.up.copy(x[z]),O.lookAt(p),g.viewport(A[z])):(p.setFromMatrixPosition(E.target.matrixWorld),O.lookAt(p));O.updateMatrixWorld();O.matrixWorldInverse.getInverse(O.matrixWorld);M.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1);M.multiply(O.projectionMatrix);M.multiply(O.matrixWorldInverse);k.multiplyMatrices(O.projectionMatrix,O.matrixWorldInverse);h.setFromMatrix(k);
q.length=0;e(b,r,O);for(var B=0,C=q.length;B<C;B++){var J=q[B],T=c.update(J),X=J.material;if(X instanceof THREE.MultiMaterial)for(var ba=T.groups,X=X.materials,ha=0,qa=ba.length;ha<qa;ha++){var W=ba[ha],ca=X[W.materialIndex];!0===ca.visible&&(ca=d(J,ca,u,m),a.renderBufferDirect(O,null,T,ca,J,W))}else ca=d(J,X,u,m),a.renderBufferDirect(O,null,T,ca,J,null)}}}s=a.getClearColor();u=a.getClearAlpha();a.setClearColor(s,u);g.enable(f.BLEND);D.cullFace===THREE.CullFaceFront&&f.cullFace(f.BACK);D.needsUpdate=
!1}}};
THREE.WebGLState=function(a,b,c){var d=this,e=new THREE.Vector4,f=a.getParameter(a.MAX_VERTEX_ATTRIBS),g=new Uint8Array(f),h=new Uint8Array(f),k=new Uint8Array(f),l={},n=null,p=null,m=null,q=null,r=null,s=null,u=null,v=null,x=!1,A=null,w=null,B=null,z=null,y=null,C=null,J=null,D=null,H=null,G=null,K=null,P=null,I=null,L=null,E=null,M=a.getParameter(a.MAX_TEXTURE_IMAGE_UNITS),O=void 0,Q={},R=new THREE.Vector4,F=null,Z=null,T=new THREE.Vector4,X=new THREE.Vector4;this.init=function(){this.clearColor(0,0,
0,1);this.clearDepth(1);this.clearStencil(0);this.enable(a.DEPTH_TEST);a.depthFunc(a.LEQUAL);a.frontFace(a.CCW);a.cullFace(a.BACK);this.enable(a.CULL_FACE);this.enable(a.BLEND);a.blendEquation(a.FUNC_ADD);a.blendFunc(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA)};this.initAttributes=function(){for(var a=0,b=g.length;a<b;a++)g[a]=0};this.enableAttribute=function(c){g[c]=1;0===h[c]&&(a.enableVertexAttribArray(c),h[c]=1);0!==k[c]&&(b.get("ANGLE_instanced_arrays").vertexAttribDivisorANGLE(c,0),k[c]=0)};this.enableAttributeAndDivisor=
function(b,c,d){g[b]=1;0===h[b]&&(a.enableVertexAttribArray(b),h[b]=1);k[b]!==c&&(d.vertexAttribDivisorANGLE(b,c),k[b]=c)};this.disableUnusedAttributes=function(){for(var b=0,c=h.length;b<c;b++)h[b]!==g[b]&&(a.disableVertexAttribArray(b),h[b]=0)};this.enable=function(b){!0!==l[b]&&(a.enable(b),l[b]=!0)};this.disable=function(b){!1!==l[b]&&(a.disable(b),l[b]=!1)};this.getCompressedTextureFormats=function(){if(null===n&&(n=[],b.get("WEBGL_compressed_texture_pvrtc")||b.get("WEBGL_compressed_texture_s3tc")||
b.get("WEBGL_compressed_texture_etc1")))for(var c=a.getParameter(a.COMPRESSED_TEXTURE_FORMATS),d=0;d<c.length;d++)n.push(c[d]);return n};this.setBlending=function(b,d,e,f,g,h,k,l){b===THREE.NoBlending?this.disable(a.BLEND):this.enable(a.BLEND);if(b!==p||l!==x)b===THREE.AdditiveBlending?l?(a.blendEquationSeparate(a.FUNC_ADD,a.FUNC_ADD),a.blendFuncSeparate(a.ONE,a.ONE,a.ONE,a.ONE)):(a.blendEquation(a.FUNC_ADD),a.blendFunc(a.SRC_ALPHA,a.ONE)):b===THREE.SubtractiveBlending?l?(a.blendEquationSeparate(a.FUNC_ADD,
a.FUNC_ADD),a.blendFuncSeparate(a.ZERO,a.ZERO,a.ONE_MINUS_SRC_COLOR,a.ONE_MINUS_SRC_ALPHA)):(a.blendEquation(a.FUNC_ADD),a.blendFunc(a.ZERO,a.ONE_MINUS_SRC_COLOR)):b===THREE.MultiplyBlending?l?(a.blendEquationSeparate(a.FUNC_ADD,a.FUNC_ADD),a.blendFuncSeparate(a.ZERO,a.ZERO,a.SRC_COLOR,a.SRC_ALPHA)):(a.blendEquation(a.FUNC_ADD),a.blendFunc(a.ZERO,a.SRC_COLOR)):l?(a.blendEquationSeparate(a.FUNC_ADD,a.FUNC_ADD),a.blendFuncSeparate(a.ONE,a.ONE_MINUS_SRC_ALPHA,a.ONE,a.ONE_MINUS_SRC_ALPHA)):(a.blendEquationSeparate(a.FUNC_ADD,
a.FUNC_ADD),a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE,a.ONE_MINUS_SRC_ALPHA)),p=b,x=l;if(b===THREE.CustomBlending){g=g||d;h=h||e;k=k||f;if(d!==m||g!==s)a.blendEquationSeparate(c(d),c(g)),m=d,s=g;if(e!==q||f!==r||h!==u||k!==v)a.blendFuncSeparate(c(e),c(f),c(h),c(k)),q=e,r=f,u=h,v=k}else v=u=s=r=q=m=null};this.setDepthFunc=function(b){if(A!==b){if(b)switch(b){case THREE.NeverDepth:a.depthFunc(a.NEVER);break;case THREE.AlwaysDepth:a.depthFunc(a.ALWAYS);break;case THREE.LessDepth:a.depthFunc(a.LESS);
break;case THREE.LessEqualDepth:a.depthFunc(a.LEQUAL);break;case THREE.EqualDepth:a.depthFunc(a.EQUAL);break;case THREE.GreaterEqualDepth:a.depthFunc(a.GEQUAL);break;case THREE.GreaterDepth:a.depthFunc(a.GREATER);break;case THREE.NotEqualDepth:a.depthFunc(a.NOTEQUAL);break;default:a.depthFunc(a.LEQUAL)}else a.depthFunc(a.LEQUAL);A=b}};this.setDepthTest=function(b){b?this.enable(a.DEPTH_TEST):this.disable(a.DEPTH_TEST)};this.setDepthWrite=function(b){w!==b&&(a.depthMask(b),w=b)};this.setColorWrite=
function(b){B!==b&&(a.colorMask(b,b,b,b),B=b)};this.setStencilFunc=function(b,c,d){if(y!==b||C!==c||J!==d)a.stencilFunc(b,c,d),y=b,C=c,J=d};this.setStencilOp=function(b,c,d){if(D!==b||H!==c||G!==d)a.stencilOp(b,c,d),D=b,H=c,G=d};this.setStencilTest=function(b){b?this.enable(a.STENCIL_TEST):this.disable(a.STENCIL_TEST)};this.setStencilWrite=function(b){z!==b&&(a.stencilMask(b),z=b)};this.setFlipSided=function(b){K!==b&&(b?a.frontFace(a.CW):a.frontFace(a.CCW),K=b)};this.setLineWidth=function(b){b!==
P&&(a.lineWidth(b),P=b)};this.setPolygonOffset=function(b,c,d){b?this.enable(a.POLYGON_OFFSET_FILL):this.disable(a.POLYGON_OFFSET_FILL);!b||I===c&&L===d||(a.polygonOffset(c,d),I=c,L=d)};this.getScissorTest=function(){return E};this.setScissorTest=function(b){(E=b)?this.enable(a.SCISSOR_TEST):this.disable(a.SCISSOR_TEST)};this.activeTexture=function(b){void 0===b&&(b=a.TEXTURE0+M-1);O!==b&&(a.activeTexture(b),O=b)};this.bindTexture=function(b,c){void 0===O&&d.activeTexture();var e=Q[O];void 0===e&&
(e={type:void 0,texture:void 0},Q[O]=e);if(e.type!==b||e.texture!==c)a.bindTexture(b,c),e.type=b,e.texture=c};this.compressedTexImage2D=function(){try{a.compressedTexImage2D.apply(a,arguments)}catch(b){console.error(b)}};this.texImage2D=function(){try{a.texImage2D.apply(a,arguments)}catch(b){console.error(b)}};this.clearColor=function(b,c,d,f){e.set(b,c,d,f);!1===R.equals(e)&&(a.clearColor(b,c,d,f),R.copy(e))};this.clearDepth=function(b){F!==b&&(a.clearDepth(b),F=b)};this.clearStencil=function(b){Z!==
b&&(a.clearStencil(b),Z=b)};this.scissor=function(b){!1===T.equals(b)&&(a.scissor(b.x,b.y,b.z,b.w),T.copy(b))};this.viewport=function(b){!1===X.equals(b)&&(a.viewport(b.x,b.y,b.z,b.w),X.copy(b))};this.reset=function(){for(var b=0;b<h.length;b++)1===h[b]&&(a.disableVertexAttribArray(b),h[b]=0);l={};n=null;O=void 0;Q={};K=z=w=B=p=null}};
THREE.WebGLUniforms=function(){var a=[],b=[],c=function(b,c,d){var e=b[0];if(0>=e||0<e)return b;var f=c*d,g=a[f];void 0===g&&(g=new Float32Array(f),a[f]=g);if(0!==c)for(e.toArray(g,0),e=1,f=0;e!==c;++e)f+=d,b[e].toArray(g,f);return g},d=function(a,c){var d=b[c];void 0===d&&(d=new Int32Array(c),b[c]=d);for(var e=0;e!==c;++e)d[e]=a.allocTextureUnit();return d},e=function(a,b){a.uniform1f(this.addr,b)},f=function(a,b){a.uniform1i(this.addr,b)},g=function(a,b){void 0===b.x?a.uniform2fv(this.addr,b):a.uniform2f(this.addr,
b.x,b.y)},h=function(a,b){void 0!==b.x?a.uniform3f(this.addr,b.x,b.y,b.z):void 0!==b.r?a.uniform3f(this.addr,b.r,b.g,b.b):a.uniform3fv(this.addr,b)},k=function(a,b){void 0===b.x?a.uniform4fv(this.addr,b):a.uniform4f(this.addr,b.x,b.y,b.z,b.w)},l=function(a,b){a.uniformMatrix2fv(this.addr,!1,b.elements||b)},n=function(a,b){a.uniformMatrix3fv(this.addr,!1,b.elements||b)},p=function(a,b){a.uniformMatrix4fv(this.addr,!1,b.elements||b)},m=function(a,b,c){var d=c.allocTextureUnit();a.uniform1i(this.addr,
d);b&&c.setTexture2D(b,d)},q=function(a,b,c){var d=c.allocTextureUnit();a.uniform1i(this.addr,d);b&&c.setTextureCube(b,d)},r=function(a,b){a.uniform2iv(this.addr,b)},s=function(a,b){a.uniform3iv(this.addr,b)},u=function(a,b){a.uniform4iv(this.addr,b)},v=function(a){switch(a){case 5126:return e;case 35664:return g;case 35665:return h;case 35666:return k;case 35674:return l;case 35675:return n;case 35676:return p;case 35678:return m;case 35680:return q;case 5124:case 35670:return f;case 35667:case 35671:return r;
case 35668:case 35672:return s;case 35669:case 35673:return u}},x=function(a,b){a.uniform1fv(this.addr,b)},A=function(a,b){a.uniform1iv(this.addr,b)},w=function(a,b){a.uniform2fv(this.addr,c(b,this.size,2))},B=function(a,b){a.uniform3fv(this.addr,c(b,this.size,3))},z=function(a,b){a.uniform4fv(this.addr,c(b,this.size,4))},y=function(a,b){a.uniformMatrix2fv(this.addr,!1,c(b,this.size,4))},C=function(a,b){a.uniformMatrix3fv(this.addr,!1,c(b,this.size,9))},J=function(a,b){a.uniformMatrix4fv(this.addr,
!1,c(b,this.size,16))},D=function(a,b,c){var e=b.length,f=d(c,e);a.uniform1iv(this.addr,f);for(a=0;a!==e;++a){var g=b[a];g&&c.setTexture2D(g,f[a])}},H=function(a,b,c){var e=b.length,f=d(c,e);a.uniform1iv(this.addr,f);for(a=0;a!==e;++a){var g=b[a];g&&c.setTextureCube(g,f[a])}},G=function(a){switch(a){case 5126:return x;case 35664:return w;case 35665:return B;case 35666:return z;case 35674:return y;case 35675:return C;case 35676:return J;case 35678:return D;case 35680:return H;case 5124:case 35670:return A;
case 35667:case 35671:return r;case 35668:case 35672:return s;case 35669:case 35673:return u}},K=function(a,b,c){this.id=a;this.addr=c;this.setValue=v(b.type)},P=function(a,b,c){this.id=a;this.addr=c;this.size=b.size;this.setValue=G(b.type)},I=function(a){this.id=a;this.seq=[];this.map={}};I.prototype.setValue=function(a,b){for(var c=this.seq,d=0,e=c.length;d!==e;++d){var f=c[d];f.setValue(a,b[f.id])}};var L=/([\w\d_]+)(\])?(\[|\.)?/g,E=function(a,b,c){this.seq=[];this.map={};this.renderer=c;c=a.getProgramParameter(b,
a.ACTIVE_UNIFORMS);for(var d=0;d!==c;++d){var e=a.getActiveUniform(b,d),f=a.getUniformLocation(b,e.name),g=this,h=e.name,k=h.length;for(L.lastIndex=0;;){var m=L.exec(h),l=L.lastIndex,n=m[1],q=m[3];"]"===m[2]&&(n|=0);if(void 0===q||"["===q&&l+2===k){h=g;e=void 0===q?new K(n,e,f):new P(n,e,f);h.seq.push(e);h.map[e.id]=e;break}else q=g.map[n],void 0===q&&(q=new I(n),n=g,g=q,n.seq.push(g),n.map[g.id]=g),g=q}}};E.prototype.setValue=function(a,b,c){b=this.map[b];void 0!==b&&b.setValue(a,c,this.renderer)};
E.prototype.set=function(a,b,c){var d=this.map[c];void 0!==d&&d.setValue(a,b[c],this.renderer)};E.prototype.setOptional=function(a,b,c){b=b[c];void 0!==b&&this.setValue(a,c,b)};E.upload=function(a,b,c,d){for(var e=0,f=b.length;e!==f;++e){var g=b[e],h=c[g.id];!1!==h.needsUpdate&&g.setValue(a,h.value,d)}};E.seqWithValue=function(a,b){for(var c=[],d=0,e=a.length;d!==e;++d){var f=a[d];f.id in b&&c.push(f)}return c};E.splitDynamic=function(a,b){for(var c=null,d=a.length,e=0,f=0;f!==d;++f){var g=a[f],h=
b[g.id];h&&!0===h.dynamic?(null===c&&(c=[]),c.push(g)):(e<f&&(a[e]=g),++e)}e<d&&(a.length=e);return c};E.evalDynamic=function(a,b,c,d){for(var e=0,f=a.length;e!==f;++e){var g=b[a[e].id],h=g.onUpdateCallback;void 0!==h&&h.call(g,c,d)}};return E}();
THREE.LensFlarePlugin=function(a,b){var c,d,e,f,g,h,k,l,n,p,m=a.context,q=a.state,r,s,u,v,x,A;this.render=function(w,B,z){if(0!==b.length){w=new THREE.Vector3;var y=z.w/z.z,C=.5*z.z,J=.5*z.w,D=16/z.w,H=new THREE.Vector2(D*y,D),G=new THREE.Vector3(1,1,0),K=new THREE.Vector2(1,1),P=new THREE.Box2;P.min.set(0,0);P.max.set(z.z-16,z.w-16);if(void 0===v){var D=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]),I=new Uint16Array([0,1,2,0,2,3]);r=m.createBuffer();s=m.createBuffer();m.bindBuffer(m.ARRAY_BUFFER,
r);m.bufferData(m.ARRAY_BUFFER,D,m.STATIC_DRAW);m.bindBuffer(m.ELEMENT_ARRAY_BUFFER,s);m.bufferData(m.ELEMENT_ARRAY_BUFFER,I,m.STATIC_DRAW);x=m.createTexture();A=m.createTexture();q.bindTexture(m.TEXTURE_2D,x);m.texImage2D(m.TEXTURE_2D,0,m.RGB,16,16,0,m.RGB,m.UNSIGNED_BYTE,null);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_WRAP_S,m.CLAMP_TO_EDGE);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_WRAP_T,m.CLAMP_TO_EDGE);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_MAG_FILTER,m.NEAREST);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_MIN_FILTER,
m.NEAREST);q.bindTexture(m.TEXTURE_2D,A);m.texImage2D(m.TEXTURE_2D,0,m.RGBA,16,16,0,m.RGBA,m.UNSIGNED_BYTE,null);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_WRAP_S,m.CLAMP_TO_EDGE);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_WRAP_T,m.CLAMP_TO_EDGE);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_MAG_FILTER,m.NEAREST);m.texParameteri(m.TEXTURE_2D,m.TEXTURE_MIN_FILTER,m.NEAREST);var D=u={vertexShader:"uniform lowp int renderType;\nuniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif ( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility =        visibility.r / 9.0;\nvVisibility *= 1.0 - visibility.g / 9.0;\nvVisibility *=       visibility.b / 9.0;\nvVisibility *= 1.0 - visibility.a / 9.0;\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",
fragmentShader:"uniform lowp int renderType;\nuniform sampler2D map;\nuniform float opacity;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif ( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if ( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},I=m.createProgram(),L=m.createShader(m.FRAGMENT_SHADER),
E=m.createShader(m.VERTEX_SHADER),M="precision "+a.getPrecision()+" float;\n";m.shaderSource(L,M+D.fragmentShader);m.shaderSource(E,M+D.vertexShader);m.compileShader(L);m.compileShader(E);m.attachShader(I,L);m.attachShader(I,E);m.linkProgram(I);v=I;n=m.getAttribLocation(v,"position");p=m.getAttribLocation(v,"uv");c=m.getUniformLocation(v,"renderType");d=m.getUniformLocation(v,"map");e=m.getUniformLocation(v,"occlusionMap");f=m.getUniformLocation(v,"opacity");g=m.getUniformLocation(v,"color");h=m.getUniformLocation(v,
"scale");k=m.getUniformLocation(v,"rotation");l=m.getUniformLocation(v,"screenPosition")}m.useProgram(v);q.initAttributes();q.enableAttribute(n);q.enableAttribute(p);q.disableUnusedAttributes();m.uniform1i(e,0);m.uniform1i(d,1);m.bindBuffer(m.ARRAY_BUFFER,r);m.vertexAttribPointer(n,2,m.FLOAT,!1,16,0);m.vertexAttribPointer(p,2,m.FLOAT,!1,16,8);m.bindBuffer(m.ELEMENT_ARRAY_BUFFER,s);q.disable(m.CULL_FACE);q.setDepthWrite(!1);I=0;for(L=b.length;I<L;I++)if(D=16/z.w,H.set(D*y,D),E=b[I],w.set(E.matrixWorld.elements[12],
E.matrixWorld.elements[13],E.matrixWorld.elements[14]),w.applyMatrix4(B.matrixWorldInverse),w.applyProjection(B.projectionMatrix),G.copy(w),K.x=z.x+G.x*C+C-8,K.y=z.y+G.y*J+J-8,!0===P.containsPoint(K)){q.activeTexture(m.TEXTURE0);q.bindTexture(m.TEXTURE_2D,null);q.activeTexture(m.TEXTURE1);q.bindTexture(m.TEXTURE_2D,x);m.copyTexImage2D(m.TEXTURE_2D,0,m.RGB,K.x,K.y,16,16,0);m.uniform1i(c,0);m.uniform2f(h,H.x,H.y);m.uniform3f(l,G.x,G.y,G.z);q.disable(m.BLEND);q.enable(m.DEPTH_TEST);m.drawElements(m.TRIANGLES,
6,m.UNSIGNED_SHORT,0);q.activeTexture(m.TEXTURE0);q.bindTexture(m.TEXTURE_2D,A);m.copyTexImage2D(m.TEXTURE_2D,0,m.RGBA,K.x,K.y,16,16,0);m.uniform1i(c,1);q.disable(m.DEPTH_TEST);q.activeTexture(m.TEXTURE1);q.bindTexture(m.TEXTURE_2D,x);m.drawElements(m.TRIANGLES,6,m.UNSIGNED_SHORT,0);E.positionScreen.copy(G);E.customUpdateCallback?E.customUpdateCallback(E):E.updateLensFlares();m.uniform1i(c,2);q.enable(m.BLEND);for(var M=0,O=E.lensFlares.length;M<O;M++){var Q=E.lensFlares[M];.001<Q.opacity&&.001<Q.scale&&
(G.x=Q.x,G.y=Q.y,G.z=Q.z,D=Q.size*Q.scale/z.w,H.x=D*y,H.y=D,m.uniform3f(l,G.x,G.y,G.z),m.uniform2f(h,H.x,H.y),m.uniform1f(k,Q.rotation),m.uniform1f(f,Q.opacity),m.uniform3f(g,Q.color.r,Q.color.g,Q.color.b),q.setBlending(Q.blending,Q.blendEquation,Q.blendSrc,Q.blendDst),a.setTexture2D(Q.texture,1),m.drawElements(m.TRIANGLES,6,m.UNSIGNED_SHORT,0))}}q.enable(m.CULL_FACE);q.enable(m.DEPTH_TEST);q.setDepthWrite(!0);a.resetGLState()}}};
THREE.SpritePlugin=function(a,b){var c,d,e,f,g,h,k,l,n,p,m,q,r,s,u,v,x;function A(a,b){return a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.z!==b.z?b.z-a.z:b.id-a.id}var w=a.context,B=a.state,z,y,C,J,D=new THREE.Vector3,H=new THREE.Quaternion,G=new THREE.Vector3;this.render=function(K,P){if(0!==b.length){if(void 0===C){var I=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]),L=new Uint16Array([0,1,2,0,2,3]);z=w.createBuffer();y=w.createBuffer();w.bindBuffer(w.ARRAY_BUFFER,
z);w.bufferData(w.ARRAY_BUFFER,I,w.STATIC_DRAW);w.bindBuffer(w.ELEMENT_ARRAY_BUFFER,y);w.bufferData(w.ELEMENT_ARRAY_BUFFER,L,w.STATIC_DRAW);var I=w.createProgram(),L=w.createShader(w.VERTEX_SHADER),E=w.createShader(w.FRAGMENT_SHADER);w.shaderSource(L,["precision "+a.getPrecision()+" float;","uniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position * scale;\nvec2 rotatedPosition;\nrotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\nrotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\nvec4 finalPosition;\nfinalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition;\nfinalPosition = projectionMatrix * finalPosition;\ngl_Position = finalPosition;\n}"].join("\n"));
w.shaderSource(E,["precision "+a.getPrecision()+" float;","uniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nuniform int fogType;\nuniform vec3 fogColor;\nuniform float fogDensity;\nuniform float fogNear;\nuniform float fogFar;\nuniform float alphaTest;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\nif ( texture.a < alphaTest ) discard;\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\nif ( fogType > 0 ) {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat fogFactor = 0.0;\nif ( fogType == 1 ) {\nfogFactor = smoothstep( fogNear, fogFar, depth );\n} else {\nconst float LOG2 = 1.442695;\nfogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n}\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n}\n}"].join("\n"));
w.compileShader(L);w.compileShader(E);w.attachShader(I,L);w.attachShader(I,E);w.linkProgram(I);C=I;v=w.getAttribLocation(C,"position");x=w.getAttribLocation(C,"uv");c=w.getUniformLocation(C,"uvOffset");d=w.getUniformLocation(C,"uvScale");e=w.getUniformLocation(C,"rotation");f=w.getUniformLocation(C,"scale");g=w.getUniformLocation(C,"color");h=w.getUniformLocation(C,"map");k=w.getUniformLocation(C,"opacity");l=w.getUniformLocation(C,"modelViewMatrix");n=w.getUniformLocation(C,"projectionMatrix");p=
w.getUniformLocation(C,"fogType");m=w.getUniformLocation(C,"fogDensity");q=w.getUniformLocation(C,"fogNear");r=w.getUniformLocation(C,"fogFar");s=w.getUniformLocation(C,"fogColor");u=w.getUniformLocation(C,"alphaTest");I=document.createElement("canvas");I.width=8;I.height=8;L=I.getContext("2d");L.fillStyle="white";L.fillRect(0,0,8,8);J=new THREE.Texture(I);J.needsUpdate=!0}w.useProgram(C);B.initAttributes();B.enableAttribute(v);B.enableAttribute(x);B.disableUnusedAttributes();B.disable(w.CULL_FACE);
B.enable(w.BLEND);w.bindBuffer(w.ARRAY_BUFFER,z);w.vertexAttribPointer(v,2,w.FLOAT,!1,16,0);w.vertexAttribPointer(x,2,w.FLOAT,!1,16,8);w.bindBuffer(w.ELEMENT_ARRAY_BUFFER,y);w.uniformMatrix4fv(n,!1,P.projectionMatrix.elements);B.activeTexture(w.TEXTURE0);w.uniform1i(h,0);L=I=0;(E=K.fog)?(w.uniform3f(s,E.color.r,E.color.g,E.color.b),E instanceof THREE.Fog?(w.uniform1f(q,E.near),w.uniform1f(r,E.far),w.uniform1i(p,1),L=I=1):E instanceof THREE.FogExp2&&(w.uniform1f(m,E.density),w.uniform1i(p,2),L=I=2)):
(w.uniform1i(p,0),L=I=0);for(var E=0,M=b.length;E<M;E++){var O=b[E];O.modelViewMatrix.multiplyMatrices(P.matrixWorldInverse,O.matrixWorld);O.z=-O.modelViewMatrix.elements[14]}b.sort(A);for(var Q=[],E=0,M=b.length;E<M;E++){var O=b[E],R=O.material;w.uniform1f(u,R.alphaTest);w.uniformMatrix4fv(l,!1,O.modelViewMatrix.elements);O.matrixWorld.decompose(D,H,G);Q[0]=G.x;Q[1]=G.y;O=0;K.fog&&R.fog&&(O=L);I!==O&&(w.uniform1i(p,O),I=O);null!==R.map?(w.uniform2f(c,R.map.offset.x,R.map.offset.y),w.uniform2f(d,
R.map.repeat.x,R.map.repeat.y)):(w.uniform2f(c,0,0),w.uniform2f(d,1,1));w.uniform1f(k,R.opacity);w.uniform3f(g,R.color.r,R.color.g,R.color.b);w.uniform1f(e,R.rotation);w.uniform2fv(f,Q);B.setBlending(R.blending,R.blendEquation,R.blendSrc,R.blendDst);B.setDepthTest(R.depthTest);B.setDepthWrite(R.depthWrite);R.map?a.setTexture2D(R.map,0):a.setTexture2D(J,0);w.drawElements(w.TRIANGLES,6,w.UNSIGNED_SHORT,0)}B.enable(w.CULL_FACE);a.resetGLState()}}};
Object.defineProperties(THREE.Box2.prototype,{empty:{value:function(){console.warn("THREE.Box2: .empty() has been renamed to .isEmpty().");return this.isEmpty()}},isIntersectionBox:{value:function(a){console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox().");return this.intersectsBox(a)}}});
Object.defineProperties(THREE.Box3.prototype,{empty:{value:function(){console.warn("THREE.Box3: .empty() has been renamed to .isEmpty().");return this.isEmpty()}},isIntersectionBox:{value:function(a){console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox().");return this.intersectsBox(a)}},isIntersectionSphere:{value:function(a){console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere().");return this.intersectsSphere(a)}}});
Object.defineProperties(THREE.Matrix3.prototype,{multiplyVector3:{value:function(a){console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead.");return a.applyMatrix3(this)}},multiplyVector3Array:{value:function(a){console.warn("THREE.Matrix3: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead.");return this.applyToVector3Array(a)}}});
Object.defineProperties(THREE.Matrix4.prototype,{extractPosition:{value:function(a){console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition().");return this.copyPosition(a)}},setRotationFromQuaternion:{value:function(a){console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion().");return this.makeRotationFromQuaternion(a)}},multiplyVector3:{value:function(a){console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) or vector.applyProjection( matrix ) instead.");
return a.applyProjection(this)}},multiplyVector4:{value:function(a){console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead.");return a.applyMatrix4(this)}},multiplyVector3Array:{value:function(a){console.warn("THREE.Matrix4: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead.");return this.applyToVector3Array(a)}},rotateAxis:{value:function(a){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead.");
a.transformDirection(this)}},crossVector:{value:function(a){console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead.");return a.applyMatrix4(this)}},translate:{value:function(a){console.error("THREE.Matrix4: .translate() has been removed.")}},rotateX:{value:function(a){console.error("THREE.Matrix4: .rotateX() has been removed.")}},rotateY:{value:function(a){console.error("THREE.Matrix4: .rotateY() has been removed.")}},rotateZ:{value:function(a){console.error("THREE.Matrix4: .rotateZ() has been removed.")}},
rotateByAxis:{value:function(a,b){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")}}});Object.defineProperties(THREE.Plane.prototype,{isIntersectionLine:{value:function(a){console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine().");return this.intersectsLine(a)}}});
Object.defineProperties(THREE.Quaternion.prototype,{multiplyVector3:{value:function(a){console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead.");return a.applyQuaternion(this)}}});
Object.defineProperties(THREE.Ray.prototype,{isIntersectionBox:{value:function(a){console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox().");return this.intersectsBox(a)}},isIntersectionPlane:{value:function(a){console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane().");return this.intersectsPlane(a)}},isIntersectionSphere:{value:function(a){console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere().");return this.intersectsSphere(a)}}});
Object.defineProperties(THREE.Vector3.prototype,{setEulerFromRotationMatrix:{value:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")}},setEulerFromQuaternion:{value:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")}},getPositionFromMatrix:{value:function(a){console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition().");
return this.setFromMatrixPosition(a)}},getScaleFromMatrix:{value:function(a){console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale().");return this.setFromMatrixScale(a)}},getColumnFromMatrix:{value:function(a,b){console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn().");return this.setFromMatrixColumn(a,b)}}});
THREE.Face4=function(a,b,c,d,e,f,g){console.warn("THREE.Face4 has been removed. A THREE.Face3 will be created instead.");return new THREE.Face3(a,b,c,e,f,g)};THREE.Vertex=function(a,b,c){console.warn("THREE.Vertex has been removed. Use THREE.Vector3 instead.");return new THREE.Vector3(a,b,c)};
Object.defineProperties(THREE.Object3D.prototype,{eulerOrder:{get:function(){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order.");return this.rotation.order},set:function(a){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order.");this.rotation.order=a}},getChildByName:{value:function(a){console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName().");return this.getObjectByName(a)}},renderDepth:{set:function(a){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")}},
translate:{value:function(a,b){console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead.");return this.translateOnAxis(b,a)}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(a){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}});
Object.defineProperties(THREE,{PointCloud:{value:function(a,b){console.warn("THREE.PointCloud has been renamed to THREE.Points.");return new THREE.Points(a,b)}},ParticleSystem:{value:function(a,b){console.warn("THREE.ParticleSystem has been renamed to THREE.Points.");return new THREE.Points(a,b)}}});
Object.defineProperties(THREE.Light.prototype,{onlyShadow:{set:function(a){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(a){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov.");this.shadow.camera.fov=a}},shadowCameraLeft:{set:function(a){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left.");this.shadow.camera.left=a}},shadowCameraRight:{set:function(a){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right.");
this.shadow.camera.right=a}},shadowCameraTop:{set:function(a){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top.");this.shadow.camera.top=a}},shadowCameraBottom:{set:function(a){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom.");this.shadow.camera.bottom=a}},shadowCameraNear:{set:function(a){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near.");this.shadow.camera.near=a}},shadowCameraFar:{set:function(a){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far.");
this.shadow.camera.far=a}},shadowCameraVisible:{set:function(a){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(a){console.warn("THREE.Light: .shadowBias is now .shadow.bias.");this.shadow.bias=a}},shadowDarkness:{set:function(a){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(a){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width.");
this.shadow.mapSize.width=a}},shadowMapHeight:{set:function(a){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height.");this.shadow.mapSize.height=a}}});Object.defineProperties(THREE.BufferAttribute.prototype,{length:{get:function(){console.warn("THREE.BufferAttribute: .length has been deprecated. Please use .count.");return this.array.length}}});
Object.defineProperties(THREE.BufferGeometry.prototype,{drawcalls:{get:function(){console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups.");return this.groups}},offsets:{get:function(){console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups.");return this.groups}},addIndex:{value:function(a){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex().");this.setIndex(a)}},addDrawCall:{value:function(a,b,c){void 0!==c&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset.");
console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup().");this.addGroup(a,b)}},clearDrawCalls:{value:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups().");this.clearGroups()}},computeTangents:{value:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")}},computeOffsets:{value:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")}}});
Object.defineProperties(THREE.Material.prototype,{wrapAround:{get:function(){console.warn("THREE."+this.type+": .wrapAround has been removed.")},set:function(a){console.warn("THREE."+this.type+": .wrapAround has been removed.")}},wrapRGB:{get:function(){console.warn("THREE."+this.type+": .wrapRGB has been removed.");return new THREE.Color}}});
Object.defineProperties(THREE,{PointCloudMaterial:{value:function(a){console.warn("THREE.PointCloudMaterial has been renamed to THREE.PointsMaterial.");return new THREE.PointsMaterial(a)}},ParticleBasicMaterial:{value:function(a){console.warn("THREE.ParticleBasicMaterial has been renamed to THREE.PointsMaterial.");return new THREE.PointsMaterial(a)}},ParticleSystemMaterial:{value:function(a){console.warn("THREE.ParticleSystemMaterial has been renamed to THREE.PointsMaterial.");return new THREE.PointsMaterial(a)}}});
Object.defineProperties(THREE.MeshPhongMaterial.prototype,{metal:{get:function(){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead.");return!1},set:function(a){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}});
Object.defineProperties(THREE.ShaderMaterial.prototype,{derivatives:{get:function(){console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives.");return this.extensions.derivatives},set:function(a){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives.");this.extensions.derivatives=a}}});
Object.defineProperties(THREE.WebGLRenderer.prototype,{supportsFloatTextures:{value:function(){console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' ).");return this.extensions.get("OES_texture_float")}},supportsHalfFloatTextures:{value:function(){console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' ).");return this.extensions.get("OES_texture_half_float")}},supportsStandardDerivatives:{value:function(){console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' ).");
return this.extensions.get("OES_standard_derivatives")}},supportsCompressedTextureS3TC:{value:function(){console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' ).");return this.extensions.get("WEBGL_compressed_texture_s3tc")}},supportsCompressedTexturePVRTC:{value:function(){console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' ).");return this.extensions.get("WEBGL_compressed_texture_pvrtc")}},
supportsBlendMinMax:{value:function(){console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' ).");return this.extensions.get("EXT_blend_minmax")}},supportsVertexTextures:{value:function(){return this.capabilities.vertexTextures}},supportsInstancedArrays:{value:function(){console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' ).");return this.extensions.get("ANGLE_instanced_arrays")}},enableScissorTest:{value:function(a){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest().");
this.setScissorTest(a)}},initMaterial:{value:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")}},addPrePlugin:{value:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")}},addPostPlugin:{value:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")}},updateShadowMap:{value:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")}},shadowMapEnabled:{get:function(){return this.shadowMap.enabled},
set:function(a){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled.");this.shadowMap.enabled=a}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(a){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type.");this.shadowMap.type=a}},shadowMapCullFace:{get:function(){return this.shadowMap.cullFace},set:function(a){console.warn("THREE.WebGLRenderer: .shadowMapCullFace is now .shadowMap.cullFace.");this.shadowMap.cullFace=a}}});
Object.defineProperties(THREE.WebGLRenderTarget.prototype,{wrapS:{get:function(){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS.");return this.texture.wrapS},set:function(a){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS.");this.texture.wrapS=a}},wrapT:{get:function(){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT.");return this.texture.wrapT},set:function(a){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT.");this.texture.wrapT=
a}},magFilter:{get:function(){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter.");return this.texture.magFilter},set:function(a){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter.");this.texture.magFilter=a}},minFilter:{get:function(){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter.");return this.texture.minFilter},set:function(a){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter.");this.texture.minFilter=
a}},anisotropy:{get:function(){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy.");return this.texture.anisotropy},set:function(a){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy.");this.texture.anisotropy=a}},offset:{get:function(){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset.");return this.texture.offset},set:function(a){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset.");this.texture.offset=
a}},repeat:{get:function(){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat.");return this.texture.repeat},set:function(a){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat.");this.texture.repeat=a}},format:{get:function(){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format.");return this.texture.format},set:function(a){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format.");this.texture.format=a}},type:{get:function(){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type.");
return this.texture.type},set:function(a){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type.");this.texture.type=a}},generateMipmaps:{get:function(){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps.");return this.texture.generateMipmaps},set:function(a){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps.");this.texture.generateMipmaps=a}}});
Object.defineProperties(THREE.Audio.prototype,{load:{value:function(a){console.warn("THREE.Audio: .load has been deprecated. Please use THREE.AudioLoader.");var b=this;(new THREE.AudioLoader).load(a,function(a){b.setBuffer(a)});return this}}});
THREE.GeometryUtils={merge:function(a,b,c){console.warn("THREE.GeometryUtils: .merge() has been moved to Geometry. Use geometry.merge( geometry2, matrix, materialIndexOffset ) instead.");var d;b instanceof THREE.Mesh&&(b.matrixAutoUpdate&&b.updateMatrix(),d=b.matrix,b=b.geometry);a.merge(b,d,c)},center:function(a){console.warn("THREE.GeometryUtils: .center() has been moved to Geometry. Use geometry.center() instead.");return a.center()}};
THREE.ImageUtils={crossOrigin:void 0,loadTexture:function(a,b,c,d){console.warn("THREE.ImageUtils.loadTexture has been deprecated. Use THREE.TextureLoader() instead.");var e=new THREE.TextureLoader;e.setCrossOrigin(this.crossOrigin);a=e.load(a,c,void 0,d);b&&(a.mapping=b);return a},loadTextureCube:function(a,b,c,d){console.warn("THREE.ImageUtils.loadTextureCube has been deprecated. Use THREE.CubeTextureLoader() instead.");var e=new THREE.CubeTextureLoader;e.setCrossOrigin(this.crossOrigin);a=e.load(a,
c,void 0,d);b&&(a.mapping=b);return a},loadCompressedTexture:function(){console.error("THREE.ImageUtils.loadCompressedTexture has been removed. Use THREE.DDSLoader instead.")},loadCompressedTextureCube:function(){console.error("THREE.ImageUtils.loadCompressedTextureCube has been removed. Use THREE.DDSLoader instead.")}};
THREE.Projector=function(){console.error("THREE.Projector has been moved to /examples/js/renderers/Projector.js.");this.projectVector=function(a,b){console.warn("THREE.Projector: .projectVector() is now vector.project().");a.project(b)};this.unprojectVector=function(a,b){console.warn("THREE.Projector: .unprojectVector() is now vector.unproject().");a.unproject(b)};this.pickingRay=function(a,b){console.error("THREE.Projector: .pickingRay() is now raycaster.setFromCamera().")}};
THREE.CanvasRenderer=function(){console.error("THREE.CanvasRenderer has been moved to /examples/js/renderers/CanvasRenderer.js");this.domElement=document.createElement("canvas");this.clear=function(){};this.render=function(){};this.setClearColor=function(){};this.setSize=function(){}};THREE.MeshFaceMaterial=THREE.MultiMaterial;Object.defineProperties(THREE.LOD.prototype,{objects:{get:function(){console.warn("THREE.LOD: .objects has been renamed to .levels.");return this.levels}}});
THREE.CurveUtils={tangentQuadraticBezier:function(a,b,c,d){return 2*(1-a)*(c-b)+2*a*(d-c)},tangentCubicBezier:function(a,b,c,d,e){return-3*b*(1-a)*(1-a)+3*c*(1-a)*(1-a)-6*a*c*(1-a)+6*a*d*(1-a)-3*a*a*d+3*a*a*e},tangentSpline:function(a,b,c,d,e){return 6*a*a-6*a+(3*a*a-4*a+1)+(-6*a*a+6*a)+(3*a*a-2*a)},interpolate:function(a,b,c,d,e){a=.5*(c-a);d=.5*(d-b);var f=e*e;return(2*b-2*c+a+d)*e*f+(-3*b+3*c-2*a-d)*f+a*e+b}};
THREE.SceneUtils={createMultiMaterialObject:function(a,b){for(var c=new THREE.Group,d=0,e=b.length;d<e;d++)c.add(new THREE.Mesh(a,b[d]));return c},detach:function(a,b,c){a.applyMatrix(b.matrixWorld);b.remove(a);c.add(a)},attach:function(a,b,c){var d=new THREE.Matrix4;d.getInverse(c.matrixWorld);a.applyMatrix(d);b.remove(a);c.add(a)}};
THREE.ShapeUtils={area:function(a){for(var b=a.length,c=0,d=b-1,e=0;e<b;d=e++)c+=a[d].x*a[e].y-a[e].x*a[d].y;return.5*c},triangulate:function(){return function(a,b){var c=a.length;if(3>c)return null;var d=[],e=[],f=[],g,h,k;if(0<THREE.ShapeUtils.area(a))for(h=0;h<c;h++)e[h]=h;else for(h=0;h<c;h++)e[h]=c-1-h;var l=2*c;for(h=c-1;2<c;){if(0>=l--){console.warn("THREE.ShapeUtils: Unable to triangulate polygon! in triangulate()");break}g=h;c<=g&&(g=0);h=g+1;c<=h&&(h=0);k=h+1;c<=k&&(k=0);var n;a:{var p=
n=void 0,m=void 0,q=void 0,r=void 0,s=void 0,u=void 0,v=void 0,x=void 0,p=a[e[g]].x,m=a[e[g]].y,q=a[e[h]].x,r=a[e[h]].y,s=a[e[k]].x,u=a[e[k]].y;if(Number.EPSILON>(q-p)*(u-m)-(r-m)*(s-p))n=!1;else{var A=void 0,w=void 0,B=void 0,z=void 0,y=void 0,C=void 0,J=void 0,D=void 0,H=void 0,G=void 0,H=D=J=x=v=void 0,A=s-q,w=u-r,B=p-s,z=m-u,y=q-p,C=r-m;for(n=0;n<c;n++)if(v=a[e[n]].x,x=a[e[n]].y,!(v===p&&x===m||v===q&&x===r||v===s&&x===u)&&(J=v-p,D=x-m,H=v-q,G=x-r,v-=s,x-=u,H=A*G-w*H,J=y*D-C*J,D=B*x-z*v,H>=-Number.EPSILON&&
D>=-Number.EPSILON&&J>=-Number.EPSILON)){n=!1;break a}n=!0}}if(n){d.push([a[e[g]],a[e[h]],a[e[k]]]);f.push([e[g],e[h],e[k]]);g=h;for(k=h+1;k<c;g++,k++)e[g]=e[k];c--;l=2*c}}return b?f:d}}(),triangulateShape:function(a,b){function c(a,b,c){return a.x!==b.x?a.x<b.x?a.x<=c.x&&c.x<=b.x:b.x<=c.x&&c.x<=a.x:a.y<b.y?a.y<=c.y&&c.y<=b.y:b.y<=c.y&&c.y<=a.y}function d(a,b,d,e,f){var g=b.x-a.x,h=b.y-a.y,k=e.x-d.x,l=e.y-d.y,n=a.x-d.x,p=a.y-d.y,y=h*k-g*l,C=h*n-g*p;if(Math.abs(y)>Number.EPSILON){if(0<y){if(0>C||C>
y)return[];k=l*n-k*p;if(0>k||k>y)return[]}else{if(0<C||C<y)return[];k=l*n-k*p;if(0<k||k<y)return[]}if(0===k)return!f||0!==C&&C!==y?[a]:[];if(k===y)return!f||0!==C&&C!==y?[b]:[];if(0===C)return[d];if(C===y)return[e];f=k/y;return[{x:a.x+f*g,y:a.y+f*h}]}if(0!==C||l*n!==k*p)return[];h=0===g&&0===h;k=0===k&&0===l;if(h&&k)return a.x!==d.x||a.y!==d.y?[]:[a];if(h)return c(d,e,a)?[a]:[];if(k)return c(a,b,d)?[d]:[];0!==g?(a.x<b.x?(g=a,k=a.x,h=b,a=b.x):(g=b,k=b.x,h=a,a=a.x),d.x<e.x?(b=d,y=d.x,l=e,d=e.x):(b=
e,y=e.x,l=d,d=d.x)):(a.y<b.y?(g=a,k=a.y,h=b,a=b.y):(g=b,k=b.y,h=a,a=a.y),d.y<e.y?(b=d,y=d.y,l=e,d=e.y):(b=e,y=e.y,l=d,d=d.y));return k<=y?a<y?[]:a===y?f?[]:[b]:a<=d?[b,h]:[b,l]:k>d?[]:k===d?f?[]:[g]:a<=d?[g,h]:[g,l]}function e(a,b,c,d){var e=b.x-a.x,f=b.y-a.y;b=c.x-a.x;c=c.y-a.y;var g=d.x-a.x;d=d.y-a.y;a=e*c-f*b;e=e*d-f*g;return Math.abs(a)>Number.EPSILON?(b=g*c-d*b,0<a?0<=e&&0<=b:0<=e||0<=b):0<e}var f,g,h,k,l,n={};h=a.concat();f=0;for(g=b.length;f<g;f++)Array.prototype.push.apply(h,b[f]);f=0;for(g=
h.length;f<g;f++)l=h[f].x+":"+h[f].y,void 0!==n[l]&&console.warn("THREE.Shape: Duplicate point",l),n[l]=f;f=function(a,b){function c(a,b){var d=h.length-1,f=a-1;0>f&&(f=d);var g=a+1;g>d&&(g=0);d=e(h[a],h[f],h[g],k[b]);if(!d)return!1;d=k.length-1;f=b-1;0>f&&(f=d);g=b+1;g>d&&(g=0);return(d=e(k[b],k[f],k[g],h[a]))?!0:!1}function f(a,b){var c,e;for(c=0;c<h.length;c++)if(e=c+1,e%=h.length,e=d(a,b,h[c],h[e],!0),0<e.length)return!0;return!1}function g(a,c){var e,f,h,k;for(e=0;e<l.length;e++)for(f=b[l[e]],
h=0;h<f.length;h++)if(k=h+1,k%=f.length,k=d(a,c,f[h],f[k],!0),0<k.length)return!0;return!1}var h=a.concat(),k,l=[],n,p,z,y,C,J=[],D,H,G,K=0;for(n=b.length;K<n;K++)l.push(K);D=0;for(var P=2*l.length;0<l.length;){P--;if(0>P){console.log("Infinite Loop! Holes left:"+l.length+", Probably Hole outside Shape!");break}for(p=D;p<h.length;p++){z=h[p];n=-1;for(K=0;K<l.length;K++)if(y=l[K],C=z.x+":"+z.y+":"+y,void 0===J[C]){k=b[y];for(H=0;H<k.length;H++)if(y=k[H],c(p,H)&&!f(z,y)&&!g(z,y)){n=H;l.splice(K,1);
D=h.slice(0,p+1);y=h.slice(p);H=k.slice(n);G=k.slice(0,n+1);h=D.concat(H).concat(G).concat(y);D=p;break}if(0<=n)break;J[C]=!0}if(0<=n)break}}return h}(a,b);var p=THREE.ShapeUtils.triangulate(f,!1);f=0;for(g=p.length;f<g;f++)for(k=p[f],h=0;3>h;h++)l=k[h].x+":"+k[h].y,l=n[l],void 0!==l&&(k[h]=l);return p.concat()},isClockWise:function(a){return 0>THREE.ShapeUtils.area(a)},b2:function(){return function(a,b,c,d){var e=1-a;return e*e*b+2*(1-a)*a*c+a*a*d}}(),b3:function(){return function(a,b,c,d,e){var f=
1-a,g=1-a;return f*f*f*b+3*g*g*a*c+3*(1-a)*a*a*d+a*a*a*e}}()};THREE.Curve=function(){};
THREE.Curve.prototype={constructor:THREE.Curve,getPoint:function(a){console.warn("THREE.Curve: Warning, getPoint() not implemented!");return null},getPointAt:function(a){a=this.getUtoTmapping(a);return this.getPoint(a)},getPoints:function(a){a||(a=5);var b,c=[];for(b=0;b<=a;b++)c.push(this.getPoint(b/a));return c},getSpacedPoints:function(a){a||(a=5);var b,c=[];for(b=0;b<=a;b++)c.push(this.getPointAt(b/a));return c},getLength:function(){var a=this.getLengths();return a[a.length-1]},getLengths:function(a){a||
(a=this.__arcLengthDivisions?this.__arcLengthDivisions:200);if(this.cacheArcLengths&&this.cacheArcLengths.length===a+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var b=[],c,d=this.getPoint(0),e,f=0;b.push(0);for(e=1;e<=a;e++)c=this.getPoint(e/a),f+=c.distanceTo(d),b.push(f),d=c;return this.cacheArcLengths=b},updateArcLengths:function(){this.needsUpdate=!0;this.getLengths()},getUtoTmapping:function(a,b){var c=this.getLengths(),d=0,e=c.length,f;f=b?b:a*c[e-1];for(var g=0,h=e-
1,k;g<=h;)if(d=Math.floor(g+(h-g)/2),k=c[d]-f,0>k)g=d+1;else if(0<k)h=d-1;else{h=d;break}d=h;if(c[d]===f)return d/(e-1);g=c[d];return c=(d+(f-g)/(c[d+1]-g))/(e-1)},getTangent:function(a){var b=a-1E-4;a+=1E-4;0>b&&(b=0);1<a&&(a=1);b=this.getPoint(b);return this.getPoint(a).clone().sub(b).normalize()},getTangentAt:function(a){a=this.getUtoTmapping(a);return this.getTangent(a)}};
THREE.Curve.create=function(a,b){a.prototype=Object.create(THREE.Curve.prototype);a.prototype.constructor=a;a.prototype.getPoint=b;return a};THREE.CurvePath=function(){this.curves=[];this.autoClose=!1};THREE.CurvePath.prototype=Object.create(THREE.Curve.prototype);THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(a){this.curves.push(a)};
THREE.CurvePath.prototype.closePath=function(){var a=this.curves[0].getPoint(0),b=this.curves[this.curves.length-1].getPoint(1);a.equals(b)||this.curves.push(new THREE.LineCurve(b,a))};THREE.CurvePath.prototype.getPoint=function(a){for(var b=a*this.getLength(),c=this.getCurveLengths(),d=0;d<c.length;){if(c[d]>=b)return a=this.curves[d],b=1-(c[d]-b)/a.getLength(),a.getPointAt(b);d++}return null};THREE.CurvePath.prototype.getLength=function(){var a=this.getCurveLengths();return a[a.length-1]};
THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var a=[],b=0,c=0,d=this.curves.length;c<d;c++)b+=this.curves[c].getLength(),a.push(b);return this.cacheLengths=a};THREE.CurvePath.prototype.createPointsGeometry=function(a){a=this.getPoints(a);return this.createGeometry(a)};THREE.CurvePath.prototype.createSpacedPointsGeometry=function(a){a=this.getSpacedPoints(a);return this.createGeometry(a)};
THREE.CurvePath.prototype.createGeometry=function(a){for(var b=new THREE.Geometry,c=0,d=a.length;c<d;c++){var e=a[c];b.vertices.push(new THREE.Vector3(e.x,e.y,e.z||0))}return b};THREE.Font=function(a){this.data=a};
THREE.Font.prototype={constructor:THREE.Font,generateShapes:function(a,b,c){void 0===b&&(b=100);void 0===c&&(c=4);var d=this.data;a=String(a).split("");var e=b/d.resolution,f=0;b=[];for(var g=0;g<a.length;g++){var h;h=e;var k=f,l=d.glyphs[a[g]]||d.glyphs["?"];if(l){var n=new THREE.Path,p=[],m=THREE.ShapeUtils.b2,q=THREE.ShapeUtils.b3,r=void 0,s=void 0,u=s=r=void 0,v=void 0,x=void 0,A=void 0,w=void 0,B=void 0,v=void 0;if(l.o)for(var z=l._cachedOutline||(l._cachedOutline=l.o.split(" ")),y=0,C=z.length;y<
C;)switch(z[y++]){case "m":r=z[y++]*h+k;s=z[y++]*h;n.moveTo(r,s);break;case "l":r=z[y++]*h+k;s=z[y++]*h;n.lineTo(r,s);break;case "q":r=z[y++]*h+k;s=z[y++]*h;x=z[y++]*h+k;A=z[y++]*h;n.quadraticCurveTo(x,A,r,s);if(v=p[p.length-1])for(var u=v.x,v=v.y,J=1;J<=c;J++){var D=J/c;m(D,u,x,r);m(D,v,A,s)}break;case "b":if(r=z[y++]*h+k,s=z[y++]*h,x=z[y++]*h+k,A=z[y++]*h,w=z[y++]*h+k,B=z[y++]*h,n.bezierCurveTo(x,A,w,B,r,s),v=p[p.length-1])for(u=v.x,v=v.y,J=1;J<=c;J++)D=J/c,q(D,u,x,w,r),q(D,v,A,B,s)}h={offset:l.ha*
h,path:n}}else h=void 0;f+=h.offset;b.push(h.path)}c=[];d=0;for(a=b.length;d<a;d++)Array.prototype.push.apply(c,b[d].toShapes());return c}};THREE.Path=function(a){THREE.CurvePath.call(this);this.actions=[];a&&this.fromPoints(a)};THREE.Path.prototype=Object.create(THREE.CurvePath.prototype);THREE.Path.prototype.constructor=THREE.Path;THREE.Path.prototype.fromPoints=function(a){this.moveTo(a[0].x,a[0].y);for(var b=1,c=a.length;b<c;b++)this.lineTo(a[b].x,a[b].y)};
THREE.Path.prototype.moveTo=function(a,b){this.actions.push({action:"moveTo",args:[a,b]})};THREE.Path.prototype.lineTo=function(a,b){var c=this.actions[this.actions.length-1].args,c=new THREE.LineCurve(new THREE.Vector2(c[c.length-2],c[c.length-1]),new THREE.Vector2(a,b));this.curves.push(c);this.actions.push({action:"lineTo",args:[a,b]})};
THREE.Path.prototype.quadraticCurveTo=function(a,b,c,d){var e=this.actions[this.actions.length-1].args,e=new THREE.QuadraticBezierCurve(new THREE.Vector2(e[e.length-2],e[e.length-1]),new THREE.Vector2(a,b),new THREE.Vector2(c,d));this.curves.push(e);this.actions.push({action:"quadraticCurveTo",args:[a,b,c,d]})};
THREE.Path.prototype.bezierCurveTo=function(a,b,c,d,e,f){var g=this.actions[this.actions.length-1].args,g=new THREE.CubicBezierCurve(new THREE.Vector2(g[g.length-2],g[g.length-1]),new THREE.Vector2(a,b),new THREE.Vector2(c,d),new THREE.Vector2(e,f));this.curves.push(g);this.actions.push({action:"bezierCurveTo",args:[a,b,c,d,e,f]})};
THREE.Path.prototype.splineThru=function(a){var b=Array.prototype.slice.call(arguments),c=this.actions[this.actions.length-1].args,c=[new THREE.Vector2(c[c.length-2],c[c.length-1])];Array.prototype.push.apply(c,a);c=new THREE.SplineCurve(c);this.curves.push(c);this.actions.push({action:"splineThru",args:b})};THREE.Path.prototype.arc=function(a,b,c,d,e,f){var g=this.actions[this.actions.length-1].args;this.absarc(a+g[g.length-2],b+g[g.length-1],c,d,e,f)};
THREE.Path.prototype.absarc=function(a,b,c,d,e,f){this.absellipse(a,b,c,c,d,e,f)};THREE.Path.prototype.ellipse=function(a,b,c,d,e,f,g,h){var k=this.actions[this.actions.length-1].args;this.absellipse(a+k[k.length-2],b+k[k.length-1],c,d,e,f,g,h)};THREE.Path.prototype.absellipse=function(a,b,c,d,e,f,g,h){var k=[a,b,c,d,e,f,g,h||0];a=new THREE.EllipseCurve(a,b,c,d,e,f,g,h);this.curves.push(a);a=a.getPoint(1);k.push(a.x);k.push(a.y);this.actions.push({action:"ellipse",args:k})};
THREE.Path.prototype.getSpacedPoints=function(a){a||(a=40);for(var b=[],c=0;c<a;c++)b.push(this.getPoint(c/a));this.autoClose&&b.push(b[0]);return b};
THREE.Path.prototype.getPoints=function(a){a=a||12;for(var b=THREE.ShapeUtils.b2,c=THREE.ShapeUtils.b3,d=[],e,f,g,h,k,l,n,p,m,q,r=0,s=this.actions.length;r<s;r++){m=this.actions[r];var u=m.args;switch(m.action){case "moveTo":d.push(new THREE.Vector2(u[0],u[1]));break;case "lineTo":d.push(new THREE.Vector2(u[0],u[1]));break;case "quadraticCurveTo":e=u[2];f=u[3];k=u[0];l=u[1];0<d.length?(m=d[d.length-1],n=m.x,p=m.y):(m=this.actions[r-1].args,n=m[m.length-2],p=m[m.length-1]);for(u=1;u<=a;u++)q=u/a,m=
b(q,n,k,e),q=b(q,p,l,f),d.push(new THREE.Vector2(m,q));break;case "bezierCurveTo":e=u[4];f=u[5];k=u[0];l=u[1];g=u[2];h=u[3];0<d.length?(m=d[d.length-1],n=m.x,p=m.y):(m=this.actions[r-1].args,n=m[m.length-2],p=m[m.length-1]);for(u=1;u<=a;u++)q=u/a,m=c(q,n,k,g,e),q=c(q,p,l,h,f),d.push(new THREE.Vector2(m,q));break;case "splineThru":m=this.actions[r-1].args;q=[new THREE.Vector2(m[m.length-2],m[m.length-1])];m=a*u[0].length;q=q.concat(u[0]);q=new THREE.SplineCurve(q);for(u=1;u<=m;u++)d.push(q.getPointAt(u/
m));break;case "arc":e=u[0];f=u[1];l=u[2];g=u[3];m=u[4];k=!!u[5];n=m-g;p=2*a;for(u=1;u<=p;u++)q=u/p,k||(q=1-q),q=g+q*n,m=e+l*Math.cos(q),q=f+l*Math.sin(q),d.push(new THREE.Vector2(m,q));break;case "ellipse":e=u[0];f=u[1];l=u[2];h=u[3];g=u[4];m=u[5];k=!!u[6];var v=u[7];n=m-g;p=2*a;var x,A;0!==v&&(x=Math.cos(v),A=Math.sin(v));for(u=1;u<=p;u++){q=u/p;k||(q=1-q);q=g+q*n;m=e+l*Math.cos(q);q=f+h*Math.sin(q);if(0!==v){var w=m;m=(w-e)*x-(q-f)*A+e;q=(w-e)*A+(q-f)*x+f}d.push(new THREE.Vector2(m,q))}}}a=d[d.length-
1];Math.abs(a.x-d[0].x)<Number.EPSILON&&Math.abs(a.y-d[0].y)<Number.EPSILON&&d.splice(d.length-1,1);this.autoClose&&d.push(d[0]);return d};
THREE.Path.prototype.toShapes=function(a,b){function c(a){for(var b=[],c=0,d=a.length;c<d;c++){var e=a[c],f=new THREE.Shape;f.actions=e.actions;f.curves=e.curves;b.push(f)}return b}function d(a,b){for(var c=b.length,d=!1,e=c-1,f=0;f<c;e=f++){var g=b[e],h=b[f],k=h.x-g.x,l=h.y-g.y;if(Math.abs(l)>Number.EPSILON){if(0>l&&(g=b[f],k=-k,h=b[e],l=-l),!(a.y<g.y||a.y>h.y))if(a.y===g.y){if(a.x===g.x)return!0}else{e=l*(a.x-g.x)-k*(a.y-g.y);if(0===e)return!0;0>e||(d=!d)}}else if(a.y===g.y&&(h.x<=a.x&&a.x<=g.x||
g.x<=a.x&&a.x<=h.x))return!0}return d}var e=THREE.ShapeUtils.isClockWise,f=function(a){for(var b=[],c=new THREE.Path,d=0,e=a.length;d<e;d++){var f=a[d],g=f.args,f=f.action;"moveTo"===f&&0!==c.actions.length&&(b.push(c),c=new THREE.Path);c[f].apply(c,g)}0!==c.actions.length&&b.push(c);return b}(this.actions);if(0===f.length)return[];if(!0===b)return c(f);var g,h,k,l=[];if(1===f.length)return h=f[0],k=new THREE.Shape,k.actions=h.actions,k.curves=h.curves,l.push(k),l;var n=!e(f[0].getPoints()),n=a?!n:
n;k=[];var p=[],m=[],q=0,r;p[q]=void 0;m[q]=[];for(var s=0,u=f.length;s<u;s++)h=f[s],r=h.getPoints(),g=e(r),(g=a?!g:g)?(!n&&p[q]&&q++,p[q]={s:new THREE.Shape,p:r},p[q].s.actions=h.actions,p[q].s.curves=h.curves,n&&q++,m[q]=[]):m[q].push({h:h,p:r[0]});if(!p[0])return c(f);if(1<p.length){s=!1;h=[];e=0;for(f=p.length;e<f;e++)k[e]=[];e=0;for(f=p.length;e<f;e++)for(g=m[e],n=0;n<g.length;n++){q=g[n];r=!0;for(u=0;u<p.length;u++)d(q.p,p[u].p)&&(e!==u&&h.push({froms:e,tos:u,hole:n}),r?(r=!1,k[u].push(q)):
s=!0);r&&k[e].push(q)}0<h.length&&(s||(m=k))}s=0;for(e=p.length;s<e;s++)for(k=p[s].s,l.push(k),h=m[s],f=0,g=h.length;f<g;f++)k.holes.push(h[f].h);return l};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=Object.create(THREE.Path.prototype);THREE.Shape.prototype.constructor=THREE.Shape;THREE.Shape.prototype.extrude=function(a){return new THREE.ExtrudeGeometry(this,a)};THREE.Shape.prototype.makeGeometry=function(a){return new THREE.ShapeGeometry(this,a)};
THREE.Shape.prototype.getPointsHoles=function(a){for(var b=[],c=0,d=this.holes.length;c<d;c++)b[c]=this.holes[c].getPoints(a);return b};THREE.Shape.prototype.extractAllPoints=function(a){return{shape:this.getPoints(a),holes:this.getPointsHoles(a)}};THREE.Shape.prototype.extractPoints=function(a){return this.extractAllPoints(a)};THREE.LineCurve=function(a,b){this.v1=a;this.v2=b};THREE.LineCurve.prototype=Object.create(THREE.Curve.prototype);THREE.LineCurve.prototype.constructor=THREE.LineCurve;
THREE.LineCurve.prototype.getPoint=function(a){var b=this.v2.clone().sub(this.v1);b.multiplyScalar(a).add(this.v1);return b};THREE.LineCurve.prototype.getPointAt=function(a){return this.getPoint(a)};THREE.LineCurve.prototype.getTangent=function(a){return this.v2.clone().sub(this.v1).normalize()};THREE.QuadraticBezierCurve=function(a,b,c){this.v0=a;this.v1=b;this.v2=c};THREE.QuadraticBezierCurve.prototype=Object.create(THREE.Curve.prototype);THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;
THREE.QuadraticBezierCurve.prototype.getPoint=function(a){var b=THREE.ShapeUtils.b2;return new THREE.Vector2(b(a,this.v0.x,this.v1.x,this.v2.x),b(a,this.v0.y,this.v1.y,this.v2.y))};THREE.QuadraticBezierCurve.prototype.getTangent=function(a){var b=THREE.CurveUtils.tangentQuadraticBezier;return(new THREE.Vector2(b(a,this.v0.x,this.v1.x,this.v2.x),b(a,this.v0.y,this.v1.y,this.v2.y))).normalize()};THREE.CubicBezierCurve=function(a,b,c,d){this.v0=a;this.v1=b;this.v2=c;this.v3=d};
THREE.CubicBezierCurve.prototype=Object.create(THREE.Curve.prototype);THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;THREE.CubicBezierCurve.prototype.getPoint=function(a){var b=THREE.ShapeUtils.b3;return new THREE.Vector2(b(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x),b(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y))};
THREE.CubicBezierCurve.prototype.getTangent=function(a){var b=THREE.CurveUtils.tangentCubicBezier;return(new THREE.Vector2(b(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x),b(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y))).normalize()};THREE.SplineCurve=function(a){this.points=void 0==a?[]:a};THREE.SplineCurve.prototype=Object.create(THREE.Curve.prototype);THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;
THREE.SplineCurve.prototype.getPoint=function(a){var b=this.points;a*=b.length-1;var c=Math.floor(a);a-=c;var d=b[0===c?c:c-1],e=b[c],f=b[c>b.length-2?b.length-1:c+1],b=b[c>b.length-3?b.length-1:c+2],c=THREE.CurveUtils.interpolate;return new THREE.Vector2(c(d.x,e.x,f.x,b.x,a),c(d.y,e.y,f.y,b.y,a))};THREE.EllipseCurve=function(a,b,c,d,e,f,g,h){this.aX=a;this.aY=b;this.xRadius=c;this.yRadius=d;this.aStartAngle=e;this.aEndAngle=f;this.aClockwise=g;this.aRotation=h||0};THREE.EllipseCurve.prototype=Object.create(THREE.Curve.prototype);
THREE.EllipseCurve.prototype.constructor=THREE.EllipseCurve;
THREE.EllipseCurve.prototype.getPoint=function(a){var b=this.aEndAngle-this.aStartAngle;0>b&&(b+=2*Math.PI);b>2*Math.PI&&(b-=2*Math.PI);b=!0===this.aClockwise?this.aEndAngle+(1-a)*(2*Math.PI-b):this.aStartAngle+a*b;a=this.aX+this.xRadius*Math.cos(b);var c=this.aY+this.yRadius*Math.sin(b);if(0!==this.aRotation){var b=Math.cos(this.aRotation),d=Math.sin(this.aRotation),e=a;a=(e-this.aX)*b-(c-this.aY)*d+this.aX;c=(e-this.aX)*d+(c-this.aY)*b+this.aY}return new THREE.Vector2(a,c)};
THREE.ArcCurve=function(a,b,c,d,e,f){THREE.EllipseCurve.call(this,a,b,c,c,d,e,f)};THREE.ArcCurve.prototype=Object.create(THREE.EllipseCurve.prototype);THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.LineCurve3=THREE.Curve.create(function(a,b){this.v1=a;this.v2=b},function(a){var b=new THREE.Vector3;b.subVectors(this.v2,this.v1);b.multiplyScalar(a);b.add(this.v1);return b});
THREE.QuadraticBezierCurve3=THREE.Curve.create(function(a,b,c){this.v0=a;this.v1=b;this.v2=c},function(a){var b=THREE.ShapeUtils.b2;return new THREE.Vector3(b(a,this.v0.x,this.v1.x,this.v2.x),b(a,this.v0.y,this.v1.y,this.v2.y),b(a,this.v0.z,this.v1.z,this.v2.z))});
THREE.CubicBezierCurve3=THREE.Curve.create(function(a,b,c,d){this.v0=a;this.v1=b;this.v2=c;this.v3=d},function(a){var b=THREE.ShapeUtils.b3;return new THREE.Vector3(b(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x),b(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y),b(a,this.v0.z,this.v1.z,this.v2.z,this.v3.z))});
THREE.SplineCurve3=THREE.Curve.create(function(a){console.warn("THREE.SplineCurve3 will be deprecated. Please use THREE.CatmullRomCurve3");this.points=void 0==a?[]:a},function(a){var b=this.points;a*=b.length-1;var c=Math.floor(a);a-=c;var d=b[0==c?c:c-1],e=b[c],f=b[c>b.length-2?b.length-1:c+1],b=b[c>b.length-3?b.length-1:c+2],c=THREE.CurveUtils.interpolate;return new THREE.Vector3(c(d.x,e.x,f.x,b.x,a),c(d.y,e.y,f.y,b.y,a),c(d.z,e.z,f.z,b.z,a))});
THREE.CatmullRomCurve3=function(){function a(){}var b=new THREE.Vector3,c=new a,d=new a,e=new a;a.prototype.init=function(a,b,c,d){this.c0=a;this.c1=c;this.c2=-3*a+3*b-2*c-d;this.c3=2*a-2*b+c+d};a.prototype.initNonuniformCatmullRom=function(a,b,c,d,e,n,p){a=((b-a)/e-(c-a)/(e+n)+(c-b)/n)*n;d=((c-b)/n-(d-b)/(n+p)+(d-c)/p)*n;this.init(b,c,a,d)};a.prototype.initCatmullRom=function(a,b,c,d,e){this.init(b,c,e*(c-a),e*(d-b))};a.prototype.calc=function(a){var b=a*a;return this.c0+this.c1*a+this.c2*b+this.c3*
b*a};return THREE.Curve.create(function(a){this.points=a||[];this.closed=!1},function(a){var g=this.points,h,k;k=g.length;2>k&&console.log("duh, you need at least 2 points");a*=k-(this.closed?0:1);h=Math.floor(a);a-=h;this.closed?h+=0<h?0:(Math.floor(Math.abs(h)/g.length)+1)*g.length:0===a&&h===k-1&&(h=k-2,a=1);var l,n,p;this.closed||0<h?l=g[(h-1)%k]:(b.subVectors(g[0],g[1]).add(g[0]),l=b);n=g[h%k];p=g[(h+1)%k];this.closed||h+2<k?g=g[(h+2)%k]:(b.subVectors(g[k-1],g[k-2]).add(g[k-1]),g=b);if(void 0===
this.type||"centripetal"===this.type||"chordal"===this.type){var m="chordal"===this.type?.5:.25;k=Math.pow(l.distanceToSquared(n),m);h=Math.pow(n.distanceToSquared(p),m);m=Math.pow(p.distanceToSquared(g),m);1E-4>h&&(h=1);1E-4>k&&(k=h);1E-4>m&&(m=h);c.initNonuniformCatmullRom(l.x,n.x,p.x,g.x,k,h,m);d.initNonuniformCatmullRom(l.y,n.y,p.y,g.y,k,h,m);e.initNonuniformCatmullRom(l.z,n.z,p.z,g.z,k,h,m)}else"catmullrom"===this.type&&(k=void 0!==this.tension?this.tension:.5,c.initCatmullRom(l.x,n.x,p.x,g.x,
k),d.initCatmullRom(l.y,n.y,p.y,g.y,k),e.initCatmullRom(l.z,n.z,p.z,g.z,k));return new THREE.Vector3(c.calc(a),d.calc(a),e.calc(a))})}();THREE.ClosedSplineCurve3=function(a){console.warn("THREE.ClosedSplineCurve3 has been deprecated. Please use THREE.CatmullRomCurve3.");THREE.CatmullRomCurve3.call(this,a);this.type="catmullrom";this.closed=!0};THREE.ClosedSplineCurve3.prototype=Object.create(THREE.CatmullRomCurve3.prototype);
THREE.BoxGeometry=function(a,b,c,d,e,f){THREE.Geometry.call(this);this.type="BoxGeometry";this.parameters={width:a,height:b,depth:c,widthSegments:d,heightSegments:e,depthSegments:f};this.fromBufferGeometry(new THREE.BoxBufferGeometry(a,b,c,d,e,f));this.mergeVertices()};THREE.BoxGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.BoxGeometry.prototype.constructor=THREE.BoxGeometry;THREE.CubeGeometry=THREE.BoxGeometry;
THREE.BoxBufferGeometry=function(a,b,c,d,e,f){function g(a,b,c,d,e,f,g,k,l,G,K){var P=f/l,I=g/G,L=f/2,E=g/2,M=k/2;g=l+1;for(var O=G+1,Q=f=0,R=new THREE.Vector3,F=0;F<O;F++)for(var Z=F*I-E,T=0;T<g;T++)R[a]=(T*P-L)*d,R[b]=Z*e,R[c]=M,p[r]=R.x,p[r+1]=R.y,p[r+2]=R.z,R[a]=0,R[b]=0,R[c]=0<k?1:-1,m[r]=R.x,m[r+1]=R.y,m[r+2]=R.z,q[s]=T/l,q[s+1]=1-F/G,r+=3,s+=2,f+=1;for(F=0;F<G;F++)for(T=0;T<l;T++)a=v+T+g*(F+1),b=v+(T+1)+g*(F+1),c=v+(T+1)+g*F,n[u]=v+T+g*F,n[u+1]=a,n[u+2]=c,n[u+3]=a,n[u+4]=b,n[u+5]=c,u+=6,Q+=
6;h.addGroup(x,Q,K);x+=Q;v+=f}THREE.BufferGeometry.call(this);this.type="BoxBufferGeometry";this.parameters={width:a,height:b,depth:c,widthSegments:d,heightSegments:e,depthSegments:f};var h=this;d=Math.floor(d)||1;e=Math.floor(e)||1;f=Math.floor(f)||1;var k=function(a,b,c){a=0+a*b*2+a*c*2;a+=c*b*2;return 4*a}(d,e,f),l=k/4*6,n=new (65535<l?Uint32Array:Uint16Array)(l),p=new Float32Array(3*k),m=new Float32Array(3*k),q=new Float32Array(2*k),r=0,s=0,u=0,v=0,x=0;g("z","y","x",-1,-1,c,b,a,f,e,0);g("z","y",
"x",1,-1,c,b,-a,f,e,1);g("x","z","y",1,1,a,c,b,d,f,2);g("x","z","y",1,-1,a,c,-b,d,f,3);g("x","y","z",1,-1,a,b,c,d,e,4);g("x","y","z",-1,-1,a,b,-c,d,e,5);this.setIndex(new THREE.BufferAttribute(n,1));this.addAttribute("position",new THREE.BufferAttribute(p,3));this.addAttribute("normal",new THREE.BufferAttribute(m,3));this.addAttribute("uv",new THREE.BufferAttribute(q,2))};THREE.BoxBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);
THREE.BoxBufferGeometry.prototype.constructor=THREE.BoxBufferGeometry;THREE.CircleGeometry=function(a,b,c,d){THREE.Geometry.call(this);this.type="CircleGeometry";this.parameters={radius:a,segments:b,thetaStart:c,thetaLength:d};this.fromBufferGeometry(new THREE.CircleBufferGeometry(a,b,c,d))};THREE.CircleGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.CircleGeometry.prototype.constructor=THREE.CircleGeometry;
THREE.CircleBufferGeometry=function(a,b,c,d){THREE.BufferGeometry.call(this);this.type="CircleBufferGeometry";this.parameters={radius:a,segments:b,thetaStart:c,thetaLength:d};a=a||50;b=void 0!==b?Math.max(3,b):8;c=void 0!==c?c:0;d=void 0!==d?d:2*Math.PI;var e=b+2,f=new Float32Array(3*e),g=new Float32Array(3*e),e=new Float32Array(2*e);g[2]=1;e[0]=.5;e[1]=.5;for(var h=0,k=3,l=2;h<=b;h++,k+=3,l+=2){var n=c+h/b*d;f[k]=a*Math.cos(n);f[k+1]=a*Math.sin(n);g[k+2]=1;e[l]=(f[k]/a+1)/2;e[l+1]=(f[k+1]/a+1)/2}c=
[];for(k=1;k<=b;k++)c.push(k,k+1,0);this.setIndex(new THREE.BufferAttribute(new Uint16Array(c),1));this.addAttribute("position",new THREE.BufferAttribute(f,3));this.addAttribute("normal",new THREE.BufferAttribute(g,3));this.addAttribute("uv",new THREE.BufferAttribute(e,2));this.boundingSphere=new THREE.Sphere(new THREE.Vector3,a)};THREE.CircleBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.CircleBufferGeometry.prototype.constructor=THREE.CircleBufferGeometry;
THREE.CylinderBufferGeometry=function(a,b,c,d,e,f,g,h){function k(c){var e,f,k;k=new THREE.Vector2;var n=new THREE.Vector3,p=0,x=!0===c?a:b,G=!0===c?1:-1;f=u;for(e=1;e<=d;e++)q.setXYZ(u,0,A*G,0),r.setXYZ(u,0,G,0),!0===c?(k.x=e/d,k.y=0):(k.x=(e-1)/d,k.y=1),s.setXY(u,k.x,k.y),u++;k=u;for(e=0;e<=d;e++){var K=e/d;n.x=x*Math.sin(K*h+g);n.y=A*G;n.z=x*Math.cos(K*h+g);q.setXYZ(u,n.x,n.y,n.z);r.setXYZ(u,0,G,0);s.setXY(u,K,!0===c?1:0);u++}for(e=0;e<d;e++)n=f+e,x=k+e,!0===c?(m.setX(v,x),v++,m.setX(v,x+1)):(m.setX(v,
x+1),v++,m.setX(v,x)),v++,m.setX(v,n),v++,p+=3;l.addGroup(w,p,!0===c?1:2);w+=p}THREE.BufferGeometry.call(this);this.type="CylinderBufferGeometry";this.parameters={radiusTop:a,radiusBottom:b,height:c,radialSegments:d,heightSegments:e,openEnded:f,thetaStart:g,thetaLength:h};var l=this;a=void 0!==a?a:20;b=void 0!==b?b:20;c=void 0!==c?c:100;d=Math.floor(d)||8;e=Math.floor(e)||1;f=void 0!==f?f:!1;g=void 0!==g?g:0;h=void 0!==h?h:2*Math.PI;var n=function(){var a=(d+1)*(e+1);!1===f&&(a+=2*(d+1)+2*d);return a}(),
p=function(){var a=d*e*6;!1===f&&(a+=6*d);return a}(),m=new THREE.BufferAttribute(new (65535<p?Uint32Array:Uint16Array)(p),1),q=new THREE.BufferAttribute(new Float32Array(3*n),3),r=new THREE.BufferAttribute(new Float32Array(3*n),3),s=new THREE.BufferAttribute(new Float32Array(2*n),2),u=0,v=0,x=[],A=c/2,w=0;(function(){var f,k,n=new THREE.Vector3,p=new THREE.Vector3,J=0,D=(b-a)/c;for(k=0;k<=e;k++){var H=[],G=k/e,K=G*(b-a)+a;for(f=0;f<=d;f++){var P=f/d;p.x=K*Math.sin(P*h+g);p.y=-G*c+A;p.z=K*Math.cos(P*
h+g);q.setXYZ(u,p.x,p.y,p.z);n.copy(p);if(0===a&&0===k||0===b&&k===e)n.x=Math.sin(P*h+g),n.z=Math.cos(P*h+g);n.setY(Math.sqrt(n.x*n.x+n.z*n.z)*D).normalize();r.setXYZ(u,n.x,n.y,n.z);s.setXY(u,P,1-G);H.push(u);u++}x.push(H)}for(f=0;f<d;f++)for(k=0;k<e;k++)n=x[k+1][f],p=x[k+1][f+1],D=x[k][f+1],m.setX(v,x[k][f]),v++,m.setX(v,n),v++,m.setX(v,D),v++,m.setX(v,n),v++,m.setX(v,p),v++,m.setX(v,D),v++,J+=6;l.addGroup(w,J,0);w+=J})();!1===f&&(0<a&&k(!0),0<b&&k(!1));this.setIndex(m);this.addAttribute("position",
q);this.addAttribute("normal",r);this.addAttribute("uv",s)};THREE.CylinderBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.CylinderBufferGeometry.prototype.constructor=THREE.CylinderBufferGeometry;
THREE.CylinderGeometry=function(a,b,c,d,e,f,g,h){THREE.Geometry.call(this);this.type="CylinderGeometry";this.parameters={radiusTop:a,radiusBottom:b,height:c,radialSegments:d,heightSegments:e,openEnded:f,thetaStart:g,thetaLength:h};this.fromBufferGeometry(new THREE.CylinderBufferGeometry(a,b,c,d,e,f,g,h));this.mergeVertices()};THREE.CylinderGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;
THREE.EdgesGeometry=function(a,b){function c(a,b){return a-b}THREE.BufferGeometry.call(this);var d=Math.cos(THREE.Math.DEG2RAD*(void 0!==b?b:1)),e=[0,0],f={},g=["a","b","c"],h;a instanceof THREE.BufferGeometry?(h=new THREE.Geometry,h.fromBufferGeometry(a)):h=a.clone();h.mergeVertices();h.computeFaceNormals();var k=h.vertices;h=h.faces;for(var l=0,n=h.length;l<n;l++)for(var p=h[l],m=0;3>m;m++){e[0]=p[g[m]];e[1]=p[g[(m+1)%3]];e.sort(c);var q=e.toString();void 0===f[q]?f[q]={vert1:e[0],vert2:e[1],face1:l,
face2:void 0}:f[q].face2=l}e=[];for(q in f)if(g=f[q],void 0===g.face2||h[g.face1].normal.dot(h[g.face2].normal)<=d)l=k[g.vert1],e.push(l.x),e.push(l.y),e.push(l.z),l=k[g.vert2],e.push(l.x),e.push(l.y),e.push(l.z);this.addAttribute("position",new THREE.BufferAttribute(new Float32Array(e),3))};THREE.EdgesGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.EdgesGeometry.prototype.constructor=THREE.EdgesGeometry;
THREE.ExtrudeGeometry=function(a,b){"undefined"!==typeof a&&(THREE.Geometry.call(this),this.type="ExtrudeGeometry",a=Array.isArray(a)?a:[a],this.addShapeList(a,b),this.computeFaceNormals())};THREE.ExtrudeGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;THREE.ExtrudeGeometry.prototype.addShapeList=function(a,b){for(var c=a.length,d=0;d<c;d++)this.addShape(a[d],b)};
THREE.ExtrudeGeometry.prototype.addShape=function(a,b){function c(a,b,c){b||console.error("THREE.ExtrudeGeometry: vec does not exist");return b.clone().multiplyScalar(c).add(a)}function d(a,b,c){var d=1,d=a.x-b.x,e=a.y-b.y,f=c.x-a.x,g=c.y-a.y,h=d*d+e*e;if(Math.abs(d*g-e*f)>Number.EPSILON){var k=Math.sqrt(h),l=Math.sqrt(f*f+g*g),h=b.x-e/k;b=b.y+d/k;f=((c.x-g/l-h)*g-(c.y+f/l-b)*f)/(d*g-e*f);c=h+d*f-a.x;a=b+e*f-a.y;d=c*c+a*a;if(2>=d)return new THREE.Vector2(c,a);d=Math.sqrt(d/2)}else a=!1,d>Number.EPSILON?
f>Number.EPSILON&&(a=!0):d<-Number.EPSILON?f<-Number.EPSILON&&(a=!0):Math.sign(e)===Math.sign(g)&&(a=!0),a?(c=-e,a=d,d=Math.sqrt(h)):(c=d,a=e,d=Math.sqrt(h/2));return new THREE.Vector2(c/d,a/d)}function e(a,b){var c,d;for(F=a.length;0<=--F;){c=F;d=F-1;0>d&&(d=a.length-1);for(var e=0,f=q+2*n,e=0;e<f;e++){var g=O*e,h=O*(e+1),k=b+c+g,g=b+d+g,l=b+d+h,h=b+c+h,k=k+D,g=g+D,l=l+D,h=h+D;J.faces.push(new THREE.Face3(k,g,h,null,null,1));J.faces.push(new THREE.Face3(g,l,h,null,null,1));k=v.generateSideWallUV(J,
k,g,l,h);J.faceVertexUvs[0].push([k[0],k[1],k[3]]);J.faceVertexUvs[0].push([k[1],k[2],k[3]])}}}function f(a,b,c){J.vertices.push(new THREE.Vector3(a,b,c))}function g(a,b,c){a+=D;b+=D;c+=D;J.faces.push(new THREE.Face3(a,b,c,null,null,0));a=v.generateTopUV(J,a,b,c);J.faceVertexUvs[0].push(a)}var h=void 0!==b.amount?b.amount:100,k=void 0!==b.bevelThickness?b.bevelThickness:6,l=void 0!==b.bevelSize?b.bevelSize:k-2,n=void 0!==b.bevelSegments?b.bevelSegments:3,p=void 0!==b.bevelEnabled?b.bevelEnabled:!0,
m=void 0!==b.curveSegments?b.curveSegments:12,q=void 0!==b.steps?b.steps:1,r=b.extrudePath,s,u=!1,v=void 0!==b.UVGenerator?b.UVGenerator:THREE.ExtrudeGeometry.WorldUVGenerator,x,A,w,B;r&&(s=r.getSpacedPoints(q),u=!0,p=!1,x=void 0!==b.frames?b.frames:new THREE.TubeGeometry.FrenetFrames(r,q,!1),A=new THREE.Vector3,w=new THREE.Vector3,B=new THREE.Vector3);p||(l=k=n=0);var z,y,C,J=this,D=this.vertices.length,r=a.extractPoints(m),m=r.shape,H=r.holes;if(r=!THREE.ShapeUtils.isClockWise(m)){m=m.reverse();
y=0;for(C=H.length;y<C;y++)z=H[y],THREE.ShapeUtils.isClockWise(z)&&(H[y]=z.reverse());r=!1}var G=THREE.ShapeUtils.triangulateShape(m,H),K=m;y=0;for(C=H.length;y<C;y++)z=H[y],m=m.concat(z);var P,I,L,E,M,O=m.length,Q,R=G.length,r=[],F=0;L=K.length;P=L-1;for(I=F+1;F<L;F++,P++,I++)P===L&&(P=0),I===L&&(I=0),r[F]=d(K[F],K[P],K[I]);var Z=[],T,X=r.concat();y=0;for(C=H.length;y<C;y++){z=H[y];T=[];F=0;L=z.length;P=L-1;for(I=F+1;F<L;F++,P++,I++)P===L&&(P=0),I===L&&(I=0),T[F]=d(z[F],z[P],z[I]);Z.push(T);X=X.concat(T)}for(P=
0;P<n;P++){L=P/n;E=k*(1-L);I=l*Math.sin(L*Math.PI/2);F=0;for(L=K.length;F<L;F++)M=c(K[F],r[F],I),f(M.x,M.y,-E);y=0;for(C=H.length;y<C;y++)for(z=H[y],T=Z[y],F=0,L=z.length;F<L;F++)M=c(z[F],T[F],I),f(M.x,M.y,-E)}I=l;for(F=0;F<O;F++)M=p?c(m[F],X[F],I):m[F],u?(w.copy(x.normals[0]).multiplyScalar(M.x),A.copy(x.binormals[0]).multiplyScalar(M.y),B.copy(s[0]).add(w).add(A),f(B.x,B.y,B.z)):f(M.x,M.y,0);for(L=1;L<=q;L++)for(F=0;F<O;F++)M=p?c(m[F],X[F],I):m[F],u?(w.copy(x.normals[L]).multiplyScalar(M.x),A.copy(x.binormals[L]).multiplyScalar(M.y),
B.copy(s[L]).add(w).add(A),f(B.x,B.y,B.z)):f(M.x,M.y,h/q*L);for(P=n-1;0<=P;P--){L=P/n;E=k*(1-L);I=l*Math.sin(L*Math.PI/2);F=0;for(L=K.length;F<L;F++)M=c(K[F],r[F],I),f(M.x,M.y,h+E);y=0;for(C=H.length;y<C;y++)for(z=H[y],T=Z[y],F=0,L=z.length;F<L;F++)M=c(z[F],T[F],I),u?f(M.x,M.y+s[q-1].y,s[q-1].x+E):f(M.x,M.y,h+E)}(function(){if(p){var a;a=0*O;for(F=0;F<R;F++)Q=G[F],g(Q[2]+a,Q[1]+a,Q[0]+a);a=q+2*n;a*=O;for(F=0;F<R;F++)Q=G[F],g(Q[0]+a,Q[1]+a,Q[2]+a)}else{for(F=0;F<R;F++)Q=G[F],g(Q[2],Q[1],Q[0]);for(F=
0;F<R;F++)Q=G[F],g(Q[0]+O*q,Q[1]+O*q,Q[2]+O*q)}})();(function(){var a=0;e(K,a);a+=K.length;y=0;for(C=H.length;y<C;y++)z=H[y],e(z,a),a+=z.length})()};
THREE.ExtrudeGeometry.WorldUVGenerator={generateTopUV:function(a,b,c,d){a=a.vertices;b=a[b];c=a[c];d=a[d];return[new THREE.Vector2(b.x,b.y),new THREE.Vector2(c.x,c.y),new THREE.Vector2(d.x,d.y)]},generateSideWallUV:function(a,b,c,d,e){a=a.vertices;b=a[b];c=a[c];d=a[d];e=a[e];return.01>Math.abs(b.y-c.y)?[new THREE.Vector2(b.x,1-b.z),new THREE.Vector2(c.x,1-c.z),new THREE.Vector2(d.x,1-d.z),new THREE.Vector2(e.x,1-e.z)]:[new THREE.Vector2(b.y,1-b.z),new THREE.Vector2(c.y,1-c.z),new THREE.Vector2(d.y,
1-d.z),new THREE.Vector2(e.y,1-e.z)]}};THREE.ShapeGeometry=function(a,b){THREE.Geometry.call(this);this.type="ShapeGeometry";!1===Array.isArray(a)&&(a=[a]);this.addShapeList(a,b);this.computeFaceNormals()};THREE.ShapeGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.ShapeGeometry.prototype.constructor=THREE.ShapeGeometry;THREE.ShapeGeometry.prototype.addShapeList=function(a,b){for(var c=0,d=a.length;c<d;c++)this.addShape(a[c],b);return this};
THREE.ShapeGeometry.prototype.addShape=function(a,b){void 0===b&&(b={});var c=b.material,d=void 0===b.UVGenerator?THREE.ExtrudeGeometry.WorldUVGenerator:b.UVGenerator,e,f,g,h=this.vertices.length;e=a.extractPoints(void 0!==b.curveSegments?b.curveSegments:12);var k=e.shape,l=e.holes;if(!THREE.ShapeUtils.isClockWise(k))for(k=k.reverse(),e=0,f=l.length;e<f;e++)g=l[e],THREE.ShapeUtils.isClockWise(g)&&(l[e]=g.reverse());var n=THREE.ShapeUtils.triangulateShape(k,l);e=0;for(f=l.length;e<f;e++)g=l[e],k=k.concat(g);
l=k.length;f=n.length;for(e=0;e<l;e++)g=k[e],this.vertices.push(new THREE.Vector3(g.x,g.y,0));for(e=0;e<f;e++)l=n[e],k=l[0]+h,g=l[1]+h,l=l[2]+h,this.faces.push(new THREE.Face3(k,g,l,null,null,c)),this.faceVertexUvs[0].push(d.generateTopUV(this,k,g,l))};
THREE.LatheBufferGeometry=function(a,b,c,d){THREE.BufferGeometry.call(this);this.type="LatheBufferGeometry";this.parameters={points:a,segments:b,phiStart:c,phiLength:d};b=Math.floor(b)||12;c=c||0;d=d||2*Math.PI;d=THREE.Math.clamp(d,0,2*Math.PI);for(var e=(b+1)*a.length,f=b*a.length*6,g=new THREE.BufferAttribute(new (65535<f?Uint32Array:Uint16Array)(f),1),h=new THREE.BufferAttribute(new Float32Array(3*e),3),k=new THREE.BufferAttribute(new Float32Array(2*e),2),l=0,n=0,p=1/b,m=new THREE.Vector3,q=new THREE.Vector2,
e=0;e<=b;e++)for(var f=c+e*p*d,r=Math.sin(f),s=Math.cos(f),f=0;f<=a.length-1;f++)m.x=a[f].x*r,m.y=a[f].y,m.z=a[f].x*s,h.setXYZ(l,m.x,m.y,m.z),q.x=e/b,q.y=f/(a.length-1),k.setXY(l,q.x,q.y),l++;for(e=0;e<b;e++)for(f=0;f<a.length-1;f++)c=f+e*a.length,l=c+a.length,p=c+a.length+1,m=c+1,g.setX(n,c),n++,g.setX(n,l),n++,g.setX(n,m),n++,g.setX(n,l),n++,g.setX(n,p),n++,g.setX(n,m),n++;this.setIndex(g);this.addAttribute("position",h);this.addAttribute("uv",k);this.computeVertexNormals();if(d===2*Math.PI)for(d=
this.attributes.normal.array,g=new THREE.Vector3,h=new THREE.Vector3,k=new THREE.Vector3,c=b*a.length*3,f=e=0;e<a.length;e++,f+=3)g.x=d[f+0],g.y=d[f+1],g.z=d[f+2],h.x=d[c+f+0],h.y=d[c+f+1],h.z=d[c+f+2],k.addVectors(g,h).normalize(),d[f+0]=d[c+f+0]=k.x,d[f+1]=d[c+f+1]=k.y,d[f+2]=d[c+f+2]=k.z};THREE.LatheBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.LatheBufferGeometry.prototype.constructor=THREE.LatheBufferGeometry;
THREE.LatheGeometry=function(a,b,c,d){THREE.Geometry.call(this);this.type="LatheGeometry";this.parameters={points:a,segments:b,phiStart:c,phiLength:d};this.fromBufferGeometry(new THREE.LatheBufferGeometry(a,b,c,d));this.mergeVertices()};THREE.LatheGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.PlaneGeometry=function(a,b,c,d){THREE.Geometry.call(this);this.type="PlaneGeometry";this.parameters={width:a,height:b,widthSegments:c,heightSegments:d};this.fromBufferGeometry(new THREE.PlaneBufferGeometry(a,b,c,d))};THREE.PlaneGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.PlaneBufferGeometry=function(a,b,c,d){THREE.BufferGeometry.call(this);this.type="PlaneBufferGeometry";this.parameters={width:a,height:b,widthSegments:c,heightSegments:d};var e=a/2,f=b/2;c=Math.floor(c)||1;d=Math.floor(d)||1;var g=c+1,h=d+1,k=a/c,l=b/d;b=new Float32Array(g*h*3);a=new Float32Array(g*h*3);for(var n=new Float32Array(g*h*2),p=0,m=0,q=0;q<h;q++)for(var r=q*l-f,s=0;s<g;s++)b[p]=s*k-e,b[p+1]=-r,a[p+2]=1,n[m]=s/c,n[m+1]=1-q/d,p+=3,m+=2;p=0;e=new (65535<b.length/3?Uint32Array:Uint16Array)(c*
d*6);for(q=0;q<d;q++)for(s=0;s<c;s++)f=s+g*(q+1),h=s+1+g*(q+1),k=s+1+g*q,e[p]=s+g*q,e[p+1]=f,e[p+2]=k,e[p+3]=f,e[p+4]=h,e[p+5]=k,p+=6;this.setIndex(new THREE.BufferAttribute(e,1));this.addAttribute("position",new THREE.BufferAttribute(b,3));this.addAttribute("normal",new THREE.BufferAttribute(a,3));this.addAttribute("uv",new THREE.BufferAttribute(n,2))};THREE.PlaneBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.PlaneBufferGeometry.prototype.constructor=THREE.PlaneBufferGeometry;
THREE.RingBufferGeometry=function(a,b,c,d,e,f){THREE.BufferGeometry.call(this);this.type="RingBufferGeometry";this.parameters={innerRadius:a,outerRadius:b,thetaSegments:c,phiSegments:d,thetaStart:e,thetaLength:f};a=a||20;b=b||50;e=void 0!==e?e:0;f=void 0!==f?f:2*Math.PI;c=void 0!==c?Math.max(3,c):8;d=void 0!==d?Math.max(1,d):1;var g=(c+1)*(d+1),h=c*d*6,h=new THREE.BufferAttribute(new (65535<h?Uint32Array:Uint16Array)(h),1),k=new THREE.BufferAttribute(new Float32Array(3*g),3),l=new THREE.BufferAttribute(new Float32Array(3*
g),3),g=new THREE.BufferAttribute(new Float32Array(2*g),2),n=0,p=0,m,q=a,r=(b-a)/d,s=new THREE.Vector3,u=new THREE.Vector2,v;for(a=0;a<=d;a++){for(v=0;v<=c;v++)m=e+v/c*f,s.x=q*Math.cos(m),s.y=q*Math.sin(m),k.setXYZ(n,s.x,s.y,s.z),l.setXYZ(n,0,0,1),u.x=(s.x/b+1)/2,u.y=(s.y/b+1)/2,g.setXY(n,u.x,u.y),n++;q+=r}for(a=0;a<d;a++)for(b=a*(c+1),v=0;v<c;v++)e=m=v+b,f=m+c+1,n=m+c+2,m+=1,h.setX(p,e),p++,h.setX(p,f),p++,h.setX(p,n),p++,h.setX(p,e),p++,h.setX(p,n),p++,h.setX(p,m),p++;this.setIndex(h);this.addAttribute("position",
k);this.addAttribute("normal",l);this.addAttribute("uv",g)};THREE.RingBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.RingBufferGeometry.prototype.constructor=THREE.RingBufferGeometry;THREE.RingGeometry=function(a,b,c,d,e,f){THREE.Geometry.call(this);this.type="RingGeometry";this.parameters={innerRadius:a,outerRadius:b,thetaSegments:c,phiSegments:d,thetaStart:e,thetaLength:f};this.fromBufferGeometry(new THREE.RingBufferGeometry(a,b,c,d,e,f))};
THREE.RingGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.RingGeometry.prototype.constructor=THREE.RingGeometry;THREE.SphereGeometry=function(a,b,c,d,e,f,g){THREE.Geometry.call(this);this.type="SphereGeometry";this.parameters={radius:a,widthSegments:b,heightSegments:c,phiStart:d,phiLength:e,thetaStart:f,thetaLength:g};this.fromBufferGeometry(new THREE.SphereBufferGeometry(a,b,c,d,e,f,g))};THREE.SphereGeometry.prototype=Object.create(THREE.Geometry.prototype);
THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;
THREE.SphereBufferGeometry=function(a,b,c,d,e,f,g){THREE.BufferGeometry.call(this);this.type="SphereBufferGeometry";this.parameters={radius:a,widthSegments:b,heightSegments:c,phiStart:d,phiLength:e,thetaStart:f,thetaLength:g};a=a||50;b=Math.max(3,Math.floor(b)||8);c=Math.max(2,Math.floor(c)||6);d=void 0!==d?d:0;e=void 0!==e?e:2*Math.PI;f=void 0!==f?f:0;g=void 0!==g?g:Math.PI;for(var h=f+g,k=(b+1)*(c+1),l=new THREE.BufferAttribute(new Float32Array(3*k),3),n=new THREE.BufferAttribute(new Float32Array(3*
k),3),k=new THREE.BufferAttribute(new Float32Array(2*k),2),p=0,m=[],q=new THREE.Vector3,r=0;r<=c;r++){for(var s=[],u=r/c,v=0;v<=b;v++){var x=v/b,A=-a*Math.cos(d+x*e)*Math.sin(f+u*g),w=a*Math.cos(f+u*g),B=a*Math.sin(d+x*e)*Math.sin(f+u*g);q.set(A,w,B).normalize();l.setXYZ(p,A,w,B);n.setXYZ(p,q.x,q.y,q.z);k.setXY(p,x,1-u);s.push(p);p++}m.push(s)}d=[];for(r=0;r<c;r++)for(v=0;v<b;v++)e=m[r][v+1],g=m[r][v],p=m[r+1][v],q=m[r+1][v+1],(0!==r||0<f)&&d.push(e,g,q),(r!==c-1||h<Math.PI)&&d.push(g,p,q);this.setIndex(new (65535<
l.count?THREE.Uint32Attribute:THREE.Uint16Attribute)(d,1));this.addAttribute("position",l);this.addAttribute("normal",n);this.addAttribute("uv",k);this.boundingSphere=new THREE.Sphere(new THREE.Vector3,a)};THREE.SphereBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.SphereBufferGeometry.prototype.constructor=THREE.SphereBufferGeometry;
THREE.TextGeometry=function(a,b){b=b||{};var c=b.font;if(!1===c instanceof THREE.Font)return console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new THREE.Geometry;c=c.generateShapes(a,b.size,b.curveSegments);b.amount=void 0!==b.height?b.height:50;void 0===b.bevelThickness&&(b.bevelThickness=10);void 0===b.bevelSize&&(b.bevelSize=8);void 0===b.bevelEnabled&&(b.bevelEnabled=!1);THREE.ExtrudeGeometry.call(this,c,b);this.type="TextGeometry"};
THREE.TextGeometry.prototype=Object.create(THREE.ExtrudeGeometry.prototype);THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.TorusBufferGeometry=function(a,b,c,d,e){THREE.BufferGeometry.call(this);this.type="TorusBufferGeometry";this.parameters={radius:a,tube:b,radialSegments:c,tubularSegments:d,arc:e};a=a||100;b=b||40;c=Math.floor(c)||8;d=Math.floor(d)||6;e=e||2*Math.PI;var f=(c+1)*(d+1),g=c*d*6,g=new (65535<g?Uint32Array:Uint16Array)(g),h=new Float32Array(3*f),k=new Float32Array(3*f),f=new Float32Array(2*f),l=0,n=0,p=0,m=new THREE.Vector3,q=new THREE.Vector3,r=new THREE.Vector3,s,u;for(s=0;s<=c;s++)for(u=0;u<=d;u++){var v=
u/d*e,x=s/c*Math.PI*2;q.x=(a+b*Math.cos(x))*Math.cos(v);q.y=(a+b*Math.cos(x))*Math.sin(v);q.z=b*Math.sin(x);h[l]=q.x;h[l+1]=q.y;h[l+2]=q.z;m.x=a*Math.cos(v);m.y=a*Math.sin(v);r.subVectors(q,m).normalize();k[l]=r.x;k[l+1]=r.y;k[l+2]=r.z;f[n]=u/d;f[n+1]=s/c;l+=3;n+=2}for(s=1;s<=c;s++)for(u=1;u<=d;u++)a=(d+1)*(s-1)+u-1,b=(d+1)*(s-1)+u,e=(d+1)*s+u,g[p]=(d+1)*s+u-1,g[p+1]=a,g[p+2]=e,g[p+3]=a,g[p+4]=b,g[p+5]=e,p+=6;this.setIndex(new THREE.BufferAttribute(g,1));this.addAttribute("position",new THREE.BufferAttribute(h,
3));this.addAttribute("normal",new THREE.BufferAttribute(k,3));this.addAttribute("uv",new THREE.BufferAttribute(f,2))};THREE.TorusBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.TorusBufferGeometry.prototype.constructor=THREE.TorusBufferGeometry;
THREE.TorusGeometry=function(a,b,c,d,e){THREE.Geometry.call(this);this.type="TorusGeometry";this.parameters={radius:a,tube:b,radialSegments:c,tubularSegments:d,arc:e};this.fromBufferGeometry(new THREE.TorusBufferGeometry(a,b,c,d,e))};THREE.TorusGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotBufferGeometry=function(a,b,c,d,e,f){function g(a,b,c,d,e){var f=Math.cos(a),g=Math.sin(a);a*=c/b;b=Math.cos(a);e.x=d*(2+b)*.5*f;e.y=d*(2+b)*g*.5;e.z=d*Math.sin(a)*.5}THREE.BufferGeometry.call(this);this.type="TorusKnotBufferGeometry";this.parameters={radius:a,tube:b,tubularSegments:c,radialSegments:d,p:e,q:f};a=a||100;b=b||40;c=Math.floor(c)||64;d=Math.floor(d)||8;e=e||2;f=f||3;var h=(d+1)*(c+1),k=d*c*6,k=new THREE.BufferAttribute(new (65535<k?Uint32Array:Uint16Array)(k),1),l=new THREE.BufferAttribute(new Float32Array(3*
h),3),n=new THREE.BufferAttribute(new Float32Array(3*h),3),h=new THREE.BufferAttribute(new Float32Array(2*h),2),p,m,q=0,r=0,s=new THREE.Vector3,u=new THREE.Vector3,v=new THREE.Vector2,x=new THREE.Vector3,A=new THREE.Vector3,w=new THREE.Vector3,B=new THREE.Vector3,z=new THREE.Vector3;for(p=0;p<=c;++p)for(m=p/c*e*Math.PI*2,g(m,e,f,a,x),g(m+.01,e,f,a,A),B.subVectors(A,x),z.addVectors(A,x),w.crossVectors(B,z),z.crossVectors(w,B),w.normalize(),z.normalize(),m=0;m<=d;++m){var y=m/d*Math.PI*2,C=-b*Math.cos(y),
y=b*Math.sin(y);s.x=x.x+(C*z.x+y*w.x);s.y=x.y+(C*z.y+y*w.y);s.z=x.z+(C*z.z+y*w.z);l.setXYZ(q,s.x,s.y,s.z);u.subVectors(s,x).normalize();n.setXYZ(q,u.x,u.y,u.z);v.x=p/c;v.y=m/d;h.setXY(q,v.x,v.y);q++}for(m=1;m<=c;m++)for(p=1;p<=d;p++)a=(d+1)*m+(p-1),b=(d+1)*m+p,e=(d+1)*(m-1)+p,k.setX(r,(d+1)*(m-1)+(p-1)),r++,k.setX(r,a),r++,k.setX(r,e),r++,k.setX(r,a),r++,k.setX(r,b),r++,k.setX(r,e),r++;this.setIndex(k);this.addAttribute("position",l);this.addAttribute("normal",n);this.addAttribute("uv",h)};
THREE.TorusKnotBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);THREE.TorusKnotBufferGeometry.prototype.constructor=THREE.TorusKnotBufferGeometry;
THREE.TorusKnotGeometry=function(a,b,c,d,e,f,g){THREE.Geometry.call(this);this.type="TorusKnotGeometry";this.parameters={radius:a,tube:b,tubularSegments:c,radialSegments:d,p:e,q:f};void 0!==g&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead.");this.fromBufferGeometry(new THREE.TorusKnotBufferGeometry(a,b,c,d,e,f));this.mergeVertices()};THREE.TorusKnotGeometry.prototype=Object.create(THREE.Geometry.prototype);
THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;
THREE.TubeGeometry=function(a,b,c,d,e,f){THREE.Geometry.call(this);this.type="TubeGeometry";this.parameters={path:a,segments:b,radius:c,radialSegments:d,closed:e,taper:f};b=b||64;c=c||1;d=d||8;e=e||!1;f=f||THREE.TubeGeometry.NoTaper;var g=[],h,k,l=b+1,n,p,m,q,r,s=new THREE.Vector3,u,v,x;u=new THREE.TubeGeometry.FrenetFrames(a,b,e);v=u.normals;x=u.binormals;this.tangents=u.tangents;this.normals=v;this.binormals=x;for(u=0;u<l;u++)for(g[u]=[],n=u/(l-1),r=a.getPointAt(n),h=v[u],k=x[u],m=c*f(n),n=0;n<
d;n++)p=n/d*2*Math.PI,q=-m*Math.cos(p),p=m*Math.sin(p),s.copy(r),s.x+=q*h.x+p*k.x,s.y+=q*h.y+p*k.y,s.z+=q*h.z+p*k.z,g[u][n]=this.vertices.push(new THREE.Vector3(s.x,s.y,s.z))-1;for(u=0;u<b;u++)for(n=0;n<d;n++)f=e?(u+1)%b:u+1,l=(n+1)%d,a=g[u][n],c=g[f][n],f=g[f][l],l=g[u][l],s=new THREE.Vector2(u/b,n/d),v=new THREE.Vector2((u+1)/b,n/d),x=new THREE.Vector2((u+1)/b,(n+1)/d),h=new THREE.Vector2(u/b,(n+1)/d),this.faces.push(new THREE.Face3(a,c,l)),this.faceVertexUvs[0].push([s,v,h]),this.faces.push(new THREE.Face3(c,
f,l)),this.faceVertexUvs[0].push([v.clone(),x,h.clone()]);this.computeFaceNormals();this.computeVertexNormals()};THREE.TubeGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.TubeGeometry.prototype.constructor=THREE.TubeGeometry;THREE.TubeGeometry.NoTaper=function(a){return 1};THREE.TubeGeometry.SinusoidalTaper=function(a){return Math.sin(Math.PI*a)};
THREE.TubeGeometry.FrenetFrames=function(a,b,c){var d=new THREE.Vector3,e=[],f=[],g=[],h=new THREE.Vector3,k=new THREE.Matrix4;b+=1;var l,n,p;this.tangents=e;this.normals=f;this.binormals=g;for(l=0;l<b;l++)n=l/(b-1),e[l]=a.getTangentAt(n),e[l].normalize();f[0]=new THREE.Vector3;g[0]=new THREE.Vector3;a=Number.MAX_VALUE;l=Math.abs(e[0].x);n=Math.abs(e[0].y);p=Math.abs(e[0].z);l<=a&&(a=l,d.set(1,0,0));n<=a&&(a=n,d.set(0,1,0));p<=a&&d.set(0,0,1);h.crossVectors(e[0],d).normalize();f[0].crossVectors(e[0],
h);g[0].crossVectors(e[0],f[0]);for(l=1;l<b;l++)f[l]=f[l-1].clone(),g[l]=g[l-1].clone(),h.crossVectors(e[l-1],e[l]),h.length()>Number.EPSILON&&(h.normalize(),d=Math.acos(THREE.Math.clamp(e[l-1].dot(e[l]),-1,1)),f[l].applyMatrix4(k.makeRotationAxis(h,d))),g[l].crossVectors(e[l],f[l]);if(c)for(d=Math.acos(THREE.Math.clamp(f[0].dot(f[b-1]),-1,1)),d/=b-1,0<e[0].dot(h.crossVectors(f[0],f[b-1]))&&(d=-d),l=1;l<b;l++)f[l].applyMatrix4(k.makeRotationAxis(e[l],d*l)),g[l].crossVectors(e[l],f[l])};
THREE.PolyhedronGeometry=function(a,b,c,d){function e(a){var b=a.normalize().clone();b.index=k.vertices.push(b)-1;var c=Math.atan2(a.z,-a.x)/2/Math.PI+.5;a=Math.atan2(-a.y,Math.sqrt(a.x*a.x+a.z*a.z))/Math.PI+.5;b.uv=new THREE.Vector2(c,1-a);return b}function f(a,b,c,d){d=new THREE.Face3(a.index,b.index,c.index,[a.clone(),b.clone(),c.clone()],void 0,d);k.faces.push(d);u.copy(a).add(b).add(c).divideScalar(3);d=Math.atan2(u.z,-u.x);k.faceVertexUvs[0].push([h(a.uv,a,d),h(b.uv,b,d),h(c.uv,c,d)])}function g(a,
b){for(var c=Math.pow(2,b),d=e(k.vertices[a.a]),g=e(k.vertices[a.b]),h=e(k.vertices[a.c]),l=[],m=a.materialIndex,n=0;n<=c;n++){l[n]=[];for(var p=e(d.clone().lerp(h,n/c)),q=e(g.clone().lerp(h,n/c)),r=c-n,s=0;s<=r;s++)l[n][s]=0===s&&n===c?p:e(p.clone().lerp(q,s/r))}for(n=0;n<c;n++)for(s=0;s<2*(c-n)-1;s++)d=Math.floor(s/2),0===s%2?f(l[n][d+1],l[n+1][d],l[n][d],m):f(l[n][d+1],l[n+1][d+1],l[n+1][d],m)}function h(a,b,c){0>c&&1===a.x&&(a=new THREE.Vector2(a.x-1,a.y));0===b.x&&0===b.z&&(a=new THREE.Vector2(c/
2/Math.PI+.5,a.y));return a.clone()}THREE.Geometry.call(this);this.type="PolyhedronGeometry";this.parameters={vertices:a,indices:b,radius:c,detail:d};c=c||1;d=d||0;for(var k=this,l=0,n=a.length;l<n;l+=3)e(new THREE.Vector3(a[l],a[l+1],a[l+2]));a=this.vertices;for(var p=[],m=l=0,n=b.length;l<n;l+=3,m++){var q=a[b[l]],r=a[b[l+1]],s=a[b[l+2]];p[m]=new THREE.Face3(q.index,r.index,s.index,[q.clone(),r.clone(),s.clone()],void 0,m)}for(var u=new THREE.Vector3,l=0,n=p.length;l<n;l++)g(p[l],d);l=0;for(n=this.faceVertexUvs[0].length;l<
n;l++)b=this.faceVertexUvs[0][l],d=b[0].x,a=b[1].x,p=b[2].x,m=Math.max(d,a,p),q=Math.min(d,a,p),.9<m&&.1>q&&(.2>d&&(b[0].x+=1),.2>a&&(b[1].x+=1),.2>p&&(b[2].x+=1));l=0;for(n=this.vertices.length;l<n;l++)this.vertices[l].multiplyScalar(c);this.mergeVertices();this.computeFaceNormals();this.boundingSphere=new THREE.Sphere(new THREE.Vector3,c)};THREE.PolyhedronGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.PolyhedronGeometry.prototype.constructor=THREE.PolyhedronGeometry;
THREE.DodecahedronGeometry=function(a,b){var c=(1+Math.sqrt(5))/2,d=1/c;THREE.PolyhedronGeometry.call(this,[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-d,-c,0,-d,c,0,d,-c,0,d,c,-d,-c,0,-d,c,0,d,-c,0,d,c,0,-c,0,-d,c,0,-d,-c,0,d,c,0,d],[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,
12,14,1,14,5,1,5,9],a,b);this.type="DodecahedronGeometry";this.parameters={radius:a,detail:b}};THREE.DodecahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype);THREE.DodecahedronGeometry.prototype.constructor=THREE.DodecahedronGeometry;
THREE.IcosahedronGeometry=function(a,b){var c=(1+Math.sqrt(5))/2;THREE.PolyhedronGeometry.call(this,[-1,c,0,1,c,0,-1,-c,0,1,-c,0,0,-1,c,0,1,c,0,-1,-c,0,1,-c,c,0,-1,c,0,1,-c,0,-1,-c,0,1],[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],a,b);this.type="IcosahedronGeometry";this.parameters={radius:a,detail:b}};THREE.IcosahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype);
THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;THREE.OctahedronGeometry=function(a,b){THREE.PolyhedronGeometry.call(this,[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],a,b);this.type="OctahedronGeometry";this.parameters={radius:a,detail:b}};THREE.OctahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype);THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry;
THREE.TetrahedronGeometry=function(a,b){THREE.PolyhedronGeometry.call(this,[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],a,b);this.type="TetrahedronGeometry";this.parameters={radius:a,detail:b}};THREE.TetrahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype);THREE.TetrahedronGeometry.prototype.constructor=THREE.TetrahedronGeometry;
THREE.ParametricGeometry=function(a,b,c){THREE.Geometry.call(this);this.type="ParametricGeometry";this.parameters={func:a,slices:b,stacks:c};var d=this.vertices,e=this.faces,f=this.faceVertexUvs[0],g,h,k,l,n=b+1;for(g=0;g<=c;g++)for(l=g/c,h=0;h<=b;h++)k=h/b,k=a(k,l),d.push(k);var p,m,q,r;for(g=0;g<c;g++)for(h=0;h<b;h++)a=g*n+h,d=g*n+h+1,l=(g+1)*n+h+1,k=(g+1)*n+h,p=new THREE.Vector2(h/b,g/c),m=new THREE.Vector2((h+1)/b,g/c),q=new THREE.Vector2((h+1)/b,(g+1)/c),r=new THREE.Vector2(h/b,(g+1)/c),e.push(new THREE.Face3(a,
d,k)),f.push([p,m,r]),e.push(new THREE.Face3(d,l,k)),f.push([m.clone(),q,r.clone()]);this.computeFaceNormals();this.computeVertexNormals()};THREE.ParametricGeometry.prototype=Object.create(THREE.Geometry.prototype);THREE.ParametricGeometry.prototype.constructor=THREE.ParametricGeometry;
THREE.WireframeGeometry=function(a){function b(a,b){return a-b}THREE.BufferGeometry.call(this);var c=[0,0],d={},e=["a","b","c"];if(a instanceof THREE.Geometry){var f=a.vertices,g=a.faces,h=0,k=new Uint32Array(6*g.length);a=0;for(var l=g.length;a<l;a++)for(var n=g[a],p=0;3>p;p++){c[0]=n[e[p]];c[1]=n[e[(p+1)%3]];c.sort(b);var m=c.toString();void 0===d[m]&&(k[2*h]=c[0],k[2*h+1]=c[1],d[m]=!0,h++)}c=new Float32Array(6*h);a=0;for(l=h;a<l;a++)for(p=0;2>p;p++)d=f[k[2*a+p]],h=6*a+3*p,c[h+0]=d.x,c[h+1]=d.y,
c[h+2]=d.z;this.addAttribute("position",new THREE.BufferAttribute(c,3))}else if(a instanceof THREE.BufferGeometry){if(null!==a.index){l=a.index.array;f=a.attributes.position;e=a.groups;h=0;0===e.length&&a.addGroup(0,l.length);k=new Uint32Array(2*l.length);g=0;for(n=e.length;g<n;++g){a=e[g];p=a.start;m=a.count;a=p;for(var q=p+m;a<q;a+=3)for(p=0;3>p;p++)c[0]=l[a+p],c[1]=l[a+(p+1)%3],c.sort(b),m=c.toString(),void 0===d[m]&&(k[2*h]=c[0],k[2*h+1]=c[1],d[m]=!0,h++)}c=new Float32Array(6*h);a=0;for(l=h;a<
l;a++)for(p=0;2>p;p++)h=6*a+3*p,d=k[2*a+p],c[h+0]=f.getX(d),c[h+1]=f.getY(d),c[h+2]=f.getZ(d)}else for(f=a.attributes.position.array,h=f.length/3,k=h/3,c=new Float32Array(6*h),a=0,l=k;a<l;a++)for(p=0;3>p;p++)h=18*a+6*p,k=9*a+3*p,c[h+0]=f[k],c[h+1]=f[k+1],c[h+2]=f[k+2],d=9*a+(p+1)%3*3,c[h+3]=f[d],c[h+4]=f[d+1],c[h+5]=f[d+2];this.addAttribute("position",new THREE.BufferAttribute(c,3))}};THREE.WireframeGeometry.prototype=Object.create(THREE.BufferGeometry.prototype);
THREE.WireframeGeometry.prototype.constructor=THREE.WireframeGeometry;THREE.AxisHelper=function(a){a=a||1;var b=new Float32Array([0,0,0,a,0,0,0,0,0,0,a,0,0,0,0,0,0,a]),c=new Float32Array([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1]);a=new THREE.BufferGeometry;a.addAttribute("position",new THREE.BufferAttribute(b,3));a.addAttribute("color",new THREE.BufferAttribute(c,3));b=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors});THREE.LineSegments.call(this,a,b)};THREE.AxisHelper.prototype=Object.create(THREE.LineSegments.prototype);
THREE.AxisHelper.prototype.constructor=THREE.AxisHelper;
THREE.ArrowHelper=function(){var a=new THREE.Geometry;a.vertices.push(new THREE.Vector3(0,0,0),new THREE.Vector3(0,1,0));var b=new THREE.CylinderGeometry(0,.5,1,5,1);b.translate(0,-.5,0);return function(c,d,e,f,g,h){THREE.Object3D.call(this);void 0===f&&(f=16776960);void 0===e&&(e=1);void 0===g&&(g=.2*e);void 0===h&&(h=.2*g);this.position.copy(d);this.line=new THREE.Line(a,new THREE.LineBasicMaterial({color:f}));this.line.matrixAutoUpdate=!1;this.add(this.line);this.cone=new THREE.Mesh(b,new THREE.MeshBasicMaterial({color:f}));
this.cone.matrixAutoUpdate=!1;this.add(this.cone);this.setDirection(c);this.setLength(e,g,h)}}();THREE.ArrowHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.ArrowHelper.prototype.constructor=THREE.ArrowHelper;THREE.ArrowHelper.prototype.setDirection=function(){var a=new THREE.Vector3,b;return function(c){.99999<c.y?this.quaternion.set(0,0,0,1):-.99999>c.y?this.quaternion.set(1,0,0,0):(a.set(c.z,0,-c.x).normalize(),b=Math.acos(c.y),this.quaternion.setFromAxisAngle(a,b))}}();
THREE.ArrowHelper.prototype.setLength=function(a,b,c){void 0===b&&(b=.2*a);void 0===c&&(c=.2*b);this.line.scale.set(1,Math.max(0,a-b),1);this.line.updateMatrix();this.cone.scale.set(c,b,c);this.cone.position.y=a;this.cone.updateMatrix()};THREE.ArrowHelper.prototype.setColor=function(a){this.line.material.color.set(a);this.cone.material.color.set(a)};
THREE.BoxHelper=function(a){var b=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),c=new Float32Array(24),d=new THREE.BufferGeometry;d.setIndex(new THREE.BufferAttribute(b,1));d.addAttribute("position",new THREE.BufferAttribute(c,3));THREE.LineSegments.call(this,d,new THREE.LineBasicMaterial({color:16776960}));void 0!==a&&this.update(a)};THREE.BoxHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.BoxHelper.prototype.constructor=THREE.BoxHelper;
THREE.BoxHelper.prototype.update=function(){var a=new THREE.Box3;return function(b){b instanceof THREE.Box3?a.copy(b):a.setFromObject(b);if(!a.isEmpty()){b=a.min;var c=a.max,d=this.geometry.attributes.position,e=d.array;e[0]=c.x;e[1]=c.y;e[2]=c.z;e[3]=b.x;e[4]=c.y;e[5]=c.z;e[6]=b.x;e[7]=b.y;e[8]=c.z;e[9]=c.x;e[10]=b.y;e[11]=c.z;e[12]=c.x;e[13]=c.y;e[14]=b.z;e[15]=b.x;e[16]=c.y;e[17]=b.z;e[18]=b.x;e[19]=b.y;e[20]=b.z;e[21]=c.x;e[22]=b.y;e[23]=b.z;d.needsUpdate=!0;this.geometry.computeBoundingSphere()}}}();
THREE.BoundingBoxHelper=function(a,b){var c=void 0!==b?b:8947848;this.object=a;this.box=new THREE.Box3;THREE.Mesh.call(this,new THREE.BoxGeometry(1,1,1),new THREE.MeshBasicMaterial({color:c,wireframe:!0}))};THREE.BoundingBoxHelper.prototype=Object.create(THREE.Mesh.prototype);THREE.BoundingBoxHelper.prototype.constructor=THREE.BoundingBoxHelper;THREE.BoundingBoxHelper.prototype.update=function(){this.box.setFromObject(this.object);this.box.size(this.scale);this.box.center(this.position)};
THREE.CameraHelper=function(a){function b(a,b,d){c(a,d);c(b,d)}function c(a,b){d.vertices.push(new THREE.Vector3);d.colors.push(new THREE.Color(b));void 0===f[a]&&(f[a]=[]);f[a].push(d.vertices.length-1)}var d=new THREE.Geometry,e=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors}),f={};b("n1","n2",16755200);b("n2","n4",16755200);b("n4","n3",16755200);b("n3","n1",16755200);b("f1","f2",16755200);b("f2","f4",16755200);b("f4","f3",16755200);b("f3","f1",16755200);b("n1","f1",16755200);
b("n2","f2",16755200);b("n3","f3",16755200);b("n4","f4",16755200);b("p","n1",16711680);b("p","n2",16711680);b("p","n3",16711680);b("p","n4",16711680);b("u1","u2",43775);b("u2","u3",43775);b("u3","u1",43775);b("c","t",16777215);b("p","c",3355443);b("cn1","cn2",3355443);b("cn3","cn4",3355443);b("cf1","cf2",3355443);b("cf3","cf4",3355443);THREE.LineSegments.call(this,d,e);this.camera=a;this.camera.updateProjectionMatrix();this.matrix=a.matrixWorld;this.matrixAutoUpdate=!1;this.pointMap=f;this.update()};
THREE.CameraHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;
THREE.CameraHelper.prototype.update=function(){function a(a,g,h,k){d.set(g,h,k).unproject(e);a=c[a];if(void 0!==a)for(g=0,h=a.length;g<h;g++)b.vertices[a[g]].copy(d)}var b,c,d=new THREE.Vector3,e=new THREE.Camera;return function(){b=this.geometry;c=this.pointMap;e.projectionMatrix.copy(this.camera.projectionMatrix);a("c",0,0,-1);a("t",0,0,1);a("n1",-1,-1,-1);a("n2",1,-1,-1);a("n3",-1,1,-1);a("n4",1,1,-1);a("f1",-1,-1,1);a("f2",1,-1,1);a("f3",-1,1,1);a("f4",1,1,1);a("u1",.7,1.1,-1);a("u2",-.7,1.1,
-1);a("u3",0,2,-1);a("cf1",-1,0,1);a("cf2",1,0,1);a("cf3",0,-1,1);a("cf4",0,1,1);a("cn1",-1,0,-1);a("cn2",1,0,-1);a("cn3",0,-1,-1);a("cn4",0,1,-1);b.verticesNeedUpdate=!0}}();
THREE.DirectionalLightHelper=function(a,b){THREE.Object3D.call(this);this.light=a;this.light.updateMatrixWorld();this.matrix=a.matrixWorld;this.matrixAutoUpdate=!1;b=b||1;var c=new THREE.Geometry;c.vertices.push(new THREE.Vector3(-b,b,0),new THREE.Vector3(b,b,0),new THREE.Vector3(b,-b,0),new THREE.Vector3(-b,-b,0),new THREE.Vector3(-b,b,0));var d=new THREE.LineBasicMaterial({fog:!1});d.color.copy(this.light.color).multiplyScalar(this.light.intensity);this.lightPlane=new THREE.Line(c,d);this.add(this.lightPlane);
c=new THREE.Geometry;c.vertices.push(new THREE.Vector3,new THREE.Vector3);d=new THREE.LineBasicMaterial({fog:!1});d.color.copy(this.light.color).multiplyScalar(this.light.intensity);this.targetLine=new THREE.Line(c,d);this.add(this.targetLine);this.update()};THREE.DirectionalLightHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.DirectionalLightHelper.prototype.constructor=THREE.DirectionalLightHelper;
THREE.DirectionalLightHelper.prototype.dispose=function(){this.lightPlane.geometry.dispose();this.lightPlane.material.dispose();this.targetLine.geometry.dispose();this.targetLine.material.dispose()};
THREE.DirectionalLightHelper.prototype.update=function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Vector3;return function(){a.setFromMatrixPosition(this.light.matrixWorld);b.setFromMatrixPosition(this.light.target.matrixWorld);c.subVectors(b,a);this.lightPlane.lookAt(c);this.lightPlane.material.color.copy(this.light.color).multiplyScalar(this.light.intensity);this.targetLine.geometry.vertices[1].copy(c);this.targetLine.geometry.verticesNeedUpdate=!0;this.targetLine.material.color.copy(this.lightPlane.material.color)}}();
THREE.EdgesHelper=function(a,b,c){b=void 0!==b?b:16777215;THREE.LineSegments.call(this,new THREE.EdgesGeometry(a.geometry,c),new THREE.LineBasicMaterial({color:b}));this.matrix=a.matrixWorld;this.matrixAutoUpdate=!1};THREE.EdgesHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.EdgesHelper.prototype.constructor=THREE.EdgesHelper;
THREE.FaceNormalsHelper=function(a,b,c,d){this.object=a;this.size=void 0!==b?b:1;a=void 0!==c?c:16776960;d=void 0!==d?d:1;b=0;c=this.object.geometry;c instanceof THREE.Geometry?b=c.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead.");c=new THREE.BufferGeometry;b=new THREE.Float32Attribute(6*b,3);c.addAttribute("position",b);THREE.LineSegments.call(this,c,new THREE.LineBasicMaterial({color:a,linewidth:d}));this.matrixAutoUpdate=
!1;this.update()};THREE.FaceNormalsHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.FaceNormalsHelper.prototype.constructor=THREE.FaceNormalsHelper;
THREE.FaceNormalsHelper.prototype.update=function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Matrix3;return function(){this.object.updateMatrixWorld(!0);c.getNormalMatrix(this.object.matrixWorld);for(var d=this.object.matrixWorld,e=this.geometry.attributes.position,f=this.object.geometry,g=f.vertices,f=f.faces,h=0,k=0,l=f.length;k<l;k++){var n=f[k],p=n.normal;a.copy(g[n.a]).add(g[n.b]).add(g[n.c]).divideScalar(3).applyMatrix4(d);b.copy(p).applyMatrix3(c).normalize().multiplyScalar(this.size).add(a);
e.setXYZ(h,a.x,a.y,a.z);h+=1;e.setXYZ(h,b.x,b.y,b.z);h+=1}e.needsUpdate=!0;return this}}();
THREE.GridHelper=function(a,b){var c=new THREE.Geometry,d=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors});this.color1=new THREE.Color(4473924);this.color2=new THREE.Color(8947848);for(var e=-a;e<=a;e+=b){c.vertices.push(new THREE.Vector3(-a,0,e),new THREE.Vector3(a,0,e),new THREE.Vector3(e,0,-a),new THREE.Vector3(e,0,a));var f=0===e?this.color1:this.color2;c.colors.push(f,f,f,f)}THREE.LineSegments.call(this,c,d)};THREE.GridHelper.prototype=Object.create(THREE.LineSegments.prototype);
THREE.GridHelper.prototype.constructor=THREE.GridHelper;THREE.GridHelper.prototype.setColors=function(a,b){this.color1.set(a);this.color2.set(b);this.geometry.colorsNeedUpdate=!0};
THREE.HemisphereLightHelper=function(a,b){THREE.Object3D.call(this);this.light=a;this.light.updateMatrixWorld();this.matrix=a.matrixWorld;this.matrixAutoUpdate=!1;this.colors=[new THREE.Color,new THREE.Color];var c=new THREE.SphereGeometry(b,4,2);c.rotateX(-Math.PI/2);for(var d=0;8>d;d++)c.faces[d].color=this.colors[4>d?0:1];d=new THREE.MeshBasicMaterial({vertexColors:THREE.FaceColors,wireframe:!0});this.lightSphere=new THREE.Mesh(c,d);this.add(this.lightSphere);this.update()};
THREE.HemisphereLightHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.HemisphereLightHelper.prototype.constructor=THREE.HemisphereLightHelper;THREE.HemisphereLightHelper.prototype.dispose=function(){this.lightSphere.geometry.dispose();this.lightSphere.material.dispose()};
THREE.HemisphereLightHelper.prototype.update=function(){var a=new THREE.Vector3;return function(){this.colors[0].copy(this.light.color).multiplyScalar(this.light.intensity);this.colors[1].copy(this.light.groundColor).multiplyScalar(this.light.intensity);this.lightSphere.lookAt(a.setFromMatrixPosition(this.light.matrixWorld).negate());this.lightSphere.geometry.colorsNeedUpdate=!0}}();
THREE.PointLightHelper=function(a,b){this.light=a;this.light.updateMatrixWorld();var c=new THREE.SphereGeometry(b,4,2),d=new THREE.MeshBasicMaterial({wireframe:!0,fog:!1});d.color.copy(this.light.color).multiplyScalar(this.light.intensity);THREE.Mesh.call(this,c,d);this.matrix=this.light.matrixWorld;this.matrixAutoUpdate=!1};THREE.PointLightHelper.prototype=Object.create(THREE.Mesh.prototype);THREE.PointLightHelper.prototype.constructor=THREE.PointLightHelper;
THREE.PointLightHelper.prototype.dispose=function(){this.geometry.dispose();this.material.dispose()};THREE.PointLightHelper.prototype.update=function(){this.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)};
THREE.SkeletonHelper=function(a){this.bones=this.getBoneList(a);for(var b=new THREE.Geometry,c=0;c<this.bones.length;c++)this.bones[c].parent instanceof THREE.Bone&&(b.vertices.push(new THREE.Vector3),b.vertices.push(new THREE.Vector3),b.colors.push(new THREE.Color(0,0,1)),b.colors.push(new THREE.Color(0,1,0)));b.dynamic=!0;c=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,depthTest:!1,depthWrite:!1,transparent:!0});THREE.LineSegments.call(this,b,c);this.root=a;this.matrix=a.matrixWorld;
this.matrixAutoUpdate=!1;this.update()};THREE.SkeletonHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.SkeletonHelper.prototype.constructor=THREE.SkeletonHelper;THREE.SkeletonHelper.prototype.getBoneList=function(a){var b=[];a instanceof THREE.Bone&&b.push(a);for(var c=0;c<a.children.length;c++)b.push.apply(b,this.getBoneList(a.children[c]));return b};
THREE.SkeletonHelper.prototype.update=function(){for(var a=this.geometry,b=(new THREE.Matrix4).getInverse(this.root.matrixWorld),c=new THREE.Matrix4,d=0,e=0;e<this.bones.length;e++){var f=this.bones[e];f.parent instanceof THREE.Bone&&(c.multiplyMatrices(b,f.matrixWorld),a.vertices[d].setFromMatrixPosition(c),c.multiplyMatrices(b,f.parent.matrixWorld),a.vertices[d+1].setFromMatrixPosition(c),d+=2)}a.verticesNeedUpdate=!0;a.computeBoundingSphere()};
THREE.SpotLightHelper=function(a){THREE.Object3D.call(this);this.light=a;this.light.updateMatrixWorld();this.matrix=a.matrixWorld;this.matrixAutoUpdate=!1;a=new THREE.BufferGeometry;for(var b=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],c=0,d=1;32>c;c++,d++){var e=c/32*Math.PI*2,f=d/32*Math.PI*2;b.push(Math.cos(e),Math.sin(e),1,Math.cos(f),Math.sin(f),1)}a.addAttribute("position",new THREE.Float32Attribute(b,3));b=new THREE.LineBasicMaterial({fog:!1});this.cone=new THREE.LineSegments(a,
b);this.add(this.cone);this.update()};THREE.SpotLightHelper.prototype=Object.create(THREE.Object3D.prototype);THREE.SpotLightHelper.prototype.constructor=THREE.SpotLightHelper;THREE.SpotLightHelper.prototype.dispose=function(){this.cone.geometry.dispose();this.cone.material.dispose()};
THREE.SpotLightHelper.prototype.update=function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(){var c=this.light.distance?this.light.distance:1E3,d=c*Math.tan(this.light.angle);this.cone.scale.set(d,d,c);a.setFromMatrixPosition(this.light.matrixWorld);b.setFromMatrixPosition(this.light.target.matrixWorld);this.cone.lookAt(b.sub(a));this.cone.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)}}();
THREE.VertexNormalsHelper=function(a,b,c,d){this.object=a;this.size=void 0!==b?b:1;a=void 0!==c?c:16711680;d=void 0!==d?d:1;b=0;c=this.object.geometry;c instanceof THREE.Geometry?b=3*c.faces.length:c instanceof THREE.BufferGeometry&&(b=c.attributes.normal.count);c=new THREE.BufferGeometry;b=new THREE.Float32Attribute(6*b,3);c.addAttribute("position",b);THREE.LineSegments.call(this,c,new THREE.LineBasicMaterial({color:a,linewidth:d}));this.matrixAutoUpdate=!1;this.update()};
THREE.VertexNormalsHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.VertexNormalsHelper.prototype.constructor=THREE.VertexNormalsHelper;
THREE.VertexNormalsHelper.prototype.update=function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Matrix3;return function(){var d=["a","b","c"];this.object.updateMatrixWorld(!0);c.getNormalMatrix(this.object.matrixWorld);var e=this.object.matrixWorld,f=this.geometry.attributes.position,g=this.object.geometry;if(g instanceof THREE.Geometry)for(var h=g.vertices,k=g.faces,l=g=0,n=k.length;l<n;l++)for(var p=k[l],m=0,q=p.vertexNormals.length;m<q;m++){var r=p.vertexNormals[m];a.copy(h[p[d[m]]]).applyMatrix4(e);
b.copy(r).applyMatrix3(c).normalize().multiplyScalar(this.size).add(a);f.setXYZ(g,a.x,a.y,a.z);g+=1;f.setXYZ(g,b.x,b.y,b.z);g+=1}else if(g instanceof THREE.BufferGeometry)for(d=g.attributes.position,h=g.attributes.normal,m=g=0,q=d.count;m<q;m++)a.set(d.getX(m),d.getY(m),d.getZ(m)).applyMatrix4(e),b.set(h.getX(m),h.getY(m),h.getZ(m)),b.applyMatrix3(c).normalize().multiplyScalar(this.size).add(a),f.setXYZ(g,a.x,a.y,a.z),g+=1,f.setXYZ(g,b.x,b.y,b.z),g+=1;f.needsUpdate=!0;return this}}();
THREE.WireframeHelper=function(a,b){var c=void 0!==b?b:16777215;THREE.LineSegments.call(this,new THREE.WireframeGeometry(a.geometry),new THREE.LineBasicMaterial({color:c}));this.matrix=a.matrixWorld;this.matrixAutoUpdate=!1};THREE.WireframeHelper.prototype=Object.create(THREE.LineSegments.prototype);THREE.WireframeHelper.prototype.constructor=THREE.WireframeHelper;THREE.ImmediateRenderObject=function(a){THREE.Object3D.call(this);this.material=a;this.render=function(a){}};
THREE.ImmediateRenderObject.prototype=Object.create(THREE.Object3D.prototype);THREE.ImmediateRenderObject.prototype.constructor=THREE.ImmediateRenderObject;THREE.MorphBlendMesh=function(a,b){THREE.Mesh.call(this,a,b);this.animationsMap={};this.animationsList=[];var c=this.geometry.morphTargets.length;this.createAnimation("__default",0,c-1,c/1);this.setAnimationWeight("__default",1)};THREE.MorphBlendMesh.prototype=Object.create(THREE.Mesh.prototype);THREE.MorphBlendMesh.prototype.constructor=THREE.MorphBlendMesh;
THREE.MorphBlendMesh.prototype.createAnimation=function(a,b,c,d){b={start:b,end:c,length:c-b+1,fps:d,duration:(c-b)/d,lastFrame:0,currentFrame:0,active:!1,time:0,direction:1,weight:1,directionBackwards:!1,mirroredLoop:!1};this.animationsMap[a]=b;this.animationsList.push(b)};
THREE.MorphBlendMesh.prototype.autoCreateAnimations=function(a){for(var b=/([a-z]+)_?(\d+)/i,c,d={},e=this.geometry,f=0,g=e.morphTargets.length;f<g;f++){var h=e.morphTargets[f].name.match(b);if(h&&1<h.length){var k=h[1];d[k]||(d[k]={start:Infinity,end:-Infinity});h=d[k];f<h.start&&(h.start=f);f>h.end&&(h.end=f);c||(c=k)}}for(k in d)h=d[k],this.createAnimation(k,h.start,h.end,a);this.firstAnimation=c};
THREE.MorphBlendMesh.prototype.setAnimationDirectionForward=function(a){if(a=this.animationsMap[a])a.direction=1,a.directionBackwards=!1};THREE.MorphBlendMesh.prototype.setAnimationDirectionBackward=function(a){if(a=this.animationsMap[a])a.direction=-1,a.directionBackwards=!0};THREE.MorphBlendMesh.prototype.setAnimationFPS=function(a,b){var c=this.animationsMap[a];c&&(c.fps=b,c.duration=(c.end-c.start)/c.fps)};
THREE.MorphBlendMesh.prototype.setAnimationDuration=function(a,b){var c=this.animationsMap[a];c&&(c.duration=b,c.fps=(c.end-c.start)/c.duration)};THREE.MorphBlendMesh.prototype.setAnimationWeight=function(a,b){var c=this.animationsMap[a];c&&(c.weight=b)};THREE.MorphBlendMesh.prototype.setAnimationTime=function(a,b){var c=this.animationsMap[a];c&&(c.time=b)};THREE.MorphBlendMesh.prototype.getAnimationTime=function(a){var b=0;if(a=this.animationsMap[a])b=a.time;return b};
THREE.MorphBlendMesh.prototype.getAnimationDuration=function(a){var b=-1;if(a=this.animationsMap[a])b=a.duration;return b};THREE.MorphBlendMesh.prototype.playAnimation=function(a){var b=this.animationsMap[a];b?(b.time=0,b.active=!0):console.warn("THREE.MorphBlendMesh: animation["+a+"] undefined in .playAnimation()")};THREE.MorphBlendMesh.prototype.stopAnimation=function(a){if(a=this.animationsMap[a])a.active=!1};
THREE.MorphBlendMesh.prototype.update=function(a){for(var b=0,c=this.animationsList.length;b<c;b++){var d=this.animationsList[b];if(d.active){var e=d.duration/d.length;d.time+=d.direction*a;if(d.mirroredLoop){if(d.time>d.duration||0>d.time)d.direction*=-1,d.time>d.duration&&(d.time=d.duration,d.directionBackwards=!0),0>d.time&&(d.time=0,d.directionBackwards=!1)}else d.time%=d.duration,0>d.time&&(d.time+=d.duration);var f=d.start+THREE.Math.clamp(Math.floor(d.time/e),0,d.length-1),g=d.weight;f!==d.currentFrame&&
(this.morphTargetInfluences[d.lastFrame]=0,this.morphTargetInfluences[d.currentFrame]=1*g,this.morphTargetInfluences[f]=0,d.lastFrame=d.currentFrame,d.currentFrame=f);e=d.time%e/e;d.directionBackwards&&(e=1-e);d.currentFrame!==d.lastFrame?(this.morphTargetInfluences[d.currentFrame]=e*g,this.morphTargetInfluences[d.lastFrame]=(1-e)*g):this.morphTargetInfluences[d.currentFrame]=g}}};THREE.TypedArrayUtils={};
THREE.TypedArrayUtils.quicksortIP=function(){var a=new Float32Array(4),b=new Float32Array(4);return function(c,d,e,f,g){g=(g||c.length/d)-1;var h=[],k=-1;f=f||0;for(var l=0,n=0,p=0,m=function(a,b){a*=d;b*=d;for(p=0;p<d;p++)l=c[a+p],c[a+p]=c[b+p],c[b+p]=l},q,r;;)if(25>=g-f){for(r=f+1;r<=g;r++){for(n=0;n<d;n++)a[n]=c[r*d+n];for(q=r-1;q>=f&&c[q*d+e]>a[e];){for(n=0;n<d;n++)c[(q+1)*d+n]=c[q*d+n];q--}for(n=0;n<d;n++)c[(q+1)*d+n]=a[n]}if(-1==k)break;g=h[k--];f=h[k--]}else{n=f+g>>1;q=f+1;r=g;m(n,q);c[f*d+
e]>c[g*d+e]&&m(f,g);c[q*d+e]>c[g*d+e]&&m(q,g);c[f*d+e]>c[q*d+e]&&m(f,q);for(n=0;n<d;n++)b[n]=c[q*d+n];for(;;){do q++;while(c[q*d+e]<b[e]);do r--;while(c[r*d+e]>b[e]);if(r<q)break;m(q,r)}for(n=0;n<d;n++)c[(f+1)*d+n]=c[r*d+n],c[r*d+n]=b[n];g-q+1>=r-f?(h[++k]=q,h[++k]=g,g=r-1):(h[++k]=f,h[++k]=r-1,f=q)}return c}}();
THREE.TypedArrayUtils.Kdtree=function(a,b,c,d){function e(b,f,n,p){var m=b%c,q=p-n;b>h&&(h=b);if(0===q)return null;1===q&&new g.Node((0+n)*c,f);m<d&&THREE.TypedArrayUtils.quicksortIP(a,c,m,n,p);m=Math.floor(q/2);f=new g.Node((m+n)*c,f);f.left=e(b+1,f,n,n+m);f.right=e(b+1,f,n+m+1,p);return f}function f(a){return null===a.parent?0:f(a.parent)+1}var g=this,h=0;this.root=e(0,null,0,a.length/c);this.getMaxDepth=function(){return h};this.nearest=function(e,h,n){function p(g){var m;m=f(g)%c;for(var q=[a[g.pos+
0],a[g.pos+1],a[g.pos+2]],s=b(e,q),w=0,B=[],w=0;w<d;w+=1)w===f(g)%c?B[w]=e[w]:B[w]=a[g.pos+w];w=b(B,q);null===g.right&&null===g.left?(r.size()<h||s<r.peek()[1])&&s<n&&(r.push([g,s]),r.size()>h&&r.pop()):(m=null===g.right?g.left:null===g.left?g.right:e[m]<a[g.pos+m]?g.left:g.right,p(m),(r.size()<h||s<r.peek()[1])&&s<=n&&(r.push([g,s]),r.size()>h&&r.pop()),(r.size()<h||Math.abs(w)<r.peek()[1])&&Math.abs(w)<=n&&(g=m===g.left?g.right:g.left,null!==g&&p(g)))}var m,q,r;r=new THREE.TypedArrayUtils.Kdtree.BinaryHeap(function(a){return-a[1]});
p(g.root);q=[];for(m=0;m<Math.min(r.size(),h);m+=1){var s=r.content[m];s&&s[0]&&q.push([s[0],s[1]])}return q}};THREE.TypedArrayUtils.Kdtree.prototype.Node=function(a,b){this.pos=a;this.right=this.left=null;this.parent=b};THREE.TypedArrayUtils.Kdtree.BinaryHeap=function(a){this.content=[];this.scoreFunction=a};
THREE.TypedArrayUtils.Kdtree.BinaryHeap.prototype={push:function(a){this.content.push(a);this.bubbleUp(this.content.length-1)},pop:function(){var a=this.content[0],b=this.content.pop();0<this.content.length&&(this.content[0]=b,this.sinkDown(0));return a},peek:function(){return this.content[0]},remove:function(a){for(var b=this.content.length,c=0;c<b;c++)if(this.content[c]==a){var d=this.content.pop();c!=b-1&&(this.content[c]=d,this.scoreFunction(d)<this.scoreFunction(a)?this.bubbleUp(c):this.sinkDown(c));
return}throw Error("Node not found.");},size:function(){return this.content.length},bubbleUp:function(a){for(var b=this.content[a];0<a;){var c=Math.floor((a+1)/2)-1,d=this.content[c];if(this.scoreFunction(b)<this.scoreFunction(d))this.content[c]=b,this.content[a]=d,a=c;else break}},sinkDown:function(a){for(var b=this.content.length,c=this.content[a],d=this.scoreFunction(c);;){var e=2*(a+1),f=e-1,g=null;if(f<b){var h=this.scoreFunction(this.content[f]);h<d&&(g=f)}e<b&&this.scoreFunction(this.content[e])<
(null===g?d:h)&&(g=e);if(null!==g)this.content[a]=this.content[g],this.content[g]=c,a=g;else break}}};
THREE.TrackballControls=function(a,b){function c(a){!1!==m.enabled&&(u=s,s===q.NONE)&&(a.keyCode!==m.keys[q.ROTATE]||m.noRotate?a.keyCode!==m.keys[q.ZOOM]||m.noZoom?a.keyCode!==m.keys[q.PAN]||m.noPan||(s=q.PAN):s=q.ZOOM:s=q.ROTATE)}function d(a){!1!==m.enabled&&(s=u)}function e(a){!1!==m.enabled&&(s===q.NONE&&(s=a.button),s!==q.ROTATE||m.noRotate?s!==q.ZOOM||m.noZoom?s!==q.PAN||m.noPan||(D.copy(I(a.pageX,a.pageY)),H.copy(D)):(z.copy(I(a.pageX,a.pageY)),y.copy(z)):(A.copy(L(a.pageX,a.pageY)),x.copy(A)),
document.addEventListener("mousemove",f,!1),document.addEventListener("mouseup",g,!1),m.dispatchEvent(K))}function f(a){!1!==m.enabled&&(s!==q.ROTATE||m.noRotate?s!==q.ZOOM||m.noZoom?s!==q.PAN||m.noPan||H.copy(I(a.pageX,a.pageY)):y.copy(I(a.pageX,a.pageY)):(x.copy(A),A.copy(L(a.pageX,a.pageY))))}function g(a){!1!==m.enabled&&(s=q.NONE,document.removeEventListener("mousemove",f),document.removeEventListener("mouseup",g),m.dispatchEvent(P))}function h(a){if(!1!==m.enabled){var b=0;a.wheelDelta?b=a.wheelDelta/
40:a.detail&&(b=-a.detail/3);z.y+=.01*b;m.dispatchEvent(K);m.dispatchEvent(P)}}function k(a){if(!1!==m.enabled){switch(a.touches.length){case 1:s=q.TOUCH_ROTATE;A.copy(L(a.touches[0].pageX,a.touches[0].pageY));x.copy(A);break;default:s=q.TOUCH_ZOOM_PAN;var b=a.touches[0].pageX-a.touches[1].pageX,c=a.touches[0].pageY-a.touches[1].pageY;J=C=Math.sqrt(b*b+c*c);D.copy(I((a.touches[0].pageX+a.touches[1].pageX)/2,(a.touches[0].pageY+a.touches[1].pageY)/2));H.copy(D)}m.dispatchEvent(K)}}function l(a){if(!1!==
m.enabled)switch(a.touches.length){case 1:x.copy(A);A.copy(L(a.touches[0].pageX,a.touches[0].pageY));break;default:var b=a.touches[0].pageX-a.touches[1].pageX,c=a.touches[0].pageY-a.touches[1].pageY;J=Math.sqrt(b*b+c*c);H.copy(I((a.touches[0].pageX+a.touches[1].pageX)/2,(a.touches[0].pageY+a.touches[1].pageY)/2))}}function n(a){if(!1!==m.enabled){switch(a.touches.length){case 0:s=q.NONE;break;case 1:s=q.TOUCH_ROTATE,A.copy(L(a.touches[0].pageX,a.touches[0].pageY)),x.copy(A)}m.dispatchEvent(P)}}function p(a){a.preventDefault()}
var m=this,q={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM_PAN:4};this.object=a;this.domElement=void 0!==b?b:document;this.enabled=!0;this.screen={left:0,top:0,width:0,height:0};this.rotateSpeed=1;this.zoomSpeed=1.2;this.panSpeed=.3;this.staticMoving=this.noPan=this.noZoom=this.noRotate=!1;this.dynamicDampingFactor=.2;this.minDistance=0;this.maxDistance=Infinity;this.keys=[65,83,68];this.target=new THREE.Vector3;var r=new THREE.Vector3,s=q.NONE,u=q.NONE,v=new THREE.Vector3,x=new THREE.Vector2,
A=new THREE.Vector2,w=new THREE.Vector3,B=0,z=new THREE.Vector2,y=new THREE.Vector2,C=0,J=0,D=new THREE.Vector2,H=new THREE.Vector2;this.target0=this.target.clone();this.position0=this.object.position.clone();this.up0=this.object.up.clone();var G={type:"change"},K={type:"start"},P={type:"end"};this.handleResize=function(){if(this.domElement===document)this.screen.left=0,this.screen.top=0,this.screen.width=window.innerWidth,this.screen.height=window.innerHeight;else{var a=this.domElement.getBoundingClientRect(),
b=this.domElement.ownerDocument.documentElement;this.screen.left=a.left+window.pageXOffset-b.clientLeft;this.screen.top=a.top+window.pageYOffset-b.clientTop;this.screen.width=a.width;this.screen.height=a.height}};this.handleEvent=function(a){if("function"==typeof this[a.type])this[a.type](a)};var I=function(){var a=new THREE.Vector2;return function(b,c){a.set((b-m.screen.left)/m.screen.width,(c-m.screen.top)/m.screen.height);return a}}(),L=function(){var a=new THREE.Vector2;return function(b,c){a.set((b-
.5*m.screen.width-m.screen.left)/(.5*m.screen.width),(m.screen.height+2*(m.screen.top-c))/m.screen.width);return a}}();this.rotateCamera=function(){var a=new THREE.Vector3,b=new THREE.Quaternion,c=new THREE.Vector3,d=new THREE.Vector3,e=new THREE.Vector3,f=new THREE.Vector3,g;return function(){f.set(A.x-x.x,A.y-x.y,0);(g=f.length())?(v.copy(m.object.position).sub(m.target),c.copy(v).normalize(),d.copy(m.object.up).normalize(),e.crossVectors(d,c).normalize(),d.setLength(A.y-x.y),e.setLength(A.x-x.x),
f.copy(d.add(e)),a.crossVectors(f,v).normalize(),g*=m.rotateSpeed,b.setFromAxisAngle(a,g),v.applyQuaternion(b),m.object.up.applyQuaternion(b),w.copy(a),B=g):!m.staticMoving&&B&&(B*=Math.sqrt(1-m.dynamicDampingFactor),v.copy(m.object.position).sub(m.target),b.setFromAxisAngle(w,B),v.applyQuaternion(b),m.object.up.applyQuaternion(b));x.copy(A)}}();this.zoomCamera=function(){var a;s===q.TOUCH_ZOOM_PAN?(a=C/J,C=J,v.multiplyScalar(a)):(a=1+(y.y-z.y)*m.zoomSpeed,1!==a&&0<a&&(v.multiplyScalar(a),m.staticMoving?
z.copy(y):z.y+=(y.y-z.y)*this.dynamicDampingFactor))};this.panCamera=function(){var a=new THREE.Vector2,b=new THREE.Vector3,c=new THREE.Vector3;return function(){a.copy(H).sub(D);a.lengthSq()&&(a.multiplyScalar(v.length()*m.panSpeed),c.copy(v).cross(m.object.up).setLength(a.x),c.add(b.copy(m.object.up).setLength(a.y)),m.object.position.add(c),m.target.add(c),m.staticMoving?D.copy(H):D.add(a.subVectors(H,D).multiplyScalar(m.dynamicDampingFactor)))}}();this.checkDistances=function(){m.noZoom&&m.noPan||
(v.lengthSq()>m.maxDistance*m.maxDistance&&(m.object.position.addVectors(m.target,v.setLength(m.maxDistance)),z.copy(y)),v.lengthSq()<m.minDistance*m.minDistance&&(m.object.position.addVectors(m.target,v.setLength(m.minDistance)),z.copy(y)))};this.update=function(){v.subVectors(m.object.position,m.target);m.noRotate||m.rotateCamera();m.noZoom||m.zoomCamera();m.noPan||m.panCamera();m.object.position.addVectors(m.target,v);m.checkDistances();m.object.lookAt(m.target);1E-6<r.distanceToSquared(m.object.position)&&
(m.dispatchEvent(G),r.copy(m.object.position))};this.reset=function(){u=s=q.NONE;m.target.copy(m.target0);m.object.position.copy(m.position0);m.object.up.copy(m.up0);v.subVectors(m.object.position,m.target);m.object.lookAt(m.target);m.dispatchEvent(G);r.copy(m.object.position)};this.dispose=function(){this.domElement.removeEventListener("contextmenu",p,!1);this.domElement.removeEventListener("mousedown",e,!1);this.domElement.removeEventListener("mousewheel",h,!1);this.domElement.removeEventListener("MozMousePixelScroll",
h,!1);this.domElement.removeEventListener("touchstart",k,!1);this.domElement.removeEventListener("touchend",n,!1);this.domElement.removeEventListener("touchmove",l,!1);document.removeEventListener("mousemove",f,!1);document.removeEventListener("mouseup",g,!1);window.removeEventListener("keydown",c,!1);window.removeEventListener("keyup",d,!1)};this.domElement.addEventListener("contextmenu",p,!1);this.domElement.addEventListener("mousedown",e,!1);this.domElement.addEventListener("mousewheel",h,!1);
this.domElement.addEventListener("MozMousePixelScroll",h,!1);this.domElement.addEventListener("touchstart",k,!1);this.domElement.addEventListener("touchend",n,!1);this.domElement.addEventListener("touchmove",l,!1);window.addEventListener("keydown",c,!1);window.addEventListener("keyup",d,!1);this.handleResize();this.update()};THREE.TrackballControls.prototype=Object.create(THREE.EventDispatcher.prototype);THREE.TrackballControls.prototype.constructor=THREE.TrackballControls;
THREE.OBJLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this.materials=null;this.regexp={vertex_pattern:/^v\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)/,normal_pattern:/^vn\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)/,uv_pattern:/^vt\s+([\d|\.|\+|\-|e|E]+)\s+([\d|\.|\+|\-|e|E]+)/,face_vertex:/^f\s+(-?\d+)\s+(-?\d+)\s+(-?\d+)(?:\s+(-?\d+))?/,face_vertex_uv:/^f\s+(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)(?:\s+(-?\d+)\/(-?\d+))?/,
face_vertex_uv_normal:/^f\s+(-?\d+)\/(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\/(-?\d+)\s+(-?\d+)\/(-?\d+)\/(-?\d+)(?:\s+(-?\d+)\/(-?\d+)\/(-?\d+))?/,face_vertex_normal:/^f\s+(-?\d+)\/\/(-?\d+)\s+(-?\d+)\/\/(-?\d+)\s+(-?\d+)\/\/(-?\d+)(?:\s+(-?\d+)\/\/(-?\d+))?/,object_pattern:/^[og]\s*(.+)?/,smoothing_pattern:/^s\s+(\d+|on|off)/,material_library_pattern:/^mtllib /,material_use_pattern:/^usemtl /}};
THREE.OBJLoader.prototype={constructor:THREE.OBJLoader,load:function(a,b,c,d){var e=this,f=new THREE.XHRLoader(e.manager);f.setPath(this.path);f.load(a,function(a){b(e.parse(a))},c,d)},setPath:function(a){this.path=a},setMaterials:function(a){this.materials=a},_createParserState:function(){var a={objects:[],object:{},vertices:[],normals:[],uvs:[],materialLibraries:[],startObject:function(a,c){this.object&&!1===this.object.fromDeclaration?(this.object.name=a,this.object.fromDeclaration=!1!==c):(this.object=
{name:a||"",geometry:{vertices:[],normals:[],uvs:[]},material:{name:"",smooth:!0},fromDeclaration:!1!==c},this.objects.push(this.object))},parseVertexIndex:function(a,c){var d=parseInt(a,10);return 3*(0<=d?d-1:d+c/3)},parseNormalIndex:function(a,c){var d=parseInt(a,10);return 3*(0<=d?d-1:d+c/3)},parseUVIndex:function(a,c){var d=parseInt(a,10);return 2*(0<=d?d-1:d+c/2)},addVertex:function(a,c,d){var e=this.vertices,f=this.object.geometry.vertices;f.push(e[a+0]);f.push(e[a+1]);f.push(e[a+2]);f.push(e[c+
0]);f.push(e[c+1]);f.push(e[c+2]);f.push(e[d+0]);f.push(e[d+1]);f.push(e[d+2])},addVertexLine:function(a){var c=this.vertices,d=this.object.geometry.vertices;d.push(c[a+0]);d.push(c[a+1]);d.push(c[a+2])},addNormal:function(a,c,d){var e=this.normals,f=this.object.geometry.normals;f.push(e[a+0]);f.push(e[a+1]);f.push(e[a+2]);f.push(e[c+0]);f.push(e[c+1]);f.push(e[c+2]);f.push(e[d+0]);f.push(e[d+1]);f.push(e[d+2])},addUV:function(a,c,d){var e=this.uvs,f=this.object.geometry.uvs;f.push(e[a+0]);f.push(e[a+
1]);f.push(e[c+0]);f.push(e[c+1]);f.push(e[d+0]);f.push(e[d+1])},addUVLine:function(a){var c=this.uvs,d=this.object.geometry.uvs;d.push(c[a+0]);d.push(c[a+1])},addFace:function(a,c,d,e,f,g,h,k,l,n,p,m){var q=this.vertices.length;a=this.parseVertexIndex(a,q);c=this.parseVertexIndex(c,q);d=this.parseVertexIndex(d,q);void 0===e?this.addVertex(a,c,d):(q=this.parseVertexIndex(e,q),this.addVertex(a,c,q),this.addVertex(c,d,q));void 0!==f&&(q=this.uvs.length,a=this.parseUVIndex(f,q),c=this.parseUVIndex(g,
q),d=this.parseUVIndex(h,q),void 0===e?this.addUV(a,c,d):(q=this.parseUVIndex(k,q),this.addUV(a,c,q),this.addUV(c,d,q)));void 0!==l&&(f=this.normals.length,a=this.parseNormalIndex(l,f),c=l===n?a:this.parseNormalIndex(n,f),d=l===p?a:this.parseNormalIndex(p,f),void 0===e?this.addNormal(a,c,d):(q=this.parseNormalIndex(m,f),this.addNormal(a,c,q),this.addNormal(c,d,q)))},addLineGeometry:function(a,c){this.object.geometry.type="Line";for(var d=this.vertices.length,e=this.uvs.length,f=0,g=a.length;f<g;f++)this.addVertexLine(this.parseVertexIndex(a[f],
d));d=0;for(g=c.length;d<g;d++)this.addUVLine(this.parseUVIndex(c[d],e))}};a.startObject("",!1);return a},parse:function(a){console.time("OBJLoader");var b=this._createParserState();-1!==a.indexOf("\r\n")&&(a=a.replace("\r\n","\n"));var c=a.split("\n"),d="",e="",e="",e=0,f=[],g="function"===typeof"".trimLeft;a=0;for(var h=c.length;a<h;a++)if(d=c[a],d=g?d.trimLeft():d.trim(),e=d.length,0!==e&&(e=d.charAt(0),"#"!==e))if("v"===e)if(e=d.charAt(1)," "===e&&null!==(f=this.regexp.vertex_pattern.exec(d)))b.vertices.push(parseFloat(f[1]),
parseFloat(f[2]),parseFloat(f[3]));else if("n"===e&&null!==(f=this.regexp.normal_pattern.exec(d)))b.normals.push(parseFloat(f[1]),parseFloat(f[2]),parseFloat(f[3]));else if("t"===e&&null!==(f=this.regexp.uv_pattern.exec(d)))b.uvs.push(parseFloat(f[1]),parseFloat(f[2]));else throw Error("Unexpected vertex/normal/uv line: '"+d+"'");else if("f"===e)if(null!==(f=this.regexp.face_vertex_uv_normal.exec(d)))b.addFace(f[1],f[4],f[7],f[10],f[2],f[5],f[8],f[11],f[3],f[6],f[9],f[12]);else if(null!==(f=this.regexp.face_vertex_uv.exec(d)))b.addFace(f[1],
f[3],f[5],f[7],f[2],f[4],f[6],f[8]);else if(null!==(f=this.regexp.face_vertex_normal.exec(d)))b.addFace(f[1],f[3],f[5],f[7],void 0,void 0,void 0,void 0,f[2],f[4],f[6],f[8]);else if(null!==(f=this.regexp.face_vertex.exec(d)))b.addFace(f[1],f[2],f[3],f[4]);else throw Error("Unexpected face line: '"+d+"'");else if("l"===e){var e=d.substring(1).trim().split(" "),k=[],l=[];if(-1===d.indexOf("/"))k=e;else for(var d=0,n=e.length;d<n;d++){var p=e[d].split("/");""!==p[0]&&k.push(p[0]);""!==p[1]&&l.push(p[1])}b.addLineGeometry(k,
l)}else if(null!==(f=this.regexp.object_pattern.exec(d)))d=f[0].substr(1).trim(),b.startObject(d);else if(this.regexp.material_use_pattern.test(d))b.object.material.name=d.substring(7).trim();else if(this.regexp.material_library_pattern.test(d))b.materialLibraries.push(d.substring(7).trim());else if(null!==(f=this.regexp.smoothing_pattern.exec(d)))d=f[1].trim().toLowerCase(),b.object.material.smooth="1"===d||"on"===d;else if("\x00"!==d)throw Error("Unexpected line: '"+d+"'");c=new THREE.Group;c.materialLibraries=
[].concat(b.materialLibraries);a=0;for(h=b.objects.length;a<h;a++)if(f=b.objects[a],e=f.geometry,g="Line"===e.type,0!==e.vertices.length){d=new THREE.BufferGeometry;d.addAttribute("position",new THREE.BufferAttribute(new Float32Array(e.vertices),3));0<e.normals.length?d.addAttribute("normal",new THREE.BufferAttribute(new Float32Array(e.normals),3)):d.computeVertexNormals();0<e.uvs.length&&d.addAttribute("uv",new THREE.BufferAttribute(new Float32Array(e.uvs),2));var m;null!==this.materials&&(m=this.materials.create(f.material.name),
!g||!m||m instanceof THREE.LineBasicMaterial||(e=new THREE.LineBasicMaterial,e.copy(m),m=e));m||(m=g?new THREE.LineBasicMaterial:new THREE.MeshPhongMaterial,m.name=f.material.name);m.shading=f.material.smooth?THREE.SmoothShading:THREE.FlatShading;g=g?new THREE.Line(d,m):new THREE.Mesh(d,m);g.name=f.name;c.add(g)}console.timeEnd("OBJLoader");return c}};THREE.PLYLoader=function(a){this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this.propertyNameMapping={}};
THREE.PLYLoader.prototype={constructor:THREE.PLYLoader,load:function(a,b,c,d){var e=this,f=new THREE.XHRLoader(this.manager);f.setResponseType("arraybuffer");f.load(a,function(a){b(e.parse(a))},c,d)},setPropertyNameMapping:function(a){this.propertyNameMapping=a},bin2str:function(a){for(var b=new Uint8Array(a),c="",d=0;d<a.byteLength;d++)c+=String.fromCharCode(b[d]);return c},isASCII:function(a){return"ascii"===this.parseHeader(this.bin2str(a)).format},parse:function(a){return a instanceof ArrayBuffer?
this.isASCII(a)?this.parseASCII(this.bin2str(a)):this.parseBinary(a):this.parseASCII(a)},parseHeader:function(a){function b(a,b){var c={type:a[0]};"list"===c.type?(c.name=a[3],c.countType=a[1],c.itemType=a[2]):c.name=a[1];c.name in b&&(c.name=b[c.name]);return c}var c="",d=0;a=/ply([\s\S]*)end_header\s/.exec(a);null!==a&&(c=a[1],d=a[0].length);d={comments:[],elements:[],headerLength:d};c=c.split("\n");a=void 0;for(var e,f,g=0;g<c.length;g++){var h=c[g],h=h.trim();if(""!==h)switch(f=h.split(/\s+/),
e=f.shift(),h=f.join(" "),e){case "format":d.format=f[0];d.version=f[1];break;case "comment":d.comments.push(h);break;case "element":void 0!==a&&d.elements.push(a);a={};a.name=f[0];a.count=parseInt(f[1]);a.properties=[];break;case "property":a.properties.push(b(f,this.propertyNameMapping));break;default:console.log("unhandled",e,f)}}void 0!==a&&d.elements.push(a);return d},parseASCIINumber:function(a,b){switch(b){case "char":case "uchar":case "short":case "ushort":case "int":case "uint":case "int8":case "uint8":case "int16":case "uint16":case "int32":case "uint32":return parseInt(a);
case "float":case "double":case "float32":case "float64":return parseFloat(a)}},parseASCIIElement:function(a,b){for(var c=b.split(/\s+/),d={},e=0;e<a.length;e++)if("list"===a[e].type){for(var f=[],g=this.parseASCIINumber(c.shift(),a[e].countType),h=0;h<g;h++)f.push(this.parseASCIINumber(c.shift(),a[e].itemType));d[a[e].name]=f}else d[a[e].name]=this.parseASCIINumber(c.shift(),a[e].type);return d},parseASCII:function(a){var b=new THREE.Geometry,c,d=this.parseHeader(a),e="";null!==(c=/end_header\s([\s\S]*)$/.exec(a))&&
(e=c[1]);a=e.split("\n");e=c=0;b.useColor=!1;for(var f=0;f<a.length;f++){var g=a[f],g=g.trim();""!==g&&(e>=d.elements[c].count&&(c++,e=0),g=this.parseASCIIElement(d.elements[c].properties,g),this.handleElement(b,d.elements[c].name,g),e++)}return this.postProcess(b)},postProcess:function(a){if(a.useColor){for(var b=0;b<a.faces.length;b++)a.faces[b].vertexColors=[a.colors[a.faces[b].a],a.colors[a.faces[b].b],a.colors[a.faces[b].c]];a.elementsNeedUpdate=!0}a.computeBoundingSphere();return a},handleElement:function(a,
b,c){"vertex"===b?(a.vertices.push(new THREE.Vector3(c.x,c.y,c.z)),"red"in c&&"green"in c&&"blue"in c&&(a.useColor=!0,b=new THREE.Color,b.setRGB(c.red/255,c.green/255,c.blue/255),a.colors.push(b))):"face"===b&&(c=c.vertex_indices,3===c.length?a.faces.push(new THREE.Face3(c[0],c[1],c[2])):4===c.length&&a.faces.push(new THREE.Face3(c[0],c[1],c[3]),new THREE.Face3(c[1],c[2],c[3])))},binaryRead:function(a,b,c,d){switch(c){case "int8":case "char":return[a.getInt8(b),1];case "uint8":case "uchar":return[a.getUint8(b),
1];case "int16":case "short":return[a.getInt16(b,d),2];case "uint16":case "ushort":return[a.getUint16(b,d),2];case "int32":case "int":return[a.getInt32(b,d),4];case "uint32":case "uint":return[a.getUint32(b,d),4];case "float32":case "float":return[a.getFloat32(b,d),4];case "float64":case "double":return[a.getFloat64(b,d),8]}},binaryReadElement:function(a,b,c,d){for(var e={},f,g=0,h=0;h<c.length;h++)if("list"===c[h].type){var k=[];f=this.binaryRead(a,b+g,c[h].countType,d);for(var l=f[0],g=g+f[1],n=
0;n<l;n++)f=this.binaryRead(a,b+g,c[h].itemType,d),k.push(f[0]),g+=f[1];e[c[h].name]=k}else f=this.binaryRead(a,b+g,c[h].type,d),e[c[h].name]=f[0],g+=f[1];return[e,g]},parseBinary:function(a){var b=new THREE.Geometry,c=this.parseHeader(this.bin2str(a)),d="binary_little_endian"===c.format;a=new DataView(a,c.headerLength);for(var e,f=0,g=0;g<c.elements.length;g++)for(var h=0;h<c.elements[g].count;h++)e=this.binaryReadElement(a,f,c.elements[g].properties,d),f+=e[1],this.handleElement(b,c.elements[g].name,
e[0]);return this.postProcess(b)}};

// File:js/build/lib.min.js

// File:js/lib/chroma.min.js

/*
chroma.js - JavaScript library for color conversions

Copyright (c) 2011-2015, Gregor Aisch
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. The name Gregor Aisch may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL GREGOR AISCH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/
(function(){var a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,_,aa,ba,ca,da,ea,fa,ga,ha,ia,ja,ka,la,ma,na,oa,pa,qa,ra,sa,ta,ua,va,wa,xa,ya,za=[].slice;ua=function(){var a,b,c,d,e;for(a={},e="Boolean Number String Function Array Date RegExp Undefined Null".split(" "),d=0,b=e.length;b>d;d++)c=e[d],a["[object "+c+"]"]=c.toLowerCase();return function(b){var c;return c=Object.prototype.toString.call(b),a[c]||"object"}}(),S=function(a,b,c){return null==b&&(b=0),null==c&&(c=1),b>a&&(a=b),a>c&&(a=c),a},va=function(a){return a.length>=3?[].slice.call(a):a[0]},t=function(a){var b;for(b in a)3>b?(a[b]<0&&(a[b]=0),a[b]>255&&(a[b]=255)):3===b&&(a[b]<0&&(a[b]=0),a[b]>1&&(a[b]=1));return a},d=Math.PI,pa=Math.round,w=Math.cos,B=Math.floor,_=Math.pow,T=Math.log,ra=Math.sin,sa=Math.sqrt,m=Math.atan2,W=Math.max,l=Math.abs,g=2*d,e=d/3,b=d/180,f=180/d,s=function(){return arguments[0]instanceof a?arguments[0]:function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,arguments,function(){})},k=[],"undefined"!=typeof module&&null!==module&&null!=module.exports&&(module.exports=s),"function"==typeof define&&define.amd?define([],function(){return s}):(oa="undefined"!=typeof exports&&null!==exports?exports:this,oa.chroma=s),s.version="1.1.1",j={},h=[],i=!1,a=function(){function a(){var a,b,c,d,e,f,g,k,l;for(f=this,b=[],k=0,d=arguments.length;d>k;k++)a=arguments[k],null!=a&&b.push(a);if(g=b[b.length-1],null!=j[g])f._rgb=t(j[g](va(b.slice(0,-1))));else{for(i||(h=h.sort(function(a,b){return b.p-a.p}),i=!0),l=0,e=h.length;e>l&&(c=h[l],!(g=c.test.apply(c,b)));l++);g&&(f._rgb=t(j[g].apply(j,b)))}null==f._rgb&&console.warn("unknown format: "+b),null==f._rgb&&(f._rgb=[0,0,0]),3===f._rgb.length&&f._rgb.push(1)}return a.prototype.alpha=function(a){return arguments.length?(this._rgb[3]=a,this):this._rgb[3]},a.prototype.toString=function(){return this.name()},a}(),s._input=j,s.brewer=q={OrRd:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"],PuBu:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"],BuPu:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"],Oranges:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"],BuGn:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"],YlOrBr:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"],YlGn:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"],Reds:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"],RdPu:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"],Greens:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"],YlGnBu:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"],Purples:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"],GnBu:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"],Greys:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"],YlOrRd:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"],PuRd:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"],Blues:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"],PuBuGn:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"],Spectral:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],RdYlGn:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],RdBu:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],PiYG:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],PRGn:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],RdYlBu:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],BrBG:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],RdGy:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],PuOr:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],Set2:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"],Accent:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"],Set1:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"],Set3:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"],Dark2:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"],Paired:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"],Pastel2:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"],Pastel1:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},wa={indigo:"#4b0082",gold:"#ffd700",hotpink:"#ff69b4",firebrick:"#b22222",indianred:"#cd5c5c",yellow:"#ffff00",mistyrose:"#ffe4e1",darkolivegreen:"#556b2f",olive:"#808000",darkseagreen:"#8fbc8f",pink:"#ffc0cb",tomato:"#ff6347",lightcoral:"#f08080",orangered:"#ff4500",navajowhite:"#ffdead",lime:"#00ff00",palegreen:"#98fb98",darkslategrey:"#2f4f4f",greenyellow:"#adff2f",burlywood:"#deb887",seashell:"#fff5ee",mediumspringgreen:"#00fa9a",fuchsia:"#ff00ff",papayawhip:"#ffefd5",blanchedalmond:"#ffebcd",chartreuse:"#7fff00",dimgray:"#696969",black:"#000000",peachpuff:"#ffdab9",springgreen:"#00ff7f",aquamarine:"#7fffd4",white:"#ffffff",orange:"#ffa500",lightsalmon:"#ffa07a",darkslategray:"#2f4f4f",brown:"#a52a2a",ivory:"#fffff0",dodgerblue:"#1e90ff",peru:"#cd853f",lawngreen:"#7cfc00",chocolate:"#d2691e",crimson:"#dc143c",forestgreen:"#228b22",darkgrey:"#a9a9a9",lightseagreen:"#20b2aa",cyan:"#00ffff",mintcream:"#f5fffa",silver:"#c0c0c0",antiquewhite:"#faebd7",mediumorchid:"#ba55d3",skyblue:"#87ceeb",gray:"#808080",darkturquoise:"#00ced1",goldenrod:"#daa520",darkgreen:"#006400",floralwhite:"#fffaf0",darkviolet:"#9400d3",darkgray:"#a9a9a9",moccasin:"#ffe4b5",saddlebrown:"#8b4513",grey:"#808080",darkslateblue:"#483d8b",lightskyblue:"#87cefa",lightpink:"#ffb6c1",mediumvioletred:"#c71585",slategrey:"#708090",red:"#ff0000",deeppink:"#ff1493",limegreen:"#32cd32",darkmagenta:"#8b008b",palegoldenrod:"#eee8aa",plum:"#dda0dd",turquoise:"#40e0d0",lightgrey:"#d3d3d3",lightgoldenrodyellow:"#fafad2",darkgoldenrod:"#b8860b",lavender:"#e6e6fa",maroon:"#800000",yellowgreen:"#9acd32",sandybrown:"#f4a460",thistle:"#d8bfd8",violet:"#ee82ee",navy:"#000080",magenta:"#ff00ff",dimgrey:"#696969",tan:"#d2b48c",rosybrown:"#bc8f8f",olivedrab:"#6b8e23",blue:"#0000ff",lightblue:"#add8e6",ghostwhite:"#f8f8ff",honeydew:"#f0fff0",cornflowerblue:"#6495ed",slateblue:"#6a5acd",linen:"#faf0e6",darkblue:"#00008b",powderblue:"#b0e0e6",seagreen:"#2e8b57",darkkhaki:"#bdb76b",snow:"#fffafa",sienna:"#a0522d",mediumblue:"#0000cd",royalblue:"#4169e1",lightcyan:"#e0ffff",green:"#008000",mediumpurple:"#9370db",midnightblue:"#191970",cornsilk:"#fff8dc",paleturquoise:"#afeeee",bisque:"#ffe4c4",slategray:"#708090",darkcyan:"#008b8b",khaki:"#f0e68c",wheat:"#f5deb3",teal:"#008080",darkorchid:"#9932cc",deepskyblue:"#00bfff",salmon:"#fa8072",darkred:"#8b0000",steelblue:"#4682b4",palevioletred:"#db7093",lightslategray:"#778899",aliceblue:"#f0f8ff",lightslategrey:"#778899",lightgreen:"#90ee90",orchid:"#da70d6",gainsboro:"#dcdcdc",mediumseagreen:"#3cb371",lightgray:"#d3d3d3",mediumturquoise:"#48d1cc",lemonchiffon:"#fffacd",cadetblue:"#5f9ea0",lightyellow:"#ffffe0",lavenderblush:"#fff0f5",coral:"#ff7f50",purple:"#800080",aqua:"#00ffff",whitesmoke:"#f5f5f5",mediumslateblue:"#7b68ee",darkorange:"#ff8c00",mediumaquamarine:"#66cdaa",darksalmon:"#e9967a",beige:"#f5f5dc",blueviolet:"#8a2be2",azure:"#f0ffff",lightsteelblue:"#b0c4de",oldlace:"#fdf5e6",rebeccapurple:"#663399"},s.colors=v=wa,N=function(){var a,b,d,e,f,g,h,i,j;return b=va(arguments),f=b[0],a=b[1],d=b[2],i=(f+16)/116,h=isNaN(a)?i:i+a/500,j=isNaN(d)?i:i-d/200,i=c.Yn*O(i),h=c.Xn*O(h),j=c.Zn*O(j),g=ya(3.2404542*h-1.5371385*i-.4985314*j),e=ya(-.969266*h+1.8760108*i+.041556*j),d=ya(.0556434*h-.2040259*i+1.0572252*j),g=S(g,0,255),e=S(e,0,255),d=S(d,0,255),[g,e,d,b.length>3?b[3]:1]},ya=function(a){return pa(255*(.00304>=a?12.92*a:1.055*_(a,1/2.4)-.055))},O=function(a){return a>c.t1?a*a*a:c.t2*(a-c.t0)},c={Kn:18,Xn:.95047,Yn:1,Zn:1.08883,t0:.137931034,t1:.206896552,t2:.12841855,t3:.008856452},ga=function(){var a,b,c,d,e,f,g,h;return d=va(arguments),c=d[0],b=d[1],a=d[2],e=la(c,b,a),f=e[0],g=e[1],h=e[2],[116*g-16,500*(f-g),200*(g-h)]},ma=function(a){return(a/=255)<=.04045?a/12.92:_((a+.055)/1.055,2.4)},xa=function(a){return a>c.t3?_(a,1/3):a/c.t2+c.t0},la=function(){var a,b,d,e,f,g,h;return e=va(arguments),d=e[0],b=e[1],a=e[2],d=ma(d),b=ma(b),a=ma(a),f=xa((.4124564*d+.3575761*b+.1804375*a)/c.Xn),g=xa((.2126729*d+.7151522*b+.072175*a)/c.Yn),h=xa((.0193339*d+.119192*b+.9503041*a)/c.Zn),[f,g,h]},s.lab=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["lab"]),function(){})},j.lab=N,a.prototype.lab=function(){return ga(this._rgb)},n=function(a){var b,c,d,e,f,g,h,i,j,k,l;return a=function(){var b,c,d;for(d=[],c=0,b=a.length;b>c;c++)e=a[c],d.push(s(e));return d}(),2===a.length?(j=function(){var b,c,d;for(d=[],c=0,b=a.length;b>c;c++)e=a[c],d.push(e.lab());return d}(),f=j[0],g=j[1],b=function(a){var b,c;return c=function(){var c,d;for(d=[],b=c=0;2>=c;b=++c)d.push(f[b]+a*(g[b]-f[b]));return d}(),s.lab.apply(s,c)}):3===a.length?(k=function(){var b,c,d;for(d=[],c=0,b=a.length;b>c;c++)e=a[c],d.push(e.lab());return d}(),f=k[0],g=k[1],h=k[2],b=function(a){var b,c;return c=function(){var c,d;for(d=[],b=c=0;2>=c;b=++c)d.push((1-a)*(1-a)*f[b]+2*(1-a)*a*g[b]+a*a*h[b]);return d}(),s.lab.apply(s,c)}):4===a.length?(l=function(){var b,c,d;for(d=[],c=0,b=a.length;b>c;c++)e=a[c],d.push(e.lab());return d}(),f=l[0],g=l[1],h=l[2],i=l[3],b=function(a){var b,c;return c=function(){var c,d;for(d=[],b=c=0;2>=c;b=++c)d.push((1-a)*(1-a)*(1-a)*f[b]+3*(1-a)*(1-a)*a*g[b]+3*(1-a)*a*a*h[b]+a*a*a*i[b]);return d}(),s.lab.apply(s,c)}):5===a.length&&(c=n(a.slice(0,3)),d=n(a.slice(2,5)),b=function(a){return.5>a?c(2*a):d(2*(a-.5))}),b},s.bezier=function(a){var b;return b=n(a),b.scale=function(){return s.scale(b)},b},s.cubehelix=function(a,b,c,d,e){var f,h,i;return null==a&&(a=300),null==b&&(b=-1.5),null==c&&(c=1),null==d&&(d=1),null==e&&(e=[0,1]),h=e[1]-e[0],f=0,i=function(i){var j,k,l,m,n,o,p,q,r;return j=g*((a+120)/360+b*i),p=_(e[0]+h*i,d),o=0!==f?c[0]+i*f:c,k=o*p*(1-p)/2,m=w(j),r=ra(j),q=p+k*(-.14861*m+1.78277*r),n=p+k*(-.29227*m-.90649*r),l=p+1.97294*k*m,s(t([255*q,255*n,255*l]))},i.start=function(b){return null==b?a:(a=b,i)},i.rotations=function(a){return null==a?b:(b=a,i)},i.gamma=function(a){return null==a?d:(d=a,i)},i.hue=function(a){return null==a?c:(c=a,"array"===ua(c)?(f=c[1]-c[0],0===f&&(c=c[1])):f=0,i)},i.lightness=function(a){return null==a?e:(e=a,"array"===ua(e)?(h=e[1]-e[0],0===h&&(e=e[1])):h=0,i)},i.scale=function(){return s.scale(i)},i.hue(c),i},s.random=function(){var b,c,d,e;for(c="0123456789abcdef",b="#",d=e=0;6>e;d=++e)b+=c.charAt(B(16*Math.random()));return new a(b)},j.rgb=function(){var a,b,c,d;b=va(arguments),c=[];for(a in b)d=b[a],c.push(d);return c},s.rgb=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["rgb"]),function(){})},a.prototype.rgb=function(){return this._rgb.slice(0,3)},a.prototype.rgba=function(){return this._rgb},h.push({p:15,test:function(a){var b;return b=va(arguments),"array"===ua(b)&&3===b.length?"rgb":4===b.length&&"number"===ua(b[3])&&b[3]>=0&&b[3]<=1?"rgb":void 0}}),C=function(a){var b,c,d,e,f,g;if(a.match(/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/))return(4===a.length||7===a.length)&&(a=a.substr(1)),3===a.length&&(a=a.split(""),a=a[0]+a[0]+a[1]+a[1]+a[2]+a[2]),g=parseInt(a,16),e=g>>16,d=g>>8&255,c=255&g,[e,d,c,1];if(a.match(/^#?([A-Fa-f0-9]{8})$/))return 9===a.length&&(a=a.substr(1)),g=parseInt(a,16),e=g>>24&255,d=g>>16&255,c=g>>8&255,b=pa((255&g)/255*100)/100,[e,d,c,b];if(null!=j.css&&(f=j.css(a)))return f;throw"unknown color: "+a},ca=function(a,b){var c,d,e,f,g,h,i;return null==b&&(b="rgb"),g=a[0],e=a[1],d=a[2],c=a[3],i=g<<16|e<<8|d,h="000000"+i.toString(16),h=h.substr(h.length-6),f="0"+pa(255*c).toString(16),f=f.substr(f.length-2),"#"+function(){switch(b.toLowerCase()){case"rgba":return h+f;case"argb":return f+h;default:return h}}()},j.hex=function(a){return C(a)},s.hex=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["hex"]),function(){})},a.prototype.hex=function(a){return null==a&&(a="rgb"),ca(this._rgb,a)},h.push({p:10,test:function(a){return 1===arguments.length&&"string"===ua(a)?"hex":void 0}}),F=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m,n;if(a=va(arguments),e=a[0],k=a[1],g=a[2],0===k)i=d=b=255*g;else{for(n=[0,0,0],c=[0,0,0],m=.5>g?g*(1+k):g+k-g*k,l=2*g-m,e/=360,n[0]=e+1/3,n[1]=e,n[2]=e-1/3,f=h=0;2>=h;f=++h)n[f]<0&&(n[f]+=1),n[f]>1&&(n[f]-=1),6*n[f]<1?c[f]=l+6*(m-l)*n[f]:2*n[f]<1?c[f]=m:3*n[f]<2?c[f]=l+(m-l)*(2/3-n[f])*6:c[f]=l;j=[pa(255*c[0]),pa(255*c[1]),pa(255*c[2])],i=j[0],d=j[1],b=j[2]}return a.length>3?[i,d,b,a[3]]:[i,d,b]},ea=function(a,b,c){var d,e,f,g,h;return void 0!==a&&a.length>=3&&(g=a,a=g[0],b=g[1],c=g[2]),a/=255,b/=255,c/=255,f=Math.min(a,b,c),W=Math.max(a,b,c),e=(W+f)/2,W===f?(h=0,d=Number.NaN):h=.5>e?(W-f)/(W+f):(W-f)/(2-W-f),a===W?d=(b-c)/(W-f):b===W?d=2+(c-a)/(W-f):c===W&&(d=4+(a-b)/(W-f)),d*=60,0>d&&(d+=360),[d,h,e]},s.hsl=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["hsl"]),function(){})},j.hsl=F,a.prototype.hsl=function(){return ea(this._rgb)},G=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;if(a=va(arguments),e=a[0],p=a[1],r=a[2],r*=255,0===p)i=d=b=r;else switch(360===e&&(e=0),e>360&&(e-=360),0>e&&(e+=360),e/=60,f=B(e),c=e-f,g=r*(1-p),h=r*(1-p*c),q=r*(1-p*(1-c)),f){case 0:j=[r,q,g],i=j[0],d=j[1],b=j[2];break;case 1:k=[h,r,g],i=k[0],d=k[1],b=k[2];break;case 2:l=[g,r,q],i=l[0],d=l[1],b=l[2];break;case 3:m=[g,h,r],i=m[0],d=m[1],b=m[2];break;case 4:n=[q,g,r],i=n[0],d=n[1],b=n[2];break;case 5:o=[r,g,h],i=o[0],d=o[1],b=o[2]}return i=pa(i),d=pa(d),b=pa(b),[i,d,b,a.length>3?a[3]:1]},fa=function(){var a,b,c,d,e,f,g,h,i;return g=va(arguments),f=g[0],c=g[1],a=g[2],e=Math.min(f,c,a),W=Math.max(f,c,a),b=W-e,i=W/255,0===W?(d=Number.NaN,h=0):(h=b/W,f===W&&(d=(c-a)/b),c===W&&(d=2+(a-f)/b),a===W&&(d=4+(f-c)/b),d*=60,0>d&&(d+=360)),[d,h,i]},s.hsv=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["hsv"]),function(){})},j.hsv=G,a.prototype.hsv=function(){return fa(this._rgb)},Z=function(a){var b,c,d;return"number"===ua(a)&&a>=0&&16777215>=a?(d=a>>16,c=a>>8&255,b=255&a,[d,c,b,1]):(console.warn("unknown num color: "+a),[0,0,0,1])},ja=function(){var a,b,c,d;return d=va(arguments),c=d[0],b=d[1],a=d[2],(c<<16)+(b<<8)+a},s.num=function(b){return new a(b,"num")},a.prototype.num=function(a){return null==a&&(a="rgb"),ja(this._rgb,a)},j.num=Z,h.push({p:10,test:function(a){return 1===arguments.length&&"number"===ua(a)&&a>=0&&16777215>=a?"num":void 0}}),x=function(a){var b,c,d,e,f,g,h,i;if(a=a.toLowerCase(),null!=s.colors&&s.colors[a])return C(s.colors[a]);if(f=a.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){for(h=f.slice(1,4),e=g=0;2>=g;e=++g)h[e]=+h[e];h[3]=1}else if(f=a.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/))for(h=f.slice(1,5),e=i=0;3>=i;e=++i)h[e]=+h[e];else if(f=a.match(/rgb\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/)){for(h=f.slice(1,4),e=b=0;2>=b;e=++b)h[e]=pa(2.55*h[e]);h[3]=1}else if(f=a.match(/rgba\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/)){for(h=f.slice(1,5),e=c=0;2>=c;e=++c)h[e]=pa(2.55*h[e]);h[3]=+h[3]}else(f=a.match(/hsl\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/))?(d=f.slice(1,4),d[1]*=.01,d[2]*=.01,h=F(d),h[3]=1):(f=a.match(/hsla\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/))&&(d=f.slice(1,4),d[1]*=.01,d[2]*=.01,h=F(d),h[3]=+f[4]);return h},ba=function(a){var b;return b=a[3]<1?"rgba":"rgb","rgb"===b?b+"("+a.slice(0,3).map(pa).join(",")+")":"rgba"===b?b+"("+a.slice(0,3).map(pa).join(",")+","+a[3]+")":void 0},na=function(a){return pa(100*a)/100},E=function(a,b){var c;return c=1>b?"hsla":"hsl",a[0]=na(a[0]||0),a[1]=na(100*a[1])+"%",a[2]=na(100*a[2])+"%","hsla"===c&&(a[3]=b),c+"("+a.join(",")+")"},j.css=function(a){return x(a)},s.css=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["css"]),function(){})},a.prototype.css=function(a){return null==a&&(a="rgb"),"rgb"===a.slice(0,3)?ba(this._rgb):"hsl"===a.slice(0,3)?E(this.hsl(),this.alpha()):void 0},j.named=function(a){return C(wa[a])},h.push({p:20,test:function(a){return 1===arguments.length&&null!=wa[a]?"named":void 0}}),a.prototype.name=function(a){var b,c;arguments.length&&(wa[a]&&(this._rgb=C(wa[a])),this._rgb[3]=1),b=this.hex();for(c in wa)if(b===wa[c])return c;return b},P=function(){var a,c,d,e;return e=va(arguments),d=e[0],a=e[1],c=e[2],c*=b,[d,w(c)*a,ra(c)*a]},Q=function(){var a,b,c,d,e,f,g,h,i,j,k;return c=va(arguments),h=c[0],e=c[1],g=c[2],j=P(h,e,g),a=j[0],b=j[1],d=j[2],k=N(a,b,d),i=k[0],f=k[1],d=k[2],[S(i,0,255),S(f,0,255),S(d,0,255),c.length>3?c[3]:1]},M=function(){var a,b,c,d,e,g;return g=va(arguments),e=g[0],a=g[1],b=g[2],c=sa(a*a+b*b),d=(m(b,a)*f+360)%360,0===pa(1e4*c)&&(d=Number.NaN),[e,c,d]},ha=function(){var a,b,c,d,e,f,g;return f=va(arguments),e=f[0],c=f[1],b=f[2],g=ga(e,c,b),d=g[0],a=g[1],b=g[2],M(d,a,b)},s.lch=function(){var b;return b=va(arguments),new a(b,"lch")},s.hcl=function(){var b;return b=va(arguments),new a(b,"hcl")},j.lch=Q,j.hcl=function(){var a,b,c,d;return d=va(arguments),b=d[0],a=d[1],c=d[2],Q([c,a,b])},a.prototype.lch=function(){return ha(this._rgb)},a.prototype.hcl=function(){return ha(this._rgb).reverse()},aa=function(a){var b,c,d,e,f,g,h,i,j;return null==a&&(a="rgb"),i=va(arguments),h=i[0],e=i[1],b=i[2],h/=255,e/=255,b/=255,f=1-Math.max(h,Math.max(e,b)),d=1>f?1/(1-f):0,c=(1-h-f)*d,g=(1-e-f)*d,j=(1-b-f)*d,[c,g,j,f]},u=function(){var a,b,c,d,e,f,g,h,i;return b=va(arguments),d=b[0],g=b[1],i=b[2],f=b[3],a=b.length>4?b[4]:1,1===f?[0,0,0,a]:(h=d>=1?0:pa(255*(1-d)*(1-f)),e=g>=1?0:pa(255*(1-g)*(1-f)),c=i>=1?0:pa(255*(1-i)*(1-f)),[h,e,c,a])},j.cmyk=function(){return u(va(arguments))},s.cmyk=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["cmyk"]),function(){})},a.prototype.cmyk=function(){return aa(this._rgb)},j.gl=function(){var a,b,c,d,e;for(d=function(){var a,c;a=va(arguments),c=[];for(b in a)e=a[b],c.push(e);return c}.apply(this,arguments),a=c=0;2>=c;a=++c)d[a]*=255;return d},s.gl=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["gl"]),function(){})},a.prototype.gl=function(){var a;return a=this._rgb,[a[0]/255,a[1]/255,a[2]/255,a[3]]},ia=function(a,b,c){var d;return d=va(arguments),a=d[0],b=d[1],c=d[2],a=U(a),b=U(b),c=U(c),.2126*a+.7152*b+.0722*c},U=function(a){return a/=255,.03928>=a?a/12.92:_((a+.055)/1.055,2.4)},k=[],H=function(a,b,c,d){var e,f,g,h;for(null==c&&(c=.5),null==d&&(d="rgb"),"object"!==ua(a)&&(a=s(a)),"object"!==ua(b)&&(b=s(b)),g=0,f=k.length;f>g;g++)if(e=k[g],d===e[0]){h=e[1](a,b,c,d);break}if(null==h)throw"color mode "+d+" is not supported";return h.alpha(a.alpha()+c*(b.alpha()-a.alpha())),h},s.interpolate=H,a.prototype.interpolate=function(a,b,c){return H(this,a,b,c)},s.mix=H,a.prototype.mix=a.prototype.interpolate,L=function(b,c,d,e){var f,g;return f=b._rgb,g=c._rgb,new a(f[0]+d*(g[0]-f[0]),f[1]+d*(g[1]-f[1]),f[2]+d*(g[2]-f[2]),e)},k.push(["rgb",L]),a.prototype.luminance=function(a,b){var c,d,e,f;return null==b&&(b="rgb"),arguments.length?(0===a?this._rgb=[0,0,0,this._rgb[3]]:1===a?this._rgb=[255,255,255,this._rgb[3]]:(d=1e-7,e=20,f=function(c,g){var h,i;return i=c.interpolate(g,.5,b),h=i.luminance(),Math.abs(a-h)<d||!e--?i:h>a?f(c,i):f(i,g)},c=ia(this._rgb),this._rgb=(c>a?f(s("black"),this):f(this,s("white"))).rgba()),this):ia(this._rgb)},ta=function(a){var b,c,d,e;return e=a/100,66>e?(d=255,c=-155.25485562709179-.44596950469579133*(c=e-2)+104.49216199393888*T(c),b=20>e?0:-254.76935184120902+.8274096064007395*(b=e-10)+115.67994401066147*T(b)):(d=351.97690566805693+.114206453784165*(d=e-55)-40.25366309332127*T(d),c=325.4494125711974+.07943456536662342*(c=e-50)-28.0852963507957*T(c),b=255),t([d,c,b])},ka=function(){var a,b,c,d,e,f,g,h,i;for(g=va(arguments),f=g[0],c=g[1],a=g[2],e=1e3,d=4e4,b=.4;d-e>b;)i=.5*(d+e),h=ta(i),h[2]/h[0]>=a/f?d=i:e=i;return pa(i)},s.temperature=s.kelvin=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["temperature"]),function(){})},j.temperature=j.kelvin=j.K=ta,a.prototype.temperature=function(){return ka(this._rgb)},a.prototype.kelvin=a.prototype.temperature,s.contrast=function(b,c){var d,e,f,g;return("string"===(f=ua(b))||"number"===f)&&(b=new a(b)),("string"===(g=ua(c))||"number"===g)&&(c=new a(c)),d=b.luminance(),e=c.luminance(),d>e?(d+.05)/(e+.05):(e+.05)/(d+.05)},a.prototype.get=function(a){var b,c,d,e,f,g;return d=this,f=a.split("."),e=f[0],b=f[1],g=d[e](),b?(c=e.indexOf(b),c>-1?g[c]:console.warn("unknown channel "+b+" in mode "+e)):g},a.prototype.set=function(a,b){var c,d,e,f,g,h;if(e=this,g=a.split("."),f=g[0],c=g[1],c)if(h=e[f](),d=f.indexOf(c),d>-1)if("string"===ua(b))switch(b.charAt(0)){case"+":h[d]+=+b;break;case"-":h[d]+=+b;break;case"*":h[d]*=+b.substr(1);break;case"/":h[d]/=+b.substr(1);break;default:h[d]=+b}else h[d]=b;else console.warn("unknown channel "+c+" in mode "+f);else h=b;return e._rgb=s(h,f).alpha(e.alpha())._rgb,e},a.prototype.darken=function(a){var b,d;return null==a&&(a=1),d=this,b=d.lab(),b[0]-=c.Kn*a,s.lab(b).alpha(d.alpha())},a.prototype.brighten=function(a){return null==a&&(a=1),this.darken(-a)},a.prototype.darker=a.prototype.darken,a.prototype.brighter=a.prototype.brighten,a.prototype.saturate=function(a){var b,d;return null==a&&(a=1),d=this,b=d.lch(),b[1]+=a*c.Kn,b[1]<0&&(b[1]=0),s.lch(b).alpha(d.alpha())},a.prototype.desaturate=function(a){return null==a&&(a=1),this.saturate(-a)},a.prototype.premultiply=function(){var a,b;return b=this.rgb(),a=this.alpha(),s(b[0]*a,b[1]*a,b[2]*a,a)},o=function(a,b,c){if(!o[c])throw"unknown blend mode "+c;return o[c](a,b)},p=function(a){return function(b,c){var d,e;return d=s(c).rgb(),e=s(b).rgb(),s(a(d,e),"rgb")}},A=function(a){return function(b,c){var d,e,f;for(f=[],d=e=0;3>=e;d=++e)f[d]=a(b[d],c[d]);return f}},Y=function(a,b){return a},X=function(a,b){return a*b/255},y=function(a,b){return a>b?b:a},R=function(a,b){return a>b?a:b},qa=function(a,b){return 255*(1-(1-a/255)*(1-b/255))},$=function(a,b){return 128>b?2*a*b/255:255*(1-2*(1-a/255)*(1-b/255))},r=function(a,b){return 255*(1-(1-b/255)/(a/255))},z=function(a,b){return 255===a?255:(a=255*(b/255)/(1-a/255),a>255?255:a)},o.normal=p(A(Y)),o.multiply=p(A(X)),o.screen=p(A(qa)),o.overlay=p(A($)),o.darken=p(A(y)),o.lighten=p(A(R)),o.dodge=p(A(z)),o.burn=p(A(r)),s.blend=o,s.analyze=function(a){var b,c,d,e;for(d={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0},c=0,b=a.length;b>c;c++)e=a[c],null==e||isNaN(e)||(d.values.push(e),d.sum+=e,e<d.min&&(d.min=e),e>d.max&&(d.max=e),d.count+=1);return d.domain=[d.min,d.max],d.limits=function(a,b){return s.limits(d,a,b)},d},s.scale=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,t,u,v,w,x;return k="rgb",l=s("#ccc"),p=0,h=!1,g=[0,1],o=[],n=[0,0],c=!1,e=[],m=!1,j=0,i=1,f=!1,d={},w=function(a){var b,c,d,f,g,h,i;if(null==a&&(a=["#fff","#000"]),null!=a&&"string"===ua(a)&&null!=(null!=(f=s.brewer)?f[a]:void 0)&&(a=s.brewer[a]),"array"===ua(a)){for(a=a.slice(0),b=d=0,g=a.length-1;g>=0?g>=d:d>=g;b=g>=0?++d:--d)c=a[b],"string"===ua(c)&&(a[b]=s(c));for(o.length=0,b=i=0,h=a.length-1;h>=0?h>=i:i>=h;b=h>=0?++i:--i)o.push(b/(a.length-1))}return v(),e=a},t=function(a){var b,d;if(null!=c){for(d=c.length-1,b=0;d>b&&a>=c[b];)b++;return b-1}return 0},x=function(a){return a},q=function(a){var b,d,e,f,g;return g=a,c.length>2&&(f=c.length-1,b=t(a),e=c[0]+(c[1]-c[0])*(0+.5*p),d=c[f-1]+(c[f]-c[f-1])*(1-.5*p),g=j+(c[b]+.5*(c[b+1]-c[b])-e)/(d-e)*(i-j)),g},u=function(a,b){var f,g,h,m,p,q,r,u;if(null==b&&(b=!1),isNaN(a))return l;if(b?u=a:c&&c.length>2?(f=t(a),u=f/(c.length-2),u=n[0]+u*(1-n[0]-n[1])):i!==j?(u=(a-j)/(i-j),u=n[0]+u*(1-n[0]-n[1]),u=Math.min(1,Math.max(0,u))):u=1,b||(u=x(u)),m=Math.floor(1e4*u),d[m])g=d[m];else{if("array"===ua(e))for(h=p=0,r=o.length-1;r>=0?r>=p:p>=r;h=r>=0?++p:--p){if(q=o[h],q>=u){g=e[h];break}if(u>=q&&h===o.length-1){g=e[h];break}if(u>q&&u<o[h+1]){u=(u-q)/(o[h+1]-q),g=s.interpolate(e[h],e[h+1],u,k);break}}else"function"===ua(e)&&(g=e(u));d[m]=g}return g},v=function(){return d={}},w(a),r=function(a){var b;return b=s(u(a)),m&&b[m]?b[m]():b},r.classes=function(a){var b;return null!=a?("array"===ua(a)?(c=a,g=[a[0],a[a.length-1]]):(b=s.analyze(g),c=0===a?[b.min,b.max]:s.limits(b,"e",a)),r):c},r.domain=function(a){var b,c,d,f,h,k,l;if(!arguments.length)return g;if(j=a[0],i=a[a.length-1],o=[],d=e.length,a.length===d&&j!==i)for(h=0,f=a.length;f>h;h++)c=a[h],o.push((c-j)/(i-j));else for(b=l=0,k=d-1;k>=0?k>=l:l>=k;b=k>=0?++l:--l)o.push(b/(d-1));return g=[j,i],r},r.mode=function(a){return arguments.length?(k=a,v(),r):k},r.range=function(a,b){return w(a,b),r},r.out=function(a){return m=a,r},r.spread=function(a){return arguments.length?(p=a,r):p},r.correctLightness=function(a){return null==a&&(a=!0),f=a,v(),x=f?function(a){var b,c,d,e,f,g,h,i,j;for(b=u(0,!0).lab()[0],c=u(1,!0).lab()[0],h=b>c,d=u(a,!0).lab()[0],f=b+(c-b)*a,e=d-f,i=0,j=1,g=20;Math.abs(e)>.01&&g-->0;)!function(){return h&&(e*=-1),0>e?(i=a,a+=.5*(j-a)):(j=a,a+=.5*(i-a)),d=u(a,!0).lab()[0],e=d-f}();return a}:function(a){return a},r},r.padding=function(a){return null!=a?("number"===ua(a)&&(a=[a,a]),n=a,r):n},r.colors=function(){var b,d,e,f,h,i,j,k,l;if(f=0,h="hex",1===arguments.length&&("string"===ua(arguments[0])?h=arguments[0]:f=arguments[0]),2===arguments.length&&(f=arguments[0],h=arguments[1]),f)return d=g[0],b=g[1]-d,function(){j=[];for(var a=0;f>=0?f>a:a>f;f>=0?a++:a--)j.push(a);return j}.apply(this).map(function(a){return r(d+a/(f-1)*b)[h]()});if(a=[],k=[],c&&c.length>2)for(e=l=1,i=c.length;i>=1?i>l:l>i;e=i>=1?++l:--l)k.push(.5*(c[e-1]+c[e]));else k=g;return k.map(function(a){return r(a)[h]()})},r},null==s.scales&&(s.scales={}),s.scales.cool=function(){return s.scale([s.hsl(180,1,.9),s.hsl(250,.7,.4)])},s.scales.hot=function(){return s.scale(["#000","#f00","#ff0","#fff"],[0,.25,.75,1]).mode("rgb")},s.analyze=function(a,b,c){var d,e,f,g,h,i,j;if(h={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0},null==c&&(c=function(){return!0}),d=function(a){null==a||isNaN(a)||(h.values.push(a),h.sum+=a,a<h.min&&(h.min=a),a>h.max&&(h.max=a),h.count+=1)},j=function(a,e){return c(a,e)?d(null!=b&&"function"===ua(b)?b(a):null!=b&&"string"===ua(b)||"number"===ua(b)?a[b]:a):void 0},"array"===ua(a))for(g=0,f=a.length;f>g;g++)i=a[g],j(i);else for(e in a)i=a[e],j(i,e);return h.domain=[h.min,h.max],h.limits=function(a,b){return s.limits(h,a,b)},h},s.limits=function(a,b,c){var d,e,f,g,h,i,j,k,m,n,o,p,q,r,t,u,v,w,x,y,z,A,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,U,V,X,Y,Z,$,aa,ba,ca,da,ea,fa,ga,ha,ia,ja;if(null==b&&(b="equal"),null==c&&(c=7),"array"===ua(a)&&(a=s.analyze(a)),E=a.min,W=a.max,fa=a.sum,ia=a.values.sort(function(a,b){return a-b}),C=[],"c"===b.substr(0,1)&&(C.push(E),C.push(W)),"e"===b.substr(0,1)){for(C.push(E),y=K=1,O=c-1;O>=1?O>=K:K>=O;y=O>=1?++K:--K)C.push(E+y/c*(W-E));C.push(W)}else if("l"===b.substr(0,1)){if(0>=E)throw"Logarithmic scales are only possible for values > 0";for(F=Math.LOG10E*T(E),D=Math.LOG10E*T(W),C.push(E),y=ja=1,P=c-1;P>=1?P>=ja:ja>=P;y=P>=1?++ja:--ja)C.push(_(10,F+y/c*(D-F)));C.push(W)}else if("q"===b.substr(0,1)){for(C.push(E),y=d=1,X=c-1;X>=1?X>=d:d>=X;y=X>=1?++d:--d)L=ia.length*y/c,M=B(L),M===L?C.push(ia[M]):(N=L-M,C.push(ia[M]*N+ia[M+1]*(1-N)));C.push(W)}else if("k"===b.substr(0,1)){for(H=ia.length,r=new Array(H),w=new Array(c),ea=!0,I=0,u=null,u=[],u.push(E),y=e=1,Y=c-1;Y>=1?Y>=e:e>=Y;y=Y>=1?++e:--e)u.push(E+y/c*(W-E));for(u.push(W);ea;){for(z=f=0,Z=c-1;Z>=0?Z>=f:f>=Z;z=Z>=0?++f:--f)w[z]=0;for(y=g=0,$=H-1;$>=0?$>=g:g>=$;y=$>=0?++g:--g){for(ha=ia[y],G=Number.MAX_VALUE,z=h=0,aa=c-1;aa>=0?aa>=h:h>=aa;z=aa>=0?++h:--h)x=l(u[z]-ha),G>x&&(G=x,t=z);w[t]++,r[y]=t}for(J=new Array(c),z=i=0,ba=c-1;ba>=0?ba>=i:i>=ba;z=ba>=0?++i:--i)J[z]=null;for(y=j=0,ca=H-1;ca>=0?ca>=j:j>=ca;y=ca>=0?++j:--j)v=r[y],null===J[v]?J[v]=ia[y]:J[v]+=ia[y];for(z=k=0,da=c-1;da>=0?da>=k:k>=da;z=da>=0?++k:--k)J[z]*=1/w[z];for(ea=!1,z=m=0,Q=c-1;Q>=0?Q>=m:m>=Q;z=Q>=0?++m:--m)if(J[z]!==u[y]){ea=!0;break}u=J,I++,I>200&&(ea=!1)}for(A={},z=n=0,R=c-1;R>=0?R>=n:n>=R;z=R>=0?++n:--n)A[z]=[];for(y=o=0,S=H-1;S>=0?S>=o:o>=S;y=S>=0?++o:--o)v=r[y],A[v].push(ia[y]);for(ga=[],z=p=0,U=c-1;U>=0?U>=p:p>=U;z=U>=0?++p:--p)ga.push(A[z][0]),ga.push(A[z][A[z].length-1]);for(ga=ga.sort(function(a,b){return a-b}),C.push(ga[0]),y=q=1,V=ga.length-1;V>=q;y=q+=2)isNaN(ga[y])||C.push(ga[y])}return C},D=function(a,b,c){var d,f,h,i;return d=va(arguments),a=d[0],b=d[1],c=d[2],a/=360,1/3>a?(f=(1-b)/3,i=(1+b*w(g*a)/w(e-g*a))/3,h=1-(f+i)):2/3>a?(a-=1/3,i=(1-b)/3,h=(1+b*w(g*a)/w(e-g*a))/3,f=1-(i+h)):(a-=2/3,h=(1-b)/3,f=(1+b*w(g*a)/w(e-g*a))/3,i=1-(h+f)),i=S(c*i*3),h=S(c*h*3),f=S(c*f*3),[255*i,255*h,255*f,d.length>3?d[3]:1]},da=function(){var a,b,c,d,e,f,h,i;return h=va(arguments),f=h[0],b=h[1],a=h[2],g=2*Math.PI,f/=255,b/=255,a/=255,e=Math.min(f,b,a),d=(f+b+a)/3,i=1-e/d,0===i?c=0:(c=(f-b+(f-a))/2,c/=Math.sqrt((f-b)*(f-b)+(f-a)*(b-a)),c=Math.acos(c),a>b&&(c=g-c),c/=g),[360*c,i,d]},s.hsi=function(){return function(a,b,c){c.prototype=a.prototype;var d=new c,e=a.apply(d,b);return Object(e)===e?e:d}(a,za.call(arguments).concat(["hsi"]),function(){})},j.hsi=D,a.prototype.hsi=function(){return da(this._rgb)},I=function(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q;return"hsl"===d?(p=a.hsl(),q=b.hsl()):"hsv"===d?(p=a.hsv(),q=b.hsv()):"hsi"===d?(p=a.hsi(),q=b.hsi()):("lch"===d||"hcl"===d)&&(d="hcl",p=a.hcl(),q=b.hcl()),"h"===d.substr(0,1)&&(g=p[0],n=p[1],j=p[2],h=q[0],o=q[1],k=q[2]),isNaN(g)||isNaN(h)?isNaN(g)?isNaN(h)?f=Number.NaN:(f=h,1!==j&&0!==j||"hsv"===d||(m=o)):(f=g,1!==k&&0!==k||"hsv"===d||(m=n)):(e=h>g&&h-g>180?h-(g+360):g>h&&g-h>180?h+360-g:h-g,f=g+c*e),null==m&&(m=n+c*(o-n)),i=j+c*(k-j),l=s[d](f,m,i)},k=k.concat(function(){var a,b,c,d;for(c=["hsv","hsl","hsi","hcl","lch"],d=[],b=0,a=c.length;a>b;b++)V=c[b],d.push([V,I]);return d}()),K=function(a,b,c,d){var e,f;return e=a.num(),f=b.num(),s.num(e+(f-e)*c,"num")},k.push(["num",K]),J=function(b,c,d,e){var f,g,h;return g=b.lab(),h=c.lab(),f=new a(g[0]+d*(h[0]-g[0]),g[1]+d*(h[1]-g[1]),g[2]+d*(h[2]-g[2]),e);
},k.push(["lab",J])}).call(this);
// File:js/lib/pako_inflate.min.js

/* pako 0.2.8 nodeca/pako */
!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var t;t="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,t.pako=e()}}(function(){return function e(t,i,n){function a(o,s){if(!i[o]){if(!t[o]){var f="function"==typeof require&&require;if(!s&&f)return f(o,!0);if(r)return r(o,!0);var l=new Error("Cannot find module '"+o+"'");throw l.code="MODULE_NOT_FOUND",l}var d=i[o]={exports:{}};t[o][0].call(d.exports,function(e){var i=t[o][1][e];return a(i?i:e)},d,d.exports,e,t,i,n)}return i[o].exports}for(var r="function"==typeof require&&require,o=0;o<n.length;o++)a(n[o]);return a}({1:[function(e,t,i){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;i.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var i=t.shift();if(i){if("object"!=typeof i)throw new TypeError(i+"must be non-object");for(var n in i)i.hasOwnProperty(n)&&(e[n]=i[n])}}return e},i.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var a={arraySet:function(e,t,i,n,a){if(t.subarray&&e.subarray)return void e.set(t.subarray(i,i+n),a);for(var r=0;n>r;r++)e[a+r]=t[i+r]},flattenChunks:function(e){var t,i,n,a,r,o;for(n=0,t=0,i=e.length;i>t;t++)n+=e[t].length;for(o=new Uint8Array(n),a=0,t=0,i=e.length;i>t;t++)r=e[t],o.set(r,a),a+=r.length;return o}},r={arraySet:function(e,t,i,n,a){for(var r=0;n>r;r++)e[a+r]=t[i+r]},flattenChunks:function(e){return[].concat.apply([],e)}};i.setTyped=function(e){e?(i.Buf8=Uint8Array,i.Buf16=Uint16Array,i.Buf32=Int32Array,i.assign(i,a)):(i.Buf8=Array,i.Buf16=Array,i.Buf32=Array,i.assign(i,r))},i.setTyped(n)},{}],2:[function(e,t,i){"use strict";function n(e,t){if(65537>t&&(e.subarray&&o||!e.subarray&&r))return String.fromCharCode.apply(null,a.shrinkBuf(e,t));for(var i="",n=0;t>n;n++)i+=String.fromCharCode(e[n]);return i}var a=e("./common"),r=!0,o=!0;try{String.fromCharCode.apply(null,[0])}catch(s){r=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(s){o=!1}for(var f=new a.Buf8(256),l=0;256>l;l++)f[l]=l>=252?6:l>=248?5:l>=240?4:l>=224?3:l>=192?2:1;f[254]=f[254]=1,i.string2buf=function(e){var t,i,n,r,o,s=e.length,f=0;for(r=0;s>r;r++)i=e.charCodeAt(r),55296===(64512&i)&&s>r+1&&(n=e.charCodeAt(r+1),56320===(64512&n)&&(i=65536+(i-55296<<10)+(n-56320),r++)),f+=128>i?1:2048>i?2:65536>i?3:4;for(t=new a.Buf8(f),o=0,r=0;f>o;r++)i=e.charCodeAt(r),55296===(64512&i)&&s>r+1&&(n=e.charCodeAt(r+1),56320===(64512&n)&&(i=65536+(i-55296<<10)+(n-56320),r++)),128>i?t[o++]=i:2048>i?(t[o++]=192|i>>>6,t[o++]=128|63&i):65536>i?(t[o++]=224|i>>>12,t[o++]=128|i>>>6&63,t[o++]=128|63&i):(t[o++]=240|i>>>18,t[o++]=128|i>>>12&63,t[o++]=128|i>>>6&63,t[o++]=128|63&i);return t},i.buf2binstring=function(e){return n(e,e.length)},i.binstring2buf=function(e){for(var t=new a.Buf8(e.length),i=0,n=t.length;n>i;i++)t[i]=e.charCodeAt(i);return t},i.buf2string=function(e,t){var i,a,r,o,s=t||e.length,l=new Array(2*s);for(a=0,i=0;s>i;)if(r=e[i++],128>r)l[a++]=r;else if(o=f[r],o>4)l[a++]=65533,i+=o-1;else{for(r&=2===o?31:3===o?15:7;o>1&&s>i;)r=r<<6|63&e[i++],o--;o>1?l[a++]=65533:65536>r?l[a++]=r:(r-=65536,l[a++]=55296|r>>10&1023,l[a++]=56320|1023&r)}return n(l,a)},i.utf8border=function(e,t){var i;for(t=t||e.length,t>e.length&&(t=e.length),i=t-1;i>=0&&128===(192&e[i]);)i--;return 0>i?t:0===i?t:i+f[e[i]]>t?i:t}},{"./common":1}],3:[function(e,t,i){"use strict";function n(e,t,i,n){for(var a=65535&e|0,r=e>>>16&65535|0,o=0;0!==i;){o=i>2e3?2e3:i,i-=o;do a=a+t[n++]|0,r=r+a|0;while(--o);a%=65521,r%=65521}return a|r<<16|0}t.exports=n},{}],4:[function(e,t,i){t.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],5:[function(e,t,i){"use strict";function n(){for(var e,t=[],i=0;256>i;i++){e=i;for(var n=0;8>n;n++)e=1&e?3988292384^e>>>1:e>>>1;t[i]=e}return t}function a(e,t,i,n){var a=r,o=n+i;e=-1^e;for(var s=n;o>s;s++)e=e>>>8^a[255&(e^t[s])];return-1^e}var r=n();t.exports=a},{}],6:[function(e,t,i){"use strict";function n(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}t.exports=n},{}],7:[function(e,t,i){"use strict";var n=30,a=12;t.exports=function(e,t){var i,r,o,s,f,l,d,u,h,c,b,w,m,k,_,g,v,p,x,y,S,E,B,Z,A;i=e.state,r=e.next_in,Z=e.input,o=r+(e.avail_in-5),s=e.next_out,A=e.output,f=s-(t-e.avail_out),l=s+(e.avail_out-257),d=i.dmax,u=i.wsize,h=i.whave,c=i.wnext,b=i.window,w=i.hold,m=i.bits,k=i.lencode,_=i.distcode,g=(1<<i.lenbits)-1,v=(1<<i.distbits)-1;e:do{15>m&&(w+=Z[r++]<<m,m+=8,w+=Z[r++]<<m,m+=8),p=k[w&g];t:for(;;){if(x=p>>>24,w>>>=x,m-=x,x=p>>>16&255,0===x)A[s++]=65535&p;else{if(!(16&x)){if(0===(64&x)){p=k[(65535&p)+(w&(1<<x)-1)];continue t}if(32&x){i.mode=a;break e}e.msg="invalid literal/length code",i.mode=n;break e}y=65535&p,x&=15,x&&(x>m&&(w+=Z[r++]<<m,m+=8),y+=w&(1<<x)-1,w>>>=x,m-=x),15>m&&(w+=Z[r++]<<m,m+=8,w+=Z[r++]<<m,m+=8),p=_[w&v];i:for(;;){if(x=p>>>24,w>>>=x,m-=x,x=p>>>16&255,!(16&x)){if(0===(64&x)){p=_[(65535&p)+(w&(1<<x)-1)];continue i}e.msg="invalid distance code",i.mode=n;break e}if(S=65535&p,x&=15,x>m&&(w+=Z[r++]<<m,m+=8,x>m&&(w+=Z[r++]<<m,m+=8)),S+=w&(1<<x)-1,S>d){e.msg="invalid distance too far back",i.mode=n;break e}if(w>>>=x,m-=x,x=s-f,S>x){if(x=S-x,x>h&&i.sane){e.msg="invalid distance too far back",i.mode=n;break e}if(E=0,B=b,0===c){if(E+=u-x,y>x){y-=x;do A[s++]=b[E++];while(--x);E=s-S,B=A}}else if(x>c){if(E+=u+c-x,x-=c,y>x){y-=x;do A[s++]=b[E++];while(--x);if(E=0,y>c){x=c,y-=x;do A[s++]=b[E++];while(--x);E=s-S,B=A}}}else if(E+=c-x,y>x){y-=x;do A[s++]=b[E++];while(--x);E=s-S,B=A}for(;y>2;)A[s++]=B[E++],A[s++]=B[E++],A[s++]=B[E++],y-=3;y&&(A[s++]=B[E++],y>1&&(A[s++]=B[E++]))}else{E=s-S;do A[s++]=A[E++],A[s++]=A[E++],A[s++]=A[E++],y-=3;while(y>2);y&&(A[s++]=A[E++],y>1&&(A[s++]=A[E++]))}break}}break}}while(o>r&&l>s);y=m>>3,r-=y,m-=y<<3,w&=(1<<m)-1,e.next_in=r,e.next_out=s,e.avail_in=o>r?5+(o-r):5-(r-o),e.avail_out=l>s?257+(l-s):257-(s-l),i.hold=w,i.bits=m}},{}],8:[function(e,t,i){"use strict";function n(e){return(e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function a(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new k.Buf16(320),this.work=new k.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function r(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=T,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new k.Buf32(be),t.distcode=t.distdyn=new k.Buf32(we),t.sane=1,t.back=-1,A):N}function o(e){var t;return e&&e.state?(t=e.state,t.wsize=0,t.whave=0,t.wnext=0,r(e)):N}function s(e,t){var i,n;return e&&e.state?(n=e.state,0>t?(i=0,t=-t):(i=(t>>4)+1,48>t&&(t&=15)),t&&(8>t||t>15)?N:(null!==n.window&&n.wbits!==t&&(n.window=null),n.wrap=i,n.wbits=t,o(e))):N}function f(e,t){var i,n;return e?(n=new a,e.state=n,n.window=null,i=s(e,t),i!==A&&(e.state=null),i):N}function l(e){return f(e,ke)}function d(e){if(_e){var t;for(w=new k.Buf32(512),m=new k.Buf32(32),t=0;144>t;)e.lens[t++]=8;for(;256>t;)e.lens[t++]=9;for(;280>t;)e.lens[t++]=7;for(;288>t;)e.lens[t++]=8;for(p(y,e.lens,0,288,w,0,e.work,{bits:9}),t=0;32>t;)e.lens[t++]=5;p(S,e.lens,0,32,m,0,e.work,{bits:5}),_e=!1}e.lencode=w,e.lenbits=9,e.distcode=m,e.distbits=5}function u(e,t,i,n){var a,r=e.state;return null===r.window&&(r.wsize=1<<r.wbits,r.wnext=0,r.whave=0,r.window=new k.Buf8(r.wsize)),n>=r.wsize?(k.arraySet(r.window,t,i-r.wsize,r.wsize,0),r.wnext=0,r.whave=r.wsize):(a=r.wsize-r.wnext,a>n&&(a=n),k.arraySet(r.window,t,i-n,a,r.wnext),n-=a,n?(k.arraySet(r.window,t,i-n,n,0),r.wnext=n,r.whave=r.wsize):(r.wnext+=a,r.wnext===r.wsize&&(r.wnext=0),r.whave<r.wsize&&(r.whave+=a))),0}function h(e,t){var i,a,r,o,s,f,l,h,c,b,w,m,be,we,me,ke,_e,ge,ve,pe,xe,ye,Se,Ee,Be=0,Ze=new k.Buf8(4),Ae=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return N;i=e.state,i.mode===G&&(i.mode=X),s=e.next_out,r=e.output,l=e.avail_out,o=e.next_in,a=e.input,f=e.avail_in,h=i.hold,c=i.bits,b=f,w=l,ye=A;e:for(;;)switch(i.mode){case T:if(0===i.wrap){i.mode=X;break}for(;16>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(2&i.wrap&&35615===h){i.check=0,Ze[0]=255&h,Ze[1]=h>>>8&255,i.check=g(i.check,Ze,2,0),h=0,c=0,i.mode=U;break}if(i.flags=0,i.head&&(i.head.done=!1),!(1&i.wrap)||(((255&h)<<8)+(h>>8))%31){e.msg="incorrect header check",i.mode=ue;break}if((15&h)!==F){e.msg="unknown compression method",i.mode=ue;break}if(h>>>=4,c-=4,xe=(15&h)+8,0===i.wbits)i.wbits=xe;else if(xe>i.wbits){e.msg="invalid window size",i.mode=ue;break}i.dmax=1<<xe,e.adler=i.check=1,i.mode=512&h?Y:G,h=0,c=0;break;case U:for(;16>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(i.flags=h,(255&i.flags)!==F){e.msg="unknown compression method",i.mode=ue;break}if(57344&i.flags){e.msg="unknown header flags set",i.mode=ue;break}i.head&&(i.head.text=h>>8&1),512&i.flags&&(Ze[0]=255&h,Ze[1]=h>>>8&255,i.check=g(i.check,Ze,2,0)),h=0,c=0,i.mode=D;case D:for(;32>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}i.head&&(i.head.time=h),512&i.flags&&(Ze[0]=255&h,Ze[1]=h>>>8&255,Ze[2]=h>>>16&255,Ze[3]=h>>>24&255,i.check=g(i.check,Ze,4,0)),h=0,c=0,i.mode=L;case L:for(;16>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}i.head&&(i.head.xflags=255&h,i.head.os=h>>8),512&i.flags&&(Ze[0]=255&h,Ze[1]=h>>>8&255,i.check=g(i.check,Ze,2,0)),h=0,c=0,i.mode=H;case H:if(1024&i.flags){for(;16>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}i.length=h,i.head&&(i.head.extra_len=h),512&i.flags&&(Ze[0]=255&h,Ze[1]=h>>>8&255,i.check=g(i.check,Ze,2,0)),h=0,c=0}else i.head&&(i.head.extra=null);i.mode=j;case j:if(1024&i.flags&&(m=i.length,m>f&&(m=f),m&&(i.head&&(xe=i.head.extra_len-i.length,i.head.extra||(i.head.extra=new Array(i.head.extra_len)),k.arraySet(i.head.extra,a,o,m,xe)),512&i.flags&&(i.check=g(i.check,a,m,o)),f-=m,o+=m,i.length-=m),i.length))break e;i.length=0,i.mode=M;case M:if(2048&i.flags){if(0===f)break e;m=0;do xe=a[o+m++],i.head&&xe&&i.length<65536&&(i.head.name+=String.fromCharCode(xe));while(xe&&f>m);if(512&i.flags&&(i.check=g(i.check,a,m,o)),f-=m,o+=m,xe)break e}else i.head&&(i.head.name=null);i.length=0,i.mode=K;case K:if(4096&i.flags){if(0===f)break e;m=0;do xe=a[o+m++],i.head&&xe&&i.length<65536&&(i.head.comment+=String.fromCharCode(xe));while(xe&&f>m);if(512&i.flags&&(i.check=g(i.check,a,m,o)),f-=m,o+=m,xe)break e}else i.head&&(i.head.comment=null);i.mode=P;case P:if(512&i.flags){for(;16>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(h!==(65535&i.check)){e.msg="header crc mismatch",i.mode=ue;break}h=0,c=0}i.head&&(i.head.hcrc=i.flags>>9&1,i.head.done=!0),e.adler=i.check=0,i.mode=G;break;case Y:for(;32>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}e.adler=i.check=n(h),h=0,c=0,i.mode=q;case q:if(0===i.havedict)return e.next_out=s,e.avail_out=l,e.next_in=o,e.avail_in=f,i.hold=h,i.bits=c,R;e.adler=i.check=1,i.mode=G;case G:if(t===B||t===Z)break e;case X:if(i.last){h>>>=7&c,c-=7&c,i.mode=fe;break}for(;3>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}switch(i.last=1&h,h>>>=1,c-=1,3&h){case 0:i.mode=W;break;case 1:if(d(i),i.mode=te,t===Z){h>>>=2,c-=2;break e}break;case 2:i.mode=V;break;case 3:e.msg="invalid block type",i.mode=ue}h>>>=2,c-=2;break;case W:for(h>>>=7&c,c-=7&c;32>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if((65535&h)!==(h>>>16^65535)){e.msg="invalid stored block lengths",i.mode=ue;break}if(i.length=65535&h,h=0,c=0,i.mode=J,t===Z)break e;case J:i.mode=Q;case Q:if(m=i.length){if(m>f&&(m=f),m>l&&(m=l),0===m)break e;k.arraySet(r,a,o,m,s),f-=m,o+=m,l-=m,s+=m,i.length-=m;break}i.mode=G;break;case V:for(;14>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(i.nlen=(31&h)+257,h>>>=5,c-=5,i.ndist=(31&h)+1,h>>>=5,c-=5,i.ncode=(15&h)+4,h>>>=4,c-=4,i.nlen>286||i.ndist>30){e.msg="too many length or distance symbols",i.mode=ue;break}i.have=0,i.mode=$;case $:for(;i.have<i.ncode;){for(;3>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}i.lens[Ae[i.have++]]=7&h,h>>>=3,c-=3}for(;i.have<19;)i.lens[Ae[i.have++]]=0;if(i.lencode=i.lendyn,i.lenbits=7,Se={bits:i.lenbits},ye=p(x,i.lens,0,19,i.lencode,0,i.work,Se),i.lenbits=Se.bits,ye){e.msg="invalid code lengths set",i.mode=ue;break}i.have=0,i.mode=ee;case ee:for(;i.have<i.nlen+i.ndist;){for(;Be=i.lencode[h&(1<<i.lenbits)-1],me=Be>>>24,ke=Be>>>16&255,_e=65535&Be,!(c>=me);){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(16>_e)h>>>=me,c-=me,i.lens[i.have++]=_e;else{if(16===_e){for(Ee=me+2;Ee>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(h>>>=me,c-=me,0===i.have){e.msg="invalid bit length repeat",i.mode=ue;break}xe=i.lens[i.have-1],m=3+(3&h),h>>>=2,c-=2}else if(17===_e){for(Ee=me+3;Ee>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}h>>>=me,c-=me,xe=0,m=3+(7&h),h>>>=3,c-=3}else{for(Ee=me+7;Ee>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}h>>>=me,c-=me,xe=0,m=11+(127&h),h>>>=7,c-=7}if(i.have+m>i.nlen+i.ndist){e.msg="invalid bit length repeat",i.mode=ue;break}for(;m--;)i.lens[i.have++]=xe}}if(i.mode===ue)break;if(0===i.lens[256]){e.msg="invalid code -- missing end-of-block",i.mode=ue;break}if(i.lenbits=9,Se={bits:i.lenbits},ye=p(y,i.lens,0,i.nlen,i.lencode,0,i.work,Se),i.lenbits=Se.bits,ye){e.msg="invalid literal/lengths set",i.mode=ue;break}if(i.distbits=6,i.distcode=i.distdyn,Se={bits:i.distbits},ye=p(S,i.lens,i.nlen,i.ndist,i.distcode,0,i.work,Se),i.distbits=Se.bits,ye){e.msg="invalid distances set",i.mode=ue;break}if(i.mode=te,t===Z)break e;case te:i.mode=ie;case ie:if(f>=6&&l>=258){e.next_out=s,e.avail_out=l,e.next_in=o,e.avail_in=f,i.hold=h,i.bits=c,v(e,w),s=e.next_out,r=e.output,l=e.avail_out,o=e.next_in,a=e.input,f=e.avail_in,h=i.hold,c=i.bits,i.mode===G&&(i.back=-1);break}for(i.back=0;Be=i.lencode[h&(1<<i.lenbits)-1],me=Be>>>24,ke=Be>>>16&255,_e=65535&Be,!(c>=me);){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(ke&&0===(240&ke)){for(ge=me,ve=ke,pe=_e;Be=i.lencode[pe+((h&(1<<ge+ve)-1)>>ge)],me=Be>>>24,ke=Be>>>16&255,_e=65535&Be,!(c>=ge+me);){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}h>>>=ge,c-=ge,i.back+=ge}if(h>>>=me,c-=me,i.back+=me,i.length=_e,0===ke){i.mode=se;break}if(32&ke){i.back=-1,i.mode=G;break}if(64&ke){e.msg="invalid literal/length code",i.mode=ue;break}i.extra=15&ke,i.mode=ne;case ne:if(i.extra){for(Ee=i.extra;Ee>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}i.length+=h&(1<<i.extra)-1,h>>>=i.extra,c-=i.extra,i.back+=i.extra}i.was=i.length,i.mode=ae;case ae:for(;Be=i.distcode[h&(1<<i.distbits)-1],me=Be>>>24,ke=Be>>>16&255,_e=65535&Be,!(c>=me);){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(0===(240&ke)){for(ge=me,ve=ke,pe=_e;Be=i.distcode[pe+((h&(1<<ge+ve)-1)>>ge)],me=Be>>>24,ke=Be>>>16&255,_e=65535&Be,!(c>=ge+me);){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}h>>>=ge,c-=ge,i.back+=ge}if(h>>>=me,c-=me,i.back+=me,64&ke){e.msg="invalid distance code",i.mode=ue;break}i.offset=_e,i.extra=15&ke,i.mode=re;case re:if(i.extra){for(Ee=i.extra;Ee>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}i.offset+=h&(1<<i.extra)-1,h>>>=i.extra,c-=i.extra,i.back+=i.extra}if(i.offset>i.dmax){e.msg="invalid distance too far back",i.mode=ue;break}i.mode=oe;case oe:if(0===l)break e;if(m=w-l,i.offset>m){if(m=i.offset-m,m>i.whave&&i.sane){e.msg="invalid distance too far back",i.mode=ue;break}m>i.wnext?(m-=i.wnext,be=i.wsize-m):be=i.wnext-m,m>i.length&&(m=i.length),we=i.window}else we=r,be=s-i.offset,m=i.length;m>l&&(m=l),l-=m,i.length-=m;do r[s++]=we[be++];while(--m);0===i.length&&(i.mode=ie);break;case se:if(0===l)break e;r[s++]=i.length,l--,i.mode=ie;break;case fe:if(i.wrap){for(;32>c;){if(0===f)break e;f--,h|=a[o++]<<c,c+=8}if(w-=l,e.total_out+=w,i.total+=w,w&&(e.adler=i.check=i.flags?g(i.check,r,w,s-w):_(i.check,r,w,s-w)),w=l,(i.flags?h:n(h))!==i.check){e.msg="incorrect data check",i.mode=ue;break}h=0,c=0}i.mode=le;case le:if(i.wrap&&i.flags){for(;32>c;){if(0===f)break e;f--,h+=a[o++]<<c,c+=8}if(h!==(4294967295&i.total)){e.msg="incorrect length check",i.mode=ue;break}h=0,c=0}i.mode=de;case de:ye=z;break e;case ue:ye=O;break e;case he:return C;case ce:default:return N}return e.next_out=s,e.avail_out=l,e.next_in=o,e.avail_in=f,i.hold=h,i.bits=c,(i.wsize||w!==e.avail_out&&i.mode<ue&&(i.mode<fe||t!==E))&&u(e,e.output,e.next_out,w-e.avail_out)?(i.mode=he,C):(b-=e.avail_in,w-=e.avail_out,e.total_in+=b,e.total_out+=w,i.total+=w,i.wrap&&w&&(e.adler=i.check=i.flags?g(i.check,r,w,e.next_out-w):_(i.check,r,w,e.next_out-w)),e.data_type=i.bits+(i.last?64:0)+(i.mode===G?128:0)+(i.mode===te||i.mode===J?256:0),(0===b&&0===w||t===E)&&ye===A&&(ye=I),ye)}function c(e){if(!e||!e.state)return N;var t=e.state;return t.window&&(t.window=null),e.state=null,A}function b(e,t){var i;return e&&e.state?(i=e.state,0===(2&i.wrap)?N:(i.head=t,t.done=!1,A)):N}var w,m,k=e("../utils/common"),_=e("./adler32"),g=e("./crc32"),v=e("./inffast"),p=e("./inftrees"),x=0,y=1,S=2,E=4,B=5,Z=6,A=0,z=1,R=2,N=-2,O=-3,C=-4,I=-5,F=8,T=1,U=2,D=3,L=4,H=5,j=6,M=7,K=8,P=9,Y=10,q=11,G=12,X=13,W=14,J=15,Q=16,V=17,$=18,ee=19,te=20,ie=21,ne=22,ae=23,re=24,oe=25,se=26,fe=27,le=28,de=29,ue=30,he=31,ce=32,be=852,we=592,me=15,ke=me,_e=!0;i.inflateReset=o,i.inflateReset2=s,i.inflateResetKeep=r,i.inflateInit=l,i.inflateInit2=f,i.inflate=h,i.inflateEnd=c,i.inflateGetHeader=b,i.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":1,"./adler32":3,"./crc32":5,"./inffast":7,"./inftrees":9}],9:[function(e,t,i){"use strict";var n=e("../utils/common"),a=15,r=852,o=592,s=0,f=1,l=2,d=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],u=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],h=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],c=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];t.exports=function(e,t,i,b,w,m,k,_){var g,v,p,x,y,S,E,B,Z,A=_.bits,z=0,R=0,N=0,O=0,C=0,I=0,F=0,T=0,U=0,D=0,L=null,H=0,j=new n.Buf16(a+1),M=new n.Buf16(a+1),K=null,P=0;for(z=0;a>=z;z++)j[z]=0;for(R=0;b>R;R++)j[t[i+R]]++;for(C=A,O=a;O>=1&&0===j[O];O--);if(C>O&&(C=O),0===O)return w[m++]=20971520,w[m++]=20971520,_.bits=1,0;for(N=1;O>N&&0===j[N];N++);for(N>C&&(C=N),T=1,z=1;a>=z;z++)if(T<<=1,T-=j[z],0>T)return-1;if(T>0&&(e===s||1!==O))return-1;for(M[1]=0,z=1;a>z;z++)M[z+1]=M[z]+j[z];for(R=0;b>R;R++)0!==t[i+R]&&(k[M[t[i+R]]++]=R);if(e===s?(L=K=k,S=19):e===f?(L=d,H-=257,K=u,P-=257,S=256):(L=h,K=c,S=-1),D=0,R=0,z=N,y=m,I=C,F=0,p=-1,U=1<<C,x=U-1,e===f&&U>r||e===l&&U>o)return 1;for(var Y=0;;){Y++,E=z-F,k[R]<S?(B=0,Z=k[R]):k[R]>S?(B=K[P+k[R]],Z=L[H+k[R]]):(B=96,Z=0),g=1<<z-F,v=1<<I,N=v;do v-=g,w[y+(D>>F)+v]=E<<24|B<<16|Z|0;while(0!==v);for(g=1<<z-1;D&g;)g>>=1;if(0!==g?(D&=g-1,D+=g):D=0,R++,0===--j[z]){if(z===O)break;z=t[i+k[R]]}if(z>C&&(D&x)!==p){for(0===F&&(F=C),y+=N,I=z-F,T=1<<I;O>I+F&&(T-=j[I+F],!(0>=T));)I++,T<<=1;if(U+=1<<I,e===f&&U>r||e===l&&U>o)return 1;p=D&x,w[p]=C<<24|I<<16|y-m|0}}return 0!==D&&(w[y+D]=z-F<<24|64<<16|0),_.bits=C,0}},{"../utils/common":1}],10:[function(e,t,i){"use strict";t.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],11:[function(e,t,i){"use strict";function n(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}t.exports=n},{}],"/lib/inflate.js":[function(e,t,i){"use strict";function n(e,t){var i=new c(t);if(i.push(e,!0),i.err)throw i.msg;return i.result}function a(e,t){return t=t||{},t.raw=!0,n(e,t)}var r=e("./zlib/inflate.js"),o=e("./utils/common"),s=e("./utils/strings"),f=e("./zlib/constants"),l=e("./zlib/messages"),d=e("./zlib/zstream"),u=e("./zlib/gzheader"),h=Object.prototype.toString,c=function(e){this.options=o.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&t.windowBits>=0&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(t.windowBits>=0&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),t.windowBits>15&&t.windowBits<48&&0===(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new d,this.strm.avail_out=0;var i=r.inflateInit2(this.strm,t.windowBits);if(i!==f.Z_OK)throw new Error(l[i]);this.header=new u,r.inflateGetHeader(this.strm,this.header)};c.prototype.push=function(e,t){var i,n,a,l,d,u=this.strm,c=this.options.chunkSize,b=!1;if(this.ended)return!1;n=t===~~t?t:t===!0?f.Z_FINISH:f.Z_NO_FLUSH,"string"==typeof e?u.input=s.binstring2buf(e):"[object ArrayBuffer]"===h.call(e)?u.input=new Uint8Array(e):u.input=e,u.next_in=0,u.avail_in=u.input.length;do{if(0===u.avail_out&&(u.output=new o.Buf8(c),u.next_out=0,u.avail_out=c),i=r.inflate(u,f.Z_NO_FLUSH),i===f.Z_BUF_ERROR&&b===!0&&(i=f.Z_OK,b=!1),i!==f.Z_STREAM_END&&i!==f.Z_OK)return this.onEnd(i),this.ended=!0,!1;u.next_out&&(0===u.avail_out||i===f.Z_STREAM_END||0===u.avail_in&&(n===f.Z_FINISH||n===f.Z_SYNC_FLUSH))&&("string"===this.options.to?(a=s.utf8border(u.output,u.next_out),l=u.next_out-a,d=s.buf2string(u.output,a),u.next_out=l,u.avail_out=c-l,l&&o.arraySet(u.output,u.output,a,l,0),this.onData(d)):this.onData(o.shrinkBuf(u.output,u.next_out))),0===u.avail_in&&0===u.avail_out&&(b=!0)}while((u.avail_in>0||0===u.avail_out)&&i!==f.Z_STREAM_END);return i===f.Z_STREAM_END&&(n=f.Z_FINISH),n===f.Z_FINISH?(i=r.inflateEnd(this.strm),this.onEnd(i),this.ended=!0,i===f.Z_OK):n===f.Z_SYNC_FLUSH?(this.onEnd(f.Z_OK),u.avail_out=0,!0):!0},c.prototype.onData=function(e){this.chunks.push(e)},c.prototype.onEnd=function(e){e===f.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=o.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},i.Inflate=c,i.inflate=n,i.inflateRaw=a,i.ungzip=n},{"./utils/common":1,"./utils/strings":2,"./zlib/constants":4,"./zlib/gzheader":6,"./zlib/inflate.js":8,"./zlib/messages":10,"./zlib/zstream":11}]},{},[])("/lib/inflate.js")});

// File:js/lib/promise.min.js

/*! promise-polyfill 3.1.0 */
!function(a){function b(a,b){return function(){a.apply(b,arguments)}}function c(a){if("object"!=typeof this)throw new TypeError("Promises must be constructed via new");if("function"!=typeof a)throw new TypeError("not a function");this._state=null,this._value=null,this._deferreds=[],i(a,b(e,this),b(f,this))}function d(a){var b=this;return null===this._state?void this._deferreds.push(a):void k(function(){var c=b._state?a.onFulfilled:a.onRejected;if(null===c)return void(b._state?a.resolve:a.reject)(b._value);var d;try{d=c(b._value)}catch(e){return void a.reject(e)}a.resolve(d)})}function e(a){try{if(a===this)throw new TypeError("A promise cannot be resolved with itself.");if(a&&("object"==typeof a||"function"==typeof a)){var c=a.then;if("function"==typeof c)return void i(b(c,a),b(e,this),b(f,this))}this._state=!0,this._value=a,g.call(this)}catch(d){f.call(this,d)}}function f(a){this._state=!1,this._value=a,g.call(this)}function g(){for(var a=0,b=this._deferreds.length;b>a;a++)d.call(this,this._deferreds[a]);this._deferreds=null}function h(a,b,c,d){this.onFulfilled="function"==typeof a?a:null,this.onRejected="function"==typeof b?b:null,this.resolve=c,this.reject=d}function i(a,b,c){var d=!1;try{a(function(a){d||(d=!0,b(a))},function(a){d||(d=!0,c(a))})}catch(e){if(d)return;d=!0,c(e)}}var j=setTimeout,k="function"==typeof setImmediate&&setImmediate||function(a){j(a,1)},l=Array.isArray||function(a){return"[object Array]"===Object.prototype.toString.call(a)};c.prototype["catch"]=function(a){return this.then(null,a)},c.prototype.then=function(a,b){var e=this;return new c(function(c,f){d.call(e,new h(a,b,c,f))})},c.all=function(){var a=Array.prototype.slice.call(1===arguments.length&&l(arguments[0])?arguments[0]:arguments);return new c(function(b,c){function d(f,g){try{if(g&&("object"==typeof g||"function"==typeof g)){var h=g.then;if("function"==typeof h)return void h.call(g,function(a){d(f,a)},c)}a[f]=g,0===--e&&b(a)}catch(i){c(i)}}if(0===a.length)return b([]);for(var e=a.length,f=0;f<a.length;f++)d(f,a[f])})},c.resolve=function(a){return a&&"object"==typeof a&&a.constructor===c?a:new c(function(b){b(a)})},c.reject=function(a){return new c(function(b,c){c(a)})},c.race=function(a){return new c(function(b,c){for(var d=0,e=a.length;e>d;d++)a[d].then(b,c)})},c._setImmediateFn=function(a){k=a},"undefined"!=typeof module&&module.exports?module.exports=c:a.Promise||(a.Promise=c)}(this);
// File:js/lib/signals.min.js

/*
 JS Signals <http://millermedeiros.github.com/js-signals/>
 Released under the MIT license
 Author: Miller Medeiros
 Version: 1.0.0 - Build: 268 (2012/11/29 05:48 PM)
*/
(function(i){function h(a,b,c,d,e){this._listener=b;this._isOnce=c;this.context=d;this._signal=a;this._priority=e||0}function g(a,b){if(typeof a!=="function")throw Error("listener is a required param of {fn}() and should be a Function.".replace("{fn}",b));}function e(){this._bindings=[];this._prevParams=null;var a=this;this.dispatch=function(){e.prototype.dispatch.apply(a,arguments)}}h.prototype={active:!0,params:null,execute:function(a){var b;this.active&&this._listener&&(a=this.params?this.params.concat(a):
a,b=this._listener.apply(this.context,a),this._isOnce&&this.detach());return b},detach:function(){return this.isBound()?this._signal.remove(this._listener,this.context):null},isBound:function(){return!!this._signal&&!!this._listener},isOnce:function(){return this._isOnce},getListener:function(){return this._listener},getSignal:function(){return this._signal},_destroy:function(){delete this._signal;delete this._listener;delete this.context},toString:function(){return"[SignalBinding isOnce:"+this._isOnce+
", isBound:"+this.isBound()+", active:"+this.active+"]"}};e.prototype={VERSION:"1.0.0",memorize:!1,_shouldPropagate:!0,active:!0,_registerListener:function(a,b,c,d){var e=this._indexOfListener(a,c);if(e!==-1){if(a=this._bindings[e],a.isOnce()!==b)throw Error("You cannot add"+(b?"":"Once")+"() then add"+(!b?"":"Once")+"() the same listener without removing the relationship first.");}else a=new h(this,a,b,c,d),this._addBinding(a);this.memorize&&this._prevParams&&a.execute(this._prevParams);return a},
_addBinding:function(a){var b=this._bindings.length;do--b;while(this._bindings[b]&&a._priority<=this._bindings[b]._priority);this._bindings.splice(b+1,0,a)},_indexOfListener:function(a,b){for(var c=this._bindings.length,d;c--;)if(d=this._bindings[c],d._listener===a&&d.context===b)return c;return-1},has:function(a,b){return this._indexOfListener(a,b)!==-1},add:function(a,b,c){g(a,"add");return this._registerListener(a,!1,b,c)},addOnce:function(a,b,c){g(a,"addOnce");return this._registerListener(a,
!0,b,c)},remove:function(a,b){g(a,"remove");var c=this._indexOfListener(a,b);c!==-1&&(this._bindings[c]._destroy(),this._bindings.splice(c,1));return a},removeAll:function(){for(var a=this._bindings.length;a--;)this._bindings[a]._destroy();this._bindings.length=0},getNumListeners:function(){return this._bindings.length},halt:function(){this._shouldPropagate=!1},dispatch:function(a){if(this.active){var b=Array.prototype.slice.call(arguments),c=this._bindings.length,d;if(this.memorize)this._prevParams=
b;if(c){d=this._bindings.slice();this._shouldPropagate=!0;do c--;while(d[c]&&this._shouldPropagate&&d[c].execute(b)!==!1)}}},forget:function(){this._prevParams=null},dispose:function(){this.removeAll();delete this._bindings;delete this._prevParams},toString:function(){return"[Signal active:"+this.active+" numListeners:"+this.getNumListeners()+"]"}};var f=e;f.Signal=e;typeof define==="function"&&define.amd?define(function(){return f}):typeof module!=="undefined"&&module.exports?module.exports=f:i.signals=
f})(this);
// File:js/lib/sprintf.min.js

/*! sprintf-js | Alexandru Marasteanu <hello@alexei.ro> (http://alexei.ro/) | BSD-3-Clause */

!function(a){function b(){var a=arguments[0],c=b.cache;return c[a]&&c.hasOwnProperty(a)||(c[a]=b.parse(a)),b.format.call(null,c[a],arguments)}function c(a){return Object.prototype.toString.call(a).slice(8,-1).toLowerCase()}function d(a,b){return Array(b+1).join(a)}var e={not_string:/[^s]/,number:/[diefg]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijosuxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/};b.format=function(a,f){var g,h,i,j,k,l,m,n=1,o=a.length,p="",q=[],r=!0,s="";for(h=0;o>h;h++)if(p=c(a[h]),"string"===p)q[q.length]=a[h];else if("array"===p){if(j=a[h],j[2])for(g=f[n],i=0;i<j[2].length;i++){if(!g.hasOwnProperty(j[2][i]))throw new Error(b("[sprintf] property '%s' does not exist",j[2][i]));g=g[j[2][i]]}else g=j[1]?f[j[1]]:f[n++];if("function"==c(g)&&(g=g()),e.not_string.test(j[8])&&e.not_json.test(j[8])&&"number"!=c(g)&&isNaN(g))throw new TypeError(b("[sprintf] expecting number but found %s",c(g)));switch(e.number.test(j[8])&&(r=g>=0),j[8]){case"b":g=g.toString(2);break;case"c":g=String.fromCharCode(g);break;case"d":case"i":g=parseInt(g,10);break;case"j":g=JSON.stringify(g,null,j[6]?parseInt(j[6]):0);break;case"e":g=j[7]?g.toExponential(j[7]):g.toExponential();break;case"f":g=j[7]?parseFloat(g).toFixed(j[7]):parseFloat(g);break;case"g":g=j[7]?parseFloat(g).toPrecision(j[7]):parseFloat(g);break;case"o":g=g.toString(8);break;case"s":g=(g=String(g))&&j[7]?g.substring(0,j[7]):g;break;case"u":g>>>=0;break;case"x":g=g.toString(16);break;case"X":g=g.toString(16).toUpperCase()}e.json.test(j[8])?q[q.length]=g:(!e.number.test(j[8])||r&&!j[3]?s="":(s=r?"+":"-",g=g.toString().replace(e.sign,"")),l=j[4]?"0"===j[4]?"0":j[4].charAt(1):" ",m=j[6]-(s+g).length,k=j[6]&&m>0?d(l,m):"",q[q.length]=j[5]?s+g+k:"0"===l?s+k+g:k+s+g)}return q.join("")},b.cache={},b.parse=function(a){for(var b=a,c=[],d=[],f=0;b;){if(null!==(c=e.text.exec(b)))d[d.length]=c[0];else if(null!==(c=e.modulo.exec(b)))d[d.length]="%";else{if(null===(c=e.placeholder.exec(b)))throw new SyntaxError("[sprintf] unexpected placeholder");if(c[2]){f|=1;var g=[],h=c[2],i=[];if(null===(i=e.key.exec(h)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(g[g.length]=i[1];""!==(h=h.substring(i[0].length));)if(null!==(i=e.key_access.exec(h)))g[g.length]=i[1];else{if(null===(i=e.index_access.exec(h)))throw new SyntaxError("[sprintf] failed to parse named argument key");g[g.length]=i[1]}c[2]=g}else f|=2;if(3===f)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");d[d.length]=c}b=b.substring(c[0].length)}return d};var f=function(a,c,d){return d=(c||[]).slice(0),d.splice(0,0,a),b.apply(null,d)};"undefined"!=typeof exports?(exports.sprintf=b,exports.vsprintf=f):(a.sprintf=b,a.vsprintf=f,"function"==typeof define&&define.amd&&define(function(){return{sprintf:b,vsprintf:f}}))}("undefined"==typeof window?this:window);
// File:js/lib/svd.min.js

var jsfeat=jsfeat||{REVISION:"ALPHA"};
(function(f){var E=new Int32Array([-1,1,4,-1,4,-1,-1,-1,8,-1,-1,-1,-1,-1,-1,-1,8]),d=function(){return function(a){return a&65280}}(),g=function(){return function(a){return a&255}}(),a=function(){return function(a){return E[(a&65280)>>8]}}(),b=function(){return function(a,b){this.size=(a+7|0)&-8;"undefined"===typeof b?this.buffer=new ArrayBuffer(this.size):(this.buffer=b,this.size=b.length);this.u8=new Uint8Array(this.buffer);this.i32=new Int32Array(this.buffer);this.f32=new Float32Array(this.buffer);
this.f64=new Float64Array(this.buffer)}}(),h=function(){function h(a,b,c,m){this.type=d(c)|0;this.channel=g(c)|0;this.cols=a|0;this.rows=b|0;"undefined"===typeof m?this.allocate():(this.buffer=m,this.data=this.type&256?this.buffer.u8:this.type&512?this.buffer.i32:this.type&1024?this.buffer.f32:this.buffer.f64)}h.prototype.allocate=function(){delete this.data;delete this.buffer;this.buffer=new b(this.cols*a(this.type)*this.channel*this.rows);this.data=this.type&256?this.buffer.u8:this.type&512?this.buffer.i32:
this.type&1024?this.buffer.f32:this.buffer.f64};h.prototype.copy_to=function(a){a=a.data;for(var b=this.data,c=0,d=this.cols*this.rows*this.channel|0;c<d-4;c+=4)a[c]=b[c],a[c+1]=b[c+1],a[c+2]=b[c+2],a[c+3]=b[c+3];for(;c<d;++c)a[c]=b[c]};h.prototype.resize=function(a,b,c){"undefined"===typeof c&&(c=this.channel);a*c*b>this.rows*this.cols*this.channel?(this.cols=a,this.rows=b,this.channel=c,this.allocate()):(this.cols=a,this.rows=b,this.channel=c)};return h}();f.U8_t=256;f.S32_t=512;f.F32_t=1024;f.S64_t=
2048;f.F64_t=4096;f.C1_t=1;f.C2_t=2;f.C3_t=3;f.C4_t=4;f.U8C1_t=257;f.U8C3_t=259;f.U8C4_t=260;f.F32C1_t=1025;f.F32C2_t=1026;f.S32C1_t=513;f.S32C2_t=514;f.EPSILON=1.192092896E-7;f.FLT_MIN=1E-37;f.BOX_BLUR_NOSCALE=1;f.SVD_U_T=1;f.SVD_V_T=2;f.get_data_type=d;f.get_channel=g;f.get_data_type_size=a;f.data_t=b;f.matrix_t=h})(jsfeat);
(function(f){var E=function(){return{transpose:function(d,g){for(var a=0,b=0,h=g.rows,m=g.cols,k=0,p=0,c=0,f=g.data,y=d.data;a<h;p+=1,k+=m,a++)for(c=p,b=0;b<m;c+=h,b++)y[c]=f[k+b]},multiply:function(d,g,a){var b=0,h=0,m=0,k=0,p=0,c=0,f=0,y=0,q=g.cols,r=g.rows,t=a.cols;g=g.data;a=a.data;d=d.data;for(var z=0;b<r;k+=q,b++)for(h=f=0;h<t;y++,f++,h++){c=f;p=k;for(m=z=0;m<q;p++,c+=t,m++)z+=g[p]*a[c];d[y]=z}},multiply_ABt:function(d,g,a){var b=0,h=0,m=0,k=0,p=0,c=0,f=0,y=g.cols,q=g.rows,r=a.rows;g=g.data;
a=a.data;d=d.data;for(var t=0;b<q;k+=y,b++)for(h=c=0;h<r;f++,h++){p=k;for(m=t=0;m<y;p++,c++,m++)t+=g[p]*a[c];d[f]=t}},multiply_AtB:function(d,g,a){var b=0,h=0,m=0,k=0,p=0,c=0,f=0,y=0,q=g.cols,r=g.rows,t=a.cols;g=g.data;a=a.data;d=d.data;for(var z=0;b<q;k++,b++)for(h=f=0;h<t;y++,f++,h++){c=f;p=k;for(m=z=0;m<r;p+=q,c+=t,m++)z+=g[p]*a[c];d[y]=z}},invert_3x3:function(d,g){var a=d.data,b=g.data,h=a[4],m=a[8],k=a[5],f=a[7],c=a[0],J=c*h,y=c*k,q=a[3],r=a[1],t=q*r,z=a[2],N=q*z,a=a[6],O=a*r,F=a*z,D=1/(J*m-
y*f-t*m+N*f+O*k-F*h);b[0]=(h*m-k*f)*D;b[1]=-(r*m-z*f)*D;b[2]=-(-r*k+z*h)*D;b[3]=-(q*m-k*a)*D;b[4]=(c*m-F)*D;b[5]=-(y-N)*D;b[6]=-(-q*f+h*a)*D;b[7]=-(c*f-O)*D;b[8]=(J-t)*D},mat3x3_determinant:function(d){d=d.data;return d[0]*d[4]*d[8]-d[0]*d[5]*d[7]-d[3]*d[1]*d[8]+d[3]*d[2]*d[7]+d[6]*d[1]*d[5]-d[6]*d[2]*d[4]},multiply_3x3:function(d,g,a){d=d.data;var b=g.data,h=a.data;a=b[0];g=b[1];var m=b[2],k=b[3],f=b[4],c=b[5],J=b[6],y=b[7],b=b[8],q=h[0],r=h[1],t=h[2],z=h[3],N=h[4],O=h[5],F=h[6],D=h[7],h=h[8];d[0]=
a*q+g*z+m*F;d[1]=a*r+g*N+m*D;d[2]=a*t+g*O+m*h;d[3]=k*q+f*z+c*F;d[4]=k*r+f*N+c*D;d[5]=k*t+f*O+c*h;d[6]=J*q+y*z+b*F;d[7]=J*r+y*N+b*D;d[8]=J*t+y*O+b*h},mean_rows:function(d){var g,a=0,b=d.rows,h=d.cols,m=d.data,f=Array(h);for(g=0;g<h;++g)f[g]=0;for(d=0;d<b;++d)for(g=0;g<h;++g,++a)f[g]+=m[a];for(g=0;g<h;++g)f[g]/=b;return f},mean_cols:function(d){var g,a=0,b=d.rows,h=d.cols,f=d.data,k=Array(b);for(g=0;g<b;++g)k[g]=0;for(d=0;d<h;++d)for(g=0;g<b;++g,++a)k[g]+=f[a];for(g=0;g<b;++g)k[g]/=h;return k},sub_rows:function(d,
g){var a,b,h=0,f=d.rows,k=d.cols,p=d.data;for(a=0;a<f;++a)for(b=0;b<k;++b,++h)p[h]-=g[b]},sub_cols:function(d,g){var a,b,h=0,f=d.rows,k=d.cols,p=d.data;for(a=0;a<k;++a)for(b=0;b<f;++b,++h)p[h]-=g[b]},add_rows:function(d,g){var a,b,h=0,f=d.rows,k=d.cols,p=d.data;for(a=0;a<f;++a)for(b=0;b<k;++b,++h)p[h]+=g[b]},add_cols:function(d,g){var a,b,h=0,f=d.rows,k=d.cols,p=d.data;for(a=0;a<k;++a)for(b=0;b<f;++b,++h)p[h]+=g[b]}}}();f.matmath=E})(jsfeat);
(function(f){var E=function(){var d=function(){function a(b){this.next=null;this.data=new jsfeat.data_t(b);this.size=this.data.size;this.buffer=this.data.buffer;this.u8=this.data.u8;this.i32=this.data.i32;this.f32=this.data.f32;this.f64=this.data.f64}a.prototype.resize=function(a){delete this.data;this.data=new jsfeat.data_t(a);this.size=this.data.size;this.buffer=this.data.buffer;this.u8=this.data.u8;this.i32=this.data.i32;this.f32=this.data.f32;this.f64=this.data.f64};return a}(),g,a,b=0;return{allocate:function(h,
f){g=a=new d(f);for(var k=0;k<h;++k){var p=new d(f);a=a.next=p;b++}},get_buffer:function(a){var d=g;g=g.next;b--;a>d.size&&d.resize(a);return d},put_buffer:function(d){a=a.next=d;b++}}}();f.cache=E;E.allocate(30,2560)})(jsfeat);
(function(f){var E=function(){var d=function(a,b,d,g){g=a[b];a[b]=a[d];a[d]=g},g=function(a,b){a=Math.abs(a);b=Math.abs(b);return a>b?(b/=a,a*Math.sqrt(1+b*b)):0<b?(a/=b,b*Math.sqrt(1+a*a)):0};return{svd_decompose:function(a,b,f,m,k){"undefined"===typeof k&&(k=0);var p=0,c=0,J=a.rows,y=a.cols,q=J,r=y,t=a.type|jsfeat.C1_t;q<r&&(p=1,c=q,q=r,r=c);var z=jsfeat.cache.get_buffer(q*q<<3),N=jsfeat.cache.get_buffer(r<<3),O=jsfeat.cache.get_buffer(r*r<<3),F=new jsfeat.matrix_t(q,q,t,z.data),D=new jsfeat.matrix_t(1,
r,t,N.data),t=new jsfeat.matrix_t(r,r,t,O.data);if(0==p)jsfeat.matmath.transpose(F,a);else{for(c=0;c<y*J;c++)F.data[c]=a.data[c];for(;c<r*q;c++)F.data[c]=0}a=F.data;for(var c=q,J=D.data,u=t.data,E=r,H=q,I=r,T=q,U=2*jsfeat.EPSILON,V=jsfeat.FLT_MIN,l=0,x=0,e=0,P=0,W=Math.max(H,30),n=0,v=0,Q=v=n=0,w=0,C=0,G=0,s=0,B=0,A=0,K=w=e=w=0,L=s=0,R=4660,n=n=x=0,S=jsfeat.cache.get_buffer(I<<3),M=S.f64;l<I;l++){for(A=e=0;e<H;e++)G=a[l*c+e],A+=G*G;M[l]=A;if(u){for(e=0;e<I;e++)u[l*E+e]=0;u[l*E+l]=1}}for(;P<W;P++){for(l=
Q=0;l<I-1;l++)for(x=l+1;x<I;x++){n=l*c|0;v=x*c|0;K=M[l];s=0;L=M[x];e=2;s+=a[n]*a[v];for(s+=a[n+1]*a[v+1];e<H;e++)s+=a[n+e]*a[v+e];if(!(Math.abs(s)<=U*Math.sqrt(K*L))){s*=2;w=K-L;e=g(s,w);0>w?(w=.5*(e-w),C=Math.sqrt(w/e),w=s/(e*C*2)):(w=Math.sqrt((e+w)/(2*e)),C=s/(e*w*2));L=K=0;e=2;s=w*a[n]+C*a[v];B=-C*a[n]+w*a[v];a[n]=s;a[v]=B;K+=s*s;L+=B*B;s=w*a[n+1]+C*a[v+1];B=-C*a[n+1]+w*a[v+1];a[n+1]=s;a[v+1]=B;K+=s*s;for(L+=B*B;e<H;e++)s=w*a[n+e]+C*a[v+e],B=-C*a[n+e]+w*a[v+e],a[n+e]=s,a[v+e]=B,K+=s*s,L+=B*B;
M[l]=K;M[x]=L;Q=1;if(u)for(n=l*E|0,v=x*E|0,e=2,s=w*u[n]+C*u[v],B=-C*u[n]+w*u[v],u[n]=s,u[v]=B,s=w*u[n+1]+C*u[v+1],B=-C*u[n+1]+w*u[v+1],u[n+1]=s,u[v+1]=B;e<I;e++)s=w*u[n+e]+C*u[v+e],B=-C*u[n+e]+w*u[v+e],u[n+e]=s,u[v+e]=B}}if(0==Q)break}for(l=0;l<I;l++){for(A=e=0;e<H;e++)G=a[l*c+e],A+=G*G;M[l]=Math.sqrt(A)}for(l=0;l<I-1;l++){x=l;for(e=l+1;e<I;e++)M[x]<M[e]&&(x=e);if(l!=x&&(d(M,l,x,A),u)){for(e=0;e<H;e++)d(a,l*c+e,x*c+e,G);for(e=0;e<I;e++)d(u,l*E+e,x*E+e,G)}}for(l=0;l<I;l++)J[l]=M[l];if(u)for(l=0;l<
T;l++){for(A=l<I?M[l]:0;A<=V;){n=1/H;for(e=0;e<H;e++)R=214013*R+2531011,x=0!=(R>>16&256)?n:-n,a[l*c+e]=x;for(P=0;2>P;P++)for(x=0;x<l;x++){for(e=A=0;e<H;e++)A+=a[l*c+e]*a[x*c+e];for(e=n=0;e<H;e++)G=a[l*c+e]-A*a[x*c+e],a[l*c+e]=G,n+=Math.abs(G);n=n?1/n:0;for(e=0;e<H;e++)a[l*c+e]*=n}for(e=A=0;e<H;e++)G=a[l*c+e],A+=G*G;A=Math.sqrt(A)}C=1/A;for(e=0;e<H;e++)a[l*c+e]*=C}jsfeat.cache.put_buffer(S);if(b){for(c=0;c<r;c++)b.data[c]=D.data[c];for(;c<y;c++)b.data[c]=0}if(0==p){if(f&&k&jsfeat.SVD_U_T)for(c=q*q;0<=
--c;)f.data[c]=F.data[c];else f&&jsfeat.matmath.transpose(f,F);if(m&&k&jsfeat.SVD_V_T)for(c=r*r;0<=--c;)m.data[c]=t.data[c];else m&&jsfeat.matmath.transpose(m,t)}else{if(f&&k&jsfeat.SVD_U_T)for(c=r*r;0<=--c;)f.data[c]=t.data[c];else f&&jsfeat.matmath.transpose(f,t);if(m&&k&jsfeat.SVD_V_T)for(c=q*q;0<=--c;)m.data[c]=F.data[c];else m&&jsfeat.matmath.transpose(m,F)}jsfeat.cache.put_buffer(z);jsfeat.cache.put_buffer(N);jsfeat.cache.put_buffer(O)}}}();f.linalg=E})(jsfeat);

// File:js/lib/TypedFastBitSet.js

/**
 * FastBitSet.js : a fast bit set implementation in JavaScript.
 * (c) the authors
 * Licensed under the Apache License, Version 2.0.
 *
 * Speed-optimized BitSet implementation for modern browsers and JavaScript engines.
 *
 * A BitSet is an ideal data structure to implement a Set when values being stored are
 * reasonably small integers. It can be orders of magnitude faster than a generic set implementation.
 * The FastBitSet implementation optimizes for speed, leveraging commonly available features
 * like typed arrays.
 *
 * Simple usage :
 *  var b = new TypedFastBitSet();// initially empty
 *         // will throw exception if typed arrays are not supported
 *  b.add(1);// add the value "1"
 *  b.has(1); // check that the value is present! (will return true)
 *  b.add(2);
 *  console.log(""+b);// should display {1,2}
 *  b.add(10);
 *  b.array(); // would return [1,2,10]
 *
 *  var c = new TypedFastBitSet([1,2,3,10]); // create bitset initialized with values 1,2,3,10
 *  c.difference(b); // from c, remove elements that are in b
 *  var su = c.union_size(b);// compute the size of the union (bitsets are unchanged)
 * c.union(b); // c will contain all elements that are in c and b
 * var s1 = c.intersection_size(b);// compute the size of the intersection (bitsets are unchanged)
 * c.intersection(b); // c will only contain elements that are in both c and b
 * c = b.clone(); // create a (deep) copy of b and assign it to c.
 * c.equals(b); // check whether c and b are equal
 *
 *   See README.md file for a more complete description.
 *
 * You can install the library under node with the command line
 *   npm install fastbitset
 */
'use strict';

// you can provide an iterable
// an exception is thrown if typed arrays are not supported
// - added size argument, ASR
// - added flip argument, ASR
function TypedFastBitSet(size, flip) {
  this.count = 0 | 0;
  this.words = new Uint32Array(8);
  this.resize(size);
  if (flip) {
    this.flip_all();
  }
}

// Add the value (Set the bit at index to true)
TypedFastBitSet.prototype.add = function(index) {
  if ((this.count << 5) <= index) {
    this.resize(index);
  }
  this.words[index >>> 5] |= 1 << index ;
};

// Add the value (Set the bit at index to true)
// - unsafe because size is not checked, added by ASR
TypedFastBitSet.prototype.add_unsafe = function(index) {
  this.words[index >>> 5] |= 1 << index ;
};

// If the value was not in the set, add it, otherwise remove it (flip bit at index)
TypedFastBitSet.prototype.flip = function(index) {
  if ((this.count << 5) <= index) {
    this.resize(index);
  }
  this.words[index >>> 5] ^= 1 << index ;
};

// If the value was not in the set, add it, otherwise remove it (flip bit at index)
// - unsafe because size is not checked, added by ASR
TypedFastBitSet.prototype.flip_unsafe = function(index) {
  this.words[index >>> 5] ^= 1 << index ;
};

// Flip all bits, added by ASR
TypedFastBitSet.prototype.flip_all = function() {
  // FIXME sets values beyond this.length
  var count = this.count;
  var k = 0 | 0;
  for (; k + 7 < count; k += 8) {
    this.words[k    ] = ~this.words[k    ];
    this.words[k + 1] = ~this.words[k + 1];
    this.words[k + 2] = ~this.words[k + 2];
    this.words[k + 3] = ~this.words[k + 3];
    this.words[k + 4] = ~this.words[k + 4];
    this.words[k + 5] = ~this.words[k + 5];
    this.words[k + 6] = ~this.words[k + 6];
    this.words[k + 7] = ~this.words[k + 7];
  }
  for (; k < count; ++k) {
    this.words[k] = ~this.words[k];
  }
  return this;
};

// Set all bits to value, added by ASR
TypedFastBitSet.prototype.set_all = function(value) {
  if (this.length <= 0) return this;
  this.set_range( 0, this.length-1, value );
  return this;
};

// Set all bits in range to value, added by ASR
TypedFastBitSet.prototype.set_range = function(from, to, value) {
  // set complete words when applicable
  value = value ? 0xFFFFFFFF : 0x00000000;
  var wordStart = (from >>> 5) + 1;
  var wordEnd = (to >>> 5) - 1;
  var k = wordStart | 0;
  for (; k + 7 < wordEnd; k += 8) {
    this.words[k    ] = value;
    this.words[k + 1] = value;
    this.words[k + 2] = value;
    this.words[k + 3] = value;
    this.words[k + 4] = value;
    this.words[k + 5] = value;
    this.words[k + 6] = value;
    this.words[k + 7] = value;
  }
  for (; k < wordEnd; ++k) {
    this.words[k] = value;
  }
  // set parts of the range not spanning complete words
  if (value){
    for (var i = from, n = (wordStart << 5) + 1; i < n; ++i) {
      this.words[i >>> 5] |= 1 << i ;
    }
    for (var i = (wordEnd << 5), n = to + 1; i < n; ++i) {
      this.words[i >>> 5] |= 1 << i ;
    }
  }else{
    for (var i = from, n = (wordStart << 5) + 1; i < n; ++i) {
      this.words[i >>> 5] &= ~(1 << i);
    }
    for (var i = (wordEnd << 5), n = to + 1; i < n; ++i) {
      this.words[i >>> 5] &= ~(1 << i);
    }
  }
  return this;
};

// Remove all values, reset memory usage
TypedFastBitSet.prototype.clear = function() {
  this.count = 0 | 0;
  this.length = 0 | 0;
  this.words = new Uint32Array(count);
  return this;
};

// Set the bit at index to false
TypedFastBitSet.prototype.remove = function(index) {
  if ((this.count << 5) <= index) {
    this.resize(index);
  }
  this.words[index >>> 5] &= ~(1 << index);
};

// Set the bit at index to false
// - unsafe because size is not checked, added by ASR
TypedFastBitSet.prototype.remove_unsafe = function(index) {
  this.words[index >>> 5] &= ~(1 << index);
};

// Return true if no bit is set
TypedFastBitSet.prototype.isEmpty = function(index) {
  var c = this.count;
  for (var  i = 0; i < c; i++) {
    if (this.words[i] !== 0) return false;
  }
  return true;
};

// Is the value contained in the set? Is the bit at index true or false? Returns a boolean
TypedFastBitSet.prototype.has = function(index) {
  return (this.words[index >>> 5] & (1 << index)) !== 0;
};

// Reduce the memory usage to a minimum
TypedFastBitSet.prototype.trim = function(index) {
  while (this.count > 0) {
    if (this.words[this.count - 1] === 0)
      this.count--;
  }
  this.words = this.words.slice(0,this.count);
};

// Resize the bitset so that we can write a value at index
TypedFastBitSet.prototype.resize = function(index) {
  this.length = index;
  if ((this.count << 5) > index) {
    return; //nothing to do
  }
  this.count = (index + 32) >>> 5;// just what is needed
  if ((this.words.length << 5) <= index) {
    var newwords = new Uint32Array(this.count << 1);
    newwords.set(this.words);// hopefully, this copy is fast
    this.words = newwords;
  }
};

// fast function to compute the Hamming weight of a 32-bit unsigned integer
TypedFastBitSet.prototype.hammingWeight = function(v) {
  v -= ((v >>> 1) & 0x55555555);// works with signed or unsigned shifts
  v = (v & 0x33333333) + ((v >>> 2) & 0x33333333);
  return ((v + (v >>> 4) & 0xF0F0F0F) * 0x1010101) >>> 24;
};


// How many values stored in the set? How many set bits?
TypedFastBitSet.prototype.size = function() {
  var answer = 0;
  var c = this.count;
  for (var i = 0; i < c; i++) {
    answer += this.hammingWeight(this.words[i] | 0);
  }
  return answer;
};

// How many bits are set in the given range of the set?
// - added by ASR
TypedFastBitSet.prototype.sizeRange = function(offset, count) {
  var size = 0;
  var end = offset + count;
  this.forEach( function( index ){
      if( index >= offset && index < end ) ++size;
  } );
  return size;
};

// Return an array with the set bit locations (values)
// - use Uint32Array instead of Array, ASR
TypedFastBitSet.prototype.array = function() {
  var answer = new Uint32Array(this.size());
  var pos = 0 | 0;
  var c = this.count | 0;
  for (var k = 0; k < c; ++k) {
    var w =  this.words[k];
    while (w != 0) {
      var t = w & -w;
      answer[pos++] = (k << 5) + this.hammingWeight((t - 1) | 0);
      w ^= t;
    }
  }
  return answer;
};


// Call fnc with the set bit locations (values)
// - fixed method description, ASR
TypedFastBitSet.prototype.forEach = function(fnc) {
  var c = this.count | 0;
  var i = 0 | 0;
  for (var k = 0; k < c; ++k) {
    var w = this.words[k];
    while (w != 0) {
      var t = w & -w;
      var index = (k << 5) + this.hammingWeight((t - 1) | 0);
      // FIXME workaround, it should not be required to check the length
      if(index < this.length) fnc(index,i);
      w ^= t;
      i += 1;
    }
  }
};

TypedFastBitSet.forEach = function(fnc, bitmap1, bitmap2) {
  var c = Math.min(bitmap1.count, bitmap2.count) | 0;
  for (var k = 0; k < c; ++k) {
    var w1 = bitmap1.words[k];
    var w2 = bitmap2.words[k];
    while (w1 != 0 && w2 != 0) {
      var t1 = w1 & -w1;
      var t2 = w2 & -w2;
      var kShift = k << 5;
      fnc(
        kShift + bitmap1.hammingWeight((t1 - 1) | 0),
        kShift + bitmap2.hammingWeight((t2 - 1) | 0)
      );
      w1 ^= t1;
      w2 ^= t2;
    }
  }
};

// Creates a copy of this bitmap
TypedFastBitSet.prototype.clone = function() {
  var clone = Object.create(TypedFastBitSet.prototype);
  clone.count = this.count;
  clone.length = this.length;
  clone.words = new Uint32Array(this.words);
  return clone;
};

// Check if this bitset intersects with another one,
// no bitmap is modified
TypedFastBitSet.prototype.intersects = function(otherbitmap) {
  var newcount = Math.min(this.count,otherbitmap.count);
  for (var k = 0 | 0; k < newcount; ++k) {
    if ((this.words[k] & otherbitmap.words[k]) !== 0) return true;
  }
  return false;
};

// Computes the intersection between this bitset and another one,
// the current bitmap is modified  (and returned by the function)
TypedFastBitSet.prototype.intersection = function(otherbitmap) {
  var newcount = Math.min(this.count,otherbitmap.count);
  var k = 0 | 0;
  for (; k + 7 < newcount; k += 8) {
    this.words[k    ] &= otherbitmap.words[k    ];
    this.words[k + 1] &= otherbitmap.words[k + 1];
    this.words[k + 2] &= otherbitmap.words[k + 2];
    this.words[k + 3] &= otherbitmap.words[k + 3];
    this.words[k + 4] &= otherbitmap.words[k + 4];
    this.words[k + 5] &= otherbitmap.words[k + 5];
    this.words[k + 6] &= otherbitmap.words[k + 6];
    this.words[k + 7] &= otherbitmap.words[k + 7];
  }
  for (; k < newcount; ++k) {
    this.words[k] &= otherbitmap.words[k];
  }
  var c = this.count;
  for (var k = newcount; k < c; ++k) {
    this.words[k] = 0;
  }
  this.count = newcount;
  return this;
};

// Computes the size of the intersection between this bitset and another one
TypedFastBitSet.prototype.intersection_size = function(otherbitmap) {
  var newcount = Math.min(this.count,otherbitmap.count);
  var answer = 0 | 0;
  for (var k = 0 | 0; k < newcount; ++k) {
    answer += this.hammingWeight(this.words[k] & otherbitmap.words[k]);
  }
  return answer;
};

// Computes the intersection between this bitset and another one,
// a new bitmap is generated
TypedFastBitSet.prototype.new_intersection = function(otherbitmap) {
  var answer = Object.create(TypedFastBitSet.prototype);
  answer.count = Math.min(this.count,otherbitmap.count);
  answer.words = new Uint32Array(answer.count);
  answer.length = Math.min(this.length,otherbitmap.length);
  var c = answer.count;
  for (var k = 0 | 0; k < c; ++k) {
    answer.words[k] = this.words[k] & otherbitmap.words[k];
  }
  return answer;
};

// Computes the intersection between this bitset and another one,
// the current bitmap is modified
TypedFastBitSet.prototype.equals = function(otherbitmap) {
  var mcount = Math.min(this.count , otherbitmap.count);
  for (var k = 0 | 0; k < mcount; ++k) {
    if (this.words[k] != otherbitmap.words[k]) return false;
  }
  if (this.count < otherbitmap.count) {
    var c = otherbitmap.count;
    for (var k = this.count; k < c; ++k) {
      if (otherbitmap.words[k] != 0) return false;
    }
  } else if (otherbitmap.count < this.count) {
    var c = this.count;
    for (var k = otherbitmap.count; k < c; ++k) {
      if (this.words[k] != 0) return false;
    }
  }
  return true;
};

// Computes the difference between this bitset and another one,
// the current bitset is modified (and returned by the function)
TypedFastBitSet.prototype.difference = function(otherbitmap) {
  var newcount = Math.min(this.count,otherbitmap.count);
  var k = 0 | 0;
  for (; k + 7 < newcount; k += 8) {
    this.words[k    ] &= ~otherbitmap.words[k    ];
    this.words[k + 1] &= ~otherbitmap.words[k + 1];
    this.words[k + 2] &= ~otherbitmap.words[k + 2];
    this.words[k + 3] &= ~otherbitmap.words[k + 3];
    this.words[k + 4] &= ~otherbitmap.words[k + 4];
    this.words[k + 5] &= ~otherbitmap.words[k + 5];
    this.words[k + 6] &= ~otherbitmap.words[k + 6];
    this.words[k + 7] &= ~otherbitmap.words[k + 7];
  }
  for (; k < newcount; ++k) {
    this.words[k] &= ~otherbitmap.words[k];
  }
  return this;
};

// Computes the size of the difference between this bitset and another one
TypedFastBitSet.prototype.difference_size = function(otherbitmap) {
  var newcount = Math.min(this.count,otherbitmap.count);
  var answer = 0 | 0;
  var k = 0 | 0;
  for (; k < newcount; ++k) {
    answer += this.hammingWeight(this.words[k] & (~otherbitmap.words[k]));
  }
  var c = this.count;
  for (; k < c; ++k) {
    answer += this.hammingWeight(this.words[k]);
  }
  return answer;
};

// Returns a string representation
TypedFastBitSet.prototype.toString = function() {
  return '{' + this.array().join(',') + '}';
};

// Computes the union between this bitset and another one,
// the current bitset is modified  (and returned by the function)
TypedFastBitSet.prototype.union = function(otherbitmap) {
  var mcount = Math.min(this.count,otherbitmap.count);
  var k = 0 | 0;
  for (; k + 7  < mcount; k += 8) {
    this.words[k    ] |= otherbitmap.words[k    ];
    this.words[k + 1] |= otherbitmap.words[k + 1];
    this.words[k + 2] |= otherbitmap.words[k + 2];
    this.words[k + 3] |= otherbitmap.words[k + 3];
    this.words[k + 4] |= otherbitmap.words[k + 4];
    this.words[k + 5] |= otherbitmap.words[k + 5];
    this.words[k + 6] |= otherbitmap.words[k + 6];
    this.words[k + 7] |= otherbitmap.words[k + 7];
  }
  for (; k < mcount; ++k) {
    this.words[k] |= otherbitmap.words[k];
  }
  if (this.count < otherbitmap.count) {
    this.resize((otherbitmap.count  << 5) - 1);
    var c = otherbitmap.count;
    for (var k = mcount; k < c; ++k) {
      this.words[k] = otherbitmap.words[k];
    }
    this.count = otherbitmap.count;
  }
  return this;
};

// Computes the union between this bitset and another one,
// a new bitmap is generated
TypedFastBitSet.prototype.new_union = function(otherbitmap) {
  var answer = Object.create(TypedFastBitSet.prototype);
  answer.count = Math.max(this.count,otherbitmap.count);
  answer.words = new Uint32Array(answer.count);
  var mcount = Math.min(this.count,otherbitmap.count)
  for (var k = 0; k < mcount; ++k) {
      answer.words[k] = this.words[k] | otherbitmap.words[k];
  }
  var c = this.count;
  for (var k = mcount; k < c; ++k) {
      answer.words[k] = this.words[k] ;
  }
  var c2 = otherbitmap.count;
  for (var k = mcount; k < c2; ++k) {
      answer.words[k] = otherbitmap.words[k] ;
  }
  return answer;
};

// Computes the difference between this bitset and another one,
// a new bitmap is generated
TypedFastBitSet.prototype.new_difference = function(otherbitmap) {
  return this.clone().difference(otherbitmap);// should be fast enough
};

// Computes the size union between this bitset and another one
TypedFastBitSet.prototype.union_size = function(otherbitmap) {
  var mcount = Math.min(this.count,otherbitmap.count);
  var answer = 0 | 0;
  for (var k = 0 | 0; k < mcount; ++k) {
    answer += this.hammingWeight(this.words[k] | otherbitmap.words[k]);
  }
  if (this.count < otherbitmap.count) {
    var c = otherbitmap.count;
    for (var k = this.count ; k < c; ++k) {
      answer += this.hammingWeight(otherbitmap.words[k] | 0);
    }
  } else {
    var c = this.count;
    for (var k = otherbitmap.count ; k < c; ++k) {
      answer += this.hammingWeight(this.words[k] | 0);
    }
  }
  return answer;
};

// Get transferable objects, added by ASR
TypedFastBitSet.prototype.getTransferable = function() {
  return [ this.words ];
};

// Serialize to JSON, added by ASR
TypedFastBitSet.prototype.toJSON = function() {
  return {
    count: this.count,
    length: this.length,
    words: this.words
  };
};

// De-serialize from JSON, added by ASR
TypedFastBitSet.prototype.fromJSON = function(input) {
  this.count = input.count;
  this.length = input.length;
  this.words = input.words;
  return this;
};

// File:js/lib/msgpack-decode.js

var decodeMsgpack=function(){"use strict";function r(r){function t(r){for(var t={},e=0;r>e;e++){var n=a();t[n]=a()}return t}function e(t){var e=r.subarray(i,i+t);return i+=t,e}function n(t){var e=r.subarray(i,i+t);i+=t;var n=65535;if(t>n){for(var u=[],a=0;a<e.length;a+=n)u.push(String.fromCharCode.apply(null,e.subarray(a,a+n)));return u.join("")}return String.fromCharCode.apply(null,e)}function u(r){for(var t=new Array(r),e=0;r>e;e++)t[e]=a();return t}function a(){var a,s,g,U=r[i];if(0===(128&U))return i++,U;if(128===(240&U))return s=15&U,i++,t(s);if(144===(240&U))return s=15&U,i++,u(s);if(160===(224&U))return s=31&U,i++,n(s);if(224===(224&U))return a=c.getInt8(i),i++,a;switch(U){case 192:return i++,null;case 194:return i++,!1;case 195:return i++,!0;case 196:return s=c.getUint8(i+1),i+=2,e(s);case 197:return s=c.getUint16(i+1),i+=3,e(s);case 198:return s=c.getUint32(i+1),i+=5,e(s);case 199:return s=c.getUint8(i+1),g=c.getUint8(i+2),i+=3,[g,e(s)];case 200:return s=c.getUint16(i+1),g=c.getUint8(i+3),i+=4,[g,e(s)];case 201:return s=c.getUint32(i+1),g=c.getUint8(i+5),i+=6,[g,e(s)];case 202:return a=c.getFloat32(i+1),i+=5,a;case 203:return a=c.getFloat64(i+1),i+=9,a;case 204:return a=r[i+1],i+=2,a;case 205:return a=c.getUint16(i+1),i+=3,a;case 206:return a=c.getUint32(i+1),i+=5,a;case 207:return i+=9,0;case 208:return a=c.getInt8(i+1),i+=2,a;case 209:return a=c.getInt16(i+1),i+=3,a;case 210:return a=c.getInt32(i+1),i+=5,a;case 211:return i+=9,0;case 212:return g=c.getUint8(i+1),i+=2,[g,e(1)];case 213:return g=c.getUint8(i+1),i+=2,[g,e(2)];case 214:return g=c.getUint8(i+1),i+=2,[g,e(4)];case 215:return g=c.getUint8(i+1),i+=2,[g,e(8)];case 216:return g=c.getUint8(i+1),i+=2,[g,e(16)];case 217:return s=c.getUint8(i+1),i+=2,n(s);case 218:return s=c.getUint16(i+1),i+=3,n(s);case 219:return s=c.getUint32(i+1),i+=5,n(s);case 220:return s=c.getUint16(i+1),i+=3,u(s);case 221:return s=c.getUint32(i+1),i+=5,u(s);case 222:return s=c.getUint16(i+1),i+=3,t(s);case 223:return s=c.getUint32(i+1),i+=5,t(s)}throw new Error("Unknown type 0x"+U.toString(16))}var i=0,c=new DataView(r.buffer);return a()}return r}();
// File:js/lib/mmtf-decode.js

var decodeMmtf=function(){"use strict";function r(r){return new Uint8Array(r.buffer,r.byteOffset,r.byteLength)}function t(r){return new Int8Array(r.buffer,r.byteOffset,r.byteLength)}function n(r,t){var n,e,o,i=(r.byteOffset,r.byteLength);for(t||(t=new Int16Array(i/2)),n=0,e=0,o=i/2;o>n;++n,e+=2)t[n]=r[e]<<8^r[e+1]<<0;return t}function e(r,t){var n,e,o,i=(r.byteOffset,r.byteLength);for(t||(t=new Int32Array(i/4)),n=0,e=0,o=i/4;o>n;++n,e+=4)t[n]=r[e]<<24^r[e+1]<<16^r[e+2]<<8^r[e+3]<<0;return t}function o(r){return new Int32Array(r.buffer,r.byteOffset,r.byteLength/4)}function i(r,t,n){var e=r.length,o=1/t;n||(n=new Float32Array(e));for(var i=0;e>i;++i)n[i]=r[i]*o;return n}function a(r,t){var n,e;if(!t){var o=0;for(n=0,e=r.length;e>n;n+=2)o+=r[n+1];t=new r.constructor(o)}var i=0;for(n=0,e=r.length;e>n;n+=2)for(var a=r[n],u=r[n+1],s=0;u>s;++s)t[i]=a,i+=1;return t}function u(r){for(var t=1,n=r.length;n>t;++t)r[t]+=r[t-1];return r}function s(r,t,n){var e=r.length/2+t.length;n||(n=new Int32Array(e));for(var o=0,i=0,a=0,u=r.length;u>a;a+=2){var s=r[a],f=r[a+1];n[o]=s,0!==a&&(n[o]+=n[o-1]),o+=1;for(var c=0;f>c;++c)n[o]=n[o-1]+t[i],o+=1,i+=1}return n}function f(r,t,a,u){var f=r.length/4/2+t.length/2;u||(u=new Float32Array(f));var c=o(u),d=s(e(r),n(t),c);return i(d,a,u)}function c(r,t,n){var u=n?o(n):void 0,s=a(e(r),u);return i(s,t,n)}function d(n,o){function i(r){return s?-1===s.indexOf(r):!0}o=o||{};var s=o.ignoreFields,d=(n.numBonds||0,n.numAtoms||0),l=n.groupTypeList.length/4,v=n.chainIdList.length/4,L=n.chainsPerModel.length,g={numGroups:l,numChains:v,numModels:L};["mmtfVersion","mmtfProducer","unitCell","spaceGroup","structureId","title","depositionDate","releaseDate","experimentalMethods","resolution","rFree","rWork","bioAssemblyList","entityList","groupList","numBonds","numAtoms","groupsPerChain","chainsPerModel"].forEach(function(r){void 0!==n[r]&&(g[r]=n[r])});var y="bondAtomList";n[y]&&i(y)&&(g[y]=e(n[y]));var h="bondOrderList";n[h]&&i(h)&&(g[h]=r(n[h])),g.xCoordList=f(n.xCoordBig,n.xCoordSmall,1e3),g.yCoordList=f(n.yCoordBig,n.yCoordSmall,1e3),g.zCoordList=f(n.zCoordBig,n.zCoordSmall,1e3);var m="bFactorList",b="bFactorBig",p="bFactorSmall";n[b]&&n[p]&&i(m)&&(g[m]=f(n[b],n[p],100));var A="atomIdList";n[A]&&i(A)&&(g[A]=u(a(e(n[A]))));var C="altLocList";n[C]&&i(C)&&(g[C]=a(e(n[C]),new Uint8Array(d)));var I="occupancyList";n[I]&&i(I)&&(g[I]=c(n[I],100)),g.groupIdList=u(a(e(n.groupIdList))),g.groupTypeList=e(n.groupTypeList);var w="secStructList";n[w]&&i(w)&&(g[w]=t(n[w]));var F="insCodeList";n[F]&&i(F)&&(g[F]=a(e(n[F]),new Uint8Array(l)));var O="sequenceIndexList";n[O]&&i(O)&&(g[O]=u(a(e(n[O])))),g.chainIdList=r(n.chainIdList);var x="chainNameList";return n[x]&&i(x)&&(g[x]=r(n[x])),g}return d}();

// File:js/build/ngl.min.js

// https://github.com/arose/ngl/ LICENSE
(function(a){a.console=a.console||{};a=a.console;for(var b,c={},d=function(){},e=["memory"],f="assert clear count debug dir dirxml error exception group groupCollapsed groupEnd info log markTimeline profile profiles profileEnd show table time timeEnd timeline timelineEnd timeStamp trace warn".split(" ");b=e.pop();)a[b]||(a[b]=c);for(;b=f.pop();)a[b]||(a[b]=d)})("undefined"===typeof window?this:window);
"function"===typeof importScripts||HTMLCanvasElement.prototype.toBlob||Object.defineProperty(HTMLCanvasElement.prototype,"toBlob",{value:function(a,b,c){c=window.atob(this.toDataURL(b,c).split(",")[1]);for(var d=c.length,e=d>>2,f=new Uint8Array(d),g=new Uint32Array(f.buffer,0,e),h=0,k=0;h<e;h++)g[h]=c.charCodeAt(k++)|c.charCodeAt(k++)<<8|c.charCodeAt(k++)<<16|c.charCodeAt(k++)<<24;for(d&=3;d--;)f[k]=c.charCodeAt(k++);a(new Blob([f],{type:b||"image/png"}))}});
Number.isInteger||(Number.isInteger=function(a){return"number"===typeof a&&isFinite(a)&&-9007199254740992<a&&9007199254740992>a&&Math.floor(a)===a});Number.isNaN||(Number.isNaN=function(a){return a!==a});
Object.assign||Object.defineProperty(Object,"assign",{enumerable:!1,configurable:!0,writable:!0,value:function(a,b){if(void 0===a||null===a)throw new TypeError("Cannot convert first argument to object");for(var c=Object(a),d=!1,e,f=1;f<arguments.length;f++){var g=arguments[f];if(void 0!==g&&null!==g){for(var h=Object.keys(Object(g)),k=0,l=h.length;k<l;k++){var m=h[k];try{var n=Object.getOwnPropertyDescriptor(g,m);void 0!==n&&n.enumerable&&(c[m]=g[m])}catch(p){d||(d=!0,e=p)}}if(d)throw e;}}return c}});
String.prototype.startsWith||function(){var a=function(){try{var a={},b=Object.defineProperty,c=b(a,a,a)&&b}catch(g){}return c}(),b={}.toString,c=function(a){if(null==this)throw TypeError();var c=String(this);if(a&&"[object RegExp]"==b.call(a))throw TypeError();var f=c.length,g=String(a),h=g.length,k=1<arguments.length?arguments[1]:void 0,k=k?Number(k):0;k!=k&&(k=0);k=Math.min(Math.max(k,0),f);if(h+k>f)return!1;for(f=-1;++f<h;)if(c.charCodeAt(k+f)!=g.charCodeAt(f))return!1;return!0};a?a(String.prototype,
"startsWith",{value:c,configurable:!0,writable:!0}):String.prototype.startsWith=c}();String.prototype.endsWith||(String.prototype.endsWith=function(a,b){var c=this.toString();if("number"!==typeof b||!isFinite(b)||Math.floor(b)!==b||b>c.length)b=c.length;b-=a.length;c=c.indexOf(a,b);return-1!==c&&c===b});
"function"!==typeof importScripts&&function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(b,c){var f=(new Date).getTime(),g=Math.max(0,16-(f-a)),h=window.setTimeout(function(){b(f+g)},g);a=f+g;return h});window.cancelAnimationFrame||
(window.cancelAnimationFrame=function(a){clearTimeout(a)})}();void 0===Function.prototype.name&&void 0!==Object.defineProperty&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}});void 0===self.performance&&(self.performance={});void 0===self.performance.now&&function(){var a=Date.now();self.performance.now=function(){return Date.now()-a}}();
"function"!==typeof importScripts&&(HTMLElement.prototype.getBoundingClientRect=function(){var a=HTMLElement.prototype.getBoundingClientRect;return function(){try{return a.apply(this,arguments)}catch(b){return{top:0,left:0,width:this.width,height:this.height}}}}());
"function"!==typeof importScripts&&WebGLRenderingContext&&(WebGLRenderingContext.prototype.getShaderParameter=function(){var a=WebGLRenderingContext.prototype.getShaderParameter;return function(){return NGL.debug?a.apply(this,arguments):!0}}(),WebGLRenderingContext.prototype.getShaderInfoLog=function(){var a=WebGLRenderingContext.prototype.getShaderInfoLog;return function(){return NGL.debug?a.apply(this,arguments):""}}(),WebGLRenderingContext.prototype.getProgramParameter=function(){var a=WebGLRenderingContext.prototype.getProgramParameter;
return function(b,c){return NGL.debug||c!==WebGLRenderingContext.prototype.LINK_STATUS?a.apply(this,arguments):!0}}(),WebGLRenderingContext.prototype.getProgramInfoLog=function(){var a=WebGLRenderingContext.prototype.getProgramInfoLog;return function(){return NGL.debug?a.apply(this,arguments):""}}());
var NGL={REVISION:"0.7",EPS:1E-7,useWorker:!0,indexUint16:!1,debug:!1,develop:-1!==self.location.pathname.indexOf("core.js")||-1!==self.location.pathname.indexOf("dev.html"),mainScriptFilePath:"../js/build/ngl.full.min.js",cssDirectory:"../css/",assetsDirectory:"../",documentationUrl:"../doc/index.html",webglErrorMessage:'<div style="display:flex; align-items:center; justify-content:center; height:100%;"><p style="padding:15px; text-align:center;">Your browser/graphics card does not seem to support <a target="_blank" href="https://en.wikipedia.org/wiki/WebGL">WebGL</a>.<br /><br />Find out how to get it <a target="_blank" href="http://get.webgl.org/">here</a>.</p></div>'};
NGL.log=Function.prototype.bind.call(console.log,console);NGL.info=Function.prototype.bind.call(console.info,console);NGL.warn=Function.prototype.bind.call(console.warn,console);NGL.error=Function.prototype.bind.call(console.error,console);NGL.time=Function.prototype.bind.call(console.time,console);NGL.timeEnd=Function.prototype.bind.call(console.timeEnd,console);NGL.LeftMouseButton=1;NGL.MiddleMouseButton=2;NGL.RightMouseButton=3;
"function"===typeof importScripts&&NGL.develop&&importScripts("../three/three.js","../three/TypedArrayUtils.js","../three/controls/TrackballControls.js","../three/loaders/OBJLoader.js","../three/loaders/PLYLoader.js","../lib/promise.min.js","../lib/sprintf.min.js","../lib/pako_inflate.min.js","../lib/chroma.min.js","../lib/svd.js","../lib/signals.min.js","../lib/TypedFastBitSet.js","../lib/msgpack-decode.js","../lib/mmtf-decode.js","../ngl/shims.js","../ngl/worker.js","../ngl/utils.js","../ngl/proxy.js",
"../ngl/store.js","../ngl/symmetry.js","../ngl/alignment.js","../ngl/geometry.js","../ngl/selection.js","../ngl/superposition.js","../ngl/structure.js","../ngl/trajectory.js","../ngl/surface.js","../ngl/script.js","../ngl/streamer.js","../ngl/parser.js","../ngl/writer.js","../ngl/loader.js","../ngl/viewer.js","../ngl/buffer.js","../ngl/representation.js","../ngl/stage.js");NGL.GET=function(a){if(a=(new RegExp(a+"=([^&#=]*)")).exec(window.location.search))return decodeURIComponent(a[1])};
NGL.boolean=function(a){return a?"string"===typeof a?/^1|true|t|yes|y$/i.test(a):!0:!1};"function"!==typeof importScripts&&function(){var a=NGL.GET("debug");void 0!==a&&(NGL.debug=NGL.boolean(a))}();
NGL.PluginRegistry={dict:{},add:function(a,b){this.dict[a]=b},get:function(a){if(a in this.dict)return this.dict[a];throw"NGL.PluginRegistry '"+a+"' not defined";},get names(){return Object.keys(this.dict)},get count(){return this.names.length},load:function(a,b){var c=this.get(a);b.loadFile(c,{name:a+" plugin"})}};
NGL.ExampleRegistry={dict:{},add:function(a,b){this.dict[a]=b},addDict:function(a){Object.keys(a).forEach(function(b){this.add(b,a[b])}.bind(this))},get:function(a){return this.dict[a]},get names(){return Object.keys(this.dict)},get count(){return this.names.length},load:function(a,b){var c=this.get(a);"function"===typeof c?c(b):NGL.warn("NGL.ExampleRegistry.load not available:",a)}};NGL.WorkerRegistry={activeWorkerCount:0,funcDict:{},add:function(a,b){NGL.WorkerRegistry.funcDict[a]=b}};
NGL.Worker=function(a){var b=0,c=0,d={},e={},f=new Worker(NGL.mainScriptFilePath);NGL.WorkerRegistry.activeWorkerCount+=1;f.onmessage=function(c){--b;var h=c.data.__postId;NGL.timeEnd("NGL.Worker.postMessage "+a+" #"+h);d[h]&&d[h].call(f,c);delete d[h];delete e[h]};f.onerror=function(c){--b;var h=c.data.__postId;e[h]?e[h].call(f,c):NGL.error("NGL.Worker.onerror",h,a,c);delete d[h];delete e[h]};this.name=a;this.post=function(g,h,k,l){d[c]=k;e[c]=l;g=g||{};g.__name=a;g.__postId=c;g.__debug=NGL.debug;
NGL.time("NGL.Worker.postMessage "+a+" #"+c);try{f.postMessage.call(f,g,h)}catch(m){NGL.error("NGL.worker.post:",m),f.postMessage.call(f,g)}b+=1;c+=1;return this};this.terminate=function(){f?(f.terminate(),--NGL.WorkerRegistry.activeWorkerCount):console.log("no worker to terminate")};Object.defineProperties(this,{postCount:{get:function(){return c}},pending:{get:function(){return b}}})};NGL.Worker.prototype.constructor=NGL.Worker;
NGL.WorkerPool=function(a,b){b=Math.min(8,b||2);var c=[],d=0;this.name=a;this.maxCount=b;this.post=function(a,b,c,d){this.getNextWorker().post(a,b,c,d);return this};this.terminate=function(){c.forEach(function(a){a.terminate()})};this.getNextWorker=function(){for(var e,f=Infinity,g=0;g<b;++g){if(g>=d){e=new NGL.Worker(a);c.push(e);d+=1;break}var h=c[g];if(0===h.pending){e=h;break}else h.pending<f&&(f=h.pending,e=h)}return e};Object.defineProperties(this,{count:{get:function(){return d}}})};
NGL.WorkerPool.prototype.constructor=NGL.WorkerPool;"function"===typeof importScripts&&(self.onmessage=function(a){var b=a.data.__name,c=a.data.__postId;NGL.debug=a.data.__debug;if(void 0===b)NGL.error("message __name undefined");else if(void 0===NGL.WorkerRegistry.funcDict[b])NGL.error("funcDict[ __name ] undefined",b);else NGL.WorkerRegistry.funcDict[b](a,function(a,b){a=a||{};void 0!==c&&(a.__postId=c);try{self.postMessage(a,b)}catch(f){NGL.error("self.postMessage:",f),self.postMessage(a)}})});
NGL.defaults=function(a,b){return void 0!==a?a:b};NGL.browser=function(){var a=navigator.userAgent;return/Arora/i.test(a)?"Arora":/Opera|OPR/.test(a)?"Opera":/Chrome/i.test(a)?"Chrome":/Epiphany/i.test(a)?"Epiphany":/Firefox/i.test(a)?"Firefox":/Mobile(\/.*)? Safari/i.test(a)?"Mobile Safari":/MSIE/i.test(a)?"Internet Explorer":/Midori/i.test(a)?"Midori":/Safari/i.test(a)?"Safari":!1}();
NGL.getAbsolutePath=function(a){var b=window.location,c=b.pathname,c=c.substring(0,c.lastIndexOf("/")+1);return b.origin+c+a};NGL.createObject=function(a,b){var c=Object.create(a),d;for(d in b)b.hasOwnProperty(d)&&(c[d]=b[d]);return c};NGL.deepCopy=function(a){if("object"!==typeof a)return a;var b=Array.isArray(a)?[]:{},c;for(c in a)b[c]=NGL.deepCopy(a[c]);return b};
NGL.download=function(a,b){if(a){b=b||"download";var c=document.createElement("a");c.style.display="hidden";document.body.appendChild(c);c.href=a instanceof Blob?URL.createObjectURL(a):a;c.download=b;c.target="_blank";c.click();document.body.removeChild(c);a instanceof Blob&&URL.revokeObjectURL(a)}else NGL.warn("NGL.download: no data given.")};
NGL.submit=function(a,b,c,d){if(b instanceof FormData){var e=new XMLHttpRequest;e.open("POST",a);e.addEventListener("load",function(a){200===e.status||304===e.status?c(e.response):"function"===typeof d&&d(e.status)},!1);e.send(b)}else NGL.warn("NGL.submit: type not supported.",b)};
NGL.open=function(a,b){b=b||["*"];var c=document.createElement("input");c.type="file";c.multiple=!0;c.style.display="hidden";document.body.appendChild(c);c.accept="."+b.join(",.");c.addEventListener("change",function(b){a(b.target.files)},!1);c.click()};NGL.unicodeHelper=function(){var a={"{alpha}":"\u03b1","{beta}":"\u03b2","{gamma}":"\u03b3","{dot}":"\u00b7","{bullet}":"\u2022"},b=Object.keys(a).join("|"),c=new RegExp("("+b+")","gi");return function(b){return b.replace(c,function(b,c,d,h,k){return a[String(b)]})}}();
NGL.getFileInfo=function(a){var b,c,d;b=self.File&&a instanceof File||self.Blob&&a instanceof self.Blob?a.name||"":a;var e=b.replace(/^.*[\\\/]/,""),f=e.substring(0,e.lastIndexOf(".")),g=e.split("."),g=1<g.length?g.pop().toLowerCase():"";if(c=b.match(/^(.+):\/\/(.+)$/))d=c[1].toLowerCase(),b=c[2];var h=b.substring(0,b.lastIndexOf("/")+1);-1!==["gz"].indexOf(g)?(c=g,g=b.substr(0,b.length-g.length-1).split(".").pop().toLowerCase(),f=f.substr(0,f.length-g.length-1)):c=!1;return{path:b,name:e,ext:g,base:f,
dir:h,compressed:c,protocol:d,src:a}};NGL.fromJSON=function(a){return(new NGL[a.metadata.type]).fromJSON(a)};NGL.throttle=function(a,b,c){var d,e,f,g=null,h=0;c||(c={});var k=function(){h=!1===c.leading?0:Date.now();g=null;f=a.apply(d,e);g||(d=e=null)};return function(){var l=Date.now();h||!1!==c.leading||(h=l);var m=b-(l-h);d=this;e=arguments;0>=m||m>b?(g&&(clearTimeout(g),g=null),h=l,f=a.apply(d,e),g||(d=e=null)):g||!1===c.trailing||(g=setTimeout(k,m));return f}};
NGL.binarySearchIndexOf=function(){function a(a,c){return a<c?-1:a>c?1:0}return function(b,c,d){var e=0,f=b.length-1;for(d||(d=a);e<=f;){var g=e+f>>1,h=d(c,b[g]);if(0<h)e=g+1;else if(0>h)f=g-1;else return g}return-e-1}}();NGL.dataURItoImage=function(a){if("function"!==typeof importScripts){var b=document.createElement("img");b.src=a;return b}};NGL.uniqueArray=function(a){return a.sort().filter(function(a,c,d){return 0===c||a!==d[c-1]})};
NGL.Uint8ToString=function(a){if(28672<a.length){for(var b=[],c=0;c<a.length;c+=28672)b.push(String.fromCharCode.apply(null,a.subarray(c,c+28672)));return b.join("")}return String.fromCharCode.apply(null,a)};
NGL.Uint8ToLines=function(a,b,c){NGL.time("NGL.Uint8ToLines");b=void 0!==b?b:10485760;c=void 0!==c?c:"\n";for(var d="",e=[],f=0;f<a.length;f+=b){var g=NGL.Uint8ToString(a.subarray(f,f+b)),h=g.lastIndexOf(c);-1===h?d+=g:(d+=g.substr(0,h),e=e.concat(d.split(c)),d=h===g.length-c.length?"":g.substr(h+c.length))}""!==d&&e.push(d);NGL.timeEnd("NGL.Uint8ToLines");return e};
NGL.decompress=function(a){var b;NGL.time("NGL.decompress");a instanceof ArrayBuffer&&(a=new Uint8Array(a));try{b=pako.ungzip(a)}catch(c){NGL.debug&&NGL.warn(c),b=a}NGL.timeEnd("NGL.decompress");return b};NGL.Counter=function(){var a=signals;this.count=0;this.signals={countChanged:new a.Signal}};
NGL.Counter.prototype={clear:function(){this.change(-this.count)},change:function(a){this.count+=a;this.signals.countChanged.dispatch(a,this.count);0>this.count&&NGL.warn("NGL.Counter.count below zero",this.count)},increment:function(){this.change(1)},decrement:function(){this.change(-1)},listen:function(a){this.change(a.count);a.signals.countChanged.add(function(a,c){this.change(a)}.bind(this))},onZeroOnce:function(a,b){if(0===this.count)a.call(b,0,0);else{var c=function(){0===this.count&&(this.signals.countChanged.remove(c,
this),a.apply(b,arguments))};this.signals.countChanged.add(c,this)}},dispose:function(){this.clear()}};NGL.Queue=function(a,b){function c(){var b=d.shift();void 0!==b?(e=!0,setTimeout(function(){a(b,c)})):e=!1}var d=[],e=!1;if(b){for(var f=0,g=b.length;f<g;++f)d.push(b[f]);c()}this.push=function(a){d.push(a);e||c()};this.kill=function(a){d.length=0};this.length=function(){return d.length}};
NGL.ElementColors={H:16777215,HE:14286847,LI:13402367,BE:12779264,B:16758197,C:9474192,N:3166456,O:16715021,F:9494608,NE:11789301,NA:11230450,MG:9109248,AL:12560038,SI:1578E4,P:16744448,S:16777008,CL:2093087,AR:8442339,K:9388244,CA:4062976,SC:15132390,TI:12567239,V:10921643,CR:9083335,MN:10255047,FE:14706227,CO:15765664,NI:5296208,CU:13140019,ZN:8224944,GA:12750735,GE:6721423,AS:12419299,SE:16752896,BR:10889513,KR:6076625,RB:7351984,SR:65280,Y:9764863,ZR:9756896,NB:7586505,MO:5551541,TC:3907230,RU:2396047,
RH:687500,PD:27013,AG:12632256,CD:16767375,IN:10909043,SN:6717568,SB:10380213,TE:13924864,I:9699476,XE:9699476,CS:5707663,BA:51456,LA:7394559,CE:16777159,PR:14286791,ND:13107143,PM:10747847,SM:9437127,EU:6422471,GD:4587463,TB:3211207,DY:2097095,HO:65436,ER:58997,TM:54354,YB:48952,LU:43812,HF:5096191,TA:5089023,W:2200790,RE:2522539,OS:2516630,IR:1528967,PT:13684960,AU:16765219,HG:12105936,TL:10900557,PB:5724513,BI:10375093,PO:11230208,AT:7688005,RN:4358806,FR:4325478,RA:32E3,AC:7384058,TH:47871,PA:41471,
U:36863,NP:33023,PU:27647,AM:5528818,CM:7888099,BK:9064419,CF:10565332,ES:11739092,FM:11739066,MD:11734438,NO:12389767,LR:13041766,RF:13369433,DB:13697103,SG:14221381,BH:14680120,HS:15073326,MT:15400998,DS:16777215,RG:16777215,CN:16777215,UUT:16777215,FL:16777215,UUP:16777215,LV:16777215,UUH:16777215,D:16777152,T:16777120,"":16777215};
NGL.ResidueColors={ALA:9240460,ARG:124,ASN:16743536,ASP:10485826,CYS:16777072,GLN:16731212,GLU:6684672,GLY:16777215,HIS:7368959,ILE:19456,LEU:4546117,LYS:4671416,MET:12099650,PHE:5459026,PRO:5395026,SER:16740418,THR:12078080,TRP:5195264,TYR:9203788,VAL:16747775,ASX:16711935,GLX:16711935,ASH:16711935,GLH:16711935,A:10526975,G:16740464,I:8454143,C:16747595,T:10551200,U:16744576,DA:10526975,DG:16740464,DI:8454143,DC:16747595,DT:10551200,DU:16744576,"":16711935};
NGL.StructureColors={alphaHelix:16711808,"3_10Helix":10485888,piHelix:6291584,betaStrand:16762880,betaTurn:6324479,coil:16777215,dna:11403518,rna:16580962,carbohydrate:10921722,"":8421504};NGL.HelixTypes={1:"h",2:"h",3:"i",4:"h",5:"g",6:"h",7:"h",8:"h",9:"h",10:"h","":"h"};
NGL.VdwRadii={H:1.1,HE:1.4,LI:1.81,BE:1.53,B:1.92,C:1.7,N:1.55,O:1.52,F:1.47,NE:1.54,NA:2.27,MG:1.73,AL:1.84,SI:2.1,P:1.8,S:1.8,CL:1.75,AR:1.88,K:2.75,CA:2.31,SC:2.3,TI:2.15,V:2.05,CR:2.05,MN:2.05,FE:2.05,CO:2,NI:2,CU:2,ZN:2.1,GA:1.87,GE:2.11,AS:1.85,SE:1.9,BR:1.83,KR:2.02,RB:3.03,SR:2.49,Y:2.4,ZR:2.3,NB:2.15,MO:2.1,TC:2.05,RU:2.05,RH:2,PD:2.05,AG:2.1,CD:2.2,IN:2.2,SN:1.93,SB:2.17,TE:2.06,I:1.98,XE:2.16,CS:3.43,BA:2.68,LA:2.5,CE:2.48,PR:2.47,ND:2.45,PM:2.43,SM:2.42,EU:2.4,GD:2.38,TB:2.37,DY:2.35,
HO:2.33,ER:2.32,TM:2.3,YB:2.28,LU:2.27,HF:2.25,TA:2.2,W:2.1,RE:2.05,OS:2,IR:2,PT:2.05,AU:2.1,HG:2.05,TL:1.96,PB:2.02,BI:2.07,PO:1.97,AT:2.02,RN:2.2,FR:3.48,RA:2.83,AC:2,TH:2.4,PA:2,U:2.3,NP:2,PU:2,AM:2,CM:2,BK:2,CF:2,ES:2,FM:2,MD:2,NO:2,LR:2,RF:2,DB:2,SG:2,BH:2,HS:2,MT:2,DS:2,RG:2,CN:2,UUT:2,FL:2,UUP:2,LV:2,UUH:2,"":2};
NGL.CovalentRadii={H:.31,HE:.28,LI:1.28,BE:.96,B:.84,C:.76,N:.71,O:.66,F:.57,NE:.58,NA:1.66,MG:1.41,AL:1.21,SI:1.11,P:1.07,S:1.05,CL:1.02,AR:1.06,K:2.03,CA:1.76,SC:1.7,TI:1.6,V:1.53,CR:1.39,MN:1.39,FE:1.32,CO:1.26,NI:1.24,CU:1.32,ZN:1.22,GA:1.22,GE:1.2,AS:1.19,SE:1.2,BR:1.2,KR:1.16,RB:2.2,SR:1.95,Y:1.9,ZR:1.75,NB:1.64,MO:1.54,TC:1.47,RU:1.46,RH:1.42,PD:1.39,AG:1.45,CD:1.44,IN:1.42,SN:1.39,SB:1.39,TE:1.38,I:1.39,XE:1.4,CS:2.44,BA:2.15,LA:2.07,CE:2.04,PR:2.03,ND:2.01,PM:1.99,SM:1.98,EU:1.98,GD:1.96,
TB:1.94,DY:1.92,HO:1.92,ER:1.89,TM:1.9,YB:1.87,LU:1.87,HF:1.75,TA:1.7,W:1.62,RE:1.51,OS:1.44,IR:1.41,PT:1.36,AU:1.36,HG:1.32,TL:1.45,PB:1.46,BI:1.48,PO:1.4,AT:1.5,RN:1.5,FR:2.6,RA:2.21,AC:2.15,TH:2.06,PA:2,U:1.96,NP:1.9,PU:1.87,AM:1.8,CM:1.69,BK:1.6,CF:1.6,ES:1.6,FM:1.6,MD:1.6,NO:1.6,LR:1.6,RF:1.6,DB:1.6,SG:1.6,BH:1.6,HS:1.6,MT:1.6,DS:1.6,RG:1.6,CN:1.6,UUT:1.6,FL:1.6,UUP:1.6,LV:1.6,UUH:1.6,"":1.6};
NGL.ResidueRadii={"2QY":6.58,CY0:11.98,"2QZ":2.52,CY1:6.59,HHK:5.11,CXM:4.69,HHI:4.58,CY4:4.57,S12:18.57,CY3:2.79,C5C:5.35,PFX:11.84,"2R3":6.94,"2R1":3.78,ILX:4.99,"32S":5.68,BTK:8.59,"32T":5.72,FAK:9.8,B27:2.78,ILM:3.84,C4R:5.63,"32L":6.75,SYS:3.01,"1MH":5.04,ILE:3.65,YNM:6.39,"2RX":4.91,B3A:2.48,GEE:4.76,"7MN":7.34,B3E:5.4,ARG:6.33,200:6.89,HIP:5.47,HIA:4.64,B3K:5.89,HIC:5.76,B3L:4.96,B3M:5.07,ARM:6.86,ARO:7.35,AR4:8.42,PG1:10.67,YOF:6.44,IML:3.74,SXE:6.65,HIQ:7.98,PFF:6.31,HIS:4.52,"0TD":3.62,
C3Y:5.24,"1OP":11.55,"02Y":4.77,"02V":4.83,ASB:5.59,"30V":8.53,S2P:4.81,ASP:3.55,ASN:3.54,"2OR":6.91,QMM:6.13,"2P0":8.52,ASL:5.36,HFA:5.14,"5PG":5.69,B3X:4.38,AS9:4.1,ARV:7.59,B3U:6.06,S2C:7.54,B3T:3.34,175:5.64,GFT:8.18,HG7:6.8,B3Q:4.48,ASA:3.64,"02K":2.94,B3Y:7.45,PHD:5.35,C6C:6.42,BUC:5.8,HGL:8.07,PHE:5.06,"03Y":2.6,PHA:5.11,OCY:5,"4PH":6.79,"5OH":4.7,"31Q":10.46,BTR:7.98,"3PX":4.7,"1PA":8.07,ASX:3.54,IOR:7.23,"03E":3.38,PHL:5.17,KWS:5.09,PHI:7.12,NAL:7.22,S1H:19.21,"2ML":3.86,"2MR":7.35,GHG:4.83,
TYY:6.54,"2MT":3.67,"56A":13.01,SVA:5.46,TYX:8.31,TYS:8.59,TYR:6.38,TYQ:6.43,HLU:3.99,MYK:19.47,TYO:7.71,HLX:4.98,TYN:9.87,TYJ:6.25,TYI:6.49,LYH:5.13,LYF:12.19,SUN:6.73,LYR:18.28,TYB:6.46,"11W":14.39,LYS:5.54,LYN:4.8,"11Q":4.85,LYO:4.71,LYZ:1.76,TXY:6.44,MYN:4.71,TY5:10.6,HMR:5.09,"01W":8.55,LYX:13.36,TY8:7.22,TY2:6.49,KYN:6.18,KYQ:9.75,CZZ:5.14,IIL:3.81,HNC:10.41,OIC:4.62,LVN:2.89,QIL:3.84,JJL:8.3,VAH:3.88,JJJ:7.5,JJK:7.43,VAD:2.56,CYW:4.65,"0QL":5.72,143:8.22,SVX:7.04,CYJ:11.64,SVY:7.1,SVZ:6.6,
CYG:8.03,CYF:13.54,SVV:5.09,GL3:2.72,"8SP":14.26,CYS:2.78,"004":4.33,CYR:10.33,PLJ:3.71,EXY:7.37,HL2:3.75,A5N:5.21,CYQ:5.67,CZ2:5.16,LWY:4.12,PM3:8.78,OHS:6.98,OHI:5.35,"3TY":8.42,CYD:8.55,DYS:7.87,DAH:6.47,"4IK":11.81,"3EG":3.66,AYA:3.65,"4IN":6.31,DAB:3.48,"4HT":6.03,RGL:7.03,DAM:2.49,NFA:5.04,WFP:6.07,"2JC":2.97,HAR:7.55,"2JG":5.67,MH6:1.72,"2JF":9.13,"3FG":4.96,MGN:4.84,AZH:5.36,AZK:6.03,ZBZ:7.79,TBG:2.58,VAL:2.51,MGG:7.34,AZS:5.61,FHL:9.75,"2JH":4.56,IEL:7.07,FHO:6.75,DA2:7.79,FH7:6.99,ME0:4.52,
"3GL":4.84,MDO:5.03,AZY:7.37,A8E:3.76,ZCL:6.71,MDH:2.58,LA2:14.07,"4FW":6.1,YCM:5.32,MDF:4.95,YCP:3.01,TEF:8.63,FGP:4.34,UF0:19.72,XCN:4.57,FGL:2.56,MF3:6.37,MEQ:5.13,LAA:3.23,IGL:5.52,MET:4.49,NIY:6.81,QCS:5.18,TCQ:8.56,MEN:4.33,"4HL":8.79,MEA:4.95,EFC:5.28,LAL:2.41,"2HF":5.52,KBE:5.64,OCS:3.94,CAF:5.46,NC1:11.4,NBQ:9.82,CAB:4.19,MBQ:9.55,193:7.38,192:2.44,"0WZ":7.61,CAS:5.35,NB8:11.98,OBS:11.71,"1AC":2.42,PCA:3.48,MCL:9.73,LBY:7.75,GAU:4.67,PBF:9.75,MCG:6.46,DDE:6.86,"19W":3.94,MD5:9.33,MD6:6.44,
MD3:8.41,MCS:7.56,OBF:3.64,UAL:4.68,PAT:6.05,IAM:8.88,PAQ:8.77,FDL:9.49,NCB:3.45,LCK:9.81,DDZ:2.52,"2FM":5.54,IAR:6.77,OAS:4.8,HBN:8.8,TA4:5.55,"1C3":7.43,ECX:5.51,PF5:6.28,RE3:5.29,FCL:6.25,ECC:4.79,LDH:7.06,NCY:2.91,CCS:4.58,PEC:6.54,"2CO":4.45,LE1:2.72,HCM:5.53,"07O":8.05,HCL:4.96,NEP:6.94,PE1:8.01,LEF:4.37,FC0:5.18,LED:4.34,HCS:4.09,DBU:2.49,RE0:5.53,LEN:3.82,"1E3":8.71,BB9:2.56,BB8:5.14,PCS:5.05,BB7:4.56,BB6:2.62,LEU:3.83,DBZ:7.08,LET:11.29,DBY:6.46,ICY:7.76,MAA:2.4,CGA:7.91,"5CS":8.34,UGY:3.7,
LGY:11.71,N10:8.96,AAR:6.39,FT6:7.5,MOD:12.62,"5CW":7.21,PVH:4.58,BBC:6.42,YYA:7.3,O12:14.08,NOT:7.15,KGC:9.88,MP4:5.86,"0CS":4.07,MP8:3.75,VLL:2.54,VLM:2.51,BCS:8.03,MNL:4.9,AA4:4.47,SAC:3.49,BCX:2.99,"3CF":6.47,SAH:11.7,NNH:6.86,CGU:4.71,SIB:12.41,TLY:8.78,SIC:4.81,VMS:8.82,TMD:6.76,MMO:6.53,PXU:2.46,"4AW":6.22,OTH:3.6,DLS:6.84,MME:4.99,DM0:6.99,"0FL":2.76,SBL:8.96,CDV:3.72,OTY:6.51,PYA:7.75,"2AS":3.57,DMH:4.92,ELY:7.42,GVL:9.6,FVA:2.9,SAR:2.48,"4BF":6.92,EME:4.69,CDE:2.51,"3AR":7.86,"3AH":9.11,
AC5:2.44,FTR:6.08,MLL:3.76,NPH:11.66,NPI:6.9,DMT:6.67,PYX:11.3,MLE:3.87,PYL:9.67,ZZU:6.94,H5M:3.61,SCH:4.46,DMK:3.52,FTY:9.07,"2AG":3.7,ABA:2.55,ZZJ:2.44,MLZ:6.8,MLY:6.88,KCX:7.28,ZZD:8.16,"3A5":5.37,LHC:7.75,"9AT":2.47,OZT:3.4,THO:2.62,THR:2.5,DFI:3.93,MKD:6.42,"4CY":4.6,SDP:6.07,DFO:3.94,"0A0":3.45,"4DB":9.73,ML3:6.26,BG1:8.02,SD4:4.57,THC:3.8,SCS:5.48,TH5:4.65,BFD:5.33,AEI:6.34,TH6:2.85,SCY:4.53,TIS:4.81,SEE:4.53,BHD:3.48,SEB:8.18,SEC:2.96,SEP:4.8,CLH:7.13,TIH:5.02,CLG:13.62,SEN:6.43,XXA:7.34,
SEL:2.46,SE7:4.19,"4CF":7.72,G8M:3.57,BH2:3.51,UN2:3.22,VR0:10.51,MK8:4.76,DHA:2.32,LMQ:4.69,SFE:5.01,AHB:3.47,OXX:7.05,BIF:9.63,IZO:4.47,NMM:8.25,"0BN":7,HZP:3.12,NMC:4.23,DHL:2.69,"9DS":9.29,SER:2.41,CHG:4.2,MIR:6.54,AGQ:7.79,SET:2.46,MIS:6.32,"4FB":3.08,"0AR":8.46,LME:3.99,FZN:24.42,AGT:9.04,IYR:6.46,"9DN":9.31,CHP:5.75,UNK:1.64,XX1:9.92,AGM:6.57,"0AH":5.78,LLP:10.22,"0AF":6.72,"4DP":9.28,HYP:2.25,DIR:5.8,LLY:8.71,"0AK":6.11,NLE:4.67,OYL:6.42,WVL:4.69,"0A8":8.1,NLY:6.37,MHO:4.89,VOL:2.55,"0A1":7.1,
MHL:3.92,NLP:4.81,NLQ:4.65,MHW:2.74,BIL:4.7,NLO:4.8,MHU:7.51,XW1:9.36,LLO:10.13,SGB:6.88,MHV:3.6,MHS:4.51,"0A9":5.17,"0LF":9.96,HT7:6.82,X2W:6.6,YPZ:9.38,I58:6.73,FLA:2.4,M0H:4.83,HSL:2.46,FLE:6.17,KOR:10.1,"1VR":3.89,HSO:4.56,TTS:9.41,RVX:7.01,TTQ:7.71,H14:5.27,HTI:7.8,ONH:6.14,LP6:8.58,ONL:4.83,AHH:5.06,HS8:7.4,HS9:4.71,BL2:5.82,AHP:5.26,"6HN":7.34,HRP:5.46,POM:3.6,WPA:5.11,"2ZC":4.29,CPC:2.65,AIB:2.4,XSN:3.47,M2S:5.28,GND:6.67,GNC:4.6,MVA:2.56,OLZ:5.32,M2L:6.15,TRF:6.69,NZH:7.66,SRZ:5.27,OLD:10.47,
CME:5.86,CMH:5.3,ALA:2.38,TRQ:7.36,PPN:7.24,TRP:6.07,TRO:5.82,TRN:5.95,NYS:8.1,ALC:5.26,U3X:11.7,HVA:2.58,TS9:3.92,TRX:7.27,TRW:11.8,LPL:7.51,GMA:4.4,OMT:5.07,CMT:3.54,GME:4.66,NYB:6.07,PR3:5.12,LPD:2.48,GLU:4.49,"1X6":6.84,LPG:2.39,GLX:4.52,PR4:4.52,CML:6.16,FME:4.52,HTR:6.48,PR7:4.66,Z3E:7.2,GLZ:2.39,BMT:6.37,WRP:8.16,GLY:2.37,OMY:6.11,MTY:5.46,OMX:6.15,GLN:4.46,"2XA":8.25,"28X":7.84,"7JA":9.46,FLT:9.65,GLJ:3.7,OMH:5.26,TSY:4.26,PRV:4.28,CS4:11.21,DOA:12.33,"23P":5.42,CS3:8.24,"6CL":6.47,PRR:5.58,
KST:11.58,CS1:7.23,PRS:2.63,ZYJ:11.4,IT1:9.75,UU5:4.98,ESB:6.69,UU4:2.49,ESC:5.65,LSO:10.58,ZYK:11.45,"9NV":8.99,"23F":5.27,ORN:4.25,HOX:6.61,CSD:3.95,FP9:3.03,DO2:4.44,SLL:11.53,P3Q:9.54,ORQ:6.04,MSL:5.21,DNP:2.45,CSB:3.51,WLU:4.24,CSA:5.7,MT2:5.51,CSO:3.53,TPO:4.73,MSP:13.11,"23S":6.09,MSO:4.96,PRO:2.41,TPL:5.41,DNS:8.79,CSK:3.91,Z70:7.4,CSJ:7.51,DNW:7.97,PRK:9.15,GSU:11.81,LTA:6.57,HPE:6.63,TPQ:6.48,PRJ:5.26,PSW:4.65,L3O:3.89,CSU:4.89,ALY:7.38,M3L:7.12,CSW:3.68,XPR:7.68,D4P:5.66,FOE:8.17,SLZ:5.69,
CSP:5.26,TQI:7.68,ALT:2.72,CSR:5.42,CSS:3.61,M3R:7.18,ALO:2.57,R4K:4.67,SMF:9,MSA:2.73,SMC:3.39,CSX:3.47,SME:4.8,ETA:2.4,CSZ:3.6,"22G":8.8,MSE:4.62,ALN:6.16,PSH:7.26,CTE:7.27,DON:6.72,CTH:3.45,U2X:11.54,"6CW":7.56,TQZ:6.97,"3YM":6.52,OSE:4.49,"2VA":9.82,TQQ:7.76,NRG:8.35,BPE:7.24,F2F:6.25,"1TQ":8.58,I2M:3.13,NVA:3.76,R1A:8.2,QPA:6.95,C1X:11.63,FRD:5.05,HR7:6.98,SNC:3.93,QPH:5.15,"26B":8.39,DPQ:6.54,DPP:2.51,"2TY":8.65,TNR:6.88,PTH:8.35,DPL:3.58,APK:8.79,"1TY":8.84,HRG:7.36,PTM:8.74,"1U8":3.62,PTR:8.64,
LVG:3.01,"6FL":4.85,SOC:4.05,KPI:9.79,IPG:2.91,P2Y:2.51,N2C:3.55,T0I:7.34,MPH:5.29,R2T:4.71,TOX:6.78,P2Q:9.8,GPL:10.77,MPJ:5.07,F2Y:6.2,T11:8.58,"9NR":9.33,FPR:8.85,"9NF":8.93,KPY:10.17,"9NE":9.77,TOQ:7.5,MPQ:4.2,FPK:3.08,HQA:7.25,SOY:10.94,"":5};
NGL.ResidueHydrophobicity={ALA:[.17,.5,.33],ARG:[.81,1.81,1],ASN:[.42,.85,.43],ASP:[1.23,3.64,2.41],ASH:[-.07,.43,.5],CYS:[-.24,-.02,.22],GLN:[.58,.77,.19],GLU:[2.02,3.63,1.61],GLH:[-.01,.11,.12],GLY:[.01,1.15,1.14],HIS:[.17,.11,-.06],ILE:[-.31,-1.12,-.81],LEU:[-.56,-1.25,-.69],LYS:[.99,2.8,1.81],MET:[-.23,-.67,-.44],PHE:[-1.13,-1.71,-.58],PRO:[.45,.14,-.31],SER:[.13,.46,.33],THR:[.14,.25,.11],TRP:[-1.85,-2.09,-.24],TYR:[-.94,-.71,.23],VAL:[.07,-.46,-.53],"":[0,0,0]};
NGL.guessElement=function(){var a="HCONSP".split(""),b=["NA","CL"];return function(c){c=c.trim().toUpperCase();parseInt(c.charAt(0))&&(c=c.substr(1));parseInt(c.charAt(0))&&(c=c.substr(1));var d=c.length;if(0===d)return"";if(1===d)return c;if(2===d){if(-1!==b.indexOf(c))return c;if(-1!==a.indexOf(c[0]))return c[0]}return 3<=d&&-1!==a.indexOf(c[0])?c[0]:""}}();NGL.UnknownType=0;NGL.WaterType=1;NGL.IonType=2;NGL.ProteinType=3;NGL.RnaType=4;NGL.DnaType=5;NGL.UnknownBackboneType=0;
NGL.ProteinBackboneType=1;NGL.RnaBackboneType=2;NGL.DnaBackboneType=3;NGL.CgProteinBackboneType=4;NGL.CgRnaBackboneType=5;NGL.CgDnaBackboneType=6;NGL.AA1={HIS:"H",ARG:"R",LYS:"K",ILE:"I",PHE:"F",LEU:"L",TRP:"W",ALA:"A",MET:"M",PRO:"P",CYS:"C",ASN:"N",VAL:"V",GLY:"G",SER:"S",GLN:"Q",TYR:"Y",ASP:"D",GLU:"E",THR:"T",ASH:"D",GLH:"E",UNK:""};NGL.AA3=Object.keys(NGL.AA1);NGL.RnaBases=["A","C","T","G","U"];NGL.DnaBases="DA DC DT DG DU TCY MCY 5CM".split(" ");NGL.PurinBases=["A","G","DA","DG"];
NGL.WaterNames="SOL WAT HOH H2O W DOD D3O".split(" ");NGL.IonNames="3CO 3NI 4MO 6MO AG AL AU AU3 BA BR CA CD CE CL CO CR CU CU1 CU3 F FE FE2 GA K LI MG MN MN3 NA ND4 NH4 NI OH RB SR V Y1 YT3 ZN".split(" ");NGL.LigandNames=["FOL"];NGL.ProteinBackboneAtoms="CA C N O O1 O2 OC1 OC2 H H1 H2 H3 HA BB".split(" ");NGL.NucleicBackboneAtoms="P O3' O5' C5' C4' C3' OP1 OP2 O3* O5* C5* C4* C3*".split(" ");NGL.BondProxy=function(a,b){this.structure=a;this.bondStore=a.bondStore;this.index=b};
NGL.BondProxy.prototype={constructor:NGL.BondProxy,type:"BondProxy",structure:void 0,bondStore:void 0,index:void 0,get atom1(){return this.structure.getAtomProxy(this.atomIndex1)},get atom2(){return this.structure.getAtomProxy(this.atomIndex2)},get atomIndex1(){return this.bondStore.atomIndex1[this.index]},set atomIndex1(a){this.bondStore.atomIndex1[this.index]=a},get atomIndex2(){return this.bondStore.atomIndex2[this.index]},set atomIndex2(a){this.bondStore.atomIndex2[this.index]=a},get bondOrder(){return this.bondStore.bondOrder[this.index]},
set bondOrder(a){this.bondStore.bondOrder[this.index]=a},qualifiedName:function(){return this.atomIndex1+"="+this.atomIndex2},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{atomIndex1:this.atomIndex1,atomIndex2:this.atomIndex2,bondOrder:this.bondOrder}}};
NGL.AtomProxy=function(a,b){this.structure=a;this.chainStore=a.chainStore;this.residueStore=a.residueStore;this.atomStore=a.atomStore;this.residueMap=a.residueMap;this.atomMap=a.atomMap;this.index=b};
NGL.AtomProxy.prototype={constructor:NGL.AtomProxy,type:"AtomProxy",structure:void 0,chainStore:void 0,residueStore:void 0,atomStore:void 0,index:void 0,get modelIndex(){return this.chainStore.modelIndex[this.chainIndex]},get chainIndex(){return this.residueStore.chainIndex[this.residueIndex]},get residue(){console.warn("residue");return this.structure.getResidueProxy(this.residueIndex,!1)},get residueIndex(){return this.atomStore.residueIndex[this.index]},set residueIndex(a){this.atomStore.residueIndex[this.index]=
a},get sstruc(){return this.residueStore.getSstruc(this.residueIndex)},get inscode(){return this.residueStore.getInscode(this.residueIndex)},get resno(){return this.residueStore.resno[this.residueIndex]},get chainname(){return this.chainStore.getChainname(this.chainIndex)},get residueType(){return this.residueMap.get(this.residueStore.residueTypeId[this.residueIndex])},get atomType(){return this.atomMap.get(this.atomStore.atomTypeId[this.index])},get resname(){return this.residueType.resname},get hetero(){return this.residueType.hetero},
get atomname(){return this.atomType.atomname},get element(){return this.atomType.element},get vdw(){return this.atomType.vdw},get covalent(){return this.atomType.covalent},get x(){return this.atomStore.x[this.index]},set x(a){this.atomStore.x[this.index]=a},get y(){return this.atomStore.y[this.index]},set y(a){this.atomStore.y[this.index]=a},get z(){return this.atomStore.z[this.index]},set z(a){this.atomStore.z[this.index]=a},get serial(){return this.atomStore.serial[this.index]},set serial(a){this.atomStore.serial[this.index]=
a},get bfactor(){return this.atomStore.bfactor[this.index]},set bfactor(a){this.atomStore.bfactor[this.index]=a},get occupancy(){return this.atomStore.occupancy[this.index]},set occupancy(a){this.atomStore.occupancy[this.index]=a},get altloc(){return this.atomStore.getAltloc(this.index)},set altloc(a){this.atomStore.setAltloc(this.index,a)},isBackbone:function(){var a=this.residueType.backboneIndexList;return 0<a.length?-1!==a.indexOf(this.index-this.residueStore.atomOffset[this.residueIndex]):!1},
isPolymer:function(){var a=this.residueType.moleculeType;return a===NGL.ProteinType||a===NGL.RnaType||a===NGL.DnaType||a===NGL.CgType},isSidechain:function(){return this.isPolymer()&&!this.isBackbone()},isCg:function(){var a=this.residueType.backboneType;return a===NGL.CgProteinBackboneType||a===NGL.CgRnaBackboneType||a===NGL.CgDnaBackboneType},isHetero:function(){return 1===this.residueType.hetero},isProtein:function(){return this.residueType.moleculeType===NGL.ProteinType},isNucleic:function(){var a=
this.residueType.moleculeType;return a===NGL.RnaType||a===NGL.DnaType},isRna:function(){return this.residueType.moleculeType===NGL.RnaType},isDna:function(){return this.residueType.moleculeType===NGL.DnaType},isWater:function(){return this.residueType.moleculeType===NGL.WaterType},isIon:function(){return this.residueType.moleculeType===NGL.IonType},distanceTo:function(a){var b=this.atomStore,c=a.atomStore,d=this.index,e=a.index;a=b.x[d]-c.x[e];var f=b.y[d]-c.y[e],b=b.z[d]-c.z[e];return Math.sqrt(a*
a+f*f+b*b)},connectedTo:function(a){var b=this.atomStore,c=a.atomStore,d=this.index,e=a.index;if(b.altloc&&c.altloc){var f=b.altloc[d],g=c.altloc[e];if(0!==f&&0!==g&&32!==f&&32!==g&&f!==g)return!1}f=b.x[d]-c.x[e];g=b.y[d]-c.y[e];b=b.z[d]-c.z[e];b=f*f+g*g+b*b;if(64>b&&this.isCg())return!0;if(isNaN(b))return!1;c=this.covalent+a.covalent;a=c+.3;c-=.5;return b<a*a&&b>c*c},positionFromArray:function(a,b){void 0===b&&(b=0);this.x=a[b+0];this.y=a[b+1];this.z=a[b+2];return this},positionToArray:function(a,
b){void 0===a&&(a=[]);void 0===b&&(b=0);a[b+0]=this.x;a[b+1]=this.y;a[b+2]=this.z;return a},positionToVector3:function(a){void 0===a&&(a=new THREE.Vector3);a.x=this.x;a.y=this.y;a.z=this.z;return a},positionFromVector3:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},qualifiedName:function(a){var b="";this.resname&&!a&&(b+="["+this.resname+"]");void 0!==this.resno&&(b+=this.resno);this.inscode&&(b+="^"+this.inscode);this.chainname&&(b+=":"+this.chainname);this.atomname&&(b+="."+this.atomname);
this.altloc&&(b+="%"+this.altloc);return b+="/"+this.modelIndex},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,residueIndex:this.residueIndex,atomno:this.atomno,resname:this.resname,x:this.x,y:this.y,z:this.z,element:this.element,chainname:this.chainname,resno:this.resno,serial:this.serial,vdw:this.vdw,covalent:this.covalent,hetero:this.hetero,bfactor:this.bfactor,altloc:this.altloc,atomname:this.atomname,modelindex:this.modelindex}}};
NGL.Residue={atomnames:function(){var a={};a[NGL.ProteinBackboneType]={trace:"CA",direction1:"C",direction2:["O","OC1","O1"],backboneStart:"N",backboneEnd:"C"};a[NGL.RnaBackboneType]={trace:["C4'","C4*"],direction1:["C1'","C1*"],direction2:["C3'","C3*"],backboneStart:"P",backboneEnd:["O3'","O3*"]};a[NGL.DnaBackboneType]={trace:["C3'","C3*"],direction1:["C2'","C2*"],direction2:["O4'","O4*"],backboneStart:"P",backboneEnd:["O3'","O3*"]};a[NGL.CgProteinBackboneType]={trace:["CA","BB"],backboneStart:["CA",
"BB"],backboneEnd:["CA","BB"]};a[NGL.CgRnaBackboneType]={trace:["C4'","C4*","P"],backboneStart:["C4'","C4*","P"],backboneEnd:["C4'","C4*","P"]};a[NGL.CgDnaBackboneType]={trace:["C3'","C3*","C2'","P"],backboneStart:["C3'","C3*","C2'","P"],backboneEnd:["C3'","C3*","C2'","P"]};a[NGL.UnknownBackboneType]={};return a}()};
NGL.ResidueProxy=function(a,b){this.structure=a;this.chainStore=a.chainStore;this.residueStore=a.residueStore;this.atomStore=a.atomStore;this.residueMap=a.residueMap;this.atomMap=a.atomMap;this.index=b};
NGL.ResidueProxy.prototype={constructor:NGL.ResidueProxy,type:"ResidueProxy",structure:void 0,chainStore:void 0,residueStore:void 0,atomStore:void 0,index:void 0,get chain(){return this.structure.getChainProxy(this.chainIndex)},get chainIndex(){return this.residueStore.chainIndex[this.index]},set chainIndex(a){this.residueStore.chainIndex[this.index]=a},get atomOffset(){return this.residueStore.atomOffset[this.index]},set atomOffset(a){this.residueStore.atomOffset[this.index]=a},get atomCount(){return this.residueStore.atomCount[this.index]},
set atomCount(a){this.residueStore.atomCount[this.index]=a},get modelIndex(){return this.chainStore.modelIndex[this.chainIndex]},get chainname(){return this.chainStore.getChainname(this.chainIndex)},get resno(){return this.residueStore.resno[this.index]},set resno(a){this.residueStore.resno[this.index]=a},get sstruc(){return this.residueStore.getSstruc(this.index)},set sstruc(a){this.residueStore.setSstruc(this.index,a)},get inscode(){return this.residueStore.getInscode(this.index)},set inscode(a){this.residueStore.getInscode(this.index,
a)},get residueType(){return this.residueMap.get(this.residueStore.residueTypeId[this.index])},get resname(){return this.residueType.resname},get hetero(){return this.residueType.hetero},get moleculeType(){return this.residueType.moleculeType},get backboneType(){return this.residueType.backboneType},get backboneStartType(){return this.residueType.backboneStartType},get backboneEndType(){return this.residueType.backboneEndType},get traceAtomIndex(){return this.residueType.traceAtomIndex+this.atomOffset},
get direction1AtomIndex(){return this.residueType.direction1AtomIndex+this.atomOffset},get direction2AtomIndex(){return this.residueType.direction2AtomIndex+this.atomOffset},get backboneStartAtomIndex(){return this.residueType.backboneStartAtomIndex+this.atomOffset},get backboneEndAtomIndex(){return this.residueType.backboneEndAtomIndex+this.atomOffset},get rungEndAtomIndex(){return this.residueType.rungEndAtomIndex+this.atomOffset},eachAtom:function(a,b){var c=this.atomOffset,d=this.structure._ap,
e=c+this.atomCount;if(b&&b.atomOnlyTest)for(var f=b.atomOnlyTest;c<e;++c)d.index=c,f(d)&&a(d);else for(;c<e;++c)d.index=c,a(d)},isProtein:function(){return this.residueType.moleculeType===NGL.ProteinType},isNucleic:function(){var a=this.residueType.moleculeType;return a===NGL.RnaType||a===NGL.DnaType},isRna:function(){return this.residueType.moleculeType===NGL.RnaType},isDna:function(){return this.residueType.moleculeType===NGL.DnaType},isCg:function(){var a=this.residueType.backboneType;return a===
NGL.CgProteinBackboneType||a===NGL.CgRnaBackboneType||a===NGL.CgDnaBackboneType},isPolymer:function(){var a=this.residueType.moleculeType;return a===NGL.ProteinType||a===NGL.RnaType||a===NGL.DnaType},isHetero:function(){return 1===this.residueType.hetero},isWater:function(){return this.residueType.moleculeType===NGL.WaterType},isIon:function(){return this.residueType.moleculeType===NGL.IonType},getAtomType:function(a){return this.atomMap.get(this.atomStore.atomTypeId[a])},getResname1:function(){return NGL.AA1[this.resname.toUpperCase()]||
"X"},getBackboneType:function(a){switch(a){case -1:return this.residueType.backboneStartType;case 1:return this.residueType.backboneEndType;default:return this.residueType.backboneType}},getAtomIndexByName:function(a){return this.residueType.getAtomIndexByName(a)},getAtomByName:function(a){return this.residueType.getAtomByName(a)},hasAtomWithName:function(a){return this.residueType.hasAtomWithName(a)},getAtomnameList:function(){console.warn("getAtomnameList");for(var a=this.atomCount,b=this.atomOffset,
c=Array(a),d=0;d<a;++d)c[d]=this.getAtomType(b+d).atomname;return c},connectedTo:function(a){var b=this.structure.getAtomProxy(this.backboneEndAtomIndex);a=this.structure.getAtomProxy(a.backboneStartAtomIndex);return b&&a?b.connectedTo(a):!1},getNextConnectedResidue:function(){var a=this.chainStore.residueOffset[this.chainIndex],b=this.chainStore.residueCount[this.chainIndex],c=this.index+1;if(c<a+b){if(a=this.structure.getResidueProxy(c),this.connectedTo(a))return a}else if(c===a+b&&(a=this.structure.getResidueProxy(a),
this.connectedTo(a)))return a},getPreviousConnectedResidue:function(a){var b=this.chainStore.residueOffset[this.chainIndex],c=this.index-1;if(c>=b){if(void 0===a&&(a=this.structure.getResidueProxy()),a.index=c,a.connectedTo(this))return a}else if(c===b-1&&(void 0===a&&(a=this.structure.getResidueProxy()),a.index=b+this.chainStore.residueCount[this.chainIndex]-1,a.connectedTo(this)))return a},getBonds:function(){return this.residueType.getBonds(this)},qualifiedName:function(a){var b="";this.resname&&
!a&&(b+="["+this.resname+"]");void 0!==this.resno&&(b+=this.resno);this.inscode&&(b+="^"+this.inscode);this.chain&&(b+=":"+this.chainname);return b+="/"+this.modelIndex},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,chainIndex:this.chainIndex,atomOffset:this.atomOffset,atomCount:this.atomCount,resno:this.resno,resname:this.resname,sstruc:this.sstruc}}};
NGL.Polymer=function(a,b,c){this.structure=a;this.chainStore=a.chainStore;this.residueStore=a.residueStore;this.atomStore=a.atomStore;this.residueIndexStart=b;this.residueIndexEnd=c;this.residueCount=c-b+1;a=this.structure.getResidueProxy(this.residueIndexStart);b=this.structure.getResidueProxy(this.residueIndexEnd);this.isPrevConnected=void 0!==a.getPreviousConnectedResidue();c=b.getNextConnectedResidue();this.isNextNextConnected=(this.isNextConnected=void 0!==c)&&void 0!==c.getNextConnectedResidue();
this.isCyclic=b.connectedTo(a);this.__residueProxy=this.structure.getResidueProxy()};
NGL.Polymer.prototype={constructor:NGL.Polymer,type:"Polymer",structure:void 0,residueStore:void 0,atomStore:void 0,residueIndexStart:void 0,residueIndexEnd:void 0,residueCount:void 0,get chainIndex(){return this.residueStore.chainIndex[this.residueIndexStart]},get modelIndex(){return this.chainStore.modelIndex[this.chainIndex]},get chainname(){return this.chainStore.getChainname(this.chainIndex)},isProtein:function(){this.__residueProxy.index=this.residueIndexStart;return this.__residueProxy.isProtein()},
isCg:function(){this.__residueProxy.index=this.residueIndexStart;return this.__residueProxy.isCg()},isNucleic:function(){this.__residueProxy.index=this.residueIndexStart;return this.__residueProxy.isNucleic()},getMoleculeType:function(){this.__residueProxy.index=this.residueIndexStart;return this.__residueProxy.moleculeType},getBackboneType:function(a){this.__residueProxy.index=this.residueIndexStart;return this.__residueProxy.getBackboneType(a)},getAtomIndexByType:function(a,b){this.isCyclic?-1===
a?a=this.residueCount-1:a===this.residueCount&&(a=0):(-1!==a||this.isPrevConnected||(a+=1),a!==this.residueCount||this.isNextNextConnected||--a);var c=this.__residueProxy;c.index=this.residueIndexStart+a;switch(b){case "trace":c=c.traceAtomIndex;break;case "direction1":c=c.direction1AtomIndex;break;case "direction2":c=c.direction2AtomIndex;break;default:c=(c=c.getAtomByName(b))?c.index:void 0}return c},eachAtom:function(a,b){this.eachResidue(function(c){c.eachAtom(a,b)},b)},eachAtomN:function(a,b,
c){for(var d=this.residueCount,e=Array(a),f=0;f<a;++f)e[f]=this.structure.getAtomProxy(this.getAtomIndexByType(f,c));b.apply(this,e);for(var g=a;g<d;++g){for(f=1;f<a;++f)e[f-1].index=e[f].index;e[a-1].index=this.getAtomIndexByType(g,c);b.apply(this,e)}},eachAtomN2:function(a,b,c){var d=this.atomOffset,e=this.atomCount,f=d+e;if(!(e<a)){for(var g=Array(a),e=0;e<a;++e)g[e]=this.structure.getAtomProxy();var h=this.structure.atomSetCache["__"+c];void 0===h&&(NGL.warn("no precomputed atomSet for: "+c),
h=this.structure.getAtomSet(!1),this.eachResidue(function(a){a=a.getAtomByName(c);h.add_unsafe(a.index)}));var k=0;h.forEach(function(c){if(c>=d&&c<f){for(var e=1;e<a;++e)g[e-1].index=g[e].index;g[a-1].index=c;k+=1;k>=a&&b.apply(this,g)}})}},eachDirectionAtomsN:function(a,b){var c=2*a,d=this.atomOffset,e=this.atomCount,f=d+e;if(!(e<a)){for(var g=Array(c),e=0;e<c;++e)g[e]=this.structure.getAtomProxy();c=this.structure.atomSetCache.__direction1;e=this.structure.atomSetCache.__direction2;if(void 0===
c||void 0===e)NGL.error("no precomputed atomSet for direction1 or direction2");else{var h=0;TypedFastBitSet.forEach(function(c,e){if(c>=d&&c<f&&e>=d&&e<f){for(var m=1;m<a;++m)g[m-1].index=g[m].index,g[m-1+a].index=g[m+a].index;g[a-1].index=c;g[a-1+a].index=e;h+=1;h>=a&&b.apply(this,g)}},c,e)}}},eachResidue:function(a){for(var b=this.structure.getResidueProxy(),c=this.residueCount,d=this.residueIndexStart,e=0;e<c;++e)b.index=d+e,a(b)},qualifiedName:function(){var a=this.structure.getResidueProxy(this.residueIndexStart),
b=this.structure.getResidueProxy(this.residueIndexEnd);return a.qualifiedName()+" - "+b.qualifiedName()}};NGL.ChainProxy=function(a,b){this.structure=a;this.chainStore=a.chainStore;this.residueStore=a.residueStore;this.index=b};
NGL.ChainProxy.prototype={constructor:NGL.ChainProxy,type:"ChainProxy",structure:void 0,chainStore:void 0,index:void 0,get model(){return this.structure.getModelProxy(this.modelIndex)},get modelIndex(){return this.chainStore.modelIndex[this.index]},set modelIndex(a){this.chainStore.modelIndex[this.index]=a},get residueOffset(){return this.chainStore.residueOffset[this.index]},set residueOffset(a){this.chainStore.residueOffset[this.index]=a},get residueCount(){return this.chainStore.residueCount[this.index]},
set residueCount(a){this.chainStore.residueCount[this.index]=a},get residueEnd(){return this.residueOffset+this.residueCount-1},get atomOffset(){return this.residueStore.atomOffset[this.residueOffset]},get atomEnd(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},get atomCount(){return this.atomEnd-this.atomOffset+1},get chainname(){return this.chainStore.getChainname(this.index)},set chainname(a){this.chainStore.setChainname(this.index,a)},eachAtom:function(a,
b){this.eachResidue(function(c){c.eachAtom(a,b)},b)},eachResidue:function(a,b){var c=this.residueOffset,d=this.structure._rp,e=c+this.residueCount;if(b&&b.test){var f=b.residueOnlyTest;if(f)for(;c<e;++c)d.index=c,f(d)&&a(d,b);else for(;c<e;++c)d.index=c,a(d,b)}else for(;c<e;++c)d.index=c,a(d)},eachResidueN:function(a,b){var c=this.residueCount,d=this.residueOffset,e=d+c;if(!(c<a)){for(var c=Array(a),f=0;f<a;++f)c[f]=this.structure.getResidueProxy(d+f);b.apply(this,c);for(d+=a;d<e;++d){for(f=0;f<a;++f)c[f].index+=
1;b.apply(this,c)}}},eachPolymer:function(a,b){for(var c,d,e=b?b.residueOnlyTest:void 0,f=this.model.structure,g=this.residueOffset,h=g+this.residueCount,k=this.structure.getResidueProxy(),l=this.structure.getResidueProxy(g),m=this.structure.getAtomProxy(),n=this.structure.getAtomProxy(),p=!0,g=g+1;g<h;++g){k.index=l.index;l.index=g;p&&(c=k.index,p=!1);d=l.index;var q=p?k.backboneEndType:k.backboneType,r=l.backboneType;q!==NGL.UnknownBackboneType&&q===r?(m.index=k.backboneEndAtomIndex,n.index=l.backboneStartAtomIndex,
m&&n&&m.connectedTo(n)&&(!e||e(k)&&e(l))||(1<k.index-c&&a(new NGL.Polymer(f,c,k.index)),c=d)):(q!==NGL.UnknownBackboneType&&1<k.index-c&&a(new NGL.Polymer(f,c,k.index)),c=d)}1<d-c&&this.structure.getResidueProxy(c).backboneStartType&&a(new NGL.Polymer(f,c,d))},qualifiedName:function(){return":"+this.chainname+"/"+this.modelIndex},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,residueOffset:this.residueOffset,residueCount:this.residueCount,
chainname:this.chainname}}};NGL.ModelProxy=function(a,b){this.structure=a;this.modelStore=a.modelStore;this.chainStore=a.chainStore;this.residueStore=a.residueStore;this.index=b};
NGL.ModelProxy.prototype={constructor:NGL.ModelProxy,type:"ModelProxy",structure:void 0,modelStore:void 0,index:void 0,get chainOffset(){return this.modelStore.chainOffset[this.index]},set chainOffset(a){this.modelStore.chainOffset[this.index]=a},get chainCount(){return this.modelStore.chainCount[this.index]},set chainCount(a){this.modelStore.chainCount[this.index]=a},get residueOffset(){return this.chainStore.residueOffset[this.chainOffset]},get atomOffset(){return this.residueStore.atomOffset[this.residueOffset]},
get chainEnd(){return this.chainOffset+this.chainCount-1},get residueEnd(){return this.chainStore.residueOffset[this.chainEnd]+this.chainStore.residueCount[this.chainEnd]-1},get atomEnd(){return this.residueStore.atomOffset[this.residueEnd]+this.residueStore.atomCount[this.residueEnd]-1},get residueCount(){return this.residueEnd-this.residueOffset+1},get atomCount(){return this.atomEnd-this.atomOffset+1},eachAtom:function(a,b){this.eachChain(function(c){c.eachAtom(a,b)},b)},eachResidue:function(a,
b){var c,d,e=this.chainCount;if(b&&b.chainOnlyTest){var f=b.chainOnlyTest;for(c=0;c<e;++c)d=this.chains[c],f(d)&&d.eachResidue(a,b)}else for(c=0;c<e;++c)d=this.chains[c],d.eachResidue(a,b)},eachPolymer:function(a,b){if(b&&b.chainOnlyTest){var c=b.chainOnlyTest;this.eachChain(function(d){c(d)&&d.eachPolymer(a,b)})}else this.eachChain(function(c){c.eachPolymer(a,b)})},eachChain:function(a,b){var c=this.chainOffset,d=this.structure._cp,e=c+this.chainCount;if(b&&b.test){var f=b.chainOnlyTest;if(f)for(;c<
e;++c)d.index=c,f(d)&&a(d,b);else for(;c<e;++c)d.index=c,a(d,b)}else for(;c<e;++c)d.index=c,a(d)},qualifiedName:function(){return"/"+this.index},clone:function(){return new this.constructor(this.structure,this.index)},toObject:function(){return{index:this.index,chainOffset:this.chainOffset,chainCount:this.chainCount}}};NGL.AtomType=function(a,b,c){this.structure=a;c=c||NGL.guessElement(b);this.atomname=b;this.element=c;this.vdw=NGL.VdwRadii[c];this.covalent=NGL.CovalentRadii[c]};
NGL.AtomType.prototype={constructor:NGL.AtomType,type:"AtomType",atomname:void 0,element:void 0,vdw:void 0,covalent:void 0,toJSON:function(){return{atomname:this.atomname,element:this.element}}};
NGL.AtomMap=function(a){var b={},c=[];this.add=function(d,e){e=e||NGL.guessElement(d);var f=d+"|"+e,g=b[f];if(void 0===g){var h=new NGL.AtomType(a,d,e),g=c.length;b[f]=g;c.push(h)}return g};this.get=function(a){return c[a]};this.list=c;this.dict=b;this.toJSON=function(){return{metadata:{version:.1,type:"AtomMap",generator:"AtomMapExporter"},idDict:b,typeList:c.map(function(a){return a.toJSON()})}};this.fromJSON=function(d){b=d.idDict;this.list=c=d.typeList.map(function(b){return new NGL.AtomType(a,
b.atomname,b.element)});this.dict=b}};
NGL.ResidueType=function(a,b,c,d){this.structure=a;this.resname=b;this.atomTypeIdList=c;this.hetero=d?1:0;this.atomCount=c.length;this.moleculeType=this.getMoleculeType();this.backboneType=this.getBackboneType(0);this.backboneEndType=this.getBackboneType(-1);this.backboneStartType=this.getBackboneType(1);this.backboneIndexList=this.getBackboneIndexList();c=NGL.Residue.atomnames;d=c[this.backboneType];a=c[this.backboneStartType];c=c[this.backboneEndType];var e=this.getAtomIndexByName(d.trace);this.traceAtomIndex=
void 0!==e?e:-1;e=this.getAtomIndexByName(d.direction1);this.direction1AtomIndex=void 0!==e?e:-1;d=this.getAtomIndexByName(d.direction2);this.direction2AtomIndex=void 0!==d?d:-1;a=this.getAtomIndexByName(a.backboneStart);this.backboneStartAtomIndex=void 0!==a?a:-1;a=this.getAtomIndexByName(c.backboneEnd);this.backboneEndAtomIndex=void 0!==a?a:-1;b=-1!==NGL.PurinBases.indexOf(b)?this.getAtomIndexByName("N1"):this.getAtomIndexByName("N3");this.rungEndAtomIndex=void 0!==b?b:-1};
NGL.ResidueType.prototype={constructor:NGL.ResidueType,type:"ResidueType",resname:void 0,atomTypeIdList:void 0,atomCount:void 0,getBackboneIndexList:function(){var a=[],b;switch(this.moleculeType){case NGL.ProteinType:b=NGL.ProteinBackboneAtoms;break;case NGL.RnaType:case NGL.DnaType:b=NGL.NucleicBackboneAtoms;break;default:return a}for(var c=this.structure.atomMap,d=this.atomTypeIdList,e=0,f=this.atomCount;e<f;++e){var g=c.get(d[e]);-1!==b.indexOf(g.atomname)&&a.push(e)}return a},getMoleculeType:function(){return this.isProtein()?
NGL.ProteinType:this.isRna()?NGL.RnaType:this.isDna()?NGL.DnaType:this.isWater()?NGL.WaterType:this.isIon()?NGL.IonType:NGL.UnknownType},getBackboneType:function(a){return this.hasProteinBackbone(a)?NGL.ProteinBackboneType:this.hasRnaBackbone(a)?NGL.RnaBackboneType:this.hasDnaBackbone(a)?NGL.DnaBackboneType:this.hasCgProteinBackbone(a)?NGL.CgProteinBackboneType:this.hasCgRnaBackbone(a)?NGL.CgRnaBackboneType:this.hasCgDnaBackbone(a)?NGL.CgDnaBackboneType:NGL.UnknownBackboneType},isProtein:function(){return this.hasAtomWithName("CA",
"C","N")&&-1===NGL.LigandNames.indexOf(this.resname)||-1!==NGL.AA3.indexOf(this.resname)},isCg:function(){var a=this.backboneType;return a===NGL.CgProteinBackboneType||a===NGL.CgRnaBackboneType||a===NGL.CgDnaBackboneType},isNucleic:function(){return this.isRna()||this.isDna()},isRna:function(){return this.hasAtomWithName(["P","O3'","O3*"],["C4'","C4*"],["O2'","O2*"])&&-1===NGL.LigandNames.indexOf(this.resname)||-1!==NGL.RnaBases.indexOf(this.resname)},isDna:function(){return this.hasAtomWithName(["P",
"O3'","O3*"],["C3'","C3*"])&&!this.hasAtomWithName(["O2'","O2*"])&&-1===NGL.LigandNames.indexOf(this.resname)||-1!==NGL.DnaBases.indexOf(this.resname)},isPolymer:function(){return this.isProtein()||this.isNucleic()},isHetero:function(){return 1===this.hetero},isIon:function(){return-1!==NGL.IonNames.indexOf(this.resname)},isWater:function(){return-1!==NGL.WaterNames.indexOf(this.resname)},hasBackboneAtoms:function(a,b){var c=NGL.Residue.atomnames[b];return-1===a?this.hasAtomWithName(c.trace,c.backboneEnd,
c.direction1,c.direction2):0===a?this.hasAtomWithName(c.trace,c.direction1,c.direction2):1===a?this.hasAtomWithName(c.trace,c.backboneStart,c.direction1,c.direction2):this.hasAtomWithName(c.trace,c.backboneStart,c.backboneEnd,c.direction1,c.direction2)},hasProteinBackbone:function(a){return this.isProtein()&&this.hasBackboneAtoms(a,NGL.ProteinBackboneType)},hasRnaBackbone:function(a){return this.isRna()&&this.hasBackboneAtoms(a,NGL.RnaBackboneType)},hasDnaBackbone:function(a){return this.isDna()&&
this.hasBackboneAtoms(a,NGL.DnaBackboneType)},hasCgProteinBackbone:function(a){return this.isProtein()&&this.hasBackboneAtoms(a,NGL.CgProteinBackboneType)},hasCgRnaBackbone:function(a){return this.isRna()&&this.hasBackboneAtoms(a,NGL.CgRnaBackboneType)},hasCgDnaBackbone:function(a){return this.isDna()&&this.hasBackboneAtoms(a,NGL.CgDnaBackboneType)},hasBackbone:function(a){return this.hasProteinBackbone(a)||this.hasRnaBackbone(a)||this.hasDnaBackbone(a)||this.hasCgProteinBackbone(a)||this.hasCgRnaBackbone(a)||
this.hasCgDnaBackbone(a)},getAtomIndexByName:function(a){var b=this.atomCount,c=this.structure.atomMap,d=this.atomTypeIdList;if(Array.isArray(a))for(var e=0;e<b;++e){var f=d[e];if(-1!==a.indexOf(c.get(f).atomname))return e}else for(e=0;e<b;++e)if(f=d[e],a===c.get(f).atomname)return e},hasAtomWithName:function(a){for(var b=arguments.length,c=0;c<b;++c)if(void 0!==arguments[c]&&void 0===this.getAtomIndexByName(arguments[c]))return!1;return!0},getBonds:function(a){this.bonds||(this.bonds=NGL.calculateResidueBonds(a));
return this.bonds},toJSON:function(){return{resname:this.resname,atomTypeIdList:this.atomTypeIdList,hetero:this.hetero}}};
NGL.ResidueMap=function(a){var b={},c=[];this.add=function(d,e,f){var g;g=d+"|"+e.join(",")+"|"+(f?1:0);var h=b[g];void 0===h&&(d=new NGL.ResidueType(a,d,e,f),h=c.length,b[g]=h,c.push(d));return h};this.get=function(a){return c[a]};this.list=c;this.dict=b;this.toJSON=function(){return{metadata:{version:.1,type:"ResidueMap",generator:"ResidueMapExporter"},idDict:b,typeList:c.map(function(a){return a.toJSON()})}};this.fromJSON=function(d){b=d.idDict;this.list=c=d.typeList.map(function(b){return new NGL.ResidueType(a,
b.resname,b.atomTypeIdList,b.hetero)});this.dict=b}};NGL.Store=function(a){void 0===a?this.init(0):Number.isInteger(a)?this.init(a):this.fromJSON(a)};
NGL.Store.prototype={constructor:NGL.Store,type:"Store",init:function(a){this.length=a;a=this.count=0;for(var b=this.__fields.length;a<b;++a){var c=this.__fields[a][0],d=this.__fields[a][2],e=this.length*this.__fields[a][1];switch(d){case "int8":this[c]=new Int8Array(e);break;case "int16":this[c]=new Int16Array(e);break;case "int32":this[c]=new Int32Array(e);break;case "uint8":this[c]=new Uint8Array(e);break;case "uint16":this[c]=new Uint16Array(e);break;case "uint32":this[c]=new Uint32Array(e);break;
case "float32":this[c]=new Float32Array(e);break;default:NGL.warn("arrayType unknown: "+d)}}},resize:function(a){this.length=Math.round(a||0);this.count=Math.min(this.count,this.length);a=0;for(var b=this.__fields.length;a<b;++a){var c=this.__fields[a][0],d=this.length*this.__fields[a][1],e=new this[c].constructor(d);this[c].length>d?e.set(this[c].subarray(0,d)):e.set(this[c]);this[c]=e}},growIfFull:function(){if(this.count>=this.length){var a=Math.round(1.5*this.length);this.resize(Math.max(256,
a))}},copyFrom:function(a,b,c,d){for(var e=0,f=this.__fields.length;e<f;++e)for(var g=this.__fields[e][0],h=this.__fields[e][1],k=this[g],g=a[g],l=0;l<d;++l)for(var m=h*(b+l),n=h*(c+l),p=0;p<h;++p)k[m+p]=g[n+p]},copyWithin:function(a,b,c){for(var d=0,e=this.__fields.length;d<e;++d)for(var f=this.__fields[d][1],g=this[this.__fields[d][0]],h=0;h<c;++h)for(var k=f*(a+h),l=f*(b+h),m=0;m<f;++m)g[k+m]=g[l+m]},sort:function(a){function b(e,f){if(e<f){var g=Math.floor((e+f)/2),h=e,k=f;do{for(;0>a(h,g);)h+=
1;for(;0<a(k,g);)--k;if(h<=k){h===g?g=k:k===g&&(g=h);var l=h,m=k;l!==m&&(d.copyFrom(c,0,l,1),c.copyWithin(l,m,1),c.copyFrom(d,m,0,1));h+=1;--k}}while(h<=k);b(e,k);b(h,f)}}NGL.time("NGL.Store.sort");var c=this,d=new this.constructor(1);b(0,this.count-1);NGL.timeEnd("NGL.Store.sort")},toJSON:function(){for(var a={metadata:{version:.1,type:this.type,generator:this.type+"Exporter"},length:this.length,count:this.count},b=0,c=this.__fields.length;b<c;++b){var d=this.__fields[b][0];a[d]=this[d]}return a},
fromJSON:function(a){this.length=a.length;this.count=a.count;for(var b=0,c=this.__fields.length;b<c;++b){var d=this.__fields[b][0];this[d]=a[d]}return this},getTransferable:function(){for(var a=[],b=0,c=this.__fields.length;b<c;++b)a.push(this[this.__fields[b][0]].buffer);return a},clear:function(){this.count=0},dispose:function(){delete this.length;delete this.count;for(var a=0,b=this.__fields.length;a<b;++a)delete this[this.__fields[a][0]]}};NGL.BondStore=function(a){NGL.Store.call(this,a)};
NGL.BondStore.prototype=NGL.createObject(NGL.Store.prototype,{constructor:NGL.BondStore,type:"BondStore",__fields:[["atomIndex1",1,"int32"],["atomIndex2",1,"int32"],["bondOrder",1,"int8"]],addBond:function(a,b,c){this.growIfFull();var d=this.count;this.atomIndex1[d]=a.index;this.atomIndex2[d]=b.index;this.bondOrder[d]=c;this.count+=1},addBondIfConnected:function(a,b,c){return a.connectedTo(b)?(this.addBond(a,b,c),!0):!1}});NGL.AtomStore=function(a){NGL.Store.call(this,a)};
NGL.AtomStore.prototype=NGL.createObject(NGL.Store.prototype,{constructor:NGL.AtomStore,type:"AtomStore",__fields:[["residueIndex",1,"uint32"],["atomTypeId",1,"uint16"],["x",1,"float32"],["y",1,"float32"],["z",1,"float32"],["serial",1,"int32"],["bfactor",1,"float32"],["altloc",1,"uint8"],["occupancy",1,"float32"]],setAltloc:function(a,b){this.altloc[a]=b.charCodeAt(0)},getAltloc:function(a){return(a=this.altloc[a])?String.fromCharCode(a):""}});NGL.ResidueStore=function(a){NGL.Store.call(this,a)};
NGL.ResidueStore.prototype=NGL.createObject(NGL.Store.prototype,{constructor:NGL.ResidueStore,type:"ResidueStore",__fields:[["chainIndex",1,"uint32"],["atomOffset",1,"uint32"],["atomCount",1,"uint16"],["residueTypeId",1,"uint16"],["resno",1,"int32"],["sstruc",1,"uint8"],["inscode",1,"uint8"]],setSstruc:function(a,b){this.sstruc[a]=b.charCodeAt(0)},getSstruc:function(a){return(a=this.sstruc[a])?String.fromCharCode(a):""},setInscode:function(a,b){this.inscode[a]=b.charCodeAt(0)},getInscode:function(a){return(a=
this.inscode[a])?String.fromCharCode(a):""}});NGL.ChainStore=function(a){NGL.Store.call(this,a)};
NGL.ChainStore.prototype=NGL.createObject(NGL.Store.prototype,{constructor:NGL.ChainStore,type:"ChainStore",__fields:[["modelIndex",1,"uint16"],["residueOffset",1,"uint32"],["residueCount",1,"uint32"],["chainname",4,"uint8"]],setChainname:function(a,b){var c=4*a;this.chainname[c]=b.charCodeAt(0);this.chainname[c+1]=b.charCodeAt(1);this.chainname[c+2]=b.charCodeAt(2);this.chainname[c+3]=b.charCodeAt(3)},getChainname:function(a){for(var b="",c=0;4>c;++c){var d=this.chainname[4*a+c];if(d)b+=String.fromCharCode(d);
else break}return b}});NGL.ModelStore=function(a){NGL.Store.call(this,a)};NGL.ModelStore.prototype=NGL.createObject(NGL.Store.prototype,{constructor:NGL.ModelStore,type:"ModelStore",__fields:[["chainOffset",1,"uint32"],["chainCount",1,"uint32"]]});
NGL.Unitcell=function(a,b,c,d,e,f,g,h){this.a=a||1;this.b=b||1;this.c=c||1;this.alpha=d||90;this.beta=e||90;this.gamma=f||90;this.spacegroup=g||"P 1";d=THREE.Math.degToRad(this.alpha);f=THREE.Math.degToRad(this.beta);e=THREE.Math.degToRad(this.gamma);c=Math.cos(d);a=Math.cos(f);b=Math.cos(e);Math.sin(d);d=Math.sin(f);e=Math.sin(e);this.volume=this.a*this.b*this.c*Math.sqrt(1-c*c-a*a-b*b+2*c*a*b);void 0===h?(h=this.a*this.b*e/this.volume,c=(a*b-c)/(d*e),this.fracToCart=(new THREE.Matrix4).set(this.a,
0,0,0,this.b*b,this.b*e,0,0,this.c*a,-this.c*d*c,1/h,0,0,0,0,1).transpose(),this.cartToFrac=(new THREE.Matrix4).getInverse(this.fracToCart)):(this.cartToFrac=h,this.fracToCart=(new THREE.Matrix4).getInverse(this.cartToFrac))};
NGL.Unitcell.prototype={toJSON:function(){return{metadata:{version:.1,type:"Unitcell",generator:"UnitcellExporter"},a:this.a,b:this.b,c:this.c,alpha:this.alpha,beta:this.beta,gamma:this.gamma,spacegroup:this.spacegroup,volume:this.volume,cartToFrac:this.cartToFrac.toArray(),fracToCart:this.fracToCart.toArray()}},fromJSON:function(a){this.a=a.a;this.b=a.b;this.c=a.c;this.alpha=a.alpha;this.beta=a.beta;this.gamma=a.gamma;this.spacegroup=a.spacegroup;this.volume=a.volume;this.cartToFrac.fromArray(a.cartToFrac);
this.fracToCart.fromArray(a.fracToCart);return this}};
NGL.getSymmetryOperations=function(a){var b=NGL.SymOp[a],c={};if(void 0===b)return console.warn("NGL.getSymmetryOperations: spacegroup '"+a+"' not found in symop library"),c;var d=/^[1-9]$/;b.forEach(function(a){var b=a.split(","),g=0,h=(new THREE.Matrix4).set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1),k=h.elements;c[a]=h;b.forEach(function(a){for(var b=!1,c=!1,e=0,f=a.length;e<f;++e){var h=a[e];"-"===h?b=!0:"+"===h?b=!1:"/"===h?c=!0:"X"===h?k[0+g]=b?-1:1:"Y"===h?k[4+g]=b?-1:1:"Z"===h?k[8+g]=b?-1:1:d.test(h)?
(h=parseInt(h),k[12+g]=c?k[12+g]/h:h):NGL.warn("NGL.getSymmetryOperations: unknown token '"+h+"'")}g+=1})});return c};
NGL.SymOp={"P 1":["X,Y,Z"],"P -1":["X,Y,Z","-X,-Y,-Z"],"P 1 2 1":["X,Y,Z","-X,Y,-Z"],"P 1 21 1":["X,Y,Z","-X,Y+1/2,-Z"],"C 1 2 1":["X,Y,Z","-X,Y,-Z","1/2+X,1/2+Y,Z","1/2-X,1/2+Y,-Z"],"P 1 m 1":["X,Y,Z","X,-Y,Z"],"P 1 c 1":["X,Y,Z","X,-Y,1/2+Z"],"C 1 m 1":["X,Y,Z","X,-Y,Z","1/2+X,1/2+Y,Z","1/2+X,1/2-Y,Z"],"C 1 c 1":["X,Y,Z","X,-Y,1/2+Z","1/2+X,1/2+Y,Z","1/2+X,1/2-Y,1/2+Z"],"P 1 2/m 1":["X,Y,Z","X,-Y,Z","-X,Y,-Z","-X,-Y,-Z"],"P 1 21/m 1":["X,Y,Z","-X,1/2+Y,-Z","-X,-Y,-Z","X,1/2-Y,Z"],"C 1 2/m 1":"X,Y,Z X,-Y,Z -X,Y,-Z -X,-Y,-Z 1/2+X,1/2+Y,Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2-X,1/2-Y,-Z".split(" "),
"P 1 2/c 1":["X,Y,Z","-X,Y,1/2-Z","-X,-Y,-Z","X,-Y,1/2+Z"],"P 1 21/c 1":["X,Y,Z","-X,-Y,-Z","-X,1/2+Y,1/2-Z","X,1/2-Y,1/2+Z"],"C 1 2/c 1":"X,Y,Z -X,Y,1/2-Z -X,-Y,-Z X,-Y,1/2+Z 1/2+X,1/2+Y,Z 1/2-X,1/2+Y,1/2-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2-Y,1/2+Z".split(" "),"P 2 2 2":["X,Y,Z","-X,-Y,Z","-X,Y,-Z","X,-Y,-Z"],"P 2 2 21":["X,Y,Z","-X,-Y,1/2+Z","-X,Y,1/2-Z","X,-Y,-Z"],"P 21 21 2":["X,Y,Z","-X,-Y,Z","1/2-X,1/2+Y,-Z","1/2+X,1/2-Y,-Z"],"P 21 21 21":["X,Y,Z","1/2-X,-Y,1/2+Z","-X,1/2+Y,1/2-Z","1/2+X,1/2-Y,-Z"],
"C 2 2 21":"X,Y,Z -X,-Y,1/2+Z -X,Y,1/2-Z X,-Y,-Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z".split(" "),"C 2 2 2":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z".split(" "),"F 2 2 2":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z".split(" "),"I 2 2 2":"X,Y,Z -X,-Y,Z X,-Y,-Z -X,Y,-Z X+1/2,Y+1/2,Z+1/2 -X+1/2,-Y+1/2,Z+1/2 X+1/2,-Y+1/2,-Z+1/2 -X+1/2,Y+1/2,-Z+1/2".split(" "),
"I 21 21 21":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,Y,-Z X,-Y,1/2-Z".split(" "),"P m m 2":["X,Y,Z","-X,-Y,Z","X,-Y,Z","-X,Y,Z"],"P m c 21":["X,Y,Z","-X,-Y,1/2+Z","X,-Y,1/2+Z","-X,Y,Z"],"P c c 2":["X,Y,Z","-X,-Y,Z","X,-Y,1/2+Z","-X,Y,1/2+Z"],"P m a 2":["X,Y,Z","-X,-Y,Z","1/2+X,-Y,Z","1/2-X,Y,Z"],"P c a 21":["X,Y,Z","-X,-Y,1/2+Z","1/2+X,-Y,Z","1/2-X,Y,1/2+Z"],"P n c 2":["X,Y,Z","-X,-Y,Z","X,1/2-Y,1/2+Z","-X,1/2+Y,1/2+Z"],"P m n 21":["X,Y,Z","1/2-X,-Y,1/2+Z",
"1/2+X,-Y,1/2+Z","-X,Y,Z"],"P b a 2":["X,Y,Z","-X,-Y,Z","1/2+X,1/2-Y,Z","1/2-X,1/2+Y,Z"],"P n a 21":["X,Y,Z","-X,-Y,1/2+Z","1/2+X,1/2-Y,Z","1/2-X,1/2+Y,1/2+Z"],"P n n 2":["X,Y,Z","-X,-Y,Z","1/2+X,1/2-Y,1/2+Z","1/2-X,1/2+Y,1/2+Z"],"C m m 2":"X,Y,Z -X,-Y,Z X,-Y,Z -X,Y,Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z".split(" "),"C m c 21":"X,Y,Z -X,-Y,1/2+Z X,-Y,1/2+Z -X,Y,Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,1/2+Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z".split(" "),"C c c 2":"X,Y,Z -X,-Y,Z X,-Y,1/2+Z -X,Y,1/2+Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),
"A m m 2":"X,Y,Z -X,-Y,Z X,-Y,Z -X,Y,Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z".split(" "),"A b m 2":"X,Y,Z -X,-Y,Z X,1/2-Y,Z -X,1/2+Y,Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z X,-Y,1/2+Z -X,Y,1/2+Z".split(" "),"A m a 2":"X,Y,Z -X,-Y,Z 1/2+X,-Y,Z 1/2-X,Y,Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),"A b a 2":"X,Y,Z -X,-Y,Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z 1/2+X,-Y,1/2+Z 1/2-X,Y,1/2+Z".split(" "),"F m m 2":"X,Y,Z -X,-Y,Z X,-Y,Z -X,Y,Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2+X,-Y,1/2+Z 1/2-X,Y,1/2+Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z".split(" "),
"F d d 2":"X,Y,Z -X,-Y,Z 1/4+X,1/4-Y,1/4+Z 1/4-X,1/4+Y,1/4+Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z 1/4+X,3/4-Y,3/4+Z 1/4-X,3/4+Y,3/4+Z 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 3/4+X,1/4-Y,3/4+Z 3/4-X,1/4+Y,3/4+Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 3/4+X,3/4-Y,1/4+Z 3/4-X,3/4+Y,1/4+Z".split(" "),"I m m 2":"X,Y,Z -X,-Y,Z X,-Y,Z -X,Y,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),"I b a 2":"X,Y,Z -X,-Y,Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z X,-Y,1/2+Z -X,Y,1/2+Z".split(" "),
"I m a 2":"X,Y,Z -X,-Y,Z 1/2+X,-Y,Z 1/2-X,Y,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z".split(" "),"P 2/m 2/m 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z".split(" "),"P 2/n 2/n 2/n":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),"P 2/c 2/c 2/m":"X,Y,Z -X,-Y,Z -X,Y,1/2-Z X,-Y,1/2-Z -X,-Y,-Z X,Y,-Z X,-Y,1/2+Z -X,Y,1/2+Z".split(" "),"P 2/b 2/a 2/n":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z".split(" "),
"P 21/m 2/m 2/a":"X,Y,Z 1/2-X,-Y,Z -X,Y,-Z 1/2+X,-Y,-Z -X,-Y,-Z 1/2+X,Y,-Z X,-Y,Z 1/2-X,Y,Z".split(" "),"P 2/n 21/n 2/a":"X,Y,Z 1/2-X,-Y,Z 1/2-X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z -X,-Y,-Z 1/2+X,Y,-Z 1/2+X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z".split(" "),"P 2/m 2/n 21/a":"X,Y,Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z X,-Y,-Z -X,-Y,-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z -X,Y,Z".split(" "),"P 21/c 2/c 2/a":"X,Y,Z 1/2-X,-Y,Z -X,Y,1/2-Z 1/2+X,-Y,1/2-Z -X,-Y,-Z 1/2+X,Y,-Z X,-Y,1/2+Z 1/2-X,Y,1/2+Z".split(" "),"P 21/b 21/a 2/m":"X,Y,Z -X,-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z -X,-Y,-Z X,Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z".split(" "),
"P 21/c 21/c 2/n":"X,Y,Z 1/2-X,1/2-Y,Z -X,1/2+Y,1/2-Z 1/2+X,-Y,1/2-Z -X,-Y,-Z 1/2+X,1/2+Y,-Z X,1/2-Y,1/2+Z 1/2-X,Y,1/2+Z".split(" "),"P 2/b 21/c 21/m":"X,Y,Z -X,-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,-Z -X,-Y,-Z X,Y,1/2-Z X,1/2-Y,1/2+Z -X,1/2+Y,Z".split(" "),"P 21/n 21/n 2/m":"X,Y,Z -X,-Y,Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z -X,-Y,-Z X,Y,-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),"P 21/m 21/m 2/n":"X,Y,Z -X,-Y,Z 1/2-X,Y+1/2,-Z X+1/2,1/2-Y,-Z 1/2-X,1/2-Y,-Z X+1/2,Y+1/2,-Z X,-Y,Z -X,Y,Z".split(" "),
"P 21/b 2/c 21/n":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -X,Y,1/2-Z 1/2+X,1/2-Y,-Z -X,-Y,-Z 1/2+X,1/2+Y,1/2-Z X,-Y,1/2+Z 1/2-X,1/2+Y,Z".split(" "),"P 21/b 21/c 21/a":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z -X,-Y,-Z 1/2+X,Y,1/2-Z X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z".split(" "),"P 21/n 21/m 21/a":"X,Y,Z -X+1/2,-Y,Z+1/2 -X,Y+1/2,-Z X+1/2,-Y+1/2,-Z+1/2 -X,-Y,-Z X+1/2,Y,-Z+1/2 X,-Y+1/2,Z -X+1/2,Y+1/2,Z+1/2".split(" "),"C 2/m 2/c 21/m":"X,Y,Z -X,-Y,1/2+Z -X,Y,1/2-Z X,-Y,-Z -X,-Y,-Z X,Y,1/2-Z X,-Y,1/2+Z -X,Y,Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z".split(" "),
"C 2/m 2/c 21/a":"X,Y,Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,-Y,-Z -X,-Y,-Z X,1/2+Y,1/2-Z X,1/2-Y,1/2+Z -X,Y,Z 1/2+X,1/2+Y,Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,1/2-Y,-Z 1/2-X,1/2-Y,-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z 1/2-X,1/2+Y,Z".split(" "),"C 2/m 2/m 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z".split(" "),"C 2/c 2/c 2/m":"X,Y,Z -X,-Y,Z -X,Y,1/2-Z X,-Y,1/2-Z -X,-Y,-Z X,Y,-Z X,-Y,1/2+Z -X,Y,1/2+Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),
"C 2/m 2/m 2/a":"X,Y,Z -X,1/2-Y,Z -X,1/2+Y,-Z X,-Y,-Z -X,-Y,-Z X,1/2+Y,-Z X,1/2-Y,Z -X,Y,Z 1/2+X,1/2+Y,Z 1/2-X,-Y,Z 1/2-X,Y,-Z 1/2+X,1/2-Y,-Z 1/2-X,1/2-Y,-Z 1/2+X,Y,-Z 1/2+X,-Y,Z 1/2-X,1/2+Y,Z".split(" "),"C 2/c 2/c 2/a":"X,Y,Z 1/2-X,1/2-Y,Z -X,Y,-Z 1/2+X,1/2-Y,-Z -X,1/2-Y,1/2-Z 1/2+X,Y,1/2-Z X,1/2-Y,1/2+Z 1/2-X,Y,1/2+Z 1/2+X,1/2+Y,Z -X,-Y,Z 1/2-X,1/2+Y,-Z X,-Y,-Z 1/2-X,-Y,1/2-Z X,1/2+Y,1/2-Z 1/2+X,-Y,1/2+Z -X,1/2+Y,1/2+Z".split(" "),"F 2/m 2/m 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z -X,1/2-Y,1/2-Z X,1/2+Y,1/2-Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2-X,-Y,1/2-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z 1/2-X,Y,1/2+Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z".split(" "),
"F 2/d 2/d 2/d":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z 1/4-X,1/4-Y,1/4-Z 1/4+X,1/4+Y,1/4-Z 1/4+X,1/4-Y,1/4+Z 1/4-X,1/4+Y,1/4+Z X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z 1/4-X,3/4-Y,3/4-Z 1/4+X,3/4+Y,3/4-Z 1/4+X,3/4-Y,3/4+Z 1/4-X,3/4+Y,3/4+Z 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 3/4-X,1/4-Y,3/4-Z 3/4+X,1/4+Y,3/4-Z 3/4+X,1/4-Y,3/4+Z 3/4-X,1/4+Y,3/4+Z 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 3/4-X,3/4-Y,1/4-Z 3/4+X,3/4+Y,1/4-Z 3/4+X,3/4-Y,1/4+Z 3/4-X,3/4+Y,1/4+Z".split(" "),
"I 2/m 2/m 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),"I 2/b 2/a 2/m":"X,Y,Z -X,-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z -X,-Y,-Z X,Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z -X,Y,1/2-Z X,-Y,1/2-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z X,-Y,1/2+Z -X,Y,1/2+Z".split(" "),"I 21/b 21/c 21/a":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z -X,-Y,-Z 1/2+X,Y,1/2-Z X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,Y,-Z X,-Y,1/2-Z 1/2-X,1/2-Y,1/2-Z X,1/2+Y,-Z 1/2+X,-Y,Z -X,Y,1/2+Z".split(" "),
"I 21/m 21/m 21/a":"X,Y,Z -X,1/2-Y,Z -X,1/2+Y,-Z X,-Y,-Z -X,-Y,-Z X,1/2+Y,-Z X,1/2-Y,Z -X,Y,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z".split(" "),"P 4":["X,Y,Z","-X,-Y,Z","-Y,X,Z","Y,-X,Z"],"P 41":["X,Y,Z","-X,-Y,1/2+Z","-Y,X,1/4+Z","Y,-X,3/4+Z"],"P 42":["X,Y,Z","-X,-Y,Z","-Y,X,1/2+Z","Y,-X,1/2+Z"],"P 43":["X,Y,Z","-X,-Y,1/2+Z","-Y,X,3/4+Z","Y,-X,1/4+Z"],"I 4":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z".split(" "),
"I 41":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z".split(" "),"P -4":["X,Y,Z","-X,-Y,Z","Y,-X,-Z","-Y,X,-Z"],"I -4":"X,Y,Z -X,-Y,Z Y,-X,-Z -Y,X,-Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z".split(" "),"P 4/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z".split(" "),"P 42/m":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z -X,-Y,-Z X,Y,-Z Y,-X,1/2-Z -Y,X,1/2-Z".split(" "),"P 4/n":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,Z 1/2+Y,1/2-X,Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z Y,-X,-Z -Y,X,-Z".split(" "),
"P 42/n":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z Y,-X,-Z -Y,X,-Z".split(" "),"I 4/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z".split(" "),"I 41/a":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z -X,1/2-Y,1/4-Z 1/2+X,Y,3/4-Z Y,-X,-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z 1/2-X,-Y,3/4-Z X,1/2+Y,1/4-Z 1/2+Y,1/2-X,1/2-Z -Y,X,-Z".split(" "),
"P 4 2 2":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,-Z X,-Y,-Z Y,X,-Z -Y,-X,-Z".split(" "),"P 4 21 2":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,Z 1/2+Y,1/2-X,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z Y,X,-Z -Y,-X,-Z".split(" "),"P 41 2 2":"X,Y,Z -X,-Y,1/2+Z -Y,X,1/4+Z Y,-X,3/4+Z -X,Y,-Z X,-Y,1/2-Z Y,X,3/4-Z -Y,-X,1/4-Z".split(" "),"P 41 21 2":"X,Y,Z -X,-Y,1/2+Z 1/2-Y,1/2+X,1/4+Z 1/2+Y,1/2-X,3/4+Z 1/2-X,1/2+Y,1/4-Z 1/2+X,1/2-Y,3/4-Z Y,X,-Z -Y,-X,1/2-Z".split(" "),"P 42 2 2":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z -X,Y,-Z X,-Y,-Z Y,X,1/2-Z -Y,-X,1/2-Z".split(" "),
"P 42 21 2":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z Y,X,-Z -Y,-X,-Z".split(" "),"P 43 2 2":"X,Y,Z -X,-Y,1/2+Z -Y,X,3/4+Z Y,-X,1/4+Z -X,Y,-Z X,-Y,1/2-Z Y,X,1/4-Z -Y,-X,3/4-Z".split(" "),"P 43 21 2":"X,Y,Z -X,-Y,1/2+Z 1/2-Y,1/2+X,3/4+Z 1/2+Y,1/2-X,1/4+Z 1/2-X,1/2+Y,3/4-Z 1/2+X,1/2-Y,1/4-Z Y,X,-Z -Y,-X,1/2-Z".split(" "),"I 4 2 2":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,-Z X,-Y,-Z Y,X,-Z -Y,-X,-Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z".split(" "),
"I 41 2 2":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z 1/2-X,Y,3/4-Z X,1/2-Y,1/4-Z 1/2+Y,1/2+X,1/2-Z -Y,-X,-Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z -X,1/2+Y,1/4-Z 1/2+X,-Y,3/4-Z Y,X,-Z 1/2-Y,1/2-X,1/2-Z".split(" "),"P 4 m m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z X,-Y,Z -X,Y,Z -Y,-X,Z Y,X,Z".split(" "),"P 4 b m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),"P 42 c m":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z X,-Y,1/2+Z -X,Y,1/2+Z -Y,-X,Z Y,X,Z".split(" "),
"P 42 n m":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z -Y,-X,Z Y,X,Z".split(" "),"P 4 c c":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z X,-Y,1/2+Z -X,Y,1/2+Z -Y,-X,1/2+Z Y,X,1/2+Z".split(" "),"P 4 n c":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"P 42 m c":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z X,-Y,Z -X,Y,Z -Y,-X,1/2+Z Y,X,1/2+Z".split(" "),"P 42 b c":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),
"I 4 m m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z X,-Y,Z -X,Y,Z -Y,-X,Z Y,X,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"I 4 c m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z X,-Y,1/2+Z -X,Y,1/2+Z -Y,-X,1/2+Z Y,X,1/2+Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),"I 41 m d":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z X,-Y,Z 1/2-X,1/2+Y,1/2+Z -Y,1/2-X,1/4+Z 1/2+Y,X,3/4+Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z 1/2+X,1/2-Y,1/2+Z -X,Y,Z 1/2-Y,-X,3/4+Z Y,1/2+X,1/4+Z".split(" "),
"I 41 c d":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z X,-Y,1/2+Z 1/2-X,1/2+Y,Z -Y,1/2-X,3/4+Z 1/2+Y,X,1/4+Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z 1/2+X,1/2-Y,Z -X,Y,1/2+Z 1/2-Y,-X,1/4+Z Y,1/2+X,3/4+Z".split(" "),"P -4 2 m":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z -X,Y,-Z X,-Y,-Z -Y,-X,Z Y,X,Z".split(" "),"P -4 2 c":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z -X,Y,1/2-Z X,-Y,1/2-Z -Y,-X,1/2+Z Y,X,1/2+Z".split(" "),"P -4 21 m":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),
"P -4 21 c":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"P -4 m 2":"X,Y,Z -X,-Y,Z Y,-X,-Z -Y,X,-Z X,-Y,Z -X,Y,Z Y,X,-Z -Y,-X,-Z".split(" "),"P -4 c 2":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z X,-Y,1/2+Z -X,Y,1/2+Z Y,X,1/2-Z -Y,-X,1/2-Z".split(" "),"P -4 b 2":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z".split(" "),"P -4 n 2":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z".split(" "),
"I -4 m 2":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z X,-Y,Z -X,Y,Z Y,X,-Z -Y,-X,-Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z".split(" "),"I -4 c 2":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z X,-Y,1/2+Z -X,Y,1/2+Z Y,X,1/2-Z -Y,-X,1/2-Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z".split(" "),"I -4 2 m":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z -X,Y,-Z X,-Y,-Z -Y,-X,Z Y,X,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),
"I -4 2 d":"X,Y,Z -X,-Y,Z -Y,X,-Z Y,-X,-Z 1/2-X,Y,3/4-Z 1/2+X,-Y,3/4-Z 1/2-Y,-X,3/4+Z 1/2+Y,X,3/4+Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z -X,1/2+Y,1/4-Z X,1/2-Y,1/4-Z -Y,1/2-X,1/4+Z Y,1/2+X,1/4+Z".split(" "),"P 4/m 2/m 2/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,-Z X,-Y,-Z Y,X,-Z -Y,-X,-Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z X,-Y,Z -X,Y,Z -Y,-X,Z Y,X,Z".split(" "),"P 4/m 2/c 2/c":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,1/2-Z X,-Y,1/2-Z Y,X,1/2-Z -Y,-X,1/2-Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z X,-Y,1/2+Z -X,Y,1/2+Z -Y,-X,1/2+Z Y,X,1/2+Z".split(" "),
"P 4/n 2/b 2/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,-Z X,-Y,-Z Y,X,-Z -Y,-X,-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+Y,1/2-X,-Z 1/2-Y,1/2+X,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),"P 4/n 2/n 2/c":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,-Z X,-Y,-Z Y,X,-Z -Y,-X,-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"P 4/m 21/b 2/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),
"P 4/m 21/n 2/c":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"P 4/n 21/m 2/m":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,Z 1/2+Y,1/2-X,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z Y,X,-Z -Y,-X,-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z Y,-X,-Z -Y,X,-Z X,-Y,Z -X,Y,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),"P 4/n 2/c 2/c":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,Z 1/2+Y,1/2-X,Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z Y,X,1/2-Z -Y,-X,1/2-Z 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z Y,-X,-Z -Y,X,-Z X,-Y,1/2+Z -X,Y,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),
"P 42/m 2/m 2/c":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z -X,Y,-Z X,-Y,-Z Y,X,1/2-Z -Y,-X,1/2-Z -X,-Y,-Z X,Y,-Z Y,-X,1/2-Z -Y,X,1/2-Z X,-Y,Z -X,Y,Z -Y,-X,1/2+Z Y,X,1/2+Z".split(" "),"P 42/m 2/c 2/m":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z -X,Y,1/2-Z X,-Y,1/2-Z Y,X,-Z -Y,-X,-Z -X,-Y,-Z X,Y,-Z Y,-X,1/2-Z -Y,X,1/2-Z X,-Y,1/2+Z -X,Y,1/2+Z -Y,-X,Z Y,X,Z".split(" "),"P 42/n 2/b 2/c":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z -X,Y,1/2-Z X,-Y,1/2-Z 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z Y,-X,-Z -Y,X,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z -Y,-X,1/2+Z Y,X,1/2+Z".split(" "),
"P 42/n 2/n 2/m":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z -X,Y,-Z X,-Y,-Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z Y,-X,-Z -Y,X,-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z -Y,-X,Z Y,X,Z".split(" "),"P 42/m 21/b 2/c":"X,Y,Z -X,-Y,Z -Y,X,1/2+Z Y,-X,1/2+Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z -X,-Y,-Z X,Y,-Z Y,-X,1/2-Z -Y,X,1/2-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"P 42/m 21/n 2/m":"X,Y,Z -X,-Y,Z 1/2-Y,X+1/2,Z+1/2 Y+1/2,1/2-X,Z+1/2 1/2-X,Y+1/2,1/2-Z X+1/2,1/2-Y,1/2-Z Y,X,-Z -Y,-X,-Z -X,-Y,-Z X,Y,-Z Y+1/2,1/2-X,1/2-Z 1/2-Y,X+1/2,1/2-Z X+1/2,1/2-Y,Z+1/2 1/2-X,Y+1/2,Z+1/2 -Y,-X,Z Y,X,Z".split(" "),
"P 42/n 21/m 2/c":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z Y,X,-Z -Y,-X,-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z Y,-X,-Z -Y,X,-Z X,-Y,Z -X,Y,Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),"P 42/n 21/c 2/m":"X,Y,Z -X,-Y,Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z Y,X,1/2-Z -Y,-X,1/2-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z Y,-X,-Z -Y,X,-Z X,-Y,1/2+Z -X,Y,1/2+Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),"I 4/m 2/m 2/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,-Z X,-Y,-Z Y,X,-Z -Y,-X,-Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z X,-Y,Z -X,Y,Z -Y,-X,Z Y,X,Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z".split(" "),
"I 4/m 2/c 2/m":"X,Y,Z -X,-Y,Z -Y,X,Z Y,-X,Z -X,Y,1/2-Z X,-Y,1/2-Z Y,X,1/2-Z -Y,-X,1/2-Z -X,-Y,-Z X,Y,-Z Y,-X,-Z -Y,X,-Z X,-Y,1/2+Z -X,Y,1/2+Z -Y,-X,1/2+Z Y,X,1/2+Z 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+Y,1/2-X,1/2+Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z".split(" "),"I 41/a 2/m 2/d":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z 1/2-X,Y,3/4-Z X,1/2-Y,1/4-Z 1/2+Y,1/2+X,1/2-Z -Y,-X,-Z -X,1/2-Y,1/4-Z 1/2+X,Y,3/4-Z Y,-X,-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2-Y,1/2+Z -X,Y,Z 1/2-Y,-X,3/4+Z Y,1/2+X,1/4+Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z -X,1/2+Y,1/4-Z 1/2+X,-Y,3/4-Z Y,X,-Z 1/2-Y,1/2-X,1/2-Z 1/2-X,-Y,3/4-Z X,1/2+Y,1/4-Z 1/2+Y,1/2-X,1/2-Z -Y,X,-Z X,-Y,Z 1/2-X,1/2+Y,1/2+Z -Y,1/2-X,1/4+Z 1/2+Y,X,3/4+Z".split(" "),
"I 41/a 2/c 2/d":"X,Y,Z 1/2-X,1/2-Y,1/2+Z -Y,1/2+X,1/4+Z 1/2+Y,-X,3/4+Z 1/2-X,Y,1/4-Z X,1/2-Y,3/4-Z 1/2+Y,1/2+X,-Z -Y,-X,1/2-Z -X,1/2-Y,1/4-Z 1/2+X,Y,3/4-Z Y,-X,-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2-Y,Z -X,Y,1/2+Z 1/2-Y,-X,1/4+Z Y,1/2+X,3/4+Z 1/2+X,1/2+Y,1/2+Z -X,-Y,Z 1/2-Y,X,3/4+Z Y,1/2-X,1/4+Z -X,1/2+Y,3/4-Z 1/2+X,-Y,1/4-Z Y,X,1/2-Z 1/2-Y,1/2-X,-Z 1/2-X,-Y,3/4-Z X,1/2+Y,1/4-Z 1/2+Y,1/2-X,1/2-Z -Y,X,-Z X,-Y,1/2+Z 1/2-X,1/2+Y,Z -Y,1/2-X,3/4+Z 1/2+Y,X,1/4+Z".split(" "),"P 3":["X,Y,Z","-Y,X-Y,Z","Y-X,-X,Z"],
"P 31":["X,Y,Z","-Y,X-Y,Z+1/3","Y-X,-X,Z+2/3"],"P 32":["X,Y,Z","-Y,X-Y,Z+2/3","Y-X,-X,Z+1/3"],"H 3":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z X+2/3,Y+1/3,Z+1/3 -Y+2/3,X-Y+1/3,Z+1/3 Y-X+2/3,-X+1/3,Z+1/3 X+1/3,Y+2/3,Z+2/3 -Y+1/3,X-Y+2/3,Z+2/3 Y-X+1/3,-X+2/3,Z+2/3".split(" "),"R 3":["X,Y,Z","Z,X,Y","Y,Z,X"],"P -3":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z".split(" "),"H -3":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z 2/3+X,1/3+Y,1/3+Z 2/3-Y,1/3+X-Y,1/3+Z 2/3+Y-X,1/3-X,1/3+Z 2/3-X,1/3-Y,1/3-Z 2/3+Y,1/3+Y-X,1/3-Z 2/3+X-Y,1/3+X,1/3-Z 1/3+X,2/3+Y,2/3+Z 1/3-Y,2/3+X-Y,2/3+Z 1/3+Y-X,2/3-X,2/3+Z 1/3-X,2/3-Y,2/3-Z 1/3+Y,2/3+Y-X,2/3-Z 1/3+X-Y,2/3+X,2/3-Z".split(" "),
"R -3":"X,Y,Z Z,X,Y Y,Z,X -X,-Y,-Z -Z,-X,-Y -Y,-Z,-X".split(" "),"P 3 1 2":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z".split(" "),"P 3 2 1":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z".split(" "),"P 31 1 2":"X,Y,Z -Y,X-Y,1/3+Z Y-X,-X,2/3+Z -Y,-X,2/3-Z Y-X,Y,1/3-Z X,X-Y,-Z".split(" "),"P 31 2 1":"X,Y,Z -Y,X-Y,Z+1/3 Y-X,-X,Z+2/3 Y,X,-Z X-Y,-Y,2/3-Z -X,Y-X,1/3-Z".split(" "),"P 32 1 2":"X,Y,Z -Y,X-Y,2/3+Z Y-X,-X,1/3+Z -Y,-X,1/3-Z Y-X,Y,2/3-Z X,X-Y,-Z".split(" "),"P 32 2 1":"X,Y,Z -Y,X-Y,Z+2/3 Y-X,-X,Z+1/3 Y,X,-Z X-Y,-Y,1/3-Z -X,Y-X,2/3-Z".split(" "),
"H 3 2":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z 2/3+X,1/3+Y,1/3+Z 2/3-Y,1/3+X-Y,1/3+Z 2/3+Y-X,1/3-X,1/3+Z 2/3+Y,1/3+X,1/3-Z 2/3+X-Y,1/3-Y,1/3-Z 2/3-X,1/3+Y-X,1/3-Z 1/3+X,2/3+Y,2/3+Z 1/3-Y,2/3+X-Y,2/3+Z 1/3+Y-X,2/3-X,2/3+Z 1/3+Y,2/3+X,2/3-Z 1/3+X-Y,2/3-Y,2/3-Z 1/3-X,2/3+Y-X,2/3-Z".split(" "),"R 3 2":"X,Y,Z Z,X,Y Y,Z,X -Y,-X,-Z -X,-Z,-Y -Z,-Y,-X".split(" "),"P 3 m 1":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z".split(" "),"P 3 1 m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),
"P 3 c 1":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z".split(" "),"P 3 1 c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),"H 3 m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z 2/3+X,1/3+Y,1/3+Z 2/3-Y,1/3+X-Y,1/3+Z 2/3+Y-X,1/3-X,1/3+Z 2/3-Y,1/3-X,1/3+Z 2/3+Y-X,1/3+Y,1/3+Z 2/3+X,1/3+X-Y,1/3+Z 1/3+X,2/3+Y,2/3+Z 1/3-Y,2/3+X-Y,2/3+Z 1/3+Y-X,2/3-X,2/3+Z 1/3-Y,2/3-X,2/3+Z 1/3+Y-X,2/3+Y,2/3+Z 1/3+X,2/3+X-Y,2/3+Z".split(" "),"R 3 m":"X,Y,Z Z,X,Y Y,Z,X Y,X,Z X,Z,Y Z,Y,X".split(" "),
"H 3 c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z 2/3+X,1/3+Y,1/3+Z 2/3-Y,1/3+X-Y,1/3+Z 2/3+Y-X,1/3-X,1/3+Z 2/3-Y,1/3-X,5/6+Z 2/3+Y-X,1/3+Y,5/6+Z 2/3+X,1/3+X-Y,5/6+Z 1/3+X,2/3+Y,2/3+Z 1/3-Y,2/3+X-Y,2/3+Z 1/3+Y-X,2/3-X,2/3+Z 1/3-Y,2/3-X,1/6+Z 1/3+Y-X,2/3+Y,1/6+Z 1/3+X,2/3+X-Y,1/6+Z".split(" "),"R 3 c":"X,Y,Z Z,X,Y Y,Z,X Y+1/2,X+1/2,Z+1/2 X+1/2,Z+1/2,Y+1/2 Z+1/2,Y+1/2,X+1/2".split(" "),"P -3 1 2/m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),
"P -3 1 2/c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -Y,-X,1/2-Z Y-X,Y,1/2-Z X,X-Y,1/2-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),"P -3 2/m 1":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z".split(" "),"P -3 2/c 1":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,1/2-Z X-Y,-Y,1/2-Z -X,Y-X,1/2-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z".split(" "),"H -3 2/m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z 2/3+X,1/3+Y,1/3+Z 2/3-Y,1/3+X-Y,1/3+Z 2/3+Y-X,1/3-X,1/3+Z 2/3+Y,1/3+X,1/3-Z 2/3+X-Y,1/3-Y,1/3-Z 2/3-X,1/3+Y-X,1/3-Z 2/3-X,1/3-Y,1/3-Z 2/3+Y,1/3+Y-X,1/3-Z 2/3+X-Y,1/3+X,1/3-Z 2/3-Y,1/3-X,1/3+Z 2/3+Y-X,1/3+Y,1/3+Z 2/3+X,1/3+X-Y,1/3+Z 1/3+X,2/3+Y,2/3+Z 1/3-Y,2/3+X-Y,2/3+Z 1/3+Y-X,2/3-X,2/3+Z 1/3+Y,2/3+X,2/3-Z 1/3+X-Y,2/3-Y,2/3-Z 1/3-X,2/3+Y-X,2/3-Z 1/3-X,2/3-Y,2/3-Z 1/3+Y,2/3+Y-X,2/3-Z 1/3+X-Y,2/3+X,2/3-Z 1/3-Y,2/3-X,2/3+Z 1/3+Y-X,2/3+Y,2/3+Z 1/3+X,2/3+X-Y,2/3+Z".split(" "),
"R -3 2/m":"X,Y,Z Z,X,Y Y,Z,X -Y,-X,-Z -X,-Z,-Y -Z,-Y,-X -X,-Y,-Z -Z,-X,-Y -Y,-Z,-X Y,X,Z X,Z,Y Z,Y,X".split(" "),"H -3 2/c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z Y,X,1/2-Z X-Y,-Y,1/2-Z -X,Y-X,1/2-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z 2/3+X,1/3+Y,1/3+Z 2/3-Y,1/3+X-Y,1/3+Z 2/3+Y-X,1/3-X,1/3+Z 2/3+Y,1/3+X,5/6-Z 2/3+X-Y,1/3-Y,5/6-Z 2/3-X,1/3+Y-X,5/6-Z 2/3-X,1/3-Y,1/3-Z 2/3+Y,1/3+Y-X,1/3-Z 2/3+X-Y,1/3+X,1/3-Z 2/3-Y,1/3-X,5/6+Z 2/3+Y-X,1/3+Y,5/6+Z 2/3+X,1/3+X-Y,5/6+Z 1/3+X,2/3+Y,2/3+Z 1/3-Y,2/3+X-Y,2/3+Z 1/3+Y-X,2/3-X,2/3+Z 1/3+Y,2/3+X,1/6-Z 1/3+X-Y,2/3-Y,1/6-Z 1/3-X,2/3+Y-X,1/6-Z 1/3-X,2/3-Y,2/3-Z 1/3+Y,2/3+Y-X,2/3-Z 1/3+X-Y,2/3+X,2/3-Z 1/3-Y,2/3-X,1/6+Z 1/3+Y-X,2/3+Y,1/6+Z 1/3+X,2/3+X-Y,1/6+Z".split(" "),
"R -3 2/c":"X,Y,Z Z,X,Y Y,Z,X -Y+1/2,-X+1/2,-Z+1/2 -X+1/2,-Z+1/2,-Y+1/2 -Z+1/2,-Y+1/2,-X+1/2 -X,-Y,-Z -Z,-X,-Y -Y,-Z,-X Y+1/2,X+1/2,Z+1/2 X+1/2,Z+1/2,Y+1/2 Z+1/2,Y+1/2,X+1/2".split(" "),"P 6":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z".split(" "),"P 61":"X,Y,Z -Y,X-Y,Z+1/3 Y-X,-X,Z+2/3 -X,-Y,Z+1/2 Y,Y-X,Z+5/6 X-Y,X,Z+1/6".split(" "),"P 65":"X,Y,Z -Y,X-Y,Z+2/3 Y-X,-X,Z+1/3 -X,-Y,Z+1/2 Y,Y-X,Z+1/6 X-Y,X,Z+5/6".split(" "),"P 62":"X,Y,Z -Y,X-Y,2/3+Z Y-X,-X,1/3+Z -X,-Y,Z Y,Y-X,2/3+Z X-Y,X,1/3+Z".split(" "),
"P 64":"X,Y,Z -Y,X-Y,1/3+Z Y-X,-X,2/3+Z -X,-Y,Z Y,Y-X,1/3+Z X-Y,X,2/3+Z".split(" "),"P 63":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z".split(" "),"P -6":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z X,Y,-Z -Y,X-Y,-Z Y-X,-X,-Z".split(" "),"P 6/m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z X,Y,-Z -Y,X-Y,-Z Y-X,-X,-Z".split(" "),"P 63/m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z X,Y,1/2-Z -Y,X-Y,1/2-Z Y-X,-X,1/2-Z".split(" "),
"P 6 2 2":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z".split(" "),"P 61 2 2":"X,Y,Z -Y,X-Y,1/3+Z Y-X,-X,2/3+Z -X,-Y,1/2+Z Y,Y-X,5/6+Z X-Y,X,1/6+Z Y,X,1/3-Z X-Y,-Y,-Z -X,Y-X,2/3-Z -Y,-X,5/6-Z Y-X,Y,1/2-Z X,X-Y,1/6-Z".split(" "),"P 65 2 2":"X,Y,Z -Y,X-Y,2/3+Z Y-X,-X,1/3+Z -X,-Y,1/2+Z Y,Y-X,1/6+Z X-Y,X,5/6+Z Y,X,2/3-Z X-Y,-Y,-Z -X,Y-X,1/3-Z -Y,-X,1/6-Z Y-X,Y,1/2-Z X,X-Y,5/6-Z".split(" "),"P 62 2 2":"X,Y,Z -Y,X-Y,2/3+Z Y-X,-X,1/3+Z -X,-Y,Z Y,Y-X,2/3+Z X-Y,X,1/3+Z Y,X,2/3-Z X-Y,-Y,-Z -X,Y-X,1/3-Z -Y,-X,2/3-Z Y-X,Y,-Z X,X-Y,1/3-Z".split(" "),
"P 64 2 2":"X,Y,Z -Y,X-Y,1/3+Z Y-X,-X,2/3+Z -X,-Y,Z Y,Y-X,1/3+Z X-Y,X,2/3+Z Y,X,1/3-Z X-Y,-Y,-Z -X,Y-X,2/3-Z -Y,-X,1/3-Z Y-X,Y,-Z X,X-Y,2/3-Z".split(" "),"P 63 2 2":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z -Y,-X,1/2-Z Y-X,Y,1/2-Z X,X-Y,1/2-Z".split(" "),"P 6 m m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),"P 6 c c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),
"P 63 c m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),"P 63 m c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),"P -6 m 2":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z X,Y,-Z -Y,X-Y,-Z Y-X,-X,-Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z".split(" "),"P -6 c 2":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z X,Y,1/2-Z -Y,X-Y,1/2-Z Y-X,-X,1/2-Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z".split(" "),
"P -6 2 m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z X,Y,-Z -Y,X-Y,-Z Y-X,-X,-Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),"P -6 2 c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z X,Y,1/2-Z -Y,X-Y,1/2-Z Y-X,-X,1/2-Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),"P 6/m 2/m 2/m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z X,Y,-Z Y-X,-X,-Z -Y,X-Y,-Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),
"P 6/m 2/c 2/c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,Z Y,Y-X,Z X-Y,X,Z Y,X,1/2-Z X-Y,-Y,1/2-Z -X,Y-X,1/2-Z -Y,-X,1/2-Z Y-X,Y,1/2-Z X,X-Y,1/2-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z X,Y,-Z Y-X,-X,-Z -Y,X-Y,-Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),"P 63/m 2/c 2/m":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z Y,X,1/2-Z X-Y,-Y,1/2-Z -X,Y-X,1/2-Z -Y,-X,-Z Y-X,Y,-Z X,X-Y,-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z X,Y,1/2-Z Y-X,-X,1/2-Z -Y,X-Y,1/2-Z -Y,-X,1/2+Z Y-X,Y,1/2+Z X,X-Y,1/2+Z Y,X,Z X-Y,-Y,Z -X,Y-X,Z".split(" "),
"P 63/m 2/m 2/c":"X,Y,Z -Y,X-Y,Z Y-X,-X,Z -X,-Y,1/2+Z Y,Y-X,1/2+Z X-Y,X,1/2+Z Y,X,-Z X-Y,-Y,-Z -X,Y-X,-Z -Y,-X,1/2-Z Y-X,Y,1/2-Z X,X-Y,1/2-Z -X,-Y,-Z Y,Y-X,-Z X-Y,X,-Z X,Y,1/2-Z Y-X,-X,1/2-Z -Y,X-Y,1/2-Z -Y,-X,Z Y-X,Y,Z X,X-Y,Z Y,X,1/2+Z X-Y,-Y,1/2+Z -X,Y-X,1/2+Z".split(" "),"P 2 3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X".split(" "),"F 2 3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X".split(" "),
"I 2 3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y 1/2+Z,1/2-X,1/2-Y 1/2-Z,1/2-X,1/2+Y 1/2-Z,1/2+X,1/2-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,1/2-X 1/2-Y,1/2-Z,1/2+X".split(" "),"P 21 3":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X".split(" "),
"I 21 3":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,Y,-Z X,-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y Z,-X,1/2-Y -Z,1/2-X,Y 1/2-Z,X,-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,Z,-X Y,-Z,1/2-X -Y,1/2-Z,X".split(" "),"P 2/m -3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X".split(" "),
"P 2/n -3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Z,1/2-X,1/2-Y 1/2-Z,1/2+X,1/2+Y 1/2+Z,1/2+X,1/2-Y 1/2+Z,1/2-X,1/2+Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,1/2+X 1/2+Y,1/2+Z,1/2-X".split(" "),"F 2/m -3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X -X,1/2-Y,1/2-Z X,1/2+Y,1/2-Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z -Z,1/2-X,1/2-Y -Z,1/2+X,1/2+Y Z,1/2+X,1/2-Y Z,1/2-X,1/2+Y -Y,1/2-Z,1/2-X Y,1/2-Z,1/2+X -Y,1/2+Z,1/2+X Y,1/2+Z,1/2-X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X 1/2-X,-Y,1/2-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z 1/2-X,Y,1/2+Z 1/2-Z,-X,1/2-Y 1/2-Z,X,1/2+Y 1/2+Z,X,1/2-Y 1/2+Z,-X,1/2+Y 1/2-Y,-Z,1/2-X 1/2+Y,-Z,1/2+X 1/2-Y,Z,1/2+X 1/2+Y,Z,1/2-X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Z,1/2-X,-Y 1/2-Z,1/2+X,Y 1/2+Z,1/2+X,-Y 1/2+Z,1/2-X,Y 1/2-Y,1/2-Z,-X 1/2+Y,1/2-Z,X 1/2-Y,1/2+Z,X 1/2+Y,1/2+Z,-X".split(" "),
"F 2/d -3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/4-X,1/4-Y,1/4-Z 1/4+X,1/4+Y,1/4-Z 1/4+X,1/4-Y,1/4+Z 1/4-X,1/4+Y,1/4+Z 1/4-Z,1/4-X,1/4-Y 1/4-Z,1/4+X,1/4+Y 1/4+Z,1/4+X,1/4-Y 1/4+Z,1/4-X,1/4+Y 1/4-Y,1/4-Z,1/4-X 1/4+Y,1/4-Z,1/4+X 1/4-Y,1/4+Z,1/4+X 1/4+Y,1/4+Z,1/4-X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X 1/4-X,3/4-Y,3/4-Z 1/4+X,3/4+Y,3/4-Z 1/4+X,3/4-Y,3/4+Z 1/4-X,3/4+Y,3/4+Z 1/4-Z,3/4-X,3/4-Y 1/4-Z,3/4+X,3/4+Y 1/4+Z,3/4+X,3/4-Y 1/4+Z,3/4-X,3/4+Y 1/4-Y,3/4-Z,3/4-X 1/4+Y,3/4-Z,3/4+X 1/4-Y,3/4+Z,3/4+X 1/4+Y,3/4+Z,3/4-X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X 3/4-X,1/4-Y,3/4-Z 3/4+X,1/4+Y,3/4-Z 3/4+X,1/4-Y,3/4+Z 3/4-X,1/4+Y,3/4+Z 3/4-Z,1/4-X,3/4-Y 3/4-Z,1/4+X,3/4+Y 3/4+Z,1/4+X,3/4-Y 3/4+Z,1/4-X,3/4+Y 3/4-Y,1/4-Z,3/4-X 3/4+Y,1/4-Z,3/4+X 3/4-Y,1/4+Z,3/4+X 3/4+Y,1/4+Z,3/4-X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X 3/4-X,3/4-Y,1/4-Z 3/4+X,3/4+Y,1/4-Z 3/4+X,3/4-Y,Z+1/4 3/4-X,3/4+Y,Z+1/4 3/4-Z,3/4-X,1/4-Y 3/4-Z,3/4+X,1/4+Y 3/4+Z,3/4+X,1/4-Y 3/4+Z,3/4-X,1/4+Y 3/4-Y,3/4-Z,1/4-X 3/4+Y,3/4-Z,1/4+X 3/4-Y,3/4+Z,1/4+X 3/4+Y,3/4+Z,1/4-X".split(" "),
"I 2/m -3":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y 1/2+Z,1/2-X,1/2-Y 1/2-Z,1/2-X,1/2+Y 1/2-Z,1/2+X,1/2-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,1/2-X 1/2-Y,1/2-Z,1/2+X 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Z,1/2-X,1/2-Y 1/2-Z,1/2+X,1/2+Y 1/2+Z,1/2+X,1/2-Y 1/2+Z,1/2-X,1/2+Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,1/2+X 1/2+Y,1/2+Z,1/2-X".split(" "),
"P 21/a -3":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X -X,-Y,-Z 1/2+X,Y,1/2-Z X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z -Z,-X,-Y 1/2-Z,1/2+X,Y 1/2+Z,X,1/2-Y Z,1/2-X,1/2+Y -Y,-Z,-X Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,X 1/2+Y,Z,1/2-X".split(" "),"I 21/a -3":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X -X,-Y,-Z 1/2+X,Y,1/2-Z X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z -Z,-X,-Y 1/2-Z,1/2+X,Y 1/2+Z,X,1/2-Y Z,1/2-X,1/2+Y -Y,-Z,-X Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,X 1/2+Y,Z,1/2-X 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,+Y,-Z X,-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y Z,-X,1/2-Y -Z,1/2-X,Y 1/2-Z,X,-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,Z,-X Y,-Z,1/2-X -Y,1/2-Z,X 1/2-X,1/2-Y,1/2-Z X,1/2+Y,-Z 1/2+X,-Y,Z -X,Y,1/2+Z 1/2-Z,1/2-X,1/2-Y -Z,X,1/2+Y Z,1/2+X,-Y 1/2+Z,-X,Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,-Z,X -Y,Z,1/2+X Y,1/2+Z,-X".split(" "),
"P 4 3 2":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X".split(" "),"P 42 3 2":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2+Y,1/2-X,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+X,1/2+Z,1/2-Y 1/2-X,1/2+Z,1/2+Y 1/2-X,1/2-Z,1/2-Y 1/2+X,1/2-Z,1/2+Y 1/2+Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2+X 1/2-Z,1/2-Y,1/2-X".split(" "),
"F 4 3 2":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X Y,1/2+X,1/2-Z -Y,1/2-X,1/2-Z Y,1/2-X,1/2+Z -Y,1/2+X,1/2+Z X,1/2+Z,1/2-Y -X,1/2+Z,1/2+Y -X,1/2-Z,1/2-Y X,1/2-Z,1/2+Y Z,1/2+Y,1/2-X Z,1/2-Y,1/2+X -Z,1/2+Y,1/2+X -Z,1/2-Y,1/2-X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X 1/2+Y,X,1/2-Z 1/2-Y,-X,1/2-Z 1/2+Y,-X,1/2+Z 1/2-Y,X,1/2+Z 1/2+X,Z,1/2-Y 1/2-X,Z,1/2+Y 1/2-X,-Z,1/2-Y 1/2+X,-Z,1/2+Y 1/2+Z,Y,1/2-X 1/2+Z,-Y,1/2+X 1/2-Z,Y,1/2+X 1/2-Z,-Y,1/2-X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z 1/2+Y,1/2-X,Z 1/2-Y,1/2+X,Z 1/2+X,1/2+Z,-Y 1/2-X,1/2+Z,Y 1/2-X,1/2-Z,-Y 1/2+X,1/2-Z,Y 1/2+Z,1/2+Y,-X 1/2+Z,1/2-Y,X 1/2-Z,1/2+Y,X 1/2-Z,1/2-Y,-X".split(" "),
"F 41 3 2":"X,Y,Z -X,1/2-Y,1/2+Z 1/2-X,1/2+Y,-Z 1/2+X,-Y,1/2-Z Z,X,Y 1/2+Z,-X,1/2-Y -Z,1/2-X,1/2+Y 1/2-Z,1/2+X,-Y Y,Z,X 1/2-Y,1/2+Z,-X 1/2+Y,-Z,1/2-X -Y,1/2-Z,1/2+X 3/4+Y,1/4+X,3/4-Z 1/4-Y,1/4-X,1/4-Z 1/4+Y,3/4-X,3/4+Z 3/4-Y,3/4+X,1/4+Z 3/4+X,1/4+Z,3/4-Y 3/4-X,3/4+Z,1/4+Y 1/4-X,1/4-Z,1/4-Y 1/4+X,3/4-Z,3/4+Y 3/4+Z,1/4+Y,3/4-X 1/4+Z,3/4-Y,3/4+X 3/4-Z,3/4+Y,1/4+X 1/4-Z,1/4-Y,1/4-X X,1/2+Y,1/2+Z -X,-Y,Z 1/2-X,Y,1/2-Z 1/2+X,1/2-Y,-Z Z,1/2+X,1/2+Y 1/2+Z,1/2-X,-Y -Z,-X,Y 1/2-Z,X,1/2-Y Y,1/2+Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,1/2-Z,-X -Y,-Z,X 3/4+Y,3/4+X,1/4-Z 1/4-Y,3/4-X,3/4-Z 1/4+Y,1/4-X,1/4+Z 3/4-Y,1/4+X,3/4+Z 3/4+X,3/4+Z,1/4-Y 3/4-X,1/4+Z,3/4+Y 1/4-X,3/4-Z,3/4-Y 1/4+X,1/4-Z,1/4+Y 3/4+Z,3/4+Y,1/4-X 1/4+Z,1/4-Y,1/4+X 3/4-Z,1/4+Y,3/4+X 1/4-Z,3/4-Y,3/4-X 1/2+X,Y,1/2+Z 1/2-X,1/2-Y,Z -X,1/2+Y,1/2-Z X,-Y,-Z 1/2+Z,X,1/2+Y Z,-X,-Y 1/2-Z,1/2-X,Y -Z,1/2+X,1/2-Y 1/2+Y,Z,1/2+X -Y,1/2+Z,1/2-X Y,-Z,-X 1/2-Y,1/2-Z,X 1/4+Y,1/4+X,1/4-Z 3/4-Y,1/4-X,3/4-Z 3/4+Y,3/4-X,1/4+Z 1/4-Y,3/4+X,3/4+Z 1/4+X,1/4+Z,1/4-Y 1/4-X,3/4+Z,3/4+Y 3/4-X,1/4-Z,3/4-Y 3/4+X,3/4-Z,1/4+Y 1/4+Z,1/4+Y,1/4-X 3/4+Z,3/4-Y,1/4+X 1/4-Z,3/4+Y,3/4+X 3/4-Z,1/4-Y,3/4-X 1/2+X,1/2+Y,Z 1/2-X,-Y,1/2+Z -X,Y,-Z X,1/2-Y,1/2-Z 1/2+Z,1/2+X,Y Z,1/2-X,1/2-Y 1/2-Z,-X,1/2+Y -Z,X,-Y 1/2+Y,1/2+Z,X -Y,Z,-X Y,1/2-Z,1/2-X 1/2-Y,-Z,1/2+X 1/4+Y,3/4+X,3/4-Z 3/4-Y,3/4-X,1/4-Z 3/4+Y,1/4-X,3/4+Z 1/4-Y,1/4+X,1/4+Z 1/4+X,3/4+Z,3/4-Y 1/4-X,1/4+Z,1/4+Y 3/4-X,3/4-Z,1/4-Y 3/4+X,1/4-Z,3/4+Y 1/4+Z,3/4+Y,3/4-X 3/4+Z,1/4-Y,3/4+X 1/4-Z,1/4+Y,1/4+X 3/4-Z,3/4-Y,1/4-X".split(" "),
"I 4 3 2":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y 1/2+Z,1/2-X,1/2-Y 1/2-Z,1/2-X,1/2+Y 1/2-Z,1/2+X,1/2-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,1/2-X 1/2-Y,1/2-Z,1/2+X 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2+Y,1/2-X,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+X,1/2+Z,1/2-Y 1/2-X,1/2+Z,1/2+Y 1/2-X,1/2-Z,1/2-Y 1/2+X,1/2-Z,1/2+Y 1/2+Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2+X 1/2-Z,1/2-Y,1/2-X".split(" "),
"P 43 3 2":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X 1/4+Y,3/4+X,3/4-Z 1/4-Y,1/4-X,1/4-Z 3/4+Y,3/4-X,1/4+Z 3/4-Y,1/4+X,3/4+Z 1/4+X,3/4+Z,3/4-Y 3/4-X,1/4+Z,3/4+Y 1/4-X,1/4-Z,1/4-Y 3/4+X,3/4-Z,1/4+Y 1/4+Z,3/4+Y,3/4-X 3/4+Z,3/4-Y,1/4+X 3/4-Z,1/4+Y,3/4+X 1/4-Z,1/4-Y,1/4-X".split(" "),"P 41 3 2":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X 3/4+Y,1/4+X,1/4-Z 3/4-Y,3/4-X,3/4-Z 1/4+Y,1/4-X,3/4+Z 1/4-Y,3/4+X,1/4+Z 3/4+X,1/4+Z,1/4-Y 1/4-X,3/4+Z,1/4+Y 3/4-X,3/4-Z,3/4-Y 1/4+X,1/4-Z,3/4+Y 3/4+Z,1/4+Y,1/4-X 1/4+Z,1/4-Y,3/4+X 1/4-Z,3/4+Y,1/4+X 3/4-Z,3/4-Y,3/4-X".split(" "),
"I 41 3 2":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X 3/4+Y,1/4+X,1/4-Z 3/4-Y,3/4-X,3/4-Z 1/4+Y,1/4-X,3/4+Z 1/4-Y,3/4+X,1/4+Z 3/4+X,1/4+Z,1/4-Y 1/4-X,3/4+Z,1/4+Y 3/4-X,3/4-Z,3/4-Y 1/4+X,1/4-Z,3/4+Y 3/4+Z,1/4+Y,1/4-X 1/4+Z,1/4-Y,3/4+X 1/4-Z,3/4+Y,1/4+X 3/4-Z,3/4-Y,3/4-X 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,Y,-Z X,-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y Z,-X,1/2-Y -Z,1/2-X,Y 1/2-Z,X,-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,Z,-X Y,-Z,1/2-X -Y,1/2-Z,X 1/4+Y,3/4+X,3/4-Z 1/4-Y,1/4-X,1/4-Z 3/4+Y,3/4-X,1/4+Z 3/4-Y,1/4+X,3/4+Z 1/4+X,3/4+Z,3/4-Y 3/4-X,1/4+Z,3/4+Y 1/4-X,1/4-Z,1/4-Y 3/4+X,3/4-Z,1/4+Y 1/4+Z,3/4+Y,3/4-X 3/4+Z,3/4-Y,1/4+X 3/4-Z,1/4+Y,3/4+X 1/4-Z,1/4-Y,1/4-X".split(" "),
"P -4 3 m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,Z -Y,-X,Z Y,-X,-Z -Y,X,-Z X,Z,Y -X,Z,-Y -X,-Z,Y X,-Z,-Y Z,Y,X Z,-Y,-X -Z,Y,-X -Z,-Y,X".split(" "),"F -4 3 m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,Z -Y,-X,Z Y,-X,-Z -Y,X,-Z X,Z,Y -X,Z,-Y -X,-Z,Y X,-Z,-Y Z,Y,X Z,-Y,-X -Z,Y,-X -Z,-Y,X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X Y,1/2+X,1/2+Z -Y,1/2-X,1/2+Z Y,1/2-X,1/2-Z -Y,1/2+X,1/2-Z X,1/2+Z,1/2+Y -X,1/2+Z,1/2-Y -X,1/2-Z,1/2+Y X,1/2-Z,1/2-Y Z,1/2+Y,1/2+X Z,1/2-Y,1/2-X -Z,1/2+Y,1/2-X -Z,1/2-Y,1/2+X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X 1/2+Y,X,1/2+Z 1/2-Y,-X,1/2+Z 1/2+Y,-X,1/2-Z 1/2-Y,X,1/2-Z 1/2+X,Z,1/2+Y 1/2-X,Z,1/2-Y 1/2-X,-Z,1/2+Y 1/2+X,-Z,1/2-Y 1/2+Z,Y,1/2+X 1/2+Z,-Y,1/2-X 1/2-Z,Y,1/2-X 1/2-Z,-Y,1/2+X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X 1/2+Y,1/2+X,Z 1/2-Y,1/2-X,Z 1/2+Y,1/2-X,-Z 1/2-Y,1/2+X,-Z 1/2+X,1/2+Z,Y 1/2-X,1/2+Z,-Y 1/2-X,1/2-Z,Y 1/2+X,1/2-Z,-Y 1/2+Z,1/2+Y,X 1/2+Z,1/2-Y,-X 1/2-Z,1/2+Y,-X 1/2-Z,1/2-Y,X".split(" "),
"I -4 3 m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,Z -Y,-X,Z Y,-X,-Z -Y,X,-Z X,Z,Y -X,Z,-Y -X,-Z,Y X,-Z,-Y Z,Y,X Z,-Y,-X -Z,Y,-X -Z,-Y,X 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y 1/2+Z,1/2-X,1/2-Y 1/2-Z,1/2-X,1/2+Y 1/2-Z,1/2+X,1/2-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,1/2-X 1/2-Y,1/2-Z,1/2+X 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+Z,1/2+Y,1/2+X 1/2+Z,1/2-Y,1/2-X 1/2-Z,1/2+Y,1/2-X 1/2-Z,1/2-Y,1/2+X".split(" "),
"P -4 3 n":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+Z,1/2+Y,1/2+X 1/2+Z,1/2-Y,1/2-X 1/2-Z,1/2+Y,1/2-X 1/2-Z,1/2-Y,1/2+X".split(" "),"F -4 3 c":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2-X,1/2-Z 1/2-Y,1/2+X,1/2-Z 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+Z,1/2+Y,1/2+X 1/2+Z,1/2-Y,1/2-X 1/2-Z,1/2+Y,1/2-X 1/2-Z,1/2-Y,1/2+X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X 1/2+Y,X,Z 1/2-Y,-X,Z 1/2+Y,-X,-Z 1/2-Y,X,-Z 1/2+X,Z,Y 1/2-X,Z,-Y 1/2-X,-Z,Y 1/2+X,-Z,-Y 1/2+Z,Y,X 1/2+Z,-Y,-X 1/2-Z,Y,-X 1/2-Z,-Y,X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X Y,1/2+X,Z -Y,1/2-X,Z Y,1/2-X,-Z -Y,1/2+X,-Z X,1/2+Z,Y -X,1/2+Z,-Y -X,1/2-Z,Y X,1/2-Z,-Y Z,1/2+Y,X Z,1/2-Y,-X -Z,1/2+Y,-X -Z,1/2-Y,X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X Y,X,1/2+Z -Y,-X,1/2+Z Y,-X,1/2-Z -Y,X,1/2-Z X,Z,1/2+Y -X,Z,1/2-Y -X,-Z,1/2+Y X,-Z,1/2-Y Z,Y,1/2+X Z,-Y,1/2-X -Z,Y,1/2-X -Z,-Y,1/2+X".split(" "),
"I -4 3 d":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X 1/4+Y,1/4+X,1/4+Z 1/4-Y,3/4-X,3/4+Z 3/4+Y,1/4-X,3/4-Z 3/4-Y,3/4+X,1/4-Z 1/4+X,1/4+Z,1/4+Y 3/4-X,3/4+Z,1/4-Y 1/4-X,3/4-Z,3/4+Y 3/4+X,1/4-Z,3/4-Y 1/4+Z,1/4+Y,1/4+X 3/4+Z,1/4-Y,3/4-X 3/4-Z,3/4+Y,1/4-X 1/4-Z,3/4-Y,3/4+X 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,Y,-Z X,-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y Z,-X,1/2-Y -Z,1/2-X,Y 1/2-Z,X,-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,Z,-X Y,-Z,1/2-X -Y,1/2-Z,X 3/4+Y,3/4+X,3/4+Z 3/4-Y,1/4-X,1/4+Z 1/4+Y,3/4-X,1/4-Z 1/4-Y,1/4+X,3/4-Z 3/4+X,3/4+Z,3/4+Y 1/4-X,1/4+Z,3/4-Y 3/4-X,1/4-Z,1/4+Y 1/4+X,3/4-Z,1/4-Y 3/4+Z,3/4+Y,3/4+X 1/4+Z,3/4-Y,1/4-X 1/4-Z,1/4+Y,3/4-X 3/4-Z,1/4-Y,1/4+X".split(" "),
"P 4/m -3 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X -Y,-X,Z Y,X,Z -Y,X,-Z Y,-X,-Z -X,-Z,Y X,-Z,-Y X,Z,Y -X,Z,-Y -Z,-Y,X -Z,Y,-X Z,-Y,-X Z,Y,X".split(" "),"P 4/n -3 2/n":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Z,1/2-X,1/2-Y 1/2-Z,1/2+X,1/2+Y 1/2+Z,1/2+X,1/2-Y 1/2+Z,1/2-X,1/2+Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,1/2+X 1/2+Y,1/2+Z,1/2-X 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2-X 1/2+Z,1/2+Y,1/2+X".split(" "),
"P 42/m -3 2/n":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2+Y,1/2-X,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+X,1/2+Z,1/2-Y 1/2-X,1/2+Z,1/2+Y 1/2-X,1/2-Z,1/2-Y 1/2+X,1/2-Z,1/2+Y 1/2+Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2+X 1/2-Z,1/2-Y,1/2-X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2-X 1/2+Z,1/2+Y,1/2+X".split(" "),
"P 42/n -3 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2+Y,1/2-X,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+X,1/2+Z,1/2-Y 1/2-X,1/2+Z,1/2+Y 1/2-X,1/2-Z,1/2-Y 1/2+X,1/2-Z,1/2+Y 1/2+Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2+X 1/2-Z,1/2-Y,1/2-X 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Z,1/2-X,1/2-Y 1/2-Z,1/2+X,1/2+Y 1/2+Z,1/2+X,1/2-Y 1/2+Z,1/2-X,1/2+Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,1/2+X 1/2+Y,1/2+Z,1/2-X -Y,-X,Z Y,X,Z -Y,X,-Z Y,-X,-Z -X,-Z,Y X,-Z,-Y X,Z,Y -X,Z,-Y -Z,-Y,X -Z,Y,-X Z,-Y,-X Z,Y,X".split(" "),
"F 4/m -3 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X -Y,-X,Z Y,X,Z -Y,X,-Z Y,-X,-Z -X,-Z,Y X,-Z,-Y X,Z,Y -X,Z,-Y -Z,-Y,X -Z,Y,-X Z,-Y,-X Z,Y,X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X Y,1/2+X,1/2-Z -Y,1/2-X,1/2-Z Y,1/2-X,1/2+Z -Y,1/2+X,1/2+Z X,1/2+Z,1/2-Y -X,1/2+Z,1/2+Y -X,1/2-Z,1/2-Y X,1/2-Z,1/2+Y Z,1/2+Y,1/2-X Z,1/2-Y,1/2+X -Z,1/2+Y,1/2+X -Z,1/2-Y,1/2-X -X,1/2-Y,1/2-Z X,1/2+Y,1/2-Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z -Z,1/2-X,1/2-Y -Z,1/2+X,1/2+Y Z,1/2+X,1/2-Y Z,1/2-X,1/2+Y -Y,1/2-Z,1/2-X Y,1/2-Z,1/2+X -Y,1/2+Z,1/2+X Y,1/2+Z,1/2-X -Y,1/2-X,1/2+Z Y,1/2+X,1/2+Z -Y,1/2+X,1/2-Z Y,1/2-X,1/2-Z -X,1/2-Z,1/2+Y X,1/2-Z,1/2-Y X,1/2+Z,1/2+Y -X,1/2+Z,1/2-Y -Z,1/2-Y,1/2+X -Z,1/2+Y,1/2-X Z,1/2-Y,1/2-X Z,1/2+Y,1/2+X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X 1/2+Y,X,1/2-Z 1/2-Y,-X,1/2-Z 1/2+Y,-X,1/2+Z 1/2-Y,X,1/2+Z 1/2+X,Z,1/2-Y 1/2-X,Z,1/2+Y 1/2-X,-Z,1/2-Y 1/2+X,-Z,1/2+Y 1/2+Z,Y,1/2-X 1/2+Z,-Y,1/2+X 1/2-Z,Y,1/2+X 1/2-Z,-Y,1/2-X 1/2-X,-Y,1/2-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z 1/2-X,Y,1/2+Z 1/2-Z,-X,1/2-Y 1/2-Z,X,1/2+Y 1/2+Z,X,1/2-Y 1/2+Z,-X,1/2+Y 1/2-Y,-Z,1/2-X 1/2+Y,-Z,1/2+X 1/2-Y,Z,1/2+X 1/2+Y,Z,1/2-X 1/2-Y,-X,1/2+Z 1/2+Y,X,1/2+Z 1/2-Y,X,1/2-Z 1/2+Y,-X,1/2-Z 1/2-X,-Z,1/2+Y 1/2+X,-Z,1/2-Y 1/2+X,Z,1/2+Y 1/2-X,Z,1/2-Y 1/2-Z,-Y,1/2+X 1/2-Z,Y,1/2-X 1/2+Z,-Y,1/2-X 1/2+Z,Y,1/2+X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X 1/2+Y,1/2+X,-Z 1/2-Y,1/2-X,-Z 1/2+Y,1/2-X,Z 1/2-Y,1/2+X,Z 1/2+X,1/2+Z,-Y 1/2-X,1/2+Z,Y 1/2-X,1/2-Z,-Y 1/2+X,1/2-Z,Y 1/2+Z,1/2+Y,-X 1/2+Z,1/2-Y,X 1/2-Z,1/2+Y,X 1/2-Z,1/2-Y,-X 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Z,1/2-X,-Y 1/2-Z,1/2+X,Y 1/2+Z,1/2+X,-Y 1/2+Z,1/2-X,Y 1/2-Y,1/2-Z,-X 1/2+Y,1/2-Z,X 1/2-Y,1/2+Z,X 1/2+Y,1/2+Z,-X 1/2-Y,1/2-X,Z 1/2+Y,1/2+X,Z 1/2-Y,1/2+X,-Z 1/2+Y,1/2-X,-Z 1/2-X,1/2-Z,Y 1/2+X,1/2-Z,-Y 1/2+X,1/2+Z,Y 1/2-X,1/2+Z,-Y 1/2-Z,1/2-Y,X 1/2-Z,1/2+Y,-X 1/2+Z,1/2-Y,-X 1/2+Z,1/2+Y,X".split(" "),
"F 4/m -3 2/c":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2+Y,1/2-X,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+X,1/2+Z,1/2-Y 1/2-X,1/2+Z,1/2+Y 1/2-X,1/2-Z,1/2-Y 1/2+X,1/2-Z,1/2+Y 1/2+Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2+X 1/2-Z,1/2-Y,1/2-X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2-X 1/2+Z,1/2+Y,1/2+X X,1/2+Y,1/2+Z -X,1/2-Y,1/2+Z -X,1/2+Y,1/2-Z X,1/2-Y,1/2-Z Z,1/2+X,1/2+Y Z,1/2-X,1/2-Y -Z,1/2-X,1/2+Y -Z,1/2+X,1/2-Y Y,1/2+Z,1/2+X -Y,1/2+Z,1/2-X Y,1/2-Z,1/2-X -Y,1/2-Z,1/2+X 1/2+Y,X,-Z 1/2-Y,-X,-Z 1/2+Y,-X,Z 1/2-Y,X,Z 1/2+X,Z,-Y 1/2-X,Z,Y 1/2-X,-Z,-Y 1/2+X,-Z,Y 1/2+Z,Y,-X 1/2+Z,-Y,X 1/2-Z,Y,X 1/2-Z,-Y,-X -X,1/2-Y,1/2-Z X,1/2+Y,1/2-Z X,1/2-Y,1/2+Z -X,1/2+Y,1/2+Z -Z,1/2-X,1/2-Y -Z,1/2+X,1/2+Y Z,1/2+X,1/2-Y Z,1/2-X,1/2+Y -Y,1/2-Z,1/2-X Y,1/2-Z,1/2+X -Y,1/2+Z,1/2+X Y,1/2+Z,1/2-X 1/2-Y,-X,Z 1/2+Y,X,Z 1/2-Y,X,-Z 1/2+Y,-X,-Z 1/2-X,-Z,Y 1/2+X,-Z,-Y 1/2+X,Z,Y 1/2-X,Z,-Y 1/2-Z,-Y,X 1/2-Z,Y,-X 1/2+Z,-Y,-X 1/2+Z,Y,X 1/2+X,Y,1/2+Z 1/2-X,-Y,1/2+Z 1/2-X,Y,1/2-Z 1/2+X,-Y,1/2-Z 1/2+Z,X,1/2+Y 1/2+Z,-X,1/2-Y 1/2-Z,-X,1/2+Y 1/2-Z,X,1/2-Y 1/2+Y,Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,-Z,1/2-X 1/2-Y,-Z,1/2+X Y,1/2+X,-Z -Y,1/2-X,-Z Y,1/2-X,Z -Y,1/2+X,Z X,1/2+Z,-Y -X,1/2+Z,Y -X,1/2-Z,-Y X,1/2-Z,Y Z,1/2+Y,-X Z,1/2-Y,X -Z,1/2+Y,X -Z,1/2-Y,-X 1/2-X,-Y,1/2-Z 1/2+X,Y,1/2-Z 1/2+X,-Y,1/2+Z 1/2-X,Y,1/2+Z 1/2-Z,-X,1/2-Y 1/2-Z,X,1/2+Y 1/2+Z,X,1/2-Y 1/2+Z,-X,1/2+Y 1/2-Y,-Z,1/2-X 1/2+Y,-Z,1/2+X 1/2-Y,Z,1/2+X 1/2+Y,Z,1/2-X -Y,1/2-X,Z Y,1/2+X,Z -Y,1/2+X,-Z Y,1/2-X,-Z -X,1/2-Z,Y X,1/2-Z,-Y X,1/2+Z,Y -X,1/2+Z,-Y -Z,1/2-Y,X -Z,1/2+Y,-X Z,1/2-Y,-X Z,1/2+Y,X 1/2+X,1/2+Y,Z 1/2-X,1/2-Y,Z 1/2-X,1/2+Y,-Z 1/2+X,1/2-Y,-Z 1/2+Z,1/2+X,Y 1/2+Z,1/2-X,-Y 1/2-Z,1/2-X,Y 1/2-Z,1/2+X,-Y 1/2+Y,1/2+Z,X 1/2-Y,1/2+Z,-X 1/2+Y,1/2-Z,-X 1/2-Y,1/2-Z,X Y,X,1/2-Z -Y,-X,1/2-Z Y,-X,1/2+Z -Y,X,1/2+Z X,Z,1/2-Y -X,Z,1/2+Y -X,-Z,1/2-Y X,-Z,1/2+Y Z,Y,1/2-X Z,-Y,1/2+X -Z,Y,1/2+X -Z,-Y,1/2-X 1/2-X,1/2-Y,-Z 1/2+X,1/2+Y,-Z 1/2+X,1/2-Y,Z 1/2-X,1/2+Y,Z 1/2-Z,1/2-X,-Y 1/2-Z,1/2+X,Y 1/2+Z,1/2+X,-Y 1/2+Z,1/2-X,Y 1/2-Y,1/2-Z,-X 1/2+Y,1/2-Z,X 1/2-Y,1/2+Z,X 1/2+Y,1/2+Z,-X -Y,-X,1/2+Z Y,X,1/2+Z -Y,X,1/2-Z Y,-X,1/2-Z -X,-Z,1/2+Y X,-Z,1/2-Y X,Z,1/2+Y -X,Z,1/2-Y -Z,-Y,1/2+X -Z,Y,1/2-X Z,-Y,1/2-X Z,Y,1/2+X".split(" "),
"F 41/d -3 2/m":"X,Y,Z -X,1/2-Y,1/2+Z 1/2-X,1/2+Y,-Z 1/2+X,-Y,1/2-Z Z,X,Y 1/2+Z,-X,1/2-Y -Z,1/2-X,1/2+Y 1/2-Z,1/2+X,-Y Y,Z,X 1/2-Y,1/2+Z,-X 1/2+Y,-Z,1/2-X -Y,1/2-Z,1/2+X 3/4+Y,1/4+X,3/4-Z 1/4-Y,1/4-X,1/4-Z 1/4+Y,3/4-X,3/4+Z 3/4-Y,3/4+X,1/4+Z 3/4+X,1/4+Z,3/4-Y 3/4-X,3/4+Z,1/4+Y 1/4-X,1/4-Z,1/4-Y 1/4+X,3/4-Z,3/4+Y 3/4+Z,1/4+Y,3/4-X 1/4+Z,3/4-Y,3/4+X 3/4-Z,3/4+Y,1/4+X 1/4-Z,1/4-Y,1/4-X 1/4-X,1/4-Y,1/4-Z 1/4+X,3/4+Y,3/4-Z 3/4+X,3/4-Y,1/4+Z 3/4-X,1/4+Y,3/4+Z 1/4-Z,1/4-X,1/4-Y 3/4-Z,1/4+X,3/4+Y 1/4+Z,3/4+X,3/4-Y 3/4+Z,3/4-X,1/4+Y 1/4-Y,1/4-Z,1/4-X 3/4+Y,3/4-Z,1/4+X 3/4-Y,1/4+Z,3/4+X 1/4+Y,3/4+Z,3/4-X 1/2-Y,-X,1/2+Z Y,X,Z -Y,1/2+X,1/2-Z 1/2+Y,1/2-X,-Z 1/2-X,-Z,1/2+Y 1/2+X,1/2-Z,-Y X,Z,Y -X,1/2+Z,1/2-Y 1/2-Z,-Y,1/2+X -Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,-X Z,Y,X X,1/2+Y,1/2+Z -X,-Y,Z 1/2-X,Y,1/2-Z 1/2+X,1/2-Y,-Z Z,1/2+X,1/2+Y 1/2+Z,1/2-X,-Y -Z,-X,Y 1/2-Z,X,1/2-Y Y,1/2+Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,1/2-Z,-X -Y,-Z,X 3/4+Y,3/4+X,1/4-Z 1/4-Y,3/4-X,3/4-Z 1/4+Y,1/4-X,1/4+Z 3/4-Y,1/4+X,3/4+Z 3/4+X,3/4+Z,1/4-Y 3/4-X,1/4+Z,3/4+Y 1/4-X,3/4-Z,3/4-Y 1/4+X,1/4-Z,1/4+Y 3/4+Z,3/4+Y,1/4-X 1/4+Z,1/4-Y,1/4+X 3/4-Z,1/4+Y,3/4+X 1/4-Z,3/4-Y,3/4-X 1/4-X,3/4-Y,3/4-Z 1/4+X,1/4+Y,1/4-Z 3/4+X,1/4-Y,3/4+Z 3/4-X,3/4+Y,1/4+Z 1/4-Z,3/4-X,3/4-Y 3/4-Z,3/4+X,1/4+Y 1/4+Z,1/4+X,1/4-Y 3/4+Z,1/4-X,3/4+Y 1/4-Y,3/4-Z,3/4-X 3/4+Y,1/4-Z,3/4+X 3/4-Y,3/4+Z,1/4+X 1/4+Y,1/4+Z,1/4-X 1/2-Y,1/2-X,Z Y,1/2+X,1/2+Z -Y,X,-Z 1/2+Y,-X,1/2-Z 1/2-X,1/2-Z,Y 1/2+X,-Z,1/2-Y X,1/2+Z,1/2+Y -X,Z,-Y 1/2-Z,1/2-Y,X -Z,Y,-X 1/2+Z,-Y,1/2-X Z,1/2+Y,1/2+X 1/2+X,Y,1/2+Z 1/2-X,1/2-Y,Z -X,1/2+Y,1/2-Z X,-Y,-Z 1/2+Z,X,1/2+Y Z,-X,-Y 1/2-Z,1/2-X,Y -Z,1/2+X,1/2-Y 1/2+Y,Z,1/2+X -Y,1/2+Z,1/2-X Y,-Z,-X 1/2-Y,1/2-Z,X 1/4+Y,1/4+X,1/4-Z 3/4-Y,1/4-X,3/4-Z 3/4+Y,3/4-X,1/4+Z 1/4-Y,3/4+X,3/4+Z 1/4+X,1/4+Z,1/4-Y 1/4-X,3/4+Z,3/4+Y 3/4-X,1/4-Z,3/4-Y 3/4+X,3/4-Z,1/4+Y 1/4+Z,1/4+Y,1/4-X 3/4+Z,3/4-Y,1/4+X 1/4-Z,3/4+Y,3/4+X 3/4-Z,1/4-Y,3/4-X 3/4-X,1/4-Y,3/4-Z 3/4+X,3/4+Y,1/4-Z 1/4+X,3/4-Y,3/4+Z 1/4-X,1/4+Y,1/4+Z 3/4-Z,1/4-X,3/4-Y 1/4-Z,1/4+X,1/4+Y 3/4+Z,3/4+X,1/4-Y 1/4+Z,3/4-X,3/4+Y 3/4-Y,1/4-Z,3/4-X 1/4+Y,3/4-Z,3/4+X 1/4-Y,1/4+Z,1/4+X 3/4+Y,3/4+Z,1/4-X -Y,-X,Z 1/2+Y,X,1/2+Z 1/2-Y,1/2+X,-Z Y,1/2-X,1/2-Z -X,-Z,Y X,1/2-Z,1/2-Y 1/2+X,Z,1/2+Y 1/2-X,1/2+Z,-Y -Z,-Y,X 1/2-Z,1/2+Y,-X Z,1/2-Y,1/2-X 1/2+Z,Y,1/2+X 1/2+X,1/2+Y,Z 1/2-X,-Y,1/2+Z -X,Y,-Z X,1/2-Y,1/2-Z 1/2+Z,1/2+X,Y Z,1/2-X,1/2-Y 1/2-Z,-X,1/2+Y -Z,X,-Y 1/2+Y,1/2+Z,X -Y,Z,-X Y,1/2-Z,1/2-X 1/2-Y,-Z,1/2+X 1/4+Y,3/4+X,3/4-Z 3/4-Y,3/4-X,1/4-Z 3/4+Y,1/4-X,3/4+Z 1/4-Y,1/4+X,1/4+Z 1/4+X,3/4+Z,3/4-Y 1/4-X,1/4+Z,1/4+Y 3/4-X,3/4-Z,1/4-Y 3/4+X,1/4-Z,3/4+Y 1/4+Z,3/4+Y,3/4-X 3/4+Z,1/4-Y,3/4+X 1/4-Z,1/4+Y,1/4+X 3/4-Z,3/4-Y,1/4-X 3/4-X,3/4-Y,1/4-Z 3/4+X,1/4+Y,3/4-Z 1/4+X,1/4-Y,1/4+Z 1/4-X,3/4+Y,3/4+Z 3/4-Z,3/4-X,1/4-Y 1/4-Z,3/4+X,3/4+Y 3/4+Z,1/4+X,3/4-Y 1/4+Z,1/4-X,1/4+Y 3/4-Y,3/4-Z,1/4-X 1/4+Y,1/4-Z,1/4+X 1/4-Y,3/4+Z,3/4+X 3/4+Y,1/4+Z,3/4-X -Y,1/2-X,1/2+Z 1/2+Y,1/2+X,Z 1/2-Y,X,1/2-Z Y,-X,-Z -X,1/2-Z,1/2+Y X,-Z,-Y 1/2+X,1/2+Z,Y 1/2-X,Z,1/2-Y -Z,1/2-Y,1/2+X 1/2-Z,Y,1/2-X Z,-Y,-X 1/2+Z,1/2+Y,X".split(" "),
"F 41/d -3 2/c":"X,Y,Z -X,1/2-Y,1/2+Z 1/2-X,1/2+Y,-Z 1/2+X,-Y,1/2-Z Z,X,Y 1/2+Z,-X,1/2-Y -Z,1/2-X,1/2+Y 1/2-Z,1/2+X,-Y Y,Z,X 1/2-Y,1/2+Z,-X 1/2+Y,-Z,1/2-X -Y,1/2-Z,1/2+X 3/4+Y,1/4+X,3/4-Z 1/4-Y,1/4-X,1/4-Z 1/4+Y,3/4-X,3/4+Z 3/4-Y,3/4+X,1/4+Z 3/4+X,1/4+Z,3/4-Y 3/4-X,3/4+Z,1/4+Y 1/4-X,1/4-Z,1/4-Y 1/4+X,3/4-Z,3/4+Y 3/4+Z,1/4+Y,3/4-X 1/4+Z,3/4-Y,3/4+X 3/4-Z,3/4+Y,1/4+X 1/4-Z,1/4-Y,1/4-X 3/4-X,3/4-Y,3/4-Z 3/4+X,1/4+Y,1/4-Z 1/4+X,1/4-Y,3/4+Z 1/4-X,3/4+Y,1/4+Z 3/4-Z,3/4-X,3/4-Y 1/4-Z,3/4+X,1/4+Y 3/4+Z,1/4+X,1/4-Y 1/4+Z,1/4-X,3/4+Y 3/4-Y,3/4-Z,3/4-X 1/4+Y,1/4-Z,3/4+X 1/4-Y,3/4+Z,1/4+X 3/4+Y,1/4+Z,1/4-X -Y,1/2-X,Z 1/2+Y,1/2+X,1/2+Z 1/2-Y,X,-Z Y,-X,1/2-Z -X,1/2-Z,Y X,-Z,1/2-Y 1/2+X,1/2+Z,1/2+Y 1/2-X,Z,-Y -Z,1/2-Y,X 1/2-Z,Y,-X Z,-Y,1/2-X 1/2+Z,1/2+Y,1/2+X X,1/2+Y,1/2+Z -X,-Y,Z 1/2-X,Y,1/2-Z 1/2+X,1/2-Y,-Z Z,1/2+X,1/2+Y 1/2+Z,1/2-X,-Y -Z,-X,Y 1/2-Z,X,1/2-Y Y,1/2+Z,1/2+X 1/2-Y,Z,1/2-X 1/2+Y,1/2-Z,-X -Y,-Z,X 3/4+Y,3/4+X,1/4-Z 1/4-Y,3/4-X,3/4-Z 1/4+Y,1/4-X,1/4+Z 3/4-Y,1/4+X,3/4+Z 3/4+X,3/4+Z,1/4-Y 3/4-X,1/4+Z,3/4+Y 1/4-X,3/4-Z,3/4-Y 1/4+X,1/4-Z,1/4+Y 3/4+Z,3/4+Y,1/4-X 1/4+Z,1/4-Y,1/4+X 3/4-Z,1/4+Y,3/4+X 1/4-Z,3/4-Y,3/4-X 3/4-X,1/4-Y,1/4-Z 3/4+X,3/4+Y,3/4-Z 1/4+X,3/4-Y,1/4+Z 1/4-X,1/4+Y,3/4+Z 3/4-Z,1/4-X,1/4-Y 1/4-Z,1/4+X,3/4+Y 3/4+Z,3/4+X,3/4-Y 1/4+Z,3/4-X,1/4+Y 3/4-Y,1/4-Z,1/4-X 1/4+Y,3/4-Z,1/4+X 1/4-Y,1/4+Z,3/4+X 3/4+Y,3/4+Z,3/4-X -Y,-X,1/2+Z 1/2+Y,X,Z 1/2-Y,1/2+X,1/2-Z Y,1/2-X,-Z -X,-Z,1/2+Y X,1/2-Z,-Y 1/2+X,Z,Y 1/2-X,1/2+Z,1/2-Y -Z,-Y,1/2+X 1/2-Z,1/2+Y,1/2-X Z,1/2-Y,-X 1/2+Z,Y,X 1/2+X,Y,1/2+Z 1/2-X,1/2-Y,Z -X,1/2+Y,1/2-Z X,-Y,-Z 1/2+Z,X,1/2+Y Z,-X,-Y 1/2-Z,1/2-X,Y -Z,1/2+X,1/2-Y 1/2+Y,Z,1/2+X -Y,1/2+Z,1/2-X Y,-Z,-X 1/2-Y,1/2-Z,X 1/4+Y,1/4+X,1/4-Z 3/4-Y,1/4-X,3/4-Z 3/4+Y,3/4-X,1/4+Z 1/4-Y,3/4+X,3/4+Z 1/4+X,1/4+Z,1/4-Y 1/4-X,3/4+Z,3/4+Y 3/4-X,1/4-Z,3/4-Y 3/4+X,3/4-Z,1/4+Y 1/4+Z,1/4+Y,1/4-X 3/4+Z,3/4-Y,1/4+X 1/4-Z,3/4+Y,3/4+X 3/4-Z,1/4-Y,3/4-X 1/4-X,3/4-Y,1/4-Z 1/4+X,1/4+Y,3/4-Z 3/4+X,1/4-Y,1/4+Z 3/4-X,3/4+Y,3/4+Z 1/4-Z,3/4-X,1/4-Y 3/4-Z,3/4+X,3/4+Y 1/4+Z,1/4+X,3/4-Y 3/4+Z,1/4-X,1/4+Y 1/4-Y,3/4-Z,1/4-X 3/4+Y,1/4-Z,1/4+X 3/4-Y,3/4+Z,3/4+X 1/4+Y,1/4+Z,3/4-X 1/2-Y,1/2-X,1/2+Z Y,1/2+X,Z -Y,X,1/2-Z 1/2+Y,-X,-Z 1/2-X,1/2-Z,1/2+Y 1/2+X,-Z,-Y X,1/2+Z,Y -X,Z,1/2-Y 1/2-Z,1/2-Y,1/2+X -Z,Y,1/2-X 1/2+Z,-Y,-X Z,1/2+Y,X 1/2+X,1/2+Y,Z 1/2-X,-Y,1/2+Z -X,Y,-Z X,1/2-Y,1/2-Z 1/2+Z,1/2+X,Y Z,1/2-X,1/2-Y 1/2-Z,-X,1/2+Y -Z,X,-Y 1/2+Y,1/2+Z,X -Y,Z,-X Y,1/2-Z,1/2-X 1/2-Y,-Z,1/2+X 1/4+Y,3/4+X,3/4-Z 3/4-Y,3/4-X,1/4-Z 3/4+Y,1/4-X,3/4+Z 1/4-Y,1/4+X,1/4+Z 1/4+X,3/4+Z,3/4-Y 1/4-X,1/4+Z,1/4+Y 3/4-X,3/4-Z,1/4-Y 3/4+X,1/4-Z,3/4+Y 1/4+Z,3/4+Y,3/4-X 3/4+Z,1/4-Y,3/4+X 1/4-Z,1/4+Y,1/4+X 3/4-Z,3/4-Y,1/4-X 1/4-X,1/4-Y,3/4-Z 1/4+X,3/4+Y,1/4-Z 3/4+X,3/4-Y,3/4+Z 3/4-X,1/4+Y,1/4+Z 1/4-Z,1/4-X,3/4-Y 3/4-Z,1/4+X,1/4+Y 1/4+Z,3/4+X,1/4-Y 3/4+Z,3/4-X,3/4+Y 1/4-Y,1/4-Z,3/4-X 3/4+Y,3/4-Z,3/4+X 3/4-Y,1/4+Z,1/4+X 1/4+Y,3/4+Z,1/4-X 1/2-Y,-X,Z Y,X,1/2+Z -Y,1/2+X,-Z 1/2+Y,1/2-X,1/2-Z 1/2-X,-Z,Y 1/2+X,1/2-Z,1/2-Y X,Z,1/2+Y -X,1/2+Z,-Y 1/2-Z,-Y,X -Z,1/2+Y,-X 1/2+Z,1/2-Y,1/2-X Z,Y,1/2+X".split(" "),
"I 4/m -3 2/m":"X,Y,Z -X,-Y,Z -X,Y,-Z X,-Y,-Z Z,X,Y Z,-X,-Y -Z,-X,Y -Z,X,-Y Y,Z,X -Y,Z,-X Y,-Z,-X -Y,-Z,X Y,X,-Z -Y,-X,-Z Y,-X,Z -Y,X,Z X,Z,-Y -X,Z,Y -X,-Z,-Y X,-Z,Y Z,Y,-X Z,-Y,X -Z,Y,X -Z,-Y,-X -X,-Y,-Z X,Y,-Z X,-Y,Z -X,Y,Z -Z,-X,-Y -Z,X,Y Z,X,-Y Z,-X,Y -Y,-Z,-X Y,-Z,X -Y,Z,X Y,Z,-X -Y,-X,Z Y,X,Z -Y,X,-Z Y,-X,-Z -X,-Z,Y X,-Z,-Y X,Z,Y -X,Z,-Y -Z,-Y,X -Z,Y,-X Z,-Y,-X Z,Y,X 1/2+X,1/2+Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y 1/2+Z,1/2-X,1/2-Y 1/2-Z,1/2-X,1/2+Y 1/2-Z,1/2+X,1/2-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,1/2-X 1/2-Y,1/2-Z,1/2+X 1/2+Y,1/2+X,1/2-Z 1/2-Y,1/2-X,1/2-Z 1/2+Y,1/2-X,1/2+Z 1/2-Y,1/2+X,1/2+Z 1/2+X,1/2+Z,1/2-Y 1/2-X,1/2+Z,1/2+Y 1/2-X,1/2-Z,1/2-Y 1/2+X,1/2-Z,1/2+Y 1/2+Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2+X 1/2-Z,1/2-Y,1/2-X 1/2-X,1/2-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z 1/2+X,1/2-Y,1/2+Z 1/2-X,1/2+Y,1/2+Z 1/2-Z,1/2-X,1/2-Y 1/2-Z,1/2+X,1/2+Y 1/2+Z,1/2+X,1/2-Y 1/2+Z,1/2-X,1/2+Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,1/2+X 1/2+Y,1/2+Z,1/2-X 1/2-Y,1/2-X,1/2+Z 1/2+Y,1/2+X,1/2+Z 1/2-Y,1/2+X,1/2-Z 1/2+Y,1/2-X,1/2-Z 1/2-X,1/2-Z,1/2+Y 1/2+X,1/2-Z,1/2-Y 1/2+X,1/2+Z,1/2+Y 1/2-X,1/2+Z,1/2-Y 1/2-Z,1/2-Y,1/2+X 1/2-Z,1/2+Y,1/2-X 1/2+Z,1/2-Y,1/2-X 1/2+Z,1/2+Y,1/2+X".split(" "),
"I 41/a -3 2/d":"X,Y,Z 1/2-X,-Y,1/2+Z -X,1/2+Y,1/2-Z 1/2+X,1/2-Y,-Z Z,X,Y 1/2+Z,1/2-X,-Y 1/2-Z,-X,1/2+Y -Z,1/2+X,1/2-Y Y,Z,X -Y,1/2+Z,1/2-X 1/2+Y,1/2-Z,-X 1/2-Y,-Z,1/2+X 3/4+Y,1/4+X,1/4-Z 3/4-Y,3/4-X,3/4-Z 1/4+Y,1/4-X,3/4+Z 1/4-Y,3/4+X,1/4+Z 3/4+X,1/4+Z,1/4-Y 1/4-X,3/4+Z,1/4+Y 3/4-X,3/4-Z,3/4-Y 1/4+X,1/4-Z,3/4+Y 3/4+Z,1/4+Y,1/4-X 1/4+Z,1/4-Y,3/4+X 1/4-Z,3/4+Y,1/4+X 3/4-Z,3/4-Y,3/4-X -X,-Y,-Z 1/2+X,Y,1/2-Z X,1/2-Y,1/2+Z 1/2-X,1/2+Y,Z -Z,-X,-Y 1/2-Z,1/2+X,Y 1/2+Z,X,1/2-Y Z,1/2-X,1/2+Y -Y,-Z,-X Y,1/2-Z,1/2+X 1/2-Y,1/2+Z,X 1/2+Y,Z,1/2-X 1/4-Y,3/4-X,3/4+Z 1/4+Y,1/4+X,1/4+Z 3/4-Y,3/4+X,1/4-Z 3/4+Y,1/4-X,3/4-Z 1/4-X,3/4-Z,3/4+Y 3/4+X,1/4-Z,3/4-Y 1/4+X,1/4+Z,1/4+Y 3/4-X,3/4+Z,1/4-Y 1/4-Z,3/4-Y,3/4+X 3/4-Z,3/4+Y,1/4-X 3/4+Z,1/4-Y,3/4-X 1/4+Z,1/4+Y,1/4+X 1/2+X,1/2+Y,1/2+Z -X,1/2-Y,Z 1/2-X,Y,-Z X,-Y,1/2-Z 1/2+Z,1/2+X,1/2+Y Z,-X,1/2-Y -Z,1/2-X,Y 1/2-Z,X,-Y 1/2+Y,1/2+Z,1/2+X 1/2-Y,Z,-X Y,-Z,1/2-X -Y,1/2-Z,X 1/4+Y,3/4+X,3/4-Z 1/4-Y,1/4-X,1/4-Z 3/4+Y,3/4-X,1/4+Z 3/4-Y,1/4+X,3/4+Z 1/4+X,3/4+Z,3/4-Y 3/4-X,1/4+Z,3/4+Y 1/4-X,1/4-Z,1/4-Y 3/4+X,3/4-Z,1/4+Y 1/4+Z,3/4+Y,3/4-X 3/4+Z,3/4-Y,1/4+X 3/4-Z,1/4+Y,3/4+X 1/4-Z,1/4-Y,1/4-X 1/2-X,1/2-Y,1/2-Z X,1/2+Y,-Z 1/2+X,-Y,Z -X,Y,1/2+Z 1/2-Z,1/2-X,1/2-Y -Z,X,1/2+Y Z,1/2+X,-Y 1/2+Z,-X,Y 1/2-Y,1/2-Z,1/2-X 1/2+Y,-Z,X -Y,Z,1/2+X Y,1/2+Z,-X 3/4-Y,1/4-X,1/4+Z 3/4+Y,3/4+X,3/4+Z 1/4-Y,1/4+X,3/4-Z 1/4+Y,3/4-X,1/4-Z 3/4-X,1/4-Z,1/4+Y 1/4+X,3/4-Z,1/4-Y 3/4+X,3/4+Z,3/4+Y 1/4-X,1/4+Z,3/4-Y 3/4-Z,1/4-Y,1/4+X 1/4-Z,1/4+Y,3/4-X 1/4+Z,3/4-Y,1/4-X 3/4+Z,3/4+Y,3/4+X".split(" "),
"P 1 1 2":["X,Y,Z","-X,-Y,Z"],"P 1 1 21":["X,Y,Z","-X,-Y,1/2+Z"],"B 1 1 2":["X,Y,Z","-X,-Y,Z","1/2+X,+Y,1/2+Z","1/2-X,-Y,1/2+Z"],"A 1 2 1":["X,Y,Z","-X,Y,-Z","X,1/2+Y,1/2+Z","-X,1/2+Y,1/2-Z"],"C 1 21 1":["X,Y,Z","-X,1/2+Y,-Z","1/2+X,1/2+Y,Z","1/2-X,Y,-Z"],"I 1 2 1":["X,Y,Z","-X,Y,-Z","X+1/2,Y+1/2,Z+1/2","-X+1/2,Y+1/2,-Z+1/2"],"I 1 21 1":["X,Y,Z","-X,1/2+Y,-Z","X+1/2,Y+1/2,Z+1/2","-X+1/2,Y,1/2-Z"],"P 1 1 m":["X,Y,Z","X,Y,-Z"],"P 1 1 b":["X,Y,Z","X,1/2+Y,-Z"],"B 1 1 m":["X,Y,Z","X,Y,-Z","1/2+X,Y,1/2+Z",
"1/2+X,Y,1/2-Z"],"B 1 1 b":["X,Y,Z","X,1/2+Y,-Z","1/2+X,Y,1/2+Z","1/2+X,1/2+Y,1/2-Z"],"P 1 1 2/m":["X,Y,Z","X,Y,-Z","-X,-Y,Z","-X,-Y,-Z"],"P 1 1 21/m":["X,Y,Z","-X,-Y,1/2+Z","-X,-Y,-Z","X,Y,1/2-Z"],"B 1 1 2/m":"X,Y,Z X,Y,-Z -X,-Y,Z -X,-Y,-Z 1/2+X,Y,1/2+Z 1/2+X,Y,1/2-Z 1/2-X,-Y,1/2+Z 1/2-X,-Y,1/2-Z".split(" "),"P 1 1 2/b":["X,Y,Z","-X,1/2-Y,Z","-X,-Y,-Z","X,1/2+Y,-Z"],"P 1 1 21/b":["X,Y,Z","-X,-Y,-Z","-X,1/2-Y,1/2+Z","X,1/2+Y,1/2-Z"],"B 1 1 2/b":"X,Y,Z -X,1/2-Y,Z -X,-Y,-Z X,1/2+Y,-Z 1/2+X,Y,1/2+Z 1/2-X,1/2-Y,1/2+Z 1/2-X,-Y,1/2-Z 1/2+X,1/2+Y,1/2-Z".split(" "),
"P 21 2 2":["X,Y,Z","-X,Y,-Z","1/2+X,-Y,-Z","1/2-X,-Y,Z"],"P 2 21 2":["X,Y,Z","X,1/2-Y,-Z","-X,1/2+Y,-Z","-X,-Y,Z"],"P 21 21 2 (a)":["X,Y,Z","1/2-X,1/2-Y,Z","X+1/2,-Y,-Z","-X,Y+1/2,-Z"],"P 21 2 21":["X,Y,Z","-X,Y,-Z","1/2+X,-Y,1/2-Z","1/2-X,-Y,1/2+Z"],"P 2 21 21":["X,Y,Z","X,-Y,-Z","-X,1/2+Y,1/2-Z","-X,1/2-Y,1/2+Z"],"C 2 2 21a)":"X,Y,Z 1/2-X,-Y,1/2+Z 1/2+X,1/2-Y,-Z -X,1/2+Y,1/2-Z 1/2+X,1/2+Y,Z -X,1/2-Y,1/2+Z X,-Y,-Z 1/2-X,Y,1/2-Z".split(" "),"C 2 2 2a":"X,Y,Z;1/2-X,1/2-Y,Z;X+1/2,-Y,-Z;-X,Y+1/2,-Z;1/2+ X,1/2+Y,Z;-X,-Y,Z;X,1/2-Y,-Z;1/2-X,Y,-Z".split(";"),
"F 2 2 2a":"X,Y,Z 1/2-X,1/2-Y,Z X+1/2,-Y,-Z -X,Y+1/2,-Z X,Y+1/2,Z+1/2 1/2-X,-Y,Z+1/2 X+1/2,-Y+1/2,-Z+1/2 -X,Y,-Z+1/2 X+1/2,Y,Z+1/2 -X,1/2-Y,Z+1/2 X,-Y,-Z+1/2 -X+1/2,Y+1/2,-Z+1/2 X+1/2,Y+1/2,Z -X,-Y,Z X,-Y+1/2,-Z -X+1/2,Y,-Z".split(" "),"I 2 2 2a":"X,Y,Z 1/2-X,1/2-Y,Z X+1/2,-Y,-Z -X,Y+1/2,-Z 1/2+X,1/2+Y,1/2+Z -X,-Y,1/2+Z 1/2-X,Y,1/2-Z X,1/2-Y,1/2-Z".split(" "),"P 21/m 21/m 2/n a":"X,Y,Z 1/2-X,1/2-Y,Z -X,1/2+Y,-Z 1/2+X,-Y,-Z -X,-Y,-Z X+1/2,Y+1/2,-Z X,1/2-Y,Z 1/2-X,Y,Z".split(" "),"P 42 21 2a":"X,Y,Z 1/2-X,1/2-Y,Z -Y,X+1/2,1/2+Z Y+1/2,-X,1/2+Z -X,Y+1/2,-Z X+1/2,-Y,-Z Y,X,1/2-Z 1/2-Y,1/2-X,1/2-Z".split(" "),
"I 2 3a":"X,Y,Z 1/2-X,1/2-Y,Z X+1/2,-Y,-Z -X,Y+1/2,-Z Y,Z,X 1/2-Y,1/2-Z,X Y+1/2,-Z,-X -Y,Z+1/2,-X Z,X,Y 1/2-Z,1/2-X,Y Z+1/2,-X,-Y -Z,X+1/2,-Y 1/2+X,1/2+Y,1/2+Z -X,-Y,1/2+Z X,1/2-Y,1/2-Z 1/2-X,Y,1/2-Z 1/2+Y,1/2+Z,1/2+X -Y,-Z,1/2+X Y,1/2-Z,1/2-X 1/2-Y,Z,1/2-X 1/2+Z,1/2+X,1/2+Y -Z,-X,1/2+Y Z,1/2-X,1/2-Y 1/2-Z,X,1/2-Y".split(" ")};
NGL.SubstitutionMatrices=function(){function a(a,c){var d,e=0,f={};c.forEach(function(c){d=0;var h={};c.forEach(function(c){h[a[d++]]=c});f[a[e++]]=h});return f}return{blosum62:a("ARNDCQEGHILKMFPSTWYVBZ?",[[4,-1,-2,-2,0,-1,-1,0,-2,-1,-1,-1,-1,-2,-1,1,0,-3,-2,0,-2,-1,0],[-1,5,0,-2,-3,1,0,-2,0,-3,-2,2,-1,-3,-2,-1,-1,-3,-2,-3,-1,0,-1],[-2,0,6,1,-3,0,0,0,1,-3,-3,0,-2,-3,-2,1,0,-4,-2,-3,3,0,-1],[-2,-2,1,6,-3,0,2,-1,-1,-3,-4,-1,-3,-3,-1,0,-1,-4,-3,-3,4,1,-1],[0,-3,-3,-3,9,-3,-4,-3,-3,-1,-1,-3,-1,-2,-3,
-1,-1,-2,-2,-1,-3,-3,-2],[-1,1,0,0,-3,5,2,-2,0,-3,-2,1,0,-3,-1,0,-1,-2,-1,-2,0,3,-1],[-1,0,0,2,-4,2,5,-2,0,-3,-3,1,-2,-3,-1,0,-1,-3,-2,-2,1,4,-1],[0,-2,0,-1,-3,-2,-2,6,-2,-4,-4,-2,-3,-3,-2,0,-2,-2,-3,-3,-1,-2,-1],[-2,0,1,-1,-3,0,0,-2,8,-3,-3,-1,-2,-1,-2,-1,-2,-2,2,-3,0,0,-1],[-1,-3,-3,-3,-1,-3,-3,-4,-3,4,2,-3,1,0,-3,-2,-1,-3,-1,3,-3,-3,-1],[-1,-2,-3,-4,-1,-2,-3,-4,-3,2,4,-2,2,0,-3,-2,-1,-2,-1,1,-4,-3,-1],[-1,2,0,-1,-3,1,1,-2,-1,-3,-2,5,-1,-3,-1,0,-1,-3,-2,-2,0,1,-1],[-1,-1,-2,-3,-1,0,-2,-3,-2,1,2,
-1,5,0,-2,-1,-1,-1,-1,1,-3,-1,-1],[-2,-3,-3,-3,-2,-3,-3,-3,-1,0,0,-3,0,6,-4,-2,-2,1,3,-1,-3,-3,-1],[-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4,7,-1,-1,-4,-3,-2,-2,-1,-2],[1,-1,1,0,-1,0,0,0,-1,-2,-2,0,-1,-2,-1,4,1,-3,-2,-2,0,0,0],[0,-1,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1,1,5,-2,-2,0,-1,-1,0],[-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1,1,-4,-3,-2,11,2,-3,-4,-3,-2],[-2,-2,-2,-3,-2,-1,-2,-3,2,-1,-1,-2,-1,3,-3,-2,-2,2,7,-1,-3,-2,-1],[0,-3,-3,-3,-1,-2,-2,-3,-3,3,1,-2,1,-1,-2,-2,0,-3,-1,4,-3,-2,-1],[-2,-1,
3,4,-3,0,1,-1,0,-3,-4,0,-3,-3,-2,0,-1,-4,-3,-3,4,1,-1],[-1,0,0,1,-3,3,4,-2,0,-3,-3,1,-1,-3,-1,0,-1,-3,-2,-2,1,4,-1],[0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,0,0,-2,-1,-1,-1,-1,-1]]),blosum62x:a("ACDEFGHIKLMNPQRSTVWY",[[4,0,-2,-1,-2,0,-2,-1,-1,-1,-1,-2,-1,-1,-1,1,0,0,-3,-2],[0,9,-3,-4,-2,-3,-3,-1,-3,-1,-1,-3,-3,-3,-3,-1,-1,-1,-2,-2],[-2,-3,6,2,-3,-1,-1,-3,-1,-4,-3,1,-1,0,-2,0,-1,-3,-4,-3],[-1,-4,2,5,-3,-2,0,-3,1,-3,-2,0,-1,2,0,0,-1,-2,-3,-2],[-2,-2,-3,-3,6,-3,-1,0,-3,0,0,-3,-4,-3,-3,-2,-2,-1,1,
3],[0,-3,-1,-2,-3,6,-2,-4,-2,-4,-3,0,-2,-2,-2,0,-2,-3,-2,-3],[-2,-3,-1,0,-1,-2,8,-3,-1,-3,-2,1,-2,0,0,-1,-2,-3,-2,2],[-1,-1,-3,-3,0,-4,-3,4,-3,2,1,-3,-3,-3,-3,-2,-1,3,-3,-1],[-1,-3,-1,1,-3,-2,-1,-3,5,-2,-1,0,-1,1,2,0,-1,-2,-3,-2],[-1,-1,-4,-3,0,-4,-3,2,-2,4,2,-3,-3,-2,-2,-2,-1,1,-2,-1],[-1,-1,-3,-2,0,-3,-2,1,-1,2,5,-2,-2,0,-1,-1,-1,1,-1,-1],[-2,-3,1,0,-3,0,1,-3,0,-3,-2,6,-2,0,0,1,0,-3,-4,-2],[-1,-3,-1,-1,-4,-2,-2,-3,-1,-3,-2,-2,7,-1,-2,-1,-1,-2,-4,-3],[-1,-3,0,2,-3,-2,0,-3,1,-2,0,0,-1,5,1,0,-1,-2,
-2,-1],[-1,-3,-2,0,-3,-2,0,-3,2,-2,-1,0,-2,1,5,-1,-1,-3,-3,-2],[1,-1,0,0,-2,0,-1,-2,0,-2,-1,1,-1,0,-1,4,1,-2,-3,-2],[0,-1,-1,-1,-2,-2,-2,-1,-1,-1,-1,0,-1,-1,-1,1,5,0,-2,-2],[0,-1,-3,-2,-1,-3,-3,3,-2,1,1,-3,-2,-2,-3,-2,0,4,-3,-1],[-3,-2,-4,-3,1,-2,-2,-3,-3,-2,-1,-4,-4,-2,-3,-3,-2,-3,11,2],[-2,-2,-3,-2,3,-3,2,-1,-2,-1,-1,-2,-3,-1,-2,-2,-2,-1,2,7]])}}();
NGL.Alignment=function(a,b,c,d,e){this.seq1=a;this.seq2=b;this.gapPenalty=c||-10;this.gapExtensionPenalty=d||-1;this.substMatrix=e||"blosum62",this.substMatrix=NGL.SubstitutionMatrices[this.substMatrix]};
NGL.Alignment.prototype={constructor:NGL.Alignment,initMatrices:function(){this.n=this.seq1.length;this.m=this.seq2.length;this.score=void 0;this.ali="";this.S=[];this.V=[];this.H=[];for(var a=0;a<=this.n;++a){this.S[a]=[];this.V[a]=[];this.H[a]=[];for(var b=0;b<=this.m;++b)this.S[a][b]=0,this.V[a][b]=0,this.H[a][b]=0}for(a=0;a<=this.n;++a)this.S[a][0]=this.gap(0),this.H[a][0]=-Infinity;for(b=0;b<=this.m;++b)this.S[0][b]=this.gap(0),this.V[0][b]=-Infinity;this.S[0][0]=0},gap:function(a){return this.gapPenalty+
a*this.gapExtensionPenalty},makeScoreFn:function(){var a=this.seq1,b=this.seq2,c=this.substMatrix,d,e;if(c)return function(f,g){d=a[f];e=b[g];try{return c[d][e]}catch(h){return-4}};NGL.warn("NGL.Alignment: no subst matrix");return function(c,g){d=a[c];e=b[g];return d===e?5:-3}},calc:function(){NGL.time("NGL.Alignment.calc");this.initMatrices();var a=this.gap(0),b=this.makeScoreFn(),c=this.gapExtensionPenalty,d=this.V,e=this.H,f=this.S,g=this.n,h=this.m,k,l,m,n,p,q,r;for(q=1;q<=g;++q)for(l=f[q-1],
k=d[q-1],m=d[q],n=e[q],p=f[q],r=1;r<=h;++r)m[r]=Math.max(l[r]+a,k[r]+c),n[r]=Math.max(p[r-1]+a,n[r-1]+c),p[r]=Math.max(l[r-1]+b(q-1,r-1),m[r],n[r]);NGL.timeEnd("NGL.Alignment.calc")},trace:function(){this.ali2=this.ali1="";var a=this.makeScoreFn(),b=this.n,c=this.m,d="S";this.S[b][c]>=this.V[b][c]&&this.S[b][c]>=this.V[b][c]?(d="S",this.score=this.S[b][c]):this.V[b][c]>=this.H[b][c]?(d="V",this.score=this.V[b][c]):(d="H",this.score=this.H[b][c]);for(;0<b&&0<c;)"S"==d?this.S[b][c]==this.S[b-1][c-1]+
a(b-1,c-1)?(this.ali1=this.seq1[b-1]+this.ali1,this.ali2=this.seq2[c-1]+this.ali2,--b,--c,d="S"):this.S[b][c]==this.V[b][c]?d="V":this.S[b][c]==this.H[b][c]?d="H":(NGL.error("NGL.Alignment: S"),--b,--c):"V"==d?this.V[b][c]==this.V[b-1][c]+this.gapExtensionPenalty?(this.ali1=this.seq1[b-1]+this.ali1,this.ali2="-"+this.ali2,--b,d="V"):this.V[b][c]==this.S[b-1][c]+this.gap(0)?(this.ali1=this.seq1[b-1]+this.ali1,this.ali2="-"+this.ali2,--b,d="S"):(NGL.error("NGL.Alignment: V"),--b):"H"==d?this.H[b][c]==
this.H[b][c-1]+this.gapExtensionPenalty?(this.ali1="-"+this.ali1,this.ali2=this.seq2[c-1]+this.ali2,--c,d="H"):this.H[b][c]==this.S[b][c-1]+this.gap(0)?(this.ali1="-"+this.ali1,this.ali2=this.seq2[c-1]+this.ali2,--c,d="S"):(NGL.error("NGL.Alignment: H"),--c):NGL.error("NGL.Alignment: no matrix");for(;0<b;)this.ali1=this.seq1[b-1]+this.ali1,this.ali2="-"+this.ali2,--b;for(;0<c;)this.ali1="-"+this.ali1,this.ali2=this.seq2[c-1]+this.ali2,--c}};
NGL.Interpolator=function(a,b){function c(a,c,d,e,f){a=(d-a)*b;e=(e-c)*b;var g=f*f;return(2*c-2*d+a+e)*f*g+(-3*c+3*d-2*a-e)*g+a*f+c}function d(a,b,d,e,f,g){g.x=c(a.x,b.x,d.x,e.x,f);g.y=c(a.y,b.y,d.y,e.y,f);g.z=c(a.z,b.z,d.z,e.z,f)}function e(b,d,e,f,g,h){for(var k=0;k<a;++k){var l=b,m=d,q=e,p=f,r=n*k,t=g,v=h+3*k;t[v+0]=c(l.x,m.x,q.x,p.x,r);t[v+1]=c(l.y,m.y,q.y,p.y,r);t[v+2]=c(l.z,m.z,q.z,p.z,r)}}function f(b,c,e,f,g,h){for(var k=0;k<a;++k){var l=n*k,m=l-1E-4,l=l+1E-4,r=h+3*k;0>m&&(m=0);1<l&&(l=1);
d(b,c,e,f,m,p);d(b,c,e,f,l,q);q.sub(p).normalize();q.toArray(g,r)}}function g(b,c,d,e,f){for(var g=c.next(),h=c.next(),k=c.next(),l=c.size,m=l-1,n=e||0,q=0;q<m;++q)e=g,g=h,h=k,k=c.next(),b(e,g,h,k,d,n),n+=3*a;f&&(e=c.get(l-2),g=c.get(l-1),h=c.get(0),k=c.get(1),b(e,g,h,k,d,n))}function h(b,c,e,f,g,h,k,l,m,O,W,J,Z){for(var K=0;K<a;++K){var U=J+3*K;Z&&(U+=3*u);var D=n*K;d(b,c,e,f,D,p);d(g,h,k,l,D,q);r.subVectors(q,p).normalize();t.fromArray(m,U);w.crossVectors(r,t).normalize();w.toArray(W,U);v.crossVectors(t,
w).normalize();v.toArray(O,U)}}function k(b,c,d,e,f){for(var g=0;g<a;++g){var h=f+3*g;b.copy(v);t.fromArray(c,h);w.crossVectors(b,t).normalize();w.toArray(e,h);v.crossVectors(t,w).normalize();v.toArray(d,h)}}function l(b,c,d,e,f,g,h){for(var k=0;k<u;++k){var l=h+3*k;d(b,f,l);e(b,g,l)}for(k=u;k<a;++k)l=h+3*k,d(c,f,l),e(c,g,l)}function m(b,c,d,e,f){b=d(b);c=d(c);for(d=0;d<a;++d){var g=d/a;e[f+d]=(1-g)*b+g*c}}var n=1/a,p=new THREE.Vector3,q=new THREE.Vector3;this.getPosition=function(b,c,d,f){b.reset();
g(e,b,c,d,f);var h=b.size-1;d=h*a*3;f&&(d+=3*a);b=b.get(f?0:h);c[d]=b.x;c[d+1]=b.y;c[d+2]=b.z};this.getTangent=function(b,c,d,e){b.reset();g(f,b,c,d,e);b=(b.size-1)*a*3;e&&(b+=3*a);NGL.Utils.copyArray(c,c,b-3,b,3)};var r=new THREE.Vector3,t=new THREE.Vector3,v=new THREE.Vector3,w=new THREE.Vector3,u=Math.ceil(a/2);this.getNormal=function(b,c,d,e,f,g,h){v.set(0,0,1);--b;f=f||0;for(h=0;h<b;++h)k(r,c,d,e,f),f+=3*a;g&&(k(r,c,d,e,f),f+=3*a);w.toArray(e,f);v.toArray(d,f)};this.getNormalDir=function(b,c,
d,e,f,g,k,l){b.reset();c.reset();var m=new THREE.Vector3,n=new THREE.Vector3,q=new THREE.Vector3,p=new THREE.Vector3,r=new THREE.Vector3,t=(new THREE.Vector3).copy(b.next()),U=(new THREE.Vector3).copy(b.next()),D=(new THREE.Vector3).copy(b.next()),G=new THREE.Vector3,S=(new THREE.Vector3).copy(c.next()),T=(new THREE.Vector3).copy(c.next()),$=(new THREE.Vector3).copy(c.next());v.set(0,0,1);var Y=b.size,L=Y-1;g=g||0;for(var P=0;P<L;++P)r.copy(t),t.copy(U),U.copy(D),D.copy(b.next()),G.copy(S),S.copy(T),
T.copy($),$.copy(c.next()),0===P?(m.subVectors(G,r),n.subVectors(S,t),0>m.dot(n)&&(n.multiplyScalar(-1),S.addVectors(t,n)),q.subVectors(T,U),0>n.dot(q)&&(q.multiplyScalar(-1),T.addVectors(U,q))):q.copy(p),p.subVectors($,D),0>q.dot(p)&&(p.multiplyScalar(-1),$.addVectors(D,p)),h(r,t,U,D,G,S,T,$,d,e,f,g,l),g+=3*a;k&&(r.copy(b.get(Y-2)),t.copy(b.get(Y-1)),U.copy(b.get(0)),D.copy(b.get(1)),G.copy(c.get(Y-2)),S.copy(c.get(Y-1)),T.copy(c.get(0)),$.copy(c.get(1)),q.copy(p),p.subVectors($,D),0>q.dot(p)&&(p.multiplyScalar(-1),
$.addVectors(D,p)),h(r,t,U,D,G,S,T,$,d,e,f,g,l),g+=3*a);if(l)for(w.fromArray(f,3*u),v.fromArray(e,3*u),b=0;b<u;++b)w.toArray(f,3*b),v.toArray(e,3*b);else w.toArray(f,g),v.toArray(e,g)};this.getColor=function(b,c,d,e,f,g,h){b.reset();var k=b.next(),m=b.next(),n=b.size,q=n-1;g=g||0;for(var p=0;p<q;++p)k=m,m=b.next(),l(k,m,c,d,e,f,g),g+=3*a;h&&(k=b.get(n-1),m=b.get(0),l(k,m,c,d,e,f,g),g+=3*a);e[g]=e[g-3];e[g+1]=e[g-2];e[g+2]=e[g-1];f[g]=f[g-3];f[g+1]=f[g-2];f[g+2]=f[g-1]};this.getSize=function(b,c,d,
e,f){b.reset();var g=b.next(),h=b.next(),k=b.size,l=k-1;e=e||0;for(var n=0;n<l;++n)g=h,h=b.next(),m(g,h,c,d,e),e+=a;f&&(g=b.get(k-1),h=b.get(0),m(g,h,c,d,e),e+=a);d[e]=d[e-1]}};
NGL.Spline=function(a,b){this.polymer=a;this.size=a.residueCount;var c=b||{};this.directional=c.directional||!1;this.positionIterator=c.positionIterator||!1;this.subdiv=c.subdiv||1;this.smoothSheet=c.smoothSheet||!1;isNaN(c.tension)?this.tension=this.polymer.isNucleic()?.5:.9:this.tension=c.tension||.5;this.interpolator=new NGL.Interpolator(this.subdiv,this.tension)};
NGL.Spline.prototype={constructor:NGL.Spline,getAtomIterator:function(a,b){var c=this.polymer,d=c.structure,e=c.residueCount,f=0,g=-1,h=[d.getAtomProxy(),d.getAtomProxy(),d.getAtomProxy(),d.getAtomProxy()],k=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3],l=d.getAtomProxy(),m=d.getAtomProxy();return{size:e,next:function(){var a=this.get(g);g+=1;return a},get:function(d){var g=h[f%4];g.index=c.getAtomIndexByType(d,a);if(b&&0<d&&d<e&&"e"===g.sstruc){var q=k[f%4];l.index=c.getAtomIndexByType(d+
1,a);m.index=c.getAtomIndexByType(d-1,a);q.addVectors(l,m).add(g).add(g).multiplyScalar(.25);f+=1;return q}f+=1;return g},reset:function(){f=0;g=-1}}},getSubdividedColor:function(a){var b=this.subdiv,c=this.polymer,d=(c.residueCount-1)*b*3+3;c.isCyclic&&(d+=3*b);var b=new Float32Array(d),d=new Float32Array(d),e=this.getAtomIterator("trace");a=a||{};a.structure=c.structure;var f=NGL.ColorMakerRegistry.getScheme(a),g=NGL.ColorMakerRegistry.getPickingScheme(a);this.interpolator.getColor(e,function(a,
b,c){f.atomColorToArray(a,b,c)},function(a,b,c){g.atomColorToArray(a,b,c)},b,d,0,c.isCyclic);return{color:b,pickingColor:d}},getSubdividedPosition:function(){return{position:this.getPosition()}},getSubdividedOrientation:function(){var a=this.getTangent(),b=this.getNormals(a);return{tangent:a,normal:b.normal,binormal:b.binormal}},getSubdividedSize:function(a,b){var c=this.subdiv,d=this.polymer,e=(d.residueCount-1)*c+1;d.isCyclic&&(e+=c);var c=new Float32Array(e),e=this.getAtomIterator("trace"),f=new NGL.RadiusFactory(a,
b);this.interpolator.getSize(e,function(a){return f.atomRadius(a)},c,0,d.isCyclic);return{size:c}},getPosition:function(){var a=this.subdiv,b=this.polymer,c=(b.residueCount-1)*a*3+3;b.isCyclic&&(c+=3*a);a=new Float32Array(c);c=this.positionIterator||this.getAtomIterator("trace",this.smoothSheet);this.interpolator.getPosition(c,a,0,b.isCyclic);return a},getTangent:function(){var a=this.subdiv,b=this.polymer,c=(this.size-1)*a*3+3;b.isCyclic&&(c+=3*a);a=new Float32Array(c);c=this.positionIterator||this.getAtomIterator("trace",
this.smoothSheet);this.interpolator.getTangent(c,a,0,b.isCyclic);return a},getNormals:function(a){var b=this.subdiv,c=this.polymer,d=c.isProtein(),e=this.size,f=(e-1)*b*3+3;c.isCyclic&&(f+=3*b);b=new Float32Array(f);f=new Float32Array(f);if(this.directional&&!this.polymer.isCg()){var e=this.getAtomIterator("direction1"),g=this.getAtomIterator("direction2");this.interpolator.getNormalDir(e,g,a,b,f,0,c.isCyclic,d)}else this.interpolator.getNormal(e,a,b,f,0,c.isCyclic,d);return{normal:b,binormal:f}}};
NGL.Helixorient=function(a){this.polymer=a;this.size=a.residueCount};
NGL.Helixorient.prototype={constructor:NGL.Helixorient,getCenterIterator:function(a){var b=this.getPosition().center,c=b.length/3,d=0,e=-1,f=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];return{size:c,next:function(){var a=this.get(e);e+=1;return a},get:function(e){e=Math.min(c-1,Math.max(0,e));var h=f[d%4],k=3*e;h.fromArray(b,k);if(a){var l,m,n=Math.min(a,e,c-e-1);for(l=1;l<=n;++l)e=3*l,m=(n+1-l)/(n+1),h.x+=m*b[k-e+0]+m*b[k+e+0],h.y+=m*b[k-e+1]+m*b[k+e+1],h.z+=m*b[k-e+
2]+m*b[k+e+2];h.x/=n+1;h.y/=n+1;h.z/=n+1}d+=1;return h},reset:function(){d=0;e=-1}}},getColor:function(a){var b=this.polymer,c=b.structure,d=b.residueCount,b=b.residueIndexStart,e=new Float32Array(3*d),f=new Float32Array(3*d),g=a||{};g.structure=c;a=NGL.ColorMakerRegistry.getScheme(g);for(var g=NGL.ColorMakerRegistry.getPickingScheme(g),h=c.getResidueProxy(),c=c.getAtomProxy(),k=0;k<d;++k){h.index=b+k;c.index=h.traceAtomIndex;var l=3*k;a.atomColorToArray(c,e,l);g.atomColorToArray(c,f,l)}return{color:e,
pickingColor:f}},getSize:function(a,b){for(var c=this.polymer,d=c.structure,e=c.residueCount,c=c.residueIndexStart,f=new Float32Array(e),g=new NGL.RadiusFactory(a,b),h=d.getResidueProxy(),d=d.getAtomProxy(),k=0;k<e;++k)h.index=c+k,d.index=h.traceAtomIndex,f[k]=g.atomRadius(d);return{size:f}},getPosition:function(){var a=this.polymer,b=a.structure,c=a.residueCount,d=c-3,e=new Float32Array(3*c),f=new Float32Array(3*c),g=new Float32Array(c),h=new Float32Array(c),k=new Float32Array(c),l=new Float32Array(c),
m=new Float32Array(3*c),n,p,q,r,t=new THREE.Vector3,v=new THREE.Vector3,w=new THREE.Vector3,u=new THREE.Vector3,B=new THREE.Vector3,s=new THREE.Vector3,z=new THREE.Vector3,x=new THREE.Vector3,y=new THREE.Vector3,A=new THREE.Vector3;new THREE.Vector3;for(var M=new THREE.Vector3(0,0,0),H=b.getAtomProxy(),R=b.getAtomProxy(a.getAtomIndexByType(0,"trace")),O=b.getAtomProxy(a.getAtomIndexByType(1,"trace")),W=b.getAtomProxy(a.getAtomIndexByType(2,"trace")),b=0;b<d;++b)H.index=R.index,R.index=O.index,O.index=
W.index,W.index=a.getAtomIndexByType(b+3,"trace"),p=3*b,t.subVectors(R,H),v.subVectors(O,R),w.subVectors(W,O),u.subVectors(t,v),B.subVectors(v,w),x.crossVectors(u,B).normalize(),x.toArray(f,p),0<b&&(g[b]=x.angleTo(y)),n=Math.cos(u.angleTo(B)),l[b]=180/Math.PI*Math.acos(n),q=u.length(),r=B.length(),h[b]=Math.sqrt(r*q)/Math.max(2,2*(1-n)),k[b]=Math.abs(v.dot(x)),s.copy(u).multiplyScalar(h[b]/q),z.copy(B).multiplyScalar(h[b]/r),s.subVectors(R,s),z.subVectors(O,z),s.toArray(e,p+3),z.toArray(e,p+6),A.subVectors(H,
M),A.toArray(m,p),y.copy(x),M.copy(s);s.fromArray(e,3);z.fromArray(e,6);x.subVectors(s,z).normalize();H.index=a.getAtomIndexByType(0,"trace");M.copy(H);s=NGL.Utils.pointVectorIntersection(M,s,x);s.toArray(e,0);A.subVectors(M,s);A.toArray(m,0);s.fromArray(e,3*c-6);z.fromArray(e,3*c-9);x.subVectors(s,z).normalize();H.index=a.getAtomIndexByType(c-1,"trace");M.copy(H);s=NGL.Utils.pointVectorIntersection(M,s,x);s.toArray(e,3*c-3);for(b=c-3;b<c;++b)s.fromArray(e,3*b),H.index=a.getAtomIndexByType(b,"trace"),
M.copy(H),A.subVectors(M,s),A.toArray(m,3*b);a=new Float32Array(c);d=new Float32Array(c);g=new Float32Array(c);t=new Float32Array(c);a[1]=h[0];d[1]=l[0];g[1]=h[0];for(b=2;b<c-2;++b)a[b]=.5*(h[b-2]+h[b-1]),d[b]=.5*(l[b-2]+l[b-1]),g[b]=.5*(k[b-2]+k[b-1]),s.fromArray(f,3*(b-2)),z.fromArray(f,3*(b-1)),t[b]=180/Math.PI*Math.acos(Math.cos(s.angleTo(z)));a[c-2]=h[c-4];d[c-2]=l[c-4];g[c-2]=k[c-4];h=new Float32Array(3*c);NGL.Utils.copyArray(f,h,0,0,3);NGL.Utils.copyArray(f,h,0,3,3);for(b=2;b<c-2;++b)s.fromArray(f,
3*(b-2)),z.fromArray(f,3*(b-1)),x.addVectors(z,s).multiplyScalar(.5).normalize(),x.toArray(h,3*b);NGL.Utils.copyArray(f,h,3*c-12,3*c-6,3);NGL.Utils.copyArray(f,h,3*c-12,3*c-3,3);return{center:e,axis:h,bending:t,radius:a,rise:g,twist:d,resdir:m}}};NGL.Helixbundle=function(a){this.polymer=a;this.helixorient=new NGL.Helixorient(a);this.position=this.helixorient.getPosition()};
NGL.Helixbundle.prototype={constructor:NGL.Helixbundle,getAxis:function(a,b,c,d,e,f){a=a||30;b=b||2.5;c=void 0===c?!1:c;var g=this.polymer,h=g.structure,k=g.residueCount,g=g.residueIndexStart,l=this.position,m=d||{};m.structure=h;d=NGL.ColorMakerRegistry.getScheme(m);m=NGL.ColorMakerRegistry.getPickingScheme(m);e=new NGL.RadiusFactory(e,f);for(var n=f=0,p=[],q=[],r=[],t=[],v=[],w=[],u=[],B=[],s=[],z=[],x=[],y,A=new THREE.Vector3,M=new THREE.Vector3,H=h.getResidueProxy(),R=h.getResidueProxy(),h=h.getAtomProxy(),
O=new THREE.Vector3,W=new THREE.Vector3,x=!1,J=0;J<k;++J)H.index=g+J,O.fromArray(l.center,3*J),J===k-1?x=!0:(R.index=g+J+1,W.fromArray(l.center,3*J+3),c&&H.sstruc!==R.sstruc?x=!0:O.distanceTo(W)>b?x=!0:l.bending[J]>a&&(x=!0)),x&&(4>J-f||(h.index=H.traceAtomIndex,z=l.axis.subarray(3*f+3,3*J),x=l.center.subarray(3*f,3*J+3),z=NGL.Utils.calculateMeanVector3(z).normalize(),y=NGL.Utils.calculateMeanVector3(x),A.fromArray(x),A=NGL.Utils.pointVectorIntersection(A,y,z),M.fromArray(x,x.length-3),M=NGL.Utils.pointVectorIntersection(M,
y,z),z.subVectors(M,A),z.toArray(p,n),y.toArray(q,n),A.toArray(r,n),M.toArray(t,n),d.atomColorToArray(h,v,n),m.atomColorToArray(h,w,n),u.push(e.atomRadius(h)),B.push(g+f),s.push(g+J+1-f),n+=3),f=J,x=!1);return{axis:new Float32Array(p),center:new Float32Array(q),begin:new Float32Array(r),end:new Float32Array(t),color:new Float32Array(v),pickingColor:new Float32Array(w),size:new Float32Array(u),residueOffset:B,residueCount:s}}};
NGL.Kdtree=function(a,b){NGL.debug&&NGL.time("NGL.Kdtree build");var c=b?function(a,b){var c=a[0]-b[0],d=a[1]-b[1],e=a[2]-b[2];return c*c+d*d+e*e}:function(a,b){var c=a[0]-b[0],d=a[1]-b[1],e=a[2]-b[2];return Math.sqrt(c*c+d*d+e*e)},d=new Float32Array(4*a.atomCount),e=0;a[a.eachSelectedAtom?"eachSelectedAtom":"eachAtom"](function(a){d[e+0]=a.x;d[e+1]=a.y;d[e+2]=a.z;d[e+3]=a.index;e+=4});this.points=d;this.kdtree=new THREE.TypedArrayUtils.Kdtree(d,c,4,3);NGL.debug&&NGL.timeEnd("NGL.Kdtree build")};
NGL.Kdtree.prototype={nearest:function(){var a=new Float32Array(3);return function(b,c,d){b instanceof THREE.Vector3?b.toArray(a):b instanceof NGL.AtomProxy&&b.positionToArray(a);b=this.kdtree.nearest(a,c,d);c=this.points;d=[];for(var e=0,f=b.length;e<f;++e){var g=b[e];d.push({index:c[g[0].pos+3],distance:g[1]})}return d}}()};NGL.Contact=function(a,b){this.sview1=a;this.sview2=b;this.kdtree2=new NGL.Kdtree(b)};
NGL.Contact.prototype={within:function(a,b){NGL.time("NGL.Contact within");var c=this.kdtree2,d=this.sview1.getAtomProxy(),e=this.sview1.getAtomSet(!1),f=new NGL.BondStore;this.sview1.eachSelectedAtom(function(g){for(var k=!1,l=c.nearest(g,Infinity,a),m=0,n=l.length;m<n;++m){var p=l[m];d.index=p.index;g.residueIndex!==d.residueIndex&&(!b||p.distance>b)&&(k=!0,e.add_unsafe(d.index),f.addBond(g,d,1))}k&&e.add_unsafe(g.index)});var g=new TypedFastBitSet(f.count);g.set_all(!0);NGL.timeEnd("NGL.Contact within");
return{atomSet:e,bondSet:g,bondStore:f}}};
NGL.polarContacts=function(a,b,c){b=b||3.5;c=c||40;var d=new NGL.Selection("( ARG and ( .NE or .NH1 or .NH2 ) ) or ( ASP and .ND2 ) or ( GLN and .NE2 ) or ( HIS and ( .ND1 or .NE2 ) ) or ( LYS and .NZ ) or ( SER and .OG ) or ( THR and .OG1 ) or ( TRP and .NE1 ) or ( TYR and .OH ) or ( PROTEIN and .N )"),e=new NGL.Selection("( ASN and .OD1 ) or ( ASP and ( OD1 or .OD2 ) ) or ( GLN and .OE1 ) or ( GLU and ( .OE1 or .OE2 ) ) or ( HIS and ( .ND1 or .NE2 ) ) or ( SER and .OG ) or ( THR and .OG1 ) or ( TYR and .OH ) or ( PROTEIN and .O )"),d=
a.getView(d),e=a.getView(e);b=(new NGL.Contact(d,e)).within(b);var e=b.bondStore,d=a.getAtomProxy(),f=a.getAtomProxy(),g=a.getAtomProxy(),h=a.getAtomProxy(),k=a.getResidueProxy();a=a.getResidueProxy();for(var l=new THREE.Vector3,m=new THREE.Vector3,n=0,p=e.count;n<p;++n)if(d.index=e.atomIndex1[n],f.index=e.atomIndex2[n],"O"===d.atomname&&"N"===f.atomname||"N"===d.atomname&&"O"===f.atomname)b.bondSet.flip_unsafe(n);else if("N"===d.atomname||"N"===f.atomname){var q,r;"N"===d.atomname?(q=d,r=f):(q=f,
r=d);k.index=q.residueIndex;g.index=k.getAtomIndexByName("CA")+k.atomOffset;if(void 0!==g.index){var t=k.getPreviousConnectedResidue(a);void 0!==t&&(h.index=t.getAtomIndexByName("C")+t.atomOffset,void 0!==h.index&&(l.subVectors(q,h),m.subVectors(q,g),l.add(m).multiplyScalar(.5),m.subVectors(r,q),THREE.Math.radToDeg(l.angleTo(m))>c&&b.bondSet.flip_unsafe(n)))}}else if("OH"===d.atomname&&"TYR"===d.resname||"OH"===f.atomname&&"TYR"===f.resname)r=q=void 0,"OH"===d.atomname?(q=d,r=f):(q=f,r=d),k.index=
q.residueIndex,t=k.getAtomIndexByName("CZ")+k.atomOffset,l.subVectors(t,q),m.subVectors(t,r),THREE.Math.radToDeg(l.angleTo(m))<c||b.bondSet.flip_unsafe(n);return{atomSet:b.atomSet,bondSet:b.bondSet,bondStore:b.bondStore}};
NGL.polarBackboneContacts=function(a,b,c){b=b||3.5;c=c||40;var d=new NGL.Selection("( PROTEIN and .N )"),e=new NGL.Selection("( PROTEIN and .O )"),d=a.getView(d),e=a.getView(e);b=(new NGL.Contact(d,e)).within(b);var e=b.bondStore,d=a.getAtomProxy(),f=a.getAtomProxy(),g=a.getAtomProxy(),h=a.getAtomProxy(),k=a.getResidueProxy();a=a.getResidueProxy();for(var l=new THREE.Vector3,m=new THREE.Vector3,n=0,p=e.count;n<p;++n){d.index=e.atomIndex1[n];f.index=e.atomIndex2[n];var q,r;"N"===d.atomname?(q=d,r=
f):(q=f,r=d);k.index=q.residueIndex;g.index=k.getAtomIndexByName("CA")+k.atomOffset;if(void 0!==g.index){var t=k.getPreviousConnectedResidue(a);void 0!==t&&(h.index=t.getAtomIndexByName("C")+t.atomOffset,void 0!==h.index&&(l.subVectors(q,h),m.subVectors(q,g),l.add(m).multiplyScalar(.5),m.subVectors(r,q),THREE.Math.radToDeg(l.angleTo(m))>c&&b.bondSet.flip_unsafe(n)))}}return{atomSet:b.atomSet,bondSet:b.bondSet,bondStore:b.bondStore}};
NGL.Selection=function(a){this.signals={stringChanged:new signals.Signal};this.setString(a)};NGL.Selection.Keywords={PROTEIN:1,NUCLEIC:2,RNA:3,DNA:4,POLYMER:5,WATER:6,HELIX:7,SHEET:8,BACKBONE:9,SIDECHAIN:10,ALL:11,HETERO:12,ION:13};
NGL.Selection.prototype={constructor:NGL.Selection,setString:function(a,b){void 0===a&&(a=this.string||"");if(a!==this.string){try{this.parse(a)}catch(c){this.selection={error:c.message}}this.string=a;this.test=this.makeAtomTest();this.residueTest=this.makeResidueTest();this.chainTest=this.makeChainTest();this.modelTest=this.makeModelTest();this.atomOnlyTest=this.makeAtomTest(!0);this.residueOnlyTest=this.makeResidueTest(!0);this.chainOnlyTest=this.makeChainTest(!0);this.modelOnlyTest=this.makeModelTest(!0);
b||this.signals.stringChanged.dispatch(this.string)}},parse:function(a){this.selection={operator:void 0,rules:[]};if(a){var b=this,c=NGL.Selection.Keywords,d=this.selection,e=[],f,g;a=a.replace(/\(/g," ( ").replace(/\)/g," ) ").trim();"("===a.charAt(0)&&")"===a.substr(-1)&&(a=a.slice(1,-1).trim());a=a.split(/\s+/);var h=["*","","ALL"],k,l,m,n,p=function(a){f={operator:a,rules:[]};void 0===d?(d=f,b.selection=f):(d.rules.push(f),e.push(d),d=f)},q=function(a){g=d;d=e.pop();void 0===d&&(p(a),r(g))},r=
function(a){d.rules.push(a)};for(m=0;m<a.length;++m)if(k=a[m],"("===k)n=!1,p();else if(")"===k)q(),d.negate&&q();else{if(0<n)if("NOT"===k.toUpperCase())n=1;else if(1===n)n=2;else if(2===n)n=!1,q();else throw Error("something went wrong with 'not'");if("AND"===k.toUpperCase())"OR"===d.operator?(l=d.rules.pop(),p("AND"),r(l)):d.operator="AND";else if("OR"===k.toUpperCase())"AND"===d.operator?q("OR"):d.operator="OR";else if("NOT"===k.toUpperCase())n=1,p(),d.negate=!0;else if(l={},"HETERO"===k.toUpperCase())l.keyword=
c.HETERO,r(l);else if("WATER"===k.toUpperCase())l.keyword=c.WATER,r(l);else if("PROTEIN"===k.toUpperCase())l.keyword=c.PROTEIN,r(l);else if("NUCLEIC"===k.toUpperCase())l.keyword=c.NUCLEIC,r(l);else if("RNA"===k.toUpperCase())l.keyword=c.RNA,r(l);else if("DNA"===k.toUpperCase())l.keyword=c.DNA,r(l);else if("POLYMER"===k.toUpperCase())l.keyword=c.POLYMER,r(l);else if("ION"===k.toUpperCase())l.keyword=c.ION,r(l);else if("HYDROGEN"===k.toUpperCase())l.element="H",r(l);else if("SMALL"===k.toUpperCase())l=
{operator:"OR",rules:[{resname:"GLY"},{resname:"ALA"}]},r(l);else if("NUCLEOPHILIC"===k.toUpperCase())l={operator:"OR",rules:[{resname:"SER"},{resname:"THR"},{resname:"CYS"}]},r(l);else if("HYDROPHOBIC"===k.toUpperCase())l={operator:"OR",rules:[{resname:"VAL"},{resname:"LEU"},{resname:"ILE"},{resname:"MET"},{resname:"PRO"}]},r(l);else if("AROMATIC"===k.toUpperCase())l={operator:"OR",rules:[{resname:"PHE"},{resname:"TYR"},{resname:"TRP"}]},r(l);else if("AMIDE"===k.toUpperCase())l={operator:"OR",rules:[{resname:"ASN"},
{resname:"GLN"}]},r(l);else if("ACIDIC"===k.toUpperCase())l={operator:"OR",rules:[{resname:"ASP"},{resname:"GLU"}]},r(l);else if("BASIC"===k.toUpperCase())l={operator:"OR",rules:[{resname:"HIS"},{resname:"LYS"},{resname:"ARG"}]},r(l);else if("CHARGED"===k.toUpperCase())l={operator:"OR",rules:[{resname:"ASP"},{resname:"GLU"},{resname:"HIS"},{resname:"LYS"},{resname:"ARG"}]},r(l);else if("POLAR"===k.toUpperCase())l={operator:"OR",rules:[{resname:"ASP"},{resname:"GLU"},{resname:"HIS"},{resname:"LYS"},
{resname:"ARG"},{resname:"ASN"},{resname:"GLN"},{resname:"SER"},{resname:"THR"},{resname:"TYR"}]},r(l);else if("NONPOLAR"===k.toUpperCase())l={operator:"OR",rules:[{resname:"ALA"},{resname:"CYS"},{resname:"GLY"},{resname:"ILE"},{resname:"LEU"},{resname:"MET"},{resname:"PHE"},{resname:"PRO"},{resname:"VAL"},{resname:"TRP"}]},r(l);else if("HELIX"===k.toUpperCase())l.keyword=c.HELIX,r(l);else if("SHEET"===k.toUpperCase())l.keyword=c.SHEET,r(l);else if("TURN"===k.toUpperCase())l={operator:"AND",rules:[{operator:"OR",
negate:!0,rules:[{keyword:c.HELIX},{keyword:c.SHEET}]},{operator:"OR",rules:[{keyword:c.PROTEIN},{sstruc:"s"},{sstruc:"t"},{sstruc:"l"}]}]},r(l);else if("BACKBONE"===k.toUpperCase())l.keyword=c.BACKBONE,r(l);else if("SIDECHAIN"===k.toUpperCase())l.keyword=c.SIDECHAIN,r(l);else if("SIDECHAINATTACHED"===k.toUpperCase())l={operator:"OR",rules:[{keyword:c.SIDECHAIN},{operator:"AND",negate:!1,rules:[{keyword:c.PROTEIN},{operator:"OR",negate:!1,rules:[{atomname:"CA"},{atomname:"BB"}]}]},{operator:"AND",
negate:!1,rules:[{resname:"PRO"},{atomname:"N"}]},{operator:"AND",negate:!1,rules:[{keyword:c.NUCLEIC},{operator:"OR",negate:!0,rules:[{atomname:"P"},{atomname:"OP1"},{atomname:"OP2"},{atomname:"O3'"},{atomname:"O3*"},{atomname:"O5'"},{atomname:"O5*"},{atomname:"C5'"},{atomname:"C5*"}]}]}]},r(l);else if(-1!==h.indexOf(k.toUpperCase()))l.keyword=c.ALL,r(l);else if("@"===k.charAt(0)){k=k.substr(1).split(",");for(var t=0,v=k.length;t<v;++t)k[t]=parseInt(k[t]);k.sort(function(a,b){return a-b});l.atomindex=
k;r(l)}else if("#"===k.charAt(0))l.element=k.substr(1).toUpperCase(),r(l);else if("["===k[0]&&"]"===k[k.length-1])l.resname=k.substr(1,k.length-2).toUpperCase(),r(l);else if(1<=k.length&&4>=k.length&&"^"!==k[0]&&":"!==k[0]&&"."!==k[0]&&"%"!==k[0]&&"/"!==k[0]&&isNaN(parseInt(k)))l.resname=k.toUpperCase(),r(l);else{l={operator:"AND",rules:[]};k=k.split("/");if(1<k.length&&k[1]){if(isNaN(parseInt(k[1])))throw Error("model must be an integer");l.rules.push({model:parseInt(k[1])})}k=k[0].split("%");1<
k.length&&l.rules.push({altloc:k[1]});k=k[0].split(".");if(1<k.length&&k[1]){if(4<k[1].length)throw Error("atomname must be one to four characters");l.rules.push({atomname:k[1].substring(0,4).toUpperCase()})}k=k[0].split(":");1<k.length&&k[1]&&l.rules.push({chainname:k[1]});k=k[0].split("^");1<k.length&&l.rules.push({inscode:k[1]});if(k[0])if(k=k[0].split("-"),1===k.length){k=parseInt(k[0]);if(isNaN(k))throw Error("resi must be an integer");l.rules.push({resno:k})}else if(2===k.length)l.rules.push({resno:[parseInt(k[0]),
parseInt(k[1])]});else throw Error("resi range must contain one '-'");if(1===l.rules.length)r(l.rules[0]);else if(1<l.rules.length)r(l);else throw Error("empty selection chunk");}}void 0===this.selection.operator&&1===this.selection.rules.length&&this.selection.rules[0].hasOwnProperty("operator")&&(this.selection=this.selection.rules[0])}},_makeTest:function(a,b){void 0===b&&(b=this.selection);if(null===b||b.error)return!1;var c=b.rules.length;if(0===c)return!1;for(var d=b.negate?!1:!0,e=b.negate?
!0:!1,f=NGL.Selection.Keywords,g,h,k,l,m=[],n=0;n<c;++n)g=b.rules[n],g.hasOwnProperty("operator")&&(m[n]=this._makeTest(a,g));return function(n){h="AND"===b.operator;l=!1;for(var q=0;q<c;++q){g=b.rules[q];if(g.hasOwnProperty("operator"))k=m[q]?m[q](n):-1;else{if(g.keyword===f.ALL)if(h)continue;else return d;k=a(n,g)}if(-1===k)l=!0;else if(!0===k){if(!h)return d}else if(h)return e}return l?-1:h?d:e}},_filter:function(a,b){void 0===b&&(b=this.selection);if(b.error)return b;var c=b.rules.length;if(0===
c)return b;var d=[];b.hasOwnProperty("negate");for(var e=0;e<c;++e){var f=b.rules[e];f.hasOwnProperty("operator")?(f=this._filter(a,f),null!==f&&d.push(f)):a(f)||d.push(f)}return 0<d.length?b:null},makeAtomTest:function(a){var b=["h","g","i"],c=["e","b"],d=NGL.Selection.Keywords;a=a?this._filter(function(a){return void 0!==a.keyword&&a.keyword!==d.BACKBONE&&a.keyword!==d.SIDECHAIN||void 0!==a.model||void 0!==a.chainname||void 0!==a.resname||void 0!==a.resno||void 0!==a.sstruc?!0:!1}):this.selection;
return this._makeTest(function(a,f){if(void 0===f.atomname&&void 0===f.element&&void 0===f.altloc&&void 0===f.atomindex&&void 0===f.keyword&&void 0===f.inscode&&void 0===f.resname&&void 0===f.sstruc&&void 0===f.resno&&void 0===f.chainname&&void 0===f.model)return-1;if(void 0!==f.keyword&&(f.keyword===d.BACKBONE&&!a.isBackbone()||f.keyword===d.SIDECHAIN&&!a.isSidechain()||f.keyword===d.HETERO&&!a.isHetero()||f.keyword===d.PROTEIN&&!a.isProtein()||f.keyword===d.NUCLEIC&&!a.isNucleic()||f.keyword===
d.RNA&&!a.isRna()||f.keyword===d.DNA&&!a.isDna()||f.keyword===d.POLYMER&&!a.isPolymer()||f.keyword===d.WATER&&!a.isWater()||f.keyword===d.HELIX&&-1===b.indexOf(a.sstruc)||f.keyword===d.SHEET&&-1===c.indexOf(a.sstruc)||f.keyword===d.ION&&!a.isIon())||void 0!==f.atomname&&f.atomname!==a.atomname||void 0!==f.element&&f.element!==a.element||void 0!==f.altloc&&f.altloc!==a.altloc||void 0!==f.atomindex&&0>NGL.binarySearchIndexOf(f.atomindex,a.index)||void 0!==f.resname&&f.resname!==a.resname||void 0!==
f.sstruc&&f.sstruc!==a.sstruc)return!1;if(void 0!==f.resno)if(Array.isArray(f.resno)&&2===f.resno.length){if(f.resno[0]>a.resno||f.resno[1]<a.resno)return!1}else if(f.resno!==a.resno)return!1;return void 0!==f.inscode&&f.inscode!==a.inscode||void 0!==f.chainname&&f.chainname!==a.chainname||void 0!==f.model&&f.model!==a.modelIndex?!1:!0},a)},makeResidueTest:function(a){var b=["h","g","i"],c=["e","b"],d=NGL.Selection.Keywords;a=a?this._filter(function(a){return a.keyword===d.BACKBONE||a.keyword===d.SIDECHAIN||
void 0!==a.model||void 0!==a.chainname||void 0!==a.atomname||void 0!==a.element||void 0!==a.altloc||void 0!==a.atomindex?!0:!1}):this.selection;return this._makeTest(function(a,f){if(void 0===f.resname&&void 0===f.resno&&void 0===f.inscode&&void 0===f.sstruc&&void 0===f.model&&void 0===f.chainname&&(void 0===f.keyword||f.keyword===d.BACKBONE||f.keyword===d.SIDECHAIN))return-1;if(void 0!==f.keyword&&(f.keyword===d.HETERO&&!a.isHetero()||f.keyword===d.PROTEIN&&!a.isProtein()||f.keyword===d.NUCLEIC&&
!a.isNucleic()||f.keyword===d.RNA&&!a.isRna()||f.keyword===d.DNA&&!a.isDna()||f.keyword===d.POLYMER&&!a.isPolymer()||f.keyword===d.WATER&&!a.isWater()||f.keyword===d.HELIX&&-1===b.indexOf(a.sstruc)||f.keyword===d.SHEET&&-1===c.indexOf(a.sstruc)||f.keyword===d.ION&&!a.isIon())||void 0!==f.resname&&f.resname!==a.resname||void 0!==f.sstruc&&f.sstruc!==a.sstruc)return!1;if(void 0!==f.resno)if(Array.isArray(f.resno)&&2===f.resno.length){if(f.resno[0]>a.resno||f.resno[1]<a.resno)return!1}else if(f.resno!==
a.resno)return!1;return void 0!==f.inscode&&f.inscode!==a.inscode||void 0!==f.chainname&&f.chainname!==a.chainname||void 0!==f.model&&f.model!==a.modelIndex?!1:!0},a)},makeChainTest:function(a){a=a?this._filter(function(a){return void 0!==a.keyword||void 0!==a.resname||void 0!==a.resno||void 0!==a.atomname||void 0!==a.element||void 0!==a.altloc||void 0!==a.sstruc||void 0!==a.inscode||void 0!==a.atomindex?!0:!1}):this.selection;return this._makeTest(function(a,c){return void 0===c.chainname&&void 0===
c.model?-1:void 0!==c.chainname&&c.chainname!==a.chainname||void 0!==c.model&&c.model!==a.modelIndex?!1:!0},a)},makeModelTest:function(a){a=a?this._filter(function(a){return void 0!==a.keyword||void 0!==a.chainname||void 0!==a.resname||void 0!==a.resno||void 0!==a.atomname||void 0!==a.element||void 0!==a.altloc||void 0!==a.sstruc||void 0!==a.inscode||void 0!==a.atomindex?!0:!1}):this.selection;return this._makeTest(function(a,c){return void 0===c.model?-1:void 0!==c.model&&c.model!==a.index?!1:!0},
a)}};NGL.Matrix=function(a,b){return new jsfeat.matrix_t(a,b,jsfeat.F32_t|jsfeat.C1_t)};
NGL.Superposition=function(a,b){var c;"function"===typeof a.eachSelectedAtom?c=a.atomCount:a instanceof Float32Array&&(c=a.length/3);var d=new NGL.Matrix(3,c),e=new NGL.Matrix(3,c);this.coords1t=new NGL.Matrix(c,3);this.coords2t=new NGL.Matrix(c,3);this.A=new NGL.Matrix(3,3);this.W=new NGL.Matrix(1,3);this.U=new NGL.Matrix(3,3);this.V=new NGL.Matrix(3,3);this.VH=new NGL.Matrix(3,3);this.R=new NGL.Matrix(3,3);this.tmp=new NGL.Matrix(3,3);this.c=new NGL.Matrix(3,3);this.c.data.set([1,0,0,0,1,0,0,0,
-1]);this.prepCoords(a,d);this.prepCoords(b,e);this._superpose(d,e)};
NGL.Superposition.prototype={constructor:NGL.Superposition,_superpose:function(a,b){this.mean1=jsfeat.matmath.mean_rows(a);this.mean2=jsfeat.matmath.mean_rows(b);jsfeat.matmath.sub_rows(a,this.mean1);jsfeat.matmath.sub_rows(b,this.mean2);jsfeat.matmath.transpose(this.coords1t,a);jsfeat.matmath.transpose(this.coords2t,b);jsfeat.matmath.multiply_ABt(this.A,this.coords2t,this.coords1t);jsfeat.linalg.svd_decompose(this.A,this.W,this.U,this.V);jsfeat.matmath.invert_3x3(this.V,this.VH);jsfeat.matmath.multiply_3x3(this.R,
this.U,this.VH);0>jsfeat.matmath.mat3x3_determinant(this.R)&&(NGL.log("R not a right handed system"),jsfeat.matmath.multiply_3x3(this.tmp,this.c,this.VH),jsfeat.matmath.multiply_3x3(this.R,this.U,this.tmp))},prepCoords:function(a,b){var c=0,d=b.data;"function"===typeof a.eachSelectedAtom?a.eachSelectedAtom(function(a){d[c+0]=a.x;d[c+1]=a.y;d[c+2]=a.z;c+=3}):a instanceof Float32Array?d.set(a):NGL.warn("prepCoords: input type unknown")},transform:function(a){var b;"function"===typeof a.eachSelectedAtom?
b=a.atomCount:a instanceof Float32Array&&(b=a.length/3);var c=new NGL.Matrix(3,b),d=new NGL.Matrix(b,3);this.prepCoords(a,c);jsfeat.matmath.sub_rows(c,this.mean1);jsfeat.matmath.multiply_ABt(d,this.R,c);jsfeat.matmath.transpose(c,d);jsfeat.matmath.add_rows(c,this.mean2);var e=0,f=c.data;"function"===typeof a.eachSelectedAtom?a.eachSelectedAtom(function(a){a.x=f[e+0];a.y=f[e+1];a.z=f[e+2];e+=3}):a instanceof Float32Array?a.set(f.subarray(0,3*b)):NGL.warn("transform: input type unknown")}};
NGL.superpose=function(a,b,c,d,e,f,g){d=d||"";e=e||"";f=f||"";g=g||"";var h,k;if(c){c=a;var l=b;d&&e&&(c=new NGL.StructureSubset(a,new NGL.Selection(d)),l=new NGL.StructureSubset(b,new NGL.Selection(e)));b=c.getSequence();d=l.getSequence();d=new NGL.Alignment(b.join(""),d.join(""));d.calc();d.trace();var m,n,p,q,r=0,t=0;b=d.ali1.length;var v=[],w=[];for(e=0;e<b;++e)p=d.ali1[e],q=d.ali2[e],n=m=0,"-"===p?w[t]=!1:(w[t]=!0,m=1),"-"===q?v[r]=!1:(v[r]=!0,n=1),r+=m,t+=n;h=new NGL.AtomSet;k=new NGL.AtomSet;
r=0;c.eachResidue(function(a){a.getResname1()&&a.getAtomByName("CA")&&(v[r]&&h.addAtom(a.getAtomByName("CA")),r+=1)});r=0;l.eachResidue(function(a){a.getResname1()&&a.getAtomByName("CA")&&(w[r]&&k.addAtom(a.getAtomByName("CA")),r+=1)})}else h=new NGL.AtomSet(a,new NGL.Selection(d+" and .CA")),k=new NGL.AtomSet(b,new NGL.Selection(e+" and .CA"));if(f&&g){c=new NGL.AtomSet;l=new NGL.AtomSet;f=new NGL.Selection(f);b=new NGL.Selection(g);g=f.test;f=b.test;b=h.atomCount;for(r=0;r<b;++r)d=h.atoms[r],e=
k.atoms[r],g(d)&&f(e)&&(c.addAtom(d),l.addAtom(e));h=c;k=l}g=new NGL.Superposition(h,k);f=new NGL.AtomSet(a,new NGL.Selection("*"));g.transform(f);a.center=a.atomCenter()};
NGL.GidPool={nextGid:1,objectList:[],rangeList:[],getBaseObject:function(a){"StructureView"===a.type&&(a=a.getStructure());return a},addObject:function(a){a=this.getBaseObject(a);NGL.GidPool.objectList.push(a);NGL.GidPool.rangeList.push(NGL.GidPool.allocateGidRange(a));return NGL.GidPool},removeObject:function(a){a=this.getBaseObject(a);a=NGL.GidPool.objectList.indexOf(a);-1!==a&&(NGL.GidPool.objectList.splice(a,1),NGL.GidPool.rangeList.splice(a,1),0===NGL.GidPool.objectList.length&&(NGL.GidPool.nextGid=
1));return NGL.GidPool},updateObject:function(a,b){a=this.getBaseObject(a);var c=NGL.GidPool.objectList.indexOf(a);if(-1!==c){var d=NGL.GidPool.rangeList[c];d[1]===NGL.GidPool.nextGid?(c=NGL.GidPool.getGidCount(a),NGL.GidPool.nextGid+=c-(d[1]-d[0]),d[1]=NGL.GidPool.nextGid):NGL.GidPool.rangeList[c]=NGL.GidPool.allocateGidRange(a)}else b||NGL.warn("NGL.GidPool.updateObject: object not found.");return NGL.GidPool},getGidCount:function(a){a=this.getBaseObject(a);var b=0;"Structure"===a.type?b=a.atomStore.count+
a.bondStore.count+a.backboneBondStore.count+a.rungBondStore.count:"Volume"===a.type?b=a.__data.length:NGL.warn("NGL.GidPool.getGidCount: unknown object type");return b},allocateGidRange:function(a){a=this.getBaseObject(a);var b=NGL.GidPool.nextGid;NGL.GidPool.nextGid+=NGL.GidPool.getGidCount(a);NGL.GidPool.nextGid>Math.pow(2,24)&&NGL.error("NGL.GidPool.allocateGidRange: GidPool overflown");return[b,NGL.GidPool.nextGid]},freeGidRange:function(a){this.getBaseObject(a)},getNextGid:function(){return NGL.GidPool.nextGid++},
getGid:function(a,b){a=this.getBaseObject(a);b=b||0;var c=0,d=NGL.GidPool.objectList.indexOf(a);-1!==d?c=NGL.GidPool.rangeList[d][0]+b:NGL.warn("NGL.GidPool.getGid: object not found.");return c},getByGid:function(a){var b;NGL.GidPool.objectList.forEach(function(c,d){var e=NGL.GidPool.rangeList[d];a<e[0]||a>=e[1]||(e=a-e[0],"Structure"===c.type?e<=c.atomStore.count?b=c.getAtomProxy(e):e<=c.atomStore.count+c.bondStore.count?(e-=c.atomStore.count,b=c.getBondProxy(e)):e<=c.atomStore.count+c.bondStore.count+
c.backboneBondStore.count?(e-=c.atomStore.count+c.bondStore.count,b=c.getBondProxy(e),b.bondStore=c.backboneBondStore):e<=c.atomStore.count+c.bondStore.count+c.backboneBondStore.count+c.rungBondStore.count?(e-=c.atomStore.count+c.bondStore.count+c.backboneBondStore.count,b=c.getBondProxy(e),b.bondStore=c.rungBondStore):NGL.warn("NGL.GidPool.getByGid: invalid Structure gid",a):"Volume"===c.type?b={volume:c,index:e,value:c.data[e],x:c.dataPosition[3*e],y:c.dataPosition[3*e+1],z:c.dataPosition[3*e+2]}:
NGL.warn("NGL.GidPool.getByGid: unknown object type for gid",a))});return b}};
NGL.ColorMakerRegistry={signals:{},scales:{"":"",OrRd:"[S] Orange-Red",PuBu:"[S] Purple-Blue",BuPu:"[S] Blue-Purple",Oranges:"[S] Oranges",BuGn:"[S] Blue-Green",YlOrBr:"[S] Yellow-Orange-Brown",YlGn:"[S] Yellow-Green",Reds:"[S] Reds",RdPu:"[S] Red-Purple",Greens:"[S] Greens",YlGnBu:"[S] Yellow-Green-Blue",Purples:"[S] Purples",GnBu:"[S] Green-Blue",Greys:"[S] Greys",YlOrRd:"[S] Yellow-Orange-Red",PuRd:"[S] Purple-Red",Blues:"[S] Blues",PuBuGn:"[S] Purple-Blue-Green",Spectral:"[D] Spectral",RdYlGn:"[D] Red-Yellow-Green",
RdBu:"[D] Red-Blue",PiYG:"[D] Pink-Yellowgreen",PRGn:"[D] Purplered-Green",RdYlBu:"[D] Red-Yellow-Blue",BrBG:"[D] Brown-Bluegreen",RdGy:"[D] Red-Grey",PuOr:"[D] Purple-Orange",Set1:"[Q] Set1",Set2:"[Q] Set2",Set3:"[Q] Set3",Dark2:"[Q] Dark2",Paired:"[Q] Paired",Pastel1:"[Q] Pastel1",Pastel2:"[Q] Pastel2",Accent:"[Q] Accent",roygb:"[?] Rainbow",rwb:"[?] Red-White-Blue"},modes:{"":"",rgb:"Red Green Blue",hsv:"Hue Saturation Value",hsl:"Hue Saturation Lightness",hsi:"Hue Saturation Intensity",lab:"CIE L*a*b*",
hcl:"Hue Chroma Lightness"},types:{},userSchemes:{},getScheme:function(a){var b=(a||{}).scheme||"";return new (b in NGL.ColorMakerRegistry.types?NGL.ColorMakerRegistry.types[b]:b in NGL.ColorMakerRegistry.userSchemes?NGL.ColorMakerRegistry.userSchemes[b]:NGL.ColorMaker)(a)},getPickingScheme:function(a){a=Object.assign(a||{});a.scheme="picking";return NGL.ColorMakerRegistry.getScheme(a)},getTypes:function(){var a={};Object.keys(NGL.ColorMakerRegistry.types).forEach(function(b){a[b]=b});Object.keys(NGL.ColorMakerRegistry.userSchemes).forEach(function(b){a[b]=
b.split("|")[1]});return a},getScales:function(){return NGL.ColorMakerRegistry.scales},getModes:function(){return NGL.ColorMakerRegistry.modes},addScheme:function(a,b){a instanceof NGL.ColorMaker||(a=NGL.ColorMakerRegistry.createScheme(a,b));b=b||"";var c=""+THREE.Math.generateUUID()+"|"+b;NGL.ColorMakerRegistry.userSchemes[c]=a;return c},removeScheme:function(a){delete NGL.ColorMakerRegistry.userSchemes[a]},createScheme:function(a,b){var c=function(c){NGL.ColorMaker.call(this,c);this.label=b||"";
a.call(this,c)};c.prototype=NGL.ColorMaker.prototype;return c.prototype.constructor=c},addSelectionScheme:function(a,b){return NGL.ColorMakerRegistry.addScheme(function(b){var d=[],e=[];a.forEach(function(a){d.push((new THREE.Color(a[0])).getHex());e.push(new NGL.Selection(a[1]))});var f=a.length;this.atomColor=function(a){for(var b=0;b<f;++b)if(e[b].test(a))return d[b];return 16777215}},b)}};
NGL.ColorMaker=function(a){a=a||{};this.scale=a.scale||"uniform";this.mode=a.mode||"hcl";this.domain=a.domain||[0,1];this.value=(new THREE.Color(a.value||16777215)).getHex();this.structure=a.structure;this.volume=a.volume;this.surface=a.surface;this.structure&&(this.atomProxy=this.structure.getAtomProxy())};
NGL.ColorMaker.prototype={constructor:NGL.ColorMaker,getScale:function(a){a=a||{};var b=a.scale||this.scale;"rainbow"===b||"roygb"===b?b=["red","orange","yellow","green","blue"]:"rwb"===b&&(b=["red","white","blue"]);return chroma.scale(b).mode(a.mode||this.mode).domain(a.domain||this.domain).out("num")},colorToArray:function(a,b,c){void 0===b&&(b=[]);void 0===c&&(c=0);b[c+0]=(a>>16&255)/255;b[c+1]=(a>>8&255)/255;b[c+2]=(a&255)/255;return b},atomColor:function(a){return 16777215},atomColorToArray:function(a,
b,c){return this.colorToArray(this.atomColor(a),b,c)},bondColor:function(a,b){this.atomProxy.index=b?a.atomIndex1:a.atomIndex2;return this.atomColor(this.atomProxy)},bondColorToArray:function(a,b,c,d){return this.colorToArray(this.bondColor(a,b),c,d)},volumeColor:function(a){return 16777215},volumeColorToArray:function(a,b,c){return this.colorToArray(this.volumeColor(a),b,c)},positionColor:function(a){return 16777215},positionColorToArray:function(a,b,c){return this.colorToArray(this.positionColor(a),
b,c)}};NGL.VolumeColorMaker=function(a){NGL.ColorMaker.call(this,a);var b=this.getScale();a=this.volume;var c=a.inverseMatrix,d=a.__data,e=a.nx,f=a.ny,g=new THREE.Vector3;this.positionColor=function(a){g.copy(a);g.applyMatrix4(c);g.round();return b(d[(g.z*f+g.y)*e+g.x])}};NGL.VolumeColorMaker.prototype=NGL.ColorMaker.prototype;NGL.VolumeColorMaker.prototype.constructor=NGL.VolumeColorMaker;NGL.ValueColorMaker=function(a){NGL.ColorMaker.call(this,a);var b=this.getScale();this.volumeColor=function(a){return b(this.volume.data[a])}};
NGL.ValueColorMaker.prototype=NGL.ColorMaker.prototype;NGL.ValueColorMaker.prototype.constructor=NGL.ValueColorMaker;
NGL.PickingColorMaker=function(a){NGL.ColorMaker.call(this,a);var b;this.structure&&(b=this.structure.atomStore.count,a.backbone?b+=this.structure.bondStore.count:a.rung&&(b+=this.structure.bondStore.count,b+=this.structure.backboneBondStore.count));this.atomColor=function(a){return NGL.GidPool.getGid(this.structure,a.index)};this.bondColor=function(a,d){return NGL.GidPool.getGid(this.structure,b+a.index)};this.volumeColor=function(a){return NGL.GidPool.getGid(this.volume,a)}};
NGL.PickingColorMaker.prototype=NGL.ColorMaker.prototype;NGL.PickingColorMaker.prototype.constructor=NGL.PickingColorMaker;NGL.RandomColorMaker=function(a){NGL.ColorMaker.call(this,a);this.atomColor=function(a){return 16777215*Math.random()}};NGL.RandomColorMaker.prototype=NGL.ColorMaker.prototype;NGL.RandomColorMaker.prototype.constructor=NGL.RandomColorMaker;
NGL.UniformColorMaker=function(a){NGL.ColorMaker.call(this,a);var b=this.value;this.atomColor=function(){return b};this.bondColor=function(){return b};this.valueColor=function(){return b}};NGL.UniformColorMaker.prototype=NGL.ColorMaker.prototype;NGL.UniformColorMaker.prototype.constructor=NGL.UniformColorMaker;
NGL.AtomindexColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="roygb");if(a.domain){var b=this.getScale();this.atomColor=function(a){return b(a.index)}}else{var c={};this.structure.eachModel(function(a){this.domain=[a.atomOffset,a.atomEnd];c[a.index]=this.getScale()}.bind(this));this.atomColor=function(a){return c[a.modelIndex](a.index)}}};NGL.AtomindexColorMaker.prototype=NGL.ColorMaker.prototype;NGL.AtomindexColorMaker.prototype.constructor=NGL.AtomindexColorMaker;
NGL.ResidueindexColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="roygb");a.domain||(this.domain=[0,this.structure.residueStore.count]);var b=this.getScale();this.atomColor=function(a){return b(a.residueIndex)}};NGL.ResidueindexColorMaker.prototype=NGL.ColorMaker.prototype;NGL.ResidueindexColorMaker.prototype.constructor=NGL.ResidueindexColorMaker;
NGL.ChainindexColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="Spectral");a.domain||(this.domain=[0,this.structure.chainStore.count]);var b=this.getScale();this.atomColor=function(a){return b(a.chainIndex)}};NGL.ChainindexColorMaker.prototype=NGL.ColorMaker.prototype;NGL.ChainindexColorMaker.prototype.constructor=NGL.ChainindexColorMaker;
NGL.ModelindexColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="roygb");a.domain||(this.domain=[0,this.structure.modelStore.count]);var b=this.getScale();this.atomColor=function(a){return b(a.modelIndex)}};NGL.ModelindexColorMaker.prototype=NGL.ColorMaker.prototype;NGL.ModelindexColorMaker.prototype.constructor=NGL.ModelindexColorMaker;
NGL.SstrucColorMaker=function(a){NGL.ColorMaker.call(this,a);var b=NGL.StructureColors,c=NGL.StructureColors[""],d=this.structure.getResidueProxy();this.atomColor=function(a){var f=a.sstruc;if("h"===f)return b.alphaHelix;if("g"===f)return b["3_10Helix"];if("i"===f)return b.piHelix;if("e"===f||"b"===f)return b.betaStrand;d.index=a.residueIndex;return d.isNucleic()?b.dna:d.isProtein()||"s"===f||"t"===f||"l"===f?b.coil:c}};NGL.SstrucColorMaker.prototype=NGL.ColorMaker.prototype;
NGL.SstrucColorMaker.prototype.constructor=NGL.SstrucColorMaker;NGL.ElementColorMaker=function(a){NGL.ColorMaker.call(this,a);var b=NGL.ElementColors,c=NGL.ElementColors[""],d=this.value;void 0===a.value&&(d=NGL.ElementColors.C);this.atomColor=function(a){a=a.element;return"C"===a?d:b[a]||c}};NGL.ElementColorMaker.prototype=NGL.ColorMaker.prototype;NGL.ElementColorMaker.prototype.constructor=NGL.ElementColorMaker;
NGL.ResnameColorMaker=function(a){NGL.ColorMaker.call(this,a);var b=NGL.ResidueColors,c=NGL.ResidueColors[""];this.atomColor=function(a){return b[a.resname]||c}};NGL.ResnameColorMaker.prototype=NGL.ColorMaker.prototype;NGL.ResnameColorMaker.prototype.constructor=NGL.ResnameColorMaker;
NGL.BfactorColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="OrRd");if(!a.domain){var b,c=Infinity,d=-Infinity;a.sele&&(b=new NGL.Selection(a.sele));this.structure.eachSelectedAtom(function(a){a=a.bfactor;c=Math.min(c,a);d=Math.max(d,a)},b);this.domain=[c,d]}var e=this.getScale();this.atomColor=function(a){return e(a.bfactor)}};NGL.BfactorColorMaker.prototype=NGL.ColorMaker.prototype;NGL.BfactorColorMaker.prototype.constructor=NGL.BfactorColorMaker;
NGL.OccupancyColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="PuBu");a.domain||(this.domain=[0,1]);var b=this.getScale();this.atomColor=function(a){return b(a.occupancy)}};NGL.OccupancyColorMaker.prototype=NGL.ColorMaker.prototype;NGL.OccupancyColorMaker.prototype.constructor=NGL.OccupancyColorMaker;
NGL.HydrophobicityColorMaker=function(a){NGL.ColorMaker.call(this,a);a.scale||(this.scale="RdYlGn");var b={},c;for(c in NGL.ResidueHydrophobicity)b[c]=NGL.ResidueHydrophobicity[c][0];var d=b[""];if(!a.domain){var e=Infinity,f=-Infinity;for(c in b)a=b[c],e=Math.min(e,a),f=Math.max(f,a);this.domain=[e,0,f]}var g=this.getScale();this.atomColor=function(a){return g(b[a.resname]||d)}};NGL.HydrophobicityColorMaker.prototype=NGL.ColorMaker.prototype;NGL.HydrophobicityColorMaker.prototype.constructor=NGL.HydrophobicityColorMaker;
NGL.ColorMakerRegistry.types={"":NGL.ColorMaker,picking:NGL.PickingColorMaker,random:NGL.RandomColorMaker,uniform:NGL.UniformColorMaker,atomindex:NGL.AtomindexColorMaker,residueindex:NGL.ResidueindexColorMaker,chainindex:NGL.ChainindexColorMaker,modelindex:NGL.ModelindexColorMaker,sstruc:NGL.SstrucColorMaker,element:NGL.ElementColorMaker,resname:NGL.ResnameColorMaker,bfactor:NGL.BfactorColorMaker,hydrophobicity:NGL.HydrophobicityColorMaker,value:NGL.ValueColorMaker,volume:NGL.VolumeColorMaker,occupancy:NGL.OccupancyColorMaker};
NGL.RadiusFactory=function(a,b){this.type=a;this.scale=b||1;this.max=10};NGL.RadiusFactory.types={"":"",vdw:"by vdW radius",covalent:"by covalent radius",sstruc:"by secondary structure",bfactor:"by bfactor",size:"size"};
NGL.RadiusFactory.prototype={constructor:NGL.RadiusFactory,atomRadius:function(a){var b=this.type,c=this.scale,d=NGL.VdwRadii,e=NGL.CovalentRadii,f=NGL.VdwRadii[""],g=NGL.CovalentRadii[""],h=["C3'","C3*","C4'","C4*","P"];switch(b){case "vdw":a=d[a.element]||f;break;case "covalent":a=e[a.element]||g;break;case "bfactor":a=a.bfactor||1;break;case "sstruc":b=a.sstruc;a="h"===b?.25:"g"===b?.25:"i"===b?.25:"e"===b?.25:"b"===b?.25:-1!==h.indexOf(a.atomname)?.4:.1;break;default:a=b||1}return Math.min(a*
c,this.max)}};NGL.LabelFactory=function(a,b){this.type=a;this.text=b||{}};NGL.LabelFactory.types={"":"",atomname:"atom name",atomindex:"atom index",atom:"atom name + index",resname:"residue name",resno:"residue no",res:"residue name + no",text:"text"};
NGL.LabelFactory.prototype={constructor:NGL.LabelFactory,atomLabel:function(a){switch(this.type){case "atomname":a=a.atomname;break;case "atomindex":a=""+a.index;break;case "atom":a=a.atomname+"|"+a.index;break;case "resname":a=a.resname;break;case "resno":a=""+a.resno;break;case "res":a=(NGL.AA1[a.resname.toUpperCase()]||"")+a.resno;break;case "text":a=this.text[a.index];break;default:a=a.qualifiedName()}return void 0===a?"":a}};
NGL.Structure=function(a,b){this.signals={refreshed:new signals.Signal};this.name=a;this.path=b;this.id=this.title="";this.atomSetCache={};this.atomSetDict={};this.biomolDict={};this.helices=[];this.sheets=[];this.unitcell=new NGL.Unitcell;this.selection=void 0;this.frames=[];this.boxes=[];this.bondStore=new NGL.BondStore(0);this.backboneBondStore=new NGL.BondStore(0);this.rungBondStore=new NGL.BondStore(0);this.atomStore=new NGL.AtomStore(0);this.residueStore=new NGL.ResidueStore(0);this.chainStore=
new NGL.ChainStore(0);this.modelStore=new NGL.ModelStore(0);this.atomMap=new NGL.AtomMap(this);this.residueMap=new NGL.ResidueMap(this);this.atomSet=this.getAtomSet(this.selection);this.bondSet=this.getBondSet();this.center=new THREE.Vector3;this.boundingBox=new THREE.Box3;NGL.GidPool.addObject(this);this._ap=this.getAtomProxy();this._rp=this.getResidueProxy();this._cp=this.getChainProxy()};
NGL.Structure.prototype={constructor:NGL.Structure,type:"Structure",refresh:function(){NGL.debug&&NGL.time("NGL.Structure.refresh");this.atomSetCache={};this.atomSet=this.getAtomSet2(this.selection);this.bondSet=this.getBondSet();for(var a in this.atomSetDict){var b=this.atomSetDict[a],c=this.getAtomSet2(!1);this.atomSetCache["__"+a]=c.intersection(b)}this.boundingBox=this.getBoundingBox();this.center=this.boundingBox.center();NGL.GidPool.updateObject(this);NGL.debug&&NGL.timeEnd("NGL.Structure.refresh");
this.signals.refreshed.dispatch()},getBondProxy:function(a){return new NGL.BondProxy(this,a)},getAtomProxy:function(a,b){return b?(void 0===this.__tmpAtomProxy&&(this.__tmpAtomProxy=new NGL.AtomProxy(this,a)),this.__tmpAtomProxy):new NGL.AtomProxy(this,a)},getResidueProxy:function(a,b){return b?(void 0===this.__tmpResidueProxy&&(this.__tmpResidueProxy=new NGL.ResidueProxy(this,a)),this.__tmpResidueProxy):new NGL.ResidueProxy(this,a)},getChainProxy:function(a){return new NGL.ChainProxy(this,a)},getModelProxy:function(a){return new NGL.ModelProxy(this,
a)},getBondSet:function(a){NGL.debug&&NGL.time("NGL.Structure.getBondSet");a=this.bondStore.count;var b=new TypedFastBitSet(a),c=this.atomSet;if(c)for(var d=this.getBondProxy(),e=0;e<a;++e)d.index=e,c.has(d.atomIndex1)&&c.has(d.atomIndex2)&&b.add_unsafe(d.index);else b.set_all(!0);NGL.debug&&NGL.timeEnd("NGL.Structure.getBondSet");return b},getBackboneBondSet:function(a){NGL.debug&&NGL.time("NGL.Structure.getBackboneBondSet");a=this.backboneBondStore.count;var b=new TypedFastBitSet(a),c=this.atomSetCache.__backbone;
if(c){var d=this.getBondProxy();d.bondStore=this.backboneBondStore;for(var e=0;e<a;++e)d.index=e,c.has(d.atomIndex1)&&c.has(d.atomIndex2)&&b.add_unsafe(d.index)}else b.set_all(!0);NGL.debug&&NGL.timeEnd("NGL.Structure.getBackboneBondSet");return b},getRungBondSet:function(a){NGL.debug&&NGL.time("NGL.Structure.getRungBondSet");a=this.rungBondStore.count;var b=new TypedFastBitSet(a),c=this.atomSetCache.__rung;if(c){var d=this.getBondProxy();d.bondStore=this.rungBondStore;for(var e=0;e<a;++e)d.index=
e,c.has(d.atomIndex1)&&c.has(d.atomIndex2)&&b.add_unsafe(d.index)}else b.set_all(!0);NGL.debug&&NGL.timeEnd("NGL.Structure.getRungBondSet");return b},getAtomSet:function(a){NGL.debug&&NGL.time("NGL.Structure.getAtomSet");var b,c=this.atomStore.count;if(!1===a)b=new TypedFastBitSet(c);else if(!0===a)b=new TypedFastBitSet(c),b.set_all(!0);else if(a&&a.test){var d=a.string;b=this.atomSetCache[d];d||console.warn("empty seleString");if(void 0===b){b=new TypedFastBitSet(c);var e=this.getAtomProxy();a=a.test;
for(var f=0;f<c;++f)e.index=f,a(e)&&b.add_unsafe(e.index);this.atomSetCache[d]=b}}else b=new TypedFastBitSet(c),b.set_all(!0);NGL.debug&&NGL.timeEnd("NGL.Structure.getAtomSet");return b},getAtomSet2:function(a){NGL.debug&&NGL.time("NGL.Structure.getAtomSet2");var b,c=this.atomStore.count;if(!1===a)b=new TypedFastBitSet(c);else if(!0===a)b=new TypedFastBitSet(c),b.set_all(!0);else if(a&&a.test){var d=a.string;b=this.atomSetCache[d];d||console.warn("empty seleString");void 0===b&&(b=new TypedFastBitSet(c),
this.eachAtom(function(a){b.add_unsafe(a.index)},a),this.atomSetCache[d]=b)}else b=new TypedFastBitSet(c),b.set_all(!0);NGL.debug&&NGL.timeEnd("NGL.Structure.getAtomSet2");return b},setSelection:function(a){this.selection=a;this.refresh()},getSelection:function(){return this.selection},getStructure:function(){return this},eachBond:function(a,b){var c=this.getBondProxy(),d=this.bondSet;b&&b.test&&(d=d?d.new_intersection(this.getBondSet(b)):this.getBondSet(b));if(d)d.forEach(function(b){c.index=b;a(c)});
else for(var d=this.bondStore.count,e=0;e<d;++e)c.index=e,a(c)},getAtomSet3:function(a){NGL.debug&&NGL.time("NGL.Structure.getAtomSet3");var b=this.atomSet;a&&a.test&&(b=b?b.new_intersection(this.getAtomSet2(a)):this.getAtomSet2(a));NGL.debug&&NGL.timeEnd("NGL.Structure.getAtomSet3");return b},eachSelectedAtom:function(a,b){var c=this.getAtomProxy(),d=this.getAtomSet3(b),e=this.atomStore.count;if(d&&d.size()<e)d.forEach(function(b){c.index=b;a(c)});else for(d=0;d<e;++d)c.index=d,a(c)},eachAtom:function(a,
b){if(b&&b.test)this.eachModel(function(c){c.eachAtom(a,b)},b);else for(var c=this.atomStore.count,d=this.getAtomProxy(),e=0;e<c;++e)d.index=e,a(d)},eachResidue:function(a,b){if(b&&b.test){var c=this.modelStore.count,d=this.getModelProxy();if(b.modelOnlyTest)for(var e=b.modelOnlyTest,f=0;f<c;++f)d.index=f,e(d)&&d.eachResidue(a,b);else for(f=0;f<c;++f)d.index=f,d.eachResidue(a,b)}else for(c=this.residueStore.count,d=this.getResidueProxy(),f=0;f<c;++f)d.index=f,a(d)},eachResidueN:function(a,b){var c=
this.residueStore.count;if(!(c<a)){for(var d=Array(a),e=0;e<a;++e)d[e]=this.getResidueProxy(e);b.apply(this,d);for(var f=a;f<c;++f){for(e=0;e<a;++e)d[e].index+=1;b.apply(this,d)}}},eachPolymer:function(a,b){if(b&&b.modelOnlyTest){var c=b.modelOnlyTest;this.eachModel(function(d){c(d)&&d.eachPolymer(a,b)})}else this.eachModel(function(c){c.eachPolymer(a,b)})},eachChain:function(a,b){if(b&&b.test)this.eachModel(function(c){c.eachChain(a,b)});else for(var c=this.chainStore.count,d=this.getChainProxy(),
e=0;e<c;++e)d.index=e,a(d)},eachModel:function(a,b){var c=this.modelStore.count,d=this.getModelProxy();if(b&&b.test){var e=b.modelOnlyTest;if(e)for(var f=0;f<c;++f)d.index=f,e(d)&&a(d,b);else for(f=0;f<c;++f)d.index=f,a(d,b)}else for(f=0;f<c;++f)d.index=f,a(d)},getAtomData:function(a){a=Object.assign({},a);a.colorParams&&(a.colorParams.structure=this.getStructure());var b=a.what,c=a.atomSet||this.atomSet,d,e,f,g,h,k,l,m={},n=this.getAtomProxy(),p=c.size();if(!b||b.position)g=new Float32Array(3*p),
m.position=g;if(!b||b.color)h=new Float32Array(3*p),m.color=h,e=NGL.ColorMakerRegistry.getScheme(a.colorParams);if(!b||b.pickingColor){k=new Float32Array(3*p);m.pickingColor=k;var q=Object.assign(a.colorParams,{scheme:"picking"});f=NGL.ColorMakerRegistry.getScheme(q)}if(!b||b.radius)l=new Float32Array(p),m.radius=l,d=new NGL.RadiusFactory(a.radiusParams.radius,a.radiusParams.scale);c.forEach(function(a,b){var c=3*b;n.index=a;g&&n.positionToArray(g,c);h&&e.atomColorToArray(n,h,c);k&&f.atomColorToArray(n,
k,c);l&&(l[b]=d.atomRadius(n))});return m},getBondData:function(a){a=Object.assign({},a);a.colorParams&&(a.colorParams.structure=this.getStructure());var b=a.what,c=a.bondSet||this.bondSet,d,e,f,g,h,k,l,m,n,p,q,r={},t=this.getBondProxy();a.bondStore&&(t.bondStore=a.bondStore);var v=this.getAtomProxy(),w=this.getAtomProxy(),u=c.size();if(!b||b.position)g=new Float32Array(3*u),h=new Float32Array(3*u),r.position1=g,r.position2=h;if(!b||b.color)k=new Float32Array(3*u),l=new Float32Array(3*u),r.color1=
k,r.color2=l,e=NGL.ColorMakerRegistry.getScheme(a.colorParams);if(!b||b.pickingColor){m=new Float32Array(3*u);n=new Float32Array(3*u);r.pickingColor1=m;r.pickingColor2=n;var B=Object.assign(a.colorParams,{scheme:"picking"});f=NGL.ColorMakerRegistry.getScheme(B)}if(!b||b.radius)d=new NGL.RadiusFactory(a.radiusParams.radius,a.radiusParams.scale);if(!b||b.radius)p=new Float32Array(u),a.radius2?(q=new Float32Array(u),r.radius1=p,r.radius2=q):r.radius=p;c.forEach(function(a,b){var c=3*b;t.index=a;v.index=
t.atomIndex1;w.index=t.atomIndex2;g&&(v.positionToArray(g,c),w.positionToArray(h,c));k&&(e.bondColorToArray(t,1,k,c),e.bondColorToArray(t,0,l,c));m&&(f.bondColorToArray(t,1,m,c),f.bondColorToArray(t,0,n,c));p&&(p[b]=d.atomRadius(v));q&&(q[b]=d.atomRadius(w))});return r},getBackboneAtomData:function(a){a=Object.assign({atomSet:this.atomSetCache.__backbone},a);return this.getAtomData(a)},getBackboneBondData:function(a){a=Object.assign({bondSet:this.getBackboneBondSet(),bondStore:this.backboneBondStore},
a);return this.getBondData(a)},getRungAtomData:function(a){a=Object.assign({atomSet:this.atomSetCache.__rung},a);return this.getAtomData(a)},getRungBondData:function(a){a=Object.assign({bondSet:this.getRungBondSet(),bondStore:this.rungBondStore},a);return this.getBondData(a)},getView:function(a){return new NGL.StructureView(this,a)},getBoundingBox:function(a){NGL.debug&&console.time("getBoundingBox");var b=new THREE.Box3,c=Infinity,d=Infinity,e=Infinity,f=-Infinity,g=-Infinity,h=-Infinity;this.eachSelectedAtom(function(a){var b=
a.x,m=a.y;a=a.z;b<c&&(c=b);m<d&&(d=m);a<e&&(e=a);b>f&&(f=b);m>g&&(g=m);a>h&&(h=a)},a);b.min.set(c,d,e);b.max.set(f,g,h);NGL.debug&&console.timeEnd("getBoundingBox");return b},atomCenter:function(a){return a?this.getBoundingBox(a).center():this.center.clone()},getSequence:function(){var a=[],b=this.getResidueProxy();this.eachSelectedAtom(function(c){b.index=c.residueIndex;c.index===b.traceAtomIndex&&a.push(b.getResname1())});return a},getAtomIndices:function(a){var b=[];this.eachAtom(function(a){b.push(a.index)},
a);return b},atomIndex:function(){var a=new Float32Array(this.atomCount);this.eachSelectedAtom(function(b){a[0]=b.index});return a},updatePosition:function(a){var b=0;this.eachSelectedAtom(function(c){c.positionFromArray(a,b);b+=3})},toJSON:function(){NGL.debug&&NGL.time("NGL.Structure.toJSON");var a={metadata:{version:.1,type:"Structure",generator:"StructureExporter"},name:this.name,path:this.path,title:this.title,id:this.id,biomolDict:{},helices:this.helices,sheets:this.sheets,unitcell:this.unitcell.toJSON(),
frames:this.frames,boxes:this.boxes,center:this.center.toArray(),boundingBox:[this.boundingBox.min.toArray(),this.boundingBox.max.toArray()],bondStore:this.bondStore.toJSON(),backboneBondStore:this.backboneBondStore.toJSON(),rungBondStore:this.rungBondStore.toJSON(),atomStore:this.atomStore.toJSON(),residueStore:this.residueStore.toJSON(),chainStore:this.chainStore.toJSON(),modelStore:this.modelStore.toJSON(),bondSet:this.bondSet.toJSON(),atomSet:this.atomSet.toJSON(),atomSetDict:{},atomSetCache:{},
atomMap:this.atomMap.toJSON(),residueMap:this.residueMap.toJSON()},b;for(b in this.biomolDict)a.biomolDict[b]=this.biomolDict[b].toJSON();for(b in this.atomSetDict)a.atomSetDict[b]=this.atomSetDict[b].toJSON();for(b in this.atomSetCache)a.atomSetCache[b]=this.atomSetCache[b].toJSON();NGL.debug&&NGL.timeEnd("NGL.Structure.toJSON");return a},fromJSON:function(a){NGL.debug&&NGL.time("NGL.Structure.fromJSON");this.name=a.name;this.path=a.path;this.title=a.title;this.id=a.id;this.biomolDict=a.biomolDict;
this.helices=a.helices;this.sheets=a.sheets;this.unitcell=(new NGL.Unitcell).fromJSON(a.unitcell);this.frames=a.frames;this.boxes=a.boxes;this.center=(new THREE.Vector3).fromArray(a.center);this.boundingBox=new THREE.Box3((new THREE.Vector3).fromArray(a.boundingBox[0]),(new THREE.Vector3).fromArray(a.boundingBox[1]));this.bondStore.fromJSON(a.bondStore);this.backboneBondStore.fromJSON(a.backboneBondStore);this.rungBondStore.fromJSON(a.rungBondStore);this.atomStore.fromJSON(a.atomStore);this.residueStore.fromJSON(a.residueStore);
this.chainStore.fromJSON(a.chainStore);this.modelStore.fromJSON(a.modelStore);this.bondSet.fromJSON(a.bondSet);this.atomSet.fromJSON(a.atomSet);this.biomolDict={};for(var b in a.biomolDict){var c=new NGL.Assembly;this.biomolDict[b]=c.fromJSON(a.biomolDict[b])}this.atomSetDict={};for(b in a.atomSetDict)c=new TypedFastBitSet,this.atomSetDict[b]=c.fromJSON(a.atomSetDict[b]);this.atomSetCache={};for(b in a.atomSetCache)c=new TypedFastBitSet,this.atomSetCache[b]=c.fromJSON(a.atomSetCache[b]);this.atomMap.fromJSON(a.atomMap);
this.residueMap.fromJSON(a.residueMap);NGL.GidPool.updateObject(this);NGL.debug&&NGL.timeEnd("NGL.Structure.fromJSON");return this},getTransferable:function(){var a=[];a.concat(this.bondStore.getTransferable());a.concat(this.backboneBondStore.getTransferable());a.concat(this.rungBondStore.getTransferable());a.concat(this.atomStore.getTransferable());a.concat(this.residueStore.getTransferable());a.concat(this.chainStore.getTransferable());a.concat(this.modelStore.getTransferable());if(this.frames)for(var b=
this.frames,c=this.frames.length,d=0;d<c;++d)a.push(b[d].buffer);if(this.boxes)for(b=this.boxes,c=this.boxes.length,d=0;d<c;++d)a.push(b[d].buffer);a.concat(this.bondSet.getTransferable());a.concat(this.atomSet.getTransferable());for(var e in this.atomSetDict)a.concat(this.atomSetDict[e].getTransferable());for(e in this.atomSetCache)a.concat(this.atomSetCache[e].getTransferable());return a},dispose:function(){NGL.GidPool.removeObject(this);this.frames&&(this.frames.length=0);this.boxes&&(this.boxes.length=
0);this.bondStore.dispose();this.backboneBondStore.dispose();this.rungBondStore.dispose();this.atomStore.dispose();this.residueStore.dispose();this.chainStore.dispose();this.modelStore.dispose();delete this.bondStore;delete this.atomStore;delete this.residueStore;delete this.chainStore;delete this.modelStore;delete this.frames;delete this.boxes;delete this.cif;delete this.bondSet;delete this.atomSet}};
NGL.StructureView=function(a,b){this.signals={refreshed:new signals.Signal};this.structure=a;this.selection=b;this.center=new THREE.Vector3;this.boundingBox=new THREE.Box3;if(a||b)this.init(),this.refresh()};
NGL.StructureView.prototype=NGL.createObject(NGL.Structure.prototype,{constructor:NGL.StructureView,type:"StructureView",init:function(){Object.defineProperties(this,{atomSetDict:{get:function(){return this.structure.atomSetDict}},bondStore:{get:function(){return this.structure.bondStore}},backboneBondStore:{get:function(){return this.structure.backboneBondStore}},rungBondStore:{get:function(){return this.structure.rungBondStore}},atomStore:{get:function(){return this.structure.atomStore}},residueStore:{get:function(){return this.structure.residueStore}},
chainStore:{get:function(){return this.structure.chainStore}},modelStore:{get:function(){return this.structure.modelStore}},atomMap:{get:function(){return this.structure.atomMap}},residueMap:{get:function(){return this.structure.residueMap}}});this._ap=this.getAtomProxy();this._rp=this.getResidueProxy();this._cp=this.getChainProxy();this.selection&&this.selection.signals.stringChanged.add(function(a){this.refresh()},this);this.structure.signals.refreshed.add(this.refresh,this)},refresh:function(){NGL.debug&&
NGL.time("NGL.StructureView.refresh");this.atomSetCache={};this.atomSet=this.getAtomSet2(this.selection);this.structure.atomSet&&(NGL.debug&&NGL.time("NGL.StructureView.refresh#atomSet.intersection"),this.atomSet=this.atomSet.intersection(this.structure.atomSet),NGL.debug&&NGL.timeEnd("NGL.StructureView.refresh#atomSet.intersection"));this.bondSet=this.getBondSet();NGL.debug&&NGL.time("NGL.StructureView.refresh#atomSetDict.new_intersection");for(var a in this.atomSetDict)this.atomSetCache["__"+a]=
this.atomSetDict[a].new_intersection(this.atomSet);NGL.debug&&NGL.timeEnd("NGL.StructureView.refresh#atomSetDict.new_intersection");NGL.debug&&NGL.time("NGL.StructureView.refresh#size");this.atomCount=this.atomSet.size();this.bondCount=this.bondSet.size();NGL.debug&&NGL.timeEnd("NGL.StructureView.refresh#size");this.boundingBox=this.getBoundingBox();this.center=this.boundingBox.center();NGL.debug&&NGL.timeEnd("NGL.StructureView.refresh");this.signals.refreshed.dispatch()},getSelection:function(){var a=
this.structure.getSelection();return a?a.string&&this.selection.string?new NGL.Selection("( "+a.string+" ) AND ( "+this.selection.string+" )"):a.string?new NGL.Selection(a.string):this.selection.string?new NGL.Selection(this.selection.string):new NGL.Selection(""):this.selection},getStructure:function(){return this.structure.getStructure()},toJSON:function(){var a={metadata:{version:.1,type:"StructureView",generator:"StructureViewExporter"},structure:this.structure.toJSON(),atomSet:this.atomSet.toJSON(),
bondSet:this.bondSet.toJSON(),atomCount:this.atomCount,bondCount:this.bondCount,atomSetCache:{}},b;for(b in this.atomSetCache)a.atomSetCache[b]=this.atomSetCache[b].toJSON();return a},fromJSON:function(a){"Structure"===a.structure.metadata.type?this.structure=(new NGL.Structure).fromJSON(a.structure):"StructureView"===a.structure.metadata.type&&(this.structure=(new NGL.StructureView).fromJSON(a.structure));this.atomSet=(new TypedFastBitSet).fromJSON(a.atomSet);this.bondSet=(new TypedFastBitSet).fromJSON(a.bondSet);
this.atomCount=a.atomCount;this.bondCount=a.bondCount;this.atomSetCache={};for(var b in a.atomSetCache){var c=new TypedFastBitSet;this.atomSetCache[b]=c.fromJSON(a.atomSetCache[b])}this.init();return this},getTransferable:function(){var a=[];a.concat(this.structure.getTransferable());a.concat(this.bondSet.getTransferable());a.concat(this.atomSet.getTransferable());for(var b in this.atomSetCache)a.concat(this.atomSetCache[b].getTransferable());return a},dispose:function(){delete this.structure;delete this.atomSet;
delete this.bondSet;delete this.atomCount;delete this.bondCount}});NGL.makeTrajectory=function(a,b,c){return a instanceof NGL.Frames||a instanceof Promise?new NGL.FramesTrajectory(a,b,c):!a&&b.frames?new NGL.StructureTrajectory(a,b,c):new NGL.RemoteTrajectory(a,b,c)};NGL.Frames=function(a,b){this.name=a;this.path=b;this.coordinates=[];this.boxes=[]};
NGL.Frames.prototype={constructor:NGL.Frames,toJSON:function(){return{metadata:{version:.1,type:"Frames",generator:"FramesExporter"},name:this.name,path:this.path,coordinates:this.coordinates,boxes:this.boxes}},fromJSON:function(a){this.name=a.name;this.path=a.path;this.coordinates=a.coordinates;this.boxes=a.boxes},getTransferable:function(){for(var a=[],b=this.coordinates,c=b.length,d=0;d<c;++d)a.push(b[d].buffer);return a}};
NGL.Trajectory=function(a,b,c){var d=signals;this.signals={gotNumframes:new d.Signal,frameChanged:new d.Signal,selectionChanged:new d.Signal,playerChanged:new d.Signal};this.params={centerPbc:!0,removePbc:!0,superpose:!0};this.name=a.replace(/^.*[\\\/]/,"");this.selection=new NGL.Selection(c||"backbone and not hydrogen");this.selection.signals.stringChanged.add(function(a){this.makeIndices();this.resetCache()},this);this.setStructure(b);this.trajPath=a;this.numframes=void 0;this.getNumframes()};
NGL.Trajectory.prototype={constructor:NGL.Trajectory,setStructure:function(a){this.structure=a;this.atomCount=a.atomCount;this.makeAtomIndices();this.saveInitialStructure();this.backboneIndices=this.structure.atomIndex(new NGL.Selection("backbone and not hydrogen"));this.makeIndices();this.frameCache=[];this.boxCache=[];this.pathCache=[];this.frameCacheSize=0;this.currentFrame=-1},saveInitialStructure:function(){var a=0,b=new Float32Array(3*this.atomCount);this.structure.eachSelectedAtom(function(c){b[a+
0]=c.x;b[a+1]=c.y;b[a+2]=c.z;a+=3});this.initialStructure=b},setSelection:function(a){this.selection.setString(a);return this},makeIndices:function(){this.indices=this.structure.atomIndex(this.selection);var a,b,c=3*this.indices.length;this.coords1=new Float32Array(c);this.coords2=new Float32Array(c);var d=this.initialStructure,e=this.coords2;for(a=0;a<c;a+=3)b=3*this.indices[a/3],e[a+0]=d[b+0],e[a+1]=d[b+1],e[a+2]=d[b+2]},makeAtomIndices:function(){NGL.error("Trajectory.makeAtomIndices not implemented")},
getNumframes:function(){NGL.error("Trajectory.loadFrame not implemented")},resetCache:function(){this.frameCache=[];this.boxCache=[];this.pathCache=[];this.frameCacheSize=0;this.setFrame(this.currentFrame);return this},setParameters:function(a){var b=this.params,c=!1;void 0!==a.centerPbc&&a.centerPbc!==b.centerPbc&&(b.centerPbc=a.centerPbc,c=!0);void 0!==a.removePbc&&a.removePbc!==b.removePbc&&(b.removePbc=a.removePbc,c=!0);void 0!==a.superpose&&a.superpose!==b.superpose&&(b.superpose=a.superpose,
c=!0);c&&this.resetCache()},setFrame:function(a,b){if(void 0===a)return this;this.inProgress=!0;a=parseInt(a);-1===a||this.frameCache[a]?this.updateStructure(a,b):this.loadFrame(a,function(){this.updateStructure(a,b)}.bind(this));return this},interpolate:function(){var a=function(a,c,d,e,f,g){a=(d-a)*g;e=(e-c)*g;g=f*f;return(2*c-2*d+a+e)*f*g+(-3*c+3*d-2*a-e)*g+a*f+c};return function(b,c,d,e,f,g,h){var k=this.frameCache,l=k[b];c=k[c];d=k[d];var m=k[e];e=l.length;k=new Float32Array(e);if("spline"===
g)for(g=0;g<e;g+=3)k[g+0]=a(m[g+0],d[g+0],c[g+0],l[g+0],f,1),k[g+1]=a(m[g+1],d[g+1],c[g+1],l[g+1],f,1),k[g+2]=a(m[g+2],d[g+2],c[g+2],l[g+2],f,1);else for(g=0;g<e;g+=3)d=c[g+0],k[g+0]=d+(l[g+0]-d)*f,d=c[g+1],k[g+1]=d+(l[g+1]-d)*f,d=c[g+2],k[g+2]=d+(l[g+2]-d)*f;this.structure.updatePosition(k);this.currentFrame=b;this.signals.frameChanged.dispatch(b);"function"===typeof h&&h()}}(),setFrameInterpolated:function(a,b,c,d,e,f,g){if(void 0===a)return this;var h=this.frameCache,k=[];h[d]||k.push(d);h[c]||
k.push(c);h[b]||k.push(b);h[a]||k.push(a);k.length?this.loadFrame(k,function(){this.interpolate(a,b,c,d,e,f,g)}.bind(this)):this.interpolate(a,b,c,d,e,f,g);return this},loadFrame:function(a,b){if(Array.isArray(a)){var c,d=function(a,d){this._loadFrame(a,d);0===c.length()&&"function"===typeof b&&b()}.bind(this);c=new NGL.Queue(d,a)}else this._loadFrame(a,b)},_loadFrame:function(a,b){NGL.error("Trajectory._loadFrame not implemented")},updateStructure:function(a,b){this._disposed||(-1===a?this.structure.updatePosition(this.initialStructure):
this.structure.updatePosition(this.frameCache[a]),this.structure.trajectory={name:this.trajPath,frame:a},"function"===typeof b&&b(),this.currentFrame=a,this.inProgress=!1,this.signals.frameChanged.dispatch(a))},getCircularMean:function(a,b,c){return[NGL.Utils.circularMean(b,c[0],3,0,a),NGL.Utils.circularMean(b,c[1],3,1,a),NGL.Utils.circularMean(b,c[2],3,2,a)]},centerPbc:function(a,b,c){if(0!==c[0]&&0!==c[8]&&0!==c[4]){var d=a.length,e=c[0],f=c[1];c=c[2];var g=-b[0]+e+e/2,h=-b[1]+f+f/2,k=-b[2]+c+c/
2;for(b=0;b<d;b+=3)a[b+0]=(a[b+0]+g)%e,a[b+1]=(a[b+1]+h)%f,a[b+2]=(a[b+2]+k)%c}},removePbc:function(a,b){if(0!==b[0]&&0!==b[8]&&0!==b[4]){var c,d,e,f=a.length;for(c=3;c<f;c+=3)for(d=0;3>d;++d)if(e=a[c+d]-a[c-3+d],Math.abs(e)>.9*b[3*d+d])if(0<e)for(e=0;3>e;++e)a[c+e]-=b[3*d+e];else for(e=0;3>e;++e)a[c+e]+=b[3*d+e];return a}},superpose:function(a){var b,c,d=3*this.indices.length,e=this.coords1,f=this.coords2;for(b=0;b<d;b+=3)c=3*this.indices[b/3],e[b+0]=a[c+0],e[b+1]=a[c+1],e[b+2]=a[c+2];(new NGL.Superposition(e,
f)).transform(a)},process:function(a,b,c,d){this.setNumframes(d);if(b){if(0<this.backboneIndices.length&&this.params.centerPbc){d=[b[0],b[4],b[8]];var e=this.getCircularMean(this.backboneIndices,c,d);this.centerPbc(c,e,d)}this.params.removePbc&&this.removePbc(c,b)}0<this.indices.length&&this.params.superpose&&this.superpose(c);this.frameCache[a]=c;this.boxCache[a]=b;this.frameCacheSize+=1},setNumframes:function(a){a!==this.numframes&&(this.numframes=a,this.signals.gotNumframes.dispatch(a))},dispose:function(){this.frameCache=
[];this._disposed=!0;this.player&&this.player.stop()},setPlayer:function(a){this.player=a;this.signals.playerChanged.dispatch(a)},getPath:function(a,b){NGL.error("Trajectory.getPath not implemented")},download:function(a){for(var b=this,c=this.numframes,d=Math.ceil(c/a),e=0,f=new Float32Array(d*(9+3*this.atomCount)),g=0;g<c;g+=a)this.loadFrame(g,function(){var a=g,c=e,l=c*(9+3*b.atomCount);f.set(b.boxCache[a],l);f.set(b.frameCache[a],l+9);c===d-1&&(a=new Blob([f],{type:"application/octet-binary"}),
NGL.download(a,"traj.bbt"))}),e+=1}};NGL.RemoteTrajectory=function(a,b,c){NGL.Trajectory.call(this,a,b,c)};
NGL.RemoteTrajectory.prototype=NGL.createObject(NGL.Trajectory.prototype,{constructor:NGL.RemoteTrajectory,type:"remote",makeAtomIndices:function(){var a=this.structure,b=[];if(a instanceof NGL.StructureSubset){var a=a.structure.atomIndex(a.selection),c,d,e=a[0],f=a[0],g=a.length;for(c=1;c<g;++c)d=a[c],f+1<d&&(b.push([e,f+1]),e=d),f=d;b.push([e,f+1])}else b.push([0,this.atomCount]);this.atomIndices=b},_loadFrame:function(a,b){var c=new XMLHttpRequest,d=NGL.DatasourceRegistry.trajectory,e=d.getFrameUrl(this.trajPath,
a),d=d.getFrameParams(this.trajPath,this.atomIndices);c.open("POST",e,!0);c.responseType="arraybuffer";c.setRequestHeader("Content-type","application/x-www-form-urlencoded");c.addEventListener("load",function(d){var g=c.response;if(g){d=(new Int32Array(g,0,1))[0];new Float32Array(g,4,1);var h=new Float32Array(g,8,9),g=new Float32Array(g,44);this.process(a,h,g,d);"function"===typeof b&&b()}else NGL.error("empty arrayBuffer for '"+e+"'")}.bind(this),!1);c.send(d)},getNumframes:function(){var a=new THREE.XHRLoader,
b=NGL.DatasourceRegistry.trajectory.getNumframesUrl(this.trajPath);a.load(b,function(a){this.setNumframes(parseInt(a))}.bind(this))},getPath:function(a,b){if(this.pathCache[a])b(this.pathCache[a]);else{NGL.time("loadPath");var c=new XMLHttpRequest,d=NGL.DatasourceRegistry.trajectory.getPathUrl(this.trajPath,a);c.open("POST",d,!0);c.responseType="arraybuffer";c.setRequestHeader("Content-type","application/x-www-form-urlencoded");c.addEventListener("load",function(e){NGL.timeEnd("loadPath");(e=c.response)?
(e=new Float32Array(e),this.pathCache[a]=e,b(e)):NGL.error("empty arrayBuffer for '"+d+"'")}.bind(this),!1);c.send("")}}});NGL.StructureTrajectory=function(a,b,c){NGL.Trajectory.call(this,"",b,c)};
NGL.StructureTrajectory.prototype=NGL.createObject(NGL.Trajectory.prototype,{constructor:NGL.StructureTrajectory,type:"structure",makeAtomIndices:function(){var a=this.structure,b=a.atomSet,c=b.size();if(c<a.atomStore.count){var d=new Int32Array(c);b.forEach(function(a,b){d[b]=a});this.atomIndices=d}else this.atomIndices=null},_loadFrame:function(a,b){var c,d=this.structure.frames[a];if(this.atomIndices){var e=this.atomIndices,f=e.length;c=new Float32Array(3*f);for(var g=0;g<f;++g){var h=3*g,k=3*
e[g];c[h+0]=d[k+0];c[h+1]=d[k+1];c[h+2]=d[k+2]}}else c=new Float32Array(d);this.process(a,this.structure.boxes[a],c,this.structure.frames.length);"function"===typeof b&&b()},getNumframes:function(){this.setNumframes(this.structure.frames.length)},getPath:function(a,b){var c,d,e,f=this.numframes,g=3*a,h=new Float32Array(3*f);for(c=0;c<f;++c)d=3*c,e=this.structure.frames[c],h[d+0]=e[g+0],h[d+1]=e[g+1],h[d+2]=e[g+2];b(h)}});
NGL.FramesTrajectory=function(a,b,c){a instanceof Promise?a.then(function(a){this.setFrames(a);this.getNumframes()}.bind(this)):this.setFrames(a);NGL.Trajectory.call(this,"",b,c)};
NGL.FramesTrajectory.prototype=NGL.createObject(NGL.Trajectory.prototype,{constructor:NGL.FramesTrajectory,type:"frames",setFrames:function(a){this.name=a.name;this.path=a.path;this.frames=a.coordinates;this.boxes=a.boxes},makeAtomIndices:function(){var a=this.structure;this.atomIndices=a instanceof NGL.StructureView?a.structure.atomIndex(a.selection):null},_loadFrame:function(a,b){var c,d=this.frames[a];if(this.atomIndices){var e=this.atomIndices,f=e.length;c=new Float32Array(3*f);for(var g=0;g<
f;++g){var h=3*g,k=3*e[g];c[h+0]=d[k+0];c[h+1]=d[k+1];c[h+2]=d[k+2]}}else c=new Float32Array(d);this.process(a,this.boxes[a],c,this.frames.length);"function"===typeof b&&b()},getNumframes:function(){this.frames&&this.setNumframes(this.frames.length)},getPath:function(a,b){var c,d,e,f=this.numframes,g=3*a,h=new Float32Array(3*f);for(c=0;c<f;++c)d=3*c,e=this.frames[c],h[d+0]=e[g+0],h[d+1]=e[g+1],h[d+2]=e[g+2];b(h)}});
NGL.TrajectoryPlayer=function(a,b,c,d,e){var f=signals;this.signals={startedRunning:new f.Signal,haltedRunning:new f.Signal};a.signals.playerChanged.add(function(a){a!==this&&this.pause()},this);this.traj=a;this.step=b||Math.ceil((a.numframes+1)/100);this.timeout=c||50;this.start=d||0;this.end=e||a.numframes-1;this.end=Math.min(this.end,a.numframes-1);this.interpolateType="";this.interpolateStep=5;this.mode="loop";this.direction="forward";this._running=this._stopFlag=!1};
NGL.TrajectoryPlayer.prototype={constructor:NGL.TrajectoryPlayer,_animate:function(){var a;this._running=!0;if(!this.traj.inProgress&&!this._stopFlag){a="forward"===this.direction?this.traj.currentFrame+this.step:this.traj.currentFrame-this.step;if(a>=this.end||a<this.start)"once"===this.mode?(this.pause(),a="forward"===this.direction?this.end:this.start):a="forward"===this.direction?this.start:this.end;this.interpolateType||this.traj.setFrame(a)}if(this._stopFlag)this._running=!1;else if(!this.traj.inProgress&&
this.interpolateType){var b,c,d;"forward"===this.direction?(b=Math.max(this.start,a-this.step),c=Math.max(this.start,a-2*this.step),d=Math.max(this.start,a-3*this.step)):(b=Math.min(this.end,a+this.step),c=Math.min(this.end,a+2*this.step),d=Math.min(this.end,a+3*this.step));this._interpolate(a,b,c,d,1/this.interpolateStep,0)}else setTimeout(this._animate.bind(this),this.timeout)},_interpolate:function(a,b,c,d,e,f){f+=e;if(1>=f){var g=Math.round(this.timeout*e);this.traj.setFrameInterpolated(a,b,c,
d,f,this.interpolateType,function(){setTimeout(function(){this._interpolate(a,b,c,d,e,f)}.bind(this),g)}.bind(this))}else setTimeout(this._animate.bind(this),0)},toggle:function(){this._running?this.pause():this.play()},play:function(){if(!this._running){this.traj.player!==this&&this.traj.setPlayer(this);var a=this.traj.currentFrame,b=Math.ceil(a/this.step)*this.step;"forward"===this.direction&&a>=this.end?b=this.start:"backward"===this.direction&&a<=this.start&&(b=this.end);this.traj.setFrame(b);
this._stopFlag=!1;this._animate();this.signals.startedRunning.dispatch()}},pause:function(){this._running&&(this._stopFlag=!0,this.signals.haltedRunning.dispatch())},stop:function(){this.traj.setFrame(this.start);this.pause()}};
NGL.Surface=function(a,b,c){this.name=a;this.path=b;this.info={};this.center=new THREE.Vector3;this.boundingBox=new THREE.Box3;c instanceof THREE.Geometry||c instanceof THREE.BufferGeometry||c instanceof THREE.Group?this.fromGeometry(c):c&&this.set(c.position,c.index,c.normal,c.color,c.atomindex)};
NGL.Surface.prototype={constructor:NGL.Surface,type:"Surface",set:function(a,b,c,d,e){this.position=a;this.index=b;this.normal=c;this.color=d;this.atomindex=e;this.size=a.length/3},fromGeometry:function(a){NGL.debug&&NGL.time("NGL.GeometrySurface.fromGeometry");a instanceof THREE.Geometry?(a.computeVertexNormals(!0),a=(new THREE.BufferGeometry).fromGeometry(a)):a=a instanceof THREE.BufferGeometry?a:a.children[0].geometry;a.boundingBox||a.computeBoundingBox();this.center.copy(a.boundingBox.center());
this.boundingBox.copy(a.boundingBox);var b,c,d;a instanceof THREE.BufferGeometry&&(d=a.attributes,b=d.normal?d.normal.array:!1,(!b||0===b[0]&&0===b[1]&&0===b[2])&&a.computeVertexNormals(),b=d.position.array,c=d.index?d.index.array:null,d=d.normal.array);this.set(b,c,d,void 0,void 0);NGL.debug&&NGL.timeEnd("NGL.GeometrySurface.setGeometry")},getPosition:function(){return this.position},getColor:function(a){var b=a||{};a=this.size;var c;if("volume"===b.scheme){var d=new THREE.Vector3,e=this.position,
f=NGL.ColorMakerRegistry.getScheme(b);c=new Float32Array(3*a);for(b=0;b<a;++b){var g=3*b;d.set(e[g],e[g+1],e[g+2]);f.positionColorToArray(d,c,g)}}else if(this.atomindex)for(b.surface=this,c=new Float32Array(3*a),f=NGL.ColorMakerRegistry.getScheme(b),d=b.structure.getAtomProxy(),e=this.atomindex,b=0;b<a;++b)d.index=e[b],f.atomColorToArray(d,c,3*b);else c=new THREE.Color(b.value),c=NGL.Utils.uniformArray3(a,c.r,c.g,c.b);return c},getPickingColor:function(a){a=Object.assign(a||{});a.scheme="picking";
return this.getColor(a)},getNormal:function(){return this.normal},getSize:function(a){return NGL.Utils.uniformArray(this.size,a)},getIndex:function(){return this.index},getFilteredIndex:function(a,b){if(a&&this.atomindex){var c=new NGL.Selection(a),c=b.getAtomSet(c),d=[],e=this.atomindex,f=this.index,g=f.length,h=0;b.getAtomProxy();b.getAtomProxy();b.getAtomProxy();for(var k=0;k<g;k+=3){var l=f[k],m=f[k+1],n=f[k+2],p=e[m],q=e[n];c.has(e[l])&&c.has(p)&&c.has(q)&&(d[h]=l,d[h+1]=m,d[h+2]=n,h+=3)}return new (65535<
this.position.length/3?Uint32Array:Uint16Array)(d)}return this.index},getAtomindex:function(){return this.atomindex},toJSON:function(){return{metadata:{version:.1,type:"Surface",generator:"SurfaceExporter"},name:this.name,path:this.path,info:this.info,position:this.position,index:this.index,normal:this.normal,color:this.color,atomindex:this.atomindex,size:this.size,center:this.center.toArray(),boundingBox:{min:this.boundingBox.min.toArray(),max:this.boundingBox.max.toArray()}}},fromJSON:function(a){this.name=
a.name;this.path=a.path;this.info=a.info;this.position=a.position;this.index=a.index;this.normal=a.normal;this.color=a.color;this.atomindex=a.atomindex;this.size=a.size;this.center.fromArray(a.center);this.boundingBox.set(a.boundingBox.min,a.boundingBox.max);return this},getTransferable:function(){var a=[];this.position&&a.push(this.position.buffer);this.index&&a.push(this.index.buffer);this.normal&&a.push(this.normal.buffer);this.color&&a.push(this.color.buffer);this.atomindex&&a.push(this.atomindex.buffer);
return a},dispose:function(){}};
NGL.Grid=function(a,b,c,d,e){function f(a,d,f){return((a*b+d)*c+f)*e}d=d||Int32Array;e=e||1;var g,h=new d(a*b*c*e);this.data=h;this.index=f;this.set=function(a,b,c){var d=f(a,b,c);for(g=0;g<e;++g)h[d+g]=arguments[3+g]};this.toArray=function(a,b,c,d,p){a=f(a,b,c);void 0===d&&(d=[]);for(g=0;g<e;++g)d[g]=h[a+g]};this.fromArray=function(a,b,c,d,p){a=f(a,b,c);void 0===p&&(p=0);for(g=0;g<e;++g)h[a+g]=d[p+g]};this.copy=function(a){this.data.set(a.data)};this.clone=function(){return(new NGL.Grid(a,b,c,d,
e)).copy(this)}};NGL.WorkerRegistry.add("surf",function(a,b){NGL.debug&&NGL.time("WORKER surf");void 0===self.vol&&(self.vol=new NGL.Volume);var c=self.vol,d=a.data,e=d.params;d.vol&&c.fromJSON(d.vol);if(e)var f=c.getSurface(e.isolevel,e.smooth,e.center,e.size);NGL.debug&&NGL.timeEnd("WORKER surf");e?b(f.toJSON(),f.getTransferable()):b()});
NGL.Volume=function(a,b,c,d,e,f,g){this.name=a;this.path=b;this.matrix=new THREE.Matrix4;this.normalMatrix=new THREE.Matrix3;this.inverseMatrix=new THREE.Matrix4;this.center=new THREE.Vector3;this.boundingBox=new THREE.Box3;this.setData(c,d,e,f,g);this.__data.length<=Math.pow(10,7)&&NGL.GidPool.addObject(this)};
NGL.Volume.prototype={constructor:NGL.Volume,type:"Volume",setData:function(a,b,c,d,e){this.nx=b||1;this.ny=c||1;this.nz=d||1;this.__data=this.data=a||new Float32Array(1);this.setDataAtomindex(e);delete this.mc;delete this.__isolevel;delete this.__smooth;delete this.__minValue;delete this.__maxValue;delete this.__dataPositionBuffer;delete this.__dataPosition;delete this.__dataBuffer;delete this.__dataMin;delete this.__dataMax;delete this.__dataMean;delete this.__dataRms;this.worker&&this.worker.terminate();
this.__data.length<=Math.pow(10,7)?NGL.GidPool.updateObject(this,!0):(NGL.warn("Volume too large (>10^7), not adding to GidPool"),NGL.GidPool.removeObject(this))},setMatrix:function(a){this.matrix.copy(a);a=this.boundingBox;var b=this.center,c=this.nx-1,d=this.ny-1,e=this.nz-1;a.makeEmpty();a.expandByPoint(b.set(c,d,e));a.expandByPoint(b.set(c,d,0));a.expandByPoint(b.set(c,0,e));a.expandByPoint(b.set(c,0,0));a.expandByPoint(b.set(0,d,e));a.expandByPoint(b.set(0,0,e));a.expandByPoint(b.set(0,d,0));
a.expandByPoint(b.set(0,0,0));a.applyMatrix4(this.matrix);a.center(this.center);c=this.matrix.elements;a=new THREE.Vector3(c[0],c[1],c[2]);b=new THREE.Vector3(c[4],c[5],c[6]);c=new THREE.Vector3(c[8],c[9],c[10]);d=new THREE.Vector3;e=this.normalMatrix.elements;d.crossVectors(b,c);e[0]=d.x;e[1]=d.y;e[2]=d.z;d.crossVectors(c,a);e[3]=d.x;e[4]=d.y;e[5]=d.z;d.crossVectors(a,b);e[6]=d.x;e[7]=d.y;e[8]=d.z;this.inverseMatrix.getInverse(this.matrix)},setDataAtomindex:function(a){this.__dataAtomindex=this.dataAtomindex=
a;delete this.__dataAtomindexBuffer},getBox:function(a,b,c){c||(c=new THREE.Box3);c.set(a,a);c.expandByScalar(b);c.applyMatrix4(this.inverseMatrix);c.min.round();c.max.round();return c},getSurface:function(a,b,c,d){a=isNaN(a)?this.getValueForSigma(2):a;b=b||0;void 0===this.mc&&(this.mc=new NGL.MarchingCubes2(this.__data,this.nx,this.ny,this.nz,this.__dataAtomindex));var e;c&&d&&(this.__box||(this.__box=new THREE.Box3),e=this.__box,this.getBox(c,d,e));b?(c=this.mc.triangulate(a,!0,e),NGL.laplacianSmooth(c.position,
c.index,b,!0),d=new THREE.BufferGeometry,d.addAttribute("position",new THREE.BufferAttribute(c.position,3)),d.setIndex(new THREE.BufferAttribute(c.index,1)),d.computeVertexNormals(),c.normal=d.attributes.normal.array,d.dispose()):c=this.mc.triangulate(a,!1,e);this.matrix.applyToVector3Array(c.position);c.normal&&this.normalMatrix.applyToVector3Array(c.normal);c=new NGL.Surface("","",c);c.info.isolevel=a;c.info.smooth=b;return c},getSurfaceWorker:function(a,b,c,d,e){a=isNaN(a)?this.getValueForSigma(2):
a;b=b||0;if("undefined"!==typeof Worker&&"function"!==typeof importScripts){void 0===this.workerPool&&(this.workerPool=new NGL.WorkerPool("surf",2));var f=this.workerPool.getNextWorker();f.post({vol:0===f.postCount?this.toJSON():null,params:{isolevel:a,smooth:b,center:c,size:d}},void 0,function(a){a=NGL.fromJSON(a.data);e(a)},function(f){console.warn("NGL.Volume.generateSurfaceWorker error - trying without worker",f);f=this.getSurface(a,b,c,d);e(f)}.bind(this))}else f=this.getSurface(a,b,c,d),e(f)},
getValueForSigma:function(a){a=void 0!==a?a:2;return this.getDataMean()+a*this.getDataRms()},getSigmaForValue:function(a){return((void 0!==a?a:0)-this.getDataMean())/this.getDataRms()},filterData:function(a,b,c){isNaN(a)&&this.header&&(a=this.header.DMEAN+2*this.header.ARMS);a=void 0===a||isNaN(a)?-Infinity:a;b=void 0!==b?b:Infinity;c=c||!1;this.dataPosition||this.makeDataPosition();var d=this.__dataPosition,e=this.__data;if(a!==this.__minValue||b!=this.__maxValue||c!==this.__outside){if(-Infinity===
a&&Infinity===b)this.dataPosition=d,this.data=e;else{var f=e.length;this.__dataBuffer||(this.__dataPositionBuffer=new ArrayBuffer(12*f),this.__dataBuffer=new ArrayBuffer(4*f));for(var g=new Float32Array(this.__dataPositionBuffer),h=new Float32Array(this.__dataBuffer),k=0,l=0;l<f;++l){var m=3*l,n=e[l];if(!c&&n>=a&&n<=b||c&&(n<a||n>b)){var p=3*k;g[p+0]=d[m+0];g[p+1]=d[m+1];g[p+2]=d[m+2];h[k]=n;k+=1}}this.dataPosition=new Float32Array(this.__dataPositionBuffer,0,3*k);this.data=new Float32Array(this.__dataBuffer,
0,k)}this.__minValue=a;this.__maxValue=b;this.__outside=c}},makeDataPosition:function(){for(var a=this.nz,b=this.ny,c=this.nx,d=new Float32Array(c*b*a*3),e=0,f=0;f<a;++f)for(var g=0;g<b;++g)for(var h=0;h<c;++h)d[e+0]=h,d[e+1]=g,d[e+2]=f,e+=3;this.matrix.applyToVector3Array(d);this.__dataPosition=this.dataPosition=d},getDataAtomindex:function(){return this.dataAtomindex},getDataPosition:function(){return this.dataPosition},getDataColor:function(a){a=a||{};a.volume=this;a.scale=a.scale||"Spectral";
a.domain=a.domain||[this.getDataMin(),this.getDataMax()];a=NGL.ColorMakerRegistry.getScheme(a);for(var b=this.dataPosition.length/3,c=new Float32Array(3*b),d=0;d<b;++d)a.volumeColorToArray(d,c,3*d);return c},getPickingDataColor:function(a){a=Object.assign(a||{});a.scheme="picking";return this.getDataColor(a)},getDataSize:function(a,b){var c=this.dataPosition.length/3,d;switch(a){case "value":d=new Float32Array(this.data);break;case "abs-value":d=new Float32Array(this.data);for(var e=0;e<c;++e)d[e]=
Math.abs(d[e]);break;case "value-min":d=new Float32Array(this.data);for(var f=this.getDataMin(),e=0;e<c;++e)d[e]-=f;break;case "deviation":d=new Float32Array(this.data);break;default:d=NGL.Utils.uniformArray(c,a)}if(1!==b)for(e=0;e<c;++e)d[e]*=b;return d},getDataMin:function(){if(void 0===this.__dataMin){for(var a=this.__data,b=a.length,c=Infinity,d=0;d<b;++d)c=Math.min(c,a[d]);this.__dataMin=c}return this.__dataMin},getDataMax:function(){if(void 0===this.__dataMax){for(var a=this.__data,b=a.length,
c=-Infinity,d=0;d<b;++d)c=Math.max(c,a[d]);this.__dataMax=c}return this.__dataMax},getDataMean:function(){if(void 0===this.__dataMean){for(var a=this.__data,b=a.length,c=0,d=0;d<b;++d)c+=a[d];this.__dataMean=c/b}return this.__dataMean},getDataRms:function(){if(void 0===this.__dataRms){var a=this.__data,b=a.length,c=0,d,e;for(e=0;e<b;++e)d=a[e],c+=d*d;this.__dataRms=Math.sqrt(c/b)}return this.__dataRms},clone:function(){var a=new NGL.Volume(this.name,this.path,this.__data,this.nx,this.ny,this.nz,this.__dataAtomindex);
a.matrix.copy(this.matrix);this.header&&(a.header=Object.assign({},this.header));return a},toJSON:function(){var a={metadata:{version:.1,type:"Volume",generator:"VolumeExporter"},name:this.name,path:this.path,data:this.__data,nx:this.nx,ny:this.ny,nz:this.nz,dataAtomindex:this.__dataAtomindex,matrix:this.matrix.toArray(),normalMatrix:this.normalMatrix.toArray(),inverseMatrix:this.inverseMatrix.toArray(),center:this.center.toArray(),boundingBox:{min:this.boundingBox.min.toArray(),max:this.boundingBox.max.toArray()}};
this.header&&(a.header=Object.assign({},this.header));return a},fromJSON:function(a){this.name=a.name;this.path=a.path;this.setData(a.data,a.nx,a.ny,a.nz,a.dataAtomindex);this.matrix.fromArray(a.matrix);this.normalMatrix.fromArray(a.normalMatrix);this.inverseMatrix.fromArray(a.inverseMatrix);a.header&&(this.header=Object.assign({},a.header));this.center.fromArray(a.center);this.boundingBox.set(a.boundingBox.min,a.boundingBox.max);return this},getTransferable:function(){var a=[this.__data.buffer];
this.__dataAtomindex&&a.push(this.__dataAtomindex.buffer);return a},dispose:function(){this.workerPool&&this.workerPool.terminate();NGL.GidPool.removeObject(this)}};
NGL.MarchingCubes=function(a,b,c,d,e){NGL.debug&&NGL.time("NGL.MarchingCubes");d=new Int32Array([b,c,d]);var f=NGL.MarchingCubes.edgeTable,g=NGL.MarchingCubes.triTable,h=NGL.MarchingCubes.cubeVerts,k=NGL.MarchingCubes.edgeIndex;b=[];c=[];var l=0,m=0,n=0,p=new Float32Array(8),q=new Int32Array(12),r=new Int32Array(3);for(r[2]=0;r[2]<d[2]-1;++r[2],n+=d[0])for(r[1]=0;r[1]<d[1]-1;++r[1],++n)for(r[0]=0;r[0]<d[0]-1;++r[0],++n){for(var t=0,v=0;8>v;++v){var w=h[v],w=a[n+w[0]+d[0]*(w[1]+d[1]*w[2])]-e;p[v]=
w;t|=0<w?1<<v:0}w=f[t];if(0!==w){for(v=0;12>v;++v)if(0!==(w&1<<v)){q[v]=l/3;var u=k[v],B=h[u[0]],s=h[u[1]],z=p[u[0]],u=z-p[u[1]],x=0;1E-6<Math.abs(u)&&(x=z/u);b[l+0]=r[0]+B[0]+x*(s[0]-B[0]);b[l+1]=r[1]+B[1]+x*(s[1]-B[1]);b[l+2]=r[2]+B[2]+x*(s[2]-B[2]);l+=3}t=g[t];for(v=0;v<t.length;v+=3)c[m+0]=q[t[v+0]],c[m+1]=q[t[v+1]],c[m+2]=q[t[v+2]],m+=3}}NGL.debug&&NGL.timeEnd("NGL.MarchingCubes");a=65535<b.length/3?Uint32Array:Uint16Array;return{position:new Float32Array(b),normal:void 0,index:new a(c)}};
NGL.MarchingCubes2=function(a,b,c,d,e){function f(a,b,c){return a+(b-a)*c}function g(a,b,c,d,g,h,k){if(0>B[a]){h=(q-h)/(k-h);k=u;var l=3*s;y[l+0]=c+h;y[l+1]=d;y[l+2]=g;r||(c=3*a,A[l]=-f(k[c],k[c+3],h),A[l+1]=-f(k[c+1],k[c+4],h),A[l+2]=-f(k[c+2],k[c+5],h));e&&(H[s]=e[a+h]);B[a]=s;x[b]=s;s+=1}else x[b]=B[a]}function h(a,b,c,d,g,h,k){if(0>B[a]){h=(q-h)/(k-h);k=u;var l=3*s;y[l]=c;y[l+1]=d+h;y[l+2]=g;r||(c=3*a,d=c+3*v,A[l]=-f(k[c],k[d],h),A[l+1]=-f(k[c+1],k[d+1],h),A[l+2]=-f(k[c+2],k[d+2],h));e&&(H[s]=
e[a+h*v]);B[a]=s;x[b]=s;s+=1}else x[b]=B[a]}function k(a,b,c,d,g,h,k){if(0>B[a]){h=(q-h)/(k-h);k=u;var l=3*s;y[l]=c;y[l+1]=d;y[l+2]=g+h;r||(c=3*a,d=c+3*w,A[l]=-f(k[c],k[d],h),A[l+1]=-f(k[c+1],k[d+1],h),A[l+2]=-f(k[c+2],k[d+2],h));e&&(H[s]=e[a+h*w]);B[a]=s;x[b]=s;s+=1}else x[b]=B[a]}function l(b){var c=3*b;0===u[c]&&(u[c]=a[b-1]-a[b+1],u[c+1]=a[b-v]-a[b+v],u[c+2]=a[b-w]-a[b+w])}function m(e,f,m,t,s,u){var y,D,G,A,H,$;e=void 0!==e?e:0;f=void 0!==f?f:0;m=void 0!==m?m:0;t=void 0!==t?t:b-1;s=void 0!==
s?s:c-1;u=void 0!==u?u:d-1;r?(e=Math.max(0,e),f=Math.max(0,f),m=Math.max(0,m),t=Math.min(b-1,t),s=Math.min(c-1,s),u=Math.min(d-1,u)):(e=Math.max(1,e),f=Math.max(1,f),m=Math.max(1,m),t=Math.min(b-2,t),s=Math.min(c-2,s),u=Math.min(d-2,u));var Y=Math.max(0,e-2),L=Math.max(0,f-2);D=Math.max(0,m-2);var P=Math.min(b,t+2),Q=Math.min(c,s+2),V=Math.min(d,u+2);for(A=D;A<V;++A)for($=w*A,G=L;G<Q;++G)for(H=$+v*G,D=Y;D<P;++D)y=H+D,B[y]=-1;$=e;Y=f;L=m;P=t;Q=s;V=u;H=!1;for(A=m;A<u;++A){for(G=f;G<s;++G){for(D=e;D<
t;++D)if(y=b*c*A+b*G+D,a[y]>=q){L=A;H=!0;break}if(H)break}if(H)break}H=!1;for(G=f;G<s;++G){for(A=L;A<u;++A){for(D=e;D<t;++D)if(y=b*c*A+b*G+D,a[y]>=q){Y=G;H=!0;break}if(H)break}if(H)break}H=!1;for(D=e;D<t;++D){for(G=Y;G<s;++G){for(A=L;A<u;++A)if(y=b*c*A+b*G+D,a[y]>=q){$=D;H=!0;break}if(H)break}if(H)break}H=!1;for(A=u;A>=m;--A){for(G=s;G>=f;--G){for(D=t;D>=e;--D)if(y=b*c*A+b*G+D,a[y]>=q){V=A;H=!0;break}if(H)break}if(H)break}H=!1;for(G=s;G>=f;--G){for(A=V;A>=m;--A){for(D=t;D>=e;--D)if(y=b*c*A+b*G+D,
a[y]>=q){Q=G;H=!0;break}if(H)break}if(H)break}H=!1;for(D=t;D>=e;--D){for(G=Q;G>=f;--G){for(A=V;A>=m;--A)if(y=b*c*A+b*G+D,a[y]>=q){P=D;H=!0;break}if(H)break}if(H)break}r?(e=Math.max(0,$-1),f=Math.max(0,Y-1),m=Math.max(0,L-1),t=Math.min(b-1,P+1),s=Math.min(c-1,Q+1),u=Math.min(d-1,V+1)):(e=Math.max(1,$-1),f=Math.max(1,Y-1),m=Math.max(1,L-1),t=Math.min(b-2,P+1),s=Math.min(c-2,Q+1),u=Math.min(d-2,V+1));for(A=m;A<u;++A)for($=w*A,G=f;G<s;++G)for(H=$+v*G,D=e;D<t;++D){y=H+D;m=D;var Y=G,L=A,P=y,Q=P+1,V=P+v,
aa=P+w,da=Q+v,E=Q+w,X=P+v+w,N=Q+v+w;y=0;var I=a[P],C=a[Q],F=a[V],ba=a[da],fa=a[aa],ca=a[E],ga=a[X],ia=a[N];I<q&&(y|=1);C<q&&(y|=2);F<q&&(y|=8);ba<q&&(y|=4);fa<q&&(y|=16);ca<q&&(y|=32);ga<q&&(y|=128);ia<q&&(y|=64);var ea=n[y];if(0!==ea){var ja=m+1,ka=Y+1,ha=L+1;ea&1&&(r||(l(P),l(Q)),g(P,0,m,Y,L,I,C));ea&2&&(r||(l(Q),l(da)),h(Q,1,ja,Y,L,C,ba));ea&4&&(r||(l(V),l(da)),g(V,2,m,ka,L,F,ba));ea&8&&(r||(l(P),l(V)),h(P,3,m,Y,L,I,F));ea&16&&(r||(l(aa),l(E)),g(aa,4,m,Y,ha,fa,ca));ea&32&&(r||(l(E),l(N)),h(E,5,
ja,Y,ha,ca,ia));ea&64&&(r||(l(X),l(N)),g(X,6,m,ka,ha,ga,ia));ea&128&&(r||(l(aa),l(X)),h(aa,7,m,Y,ha,fa,ga));ea&256&&(r||(l(P),l(aa)),k(P,8,m,Y,L,I,fa));ea&512&&(r||(l(Q),l(E)),k(Q,9,ja,Y,L,C,ca));ea&1024&&(r||(l(da),l(N)),k(da,10,ja,ka,L,ba,ia));ea&2048&&(r||(l(V),l(X)),k(V,11,m,ka,L,F,ga));y<<=4;L=Y=m=void 0;for(P=0;-1!=p[y+P];)m=y+P,Y=m+1,L=m+2,M[z]=x[p[Y]],M[z+1]=x[p[m]],M[z+2]=x[p[L]],z+=3,P+=3}}}var n=NGL.MarchingCubes.edgeTable,p=NGL.MarchingCubes.triTable,q=0,r=!1,t=b*c*d,v=b,w=b*c,u,B,s,z,
x=new Int32Array(12),y=[],A=[],M=[],H=[];this.triangulate=function(a,b,c){NGL.debug&&NGL.time("NGL.MarchingCubes2.triangulate");q=a;(r=b)||u||(u=new Float32Array(3*t));B||(B=new Int32Array(t));z=s=0;void 0!==c?(c.min.round(),c.max.round(),m(c.min.x,c.min.y,c.min.z,c.max.x,c.max.y,c.max.z)):m();y.length=3*s;r||(A.length=3*s);M.length=z;e&&(H.length=s);NGL.debug&&NGL.timeEnd("NGL.MarchingCubes2.triangulate");a=65535<y.length/3?Uint32Array:Uint16Array;return{position:new Float32Array(y),normal:r?void 0:
new Float32Array(A),index:new a(M),atomindex:e?new Int32Array(H):void 0}}};
NGL.MarchingCubes.edgeTable=new Uint32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,
1881,1107,1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,
1958,170,419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
NGL.MarchingCubes.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,
9,0,2,8,4,7,-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,
-1,5,4,8,5,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,
-1,-1,-1,-1,-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,
2,3,11,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,
-1,-1,-1,-1,-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,
-1,-1,-1,-1,10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,
-1,-1,-1,-1,6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,
1,-1,-1,-1,-1,8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,
-1,-1,-1,-1,7,2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,
2,10,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,
3,4,9,5,11,7,6,-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,
6,10,7,3,7,10,-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,
5,3,7,5,-1,-1,-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,
0,11,3,4,5,11,2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,
1,10,11,1,11,4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
4,8,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,
-1,-1,-1,1,10,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);NGL.MarchingCubes.cubeVerts=[[0,0,0],[1,0,0],[1,1,0],[0,1,0],[0,0,1],[1,0,1],[1,1,1],[0,1,1]];NGL.MarchingCubes.edgeIndex=[[0,1],[1,2],[2,3],[3,0],[4,5],[5,6],[6,7],[7,4],[0,4],[1,5],[2,6],[3,7]];
NGL.laplacianSmooth=function(a,b,c,d){NGL.debug&&NGL.time("NGL.laplacianSmooth");c=c||1;d=d||!0;var e=a.length/3,f=b.length/3;if(d){var g=new THREE.BufferGeometry;g.addAttribute("position",new THREE.BufferAttribute(a,3));g.setIndex(new THREE.BufferAttribute(b,1))}for(var h=new Float32Array(3*e),k=Array(20),l=0;20>l;++l)k[l]=new Uint32Array(e);for(l=0;l<e;++l)k[0][l]=0;for(var m,n,p,l=0;l<f;++l){var q=3*l,r=3*l+1,t=3*l+2;p=!0;m=0;for(n=k[0][b[q]];m<n;++m)if(b[r]==k[m+1][b[q]]){p=!1;break}p&&(k[0][b[q]]++,
k[k[0][b[q]]][b[q]]=b[r]);p=!0;m=0;for(n=k[0][b[q]];m<n;++m)if(b[t]==k[m+1][b[q]]){p=!1;break}p&&(k[0][b[q]]++,k[k[0][b[q]]][b[q]]=b[t]);p=!0;m=0;for(n=k[0][b[r]];m<n;++m)if(b[q]==k[m+1][b[r]]){p=!1;break}p&&(k[0][b[r]]++,k[k[0][b[r]]][b[r]]=b[q]);p=!0;m=0;for(n=k[0][b[r]];m<n;++m)if(b[t]==k[m+1][b[r]]){p=!1;break}p&&(k[0][b[r]]++,k[k[0][b[r]]][b[r]]=b[t]);p=!0;for(m=0;m<k[0][b[t]];++m)if(b[q]==k[m+1][b[t]]){p=!1;break}p&&(k[0][b[t]]++,k[k[0][b[t]]][b[t]]=b[q]);p=!0;m=0;for(n=k[0][b[t]];m<n;++m)if(b[r]==
k[m+1][b[t]]){p=!1;break}p&&(k[0][b[t]]++,k[k[0][b[t]]][b[t]]=b[r])}f=.75/4.5;for(n=0;n<c;++n){for(l=0;l<e;++l)if(b=3*l,q=k[0][l],3>q)h[b]=a[b],h[b+1]=a[b+1],h[b+2]=a[b+2];else{if(3===q||4===q){h[b]=0;h[b+1]=0;for(m=h[b+2]=0;m<q;++m)p=3*k[m+1][l],h[b]+=a[p],h[b+1]+=a[p+1],h[b+2]+=a[p+2];h[b]+=.5*a[b];h[b+1]+=.5*a[b+1];h[b+2]+=.5*a[b+2];m=.5+q}else{h[b]=0;h[b+1]=0;for(m=h[b+2]=0;m<q;++m)p=3*k[m+1][l],h[b]+=a[p],h[b+1]+=a[p+1],h[b+2]+=a[p+2];h[b]+=1*a[b];h[b+1]+=1*a[b+1];h[b+2]+=1*a[b+2];m=1+q}h[b]/=
m;h[b+1]/=m;h[b+2]/=m}a.set(h);if(d)for(g.computeVertexNormals(),l=g.attributes.normal.array,m=3*e,b=0;b<m;b+=3)a[b]+=-1*f*l[b],a[b+1]+=-1*f*l[b+1],a[b+2]+=-1*f*l[b+2]}d&&g.dispose();NGL.debug&&NGL.timeEnd("NGL.laplacianSmooth")};
NGL.WorkerRegistry.add("molsurf",function(a,b){NGL.debug&&NGL.time("WORKER molsurf");var c=a.data,d=c.params;c.structure&&("Structure"===c.structure.metadata.type?self.molsurf=new NGL.MolecularSurface((new NGL.Structure).fromJSON(c.structure)):"StructureView"===c.structure.metadata.type?self.molsurf=new NGL.MolecularSurface((new NGL.StructureView).fromJSON(c.structure)):console.error("wrong type"));c=self.molsurf.getSurface(d);NGL.debug&&NGL.timeEnd("WORKER molsurf");b(c.toJSON(),c.getTransferable())});
NGL.MolecularSurface=function(a){this.structure=a};
NGL.MolecularSurface.prototype={getSurface:function(a){a=a||{};var b=(new NGL.EDTSurface(this.structure)).getVolume(a.type,a.probeRadius,a.scaleFactor,a.lowRes,a.cutoff),c=b.getSurface(1,a.smooth);c.info.type=a.type;c.info.probeRadius=a.probeRadius;c.info.scaleFactor=a.scaleFactor;c.info.smooth=a.smooth;c.info.lowRes=a.lowRes;c.info.cutoff=a.cutoff;b.dispose();return c},getSurfaceWorker:function(a,b){var c=Object.assign({},a);if("undefined"!==typeof Worker&&"function"!==typeof importScripts){var d=
void 0;void 0===this.worker&&(d=this.structure.toJSON(),this.worker=new NGL.Worker("molsurf"));this.worker.post({structure:d,params:c},void 0,function(a){a=NGL.fromJSON(a.data);b(a)}.bind(this),function(a){console.warn("NGL.MolecularSurface.generateSurfaceWorker error - trying without worker",a);this.worker.terminate();this.worker=void 0;a=this.getSurface(c);b(a)}.bind(this))}else d=this.getSurface(c),b(d)},dispose:function(){this.worker&&this.worker.terminate()}};
NGL.EDTSurface=function(a){function b(a){var b,c,d,e,f,g,l,m;for(m in A)if(b=A[m],!v[m]){c=a?(b+h)*k+.5:b*k+.5;b=c*c;f=Math.floor(c)+1;g=new Int32Array(f*f);for(c=l=0;c<f;++c)for(d=0;d<f;++d)e=c*c+d*d,e>b?g[l]=-1:(e=Math.sqrt(b-e),g[l]=Math.floor(e)),++l;w[m]=f;v[m]=g}}function c(b){NGL.debug&&NGL.time("NGL.EDTSurface fillvoxels");var c,d;c=0;for(d=s.length;c<d;++c)s[c]=0,b&&(z[c]=-1),B&&(x[c]=-1);a.eachSelectedAtom(function(a){a=a.index;var b,c,d,e,h,l,m,r,u,A,z,H,W,O,R;f.index=a;if(!M||M.test(f)){b=
Math.floor(.5+k*(f.x+t.x));c=Math.floor(.5+k*(f.y+t.y));d=Math.floor(.5+k*(f.z+t.z));m=f[y];var E=v[m],X=0,N=p*q,I=w[m],C;for(A=0;A<I;++A)for(z=0;z<I;++z){C=E[X];if(-1!=C)for(W=-1;2>W;++W)for(O=-1;2>O;++O)for(R=-1;2>R;++R)if(0!==W&&0!==O&&0!==R)for(m=W*A,u=R*z,H=0;H<=C;++H)if(r=H*O,e=b+m,h=c+r,l=d+u,!(0>e||0>h||0>l||e>=n||h>=p||l>=q)){var F=e*N+h*q+l;B?s[F]&1?s[F]&1&&(g.index=x[F],g.index!==f.index&&(e=b+m-Math.floor(.5+k*(g.x+t.x)),h=c+r-Math.floor(.5+k*(g.y+t.y)),l=d+u-Math.floor(.5+k*(g.z+t.z)),
m*m+r*r+u*u<e*e+h*h+l*l&&(x[F]=a))):(s[F]|=1,x[F]=a):s[F]|=1}X++}}});c=0;for(d=s.length;c<d;++c)s[c]&1&&(s[c]|=2);NGL.debug&&NGL.timeEnd("NGL.EDTSurface fillvoxels")}function d(){var b,c;b=0;for(c=s.length;b<c;++b)s[b]&=-3;a.eachSelectedAtom(function(a){var b,c,d,e,h,l=0,m,r,u,A,z,H,O,R,aa,da;f.index=a.index;if(!M||M.test(f)){a=Math.floor(.5+k*(f.x+t.x));b=Math.floor(.5+k*(f.y+t.y));c=Math.floor(.5+k*(f.z+t.z));var E=f[y],X=p*q;A=0;for(da=w[E];A<da;++A)for(z=0;z<da;++z){if(-1!=v[E][l])for(O=-1;2>
O;++O)for(R=-1;2>R;++R)for(aa=-1;2>aa;++aa)if(0!==O&&0!==R&&0!==aa)for(m=O*A,u=aa*z,H=0;H<=v[E][l];++H)if(r=H*R,d=a+m,e=b+r,h=c+u,!(0>d||0>e||0>h||d>=n||e>=p||h>=q)){var N=d*X+e*q+h;s[N]&2?B&&(g.index=x[N],d=Math.floor(.5+k*(g.x+t.x)),e=Math.floor(.5+k*(g.y+t.y)),h=Math.floor(.5+k*(g.z+t.z)),m*m+r*r+u*u<d*d+e*e+h*h&&(x[N]=f.index)):(s[N]|=2,B&&(x[N]=f.index))}l++}}})}var e=a.getBoundingBox(),f=a.getAtomProxy(),g=a.getAtomProxy(),h,k,l,m,n,p,q,r,t,v,w,u,B,s,z,x,y,A,M,H=[new Int32Array([1,0,0]),new Int32Array([-1,
0,0]),new Int32Array([0,1,0]),new Int32Array([0,-1,0]),new Int32Array([0,0,1]),new Int32Array([0,0,-1]),new Int32Array([1,1,0]),new Int32Array([1,-1,0]),new Int32Array([-1,1,0]),new Int32Array([-1,-1,0]),new Int32Array([1,0,1]),new Int32Array([1,0,-1]),new Int32Array([-1,0,1]),new Int32Array([-1,0,-1]),new Int32Array([0,1,1]),new Int32Array([0,1,-1]),new Int32Array([0,-1,1]),new Int32Array([0,-1,-1]),new Int32Array([1,1,1]),new Int32Array([1,1,-1]),new Int32Array([1,-1,1]),new Int32Array([-1,1,1]),
new Int32Array([1,-1,-1]),new Int32Array([-1,-1,1]),new Int32Array([-1,1,-1]),new Int32Array([-1,-1,-1])];this.getVolume=function(a,f,g,J,Z,K){NGL.debug&&NGL.time("NGL.EDTSurface.getVolume");K="vws"!==a;h=f||1.4;k=g||2;m=J||!1;B=!0;m?(y="resname",A=NGL.ResidueRadii,M=new NGL.Selection(".CA")):(y="element",A=NGL.VdwRadii,M=void 0);f=0;for(var U in A)f=Math.max(f,A[U]);U=NGL.getSurfaceGrid(e,f,k,K?h:0);n=U.dim.x;p=U.dim.y;q=U.dim.z;r=U.matrix;t=U.tran;k=U.scaleFactor;v={};w={};b(K);u=h*k;l=Z?Z:Math.max(.1,
-1.2+k*h);s=new Uint8Array(n*p*q);K&&(z=new Float64Array(n*p*q));B&&(x=new Int32Array(n*p*q));c(K);f=p*q;for(Z=0;Z<n;++Z)for(K=0;K<q;++K)for(U=0;U<p;++U)if(g=Z*f+U*q+K,s[g]&1)for(J=0;26>J;){var D=Z+H[J][0],G=K+H[J][2],S=U+H[J][1];if(-1<D&&D<n&&-1<S&&S<p&&-1<G&&G<q&&!(s[D*f+S*q+G]&1)){s[g]|=4;break}else J++}if("ms"===a||"ses"===a){NGL.debug&&NGL.time("NGL.EDTSurface fastdistancemap");Z=new NGL.Grid(n,p,q,Uint16Array,3);K=p*q;U=u*u;f=g=0;NGL.debug&&console.log("l, w, h",n,p,q);for(J=0;J<n;++J)for(G=
0;G<p;++G)for(S=0;S<q;++S)D=J*K+G*q+S,s[D]&=-3,s[D]&1&&(s[D]&4?(Z.set(J,G,S,J,G,S),z[D]=0,s[D]|=2,g+=1):f+=1);NGL.debug&&console.log("totalsurfacevox",g);NGL.debug&&console.log("totalinnervox",f);f=new Int32Array(3*g);var T=0;g=new Int32Array(3*g);for(J=D=0;J<n;++J)for(G=0;G<p;++G)for(S=0;S<q;++S)D=J*K+G*q+S,s[D]&4&&(f[T]=J,f[T+1]=G,f[T+2]=S,T+=3,s[D]&=-5);do{J=f;D=Z;G=T;S=g;NGL.debug&&console.log("positin",G/3);var $=T=void 0,Y=void 0,L=void 0,P=void 0,Q=void 0,V=void 0,aa=void 0,da=void 0,E=L=void 0,
E=void 0,X=new Uint16Array(3),N=0;if(0!==G){for(var I=-1,C=-1,F=-1,ba=p*q,V=0,da=G;V<da;V+=3)for(T=J[V],$=J[V+1],Y=J[V+2],D.toArray(T,$,Y,X),aa=0;6>aa;++aa)E=H[aa],I=T+E[0],C=$+E[1],F=Y+E[2],I<n&&-1<I&&C<p&&-1<C&&F<q&&-1<F&&(E=I*ba+q*C+F,s[E]&1&&!(s[E]&2)?(D.fromArray(I,C,F,X),L=I-X[0],P=C-X[1],Q=F-X[2],L=L*L+P*P+Q*Q,z[E]=L,s[E]|=2,s[E]|=4,S[N]=I,S[N+1]=C,S[N+2]=F,N+=3):s[E]&1&&s[E]&2&&(L=I-X[0],P=C-X[1],Q=F-X[2],L=L*L+P*P+Q*Q,L<z[E]&&(D.fromArray(I,C,F,X),z[E]=L,s[E]&4||(s[E]|=4,S[N]=I,S[N+1]=C,
S[N+2]=F,N+=3))));V=0;for(da=G;V<da;V+=3)for(T=J[V],$=J[V+1],Y=J[V+2],D.toArray(T,$,Y,X),aa=6;18>aa;aa++)E=H[aa],I=T+E[0],C=$+E[1],F=Y+E[2],I<n&&-1<I&&C<p&&-1<C&&F<q&&-1<F&&(E=I*ba+q*C+F,s[E]&1&&!(s[E]&2)?(D.fromArray(I,C,F,X),L=I-X[0],P=C-X[1],Q=F-X[2],L=L*L+P*P+Q*Q,z[E]=L,s[E]|=2,s[E]|=4,S[N]=I,S[N+1]=C,S[N+2]=F,N+=3):s[E]&1&&s[E]&2&&(L=I-X[0],P=C-X[1],Q=F-X[2],L=L*L+P*P+Q*Q,L<z[E]&&(D.fromArray(I,C,F,X),z[E]=L,s[E]&4||(s[E]|=4,S[N]=I,S[N+1]=C,S[N+2]=F,N+=3))));V=0;for(da=G;V<da;V+=3)for(T=J[V],
$=J[V+1],Y=J[V+2],D.toArray(T,$,Y,X),aa=18;26>aa;aa++)E=H[aa],I=T+E[0],C=$+E[1],F=Y+E[2],I<n&&-1<I&&C<p&&-1<C&&F<q&&-1<F&&(E=I*ba+q*C+F,s[E]&1&&!(s[E]&2)?(D.fromArray(I,C,F,X),L=I-X[0],P=C-X[1],Q=F-X[2],L=L*L+P*P+Q*Q,z[E]=L,s[E]|=2,s[E]|=4,S[N]=I,S[N+1]=C,S[N+2]=F,N+=3):s[E]&1&&s[E]&2&&(L=I-X[0],P=C-X[1],Q=F-X[2],L=L*L+P*P+Q*Q,L<z[E]&&(D.fromArray(I,C,F,X),z[E]=L,s[E]&4||(s[E]|=4,S[N]=I,S[N+1]=C,S[N+2]=F,N+=3))))}D=N;T=0;NGL.debug&&console.log("positout",D/3);J=0;for(G=D;J<G;J+=3)D=K*g[J]+q*g[J+1]+
g[J+2],s[D]&=-5,z[D]<=1.0404*U&&(f[T]=g[J],f[T+1]=g[J+1],f[T+2]=g[J+2],T+=3)}while(0<T);U=l*l;g=new Uint16Array(3);for(J=0;J<n;++J)for(G=0;G<p;++G)for(S=0;S<q;++S)D=J*K+G*q+S,s[D]&=-5,s[D]&1&&(!(s[D]&2)||s[D]&2&&z[D]>=U)&&(s[D]|=4,B&&s[D]&2&&(Z.toArray(J,G,S,g),f=g[0]*K+g[1]*q+g[2],x[D]=x[f]));NGL.debug&&NGL.timeEnd("NGL.EDTSurface fastdistancemap")}"ses"===a&&(b(!1),d());Z=s.length;if("vws"===a)for(K=0;K<Z;++K)s[K]&=-5,s[K]=s[K]&2?1:0;else if("ms"===a)for(K=0;K<Z;++K)s[K]&=-3,s[K]&4&&(s[K]|=2),s[K]&=
-5,s[K]=s[K]&2?1:0;else if("ses"===a)for(K=0;K<Z;++K)s[K]&4&&s[K]&2?s[K]&=-5:s[K]&4&&!(s[K]&2)&&(s[K]|=2),s[K]=s[K]&2?1:0;else if("sas"===a)for(K=0;K<Z;++K)s[K]&=-5,s[K]=s[K]&2?1:0;a=new NGL.Volume(a,"",s,q,p,n,x);a.setMatrix(r);NGL.debug&&NGL.timeEnd("NGL.EDTSurface.getVolume");return a}};
NGL.getSurfaceGrid=function(a,b,c,d){var e;e=1/c*3+b;b=(new THREE.Vector3).copy(a.min);a=(new THREE.Vector3).copy(a.max);b.subScalar(d+e);a.addScalar(d+e);b.multiplyScalar(c).floor().divideScalar(c);a.multiplyScalar(c).ceil().divideScalar(c);d=(new THREE.Vector3).subVectors(a,b).multiplyScalar(c).ceil().addScalar(1);e=256*Math.pow(10,6);var f=d.x*d.y*d.z*3;e<=f&&(c*=Math.pow(e/f,1/3),b.multiplyScalar(c).floor().divideScalar(c),a.multiplyScalar(c).ceil().divideScalar(c),d.subVectors(a,b).multiplyScalar(c).ceil().addScalar(1));
b=(new THREE.Vector3).copy(b).negate();a=new THREE.Matrix4;a.multiply((new THREE.Matrix4).makeRotationY(THREE.Math.degToRad(90)));a.multiply((new THREE.Matrix4).makeScale(-1/c,1/c,1/c));a.multiply((new THREE.Matrix4).makeTranslation(-c*b.z,-c*b.y,-c*b.x));return{dim:d,tran:b,matrix:a,scaleFactor:c}};
NGL.Script=function(a,b,c){var d=signals;this.signals={elementAdded:new d.Signal,elementRemoved:new d.Signal,nameChanged:new d.Signal};this.name=b;this.path=c;this.dir=c.substring(0,c.lastIndexOf("/")+1);try{this.fn=new Function("stage","panel","__name__","__path__","__dir__",Object.keys(NGL.makeScriptHelper()).join(","),a)}catch(e){NGL.error("NGL.Script compilation failed",e),this.fn=null}};
NGL.Script.prototype={constructor:NGL.Script,call:function(a,b){function c(){"function"===typeof b&&b()}var d={add:function(a){this.signals.elementAdded.dispatch(arguments)}.bind(this),remove:function(a){this.signals.elementRemoved.dispatch(arguments)}.bind(this),setName:function(a){this.signals.nameChanged.dispatch(a)}.bind(this)},e=new NGL.ScriptQueue(a,this.dir,b),f=NGL.makeScriptHelper(a,e,d);if(this.fn){var g=[a,d,this.name,this.path,this.dir];try{var h=[];Object.keys(f).forEach(function(a){h.push(f[a])});
this.fn.apply(null,g.concat(h))}catch(k){NGL.error("NGL.Script.fn",k)}}else NGL.log("NGL.Script.call no function available");e.then(c,function(){d.add(new UI.Text("ERROR"));c()})}};NGL.ScriptQueue=function(a,b,c){this.stage=a;this.dir=b||"";this.onFinish=c;this.promise=new Promise(function(a,b){a()})};
NGL.ScriptQueue.prototype={constructor:NGL.ScriptQueue,load:function(a,b){var c={},d=this.dir+a,e,f=b||{};"function"===typeof b?(e=b,f={}):e=f.onLoad;f.onLoad=function(a){a.requestGuiVisibility(!1);"function"===typeof e&&e(a);c.resolve?c.resolve():c.success=!0};f.onError=function(a){c.reject?c.reject(a):c.error=a||"error"};this.stage.loadFile(d,f);var g=function(a,b){!0===c.success?a():void 0!==c.error?b(c.error):(c.resolve=a,c.reject=b)};this.promise=this.promise.then(function(){return new Promise(g)})},
then:function(a,b){this.promise=this.promise.then(a,function(a){NGL.error("NGL.ScriptQueue.then",a);"function"===typeof b&&b()})}};
NGL.makeScriptHelper=function(a,b,c){function d(a){a.setVisibility(!1)}function e(a,b){b&&d();a.setVisibility(!0)}function f(a){a=void 0===a?1:a;for(var b=0;b<a;++b)c.add(new UI.Break)}var g=NGL.unicodeHelper;return{load:function(){b.load.apply(b,arguments)},then:function(){b.then.apply(b,arguments)},components:function(b){return a.getComponentsByName(b)},representations:function(b){return a.getRepresentationsByName(b)},structures:function(b){return a.getComponentsByName(b,NGL.StructureComponent)},
color:function(a,b){b.setColor(a)},visibility:function(a,b){b.setVisibility(a)},hide:d,show:e,superpose:function(a,b,c,d,e,f,g){a.superpose(b,c,d,e,f,g)},uiText:function(a,b){var d=new UI.Text(g(a));c.add(d);b&&f(1);return d},uiHtml:function(a,b){var d=new UI.Html(g(a));c.add(d);b&&f(1);return d},uiBreak:f,uiSelect:function(a,b){if(Array.isArray(a)){var d={};a.forEach(function(a){d[a]=a});a=d}var e=(new UI.Select).setOptions(a).onChange(function(){b(e)});c.add(e);return e},uiButton:function(a,b){var d=
(new UI.Button(g(a))).onClick(function(){b(d)});c.add(d);return d},uiOpenButton:function(a,b,d){a=(new UI.Button(g(a))).onClick(function(){NGL.open(b,d)});c.add(a);return a},uiDownloadButton:function(a,b,d){a=(new UI.Button(g(a))).onClick(function(){NGL.download(b(),d)});c.add(a);return a},uiVisibilitySelect:function(b){function f(){var a=[];g.forEach(function(b){b.visible&&a.push(b.name)});return a}var g=b.list,m={"":"[show]"};g.forEach(function(a){m[a.name]=a.name;a.signals.visibilityChanged.add(function(){var b=
f();b.length===g.length?n.setValue(""):a.visible?n.setValue(a.name):n.setValue(b[0])})});var n=(new UI.Select).setOptions(m).onChange(function(){var c=n.getValue();""===c?e(b):(d(b),e(a.getAnythingByName(c)))});c.add(n);return n},uiVisibilityButton:function(a,b){function c(){var a=!1;d.forEach(function(b){b.visible&&(a=!0)});return a}a=g(a?a:"all");b=b||new NGL.Collection;b instanceof NGL.Collection||b instanceof NGL.ComponentCollection||b instanceof NGL.RepresentationCollection||(b=new NGL.Collection([b]));
var d=b.list;d.forEach(function(b){b.signals.visibilityChanged.add(function(){e.setLabel((c()?"hide ":"show ")+a)})});var e=(new UI.Button((c()?"hide ":"show ")+a)).onClick(function(){var a=!c();b.setVisibility(a)});return e},uiPlayButton:function(a,b,d,e,f,p){b=b.trajectory;a=g(a);var q=new NGL.TrajectoryPlayer(b,d,e,f,p);q.mode="once";var r=(new UI.Button("play "+a)).onClick(function(){q.toggle()});q.signals.startedRunning.add(function(){r.setLabel("pause "+a)});q.signals.haltedRunning.add(function(){r.setLabel("play "+
a)});c.add(r);return r}}};NGL.Streamer=function(a,b){var c=b||{};this.compressed=void 0!==c.compressed?c.compressed:!1;this.binary=void 0!==c.binary?c.binary:!1;this.src=a;this.chunkSize=10485760;this.newline="\n";this.__pointer=0;this.__partialLine="";this.__srcName&&(this[this.__srcName]=a)};NGL.Streamer.prototype.constructor=NGL.Streamer;
NGL.Streamer.prototype={constructor:NGL.Streamer,type:"",__srcName:void 0,onload:function(){},onprogress:function(){},onerror:function(){},read:function(a){this._read(function(b){this.compressed?this.data=NGL.decompress(b):(this.binary&&b instanceof ArrayBuffer&&(b=new Uint8Array(b)),this.data=b);if("function"===typeof this.onload)this.onload(this.data);a()}.bind(this))},_read:function(a){a(this.src)},_chunk:function(a,b){b=Math.min(this.data.length,b);return 0===a&&this.data.length===b?this.data:
this.binary||this.compressed?this.data.subarray(a,b):this.data.substring(a,b)},chunk:function(a){return this._chunk(a,a+this.chunkSize)},peekLines:function(a){var b=this.data,c=b.length,d=this.binary||this.compressed?this.newline.charCodeAt(0):this.newline,e,f=0;for(e=0;e<c&&(b[e]===d&&++f,f!==a);++e);a=this._chunk(0,e+1);return this.chunkToLines(a,"",e>c).lines},lineCount:function(){console.warn("lineCount");for(var a=this.data,b=a.length,c=this.binary||this.compressed?this.newline.charCodeAt(0):
this.newline,d=0,e=0;e<b;++e)a[e]===c&&++d;a[b-1]!==c&&++d;return d},chunkCount:function(){return Math.floor(this.data.length/this.chunkSize)+1},asText:function(){return this.binary||this.compressed?NGL.Uint8ToString(this.data):this.data},chunkToLines:function(a,b,c){var d=this.newline;if(!this.binary&&!this.compressed&&a.length===this.data.length)return{lines:a.split(d),partialLine:""};a=this.binary||this.compressed?NGL.Uint8ToString(a):a;var e=[],f=a.lastIndexOf(d);-1===f?b+=a:(b+=a.substr(0,f),
e=e.concat(b.split(d)),b=f===a.length-d.length?"":a.substr(f+d.length));c&&""!==b&&e.push(b);return{lines:e,partialLine:b}},nextChunk:function(){var a=this.__pointer;if(!(a>this.data.length))return this.__pointer+=this.chunkSize,this.chunk(a)},nextChunkOfLines:function(){var a=this.nextChunk();if(void 0!==a)return a=this.chunkToLines(a,this.__partialLine,this.__pointer>this.data.length),this.__partialLine=a.partialLine,a.lines},eachChunk:function(a){for(var b=this.chunkSize,c=this.data.length,d=this.chunkCount(),
e=0;e<c;e+=b){var f=this.chunk(e),g=Math.round(e/b);a(f,g,d)}},eachChunkOfLines:function(a){this.eachChunk(function(b,c,d){b=this.chunkToLines(b,this.__partialLine,c===d+1);this.__partialLine=b.partialLine;a(b.lines,c,d)}.bind(this))},toJSON:function(){var a=this.type.substr(0,1).toUpperCase()+this.type.substr(1),a={metadata:{version:.1,type:a+"Streamer",generator:a+"StreamerExporter"},src:this.src,compressed:this.compressed,binary:this.binary,chunkSize:this.chunkSize,newline:this.newline};this.__srcName&&
(a[this.__srcName]=this[this.__srcName]);return a},fromJSON:function(a){this.src=a.src;this.compressed=a.compressed;this.binary=a.binary;this.chunkSize=a.chunkSize;this.newline=a.newline;this.__srcName&&(this[this.__srcName]=a[this.__srcName]);return this},getTransferable:function(){return[]},dispose:function(){delete this.src;this.__srcName&&delete this[this.__srcName]}};NGL.NetworkStreamer=function(a,b){NGL.Streamer.call(this,a,b)};
NGL.NetworkStreamer.prototype=NGL.createObject(NGL.Streamer.prototype,{constructor:NGL.NetworkStreamer,type:"network",__srcName:"url",_read:function(a){var b=this.src;"function"===typeof importScripts&&"../"===b.substr(0,3)&&(b="../"+b);var c=new XMLHttpRequest;c.open("GET",b,!0);c.addEventListener("load",function(b){if(200===c.status||304===c.status||0===c.status)a(c.response);else{if("function"===typeof this.onerror)this.onerror(c.status);throw"NGL.NetworkStreamer._read: status code "+c.status;
}}.bind(this),!1);"function"===typeof this.onerror&&c.addEventListener("error",function(a){this.onerror(a)}.bind(this),!1);if(this.compressed||this.binary)c.responseType="arraybuffer";c.send(null)}});NGL.FileStreamer=function(a,b){NGL.Streamer.call(this,a,b)};
NGL.FileStreamer.prototype=NGL.createObject(NGL.Streamer.prototype,{constructor:NGL.FileStreamer,type:"file",__srcName:"file",_read:function(a){if("function"===typeof importScripts){var b=new FileReaderSync,b=this.binary||this.compressed?b.readAsArrayBuffer(this.file):b.readAsText(this.file);a(b)}else b=new FileReader,b.onload=function(b){a(b.target.result)}.bind(this),"function"===typeof this.onprogress&&(b.onprogress=function(a){this.onprogress(a)}.bind(this)),"function"===typeof this.onerror&&
(b.onerror=function(a){this.onerror(a)}.bind(this)),this.binary||this.compressed?b.readAsArrayBuffer(this.file):b.readAsText(this.file)}});NGL.StringStreamer=function(a,b){NGL.Streamer.call(this,a,b)};NGL.StringStreamer.prototype=NGL.createObject(NGL.Streamer.prototype,{constructor:NGL.StringStreamer,type:"string",__srcName:"str",_chunk:function(a,b){return this.data.substr(a,b)}});NGL.BinaryStreamer=function(a,b){a instanceof ArrayBuffer&&(a=new Uint8Array(a));NGL.Streamer.call(this,a,b)};
NGL.BinaryStreamer.prototype=NGL.createObject(NGL.Streamer.prototype,{constructor:NGL.BinaryStreamer,type:"binary",__srcName:"bin",getTransferable:function(){var a=NGL.Streamer.prototype.getTransferable.call(this);this.bin instanceof Uint8Array&&a.push(this.bin.buffer);return a}});
NGL.reorderAtoms=function(a){NGL.debug&&NGL.time("NGL.reorderAtoms");var b=a.getAtomProxy(),c=a.getAtomProxy();a.atomStore.sort(function(a,e){b.index=a;c.index=e;return b.modelindex<c.modelindex?-1:b.modelindex>c.modelindex?1:b.chainname<c.chainname?-1:b.chainname>c.chainname?1:b.resno<c.resno?-1:b.resno>c.resno?1:0});NGL.debug&&NGL.timeEnd("NGL.reorderAtoms")};
NGL.StructureBuilder=function(a){function b(a){for(var b=n.atomCount[a],c=n.atomOffset[a],d=Array(b),e=0;e<b;++e)d[e]=m.atomTypeId[c+e];n.residueTypeId[a]=r.add(k,d,l)}var c=null,d=null,e=null,f=null,g=null,h=null,k,l,m=a.atomStore,n=a.residueStore,p=a.chainStore,q=a.modelStore,r=a.residueMap,t=-1,v=-1,w=-1,u=-1;this.addAtom=function(a,r,z,x,y,A,M){var H=!1,R=!1,O=!1;if(c!==a)O=R=H=!0,u+=1,w+=1,v+=1;else if(d!==r)O=R=!0,w+=1,v+=1;else if(f!==x||e!==z||g!==M)O=!0,v+=1;t+=1;H&&(q.growIfFull(),q.chainOffset[u]=
w,q.chainCount[u]=0,q.count+=1,p.modelIndex[w]=u);R&&(p.growIfFull(),p.setChainname(w,r),p.residueOffset[w]=v,p.residueCount[w]=0,p.count+=1,p.modelIndex[w]=u,q.chainCount[u]+=1,n.chainIndex[v]=w);O&&(k=e,l=h,0<v&&b(v-1),n.growIfFull(),n.resno[v]=x,void 0!==A&&(n.sstruc[v]=A.charCodeAt(0)),void 0!==M&&(n.inscode[v]=M.charCodeAt(0)),n.atomOffset[v]=t,n.atomCount[v]=0,n.count+=1,n.chainIndex[v]=w,p.residueCount[w]+=1);m.count+=1;m.residueIndex[t]=v;n.atomCount[v]+=1;c=a;d=r;e=z;f=x;g=M;h=y};this.finalize=
function(){k=e;l=h;-1<v&&b(v)}};
NGL.assignSecondaryStructure=function(a){NGL.debug&&NGL.time("NGL.assignSecondaryStructure");var b=[];a.eachModel(function(a){a.eachChain(function(a){b.push(a.chainname)})});var c=b.slice().sort(),d=[];c.forEach(function(a){d.push(b.indexOf(a))});var e=a.helices||[],e=e.filter(function(a){return 0<=NGL.binarySearchIndexOf(c,a[0])});e.sort(function(a,b){var e=a[0],f=b[0],g=a[1],p=b[1];if(e===f)return g===p?0:g<p?-1:1;e=NGL.binarySearchIndexOf(c,e);f=NGL.binarySearchIndexOf(c,f);return d[e]<d[f]?-1:
1});var f=a.residueStore;a.eachModel(function(a){var b=0,c=e.length;if(0!==c){var d=e[b],g=!1,p=!1;a.eachChain(function(a){var h=!1;if(a.chainname===d[0])for(var t=a.residueOffset,v=t+a.residueCount,w=t;w<v&&(f.resno[w]===d[1]&&f.getInscode(w)===d[2]&&(g=!0),g&&(f.sstruc[w]=d[6],f.resno[w]===d[4]&&f.getInscode(w)===d[5]&&(g=!1,b+=1,b<c?(w=t-1,d=e[b],h=a.chainname!==d[0]):p=!0)),!h&&!p);++w);})}});var g=a.sheets||[],g=g.filter(function(a){return 0<=NGL.binarySearchIndexOf(c,a[0])});g.sort(function(a,
b){var e=a[0],f=b[0];if(e===f)return 0;e=NGL.binarySearchIndexOf(c,e);f=NGL.binarySearchIndexOf(c,f);return d[e]<d[f]?-1:1});a.eachModel(function(a){var b=0,c=g.length;if(0!==c){var d=g[b],e=!1,p=!1;a.eachChain(function(a){var h=!1;if(a.chainname===d[0])for(var t=a.residueOffset,v=t+a.residueCount,w=t;w<v&&(f.resno[w]===d[1]&&f.getInscode(w)===d[2]&&(e=!0),e&&(f.sstruc[w]=101,f.resno[w]===d[4]&&f.getInscode(w)===d[5]&&(e=!1,b+=1,b<c?(w=t-1,d=g[b],h=a.chainname!==d[0]):p=!0)),!h&&!p);++w);})}});NGL.debug&&
NGL.timeEnd("NGL.assignSecondaryStructure")};
NGL.calculateSecondaryStructure=function(){var a=function(a,b,c,g){for(var h=a.structure,k=a.residueIndexStart,l=h.getResidueProxy(),m=h.getResidueProxy(),n=h.getAtomProxy(),h=h.getAtomProxy(),p=Math.max(0,b-2);p<=b;++p)for(var q=2;5>q;++q)if(!(p+q>=a.residueCount)){l.index=k+p;m.index=k+p+q;n.index=l.traceAtomIndex;h.index=m.traceAtomIndex;var r=n.distanceTo(h);if(Math.abs(r-c[q-2])>g)return!1}return!0},b=function(b){for(var c=b.residueStore,f=b.residueIndexStart,g=0,h=b.residueCount;g<h;++g){var k=
"c";a(b,g,[5.45,5.18,6.37],2.1)?k="h":a(b,g,[6.1,10.4,13],1.42)&&(k="s");c.sstruc[f+g]=k.charCodeAt(0)}},c=function(a){var b=a.residueStore,c=a.residueIndexStart,g=(new NGL.Helixbundle(a)).position,h=new THREE.Vector3,k=new THREE.Vector3,l=0;for(a=a.residueCount;l<a;++l){h.fromArray(g.center,3*l);k.fromArray(g.center,3*l+3);var m=h.distanceTo(k);2>m&&1<m&&20>g.bending[l]&&(b.sstruc[c+l]=104,b.sstruc[c+l+1]=104)}};return function(a){NGL.debug&&NGL.time("NGL.Structure.autoSS");a.eachPolymer(function(a){if(!(4>
a.residueCount)){if(a.isCg())c(a);else if(a.isProtein())b(a);else return;var d=void 0,g=0;a.eachResidue(function(a){a.sstruc===d?g+=1:(1===g&&(--a.index,a.sstruc="c"),g=1,d=a.sstruc)})}});NGL.debug&&NGL.timeEnd("NGL.Structure.autoSS")}}();
NGL.calculateChainnames=function(a){NGL.debug&&NGL.time("NGL.calculateChainnames");var b=!0;a.eachChain(function(a){a.chainname&&(b=!1)});if(b){var c=a.modelStore,d=a.chainStore,e=a.residueStore,f=a.getAtomProxy(),g=a.getAtomProxy(),h=0,k=0,l=0,m=0,n=[];a.eachResidueN(2,function(a,b){var c=!1,d=a.backboneType,p=b.backboneType,u=NGL.UnknownBackboneType;m=a.index;a.modelIndex!==b.modelIndex?c=!0:a.moleculeType!==b.moleculeType?c=!0:d!==u&&d===p&&(f.index=a.backboneEndAtomIndex,g.index=b.backboneStartAtomIndex,
f.connectedTo(g)||(c=!0));b.index===e.count-1&&(c=!0,m=b.index);if(c){c=h;d=0;for(p="ABCDEFGHIJKLMNOPQRSTUVWXYZ"[c%26];26<=c;)c=Math.floor(c/26),p+="ABCDEFGHIJKLMNOPQRSTUVWXYZ"[c%26],d+=1;n.push({mIndex:k,chainname:p,rStart:l,rCount:m-l+1});h+=1;a.modelIndex!==b.modelIndex&&(h=0,k+=1);5<=d&&(NGL.warn("out of chain names"),h=0);m=l=b.index}});d.count=0;n.forEach(function(a){var b=a.mIndex,f=a.chainname,g=a.rStart;a=a.rCount;for(var h=d.count,k=0;k<a;++k)e.chainIndex[g+k]=h;d.growIfFull();d.modelIndex[h]=
b;d.setChainname(h,f);d.residueOffset[h]=g;d.residueCount[h]=a;d.count+=1;c.chainCount[b]+=1});var p=0;a.eachModel(function(a){c.chainOffset[a.index]=p;--c.chainCount[a.index];p+=c.chainCount[a.index]})}NGL.debug&&NGL.timeEnd("NGL.calculateChainnames")};NGL.calculateBonds=function(a){NGL.debug&&NGL.time("NGL.calculateBonds");NGL.calculateBondsWithin(a);NGL.calculateBondsBetween(a);NGL.debug&&NGL.timeEnd("NGL.calculateBonds")};
NGL.calculateResidueBonds=function(a){var b=a.structure,c=b.getAtomProxy(),b=b.getAtomProxy(),d=a.atomCount,e=a.atomOffset,f=e+d-1;if(500<d)NGL.debug&&NGL.warn("more than 500 atoms, skip residue for auto-bonding",a.qualifiedName());else{var g=[],h=[];if(50<d){d=new NGL.Kdtree(a,!0);a=a.isCg()?1.2:2.3;for(var k=e;k<f;++k){c.index=k;for(var l=c.covalent+a+.3,l=d.nearest(c,Infinity,l*l),m=l.length,n=0;n<m;++n)b.index=l[n].index,c.index<b.index&&c.connectedTo(b)&&(g.push(c.index-e),h.push(b.index-e))}}else for(k=
e;k<f;++k)for(c.index=k,n=k+1;n<=f;++n)b.index=n,c.connectedTo(b)&&(g.push(k-e),h.push(n-e));return{atomIndices1:g,atomIndices2:h}}};
NGL.calculateBondsWithin=function(a,b){NGL.debug&&NGL.time("NGL.calculateBondsWithin");var c=a.bondStore,d=a.rungBondStore,e=a.getAtomSet(!1),f=a.getAtomProxy(),g=a.getAtomProxy();a.eachResidue(function(a){if(!b){var k=a.atomOffset;if(500<a.atomCount){NGL.warn("more than 500 atoms, skip residue for auto-bonding",a.qualifiedName());return}for(var l=a.getBonds(),m=l.atomIndices1,l=l.atomIndices2,n=m.length,p=0;p<n;++p)f.index=m[p]+k,g.index=l[p]+k,c.addBond(f,g)}k=a.residueType.rungEndAtomIndex;-1!==
a.residueType.traceAtomIndex&&-1!==k&&(f.index=a.traceAtomIndex,g.index=a.rungEndAtomIndex,d.addBond(f,g),e.add_unsafe(f.index),e.add_unsafe(g.index))});a.atomSetDict.rung=e;NGL.debug&&NGL.timeEnd("NGL.calculateBondsWithin")};
NGL.calculateBondsBetween=function(a,b){function c(a,c){var k=a.backboneType,l=c.backboneType;k!==NGL.UnknownBackboneType&&k===l&&(g.index=a.backboneEndAtomIndex,h.index=c.backboneStartAtomIndex,g.connectedTo(h)&&(b||d.addBond(g,h),g.index=a.traceAtomIndex,h.index=c.traceAtomIndex,e.addBond(g,h),f.add_unsafe(g.index),f.add_unsafe(h.index)))}NGL.debug&&NGL.time("NGL.calculateBondsBetween");var d=a.bondStore,e=a.backboneBondStore,f=a.getAtomSet(!1),g=a.getAtomProxy(),h=a.getAtomProxy();0===e.count&&
e.resize(a.residueStore.count);a.eachResidueN(2,c);var k=a.getResidueProxy(),l=a.getResidueProxy();a.eachChain(function(a){0!==a.residueCount&&(k.index=a.residueOffset,l.index=a.residueOffset+a.residueCount-1,c(l,k))});a.atomSetDict.backbone=f;NGL.debug&&NGL.timeEnd("NGL.calculateBondsBetween")};
NGL.buildUnitcellAssembly=function(a){function b(a){var b=[];Object.keys(e).forEach(function(k){k=e[k].clone();g.copy(d).applyMatrix4(k);h.setFromMatrixPosition(k);h.sub(f);1<g.x&&--h.x;0>g.x&&(h.x+=1);1<g.y&&--h.y;0>g.y&&(h.y+=1);1<g.z&&--h.z;0>g.z&&(h.z+=1);a&&h.add(a);k.setPosition(h);k.multiplyMatrices(c.fracToCart,k);k.multiply(c.cartToFrac);b.push(k)});return b}NGL.debug&&NGL.time("NGL.buildUnitcellAssembly");var c=a.unitcell,d=a.center.clone().applyMatrix4(c.cartToFrac),e=NGL.getSymmetryOperations(c.spacegroup),
f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3;1<d.x&&--f.x;0>d.x&&(f.x+=1);1<d.y&&--f.y;0>d.y&&(f.y+=1);1<d.z&&--f.z;0>d.z&&(f.z+=1);var k=new NGL.Assembly("UNITCELL"),l=b();if(a.biomolDict.NCS){var m=[],n=a.biomolDict.NCS.partList[0].matrixList;l.forEach(function(a){n.forEach(function(b){m.push(a.clone().multiply(b))})});k.addPart(m)}else k.addPart(l);var p=new THREE.Vector3,l=new NGL.Assembly("SUPERCELL"),p=Array.prototype.concat.call(b(),b(p.set(1,1,1)),b(p.set(-1,-1,-1)),b(p.set(1,
0,0)),b(p.set(1,1,0)),b(p.set(1,0,1)),b(p.set(0,1,0)),b(p.set(0,1,1)),b(p.set(0,0,1)),b(p.set(-1,0,0)),b(p.set(-1,-1,0)),b(p.set(-1,0,-1)),b(p.set(0,-1,0)),b(p.set(0,-1,-1)),b(p.set(0,0,-1)),b(p.set(1,-1,-1)),b(p.set(1,1,-1)),b(p.set(1,-1,1)),b(p.set(-1,1,1)),b(p.set(-1,-1,1)),b(p.set(-1,1,-1)),b(p.set(0,1,-1)),b(p.set(0,-1,1)),b(p.set(1,0,-1)),b(p.set(-1,0,1)),b(p.set(1,-1,0)),b(p.set(-1,1,0)));if(a.biomolDict.NCS){var q=[],n=a.biomolDict.NCS.partList[0].matrixList;p.forEach(function(a){n.forEach(function(b){q.push(a.clone().multiply(b))})});
l.addPart(q)}else l.addPart(p);a.biomolDict.UNITCELL=k;a.biomolDict.SUPERCELL=l;NGL.debug&&NGL.timeEnd("NGL.buildUnitcellAssembly")};NGL.Assembly=function(a){this.name=a||"";this.partList=[]};
NGL.Assembly.prototype={constructor:NGL.Assembly,type:"Assembly",addPart:function(a,b){var c=new NGL.AssemblyPart(a,b);this.partList.push(c);return c},getAtomCount:function(a){var b=0;this.partList.forEach(function(c){b+=c.getAtomCount(a)});return b},getInstanceCount:function(){var a=0;this.partList.forEach(function(b){a+=b.matrixList.length});return a},toJSON:function(){var a={name:this.name,partList:Array(this.partList.length)};this.partList.forEach(function(b,c){a.partList[c]=b.toJSON()});return a},
fromJSON:function(a){this.name=a.name;this.partList=a.partList;this.partList.forEach(function(a,c){this.partList[c]=(new NGL.AssemblyPart).fromJSON(a)}.bind(this));return this}};NGL.AssemblyPart=function(a,b){this.matrixList=a||[];this.chainList=b||[]};
NGL.AssemblyPart.prototype={constructor:NGL.AssemblyPart,type:"AssemblyPart",getAtomCount:function(a){var b=0,c=this.chainList;a.eachChain(function(a){if(0===c.length||-1!=c.indexOf(a.chainname))b+=a.atomCount});return this.matrixList.length*b},getSelection:function(){if(0<this.chainList.length){var a=":"+NGL.uniqueArray(this.chainList).join(" OR :");return new NGL.Selection(a)}return new NGL.Selection("")},getView:function(a){var b=this.getSelection();return b?a.getView(b):a},getInstanceList:function(){for(var a=
[],b=0,c=this.matrixList.length;b<c;++b)a.push({id:b+1,name:b,matrix:this.matrixList[b]});return a},toJSON:function(){return{matrixList:this.matrixList,chainList:this.chainList}},fromJSON:function(a){this.matrixList=a.matrixList;this.chainList=a.chainList;return this}};NGL.WorkerRegistry.add("parse",function(a,b){NGL.debug&&NGL.time("WORKER parse");var c=NGL.fromJSON(a.data);c.parse(function(){NGL.debug&&NGL.timeEnd("WORKER parse");c.streamer.dispose();b(c.toJSON(),c.getTransferable())})});
NGL.Parser=function(a,b){var c=b||{};this.streamer=a;this.name=c.name;this.path=c.path};
NGL.Parser.prototype={constructor:NGL.Parser,type:"",__objName:"",parse:function(a){var b=this;this.streamer.read(function(){b._beforeParse();b._parse(function(){b._afterParse();a(b[b.__objName])})});return this[this.__objName]},parseWorker:function(a){if("undefined"!==typeof Worker&&"function"!==typeof importScripts)var b=(new NGL.Worker("parse")).post(this.toJSON(),this.getTransferable(),function(c){b.terminate();this.fromJSON(c.data);this._afterWorker(a)}.bind(this),function(c){NGL.warn("NGL.Parser.parseWorker error - trying without worker",
c);b.terminate();this.parse(a)}.bind(this));else this.parse(a);return this[this.__objName]},_parse:function(a){NGL.warn("NGL.Parser._parse not implemented");a()},_beforeParse:function(){},_afterParse:function(){NGL.debug&&NGL.log(this[this.__objName])},_afterWorker:function(a){NGL.debug&&NGL.log(this[this.__objName]);a(this[this.__objName])},toJSON:function(){var a=this.type.substr(0,1).toUpperCase()+this.type.substr(1),a={metadata:{version:.1,type:a+"Parser",generator:a+"ParserExporter"},streamer:this.streamer.toJSON(),
name:this.name,path:this.path};a[this.__objName]="function"===typeof this[this.__objName].toJSON?this[this.__objName].toJSON():this[this.__objName];return a},fromJSON:function(a){this.streamer=NGL.fromJSON(a.streamer);this.name=a.name;this.path=a.path;"function"===typeof this[this.__objName].toJSON?this[this.__objName].fromJSON(a[this.__objName]):this[this.__objName]=a[this.__objName];return this},getTransferable:function(){var a=[],a=a.concat(this.streamer.getTransferable());"function"===typeof this[this.__objName].toJSON&&
(a=a.concat(this[this.__objName].getTransferable()));return a}};NGL.StructureParser=function(a,b){var c=b||{};this.firstModelOnly=c.firstModelOnly||!1;this.asTrajectory=c.asTrajectory||!1;this.cAlphaOnly=c.cAlphaOnly||!1;this.reorderAtoms=c.reorderAtoms||!1;this.dontAutoBond=c.dontAutoBond||!1;this.doAutoSS=!0;NGL.Parser.call(this,a,c);this.structure=new NGL.Structure(this.name,this.path);this.structureBuilder=new NGL.StructureBuilder(this.structure)};
NGL.StructureParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.StructureParser,type:"structure",__objName:"structure",_afterParse:function(){NGL.debug&&NGL.time("NGL.StructureParser._afterParse");var a=this.structure;a.refresh();this.reorderAtoms&&NGL.reorderAtoms(a);NGL.calculateChainnames(a);this.dontAutoBond?this.autoBondBetween&&NGL.calculateBondsBetween(a):NGL.calculateBonds(a);this.doAutoSS&&0===a.helices.length&&0===a.sheets.length&&NGL.calculateSecondaryStructure(a);
(0<a.helices.length||0<a.sheets.length)&&NGL.assignSecondaryStructure(a);this._postProcess();if(void 0===a.unitcell){var b=a.boundingBox.size();a.unitcell=new NGL.Unitcell(b.x,b.y,b.z,90,90,90,"P 1")}NGL.buildUnitcellAssembly(a);NGL.debug&&NGL.timeEnd("NGL.StructureParser._afterParse");NGL.debug&&NGL.log(this[this.__objName])},_postProcess:function(){},toJSON:function(){var a=NGL.Parser.prototype.toJSON.call(this);a.firstModelOnly=this.firstModelOnly;a.asTrajectory=this.asTrajectory;a.cAlphaOnly=
this.cAlphaOnly;a.reorderAtoms=this.reorderAtoms;a.dontAutoBond=this.dontAutoBond;a.doAutoSS=this.doAutoSS;return a},fromJSON:function(a){NGL.Parser.prototype.fromJSON.call(this,a);this.firstModelOnly=a.firstModelOnly;this.asTrajectory=a.asTrajectory;this.cAlphaOnly=a.cAlphaOnly;this.reorderAtoms=a.reorderAtoms;this.dontAutoBond=a.dontAutoBond;this.doAutoSS=a.doAutoSS;return this}});NGL.PdbParser=function(a,b){NGL.StructureParser.call(this,a,b)};
NGL.PdbParser.prototype=NGL.createObject(NGL.StructureParser.prototype,{constructor:NGL.PdbParser,type:"pdb",_parse:function(a){function b(a,b,da){for(;a<b;++a)if(x=da[a],y=x.substr(0,6),"ATOM  "===y||"HETATM"===y){if(Q&&(h?(n?(p=new Float32Array(3*T.count),l.push(p)):p=[],q=0):g||(D={})),Q=!1,!(g&&0<P)){if(c){var E=x.split(d),X=10===E.length?1:0;J=E[2];if(k&&"CA"!==J)continue;var N=parseFloat(E[6-X]),I=parseFloat(E[7-X]),C=parseFloat(E[8-X])}else{J=x.substr(12,4).trim();if(k&&"CA"!==J)continue;N=
parseFloat(x.substr(30,8));I=parseFloat(x.substr(38,8));C=parseFloat(x.substr(46,8))}if(h){var F=3*q;p[F+0]=N;p[F+1]=I;p[F+2]=C;q+=1;if(n)continue}c?(A=parseInt(E[1]),F="",Z="H"===x[0]?1:0,M=X?"":E[4],H=parseInt(E[5-X]),W="",R=E[3],K=parseFloat(E[9-X]),U="",O=0):(A=parseInt(x.substr(6,5)),F=x.substr(76,2).trim(),Z="H"===x[0]?1:0,M=x[21].trim(),H=parseInt(x.substr(22,4)),W=x[26].trim(),R=x.substr(17,4).trim(),K=parseFloat(x.substr(60,6)),U=x[16].trim(),O=parseFloat(x.substr(54,6)));T.growIfFull();
T.atomTypeId[L]=S.add(J,F);T.x[L]=N;T.y[L]=I;T.z[L]=C;T.serial[L]=A;T.bfactor[L]=isNaN(K)?0:K;T.altloc[L]=U.charCodeAt(0);T.occupancy[L]=isNaN(O)?0:O;f.addAtom(P,M,R,H,Z,void 0,W);D[A]=L;L+=1}}else if("CONECT"===y){if(C=D[parseInt(x.substr(6,5))],N=[11,16,21,26],void 0!==C){for(F=0;4>F;++F)I=parseInt(x.substr(N[F],5)),Number.isNaN(I)||(I=D[I],void 0!==I&&($.index=C,Y.index=I,e.bondStore.addBond($,Y)));e.hasConnect=!0}}else if("HELIX "===y){var C=x[19].trim(),F=parseInt(x.substr(21,4)),N=x[25].trim(),
I=x[31].trim(),ba=parseInt(x.substr(33,4)),fa=x[37].trim(),ca=parseInt(x.substr(39,1)),ca=(z[ca]||z[""]).charCodeAt(0);t.push([C,F,N,I,ba,fa,ca])}else if("SHEET "===y)C=x[21].trim(),F=parseInt(x.substr(22,4)),N=x[26].trim(),I=x[32].trim(),ba=parseInt(x.substr(33,4)),fa=x[37].trim(),v.push([C,F,N,I,ba,fa]);else if("REMARK"===y&&"350"===x.substr(7,3))if("BIOMOLECULE:"===x.substr(11,12))C=x.substr(23).trim(),/^(0|[1-9][0-9]*)$/.test(C)&&(C="BU"+C),u=new NGL.Assembly(C),w[C]=u;else if("BIOMT"===x.substr(13,
5))E=x.split(/\s+/),C=parseInt(x[18])-1,F=E[3].trim(),0===C&&(s=new THREE.Matrix4,B.matrixList.push(s)),F=s.elements,F[0+C]=parseFloat(E[4]),F[4+C]=parseFloat(E[5]),F[8+C]=parseFloat(E[6]),F[12+C]=parseFloat(E[7]);else{if("APPLY THE FOLLOWING TO CHAINS:"===x.substr(11,30)||"                   AND CHAINS:"===x.substr(11,30))"APPLY"===x.substr(11,5)&&(B=u.addPart()),x.substr(41,30).split(",").forEach(function(a){(a=a.trim())&&B.chainList.push(a)})}else if("HEADER"===y)x.substr(62,4);else if("TITLE "===
y)r+=x.substr(10,70)+"\n";else if("MODEL "===y)Q=!0;else if("ENDMDL"===y||"END"===x.substr(0,3))Q||(h&&!n&&(l.push(new Float32Array(p)),n=!0),P+=1,Q=!0);else if("MTRIX "===y)E=x.split(/\s+/),F=E[1].trim(),"1"===x[5]&&"1"===F&&(C="NCS",u=new NGL.Assembly(C),w[C]=u,B=u.addPart()),C=parseInt(x[5])-1,0===C&&(s=new THREE.Matrix4,B.matrixList.push(s)),F=s.elements,F[0+C]=parseFloat(E[2]),F[4+C]=parseFloat(E[3]),F[8+C]=parseFloat(E[4]),F[12+C]=parseFloat(E[5]);else if("ORIGX"===x.substr(0,5))G.origx||(G.origx=
new THREE.Matrix4),E=x.split(/\s+/),C=parseInt(x[5])-1,F=G.origx.elements,F[0+C]=parseFloat(E[1]),F[4+C]=parseFloat(E[2]),F[8+C]=parseFloat(E[3]),F[12+C]=parseFloat(E[4]);else if("SCALE"===x.substr(0,5))G.scale||(G.scale=new THREE.Matrix4),E=x.split(/\s+/),C=parseInt(x[5])-1,F=G.scale.elements,F[0+C]=parseFloat(E[1]),F[4+C]=parseFloat(E[2]),F[8+C]=parseFloat(E[3]),F[12+C]=parseFloat(E[4]);else if("CRYST1"===y){var F=parseFloat(x.substr(6,9)),N=parseFloat(x.substr(15,9)),I=parseFloat(x.substr(24,9)),
ba=parseFloat(x.substr(33,7)),fa=parseFloat(x.substr(40,7)),ca=parseFloat(x.substr(47,7)),ga=x.substr(55,11).trim(),C=parseInt(x.substr(66,4)),C=new Float32Array(9);C[0]=F;C[4]=N;C[8]=I;m.push(C);0===P&&(G.a=F,G.b=N,G.c=I,G.alpha=ba,G.beta=fa,G.gamma=ca,G.spacegroup=ga)}}NGL.debug&&NGL.time("NGL.PdbParser._parse "+this.name);var c="pqr"===this.type,d=/\s+/,e=this.structure,f=this.structureBuilder,g=this.firstModelOnly,h=this.asTrajectory,k=this.cAlphaOnly,l=e.frames,m=e.boxes,n=!1,p,q,r=e.title,t=
e.helices,v=e.sheets,w=e.biomolDict,u,B,s,z=NGL.HelixTypes,x,y,A,M,H,R,O,W,J,Z,K,U,D={},G={};e.hasConnect=!1;var S=e.atomMap,T=e.atomStore;T.resize(Math.round(this.streamer.data.length/80));var $=e.getAtomProxy(),Y=e.getAtomProxy(),L=0,P=0,Q=!0;this.streamer.eachChunkOfLines(function(a,c,d){b(0,a.length,a)});f.finalize();e.unitcell=void 0!==G.a?new NGL.Unitcell(G.a,G.b,G.c,G.alpha,G.beta,G.gamma,G.spacegroup,G.scale):void 0;NGL.debug&&NGL.timeEnd("NGL.PdbParser._parse "+this.name);a()}});
NGL.PqrParser=function(a,b){NGL.StructureParser.call(this,a,b)};NGL.PqrParser.prototype=NGL.createObject(NGL.PdbParser.prototype,{constructor:NGL.PqrParser,type:"pqr"});NGL.GroParser=function(a,b){NGL.StructureParser.call(this,a,b);this.structure._doAutoSS=!0;this.structure._doAutoChainName=!0};
NGL.GroParser.prototype=NGL.createObject(NGL.StructureParser.prototype,{constructor:NGL.GroParser,type:"gro",_parse:function(a){NGL.debug&&NGL.time("NGL.GroParser._parse "+this.name);var b=this.structure,c=this.structureBuilder,d=this.firstModelOnly,e=this.asTrajectory,f=this.cAlphaOnly,g=b.frames,h=b.boxes,k,l,m=this.streamer.peekLines(3);b.title=m[0].trim();var n=5+(m[2].length-m[2].lastIndexOf(".")-1),p=20+n,q=20+2*n,r,t,v,w,u=parseInt(m[1]),B=u+3,s=b.atomMap,z=b.atomStore;z.resize(u);var x=0,
y=0,A=0;this.streamer.eachChunkOfLines(function(a,b,m){a:for(b=a.length,m=0;m<b;++m){++A;var O=A-1,W=a[m];if(W)if(0===O%B)e&&(k=new Float32Array(3*u),g.push(k),l=0);else if(1!==O%B)if(O%B===B-1){O=W.trim().split(/\s+/);W=new Float32Array(9);W[0]=10*parseFloat(O[0]);W[4]=10*parseFloat(O[1]);W[8]=10*parseFloat(O[2]);h.push(W);if(d)break a;y+=1}else if(r=W.substr(10,5).trim(),!f||"CA"===r){var J=10*parseFloat(W.substr(20,n)),Z=10*parseFloat(W.substr(p,n)),K=10*parseFloat(W.substr(q,n));if(e){var U=3*
l;k[U+0]=J;k[U+1]=Z;k[U+2]=K;l+=1;if(O>B)continue}t=W.substr(5,5).trim();v=parseInt(W.substr(0,5));w=parseInt(W.substr(15,5));z.growIfFull();z.atomTypeId[x]=s.add(r);z.x[x]=J;z.y[x]=Z;z.z[x]=K;z.serial[x]=w;c.addAtom(y,"",t,v,0,"l");x+=1}}});c.finalize();b.unitcell=new NGL.Unitcell(h[0][0],h[0][4],h[0][8],90,90,90,"P 1");NGL.debug&&NGL.timeEnd("NGL.GroParser._parse "+this.name);a()}});NGL.CifParser=function(a,b){NGL.StructureParser.call(this,a,b)};
NGL.CifParser.prototype=NGL.createObject(NGL.StructureParser.prototype,{constructor:NGL.CifParser,type:"cif",_parse:function(a){NGL.time("NGL.CifParser._parse "+this.name);var b=this.structure,c=this.structureBuilder,d=this.firstModelOnly,e=this.asTrajectory,f=this.cAlphaOnly,g=b.frames,h,k,l;b.hasConnect=!1;var m=/\s+/,n=/'((?:(?!'\s).)*)'|"((?:(?!"\s).)*)"|(\S+)/g,p=/"/g,q={};this.cif=q;var r=!1,t=null,v=!1,w=!1,u=[],B=null,s=null,z=null,x=null,y=[],A,M,H,R,O,W,J,Z,K,U,D,G,S,T,$,Y,L={};this.asymIdDict=
L;var P=b.atomMap,Q=b.atomStore;Q.resize(this.streamer.data.length/100);var V=0,aa=0,da;this.streamer.eachChunkOfLines(function(a,b,N){b=a.length;for(N=0;N<b;++N)if(((l=a[N].trim())||r||w)&&"#"!==l[0])if("data_"===l.substring(0,5))l.substring(5);else if(";"===l[0])r?(w?(B===u.length&&(B=0),u[B].push(t),B+=1):q[s][z]=t,r=!1,t=null):(r=!0,t=l.substring(1));else if("loop_"===l)w=!0,u.length=0,B=y.length=0;else if("_"===l[0])if(w){var I=l.split("."),C=I[0].substring(1),F=I[1];1===I.length?(F=!1,q[C]||
(q[C]=[]),u.push(q[C])):(q[C]||(q[C]={}),q[C][F]?NGL.warn(C,F,"already exists"):(q[C][F]=[],u.push(q[C][F]),y.push(F)));s=C;z=F;x=!0}else{var I=l.match(n),ba=I[1],I=I[0].split("."),C=I[0].substring(1),F=I[1];1===I.length?(F=!1,q[C]||(q[C]=[]),q[C]=ba):(q[C]||(q[C]={}),q[C][F]?NGL.warn(C,F,"already exists"):q[C][F]=ba);ba||(v=!0);s=C;z=F}else if(r)t+=" "+l;else if(w){if(l)if("atom_site"===s){if(ba=y.length,I=l.split(m),x&&(A=y.indexOf("auth_asym_id"),M=y.indexOf("auth_seq_id"),H=y.indexOf("label_atom_id"),
R=y.indexOf("label_comp_id"),O=y.indexOf("label_asym_id"),W=y.indexOf("label_alt_id"),G=y.indexOf("Cartn_x"),S=y.indexOf("Cartn_y"),T=y.indexOf("Cartn_z"),Z=y.indexOf("id"),K=y.indexOf("type_symbol"),J=y.indexOf("group_PDB"),$=y.indexOf("B_iso_or_equiv"),U=y.indexOf("pdbx_PDB_model_num"),D=y.indexOf("pdbx_PDB_ins_code"),Y=y.indexOf("occupancy"),x=!1,da=parseInt(I[U]),e&&(h=[],k=0)),ba=parseInt(I[U]),da!==ba&&(e&&(0===aa&&g.push(new Float32Array(h)),h=new Float32Array(3*Q.count),g.push(h),k=0),aa+=
1),da=ba,!(d&&0<aa||(ba=I[H].replace(p,""),f&&"CA"!==ba))){var C=parseFloat(I[G]),F=parseFloat(I[S]),fa=parseFloat(I[T]);if(e){var ca=3*k;h[ca+0]=C;h[ca+1]=F;h[ca+2]=fa;k+=1;if(0<aa)continue}var ga=I[R],ia=parseInt(I[M]),ea=I[D],ea="?"===ea?"":ea,ca=I[A],ja="H"===I[J][0]?1:0,ka=I[K],ha=parseFloat(I[$]),ma=parseFloat(I[Y]),la=I[W],la="."===la?"":la;Q.growIfFull();Q.atomTypeId[V]=P.add(ba,ka);Q.x[V]=C;Q.y[V]=F;Q.z[V]=fa;Q.serial[V]=parseInt(I[Z]);Q.bfactor[V]=isNaN(ha)?0:ha;Q.occupancy[V]=isNaN(ma)?
0:ma;Q.altloc[V]=la.charCodeAt(0);c.addAtom(aa,ca,ga,ia,ja,void 0,ea);NGL.debug&&(ba=L[I[O]],void 0!==ba&&ba!==ca&&NGL.warn(ba,ca));L[I[O]]=ca;V+=1}}else{I=l.match(n);ba=I.length;B===u.length&&(B=0);for(ca=0;ca<ba;++ca)u[B+ca].push(I[ca]);B+=ba}}else"'"===l[0]&&"'"===l.substring(l.length-1)?(I=l.substring(1,l.length-2),!1===z?q[s]=I:q[s][z]=I):v?!1===z?q[s]=l.trim():q[s][z]=l.trim():NGL.debug&&NGL.log("NGL.CifParser._parse: unknown state",l);else v=w=r=!1,u.length=0,x=z=s=B=null,y.length=0});c.finalize();
q.struct&&q.struct.title&&(b.title=q.struct.title.trim().replace(/^['"]+|['"]+$/g,""));(function(){function a(b,c){Array.isArray(b[c])||Object.keys(b).forEach(function(a){b[a]=[b[a]]})}var c=q.struct_conf;if(c){var d=b.helices,e=NGL.HelixTypes;a(c,"id");for(var f=0,g=c.beg_auth_seq_id.length;f<g;++f){var h=parseInt(c.pdbx_PDB_helix_class[f]);if(!Number.isNaN(h)){var k=c.pdbx_beg_PDB_ins_code[f],l=c.pdbx_end_PDB_ins_code[f];d.push([L[c.beg_label_asym_id[f]],parseInt(c.beg_auth_seq_id[f]),"?"===k?"":
k,L[c.end_label_asym_id[f]],parseInt(c.end_auth_seq_id[f]),"?"===l?"":l,(e[h]||e[""]).charCodeAt(0)])}}}if(c=q.struct_sheet_range)for(d=b.sheets,a(c,"id"),f=0,g=c.beg_auth_seq_id.length;f<g;++f)k=c.pdbx_beg_PDB_ins_code[f],l=c.pdbx_end_PDB_ins_code[f],d.push([L[c.beg_label_asym_id[f]],parseInt(c.beg_auth_seq_id[f]),"?"===k?"":k,L[c.end_label_asym_id[f]],parseInt(c.end_auth_seq_id[f]),"?"===l?"":l])})();NGL.debug&&NGL.timeEnd("NGL.CifParser._parse "+this.name);a()},_postProcess:function(){function a(a,
b){Array.isArray(a[b])||Object.keys(a).forEach(function(b){a[b]=[a[b]]})}NGL.debug&&NGL.time("NGL.CifParser._postProcess");var b=this.structure,c=this.structure,d=this.cif,e=this.asymIdDict,f={},g=b.biomolDict;if(d.pdbx_struct_oper_list){var h=d.pdbx_struct_oper_list;a(h,"id");h.id.forEach(function(a,b){var c=new THREE.Matrix4,d=c.elements;d[0]=parseFloat(h["matrix[1][1]"][b]);d[1]=parseFloat(h["matrix[1][2]"][b]);d[2]=parseFloat(h["matrix[1][3]"][b]);d[4]=parseFloat(h["matrix[2][1]"][b]);d[5]=parseFloat(h["matrix[2][2]"][b]);
d[6]=parseFloat(h["matrix[2][3]"][b]);d[8]=parseFloat(h["matrix[3][1]"][b]);d[9]=parseFloat(h["matrix[3][2]"][b]);d[10]=parseFloat(h["matrix[3][3]"][b]);d[3]=parseFloat(h["vector[1]"][b]);d[7]=parseFloat(h["vector[2]"][b]);d[11]=parseFloat(h["vector[3]"][b]);c.transpose();f[a]=c})}if(d.pdbx_struct_assembly_gen){var k=d.pdbx_struct_assembly_gen;a(k,"assembly_id");var l=function(a){var b={};a.replace(/[\(\)']/g,"").split(",").forEach(function(a){if(-1!==a.indexOf("-")){var c=a.split("-");a=parseInt(c[0]);
for(c=parseInt(c[1]);a<=c;++a)b[a]=f[a]}else b[a]=f[a]});return b};k.assembly_id.forEach(function(a,b){var c={},d=k.oper_expression[b];if(-1!==d.indexOf(")(")){var d=d.split(")("),f=l(d[0]),h=l(d[1]);Object.keys(f).forEach(function(a){Object.keys(h).forEach(function(b){var d=new THREE.Matrix4;d.multiplyMatrices(f[a],h[b]);c[a+"x"+b]=d})})}else c=l(d);var d=[],m;for(m in c)d.push(c[m]);m=a;/^(0|[1-9][0-9]*)$/.test(m)&&(m="BU"+m);for(var n=k.asym_id_list[b].split(","),q=0,p=n.length;q<p;++q)n[q]=e[n[q]];
void 0===g[m]&&(g[m]=new NGL.Assembly(m));g[m].addPart(d,n)})}if(d.struct_ncs_oper){h=d.struct_ncs_oper;a(h,"id");g.NCS=new NGL.Assembly("NCS");var m=g.NCS.addPart();h.id.forEach(function(a,b){var c=new THREE.Matrix4,d=c.elements;d[0]=parseFloat(h["matrix[1][1]"][b]);d[1]=parseFloat(h["matrix[1][2]"][b]);d[2]=parseFloat(h["matrix[1][3]"][b]);d[4]=parseFloat(h["matrix[2][1]"][b]);d[5]=parseFloat(h["matrix[2][2]"][b]);d[6]=parseFloat(h["matrix[2][3]"][b]);d[8]=parseFloat(h["matrix[3][1]"][b]);d[9]=
parseFloat(h["matrix[3][2]"][b]);d[10]=parseFloat(h["matrix[3][3]"][b]);d[3]=parseFloat(h["vector[1]"][b]);d[7]=parseFloat(h["vector[2]"][b]);d[11]=parseFloat(h["vector[3]"][b]);c.transpose();m.matrixList.push(c)})}var n,p,q,r,t,v,w,u;d.cell&&(v=d.cell,n=parseFloat(v.length_a),p=parseFloat(v.length_b),q=parseFloat(v.length_c),r=new Float32Array(9),r[0]=n,r[4]=p,r[8]=q,c.boxes.push(r),r=parseFloat(v.angle_alpha),t=parseFloat(v.angle_beta),v=parseFloat(v.angle_gamma));d.symmetry&&(w=d.symmetry["space_group_name_H-M"],
w[0]!==w[w.length-1]||"'"!==w[0]&&'"'!==w[0]||(w=w.substring(1,w.length-1)));var B=new THREE.Matrix4;if(d.database_PDB_matrix){var c=d.database_PDB_matrix,s=B.elements;s[0]=parseFloat(c["origx[1][1]"]);s[1]=parseFloat(c["origx[1][2]"]);s[2]=parseFloat(c["origx[1][3]"]);s[4]=parseFloat(c["origx[2][1]"]);s[5]=parseFloat(c["origx[2][2]"]);s[6]=parseFloat(c["origx[2][3]"]);s[8]=parseFloat(c["origx[3][1]"]);s[9]=parseFloat(c["origx[3][2]"]);s[10]=parseFloat(c["origx[3][3]"]);s[3]=parseFloat(c["origx_vector[1]"]);
s[7]=parseFloat(c["origx_vector[2]"]);s[11]=parseFloat(c["origx_vector[3]"]);B.transpose()}B=new THREE.Matrix4;d.atom_sites&&(c=d.atom_sites,s=B.elements,s[0]=parseFloat(c["fract_transf_matrix[1][1]"]),s[1]=parseFloat(c["fract_transf_matrix[1][2]"]),s[2]=parseFloat(c["fract_transf_matrix[1][3]"]),s[4]=parseFloat(c["fract_transf_matrix[2][1]"]),s[5]=parseFloat(c["fract_transf_matrix[2][2]"]),s[6]=parseFloat(c["fract_transf_matrix[2][3]"]),s[8]=parseFloat(c["fract_transf_matrix[3][1]"]),s[9]=parseFloat(c["fract_transf_matrix[3][2]"]),
s[10]=parseFloat(c["fract_transf_matrix[3][3]"]),s[3]=parseFloat(c["fract_transf_vector[1]"]),s[7]=parseFloat(c["fract_transf_vector[2]"]),s[11]=parseFloat(c["fract_transf_vector[3]"]),B.transpose(),u=B);b.unitcell=void 0!==n?new NGL.Unitcell(n,p,q,r,t,v,w,u):void 0;if(d=d.struct_conn)for(a(d,"id"),u=/"/g,w=b.getAtomProxy(),n=b.getAtomProxy(),p={},q=0,r=d.id.length;q<r;++q)if(t=d.conn_type_id[q],"hydrog"!==t&&"mismat"!==t&&"saltbr"!==t&&"1_555"===d.ptnr1_symmetry[q]&&"1_555"===d.ptnr2_symmetry[q]){t=
d.pdbx_ptnr1_PDB_ins_code[q];c=d.pdbx_ptnr1_label_alt_id[q];t=d.ptnr1_auth_seq_id[q]+("?"===t?"":"^"+t)+":"+e[d.ptnr1_label_asym_id[q]]+"."+d.ptnr1_label_atom_id[q].replace(u,"")+("?"===c?"":"%"+c);c=p[t];if(!c){c=new NGL.Selection(t);if(c.selection.error){NGL.warn("invalid selection for connection",t);continue}c=b.getAtomIndices(c);p[t]=c}v=d.pdbx_ptnr2_PDB_ins_code[q];s=d.pdbx_ptnr2_label_alt_id[q];v=d.ptnr2_auth_seq_id[q]+("?"===v?"":"^"+v)+":"+e[d.ptnr2_label_asym_id[q]]+"."+d.ptnr2_label_atom_id[q].replace(u,
"")+("?"===s?"":"%"+s);s=p[v];if(!s){s=new NGL.Selection(v);if(s.selection.error){NGL.warn("invalid selection for connection",v);continue}s=b.getAtomIndices(s);p[v]=s}var B=c.length,z=s.length;if(B>z)var x=B,B=z,z=x,x=c,c=s,s=x;if(0===B||0===z)NGL.warn("no atoms found for",t,v);else for(t=0;t<z;++t)w.index=c[t%B],n.index=s[t],w&&n?b.bondStore.addBond(w,n):NGL.log("atoms for connection not found")}NGL.debug&&NGL.timeEnd("NGL.CifParser._postProcess")}});
NGL.SdfParser=function(a,b){NGL.StructureParser.call(this,a,b)};
NGL.SdfParser.prototype=NGL.createObject(NGL.StructureParser.prototype,{constructor:NGL.SdfParser,type:"sdf",_parse:function(a){NGL.debug&&NGL.time("NGL.SdfParser._parse "+this.name);var b=this.structure,c=this.structureBuilder,d=this.firstModelOnly,e=this.asTrajectory,f=this.streamer.peekLines(2);b.id=f[0].trim();b.title=f[1].trim();var g=b.frames,h=!1,k,l,m=b.atomMap,n=b.atomStore;n.resize(Math.round(this.streamer.data.length/50));var p=b.getAtomProxy(),q=b.getAtomProxy(),r=0,t=0,v=0,w=0,u,B,s,
z,x,y;this.streamer.eachChunkOfLines(function(a,f,H){f=a.length;for(H=0;H<f;++H){var R=a[H];"$$$$"===R.substr(0,4)&&(t=-1,++v,w=n.count);3===t&&(u=parseInt(R.substr(0,3)),B=parseInt(R.substr(3,3)),s=4,x=z=s+u,y=x+B,e&&(l=0,k=new Float32Array(3*u),g.push(k),0<v&&(h=!0)));if(t>=s&&t<z){if(d&&0<v)continue;var O=parseFloat(R.substr(0,10)),W=parseFloat(R.substr(10,10)),J=parseFloat(R.substr(20,10));if(e){var Z=3*l;k[Z+0]=O;k[Z+1]=W;k[Z+2]=J;l+=1;if(h)continue}var Z=R.substr(31,3).trim(),K=Z+(r+1);n.growIfFull();
n.atomTypeId[r]=m.add(K,Z);n.x[r]=O;n.y[r]=W;n.z[r]=J;n.serial[r]=r;c.addAtom(v,"","HET",1,1);r+=1}if(t>=x&&t<y){if(d&&0<v)continue;if(e&&0<v)continue;p.index=parseInt(R.substr(0,3))-1+w;q.index=parseInt(R.substr(3,3))-1+w;R=parseInt(R.substr(6,3));b.bondStore.addBond(p,q,R)}++t}});c.finalize();b._dontAutoBond=!0;b.unitcell=void 0;NGL.debug&&NGL.timeEnd("NGL.SdfParser._parse "+this.name);a()}});NGL.Mol2Parser=function(a,b){NGL.StructureParser.call(this,a,b)};
NGL.Mol2Parser.prototype=NGL.createObject(NGL.StructureParser.prototype,{constructor:NGL.Mol2Parser,type:"mol2",_parse:function(a){NGL.debug&&NGL.time("NGL.Mol2Parser._parse "+this.name);var b=/\s+/,c=this.structure,d=this.structureBuilder,e=this.firstModelOnly,f=this.asTrajectory,g=c.frames,h=!1,k,l,m=c.atomMap,n=c.atomStore;n.resize(Math.round(this.streamer.data.length/60));var p=0,q=0,r=0,t=-1,v=0,w=0,u=c.getAtomProxy(),B=c.getAtomProxy(),s={1:1,2:2,3:3,am:1,ar:1,du:1,un:1,nc:0};this.streamer.eachChunkOfLines(function(a,
x,y){x=a.length;for(y=0;y<x;++y){var A=a[y].trim();if(""!==A&&"#"!==A[0])if("@"===A[0])"@<TRIPOS>MOLECULE"===A?(w=1,q=0,++t):"@<TRIPOS>ATOM"===A?(w=2,r=n.count,f&&(l=0,k=new Float32Array(3*v),g.push(k),0<t&&(h=!0))):w="@<TRIPOS>BOND"===A?3:0;else if(1===w){if(0===q)c.title=A,c.id=A;else if(1===q){var M=A.split(b);v=parseInt(M[0])}++q}else if(2===w){if(M=A.split(b),!(e&&0<t)){var A=parseFloat(M[2]),H=parseFloat(M[3]),R=parseFloat(M[4]);if(f){var O=3*l;k[O+0]=A;k[O+1]=H;k[O+2]=R;l+=1;if(h)continue}var O=
M[0],W=M[1],J=M[5].split(".")[0],Z=M[6]?parseInt(M[6]):1,K=M[7]?M[7]:"",M=M[8]?parseFloat(M[8]):0;n.growIfFull();n.atomTypeId[p]=m.add(W,J);n.x[p]=A;n.y[p]=H;n.z[p]=R;n.serial[p]=O;n.bfactor[p]=M;d.addAtom(t,"",K,Z,1);p+=1}}else 3!==w||e&&0<t||f&&0<t||(M=A.split(b),u.index=parseInt(M[1])-1+r,B.index=parseInt(M[2])-1+r,c.bondStore.addBond(u,B,s[M[3]]))}});d.finalize();c._dontAutoBond=!0;c.unitcell=void 0;NGL.debug&&NGL.timeEnd("NGL.Mol2Parser._parse "+this.name);a()}});
NGL.MmtfParser=function(a,b){NGL.StructureParser.call(this,a,b);this.dontAutoBond=!0;this.doAutoSS=this.autoBondBetween=!1};
NGL.MmtfParser.prototype=NGL.createObject(NGL.StructureParser.prototype,{constructor:NGL.MmtfParser,type:"mmtf",_parse:function(a){NGL.debug&&NGL.time("NGL.MmtfParser._parse "+this.name);var b=this.structure,c=decodeMmtf(decodeMsgpack(this.streamer.data)),d,e,f,g,h,k;if(this.firstModelOnly||this.asTrajectory){h=1;g=c.chainsPerModel[0];for(var l=f=0,m=g;l<m;++l)f+=c.groupsPerChain[l];l=e=0;for(m=f;l<m;++l){var n=c.groupList[c.groupTypeList[l]];e+=n.atomNameList.length}d=c.numBonds;k=[g]}else d=c.numBonds,
e=c.numAtoms,f=c.numGroups,g=c.numChains,h=c.numModels,k=c.chainsPerModel;d+=f;if(this.asTrajectory)for(l=0,m=c.numModels;l<m;++l){for(var p=new Float32Array(3*e),q=e*l,n=0;n<e;++n){var r=3*n,t=n+q;p[r]=c.xCoordList[t];p[r+1]=c.yCoordList[t];p[r+2]=c.zCoordList[t]}b.frames.push(p)}p=new Uint32Array(d);q=new Uint32Array(d);d=new Uint8Array(d);for(var r=new Uint32Array(e),t=new Uint32Array(f),v=new Uint32Array(f),w=new Uint16Array(f),u=new Uint16Array(g),B=new Uint32Array(g),s=new Uint32Array(g),z=
new Uint32Array(h),x=new Uint32Array(h),y=0,l=0,m=h;l<m;++l){var A=k[l];z[l]=y;x[l]=A;for(n=0;n<A;++n)u[n+y]=l;y+=A}k=c.groupsPerChain;l=y=0;for(m=g;l<m;++l){A=k[l];B[l]=y;s[l]=A;for(n=0;n<A;++n)t[n+y]=l;y+=A}for(var M=0,l=y=0,m=f;l<m;++l){var n=c.groupList[c.groupTypeList[l]],H=n.atomNameList.length,A=n.bondAtomList,R=n.bondOrderList,n=0;for(k=R.length;n<k;++n)p[y]=M+A[2*n],q[y]=M+A[2*n+1],d[y]=R[n],y+=1;v[l]=M;w[l]=H;for(n=0;n<H;++n)r[M]=l,M+=1}if(A=c.bondAtomList)for(c.bondOrderList&&d.set(c.bondOrderList,
y),l=0,m=A.length;l<m;l+=2)n=A[l],k=A[l+1],n<e&&k<e&&(p[y]=n,q[y]=k,y+=1);b.bondStore.length=d.length;b.bondStore.count=y;b.bondStore.atomIndex1=p;b.bondStore.atomIndex2=q;b.bondStore.bondOrder=d;b.atomStore.length=e;b.atomStore.count=e;b.atomStore.residueIndex=r;b.atomStore.atomTypeId=new Uint16Array(e);b.atomStore.x=c.xCoordList.subarray(0,e);b.atomStore.y=c.yCoordList.subarray(0,e);b.atomStore.z=c.zCoordList.subarray(0,e);b.atomStore.serial=c.atomIdList.subarray(0,e);b.atomStore.bfactor=c.bFactorList.subarray(0,
e);b.atomStore.altloc=c.altLocList.subarray(0,e);b.atomStore.occupancy=c.occupancyList.subarray(0,e);b.residueStore.length=f;b.residueStore.count=f;b.residueStore.chainIndex=t;b.residueStore.residueTypeId=c.groupTypeList;b.residueStore.atomOffset=v;b.residueStore.atomCount=w;b.residueStore.resno=c.groupIdList.subarray(0,f);b.residueStore.sstruc=c.secStructList.subarray(0,f);b.residueStore.inscode=c.insCodeList.subarray(0,f);b.chainStore.length=g;b.chainStore.count=g;b.chainStore.modelIndex=u;b.chainStore.residueOffset=
B;b.chainStore.residueCount=s;b.chainStore.chainname=c.chainNameList.subarray(0,4*g);b.modelStore.length=h;b.modelStore.count=h;b.modelStore.chainOffset=z;b.modelStore.chainCount=x;e={0:105,1:115,2:104,3:101,4:103,5:98,6:116,7:108,"-1":"".charCodeAt(0)};g="non-polymer;other;saccharide;l-saccharide;d-saccharide;l-saccharide 1,4 and 1,4 linking;l-saccharide 1,4 and 1,6 linking;d-saccharide 1,4 and 1,4 linking;d-saccharide 1,4 and 1,6 linking".split(";");h={};l=0;for(m=c.groupList.length;l<m;++l){p=
c.groupList[l];q=[];n=0;for(k=p.atomNameList.length;n<k;++n)d=p.elementList[n].toUpperCase(),q.push(b.atomMap.add(p.atomNameList[n],d));n=-1!==g.indexOf(p.chemCompType.toLowerCase());h[l]=b.residueMap.add(p.groupName,q,n)}l=0;for(m=f;l<m;++l)b.residueStore.residueTypeId[l]=h[b.residueStore.residueTypeId[l]];l=0;for(m=b.atomStore.count;l<m;++l)f=b.atomStore.residueIndex[l],b.atomStore.atomTypeId[l]=b.residueMap.list[b.residueStore.residueTypeId[f]].atomTypeIdList[l-b.residueStore.atomOffset[f]];if(c.secStructList)for(f=
c.secStructList.length,l=0,m=b.residueStore.count;l<m;++l)n=e[b.residueStore.sstruc[l%f]],void 0!==n&&(b.residueStore.sstruc[l]=n);c.bioAssemblyList&&c.bioAssemblyList.forEach(function(a,d){var e=d+1,f=new NGL.Assembly(e);b.biomolDict["BU"+e]=f;var g={};a.transformList.forEach(function(a){var b=(new THREE.Matrix4).fromArray(a.matrix).transpose();a=a.chainIndexList.map(function(a){for(var b="",d=0;4>d;++d){var e=c.chainNameList[4*a+d];if(e)b+=String.fromCharCode(e);else break}return b});var d=g[a];
d?d.matrixList.push(b):g[a]=f.addPart([b],a)})});c.unitCell&&Array.isArray(c.unitCell)&&c.unitCell[0]?b.unitcell=new NGL.Unitcell(c.unitCell[0],c.unitCell[1],c.unitCell[2],c.unitCell[3],c.unitCell[4],c.unitCell[5],c.spaceGroup):b.unitcell=void 0;NGL.debug&&NGL.timeEnd("NGL.MmtfParser._parse "+this.name);NGL.calculateBondsBetween(b,!0);NGL.calculateBondsWithin(b,!0);a()}});NGL.TrajectoryParser=function(a,b){NGL.Parser.call(this,a,b||{});this.frames=new NGL.Frames(this.name,this.path)};
NGL.TrajectoryParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.TrajectoryParser,type:"trajectory",__objName:"frames"});NGL.DcdParser=function(a,b){NGL.TrajectoryParser.call(this,a,b||{})};
NGL.DcdParser.prototype=NGL.createObject(NGL.TrajectoryParser.prototype,{constructor:NGL.DcdParser,type:"dcd",_parse:function(a){NGL.debug&&NGL.time("NGL.DcdParser._parse "+this.name);var b=this.streamer.data;b instanceof Uint8Array&&(b=b.buffer);var c=new DataView(b),d=this.frames,e=d.coordinates,d=d.boxes,f,g,h,k=0;h=new Int32Array(b,0,23);var l=h[0]!==c.getInt32(0);if(84!==h[0])for(f=b.byteLength,g=0;g<f;g+=4)c.setFloat32(g,c.getFloat32(g),!0);84!==h[0]&&NGL.error("dcd bad format, header block start");
"CORD"!==String.fromCharCode(c.getUint8(4),c.getUint8(5),c.getUint8(6),c.getUint8(7))&&NGL.error("dcd bad format, format string");var m=!1,n=!1,p=!1;0!==h[22]&&(m=!0,0!==h[12]&&(n=!0),1===h[13]&&(p=!0));f=h[2];g=h[10];m?c.getFloat32(44,l):c.getFloat64(44,l);84!==h[22]&&NGL.error("dcd bad format, header block end");k=k+84+8;h=c.getInt32(k,l);m=k+1;0!==(h-4)%80&&NGL.error("dcd bad format, title block start");NGL.Uint8ToString(new Uint8Array(b,m,h));c.getInt32(m+h+4-1,l)!==h&&NGL.error("dcd bad format, title block end");
k=k+h+8;4!==c.getInt32(k,l)&&NGL.error("dcd bad format, natom block start");h=c.getInt32(k+4,l);4!==c.getInt32(k+8,l)&&NGL.error("dcd bad format, natom block end");k=k+4+8;if(0<g)NGL.error("dcd format with fixed atoms unsupported, aborting");else{m=4*h;for(g=0;g<f;++g){if(n){var k=k+4,q=new Float32Array(9);q[0]=c.getFloat64(k,l);q[4]=c.getFloat64(k+16,l);q[8]=c.getFloat64(k+40,l);d.push(q);k+=48;k+=4}for(var q=new Float32Array(3*h),r=0;3>r;++r){c.getInt32(k,l)!==m&&NGL.error("dcd bad format, coord block start",
g,r);for(var k=k+4,t=new Float32Array(b,k,h),v=0;v<h;++v)q[3*v+r]=t[v];k+=m;c.getInt32(k,l)!==m&&NGL.error("dcd bad format, coord block end",g,r);k+=4}e.push(q);p&&(q=c.getInt32(k,l),k+=4+q+4)}NGL.debug&&NGL.timeEnd("NGL.DcdParser._parse "+this.name)}a()}});NGL.VolumeParser=function(a,b){NGL.Parser.call(this,a,b||{});this.volume=new NGL.Volume(this.name,this.path)};
NGL.VolumeParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.VolumeParser,type:"volume",__objName:"volume",_afterParse:function(){this.volume.setMatrix(this.getMatrix())},getMatrix:function(){return new THREE.Matrix4}});NGL.MrcParser=function(a,b){NGL.VolumeParser.call(this,a,b)};
NGL.MrcParser.prototype=NGL.createObject(NGL.VolumeParser.prototype,{constructor:NGL.MrcParser,type:"mrc",_parse:function(a){NGL.debug&&NGL.time("NGL.MrcParser._parse "+this.name);var b=this.streamer.data;b instanceof Uint8Array&&(b=b.buffer);var c=this.volume,d={},e=new Int32Array(b,0,56),f=new Float32Array(b,0,56),g=new DataView(b);d.MAP=String.fromCharCode(g.getUint8(208),g.getUint8(209),g.getUint8(210),g.getUint8(211));d.MACHST=[g.getUint8(212),g.getUint8(213)];if(17===d.MACHST[0]&&17===d.MACHST[1])for(var h=
b.byteLength,k=0;k<h;k+=4)g.setFloat32(k,g.getFloat32(k),!0);d.NX=e[0];d.NY=e[1];d.NZ=e[2];d.MODE=e[3];d.NXSTART=e[4];d.NYSTART=e[5];d.NZSTART=e[6];d.MX=e[7];d.MY=e[8];d.MZ=e[9];d.xlen=f[10];d.ylen=f[11];d.zlen=f[12];d.alpha=f[13];d.beta=f[14];d.gamma=f[15];d.MAPC=e[16];d.MAPR=e[17];d.MAPS=e[18];d.DMIN=f[19];d.DMAX=f[20];d.DMEAN=f[21];d.ISPG=e[22];d.NSYMBT=e[23];d.LSKFLG=e[24];d.originX=f[49];d.originY=f[50];d.originZ=f[51];d.ARMS=f[54];c.header=d;b=new Float32Array(b,1024+d.NSYMBT,d.NX*d.NY*d.NZ);
c.setData(b,d.NX,d.NY,d.NZ);NGL.debug&&NGL.timeEnd("NGL.MrcParser._parse "+this.name);a()},getMatrix:function(){var a=this.volume.header,b=[a.xlen,0,0],c=[a.ylen*Math.cos(Math.PI/180*a.gamma),a.ylen*Math.sin(Math.PI/180*a.gamma),0],d=[a.zlen*Math.cos(Math.PI/180*a.beta),a.zlen*(Math.cos(Math.PI/180*a.alpha)-Math.cos(Math.PI/180*a.gamma)*Math.cos(Math.PI/180*a.beta))/Math.sin(Math.PI/180*a.gamma),0];d[2]=Math.sqrt(a.zlen*a.zlen*Math.sin(Math.PI/180*a.beta)*Math.sin(Math.PI/180*a.beta)-d[1]*d[1]);var b=
[0,b,c,d],c=[0,a.MX,a.MY,a.MZ],d=[0,a.MAPC,a.MAPR,a.MAPS],e=new THREE.Matrix4;e.set(b[d[1]][0]/c[d[1]],b[d[2]][0]/c[d[2]],b[d[3]][0]/c[d[3]],0,b[d[1]][1]/c[d[1]],b[d[2]][1]/c[d[2]],b[d[3]][1]/c[d[3]],0,b[d[1]][2]/c[d[1]],b[d[2]][2]/c[d[2]],b[d[3]][2]/c[d[3]],0,0,0,0,1);e.setPosition(new THREE.Vector3(a.originX,a.originY,a.originZ));e.multiply((new THREE.Matrix4).makeTranslation(a.NXSTART,a.NYSTART,a.NZSTART));return e}});NGL.CubeParser=function(a,b){NGL.VolumeParser.call(this,a,b)};
NGL.CubeParser.prototype=NGL.createObject(NGL.VolumeParser.prototype,{constructor:NGL.CubeParser,type:"cube",_parse:function(a){function b(a,b){var c=d[a].trim().split(f)[b];return parseFloat(c)}NGL.debug&&NGL.time("NGL.CubeParser._parse "+this.name);var c=this.volume,d=this.streamer.peekLines(6),e={},f=/\s+/;e.atomCount=Math.abs(b(2,0));e.originX=.529177210859*b(2,1);e.originY=.529177210859*b(2,2);e.originZ=.529177210859*b(2,3);e.NVX=b(3,0);e.NVY=b(4,0);e.NVZ=b(5,0);e.AVX=.529177210859*b(3,1);e.AVY=
.529177210859*b(4,2);e.AVZ=.529177210859*b(5,3);var g=new Float32Array(e.NVX*e.NVY*e.NVZ),h=0,k=0;this.streamer.eachChunkOfLines(function(a,b,c){b=a.length;for(c=0;c<b;++c){var d=a[c].trim();if(""!==d&&k>=e.atomCount+6)for(var d=d.split(f),q=0,r=d.length;q<r;++q)1!==d.length&&(g[h]=parseFloat(d[q]),++h);++k}});c.header=e;c.setData(g,e.NVZ,e.NVY,e.NVX);NGL.debug&&NGL.timeEnd("NGL.CubeParser._parse "+this.name);a()},getMatrix:function(){var a=this.volume.header,b=new THREE.Matrix4;b.multiply((new THREE.Matrix4).makeRotationY(THREE.Math.degToRad(90)));
b.multiply((new THREE.Matrix4).makeTranslation(-a.originZ,a.originY,a.originX));b.multiply((new THREE.Matrix4).makeScale(-a.AVZ,a.AVY,a.AVX));return b}});NGL.DxParser=function(a,b){NGL.VolumeParser.call(this,a,b)};
NGL.DxParser.prototype=NGL.createObject(NGL.VolumeParser.prototype,{constructor:NGL.DxParser,type:"dx",_parse:function(a){NGL.debug&&NGL.time("NGL.DxParser._parse "+this.name);var b=this.volume,c=this.streamer.peekLines(30),c=this.parseHeaderLines(c),d=this.volume.header,e=c.dataLineStart,f=/\s+/,g=d.nx*d.ny*d.nz,h=new Float32Array(g),k=0,l=0;this.streamer.eachChunkOfLines(function(a,b,c){b=a.length;for(c=0;c<b;++c){if(k<g&&l>e){var d=a[c].trim();if(""!==d)for(var d=d.split(f),r=0,t=d.length;r<t;++r)h[k]=
parseFloat(d[r]),++k}++l}});b.setData(h,d.nz,d.ny,d.nx);NGL.debug&&NGL.timeEnd("NGL.DxParser._parse "+this.name);a()},parseHeaderLines:function(a){for(var b={},c=/\s+/,d=a.length,e=0,f=0,g=0,h=0;h<d;++h){var k=a[h];if(k.startsWith("object 1")){var l=k.split(c);b.nx=parseInt(l[5]);b.ny=parseInt(l[6]);b.nz=parseInt(l[7])}else if(k.startsWith("origin"))l=k.split(c),b.xmin=parseFloat(l[1]),b.ymin=parseFloat(l[2]),b.zmin=parseFloat(l[3]);else if(k.startsWith("delta"))l=k.split(c),0===g?b.hx=parseFloat(l[1]):
1===g?b.hy=parseFloat(l[2]):2===g&&(b.hz=parseFloat(l[3])),g+=1;else if(k.startsWith("object 3")){e=h;f+=k.length+1;break}f+=k.length+1}this.volume.header=b;return{dataLineStart:e,headerByteCount:f}},getMatrix:function(){var a=this.volume.header,b=new THREE.Matrix4;b.multiply((new THREE.Matrix4).makeRotationY(THREE.Math.degToRad(90)));b.multiply((new THREE.Matrix4).makeTranslation(-a.zmin,a.ymin,a.xmin));b.multiply((new THREE.Matrix4).makeScale(-a.hz,a.hy,a.hx));return b}});
NGL.DxbinParser=function(a,b){NGL.DxParser.call(this,a,b)};
NGL.DxbinParser.prototype=NGL.createObject(NGL.DxParser.prototype,{constructor:NGL.DxbinParser,type:"dxbin",_parse:function(a){NGL.debug&&NGL.time("NGL.DxbinParser._parse "+this.name);var b=this.streamer.data;b instanceof Uint8Array&&(b=b.buffer);for(var c=NGL.Uint8ToLines(new Uint8Array(b,0,1E3)),d=this.parseHeaderLines(c),c=this.volume.header,d=d.headerByteCount,e=c.nx*c.ny*c.nz,b=new DataView(b),f=new Float32Array(e),g=0;g<e;++g)f[g]=b.getFloat64(8*g+d,!0);this.volume.setData(f,c.nz,c.ny,c.nx);
NGL.debug&&NGL.timeEnd("NGL.DxbinParser._parse "+this.name);a()}});NGL.SurfaceParser=function(a,b){NGL.Parser.call(this,a,b||{});this.loader=void 0;this.surface=new NGL.Surface(this.name,this.path)};NGL.SurfaceParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.SurfaceParser,type:"surface",__objName:"surface",_parse:function(a){var b=this.loader.parse(this.streamer.asText());this.surface.fromGeometry(b);a()}});
NGL.PlyParser=function(a,b){NGL.SurfaceParser.call(this,a,b||{});this.loader=new THREE.PLYLoader};NGL.PlyParser.prototype=NGL.createObject(NGL.SurfaceParser.prototype,{constructor:NGL.PlyParser,type:"ply"});NGL.ObjParser=function(a,b){NGL.SurfaceParser.call(this,a,b||{});this.loader=new THREE.OBJLoader};NGL.ObjParser.prototype=NGL.createObject(NGL.SurfaceParser.prototype,{constructor:NGL.ObjParser,type:"obj"});
NGL.TextParser=function(a,b){NGL.Parser.call(this,a,b||{});this.text={name:this.name,path:this.path,data:""}};NGL.TextParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.TextParser,type:"text",__objName:"text",_parse:function(a){this.text.data=this.streamer.asText();a()}});NGL.CsvParser=function(a,b){NGL.Parser.call(this,a,b||{});this.table={name:this.name,path:this.path,colNames:[],data:[]}};
NGL.CsvParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.CsvParser,type:"csv",__objName:"table",_parse:function(a){var b=this.table.data,c=/\s*,\s*/;this.streamer.eachChunkOfLines(function(a,e,f){f=a.length;for(var g=0;g<f;++g){var h=a[g].trim(),k=h.split(c);0===e&&0===g?this.table.colNames=k:h&&b.push(k)}}.bind(this));a()}});NGL.JsonParser=function(a,b){NGL.Parser.call(this,a,b||{});this.json={name:this.name,path:this.path,data:{}}};
NGL.JsonParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.JsonParser,type:"json",__objName:"json",_parse:function(a){this.json.data=JSON.parse(this.streamer.asText());a()}});NGL.XmlParser=function(a,b){NGL.Parser.call(this,a,b||{});this.xml={name:this.name,path:this.path,data:{}}};
NGL.XmlParser.prototype=NGL.createObject(NGL.Parser.prototype,{constructor:NGL.XmlParser,type:"xml",__objName:"xml",_parse:function(a){this.xml.data=function(a){function c(){var f=e(/^<([\w-:.]+)\s*/);if(f){for(f={name:f[1],attributes:{},children:[]};0!=a.length&&0!=a.indexOf(">")&&0!=a.indexOf("?>")&&0!=a.indexOf("/>");){var g=d();if(!g)return f;f.attributes[g.name]=g.value}if(e(/^\s*\/>\s*/))return f;e(/\??>\s*/);g=(g=e(/^([^<]*)/))?g[1]:"";for(f.content=g;g=c();)f.children.push(g);e(/^<\/[\w-:.]+>\s*/);
return f}}function d(){var a=e(/([\w:-]+)\s*=\s*("[^"]*"|'[^']*'|\w+)\s*/);if(a)return{name:a[1],value:a[2].replace(/^['"]|['"]$/g,"")}}function e(c){if(c=a.match(c))return a=a.slice(c[0].length),c}a=a.trim();a=a.replace(/\x3c!--[\s\S]*?--\x3e/g,"");return{declaration:function(){if(e(/^<\?xml\s*/)){for(var c={attributes:{}};0!=a.length&&0!=a.indexOf("?>");){var g=d();if(!g)return c;c.attributes[g.name]=g.value}e(/\?>\s*/);return c}}(),root:c()}}(this.streamer.asText());a()}});
NGL.PdbWriter=function(a,b){function c(a,b){return void 0!==a?a:b}function d(){l.forEach(function(a){m.push(sprintf("REMARK %-73s",a))});a.trajectory&&(m.push(sprintf("REMARK %-73s","Trajectory '"+a.trajectory.name+"'")),m.push(sprintf("REMARK %-73s","Frame "+a.trajectory.frame+"")))}function e(){var b=1,d=1;a.eachModel(function(a){m.push(sprintf("MODEL %-74d",d++));a.eachAtom(function(a){var d=a.hetero?p:n,e=k?b:a.serial,f=a.atomname;1===f.length&&(f=" "+f);m.push(sprintf(d,e,f,a.resname,c(a.chainname,
" "),a.resno,a.x,a.y,a.z,c(a.occurence,1),c(a.bfactor,0),c(a.segid,""),c(a.element,"")));b+=1});m.push(sprintf("%-80s","ENDMDL"));d+=1});m.push(sprintf("%-80s","END"))}function f(){m=[];m.push(sprintf("TITEL %-74s",a.name));d();e();return m.join("\n")}function g(){return new Blob([f()],{type:"text/plain"})}var h=Object.assign({},b),k=void 0!==h.renumberSerial?h.renumberSerial:!0,l=h.remarks||[];Array.isArray(l)||(l=[l]);var m,n="ATOM  %5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s",
p="HETATM%5d %-4s %3s %1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s%2s";this.getString=f;this.getBlob=g;this.download=function(a,b){var c=(a||"structure")+"."+(b||"pdb"),d=g();NGL.download(d,c)}};
NGL.DatasourceRegistry={sourceDict:{},listing:void 0,trajectory:void 0,__passThrough:{getUrl:function(a){return a}},add:function(a,b){a=a.toLowerCase();a in this.sourceDict&&NGL.warn("overwriting datasource named '"+a+"'");this.sourceDict[a]=b},get:function(a){a=(a||"").toLowerCase();if(a in this.sourceDict)return this.sourceDict[a];if(-1===["http","https","ftp"].indexOf(a)&&a)NGL.error("no datasource named '"+a+"' found");else return this.__passThrough}};
NGL.getDataInfo=function(a){var b=NGL.getFileInfo(a),c=NGL.DatasourceRegistry.get(b.protocol),b=c.getUrl(b.src),b=NGL.getFileInfo(b);!b.ext&&c.getExt&&(b.ext=c.getExt(a));return b};NGL.StaticDatasource=function(a){a=a||"";this.getUrl=function(b){b=NGL.getFileInfo(b);return NGL.getAbsolutePath(a+b.path)}};
NGL.RcsbDatasource=function(){this.getUrl=function(a){a=NGL.getFileInfo(a);return-1===["pdb","cif"].indexOf(a.ext)||!1!==a.compressed&&"gz"!==a.compressed?"mmtf"===a.ext?a.base.endsWith(".bb")?"http://mmtf.rcsb.org/reduced/"+a.name:"http://mmtf.rcsb.org/v0/full/"+a.name:a.ext?(console.warn("unsupported ext",a.ext),"http://mmtf.rcsb.org/v0/full/"+a.name):"http://files.rcsb.org/download/"+a.name+".cif":"http://files.rcsb.org/download/"+a.path};this.getExt=function(a){a=NGL.getFileInfo(a);if("mmtf"===
a.ext||!a.ext)return"mmtf"}};NGL.DatasourceRegistry.add("rcsb",new NGL.RcsbDatasource);
NGL.Loader=function(a,b){var c=Object.assign({},b),d=-1!=="mmtf dcd mrc ccp4 map dxbin".split(" ").indexOf(c.ext);this.compressed=c.compressed||!1;this.binary=void 0!==c.binary?c.binary:d;this.name=c.name||"";this.ext=c.ext||"";this.dir=c.dir||"";this.path=c.path||"";this.protocol=c.protocol||"";this.params=b;d={compressed:this.compressed,binary:this.binary};this.streamer=self.File&&a instanceof File||self.Blob&&a instanceof self.Blob?new NGL.FileStreamer(a,d):new NGL.NetworkStreamer(a,d);"function"===
typeof c.onProgress&&(this.streamer.onprogress=c.onprogress)};NGL.Loader.prototype={constructor:NGL.Loader,load:function(){return new Promise(function(a,b){this.streamer.onerror=b;try{this._load(a,b)}catch(c){b(c)}}.bind(this))},_load:function(a,b){b("not implemented")}};NGL.ParserLoader=function(a,b){NGL.Loader.call(this,a,b);this.useWorker=void 0===this.params.useWorker?!1:this.params.useWorker};
NGL.ParserLoader.prototype=NGL.createObject(NGL.Loader.prototype,{constructor:NGL.ParserLoader,_load:function(a,b){var c=new {gro:NGL.GroParser,pdb:NGL.PdbParser,pdb1:NGL.PdbParser,ent:NGL.PdbParser,pqr:NGL.PqrParser,cif:NGL.CifParser,mcif:NGL.CifParser,mmcif:NGL.CifParser,sdf:NGL.SdfParser,mol2:NGL.Mol2Parser,mmtf:NGL.MmtfParser,dcd:NGL.DcdParser,mrc:NGL.MrcParser,ccp4:NGL.MrcParser,map:NGL.MrcParser,cube:NGL.CubeParser,dx:NGL.DxParser,dxbin:NGL.DxbinParser,ply:NGL.PlyParser,obj:NGL.ObjParser,txt:NGL.TextParser,
text:NGL.TextParser,csv:NGL.CsvParser,json:NGL.JsonParser,xml:NGL.XmlParser}[this.ext](this.streamer,this.params);this.useWorker?c.parseWorker(a):c.parse(a)}});NGL.ScriptLoader=function(a,b){NGL.Loader.call(this,a,b)};NGL.ScriptLoader.prototype=NGL.createObject(NGL.Loader.prototype,{constructor:NGL.ScriptLoader,_load:function(a,b){this.streamer.read(function(){var b=this.streamer.asText(),b=new NGL.Script(b,this.name,this.path);a(b)}.bind(this))}});
NGL.PluginLoader=function(a,b){NGL.Loader.call(this,a,b)};
NGL.PluginLoader.prototype=NGL.createObject(NGL.Loader.prototype,{constructor:NGL.PluginLoader,_load:function(a,b){var c;c=this.protocol?this.protocol+"://"+this.dir:this.dir;this.streamer.read(function(){var b=JSON.parse(this.streamer.asText()),e=[];b.files.map(function(a){e.push(NGL.autoLoad(c+a,{ext:"text",useWorker:!1}))});Promise.all(e).then(function(c){c=c.reduce(function(a,b){return a+"\n\n"+b.data},"");c+=b.source||"";c=new NGL.Script(c,this.name,this.path);a(c)}.bind(this))}.bind(this))}});
NGL.loaderMap={gro:NGL.ParserLoader,pdb:NGL.ParserLoader,pdb1:NGL.ParserLoader,ent:NGL.ParserLoader,pqr:NGL.ParserLoader,cif:NGL.ParserLoader,mcif:NGL.ParserLoader,mmcif:NGL.ParserLoader,sdf:NGL.ParserLoader,mol2:NGL.ParserLoader,mmtf:NGL.ParserLoader,dcd:NGL.ParserLoader,mrc:NGL.ParserLoader,ccp4:NGL.ParserLoader,map:NGL.ParserLoader,cube:NGL.ParserLoader,dx:NGL.ParserLoader,dxbin:NGL.ParserLoader,obj:NGL.ParserLoader,ply:NGL.ParserLoader,txt:NGL.ParserLoader,text:NGL.ParserLoader,csv:NGL.ParserLoader,
json:NGL.ParserLoader,xml:NGL.ParserLoader,ngl:NGL.ScriptLoader,plugin:NGL.PluginLoader};NGL.autoLoad=function(a,b){var c=Object.assign(NGL.getDataInfo(a),b),d=new NGL.loaderMap[c.ext](c.src,c);return d?d.load():Promise.reject("NGL.autoLoading: ext '"+c.ext+"' unknown")};
NGL.Resources={"shader/CylinderImpostor.vert":null,"shader/CylinderImpostor.frag":null,"shader/HyperballStickImpostor.vert":null,"shader/HyperballStickImpostor.frag":null,"shader/Line.vert":null,"shader/Line.frag":null,"shader/Mesh.vert":null,"shader/Mesh.frag":null,"shader/Point.vert":null,"shader/Point.frag":null,"shader/Quad.vert":null,"shader/Quad.frag":null,"shader/Ribbon.vert":null,"shader/SDFFont.vert":null,"shader/SDFFont.frag":null,"shader/SphereImpostor.vert":null,"shader/SphereImpostor.frag":null,
"shader/chunk/dull_interior_fragment.glsl":null,"shader/chunk/fog_fragment.glsl":null,"shader/chunk/nearclip_fragment.glsl":null,"shader/chunk/nearclip_vertex.glsl":null,"shader/chunk/opaque_back_fragment.glsl":null};
NGL.Utils={lineLineIntersect:function(a,b,c,d){var e=NGL.EPS,f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3,k,l;f.x=a.x-c.x;f.y=a.y-c.y;f.z=a.z-c.z;g.x=d.x-c.x;g.y=d.y-c.y;g.z=d.z-c.z;if(Math.abs(g.x)<e&&Math.abs(g.y)<e&&Math.abs(g.z)<e)return null;h.x=b.x-a.x;h.y=b.y-a.y;h.z=b.z-a.z;if(Math.abs(h.x)<e&&Math.abs(h.y)<e&&Math.abs(h.z)<e)return null;b=f.x*g.x+f.y*g.y+f.z*g.z;d=g.x*h.x+g.y*h.y+g.z*h.z;k=f.x*h.x+f.y*h.y+f.z*h.z;f=g.x*g.x+g.y*g.y+g.z*g.z;l=(h.x*h.x+h.y*h.y+h.z*h.z)*f-d*d;
if(Math.abs(l)<e)return null;e=(b*d-k*f)/l;b=(b+d*e)/f;a=new THREE.Vector3(a.x+e*h.x,a.y+e*h.y,a.z+e*h.z);c=new THREE.Vector3(c.x+b*g.x,c.y+b*g.y,c.z+b*g.z);return[a,c]},circularMean:function(){var a=2*Math.PI;return function(b,c,d,e,f){d=d||1;e=e||0;var g=f?f.length:b.length,h,k,l=0,m=0;if(f)for(k=0;k<g;++k)h=(b[f[k]*d+e]+c)%c,h=h/c*a-Math.PI,l+=Math.cos(h),m+=Math.sin(h);else for(k=e;k<g;k+=d)h=(b[k]+c)%c,h=h/c*a-Math.PI,l+=Math.cos(h),m+=Math.sin(h);return(Math.atan2(m/g,l/g)+Math.PI)/a*c}}(),
calculateCenterArray:function(a,b,c,d){var e=a.length;c=c||new Float32Array(e);d=d||0;for(var f=0;f<e;f+=3)c[d+f+0]=(a[f+0]+b[f+0])/2,c[d+f+1]=(a[f+1]+b[f+1])/2,c[d+f+2]=(a[f+2]+b[f+2])/2;return c},calculateDirectionArray:function(a,b){for(var c=a.length,d=new Float32Array(c),e=0;e<c;e+=3)d[e+0]=b[e+0]-a[e+0],d[e+1]=b[e+1]-a[e+1],d[e+2]=b[e+2]-a[e+2];return d},positionFromGeometry:function(a){a=a.vertices;for(var b,c,d=a.length,e=new Float32Array(3*d),f=0;f<d;f++)b=3*f,c=a[f],e[b+0]=c.x,e[b+1]=c.y,
e[b+2]=c.z;return e},colorFromGeometry:function(a){for(var b=a.faces,c,d,e=b.length,f=new Float32Array(3*a.vertices.length),g=0;g<e;g++)c=b[g],d=c.color,a=3*c.a,f[a+0]=d.r,f[a+1]=d.g,f[a+2]=d.b,a=3*c.b,f[a+0]=d.r,f[a+1]=d.g,f[a+2]=d.b,a=3*c.c,f[a+0]=d.r,f[a+1]=d.g,f[a+2]=d.b;return f},indexFromGeometry:function(a){a=a.faces;for(var b,c,d=a.length,e=new (65535<3*d?Uint32Array:Uint16Array)(3*d),f=0;f<d;f++)b=3*f,c=a[f],e[b+0]=c.a,e[b+1]=c.b,e[b+2]=c.c;return e},normalFromGeometry:function(a){for(var b=
a.faces,c,d,e,f,g=b.length,h=new Float32Array(3*a.vertices.length),k=0;k<g;k++)a=b[k],c=a.vertexNormals,d=c[0],e=c[1],f=c[2],c=3*a.a,h[c+0]=d.x,h[c+1]=d.y,h[c+2]=d.z,c=3*a.b,h[c+0]=e.x,h[c+1]=e.y,h[c+2]=e.z,c=3*a.c,h[c+0]=f.x,h[c+1]=f.y,h[c+2]=f.z;return h},uniformArray:function(a,b){for(var c=new Float32Array(a),d=0;d<a;++d)c[d]=b;return c},uniformArray3:function(a,b,c,d){for(var e=new Float32Array(3*a),f,g=0;g<a;++g)f=3*g,e[f+0]=b,e[f+1]=c,e[f+2]=d;return e},randomColorArray:function(a){for(var b=
new Float32Array(3*a),c,d=0;d<a;++d)c=3*d,b[c+0]=Math.random(),b[c+1]=Math.random(),b[c+2]=Math.random();return b},replicateArray3Entries:function(a,b){for(var c=a.length/3,d=new Float32Array(c*b*3),e=0;e<c;++e)for(var f=3*e,g=e*b*3,h=a[f+0],k=a[f+1],f=a[f+2],l=0;l<b;++l){var m=g+3*l;d[m+0]=h;d[m+1]=k;d[m+2]=f}return d},calculateMeanArray:function(a,b){for(var c=a.length,d=new Float32Array(c),e=0;e<c;e++)d[e]=(a[e]+b[e])/2;return d},calculateMinArray:function(a,b){for(var c=a.length,d=new Float32Array(c),
e=0;e<c;e++)d[e]=Math.min(a[e],b[e]);return d},calculateMeanVector3:function(a){var b=a.length,c=a.length/3,d=0,e=0,f=0,g;for(g=0;g<b;g+=3)d+=a[g+0],e+=a[g+1],f+=a[g+2];return new THREE.Vector3(d/c,e/c,f/c)},isPointOnSegment:function(a,b,c){var d=b.distanceTo(c);return a.distanceTo(b)<=d&&a.distanceTo(c)<=d},pointVectorIntersection:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c,d,e){a.copy(e);b.subVectors(c,d);c=Math.cos(a.angleTo(b))*b.length();c=a.normalize().multiplyScalar(c);
return(new THREE.Vector3).addVectors(c,d)}}(),copyArray:function(a,b,c,d,e){var f;for(f=0;f<e;++f)b[d+f]=a[c+f]}};
NGL.getShader=function(){function a(a){if(void 0===a)return"";var b=[],c;for(c in a){var g=a[c];!1!==g&&b.push("#define "+c+" "+g)}return b.join("\n")+"\n"}var b=/^(?!\/\/)\s*#include\s+(\S+)/gmi,c={};return function(d,e){e=e||{};var f=d+"|",g;for(g in e)f+=g+":"+e[g];if(!c[f]){g=a(e);var h=NGL.Resources["shader/"+d];if(!h)throw"empty shader, '"+d+"'";h=h.replace(b,function(a,b){var c=NGL.Resources["shader/chunk/"+b+".glsl"]||THREE.ShaderChunk[b];return c?c:""});c[f]=g+h}return c[f]}}();
NGL.trimCanvas=function(a,b,c,d,e){var f=a.height,g=a.width,h=a.getContext("2d").getImageData(0,0,g,f).data,k,l,m;m=!1;for(l=0;l<f;l++){for(k=0;k<g;k++){var n=4*(l*g+k);if(h[n]!==b||h[n+1]!==c||h[n+2]!==d||h[n+3]!==e){m=!0;break}}if(m)break}var p=l;m=!1;for(k=0;k<g;k++){for(l=0;l<f;l++)if(n=4*(l*g+k),h[n]!==b||h[n+1]!==c||h[n+2]!==d||h[n+3]!==e){m=!0;break}if(m)break}var q=k;m=!1;for(l=f-1;0<=l;l--){for(k=g-1;0<=k;k--)if(n=4*(l*g+k),h[n]!==b||h[n+1]!==c||h[n+2]!==d||h[n+3]!==e){m=!0;break}if(m)break}var r=
l;m=!1;for(k=g-1;0<=k;k--){for(l=f-1;0<=l;l--)if(n=4*(l*g+k),h[n]!==b||h[n+1]!==c||h[n+2]!==d||h[n+3]!==e){m=!0;break}if(m)break}b=k;c=document.createElement("canvas");c.style.display="hidden";document.body.appendChild(c);c.width=b-q;c.height=r-p;c.getContext("2d").drawImage(a,q,p,c.width,c.height,0,0,c.width,c.height);return c};
NGL.JitterVectors=[[[0,0]],[[4,4],[-4,-4]],[[-2,-6],[6,-2],[-6,2],[2,6]],[[1,-3],[-1,3],[5,1],[-3,-5],[-5,5],[-7,-1],[3,7],[7,-7]],[[1,1],[-1,-3],[-3,2],[4,-1],[-5,-2],[2,5],[5,3],[3,-5],[-2,6],[0,-7],[-4,-6],[-6,4],[-8,0],[7,-4],[6,7],[-7,-8]],[[-4,-7],[-7,-5],[-3,-5],[-5,-4],[-1,-4],[-2,-2],[-6,-1],[-4,0],[-7,1],[-1,2],[-6,3],[-3,3],[-7,6],[-3,6],[-5,7],[-1,7],[5,-7],[1,-6],[6,-5],[4,-4],[2,-3],[7,-2],[1,-1],[4,-1],[2,1],[6,2],[0,4],[4,4],[2,5],[7,5],[5,6],[3,7]]];
NGL.JitterVectors.forEach(function(a){a.forEach(function(a){a[0]*=.0625;a[1]*=.0625})});NGL.Stats=function(){this.signals={updated:new signals.Signal};this.begin();this.maxDuration=-Infinity;this.minDuration=Infinity;this.avgDuration=14;this.lastDuration=Infinity;this.prevFpsTime=0;this.lastFps=Infinity;this.lastFrames=1;this.count=this.frames=0};
NGL.Stats.prototype={update:function(){this.startTime=this.end();this.signals.updated.dispatch()},begin:function(){this.startTime=performance.now();this.lastFrames=this.frames},end:function(){var a=performance.now();this.count+=1;this.frames+=1;this.lastDuration=a-this.startTime;this.minDuration=Math.min(this.minDuration,this.lastDuration);this.maxDuration=Math.max(this.maxDuration,this.lastDuration);this.avgDuration-=this.avgDuration/30;this.avgDuration+=this.lastDuration/30;a>this.prevFpsTime+1E3&&
(this.lastFps=this.frames,this.prevFpsTime=a,this.frames=0);return a}};
NGL.Viewer=function(a,b){this.signals={orientationChanged:new signals.Signal};this.container=a?document.getElementById(a):document.createElement("div");if(this.container===document)this.width=window.innerWidth,this.height=window.innerHeight;else{var c=this.container.getBoundingClientRect();this.width=c.width;this.height=c.height}this.aspect=this.width/this.height;this.initParams();this.initStats();this.initCamera();this.initScene();!1!==this.initRenderer()&&(this.initControls(),this.initHelper(),
this._render=this.render.bind(this),this._animate=this.animate.bind(this),this.setBackground(),this.setFog(),this.boundingBox=new THREE.Box3,this.distVector=new THREE.Vector3,this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}})};
NGL.Viewer.prototype={constructor:NGL.Viewer,initParams:function(){this.params={fogColor:new THREE.Color(0),fogNear:50,fogFar:100,backgroundColor:new THREE.Color(0),cameraType:1,cameraFov:40,cameraZ:-80,clipNear:0,clipFar:100,clipDist:10,spinAxis:null,spinAngle:.01,lightColor:new THREE.Color(14540253),lightIntensity:1,ambientColor:new THREE.Color(14540253),ambientIntensity:.2,holdRendering:!1,sampleLevel:0}},initCamera:function(){var a=this.params,b=new THREE.Vector3(0,0,0);this.perspectiveCamera=
new THREE.PerspectiveCamera(a.cameraFov,this.aspect,.1,1E4);this.perspectiveCamera.position.z=a.cameraZ;this.perspectiveCamera.lookAt(b);this.camera=this.perspectiveCamera;this.camera.updateProjectionMatrix()},initRenderer:function(){try{this.renderer=new THREE.WebGLRenderer({preserveDrawingBuffer:!0,alpha:!0,antialias:!0})}catch(a){return this.container.innerHTML=NGL.webglErrorMessage,!1}this.renderer.setPixelRatio(window.devicePixelRatio);this.renderer.setSize(this.width,this.height);this.renderer.autoClear=
!1;this.renderer.sortObjects=!0;NGL.extensionFragDepth=this.renderer.extensions.get("EXT_frag_depth");NGL.indexUint16=!this.renderer.extensions.get("OES_element_index_uint");NGL.supportsReadPixelsFloat="Chrome"===NGL.browser&&this.renderer.extensions.get("OES_texture_float")||this.renderer.extensions.get("OES_texture_float")&&this.renderer.extensions.get("WEBGL_color_buffer_float");this.container.appendChild(this.renderer.domElement);this.renderer.extensions.get("OES_texture_float");NGL.supportsHalfFloat=
this.renderer.extensions.get("OES_texture_half_float");this.renderer.extensions.get("WEBGL_color_buffer_float");this.pickingTarget=new THREE.WebGLRenderTarget(this.width*window.devicePixelRatio,this.height*window.devicePixelRatio,{minFilter:THREE.NearestFilter,magFilter:THREE.NearestFilter,stencilBuffer:!1,format:THREE.RGBAFormat,type:NGL.supportsReadPixelsFloat?THREE.FloatType:THREE.UnsignedByteType});this.pickingTarget.texture.generateMipmaps=!1;this.sampleLevel=0;this.sampleTarget=new THREE.WebGLRenderTarget(this.width*
window.devicePixelRatio,this.height*window.devicePixelRatio,{minFilter:THREE.NearestFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat});this.holdTarget=new THREE.WebGLRenderTarget(this.width*window.devicePixelRatio,this.height*window.devicePixelRatio,{minFilter:THREE.NearestFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat,type:NGL.supportsHalfFloat?THREE.HalfFloatType:THREE.FloatType});this.compositeUniforms={tForeground:{type:"t",value:null},scale:{type:"f",value:1}};this.compositeMaterial=
new THREE.ShaderMaterial({uniforms:this.compositeUniforms,vertexShader:NGL.getShader("Quad.vert"),fragmentShader:NGL.getShader("Quad.frag"),transparent:!0,blending:THREE.CustomBlending,blendSrc:THREE.OneFactor,blendDst:THREE.OneFactor,blendSrcAlpha:THREE.OneFactor,blendDstAlpha:THREE.OneFactor,blendEquation:THREE.AddEquation,depthTest:!1,depthWrite:!1});this.compositeCamera=new THREE.OrthographicCamera(-1,1,1,-1,0,1);this.compositeScene=(new THREE.Scene).add(new THREE.Mesh(new THREE.PlaneGeometry(2,
2),this.compositeMaterial))},initScene:function(){this.scene||(this.scene=new THREE.Scene);this.rotationGroup=new THREE.Group;this.rotationGroup.name="rotationGroup";this.scene.add(this.rotationGroup);this.modelGroup=new THREE.Group;this.modelGroup.name="modelGroup";this.rotationGroup.add(this.modelGroup);this.pickingGroup=new THREE.Group;this.pickingGroup.name="pickingGroup";this.rotationGroup.add(this.pickingGroup);this.backgroundGroup=new THREE.Group;this.backgroundGroup.name="backgroundGroup";
this.rotationGroup.add(this.backgroundGroup);this.helperGroup=new THREE.Group;this.helperGroup.name="helperGroup";this.rotationGroup.add(this.helperGroup);this.modelGroup.fog=new THREE.Fog;this.pointLight=new THREE.SpotLight(this.params.lightColor,this.params.lightIntensity);this.modelGroup.add(this.pointLight);this.ambientLight=new THREE.AmbientLight(this.params.ambientLight,this.params.ambientIntensity);this.modelGroup.add(this.ambientLight)},initHelper:function(){var a=new Uint16Array([0,1,1,2,
2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),b=new Float32Array(24),c=new THREE.BufferGeometry;c.setIndex(new THREE.BufferAttribute(a,1));c.addAttribute("position",new THREE.BufferAttribute(b,3));a=new THREE.LineBasicMaterial({color:"skyblue",linewidth:2});this.boundingBoxMesh=new THREE.LineSegments(c,a);this.helperGroup.add(this.boundingBoxMesh)},updateHelper:function(){var a=this.boundingBoxMesh.geometry.attributes.position,b=a.array,c=this.boundingBox,d=c.min,e=c.max;b[0]=e.x;b[1]=e.y;b[2]=e.z;b[3]=
d.x;b[4]=e.y;b[5]=e.z;b[6]=d.x;b[7]=d.y;b[8]=e.z;b[9]=e.x;b[10]=d.y;b[11]=e.z;b[12]=e.x;b[13]=e.y;b[14]=d.z;b[15]=d.x;b[16]=e.y;b[17]=d.z;b[18]=d.x;b[19]=d.y;b[20]=d.z;b[21]=e.x;b[22]=d.y;b[23]=d.z;a.needsUpdate=!0;c.isEmpty()||this.boundingBoxMesh.geometry.computeBoundingSphere()},initControls:function(){function a(a){a.preventDefault()}this.renderer.domElement.addEventListener("mousewheel",a,!1);this.renderer.domElement.addEventListener("MozMousePixelScroll",a,!1);this.renderer.domElement.addEventListener("touchmove",
a,!1);this.controls=new THREE.TrackballControls(this.camera,this.renderer.domElement);this.controls.rotateSpeed=2;this.controls.zoomSpeed=1.2;this.controls.panSpeed=.8;this.controls.staticMoving=!0;this.controls.keys=[65,83,68];this.controls.addEventListener("change",this.requestRender.bind(this));document.addEventListener("mousemove",this.controls.update.bind(this.controls),!1);document.addEventListener("touchmove",this.controls.update.bind(this.controls),!1);this.controls.addEventListener("change",
function(){this.signals.orientationChanged.dispatch()}.bind(this),!1)},initStats:function(){this.stats=new NGL.Stats},add:function(a,b){b?b.forEach(function(b){this.addBuffer(a,b)},this):this.addBuffer(a);a.background?(this.backgroundGroup.add(a.group),this.backgroundGroup.add(a.wireframeGroup)):(this.modelGroup.add(a.group),this.modelGroup.add(a.wireframeGroup));a.pickable&&this.pickingGroup.add(a.pickingGroup);this.rotationGroup.updateMatrixWorld();NGL.debug&&this.updateHelper()},addBuffer:function(a,
b){var c=a.getMesh();c.userData.buffer=a;b&&(c.applyMatrix(b.matrix),c.userData.instance=b);a.group.add(c);var d=a.getWireframeMesh();d.userData.buffer=a;b&&(d.matrix.copy(c.matrix),d.position.copy(c.position),d.quaternion.copy(c.quaternion),d.scale.copy(c.scale),d.userData.instance=b);a.wireframeGroup.add(d);a.pickable&&(d=a.getPickingMesh(),d.userData.buffer=a,b&&(d.matrix.copy(c.matrix),d.position.copy(c.position),d.quaternion.copy(c.quaternion),d.scale.copy(c.scale),d.userData.instance=b),a.pickingGroup.add(d));
b?this.updateBoundingBox(a.geometry,b.matrix):this.updateBoundingBox(a.geometry)},remove:function(a){this.rotationGroup.children.forEach(function(b){b.remove(a.group);b.remove(a.wireframeGroup)});a.pickable&&this.pickingGroup.remove(a.pickingGroup);this.updateBoundingBox();NGL.debug&&this.updateHelper()},updateBoundingBox:function(a,b){function c(a,b){0!==a.attributes.position.count&&(a.boundingBox||a.computeBoundingBox(),b?(e=a.boundingBox.clone(),e.applyMatrix4(b)):e=a.boundingBox,e.min.equals(e.max)&&
e.expandByScalar(5),f.expandByPoint(e.min),f.expandByPoint(e.max))}function d(a){if(void 0!==a.geometry){var b=void 0;a.userData.instance&&(b=a.userData.instance.matrix);c(a.geometry,b)}}var e,f=this.boundingBox;a?c(a,b):(f.makeEmpty(),this.modelGroup.traverse(d),this.backgroundGroup.traverse(d));this.controls.maxDistance=10*f.size().length()},getImage:function(){var a=this.renderer;return new Promise(function(b,c){a.domElement.toBlob(b,"image/png")})},makeImage:function(a){return NGL.makeImage(this,
a)},setLight:function(a,b,c,d){var e=this.params;void 0!==a&&e.lightColor.set(a);void 0!==b&&(e.lightIntensity=b);void 0!==c&&e.ambientColor.set(c);void 0!==d&&(e.ambientIntensity=d);this.requestRender()},setFog:function(a,b,c){var d=this.params;void 0!==a&&d.fogColor.set(a);void 0!==b&&(d.fogNear=b);void 0!==c&&(d.fogFar=c);this.requestRender()},setBackground:function(a){var b=this.params;a&&b.backgroundColor.set(a);this.setFog(b.backgroundColor);this.renderer.setClearColor(b.backgroundColor,0);
this.renderer.domElement.style.backgroundColor=b.backgroundColor.getStyle();this.requestRender()},setSampling:function(a){void 0!==a&&(this.sampleLevel=this.params.sampleLevel=a);this.requestRender()},setCamera:function(a,b){var c=this.params;null!==a&&(c.cameraType=a);b&&(c.cameraFov=b);this.camera=this.perspectiveCamera;this.perspectiveCamera.fov=c.cameraFov;this.controls.object=this.camera;this.camera.updateProjectionMatrix();this.requestRender()},setClip:function(a,b,c){var d=this.params;void 0!==
a&&(d.clipNear=a);void 0!==b&&(d.clipFar=b);void 0!==c&&(d.clipDist=c);this.requestRender()},setSpin:function(a,b){var c=this.params;void 0!==a&&(c.spinAxis=a);void 0!==b&&(c.spinAngle=b)},setSize:function(a,b){this.width=a;this.height=b;this.aspect=this.width/this.height;this.perspectiveCamera.aspect=this.aspect;this.camera.updateProjectionMatrix();this.renderer.setPixelRatio(window.devicePixelRatio);this.renderer.setSize(this.width,this.height);this.pickingTarget.setSize(this.width*window.devicePixelRatio,
this.height*window.devicePixelRatio);this.sampleTarget.setSize(this.width*window.devicePixelRatio,this.height*window.devicePixelRatio);this.holdTarget.setSize(this.width*window.devicePixelRatio,this.height*window.devicePixelRatio);this.controls.handleResize();-1===this.params.sampleLevel&&(this.sampleLevel=0);this.requestRender()},handleResize:function(){if(this.container===document)this.setSize(window.innerWidth,window.innerHeight);else{var a=this.container.getBoundingClientRect();this.setSize(a.width,
a.height)}},updateInfo:function(a){var b=this.info,c=b.memory,b=b.render;if(a)c.programs=0,c.geometries=0,c.textures=0,b.calls=0,b.vertices=0,b.faces=0,b.points=0;else{var d=this.renderer.info;a=d.memory;d=d.render;c.programs=a.programs;c.geometries=a.geometries;c.textures=a.textures;b.calls+=d.calls;b.vertices+=d.vertices;b.faces+=d.faces;b.points+=d.points}},rotate:function(){var a=new THREE.Vector3,b=new THREE.Quaternion,c=new THREE.Vector3,d=new THREE.Vector3,e=new THREE.Vector3,f=new THREE.Vector3;
return function(g,h){a.copy(this.camera.position).sub(this.controls.target);c.copy(a).normalize();d.copy(this.camera.up).normalize();e.crossVectors(d,c).normalize();c.setLength(g.z);d.setLength(g.y);e.setLength(g.x);f.copy(e.sub(d).add(c));b.setFromAxisAngle(f.normalize(),h);a.applyQuaternion(b);this.camera.up.applyQuaternion(b);this.camera.position.addVectors(this.controls.target,a);this.camera.lookAt(this.controls.target)}}(),zoom:function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c){a.copy(this.camera.position).sub(this.controls.target);
b.copy(a).normalize();b.setLength(c);a.add(b);this.camera.position.addVectors(this.controls.target,a);this.camera.lookAt(this.controls.target)}}(),animate:function(){this.controls.update();if(500<performance.now()-this.stats.startTime&&!this.still&&3>this.sampleLevel){var a=this.sampleLevel;this.sampleLevel=3;this._renderPending=!0;this.render();this.still=!0;this.sampleLevel=a;NGL.debug&&NGL.log("rendered still frame")}else-1===this.params.sampleLevel&&(30<this.stats.avgDuration?(this.sampleLevel=
Math.max(0,this.sampleLevel-1),NGL.debug&&NGL.log("sample level down",this.sampleLevel),this.stats.count=0):17>this.stats.avgDuration&&60<this.stats.count&&(this.sampleLevel=Math.min(5,this.sampleLevel+1),NGL.debug&&NGL.log("sample level up",this.sampleLevel),this.stats.count=0));a=this.params;a.spinAxis&&a.spinAngle&&(this.rotate(a.spinAxis,a.spinAngle*this.stats.lastDuration/16),this.requestRender());requestAnimationFrame(this._animate)},pick:function(){var a=new Float32Array(4),b=new Uint8Array(4);
return function(c,d){c*=window.devicePixelRatio;d*=window.devicePixelRatio;var e,f,g,h=NGL.supportsReadPixelsFloat?a:b;this.render(null,!0);this.renderer.readRenderTargetPixels(this.pickingTarget,c,d,1,1,h);e=NGL.supportsReadPixelsFloat?Math.round(255*h[0])<<16&16711680|Math.round(255*h[1])<<8&65280|Math.round(255*h[2])&255:h[0]<<16|h[1]<<8|h[2];(f=this.pickingGroup.getObjectById(Math.round(h[3])))&&f.userData.instance&&(g=f.userData.instance);NGL.debug&&(f=Array.apply([],h),NGL.log(h),NGL.log("picked color",
[f[0].toPrecision(2),f[1].toPrecision(2),f[2].toPrecision(2),f[3].toPrecision(2)]),NGL.log("picked gid",e),NGL.log("picked instance",g),NGL.log("picked position",c,d),NGL.log("devicePixelRatio",window.devicePixelRatio));return{gid:e,instance:g}}}(),requestRender:function(){this._renderPending||this.holdRendering||(22<performance.now()-this.stats.startTime&&(this.stats.begin(),this.still=!1),this._renderPending=!0,requestAnimationFrame(function(){this.render();this.stats.update()}.bind(this)))},__updateClipping:function(){var a=
this.params,b=this.camera,c=this.distVector.copy(b.position).sub(this.controls.target).length();c||(b.position.set(0,0,a.cameraZ),c=Math.abs(a.cameraZ));this.cDist=c;var d=Math.max(10,.5*this.boundingBox.size(this.distVector).length());if(Infinity===d||-Infinity===d||isNaN(d))d=50;this.bRadius=d+=this.boundingBox.center(this.distVector).add(this.rotationGroup.position).length();var e=-(50-a.clipFar)/50;b.near=Math.max(.1,a.clipDist,c-(50-a.clipNear)/50*d);b.far=Math.max(1,c+d*e);var b=(50-a.fogNear)/
50,e=-(50-a.fogFar)/50,f=this.modelGroup.fog;f.color.set(a.fogColor);f.near=Math.max(.1,c-d*b);f.far=Math.max(1,c+d*e)},__updateCamera:function(a){var b=this.camera;b.updateMatrix();b.updateMatrixWorld(!0);b.matrixWorldInverse.getInverse(b.matrixWorld);a||this.camera.updateProjectionMatrix();this.updateMaterialUniforms(this.scene,b);this.sortProjectedPosition(this.scene,b)},__updateLights:function(){var a=this.params,b=this.pointLight;b.position.copy(this.camera.position).multiplyScalar(100);b.updateMatrixWorld();
b.color.set(a.lightColor);b.intensity=a.lightIntensity;b=this.ambientLight;b.color.set(a.ambientColor);b.intensity=a.ambientIntensity},__renderPickingGroup:function(){this.renderer.clearTarget(this.pickingTarget);this.renderer.render(this.pickingGroup,this.camera,this.pickingTarget);this.updateInfo();this.renderer.setRenderTarget(null);NGL.debug&&(this.renderer.clear(),this.renderer.render(this.pickingGroup,this.camera),this.renderer.render(this.helperGroup,this.camera))},__renderModelGroup:function(a){a?
this.renderer.clearTarget(a):this.renderer.clear();this.renderer.render(this.backgroundGroup,this.camera,a);a?this.renderer.clearTarget(a,!1,!0,!1):this.renderer.clearDepth();this.updateInfo();this.renderer.render(this.modelGroup,this.camera,a);this.updateInfo();NGL.debug&&this.renderer.render(this.helperGroup,this.camera,a)},__renderMultiSample:function(){var a=this.camera,b=NGL.JitterVectors[Math.max(0,Math.min(this.sampleLevel,5))];this.compositeUniforms.scale.value=1/b.length;this.compositeUniforms.tForeground.value=
this.sampleTarget;this.compositeUniforms.tForeground.needsUpdate=!0;this.compositeMaterial.needsUpdate=!0;for(var c=this.sampleTarget.width,d=this.sampleTarget.height,e=0;e<b.length;++e){var f=b[e];a.setViewOffset&&a.setViewOffset(c,d,f[0],f[1],c,d);this.__updateCamera();this.__renderModelGroup(this.sampleTarget);this.renderer.render(this.compositeScene,this.compositeCamera,this.holdTarget,0===e)}this.renderer.setRenderTarget(null);this.compositeUniforms.scale.value=1;this.compositeUniforms.tForeground.value=
this.holdTarget;this.compositeUniforms.tForeground.needsUpdate=!0;this.compositeMaterial.needsUpdate=!0;this.renderer.clear();this.renderer.render(this.compositeScene,this.compositeCamera);a.setViewOffset&&(a.view=null)},render:function(a,b,c){this._rendering?NGL.warn("tried to call 'render' from within 'render'"):(this._rendering=!0,this.__updateClipping(),this.__updateCamera(c),this.__updateLights(),this.updateInfo(!0),b?this.__renderPickingGroup():0<this.sampleLevel&&!c?this.__renderMultiSample():
this.__renderModelGroup(),this._renderPending=this._rendering=!1)},updateMaterialUniforms:function(){var a=new THREE.Matrix4,b=new THREE.Matrix4;return function(c,d){var e=this.cDist,f=this.bRadius,g=this.height,h=this.renderer.getPixelRatio();a.getInverse(d.projectionMatrix);b.copy(d.projectionMatrix).transpose();c.traverse(function(c){var d=c.material;d&&(c=c.material.uniforms)&&(d.clipNear&&(c.nearClip.value=e-(50-d.clipNear)/50*f),c.canvasHeight&&(c.canvasHeight.value=g),c.pixelRatio&&(c.pixelRatio.value=
h),c.projectionMatrixInverse&&c.projectionMatrixInverse.value.copy(a),c.projectionMatrixTranspose&&c.projectionMatrixTranspose.value.copy(b))})}}(),sortProjectedPosition:function(){var a=new THREE.Vector3,b=new THREE.Matrix4,c=new THREE.Matrix4;return function(d,e){d.traverseVisible(function(d){if(d instanceof THREE.Points&&d.sortParticles){b.multiplyMatrices(e.matrixWorldInverse,d.matrixWorld);c.multiplyMatrices(e.projectionMatrix,b);var g=d.geometry.attributes,h=g.position.count;d.userData.sortData||
(d.userData.sortData={});d=d.userData.sortData;d.__sortArray||(d.__sortArray=new Float32Array(2*h));for(var k=d.__sortArray,l=0;l<h;++l){var m=2*l;a.fromArray(g.position.array,3*l);a.applyProjection(c);k[m]=-a.z;k[m+1]=l}THREE.TypedArrayUtils.quicksortIP(k,2,0);var n,p,q,r,t;for(t in g){var l=g[t],m=l.array,v=l.itemSize;d[t]||(d[t]=new Float32Array(v*h));r=d[t];d[t]=m;for(l=0;l<h;++l){n=k[2*l+1];for(var w=0;w<v;++w)p=n*v+w,q=l*v+w,r[q]=m[p]}g[t].array=r;g[t].needsUpdate=!0}}})}}(),clear:function(){NGL.log("scene cleared");
this.scene.remove(this.rotationGroup);this.initScene();this.renderer.clear()},centerView:function(){var a=new THREE.Vector3,b=new THREE.Vector3,c=new THREE.Vector3,d=new THREE.Vector3;return function(e,f){f=f||this.boundingBox.center();this.controls.object.position.sub(this.controls.target);this.controls.target.copy(this.controls.target0);a.copy(f).multiplyScalar(-1);this.rotationGroup.position.copy(a);this.rotationGroup.updateMatrixWorld();if(e){if(!0===e){this.boundingBox.size(d);var g=Math.max(d.x,
d.y,d.z),h=Math.min(d.x,d.y,d.z),g=g+h/2,h=THREE.Math.degToRad(this.camera.fov);e=g/2/this.camera.aspect/Math.tan(h/2)}e=Math.max(e,1.2*this.params.clipDist);b.copy(this.camera.position).sub(this.controls.target);c.copy(b).normalize();c.setLength(e);b.copy(c);this.camera.position.addVectors(this.controls.target,b)}this.requestRender();this.signals.orientationChanged.dispatch()}}(),getOrientation:function(){return[this.camera.position.toArray(),this.camera.up.toArray(),this.rotationGroup.position.toArray(),
this.controls.target.toArray()]},setOrientation:function(a){this.controls.object.position.sub(this.controls.target);this.controls.target.copy(this.controls.target0);this.controls.target.fromArray(a[3]);this.rotationGroup.position.fromArray(a[2]);this.rotationGroup.updateMatrixWorld();this.camera.up.fromArray(a[1]);this.camera.position.fromArray(a[0]);this.requestRender();this.signals.orientationChanged.dispatch()}};
NGL.TiledRenderer=function(a,b,c,d){d=d||{};this.renderer=a;this.camera=b;this.viewer=c;this.factor=void 0!==d.factor?d.factor:2;this.antialias=void 0!==d.antialias?d.antialias:!1;this.onProgress=d.onProgress;this.onFinish=d.onFinish;this.init()};
NGL.TiledRenderer.prototype={init:function(){this.antialias&&(this.factor*=2);this.n=this.factor*this.factor;var a=document.createElement("canvas");a.style.display="hidden";document.body.appendChild(a);this.antialias?(a.width=this.viewer.width*this.factor/2,a.height=this.viewer.height*this.factor/2):(a.width=this.viewer.width*this.factor,a.height=this.viewer.height*this.factor);this.ctx=a.getContext("2d");this.canvas=a;this.shearMatrix=new THREE.Matrix4;this.scaleMatrix=new THREE.Matrix4;a=THREE.Math.degToRad(.5*
this.camera.fov);this.near=this.camera.near;this.top=Math.tan(a)*this.near;this.bottom=-this.top;this.left=this.camera.aspect*this.bottom;this.right=this.camera.aspect*this.top;this.width=Math.abs(this.right-this.left);this.height=Math.abs(this.top-this.bottom)},makeAsymmetricFrustum:function(a,b){var c=this.factor,d=this.near;this.shearMatrix.set(1,0,(b%c-.5*(c-1))*this.width/d,0,0,1,-(Math.floor(b/c)-.5*(c-1))*this.height/d,0,0,0,1,0,0,0,0,1);this.scaleMatrix.set(c,0,0,0,0,c,0,0,0,0,1,0,0,0,0,1);
a.multiply(this.shearMatrix).multiply(this.scaleMatrix);return a},renderTile:function(a){this.makeAsymmetricFrustum(this.camera.projectionMatrix,a);this.viewer.render(null,null,!0);var b=a%this.factor*this.viewer.width,c=Math.floor(a/this.factor)*this.viewer.height;this.antialias?this.ctx.drawImage(this.renderer.domElement,Math.floor(b/2),Math.floor(c/2),Math.ceil(this.viewer.width/2),Math.ceil(this.viewer.height/2)):this.ctx.drawImage(this.renderer.domElement,Math.floor(b),Math.floor(c),Math.ceil(this.viewer.width),
Math.ceil(this.viewer.height));this.camera.updateProjectionMatrix();if("function"===typeof this.onProgress)this.onProgress(a+1,this.n,!1)},render:function(){for(var a=this.n,b=0;b<=a;++b)if(b===a){if("function"===typeof this.onFinish)this.onFinish(b+1,a,!1)}else this.renderTile(b)},renderAsync:function(){for(var a=this.n,b=this.renderTile.bind(this),c=this.onFinish,d=0;d<=a;++d)setTimeout(function(d){d===a?"function"===typeof c&&c(d+1,a,!1):b(d)},0,d)},dispose:function(){document.body.removeChild(this.canvas)}};
NGL.makeImage=function(a,b){function c(b){var c=h;k&&(c*=2);b&&(c=1/c);a.scene.traverse(function(a){(a=a.material)&&a.linewidth&&(a.linewidth*=c);a&&a.uniforms&&a.uniforms.size&&void 0===a.uniforms.size.__seen&&(a.uniforms.size.value*=c,a.uniforms.size.__seen=!0)});a.scene.traverse(function(a){(a=a.material)&&a.uniforms&&a.uniforms.size&&delete a.uniforms.size.__seen})}function d(a){if(g){var b=q;return NGL.trimCanvas(a,(l?0:255*b.r)|0,(l?0:255*b.g)|0,(l?0:255*b.b)|0,(l?0:255)|0)}return a}function e(a,
b,c){if("function"===typeof f.onProgress)f.onProgress(a,b,c)}var f=b||{},g=void 0!==f.trim?f.trim:!1,h=void 0!==f.factor?f.factor:1,k=void 0!==f.antialias?f.antialias:!1,l=void 0!==f.transparent?f.transparent:!1,m=a.renderer,n=a.camera,p=m.getClearAlpha(),q=m.getClearColor();return new Promise(function(b,f){var g=new NGL.TiledRenderer(m,n,a,{factor:h,antialias:k,onProgress:e,onFinish:function(f,h){d(g.canvas).toBlob(function(d){m.setClearAlpha(p);c(!0);a.requestRender();g.dispose();e(h,h,!0);b(d)},
"image/png")}});m.setClearAlpha(l?0:1);c();g.renderAsync()})};
NGL.DoubleSidedBuffer=function(a){this.size=a.size;this.side=a.side;this.wireframe=a.wireframe;this.visible=a.visible;this.geometry=a.geometry;this.pickable=a.pickable;this.background=a.background;this.group=new THREE.Group;this.wireframeGroup=new THREE.Group;this.pickingGroup=new THREE.Group;var b=[],c=[],d=new a.constructor;a.makeMaterial();d.makeMaterial();d.geometry=a.geometry;d.wireframeGeometry=a.wireframeGeometry;d.size=a.size;d.attributeSize=a.attributeSize;d.pickable=a.pickable;d.setParameters(a.getParameters());
d.updateShader();a.setParameters({side:THREE.FrontSide});d.setParameters({side:THREE.BackSide,opacity:d.opacity});this.getMesh=function(e){var f;e?(f=d.getPickingMesh(),e=a.getPickingMesh()):(f=d.getMesh(),e=a.getMesh());b.push(e);c.push(f);this.setParameters({side:this.side});return(new THREE.Group).add(f,e)};this.getWireframeMesh=function(){return a.getWireframeMesh()};this.getPickingMesh=function(){return this.getMesh(!0)};this.setAttributes=function(b){a.setAttributes(b)};this.setParameters=function(e){e=
Object.assign({},e);e.side===THREE.FrontSide?(b.forEach(function(a){a.visible=!0}),c.forEach(function(a){a.visible=!1})):e.side===THREE.BackSide?(b.forEach(function(a){a.visible=!1}),c.forEach(function(a){a.visible=!0})):e.side===THREE.DoubleSide&&(b.forEach(function(a){a.visible=!0}),c.forEach(function(a){a.visible=!0}));void 0!==e.side&&(this.side=e.side);delete e.side;a.setParameters(e);void 0!==e.wireframe&&(this.wireframe=e.wireframe,this.setVisibility(this.visible));delete e.wireframe;d.setParameters(e)};
this.setVisibility=NGL.Buffer.prototype.setVisibility;this.dispose=function(){a.dispose();d.dispose()}};
NGL.Buffer=function(a,b,c,d,e){e=e||{};this.pickable=!1;this.dynamic=!0;this.opaqueBack=void 0!==e.opaqueBack?e.opaqueBack:!1;this.dullInterior=void 0!==e.dullInterior?e.dullInterior:!1;this.side=void 0!==e.side?e.side:THREE.DoubleSide;this.opacity=void 0!==e.opacity?e.opacity:1;this.clipNear=void 0!==e.clipNear?e.clipNear:0;this.flatShaded=void 0!==e.flatShaded?e.flatShaded:!1;this.background=void 0!==e.background?e.background:!1;this.linewidth=void 0!==e.linewidth?e.linewidth:1;this.wireframe=void 0!==
e.wireframe?e.wireframe:!1;this.wireframeLinewidth=e.wireframeLinewidth||1;this.roughness=void 0!==e.roughness?e.roughness:.4;this.metalness=void 0!==e.metalness?e.metalness:0;this.diffuse=void 0!==e.diffuse?e.diffuse:16777215;this.forceTransparent=void 0!==e.forceTransparent?e.forceTransparent:!1;this.geometry=new THREE.BufferGeometry;this.addAttributes({position:{type:"v3",value:a},color:{type:"c",value:b}});this.indexVersion=0;this.wireframeIndexVersion=-1;c&&(this.geometry.setIndex(new THREE.BufferAttribute(c,
1)),this.geometry.getIndex().setDynamic(this.dynamic));d&&(this.addAttributes({pickingColor:{type:"c",value:d}}),this.pickable=!0);this.uniforms=THREE.UniformsUtils.merge([THREE.UniformsLib.common,{fogColor:{value:null},fogNear:{value:0},fogFar:{value:0},opacity:{value:this.opacity},nearClip:{value:0}},{emissive:{value:new THREE.Color(0)},roughness:{value:this.roughness},metalness:{value:this.metalness}},THREE.UniformsLib.ambient,THREE.UniformsLib.lights]);this.uniforms.diffuse.value.set(this.diffuse);
this.pickingUniforms={nearClip:{value:0},objectId:(new THREE.Uniform(0)).onUpdate(function(a,b){this.value=NGL.supportsReadPixelsFloat?a.id:a.id/255})};this.group=new THREE.Group;this.wireframeGroup=new THREE.Group;this.pickingGroup=new THREE.Group;this.makeWireframeGeometry()};
NGL.Buffer.prototype={constructor:NGL.Buffer,parameters:{opaqueBack:{updateShader:!0},dullInterior:{updateShader:!0},side:{updateShader:!0,property:!0},opacity:{uniform:!0},clipNear:{updateShader:!0,property:!0},flatShaded:{updateShader:!0},background:{updateShader:!0},linewidth:{property:!0},wireframe:{updateVisibility:!0},roughness:{uniform:!0},metalness:{uniform:!0},diffuse:{uniform:!0}},get transparent(){return 1>this.opacity||this.forceTransparent},makeMaterial:function(){this.material=new THREE.ShaderMaterial({uniforms:this.uniforms,
vertexShader:"",fragmentShader:"",depthTest:!0,transparent:this.transparent,depthWrite:!0,lights:!0,fog:!0,side:this.side,linewidth:this.linewidth});this.material.vertexColors=THREE.VertexColors;this.material.extensions.derivatives=this.flatShaded;this.material.extensions.fragDepth=this.impostor;this.material.clipNear=this.clipNear;this.wireframeMaterial=new THREE.ShaderMaterial({uniforms:this.uniforms,vertexShader:"Line.vert",fragmentShader:"Line.frag",depthTest:!0,transparent:this.transparent,depthWrite:!0,
lights:!1,fog:!0,side:this.side,linewidth:this.linewidth});this.wireframeMaterial.vertexColors=THREE.VertexColors;this.wireframeMaterial.clipNear=this.clipNear;this.pickingMaterial=new THREE.ShaderMaterial({uniforms:this.pickingUniforms,vertexShader:"",fragmentShader:"",depthTest:!0,transparent:!1,depthWrite:!0,lights:!1,fog:!1,side:this.side,linewidth:this.linewidth});this.pickingMaterial.vertexColors=THREE.VertexColors;this.pickingMaterial.extensions.fragDepth=this.impostor;this.pickingMaterial.clipNear=
this.clipNear;this.updateShader()},makeWireframeGeometry:function(){this.makeWireframeIndex();var a=this.geometry,b=this.wireframeIndex,c=new THREE.BufferGeometry;c.attributes=a.attributes;b&&(c.setIndex((new THREE.BufferAttribute(b,1)).setDynamic(this.dynamic)),c.setDrawRange(0,this.wireframeIndexCount));this.wireframeGeometry=c},makeWireframeIndex:function(){function a(a,d){if(a>d){var e=a;a=d;d=e}e=b[a];return void 0===e?(b[a]=[d],!0):-1===e.indexOf(d)?(e.push(d),!0):!1}var b=[];return function(){var c=
this.geometry.index;if(!this.wireframe)this.wireframeIndex=new Uint16Array(0),this.wireframeIndexCount=0;else if(c){var c=c.array,d=c.length;Infinity!==this.geometry.drawRange.count&&(d=this.geometry.drawRange.count);var e;e=this.wireframeIndex&&this.wireframeIndex.length>2*d?this.wireframeIndex:new (65535<this.geometry.attributes.position.count?Uint32Array:Uint16Array)(2*d);for(var f=0,g=b.length=0;g<d;g+=3){var h=c[g+0],k=c[g+1],l=c[g+2];a(h,k)&&(e[f+0]=h,e[f+1]=k,f+=2);a(k,l)&&(e[f+0]=k,e[f+1]=
l,f+=2);a(l,h)&&(e[f+0]=l,e[f+1]=h,f+=2)}this.wireframeIndex=e;this.wireframeIndexCount=f;this.wireframeIndexVersion=this.indexVersion}}}(),updateWireframeIndex:function(){this.wireframeGeometry.setDrawRange(0,Infinity);this.wireframeIndexVersion<this.indexVersion&&this.makeWireframeIndex();if(this.wireframeIndex.length>this.wireframeGeometry.index.array.length)this.wireframeGeometry.setIndex((new THREE.BufferAttribute(this.wireframeIndex,1)).setDynamic(this.dynamic));else{var a=this.wireframeGeometry.getIndex();
a.set(this.wireframeIndex);a.needsUpdate=0<this.wireframeIndexCount;a.updateRange.count=this.wireframeIndexCount}this.wireframeGeometry.setDrawRange(0,this.wireframeIndexCount)},getRenderOrder:function(){var a=0;this instanceof NGL.TextBuffer?a=1:this.transparent&&(a=this instanceof NGL.SurfaceBuffer?3:2);return a},getMesh:function(){var a;this.material||this.makeMaterial();this.line?a=new THREE.LineSegments(this.geometry,this.material):this.point?(a=new THREE.Points(this.geometry,this.material),
this.sortParticles&&(a.sortParticles=!0)):a=new THREE.Mesh(this.geometry,this.material);a.frustumCulled=!1;a.renderOrder=this.getRenderOrder();return a},getWireframeMesh:function(){var a;this.material||this.makeMaterial();this.wireframeGeometry||this.makeWireframeGeometry();a=new THREE.LineSegments(this.wireframeGeometry,this.wireframeMaterial);a.frustumCulled=!1;a.renderOrder=this.getRenderOrder();return a},getPickingMesh:function(){var a;this.material||this.makeMaterial();a=new THREE.Mesh(this.geometry,
this.pickingMaterial);a.frustumCulled=!1;a.renderOrder=this.getRenderOrder();return a},getShader:function(a,b){return NGL.getShader(a,this.getDefines(b))},getVertexShader:function(a){return this.getShader(this.vertexShader,a)},getFragmentShader:function(a){return this.getShader(this.fragmentShader,a)},getDefines:function(a){var b={};this.clipNear&&(b.NEAR_CLIP=1);if("picking"===a)b.PICKING=1;else{if("background"===a||this.background)b.NOLIGHT=1;this.flatShaded&&(b.FLAT_SHADED=1);this.opaqueBack&&
(b.OPAQUE_BACK=1);this.dullInterior&&(b.DULL_INTERIOR=1)}return b},getParameters:function(){var a={},b;for(b in this.parameters)a[b]=this[b];return a},addUniforms:function(a){this.uniforms=THREE.UniformsUtils.merge([this.uniforms,a]);this.pickingUniforms=THREE.UniformsUtils.merge([this.pickingUniforms,a])},addAttributes:function(a){var b={f:1,v2:2,v3:3,c:3},c;for(c in a){var d,e=a[c];e.value?(this.attributeSize*b[e.type]!==e.value.length&&NGL.error("attribute value has wrong length",c),d=e.value):
d=new Float32Array(this.attributeSize*b[e.type]);this.geometry.addAttribute(c,(new THREE.BufferAttribute(d,b[e.type])).setDynamic(this.dynamic))}},updateRenderOrder:function(){function a(a){a.renderOrder=b}var b=this.getRenderOrder();this.group.children.forEach(a);this.pickingGroup&&this.pickingGroup.children.forEach(a)},updateShader:function(){var a=this.material,b=this.wireframeMaterial,c=this.pickingMaterial;a.vertexShader=this.getVertexShader();a.fragmentShader=this.getFragmentShader();a.needsUpdate=
!0;b.vertexShader=this.getShader("Line.vert");b.fragmentShader=this.getShader("Line.frag");b.needsUpdate=!0;c.vertexShader=this.getVertexShader("picking");c.fragmentShader=this.getFragmentShader("picking");c.needsUpdate=!0},setParameters:function(a){if(a){var b=this.parameters,c={},d={},e=!1,f=!1,g;for(g in a)void 0!==a[g]&&void 0!==b[g]&&(this[g]=a[g],b[g].property&&(!0!==b[g].property?c[b[g].property]=a[g]:c[g]=a[g]),b[g].uniform&&(!0!==b[g].uniform?d[b[g].uniform]=a[g]:d[g]=a[g]),b[g].updateShader&&
(e=!0),b[g].updateVisibility&&(f=!0),this.dynamic&&"wireframe"===g&&!0===a[g]&&this.updateWireframeIndex(),"flatShaded"===g&&(this.material.extensions.derivatives=this.flatShaded),"forceTransparent"===g&&(c.transparent=this.transparent));this.setProperties(c);this.setUniforms(d);e&&this.updateShader();f&&this.setVisibility(this.visible)}},setAttributes:function(a){var b=this.geometry,c=b.attributes,d;for(d in a){var e=a[d],f=e.length;if("index"===d){var g=b.getIndex();b.setDrawRange(0,Infinity);f>
g.array.length?b.setIndex((new THREE.BufferAttribute(e,1)).setDynamic(this.dynamic)):(g.set(e),g.needsUpdate=0<f,g.updateRange.count=f,b.setDrawRange(0,f));this.indexVersion++;this.wireframe&&this.updateWireframeIndex()}else g=c[d],f>g.array.length?b.addAttribute(d,(new THREE.BufferAttribute(e,g.itemSize)).setDynamic(this.dynamic)):(c[d].set(e),c[d].needsUpdate=0<f,c[d].updateRange.count=f)}},setUniforms:function(a){if(a){var b=this.material.uniforms,c=this.wireframeMaterial.uniforms,d=this.pickingMaterial.uniforms,
e;for(e in a)"opacity"===e&&this.setProperties({transparent:this.transparent}),void 0!==b[e]&&(b[e].value.set?b[e].value.set(a[e]):b[e].value=a[e]),void 0!==c[e]&&(c[e].value.set?c[e].value.set(a[e]):c[e].value=a[e]),void 0!==d[e]&&(d[e].value.set?d[e].value.set(a[e]):d[e].value=a[e])}},setProperties:function(a){if(a){var b=this.material,c=this.wireframeMaterial,d=this.pickingMaterial,e;for(e in a)"transparent"===e&&this.updateRenderOrder(),void 0!==b[e]&&(b[e]=a[e]),void 0!==c[e]&&(c[e]=a[e]),void 0!==
d[e]&&(d[e]=a[e]);b.needsUpdate=!0;c.needsUpdate=!0;d.needsUpdate=!0}},setVisibility:function(a){this.visible=a;this.wireframe?(this.group.visible=!1,this.wireframeGroup.visible=a,this.pickable&&(this.pickingGroup.visible=!1)):(this.group.visible=a,this.wireframeGroup.visible=!1,this.pickable&&(this.pickingGroup.visible=a))},dispose:function(){this.material&&this.material.dispose();this.wireframeMaterial&&this.wireframeMaterial.dispose();this.pickingMaterial&&this.pickingMaterial.dispose();this.geometry.dispose();
this.wireframeGeometry&&this.wireframeGeometry.dispose()}};NGL.MeshBuffer=function(a,b,c,d,e,f){f=f||{};this.attributeSize=this.size=a?a.length/3:0;this.vertexShader="Mesh.vert";this.fragmentShader="Mesh.frag";NGL.Buffer.call(this,a,b,c,e,f);this.addAttributes({normal:{type:"v3",value:d}});void 0===d&&this.geometry.computeVertexNormals()};NGL.MeshBuffer.prototype=Object.create(NGL.Buffer.prototype);NGL.MeshBuffer.prototype.constructor=NGL.MeshBuffer;
NGL.MappedBuffer=function(a){this.size=this.count;this.attributeSize=this.count*this.mappingSize;this.index=new (65535<this.attributeSize?Uint32Array:Uint16Array)(this.count*this.mappingIndicesSize);this.makeIndex();NGL.Buffer.call(this,null,null,this.index,null,a);this.addAttributes({mapping:{type:this.mappingType,value:null}})};NGL.MappedBuffer.prototype=Object.create(NGL.Buffer.prototype);NGL.MappedBuffer.prototype.constructor=NGL.MappedBuffer;
NGL.MappedBuffer.prototype.setAttributes=function(a){var b=this.count,c=this.mappingSize,d=this.geometry.attributes,e,f,g,h,k,l,m,n;for(n in a){f=a[n];e=d[n];g=e.itemSize;h=e.array;for(var p=0;p<b;++p){k=p*g;l=k*c;for(var q=0;q<c;++q){m=l+g*q;for(var r=0;r<g;++r)h[m+r]=f[k+r]}}e.needsUpdate=!0}};NGL.MappedBuffer.prototype.makeMapping=function(){for(var a=this.count,b=this.mapping,c=this.mappingSize,d=this.mappingItemSize,e=this.geometry.attributes.mapping.array,f=0;f<a;f++)e.set(b,f*d*c)};
NGL.MappedBuffer.prototype.makeIndex=function(){for(var a=this.count,b=this.mappingSize,c=this.mappingIndices,d=this.mappingIndicesSize,e=this.index,f,g,h=0;h<a;h++){f=h*d;g=h*b;e.set(c,f);for(var k=0;k<d;++k)e[f+k]+=g}};NGL.QuadBuffer=function(a){this.mapping=new Float32Array([-1,1,-1,-1,1,1,1,-1]);this.mappingIndices=new Uint16Array([0,1,2,1,3,2]);this.mappingIndicesSize=6;this.mappingType="v2";this.mappingSize=4;this.mappingItemSize=2;NGL.MappedBuffer.call(this,a)};NGL.QuadBuffer.prototype=Object.create(NGL.MappedBuffer.prototype);
NGL.QuadBuffer.prototype.constructor=NGL.QuadBuffer;NGL.BoxBuffer=function(a){this.mapping=new Float32Array([-1,-1,-1,1,-1,-1,1,-1,1,-1,-1,1,-1,1,-1,1,1,-1,1,1,1,-1,1,1]);this.mappingIndices=new Uint16Array([0,1,2,0,2,3,1,5,6,1,6,2,4,6,5,4,7,6,0,7,4,0,3,7,0,5,1,0,4,5,3,2,6,3,6,7]);this.mappingIndicesSize=36;this.mappingType="v3";this.mappingSize=8;this.mappingItemSize=3;NGL.MappedBuffer.call(this,a)};NGL.BoxBuffer.prototype=Object.create(NGL.MappedBuffer.prototype);
NGL.BoxBuffer.prototype.constructor=NGL.BoxBuffer;NGL.AlignedBoxBuffer=function(a){this.mapping=new Float32Array([-1,1,-1,-1,-1,-1,1,1,-1,1,1,1,1,-1,-1,1,-1,1]);this.mappingIndices=new Uint16Array([0,1,2,1,4,2,2,4,3,4,5,3]);this.mappingIndicesSize=12;this.mappingType="v3";this.mappingSize=6;this.mappingItemSize=3;NGL.MappedBuffer.call(this,a)};NGL.AlignedBoxBuffer.prototype=Object.create(NGL.MappedBuffer.prototype);NGL.AlignedBoxBuffer.prototype.constructor=NGL.AlignedBoxBuffer;
NGL.SphereImpostorBuffer=function(a,b,c,d,e){this.impostor=!0;this.count=a.length/3;this.vertexShader="SphereImpostor.vert";this.fragmentShader="SphereImpostor.frag";NGL.QuadBuffer.call(this,e);this.addUniforms({projectionMatrixInverse:{value:new THREE.Matrix4}});this.addAttributes({radius:{type:"f",value:null}});this.setAttributes({position:a,color:b,radius:c});d&&(this.addAttributes({pickingColor:{type:"c",value:null}}),this.setAttributes({pickingColor:d}),this.pickable=!0);this.makeMapping()};
NGL.SphereImpostorBuffer.prototype=Object.create(NGL.QuadBuffer.prototype);NGL.SphereImpostorBuffer.prototype.constructor=NGL.SphereImpostorBuffer;
NGL.CylinderImpostorBuffer=function(a,b,c,d,e,f,g,h){h=h||{};this.shift=void 0!==h.shift?h.shift:0;this.cap=void 0!==h.cap?h.cap:!0;this.impostor=!0;this.count=a.length/3;this.vertexShader="CylinderImpostor.vert";this.fragmentShader="CylinderImpostor.frag";NGL.AlignedBoxBuffer.call(this,h);h=(new THREE.Uniform(new THREE.Matrix4)).onUpdate(function(a,b){this.value.getInverse(a.modelViewMatrix)});this.addUniforms({modelViewMatrixInverse:h,shift:{value:this.shift}});this.addAttributes({position1:{type:"v3",
value:null},position2:{type:"v3",value:null},color2:{type:"c",value:null},radius:{type:"f",value:null}});this.setAttributes({position:NGL.Utils.calculateCenterArray(a,b),position1:a,position2:b,color:c,color2:d,radius:e});f&&(this.addAttributes({pickingColor:{type:"c",value:null},pickingColor2:{type:"c",value:null}}),this.setAttributes({pickingColor:f,pickingColor2:g}),this.pickable=!0);this.makeMapping()};NGL.CylinderImpostorBuffer.prototype=Object.create(NGL.AlignedBoxBuffer.prototype);
NGL.CylinderImpostorBuffer.prototype.constructor=NGL.CylinderImpostorBuffer;NGL.CylinderImpostorBuffer.prototype.getMaterial=function(a){a=NGL.Buffer.prototype.getMaterial.call(this,a);this.cap&&(a.defines.CAP=1);return a};
NGL.HyperballStickImpostorBuffer=function(a,b,c,d,e,f,g,h,k){function l(a,b){var c=a.material.uniforms;c.modelViewMatrixInverse&&c.modelViewMatrixInverse.value.getInverse(a.modelViewMatrix);c.modelViewMatrixInverseTranspose&&(c.modelViewMatrixInverse?c.modelViewMatrixInverseTranspose.value.copy(c.modelViewMatrixInverse.value).transpose():c.modelViewMatrixInverseTranspose.value.getInverse(a.modelViewMatrix).transpose());c.modelViewProjectionMatrix&&c.modelViewProjectionMatrix.value.multiplyMatrices(b.projectionMatrix,
a.modelViewMatrix);c.modelViewProjectionMatrixInverse&&(c.modelViewProjectionMatrix?n.copy(c.modelViewProjectionMatrix.value):n.multiplyMatrices(b.projectionMatrix,a.modelViewMatrix),c.modelViewProjectionMatrixInverse.value.getInverse(n))}var m=k||{};k=void 0!==m.shrink?m.shrink:.14;this.impostor=!0;this.count=a.length/3;this.vertexShader="HyperballStickImpostor.vert";this.fragmentShader="HyperballStickImpostor.frag";NGL.BoxBuffer.call(this,m);var n=new THREE.Matrix4,m=(new THREE.Uniform(new THREE.Matrix4)).onUpdate(l),
p=(new THREE.Uniform(new THREE.Matrix4)).onUpdate(l),q=(new THREE.Uniform(new THREE.Matrix4)).onUpdate(l);this.addUniforms({modelViewProjectionMatrix:m,modelViewProjectionMatrixInverse:p,modelViewMatrixInverseTranspose:q,shrink:{value:k}});this.addAttributes({color:{type:"c",value:null},color2:{type:"c",value:null},radius:{type:"f",value:null},radius2:{type:"f",value:null},position1:{type:"v3",value:null},position2:{type:"v3",value:null}});this.setAttributes({color:c,color2:d,radius:e,radius2:f,position1:a,
position2:b,position:NGL.Utils.calculateCenterArray(a,b)});g&&(this.addAttributes({pickingColor:{type:"c",value:null},pickingColor2:{type:"c",value:null}}),this.setAttributes({pickingColor:g,pickingColor2:h}),this.pickable=!0);this.makeMapping()};NGL.HyperballStickImpostorBuffer.prototype=Object.create(NGL.BoxBuffer.prototype);NGL.HyperballStickImpostorBuffer.prototype.constructor=NGL.HyperballStickImpostorBuffer;
NGL.HyperballStickImpostorBuffer.prototype.parameters=Object.assign({shrink:{uniform:!0}},NGL.BoxBuffer.prototype.parameters);
NGL.GeometryBuffer=function(a,b,c,d){d=d||{};var e=this.geo,f=a.length/3,g=e.vertices.length,h=e.faces.length;this.size=f*g;this.positionCount=f;this.geoPosition=NGL.Utils.positionFromGeometry(e);this.geoNormal=NGL.Utils.normalFromGeometry(e);this.geoIndex=NGL.Utils.indexFromGeometry(e);this.transformedGeoPosition=new Float32Array(3*g);this.transformedGeoNormal=new Float32Array(3*g);this.meshPosition=new Float32Array(3*this.size);this.meshNormal=new Float32Array(3*this.size);this.meshColor=new Float32Array(3*
this.size);this.meshPickingColor=new Float32Array(3*this.size);this.meshIndex=new (65535<this.meshPosition.length/3?Uint32Array:Uint16Array)(f*h*3);this.makeIndex();NGL.MeshBuffer.call(this,this.meshPosition,this.meshColor,this.meshIndex,this.meshNormal,this.meshPickingColor,d);this.initNormals=!0;this.setAttributes({position:a,color:b,pickingColor:c});this.initNormals=!1};NGL.GeometryBuffer.prototype=Object.create(NGL.MeshBuffer.prototype);NGL.GeometryBuffer.prototype.constructor=NGL.GeometryBuffer;
NGL.GeometryBuffer.prototype.applyPositionTransform=function(){};
NGL.GeometryBuffer.prototype.setAttributes=function(){var a=new THREE.Matrix4,b=new THREE.Matrix3;return function(c){var d=this.geometry.attributes,e,f,g,h,k,l,m,n,p,q,r;c.position&&(e=c.position,h=this.geoPosition,n=this.meshPosition,l=this.transformedGeoPosition,d.position.needsUpdate=!0);c.color&&(f=c.color,p=this.meshColor,d.color.needsUpdate=!0);c.pickingColor&&(g=c.pickingColor,q=this.meshPickingColor,d.pickingColor.needsUpdate=!0);c=!(!this.updateNormals||!e);var t=!(!this.initNormals||!e);
if(c||t)k=this.geoNormal,r=this.meshNormal,m=this.transformedGeoNormal,d.normal.needsUpdate=!0;for(var d=this.positionCount,v=this.geo.vertices.length,w=0;w<d;++w){var u=w*v*3,B=3*w;e&&(l.set(h),a.makeTranslation(e[B],e[B+1],e[B+2]),this.applyPositionTransform(a,w,B),a.applyToVector3Array(l),n.set(l,u));c?(m.set(k),b.getNormalMatrix(a),b.applyToVector3Array(m),r.set(m,u)):t&&r.set(k,u);if(f)for(var s=0;s<v;++s){var z=u+3*s;p[z]=f[B];p[z+1]=f[B+1];p[z+2]=f[B+2]}if(g)for(s=0;s<v;++s)z=u+3*s,q[z]=g[B],
q[z+1]=g[B+1],q[z+2]=g[B+2]}}}();NGL.GeometryBuffer.prototype.makeIndex=function(){var a=this.geoIndex,b=this.meshIndex,c=this.positionCount,d=this.geo.vertices.length,e,f,g,h=3*this.geo.faces.length;for(f=0;f<c;++f)for(e=f*h,g=e+h,b.set(a,e);e<g;++e)b[e]+=f*d};NGL.SphereGeometryBuffer=function(a,b,c,d,e){this.geo=new THREE.IcosahedronGeometry(1,void 0!==e.sphereDetail?e.sphereDetail:1);this.setPositionTransform(c);NGL.GeometryBuffer.call(this,a,b,d,e)};NGL.SphereGeometryBuffer.prototype=Object.create(NGL.GeometryBuffer.prototype);
NGL.SphereGeometryBuffer.prototype.constructor=NGL.SphereGeometryBuffer;NGL.SphereGeometryBuffer.prototype.setPositionTransform=function(a){var b,c=new THREE.Vector3;this.applyPositionTransform=function(d,e){b=a[e];c.set(b,b,b);d.scale(c)}};NGL.SphereGeometryBuffer.prototype.setAttributes=function(a){a.radius&&this.setPositionTransform(a.radius);NGL.GeometryBuffer.prototype.setAttributes.call(this,a)};
NGL.CylinderGeometryBuffer=function(a,b,c,d,e,f,g,h){var k=void 0!==h.radiusSegments?h.radiusSegments:10;this.updateNormals=!0;var l=(new THREE.Matrix4).makeRotationX(Math.PI/2);this.geo=new THREE.CylinderGeometry(1,1,1,k,1,!0);this.geo.applyMatrix(l);k=a.length;l=e.length;this._position=new Float32Array(2*k);this._color=new Float32Array(2*k);this._pickingColor=new Float32Array(2*k);this._from=new Float32Array(2*k);this._to=new Float32Array(2*k);this._radius=new Float32Array(2*l);this.__center=new Float32Array(k);
NGL.GeometryBuffer.call(this,this._position,this._color,this._pickingColor,h);this.setPositionTransform(this._from,this._to,this._radius);this.setAttributes({position1:a,position2:b,color:c,color2:d,radius:e,pickingColor:f,pickingColor2:g})};NGL.CylinderGeometryBuffer.prototype=Object.create(NGL.GeometryBuffer.prototype);NGL.CylinderImpostorBuffer.prototype.constructor=NGL.CylinderImpostorBuffer;
NGL.CylinderGeometryBuffer.prototype.setPositionTransform=function(a,b,c){var d,e=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3(0,1,0);this.applyPositionTransform=function(k,l,m){f.fromArray(a,m);g.fromArray(b,m);k.lookAt(f,g,h);d=c[l];e.set(d,d,f.distanceTo(g));k.scale(e)}};
NGL.CylinderGeometryBuffer.prototype.setAttributes=function(a){var b=this._position.length/2,c=this._radius.length/2,d={};a.position1&&a.position2&&(NGL.Utils.calculateCenterArray(a.position1,a.position2,this.__center),NGL.Utils.calculateCenterArray(a.position1,this.__center,this._position),NGL.Utils.calculateCenterArray(this.__center,a.position2,this._position,b),this._from.set(a.position1),this._from.set(this.__center,b),this._to.set(this.__center),this._to.set(a.position2,b),d.position=this._position);
a.color&&a.color2&&(this._color.set(a.color),this._color.set(a.color2,b),d.color=this._color);a.pickingColor&&a.pickingColor2&&(this._pickingColor.set(a.pickingColor),this._pickingColor.set(a.pickingColor2,b),d.pickingColor=this._pickingColor);a.radius&&(this._radius.set(a.radius),this._radius.set(a.radius,c));(a.position1&&a.position2||a.radius)&&this.setPositionTransform(this._from,this._to,this._radius);NGL.GeometryBuffer.prototype.setAttributes.call(this,d)};
NGL.makePointTexture=function(a){function b(a,b,c,d){a=c-a;b=d-b;return Math.sqrt(a*a+b*b)}function c(a,b,c){c=Math.min(Math.max((c-a)/(b-a),0),1);return c*c*(3-2*c)}var d=Object.assign({},a);a=NGL.defaults(d.width,256);for(var e=NGL.defaults(d.height,256),f=[a/2,e/2],g=Math.min(a/2,e/2),d=NGL.defaults(d.delta,1/(g+1))*g,h=0,k=0,l=new Uint8Array(a*e*4),m=0,n=l.length;m<n;m+=4){var p=b(h,k,f[0],f[1]),p=1-c(g-d,g,p);l[m]=255*p;l[m+1]=255*p;l[m+2]=255*p;l[m+3]=255*p;++h===a&&(h=0,k++)}a=new THREE.DataTexture(l,
a,e);a.needsUpdate=!0;return a};
NGL.PointBuffer=function(a,b,c){c=c||{};this.point=!0;this.pointSize=void 0!==c.pointSize?c.pointSize:1;this.sizeAttenuation=void 0!==c.sizeAttenuation?c.sizeAttenuation:!0;this.sortParticles=void 0!==c.sortParticles?c.sortParticles:!1;this.alphaTest=void 0!==c.alphaTest?c.alphaTest:.5;this.useTexture=void 0!==c.useTexture?c.useTexture:!1;this.forceTransparent=void 0!==c.forceTransparent?c.forceTransparent:!1;this.edgeBleach=void 0!==c.edgeBleach?c.edgeBleach:0;this.attributeSize=this.size=a.length/
3;this.vertexShader="Point.vert";this.fragmentShader="Point.frag";NGL.Buffer.call(this,a,b,void 0,void 0,c);this.addUniforms({size:{value:this.pointSize},canvasHeight:{value:1},pixelRatio:{value:1},map:{value:null}})};NGL.PointBuffer.prototype=Object.create(NGL.Buffer.prototype);NGL.PointBuffer.prototype.constructor=NGL.PointBuffer;
NGL.PointBuffer.prototype.parameters=Object.assign({pointSize:{uniform:"size"},sizeAttenuation:{updateShader:!0},sortParticles:{},alphaTest:{updateShader:!0},useTexture:{updateShader:!0},forceTransparent:{},edgeBleach:{uniform:!0}},NGL.Buffer.prototype.parameters);NGL.PointBuffer.prototype.makeMaterial=function(){NGL.Buffer.prototype.makeMaterial.call(this);this.makeTexture();this.material.uniforms.map.value=this.tex;this.material.blending=THREE.NormalBlending;this.material.needsUpdate=!0};
NGL.PointBuffer.prototype.makeTexture=function(){this.tex&&this.tex.dispose();this.tex=NGL.makePointTexture({delta:this.edgeBleach})};NGL.PointBuffer.prototype.getDefines=function(a){a=NGL.Buffer.prototype.getDefines.call(this,a);this.sizeAttenuation&&(a.USE_SIZEATTENUATION=1);this.useTexture&&(a.USE_MAP=1);0<this.alphaTest&&1>=this.alphaTest&&(a.ALPHATEST=this.alphaTest.toPrecision(2));return a};
NGL.PointBuffer.prototype.setUniforms=function(a){a&&void 0!==a.edgeBleach&&(this.makeTexture(),a.map=this.tex);NGL.Buffer.prototype.setUniforms.call(this,a)};NGL.PointBuffer.prototype.dispose=function(){NGL.Buffer.prototype.dispose.call(this);this.tex&&this.tex.dispose()};
NGL.LineBuffer=function(a,b,c,d,e){e=e||{};this.size=a.length/3;this.vertexShader="Line.vert";this.fragmentShader="Line.frag";this.line=!0;var f=4*this.size;this.attributeSize=f;this.linePosition=new Float32Array(3*f);this.lineColor=new Float32Array(3*f);NGL.Buffer.call(this,this.linePosition,this.lineColor,void 0,void 0,e);this.setAttributes({from:a,to:b,color:c,color2:d})};NGL.LineBuffer.prototype=Object.create(NGL.Buffer.prototype);NGL.LineBuffer.prototype.constructor=NGL.LineBuffer;
NGL.LineBuffer.prototype.setAttributes=function(a){var b,c,d,e,f,g,h=this.geometry.attributes;a.from&&a.to&&(b=a.from,c=a.to,f=h.position.array,h.position.needsUpdate=!0);a.color&&a.color2&&(d=a.color,e=a.color2,g=h.color.array,h.color.needsUpdate=!0);a=this.size;for(var h=6*a,k,l,m,n,p,q,r,t,v,w,u,B,s=0;s<a;s++)l=3*s,k=6*s,m=k+h,b&&c&&(r=b[l],t=b[l+1],v=b[l+2],w=c[l],u=c[l+1],B=c[l+2],n=(r+w)/2,p=(t+u)/2,q=(v+B)/2,f[k]=r,f[k+1]=t,f[k+2]=v,f[k+3]=n,f[k+4]=p,f[k+5]=q,f[m]=n,f[m+1]=p,f[m+2]=q,f[m+3]=
w,f[m+4]=u,f[m+5]=B),d&&e&&(g[k]=g[k+3]=d[l],g[k+1]=g[k+4]=d[l+1],g[k+2]=g[k+5]=d[l+2],g[m]=g[m+3]=e[l],g[m+1]=g[m+4]=e[l+1],g[m+2]=g[m+5]=e[l+2])};
NGL.TraceBuffer=function(a,b,c){c=c||{};this.size=a.length/3;this.vertexShader="Line.vert";this.fragmentShader="Line.frag";this.line=!0;var d=this.size-1;this.attributeSize=2*d;this.linePosition=new Float32Array(6*d);this.lineColor=new Float32Array(6*d);NGL.Buffer.call(this,this.linePosition,this.lineColor,void 0,void 0,c);this.setAttributes({position:a,color:b})};NGL.TraceBuffer.prototype=Object.create(NGL.Buffer.prototype);NGL.TraceBuffer.prototype.constructor=NGL.TraceBuffer;
NGL.TraceBuffer.prototype.setAttributes=function(a){var b,c,d,e,f=this.geometry.attributes;a.position&&(b=a.position,d=f.position.array,f.position.needsUpdate=!0);a.color&&(c=a.color,e=f.color.array,f.color.needsUpdate=!0);if(b||c)for(var g=this.size-1,h=0;h<g;++h)a=3*h,f=6*h,b&&(d[f]=b[a],d[f+1]=b[a+1],d[f+2]=b[a+2],d[f+3]=b[a+3],d[f+4]=b[a+4],d[f+5]=b[a+5]),c&&(e[f]=c[a],e[f+1]=c[a+1],e[f+2]=c[a+2],e[f+3]=c[a+3],e[f+4]=c[a+4],e[f+5]=c[a+5]);else NGL.warn("NGL.TraceBuffer.prototype.setAttributes no data")};
NGL.RibbonBuffer=function(a,b,c,d,e,f,g){g=g||{};var h=4*(a.length/3-1),k=3*h;this.meshPosition=new Float32Array(k);this.meshColor=new Float32Array(k);this.meshNormal=new Float32Array(k);this.meshPickingColor=f?new Float32Array(k):void 0;this.meshIndex=new (65535<this.meshPosition.length/3?Uint32Array:Uint16Array)(k);this.makeIndex();NGL.MeshBuffer.call(this,this.meshPosition,this.meshColor,this.meshIndex,this.meshNormal,this.meshPickingColor,g);this.vertexShader="Ribbon.vert";this.fragmentShader=
"Mesh.frag";this.geometry.addAttribute("dir",new THREE.BufferAttribute(new Float32Array(k),3));this.geometry.addAttribute("size",new THREE.BufferAttribute(new Float32Array(h),1));this.setAttributes({position:a,normal:b,dir:c,color:d,size:e,pickingColor:f})};NGL.RibbonBuffer.prototype=Object.create(NGL.MeshBuffer.prototype);NGL.RibbonBuffer.prototype.constructor=NGL.RibbonBuffer;
NGL.RibbonBuffer.prototype.setAttributes=function(a){var b=this.size/4,c=this.geometry.attributes,d,e,f,g,h,k,l,m,n,p,q,r;a.position&&(d=a.position,l=c.position.array,c.position.needsUpdate=!0);a.normal&&(e=a.normal,m=c.normal.array,c.normal.needsUpdate=!0);a.size&&(f=a.size,n=c.size.array,c.size.needsUpdate=!0);a.dir&&(g=a.dir,p=c.dir.array,c.dir.needsUpdate=!0);a.color&&(h=a.color,q=c.color.array,c.color.needsUpdate=!0);a.pickingColor&&(k=a.pickingColor,r=c.pickingColor.array,c.pickingColor.needsUpdate=
!0);var t,v,w,u,B=f?f[0]:null;for(a=0;a<b;++a){u=3*a;c=12*a;w=4*a;d&&(l[c]=l[c+3]=d[u],l[c+1]=l[c+4]=d[u+1],l[c+2]=l[c+5]=d[u+2],l[c+6]=l[c+9]=d[u+3],l[c+7]=l[c+10]=d[u+4],l[c+8]=l[c+11]=d[u+5]);e&&(m[c]=m[c+3]=-e[u],m[c+1]=m[c+4]=-e[u+1],m[c+2]=m[c+5]=-e[u+2],m[c+6]=m[c+9]=-e[u+3],m[c+7]=m[c+10]=-e[u+4],m[c+8]=m[c+11]=-e[u+5]);for(t=0;4>t;++t)v=c+3*t,h&&(q[v]=h[u],q[v+1]=h[u+1],q[v+2]=h[u+2]),k&&(r[v]=k[u],r[v+1]=k[u+1],r[v+2]=k[u+2]);f&&(t=f[a],B!==f[a]?(n[w]=B,n[w+1]=B):(n[w]=t,n[w+1]=t),n[w+2]=
t,B=n[w+3]=t);g&&(p[c]=g[u],p[c+1]=g[u+1],p[c+2]=g[u+2],p[c+3]=-g[u],p[c+4]=-g[u+1],p[c+5]=-g[u+2],p[c+6]=g[u+3],p[c+7]=g[u+4],p[c+8]=g[u+5],p[c+9]=-g[u+3],p[c+10]=-g[u+4],p[c+11]=-g[u+5])}};NGL.RibbonBuffer.prototype.makeIndex=function(){var a=this.meshIndex,b=a.length/4/3,c=new Uint16Array([0,1,2,1,3,2]),d,e,f,g;for(e=0;e<b;++e)for(f=6*e,g=4*e,a.set(c,f),d=0;6>d;++d)a[f+d]+=g};
NGL.TubeMeshBuffer=function(a,b,c,d,e,f,g,h){h=h||{};this.aspectRatio=void 0!==h.aspectRatio?h.aspectRatio:1;this.radialSegments=void 0!==h.radialSegments?h.radialSegments:4;this.capVertices=(this.capped=void 0!==h.capped?h.capped:!1)?this.radialSegments:0;this.capTriangles=this.capped?this.radialSegments-2:0;var k=a.length/3,l=k-1,m=k*this.radialSegments*3+6*this.capVertices;this.size2=k;this.meshPosition=new Float32Array(m);this.meshColor=new Float32Array(m);this.meshNormal=new Float32Array(m);
this.meshPickingColor=g?new Float32Array(m):void 0;this.meshIndex=new (65535<this.meshPosition.length/3?Uint32Array:Uint16Array)(2*l*this.radialSegments*3+6*this.capTriangles);this.makeIndex();NGL.MeshBuffer.call(this,this.meshPosition,this.meshColor,this.meshIndex,this.meshNormal,this.meshPickingColor,h);this.setAttributes({position:a,normal:b,binormal:c,tangent:d,color:e,size:f,pickingColor:g})};NGL.TubeMeshBuffer.prototype=Object.create(NGL.MeshBuffer.prototype);
NGL.TubeMeshBuffer.prototype.constructor=NGL.TubeMeshBuffer;
NGL.TubeMeshBuffer.prototype.setAttributes=function(){var a=new THREE.Vector3,b=new THREE.Vector3;return function(c){var d=this.aspectRatio,e=this.size2,f=e-1,g=this.radialSegments,h=this.geometry.attributes,k,l,m,n,p,q,r,t,v,w,u;c.position&&(k=c.position,l=c.normal,m=c.binormal,n=c.tangent,q=c.size,t=h.position.array,w=h.normal.array,h.position.needsUpdate=!0,h.normal.needsUpdate=!0);c.color&&(p=c.color,v=h.color.array,h.color.needsUpdate=!0);c.pickingColor&&(r=c.pickingColor,u=h.pickingColor.array,
h.pickingColor.needsUpdate=!0);var B,s,z,x,y,A,M,H,R,O,W,J,Z,K,U,D,G,S,T,h=[],$=[],Y=[],L=[],P=[],Q=[];if(k)for(c=0;c<g;++c)s=c/g*2*Math.PI,h[c]=d*Math.cos(s),$[c]=Math.sin(s),Y[c]=d*Math.cos(s-.01),L[c]=Math.sin(s-.01),P[c]=d*Math.cos(s+.01),Q[c]=Math.sin(s+.01);for(B=0;B<e;++B)for(d=3*B,s=d*g,k&&(a.set(n[d],n[d+1],n[d+2]),W=l[d],J=l[d+1],Z=l[d+2],K=m[d],U=m[d+1],D=m[d+2],G=k[d],S=k[d+1],T=k[d+2],O=q[B]),c=0;c<g;++c)z=s+3*c,k&&(x=-O*h[c],y=O*$[c],A=-O*Y[c],M=O*L[c],H=-O*P[c],R=O*Q[c],t[z]=G+x*W+
y*K,t[z+1]=S+x*J+y*U,t[z+2]=T+x*Z+y*D,b.set(H*W+R*K-(A*W+M*K),H*J+R*U-(A*J+M*U),H*Z+R*D-(A*Z+M*D)).cross(a),w[z]=b.x,w[z+1]=b.y,w[z+2]=b.z),p&&(v[z]=p[d],v[z+1]=p[d+1],v[z+2]=p[d+2]),r&&(u[z]=r[d],u[z+1]=r[d+1],u[z+2]=r[d+2]);d=0;s=3*e*g;for(c=0;c<g;++c)z=d+3*c,l=s+3*c,k&&(t[l]=t[z],t[l+1]=t[z+1],t[l+2]=t[z+2],w[l]=n[d],w[l+1]=n[d+1],w[l+2]=n[d+2]),p&&(v[l]=v[z],v[l+1]=v[z+1],v[l+2]=v[z+2]),r&&(u[l]=u[z],u[l+1]=u[z+1],u[l+2]=u[z+2]);d=3*(e-1)*g;s=3*(e+1)*g;for(c=0;c<g;++c)z=d+3*c,l=s+3*c,k&&(t[l]=
t[z],t[l+1]=t[z+1],t[l+2]=t[z+2],w[l]=n[3*f],w[l+1]=n[3*f+1],w[l+2]=n[3*f+2]),p&&(v[l]=v[z],v[l+1]=v[z+1],v[l+2]=v[z+2]),r&&(u[l]=u[z],u[l+1]=u[z+1],u[l+2]=u[z+2])}}();
NGL.TubeMeshBuffer.prototype.makeIndex=function(){var a=this.meshIndex,b=this.size2,c=b-1,d=this.capTriangles,e=this.radialSegments,f=this.radialSegments+1,g,h,k,l,m,n;for(g=0;g<c;++g)for(h=g*e*6,k=g*e,l=(g+1)*e,n=0;n<e;++n)m=h+6*n,a[m]=k+n,a[m+1]=k+(n+1)%e,a[m+2]=l+n,a[m+3]=l+n,a[m+4]=k+(n+1)%e,a[m+5]=l+(n+1)%e;g=[0];for(n=1;n<f/2;++n)g.push(n),e-n!==n&&g.push(e-n);m=c*e*6;h=b*e;for(n=0;n<g.length-2;++n)0===n%2?(a[m+3*n+0]=h+g[n+0],a[m+3*n+1]=h+g[n+1],a[m+3*n+2]=h+g[n+2]):(a[m+3*n+0]=h+g[n+2],a[m+
3*n+1]=h+g[n+1],a[m+3*n+2]=h+g[n+0]);m=c*e*6+3*d;h=b*e+e;for(n=0;n<g.length-2;++n)0===n%2?(a[m+3*n+0]=h+g[n+0],a[m+3*n+1]=h+g[n+1],a[m+3*n+2]=h+g[n+2]):(a[m+3*n+0]=h+g[n+2],a[m+3*n+1]=h+g[n+1],a[m+3*n+2]=h+g[n+0])};NGL.SurfaceBuffer=function(){NGL.MeshBuffer.apply(this,arguments)};NGL.SurfaceBuffer.prototype=Object.create(NGL.MeshBuffer.prototype);NGL.SurfaceBuffer.prototype.constructor=NGL.SurfaceBuffer;
NGL.SphereBuffer=function(a,b,c,d,e){var f=e||{};return!NGL.extensionFragDepth||f.disableImpostor?new NGL.SphereGeometryBuffer(a,b,c,d,e):new NGL.SphereImpostorBuffer(a,b,c,d,e)};NGL.CylinderBuffer=function(a,b,c,d,e,f,g,h){var k=h||{};return!NGL.extensionFragDepth||k.disableImpostor?new NGL.CylinderGeometryBuffer(a,b,c,d,e,f,g,h):new NGL.CylinderImpostorBuffer(a,b,c,d,e,f,g,h)};
NGL.HyperballStickBuffer=function(a,b,c,d,e,f,g,h,k){var l=k||{};return!NGL.extensionFragDepth||l.disableImpostor?new NGL.CylinderGeometryBuffer